/*
 * Decompiled with CFR 0.152.
 */
package com.isomorphic.sql;

import com.isomorphic.base.Config;
import com.isomorphic.log.Logger;
import com.isomorphic.servlet.RequestContext;
import com.isomorphic.sql.SQLDriver;
import com.isomorphic.util.DataTools;
import java.io.Serializable;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpSession;

public class DBSandbox
implements Serializable {
    private static final long serialVersionUID = 1L;
    protected static Logger log = new Logger(DBSandbox.class.getName());
    protected static Config config = Config.getGlobal();
    public static final String sandboxPrefix = "isc_sandbox_";
    protected static final ThreadLocal<Map<String, DBSandbox>> threadLocal = new ThreadLocal();
    protected String sandboxName;
    protected String schemaName;
    protected String dbName;

    public static boolean isASandbox(String dbName) {
        return dbName.startsWith(sandboxPrefix);
    }

    public static String getSourceDBName(String sandboxName) {
        if (!DBSandbox.isASandbox(sandboxName)) {
            return null;
        }
        return sandboxName.substring(sandboxPrefix.length());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<DBSandbox> listSandboxes(String dbName) throws Exception {
        String sandboxPrefix = config.getString((Object)("sql." + dbName + ".sandbox.prefix"));
        if (sandboxPrefix == null) {
            throw new Exception("Unable to derive unique sandbox prefix for specified dbName: " + dbName + " - please set sql." + dbName + ".sandbox.prefix in config");
        }
        ArrayList<DBSandbox> sandboxes = new ArrayList<DBSandbox>();
        SQLDriver driver = SQLDriver.instance(dbName);
        try {
            List<String> databaseNames = driver.listAvailableDatabases();
            for (String s : databaseNames) {
                if (!s.startsWith("sandboxPrefix")) continue;
                String sandboxName = s;
                sandboxes.add(new DBSandbox(dbName, sandboxName));
            }
            ArrayList<DBSandbox> arrayList = sandboxes;
            return arrayList;
        }
        finally {
            driver.clearState();
        }
    }

    protected static String getSandboxAttributePrefix(String dbName) {
        return sandboxPrefix + dbName;
    }

    protected static String getSandboxAttributeName(String dbName, String attrName) {
        return DBSandbox.getSandboxAttributePrefix(dbName) + attrName;
    }

    public static DBSandbox getThreadSandbox(String dbName) {
        Map<String, DBSandbox> threadContextMap = threadLocal.get();
        if (threadContextMap != null) {
            return threadContextMap.get(dbName);
        }
        return null;
    }

    public static void setThreadSandbox(DBSandbox dbSandbox) {
        Map<String, DBSandbox> threadContextMap = threadLocal.get();
        if (threadContextMap == null) {
            threadContextMap = new HashMap<String, DBSandbox>();
            threadLocal.set(threadContextMap);
        }
        threadContextMap.put(dbSandbox.getDbName(), dbSandbox);
    }

    public static void clearThreadSandbox(String dbName) {
        Map<String, DBSandbox> threadContextMap = threadLocal.get();
        if (threadContextMap != null) {
            threadContextMap.remove(dbName);
        }
    }

    public static DBSandbox getRequestSandbox(String dbName) {
        RequestContext requestContext = RequestContext.getThreadLocal();
        if (requestContext == null) {
            return null;
        }
        String sandboxName = (String)requestContext.request.getAttribute(DBSandbox.getSandboxAttributeName(dbName, "sandboxName"));
        return sandboxName == null ? null : new DBSandbox(dbName, sandboxName);
    }

    public static void setRequestSandbox(DBSandbox dbSandbox) {
        RequestContext requestContext = RequestContext.getThreadLocal();
        if (requestContext == null) {
            return;
        }
        requestContext.request.setAttribute(DBSandbox.getSandboxAttributeName(dbSandbox.getDbName(), "sandboxName"), (Object)dbSandbox.getSandboxName());
    }

    public static void clearRequestSandbox(String dbName) {
        RequestContext requestContext = RequestContext.getThreadLocal();
        if (requestContext == null) {
            return;
        }
        requestContext.request.removeAttribute(DBSandbox.getSandboxAttributeName(dbName, "sandboxName"));
    }

    public static DBSandbox getSessionSandbox(String dbName) {
        RequestContext requestContext = RequestContext.getThreadLocal();
        if (requestContext == null) {
            return null;
        }
        HttpSession session = requestContext.request.getSession(false);
        if (session == null) {
            return null;
        }
        String sandboxName = (String)session.getAttribute(DBSandbox.getSandboxAttributeName(dbName, "sandboxName"));
        return sandboxName == null ? null : new DBSandbox(dbName, sandboxName);
    }

    public static void setSessionSandbox(DBSandbox dbSandbox) {
        RequestContext requestContext = RequestContext.getThreadLocal();
        if (requestContext == null) {
            return;
        }
        HttpSession session = requestContext.request.getSession(true);
        session.setAttribute(DBSandbox.getSandboxAttributeName(dbSandbox.getDbName(), "sandboxName"), (Object)dbSandbox.getSandboxName());
    }

    public static void clearSessionSandbox(String dbName) {
        RequestContext requestContext = RequestContext.getThreadLocal();
        if (requestContext == null) {
            return;
        }
        HttpSession session = requestContext.request.getSession(false);
        if (session == null) {
            return;
        }
        session.removeAttribute(DBSandbox.getSandboxAttributeName(dbName, "sandboxName"));
    }

    public static DBSandbox getPrevailingSandbox(String dbName) {
        DBSandbox sandbox = DBSandbox.getThreadSandbox(dbName);
        if (sandbox != null) {
            log.debug((Object)"Prevailing sandbox is thread-based");
            return sandbox;
        }
        sandbox = DBSandbox.getRequestSandbox(dbName);
        if (sandbox != null) {
            log.debug((Object)"Prevailing sandbox is httpRequest-based");
            return sandbox;
        }
        sandbox = DBSandbox.getSessionSandbox(dbName);
        if (sandbox != null) {
            log.debug((Object)"Prevailing sandbox is httpSession-based");
            return sandbox;
        }
        return null;
    }

    public static String getPrevailingSandboxName(String dbName) {
        DBSandbox prevailingSandbox = DBSandbox.getPrevailingSandbox(dbName);
        if (prevailingSandbox == null) {
            return null;
        }
        return prevailingSandbox.getSandboxName();
    }

    public static String generateSandboxName(String dbName) {
        RequestContext requestContext = RequestContext.getThreadLocal();
        if (requestContext != null) {
            return DBSandbox.getSandboxAttributePrefix(dbName) + requestContext.request.getSession(true).getId();
        }
        return null;
    }

    public static boolean isEnabled(String dbName) {
        if (DBSandbox.isASandbox(dbName)) {
            return false;
        }
        if (DBSandbox.getPrevailingSandbox(dbName) != null) {
            return true;
        }
        return config.getBoolean((Object)"sql.sandbox.enabled", true) && config.getBoolean((Object)("sql." + dbName + ".sandbox.enabled"), false);
    }

    public static boolean autoCreateOnWrite(String dbName) {
        return config.getBoolean((Object)("sql." + dbName + ".sandbox.autoCreateOnWrite"), false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Connection openSandboxConnection(String dbName, String sandboxName) throws Exception {
        String sandboxMechanism = config.getString((Object)("sql." + dbName + ".sandbox.mechanism"), "database");
        log.debug((Object)("sandboxMechanism: " + sandboxMechanism + ", for db: " + dbName));
        Connection conn = null;
        if ("database".equals(sandboxMechanism)) {
            if (!SQLDriver.isConfigured(sandboxName)) {
                Config c = config.clone();
                String dbPrefix = "sql." + dbName;
                c.put((Object)(dbPrefix + ".dbsandbox.enabled"), (Object)"false");
                c.put((Object)(dbPrefix + ".wrapConnections"), (Object)"false");
                c.put((Object)(dbPrefix + ".driver.databaseName"), (Object)sandboxName);
                c.put((Object)(dbPrefix + ".pool.enabled"), (Object)"false");
                Config sandboxConfig = c.getSubtree(dbPrefix);
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Using sandbox config: " + DataTools.prettyPrint((Object)sandboxConfig)));
                }
                SQLDriver.configure(sandboxName, sandboxConfig);
            }
            conn = SQLDriver.instance(sandboxName).rawConnection();
            log.debug((Object)("Opened sandbox conn: " + conn.hashCode()));
        } else if ("schema".equals(sandboxMechanism)) {
            dbName = config.getString((Object)("sql." + dbName + ".sandbox.dbName"), dbName);
            conn = SQLDriver.instance(dbName).rawConnection();
            try (CallableStatement cs = conn.prepareCall("ALTER SESSION SET CURRENT_SCHEMA = " + sandboxName);){
                cs.execute();
                conn.commit();
            }
            log.debug((Object)("Changed to schema: " + sandboxName));
        } else if ("workspace".equals(sandboxMechanism)) {
            conn = SQLDriver.instance(dbName).rawConnection();
            try (CallableStatement cs = conn.prepareCall("CALL DBMS_WM.GotoWorkspace('" + sandboxName + "')");){
                cs.execute();
                conn.commit();
            }
            log.debug((Object)("Applied workspace: " + sandboxName));
        } else {
            throw new Exception(dbName + ": Invalid sandbox.mechanism: " + sandboxMechanism);
        }
        return conn;
    }

    public DBSandbox(String dbName, String schemaName, String sandboxName) {
        this.dbName = dbName;
        this.schemaName = schemaName;
        this.sandboxName = sandboxName;
    }

    public DBSandbox(String dbName, String sandboxName) {
        this(dbName, null, sandboxName);
    }

    public String getDbName() {
        return this.dbName;
    }

    public String getSandboxName() {
        return this.sandboxName;
    }

    public boolean exists() throws Exception {
        return SQLDriver.exists(this.dbName, this.sandboxName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void create() throws Exception {
        String string = this.sandboxName.intern();
        synchronized (string) {
            if (!this.exists()) {
                SQLDriver.createSandbox(this.dbName, this.schemaName, this.sandboxName);
            }
        }
    }

    public void remove() throws Exception {
        SQLDriver.removeSandbox(this.dbName, this.sandboxName);
    }

    public Connection openConnection() throws Exception {
        return DBSandbox.openSandboxConnection(this.dbName, this.getSandboxName());
    }
}

