<%@ taglib uri="/WEB-INF/iscTaglib.xml" prefix="isomorphic" %>
<%@ page import="com.isomorphic.base.*" %>
<%@ page import="com.isomorphic.rpc.*" %>
<%@ page import="com.isomorphic.auth.*" %>
<%@ page import="com.isomorphic.site.*" %>
<%@ page import="com.isomorphic.servlet.*" %>
<%@ page import="com.isomorphic.datasource.*" %>
<%@ page import="java.util.*" %>
<%
RequestContext requestContext = RequestContext.instance(this, request, response, out);
Map user = DevCenter.getUserRecordForOutputToBrowser(requestContext);
String username = user != null ? (String)user.get("username") : null;

final String organization = user != null ? (String)user.get("organization") : null;
final String orgUrlFrag = user != null ? (String)user.get("orgUrlFragment") : null;
final String deploymentId = request.getParameter("id");

Map deployment = DataSourceManager.get("hostedDeployments").fetchById(deploymentId);

final String deploymentName = (String)deployment.get("fileName");
final String deploymentType = (String)deployment.get("fileType");
%>
<!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.0 Transitional//EN">
<html><head>
<title>Deployment Management Console: <%=deploymentName%> (<%=deploymentType%>)</title>
<style>
.sessionAuditSectionTitle,
.sessionAuditSectionTitleFocused {
  color: #616161;
  padding-left: 10px;
  font-family: calibri;
  font-weight: bold;
  font-size: 12.58px;
}
</style>
</head>
<body>
<isomorphic:loadISC includeModules="Tools,History,SystemSchema" skin="Tahoe"/>

<SCRIPT>

<isomorphic:loadDS ID="hostedDeployments"/>

var userId = <% requestContext.jsTrans.toJS(username, out); %>,
    organization = "<%=organization%>",
    orgUrlFrag = "<%=orgUrlFrag%>",
    deploymentId = "<%=deploymentId%>",
    deploymentName = "<%=deploymentName%>",
    deploymentType = "<%=deploymentType%>"
;

var deploymentRoot = (location.origin+"").replace("create", deploymentType=="production"?"app":deploymentType)+"/";
isc.Auth.resetPasswordURL = deploymentRoot + orgUrlFrag + "/" + deploymentName +
                            "/auth/login.jsp?emailPassword=true&USERNAME=${userId}";


isc.DeploymentManager.create({

    // Details of the user managing the deployment
    // Used to generate the deployment URL on the client side
    userId:userId,
    organization:organization,
    orgUrlFragment:orgUrlFrag,

    deploymentName: deploymentName,
    deploymentType: deploymentType,
    deploymentId: deploymentId ? parseInt(deploymentId) : null,
    // dataSource included above
    deploymentDataSource: hostedDeployments,
    deploymentRemoved : function () {
        // Notify the visual builder that launched us that the deployments menu needs an update!
        if (window.opener && window.opener.builder) {
            window.opener.builder.updateExistingDeployments();
        }
        return this.Super("deploymentRemoved", arguments);
    },
    deploymentRenamed : function (newName) {
        // Notify the visual builder that launched us that the deployments menu needs an update!
        if (window.opener && window.opener.builder) {
            window.opener.builder.updateExistingDeployments();
        }
        return this.Super("deploymentRenamed", arguments);
    }


});

</SCRIPT>
</body>
</html>
