openapi: "${oasVersion}"
${infoFragment}
${serversFragment}

paths: {}

components:

  parameters:
    sortBy:    
      name: sortBy
      description: |
        Field name to sort by, prefixed with optional "-" indicating descending sort.
            
        For example, to sort by the field "userName" in ascending order, set sortBy to just "userName". For descending sort on "userName", set sortBy to "-userName".
        To sort by multiple fields, an array of field names is also supported. For example, to sort by the field "department" in ascending order, followed by the field 
        "userName" in descending order, set
         ```          
         sortBy=department&sortBy=-userName
         ```
      in: query    
      schema:
        type: string
    startRow:
      name: startRow
      description: Starting row of returned server results, when using paged result fetching. Note that startRow and endRow are zero-based - the first record is row zero.
      in: query
      schema:
        type: integer
        default: 0
    endRow:
      name: endRow
      description: End row of returned server results, when using paged result fetching. Note that startRow and endRow are zero-based - the first record is row zero.
      in: query
      schema:
        type: integer
  schemas:
  
    ErrorModel:
      description: When an error HTTP status (4XX or 5XX) is returned from the server, there will be an error object included. It will contain an error code and an array of error messages (even if there's just one message).
      type: object
      properties:
        code:
          type: number
        messages: 
          type: array
          items: 
            $ref: "#/components/schemas/ErrorMessage"
    
    ErrorMessage:
      description: A short description of what went wrong
      type: object
      properties:
        message:
          type: string
  
    Criterion:
      type: object
      properties:
        criteria:
          description: For a criterion with an operator that acts on other criteria (eg "and", "or"), a list of sub-criteria that are grouped together by the operator.
          type: array
          items:
            $ref: "#/components/schemas/Criterion"
        fieldName:
          description: Name of the field in each Record that this criterion applies to.
          type: string
        operator:
          description: Operator this criterion applies.
          type: string          
        value:
          description: Value to be used in the application of this criterion. Value may be required or not required, or may be an Array, according to the OperatorValueType of the operator.
          oneOf:
            - type: string
            - type: number
            - type: integer
            - type: boolean          
        start:
          description: Start value of a criterion with an operator of type "valueRange".
          type: integer          
        end:
          description: End value of a criterion with an operator of type "valueRange".
          type: integer  
    
    AdvancedCriteria:
      description: A format for representing search criteria which may include operators on field values such as "less than", or may include sub-clauses such as several criteria applied to fields joined by an "OR" operator.
      type: object 
      properties:
        _constructor: 
          type: string
          enum:
            - AdvancedCriteria
        operator: 
          type: string
          enum: [and, or]
          default: and
        criteria:
          type: array
          items: 
            $ref: "#/components/schemas/Criterion"
      example:
        {
          "_constructor": "AdvancedCriteria",
          "operator": "and",
          "criteria": [
            { "fieldName": "salary", "operator": "lessThan", "value": 80000 },
            { "operator": "or", "criteria" : [
                  { "fieldName": "title", "operator": "iContains", "value": "Manager" },
                  { "fieldName": "reports", "operator": "notNull" }
              ]  
            },
            { "fieldName": "startDate", "operator": "greaterThan", "value": "2018-03-20"}
          ]
        }      
    Operator:
      description: |
        An operator is used as part of a Criterion when specifying AdvancedCriteria.  This list of operators indicates the set of operators built into SmartClient DataSources, which can be used for both client and server-side filtering
        
        * equals: exactly equal to
        * notEqual: not equal to
        * iEquals: exactly equal to, if case is disregarded
        * iNotEqual: not equal to, if case is disregarded
        * greaterThan: Greater than
        * lessThan: Less than. Note that null is treated as equivalent to an arbitrarily small value, so null field values will always be returned by lessThan / lessOrEqual filter operations by default.
        * greaterOrEqual: Greater than or equal to
        * lessOrEqual: Less than or equal to
        * contains: Contains as sub-string (match case)
        * startsWith: Starts with (match case)
        * endsWith: Ends with (match case)
        * iContains: Contains as sub-string (case insensitive)
        * iStartsWith: Starts with (case insensitive)
        * iEndsWith: Ends with (case insensitive)
        * notContains: Does not contain as sub-string (match case)
        * notStartsWith: Does not start with (match case)
        * notEndsWith: Does not end with (match case)
        * iNotContains: Does not contain as sub-string (case insensitive)
        * iNotStartsWith: Does not start with (case insensitive)
        * iNotEndsWith: Does not end with (case insensitive)
        * iBetween: shortcut for "greaterThan" + "and" + "lessThan" (case insensitive)
        * iBetweenInclusive: shortcut for "greaterOrEqual" + "and" + "lessOrEqual" (case insensitive)
        * matchesPattern: Basic GLOB matching using wildcards (see DataSource.translatePatternOperators for more information on available patterns)
        * iMatchesPattern: Basic GLOB matching using wildcards (case insensitive) (see DataSource.translatePatternOperators for more information on available patterns)
        * containsPattern: GLOB matching using wildcards. Value is considered to meet the criterion if it contains the pattern. See DataSource.translatePatternOperators for more information on available patterns)
        * startsWithPattern: GLOB mathcing using wildcards. Value is considered to meet the criterion if it starts with the pattern.See DataSource.translatePatternOperators for more information on available patterns)
        * endsWithPattern: GLOB mathcing using wildcards. Value is considered to meet the criterion if it starts with the pattern.See DataSource.translatePatternOperators for more information on available patterns)
        * iContainsPattern: GLOB matching using wildcards. Value is considered to meet the criterion if it contains the pattern. Matching is case insensitive. See DataSource.translatePatternOperators for more information on available patterns)
        * iStartsWithPattern: GLOB matching using wildcards. Value is considered to meet the criterion if it starts with the pattern. Matching is case insensitive.See DataSource.translatePatternOperators for more information on available patterns)
        * iEndsWithPattern: GLOB matching using wildcards.Value is considered to meet the criterion if it ends with the pattern. Matching is case insensitive. See DataSource.translatePatternOperators for more information on available patterns)
        * regexp: Regular expression match
        * iregexp: Regular expression match (case insensitive)
        * isBlank: value is either null or the empty string. For numeric fields it behaves as isNull
        * notBlank: value is neither null nor the empty string ("")
        * isNull: value is null
        * notNull: value is non-null. Note empty string ("") is non-null
        * inSet: value is in a set of values. Specify criterion.value as an Array
        * notInSet: value is not in a set of values. Specify criterion.value as an Array
        * equalsField: matches another field (match case, specify fieldName as criterion.value)
        * notEqualField: does not match another field (match case, specify fieldName as criterion.value)
        * iEqualsField: matches another field (case insensitive, specify fieldName as criterion.value)
        * iNotEqualField: does not match another field (case insensitive, specify fieldName as criterion.value)
        * greaterThanField: Greater than another field (specify fieldName as criterion.value)
        * lessThanField: Less than another field (specify fieldName as criterion.value)
        * greaterOrEqualField: Greater than or equal to another field (specify fieldName as criterion.value)
        * lessOrEqualField:  Less than or equal to another field (specify fieldName as criterion.value)
        * containsField: Contains as sub-string (match case) another field value (specify fieldName as criterion.value)
        * startsWithField: Starts with (match case) another field value (specify fieldName as criterion.value)
        * endsWithField: Ends with (match case) another field value (specify fieldName as criterion.value)
        * iContainsField: Contains as sub-string (case insensitive) another field value (specify fieldName as criterion.value)
        * iStartsWithField: Starts with (case insensitive) another field value (specify fieldName as criterion.value)
        * iEndsWithField: Ends with (case insensitive) another field value (specify fieldName as criterion.value)
        * notContainsField: Does not contain as sub-string (match case) another field value (specify fieldName as criterion.value)
        * notStartsWithField: Does not start with (match case) another field value (specify fieldName as criterion.value)
        * notEndsWithField: Does not end with (match case) another field value (specify fieldName as criterion.value)
        * iNotContainsField: Does not contain as sub-string (case insensitive) another field value (specify fieldName as criterion.value)
        * iNotStartsWithField: Does not start with (case insensitive) another field value (specify fieldName as criterion.value)
        * iNotEndsWithField: Does not end with (case insensitive) another field value (specify fieldName as criterion.value)
        * and: all subcriteria (criterion.criteria) are true
        * not: all subcriteria (criterion.criteria) are false
        * or: at least one subcriteria (criterion.criteria) is true
        * between: shortcut for "greaterThan" + "lessThan" + "and". Specify criterion.start and criterion.end
        * betweenInclusive: shortcut for "greaterOrEqual" + "lessOrEqual" + "and". Specify criterion.start and criterion.end
      type: string
      enum:
        - equals
        - notEqual
        - iEquals
        - iNotEqual
        - greaterThan
        - lessThan
        - greaterOrEqual
        - lessOrEqual
        - contains
        - startsWith
        - endsWith
        - iContains
        - iStartsWith
        - iEndsWith
        - notContains
        - notStartsWith
        - notEndsWith
        - iNotContains
        - iNotStartsWith
        - iNotEndsWith
        - iBetween
        - iBetweenInclusive
        - matchesPattern
        - iMatchesPattern
        - containsPattern
        - startsWithPattern
        - endsWithPattern
        - iContainsPattern
        - iStartsWithPattern
        - iEndsWithPattern
        - regexp
        - iregexp
        - isBlank
        - notBlank
        - isNull
        - notNull
        - inSet
        - notInSet
        - equalsField
        - notEqualField
        - iEqualsField
        - iNotEqualField
        - greaterThanField
        - lessThanField
        - greaterOrEqualField
        - lessOrEqualField
        - containsField
        - startsWithField
        - endsWithField
        - iContainsField
        - iStartsWithField
        - iEndsWithField
        - notContainsField
        - notStartsWithField
        - notEndsWithField
        - iNotContainsField
        - iNotStartsWithField
        - iNotEndsWithField
        - and
        - not
        - or
        - between
        - betweenInclusive
  
  
    <#--  TODO add status code enum -->
    
  responses:
  
    204:
      description: If a request returns no results, it will return an empty HTTP response with status 204 - "no content".
       
    ErrorResponse:
      description: |  
        Error.  Errors fall into two main categories, and include:

        * Validation errors, which arise as a result of rules in the application's business logic being broken. These are part of the normal operation of the system. A response with validation errors has a code value of -4.
        * Unrecoverable errors, which are errors with the system itself. These are not part of the normal operation of the system

      content:
        application/json:
          schema:
            $ref: '#/components/schemas/ErrorModel'
        application/xml:
          schema:
            $ref: '#/components/schemas/ErrorModel'  
          