/*

  SmartClient Ajax RIA system
  Version v12.1p_2026-01-14/LGPL Deployment (2026-01-14)

  Copyright 2000 and beyond Isomorphic Software, Inc. All rights reserved.
  "SmartClient" is a trademark of Isomorphic Software, Inc.

  LICENSE NOTICE
     INSTALLATION OR USE OF THIS SOFTWARE INDICATES YOUR ACCEPTANCE OF
     ISOMORPHIC SOFTWARE LICENSE TERMS. If you have received this file
     without an accompanying Isomorphic Software license file, please
     contact licensing@isomorphic.com for details. Unauthorized copying and
     use of this software is a violation of international copyright law.

  DEVELOPMENT ONLY - DO NOT DEPLOY
     This software is provided for evaluation, training, and development
     purposes only. It may include supplementary components that are not
     licensed for deployment. The separate DEPLOY package for this release
     contains SmartClient components that are licensed for deployment.

  PROPRIETARY & PROTECTED MATERIAL
     This software contains proprietary materials that are protected by
     contract and intellectual property law. You are expressly prohibited
     from attempting to reverse engineer this software or modify this
     software for human readability.

  CONTACT ISOMORPHIC
     For more information regarding license rights and restrictions, or to
     report possible license violations, please contact Isomorphic Software
     by email (licensing@isomorphic.com) or web (www.isomorphic.com).

*/
isc.docVersionInfo = {
    scVersionNumber:"12.1",
    edition:"Pro",
    scVersion:"12.1p",
    versionNumber:"v12.1p_2026-01-14",
    version:"v12.1p_2026-01-14/LGPL Development Only"
};
isc.docItems = {
    "attr:FormSetFieldValueTask.targetField":{
        seeAlso:[
        ],
        ref:"attr:FormSetFieldValueTask.targetField",
        defaultValue:"null",
        deprecated:null,
        type:"attr",
        definingClass:"class:FormSetFieldValueTask",
        valueType:"FieldName",
        description:"Field to assign new value.",
        flags:"IR",
        name:"targetField"
    },
    "method:Array.addAt":{
        seeAlso:[
        ],
        type:"method",
        definingClass:"object:Array",
        returns:{
            type:"Object",
            description:"object that was added"
        },
        groups:[
            "modification"
        ],
        deprecated:null,
        ref:"method:Array.addAt",
        params:[
            {
                defaultValue:null,
                optional:false,
                type:"Object",
                description:"object to add",
                name:"obj"
            },
            {
                defaultValue:null,
                optional:false,
                type:"number",
                description:"position in the list to add at",
                name:"pos"
            }
        ],
        description:" Add a single item to this array at a specific position in the list, sliding other items over\n to fit.\n\n",
        flags:"",
        name:"addAt"
    },
    "attr:ResultSet.implicitCriteria":{
        seeAlso:[
        ],
        ref:"attr:ResultSet.implicitCriteria",
        defaultValue:"null",
        deprecated:null,
        type:"attr",
        definingClass:"class:ResultSet",
        valueType:"Criteria",
        description:"Criteria that are never shown to or edited by the user and are cumulative with any \n criteria provided via ${isc.DocUtils.linkForRef('attr:DataBoundComponent.initialCriteria')}, ${isc.DocUtils.linkForRef('method:ResultSet.setCriteria')}\n etc.",
        flags:"IRW",
        name:"implicitCriteria"
    },
    "classMethod:TabIndexManager.getTabIndex":{
        seeAlso:[
        ],
        ref:"classMethod:TabIndexManager.getTabIndex",
        deprecated:null,
        type:"classMethod",
        definingClass:"class:TabIndexManager",
        params:[
            {
                defaultValue:null,
                optional:false,
                type:"String",
                description:"ID of the target for which you want to get a numeric tabIndex.",
                name:"ID"
            }
        ],
        description:" Returns a tabIndex number for some target ID registered via ${isc.DocUtils.linkForRef('classMethod:TabIndexManager.addTarget')}.\n Generated tab indices are guaranteed to be in order.\n <P>\n As targets are added to, or moved within the TabIndexManager, their tab index may become invalid.\n The <code>tabIndexUpdated</code> notification will be fired when this occurs, giving developers\n a way to pick up the new tab index, and assign it to the appropriate DOM element if appropriate.\n",
        flags:"",
        returns:{
            type:"Integer",
            description:"returns the numeric tabIndex value for the specified target"
        },
        name:"getTabIndex"
    },
    "attr:DataSourceField.maxFileSize":{
        seeAlso:[
            {
                ref:"classAttr:DataSource.maxFileSizeExceededMessage",
                description:null
            }
        ],
        defaultValue:"null",
        type:"attr",
        definingClass:"object:DataSourceField",
        deprecated:null,
        ref:"attr:DataSourceField.maxFileSize",
        valueType:"Integer",
        description:"For fields of a type that are represented by binary data initially uploaded from a file\n (currently \"binary\" and \"imageFile\", see ${isc.DocUtils.linkForRef('type:FieldType')}), this sets the maximum \n file size allowed, in bytes.",
        flags:"IR",
        serverDS:"only",
        name:"maxFileSize"
    },
    "attr:MultiSortDialog.applyButton":{
        seeAlso:[
        ],
        ref:"attr:MultiSortDialog.applyButton",
        defaultValue:"null",
        deprecated:null,
        type:"attr",
        definingClass:"class:MultiSortDialog",
        valueType:"AutoChild IButton",
        description:"Automatically generated ${isc.DocUtils.linkForRef('class:IButton')} providing the mechanism for accepting\n the current sort configuration.  Fires the passed callback with a single parameter,\n sortLevels, representing the current sort configuration as an array of \n ${isc.DocUtils.linkForRef('object:SortSpecifier')}s.\n <P>\n This component is an ${isc.DocUtils.linkForRef('type:AutoChild')} and as such may be customized via \n <code>multiSortDialog.applyButtonProperties</code> and \n <code>multiSortDialog.applyButtonDefaults</code>.",
        flags:"RA",
        name:"applyButton"
    },
    "attr:SelectItem.fetchDisplayedFieldsOnly":{
        seeAlso:[
        ],
        ref:"attr:SelectItem.fetchDisplayedFieldsOnly",
        defaultValue:"null",
        deprecated:null,
        type:"attr",
        definingClass:"class:SelectItem",
        valueType:"boolean",
        description:"If this item has a specified <code>optionDataSource</code> and this property is\n <code>true</code>, the list of fields used by this pickList will be passed to\n the datasource as ${isc.DocUtils.linkForRef('attr:DSRequest.outputs')}. If the datasource supports this feature\n the returned fields will be limited to this list. A custom datasource will need to\n add code to implement field limiting.\n <P>\n This list of used fields consists of the values of ${isc.DocUtils.linkForRef('attr:FormItem.valueField','valueField')},\n ${isc.DocUtils.linkForRef('attr:FormItem.displayField','displayField')} and ${isc.DocUtils.linkForRef('attr:SelectItem.pickListFields','pickListFields')}.\n <P>\n NOTE: When enabled, ${isc.DocUtils.linkForRef('method:FormItem.getSelectedRecord','getSelectedRecord')} will only include the\n fetched fields.",
        flags:"IRA",
        name:"fetchDisplayedFieldsOnly"
    },
    "method:PickList.dataArrived":{
        seeAlso:[
        ],
        ref:"method:PickList.dataArrived",
        deprecated:null,
        type:"method",
        definingClass:"interface:PickList",
        params:[
            {
                defaultValue:null,
                optional:false,
                type:"int",
                description:"index of first row returned by the server",
                name:"startRow"
            },
            {
                defaultValue:null,
                optional:false,
                type:"int",
                description:"index of last row returned by the server",
                name:"endRow"
            },
            {
                defaultValue:null,
                optional:false,
                type:"ResultSet",
                description:"pointer to this pickList's data",
                name:"data"
            }
        ],
        description:" If this item is showing a dataBound pickList, this notification method will be fired \n when new data arrives from the server.\n",
        flags:"",
        name:"dataArrived"
    },
    "method:ColorItem.pickerColorSelected":{
        seeAlso:[
        ],
        ref:"method:ColorItem.pickerColorSelected",
        deprecated:null,
        type:"method",
        definingClass:"class:ColorItem",
        params:[
            {
                defaultValue:null,
                optional:false,
                type:"String",
                description:"The selected color as a string.",
                name:"color"
            },
            {
                defaultValue:null,
                optional:false,
                type:"Integer",
                description:"The selected opacity, from 0 (transparent) to 100 (opaque),                          or null if ${isc.DocUtils.linkForRef('attr:ColorItem.supportsTransparency')} is false or the\n                          ${isc.DocUtils.linkForRef('class:ColorPicker','color picker')} selected a color while in\n                          ${isc.DocUtils.linkForRef('type:ColorPickerMode','simple mode')}.",
                name:"opacity"
            }
        ],
        description:" Store the color value selected by the user from the color picker.  You will need to \n override this method if you wish to capture opacity information from the\n ${isc.DocUtils.linkForRef('class:ColorPicker')}.\n",
        flags:"",
        name:"pickerColorSelected"
    },
    "classMethod:Authentication.getCurrentUser":{
        seeAlso:[
        ],
        ref:"classMethod:Authentication.getCurrentUser",
        deprecated:null,
        type:"classMethod",
        definingClass:"class:Authentication",
        description:" Returns the current user specified by ${isc.DocUtils.linkForRef('classMethod:Authentication.setCurrentUser')}. \n <P>\n This method returns the user record currently available in the \n ${isc.DocUtils.linkForRef('attr:Canvas.ruleScope')} as \"auth.currentUser\".\n\n",
        flags:"",
        returns:{
            type:"Record",
            description:"Record with attributes detailing the current user"
        },
        name:"getCurrentUser"
    },
    "attr:Calendar.showColumnLayouts":{
        seeAlso:[
        ],
        defaultValue:"false",
        type:"attr",
        definingClass:"class:Calendar",
        groups:[
            "appearance"
        ],
        deprecated:null,
        ref:"attr:Calendar.showColumnLayouts",
        valueType:"Boolean",
        description:"When true, causes ${isc.DocUtils.linkForRef('attr:Calendar.columnLayout','layouts')} to be added to each column in \n vertical views.  In this mode, eventCanvases are stacked in these layouts, filling width \n and auto-sizing vertically to content, rather than being placed, sized and overlapped \n according to their times.\n <P>\n Because times are ignored in this mode, various behaviors are switched off automatically;\n for example, the ${isc.DocUtils.linkForRef('attr:Calendar.showLabelColumn','time-column')} is hidden and event-canvases \n cannot be ${isc.DocUtils.linkForRef('attr:Calendar.canResizeEvents','resized')} or rendered\n ${isc.DocUtils.linkForRef('attr:Calendar.renderEventsOnDemand','on-demand')}.",
        flags:"IR",
        name:"showColumnLayouts"
    },
    "attr:MultiSortDialog.deleteLevelButton":{
        seeAlso:[
        ],
        ref:"attr:MultiSortDialog.deleteLevelButton",
        defaultValue:"null",
        deprecated:null,
        type:"attr",
        definingClass:"class:MultiSortDialog",
        valueType:"AutoChild IButton",
        description:"Automatically generated ${isc.DocUtils.linkForRef('class:IButton')} providing a mechanism for deleting levels\n from the sort configuration.\n <P>\n This component is an ${isc.DocUtils.linkForRef('type:AutoChild')} and as such may be customized via \n <code>multiSortPanel.deleteLevelButtonProperties</code> and \n <code>multiSortPanel.deleteLevelButtonDefaults</code>.",
        flags:"RA",
        name:"deleteLevelButton"
    },
    "attr:ListGrid.autoFetchDisplayMap":{
        seeAlso:[
            {
                ref:"attr:ListGridField.autoFetchDisplayMap",
                description:null
            },
            {
                ref:"attr:ListGridField.optionDataSource",
                description:null
            }
        ],
        defaultValue:"true",
        type:"attr",
        definingClass:"class:ListGrid",
        groups:[
            "display_values"
        ],
        deprecated:null,
        ref:"attr:ListGrid.autoFetchDisplayMap",
        valueType:"Boolean",
        description:"If true, for fields where ${isc.DocUtils.linkForRef('attr:ListGridField.optionDataSource')} is specified,\n a valueMap will be automatically created by making a ${isc.DocUtils.linkForRef('method:DataSource.fetchData')} call\n against the specified dataSource and extracting a valueMap from the returned records\n based on the displayField and valueField.\n <P>\n If set to false, valueMaps will not be automatically fetched.  In this case, setting\n field.optionDataSource is effectively a shortcut for setting optionDataSource on\n the editor via ${isc.DocUtils.linkForRef('attr:ListGridField.editorProperties')}.\n <P>\n Can also be disabled on a per-field basis with ${isc.DocUtils.linkForRef('attr:ListGridField.autoFetchDisplayMap')}.",
        flags:"IRW",
        name:"autoFetchDisplayMap"
    },
    "attr:FacetChart.maxDataPointSize":{
        seeAlso:[
        ],
        ref:"attr:FacetChart.maxDataPointSize",
        defaultValue:"14",
        deprecated:null,
        type:"attr",
        definingClass:"class:FacetChart",
        valueType:"float",
        description:"The maximum allowed data point size when controlled by ${isc.DocUtils.linkForRef('attr:FacetChart.pointSizeMetric')}.",
        flags:"IR",
        name:"maxDataPointSize"
    },
    "method:Calendar.currentViewChanged":{
        seeAlso:[
        ],
        ref:"method:Calendar.currentViewChanged",
        deprecated:null,
        type:"method",
        definingClass:"class:Calendar",
        params:[
            {
                defaultValue:null,
                optional:false,
                type:"ViewName",
                description:"the name of the current view after the change",
                name:"viewName"
            }
        ],
        description:" Notification that fires whenever the current view changes via the \n ${isc.DocUtils.linkForRef('attr:Calendar.mainView','mainView tabset')}.\n\n",
        flags:"",
        name:"currentViewChanged"
    },
    "method:SimpleType.getGroupValue":{
        seeAlso:[
        ],
        ref:"method:SimpleType.getGroupValue",
        deprecated:null,
        type:"method",
        definingClass:"class:SimpleType",
        params:[
            {
                defaultValue:null,
                optional:false,
                type:"Any",
                description:"the record value to return a group value for",
                name:"value"
            },
            {
                defaultValue:null,
                optional:false,
                type:"Record",
                description:"the record containing the passed value",
                name:"record"
            },
            {
                defaultValue:null,
                optional:false,
                type:"Object",
                description:"the field relating to the value to be processed",
                name:"field"
            },
            {
                defaultValue:null,
                optional:false,
                type:"String",
                description:"the name of the field relating to the value to be processed",
                name:"fieldName"
            },
            {
                defaultValue:null,
                optional:false,
                type:"Canvas",
                description:"the component, usually a ${isc.DocUtils.linkForRef('class:ListGrid')}, containing the                           passed record",
                name:"component"
            }
        ],
        description:" Returns a group value appropriate for the passed record, field and value, in the passed \n component.\n \n",
        flags:"",
        returns:{
            type:"Any",
            description:"the group value for the passed parameters"
        },
        name:"getGroupValue"
    },
    "attr:ListGrid.clipHeaderTitles":{
        seeAlso:[
            {
                ref:"attr:ListGrid.headerBaseStyle",
                description:null
            }
        ],
        defaultValue:"varies",
        type:"attr",
        definingClass:"class:ListGrid",
        groups:[
            "gridHeader",
            "appearance"
        ],
        deprecated:null,
        ref:"attr:ListGrid.clipHeaderTitles",
        valueType:"Boolean",
        description:"Whether the ListGrid should manage the clipping of titles of header buttons, showing\n ellipses if the title is clipped, and potentially showing the full title\n on ${isc.DocUtils.linkForRef('attr:ListGrid.showClippedHeaderTitlesOnHover','hover')}.\n <p>\n In some cases this may be preferable to the button component's default clipping behavior\n because if a ${isc.DocUtils.linkForRef('attr:ListGrid.showSortArrow','sort arrow')} or sort numeral is displayed for\n a header, then the button's default clipping behavior may clip the sort arrow/numeral\n whereas ListGrid-managed title clipping utilizes special HTML which keeps the sort\n arrow/numeral visible.\n <p>\n This feature is automatically enabled if supported by the browser. The only supported\n use of this attribute is to <em>disable</em> the feature by setting clipHeaderTitles\n to false.\n <P>\n Note that this feature is incompatible with ${isc.DocUtils.linkForRef('attr:ListGridField.wrap')}, and will\n automatically be disabled for wrapping fields.",
        flags:"IRA",
        name:"clipHeaderTitles"
    },
    "attr:CubeGrid.valueFormat":{
        seeAlso:[
        ],
        defaultValue:"null",
        type:"attr",
        definingClass:"class:CubeGrid",
        groups:[
            "exportFormatting"
        ],
        deprecated:null,
        ref:"attr:CubeGrid.valueFormat",
        valueType:"FormatString",
        description:"${isc.DocUtils.linkForRef('type:FormatString')} for numeric or date formatting.  See ${isc.DocUtils.linkForRef('attr:DataSourceField.format')}.",
        flags:"IR",
        name:"valueFormat"
    },
    "attr:ListGrid.hiliteCanReplaceValue":{
        seeAlso:[
        ],
        defaultValue:"null",
        type:"attr",
        definingClass:"class:ListGrid",
        groups:[
            "hiliting"
        ],
        deprecated:null,
        ref:"attr:ListGrid.hiliteCanReplaceValue",
        valueType:"boolean",
        description:"If set, end users can create advanced hiliting rules that will use the\n ${isc.DocUtils.linkForRef('attr:Hilite.replacementValue')} feature to cause values in hilited cells\n to be replaced with a user-entered value.  For example, a user could create a hilite rule\n that replaces numeric values ranging from 0.5 to 1.0 with the text \"LOW\".\n <p>\n Specifically, when the \"Add Advanced Rule\" button is pressed and\n <code>hiliteCanReplaceValue</code> is true, the user will see a text entry field titled\n \"Replace value with\" (${isc.DocUtils.linkForRef('attr:ListGrid.hiliteReplaceValueFieldTitle')}) and if they enter a value, that\n value will appear in the grid cell in lieu of the cell's original value.",
        flags:"IR",
        name:"hiliteCanReplaceValue"
    },
    "method:NavigationBar.setLeftButtonTitle":{
        seeAlso:[
        ],
        ref:"method:NavigationBar.setLeftButtonTitle",
        deprecated:null,
        type:"method",
        definingClass:"class:NavigationBar",
        params:[
            {
                defaultValue:null,
                optional:false,
                type:"HTMLString",
                description:"new title HTML for the left button.",
                name:"newTitle"
            }
        ],
        description:" Setter for ${isc.DocUtils.linkForRef('attr:NavigationBar.leftButtonTitle','leftButtonTitle')}.\n",
        flags:"",
        name:"setLeftButtonTitle"
    },
    "method:DataSource.getFieldOperators":{
        seeAlso:[
        ],
        type:"method",
        definingClass:"class:DataSource",
        returns:{
            type:"Array of OperatorId",
            description:"available Operators"
        },
        groups:[
            "advancedFilter"
        ],
        deprecated:null,
        ref:"method:DataSource.getFieldOperators",
        params:[
            {
                defaultValue:null,
                optional:false,
                type:"String | DataSourceField",
                description:"Field (or field name) to obtain operators for",
                name:"field"
            }
        ],
        description:" Get the list of ${isc.DocUtils.linkForRef('type:OperatorId')}s available for this field.\n <P>\n By default, if ${isc.DocUtils.linkForRef('attr:DataSourceField.validOperators','field.validOperators')} is set,\n returns that list, otherwise returns the result of ${isc.DocUtils.linkForRef('method:DataSource.getTypeOperators')}.\n",
        flags:"",
        name:"getFieldOperators"
    },
    "method:Array.find":{
        seeAlso:[
        ],
        type:"method",
        definingClass:"object:Array",
        returns:{
            type:"Object",
            description:"first matching object or null if not found"
        },
        groups:[
            "access",
            "find"
        ],
        deprecated:null,
        ref:"method:Array.find",
        params:[
            {
                defaultValue:null,
                optional:false,
                type:"String | Object | AdvancedCriteria",
                description:"property to match, or if an Object is passed, set of                                        properties and values to match",
                name:"propertyName"
            },
            {
                defaultValue:null,
                optional:true,
                type:"Any",
                description:"value to compare against (if propertyName is a string)",
                name:"value"
            }
        ],
        description:" Like ${isc.DocUtils.linkForRef('method:Array.findIndex')}, but returns the object itself instead of its index.\n\n",
        flags:"",
        name:"find"
    },
    "attr:RangeSlider.startThumb":{
        seeAlso:[
        ],
        ref:"attr:RangeSlider.startThumb",
        defaultValue:"null",
        deprecated:null,
        type:"attr",
        definingClass:"class:RangeSlider",
        valueType:"AutoChild Snapbar",
        description:"Thumb for the start of the range.",
        flags:"IR",
        name:"startThumb"
    },
    "method:TabSet.tabIconClick":{
        seeAlso:[
        ],
        ref:"method:TabSet.tabIconClick",
        deprecated:null,
        type:"method",
        definingClass:"class:TabSet",
        params:[
            {
                defaultValue:null,
                optional:false,
                type:"Tab",
                description:"with click handler being fired",
                name:"tab"
            }
        ],
        description:" Method fired when the user clicks the icon for a tab, as specified via ${isc.DocUtils.linkForRef('attr:Tab.icon')}.\n <P>\n Default behavior will fire <code>icon.click()</code> if specified, with two parameters\n <code>tab</code> (a pointer to the tab object and <code>tabSet</code> a pointer to the tabSet\n instance.\n",
        flags:"",
        name:"tabIconClick"
    },
    "class:TriplePane":{
        seeAlso:[
        ],
        type:"class",
        staticMethods:[
        ],
        inheritsFrom:"SplitPane",
        classMethods:[
        ],
        classAttrs:[
        ],
        attrs:[
        ],
        ref:"class:TriplePane",
        deprecated:null,
        treeLocation:[
            "Client Reference/Layout"
        ],
        description:"This class is a synonym for SplitPane that can be used to make intent clearer.\n It is used by some development tools for that purpose.",
        methods:[
        ],
        name:"TriplePane"
    },
    "attr:ListGrid.filterByCell":{
        seeAlso:[
        ],
        defaultValue:"null",
        type:"attr",
        definingClass:"class:ListGrid",
        groups:[
            "filterEditor"
        ],
        deprecated:null,
        ref:"attr:ListGrid.filterByCell",
        valueType:"boolean",
        description:"If we're showing the filterEditor (this.showFilterEditor is true), this property\n determines whether this list should be filtered every time the user puts focus in\n a different field in the filter editor.",
        flags:"IRWA",
        name:"filterByCell"
    },
    "attr:DynamicForm.checkFileAccessOnSubmit":{
        seeAlso:[
        ],
        ref:"attr:DynamicForm.checkFileAccessOnSubmit",
        defaultValue:"true",
        deprecated:null,
        type:"attr",
        definingClass:"class:DynamicForm",
        valueType:"boolean",
        description:"For dynamicForms containing a ${isc.DocUtils.linkForRef('class:FileItem')} for uploading files,\n should the browser verify that the file is accessible before submitting\n the uploaded file to the server?\n <P>\n In some cases the browser may not be able to access the selected file.<br>\n This can occur when the file has been modified in the file system after selection in the\n browser, or if the current user doesn't have permission to view the file.\n <P>\n By default, before submitting the file to the server\n the browser will verify that it can access the file's contents and display \n the ${isc.DocUtils.linkForRef('attr:DynamicForm.fileAccessFailedWarning')} if file access fails.<br>\n Note that accessing the file's contents is an asynchronous process, so\n form submission is not performed synchronously.\n <P>\n This means that if application code calls ${isc.DocUtils.linkForRef('method:DynamicForm.saveData')} on a form containing a\n fileItem and then synchronously ${isc.DocUtils.linkForRef('method:Canvas.clear','clears')} it from the DOM, the upload will\n never be kicked off.<br>\n Setting <code>checkFileAccessOnSubmit</code> to false will suppress the (asynchronous) check, \n and can be used to bypass this limitation, but this is not recommended except as a short term\n backwards-compatibility workaround. Instead we'd recommend using the ${isc.DocUtils.linkForRef('method:DynamicForm.saveData','saveData callback')}\n to clear the form when the upload has completed. This also gives the user an opportunity to correct\n validation errors and re-submit the form if necessary.",
        flags:"IRWA",
        name:"checkFileAccessOnSubmit"
    },
    "method:FormItem.getVisibleTitleWidth":{
        seeAlso:[
        ],
        type:"method",
        definingClass:"class:FormItem",
        returns:{
            type:"number",
            description:"width of the form item's title in px"
        },
        groups:[
            "sizing"
        ],
        deprecated:null,
        ref:"method:FormItem.getVisibleTitleWidth",
        params:[
            {
                defaultValue:null,
                optional:false,
                type:"Boolean",
                description:"If true, returns the visible width of the title text                                  only; if false (the default) returns the width of the \n                                  title cell",
                name:"labelOnly"
            }
        ],
        description:"\tReturns the visible width of this item's title in px.  If that is not applicable (for \n example, the form item has no title) or cannot be determined (for example, the form \n is not drawn), returns 0.\n",
        flags:"A",
        name:"getVisibleTitleWidth"
    },
    "attr:PickTreeItem.valueTree":{
        seeAlso:[
        ],
        defaultValue:"null",
        type:"attr",
        definingClass:"class:PickTreeItem",
        ref:"attr:PickTreeItem.valueTree",
        deprecated:null,
        setter:[
            "setValueTree"
        ],
        valueType:"Tree",
        description:"A ${isc.DocUtils.linkForRef('class:Tree')} of options from which the user can select.",
        flags:"IR",
        examples:[
            "${isc.DocUtils.linkForExampleId('pickTree')}"
        ],
        name:"valueTree"
    },
    "attr:TestFunctionResult.failedGeneration":{
        seeAlso:[
        ],
        defaultValue:"false",
        type:"attr",
        definingClass:"object:TestFunctionResult",
        groups:[
            "formulaFields"
        ],
        deprecated:null,
        ref:"attr:TestFunctionResult.failedGeneration",
        valueType:"boolean",
        description:"Set to true if there is a syntax error in the formula or summary being checked.\n <P>\n When set to true, ${isc.DocUtils.linkForRef('attr:TestFunctionResult.errorText')} contains the exception message.",
        flags:"IRW",
        name:"failedGeneration"
    },
    "method:Calendar.selectTab":{
        seeAlso:[
        ],
        ref:"method:Calendar.selectTab",
        deprecated:null,
        type:"method",
        definingClass:"class:Calendar",
        params:[
            {
                defaultValue:null,
                optional:false,
                type:"number",
                description:"the index of the tab to select",
                name:"tabnum"
            }
        ],
        description:" Selects the calendar view in the passed tab number.\n\n",
        flags:"",
        name:"selectTab"
    },
    "method:MultiGroupDialog.getNumLevels":{
        seeAlso:[
        ],
        ref:"method:MultiGroupDialog.getNumLevels",
        deprecated:null,
        type:"method",
        definingClass:"class:MultiGroupDialog",
        description:" Return the number of levels of grouping that have been configured.\n\n",
        flags:"",
        returns:{
            type:"number",
            description:"The number of levels of grouping that have been configured"
        },
        name:"getNumLevels"
    },
    "attr:IconButton.rowSpan":{
        seeAlso:[
        ],
        ref:"attr:IconButton.rowSpan",
        defaultValue:"1",
        deprecated:null,
        type:"attr",
        definingClass:"class:IconButton",
        valueType:"Number",
        description:"When used in a ${isc.DocUtils.linkForRef('class:RibbonBar')}, the number of rows this button should occupy in a\n single ${isc.DocUtils.linkForRef('attr:ToolStripGroup.columnLayout','column')}.",
        flags:"IRW",
        name:"rowSpan"
    },
    "method:PortalLayout.willAcceptPortletDrop":{
        seeAlso:[
            {
                ref:"attr:Canvas.dragType",
                description:null
            },
            {
                ref:"attr:PortalLayout.portletDropTypes",
                description:null
            },
            {
                ref:"method:PortalLayout.portletsChanged",
                description:null
            }
        ],
        type:"method",
        definingClass:"class:PortalLayout",
        returns:{
            type:"boolean",
            description:"true if the ${isc.DocUtils.linkForRef('class:Portlet')} or other component being dragged can be dropped on this PortalLayout,                      false otherwise"
        },
        groups:[
            "dragdrop"
        ],
        deprecated:null,
        ref:"method:PortalLayout.willAcceptPortletDrop",
        params:[
            {
                defaultValue:null,
                optional:false,
                type:"Canvas",
                description:"The ${isc.DocUtils.linkForRef('class:Portlet')}, or other component, being dragged",
                name:"dragTarget"
            },
            {
                defaultValue:null,
                optional:false,
                type:"int",
                description:"indicates which column the portlet would be dropped on.",
                name:"colNum"
            },
            {
                defaultValue:null,
                optional:false,
                type:"int",
                description:"indicates the row number being dropped on.",
                name:"rowNum"
            },
            {
                defaultValue:null,
                optional:true,
                type:"int",
                description:"Drop position within an existing row. If the dropPosition   is null, then that means that a new row will be created.",
                name:"dropPosition"
            }
        ],
        description:" <p>Returns true if the dragged ${isc.DocUtils.linkForRef('class:Portlet')}, or other component, can be dropped onto\n this <code>PortalLayout</code> (other components would be auto-wrapped in a <code>Portlet</code>).</p>\n\n <p>The default implementation acts like ${isc.DocUtils.linkForRef('method:Canvas.willAcceptDrop')}, except applying\n ${isc.DocUtils.linkForRef('attr:PortalLayout.portletDropTypes','portletDropTypes')} rather than ${isc.DocUtils.linkForRef('attr:PortalLayout.dropTypes','dropTypes')}.\n You can subclass to apply other (or additional) criteria</p>\n\n",
        flags:"A",
        name:"willAcceptPortletDrop"
    },
    "method:StatefulCanvas.setDisabled":{
        groups:[
            "enable",
            "state"
        ],
        seeAlso:[
        ],
        ref:"method:StatefulCanvas.setDisabled",
        deprecated:null,
        type:"method",
        definingClass:"class:StatefulCanvas",
        params:[
            {
                defaultValue:null,
                optional:false,
                type:"boolean",
                description:"true if this widget is to be disabled",
                name:"disabled"
            }
        ],
        description:" Enable or disable this object\n",
        flags:"",
        name:"setDisabled"
    },
    "attr:MenuItem.embeddedComponentFields":{
        seeAlso:[
        ],
        defaultValue:"null",
        type:"attr",
        definingClass:"object:MenuItem",
        groups:[
            "menuBasic"
        ],
        deprecated:null,
        ref:"attr:MenuItem.embeddedComponentFields",
        valueType:"Array of String",
        description:"See ${isc.DocUtils.linkForRef('attr:ListGridRecord.embeddedComponentFields')}.  Default for a MenuItem is to cover the\n title and key fields, leaving the icon and submenu fields visible.",
        flags:"IR",
        name:"embeddedComponentFields"
    },
    "method:ListGrid.setFieldCellIcon":{
        seeAlso:[
        ],
        ref:"method:ListGrid.setFieldCellIcon",
        deprecated:null,
        type:"method",
        definingClass:"class:ListGrid",
        params:[
            {
                defaultValue:null,
                optional:false,
                type:"String",
                description:"field to update",
                name:"fieldName"
            },
            {
                defaultValue:null,
                optional:false,
                type:"SCImgURL",
                description:"new cellIcon for the field",
                name:"cellIcon"
            }
        ],
        description:" Change the ${isc.DocUtils.linkForRef('attr:ListGridField.cellIcon')} for a field after the grid is created\n",
        flags:"",
        name:"setFieldCellIcon"
    },
    "attr:DSRequest.exportToClient":{
        seeAlso:[
        ],
        ref:"attr:DSRequest.exportToClient",
        defaultValue:"true",
        deprecated:null,
        type:"attr",
        definingClass:"object:DSRequest",
        valueType:"Boolean",
        description:"If set to true (the default), SmartClient Server will export data back to the client,\n either as a file download or as content in a new browser window, depending on the setting of\n ${isc.DocUtils.linkForRef('attr:DSRequest.exportDisplay','exportDisplay')}.\n <p>\n Setting this property to false disables this. This may be useful when developers \n wish to ${isc.DocUtils.linkForRef('attr:DSRequest.exportToFilesystem','export the data to a file on the server fileSystem')},\n but do not need to display it in the browser in response to the export request.\n <p>\n Note that it is perfectly valid to have both this property and \n ${isc.DocUtils.linkForRef('attr:DSRequest.exportToFilesystem','exportToFilesystem')} set to true; in this case the data is both \n exported to a file on the server filesystem, and downloaded to the client.  If you specify \n <em>neither</em> property, the export no-ops.",
        flags:"IR",
        name:"exportToClient"
    },
    "classMethod:Canvas.getSnapPosition":{
        seeAlso:[
        ],
        ref:"classMethod:Canvas.getSnapPosition",
        deprecated:null,
        type:"classMethod",
        definingClass:"class:Canvas",
        params:[
            {
                defaultValue:null,
                optional:false,
                type:"Canvas | Array of Integer",
                description:"canvas to snap to",
                name:"target"
            },
            {
                defaultValue:null,
                optional:false,
                type:"String",
                description:"edge against which to snap",
                name:"snapTo"
            },
            {
                defaultValue:null,
                optional:false,
                type:"Canvas | Array of Integer",
                description:"canvas being snapped",
                name:"snapper"
            },
            {
                defaultValue:null,
                optional:true,
                type:"String",
                description:"optional edge to snapTo. Default is the <b>opposite</b> edge or corner from  <code>snapTo</code>",
                name:"snapEdge"
            }
        ],
        description:"  Return the position for <code>snapper</code> to be placed in order to \"snap to\" an edge or\n  corner of <code>target</code>, in the same sense as ${isc.DocUtils.linkForRef('attr:Canvas.snapTo')}.\n  <p>\n  Default for <code>snapEdge</code> is the <b>opposite</b> edge or corner from\n  <code>snapTo</code>.  For example, <code>snapTo</code> of \"T\" (top) means <code>snapEdge</code>\n  will default to \"B\" (bottom), so the returned coordinates would place <code>snapper</code>\n  centered along the top edge of <code>target</code>.  A <code>snapTo</code> of \"TL\" (top left)\n  means <code>snapEdge</code> will default to \"BR\" (bottom right), so the returned coordinates\n  would place the bottom right of <code>snapper</code> at the top left corner of\n  <code>target</code>.\n  <p>\n  <code>target</code> can be passed as either a Canvas or 4-element Array giving the top, left,\n  width and height of the target.  \n  <code>snapper</code> can be passed as either a Canvas or a\n  two-element Array of the width and height of the rectangle to be placed.\n\n",
        flags:"",
        returns:{
            type:"Point",
            description:"the position for <code>snapper</code> to be placed in order to \"snap to\" an edge or  corner of <code>target</code>"
        },
        name:"getSnapPosition"
    },
    "method:Chart.setData":{
        seeAlso:[
        ],
        ref:"method:Chart.setData",
        deprecated:null,
        type:"method",
        definingClass:"interface:Chart",
        params:[
            {
                defaultValue:null,
                optional:false,
                type:"Array of CellRecord | CellRecord",
                description:"new dataset",
                name:"newData"
            }
        ],
        description:" Change the dataset for this chart on the fly.  May or may not be supported by concrete chart\n implementations.\n\n",
        flags:"",
        name:"setData"
    },
    "attr:DynamicForm.clipStaticValue":{
        seeAlso:[
        ],
        ref:"attr:DynamicForm.clipStaticValue",
        defaultValue:"null",
        deprecated:null,
        type:"attr",
        definingClass:"class:DynamicForm",
        valueType:"Boolean",
        description:"Default ${isc.DocUtils.linkForRef('attr:FormItem.clipStaticValue')} setting for items in this form. When unset, this\n is equivalent to <code>false</code>.",
        flags:"IR",
        name:"clipStaticValue"
    },
    "attr:StretchImgButton.showRollOverIcon":{
        seeAlso:[
        ],
        defaultValue:"false",
        type:"attr",
        definingClass:"class:StretchImgButton",
        groups:[
            "buttonIcon"
        ],
        deprecated:null,
        ref:"attr:StretchImgButton.showRollOverIcon",
        valueType:"Boolean",
        description:"If using an icon for this button, whether to switch the icon image on mouse rollover.",
        flags:"IR",
        name:"showRollOverIcon"
    },
    "method:Class.getDynamicPropertyRuleTime":{
        seeAlso:[
        ],
        ref:"method:Class.getDynamicPropertyRuleTime",
        deprecated:null,
        type:"method",
        definingClass:"class:Class",
        params:[
            {
                defaultValue:null,
                optional:false,
                type:"Identifier",
                description:"name of a settable property on this instance",
                name:"propertyName"
            }
        ],
        description:" Returns the last time the rule for the specified dynamic property fired, as a\n ${isc.DocUtils.linkForRef('object:Date')}.\n\n",
        flags:"",
        returns:{
            type:"Date",
            description:"last fire time of rule"
        },
        name:"getDynamicPropertyRuleTime"
    },
    "group:stringProcessing":{
        refs:[
            "classMethod:NumberUtil.stringify",
            "classMethod:NumberUtil.isBetween",
            "classMethod:NumberUtil.toCurrencyString",
            "method:Number.stringify",
            "method:Number.toCurrencyString",
            "method:String.contains",
            "method:String.startsWith",
            "method:String.endsWith"
        ],
        seeAlso:[
        ],
        ref:"group:stringProcessing",
        deprecated:null,
        type:"group",
        description:null,
        name:"stringProcessing"
    },
    "method:RecordEditor.performAction":{
        seeAlso:[
        ],
        ref:"method:RecordEditor.performAction",
        deprecated:null,
        type:"method",
        definingClass:"class:RecordEditor",
        description:" Fired when the user clicks the ${isc.DocUtils.linkForRef('attr:RecordEditor.actionButton')} for this RecordEditor.\n May also be triggered from other user interaction with edit values (for\n example filter-editor change - see ${isc.DocUtils.linkForRef('attr:ListGrid.filterOnKeypress')}).\n <P>\n This is the method which initiates a filter in a listGrid\n ${isc.DocUtils.linkForRef('attr:ListGrid.showFilterEditor','filter editor')}. Note that for custom\n filtering behavior, developers can use the ${isc.DocUtils.linkForRef('method:ListGrid.filterEditorSubmit')}\n notification method rather than overriding this method directly.\n\n",
        flags:"",
        name:"performAction"
    },
    "attr:ListGrid.autoFitExtraRecords":{
        seeAlso:[
        ],
        defaultValue:"null",
        type:"attr",
        definingClass:"class:ListGrid",
        groups:[
            "autoFitData"
        ],
        ref:"attr:ListGrid.autoFitExtraRecords",
        deprecated:null,
        setter:[
            "setAutoFitExtraRecords"
        ],
        valueType:"Integer",
        description:"If ${isc.DocUtils.linkForRef('attr:ListGrid.autoFitData')} is set to <code>\"vertical\"</code> or <code>\"both\"</code>,\n setting this property will cause the ListGrid body to size large enough to accomodate\n the actual data and also leave this many extra rows' worth of blank space below the last\n record. If a maximum size is specified via ${isc.DocUtils.linkForRef('attr:ListGrid.autoFitMaxHeight')} or\n ${isc.DocUtils.linkForRef('attr:ListGrid.autoFitMaxRecords')}, it will still be respected. Once the data set\n is large enough to fill or exceed that space, this property no longer has an effect.",
        flags:"IRW",
        name:"autoFitExtraRecords"
    },
    "attr:MultiFileItem.dataSource":{
        seeAlso:[
        ],
        ref:"attr:MultiFileItem.dataSource",
        defaultValue:"null",
        deprecated:null,
        type:"attr",
        definingClass:"class:MultiFileItem",
        valueType:"DataSource | ID",
        description:"DataSource where files are stored.  \n <P>\n This DataSource is expected to have a field of type \"binary\" as well as a primaryKey and\n foreignKey declaration to some other DataSource; see the ${isc.DocUtils.linkForRef('class:MultiFileItem')} for an\n overview.\n <P>\n This DataSource need only be capable of \"fetch\", \"add\" and \"remove\" - \"update\" is unused.",
        flags:"IR",
        name:"dataSource"
    },
    "attr:Validator.caseSensitive":{
        seeAlso:[
        ],
        defaultValue:"false",
        type:"attr",
        definingClass:"class:Validator",
        deprecated:null,
        ref:"attr:Validator.caseSensitive",
        valueType:"boolean",
        description:"Applies only to the \"isUnique\" and \"hasRelatedRecord\" validators and controls\n whether the search for existing records is case sensitive or not.",
        flags:"IR",
        serverDS:"only",
        name:"caseSensitive"
    },
    "attr:Canvas.hoverWidth":{
        seeAlso:[
            {
                ref:"attr:Canvas.showHover",
                description:null
            }
        ],
        defaultValue:"1",
        type:"attr",
        definingClass:"class:Canvas",
        groups:[
            "hovers"
        ],
        ref:"attr:Canvas.hoverWidth",
        deprecated:null,
        valueType:"int",
        description:"If ${isc.DocUtils.linkForRef('attr:Canvas.showHover','this.showHover')} is true, this property can be used to customize\n the width of the hover canvas shown. See also ${isc.DocUtils.linkForRef('attr:Canvas.hoverAutoFitWidth')} and \n ${isc.DocUtils.linkForRef('attr:Canvas.hoverAutoFitMaxWidth')}.",
        flags:"IRW",
        examples:[
            "${isc.DocUtils.linkForExampleId('customHovers')}"
        ],
        name:"hoverWidth"
    },
    "attr:TabSet.moreTabPane":{
        seeAlso:[
        ],
        ref:"attr:TabSet.moreTabPane",
        defaultValue:"null",
        deprecated:null,
        type:"attr",
        definingClass:"class:TabSet",
        valueType:"AutoChild VLayout",
        description:"Pane contents for the \"more\" tab based on a VLayout. Typically contains\n a ${isc.DocUtils.linkForRef('class:NavigationBar')} and ${isc.DocUtils.linkForRef('class:TableView')}.",
        flags:"R",
        name:"moreTabPane"
    },
    "method:DataSource.transformRequest":{
        seeAlso:[
        ],
        ref:"method:DataSource.transformRequest",
        deprecated:null,
        type:"method",
        definingClass:"class:DataSource",
        params:[
            {
                defaultValue:null,
                optional:false,
                type:"DSRequest",
                description:"the DSRequest being processed",
                name:"dsRequest"
            }
        ],
        description:" For a dataSource using ${isc.DocUtils.linkForRef('group:clientDataIntegration','client-side data integration')},\n return the data that should be sent to the ${isc.DocUtils.linkForRef('attr:DataSource.dataURL')}.\n <P>\n By default, HTTP requests sent to non-SmartClient servers do not include DSRequest\n metadata such as ${isc.DocUtils.linkForRef('attr:DSRequest.startRow')}, ${isc.DocUtils.linkForRef('attr:DSRequest.endRow','endRow')},\n and ${isc.DocUtils.linkForRef('attr:DSRequest.oldValues','oldValues')}.  Only the core\n ${isc.DocUtils.linkForRef('group:dataSourceOperations','datasource protocol data')} is sent, such as the criteria\n passed to ${isc.DocUtils.linkForRef('method:ListGrid.fetchData','fetchData()')} or the updated values submitted by\n ${isc.DocUtils.linkForRef('method:DynamicForm.saveData','form.saveData()')}.  \n <P>\n transformRequest() allows you to transform dsRequest metadata into a\n format understood by your server and include it in the HTTP request, so that you can\n integrate DataSource features such as data paging with servers that support such\n features.\n <P>\n How the data is actually sent to the URL is controlled by \n ${isc.DocUtils.linkForRef('attr:OperationBinding.dataProtocol')}.  If using the \"getParams\" or\n \"postParams\" protocol, data is expected to be a JavaScript Object where each property\n will become a GET or POST'd parameter.  If using dataProtocol:\"soap\" or \"postXML\", data\n will be serialized as an XML message by ${isc.DocUtils.linkForRef('method:DataSource.xmlSerialize')}.\n <P>\n As an example, if you have a dataURL that can return paged data given URL parameters\n \"start\" and \"end\", you could implement transformRequest like so:\n \n <pre>\n   isc.DataSource.create({\n      ... \n      transformRequest : function (dsRequest) {\n         if (dsRequest.operationType == \"fetch\") {\n             var params = {\n                start : dsRequest.startRow,\n                end : dsRequest.endRow\n             };\n             // combine paging parameters with criteria\n             return isc.addProperties({}, dsRequest.data, params);\n         }\n      }\n   });\n </pre>\n \n \n Other reasons to implement transformRequest():\n <ul>\n <li> transform a ${isc.DocUtils.linkForRef('type:Criteria')} object into the custom query language of a web\n      service\n <li> add a session id to requests that require authentication\n <li> detect colliding updates by sending both updated values and the values the user\n      originally retrieved before editing began (available as ${isc.DocUtils.linkForRef('attr:DSRequest.oldValues')})\n </ul>\n <i>Special case:</i> If the <code>dataProtocol</code> is <code>\"clientCustom\"</code>\n the SmartClient system will not attempt to send data to the server in any way. Instead \n transformRequest should be implemented such that it accesses or updates the underlying\n data-set and calls ${isc.DocUtils.linkForRef('method:DataSource.processResponse')} when the operation is complete. This\n setting allows straightforward integration with non SmartClient comm mechanisms that \n directly send requests to the server (such as GWT-RPC), or handle data manipulation without\n sending HTTP at all (such as Google Gears).<br>\n A <code>transformRequest</code> override may also be used to set the ${isc.DocUtils.linkForRef('attr:DSRequest.dataProtocol')}\n to clientCustom at runtime, giving developers a way to intercept normal handling for\n some particular request, and provide entirely custom handling written on the client.\n <P>\n Note: The ${isc.DocUtils.linkForRef('class:RestDataSource')} class overrides transformRequest() to handle xml-serializing\n the request (including meta data) into a standard format.\n\n",
        flags:"A",
        returns:{
            type:"Any",
            description:"data to be sent to the dataURL"
        },
        name:"transformRequest"
    },
    "attr:ListGrid.showGroupSummaryInHeader":{
        seeAlso:[
            {
                ref:"method:ListGrid.groupBy",
                description:null
            }
        ],
        defaultValue:"false",
        type:"attr",
        definingClass:"class:ListGrid",
        groups:[
            "grouping"
        ],
        ref:"attr:ListGrid.showGroupSummaryInHeader",
        deprecated:null,
        valueType:"Boolean",
        setter:[
            "setShowGroupSummaryInHeader"
        ],
        description:"If this grid is ${isc.DocUtils.linkForRef('method:ListGrid.groupBy','grouped')}, and ${isc.DocUtils.linkForRef('attr:ListGrid.showGroupSummary')}\n is true, setting this property causes field summary values for each group to be displayed\n directly in the group header node, rather than showing up at the bottom of each\n expanded group.\n <P>\n Note that this means the group header node will be showing multiple field values\n rather than the default display of a single cell spanning all columns containing the\n group title. Developers may specify an explicit ${isc.DocUtils.linkForRef('attr:ListGrid.groupTitleField')}, or\n rely on the automatically generated ${isc.DocUtils.linkForRef('attr:ListGrid.showGroupTitleColumn','groupTitleColumn')}\n to have group titles be visible as well as the summary values.\n <P>\n Also note that multi-line group summaries are not supported when showing\n the group summary in the group header. If multiple\n ${isc.DocUtils.linkForRef('attr:ListGridField.summaryFunction','field summary functions')} are defined for some field\n only the first will be displayed when this property is set to true.",
        flags:"IRW",
        name:"showGroupSummaryInHeader"
    },
    "classAttr:Canvas.REPEAT":{
        seeAlso:[
        ],
        defaultValue:"\"repeat\"",
        type:"classAttr",
        definingClass:"class:Canvas",
        deprecated:null,
        ref:"classAttr:Canvas.REPEAT",
        valueType:"Constant",
        description:"A declared value of the enum type  \n ${isc.DocUtils.linkForRef('type:BackgroundRepeat','BackgroundRepeat')}.",
        flags:"R",
        name:"REPEAT",
        constant:true
    },
    "attr:RelativeDateItem.use24HourTime":{
        seeAlso:[
        ],
        ref:"attr:RelativeDateItem.use24HourTime",
        defaultValue:"true",
        deprecated:null,
        type:"attr",
        definingClass:"class:RelativeDateItem",
        valueType:"Boolean",
        description:"When showing the ${isc.DocUtils.linkForRef('class:DateChooser')}, should the \n ${isc.DocUtils.linkForRef('attr:DateChooser.showTimeItem','time field')} be set to use 24-hour time?\n Has no effect for fields of type <code>\"date\"</code> rather than \n <code>\"datetime\"</code>, or if ${isc.DocUtils.linkForRef('attr:RelativeDateItem.showPickerTimeItem')} is <code>false</code>.\n <P>\n Default is true.",
        flags:"IRW",
        name:"use24HourTime"
    },
    "attr:FormItemIcon.tabIndex":{
        seeAlso:[
        ],
        defaultValue:"null",
        type:"attr",
        definingClass:"object:FormItemIcon",
        groups:[
            "formIcons"
        ],
        deprecated:null,
        ref:"attr:FormItemIcon.tabIndex",
        valueType:"int",
        description:"TabIndex for this formItemIcon.\n <P>\n Set to -1 to remove the icon from the tab order, but be cautious doing so: if the\n icon triggers important application functionality that cannot otherwise be accessed\n via the keyboard, it would be a violation of accessibility standard to remove the\n icon from the tab order.\n <P>\n Any usage other than setting to -1 is extremely advanced in the same way as using\n ${isc.DocUtils.linkForRef('attr:FormItem.globalTabIndex')}.",
        flags:"IRA",
        name:"tabIndex"
    },
    "class:DrawShape":{
        seeAlso:[
        ],
        type:"class",
        staticMethods:[
        ],
        inheritsFrom:"DrawItem",
        classMethods:[
        ],
        classAttrs:[
        ],
        attrs:[
            "attr:DrawShape.titleRotationMode",
            "attr:DrawShape.commands"
        ],
        ref:"class:DrawShape",
        deprecated:null,
        treeLocation:[
            "Client Reference/Drawing/DrawItem"
        ],
        description:"DrawItem to render a shape defined by executing the series of drawing commands in the\n ${isc.DocUtils.linkForRef('attr:DrawShape.commands','commands')} array.",
        methods:[
            "method:DrawShape.setCommands",
            "method:DrawShape.moveBy",
            "method:DrawShape.resizeBy"
        ],
        name:"DrawShape"
    },
    "attr:TreeMenuButton.title":{
        seeAlso:[
        ],
        ref:"attr:TreeMenuButton.title",
        defaultValue:"null",
        deprecated:null,
        type:"attr",
        definingClass:"class:TreeMenuButton",
        valueType:"String",
        description:"Title for this button. If not specified, the selected value from the tree will\n be displayed instead.",
        flags:"IRW",
        name:"title"
    },
    "method:Class.getClassName":{
        seeAlso:[
        ],
        ref:"method:Class.getClassName",
        deprecated:null,
        type:"method",
        definingClass:"class:Class",
        description:"\t\n\tGets the name of this class as a string.\n\n",
        flags:"",
        returns:{
            type:"String",
            description:"String name of this instance's Class object."
        },
        name:"getClassName"
    },
    "attr:OperationBinding.requiredCriterion":{
        seeAlso:[
        ],
        defaultValue:"null",
        type:"attr",
        definingClass:"class:OperationBinding",
        groups:[
            "clientDataIntegration"
        ],
        ref:"attr:OperationBinding.requiredCriterion",
        deprecated:null,
        valueType:"String",
        description:"A comma-separated list of field names that must be present in criteria / advancedCriteria provided by the caller.\n Failure to provide any one of these will yield a ${isc.DocUtils.linkForRef('classAttr:RPCResponse.STATUS_CRITERIA_REQUIRED_ERROR')} from the server.",
        flags:"IR",
        serverDS:"allowed",
        examples:[
            "${isc.DocUtils.linkForExampleId('requiredCriterion')}"
        ],
        name:"requiredCriterion"
    },
    "staticMethod:Date.createLogicalTime":{
        seeAlso:[
        ],
        ref:"staticMethod:Date.createLogicalTime",
        deprecated:"Use ${isc.DocUtils.linkForRef('classMethod:DateUtil.createLogicalTime')}.",
        type:"staticMethod",
        definingClass:"object:Date",
        params:[
            {
                defaultValue:null,
                optional:false,
                type:"int",
                description:"hour (0-23)",
                name:"hour"
            },
            {
                defaultValue:null,
                optional:false,
                type:"int",
                description:"minute (0-59)",
                name:"minute"
            },
            {
                defaultValue:null,
                optional:false,
                type:"int",
                description:"second (0-59)",
                name:"second"
            }
        ],
        description:" Create a new Date object to represent a logical time value (rather than a specific datetime\n value), typically for display in a ${isc.DocUtils.linkForRef('attr:DataSourceField.type','time type field')}. The generated\n Date value will have year, month and date set to the epoch date (Jan 1 1970), and time\n elements set to the supplied hour, minute and second (in browser native local time).\n",
        flags:"",
        returns:{
            type:"Date",
            description:"new Javascript Date object representing the time in question"
        },
        name:"createLogicalTime"
    },
    "attr:FacetChart.padChartRectByCornerRadius":{
        seeAlso:[
        ],
        ref:"attr:FacetChart.padChartRectByCornerRadius",
        defaultValue:"true",
        deprecated:null,
        type:"attr",
        definingClass:"class:FacetChart",
        valueType:"boolean",
        description:"If ${isc.DocUtils.linkForRef('attr:FacetChart.showChartRect')} is enabled and if ${isc.DocUtils.linkForRef('attr:FacetChart.chartRectProperties')} specifies a\n nonzero ${isc.DocUtils.linkForRef('attr:DrawRect.rounding','rounding')}, whether the padding around the inside of the\n chart rect. should include at least the radius of the rounded corner.",
        flags:"IR",
        name:"padChartRectByCornerRadius"
    },
    "attr:SelectItem.pickerExitButton":{
        seeAlso:[
        ],
        defaultValue:"null",
        type:"attr",
        definingClass:"class:SelectItem",
        groups:[
            "panelPlacement"
        ],
        deprecated:null,
        ref:"attr:SelectItem.pickerExitButton",
        valueType:"AutoChild NavigationButton",
        description:"${isc.DocUtils.linkForRef('class:NavigationButton')} to dismiss the picker interface, created when \n ${isc.DocUtils.linkForRef('attr:SelectItem.pickListPlacement')} indicates that the search interface takes over the\n entire panel or screen.\n <p>\n The following ${isc.DocUtils.linkForRef('group:autoChildUsage','passthroughs')} apply:\n <ul>\n <li>${isc.DocUtils.linkForRef('attr:SelectItem.pickerExitButtonTitle','pickerExitButtonTitle')} for ${isc.DocUtils.linkForRef('attr:Button.title')}</li>\n </ul>",
        flags:"IR",
        name:"pickerExitButton"
    },
    "attr:DataSource.sqlUsePagingHint":{
        seeAlso:[
            {
                ref:"attr:OperationBinding.sqlUsePagingHint",
                description:null
            }
        ],
        defaultValue:"null",
        requiresModules:[
            "SCServer"
        ],
        type:"attr",
        definingClass:"class:DataSource",
        groups:[
            "sqlPaging"
        ],
        ref:"attr:DataSource.sqlUsePagingHint",
        deprecated:null,
        valueType:"boolean",
        description:"If explicitly set true or left null, causes the server to use a \"hint\" in the SQL we \n generate for paged queries.  If explicitly set false, forces off the use of hints.  This\n property can be overridden per operationBinding - see \n ${isc.DocUtils.linkForRef('attr:OperationBinding.sqlUsePagingHint')}.\n <p>\n Note this property is only applicable to ${isc.DocUtils.linkForRef('attr:DataSource.serverType','SQL')} DataSources, \n only when a ${isc.DocUtils.linkForRef('attr:DataSource.sqlPaging','paging strategy')} of \"sqlLimit\" is in force,\n and it only has an effect for those specific database products where we employ a native\n hint in the generated SQL in an attempt to improve performance.",
        flags:"IR",
        serverDS:"only",
        name:"sqlUsePagingHint"
    },
    "attr:ViewLoader.httpMethod":{
        seeAlso:[
        ],
        defaultValue:"\"GET\"",
        type:"attr",
        definingClass:"class:ViewLoader",
        groups:[
            "contentLoading"
        ],
        deprecated:null,
        ref:"attr:ViewLoader.httpMethod",
        valueType:"String",
        description:"Selects the HTTP method that will be used when fetching content.  Valid values are \"POST\"\n and \"GET\".",
        flags:"IRW",
        name:"httpMethod"
    },
    "type:NavigationMode":{
        seeAlso:[
        ],
        ref:"type:NavigationMode",
        deprecated:null,
        type:"type",
        values:[
            {
                value:"TableView.WHOLE_RECORD",
                description:"Clicking anywhere on the record navigates"
            },
            {
                value:"TableView.NAVICON_ONLY",
                description:"Only clicking directly on the navigation icon                                    triggers navigation"
            }
        ],
        description:"Controls the navigation mode of records.",
        name:"NavigationMode"
    },
    "attr:HeaderSpan.title":{
        seeAlso:[
        ],
        defaultValue:"null",
        type:"attr",
        definingClass:"object:HeaderSpan",
        groups:[
            "headerSpan"
        ],
        deprecated:null,
        ref:"attr:HeaderSpan.title",
        valueType:"String",
        description:"A title for this headerSpan, to display in the headerSpan button for this headerSpan\n and in other contexts such as the ${isc.DocUtils.linkForRef('attr:ListGrid.canPickFields','menu for picking visible fields')}.\n\n Note: if you want to use HTML tags to affect the display of the header, you should do so\n via ${isc.DocUtils.linkForRef('attr:HeaderSpan.headerTitle')} instead so that other places where the title\n appears in the UI are not affected.  Refer to discussion at ${isc.DocUtils.linkForRef('attr:ListGridField.title')}.",
        flags:"IR",
        name:"title"
    },
    "method:DataBoundComponent.transferRecords":{
        groups:[
            "dragdrop"
        ],
        seeAlso:[
        ],
        ref:"method:DataBoundComponent.transferRecords",
        deprecated:null,
        type:"method",
        definingClass:"interface:DataBoundComponent",
        params:[
            {
                defaultValue:null,
                optional:false,
                type:"Array of Record",
                description:"Records to transfer to this component",
                name:"dropRecords"
            },
            {
                defaultValue:null,
                optional:false,
                type:"Record",
                description:"The target record (eg, of a drop interaction), for context",
                name:"targetRecord"
            },
            {
                defaultValue:null,
                optional:false,
                type:"Integer",
                description:"Insert point in this component's data for the transferred records",
                name:"index"
            },
            {
                defaultValue:null,
                optional:false,
                type:"Canvas",
                description:"The databound or non-databound component from which the records                            are to be transferred.",
                name:"sourceWidget"
            },
            {
                defaultValue:null,
                optional:true,
                type:"Callback",
                description:"optional callback to be fired when the transfer process has completed",
                name:"callback"
            }
        ],
        description:"\n Transfer a list of ${isc.DocUtils.linkForRef('object:Record')}s from another component (does not have to be a databound\n component) into this component.  This method is only applicable to list-type components,\n such as ${isc.DocUtils.linkForRef('class:ListGrid','listGrid')}, ${isc.DocUtils.linkForRef('class:TreeGrid','treeGrid')} or ${isc.DocUtils.linkForRef('class:TileGrid','tileGrid')}\n <P>\n This method implements the automatic drag-copy and drag-move behaviors of components like\n ${isc.DocUtils.linkForRef('class:ListGrid')}, and calling it is equivalent to completing a drag and drop of the\n <code>dropRecords</code>.\n <P>\n Note that this method is asynchronous - it may need to perform server turnarounds to prevent\n duplicates in the target component's data.  If you wish to be notified when the transfer \n process has completed, you can either pass the optional callback to this method or implement\n the ${isc.DocUtils.linkForRef('method:DataBoundComponent.dropComplete')} method on this component.\n <P>\n See also ${isc.DocUtils.linkForRef('method:DataBoundComponent.transferSelectedData')}.\n\n",
        flags:"",
        name:"transferRecords"
    },
    "attr:TreeGrid.customIconProperty":{
        seeAlso:[
        ],
        defaultValue:"\"icon\"",
        type:"attr",
        definingClass:"class:TreeGrid",
        groups:[
            "treeIcons"
        ],
        deprecated:null,
        ref:"attr:TreeGrid.customIconProperty",
        valueType:"String",
        description:"This property allows the developer to rename the \n ${isc.DocUtils.linkForRef('attr:TreeNode.icon','default node.icon')} property.",
        flags:"IRW",
        name:"customIconProperty"
    },
    "method:Canvas.visibilityChanged":{
        seeAlso:[
        ],
        ref:"method:Canvas.visibilityChanged",
        deprecated:null,
        type:"method",
        definingClass:"class:Canvas",
        params:[
            {
                defaultValue:null,
                optional:false,
                type:"boolean",
                description:"whether the canvas is visible to the user",
                name:"isVisible"
            }
        ],
        description:" Notification  fired when this canvas becomes visible or hidden to the user.\n Note - this method is fired when the ${isc.DocUtils.linkForRef('method:Canvas.isVisible')} state of this\n component changes. It may be fired in response an explicit call to ${isc.DocUtils.linkForRef('method:Canvas.show')}\n or ${isc.DocUtils.linkForRef('method:Canvas.hide')}, or in response to a parent component\n being shown or hidden when this widgets ${isc.DocUtils.linkForRef('attr:Canvas.visibility')} is set to \"inherit\".\n <P>\n Note that a call to ${isc.DocUtils.linkForRef('method:Canvas.show')} or ${isc.DocUtils.linkForRef('method:Canvas.hide')} will not <b>always</b> fire this\n notification. If this widget has a hidden parent, show or hide would change this\n components ${isc.DocUtils.linkForRef('attr:Canvas.visibility')} property, and may update the CSS visibility attribute\n of the drawn handle in the DOM, but would not actually hide or reveal the component to\n the user and as such the notification would not fire.\n <P>\n Note also that this notification will only be fired for components which have been\n ${isc.DocUtils.linkForRef('method:Canvas.draw','drawn')}.\n",
        flags:"",
        name:"visibilityChanged"
    },
    "type:Selected":{
        groups:[
            "state"
        ],
        seeAlso:[
        ],
        ref:"type:Selected",
        deprecated:null,
        type:"type",
        values:[
            {
                value:"StatefulCanvas.FOCUSED",
                description:"StatefulCanvas should show                                     focused state"
            },
            {
                value:"StatefulCanvas.SELECTED",
                description:"StatefulCanvas is selected"
            },
            {
                value:"StatefulCanvas.UNSELECTED",
                description:"StatefulCanvas is not selected"
            }
        ],
        description:null,
        name:"Selected"
    },
    "group:CompoundFormItem_skinning":{
        refs:[
        ],
        seeAlso:[
        ],
        ref:"group:CompoundFormItem_skinning",
        deprecated:null,
        type:"group",
        description:"When skinning basic FormItems like SelectItem and TextItem, consider that compound form\n items like DateItem and ComboBox reuse simpler items like SelectItem and TextItem, so adding\n a border to SelectItem would also apply a border to each select item within DateItem.<br>\n To avoid such side-effects, if you want to add styling to all SelectItems used in your \n application, you can create an application-specific subclass like MySelectItem and apply \n properties there.<br>",
        name:"CompoundFormItem_skinning"
    },
    "attr:ListGridField.imageURLSuffix":{
        seeAlso:[
        ],
        defaultValue:"null",
        type:"attr",
        definingClass:"object:ListGridField",
        groups:[
            "imageColumns"
        ],
        ref:"attr:ListGridField.imageURLSuffix",
        deprecated:null,
        valueType:"String",
        description:"If any cells in this field are showing a value icon (see: ${isc.DocUtils.linkForRef('attr:ListGridField.valueIcons')})\n or this is has ${isc.DocUtils.linkForRef('type:ListGridFieldType')} set to <code>\"image\"</code>, the value\n of this property will be appended to the end of the URL for the icon displayed.<br>\n Typical usage might be to append a file type such as <code>\".gif\"</code> to the\n filename of the image.<br>\n For editable fields, this property will also be passed through to any editors as\n ${isc.DocUtils.linkForRef('attr:FormItem.imageURLSuffix')}.",
        flags:"IRWA",
        examples:[
            "${isc.DocUtils.linkForExampleId('imageType')}"
        ],
        name:"imageURLSuffix"
    },
    "method:Sound.setCurrentTime":{
        seeAlso:[
        ],
        ref:"method:Sound.setCurrentTime",
        deprecated:null,
        type:"method",
        definingClass:"class:Sound",
        params:[
            {
                defaultValue:null,
                optional:false,
                type:"Float",
                description:"time to move to. This method will have no effect if the  file has not been loaded or no ${isc.DocUtils.linkForRef('attr:Sound.src')} element is defined.",
                name:"time"
            }
        ],
        description:" Move playback to a particular time in a loaded audio file.\n",
        flags:"",
        name:"setCurrentTime"
    },
    "attr:Window.hiliteHeaderStyle":{
        seeAlso:[
        ],
        defaultValue:"\"WindowHeader\"",
        type:"attr",
        definingClass:"class:Window",
        groups:[
            "appearance",
            "header"
        ],
        deprecated:null,
        ref:"attr:Window.hiliteHeaderStyle",
        valueType:"CSSStyleName",
        description:"Highlight style for the Window header. Displayed when a window \n is ${isc.DocUtils.linkForRef('method:Window.flash','flashed')}",
        flags:"IRWA",
        name:"hiliteHeaderStyle"
    },
    "method:Tree.isOpen":{
        seeAlso:[
        ],
        ref:"method:Tree.isOpen",
        deprecated:null,
        type:"method",
        definingClass:"class:Tree",
        params:[
            {
                defaultValue:null,
                optional:false,
                type:"TreeNode | String | Integer | NodeLocator",
                description:"the node in question, or the                                                               the node's ID, or a NodeLocator\n                                                              object",
                name:"node"
            }
        ],
        description:"\n Whether a particular node is open or closed (works for leaves and folders).  Note, for\n ${isc.DocUtils.linkForRef('method:Tree.isMultiLinkTree','multi-link tree')}s, passing a <code>NodeLocator</code> is the only\n unambiguous way to specify the node.\n\n",
        flags:"",
        returns:{
            type:"Boolean",
            description:"true if the node is open"
        },
        name:"isOpen"
    },
    "attr:FormulaBuilder.autoHideCheckBoxLabel":{
        seeAlso:[
        ],
        defaultValue:"\"Auto hide fields used in formula\"",
        type:"attr",
        definingClass:"class:FormulaBuilder",
        groups:[
            "i18nMessages"
        ],
        deprecated:null,
        ref:"attr:FormulaBuilder.autoHideCheckBoxLabel",
        valueType:"String",
        description:"Text label for the checkbox that allows the user to automatically hide the\n fields used in the formula.",
        flags:"IRW",
        name:"autoHideCheckBoxLabel"
    },
    "method:DateItem.setStartDate":{
        seeAlso:[
        ],
        ref:"method:DateItem.setStartDate",
        deprecated:null,
        type:"method",
        definingClass:"class:DateItem",
        params:[
            {
                defaultValue:null,
                optional:false,
                type:"Date | String",
                description:"the new startDate.",
                name:"startDate"
            }
        ],
        description:" Setter for ${isc.DocUtils.linkForRef('attr:DateItem.startDate')}. <P>\n <b>Note:</b> A ${isc.DocUtils.linkForRef('classMethod:DateUtil.createLogicalDate','LogicalDate')} is expected. \n",
        flags:"A",
        name:"setStartDate"
    },
    "attr:ListGridField.canAutoFitWidth":{
        seeAlso:[
            {
                ref:"attr:ListGrid.autoFitDateFields",
                description:null
            },
            {
                ref:"attr:ListGrid.autoFitTimeFields",
                description:null
            }
        ],
        ref:"attr:ListGridField.canAutoFitWidth",
        defaultValue:"null",
        deprecated:null,
        type:"attr",
        definingClass:"object:ListGridField",
        valueType:"Boolean",
        description:"Should the user be allowed to perform one-time autofitting of this field via\n a header context-menu option?\n <P>\n When enabled, the default header context menu for this field will\n include an item to auto-fit the field and users will be able to autofit the field\n via the ${isc.DocUtils.linkForRef('attr:ListGrid.headerAutoFitEvent')}.\n <P>\n If unset, these behaviors are enabled when ${isc.DocUtils.linkForRef('attr:ListGrid.canAutoFitFields')} is true.\n <P>\n If this property is set to false, and ${isc.DocUtils.linkForRef('attr:ListGrid.canAutoFitFields')} is true,\n this field will be ommitted from auto-fit when the user selects the header menu \n option to ${isc.DocUtils.linkForRef('attr:ListGrid.autoFitAllText','auto fit all fields')}.\n <P>\n Note - this property governs user-initiated auto-fit only. It has no impact on\n autoFit set up via ${isc.DocUtils.linkForRef('attr:ListGridField.autoFitWidth')} and ${isc.DocUtils.linkForRef('attr:ListGrid.autoFitFieldWidths')}.\n <P>\n Note that if ${isc.DocUtils.linkForRef('attr:ListGrid.showRecordComponents','showing record components')}, per-cell record\n components are not taken into account when determining the size for column auto fit.\n The default ${isc.DocUtils.linkForRef('method:ListGrid.getDefaultFieldWidth')} implementation looks at cell content\n only. We typically recommend that, for fields showing record-components, \n ${isc.DocUtils.linkForRef('attr:ListGridField.autoFitWidth')} and ${isc.DocUtils.linkForRef('attr:ListGrid.canAutoFitFields')} be disabled, or if \n the record components are of a predictable size, a ${isc.DocUtils.linkForRef('attr:ListGridField.defaultWidth')}\n be specified.<br>\n This is particularly pertinent where ${isc.DocUtils.linkForRef('attr:ListGrid.recordComponentPosition')}\n is set to \"within\", in which case cells' content is often empty or completely covered\n by record-components.",
        flags:"IR",
        name:"canAutoFitWidth"
    },
    "method:DrawOval.setHeight":{
        seeAlso:[
        ],
        ref:"method:DrawOval.setHeight",
        deprecated:null,
        type:"method",
        definingClass:"class:DrawOval",
        params:[
            {
                defaultValue:null,
                optional:false,
                type:"Distance",
                description:"new height",
                name:"height"
            }
        ],
        description:" Set the height of the drawOval\n",
        flags:"",
        name:"setHeight"
    },
    "attr:DataSource.requiresAuthentication":{
        seeAlso:[
        ],
        defaultValue:"null",
        requiresModules:[
            "SCServer"
        ],
        type:"attr",
        definingClass:"class:DataSource",
        groups:[
            "auth",
            "declarativeSecurity"
        ],
        ref:"attr:DataSource.requiresAuthentication",
        deprecated:null,
        valueType:"boolean",
        description:"Whether a user must be authenticated in order to access this DataSource.  This establishes a\n default for the DataSource as a whole; individual ${isc.DocUtils.linkForRef('attr:DataSource.operationBindings')} within the\n DataSource may still override this setting by explicitly setting\n ${isc.DocUtils.linkForRef('attr:OperationBinding.requiresAuthentication')}.\n <P>\n Whether the user is authenticated is determined by calling\n <code>httpServletRequest.getRemoteUser()</code>, hence works with both simple J2EE security\n (realms and form-based authentication) and JAAS (Java Authentication & Authorization\n Service).\n <P>\n If you wish to use an authentication scheme that does not make use of the servlet API's \n standards, SmartClient Server also implements the <code>setAuthenticated</code> method\n on <code>RPCManager</code>.  You can use this API to tell SmartClient that all the \n requests in the queue currently being processed are associated with an authenticated\n user; in this case, SmartClient will not attempt to authenticate the user via \n <code>httpServletRequest.getRemoteUser()</code>\n <P>\n You can set the default value for this property via setting \"authentication.defaultRequired\"\n in ${isc.DocUtils.linkForRef('group:server_properties','server.properties')}.  This allows you to, for example,\n cause all DataSources to require\n authentication for all operations by default.\n <P>\n Note that setting this property does not automatically cause an authentication mechanism to\n appear - you still need to separately configure an authentication system.  Likewise, setting\n requiresAuthentication=\"false\" does not automatically allow users to bypass your authentication\n mechanism - you need to set up a URL that will accept DSRequests and process them similar to\n the default \"IDACall\" servlet, and which is not protected by the authentication system.  See\n ${isc.DocUtils.linkForRef('group:servletDetails','Deploying SmartClient')} for details on the IDACall servlet.",
        flags:"IR",
        serverDS:"only",
        name:"requiresAuthentication"
    },
    "method:DrawItem.dragStop":{
        groups:[
            "widgetEvents"
        ],
        seeAlso:[
            {
                ref:"method:Canvas.getOffsetX",
                description:null
            },
            {
                ref:"method:Canvas.getOffsetY",
                description:null
            }
        ],
        ref:"method:DrawItem.dragStop",
        deprecated:null,
        type:"method",
        definingClass:"class:DrawItem",
        description:" Notification fired when the user stops dragging this DrawItem. Will only fire if ${isc.DocUtils.linkForRef('attr:DrawItem.canDrag','canDrag')}\n is true.\n <p>\n Note that if this item is part of a ${isc.DocUtils.linkForRef('class:DrawGroup')}, then the group's ${isc.DocUtils.linkForRef('attr:DrawGroup.useGroupRect','useGroupRect')}\n setting affects whether this item receives the notification. If useGroupRect is true, then\n this item will <em>not</em> receive the notification. Otherwise, the item receives the\n notification and notification bubbles up to the group.\n",
        flags:"",
        returns:{
            type:"boolean",
            description:"false to cancel drag interaction."
        },
        name:"dragStop"
    },
    "attr:EditContext.selectedTintOpacity":{
        seeAlso:[
            {
                ref:"attr:EditContext.selectedTintColor",
                description:null
            }
        ],
        ref:"attr:EditContext.selectedTintOpacity",
        defaultValue:"25",
        deprecated:null,
        type:"attr",
        definingClass:"class:EditContext",
        valueType:"Number",
        description:"Opacity applied to ${isc.DocUtils.linkForRef('attr:EditProxy.editMask','editMask')} of selected component when\n ${isc.DocUtils.linkForRef('attr:EditProxy.selectedAppearance')} is \"tintMask\".\n <P>\n This value is applied as a default to ${isc.DocUtils.linkForRef('attr:EditProxy.selectedTintOpacity')}.",
        flags:"IR",
        name:"selectedTintOpacity"
    },
    "group:serverDataIntegration":{
        refs:[
            "type:DSDataFormat",
            "type:DSServerType",
            "attr:DataSource.dataFormat",
            "attr:DataSource.dataProtocol",
            "attr:DataSource.requestProperties",
            "attr:DataSource.serverType",
            "attr:DataSource.tableName",
            "attr:DataSource.quoteTableName",
            "attr:DataSource.dbName",
            "attr:DataSource.configBean",
            "attr:DataSource.defaultTextMatchStyle",
            "attr:DataSource.defaultBooleanStorageStrategy",
            "attr:DataSource.useAnsiJoins",
            "attr:DataSource.audit",
            "attr:DataSource.serverObject",
            "attr:OperationBinding.requestProperties",
            "attr:RestDataSource.dataProtocol"
        ],
        seeAlso:[
        ],
        ref:"group:serverDataIntegration",
        treeLocation:[
            "Concepts/Client-Server Integration",
            "Java Server Reference"
        ],
        deprecated:null,
        type:"group",
        title:"Server DataSource Integration",
        description:"Server Data Integration means:\n <ul>\n <li> You ${isc.DocUtils.linkForRef('group:iscInstall','install')} the \n      ${isc.DocUtils.linkForRef('group:iscServer','SmartClient Java Server Framework')} into any J2SE/J2EE\n      environment, including any existing web application\n <li> You ${isc.DocUtils.linkForRef('group:dataSourceDeclaration','create DataSources')} via an XML declaration,\n possibly on-the-fly from ${isc.DocUtils.linkForRef('group:metadataImport','existing metadata')}.  \n <li> Server communication for components bound to these DataSources is handled\n automatically with a highly efficient, compressed protocol.  You work with clean Java APIs\n instead of dealing with the details of XML or JSON over HTTP.\n <li> You can use built-in connectors for SQL, Hibernate and other common data providers\n without writing any code, or you can easily build your own connectors in Java.\n <li> Whether using the built-in connectors or custom connectors, declarations in your\n DataSource control a large set of server features that can make common types of business\n logic entirely declarative\n </ul>\n This approach is in contrast to \n ${isc.DocUtils.linkForRef('group:clientDataIntegration','Client-side Data Integration')} in which client-side\n DataSources are configured to send and receive HTTP messages containing XML, JSON\n or other content.\n <P>\n <B>Server-side Request Processing</B>\n <P>\n Client-side ${isc.DocUtils.linkForRef('interface:DataBoundComponent','DataBoundComponents')} will send\n ${isc.DocUtils.linkForRef('object:DSRequest','DSRequests')} to the SmartClient Server as background communications transparent\n to the user.  Integrating SmartClient's DataSource layer with your data model is a matter of\n handling these DSRequests and sending back DSResponses, in order to fulfill the 4 basic\n operations of the ${isc.DocUtils.linkForRef('group:dataSourceOperations','DataSource Protocol')}.\n <P>\n Out of the box, SmartClient is set up to route all DSRequests through a special servlet\n called <code>IDACall</code>.\n <P>\n Note that the SmartClient SDK includes detailed Javadoc reference for this servlet and\n all shipped SmartClient Java server classes.\n <P>\n Requests that go through <code>IDACall</code> have the \n following lifecycle:\n <ul>\n <li>The overall HTTP request is received by the IDACall servlet.  SmartClient supports \n queuing of transactions, so each HTTP request might contain multiple DSRequests.</li>\n <li>IDACall sets up an instance of <code>RPCManager</code> to manage the processing of\n the entire queue of transactions.  For every DSRequest in the queue, this RPCManager:</li>\n   <ul>\n   <li>Validates the DSRequest</li>\n   <li>Checks the DataSource configuration for customizations implemented via \n       ${isc.DocUtils.linkForRef('group:serverScript','server scripting')} or ${isc.DocUtils.linkForRef('group:dmiOverview','DMI')} - in other words, your code -\n       and passes the request to this logic.\n       <p>\n       As described later in this section, your code can\n       perform some custom logic here: either completely fulfilling the request, or\n       alternatively modifying the request and causing the default\n       processing of the request to continue</li>\n   <li>Calls the DataSource's <code>execute</code> method to obtain a DSResponse.</li>\n   </ul>\n <li>Having processed all requests, the RPCManager now serializes all the DSResponses \n and sends them back to the browser as a single HTTP response</li>\n </ul>\n <p>\n This basic request handling flow can be customized at a number of points:\n <ul>\n <li>If you need an overarching authentication service, this is best implemented using \n <a href=http://java.sun.com/products/servlet/Filters.html>servlet Filters</a> to intercept\n unauthenticated requests before they reach the <code>IDACall</code> servlet</li>\n\n <li>The ${isc.DocUtils.linkForRef('attr:DataSource.serverType')} specification within your <code>.ds.xml</code> configuration\n     file is used to specify a standard server-side connector to service your requests.</li>\n\n <li>General custom business logic can be added in a number of ways, both declaratively and\n programmatically:</li>\n <ul>\n   <li>The &lt;criteria&gt; and &lt;values&gt; properties of an ${isc.DocUtils.linkForRef('class:OperationBinding')} \n       allow you to modify the dataSource request dynamically at transaction-processing time, using \n       built-in ${isc.DocUtils.linkForRef('group:velocitySupport','Velocity support')}.<br>\n       Note this feature also allows developers to use\n       ${isc.DocUtils.linkForRef('group:transactionChaining','Transaction Chaining')} to dynamically set data values \n       according to the results of earlier transactions.</li>\n   <li>For editing, standard ${isc.DocUtils.linkForRef('attr:DataSourceField.validators')} defined in the <code>.ds.xml</code> \n       file will be processed on both the client and the server. In addition to the built-in validator\n       types, entirely custom server validation logic may be implemented using\n       ${isc.DocUtils.linkForRef('type:ValidatorType','\"serverCustom\" type validators')}.</li>\n   <li>For SQL DataSources, use ${isc.DocUtils.linkForRef('group:customQuerying','SQL Templating')} to change, add \n       to or even completely replace the SQL sent to the database, including calling\n       stored procedures</li>\n   <li>The ${isc.DocUtils.linkForRef('attr:DataSource.serverConstructor')} allows you to specify an explicit custom DataSource\n       subclass to create as your DataSource instance. This must be a subclass of \n       <code>BasicDataSource</code>.<br>\n       When requests are recieved by the \n       <code>IDACall</code> servlet, they will be passed to standard methods on this DataSource, which\n       can be overridden for custom behavior.<br>\n       Validation is performed via a call to the <code>validate()</code> method.<br>\n       The request is processed by the <code>execute()</code>, method which can be overridden directly,\n       or developers may override the operation-specific \n       methods <code>executeFetch()</code>, <code>executeAdd()</code>, <code>executeUpdate</code>,\n       or <code>executeRemove()</code> called from the standard <code>execute()</code> implementation.<br>\n       This approach allows you to either extend one of the built-in persistence mechanisms\n       by subclassing a shipped class such as <code>SQLDataSource</code>, or\n       create an entirely custom implementation from scratch.<br>\n       A custom dataSource will still take full advantage of \n       DataSource-agnostic features of the SmartClient Server, like validation, queuing,\n       transaction chaining, support for Velocity templating, and so on.<br>\n       For more information see the ${isc.DocUtils.linkForRef('group:writeCustomDataSource','custom server dataSource overview')}</li>\n   <li>Use ${isc.DocUtils.linkForRef('group:dmiOverview','Direct Method Invocation')} to call directly into your own Java \n       classes. An operation configured to use DMI will invoke the specified method instead of\n       running through the standard DataSource <code>execute()</code> method directly - the DMI\n       implementation can then use <code>dsRequest.execute()</code> to call the default behavior.\n       This means DMIs allow you to modify the <code>DSRequest</code> before it executes,\n       modify the <code>DSResponse</code> before it returns, or replace the default behavior with\n       unrelated actions. Note that DMI can be applied \n       ${isc.DocUtils.linkForRef('attr:DataSource.serverObject','to all operations')}, or to \n       ${isc.DocUtils.linkForRef('attr:OperationBinding.serverObject','individual operation bindings')}, and can be used\n       in conjunction with a ${isc.DocUtils.linkForRef('attr:DataSource.serverObject','custom dataSource')}.</li> \n   <li>Use ${isc.DocUtils.linkForRef('group:serverScript','server scripting')} to add small amounts of business logic \n       right in your <code>.ds.xml</code> file (either \n       ${isc.DocUtils.linkForRef('attr:OperationBinding.script','per operation')}, or as standard handling for\n       ${isc.DocUtils.linkForRef('attr:DataSource.script','all operations')}).  DMI scripts allow you to add business\n       logic just like normal DMIs, but don't require the logic to be in a separate .java\n       file.</li>\n </ul><br>\n\n <li>If you need to use a Front Controller servlet for some other reason than authentication -\n for example, you are using Spring, Struts, or some other similar system which requires that \n all requests go through some particular servlet - just call \n <code>RPCManager.processRequest()</code> within your Spring Controller, Struts Action, or \n whatever the equivalent is in the framework in use.\n <p>\n However, note carefully that taking this approach is often a sign that the SmartClient \n architecture has not been correctly understood.  SmartClient is architected for \n <em>client-server</em> data communication, as opposed to early web MVC frameworks which \n do everything on the server.  In particular, it is absolutely incorrect to represent every \n individual DataSource operation - or even every DataSource - as a separate Struts Action \n or Spring Controller, because this implies different URLs for different operations.  All \n DataSource operations should go through a single URL in order to allow \n ${isc.DocUtils.linkForRef('class:RPCManager','transaction queuing')} - see these \n ${isc.DocUtils.linkForExampleId('transactionsFolder', 'Queuing examples')}.</li>\n </ul>\n <P>\n For more information on the DMI subsystem, see the ${isc.DocUtils.linkForRef('group:dmiOverview','DMI overview')},\n ${isc.DocUtils.linkForRef('class:DMI','DMI class')} and the \n ${isc.DocUtils.linkForExampleId('DMI', 'DMI example')} in the Feature Explorer.\n <P>\n Note that, as you continue to integrate your prototype with your backend, you can use a\n mixture of DataSources that have been fully integrated with your backend and DataSources\n that are running in \"client-only\" mode (see ${isc.DocUtils.linkForRef('group:clientOnlyDataSources')}).\n <P>\n <b>Important methods for handling DataSource requests</b>\n <P>\n The basic flow of logic for handling DataSource requests is:\n <P>\n <table class=\"normal\" border=1 width=\"700\">\n <tr>\n <td>1. Determine operation type (Fetch, Add, Update, Remove) for a single request.  Not \n necessary if you follow the recommendations for \n ${isc.DocUtils.linkForRef('group:writeCustomDataSource','writing a custom DataSource')} and provide your \n implementation via <code>executeFetch(), executeAdd()</code>, et al.</td>\n <td>dsRequest.getOperationType()</td>\n </tr>\n\n <tr>\n <td>2. Get inbound values (Add, Update) and/or criteria (Fetch, Update, Remove) for this\n request.</td>\n <td>dsRequest.getFieldValue()<br>\n dsRequest.getValues()<br> \n dsRequest.getCriteria()</td>\n </tr>\n\n <tr>\n <td>3. Business logic, validation, calls to data and service tiers... anything you can code.\n </td>\n <td><b>execute custom logic</b></td>\n </tr>\n\n <tr>\n <td>4. Set status and data for the response.</td>\n <td>dsResponse.setStatus()<br>\n dsResponse.setData()</td>\n </tr>\n </table>\n <P>\n For more information, see the ${isc.DocUtils.linkForRef('class:RPCManager','RPCManager documentation')}, and the \n ${isc.DocUtils.linkForExampleId('ormDataSource', 'Custom ORM DataSource example')}.",
        name:"serverDataIntegration"
    },
    "method:DrawGroup.mouseOver":{
        groups:[
            "widgetEvents"
        ],
        seeAlso:[
            {
                ref:"method:Canvas.getOffsetX",
                description:null
            },
            {
                ref:"method:Canvas.getOffsetY",
                description:null
            }
        ],
        ref:"method:DrawGroup.mouseOver",
        deprecated:null,
        type:"method",
        definingClass:"class:DrawGroup",
        description:" Notification fired when the mouse enters this DrawGroup.\n <p>\n Note that if ${isc.DocUtils.linkForRef('attr:DrawGroup.useGroupRect','useGroupRect')} is true, this notification will be triggered\n by the user interacting with the specified ${isc.DocUtils.linkForRef('method:DrawGroup.getGroupRect','group rectangle')} for the group.\n If ${isc.DocUtils.linkForRef('attr:DrawGroup.useGroupRect','useGroupRect')} is false, the notification will bubble up from interactions\n with individual items within the group.\n",
        flags:"",
        returns:{
            type:"Boolean",
            description:"false to prevent this event from bubbling to this widget's parent, true or undefined to bubble."
        },
        name:"mouseOver"
    },
    "method:List.addList":{
        seeAlso:[
        ],
        type:"method",
        definingClass:"interface:List",
        returns:{
            type:"List",
            description:"list of items that were added"
        },
        groups:[
            "modification"
        ],
        deprecated:null,
        ref:"method:List.addList",
        params:[
            {
                defaultValue:null,
                optional:false,
                type:"Array",
                description:"list of items to add",
                name:"list"
            },
            {
                defaultValue:null,
                optional:true,
                type:"number",
                description:"optional start index in list",
                name:"listStartRow"
            },
            {
                defaultValue:null,
                optional:true,
                type:"number",
                description:"optional end index in list (non-inclusive)",
                name:"listEndRow"
            }
        ],
        description:" Add a list of items to this array.\n <P>\n Note: you can specify that a subset range be added by passing start and end indices\n\n",
        flags:"",
        name:"addList"
    },
    "classAttr:Browser.isSupported":{
        seeAlso:[
        ],
        ref:"classAttr:Browser.isSupported",
        defaultValue:"auto-detected based on browser",
        deprecated:null,
        type:"classAttr",
        definingClass:"class:Browser",
        valueType:"boolean",
        description:"Whether SmartClient supports the current browser.\n <P>\n Note that this flag will only be available on browsers that at least support basic\n JavaScript.",
        flags:"R",
        name:"isSupported"
    },
    "method:ListGrid.cellErrorIconOver":{
        seeAlso:[
            {
                ref:"attr:ListGrid.showErrorIcons",
                description:null
            }
        ],
        type:"method",
        definingClass:"class:ListGrid",
        returns:{
            type:"boolean",
            description:"false to suppress the default behavior (show a standard error message                   hover)"
        },
        groups:[
            "events"
        ],
        deprecated:null,
        ref:"method:ListGrid.cellErrorIconOver",
        params:[
            {
                defaultValue:null,
                optional:false,
                type:"ListGridRecord",
                description:"cell record as returned by getCellRecord()",
                name:"record"
            },
            {
                defaultValue:null,
                optional:false,
                type:"number",
                description:"row number for the cell",
                name:"rowNum"
            },
            {
                defaultValue:null,
                optional:false,
                type:"number",
                description:"column number of the cell",
                name:"colNum"
            }
        ],
        description:" Optional stringMethod to fire when the mouse moves over the error icon of a cell with \n validation errors.\n\n",
        flags:"A",
        name:"cellErrorIconOver"
    },
    "class:ZoneCanvas":{
        seeAlso:[
        ],
        type:"class",
        staticMethods:[
        ],
        inheritsFrom:"EventCanvas",
        classMethods:[
        ],
        classAttrs:[
        ],
        attrs:[
        ],
        ref:"class:ZoneCanvas",
        deprecated:null,
        treeLocation:[
            "Client Reference/Calendar"
        ],
        description:"A subclass of ${isc.DocUtils.linkForRef('class:EventCanvas','EventCanvas')}, used to render \n ${isc.DocUtils.linkForRef('attr:Calendar.zones','styled areas')} in ${isc.DocUtils.linkForRef('class:CalendarView','calendar views')}.\n <P>\n A ZoneCanvas is a semi-transparent canvas that highlights a portion of a \n calendar view, by rendering across all lanes and behind normal ${isc.DocUtils.linkForRef('attr:Calendar.data','events')}.\n <P>\n By default, the canvas shows a bottom-aligned label containing the \n ${isc.DocUtils.linkForRef('attr:CalendarEvent.name','zone name')}.\n Default styling is specified at the ${isc.DocUtils.linkForRef('attr:Calendar.zoneStyleName','calendar level')} \n and can be overridden for ${isc.DocUtils.linkForRef('attr:CalendarEvent.styleName','individual zones')}.",
        methods:[
        ],
        name:"ZoneCanvas"
    },
    "method:DynamicForm.hasFieldErrors":{
        seeAlso:[
        ],
        type:"method",
        definingClass:"class:DynamicForm",
        returns:{
            type:"Boolean",
            description:"true if the form has outstanding errors for the field in question."
        },
        groups:[
            "errors"
        ],
        deprecated:null,
        ref:"method:DynamicForm.hasFieldErrors",
        params:[
            {
                defaultValue:null,
                optional:false,
                type:"String",
                description:"field to test for validation errors",
                name:"fieldName"
            }
        ],
        description:" Returns whether there are currently any errors visible to the user for the specified field in\n this form, without performing any validation.\n <P>\n Note that validation errors are set up automatically by validation (see ${isc.DocUtils.linkForRef('method:DynamicForm.validate')}),\n or may be explicitly set via ${isc.DocUtils.linkForRef('method:DynamicForm.setErrors')} or\n ${isc.DocUtils.linkForRef('method:DynamicForm.setFieldErrors')}.\n",
        flags:"",
        name:"hasFieldErrors"
    },
    "attr:TileLayout.layoutMargin":{
        seeAlso:[
        ],
        defaultValue:"5",
        type:"attr",
        definingClass:"class:TileLayout",
        groups:[
            "layoutMargin"
        ],
        deprecated:null,
        ref:"attr:TileLayout.layoutMargin",
        valueType:"Integer",
        description:"A margin left around the outside of all tiles.",
        flags:"IR",
        name:"layoutMargin"
    },
    "attr:ListGridField.groupingMode":{
        seeAlso:[
        ],
        defaultValue:"null",
        type:"attr",
        definingClass:"object:ListGridField",
        groups:[
            "grouping"
        ],
        deprecated:null,
        ref:"attr:ListGridField.groupingMode",
        valueType:"Identifier",
        description:"For a field that allows multiple ${isc.DocUtils.linkForRef('attr:ListGridField.groupingModes','grouping modes')},\n the current grouping mode.\n <P>\n This property is set when a user chooses a particular grouping mode, and may be set on\n ListGrid creation to affect the initial grouping.",
        flags:"IR",
        name:"groupingMode"
    },
    "type:Identifier":{
        seeAlso:[
        ],
        ref:"type:Identifier",
        deprecated:null,
        type:"type",
        description:"A string which is a valid \n JavaScript identifier, as specified by ECMA-262 Section 7.6.\n <P>\n <B>NOTE:</B> The ${isc.DocUtils.linkForRef('staticMethod:String.isValidID')}\n \n function can be used to test whether a name is a valid JavaScript identifier.",
        name:"Identifier",
        baseType:"String"
    },
    "method:Toolbar.itemDragResized":{
        seeAlso:[
        ],
        ref:"method:Toolbar.itemDragResized",
        deprecated:null,
        type:"method",
        definingClass:"class:Toolbar",
        params:[
            {
                defaultValue:null,
                optional:false,
                type:"number",
                description:"the index of the item that was resized",
                name:"itemNum"
            },
            {
                defaultValue:null,
                optional:false,
                type:"number",
                description:"the new size of the item",
                name:"newSize"
            }
        ],
        description:" Observable, overrideable method - called\n when one of the Toolbar buttons is drag resized.\n\n",
        flags:"",
        name:"itemDragResized"
    },
    "attr:DateItem.inputFormat":{
        seeAlso:[
            {
                ref:"attr:DateItem.displayFormat",
                description:null
            }
        ],
        defaultValue:"null",
        type:"attr",
        definingClass:"class:DateItem",
        getter:[
            "getInputFormat"
        ],
        deprecated:null,
        ref:"attr:DateItem.inputFormat",
        valueType:"DateInputFormat",
        description:"If ${isc.DocUtils.linkForRef('attr:DateItem.useTextField')} is <code>true</code> this property can be used to specify\n the input format for date strings. \n If unset, the input format will be determined based on the specified\n ${isc.DocUtils.linkForRef('attr:DateItem.dateFormatter')} if possible (see ${isc.DocUtils.linkForRef('method:DateItem.getInputFormat')}), otherwise\n picked up from the Date class (see ${isc.DocUtils.linkForRef('classMethod:DateUtil.setInputFormat')}).\n <P>\n Should be set to a standard ${isc.DocUtils.linkForRef('type:DateInputFormat')}\n <P>\n Note that the ${isc.DocUtils.linkForRef('type:DateInputFormat')} property is sufficient to parse date or datetime\n strings specified in most standard date formats. However should an entirely custom\n parsing function be required developers can \n implement a custom ${isc.DocUtils.linkForRef('method:DateItem.parseEditorValue')} method.\n \n <p>\n This attribute does not have an effect if a native HTML5 date input is being used.\n See ${isc.DocUtils.linkForRef('attr:DateItem.browserInputType')}.",
        flags:"IRW",
        name:"inputFormat"
    },
    "method:ListGrid.getDefaultFormattedFieldValue":{
        seeAlso:[
            {
                ref:"method:ListGridField.formatCellValue",
                description:null
            }
        ],
        ref:"method:ListGrid.getDefaultFormattedFieldValue",
        deprecated:null,
        type:"method",
        definingClass:"class:ListGrid",
        params:[
            {
                defaultValue:null,
                optional:false,
                type:"Record",
                description:"the record object",
                name:"record"
            },
            {
                defaultValue:null,
                optional:false,
                type:"ListGridField",
                description:"the field object",
                name:"field"
            },
            {
                defaultValue:null,
                optional:true,
                type:"int",
                description:"rowNum (passed to any field level cell formatter)",
                name:"rowNum"
            },
            {
                defaultValue:null,
                optional:true,
                type:"int",
                description:"colNum (passed to any field level cell formatter)",
                name:"colNum"
            }
        ],
        description:" Get a field value for some record with default field formatters applied.\n <P>\n This method differs from ${isc.DocUtils.linkForRef('method:ListGrid.getDefaultFormattedValue')} in a couple of ways.\n Firstly, this method does not rely on the rowNum and colNum parameters to find the\n record and field in the grid.<br>\n Secondly, unlike ${isc.DocUtils.linkForRef('method:ListGrid.getDefaultFormattedValue')} this method <i>will</i> call\n any explicit cell formatter specified on the field passed in (though it will not\n call a ${isc.DocUtils.linkForRef('method:ListGrid.formatCellValue','component level formatter')} if one exists).\n <P>\n This is useful for cases where a developer wishes to\n display a formatted value for some record and field combination which does not\n necessarily map to a cell displayed in the ListGrid.\n <P>\n If <code>rowNum</code> and <code>colNum</code> parameters are passed through to\n the field level cell formatter if one exists. If not explicitly provided these are\n defaulted to -1.\n\n",
        flags:"A",
        returns:{
            type:"String",
            description:"Default formatted value"
        },
        name:"getDefaultFormattedFieldValue"
    },
    "method:Window.setHeaderStyle":{
        seeAlso:[
        ],
        ref:"method:Window.setHeaderStyle",
        deprecated:null,
        type:"method",
        definingClass:"class:Window",
        params:[
            {
                defaultValue:null,
                optional:false,
                type:"CSSStyleName",
                description:"new ${isc.DocUtils.linkForRef('attr:Canvas.styleName','styleName')} for the ${isc.DocUtils.linkForRef('attr:Window.header','header')}.",
                name:"newHeaderStyle"
            }
        ],
        description:" Setter for ${isc.DocUtils.linkForRef('attr:Window.headerStyle','headerStyle')}.\n",
        flags:"",
        name:"setHeaderStyle"
    },
    "class:Comm":{
        seeAlso:[
        ],
        type:"class",
        staticMethods:[
        ],
        inheritsFrom:"Class",
        classMethods:[
        ],
        classAttrs:[
            "classAttr:Comm.concurrentXHRsInIE",
            "classAttr:Comm.concurrentXHRErrorMessage"
        ],
        attrs:[
        ],
        ref:"class:Comm",
        deprecated:null,
        treeLocation:[
            "Client Reference/RPC"
        ],
        description:"Provides background communication with an HTTP server",
        methods:[
        ],
        name:"Comm"
    },
    "class:ResetPasswordTask":{
        seeAlso:[
        ],
        type:"class",
        staticMethods:[
        ],
        inheritsFrom:"ProcessElement",
        classMethods:[
        ],
        classAttrs:[
        ],
        attrs:[
        ],
        ref:"class:ResetPasswordTask",
        deprecated:null,
        treeLocation:[
            "Client Reference/Workflow"
        ],
        description:"Show user password reset dialog by opening the ${isc.DocUtils.linkForRef('classAttr:Authentication.resetPasswordURL')}\n in another tab or window.",
        methods:[
        ],
        name:"ResetPasswordTask"
    },
    "method:ValuesManager.itemChanged":{
        seeAlso:[
        ],
        ref:"method:ValuesManager.itemChanged",
        deprecated:null,
        type:"method",
        definingClass:"class:ValuesManager",
        params:[
            {
                defaultValue:null,
                optional:false,
                type:"FormItem",
                description:"the FormItem where the change event occurred",
                name:"item"
            },
            {
                defaultValue:null,
                optional:false,
                type:"Any",
                description:"new value for the FormItem",
                name:"newValue"
            }
        ],
        description:" Handler fired whenever a change to a FormItem fires itemChanged() on one of the \n member forms.  Fires after that event.\n\n",
        flags:"",
        name:"itemChanged"
    },
    "method:EditContext.serializeEditNodesAsJSON":{
        seeAlso:[
        ],
        ref:"method:EditContext.serializeEditNodesAsJSON",
        deprecated:null,
        type:"method",
        definingClass:"class:EditContext",
        params:[
            {
                defaultValue:null,
                optional:false,
                type:"Array of EditNode",
                description:"EditNodes to be serialized",
                name:"nodes"
            },
            {
                defaultValue:null,
                optional:true,
                type:"SerializationSettings",
                description:"Additional serialization settings",
                name:"settings"
            }
        ],
        description:" Serialize the provided ${isc.DocUtils.linkForRef('object:EditNode','EditNodes')} to a JSON\n representation of ${isc.DocUtils.linkForRef('object:PaletteNode','PaletteNodes')}. Note that the\n EditNodes must have been added to this EditContext. The result can be\n supplied to ${isc.DocUtils.linkForRef('method:EditContext.addPaletteNodesFromJSON','addPaletteNodesFromJSON()')} to\n recreate the EditNodes.\n\n",
        flags:"",
        returns:{
            type:"String",
            description:"a JSON representtion of the provided EditNodes"
        },
        name:"serializeEditNodesAsJSON"
    },
    "method:Layout.reflow":{
        seeAlso:[
        ],
        ref:"method:Layout.reflow",
        deprecated:null,
        type:"method",
        definingClass:"class:Layout",
        params:[
            {
                defaultValue:null,
                optional:true,
                type:"String",
                description:"reason reflow() had to be called (appear in logs if enabled)",
                name:"reason"
            }
        ],
        description:" Layout members according to current settings.\n <P>\n Members will reflow automatically when the layout is resized, members resize, the list of\n members changes or members change visibility.  It is only necessary to manually call\n <code>reflow()</code> after changing settings on the layout, for example,\n <code>layout.reverseOrder</code>.\n\n",
        flags:"A",
        name:"reflow"
    },
    "attr:ComboBoxItem.filterFields":{
        seeAlso:[
        ],
        defaultValue:"null",
        type:"attr",
        definingClass:"class:ComboBoxItem",
        groups:[
            "pickList"
        ],
        deprecated:null,
        ref:"attr:ComboBoxItem.filterFields",
        valueType:"Array of String",
        description:"As the user types into this item's textBox, a comboBoxItem will show the\n pick-list of options, and filter the set of results displayed by the current value in the\n text box. For a databound comboBoxItem, by default the entered value is filtered against\n the ${isc.DocUtils.linkForRef('attr:ComboBoxItem.displayField','displayField')} if one is specified, otherwise the\n ${isc.DocUtils.linkForRef('attr:ComboBoxItem.valueField','valueField')}.\n <P>\n This attribute allows the developer to explicitly change which fields to filter against,\n causing the user-entered text to be matched against any of the specified set of fields from \n the ${isc.DocUtils.linkForRef('attr:ComboBoxItem.optionDataSource')}.\n <P>\n This essentially causes ${isc.DocUtils.linkForRef('method:ComboBoxItem.getPickListFilterCriteria')} to return an ${isc.DocUtils.linkForRef('object:AdvancedCriteria')}\n object representing \"field1 starts with value or field2 starts with value or ...\".  The\n ${isc.DocUtils.linkForRef('type:OperatorId','operator')} used is controlled by ${isc.DocUtils.linkForRef('type:TextMatchStyle')} as usual, that is,\n \"startsWith\" implies the operator \"iStartsWith, \"substring\" implies \"iContains\" and \"exact\"\n implies \"iEquals\".\n <P>\n The most common use case for this setting would be when a comboBoxItem is showing multiple\n ${isc.DocUtils.linkForRef('attr:ComboBoxItem.pickListFields')} - if the same set of fields is specified as\n ${isc.DocUtils.linkForRef('attr:ComboBoxItem.filterFields')}, the user can use the text-box to filter against\n whichever fields are visible in the pickList.\n <P>\n For finer grained control over comboBoxItem filtering, the \n ${isc.DocUtils.linkForRef('method:ComboBoxItem.getPickListFilterCriteria')} method may be overridden.\n ",
        flags:"IR",
        name:"filterFields"
    },
    "attr:Canvas.children":{
        seeAlso:[
        ],
        defaultValue:"null",
        type:"attr",
        definingClass:"class:Canvas",
        groups:[
            "containment"
        ],
        deprecated:null,
        ref:"attr:Canvas.children",
        valueType:"Array of Canvas",
        description:"Array of all Canvii that are immediate children of this Canvas.\n <P>\n Use ${isc.DocUtils.linkForRef('method:Canvas.addChild')} and ${isc.DocUtils.linkForRef('method:Canvas.removeChild')} to add and remove children after a Canvas\n has been created/drawn.",
        flags:"IR",
        name:"children"
    },
    "attr:SpinnerItem.min":{
        seeAlso:[
        ],
        defaultValue:"null",
        type:"attr",
        definingClass:"class:SpinnerItem",
        deprecated:null,
        ref:"attr:SpinnerItem.min",
        valueType:"Double",
        description:"Minimum valid value for this item. If this and ${isc.DocUtils.linkForRef('attr:SpinnerItem.max','max')} are both\n null or unspecified, then\n \n ${isc.DocUtils.linkForRef('method:SpinnerItem.getNextValue')} and ${isc.DocUtils.linkForRef('method:SpinnerItem.getPreviousValue')}\n are used to increase or decrease the value and these methods\n \n are also used to determine the minimum value.",
        flags:"IRW",
        examples:[
            "${isc.DocUtils.linkForExampleId('spinnerItem')}"
        ],
        name:"min"
    },
    "attr:HTMLFlow.httpMethod":{
        seeAlso:[
        ],
        defaultValue:"\"GET\"",
        type:"attr",
        definingClass:"class:HTMLFlow",
        groups:[
            "contentLoading"
        ],
        deprecated:null,
        ref:"attr:HTMLFlow.httpMethod",
        valueType:"SendMethod",
        description:"Selects the HTTP method that will be used when fetching content.  Valid values are \"POST\"\n and \"GET\".",
        flags:"IRW",
        name:"httpMethod"
    },
    "method:PortalLayout.setCanResizeColumns":{
        groups:[
            "sizing"
        ],
        seeAlso:[
            {
                ref:"attr:PortalLayout.canResizeColumns",
                description:null
            }
        ],
        ref:"method:PortalLayout.setCanResizeColumns",
        deprecated:null,
        type:"method",
        definingClass:"class:PortalLayout",
        params:[
            {
                defaultValue:null,
                optional:false,
                type:"Boolean",
                description:"Whether columns are drag-resizable",
                name:"canResize"
            }
        ],
        description:" Set whether columns in this portalLayout are drag-resizable, and update any\n drawn columns to reflect this.\n",
        flags:"",
        name:"setCanResizeColumns"
    },
    "attr:Class.autoCreator":{
        seeAlso:[
            {
                ref:"group:autoChildren",
                description:null
            }
        ],
        defaultValue:"varies",
        type:"attr",
        definingClass:"class:Class",
        groups:[
            "autoChildren"
        ],
        deprecated:null,
        ref:"attr:Class.autoCreator",
        valueType:"Class | String",
        description:"Specifies the component on which ${isc.DocUtils.linkForRef('method:Class.createAutoChild')} should be called to\n create ${isc.DocUtils.linkForRef('group:autoChildren')} defined lazily on this component in the format\n \"autoChild:<i>autoChildName</i>\".  This property may be either specified as a live\n component, or set to the <code><i>childName</i></code> of another already-created\n AutoChild.\n <P>\n If left unspecified, the Framework applies rules to determine which component to use as\n the creator.  If this component is itself an autochild, and properties or defaults for\n the child are defined on its ${isc.DocUtils.linkForRef('attr:Class.creator')} but not on the component itself, then the\n creator of this component is also used to create the new AutoChild.  Otherwise, this\n component is used.",
        flags:"IRA",
        name:"autoCreator"
    },
    "group:treeFilter":{
        refs:[
            "type:TreeFilterMode",
            "method:Tree.getFilteredTree",
            "attr:Tree.dataSource"
        ],
        seeAlso:[
        ],
        ref:"group:treeFilter",
        deprecated:null,
        type:"group",
        description:null,
        name:"treeFilter"
    },
    "method:Layout.removeMember":{
        seeAlso:[
        ],
        ref:"method:Layout.removeMember",
        deprecated:null,
        type:"method",
        definingClass:"class:Layout",
        params:[
            {
                defaultValue:null,
                optional:false,
                type:"Canvas",
                description:"the canvas to be removed from the layout",
                name:"member"
            }
        ],
        description:" Removes the specified member from the layout.  If it has a resize bar, the bar will be\n destroyed.\n\n",
        flags:"",
        name:"removeMember"
    },
    "type:ObjectLiteral":{
        seeAlso:[
        ],
        ref:"type:ObjectLiteral",
        deprecated:null,
        type:"type",
        description:"An \"Object literal\" is JavaScript shorthand for defining a JavaScript Object with a set\n of properties.  For example, code like this:\n <pre>\n    var request = {\n        actionURL : \"/foo.do\",\n        showPrompt:false\n    };</pre>\n .. is equivalent to ..\n <pre>\n    var request = new Object();\n    request.actionURL = \"/foo.do\";\n    request.showPrompt = false;</pre>\n In situations where a set of ${isc.DocUtils.linkForRef('type:Properties','properties')} may be passed to a\n method, the Object literal notation is much more compact.  For example:\n <pre>\n    isc.RPCManager.sendRequest({\n        actionURL : \"/foo.do\",\n        showPrompt:false\n    });</pre>\n <b>NOTE:</b> if you have a 'trailing comma' in an object literal, like so:\n <pre>\n    var request = {\n        actionURL : \"/foo.do\",\n        showPrompt:false, // TRAILING COMMA\n    };</pre>\n This is considered a syntax error by Internet Explorer, but not by Firefox.  This is by\n far the #1 cause of Internet Explorer-specific errors that do not occur in other\n browsers.  Pay special attention to this error, and, if you can, install the\n JSSyntaxScannerFilter into your development environment (as described in the\n ${isc.DocUtils.linkForRef('group:iscInstall','deployment instructions')}).",
        name:"ObjectLiteral"
    },
    "attr:ListGridField.valueIconWidth":{
        seeAlso:[
        ],
        defaultValue:"null",
        type:"attr",
        definingClass:"object:ListGridField",
        groups:[
            "imageColumns"
        ],
        deprecated:null,
        ref:"attr:ListGridField.valueIconWidth",
        valueType:"number",
        description:"Width for value icons for this listGrid field.\n Overrides ${isc.DocUtils.linkForRef('attr:ListGrid.valueIconSize')}, ${isc.DocUtils.linkForRef('attr:ListGrid.valueIconWidth')}, and\n ${isc.DocUtils.linkForRef('attr:ListGridField.valueIconSize')}.",
        flags:"IRW",
        name:"valueIconWidth"
    },
    "method:ListGrid.getHeaderSpanContextMenuItems":{
        seeAlso:[
        ],
        type:"method",
        definingClass:"class:ListGrid",
        returns:{
            type:"Array of MenuItem",
            description:"return false instead to avoid showing any menu"
        },
        groups:[
            "headerSpan"
        ],
        deprecated:null,
        ref:"method:ListGrid.getHeaderSpanContextMenuItems",
        params:[
            {
                defaultValue:null,
                optional:false,
                type:"HeaderSpan",
                description:"the component representing the headerSpan.  This component will                            have all the properties specified via ${isc.DocUtils.linkForRef('attr:ListGrid.headerSpans')}.",
                name:"headerSpan"
            }
        ],
        description:" Return the menus items that should be shown in a menu triggered from a ${isc.DocUtils.linkForRef('attr:ListGrid.headerSpans','headerSpan')}.  The default \n implementation returns the parent element's context menu, unless ${isc.DocUtils.linkForRef('attr:ListGrid.showHeaderSpanContextMenu')} is <code>true</code>,\n in which case it returns standard items for showing / hiding fields and freezing / unfreezing header spans.  Note that no column \n picker will be shown unless ${isc.DocUtils.linkForRef('attr:ListGrid.showTreeColumnPicker')} is <code>true</code>.\n\n",
        flags:"",
        name:"getHeaderSpanContextMenuItems"
    },
    "attr:ActiveXControl.codeBase":{
        seeAlso:[
        ],
        ref:"attr:ActiveXControl.codeBase",
        defaultValue:"null",
        deprecated:null,
        type:"attr",
        definingClass:"class:ActiveXControl",
        valueType:"URL",
        description:"Specifies the URL from which to load the ActiveX control.",
        flags:"IR",
        name:"codeBase"
    },
    "attr:TimeItem.use24HourTime":{
        seeAlso:[
        ],
        ref:"attr:TimeItem.use24HourTime",
        defaultValue:"null",
        deprecated:null,
        type:"attr",
        definingClass:"class:TimeItem",
        valueType:"Boolean",
        description:"Whether to enforce 24-hour time in the UI.  If unset, assumes to the \n ${isc.DocUtils.linkForRef('classAttr:Time.use24HourTime','global default')}.",
        flags:"IRW",
        name:"use24HourTime"
    },
    "method:CellSelection.selectSingleCell":{
        seeAlso:[
        ],
        type:"method",
        definingClass:"class:CellSelection",
        returns:{
            type:"Boolean",
            description:"true == selection actually changed, false == no change"
        },
        groups:[
            "selection"
        ],
        deprecated:null,
        ref:"method:CellSelection.selectSingleCell",
        params:[
            {
                defaultValue:null,
                optional:false,
                type:"int",
                description:"row index of cell to select",
                name:"rowNum"
            },
            {
                defaultValue:null,
                optional:false,
                type:"int",
                description:"column index of cell to select",
                name:"colNum"
            }
        ],
        description:"   select a single cell and deselect everything else\n",
        flags:"",
        name:"selectSingleCell"
    },
    "attr:ListGrid.waitForSave":{
        seeAlso:[
        ],
        defaultValue:"false",
        type:"attr",
        definingClass:"class:ListGrid",
        groups:[
            "editing"
        ],
        deprecated:null,
        ref:"attr:ListGrid.waitForSave",
        valueType:"Boolean",
        description:"If this is an editable listGrid, this property determines whether the user will be\n able to dismiss the edit form, or navigate to another cell while the save is in\n process (before the asynchronous server response returns).",
        flags:"IRWA",
        name:"waitForSave"
    },
    "attr:DSRequest.endRow":{
        seeAlso:[
        ],
        defaultValue:"null",
        type:"attr",
        definingClass:"object:DSRequest",
        groups:[
            "paging"
        ],
        deprecated:null,
        ref:"attr:DSRequest.endRow",
        valueType:"number",
        description:"End row of requested results, used only with fetch operations.\n <p>\n Note that startRow and endRow are zero-based, inclusive at the beginning and exclusive at\n the end (like substring), so startRow: 0, endRow: 1 is a request for the first record.",
        flags:"IR",
        name:"endRow"
    },
    "method:Calendar.setShowDayLanes":{
        seeAlso:[
        ],
        ref:"method:Calendar.setShowDayLanes",
        deprecated:null,
        type:"method",
        definingClass:"class:Calendar",
        params:[
            {
                defaultValue:null,
                optional:false,
                type:"boolean",
                description:"whether or not to show lanes in the day view",
                name:"showDayLanes"
            }
        ],
        description:" Changes the ${isc.DocUtils.linkForRef('attr:Calendar.showDayLanes','view mode')} of the day view at runtime - whether to show a\n normal day column for the ${isc.DocUtils.linkForRef('attr:Calendar.chosenDate')}, or the specified set of \n ${isc.DocUtils.linkForRef('attr:Calendar.lanes','vertical lanes')}.\n \n",
        flags:"",
        name:"setShowDayLanes"
    },
    "method:FormItem.editorEnter":{
        groups:[
            "eventHandling"
        ],
        seeAlso:[
        ],
        ref:"method:FormItem.editorEnter",
        deprecated:null,
        type:"method",
        definingClass:"class:FormItem",
        params:[
            {
                defaultValue:null,
                optional:false,
                type:"DynamicForm",
                description:"form containing this item",
                name:"form"
            },
            {
                defaultValue:null,
                optional:false,
                type:"FormItem",
                description:"form item recieving focus",
                name:"item"
            },
            {
                defaultValue:null,
                optional:false,
                type:"Any",
                description:"current item value.",
                name:"value"
            }
        ],
        description:" Notification method fired when the user enters this formItem.\n Differs from ${isc.DocUtils.linkForRef('method:FormItem.focus')} in that while <code>focus</code> and <code>blur</code>\n may fire multiple as the user navigates sub elements of an item (such as interacting\n with a pick list), <code>editorEnter</code> will typically fire once when the user \n starts to edit this item as a whole, and once when the user moves onto a different\n item or component\n",
        flags:"",
        name:"editorEnter"
    },
    "attr:ColorPicker.htmlFieldTitle":{
        seeAlso:[
        ],
        defaultValue:"\"HTML\"",
        type:"attr",
        definingClass:"class:ColorPicker",
        groups:[
            "i18nMessages"
        ],
        deprecated:null,
        ref:"attr:ColorPicker.htmlFieldTitle",
        valueType:"HTMLString",
        description:"The title for the 'HTML' field in the complex chooser.",
        flags:"IR",
        name:"htmlFieldTitle"
    },
    "class:SpacerItem":{
        seeAlso:[
        ],
        type:"class",
        staticMethods:[
        ],
        inheritsFrom:"FormItem",
        classMethods:[
        ],
        classAttrs:[
        ],
        attrs:[
            "attr:SpacerItem.showTitle",
            "attr:SpacerItem.width",
            "attr:SpacerItem.height"
        ],
        ref:"class:SpacerItem",
        deprecated:null,
        description:"A SpacerItem takes up a single cell in the FormLayout, of arbitrary size.",
        methods:[
        ],
        name:"SpacerItem"
    },
    "class:SectionStackEditProxy":{
        seeAlso:[
        ],
        type:"class",
        staticMethods:[
        ],
        inheritsFrom:"LayoutEditProxy",
        classMethods:[
        ],
        classAttrs:[
        ],
        attrs:[
        ],
        groups:[
            "devTools"
        ],
        ref:"class:SectionStackEditProxy",
        deprecated:null,
        treeLocation:[
            "Client Reference/Tools/EditProxy"
        ],
        description:"${isc.DocUtils.linkForRef('class:EditProxy')} that handles ${isc.DocUtils.linkForRef('class:SectionStack')} objects when editMode is enabled.",
        methods:[
        ],
        name:"SectionStackEditProxy"
    },
    "attr:ListGrid.sorterConstructor":{
        seeAlso:[
        ],
        defaultValue:"Button",
        type:"attr",
        definingClass:"class:ListGrid",
        groups:[
            "gridHeader",
            "appearance"
        ],
        deprecated:null,
        ref:"attr:ListGrid.sorterConstructor",
        valueType:"Class",
        description:"Widget class for the corner sort button, if showing.  This button displays the current\n sort direction of the primary sort field (either the only sorted field or the first in a\n ${isc.DocUtils.linkForRef('attr:ListGrid.canMultiSort','multi-sort')} grid) and reverses the direction of that field\n when clicked.  For consistent appearance, this\n is usually set to match ${isc.DocUtils.linkForRef('attr:ListGrid.headerButtonConstructor')}",
        flags:"IR",
        name:"sorterConstructor"
    },
    "method:ListGrid.isSelected":{
        seeAlso:[
        ],
        type:"method",
        definingClass:"class:ListGrid",
        returns:{
            type:"Boolean",
            description:"true if record is selected; false otherwise"
        },
        groups:[
            "selection"
        ],
        deprecated:null,
        ref:"method:ListGrid.isSelected",
        params:[
            {
                defaultValue:null,
                optional:false,
                type:"ListGridRecord",
                description:"record to check",
                name:"record"
            }
        ],
        description:" Returns true if the record is selected.\n \n",
        flags:"",
        name:"isSelected"
    },
    "attr:ToolbarItem.canvasConstructor":{
        seeAlso:[
        ],
        ref:"attr:ToolbarItem.canvasConstructor",
        defaultValue:"Toolbar",
        deprecated:null,
        type:"attr",
        definingClass:"class:ToolbarItem",
        valueType:"String",
        description:"Constructor class for this toolbarItem's ${isc.DocUtils.linkForRef('attr:ToolbarItem.canvas','canvas')}.",
        flags:"IRA",
        name:"canvasConstructor"
    },
    "attr:DateChooser.cancelButton":{
        seeAlso:[
        ],
        ref:"attr:DateChooser.cancelButton",
        defaultValue:"null",
        deprecated:null,
        type:"attr",
        definingClass:"class:DateChooser",
        valueType:"AutoChild IButton",
        description:"A button shown below the ${isc.DocUtils.linkForRef('class:DateGrid','calendar grid')} which, when clicked, \n closes the DateChooser without selecting a value.",
        flags:"IR",
        name:"cancelButton"
    },
    "attr:KeyIdentifier.shiftKey":{
        seeAlso:[
            {
                ref:"classMethod:EventHandler.shiftKeyDown",
                description:null
            }
        ],
        ref:"attr:KeyIdentifier.shiftKey",
        defaultValue:"null",
        deprecated:null,
        type:"attr",
        definingClass:"object:KeyIdentifier",
        valueType:"Boolean",
        description:"If set, whether the Shift key must be held down.",
        flags:"IR",
        name:"shiftKey"
    },
    "attr:CalendarEvent.styleName":{
        seeAlso:[
        ],
        ref:"attr:CalendarEvent.styleName",
        defaultValue:"null",
        deprecated:null,
        type:"attr",
        definingClass:"object:CalendarEvent",
        valueType:"CSSStyleName",
        description:"CSS style series to use for ${isc.DocUtils.linkForRef('attr:Calendar.eventCanvas','canvas instances')} that \n represent this event in the various ${isc.DocUtils.linkForRef('class:CalendarView','calendar views')}.  The basic \n series should include three classes - the base style and others suffixed \"Header\" and \"Body\".\n <P>\n If not specified on the event, the style can be specified on the \n ${isc.DocUtils.linkForRef('attr:Calendar.eventStyleName','calendar')}, the ${isc.DocUtils.linkForRef('attr:CalendarView.eventStyleName','view')} or\n individually on each ${isc.DocUtils.linkForRef('attr:Lane.eventStyleName','lane')} or ${isc.DocUtils.linkForRef('attr:Lane.sublanes','sublane')}.\n <P>\n The name of this field within the CalendarEvent can be changed via\n ${isc.DocUtils.linkForRef('attr:Calendar.eventStyleNameField')}",
        flags:"IR",
        name:"styleName"
    },
    "attr:FieldPicker.instructionLabel":{
        seeAlso:[
        ],
        ref:"attr:FieldPicker.instructionLabel",
        defaultValue:"null",
        deprecated:null,
        type:"attr",
        definingClass:"class:FieldPicker",
        valueType:"AutoChild Label",
        description:"A ${isc.DocUtils.linkForRef('class:Label','label')} displaying the text assigned as the FieldPicker's\n ${isc.DocUtils.linkForRef('attr:FieldPicker.instructions','instructions')}.  Shown across the top of the widget.",
        flags:"IR",
        name:"instructionLabel"
    },
    "attr:ListGrid.collapseGroupOnRowClick":{
        seeAlso:[
            {
                ref:"method:ListGrid.groupBy",
                description:null
            }
        ],
        defaultValue:"true",
        type:"attr",
        definingClass:"class:ListGrid",
        groups:[
            "grouping"
        ],
        deprecated:null,
        ref:"attr:ListGrid.collapseGroupOnRowClick",
        valueType:"boolean",
        description:"If ${isc.DocUtils.linkForRef('attr:ListGrid.canCollapseGroup')} is true, will a click anywhere on the group row\n toggle the group's expanded state? If false, the user must click the\n ${isc.DocUtils.linkForRef('attr:ListGrid.groupIcon')} directly to toggle the group.",
        flags:"IR",
        name:"collapseGroupOnRowClick"
    },
    "attr:FormulaBuilder.testRecord":{
        seeAlso:[
        ],
        defaultValue:"null",
        type:"attr",
        definingClass:"class:FormulaBuilder",
        getter:[
            "getTestRecord"
        ],
        groups:[
            "formulaFields"
        ],
        ref:"attr:FormulaBuilder.testRecord",
        deprecated:null,
        valueType:"Record",
        description:"Record to use when testing the formula dynamically (if ${isc.DocUtils.linkForRef('attr:FormulaBuilder.autoTest')} is enabled) or when\n showing samples of formula output.\n <P>\n If not specified, the selected record in the component that launched the FormulaBuilder will\n be used, or if there's no selection, the first visible row, or with no component, a dummy\n data row derived automatically from the provided DataSource.",
        flags:"IRA",
        name:"testRecord"
    },
    "classMethod:Class.toString":{
        seeAlso:[
        ],
        ref:"classMethod:Class.toString",
        deprecated:null,
        type:"classMethod",
        definingClass:"class:Class",
        description:"\n  The default toString() for a ClassObject reports that you have a ClassObject and what class\n  it is.\n",
        flags:"",
        name:"toString"
    },
    "attr:Scrollbar.cornerSize":{
        seeAlso:[
        ],
        defaultValue:"null",
        type:"attr",
        definingClass:"class:Scrollbar",
        groups:[
            "corner"
        ],
        deprecated:null,
        ref:"attr:Scrollbar.cornerSize",
        valueType:"Integer",
        description:"Allows the size of the corner segment to be set independently of the ${isc.DocUtils.linkForRef('attr:Scrollbar.btnSize')}.",
        flags:"IR",
        name:"cornerSize"
    },
    "attr:TimeItem.millisecondValues":{
        seeAlso:[
        ],
        defaultValue:"null",
        type:"attr",
        definingClass:"class:TimeItem",
        getter:[
            "getMillisecondValues"
        ],
        ref:"attr:TimeItem.millisecondValues",
        deprecated:null,
        setter:[
            "setMillisecondValues"
        ],
        valueType:"Array of Number",
        description:"An array of values to make available in the \n ${isc.DocUtils.linkForRef('attr:TimeItem.millisecondItem','millisecond picker')} when\n ${isc.DocUtils.linkForRef('attr:TimeItem.useTextField','useTextField')} is false.\n <P>Used for specifying a limited set of valid Millisecond values, or when using the \n TimeItem to record duration, rather than time per-se.\n <P> See ${isc.DocUtils.linkForRef('attr:TimeItem.millisecondMinValue','millisecondMinValue')}, \n ${isc.DocUtils.linkForRef('attr:TimeItem.millisecondMaxValue','millisecondMaxValue')} and \n ${isc.DocUtils.linkForRef('attr:TimeItem.millisecondIncrement','millisecondIncrement')} for another method of \n controlling the content in the millisecond picker.",
        flags:"IRW",
        name:"millisecondValues"
    },
    "attr:CubeGrid.editByCell":{
        seeAlso:[
        ],
        defaultValue:"true",
        type:"attr",
        definingClass:"class:CubeGrid",
        groups:[
            "cellEditing"
        ],
        deprecated:null,
        ref:"attr:CubeGrid.editByCell",
        valueType:"Boolean",
        description:"CubeGrids only support editing by cell.",
        flags:"R",
        name:"editByCell"
    },
    "attr:RPCRequest.suppressAutoDraw":{
        seeAlso:[
        ],
        ref:"attr:RPCRequest.suppressAutoDraw",
        defaultValue:"true",
        deprecated:null,
        type:"attr",
        definingClass:"object:RPCRequest",
        valueType:"Boolean",
        description:"If ${isc.DocUtils.linkForRef('attr:RPCRequest.evalResult')} is set, setting this property to true causes\n ${isc.DocUtils.linkForRef('attr:Canvas.autoDraw')} to be set to false for the duration of the result evaluation -\n which is generally what you want if you're returning new components from the server.\n <P>\n This also effects components loaded via the ${isc.DocUtils.linkForRef('classMethod:RPCManager.loadScreen')} API.",
        flags:"IRWA",
        name:"suppressAutoDraw"
    },
    "attr:DecisionGateway.nextElement":{
        seeAlso:[
            {
                ref:"attr:DecisionGateway.defaultElement",
                description:null
            }
        ],
        ref:"attr:DecisionGateway.nextElement",
        defaultValue:"null",
        deprecated:null,
        type:"attr",
        definingClass:"class:DecisionGateway",
        valueType:"String",
        description:"Not applicable to a DecisionGateway.",
        flags:"IR",
        name:"nextElement"
    },
    "attr:DrawPane.drawingType":{
        seeAlso:[
        ],
        ref:"attr:DrawPane.drawingType",
        defaultValue:"based on browser",
        deprecated:null,
        type:"attr",
        definingClass:"class:DrawPane",
        valueType:"DrawingType",
        description:"Which type of drawing back-end should be used by this <code>DrawPane</code>? A default drawing\n back-end is automatically selected based on the browser.\n <p>\n The <code>drawingType</code> can only be set to a drawing back-end type that is supported\n by the browser. It is provided for cases where the browser supports more than one drawing\n back-end. See the ${isc.DocUtils.linkForRef('type:DrawingType')} documentation for the supported drawing back-ends\n and the list of browsers that support each type of drawing back-end.",
        flags:"IRA",
        name:"drawingType"
    },
    "classMethod:RPCManager.isScreenCached":{
        seeAlso:[
        ],
        ref:"classMethod:RPCManager.isScreenCached",
        deprecated:null,
        type:"classMethod",
        definingClass:"class:RPCManager",
        params:[
            {
                defaultValue:null,
                optional:false,
                type:"String",
                description:"name of the screen",
                name:"screenName"
            }
        ],
        description:"\n Returns true if a screen with the given name has already been cached by a call to \n ${isc.DocUtils.linkForRef('classMethod:RPCManager.cacheScreens')} (or ${isc.DocUtils.linkForRef('classMethod:RPCManager.loadProject')}), false otherwise.\n \n",
        flags:"",
        name:"isScreenCached"
    },
    "method:WebService.getSoapMessage":{
        seeAlso:[
        ],
        ref:"method:WebService.getSoapMessage",
        deprecated:null,
        type:"method",
        definingClass:"class:WebService",
        params:[
            {
                defaultValue:null,
                optional:false,
                type:"WSRequest Properties",
                description:"web service request object",
                name:"wsRequest"
            }
        ],
        description:" Return the SOAP message that will be formed from this WSRequest.\n \n",
        flags:"A",
        returns:{
            type:"String",
            description:"SOAP message"
        },
        name:"getSoapMessage"
    },
    "method:ListGrid.anySelected":{
        groups:[
            "selection"
        ],
        seeAlso:[
        ],
        ref:"method:ListGrid.anySelected",
        deprecated:null,
        type:"method",
        definingClass:"class:ListGrid",
        description:" Whether at least one item is selected\n",
        flags:"",
        returns:{
            type:"boolean",
            description:"true == at least one item is selected\t\t\t\t\t\t\t\tfalse == nothing at all is selected"
        },
        name:"anySelected"
    },
    "attr:Scrollbar.trackEndHeight":{
        seeAlso:[
        ],
        defaultValue:"12",
        type:"attr",
        definingClass:"class:Scrollbar",
        groups:[
            "track"
        ],
        deprecated:null,
        ref:"attr:Scrollbar.trackEndHeight",
        valueType:"number",
        description:"The minimum pixel height of the track end segments (if enabled with showTrackEnds).",
        flags:"IRA",
        name:"trackEndHeight"
    },
    "attr:FormulaBuilder.instructionsTextStart":{
        seeAlso:[
        ],
        defaultValue:"\"The following fields are available for use in this ${builderType}.  Click any field to have it added to the ${builderType}.\"",
        type:"attr",
        definingClass:"class:FormulaBuilder",
        groups:[
            "i18nMessages"
        ],
        deprecated:null,
        ref:"attr:FormulaBuilder.instructionsTextStart",
        valueType:"HTMLString",
        description:"The text to display as a preamble to the instruction text that appears in the \n ${isc.DocUtils.linkForRef('attr:FormulaBuilder.instructions','instructions label')}.\n <P>\n This is a dynamic string - text within <code>&#36;{...}</code> are dynamic variables and will \n be evaluated as JS code when the message is displayed.\n <P>\n Only one dynamic variable, builderType, is available and represents the type of this\n builder - either Formula or Summary.\n <P>\n Default value returns <P>\n <code>\n <i>The following fields are available for use in this [Formula/Summary]</i>\n </code>",
        flags:"IRWA",
        name:"instructionsTextStart"
    },
    "classMethod:Page.setIsomorphicDir":{
        groups:[
            "files"
        ],
        seeAlso:[
        ],
        ref:"classMethod:Page.setIsomorphicDir",
        deprecated:null,
        type:"classMethod",
        definingClass:"class:Page",
        params:[
            {
                defaultValue:null,
                optional:true,
                type:"String",
                description:"New IsomorphicDir URL.",
                name:"URL"
            }
        ],
        description:" Specify the root directory for Isomorphic-supplied files - the directory containing \n the <code>modules/</code> and <code>system/</code> subdirectories shipped as part of\n the SmartClient package.\n <P>\n Note that this property is commonly specified directly in the bootstrap HTML file\n by setting <code>window.isomorphicDir</code> before loading the SmartClient library files.\n\n",
        flags:"",
        name:"setIsomorphicDir"
    },
    "method:ColumnTree.getData":{
        seeAlso:[
        ],
        ref:"method:ColumnTree.getData",
        deprecated:null,
        type:"method",
        definingClass:"class:ColumnTree",
        description:" Returns the ${isc.DocUtils.linkForRef('class:Tree')} object this ColumnTree is viewing\n\n",
        flags:"",
        name:"getData"
    },
    "attr:OperationBinding.invalidateCache":{
        seeAlso:[
        ],
        defaultValue:"null",
        type:"attr",
        definingClass:"class:OperationBinding",
        deprecated:null,
        ref:"attr:OperationBinding.invalidateCache",
        valueType:"boolean",
        description:"If set, every invocation of this operationBinding will invalidate the local cache, forcing\n a server visit to refresh the data.",
        flags:"IR",
        serverDS:"allowed",
        name:"invalidateCache"
    },
    "method:ListGrid.groupStateChanged":{
        seeAlso:[
        ],
        ref:"method:ListGrid.groupStateChanged",
        deprecated:null,
        type:"method",
        definingClass:"class:ListGrid",
        description:" Notification method executed whenever the groupState of this grid changes.\n Group state is accessible via ${isc.DocUtils.linkForRef('method:ListGrid.getGroupState')}, and contains group state\n information.\n\n",
        flags:"",
        name:"groupStateChanged"
    },
    "object:SimpleGradient":{
        seeAlso:[
        ],
        type:"object",
        staticMethods:[
        ],
        inheritsFrom:"Gradient",
        classMethods:[
        ],
        classAttrs:[
        ],
        attrs:[
            "attr:SimpleGradient.direction",
            "attr:SimpleGradient.startColor",
            "attr:SimpleGradient.endColor"
        ],
        ref:"object:SimpleGradient",
        deprecated:null,
        treeLocation:[
            "Client Reference/Drawing/Gradients"
        ],
        description:"Definition of a simple linear gradient defined by 2 colors and a ${isc.DocUtils.linkForRef('attr:SimpleGradient.direction','direction')}.",
        methods:[
        ],
        name:"SimpleGradient"
    },
    "method:TabSet.disableTab":{
        seeAlso:[
            {
                ref:"attr:Tab.disabled",
                description:null
            }
        ],
        ref:"method:TabSet.disableTab",
        deprecated:null,
        type:"method",
        definingClass:"class:TabSet",
        params:[
            {
                defaultValue:null,
                optional:false,
                type:"Tab | number | GlobalId | TabName",
                description:null,
                name:"tab"
            }
        ],
        description:" If the specified tab is enabled, disable it now.\n",
        flags:"",
        name:"disableTab"
    },
    "attr:SectionStack.canTabToHeaders":{
        seeAlso:[
        ],
        ref:"attr:SectionStack.canTabToHeaders",
        defaultValue:"null",
        deprecated:null,
        type:"attr",
        definingClass:"class:SectionStack",
        valueType:"boolean",
        description:"If true, the headers for the sections (if shown) will be included in the page's tab\n order for accessibility. \n May be overridden at the Section level via ${isc.DocUtils.linkForRef('attr:SectionStackSection.canTabToHeader')}\n <P>\n If unset, section headers will be focusable if ${isc.DocUtils.linkForRef('staticMethod:isc.setScreenReaderMode')}\n \n  has been called.\n See ${isc.DocUtils.linkForRef('group:accessibility')}.",
        flags:"IRA",
        name:"canTabToHeaders"
    },
    "group:paging":{
        refs:[
            "attr:DSResponse.startRow",
            "attr:DSResponse.endRow",
            "attr:DSResponse.totalRows",
            "attr:DSRequest.startRow",
            "attr:DSRequest.endRow"
        ],
        seeAlso:[
        ],
        ref:"group:paging",
        deprecated:null,
        type:"group",
        description:null,
        name:"paging"
    },
    "method:TileLayout.getTile":{
        seeAlso:[
        ],
        ref:"method:TileLayout.getTile",
        deprecated:null,
        type:"method",
        definingClass:"class:TileLayout",
        params:[
            {
                defaultValue:null,
                optional:false,
                type:"int",
                description:"index of the tile",
                name:"index"
            }
        ],
        description:" Retrieve a tile by index.  \n <P>\n The TileLayout consistently uses this method to access tiles, in order to allow subclasses\n to create tiles on demand.\n\n",
        flags:"",
        returns:{
            type:"Canvas",
            description:"the tile"
        },
        name:"getTile"
    },
    "classMethod:Page.getIsomorphicDir":{
        groups:[
            "files"
        ],
        seeAlso:[
        ],
        ref:"classMethod:Page.getIsomorphicDir",
        deprecated:null,
        type:"classMethod",
        definingClass:"class:Page",
        description:"\t\tReturn the root directory for Isomorphic-specific files.\n\n",
        flags:"",
        returns:{
            type:"String",
            description:"IsomorphicDir URL."
        },
        name:"getIsomorphicDir"
    },
    "method:DataSource.updateCaches":{
        seeAlso:[
        ],
        ref:"method:DataSource.updateCaches",
        deprecated:null,
        type:"method",
        definingClass:"class:DataSource",
        params:[
            {
                defaultValue:null,
                optional:false,
                type:"DSResponse",
                description:"the provided DSResponse must minimally have                                 dataSource, operationType, and data set",
                name:"dsResponse"
            },
            {
                defaultValue:null,
                optional:true,
                type:"DSRequest",
                description:"optional dsRequest.  If not specified, a DSRequest will be                                automatically created based on the DataSource and operationType of\n                                the DSResponse",
                name:"dsRequest"
            }
        ],
        description:" Causes any components using this DataSource to be notified of changes that have been made to\n the remote dataset accessed via this DataSource, as though the provided DSResponse had just\n successfully completed.  This will cause cache managers such as ${isc.DocUtils.linkForRef('class:ResultSet')} or \n ${isc.DocUtils.linkForRef('class:ResultTree')} to automatically update their caches, and components using such cache\n managers to visually update to show modified data.\n <P>\n This API should be used when you have found out about changes made by other users or by\n automatic processes.  For example, using the SmartClient ${isc.DocUtils.linkForRef('class:Messaging')} system to receive\n real-time updates via HTTP streaming, you may get updates that should affect a ListGrid\n which is using a ResultSet to view a portion of a large dataset.  \n <P>\n The provided <code>DSResponse</code> should have\n ${isc.DocUtils.linkForRef('attr:DSResponse.operationType','operationType')} \"update\", \"add\" or \"remove\" - there is no\n way for a \"fetch\" response to meaningfully update arbitrary caches.  However, if you\n have a list of updated records (possibly retrieved via ${isc.DocUtils.linkForRef('method:DataSource.fetchData')}) you can still call\n <code>updateCaches()</code>with DSResponses of type \"update\". Typically DataSource operations\n that manipulate data operate on a single record at a time, but if you explicitly set the\n <code>response.data</code> attribute to an array of records, framework code will handle this\n as it would multiple updates.\n <P>\n Example usage: if you had a ListGrid bound to the <code>supplyItem</code> sample DataSource, \n and that ListGrid was showing a Record with <code>itemId</code> 23, and you wanted to update \n the <code>unitCost</code> field to a new value, you would use the following code:<br><br>\n \n    <code>\n    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;// updatedRecord is the record we want to update<br>\n    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;var record = supplyItemDS.copyRecord(updatedRecord);<br>\n    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;record.unitCost = 500;<br>\n    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;var dsResponse = {<br>\n    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;data: [record],<br>\n    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;operationType: \"update\"<br>\n    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;};<br>\n    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;supplyItemDS.updateCaches(dsResponse);<br>\n   </code>\n \n \n <P>\n To cause all components that have cache managers to drop their caches, provide a\n DSResponse with ${isc.DocUtils.linkForRef('attr:DSResponse.invalidateCache')} set.\n <P>\n As an alternative to calling <code>updateCaches()</code> directly, if updates to other\n DataSources occur as a result of server-side logic, you can use the server-side API\n DSResponse.addRelatedUpdate(DSResponse) (Pro Edition and above), which ultimately calls\n <code>updateCaches()</code> for you - see that method's documentation for details.\n <P>\n <b>NOTE:</b>: if <code>updateCaches</code> is called for a\n ${isc.DocUtils.linkForRef('attr:DataSource.clientOnly','clientOnly')} DataSource, it will update\n ${isc.DocUtils.linkForRef('attr:DataSource.cacheData')} synchronously in addition to notifying all cache managers as\n normal.\n <P>\n If a DataSource has ${isc.DocUtils.linkForRef('attr:DataSource.cacheAllData')} set and a full cache has been obtained, calling\n <code>updateCaches</code> will automatically update the cache.\n <P>\n Note that the DSResponse provided to this method will <b>not</b> go through\n ${isc.DocUtils.linkForRef('method:DataSource.transformResponse')} or other processing that would normally occur for a\n DSResponse resulting from a DSRequest sent by the application in this page.\n\n",
        flags:"",
        name:"updateCaches"
    },
    "attr:ResultSet.requestProperties":{
        seeAlso:[
        ],
        ref:"attr:ResultSet.requestProperties",
        defaultValue:"null",
        deprecated:null,
        type:"attr",
        definingClass:"class:ResultSet",
        valueType:"DSRequest Properties",
        description:"Allows to set a DSRequest properties to this ResulSet.",
        flags:"IR",
        name:"requestProperties"
    },
    "attr:ListGrid.alternateFieldStyles":{
        seeAlso:[
        ],
        defaultValue:"false",
        type:"attr",
        definingClass:"class:ListGrid",
        groups:[
            "cellStyling"
        ],
        deprecated:null,
        ref:"attr:ListGrid.alternateFieldStyles",
        valueType:"boolean",
        description:"Whether alternating columns (or blocks of columns, depending\n on ${isc.DocUtils.linkForRef('attr:GridRenderer.alternateColumnFrequency')}) should be drawn in alternating styles,\n in order to create a vertical \"ledger\" effect for easier reading.\n <P>\n If enabled, the cell style for alternate rows will have the\n ${isc.DocUtils.linkForRef('attr:GridRenderer.alternateColumnSuffix')} appended to it.\n See also ${isc.DocUtils.linkForRef('attr:GridRenderer.alternateRowStyles')}.",
        flags:"IRW",
        name:"alternateFieldStyles"
    },
    "attr:EventCanvas.headerStyle":{
        seeAlso:[
        ],
        defaultValue:"null",
        type:"attr",
        definingClass:"class:EventCanvas",
        groups:[
            "appearance"
        ],
        deprecated:null,
        ref:"attr:EventCanvas.headerStyle",
        valueType:"CSSStyleName",
        description:"CSS class for the ${isc.DocUtils.linkForRef('attr:EventCanvas.showHeader','header area')} of the EventCanvas.\n If unset, defaults to the ${isc.DocUtils.linkForRef('attr:EventCanvas.styleName','base styleName')} with the suffix\n \"Header\".",
        flags:"IRW",
        name:"headerStyle"
    },
    "attr:ListGrid.stopOnErrors":{
        seeAlso:[
            {
                ref:"attr:ListGrid.waitForSave",
                description:null
            }
        ],
        defaultValue:"false",
        type:"attr",
        definingClass:"class:ListGrid",
        groups:[
            "editing"
        ],
        deprecated:null,
        ref:"attr:ListGrid.stopOnErrors",
        valueType:"Boolean",
        description:"If this is an editable listGrid, this property determines how failure to save due to\n validation errors should be displayed to the user.\n <P>\n If this property is true, when validation errors occur the errors will be displayed\n to the user in an alert, and focus will be returned to the first cell to fail validation.\n <P>\n If false, the cells that failed validation will be silently styled with the\n editFailedBaseStyle.\n <p>\n <b>Note:</b> stopOnErrors being set to true implies that 'waitForSave' is also true.\n We will not dismiss the editor until save has completed if stopOnErrors is true.",
        flags:"IRWA",
        name:"stopOnErrors"
    },
    "classMethod:Class.create":{
        seeAlso:[
        ],
        type:"classMethod",
        definingClass:"class:Class",
        returns:{
            type:"Object",
            description:"New instance of this class, whose init() routine has already been called"
        },
        deprecated:null,
        ref:"classMethod:Class.create",
        params:[
            {
                defaultValue:null,
                optional:true,
                type:"Any",
                description:"Any arguments passed will be passed along to the init() routine of the instance.\n      Unless ${isc.DocUtils.linkForRef('attr:Class.addPropertiesOnCreate')} is set to false, any arguments passed to\n      this method must be of type Object.",
                name:"arguments 0-N"
            }
        ],
        description:"\n Create an instance of this class.  \n <P>\n All arguments passed to this method are passed on to the ${isc.DocUtils.linkForRef('method:Class.init')} instance \n method.  Unless ${isc.DocUtils.linkForRef('attr:Class.addPropertiesOnCreate')} is set to <code>false</code>, all\n arguments passed to this method must be Objects and all properties on those\n objects will be copied to the newly created instance before ${isc.DocUtils.linkForRef('method:Class.init')} is\n called.  If there are overlapping properties in the passed arguments, the last wins.\n <p>\n Any return value from ${isc.DocUtils.linkForRef('method:Class.init')} is thrown away.\n <p>\n Note: Generally, you would not override this method.  If you want to specify a\n constructor for your class, provide an override for ${isc.DocUtils.linkForRef('method:Class.init')} for generic\n classes or ${isc.DocUtils.linkForRef('method:Canvas.initWidget')} for any subclasses of UI components\n (i.e. descendants of ${isc.DocUtils.linkForRef('class:Canvas')}).\n\n",
        flags:"",
        examples:[
            "<code>var myInstance = MyClass.create()</code>",
            "${isc.DocUtils.linkForExampleId('create')}"
        ],
        name:"create"
    },
    "method:ListGrid.editFailed":{
        groups:[
            "editing"
        ],
        seeAlso:[
        ],
        ref:"method:ListGrid.editFailed",
        deprecated:null,
        type:"method",
        definingClass:"class:ListGrid",
        params:[
            {
                defaultValue:null,
                optional:false,
                type:"number",
                description:"current index of the row we attempted to save",
                name:"rowNum"
            },
            {
                defaultValue:null,
                optional:false,
                type:"number",
                description:"index of the column where the edit failed, if applicable",
                name:"colNum"
            },
            {
                defaultValue:null,
                optional:false,
                type:"Object | Record",
                description:"new values that we attempted to save",
                name:"newValues"
            },
            {
                defaultValue:null,
                optional:false,
                type:"Record",
                description:"the complete original values from before the save occurred",
                name:"oldValues"
            },
            {
                defaultValue:null,
                optional:false,
                type:"EditCompletionEvent",
                description:"Edit completion event that led to the save                                                  attempt",
                name:"editCompletionEvent"
            },
            {
                defaultValue:null,
                optional:true,
                type:"DSResponse",
                description:"DSResponse, for saves through a DataSource",
                name:"dsResponse"
            }
        ],
        description:" Called when an attempt to save inline edits fails, due to a validation error or other\n server error.\n <P>\n The default implementation of editFailed does nothing for normal validation errors,\n which are displayed before editFailed() is called.  For any other errors, the default\n implementation will call ${isc.DocUtils.linkForRef('classMethod:RPCManager.handleError')}, which by default\n will result in a warning dialog.\n\n",
        flags:"",
        name:"editFailed"
    },
    "classAttr:EventHandler.STOP_BUBBLING":{
        seeAlso:[
        ],
        ref:"classAttr:EventHandler.STOP_BUBBLING",
        defaultValue:"\"***STOP***\"",
        deprecated:null,
        type:"classAttr",
        definingClass:"class:EventHandler",
        valueType:"String",
        description:"Return this constant from a child event to stop the event propagating to its parent,\n without suppressing any native browser handling associated with the event.\n Developers should not need to modify this value - it should be treated as read-only\n in most circumstances.",
        flags:"IRA",
        name:"STOP_BUBBLING"
    },
    "attr:FormItem.updateTextBoxOnOver":{
        seeAlso:[
            {
                ref:"attr:FormItem.showOver",
                description:null
            }
        ],
        defaultValue:"null",
        type:"attr",
        definingClass:"class:FormItem",
        groups:[
            "formItemStyling"
        ],
        deprecated:null,
        ref:"attr:FormItem.updateTextBoxOnOver",
        valueType:"Boolean",
        description:"If ${isc.DocUtils.linkForRef('attr:FormItem.showOver')} is true, setting this property to false will explicitly\n disable showing the \"Over\" state for the TextBox element of this item.",
        flags:"IRWA",
        name:"updateTextBoxOnOver"
    },
    "method:ListGrid.refreshData":{
        groups:[
            "dataBoundComponentMethods"
        ],
        seeAlso:[
            {
                ref:"method:ListGrid.fetchData",
                description:null
            },
            {
                ref:"method:ListGrid.invalidateCache",
                description:null
            }
        ],
        ref:"method:ListGrid.refreshData",
        deprecated:null,
        type:"method",
        definingClass:"class:ListGrid",
        params:[
            {
                defaultValue:null,
                optional:true,
                type:"DSCallback",
                description:"callback method to run once the refresh completes.",
                name:"callback"
            }
        ],
        description:" Unlike ${isc.DocUtils.linkForRef('method:ListGrid.invalidateCache','invalidateCache')} this will perform an asynchronous\n (background) refresh of this component's data and then call the provided callback method on\n completion.  A grid needs to have a ${isc.DocUtils.linkForRef('class:DataSource')} associated with it to use this method.\n <p>\n If <code>refreshData()</code> is called while the grid is waiting for a response from\n ${isc.DocUtils.linkForRef('method:ListGrid.fetchData')} the <code>refreshData()</code> call will be aborted. This is\n because the fetch has higher priority.\n <p>\n If ${isc.DocUtils.linkForRef('method:ListGrid.fetchData')} is called while the grid is waiting for a response from\n <code>refreshData()</code>  and the <code>fetchData()</code> call has altered the criteria\n or sort specifiers, the <code>refreshData()</code> call will be aborted.\n <p>\n If data is being edited or has been edited without being saved when\n <code>refreshData()</code> is called, the data will be retained so you can save it after the\n refresh is complete. If you however want to throw away your edited but unsaved data when\n calling <code>refreshData()</code> you first need to call ${isc.DocUtils.linkForRef('method:ListGrid.discardAllEdits')}\n which will discard any unsaved edited data.\n <p>\n Note that for a TreeGrid with ${isc.DocUtils.linkForRef('attr:TreeGrid.loadDataOnDemand')}: true, all currently opened\n parent nodes will be re-fetched, except for ${isc.DocUtils.linkForRef('attr:TreeGrid.dataFetchMode','paged')} TreeGrids,\n for which only opened parent nodes that are <i>visible</i> or contain <i>visible</i> children\n are re-fetched.  We do this in a single queued batch of fetches to maximize efficiency.\n <p>\n Except for changes to the dataset length,  ${isc.DocUtils.linkForRef('method:ListGrid.dataChanged','dataChanged()')} is\n not fired after <code>refreshData()</code>, as the Framework is not in a position to know\n for sure if data has actually changed (which would require traversing the entire dataset to\n determine) and whether criteria, sort or other specifiers of the dataset also have not\n changed.  Applications that need to take action on <code>refreshData()</code> should use the\n callback to do so.\n\n",
        flags:"",
        name:"refreshData"
    },
    "method:Calendar.getDateStyle":{
        seeAlso:[
            {
                ref:"method:Calendar.getDateHTML",
                description:null
            },
            {
                ref:"method:Calendar.getDateCSSText",
                description:null
            }
        ],
        ref:"method:Calendar.getDateStyle",
        deprecated:null,
        type:"method",
        definingClass:"class:Calendar",
        params:[
            {
                defaultValue:null,
                optional:false,
                type:"Date",
                description:"the date to return the CSS styleName for",
                name:"date"
            },
            {
                defaultValue:null,
                optional:false,
                type:"Integer",
                description:"the row number containing the date to get the CSS styleName for",
                name:"rowNum"
            },
            {
                defaultValue:null,
                optional:false,
                type:"Integer",
                description:"the column number containing the date to get the CSS styleName for",
                name:"colNum"
            },
            {
                defaultValue:null,
                optional:false,
                type:"CalendarView",
                description:"the relevant CalendarView",
                name:"view"
            }
        ],
        description:" Return the CSS styleName for the associated date-cell in the passed view.\n\n",
        flags:"",
        returns:{
            type:"CSSStyleName",
            description:"CSS style for the cell with the passed date and rowNum/colNum"
        },
        name:"getDateStyle"
    },
    "method:SliderItem.pendingStatusChanged":{
        seeAlso:[
        ],
        type:"method",
        definingClass:"class:SliderItem",
        returns:{
            type:"boolean",
            description:"<code>false</code> to cancel the default behavior."
        },
        deprecated:null,
        ref:"method:SliderItem.pendingStatusChanged",
        params:[
            {
                defaultValue:null,
                optional:false,
                type:"DynamicForm",
                description:"the managing <code>DynamicForm</code> instance.",
                name:"form"
            },
            {
                defaultValue:null,
                optional:false,
                type:"FormItem",
                description:"the form item itself (also available as \"this\").",
                name:"item"
            },
            {
                defaultValue:null,
                optional:false,
                type:"boolean",
                description:"<code>true</code> if the item should show its pending visual state; <code>false</code> otherwise.",
                name:"pendingStatus"
            },
            {
                defaultValue:null,
                optional:false,
                type:"Any",
                description:"the current form item value.",
                name:"newValue"
            },
            {
                defaultValue:null,
                optional:false,
                type:"Any",
                description:"the value that would be restored by a call to ${isc.DocUtils.linkForRef('method:DynamicForm.resetValues')}.",
                name:"value"
            }
        ],
        description:" Notification method called when ${isc.DocUtils.linkForRef('attr:FormItem.showPending','showPending')} is enabled and\n this <code>SliderItem</code> should either clear or show its pending visual state.\n <p>\n The default behavior is that the ${isc.DocUtils.linkForRef('attr:FormItem.titleStyle','titleStyle')} and\n ${isc.DocUtils.linkForRef('attr:FormItem.cellStyle','cellStyle')} are updated to include/exclude the \"Pending\" suffix.\n In addition, when displayed in the pending state the value label changes color.\n Returning <code>false</code> will cancel this default behavior.\n",
        flags:"",
        examples:[
            "${isc.DocUtils.linkForExampleId('canvasItemShowPendingSupport')}"
        ],
        name:"pendingStatusChanged"
    },
    "method:Calendar.refreshEvent":{
        seeAlso:[
        ],
        ref:"method:Calendar.refreshEvent",
        deprecated:null,
        type:"method",
        definingClass:"class:Calendar",
        params:[
            {
                defaultValue:null,
                optional:false,
                type:"CalendarEvent",
                description:"The event object to refresh in the current view",
                name:"event"
            }
        ],
        description:" Refreshes the passed event in the current view.\n\n",
        flags:"",
        name:"refreshEvent"
    },
    "attr:TreeGrid.cascadeSelection":{
        seeAlso:[
        ],
        ref:"attr:TreeGrid.cascadeSelection",
        defaultValue:"false",
        deprecated:null,
        type:"attr",
        definingClass:"class:TreeGrid",
        valueType:"Boolean",
        description:"Should children be selected when parent is selected? And should parent be\n selected when any child is selected?",
        flags:"IR",
        name:"cascadeSelection"
    },
    "attr:StatefulCanvas.showSelectedIcon":{
        seeAlso:[
        ],
        defaultValue:"false",
        type:"attr",
        definingClass:"class:StatefulCanvas",
        groups:[
            "buttonIcon"
        ],
        deprecated:null,
        ref:"attr:StatefulCanvas.showSelectedIcon",
        valueType:"Boolean",
        description:"If using an icon for this button, whether to switch the icon image when the button\n becomes selected.",
        flags:"IR",
        name:"showSelectedIcon"
    },
    "method:Canvas.getContentElement":{
        seeAlso:[
        ],
        ref:"method:Canvas.getContentElement",
        deprecated:null,
        type:"method",
        definingClass:"class:Canvas",
        description:" Returns the DOM element for this Canvas which contains the ${isc.DocUtils.linkForRef('attr:Canvas.contents')}, or\n for ${isc.DocUtils.linkForRef('method:Canvas.getParentCanvas','parent components')}, the DOM elements for any drawn\n children. This method is provided for the \n very rare cases where a programmer needs to examine the DOM hierarchy created by\n a drawn SmartClient component.\n <P>\n Direct manipulation of the DOM elements created by SmartClient components\n is not supported. SmartClient components should be rendered or cleared using\n standard methods such as ${isc.DocUtils.linkForRef('method:Canvas.draw')}, ${isc.DocUtils.linkForRef('method:Canvas.clear')}. If direct\n integration with existing DOM structures is required, this should be achieved via the\n ${isc.DocUtils.linkForRef('attr:Canvas.htmlElement')} attribute, rather than by attempting to move the\n component's outer element via native browser APIs.<br>\n The content of SmartClient components' DOM elements should also not be directly \n manipulated using native browser APIs - standard methods such as \n ${isc.DocUtils.linkForRef('method:Canvas.setContents')}, ${isc.DocUtils.linkForRef('method:Canvas.addChild')}, ${isc.DocUtils.linkForRef('method:Canvas.removeChild')},\n ${isc.DocUtils.linkForRef('method:Canvas.markForRedraw')} and ${isc.DocUtils.linkForRef('method:Canvas.redraw')} should be used instead.\n <P>\n In some cases, the element returned may match the element returned by\n ${isc.DocUtils.linkForRef('method:Canvas.getOuterElement')}, but this will not always be the case.\n <P>\n If the widget is undrawn, this method will return <code>null</code>.\n\n",
        flags:"A",
        returns:{
            type:"DOMElement",
            description:"The outer DOM element for a drawn Canvas."
        },
        name:"getContentElement"
    },
    "method:Calendar.timelineEventMoved":{
        seeAlso:[
        ],
        ref:"method:Calendar.timelineEventMoved",
        deprecated:"in favor of ${isc.DocUtils.linkForRef('method:Calendar.eventRepositionStop')}",
        type:"method",
        definingClass:"class:Calendar",
        params:[
            {
                defaultValue:null,
                optional:false,
                type:"CalendarEvent",
                description:"the event that was moved",
                name:"event"
            },
            {
                defaultValue:null,
                optional:false,
                type:"Date",
                description:"new start date of the passed event",
                name:"startDate"
            },
            {
                defaultValue:null,
                optional:false,
                type:"Date",
                description:"new end date of the passed event",
                name:"endDate"
            },
            {
                defaultValue:null,
                optional:false,
                type:"Lane",
                description:"the Lane in which this event has been dropped",
                name:"lane"
            }
        ],
        description:" Called when a Timeline event is moved via dragging by a user.  Return false to disallow the \n move.\n",
        flags:"",
        returns:{
            type:"Boolean",
            description:"return false to disallow the move."
        },
        name:"timelineEventMoved"
    },
    "attr:ListGridField.includeFrom":{
        seeAlso:[
        ],
        defaultValue:"null",
        type:"attr",
        definingClass:"object:ListGridField",
        groups:[
            "display_values"
        ],
        deprecated:null,
        ref:"attr:ListGridField.includeFrom",
        valueType:"String",
        description:"Indicates this field's values should be fetched from another, related DataSource.\n The individual field will inherit settings such as ${isc.DocUtils.linkForRef('attr:ListGridField.type','field.type')}\n and ${isc.DocUtils.linkForRef('attr:ListGridField.title','field.title')} from the related DataSource just like\n fields from the primary DataSource.\n <P>\n When ${isc.DocUtils.linkForRef('method:ListGrid.fetchData','fechData()')} is called, the automatically created ${isc.DocUtils.linkForRef('object:DSRequest')} will\n specify ${isc.DocUtils.linkForRef('attr:DSRequest.additionalOutputs')} requesting the field, and any ${isc.DocUtils.linkForRef('type:Criteria')}\n generated by the component will likewise refer to the field from the related DataSource.\n <P>\n It's an error to use this property if the ListGrid does not have a DataSource at all.\n The related DataSource must be loaded or a warning will be logged and the field\n definition ignored.\n <P>\n This value is expected to be set to the following format\n <code>dataSourceID.fieldName</code> where <i>dataSourceID</i> is the ID of the\n related dataSource and <i>fieldName</i> is the name of the field from that dataSource\n from which you wish to retrieve values. Note that if this property is set and\n ${isc.DocUtils.linkForRef('attr:ListGridField.name','field.name')} is not explicitly specified, this field's <code>name</code> will\n default to the <i>fieldName</i> value from this property.\n <p>\n Note about automatic cache updates: \"update\" and \"add\" operations\n submitted automatically by this ListGrid will include\n <code>dsRequest.additionalOutputs</code> to ensure all data necessary\n for cache updates is returned by the server.\n <p>\n If your grid shows data that can be edited elsewhere in the UI (not by\n inline editing), to avoid problems with ${isc.DocUtils.linkForRef('class:ResultSet')} automatic\n cache synchronization, you may need to switch from using\n <code>listGridField.includeFrom</code> to\n <code>dataSourceField.includeFrom</code>.  This is because\n server responses to \"add\" and \"update\" operations which are initiated\n outside of this grid do not know about the\n <code>listGridField.includeFrom</code> setting, and so will not\n automatically return data for fields included in this way.  Switching\n to <code>dataSourceField.includeFrom</code> ensures the field is\n always included in server responses, avoiding the issue.",
        flags:"IR",
        name:"includeFrom"
    },
    "method:Calendar.addEvent":{
        seeAlso:[
        ],
        ref:"method:Calendar.addEvent",
        deprecated:"in favor of ${isc.DocUtils.linkForRef('method:Calendar.addCalendarEvent')}",
        type:"method",
        definingClass:"class:Calendar",
        params:[
            {
                defaultValue:null,
                optional:false,
                type:"Date | CalendarEvent",
                description:"start date of event, or CalendarEvent Object",
                name:"startDate"
            },
            {
                defaultValue:null,
                optional:true,
                type:"Date",
                description:"end date of event",
                name:"endDate"
            },
            {
                defaultValue:null,
                optional:true,
                type:"String",
                description:"name of event",
                name:"name"
            },
            {
                defaultValue:null,
                optional:true,
                type:"String",
                description:"description of event",
                name:"description"
            },
            {
                defaultValue:null,
                optional:true,
                type:"Object",
                description:"new values of additional fields to be updated",
                name:"otherFields"
            }
        ],
        description:" Create a new event in this calendar instance.\n\n",
        flags:"",
        name:"addEvent"
    },
    "attr:Canvas.editProxyConstructor":{
        seeAlso:[
        ],
        ref:"attr:Canvas.editProxyConstructor",
        defaultValue:"\"CanvasEditProxy\"",
        deprecated:null,
        type:"attr",
        definingClass:"class:Canvas",
        valueType:"SCClassName",
        description:"Default class used to construct the ${isc.DocUtils.linkForRef('class:EditProxy')} for this component\n when the component is ${isc.DocUtils.linkForRef('method:Canvas.setEditMode','first placed into edit mode')}.",
        flags:"IR",
        name:"editProxyConstructor"
    },
    "attr:Snapbar.showDown":{
        seeAlso:[
        ],
        ref:"attr:Snapbar.showDown",
        defaultValue:"true",
        deprecated:null,
        type:"attr",
        definingClass:"class:Snapbar",
        valueType:"Boolean",
        description:"Snapbars show mouse-down styling.",
        flags:"IRW",
        name:"showDown"
    },
    "attr:ListGrid.operatorIcon":{
        seeAlso:[
        ],
        ref:"attr:ListGrid.operatorIcon",
        defaultValue:"null",
        deprecated:null,
        type:"attr",
        definingClass:"class:ListGrid",
        valueType:"MultiAutoChild FormItemIcon",
        description:"Inline icon shown inside ${isc.DocUtils.linkForRef('attr:ListGrid.showFilterEditor','filter editor')} fields when\n ${isc.DocUtils.linkForRef('attr:ListGrid.allowFilterOperators')} is enabled.",
        flags:"I",
        name:"operatorIcon"
    },
    "class:JSON":{
        seeAlso:[
        ],
        type:"class",
        staticMethods:[
        ],
        inheritsFrom:"Class",
        classMethods:[
            "classMethod:JSON.encode",
            "classMethod:JSON.decode"
        ],
        classAttrs:[
        ],
        attrs:[
        ],
        ref:"class:JSON",
        deprecated:null,
        treeLocation:[
            "Client Reference/Data Binding"
        ],
        description:"Utilities for working with JSON data.",
        methods:[
        ],
        name:"JSON"
    },
    "method:DateItem.setSelectionRange":{
        seeAlso:[
        ],
        ref:"method:DateItem.setSelectionRange",
        deprecated:null,
        type:"method",
        definingClass:"class:DateItem",
        params:[
            {
                defaultValue:null,
                optional:false,
                type:"int",
                description:"character index for start of new selection",
                name:"start"
            },
            {
                defaultValue:null,
                optional:false,
                type:"int",
                description:"character index for end of new selection",
                name:"end"
            }
        ],
        description:" If ${isc.DocUtils.linkForRef('attr:DateItem.useTextField')} is true, falls through to standard\n ${isc.DocUtils.linkForRef('method:TextItem.setSelectionRange','setSelectionRange()')} implementation on this items freeform text entry field.\n Otherwise has no effect.\n",
        flags:"",
        name:"setSelectionRange"
    },
    "attr:TimeItem.showHourItem":{
        seeAlso:[
        ],
        ref:"attr:TimeItem.showHourItem",
        defaultValue:"true",
        deprecated:null,
        type:"attr",
        definingClass:"class:TimeItem",
        valueType:"Boolean",
        description:"Controls whether to display the ${isc.DocUtils.linkForRef('attr:TimeItem.hourItem')} when ${isc.DocUtils.linkForRef('attr:TimeItem.useTextField')} is false.",
        flags:"IRW",
        name:"showHourItem"
    },
    "attr:FacadeDataSource.queuedRequests":{
        seeAlso:[
        ],
        ref:"attr:FacadeDataSource.queuedRequests",
        defaultValue:"null",
        deprecated:null,
        type:"attr",
        definingClass:"class:FacadeDataSource",
        valueType:"Array of DSRequest",
        description:"An array of derived DS requests that are queued to be ${isc.DocUtils.linkForRef('method:DataSource.execute','executed')} on the\n underlying ${isc.DocUtils.linkForRef('attr:DataSource.inheritsFrom','inherited')} DataSource.\n <p>\n When a DS request is made on this FacadeDataSource, if ${isc.DocUtils.linkForRef('attr:FacadeDataSource.queueRequests','queueRequests')}\n is true, then a new DS request is created based on the given DS request and added to this\n queue.\n <p>\n To clear the queue, set ${isc.DocUtils.linkForRef('attr:FacadeDataSource.queueRequests','queueRequests')} to false\n or call ${isc.DocUtils.linkForRef('method:FacadeDataSource.clearQueue','clearQueue()')}.",
        flags:"R",
        name:"queuedRequests"
    },
    "staticMethod:isA.nonemptyString":{
        seeAlso:[
        ],
        ref:"staticMethod:isA.nonemptyString",
        deprecated:null,
        type:"staticMethod",
        definingClass:"object:isA",
        params:[
            {
                defaultValue:null,
                optional:false,
                type:"Object",
                description:"object to test",
                name:"object"
            }
        ],
        description:"\n\tIs <code>object</code> a non-empty String?<br><br>\n\t\n",
        flags:"",
        returns:{
            type:"boolean",
            description:"true == <code>object</code> is a non-empty string"
        },
        name:"nonemptyString"
    },
    "method:DrawPane.zoom":{
        seeAlso:[
        ],
        ref:"method:DrawPane.zoom",
        deprecated:null,
        type:"method",
        definingClass:"class:DrawPane",
        params:[
            {
                defaultValue:null,
                optional:false,
                type:"float",
                description:"Desired zoom level as a float where <code>1.0</code> is equivalent to 100% magnification. Must be greater than 0.",
                name:"zoomLevel"
            }
        ],
        description:" Synonym of ${isc.DocUtils.linkForRef('method:DrawPane.setZoomLevel')}.\n",
        flags:"",
        name:"zoom"
    },
    "attr:ComboBoxItem.pickerExitButton":{
        seeAlso:[
        ],
        defaultValue:"null",
        type:"attr",
        definingClass:"class:ComboBoxItem",
        groups:[
            "panelPlacement"
        ],
        deprecated:null,
        ref:"attr:ComboBoxItem.pickerExitButton",
        valueType:"AutoChild NavigationButton",
        description:"${isc.DocUtils.linkForRef('class:NavigationButton')} to dismiss the picker interface, created when \n ${isc.DocUtils.linkForRef('attr:ComboBoxItem.pickListPlacement')} indicates that the search interface takes over the\n entire panel or screen.\n <p>\n The following ${isc.DocUtils.linkForRef('group:autoChildUsage','passthroughs')} apply:\n <ul>\n <li>${isc.DocUtils.linkForRef('attr:ComboBoxItem.pickerExitButtonTitle','pickerExitButtonTitle')} for ${isc.DocUtils.linkForRef('attr:Button.title')}</li>\n </ul>",
        flags:"IR",
        name:"pickerExitButton"
    },
    "attr:TabSet.showMoreTab":{
        seeAlso:[
        ],
        ref:"attr:TabSet.showMoreTab",
        defaultValue:"null",
        deprecated:null,
        type:"attr",
        definingClass:"class:TabSet",
        valueType:"boolean",
        description:"Should tabs exceeding ${isc.DocUtils.linkForRef('attr:TabSet.moreTabCount')} be shown on a \"more\" tab?\n <p>\n This setting is used to emulate an iPhone-style tab bar \"more\" button.",
        flags:"IR",
        name:"showMoreTab"
    },
    "classMethod:Time.setShortDisplayFormat":{
        seeAlso:[
        ],
        ref:"classMethod:Time.setShortDisplayFormat",
        deprecated:null,
        type:"classMethod",
        definingClass:"class:Time",
        params:[
            {
                defaultValue:null,
                optional:false,
                type:"TimeDisplayFormat | FormatString | Function",
                description:"Optional custom  formatter to use. Will accept a function (which will be passed a pointer to the\n  Date to format), a format string, or a string designating a standard formatter",
                name:"formatter"
            }
        ],
        description:" Sets the default format for strings returned by ${isc.DocUtils.linkForRef('classMethod:Time.toShortTime')}.\n",
        flags:"",
        name:"setShortDisplayFormat"
    },
    "attr:Canvas.locatePeersType":{
        seeAlso:[
        ],
        defaultValue:"null",
        type:"attr",
        definingClass:"class:Canvas",
        groups:[
            "autoTest"
        ],
        deprecated:null,
        ref:"attr:Canvas.locatePeersType",
        valueType:"LocatorTypeStrategy",
        description:"${isc.DocUtils.linkForRef('type:LocatorTypeStrategy')} to use when finding peers of this canvas.",
        flags:"IRWA",
        name:"locatePeersType"
    },
    "method:ListGrid.cellContextClick":{
        seeAlso:[
        ],
        type:"method",
        definingClass:"class:ListGrid",
        returns:{
            type:"boolean",
            description:"whether to cancel the event"
        },
        groups:[
            "events"
        ],
        ref:"method:ListGrid.cellContextClick",
        deprecated:null,
        params:[
            {
                defaultValue:null,
                optional:false,
                type:"ListGridRecord",
                description:"cell record as returned by getCellRecord",
                name:"record"
            },
            {
                defaultValue:null,
                optional:false,
                type:"number",
                description:"row number for the cell",
                name:"rowNum"
            },
            {
                defaultValue:null,
                optional:false,
                type:"number",
                description:"column number of the cell",
                name:"colNum"
            }
        ],
        description:" Called when a cell receives a contextclick event.\n\n",
        flags:"",
        examples:[
            "${isc.DocUtils.linkForExampleId('cellClicks')}"
        ],
        name:"cellContextClick"
    },
    "attr:IconButton.showMenuIconOver":{
        seeAlso:[
        ],
        ref:"attr:IconButton.showMenuIconOver",
        defaultValue:"true",
        deprecated:null,
        type:"attr",
        definingClass:"class:IconButton",
        valueType:"Boolean",
        description:"Whether to show an Over version of the ${isc.DocUtils.linkForRef('attr:IconButton.menuIconSrc','menuIcon')}.",
        flags:"IRW",
        name:"showMenuIconOver"
    },
    "attr:PickList.clickMaskMode":{
        seeAlso:[
        ],
        ref:"attr:PickList.clickMaskMode",
        defaultValue:"\"hard\"",
        deprecated:null,
        type:"attr",
        definingClass:"interface:PickList",
        valueType:"ClickMaskMode",
        description:"Determines the behavior of the click-mask thrown up when this pickList is visible.\n <P>\n The default value, \"hard\", matches the familiar behavior of combos and selects on \n Windows, Mac and other platforms - mouse-events such as rollovers are blocked and, when \n a click is received, the picker is hidden and the event is cancelled.\n <P>\n When <code>clickMaskMode</code> is \"soft\", mouse-events continue to fire, meaning that \n rollover styles, for example, continue to be updated.  When a click is received in this\n mode, the picker is hidden and the click event is allowed to proceed to its target - \n this means that clicking an item with an open picker will re-open the picker.",
        flags:"IRW",
        name:"clickMaskMode"
    },
    "group:mobileDevelopment":{
        refs:[
            "classMethod:Page.getOrientation",
            "classMethod:Page.updateViewport"
        ],
        seeAlso:[
        ],
        ref:"group:mobileDevelopment",
        treeLocation:[
            "Concepts"
        ],
        deprecated:null,
        type:"group",
        title:"Mobile Application Development",
        description:"SmartClient is designed to automatically adapt to smaller screen sizes and the lower\n accuracy of touch-based interfaces.  \n <p>\n In general, a SmartClient application written with complete ignorance of mobile development\n will still be highly usable on tablet or handset-sized touch devices.  This topic explains\n all the automatic behaviors that make this possible, and the few areas developers need to\n consider in order to optimize the mobile experience, the most important being:\n <p>\n <ul>\n <li> read about potential issues created by the automatically shown and hidden browser\n      toolbars in Safari on iOS7+, discussed under \"minimal-ui\" below.  SmartClient\n      automatically handles this, but most applications will want to create a non-interactive\n      banner to fill the blank screen area that is rendered unusable by iOS' behavior\n <li> read about \"Automatic touch scrolling\" below - if your application does not already\n      have alternative UIs for performing drag operations (as is required anyway for\n      ${isc.DocUtils.linkForRef('group:accessibility','accessibility reasons')}), this section discusses options for\n      controlling drag scrolling vs dragging of data\n <li> review your application for the rare screen that has a fixed, very wide width and\n      doesn't allow scrolling.  Such screens would already be unusable for narrow desktop\n      browsers but are more of a problem for fixed-size mobile screens.  The section\n      \"Exceptionally wide screens\" below explains strategies for dealing with this.\n </ul>\n <p>\n <h3>Supported Browsers</h3>\n <P>\n <ul>\n <li> Safari on iOS devices (iPad, iPhone, iPod Touch)\n <li> Android's default (WebKit-based) browser <b>*</b>\n <li> Windows Phone default browser, latest release only <b>**</b>\n <li> Blackberry 10+ default (WekKit-based) browser <b>**</b>\n </ul>\n <b>*</b>: Android issues that occur <i>exclusively</i> on rare devices (under a certain\n percent of market share) will not normally be covered by a Support plan.  This is a\n necessity because highly customized versions of Android are used for a variety of niche\n devices (even microsatellites)<br>\n <b>**</b>: These browsers generally work and bug reports are accepted, but they do not yet\n fall under the normal Enterprise+ Support guarantee of fixing every confirmed bug \n <p>\n If you would like to check whether a specific device falls under normal Support, or would\n like a quote for a Support plan that would include a specific device or platform,\n <a href='http://smartclient.com/company/contact.jsp' target='_blank'>contact Isomorphic here</a>.\n <P>\n <h3>Adaptive Components</h3>\n <p>\n Many SmartClient components automatically change their behavior and/or appearance when used\n with touch devices in general, or tablets and handsets specifically.  There are too many\n adaptations to comprehensively list, but some of the more obvious behaviors are listed below:\n <ul>\n <li> ${isc.DocUtils.linkForRef('class:SelectItem')} and ${isc.DocUtils.linkForRef('class:ComboBoxItem')} controls automatically fill the entire screen\n      or a major portion of the screen when activated, and add a control to dismiss the\n      full-screen interface.  See ${isc.DocUtils.linkForRef('attr:ComboBoxItem.pickListPlacement')} for details\n <li> ${isc.DocUtils.linkForRef('class:Menu')} components likewise fill the entire screen or a major portion, and offer\n      submenu navigation via a slide-in animation and back button instead of displaying the\n      origin menu and submenu simultaneously\n <li> ${isc.DocUtils.linkForRef('attr:Calendar.minimalUI','Calendar')} eliminates the tabs normally used to switch between\n      Day, Week and Month view, instead using device pivot to switch between Day and Week\n      views and offering a compact link to Month view\n <li> Windows and Dialogs fill the screen by default and remove rounded edges to save space\n <li> many controls implement an expanded hit area for clicks or drags so that finger touches\n      that are technically outside of the drawn area of the control still activate the\n      control.  This accomodates the imprecision of finger touches as compared to mouse\n      clicks, while still showing the same compact appearance as is used for desktop\n      interfaces.  This includes the ${isc.DocUtils.linkForRef('class:Slider')} thumb, ${isc.DocUtils.linkForRef('attr:Window.headerControls')},\n      ${isc.DocUtils.linkForRef('attr:Canvas.resizeFrom','edge-based resizing')}, and many other controls.\n <li> ${isc.DocUtils.linkForRef('class:SpinnerItem')} switches to side-by-side +/- controls instead of the very small,\n      vertically stacked +/- control typical of desktop interfaces\n <li> ${isc.DocUtils.linkForRef('class:AdaptiveMenu')} can either display menu items inline, or in a drop-down,\n        or mix the two modes according to available space.\n </ul>\n <p>\n In addition to automatic behavior, SmartClient offers Adaptive Layout whereby a ${isc.DocUtils.linkForRef('class:Layout')}\n member may be <i>designed</i> to render itself at multiple possible sizes, in order to fit\n into the amount of space available in the Layout.  Unlike simply indicating a flexible size\n on a member, setting an adaptive width or height indicates that the member has two (or more)\n different <i>ways</i> of rendering itself with different <i>discrete</I> sizes, but does not\n have the ability to use every additional available pixel.\n <p>\n For more guidance, see the documentation under ${isc.DocUtils.linkForRef('attr:Canvas.canAdaptWidth')} and the\n ${isc.DocUtils.linkForExampleId('inlinedMenuMobileSample', 'Inlined Menu Mobile')} and \n ${isc.DocUtils.linkForExampleId('adaptiveMenuMobileSample', 'Adaptive Menu')} samples.\n <p>\n <h3>Finger / touch event handling</h3>\n <P>\n Mobile and touch devices support \"touch events\" that correspond to finger actions on the\n screen.  By default, SmartClient simply sends touch events to UI components as normal mouse\n events.  Specifically:\n <ul>\n <li> a finger tap gesture will trigger mouseDown, mouseUp and click events\n <li> a touch-and-slide interaction will trigger drag and drop, firing the normal SmartClient\n      sequence of dragStart, dragMove, and dragStop\n <li> a touch-and-hold interaction will trigger a contextMenu event, and will trigger a hover\n      if no contextMenu is shown\n </ul>\n This means that most applications that are written with mouse interaction in mind will\n function with a touch-based UI without special efforts.  Some interfaces which rely heavily\n on mouse hovers may want to display instructions to explicitly tell the user that they have\n to touch a given element to see more information.\n <p>\n <h3>Automatic touch scrolling</h3>\n <p>\n Components that normally show scrollbars on desktop browsers will, by default, hide\n scrollbars and allow scrolling via finger dragging instead.\n <p>\n If you are using drag and drop features such as ${isc.DocUtils.linkForRef('attr:ListGrid.canReorderRecords')}, this\n obviously conflicts with using finger drags for scrolling.  There are two options:\n <p>\n <ol>\n <li> Leave touch scrolling active for the grid, but provide additional controls, such as\n      buttons, that enable users to perform the drag operation in a different way.\n      Optionally display scrollbars <em>in addition to</em> leaving touch scrolling active\n      by setting ${isc.DocUtils.linkForRef('attr:Canvas.alwaysShowScrollbars')} to <code>true</code>.\n <li> Set ${isc.DocUtils.linkForRef('attr:Canvas.useTouchScrolling','useTouchScrolling')} to <code>false</code> on the component.\n      Scrollbars will be shown, and finger drags will no longer cause scrolling, so that\n      finger drags can now be used for the drag and drop operation configured on the\n      component\n </ol>\n Option #1 above is generally preferred, since it is also considered an\n ${isc.DocUtils.linkForRef('group:accessibility')} violation if drag and drop is the sole way to trigger an\n operation (keyboard-only users cannot use drag and drop), and also because scrollbars are\n not usually found in touch interfaces.\n <p>\n If your application is not required to be keyboard accessible, and you prefer to show\n scrollbars and use finger drags for normal drag operations, you can use\n ${isc.DocUtils.linkForRef('attr:Canvas.disableTouchScrollingForDrag')} to make this choice system-wide or on a\n per-component-type basis.\n <p>\n <h3>Exceptionally wide screens / forms</h3>\n <p>\n If you have designed a screen for desktop use and it is too wide to fit on a handset or\n tablet-sized screen, there are several possible strategies:\n <ul>\n <li> <b>use ${isc.DocUtils.linkForRef('class:SplitPane')}</b>: any time you have two or more panes where a choice in one\n      pane decides what is displayed in the other.  See the \"SplitPane\" section further down\n      for details\n <li> <b>rely on horizontal scrolling</b>: if you have something like a ${isc.DocUtils.linkForRef('class:DynamicForm')}\n      that has 3 columns of input fields, as long as the form itself or some parent has\n      ${isc.DocUtils.linkForRef('attr:Canvas.overflow','overflow:\"auto\"')} set, horizontal touch scrolling will be\n      available to reach fields that initially render offscreen.  Most of the time, there is\n      already an <code>overflow:\"auto\"</code> parent component as a result of default\n      framework behaviors or application settings that also make sense for desktop mode,\n      so nothing needs to be done.\n      <p>\n      However, consider whether scrolling is already in use for other purposes: if you have a\n      grid plus an adjacent component to the right, if the adjacent component is entirely\n      offscreen, attempting touch scrollng on the grid will just scroll the grid as such and\n      won't reveal the adjacent component.  In this kind of situation, you can:\n   <ul>\n   <li> <i>use ${isc.DocUtils.linkForRef('class:SplitPane')}</i> as described above, a grid with something adjacent is\n        frequently a good candidate for conversion to <code>SplitPane</code>\n   <li> <i>make the scrolling component smaller or flexible size</i>.  Whether it's a grid or\n        other scrollable component on the left, this situation usually arises because an\n        inappropriately large fixed size has been set, instead of a\n        ${isc.DocUtils.linkForRef('attr:Canvas.width','flexible size')}.\n   <li> <i>leave some blank space</i> above or below the grid - this gives the user somewhere\n        to use touch scrolling to move both the grid and adjacent component\n   <li> <i>force scrollbars to appear</i> by setting\n        ${isc.DocUtils.linkForRef('attr:Canvas.useTouchScrolling','useTouchScrolling')} to false.  This is another way to\n        give the user a place they can touch in order to scroll the both the grid and\n        adjacent component together\n   </ul>\n <li> <b>use ${isc.DocUtils.linkForRef('class:FlowLayout')}</b>: a <code>FlowLayout</code> can automatically take two\n      side-by-side elements and switch them to vertical stacking when the screen is narrow\n </ul>\n <p>\n <h3>SplitPane</h3>\n <p>\n The ${isc.DocUtils.linkForRef('class:SplitPane')} component implements the common pattern of rendering\n two or three panes simultaneously on desktop machines and on tablets in landscape\n orientation, while switching to showing a single pane for handset-sized devices or tablets\n in portrait orientation.\n <p>\n Use <code>SplitPane</code> anywhere you have two or more panes in your application where a\n choice in one pane decides what is displayed in the other pane.  For example, you may have a\n list of Records where details of a single selected Record are shown next to the list.  A\n <code>SplitPane</code> is well-suited to this interface since it provides automatic \"Back\"\n navigation and a place to show the title of the selected record when only the detail view is\n showing.\n <p>\n Note that you do not need to use a <code>SplitPane</code> as your top-level component\n containing the whole application, and it <i>does</i> makes sense to use multiple\n <code>SplitPane</code> components in a single application.  For example, your top-level\n container component might be a ${isc.DocUtils.linkForRef('class:TabSet')}, and a ${isc.DocUtils.linkForRef('class:SplitPane')} would be used to manage\n components in tabs which normally show 2 panes side-by-side on desktop browsers.\n <P>\n <h3>Device type and overriding</h3>\n <p>\n In most cases SmartClient will correctly detect the device running your application, and set\n the flags ${isc.DocUtils.linkForRef('classAttr:Browser.isTouch')}, ${isc.DocUtils.linkForRef('classAttr:Browser.isHandset')}, ${isc.DocUtils.linkForRef('classAttr:Browser.isTablet')} and\n ${isc.DocUtils.linkForRef('classAttr:Browser.isDesktop')} appropriately.\n <p>\n For any uncommon device for which these variables are not set correctly, you can use\n ${isc.DocUtils.linkForRef('classMethod:Browser.setIsTablet')}, ${isc.DocUtils.linkForRef('classMethod:Browser.setIsHandset')} and ${isc.DocUtils.linkForRef('classMethod:Browser.setIsTouch')}\n to override the auto-detected settings.  If you use these APIs, call them <b>before</b>\n creating or drawing any SmartClient components or using any other SmartClient APIs.\n <p>\n Note that the various automatic behaviors triggered by flags on the ${isc.DocUtils.linkForRef('class:Browser')} class can\n be overriden at a fine-grained level on individual components.  For example,\n ${isc.DocUtils.linkForRef('class:SplitPane')} will use 2-pane display when a tablet is detected, however, for a\n particularly large, high-resolution tablet device, you could instead use 3-pane display by\n setting ${isc.DocUtils.linkForRef('attr:SplitPane.deviceMode')} to \"desktop\".\n <p>\n <h3>Mobile look and feel</h3>\n <P>\n We recommend using either the Tahoe, Stratus or Obsidian skins for applications\n that support mobile (or a custom skin based on one of these skins).  These skins make\n maximum use of CSS3 to minimize the number of images that need to be loaded and the number\n of DOM elements used to create components.\n <p>\n We also do <b>not</b> recommend attempting to mimic the native UI of each particular mobile\n platform, because:\n <ul>\n <li> if users access the same application via desktop and mobile browsers, consistent\n appearance and behavior between the desktop and mobile rendering of the application is more\n important for familiarity than looking similar to other applications on the mobile device\n <li> mobile platform design overhauls, such as the major changes from iOS6 to iOS7, can\n easily invalidate efforts to look like native applications on the device\n <li> there is no single consistent appearance across Android devices because different\n manufacturers customize the platform a great deal, so efforts to closely mimic any one\n device won't yield any real consistency\n </ul>\n <P>\n <h3>iOS 7, browser toolbars and \"minimal-ui\" setting</h3>\n <p>\n Safari in iOS 7.0 will automatically hide and show browser toolbars as the user scrolls\n around a normal web page, pivots, or touches near edges of the screen.  This creates serious\n problems for web applications, partly because notifications are not reliably fired when\n toolbars are shown and hidden, and partly because it introduces \"dead zones\" where an\n application cannot place interactive controls, since touching there shows browser toolbars\n instead.\n <p>\n iOS 7.1 introduces a \"minimal-ui\" setting on the viewport <code>meta</code> tag which\n eliminates most of these problems, by requiring that the user specifically touch the \n URL bar to reveal browser toolbars.  Even with this setting, the top 20px of space <i>in\n landscape orientation only</i> is still a \"dead zone\".\n <p>\n SmartClient automatically uses the minimal-ui setting whenever iOS is detected, and also\n sets ${isc.DocUtils.linkForRef('classAttr:Canvas.defaultPageSpace')} to 20px in landscape orientation to avoid components\n being placed in the dead zone.  These default behaviors can be disabled by defining the\n <code>isc_useMinimalUI</code> global variable with the value <code>false</code> before the\n framework is loaded: \n <pre> &lt;script type=\"text/javascript\"&gt;\n window.isc_useMinimalUI = false;\n &lt;/script&gt;</pre>\n <p>\n Whether minimal-ui is used or not, it is recommend to place some kind of non-interactive\n widget or content in the dead zones created by browser toolbars, for example, a ${isc.DocUtils.linkForRef('class:Label')}\n showing your company name or application name.  When using ${isc.DocUtils.linkForRef('classAttr:Canvas.defaultPageSpace')} to have\n all components avoid a dead zone at the top of the page, you can set\n ${isc.DocUtils.linkForRef('attr:Canvas.leavePageSpace','leavePageSpace:0')} to allow individual components to place\n themselves in a dead zone.\n <p>\n <h3>Configuring the viewport</h3>\n <p>\n When a SmartClient application loads, by default a viewport &ltmeta&gt; tag is added to the\n page which, on touch devices, fixes the page zoom to 100% and disables the pinch-zoom gesture.\n This is usually the expected behavior of a touch-enabled web application because it makes\n the application look and feel more like a native app. This default setting can be disabled\n by defining the <code>isc_useDefaultViewport</code> global variable with the value\n <code>false</code> before the framework is loaded:\n <pre> &lt;script type=\"text/javascript\"&gt;\n window.isc_useDefaultViewport = false;\n &lt;/script&gt;</pre>\n For more information on the mobile device viewport, see:\n <ul>\n <li><a href='http://developer.apple.com/safari/library/documentation/AppleApplications/Reference/SafariWebContent/UsingtheViewport/UsingtheViewport.html' target='_blank'>Configuring the Viewport - Safari Web Content Guide</a></li>\n <li><a href='https://developer.mozilla.org/en-US/docs/Mozilla/Mobile/Viewport_meta_tag' target='_blank'>Using the viewport meta tag to control layout on mobile browsers - MDN</a></li>\n </ul>\n <p>\n <h3>Orientation Change &amp; Screen Size</h3>\n <P>\n When orientation changes, this is treated identically to resizing the browser on a desktop\n machine.  If you've already created a UI that fills the browser and makes good use of\n available screen space for desktop browsers, the same behaviors will automatically apply\n when your application runs on mobile devices and the device is pivoted.\n <P>\n If you want to build specialized interfaces that respond to device orientation, the\n ${isc.DocUtils.linkForRef('classMethod:Page.getOrientation')} API may be used to determine the current orientation of the\n application, and ${isc.DocUtils.linkForRef('type:PageEvent','the page orientationChange event')} will fire whenever the\n user rotates the screen allowing applications or components to directly respond to the user\n pivoting their device.\n <p>\n <h3>Launching native helper apps (phone, facetime, maps..)</h3>\n <p>\n Generally, all that's required to launch native mobile apps is to create an ordinary HTML\n hyperlink (<code>&lt;a&gt;</code> tag) with a special prefix for the URL specified in the\n <code>href</code> attribute.  For example, the following HTML link will place a call when\n the user finger-taps it:\n <pre>\n   &lt;a href=\"tel:8675309\"&gt;Call Jenny&lt;/a&gt;</pre>\n You can provide HTML like this as ${isc.DocUtils.linkForRef('attr:HTMLFlow.contents')}.  Or use a field of\n ${isc.DocUtils.linkForRef('type:FieldType','type:\"link\"')} to cause various\n ${isc.DocUtils.linkForRef('interface:DataBoundComponent','DataBoundComponents')} to render a DataSourceField value as a\n clickable URL.\n <p>\n The URL prefixes that are valid for iOS are documented \n <a href='https://developer.apple.com/library/ios/featuredarticles/iPhoneURLScheme_Reference/Introduction/Introduction.html#//apple_ref/doc/uid/TP40007899-CH1-SW1' target='_blank'>at Apple.com</a>.\n Typically, the same prefixes also work for Android, Windows Phone and others.\n <p>\n <h3>Configure the soft keyboard</h3>\n <p>\n ${isc.DocUtils.linkForRef('attr:TextItem.browserInputType')} can be set to various values such as \"email\" or \"tel\"\n (telephone number) to hint to mobile devices to use a different software keyboard with\n specialized keys appropriate for entering certain types of data values.\n <p>\n <h3>Note on mobile platform performance</h3>\n <p>\n When the first modern smartphones were released, it was necessary to use tiny,\n mobile-specific frameworks to get adequate performance for mobile web applications.\n <p>\n The situation is now completely different: through a combination of hardware improvements,\n optimizations in mobile browsers and vastly improved network speeds, typical mobile devices\n are easily able to run applications built with full-featured web platforms like SmartClient.\n For an application that supports both desktop and mobile interfaces, the worst case scenario\n for platform performance is often <b>not</b> a mobile phone, but an older desktop machine\n running Internet Explorer.\n <p>\n Unfortunately, there is a lot of out-of-date advice on the web about mobile web development\n that still advises using ultra-light, feature-poor frameworks for performance reasons.\n Carefully consider the source and recency of any such advice - the reality is that using\n such feature-poor frameworks means you will under-deliver with both your desktop <i>and</i>\n mobile interfaces.\n <p>\n For more background on choosing the right technologies for mobile and desktop web\n applications, see the \n <a href='http://smartclient.com/product/mobileStrategy.jsp' target='_blank'>Mobile Strategy Page</a> at\n smartclient.com.\n <P>\n <h3>Offline Operation</h3>\n <P>\n SmartClient applications support \"offline\" operation (continuing to work without network\n access).\n <P>\n Permanent caching of resources such as .js, .css files and images are handled via the standard\n <a href='https://www.google.com/search?q=html5+manifest' target='_blank'>HTML5 Manifest</a> - just list all\n the static files your application needs in a manifest file and mobile browsers will cache\n those resources.\n <P>\n Dynamic data is handled via the ${isc.DocUtils.linkForRef('class:Offline')} APIs as well as special DataSource support\n enabled by ${isc.DocUtils.linkForRef('attr:DataSource.useOfflineStorage')}.\n <P>\n The end result is that you can bookmark a SmartClient application to a phone's home screen\n and use it offline with cached data, much like an installed native application.\n <P>\n <h2>Packaging as a native application</h2>\n <P>\n Via \"packaging\" technologies such as PhoneGap/Cordova and Titanium, a SmartClient web application\n can be packaged as an installable native application that can be delivered via the \"App Store\"\n for the target mobile platform.  Applications packaged in this way have access to phone-specific\n data and services such as contacts stored on the phone, or the ability to invoke the device's camera.\n <P>\n Both Titanium and PhoneGap provide access to the underlying native device APIs such as the\n accelerometer, geolocation, and UI. Both frameworks enable application development using\n only JavaScript, CSS and HTML. Additionally they provide development environments that work\n across a wide variety of devices.\n <P>\n PhoneGap has good support for native device APIs as noted <a href='http://www.phonegap.com/about/feature' target='_blank'>here</a>.\n Titanium has similar support. There are differences between the two environments and how they\n expose their APIs, though both provide Xcode-compatible projects that can be compiled and run from the Xcode IDE.\n See ${isc.DocUtils.linkForRef('group:titaniumIntegration','Integration with Titanium')} and ${isc.DocUtils.linkForRef('group:phonegapIntegration','Integration with PhoneGap')}\n for more information.",
        name:"mobileDevelopment"
    },
    "attr:ServerObject.className":{
        seeAlso:[
            {
                ref:"attr:ServerObject.lookupStyle",
                description:null
            },
            {
                ref:"attr:ServerObject.ID",
                description:null
            },
            {
                ref:"classMethod:DMI.call",
                description:null
            }
        ],
        defaultValue:"null",
        type:"attr",
        definingClass:"object:ServerObject",
        deprecated:null,
        ref:"attr:ServerObject.className",
        valueType:"String",
        description:"Specifies the fully-qualified class name that provides the server-side endpoint of the DMI\n (${isc.DocUtils.linkForRef('attr:ServerObject.lookupStyle')}:\"new\") or the class name of the factory that produces the\n DMI instance (${isc.DocUtils.linkForRef('attr:ServerObject.lookupStyle')}:\"factory\").\n <p>\n This is one of the values that you need to pass to ${isc.DocUtils.linkForRef('classMethod:DMI.call')} to invoke the DMI from\n the client.\n <p>\n The value of this attribute is used for <code>\"new\"</code> and <code>\"factory\"</code>\n values of ${isc.DocUtils.linkForRef('attr:ServerObject.lookupStyle')}.\n <p>\n It is also used for <code>\"cdi\"</code> value of ${isc.DocUtils.linkForRef('attr:ServerObject.lookupStyle')}, to provide \n class name of the bean to ask CDI to create.",
        flags:"IR",
        serverDS:"only",
        name:"className"
    },
    "group:grouping":{
        refs:[
            "method:Calendar.groupLanesBy",
            "method:ListGridField.getGroupValue",
            "method:ListGridField.getGroupTitle",
            "method:ListGrid.groupSortNormalizer",
            "method:ListGrid.getGroupMembers",
            "method:ListGrid.groupBy",
            "method:ListGrid.getOriginalData",
            "method:ListGrid.handleGroupBy",
            "method:ListGrid.groupByComplete",
            "method:ListGrid.handleRegroup",
            "method:ListGrid.groupTreeChanged",
            "object:GroupNode",
            "object:GroupSpecifier",
            "attr:Calendar.laneGroupStartOpen",
            "attr:GroupNode.groupMembers",
            "attr:GroupNode.groupTitle",
            "attr:GroupNode.groupValue",
            "attr:GroupNode.groupName",
            "attr:ListGrid.originalData",
            "attr:ListGrid.groupTree",
            "attr:ListGrid.groupStartOpen",
            "attr:ListGrid.canCollapseGroup",
            "attr:ListGrid.collapseGroupOnRowClick",
            "attr:ListGrid.groupTitleField",
            "attr:ListGrid.showGroupSummaryInHeader",
            "attr:ListGrid.showCollapsedGroupSummary",
            "attr:ListGridField.groupingModes",
            "attr:ListGridField.groupingMode",
            "attr:ListGridField.defaultGroupingMode",
            "attr:ListGridField.groupPrecision",
            "attr:ListGridField.groupGranularity",
            "attr:ListGrid.groupNodeStyle",
            "attr:ListGrid.groupNodeBaseStyle",
            "attr:ListGrid.groupIcon",
            "attr:ListGrid.groupIconSize",
            "attr:ListGrid.groupIndentSize",
            "attr:ListGrid.groupLeadingIndent",
            "attr:ListGrid.canGroupBy",
            "attr:ListGrid.groupByMaxRecords",
            "attr:ListGrid.isGrouped",
            "attr:ListGrid.nullGroupTitle",
            "attr:ListGrid.groupByField",
            "attr:ListGrid.sortByGroupFirst",
            "attr:ListGrid.groupSortDirection"
        ],
        seeAlso:[
        ],
        ref:"group:grouping",
        deprecated:null,
        type:"group",
        description:null,
        name:"grouping"
    },
    "attr:Window.printBodyStyle":{
        seeAlso:[
        ],
        ref:"attr:Window.printBodyStyle",
        defaultValue:"\"printHeader\"",
        deprecated:null,
        type:"attr",
        definingClass:"class:Window",
        valueType:"CSSStyleName",
        description:"Style for the Window body in printed output.",
        flags:"IR",
        name:"printBodyStyle"
    },
    "attr:RadialGradient.cy":{
        seeAlso:[
        ],
        ref:"attr:RadialGradient.cy",
        defaultValue:"null",
        deprecated:null,
        type:"attr",
        definingClass:"object:RadialGradient",
        valueType:"String",
        description:"y coordinate of outer radial",
        flags:"IR",
        name:"cy"
    },
    "attr:Calendar.baseStyle":{
        seeAlso:[
        ],
        defaultValue:"\"calendar\"",
        type:"attr",
        definingClass:"class:Calendar",
        groups:[
            "appearance"
        ],
        deprecated:null,
        ref:"attr:Calendar.baseStyle",
        valueType:"CSSStyleName",
        description:"The base name for the CSS class applied to the grid cells of the day and week views\n of the calendar. This style will have \"Dark\", \"Over\", \"Selected\", or \"Disabled\"\n appended to it according to the state of the cell.\n <P>\n See ${isc.DocUtils.linkForRef('group:cellStyleSuffixes')} for details on how stateful suffixes are combined with the\n base style to generate stateful cell styles.",
        flags:"IRW",
        name:"baseStyle"
    },
    "method:FacetChart.legendClick":{
        seeAlso:[
        ],
        ref:"method:FacetChart.legendClick",
        deprecated:null,
        type:"method",
        definingClass:"class:FacetChart",
        params:[
            {
                defaultValue:null,
                optional:false,
                type:"FacetValue",
                description:"facetValue that was clicked, or null if click was in        empty space",
                name:"facetValue"
            },
            {
                defaultValue:null,
                optional:false,
                type:"FacetValue",
                description:"for a multi-axis chart, facetValue representing        the clicked metric.  Null if click is in empty space or chart is not  multi-axis",
                name:"metricFacetValue"
            }
        ],
        description:" Fires when the user clicks on the legend area of the chart.\n <p>\n If the user specifically clicks on a color swatch or it's label, the ${isc.DocUtils.linkForRef('object:FacetValue')}\n clicked on will be provided.\n <p>\n If the chart is a ${isc.DocUtils.linkForRef('attr:FacetChart.extraAxisMetrics','multi-axis chart')}, the\n ${isc.DocUtils.linkForRef('object:FacetValue')} for the clicked-on metric will also be provided.\n",
        flags:"",
        examples:[
            "${isc.DocUtils.linkForExampleId('drillCharting')}"
        ],
        name:"legendClick"
    },
    "attr:LoadProjectSettings.drawFirstScreen":{
        seeAlso:[
        ],
        ref:"attr:LoadProjectSettings.drawFirstScreen",
        defaultValue:"true",
        deprecated:null,
        type:"attr",
        definingClass:"object:LoadProjectSettings",
        valueType:"boolean",
        description:"Determines whether the ${isc.DocUtils.linkForRef('attr:LoadProjectSettings.currentScreenName')} screen is drawn after all screens have been loaded.",
        flags:"IRW",
        name:"drawFirstScreen"
    },
    "method:Canvas.dragResizeMove":{
        groups:[
            "widgetEvents"
        ],
        seeAlso:[
            {
                ref:"method:Canvas.getOffsetX",
                description:null
            },
            {
                ref:"method:Canvas.getOffsetY",
                description:null
            },
            {
                ref:"classMethod:EventHandler.getDragRect",
                description:null
            }
        ],
        ref:"method:Canvas.dragResizeMove",
        deprecated:null,
        type:"method",
        definingClass:"class:Canvas",
        description:"\n Executed every time the mouse moves while drag-resizing. If this method\n does not return false, the ${isc.DocUtils.linkForRef('attr:Canvas.dragTarget')} (or outline if\n ${isc.DocUtils.linkForRef('attr:Canvas.dragAppearance')} is set to \"outline\") will automatically be moved as appropriate\n whenever the mouse moves.\n\n",
        flags:"A",
        returns:{
            type:"boolean",
            description:"false to suppress auto-resize of the ${isc.DocUtils.linkForRef('attr:Canvas.dragTarget')} or outline."
        },
        name:"dragResizeMove"
    },
    "attr:EditContext.useCopyPasteShortcuts":{
        seeAlso:[
        ],
        ref:"attr:EditContext.useCopyPasteShortcuts",
        defaultValue:"null",
        deprecated:null,
        type:"attr",
        definingClass:"class:EditContext",
        valueType:"Boolean",
        description:"If set, auto-enables ${isc.DocUtils.linkForRef('attr:EditProxy.useCopyPasteShortcuts')} on the ${isc.DocUtils.linkForRef('class:EditProxy')} for the\n ${isc.DocUtils.linkForRef('method:EditContext.getRootEditNode','root editNode')}.  This works whether there is currently a root editNode\n or one is added later.",
        flags:"IR",
        name:"useCopyPasteShortcuts"
    },
    "attr:Dialog.styleName":{
        seeAlso:[
        ],
        defaultValue:"\"dialogBackground\"",
        type:"attr",
        definingClass:"class:Dialog",
        groups:[
            "appearance"
        ],
        deprecated:null,
        ref:"attr:Dialog.styleName",
        valueType:"CSSStyleName",
        description:"Style of the Dialog background",
        flags:"IRW",
        name:"styleName"
    },
    "attr:UserTask.targetView":{
        seeAlso:[
            {
                ref:"attr:UserTask.inlineView",
                description:null
            }
        ],
        ref:"attr:UserTask.targetView",
        defaultValue:"null",
        deprecated:null,
        type:"attr",
        definingClass:"class:UserTask",
        valueType:"Canvas | String",
        description:"Widget that should be shown to allow user input.  If this widget is a DynamicForm,\n it will also be automatically used as the ${isc.DocUtils.linkForRef('attr:UserTask.targetForm')} unless either\n <code>targetForm</code> or ${isc.DocUtils.linkForRef('attr:UserTask.targetVM')} is set.\n <P>\n <code>UserTask</code> will automatically handle various scenarios of the\n <code>targetView</code> not currently visible or draw()n, according to the following\n rules:\n <ul>\n <li> if the view itself is marked hidden, it will be show()n\n <li> if the view is inside a hidden parent, the parent will be show()n\n <li> if the view is the ${isc.DocUtils.linkForRef('attr:Tab.pane')} of a tab in a TabSet, the tab will be selected\n <li> if the view is listed in ${isc.DocUtils.linkForRef('attr:SectionStackSection.items')} for a which is either\n      collapsed or hidden section, the section will be shown and expanded\n <li> if the view is listed in ${isc.DocUtils.linkForRef('attr:Window.items')} for a Window, the Window will be shown\n <li> if any of these conditions apply to any parent of the targetView, the rules will be\n      applied to that parent as well.  For example, the targetView is in a collapsed section\n      inside a tab which is not selected, the section will be expanded <b>and</b> the tab\n      selected\n </ul>",
        flags:"IR",
        name:"targetView"
    },
    "attr:ListGrid.headerMenuButton":{
        seeAlso:[
        ],
        defaultValue:"null",
        type:"attr",
        definingClass:"class:ListGrid",
        groups:[
            "headerMenuButton"
        ],
        deprecated:null,
        ref:"attr:ListGrid.headerMenuButton",
        valueType:"AutoChild StatefulCanvas",
        description:"If ${isc.DocUtils.linkForRef('attr:ListGrid.showHeaderMenuButton')} is true, when the user rolls over the header buttons in this\n grid the headerMenuButton will be shown over the header button in question. When clicked\n this button will display the standard header context menu (see\n ${isc.DocUtils.linkForRef('method:ListGrid.displayHeaderContextMenu')}).\n <P>\n ${isc.DocUtils.linkForRef('group:headerMenuButton','Several properties')} exist to customize the appearance of the\n headerMenuButton. Also see the ${isc.DocUtils.linkForRef('type:AutoChild')} documentation for information on how\n to make free-form modifications to autoChild widgets",
        flags:"RA",
        name:"headerMenuButton"
    },
    "attr:DrawSector.radius":{
        seeAlso:[
        ],
        ref:"attr:DrawSector.radius",
        defaultValue:"100",
        deprecated:null,
        type:"attr",
        definingClass:"class:DrawSector",
        valueType:"Distance",
        description:"Radius of the sector.",
        flags:"IR",
        name:"radius"
    },
    "classAttr:LoginDialog.LOGIN_ERROR_MESSAGE":{
        seeAlso:[
        ],
        defaultValue:"\"Invalid username or password\"",
        type:"classAttr",
        definingClass:"class:LoginDialog",
        groups:[
            "i18nMessages"
        ],
        deprecated:null,
        ref:"classAttr:LoginDialog.LOGIN_ERROR_MESSAGE",
        valueType:"HTMLString",
        description:"Default error message displayed on failed login in the dialog shown by\n ${isc.DocUtils.linkForRef('staticMethod:isc.showLoginDialog')}.",
        flags:"IRW",
        name:"LOGIN_ERROR_MESSAGE"
    },
    "method:DrawItem.scaleBy":{
        seeAlso:[
        ],
        ref:"method:DrawItem.scaleBy",
        deprecated:null,
        type:"method",
        definingClass:"class:DrawItem",
        params:[
            {
                defaultValue:null,
                optional:false,
                type:"float",
                description:"scale in the x direction",
                name:"x"
            },
            {
                defaultValue:null,
                optional:false,
                type:"float",
                description:"scale in the y direction",
                name:"y"
            }
        ],
        description:" Scale the shape by the x, y multipliers\n",
        flags:"",
        name:"scaleBy"
    },
    "method:MiniDateRangeItem.hasAdvancedCriteria":{
        groups:[
            "criteriaEditing"
        ],
        seeAlso:[
        ],
        ref:"method:MiniDateRangeItem.hasAdvancedCriteria",
        deprecated:null,
        type:"method",
        definingClass:"class:MiniDateRangeItem",
        description:" Overridden to return true: dateRangeItems always generate AdvancedCriteria.\n",
        flags:"",
        returns:{
            type:"Boolean",
            description:"true"
        },
        name:"hasAdvancedCriteria"
    },
    "attr:LinearGradient.x2":{
        seeAlso:[
        ],
        ref:"attr:LinearGradient.x2",
        defaultValue:"null",
        deprecated:null,
        type:"attr",
        definingClass:"object:LinearGradient",
        valueType:"String",
        description:"X coordinate of the end point. This can be a number or a percentage of the width of the\n bounding box of the DrawItem to which it is applied.",
        flags:"IR",
        name:"x2"
    },
    "attr:ListGrid.clearSortFieldText":{
        seeAlso:[
        ],
        defaultValue:"\"Clear Sort\"",
        type:"attr",
        definingClass:"class:ListGrid",
        groups:[
            "i18nMessages"
        ],
        deprecated:null,
        ref:"attr:ListGrid.clearSortFieldText",
        valueType:"String",
        description:"If we're showing a ${isc.DocUtils.linkForRef('attr:ListGrid.showHeaderContextMenu','headerContextMenu')} for this grid, this\n attribute will be shown as the menu item title to clear an existing sort on this field.",
        flags:"IRW",
        name:"clearSortFieldText"
    },
    "attr:GroupNode.groupMembers":{
        seeAlso:[
            {
                ref:"method:ListGrid.groupBy",
                description:null
            }
        ],
        defaultValue:"see below",
        type:"attr",
        definingClass:"object:GroupNode",
        groups:[
            "grouping"
        ],
        deprecated:null,
        ref:"attr:GroupNode.groupMembers",
        valueType:"Array of ListGridRecord | GroupNode",
        description:"Array of ListGridRecord that belong to this group, or, for multi-field grouping, array\n of groupNodes of subgroups under this groupNode.",
        flags:"R",
        name:"groupMembers"
    },
    "method:Slider.setShowTitle":{
        seeAlso:[
        ],
        ref:"method:Slider.setShowTitle",
        deprecated:null,
        type:"method",
        definingClass:"class:Slider",
        params:[
            {
                defaultValue:null,
                optional:false,
                type:"Boolean",
                description:"show the slider title?",
                name:"showTitle"
            }
        ],
        description:" Sets the ${isc.DocUtils.linkForRef('attr:Slider.showTitle')} property of the slider\n\n",
        flags:"",
        name:"setShowTitle"
    },
    "attr:FormItem.showIconsOnFocus":{
        seeAlso:[
        ],
        defaultValue:"null",
        type:"attr",
        definingClass:"class:FormItem",
        groups:[
            "formIcons"
        ],
        ref:"attr:FormItem.showIconsOnFocus",
        deprecated:null,
        setter:[
            "setShowIconsOnFocus"
        ],
        valueType:"Boolean",
        description:"Show the ${isc.DocUtils.linkForRef('attr:FormItem.icons')} when the item gets focus, and hide them when it loses focus.\n Can be overridden at the icon level by ${isc.DocUtils.linkForRef('attr:FormItemIcon.showOnFocus')}.\n <P>\n Note that icons marked as disabled will not be shown on focus even if this flag is\n true by default. This may be overridden by ${isc.DocUtils.linkForRef('attr:FormItem.showDisabledIconsOnFocus')}.",
        flags:"IRWA",
        name:"showIconsOnFocus"
    },
    "method:Date.toNormalDate":{
        seeAlso:[
        ],
        type:"method",
        definingClass:"object:Date",
        returns:{
            type:"String",
            description:"formatted date string"
        },
        groups:[
            "dateFormatting"
        ],
        deprecated:null,
        ref:"method:Date.toNormalDate",
        params:[
            {
                defaultValue:null,
                optional:false,
                type:"DateDisplayFormat",
                description:"Optional Format for the date returned",
                name:"format"
            }
        ],
        description:" Returns the date as a formatted string using the format set up via the\n <code>setNormalDisplayFormat()</code> method. Note that the default formatter for this\n method is <code>\"toLocaleString\"</code>.\n",
        flags:"",
        name:"toNormalDate"
    },
    "attr:FacetChart.logBase":{
        seeAlso:[
        ],
        ref:"attr:FacetChart.logBase",
        defaultValue:"10",
        deprecated:null,
        type:"attr",
        definingClass:"class:FacetChart",
        valueType:"int",
        description:"When ${isc.DocUtils.linkForRef('attr:FacetChart.useLogGradations')}, base value for logarithmic gradation lines.  Gradation\n lines will be shown at every power of this value plus intervening values specified by\n ${isc.DocUtils.linkForRef('attr:FacetChart.logGradations')}.",
        flags:"IR",
        name:"logBase"
    },
    "method:DrawSector.getCenter":{
        seeAlso:[
        ],
        ref:"method:DrawSector.getCenter",
        deprecated:null,
        type:"method",
        definingClass:"class:DrawSector",
        description:" Returns the sector's ${isc.DocUtils.linkForRef('attr:DrawSector.centerPoint','centerPoint')}.\n",
        flags:"",
        returns:{
            type:"Point",
            description:"the current centerPoint"
        },
        name:"getCenter"
    },
    "attr:ListGrid.missingSummaryFieldValue":{
        seeAlso:[
        ],
        defaultValue:"\"-\"",
        type:"attr",
        definingClass:"class:ListGrid",
        groups:[
            "summaryFields"
        ],
        deprecated:null,
        ref:"attr:ListGrid.missingSummaryFieldValue",
        valueType:"String",
        description:"If a summary format string contains an invalid field reference, replace the reference\n with the missingSummaryFieldValue. The default value is \"-\".",
        flags:"IRW",
        name:"missingSummaryFieldValue"
    },
    "attr:DataBoundComponent.dataFetchMode":{
        seeAlso:[
        ],
        defaultValue:"\"paged\"",
        type:"attr",
        definingClass:"interface:DataBoundComponent",
        groups:[
            "databinding"
        ],
        deprecated:null,
        ref:"attr:DataBoundComponent.dataFetchMode",
        valueType:"FetchMode",
        description:"How to fetch and manage records retrieve from the server.  See ${isc.DocUtils.linkForRef('type:FetchMode')}.\n <P>\n This setting only applies to the ${isc.DocUtils.linkForRef('class:ResultSet')} automatically created by calling\n ${isc.DocUtils.linkForRef('method:ListGrid.fetchData','fetchData()')}.  If a pre-existing ResultSet is passed to setData() instead, it's\n existing setting for ${isc.DocUtils.linkForRef('attr:ResultSet.fetchMode')} applies.",
        flags:"IR",
        name:"dataFetchMode"
    },
    "attr:NavigationBar.rightButton":{
        seeAlso:[
            {
                ref:"attr:NavigationBar.showRightButton",
                description:null
            }
        ],
        ref:"attr:NavigationBar.rightButton",
        defaultValue:"null",
        deprecated:null,
        type:"attr",
        definingClass:"class:NavigationBar",
        valueType:"AutoChild NavigationButton",
        description:"The button displayed to the right of the title in this NavigationBar. By default this\n will be a ${isc.DocUtils.linkForRef('class:NavigationButton')} with ${isc.DocUtils.linkForRef('attr:NavigationButton.direction','direction')} set\n to <code>\"forward\"</code>.\n <p>\n The following ${isc.DocUtils.linkForRef('group:autoChildUsage','passthroughs')} apply:\n <ul>\n <li>${isc.DocUtils.linkForRef('attr:NavigationBar.rightButtonTitle','rightButtonTitle')} for ${isc.DocUtils.linkForRef('attr:Button.title')}</li>\n <li>${isc.DocUtils.linkForRef('attr:NavigationBar.rightButtonIcon','rightButtonIcon')} for ${isc.DocUtils.linkForRef('attr:Button.icon')}</li>\n </ul>",
        flags:"IR",
        name:"rightButton"
    },
    "class:BlurbItem":{
        seeAlso:[
        ],
        type:"class",
        staticMethods:[
        ],
        inheritsFrom:"FormItem",
        classMethods:[
        ],
        classAttrs:[
        ],
        attrs:[
            "attr:BlurbItem.editProxyConstructor",
            "attr:BlurbItem.showTitle",
            "attr:BlurbItem.colSpan",
            "attr:BlurbItem.textBoxStyle",
            "attr:BlurbItem.canSelectText",
            "attr:BlurbItem.wrap",
            "attr:BlurbItem.clipValue"
        ],
        ref:"class:BlurbItem",
        deprecated:null,
        description:"FormItem intended for inserting blurbs of instructional HTML into DynamicForms.\n <p>\n Set the <code>defaultValue</code> of this item to the HTML you want to embed in the form.",
        methods:[
        ],
        name:"BlurbItem"
    },
    "attr:DetailViewer.cellStyle":{
        seeAlso:[
        ],
        defaultValue:"\"detail\"",
        type:"attr",
        definingClass:"class:DetailViewer",
        getter:[
            "getCellStyle"
        ],
        groups:[
            "appearance"
        ],
        ref:"attr:DetailViewer.cellStyle",
        deprecated:null,
        valueType:"CSSStyleName",
        description:"CSS style for a normal value",
        flags:"IRW",
        name:"cellStyle"
    },
    "classAttr:Operators.notNullTitle":{
        seeAlso:[
        ],
        defaultValue:"\"is not null\"",
        type:"classAttr",
        definingClass:"class:Operators",
        groups:[
            "i18nMessages"
        ],
        deprecated:null,
        ref:"classAttr:Operators.notNullTitle",
        valueType:"String",
        description:"Title for the \"notNull\" operator",
        flags:"IR",
        name:"notNullTitle"
    },
    "attr:MetricSettings.dataColors":{
        seeAlso:[
        ],
        defaultValue:"see below",
        type:"attr",
        definingClass:"object:MetricSettings",
        deprecated:null,
        ref:"attr:MetricSettings.dataColors",
        setter:[
            "setDataColors"
        ],
        valueType:"Array of CSSColor",
        description:"An array of colors to use for a series of visual elements representing data (eg columns,\n bars, pie slices), any of which may be adjacent to any other.\n <P>\n Colors must be in the format of a leading hash (#) plus 6 hexadecimal digits, for example, \n \"#FFFFFF\" is white, \"#FF0000\" is pure red.",
        flags:"IRW",
        name:"dataColors"
    },
    "method:EditContext.removeAll":{
        seeAlso:[
        ],
        ref:"method:EditContext.removeAll",
        deprecated:null,
        type:"method",
        definingClass:"class:EditContext",
        description:" Removes all ${isc.DocUtils.linkForRef('object:EditNode','EditNodes')} from the EditContext, but does not destroy \n the ${isc.DocUtils.linkForRef('attr:EditNode.liveObject','liveObjects')}.\n",
        flags:"",
        name:"removeAll"
    },
    "method:SimpleType.parseInput":{
        seeAlso:[
        ],
        ref:"method:SimpleType.parseInput",
        deprecated:null,
        type:"method",
        definingClass:"class:SimpleType",
        params:[
            {
                defaultValue:null,
                optional:false,
                type:"String",
                description:"edited value provided by the user",
                name:"value"
            },
            {
                defaultValue:null,
                optional:true,
                type:"FormItem",
                description:"Editor for this field",
                name:"field"
            },
            {
                defaultValue:null,
                optional:true,
                type:"DynamicForm",
                description:"DynamicForm containing this editor",
                name:"form"
            },
            {
                defaultValue:null,
                optional:true,
                type:"Record",
                description:"Current edit values for this record, as displayed in      the edit component.",
                name:"record"
            }
        ],
        description:" Parser to convert some user-edited value to an underlying data value of this type.\n This parser is called when storing out values edited in a freeform editor such as\n a ${isc.DocUtils.linkForRef('class:TextItem')}. Typically this will convert from the format produced by \n ${isc.DocUtils.linkForRef('method:SimpleType.editFormatter')} back to a data value.\n\n",
        flags:"",
        returns:{
            type:"Any",
            description:"data value derived from display string passed in."
        },
        name:"parseInput"
    },
    "classMethod:Canvas.showPrintPreview":{
        groups:[
            "printing"
        ],
        seeAlso:[
        ],
        ref:"classMethod:Canvas.showPrintPreview",
        deprecated:null,
        type:"classMethod",
        definingClass:"class:Canvas",
        params:[
            {
                defaultValue:null,
                optional:false,
                type:"Array of Canvas",
                description:"components to get the print HTML for. May also include  raw HTML strings which will be folded into the generated print output",
                name:"components"
            },
            {
                defaultValue:null,
                optional:true,
                type:"PrintProperties",
                description:"PrintProperties object for customizing the     print HTML output",
                name:"printProperties"
            },
            {
                defaultValue:null,
                optional:true,
                type:"PrintWindow Properties",
                description:"Properties to apply to the     generated print window.",
                name:"printWindowProperties"
            },
            {
                defaultValue:null,
                optional:true,
                type:"Callback",
                description:"callback to fire when the print preview canvas has     been populated with the printable HTML. This callback takes 2 parameters:\n    <code>printPreview</code> - a pointer to the generated print canvas shown in the\n    body of the print window.\n    <code>printWindow</code> - a pointer to the generated print window and",
                name:"callback"
            },
            {
                defaultValue:null,
                optional:true,
                type:"String",
                description:"Optional HTML separator to render between each component's printable                      HTML",
                name:"separator"
            }
        ],
        description:" Generate and show a ${isc.DocUtils.linkForRef('class:PrintWindow')} containing a ${isc.DocUtils.linkForRef('class:PrintCanvas')}\n showing a printable view of the components passed in.\n\n",
        flags:"",
        name:"showPrintPreview"
    },
    "attr:ServerObject.lookupStyle":{
        seeAlso:[
            {
                ref:"attr:ServerObject.className",
                description:null
            },
            {
                ref:"attr:ServerObject.bean",
                description:null
            },
            {
                ref:"attr:ServerObject.attributeName",
                description:null
            },
            {
                ref:"attr:ServerObject.attributeScope",
                description:null
            }
        ],
        defaultValue:"\"new\"",
        type:"attr",
        definingClass:"object:ServerObject",
        deprecated:null,
        ref:"attr:ServerObject.lookupStyle",
        valueType:"\"new\" | \"factory\" | \"attribute\" | \"spring\" | \"cdi\"",
        description:"Specifies the mechanism for locating the class instance on which to invoke the method.\n Valid values are as follows:\n <ul>\n <li>\"spring\": For use with the <a href='http://springframework.com' target='_blank'>Spring framework</a>.\n ${isc.DocUtils.linkForRef('attr:ServerObject.bean')} contains the name of the bean to invoke.  Which application context\n is used can be configured via web.xml (see the example web.xml in the SDK).  See also\n ${isc.DocUtils.linkForRef('group:serverInit')} for special concerns with framework initialization when using\n Spring.\n <li>\"cdi\": For use with \n <a href='http://docs.oracle.com/javaee/6/tutorial/doc/giwhb.html' target='_blank'>CDI (Contexts and Dependency Injection)</a>.\n Use ${isc.DocUtils.linkForRef('attr:ServerObject.bean')} to configure the name of the \n bean to invoke or, alternatively, ${isc.DocUtils.linkForRef('attr:ServerObject.className')} to configure its class name.\n <li>\"new\": A new instance of the class specified by ${isc.DocUtils.linkForRef('attr:ServerObject.className')} will be\n created and the DMI method will be invoked on that instance (unless the specified method is\n static, in which case no instance is created, but the class specified by\n ${isc.DocUtils.linkForRef('attr:ServerObject.className')} is still used).\n <li>\"factory\": A custom factory provides the class instance on which the DMI method is to be\n invoked.  In this case, ${isc.DocUtils.linkForRef('attr:ServerObject.className')} specifies the className of the factory\n that will provide the instance on which the DMI method is to be invoked.  The class\n specified by ${isc.DocUtils.linkForRef('attr:ServerObject.className')} must provide exactly one method named\n <code>create</code> that must return the class instance on which you wish the DMI method to\n be invoked.  Like the DMI methods, the <code>create</code> method can request a standard set of\n values as arguments.  See ${isc.DocUtils.linkForRef('group:dmiOverview','DMI')} for a list of available values.\n <li> \"attribute\": The instance on which the DMI method is to be invoked is looked up in the\n scope defined by ${isc.DocUtils.linkForRef('attr:ServerObject.attributeScope')} via the attribute name specified in\n ${isc.DocUtils.linkForRef('attr:ServerObject.attributeName')}.\n </ul>",
        flags:"IR",
        serverDS:"only",
        name:"lookupStyle"
    },
    "method:DynamicForm.editSelectedData":{
        seeAlso:[
            {
                ref:"method:DynamicForm.saveData",
                description:null
            }
        ],
        type:"method",
        definingClass:"class:DynamicForm",
        groups:[
            "dataBoundComponentMethods"
        ],
        deprecated:null,
        ref:"method:DynamicForm.editSelectedData",
        params:[
            {
                defaultValue:null,
                optional:false,
                type:"ListGrid | TileGrid | ID",
                description:"the ListGrid or TileGrid or ID of a ${isc.DocUtils.linkForRef('class:ListGrid')}/${isc.DocUtils.linkForRef('class:TileGrid')} whose currently\n     record(s) is/are to be edited",
                name:"selectionComponent"
            }
        ],
        description:"\n Edit the record selected in the specified selection component (typically a\n ${isc.DocUtils.linkForRef('class:ListGrid')}).\n <P>\n Updates the values of this editor to match the selected record's values.\n <P>\n If this form has a dataSource, then saving via ${isc.DocUtils.linkForRef('method:DynamicForm.saveData')} will use the \n \"update\" operation type.\n\n",
        flags:"",
        examples:[
            "${isc.DocUtils.linkForExampleId('updateOperation')}"
        ],
        name:"editSelectedData"
    },
    "attr:PickListMenu.styleName":{
        seeAlso:[
        ],
        defaultValue:"\"pickListMenu\"",
        type:"attr",
        definingClass:"class:PickListMenu",
        groups:[
            "appearance"
        ],
        deprecated:null,
        ref:"attr:PickListMenu.styleName",
        valueType:"CSSStyleName",
        description:"Default CSS class for the ListGrid as a whole.",
        flags:"IRW",
        name:"styleName"
    },
    "attr:ImgTab.baseStyle":{
        seeAlso:[
        ],
        ref:"attr:ImgTab.baseStyle",
        defaultValue:"\"tab\"",
        deprecated:null,
        type:"attr",
        definingClass:"class:ImgTab",
        valueType:"CSSStyleName",
        description:null,
        flags:"IR",
        name:"baseStyle"
    },
    "attr:TestFunctionResult.record":{
        seeAlso:[
        ],
        defaultValue:"null",
        type:"attr",
        definingClass:"object:TestFunctionResult",
        groups:[
            "formulaFields"
        ],
        deprecated:null,
        ref:"attr:TestFunctionResult.record",
        valueType:"Record",
        description:"Set to the record that was used when testing the generated function.  This is the record\n selected by ${isc.DocUtils.linkForRef('method:FormulaBuilder.getTestRecord')}.",
        flags:"IRW",
        name:"record"
    },
    "attr:Canvas.useImageForSVG":{
        seeAlso:[
            {
                ref:"attr:Img.src",
                description:null
            },
            {
                ref:"attr:Button.icon",
                description:null
            },
            {
                ref:"method:Class.addProperties",
                description:null
            },
            {
                ref:"attr:Canvas.forwardSVGeventsToObject",
                description:null
            }
        ],
        defaultValue:"false",
        type:"attr",
        definingClass:"class:Canvas",
        groups:[
            "images"
        ],
        deprecated:null,
        ref:"attr:Canvas.useImageForSVG",
        valueType:"boolean",
        description:"If set, forces the main SVG image or icon in the canvas to be rendered in an image tag rather\n than an object tag, the default.  Typical use cases might be configuring the image of an\n ${isc.DocUtils.linkForRef('class:Img')} or ${isc.DocUtils.linkForRef('class:ImgButton')}, or the icon of a ${isc.DocUtils.linkForRef('class:Button')}.\n <P>\n Rendering via object tag provides the maximum support for CSS in SVG, but may result in a\n flicker at the browser level when changing images - either manually such as with\n ${isc.DocUtils.linkForRef('method:Canvas.setImage')} or via state change from rollover, mouseDown, etc.  Using image tags to\n inline the images breaks CSS support but may avoid flickering.\n <P>\n If this property is <i>not</i> set, then you can also control whether an SVG image is\n rendered in an object or image tag by setting the query param \"tag\" on the image URL - see\n ${isc.DocUtils.linkForRef('type:SCImgURL')} for details.\n <P>\n Note that if multiple icons are potentially present in a canvas (e.g.\n ${isc.DocUtils.linkForRef('attr:ListGrid.removeIcon','removeIcons')} in the cells of a grid body), then setting this\n property on the widget instance may have no effect.  In such case, the ${isc.DocUtils.linkForRef('class:Canvas')}\n prototype is consulted.",
        flags:"IRA",
        name:"useImageForSVG"
    },
    "classAttr:Hover.moveWithMouse":{
        seeAlso:[
        ],
        ref:"classAttr:Hover.moveWithMouse",
        defaultValue:"false",
        deprecated:null,
        type:"classAttr",
        definingClass:"class:Hover",
        valueType:"boolean",
        description:"When the Hover canvas is shown by default, should it move as the user moves the\n mouse pointer?<br>\n May be overridden by including a <code>moveWithMouse</code> attribute on the \n properties block passed to ${isc.DocUtils.linkForRef('classMethod:Hover.show')}",
        flags:"RWA",
        name:"moveWithMouse"
    },
    "attr:FacetChart.autoSortBubblePoints":{
        seeAlso:[
        ],
        defaultValue:"true",
        type:"attr",
        definingClass:"class:FacetChart",
        deprecated:null,
        ref:"attr:FacetChart.autoSortBubblePoints",
        valueType:"boolean",
        description:"Whether to draw data points in order of descending ${isc.DocUtils.linkForRef('attr:FacetChart.pointSizeMetric','point size')}\n so that small values are less likely to be completely occluded by larger values.  Set\n this to <code>false</code> to draw the data points in the same order that they appear\n in the data.",
        flags:"IR",
        examples:[
            "${isc.DocUtils.linkForExampleId('bubbleChart')}"
        ],
        name:"autoSortBubblePoints"
    },
    "attr:FacetChart.axisEndValue":{
        seeAlso:[
        ],
        ref:"attr:FacetChart.axisEndValue",
        defaultValue:"null",
        deprecated:null,
        type:"attr",
        definingClass:"class:FacetChart",
        valueType:"Float",
        description:"End value for the primary axis of the chart.\n <p>\n If set to an explicit value, this will be respected.\n If unset, the axis end value will default to a value large enough to the\n largest data point, rounded up to the nearest (next) gradation.\n <p>\n For multi-axis charts, Bubble charts, and Scatter charts, the\n <code>facetChart.axisEndValue</code> affects only the <b>first</b> axis of the chart.\n End values for other axes of multi-axis charts can be set on a per-axis basis via\n ${isc.DocUtils.linkForRef('attr:MetricSettings.xAxisEndValue')}.  For Scatter charts, the ${isc.DocUtils.linkForRef('attr:FacetChart.xAxisEndValue')}\n property must be used to set the end value of the x-axis.\n <p>\n Note that if this chart's data includes points that fall above this value, they\n are ommitted and effectively treated as null values. For charts showing a data line,\n developers may wish to set ${isc.DocUtils.linkForRef('attr:FacetChart.discontinuousLines')} to true in this case.",
        flags:"IR",
        name:"axisEndValue"
    },
    "method:FormItem.show":{
        seeAlso:[
        ],
        ref:"method:FormItem.show",
        deprecated:null,
        type:"method",
        definingClass:"class:FormItem",
        description:" Show this form item.\n <p>\n This will cause the form to redraw.  If this item had an item.showIf expression, it will\n be destroyed.\n",
        flags:"",
        name:"show"
    },
    "method:Canvas.adaptWidthBy":{
        seeAlso:[
        ],
        ref:"method:Canvas.adaptWidthBy",
        deprecated:null,
        type:"method",
        definingClass:"class:Canvas",
        params:[
            {
                defaultValue:null,
                optional:false,
                type:"Integer",
                description:"surplus (if positive) or overflow (if negative)",
                name:"pixelDifference"
            },
            {
                defaultValue:null,
                optional:false,
                type:"Integer",
                description:"width of member currently assumed by parent layout",
                name:"unadaptedWidth"
            }
        ],
        description:" See ${isc.DocUtils.linkForRef('attr:Canvas.canAdaptWidth')}.\n",
        flags:"",
        returns:{
            type:"Integer",
            description:"sizeDelta"
        },
        name:"adaptWidthBy"
    },
    "attr:SCStatefulImgConfig.Down":{
        seeAlso:[
        ],
        ref:"attr:SCStatefulImgConfig.Down",
        defaultValue:"null",
        deprecated:null,
        type:"attr",
        definingClass:"object:SCStatefulImgConfig",
        valueType:"String",
        description:"Image to display on ${isc.DocUtils.linkForRef('attr:StatefulCanvas.showDown','mouseDown')}.\n <P>\n May be specified as \n <ul><li>A ${isc.DocUtils.linkForRef('type:SCImgURL')} indicating the media to load</li>\n     <li>A reference to another entry in this SCStatefulImgConfig via the format \n         <code>\"#state:<i>otherStateName</i>\"</code></li>\n     <li>A modifier to apply to the ${isc.DocUtils.linkForRef('attr:SCStatefulImgConfig._base')} media via the\n         format <code>\"#modifier:<i>modifierString</i>\"</code></li>\n </ul>\n See ${isc.DocUtils.linkForRef('object:SCStatefulImgConfig','SCStatefulImgConfig overview')} for further information.",
        flags:"IRW",
        name:"Down"
    },
    "method:DrawRect.setHeight":{
        seeAlso:[
        ],
        ref:"method:DrawRect.setHeight",
        deprecated:null,
        type:"method",
        definingClass:"class:DrawRect",
        params:[
            {
                defaultValue:null,
                optional:false,
                type:"Distance",
                description:"new height",
                name:"height"
            }
        ],
        description:" Set the height of the drawRect\n",
        flags:"",
        name:"setHeight"
    },
    "method:Canvas.animateResize":{
        seeAlso:[
        ],
        type:"method",
        definingClass:"class:Canvas",
        groups:[
            "animation"
        ],
        deprecated:null,
        ref:"method:Canvas.animateResize",
        params:[
            {
                defaultValue:null,
                optional:false,
                type:"Integer",
                description:"new width (or null for unchanged)",
                name:"width"
            },
            {
                defaultValue:null,
                optional:false,
                type:"Integer",
                description:"new height (or null for unchanged)",
                name:"height"
            },
            {
                defaultValue:null,
                optional:true,
                type:"AnimationCallback",
                description:"When the resize completes this callback will be                       fired. Single 'earlyFinish' parameter will be passed if the\n                       animation was cut short, for example by a call to the non-animated\n                       APIs ${isc.DocUtils.linkForRef('method:Canvas.resizeTo')} or ${isc.DocUtils.linkForRef('method:Canvas.resizeBy')}.",
                name:"callback"
            },
            {
                defaultValue:null,
                optional:true,
                type:"Integer",
                description:"Duration in ms of the animated resize",
                name:"duration"
            },
            {
                defaultValue:null,
                optional:true,
                type:"AnimationAcceleration",
                description:"Optional acceleration effect to apply to the resize",
                name:"acceleration"
            }
        ],
        description:" Animate a resize of this canvas from its current size to the specified size\n <p>\n Note that ${isc.DocUtils.linkForRef('attr:Canvas.animateResizeLayoutMode')} allows you to control whether child layout is\n rerun during every step of the animation, or just at the end, since the former may incur\n significant overhead depending on the widget hierarchy.\n\n",
        flags:"",
        examples:[
            "${isc.DocUtils.linkForExampleId('animateResize')}"
        ],
        name:"animateResize"
    },
    "method:ListGrid.showFields":{
        seeAlso:[
        ],
        ref:"method:ListGrid.showFields",
        deprecated:null,
        type:"method",
        definingClass:"class:ListGrid",
        params:[
            {
                defaultValue:null,
                optional:false,
                type:"Array of String | Array of ListGridField",
                description:"Fields to show.",
                name:"field"
            },
            {
                defaultValue:null,
                optional:true,
                type:"boolean",
                description:"If passed, don't resize non-explicitly sized columns                                       to fill the available space.",
                name:"suppressRelayout"
            }
        ],
        description:" Force an array of fields to be shown. This method does not add new fields to the grid,\n it simply changes field visibility. If a field.showIf expression exists, it will be\n destroyed.\n <P>\n Note: for showing multiple fields it is more efficient to call this method than to call\n ${isc.DocUtils.linkForRef('method:ListGrid.showField')} repeatedly.\n\n",
        flags:"",
        examples:[
            "${isc.DocUtils.linkForExampleId('columnOrder')}"
        ],
        name:"showFields"
    },
    "method:AdaptiveMenu.setPartialInlining":{
        seeAlso:[
        ],
        ref:"method:AdaptiveMenu.setPartialInlining",
        deprecated:null,
        type:"method",
        definingClass:"class:AdaptiveMenu",
        params:[
            {
                defaultValue:null,
                optional:false,
                type:"boolean",
                description:null,
                name:"partialInlining"
            }
        ],
        description:"\n",
        flags:"",
        name:"setPartialInlining"
    },
    "attr:Menu.baseStyle":{
        seeAlso:[
        ],
        ref:"attr:Menu.baseStyle",
        defaultValue:"\"menu\"",
        deprecated:null,
        type:"attr",
        definingClass:"class:Menu",
        valueType:"CSSStyleName",
        description:"CSS style for a normal cell",
        flags:"IRW",
        name:"baseStyle"
    },
    "class:HStack":{
        seeAlso:[
            {
                ref:"attr:Layout.hPolicy",
                description:null
            }
        ],
        exampleConfig:"HStack.xml",
        type:"class",
        staticMethods:[
        ],
        inheritsFrom:"Layout",
        classMethods:[
        ],
        classAttrs:[
        ],
        attrs:[
        ],
        ref:"class:HStack",
        deprecated:null,
        treeLocation:[
            "Client Reference/Layout"
        ],
        description:"A subclass of Layout that simply stacks members on the horizontal axis without trying to\n manage their width.  On the vertical axis, any members that do not have explicit heights will\n be sized to match the height of the stack.",
        methods:[
        ],
        name:"HStack"
    },
    "attr:Window.isModal":{
        seeAlso:[
        ],
        defaultValue:"false",
        type:"attr",
        definingClass:"class:Window",
        groups:[
            "modal"
        ],
        ref:"attr:Window.isModal",
        deprecated:null,
        valueType:"Boolean",
        description:"If true, when shown this Window will intercept and block events to all other existing\n components on the page.\n <P>\n Use ${isc.DocUtils.linkForRef('attr:Window.showModalMask')} to darken all other elements on the screen when a modal dialog\n is showing.\n <P>\n Chained modal windows - that is, modal windows that launch other modal windows - are\n allowed.  You can accomplish this by simply creating a second modal Window while a modal\n Window is showing.\n <P>\n Note only top-level Windows (Windows without parents) can be modal.",
        flags:"IRW",
        examples:[
            "${isc.DocUtils.linkForExampleId('modality')}"
        ],
        name:"isModal"
    },
    "attr:FormulaBuilder.helpWindowTitle":{
        seeAlso:[
        ],
        defaultValue:"\"${builderType} Help\"",
        type:"attr",
        definingClass:"class:FormulaBuilder",
        groups:[
            "i18nMessages"
        ],
        deprecated:null,
        ref:"attr:FormulaBuilder.helpWindowTitle",
        valueType:"HTMLString",
        description:"The title for the window that opens when the ${isc.DocUtils.linkForRef('attr:FormulaBuilder.helpIcon','Help icon')}\n is clicked.\n <P>\n This is a dynamic string - text within <code>&#36;{...}</code> are dynamic variables and will\n be evaluated as JS code when the message is displayed.\n <P>\n Only one dynamic variable, builderType, is available and represents the type of this \n builder, either Formula or Summary.\n <P>\n The default output is:<P>\n <code>\n <i>[Formula/Summary] Help</i>\n </code>",
        flags:"IRWA",
        name:"helpWindowTitle"
    },
    "attr:ToolbarItem.colSpan":{
        seeAlso:[
        ],
        defaultValue:"\"*\"",
        type:"attr",
        definingClass:"class:ToolbarItem",
        groups:[
            "appearance"
        ],
        deprecated:null,
        ref:"attr:ToolbarItem.colSpan",
        valueType:"int | String",
        description:"these items span all columns",
        flags:"IRW",
        name:"colSpan"
    },
    "method:GridRenderer.cellHover":{
        seeAlso:[
            {
                ref:"attr:GridRenderer.canHover",
                description:null
            }
        ],
        type:"method",
        definingClass:"class:GridRenderer",
        returns:{
            type:"boolean",
            description:"whether to cancel the event"
        },
        groups:[
            "events"
        ],
        deprecated:null,
        ref:"method:GridRenderer.cellHover",
        params:[
            {
                defaultValue:null,
                optional:false,
                type:"ListGridRecord",
                description:"cell record as returned by getCellRecord",
                name:"record"
            },
            {
                defaultValue:null,
                optional:false,
                type:"number",
                description:"row number for the cell",
                name:"rowNum"
            },
            {
                defaultValue:null,
                optional:false,
                type:"number",
                description:"column number of the cell",
                name:"colNum"
            }
        ],
        description:" Called when the mouse hovers over a cell if this.canHover is true. \n  Returning false will suppress the hover text from being shown if this.showHover is true.\n\n",
        flags:"A",
        name:"cellHover"
    },
    "group:lifecycle":{
        refs:[
            "attr:TabSet.destroyPanes"
        ],
        seeAlso:[
        ],
        ref:"group:lifecycle",
        deprecated:null,
        type:"group",
        description:null,
        name:"lifecycle"
    },
    "method:ImgButton.setAutoFit":{
        seeAlso:[
        ],
        ref:"method:ImgButton.setAutoFit",
        deprecated:null,
        type:"method",
        definingClass:"class:ImgButton",
        params:[
            {
                defaultValue:null,
                optional:false,
                type:"boolean",
                description:"New autoFit setting.",
                name:"autoFit"
            }
        ],
        description:" Setter method for the ${isc.DocUtils.linkForRef('attr:StatefulCanvas.autoFit')} property. Pass in true or false to turn\n autoFit on or off. When autoFit is set to <code>false</code>, canvas will be resized to\n it's previously specified size.\n",
        flags:"",
        name:"setAutoFit"
    },
    "attr:AdvancedHiliteEditor.invalidHilitePrompt":{
        seeAlso:[
        ],
        defaultValue:"\"Enter at least one rule, a color or icon, and a target field, or press 'Cancel' to abandon changes.\"",
        type:"attr",
        definingClass:"class:AdvancedHiliteEditor",
        groups:[
            "i18nMessages"
        ],
        deprecated:null,
        ref:"attr:AdvancedHiliteEditor.invalidHilitePrompt",
        valueType:"String",
        description:"The message to show when the user clicks \"Save\" without entering any criteria.",
        flags:"IR",
        name:"invalidHilitePrompt"
    },
    "attr:StatefulCanvas.iconHeight":{
        seeAlso:[
        ],
        defaultValue:"null",
        type:"attr",
        definingClass:"class:StatefulCanvas",
        groups:[
            "buttonIcon"
        ],
        deprecated:null,
        ref:"attr:StatefulCanvas.iconHeight",
        valueType:"Integer",
        description:"Height in pixels of the icon image.\n <P>\n If unset, defaults to ${isc.DocUtils.linkForRef('attr:StatefulCanvas.iconSize','iconSize')}.",
        flags:"IR",
        name:"iconHeight"
    },
    "method:Calendar.getCellHoverHTML":{
        seeAlso:[
        ],
        ref:"method:Calendar.getCellHoverHTML",
        deprecated:null,
        type:"method",
        definingClass:"class:Calendar",
        params:[
            {
                defaultValue:null,
                optional:false,
                type:"CalendarView",
                description:"the CalendarView the mouse is hovered over",
                name:"view"
            },
            {
                defaultValue:null,
                optional:false,
                type:"Record",
                description:"The record containing the cell being hovered",
                name:"record"
            },
            {
                defaultValue:null,
                optional:false,
                type:"Integer",
                description:"The rowNum of the cell being hovered",
                name:"rowNum"
            },
            {
                defaultValue:null,
                optional:false,
                type:"Integer",
                description:"the colNum of the cell being hovered",
                name:"colNum"
            },
            {
                defaultValue:null,
                optional:false,
                type:"Date",
                description:"the snap-date at the mouse, which may be different from the result of a                     call to ${isc.DocUtils.linkForRef('method:Calendar.getCellDate','getCellDate')}",
                name:"date"
            },
            {
                defaultValue:null,
                optional:false,
                type:"String",
                description:"the default hover text for the passed values",
                name:"defaultValue"
            }
        ],
        description:" Returns the hover HTML for the cell at the passed co-ordinates in the passed view.  By \n default, the hover text is  the snap date closest to the mouse, if the cell being hovered is \n a normal date cell - otherwise, it is the title of the ${isc.DocUtils.linkForRef('attr:Calendar.laneFields','laneField')}\n being hovered over.\n <P>\n Override here to return custom HTML for the passed cell.\n\n",
        flags:"",
        returns:{
            type:"HTMLString",
            description:"the HTML to show in the hover"
        },
        name:"getCellHoverHTML"
    },
    "classMethod:Log.getDefaultLogPriority":{
        seeAlso:[
        ],
        ref:"classMethod:Log.getDefaultLogPriority",
        deprecated:null,
        type:"classMethod",
        definingClass:"class:Log",
        description:" A common usage of ${isc.DocUtils.linkForRef('classMethod:Class.getDefaultLogPriority')} is to call the\n method directly on the Log class.\n",
        flags:"",
        returns:{
            type:"LogPriority",
            description:"default priority for logging messages on this object."
        },
        name:"getDefaultLogPriority"
    },
    "attr:FormItem.editProxyConstructor":{
        seeAlso:[
        ],
        ref:"attr:FormItem.editProxyConstructor",
        defaultValue:"\"FormItemEditProxy\"",
        deprecated:null,
        type:"attr",
        definingClass:"class:FormItem",
        valueType:"SCClassName",
        description:"Default class used to construct the ${isc.DocUtils.linkForRef('class:EditProxy')} for this component\n when the component is ${isc.DocUtils.linkForRef('method:Canvas.setEditMode','first placed into edit mode')}.",
        flags:"IR",
        name:"editProxyConstructor"
    },
    "attr:ListGrid.showEllipsisWhenClipped":{
        seeAlso:[
        ],
        ref:"attr:ListGrid.showEllipsisWhenClipped",
        defaultValue:"true",
        deprecated:null,
        type:"attr",
        definingClass:"class:ListGrid",
        valueType:"boolean",
        description:"Should ellipses be displayed when cell content is clipped? May be overridden at the field \n level via ${isc.DocUtils.linkForRef('attr:ListGridField.showEllipsisWhenClipped')}",
        flags:"IRW",
        name:"showEllipsisWhenClipped"
    },
    "method:Canvas.redraw":{
        groups:[
            "drawing"
        ],
        seeAlso:[
        ],
        ref:"method:Canvas.redraw",
        deprecated:null,
        type:"method",
        definingClass:"class:Canvas",
        params:[
            {
                defaultValue:"\"no reason provided\"",
                optional:true,
                type:"String",
                description:"reason for performing the redraw",
                name:"reason"
            }
        ],
        description:" Redraws the widget immediately with its current property values.\n\n Generally, if you want a Canvas to redraw, call markForRedraw() - this will cause the Canvas to\n be redrawn when current processing ends, so that a series of modifications made to a Canvas will\n cause it to redraw only once.\n\n Only call redraw() directly if you need immediate responsiveness, for example you are redrawing\n in response to continuous mouse motion.\n\n",
        flags:"A",
        name:"redraw"
    },
    "attr:Calendar.eventEditorButtonLayout":{
        seeAlso:[
        ],
        ref:"attr:Calendar.eventEditorButtonLayout",
        defaultValue:"null",
        deprecated:null,
        type:"attr",
        definingClass:"class:Calendar",
        valueType:"AutoChild HLayout",
        description:"An ${isc.DocUtils.linkForRef('type:AutoChild')} of type ${isc.DocUtils.linkForRef('class:HLayout')} which houses the \n ${isc.DocUtils.linkForRef('attr:Calendar.saveButton','Save')}, ${isc.DocUtils.linkForRef('attr:Calendar.removeButton','Remove')}\n and ${isc.DocUtils.linkForRef('attr:Calendar.cancelButton','Cancel')} buttons in the \n ${isc.DocUtils.linkForRef('attr:Calendar.eventEditor','eventEditor')}.",
        flags:"R",
        name:"eventEditorButtonLayout"
    },
    "attr:Lane.eventStyleName":{
        seeAlso:[
        ],
        defaultValue:"null",
        type:"attr",
        definingClass:"object:Lane",
        groups:[
            "appearance"
        ],
        deprecated:null,
        ref:"attr:Lane.eventStyleName",
        valueType:"CSSStyleName",
        description:"The base name for the CSS class applied to ${isc.DocUtils.linkForRef('attr:Calendar.eventCanvas','events')} when they're\n rendered in this lane.  See ${isc.DocUtils.linkForRef('attr:Calendar.eventStyleName')}.\n <P>\n If set directly on a ${isc.DocUtils.linkForRef('attr:Lane.sublanes','sublane')}, overrides the corresponding value on\n the parent ${isc.DocUtils.linkForRef('attr:Calendar.lanes','lane')}.  See \n ${isc.DocUtils.linkForRef('method:Calendar.getEventCanvasStyle','getEventCanvasStyle()')} for more information.",
        flags:"IRW",
        name:"eventStyleName"
    },
    "classMethod:Canvas.getPrintHTML":{
        seeAlso:[
        ],
        ref:"classMethod:Canvas.getPrintHTML",
        deprecated:null,
        type:"classMethod",
        definingClass:"class:Canvas",
        params:[
            {
                defaultValue:null,
                optional:false,
                type:"Array of Canvas",
                description:"Components to get the print HTML for. Strings of raw HTML may  also be included in this array, and will be integrated into the final HTML at the appropriate\n  point.",
                name:"components"
            },
            {
                defaultValue:null,
                optional:false,
                type:"PrintProperties",
                description:"properties affecting print output",
                name:"printProperties"
            },
            {
                defaultValue:null,
                optional:true,
                type:"Callback",
                description:"Callback to fire when the method completes. The generated print HTML  will be passed in as the first parameter <code>HTML</code>.",
                name:"callback"
            },
            {
                defaultValue:null,
                optional:true,
                type:"HTMLString",
                description:"Optional HTML separator to render between each component's printable HTML",
                name:"separator"
            }
        ],
        description:" Returns print-formatted HTML for the specified list of components.\n\n",
        flags:"",
        returns:{
            type:"HTMLString",
            description:"print HTML for the components passed in. This will be <code>null</code> if  a callback parameter was passed into this method, or if the print HTML was generated asynchronously by\n  the component[s]."
        },
        name:"getPrintHTML"
    },
    "attr:MetricSettings.filled":{
        seeAlso:[
        ],
        defaultValue:"null",
        type:"attr",
        definingClass:"object:MetricSettings",
        deprecated:null,
        ref:"attr:MetricSettings.filled",
        setter:[
            "setFilled"
        ],
        valueType:"boolean",
        description:"Whether shapes are filled, for example, whether a multi-series line chart appears as a\n stack of filled regions as opposed to just multiple lines.\n <P>\n If unset, fills will be automatically used when there are multiple facets and stacking\n is active (so Line and Radar charts will show stacked regions).  \n <P>\n You can explicitly set filled:false to create multi-facet Line or Radar charts where\n translucent regions overlap, or filled:true to fill in a single-facet Line or Radar\n chart.",
        flags:"IRW",
        name:"filled"
    },
    "attr:Window.closeButton":{
        seeAlso:[
        ],
        ref:"attr:Window.closeButton",
        defaultValue:"null",
        deprecated:null,
        type:"attr",
        definingClass:"class:Window",
        valueType:"AutoChild ImgButton",
        description:"Button show in the header that will close this Window by calling ${isc.DocUtils.linkForRef('method:Window.closeClick')}.",
        flags:"R",
        name:"closeButton"
    },
    "attr:TimeItem.millisecondIncrement":{
        seeAlso:[
        ],
        ref:"attr:TimeItem.millisecondIncrement",
        defaultValue:"null",
        deprecated:null,
        type:"attr",
        definingClass:"class:TimeItem",
        valueType:"Number",
        description:"When ${isc.DocUtils.linkForRef('attr:TimeItem.useTextField','useTextField')} is false and \n ${isc.DocUtils.linkForRef('attr:TimeItem.millisecondValues','millisecondValues')} is unset, this attribute specifies \n the increment to use when generating entries for the millisecond picker.  For example, \n if this attribute is set to 5, the millisecond picker will contain only every fifth \n value between the ${isc.DocUtils.linkForRef('attr:TimeItem.millisecondMinValue','millisecondMinValue')} and \n ${isc.DocUtils.linkForRef('attr:TimeItem.millisecondMaxValue','millisecondMaxValue')}.",
        flags:"IRW",
        name:"millisecondIncrement"
    },
    "attr:Window.restoreButton":{
        seeAlso:[
        ],
        ref:"attr:Window.restoreButton",
        defaultValue:"null",
        deprecated:null,
        type:"attr",
        definingClass:"class:Window",
        valueType:"AutoChild ImgButton",
        description:"ImgButton that restores the Window via ${isc.DocUtils.linkForRef('method:Window.restore')}.",
        flags:"R",
        name:"restoreButton"
    },
    "method:DrawOval.resizeBy":{
        seeAlso:[
        ],
        ref:"method:DrawOval.resizeBy",
        deprecated:null,
        type:"method",
        definingClass:"class:DrawOval",
        params:[
            {
                defaultValue:null,
                optional:false,
                type:"Distance",
                description:"number of pixels to resize by horizontally",
                name:"dX"
            },
            {
                defaultValue:null,
                optional:false,
                type:"Distance",
                description:"number of pixels to resize by vertically",
                name:"dY"
            }
        ],
        description:" Resize by the specified delta. Note that the resize will occur from the current top/left \n coordinates, meaning the center positon of the oval may change. You may also use\n ${isc.DocUtils.linkForRef('method:DrawOval.setRadii')} to change the radius in either direction without modifying the\n centerpoint.\n",
        flags:"",
        name:"resizeBy"
    },
    "class:Timeline":{
        seeAlso:[
        ],
        type:"class",
        staticMethods:[
        ],
        inheritsFrom:"Calendar",
        classMethods:[
        ],
        classAttrs:[
        ],
        attrs:[
        ],
        ref:"class:Timeline",
        deprecated:null,
        treeLocation:[
            "Client Reference/Calendar"
        ],
        description:"Timeline is a trivial subclass of ${isc.DocUtils.linkForRef('class:Calendar')} that configures the Calendar with settings\n typical for a standalone timeline view: hides the ${isc.DocUtils.linkForRef('attr:Calendar.dayView','day')}, \n ${isc.DocUtils.linkForRef('attr:Calendar.weekView','week')} and ${isc.DocUtils.linkForRef('attr:Calendar.monthView','month')} tabs and the \n ${isc.DocUtils.linkForRef('attr:Calendar.controlsBar','controls bar')} by default.\n <P>\n Note that the ${isc.DocUtils.linkForRef('group:loadingOptionalModules','Calendar module')} must be loaded to make \n use of the Timeline class.",
        methods:[
        ],
        name:"Timeline"
    },
    "method:List.getItems":{
        seeAlso:[
        ],
        type:"method",
        definingClass:"interface:List",
        returns:{
            type:"Array",
            description:"subset of the array, in the same order as itemList"
        },
        groups:[
            "access"
        ],
        deprecated:null,
        ref:"method:List.getItems",
        params:[
            {
                defaultValue:null,
                optional:false,
                type:"List of Number",
                description:"array of positions",
                name:"itemList"
            }
        ],
        description:" Return the items at a list of specified positions.\n\n",
        flags:"",
        name:"getItems"
    },
    "method:PortalLayout.setPreventUnderflow":{
        seeAlso:[
        ],
        type:"method",
        definingClass:"class:PortalLayout",
        groups:[
            "sizing"
        ],
        deprecated:null,
        ref:"method:PortalLayout.setPreventUnderflow",
        params:[
            {
                defaultValue:null,
                optional:false,
                type:"boolean",
                description:"Whether to stretch the last column to fill the PortalLayout's width.",
                name:"preventUnderflow"
            }
        ],
        description:" Sets ${isc.DocUtils.linkForRef('attr:PortalLayout.preventUnderflow','preventUnderflow')} and reflows the layout to implement it.\n",
        flags:"",
        examples:[
            "${isc.DocUtils.linkForExampleId('portalColumnWidth')}"
        ],
        name:"setPreventUnderflow"
    },
    "method:Tree.reloadChildren":{
        groups:[
            "loadState"
        ],
        seeAlso:[
            {
                ref:"method:Tree.removeChildren",
                description:null
            }
        ],
        ref:"method:Tree.reloadChildren",
        deprecated:null,
        type:"method",
        definingClass:"class:Tree",
        params:[
            {
                defaultValue:null,
                optional:false,
                type:"TreeNode",
                description:"node in question",
                name:"node"
            }
        ],
        description:" Reload the children of a folder.\n\n",
        flags:"",
        name:"reloadChildren"
    },
    "classMethod:AutoTest.isElementReadyForKeyPresses":{
        seeAlso:[
        ],
        type:"classMethod",
        definingClass:"class:AutoTest",
        returns:{
            type:"Boolean",
            description:"whether element is 'ready' as described above"
        },
        groups:[
            "autoTest"
        ],
        deprecated:null,
        ref:"classMethod:AutoTest.isElementReadyForKeyPresses",
        params:[
            {
                defaultValue:null,
                optional:false,
                type:"Canvas | FormItem | DOMElement | AutoTestLocator",
                description:"DOM element to test     (element obtained from canvas, form item, or SmartClient locator if provided)",
                name:"element"
            }
        ],
        description:" Given a DOM element, returns whether the associated SmartClient Canvas or FormItem is\n ready to receive keyPress events from a Selenium test.  Returns null if the locator is\n not valid or doesn't represent a valid Canvas or FormItem.  Otherwise, returns true or\n false  according as the conditions below are all satisfied:\n <ul>\n     <li> page has finished loading\n     <li> if a ${isc.DocUtils.linkForRef('class:TextItem')}, ${isc.DocUtils.linkForRef('class:FileItem')}, or ${isc.DocUtils.linkForRef('class:TextAreaItem')}, \n          it has native focus,\n     <li> the element satisfies ${isc.DocUtils.linkForRef('classMethod:AutoTest.isElementClickable')}\n </ul>\n",
        flags:"",
        name:"isElementReadyForKeyPresses"
    },
    "attr:ListGrid.alternateFieldSuffix":{
        seeAlso:[
        ],
        defaultValue:"\"AltCol\"",
        type:"attr",
        definingClass:"class:ListGrid",
        groups:[
            "cellStyling"
        ],
        deprecated:null,
        ref:"attr:ListGrid.alternateFieldSuffix",
        valueType:"String",
        description:"Suffix to append to ${isc.DocUtils.linkForRef('attr:GridRenderer.alternateColumnStyles','alternate columns')}.\n Note that if ${isc.DocUtils.linkForRef('attr:GridRenderer.alternateRowStyles')} is enabled, cells which fall\n into both an alternate row and column will have both suffixes appended - for\n example <code>\"cellDarkAltCol\"</code>.",
        flags:"IRW",
        name:"alternateFieldSuffix"
    },
    "attr:ListGridField.linkTextProperty":{
        seeAlso:[
            {
                ref:"type:ListGridFieldType",
                description:null
            },
            {
                ref:"type:FieldType",
                description:null
            },
            {
                ref:"attr:ListGridRecord.linkText",
                description:null
            },
            {
                ref:"attr:ListGridField.linkText",
                description:null
            },
            {
                ref:"attr:ListGrid.linkTextProperty",
                description:null
            }
        ],
        defaultValue:"null",
        type:"attr",
        definingClass:"object:ListGridField",
        groups:[
            "display_values"
        ],
        deprecated:null,
        ref:"attr:ListGridField.linkTextProperty",
        valueType:"String",
        description:"Name of the property in a ListGridRecord that holds the HTML to display in cells of this\n field if the fieldType is set to \"link\".",
        flags:"IRW",
        name:"linkTextProperty"
    },
    "attr:VisualBuilder.defaultApplicationMode":{
        seeAlso:[
        ],
        ref:"attr:VisualBuilder.defaultApplicationMode",
        defaultValue:"\"edit\"",
        deprecated:null,
        type:"attr",
        definingClass:"class:VisualBuilder",
        valueType:"ApplicationMode",
        description:"The default application mode.  Note, this can be changed through the UI - see \n ${isc.DocUtils.linkForRef('attr:VisualBuilder.showModeSwitcher','showModeSwitcher')}",
        flags:"IR",
        name:"defaultApplicationMode"
    },
    "attr:ListGridRecord.embeddedComponent":{
        seeAlso:[
        ],
        defaultValue:"null",
        type:"attr",
        definingClass:"object:ListGridRecord",
        groups:[
            "appearance"
        ],
        deprecated:null,
        ref:"attr:ListGridRecord.embeddedComponent",
        valueType:"Canvas",
        description:"A component that should be rendered on top of this record, similar to a\n ${isc.DocUtils.linkForRef('attr:ListGrid.showRecordComponents','record component')} but statically defined on the record.\n <p>\n The embedded component will default to covering all fields of the record, but specific fields\n can be specified via ${isc.DocUtils.linkForRef('attr:ListGridRecord.embeddedComponentFields')}.\n <p>\n By default, the embeddedComponent will fill the entire vertical and horizontal space of the\n record (or of the specified fields).  ${isc.DocUtils.linkForRef('attr:ListGridRecord.embeddedComponentPosition')} can be set to control\n exact sizing behavior.\n \n <p>\n When creating a component to use as an embedded component the component will most likely\n end up drawing before the record it is due to be embedded within, therefore it is recommended\n to set ${isc.DocUtils.linkForRef('attr:Canvas.autoDraw','autoDraw')} to false on the embedded component.\n \n <p>\n When a record with an <code>embeddedComponent</code> is eliminated from view by filtering or\n because it is not currently rendered due to ${isc.DocUtils.linkForRef('attr:ListGrid.showAllRecords','incremental rendering')}, the\n ListGrid may ${isc.DocUtils.linkForRef('method:Canvas.hide')} or ${isc.DocUtils.linkForRef('method:Canvas.clear')} it.\n <p>\n If the current dataset is completely replaced (by a call to ${isc.DocUtils.linkForRef('method:ListGrid.setData')} or\n ${isc.DocUtils.linkForRef('method:ListGrid.setDataSource')}, for example), any embedded component is\n ${isc.DocUtils.linkForRef('method:Canvas.deparent','deparented')} (which implies being ${isc.DocUtils.linkForRef('method:Canvas.clear','clear()ed')}).\n <p>\n When a ListGrid is ${isc.DocUtils.linkForRef('method:Canvas.destroy','destroyed')}, it will destroy() all embedded components\n regardless of whether they are currently visible.  Use a call to ${isc.DocUtils.linkForRef('method:ListGrid.setData')} immediately\n before destroying the ListGrid to avoid this effect when unwanted.\n <p>\n For more advanced control over the lifecycle of components displayed over records, including\n deferred creation and pooling, use the ${isc.DocUtils.linkForRef('attr:ListGrid.showRecordComponents','record components')}\n subsystem.",
        flags:"IR",
        name:"embeddedComponent"
    },
    "attr:MenuItem.fetchSubmenus":{
        seeAlso:[
        ],
        ref:"attr:MenuItem.fetchSubmenus",
        defaultValue:"true",
        deprecated:null,
        type:"attr",
        definingClass:"object:MenuItem",
        valueType:"Boolean",
        description:"If false, no submenus will be fetched for this MenuItem. This can be set globally via\n ${isc.DocUtils.linkForRef('attr:Menu.fetchSubmenus')}.",
        flags:"IR",
        name:"fetchSubmenus"
    },
    "attr:StretchImgButton.icon":{
        seeAlso:[
        ],
        defaultValue:"null",
        type:"attr",
        definingClass:"class:StretchImgButton",
        groups:[
            "buttonIcon"
        ],
        ref:"attr:StretchImgButton.icon",
        deprecated:null,
        setter:[
            "setIcon"
        ],
        valueType:"SCImgURL",
        description:"Optional icon to be shown with the button title text.  \n <P>\n Specify as the partial URL to an image, relative to the imgDir of this component.\n A sprited image can be specified using the ${isc.DocUtils.linkForRef('type:SCSpriteConfig')} format.\n <P>\n Note that the string \"blank\" is a valid setting for this attribute and will always \n result in the system blank image, with no state suffixes applied.  Typically, this \n might be used when an iconStyle is also specified and the iconStyle renders the icon via \n a stateful background-image or other CSS approach.",
        flags:"IRW",
        name:"icon"
    },
    "method:DataBoundComponent.getSort":{
        seeAlso:[
        ],
        ref:"method:DataBoundComponent.getSort",
        deprecated:null,
        type:"method",
        definingClass:"interface:DataBoundComponent",
        description:" Return the ${isc.DocUtils.linkForRef('object:SortSpecifier')}s representing the current sort configuration of this\n component.\n",
        flags:"",
        returns:{
            type:"Array of SortSpecifier",
            description:"sortSpecifiersThe current sort specification for this component"
        },
        name:"getSort"
    },
    "method:Array.equals":{
        seeAlso:[
        ],
        type:"method",
        definingClass:"object:Array",
        returns:{
            type:"boolean",
            description:"whether the specified list is equal to this list"
        },
        groups:[
            "access"
        ],
        deprecated:null,
        ref:"method:Array.equals",
        params:[
            {
                defaultValue:null,
                optional:false,
                type:"List",
                description:"list to check for equality",
                name:"list"
            }
        ],
        description:" Return whether this list is equal to another list.\n <P>\n Two lists are equal only if they have the same length and all contained items are in the same\n order and are also equal.\n\n",
        flags:"",
        name:"equals"
    },
    "method:StatefulCanvas.setSelected":{
        groups:[
            "state"
        ],
        seeAlso:[
        ],
        ref:"method:StatefulCanvas.setSelected",
        deprecated:null,
        type:"method",
        definingClass:"class:StatefulCanvas",
        params:[
            {
                defaultValue:null,
                optional:false,
                type:"boolean",
                description:"new boolean value of whether or not the object is                                          selected.",
                name:"newIsSelected"
            }
        ],
        description:" Set this object to be selected or deselected.\n",
        flags:"",
        name:"setSelected"
    },
    "method:ValuesManager.editRecord":{
        groups:[
            "dataBoundComponentMethods"
        ],
        seeAlso:[
            {
                ref:"method:DynamicForm.saveData",
                description:null
            }
        ],
        ref:"method:ValuesManager.editRecord",
        deprecated:null,
        type:"method",
        definingClass:"class:ValuesManager",
        params:[
            {
                defaultValue:null,
                optional:false,
                type:"Record",
                description:"the record to be edited as a map of field names to their corresponding values",
                name:"record"
            }
        ],
        description:"\n Edit an existing record.  Updates this editors values to match the values of the record \n passed in, via ${isc.DocUtils.linkForRef('method:ValuesManager.setValues')}.\n <P>\n This method will also call ${isc.DocUtils.linkForRef('method:DynamicForm.setSaveOperationType')} to ensure \n subsequent calls to <code>saveData()</code> will use an <code>update</code> rather than\n an <code>add</code> operation.\n\n",
        flags:"",
        name:"editRecord"
    },
    "attr:ResultSet.dropCacheOnUpdate":{
        seeAlso:[
        ],
        defaultValue:"false",
        type:"attr",
        definingClass:"class:ResultSet",
        groups:[
            "cacheSync"
        ],
        deprecated:null,
        ref:"attr:ResultSet.dropCacheOnUpdate",
        valueType:"boolean",
        description:"Whether to discard all cached rows when a modification operation (add, update, remove)\n occurs on the ResultSet's DataSource.\n <P>\n A ResultSet that has a complete cache for the current filter criteria can potentially\n incorporate a newly created or updated row based on the data that the server returns\n when a modification operation completes.  However this is not always possible for\n ResultSets that show some types of joins, or when the server cannot easily return update\n data.  In this case set <code>dropCacheOnUpdate</code> to cause the cache to be\n discarded when an update occurs.\n <P>\n <code>dropCacheOnUpdate</code> can be set either directly on a ResultSet, or on a\n DataSource in order to affect all ResultSets on that DataSource.",
        flags:"IRA",
        name:"dropCacheOnUpdate"
    },
    "attr:Canvas.maxHeight":{
        seeAlso:[
            {
                ref:"attr:Canvas.dragMaxHeight",
                description:null
            }
        ],
        defaultValue:"10000",
        type:"attr",
        definingClass:"class:Canvas",
        groups:[
            "sizing"
        ],
        deprecated:null,
        ref:"attr:Canvas.maxHeight",
        valueType:"number",
        description:"Maximum height available to this Canvas.  See ${isc.DocUtils.linkForRef('attr:Canvas.maxWidth')} for details of behavior.",
        flags:"IRWA",
        name:"maxHeight"
    },
    "attr:ColumnTree.customIconProperty":{
        seeAlso:[
        ],
        defaultValue:"\"icon\"",
        type:"attr",
        definingClass:"class:ColumnTree",
        groups:[
            "treeIcons"
        ],
        deprecated:null,
        ref:"attr:ColumnTree.customIconProperty",
        valueType:"String",
        description:"This property allows the developer to customize the icon displayed next to a node.\n Set <code>node[grid.customIconProperty]</code> to the URL of the desired icon to display and\n it will be shown instead of the standard ${isc.DocUtils.linkForRef('attr:ColumnTree.nodeIcon')} for this node.<br>\n Note that if ${isc.DocUtils.linkForRef('attr:ColumnTree.showCustomIconOpen')} \n is true for this grid, customized icons for folder nodes will be appended with the \n ${isc.DocUtils.linkForRef('attr:ColumnTree.openIconSuffix')} suffix on state change,\n as with the standard ${isc.DocUtils.linkForRef('attr:ColumnTree.folderIcon')}.  Also note that for\n custom folder icons, the ${isc.DocUtils.linkForRef('attr:ColumnTree.closedIconSuffix')} will never be appended.",
        flags:"IRW",
        name:"customIconProperty"
    },
    "attr:ListGrid.headerTitleVAlign":{
        seeAlso:[
            {
                ref:"attr:ListGridField.valign",
                description:null
            },
            {
                ref:"attr:ListGrid.rotateHeaderTitles",
                description:null
            },
            {
                ref:"attr:ListGridField.rotateTitle",
                description:null
            }
        ],
        ref:"attr:ListGrid.headerTitleVAlign",
        defaultValue:"Canvas.BOTTOM",
        deprecated:null,
        type:"attr",
        definingClass:"class:ListGrid",
        valueType:"VerticalAlignment",
        description:"When using ${isc.DocUtils.linkForRef('attr:ListGrid.rotateHeaderTitles','rotated titles')}, specifies vertical alignment in the\n column headers: \"top\", \"center\", or \"bottom\".  Can be overridden for individual fields by\n setting ${isc.DocUtils.linkForRef('attr:ListGridField.valign')}.",
        flags:"IR",
        name:"headerTitleVAlign"
    },
    "method:DrawGroup.getGroupRect":{
        seeAlso:[
        ],
        ref:"method:DrawGroup.getGroupRect",
        deprecated:null,
        type:"method",
        definingClass:"class:DrawGroup",
        description:" This method will return an array of integers (left, top, width, height) defining the area\n of the \"group rectangle\" for the group. If ${isc.DocUtils.linkForRef('attr:DrawGroup.useGroupRect','useGroupRect')} is true, this is\n the area of the DrawPane where user interactions will fire event notifications on this DrawGroup.\n <P>\n This is a convienence method to get the current coordinates of the\n ${isc.DocUtils.linkForRef('attr:DrawGroup.useGroupRect','group rectangle')}.  Developers must use\n ${isc.DocUtils.linkForRef('method:DrawGroup.setLeft')}, ${isc.DocUtils.linkForRef('method:DrawGroup.setTop')}, ${isc.DocUtils.linkForRef('method:DrawGroup.setWidth')} or\n ${isc.DocUtils.linkForRef('method:DrawGroup.setHeight')} to set each coordinate directly.\n",
        flags:"",
        returns:{
            type:"Array of int",
            description:"4 element array containing left, top, width, height of the group rectangle."
        },
        name:"getGroupRect"
    },
    "attr:NotifySettings.stackSpacing":{
        seeAlso:[
        ],
        ref:"attr:NotifySettings.stackSpacing",
        defaultValue:"2",
        deprecated:null,
        type:"attr",
        definingClass:"object:NotifySettings",
        valueType:"int",
        description:"Space between each message when ${isc.DocUtils.linkForRef('type:MultiMessageMode')} is \"stack\".",
        flags:"IR",
        name:"stackSpacing"
    },
    "method:Button.setIconOrientation":{
        groups:[
            "buttonIcon"
        ],
        seeAlso:[
        ],
        ref:"method:Button.setIconOrientation",
        deprecated:null,
        type:"method",
        definingClass:"class:Button",
        params:[
            {
                defaultValue:null,
                optional:false,
                type:"String",
                description:"The new orientation of the icon relative to the text of the button.",
                name:"orientation"
            }
        ],
        description:" Changes the orientation of the icon relative to the text of the button.\n\n",
        flags:"",
        name:"setIconOrientation"
    },
    "attr:FormItem.exportFormat":{
        seeAlso:[
        ],
        defaultValue:"null",
        type:"attr",
        definingClass:"class:FormItem",
        groups:[
            "exportFormatting"
        ],
        deprecated:null,
        ref:"attr:FormItem.exportFormat",
        valueType:"FormatString",
        description:"${isc.DocUtils.linkForRef('type:FormatString')} used during exports for numeric or date formatting.  See\n ${isc.DocUtils.linkForRef('attr:DataSourceField.exportFormat')}.",
        flags:"IR",
        name:"exportFormat"
    },
    "method:Array.setSort":{
        seeAlso:[
        ],
        ref:"method:Array.setSort",
        deprecated:null,
        type:"method",
        definingClass:"object:Array",
        params:[
            {
                defaultValue:null,
                optional:false,
                type:"Array of SortSpecifier",
                description:"the list of ${isc.DocUtils.linkForRef('object:SortSpecifier')}s to sort by",
                name:"sortSpecifiers"
            }
        ],
        description:" Sort this Array by a list of ${isc.DocUtils.linkForRef('object:SortSpecifier')}s. \n",
        flags:"",
        returns:{
            type:"Array",
            description:"the array itself"
        },
        name:"setSort"
    },
    "method:SimpleTile.getInnerHTML":{
        seeAlso:[
        ],
        ref:"method:SimpleTile.getInnerHTML",
        deprecated:null,
        type:"method",
        definingClass:"class:SimpleTile",
        description:" The default implementation will call ${isc.DocUtils.linkForRef('method:TileGrid.getTileHTML')}.\n",
        flags:"",
        returns:{
            type:"HTMLString",
            description:"HTML contents for the tile, as a String"
        },
        name:"getInnerHTML"
    },
    "attr:StretchImgButton.iconAlign":{
        seeAlso:[
        ],
        defaultValue:"null",
        type:"attr",
        definingClass:"class:StretchImgButton",
        groups:[
            "buttonIcon"
        ],
        deprecated:null,
        ref:"attr:StretchImgButton.iconAlign",
        valueType:"String",
        description:"If this button is showing an icon should it be right or left aligned?",
        flags:"IR",
        name:"iconAlign"
    },
    "type:ListGridGroupState":{
        groups:[
            "viewState"
        ],
        seeAlso:[
        ],
        ref:"type:ListGridGroupState",
        deprecated:null,
        type:"type",
        description:"An object containing the stored grouping information for a listGrid.\n Note that this object is not intended to be interrogated directly, but may be stored\n (for example) as a blob on the server for state persistence across sessions.",
        name:"ListGridGroupState",
        baseType:"String"
    },
    "type:CSSStyleName":{
        groups:[
            "appearance"
        ],
        seeAlso:[
        ],
        ref:"type:CSSStyleName",
        deprecated:null,
        type:"type",
        description:"CSS class name to apply to some HTML element on this page. This is a string that should\n match the css class defined for the page in an external stylesheet or in inline\n html &lt;STYLE&gt; tags.\n <P>\n As a general rule, wherever it is possible to provide a CSS styleName (such as\n ${isc.DocUtils.linkForRef('attr:Canvas.styleName')} or ${isc.DocUtils.linkForRef('attr:Button.baseStyle')}, your CSS style can specify border,\n margins, padding, and any CSS attributes controlling background or text styling.  You\n should not specify any CSS properties related to positioning, clipping, sizing or\n visibility (such as \"overflow\", \"position\", \"display\", \"visibility\" and \"float\") - use\n SmartClient APIs for this kind of control.\n <P>\n Because text wrapping cannot be consistently controlled cross-browser from CSS alone,\n you should use SmartClient properties such as ${isc.DocUtils.linkForRef('attr:Button.wrap')} instead of the\n corresponding CSS properties, when provided.\n <P>\n Content contained within SmartClient components can use arbitrary CSS, with the\n caveat that the content should be tested on all supported browsers, just as content\n outside of SmartClient must be.\n <P>\n <b>Special note on CSS margins</b>: wherever possible, use CSS padding and border in\n lieu of CSS margins, or non-CSS approaches such as ${isc.DocUtils.linkForRef('attr:Layout.layoutMargin')},\n ${isc.DocUtils.linkForRef('attr:Canvas.snapTo')}, or absolute positioning (including specifying percentage left/top\n coordinates).  We recommend this because CSS specifies a very complicated and widely\n criticized \"margin-collapse\" behavior which has surprising effects when margins exist on\n both parents and children.  Compounding the problem, margins are implemented very\n differently on different browsers, especially when it comes to HTML margins.\n <p>\n <b>Note about CSS \"box models\"</b>\n <p>\n The CSS \"box model\" defines whether the size applied to a DOM element includes padding,\n borders or margins, or whether such settings effectively <b>increase</b> the size of the\n component beyond the size specified in CSS.\n <p>\n In SmartClient, the size configured for a component <i>includes</i> border, padding and\n margins if specified (in CSS terminology, the box model is \"margin-box\").  This allows\n CSS borders, margins and padding to be treated as purely visual properties with no\n effect on sizing or layout.",
        examples:[
            "${isc.DocUtils.linkForExampleId('consistentSizing')}"
        ],
        name:"CSSStyleName",
        baseType:"String"
    },
    "attr:ListGrid.removeFieldProperties":{
        seeAlso:[
        ],
        ref:"attr:ListGrid.removeFieldProperties",
        defaultValue:"null",
        deprecated:null,
        type:"attr",
        definingClass:"class:ListGrid",
        valueType:"ListGridField Properties",
        description:"Configuration properties for the \"remove field\" displayed when\n ${isc.DocUtils.linkForRef('attr:ListGrid.canRemoveRecords')} is enabled.\n These configuration settings will be overlaid\n on top of the ${isc.DocUtils.linkForRef('attr:ListGrid.removeFieldDefaults')}.",
        flags:"IR",
        name:"removeFieldProperties"
    },
    "attr:CubeGrid.hideEmptyFacetValues":{
        seeAlso:[
        ],
        defaultValue:"null",
        type:"attr",
        definingClass:"class:CubeGrid",
        groups:[
            "facetLayout"
        ],
        deprecated:null,
        ref:"attr:CubeGrid.hideEmptyFacetValues",
        valueType:"boolean",
        description:"This causes the headers for any combination of facetValues for which there are no \n cellRecords to be suppressed.\n <P>\n To use this feature, either:\n <ul>\n <li> all must be provided via ${isc.DocUtils.linkForRef('method:ListGrid.setData','setData()')} before the CubeGrid is first drawn, OR\n <li> all data must be returned by the first DataSource fetch, OR\n <li> ${isc.DocUtils.linkForRef('attr:CubeGrid.hideEmptyAxis')} must be set to either \"row\" or \"column\" so that empty values\n are only automatically hidden for one axis\n </ul>\n This last point is required because there is no way to determine whether a row is empty\n unless data for all columns of the row has been loaded (and vice-versa).  For this\n reason if you set hideEmptyFacetValues but do not set hideEmptyAxis, the default\n behavior of ${isc.DocUtils.linkForRef('class:DataSource','loading only visible data')} is automatically disabled and\n only ${isc.DocUtils.linkForRef('attr:CubeGrid.fixedFacetValues')} will be sent as criteria.",
        flags:"IR",
        name:"hideEmptyFacetValues"
    },
    "attr:ResultTree.sendNullParentInLinkDataCriteria":{
        seeAlso:[
        ],
        defaultValue:"true",
        type:"attr",
        definingClass:"class:ResultTree",
        groups:[
            "multiLinkTree"
        ],
        deprecated:null,
        ref:"attr:ResultTree.sendNullParentInLinkDataCriteria",
        valueType:"Boolean",
        description:"For ${isc.DocUtils.linkForRef('method:Tree.isMultiLinkTree','multi-link tree')}s only, should we send up the \n ${isc.DocUtils.linkForRef('attr:Tree.parentIdField','parentId')} in fetch criteria if the criteria value is null?  If \n false, we remove the <code>parentId</code> from the criteria when \n ${isc.DocUtils.linkForRef('attr:ResultTree.linkDataSource','fetching link data')}, <b>if</b> the criteria value is \n null (as it will be by default when fetching the direct child nodes of the tree's root).\n <p>\n Ignored for non-multiLink trees.",
        flags:"IR",
        name:"sendNullParentInLinkDataCriteria"
    },
    "attr:FormItemEditProxy.valueMapSelectedChar":{
        seeAlso:[
        ],
        ref:"attr:FormItemEditProxy.valueMapSelectedChar",
        defaultValue:"\"*\"",
        deprecated:null,
        type:"attr",
        definingClass:"class:FormItemEditProxy",
        valueType:"String",
        description:"If ${isc.DocUtils.linkForRef('type:InlineEditEvent','inline editing')} for this FormItem edits the\n ${isc.DocUtils.linkForRef('attr:FormItem.valueMap')}, character that can be used to mark the default selected\n option.  Can appear before or after a value, for example, with this input:\n <pre>\n     Fixed,Won't Fix,Resolved*\n </pre>\n \"Resolved\" would be the default selected value.\n <p>\n If multiple values are marked selected for a SelectItem,\n ${isc.DocUtils.linkForRef('attr:SelectItem.multiple')} will automatically be set.\n <p>\n The ${isc.DocUtils.linkForRef('attr:FormItemEditProxy.valueMapEscapeChar','valueMapEscapeChar')} can be used to allow the\n <code>valueMapSelectedChar</code> to appear at the beginning or end of a  \n valueMap value.",
        flags:"IR",
        name:"valueMapSelectedChar"
    },
    "attr:DataSourceField.autoGenerated":{
        seeAlso:[
            {
                ref:"attr:DataSourceField.sequenceName",
                description:null
            },
            {
                ref:"type:FieldType",
                description:null
            },
            {
                ref:"type:SequenceMode",
                description:null
            }
        ],
        defaultValue:"null",
        type:"attr",
        definingClass:"object:DataSourceField",
        groups:[
            "dataType"
        ],
        ref:"attr:DataSourceField.autoGenerated",
        deprecated:null,
        valueType:"boolean",
        description:"Indicates that values for this field are automatically generated by the database or ORM \n provider.  Setting this flag makes the field behave somewhat like a \n ${isc.DocUtils.linkForRef('attr:DataSourceField.sequenceName','sequence field')}, in that server-side logic does not expect client code\n to provide values for the field on \"add\" operations.  However, it is not entirely the same\n as a sequence:<ul>\n <li>Sequences must be integers, whereas autoGenerated fields can be of any type</li>\n <li>SmartClient Server's DataSource implementations are capable of discovering the value \n     that was generated by the database for sequence fields, which may not be possible \n     with an autoGenerated field.  See the docs for \n     ${isc.DocUtils.linkForRef('attr:DataSourceField.customInsertExpression','customInsertExpression')} for a discussion\n     of this</li>\n </ul>\n Unrelated to the <code>autoGenerated</code> flag, you have a general ability for field \n values to be generated by application code (as opposed to being generated by the database\n or ORM provider).  For example, you can use ${isc.DocUtils.linkForRef('group:dmiOverview','DMI methods')}, \n ${isc.DocUtils.linkForRef('group:serverScript','server scripts')}, or ${isc.DocUtils.linkForRef('group:customQuerying','custom SQL')}.  (Note, \n if you want to have application code generate values for primaryKey fields, you may need to\n use an ${isc.DocUtils.linkForRef('class:OperationBinding','operationBinding')} that specifies \n ${isc.DocUtils.linkForRef('attr:OperationBinding.providesMissingKeys','providesMissingKeys')}).",
        flags:"IR",
        serverDS:"only",
        name:"autoGenerated"
    },
    "attr:ResultTree.autoOpen":{
        seeAlso:[
        ],
        ref:"attr:ResultTree.autoOpen",
        defaultValue:"\"none\"",
        deprecated:null,
        type:"attr",
        definingClass:"class:ResultTree",
        valueType:"String",
        description:"Which nodes should be opened automatically - applied whenever \n ${isc.DocUtils.linkForRef('method:Tree.setRoot','setRoot()')} is called, including during initialization and as part of \n a re-fetch caused, for example, by ${isc.DocUtils.linkForRef('method:Tree.duplicate','duplicate()')} or \n ${isc.DocUtils.linkForRef('method:ResultTree.invalidateCache','invalidateCache()')}.\n <P>\n Options are:\n <ul>\n <li>\"none\" - no nodes are opened automatically</li>\n <li>\"root\" - opens the ${isc.DocUtils.linkForRef('attr:ResultTree.rootNode','top-level node')} - in databound \n              trees, this node is always hidden</li>\n <li>\"all\" - when ${isc.DocUtils.linkForRef('attr:ResultTree.loadDataOnDemand','loading data on demand')}, opens the\n             ${isc.DocUtils.linkForRef('attr:ResultTree.rootNode','top-level node')} and all of it's direct\n             descendants - otherwise, opens all loaded nodes </li>\n </ul>",
        flags:"IRW",
        name:"autoOpen"
    },
    "method:Menu.setItemEnabled":{
        seeAlso:[
        ],
        ref:"method:Menu.setItemEnabled",
        deprecated:null,
        type:"method",
        definingClass:"class:Menu",
        params:[
            {
                defaultValue:null,
                optional:false,
                type:"MenuItem | number",
                description:"MenuItem in question, or it's index",
                name:"item"
            },
            {
                defaultValue:null,
                optional:true,
                type:"boolean",
                description:"true to enable the menu item, false to disable it.  If not                             passed, true is assumed",
                name:"newState"
            }
        ],
        description:" Enables or disables the menu item according to the value of newState, and redraws\n the menu if necessary. Returns true if there's a change in the enabled state.\n\n",
        flags:"",
        returns:{
            type:"boolean",
            description:"true if the enabled state was changed"
        },
        name:"setItemEnabled"
    },
    "attr:SCStatefulImgConfig.Selected":{
        seeAlso:[
        ],
        ref:"attr:SCStatefulImgConfig.Selected",
        defaultValue:"null",
        deprecated:null,
        type:"attr",
        definingClass:"object:SCStatefulImgConfig",
        valueType:"String",
        description:"Image to display when the component is ${isc.DocUtils.linkForRef('attr:StatefulCanvas.selected','selected')}.\n <P>\n May be specified as \n <ul><li>A ${isc.DocUtils.linkForRef('type:SCImgURL')} indicating the media to load</li>\n     <li>A reference to another entry in this SCStatefulImgConfig via the format \n         <code>\"#state:<i>otherStateName</i>\"</code></li>\n     <li>A modifier to apply to the ${isc.DocUtils.linkForRef('attr:SCStatefulImgConfig._base')} media via the\n         format <code>\"#modifier:<i>modifierString</i>\"</code></li>\n </ul>\n See ${isc.DocUtils.linkForRef('object:SCStatefulImgConfig','SCStatefulImgConfig overview')} for further information.",
        flags:"IRW",
        name:"Selected"
    },
    "attr:Button.selected":{
        seeAlso:[
        ],
        defaultValue:"false",
        type:"attr",
        definingClass:"class:Button",
        groups:[
            "state"
        ],
        ref:"attr:Button.selected",
        deprecated:null,
        setter:[
            "setSelected"
        ],
        valueType:"Boolean",
        description:"Whether this component is selected.  For some components, selection affects appearance.",
        flags:"IRW",
        name:"selected"
    },
    "classMethod:XMLTools.toJS":{
        seeAlso:[
        ],
        type:"classMethod",
        definingClass:"class:XMLTools",
        returns:{
            type:"Object",
            description:"The resulting JavaScript collection."
        },
        deprecated:null,
        ref:"classMethod:XMLTools.toJS",
        params:[
            {
                defaultValue:null,
                optional:false,
                type:"XMLElement | XMLDocument",
                description:"The element to transform to JS",
                name:"element"
            }
        ],
        description:" Translates an XML fragment to JavaScript collections.  This method works just like the\n server-side method XML.toJS(Element, Writer):\n <ul>\n <li>  Elements become JavaScript Objects with each attribute becoming a property\n <li>  Subelements with just text (no child elements or attributes) become properties\n <li>  Subelements with child elements or attributes become sub objects\n </ul>\n For example, if you pass the following fragment to this method:\n <pre>\n &lt;foo&nbsp;bar=\"zoo\"&gt;\n     &nbsp;&nbsp;&lt;x&gt;y&lt;/x&gt;\n &lt;/foo&gt;\n </pre>\n You will get back the following JS structure: \n <pre>\n { bar:\"zoo\", x:\"y\"}\n </pre>\n All atomic property values will be of String type.  Use ${isc.DocUtils.linkForRef('method:DataSource.recordsFromXML')}\n to do schema-driven XML to JS transform, which can produce correctly typed values.\n \n",
        flags:"",
        examples:[
            "${isc.DocUtils.linkForExampleId('xmlServerValidationErrors')}"
        ],
        name:"toJS"
    },
    "attr:TimeItem.hourMinValue":{
        seeAlso:[
        ],
        ref:"attr:TimeItem.hourMinValue",
        defaultValue:"null",
        deprecated:null,
        type:"attr",
        definingClass:"class:TimeItem",
        valueType:"Number",
        description:"When ${isc.DocUtils.linkForRef('attr:TimeItem.useTextField','useTextField')} is false and \n ${isc.DocUtils.linkForRef('attr:TimeItem.hourValues','hourValues')} is unset, this attribute specifies the minimum\n value present in the hour picker.\n <P>Used for specifying a limited set of valid Hour values, or when using the \n TimeItem to record duration, rather than time per-se.  The default is zero in all cases.\n <P> See also ${isc.DocUtils.linkForRef('attr:TimeItem.hourMaxValue','hourMaxValue')} and \n ${isc.DocUtils.linkForRef('attr:TimeItem.hourIncrement','hourIncrement')}.",
        flags:"IRW",
        name:"hourMinValue"
    },
    "method:NavigationBar.setShowRightButton":{
        seeAlso:[
        ],
        ref:"method:NavigationBar.setShowRightButton",
        deprecated:null,
        type:"method",
        definingClass:"class:NavigationBar",
        params:[
            {
                defaultValue:null,
                optional:false,
                type:"Boolean",
                description:"if <code>false</code>, then the <code>rightButton</code> will be hidden. If unset or <code>true</code> then the <code>rightButton</code> will be shown as\n long as it is a member of the <code>controls</code> array.",
                name:"show"
            }
        ],
        description:" Show or hide the ${isc.DocUtils.linkForRef('attr:NavigationBar.rightButton','rightButton')}. The <code>rightButton</code>\n must be a ${isc.DocUtils.linkForRef('attr:NavigationBar.controls','control')} of this <code>NavigationBar</code> or else it will\n still be hidden.\n",
        flags:"",
        name:"setShowRightButton"
    },
    "attr:ListGrid.selectionManager":{
        seeAlso:[
        ],
        defaultValue:"null",
        type:"attr",
        definingClass:"class:ListGrid",
        groups:[
            "selection"
        ],
        deprecated:null,
        ref:"attr:ListGrid.selectionManager",
        valueType:"Selection | CellSelection | MultiLinkSelection",
        description:"The ${isc.DocUtils.linkForRef('group:selection','Selection object')} associated with the <code>ListGrid</code>.",
        flags:"RA",
        name:"selectionManager"
    },
    "method:FormItemIcon.click":{
        seeAlso:[
        ],
        type:"method",
        definingClass:"object:FormItemIcon",
        returns:{
            type:"boolean",
            description:"Return false to cancel the event."
        },
        groups:[
            "formIcons"
        ],
        ref:"method:FormItemIcon.click",
        deprecated:null,
        params:[
            {
                defaultValue:null,
                optional:false,
                type:"DynamicForm",
                description:"The Dynamic Form to which this icon's item belongs.",
                name:"form"
            },
            {
                defaultValue:null,
                optional:false,
                type:"FormItem",
                description:"The Form Item containing this icon",
                name:"item"
            },
            {
                defaultValue:null,
                optional:false,
                type:"FormItemIcon",
                description:"A pointer to the form item icon clicked",
                name:"icon"
            }
        ],
        description:" Click handler for this icon.\n <P>\n \n Return false to cancel this event. \n \n \n If this event is not cancelled by the icon-level click handler, it may also\n be handled at the FormItem level via ${isc.DocUtils.linkForRef('method:FormItem.pickerIconClick')} [for the\n picker icon only], and then ${isc.DocUtils.linkForRef('method:FormItem.iconClick')}\n\n",
        flags:"",
        examples:[
            "${isc.DocUtils.linkForExampleId('formIcons')}"
        ],
        name:"click"
    },
    "method:ResultSet.indexOf":{
        seeAlso:[
        ],
        type:"method",
        definingClass:"class:ResultSet",
        returns:{
            type:"number",
            description:"position of the item, if found, -1 if not found"
        },
        groups:[
            "access"
        ],
        deprecated:null,
        ref:"method:ResultSet.indexOf",
        params:[
            {
                defaultValue:null,
                optional:false,
                type:"Any",
                description:"object to look for",
                name:"obj"
            },
            {
                defaultValue:null,
                optional:true,
                type:"number",
                description:"earliest index to consider",
                name:"pos"
            },
            {
                defaultValue:null,
                optional:true,
                type:"number",
                description:"last index to consider",
                name:"endPos"
            }
        ],
        description:" Return the position in the list of the first instance of the specified object.\n <p>\n If pos is specified, starts looking after that position.\n <p>\n Returns -1 if not found.\n <p>\n <b>NOTE:</b> ResultSet.indexOf() only inspects the current cache of records, so it is only\n appropriate for temporary presentation purposes.  For example, it would not be appropriate\n to hold onto a record and attempt to use indexOf() to determine if it had been deleted.\n\n",
        flags:"",
        name:"indexOf"
    },
    "object:NavItem":{
        seeAlso:[
        ],
        type:"object",
        staticMethods:[
        ],
        inheritsFrom:"TreeNode",
        classMethods:[
        ],
        classAttrs:[
        ],
        attrs:[
            "attr:NavItem.id",
            "attr:NavItem.title",
            "attr:NavItem.icon",
            "attr:NavItem.items",
            "attr:NavItem.isHeader",
            "attr:NavItem.customStyle",
            "attr:NavItem.isSeparator",
            "attr:NavItem.pane"
        ],
        ref:"object:NavItem",
        deprecated:null,
        treeLocation:[
            "Client Reference/Layout/NavPanel"
        ],
        description:"Properties for a navigation item in a ${isc.DocUtils.linkForRef('class:NavPanel')}.",
        methods:[
        ],
        name:"NavItem"
    },
    "attr:Label.valign":{
        seeAlso:[
        ],
        defaultValue:"Canvas.CENTER",
        type:"attr",
        definingClass:"class:Label",
        groups:[
            "positioning"
        ],
        deprecated:null,
        ref:"attr:Label.valign",
        valueType:"VerticalAlignment",
        description:"Vertical alignment of label text. See VerticalAlignment type for details.",
        flags:"IRW",
        name:"valign"
    },
    "attr:FormItemIcon.neverDisable":{
        seeAlso:[
        ],
        defaultValue:"null",
        type:"attr",
        definingClass:"object:FormItemIcon",
        groups:[
            "formIcons"
        ],
        deprecated:null,
        ref:"attr:FormItemIcon.neverDisable",
        valueType:"boolean",
        description:"If <code>icon.neverDisable</code> is true, when this form item is disabled, the \n icon will remain enabled. \n Note that disabling the entire form will disable all items, together with their \n icons including those marked as neverDisable - this property only has an effect \n if the form is enabled and a specific item is disabled within it.\n <P>\n If this property is true, the icons will also remain enabled if a form item \n is marked as ${isc.DocUtils.linkForRef('attr:FormItem.canEdit','canEdit:false')}. For finer grained control over\n whether icons are enabled for read-only icons see ${isc.DocUtils.linkForRef('attr:FormItem.disableIconsOnReadOnly')}\n and ${isc.DocUtils.linkForRef('attr:FormItemIcon.disableOnReadOnly')}",
        flags:"IRWA",
        name:"neverDisable"
    },
    "attr:SelectItem.showFocused":{
        seeAlso:[
            {
                ref:"attr:FormItem.cellStyle",
                description:null
            }
        ],
        defaultValue:"true, [IRWA]",
        type:"attr",
        definingClass:"class:SelectItem",
        groups:[
            "formItemStyling"
        ],
        deprecated:null,
        ref:"attr:SelectItem.showFocused",
        valueType:"Boolean",
        description:"When this item receives focus, should it be re-styled to indicate it has focus?\n <P>\n See ${isc.DocUtils.linkForRef('group:formItemStyling')} for more details on formItem styling.",
        flags:"IRWA",
        name:"showFocused"
    },
    "attr:PortalLayout.preventColumnUnderflow":{
        seeAlso:[
        ],
        defaultValue:"true",
        type:"attr",
        definingClass:"class:PortalLayout",
        groups:[
            "sizing"
        ],
        ref:"attr:PortalLayout.preventColumnUnderflow",
        deprecated:null,
        valueType:"Boolean",
        description:"Controls whether the last ${isc.DocUtils.linkForRef('class:Portlet')} in a column will be stretched to fill the column's height,\n or left at its specified height.",
        flags:"IRW",
        examples:[
            "${isc.DocUtils.linkForExampleId('portletHeight')}"
        ],
        name:"preventColumnUnderflow"
    },
    "attr:DrawLabel.editProxyConstructor":{
        seeAlso:[
        ],
        ref:"attr:DrawLabel.editProxyConstructor",
        defaultValue:"\"DrawLabelEditProxy\"",
        deprecated:null,
        type:"attr",
        definingClass:"class:DrawLabel",
        valueType:"SCClassName",
        description:"Default class used to construct the ${isc.DocUtils.linkForRef('class:EditProxy')} for this component\n when the component is ${isc.DocUtils.linkForRef('method:Canvas.setEditMode','first placed into edit mode')}.",
        flags:"IR",
        name:"editProxyConstructor"
    },
    "method:Class.logIsEnabledFor":{
        seeAlso:[
        ],
        ref:"method:Class.logIsEnabledFor",
        deprecated:null,
        type:"method",
        definingClass:"class:Class",
        params:[
            {
                defaultValue:null,
                optional:false,
                type:"LogPriority",
                description:"priority level",
                name:"priority"
            },
            {
                defaultValue:null,
                optional:true,
                type:"String",
                description:"category to log in",
                name:"category"
            }
        ],
        description:" Check whether a message logged at the given priority would be visible in the log.\n <P>\n As with logDebug, category is defaulted to the current className.  Use this method to avoid\n putting together expensive log messages if they will never appear in the log.\n\n",
        flags:"",
        name:"logIsEnabledFor"
    },
    "attr:ListGridField.hoverWrap":{
        seeAlso:[
        ],
        ref:"attr:ListGridField.hoverWrap",
        defaultValue:"null",
        deprecated:null,
        type:"attr",
        definingClass:"object:ListGridField",
        valueType:"Boolean",
        description:"This property may be set to customize the <code>wrap</code> attribute for the\n canvas shown when the mouse hovers over cells in this field. Note that this causes a \n soft-wrap - if set, the hover text will wrap at word boundaries.\n <P>\n If unset, default behavior is derived from ${isc.DocUtils.linkForRef('attr:ListGrid.headerHoverWrap')}.",
        flags:"IRW",
        name:"hoverWrap"
    },
    "method:RelativeDateItem.getFiscalCalendar":{
        seeAlso:[
        ],
        ref:"method:RelativeDateItem.getFiscalCalendar",
        deprecated:null,
        type:"method",
        definingClass:"class:RelativeDateItem",
        description:" Returns the ${isc.DocUtils.linkForRef('object:FiscalCalendar')} object that will be used by this item's DateChooser.\n\n",
        flags:"",
        returns:{
            type:"FiscalCalendar",
            description:"the fiscal calendar for this chooser, if set, or the global            one otherwise"
        },
        name:"getFiscalCalendar"
    },
    "method:ImgSectionHeader.titleHover":{
        groups:[
            "hovers"
        ],
        seeAlso:[
            {
                ref:"attr:ImgSectionHeader.clipTitle",
                description:null
            },
            {
                ref:"method:ImgSectionHeader.titleClipped",
                description:null
            }
        ],
        ref:"method:ImgSectionHeader.titleHover",
        deprecated:null,
        type:"method",
        definingClass:"class:ImgSectionHeader",
        description:" Optional stringMethod to fire when the user hovers over this section header and the title is\n clipped. If ${isc.DocUtils.linkForRef('attr:ImgSectionHeader.showClippedTitleOnHover')} is true, the default behavior is to\n show a hover canvas containing the HTML returned by ${isc.DocUtils.linkForRef('method:ImgSectionHeader.titleHoverHTML')}.\n Return false to suppress this default behavior.\n",
        flags:"",
        returns:{
            type:"boolean",
            description:"false to suppress the standard hover"
        },
        name:"titleHover"
    },
    "attr:TileLayout.tileSize":{
        seeAlso:[
        ],
        defaultValue:"100",
        type:"attr",
        definingClass:"class:TileLayout",
        groups:[
            "sizing"
        ],
        ref:"attr:TileLayout.tileSize",
        deprecated:null,
        setter:[
            "setTileSize"
        ],
        valueType:"int",
        description:"Size of each tile in pixels.  Depending on the ${isc.DocUtils.linkForRef('type:LayoutPolicy')}, <code>tileSize</code>\n may be taken as a maximum, minimum or exact size of tiles, or may be irrelevant.\n <P>\n Width and height may be separately set via ${isc.DocUtils.linkForRef('attr:TileLayout.tileHeight')} and ${isc.DocUtils.linkForRef('attr:TileLayout.tileWidth')}.",
        flags:"IR",
        name:"tileSize"
    },
    "classMethod:Messaging.subscribe":{
        groups:[
            "messaging"
        ],
        seeAlso:[
        ],
        ref:"classMethod:Messaging.subscribe",
        deprecated:null,
        type:"classMethod",
        definingClass:"class:Messaging",
        params:[
            {
                defaultValue:null,
                optional:false,
                type:"String",
                description:null,
                name:"channel"
            },
            {
                defaultValue:null,
                optional:false,
                type:"MessagingCallback",
                description:"callback fired whenever data is sent to this channel",
                name:"callback"
            },
            {
                defaultValue:null,
                optional:false,
                type:"Callback",
                description:"callback fired when the subscription is established",
                name:"subscribeCallback"
            },
            {
                defaultValue:null,
                optional:true,
                type:"String",
                description:"JMS selector used with Queues to filter the messages that arrive  to the channel (optional).",
                name:"selector"
            }
        ],
        description:" Subscribes the client to the messaging channel identified by channel.\n <p>\n When the server or another connected browser sends a message on this channel, the callback \n will be invoked with a single 'data' parameter containing the data that was just sent to the\n channel.\n <p>\n Calling subscribe() again for a channel you are already subscribed to will result in the new\n callback replacing the old, and will cause the server connection to be re-established.\n\n",
        flags:"",
        name:"subscribe"
    },
    "method:ListGrid.getIconCursor":{
        seeAlso:[
        ],
        ref:"method:ListGrid.getIconCursor",
        deprecated:null,
        type:"method",
        definingClass:"class:ListGrid",
        params:[
            {
                defaultValue:null,
                optional:false,
                type:"ListGridField",
                description:"field displaying the icon",
                name:"field"
            }
        ],
        description:" Returns the cursor to display when the mouse pointer is\n over an ${isc.DocUtils.linkForRef('attr:ListGridField.icon','icon')} in an <code>\"icon\"</code> type field.\n <P>\n Default behavior will display the ${isc.DocUtils.linkForRef('attr:ListGridField.iconCursor')} if specified, otherwise\n the component level ${isc.DocUtils.linkForRef('attr:ListGrid.iconCursor')}.\n\n",
        flags:"",
        returns:{
            type:"Cursor",
            description:"cursor to display when the user rolls over icons in this field's cells"
        },
        name:"getIconCursor"
    },
    "attr:ListGrid.hoverStyle":{
        seeAlso:[
            {
                ref:"attr:ListGrid.showHover",
                description:null
            }
        ],
        defaultValue:"\"gridHover\"",
        type:"attr",
        definingClass:"class:ListGrid",
        groups:[
            "hovers"
        ],
        deprecated:null,
        ref:"attr:ListGrid.hoverStyle",
        valueType:"CSSStyleName",
        description:"Style to apply to hovers shown over this grid.",
        flags:"IRWA",
        name:"hoverStyle"
    },
    "method:Canvas.getContents":{
        seeAlso:[
        ],
        ref:"method:Canvas.getContents",
        deprecated:null,
        type:"method",
        definingClass:"class:Canvas",
        description:"      Returns the contents of a Canvas. The contents are an HTML string.\n",
        flags:"",
        returns:{
            type:"HTMLString",
            description:"contents of this Canvas"
        },
        name:"getContents"
    },
    "method:Canvas.shouldDragScroll":{
        groups:[
            "events",
            "dragdrop"
        ],
        seeAlso:[
        ],
        ref:"method:Canvas.shouldDragScroll",
        deprecated:null,
        type:"method",
        definingClass:"class:Canvas",
        description:" If this widget is showing scrollbars, and a user drags close to the edge of the viewport,\n should we scroll the viewport in the appropriate direction?\n Returns this.canDragScroll if there are scrollbars, else false.\n",
        flags:"A",
        name:"shouldDragScroll"
    },
    "method:FacetChart.getDataLineColor":{
        seeAlso:[
            {
                ref:"method:FacetChart.getDataColor",
                description:null
            },
            {
                ref:"method:FacetChart.getDataLineWidth",
                description:null
            }
        ],
        ref:"method:FacetChart.getDataLineColor",
        deprecated:null,
        type:"method",
        definingClass:"class:FacetChart",
        params:[
            {
                defaultValue:null,
                optional:false,
                type:"Number",
                description:"index of the legend facet value to be colored",
                name:"index"
            },
            {
                defaultValue:null,
                optional:false,
                type:"String | Number | Date",
                description:"id of the legend facet value to be colored",
                name:"facetValueId"
            },
            {
                defaultValue:null,
                optional:false,
                type:"String",
                description:"purpose for the requested color - such as \"legend\", \"line\",                         \"area\", \"points\", etc.",
                name:"purpose"
            }
        ],
        description:" Specifies the color to use for data lines in the chart.  No default implementation.  If not\n defined or null is returned, the Framework will default to value of ${isc.DocUtils.linkForRef('method:FacetChart.getDataColor')}.\n \n <P>\n Note that this method is simply an override point, since it has no default implementation -\n must return a color in the format of of a leading hash (#) plus 6 hexadecimal digits as\n specified for ${isc.DocUtils.linkForRef('attr:FacetChart.dataColors')}.\n \n\n",
        flags:"",
        returns:{
            type:"CSSColor",
            description:"color to use for data lines or null to default to ${isc.DocUtils.linkForRef('method:FacetChart.getDataColor')}"
        },
        name:"getDataLineColor"
    },
    "method:ListGrid.updateRecordComponent":{
        seeAlso:[
        ],
        ref:"method:ListGrid.updateRecordComponent",
        deprecated:null,
        type:"method",
        definingClass:"class:ListGrid",
        params:[
            {
                defaultValue:null,
                optional:false,
                type:"ListGridRecord",
                description:"record to which the passed component applies",
                name:"record"
            },
            {
                defaultValue:null,
                optional:false,
                type:"Integer",
                description:"cell to which the passed component applies",
                name:"colNum"
            },
            {
                defaultValue:null,
                optional:false,
                type:"Canvas",
                description:"the component to update",
                name:"component"
            },
            {
                defaultValue:null,
                optional:false,
                type:"boolean",
                description:"was the passed component previously embedded in a     different record?",
                name:"recordChanged"
            }
        ],
        description:" When ${isc.DocUtils.linkForRef('attr:ListGrid.showRecordComponents')} is true, this method is called to update\n components created by ${isc.DocUtils.linkForRef('method:ListGrid.createRecordComponent')} when they are to be\n applied to a different record in the grid. See the\n ${isc.DocUtils.linkForRef('attr:ListGrid.showRecordComponents','record components overview')}\n for more information on recordComponents.\n <P>\n The colNum parameter is applicable only when\n ${isc.DocUtils.linkForRef('attr:ListGrid.showRecordComponentsByCell')} is true. Note that if\n ${isc.DocUtils.linkForRef('attr:ListGrid.poolComponentsPerColumn')} is set to false, the component may have been generated\n by a ${isc.DocUtils.linkForRef('method:ListGrid.createRecordComponent')} call applied to a different field.\n <P>\n Return null to avoid re-adding the component to the row or cell.\n\n",
        flags:"",
        returns:{
            type:"Canvas",
            description:"return the component to embed in the passed record"
        },
        name:"updateRecordComponent"
    },
    "method:Canvas.moveTo":{
        seeAlso:[
        ],
        type:"method",
        definingClass:"class:Canvas",
        returns:{
            type:"boolean",
            description:"whether the component actually moved"
        },
        groups:[
            "positioning"
        ],
        ref:"method:Canvas.moveTo",
        deprecated:null,
        params:[
            {
                defaultValue:null,
                optional:true,
                type:"number | Object",
                description:"x-coordinate to move to in LOCAL coordinates                                             or Object with left and top properties.",
                name:"left"
            },
            {
                defaultValue:null,
                optional:true,
                type:"number",
                description:"y-coordinate to move to in LOCAL coordinates",
                name:"top"
            }
        ],
        description:" Moves the widget so that its top-left corner is at the specified coordinates.\n <P>\n This method will also accept a single parameter as an object array with left and top given\n as properties.\n\n",
        flags:"",
        examples:[
            "${isc.DocUtils.linkForExampleId('move')}"
        ],
        name:"moveTo"
    },
    "attr:TabBar.moreTab":{
        seeAlso:[
        ],
        ref:"attr:TabBar.moreTab",
        defaultValue:"null",
        deprecated:null,
        type:"attr",
        definingClass:"class:TabBar",
        valueType:"Tab",
        description:"Tab to show as the \"more\" tab when ${isc.DocUtils.linkForRef('attr:TabBar.showMoreTab')} is enabled and the number\n of tabs to show exceeds ${isc.DocUtils.linkForRef('attr:TabBar.moreTabCount')}.",
        flags:"IR",
        name:"moreTab"
    },
    "class:SimpleType":{
        seeAlso:[
        ],
        type:"class",
        staticMethods:[
        ],
        inheritsFrom:"Class",
        classMethods:[
            "classMethod:SimpleType.getType",
            "classMethod:SimpleType.registerSummaryFunction",
            "classMethod:SimpleType.setDefaultSummaryFunction",
            "classMethod:SimpleType.getDefaultSummaryFunction",
            "classMethod:SimpleType.applySummaryFunction"
        ],
        classAttrs:[
        ],
        attrs:[
            "attr:SimpleType.name",
            "attr:SimpleType.inheritsFrom",
            "attr:SimpleType.validators",
            "attr:SimpleType.valueMap",
            "attr:SimpleType.editorType",
            "attr:SimpleType.readOnlyEditorType",
            "attr:SimpleType.filterEditorType",
            "attr:SimpleType.fieldProperties",
            "attr:SimpleType.format",
            "attr:SimpleType.exportFormat",
            "attr:SimpleType.validOperators",
            "attr:SimpleType.defaultOperator",
            "attr:SimpleType.groupingModes",
            "attr:SimpleType.defaultGroupingMode"
        ],
        ref:"class:SimpleType",
        deprecated:null,
        treeLocation:[
            "Client Reference/Data Binding"
        ],
        description:"An atomic type such as a string or number, that is generally stored, displayed and\n manipulated as a single value.\n <P>\n SimpleTypes can be created at any time, and subsequently referred to as a \n ${isc.DocUtils.linkForRef('attr:DataSourceField.type','field type')} in ${isc.DocUtils.linkForRef('class:DataSource','DataSources')} and\n ${isc.DocUtils.linkForRef('interface:DataBoundComponent','DataBoundComponents')}.  This allows you to define\n ${isc.DocUtils.linkForRef('attr:SimpleType.validators','validation')}, ${isc.DocUtils.linkForRef('method:SimpleType.normalDisplayFormatter','formatting')}\n and ${isc.DocUtils.linkForRef('attr:SimpleType.editorType','editing')} behaviors for a type to be reused across all\n ${isc.DocUtils.linkForRef('interface:DataBoundComponent','DataBoundComponents')}.\n <P>\n The SimpleType class also allows data to be stored in some opaque format but treated as\n simple atomic values as far as SmartClient components are concerned by implementing\n ${isc.DocUtils.linkForRef('method:SimpleType.getAtomicValue')} and ${isc.DocUtils.linkForRef('method:SimpleType.updateAtomicValue')} methods.\n For example, if some record has a field value set to a javascript object with the\n following properties:\n <pre>\n { stringValue:\"A String\", length: 9 }\n </pre>\n this value could be treated as a simple string by defining a SimpleType with \n ${isc.DocUtils.linkForRef('attr:SimpleType.inheritsFrom')} set to <code>\"text\"</code> and a custom \n <code>getAtomicValue()</code> method that simply extracted the <i>\"stringValue\"</i>\n attribute from the data object. DataBoundComponents would then display\n the string value, and use it for sorting and other standard databinding features.\n <P>\n Note that the term \"simpleType\" is used in the same sense as in\n <a href='XML Schema' target='_blank'>http://www.w3.org/TR/xmlschema-0/</a>, and\n ${isc.DocUtils.linkForRef('classMethod:XMLTools.loadXMLSchema')} will create new SimpleType definitions.\n <P>\n When using the SmartClient Server, SimpleTypes can be defined server-side, and should\n be defined server-side if validators are going to be declared so that the server will\n enforce validation. To define server-side SimpleTypes using Component XML you should create\n file {typeName}.type.xml in the following format:\n <pre>\n   &lt;SimpleType name=\"{typeName}\" inheritsFrom=\"{otherSimpleType}\" \n                  editorType=\"{FormItemClassName}\"&gt;\n     &lt;validators&gt;\n       &lt;!-- validator definition just like DataSourceField --&gt;\n     &lt;/validators&gt;\n   &lt;/SimpleType&gt;\n </pre>\n .. and place this file alongside your DataSource files (.ds.xml) files - in any of folders\n listed in <code>project.datasources</code> property in ${isc.DocUtils.linkForRef('group:server_properties','server.properties')}.\n <P>\n SimpleTypes can be loaded via DataSourceLoader or ${isc.DocUtils.linkForRef('group:loadDSTag','loadDS JSP tags')} and\n should be loaded <b>before</b> the definitions of any DataSources that use them (so\n generally put all SimpleType definitions first).\n <P>\n Define validators in the server-side type definition, for example:\n <pre>\n   &lt;SimpleType name=\"countryCodeType\" inheritsFrom=\"text\"&gt;\n     &lt;validators&gt;\n       &lt;validator type=\"lengthRange\" min=\"2\" max=\"2\"\n         errorMessage=\"Length of country code should be equal to 2.\" /&gt;\n       &lt;validator type=\"regexp\" expression=\"[A-Z][A-Z]\"\n         errorMessage=\"CountryCode should have only uppercase letters.\" /&gt;\n     &lt;/validators&gt;\n   &lt;/SimpleType&gt;\n </pre>\n <P>\n For client-side formatters, add these to the type definition after loading it from the\n server, for example:\n \n   <pre>\n     isc.SimpleType.getType(\"independenceDateType\").addProperties({\n         normalDisplayFormatter : function (value) {\n             if (value == null) return \"\";\n             return \"&lt;i&gt;\" + (value.getYear() + 1900) + \"&lt;/i&gt;\";\n         }\n     });\n   </pre>\n \n \n Note that formatters must be added to the SimpleType definition <b>before</b> any\n DataBoundComponent binds to a DataSource that uses the SimpleType.\n <p>\n An example is ${isc.DocUtils.linkForExampleId('formsCustomSimpleType', 'here')}.\n ",
        methods:[
            "method:SimpleType.getAtomicValue",
            "method:SimpleType.updateAtomicValue",
            "method:SimpleType.compareValues",
            "method:SimpleType.shortDisplayFormatter",
            "method:SimpleType.normalDisplayFormatter",
            "method:SimpleType.editFormatter",
            "method:SimpleType.parseInput",
            "method:SimpleType.getGroupingModes",
            "method:SimpleType.getGroupValue",
            "method:SimpleType.getGroupTitle"
        ],
        serverDS:"allowed",
        examples:[
            "${isc.DocUtils.linkForExampleId('extCustomSimpleType')}"
        ],
        name:"SimpleType"
    },
    "method:DataBoundComponent.findAll":{
        seeAlso:[
        ],
        ref:"method:DataBoundComponent.findAll",
        deprecated:null,
        type:"method",
        definingClass:"interface:DataBoundComponent",
        params:[
            {
                defaultValue:null,
                optional:false,
                type:"AdvancedCriteria",
                description:"AdvancedCriteria to use with",
                name:"advancedCriteria"
            }
        ],
        description:" This API is equivalent to ${isc.DocUtils.linkForRef('method:List.findAll')} but searches for a matching record among already-loaded data only.  \n Use ${isc.DocUtils.linkForRef('method:ListGrid.fetchData','fetchData')} to load data from the server.\n",
        flags:"",
        returns:{
            type:"Array",
            description:"all matching Objects or null if none found"
        },
        name:"findAll"
    },
    "attr:ListGrid.originBaseStyle":{
        seeAlso:[
        ],
        ref:"attr:ListGrid.originBaseStyle",
        defaultValue:"null",
        deprecated:null,
        type:"attr",
        definingClass:"class:ListGrid",
        valueType:"CSSStyleName",
        description:"Name of a CSS Style to use as the ${isc.DocUtils.linkForRef('attr:ListGrid.baseStyle')} for a cell that\n is currently a selection origin for shifted incremental cell selection.\n Only has an effect if ${isc.DocUtils.linkForRef('attr:ListGrid.canSelectCells')} is true.\n <P>",
        flags:"IRW",
        name:"originBaseStyle"
    },
    "method:String.endsWith":{
        seeAlso:[
        ],
        type:"method",
        definingClass:"object:String",
        returns:{
            type:"boolean",
            description:"<code>true</code> if <code>substring</code> occurs within this string ending with <code>position - 1</code>."
        },
        groups:[
            "stringProcessing"
        ],
        deprecated:null,
        ref:"method:String.endsWith",
        params:[
            {
                defaultValue:null,
                optional:false,
                type:"String",
                description:"other string to check",
                name:"substring"
            },
            {
                defaultValue:null,
                optional:true,
                type:"int",
                description:"optional position in this string. Defaults to the length of this string.",
                name:"position"
            }
        ],
        description:" Returns <code>true</code> if this string ends with another string, or if the other string\n occurs in this string beginning at <code>position - substring.length</code>.\n\n",
        flags:"",
        name:"endsWith"
    },
    "type:DateInputFormat":{
        seeAlso:[
        ],
        ref:"type:DateInputFormat",
        deprecated:null,
        type:"type",
        description:"3 character string containing the <code>\"M\"</code>, <code>\"D\"</code> and <code>\"Y\"</code>\n  characters to indicate the format of strings being parsed into Date instances via\n  <code>DateUtil.parseInput()</code>.\n  <P>\n  As an example - an input format of \"MDY\" would parse \"01/02/1999\" to Jan 2nd 1999\n \n  <P>\n  Note: In addition to these standard formats, a custom date string parser function may be\n  passed directly to ${isc.DocUtils.linkForRef('classMethod:DateUtil.setInputFormat')} or passed into \n ${isc.DocUtils.linkForRef('classMethod:DateUtil.parseInput')} as the inputFormat parameter.\n ",
        name:"DateInputFormat",
        baseType:"String"
    },
    "attr:Window.placement":{
        seeAlso:[
        ],
        ref:"attr:Window.placement",
        defaultValue:"null",
        deprecated:null,
        type:"attr",
        definingClass:"class:Window",
        valueType:"PanelPlacement",
        description:"Where should the window be placed on the screen? Valid settings include\n <code>\"fillScreen\"</code>, <code>\"fillPanel\"</code>, <code>\"halfScreen\"</code>\n and <code>\"none\"</code>\n <P>\n If not explicitly specified, default is to use ${isc.DocUtils.linkForRef('type:PanelPlacement')} \"fillScreen\" \n if ${isc.DocUtils.linkForRef('classAttr:Browser.isHandset')}, and \"none\" for non-handset devices.\n <P>\n If <code>window.placement</code> is something other than <code>\"none\"</code>,\n sizing and positioning settings (either explicit left, top, width, height settings or\n the ${isc.DocUtils.linkForRef('attr:Window.autoCenter')} and ${isc.DocUtils.linkForRef('attr:Window.autoSize')} features) will have no effect.",
        flags:"IR",
        name:"placement"
    },
    "attr:MultiSortPanel.deleteLevelButton":{
        seeAlso:[
        ],
        ref:"attr:MultiSortPanel.deleteLevelButton",
        defaultValue:"null",
        deprecated:null,
        type:"attr",
        definingClass:"class:MultiSortPanel",
        valueType:"AutoChild IButton",
        description:"Automatically generated ${isc.DocUtils.linkForRef('class:IButton')} providing a mechanism for deleting levels\n from the sort configuration.\n <P>\n This component is an ${isc.DocUtils.linkForRef('type:AutoChild')} and as such may be customized via \n <code>multiSortPanel.deleteLevelButtonProperties</code> and \n <code>multiSortPanel.deleteLevelButtonDefaults</code>.",
        flags:"RA",
        name:"deleteLevelButton"
    },
    "attr:Canvas.resizeBarTarget":{
        seeAlso:[
            {
                ref:"attr:Canvas.showResizeBar",
                description:null
            }
        ],
        defaultValue:"null",
        type:"attr",
        definingClass:"class:Canvas",
        groups:[
            "layoutMember"
        ],
        deprecated:null,
        ref:"attr:Canvas.resizeBarTarget",
        valueType:"String",
        description:"When this Canvas is included as a member in a Layout, and ${isc.DocUtils.linkForRef('attr:Canvas.showResizeBar')} is set to\n <code>true</code> so that a resizeBar is created, <code>resizeBarTarget:\"next\"</code> can be\n set to indicate that the resizeBar should resize the next member of the layout rather than\n this one.  For resizeBars that support hiding their target member when clicked on, \n <code>resizeBarTarget:\"next\"</code> also means that the next member will be the one hidden.\n <P>\n This is typically used to create a 3-way split pane, where left and right-hand sections can\n be resized or hidden to allow a center section to expand.\n <P>\n <b>NOTE:</b> as with any Layout, to ensure all available space is used, one or more members\n must maintain a flexible size (eg 75%, or *).  In a two pane Layout with a normal resize\n bar, to fill all space after a user resizes, the member on the <b>right</b> should have\n flexible size.  With resizeBarTarget:\"next\", the member on the <b>left</b> should have\n flexible size.",
        flags:"IR",
        name:"resizeBarTarget"
    },
    "object:RelativeDate":{
        seeAlso:[
        ],
        type:"object",
        staticMethods:[
        ],
        classMethods:[
        ],
        classAttrs:[
        ],
        attrs:[
            "attr:RelativeDate.value",
            "attr:RelativeDate.rangePosition"
        ],
        ref:"object:RelativeDate",
        deprecated:null,
        treeLocation:[
            "Client Reference/System"
        ],
        description:"An object representing a relative date, useful for representing date ranges etc in criteria.\n RelativeDate objects may be created directly by SmartClient components such as the\n ${isc.DocUtils.linkForRef('class:RelativeDateItem')}.\n <P>\n RelativeDate objects will have <code>\"_constructor\"</code> set to <code>\"RelativeDate\"</code>\n and must have a specified ${isc.DocUtils.linkForRef('attr:RelativeDate.value')}. Any other attributes are optional.",
        methods:[
        ],
        name:"RelativeDate"
    },
    "method:TileLayout.setTileHeight":{
        groups:[
            "tileLayout"
        ],
        seeAlso:[
        ],
        ref:"method:TileLayout.setTileHeight",
        deprecated:null,
        type:"method",
        definingClass:"class:TileLayout",
        params:[
            {
                defaultValue:null,
                optional:false,
                type:"Integer",
                description:"height",
                name:"height"
            }
        ],
        description:" Sets the height of tiles.\n",
        flags:"",
        name:"setTileHeight"
    },
    "attr:MultiFileItem.editButton":{
        seeAlso:[
        ],
        ref:"attr:MultiFileItem.editButton",
        defaultValue:"null",
        deprecated:null,
        type:"attr",
        definingClass:"class:MultiFileItem",
        valueType:"AutoChild StatefulCanvas",
        description:"Button for launching a picker to add new files for upload.  Supports the properties of a\n ${isc.DocUtils.linkForRef('object:FormItemIcon')}.",
        flags:"IR",
        name:"editButton"
    },
    "method:DoubleItem.getValueAsDouble":{
        seeAlso:[
            {
                ref:"method:FormItem.getValue",
                description:null
            }
        ],
        ref:"method:DoubleItem.getValueAsDouble",
        deprecated:null,
        type:"method",
        definingClass:"class:DoubleItem",
        description:" Return the value tracked by this form item as a Double.  If the value cannot\n be parsed to a valid double, null will be returned.\n\n",
        flags:"",
        returns:{
            type:"Double",
            description:"the value of this element"
        },
        name:"getValueAsDouble"
    },
    "attr:Point.x":{
        seeAlso:[
        ],
        ref:"attr:Point.x",
        defaultValue:"0",
        deprecated:null,
        type:"attr",
        definingClass:"object:Point",
        valueType:"Coordinate",
        description:"The x coordinate of this point.",
        flags:"IR",
        name:"x"
    },
    "attr:DetailViewerEditProxy.dataSeparatorChar":{
        seeAlso:[
        ],
        ref:"attr:DetailViewerEditProxy.dataSeparatorChar",
        defaultValue:"\",\"",
        deprecated:null,
        type:"attr",
        definingClass:"class:DetailViewerEditProxy",
        valueType:"String",
        description:"If ${isc.DocUtils.linkForRef('attr:EditProxy.inlineEditEvent','inline editing')} for this viewer edits the\n ${isc.DocUtils.linkForRef('attr:DetailViewer.data')}, character that should be used as a separator between\n values, or between pairs of field name vs values if the user is entering such\n a ${isc.DocUtils.linkForRef('type:ValueMap')} using the ${isc.DocUtils.linkForRef('attr:DetailViewerEditProxy.dataDisplaySeparatorChar','dataDisplaySeparatorChar')}.\n <p>\n If ${isc.DocUtils.linkForRef('attr:EditProxy.inlineEditMultiline')} is enabled, newlines will be used as value\n separators and the <code>dataSeparatorChar</code>\n <p>\n The ${isc.DocUtils.linkForRef('attr:DetailViewerEditProxy.dataEscapeChar','dataEscapeChar')} can be used to enter the separator\n char as part of a field name or value.",
        flags:"IR",
        name:"dataSeparatorChar"
    },
    "attr:TimeItem.secondIncrement":{
        seeAlso:[
        ],
        ref:"attr:TimeItem.secondIncrement",
        defaultValue:"null",
        deprecated:null,
        type:"attr",
        definingClass:"class:TimeItem",
        valueType:"Number",
        description:"When ${isc.DocUtils.linkForRef('attr:TimeItem.useTextField','useTextField')} is false and \n ${isc.DocUtils.linkForRef('attr:TimeItem.secondValues','secondValues')} is unset, this attribute specifies the increment\n to use when generating entries for the second picker.  For example, if this attribute is\n set to 5, the second picker will contain only every fifth value between the \n ${isc.DocUtils.linkForRef('attr:TimeItem.secondMinValue','secondMinValue')} and \n ${isc.DocUtils.linkForRef('attr:TimeItem.secondMaxValue','secondMaxValue')}.",
        flags:"IRW",
        name:"secondIncrement"
    },
    "method:DynamicForm.getField":{
        seeAlso:[
            {
                ref:"method:DynamicForm.getItem",
                description:null
            }
        ],
        type:"method",
        definingClass:"class:DynamicForm",
        returns:{
            type:"FormItem",
            description:"FormItem object or null if not found"
        },
        groups:[
            "items"
        ],
        deprecated:null,
        ref:"method:DynamicForm.getField",
        params:[
            {
                defaultValue:null,
                optional:false,
                type:"FieldName",
                description:"name of the item you're looking for",
                name:"itemName"
            }
        ],
        description:" Synonym for dynamicForm.getItem()\n\n",
        flags:"",
        name:"getField"
    },
    "attr:TextAreaItem.iconVAlign":{
        seeAlso:[
        ],
        defaultValue:"Canvas.TOP",
        type:"attr",
        definingClass:"class:TextAreaItem",
        groups:[
            "formIcons"
        ],
        deprecated:null,
        ref:"attr:TextAreaItem.iconVAlign",
        valueType:"VerticalAlignment",
        description:"Align icons with the top edge of text area icons by default.",
        flags:"IR",
        name:"iconVAlign"
    },
    "method:Date.getShortDayName":{
        seeAlso:[
        ],
        type:"method",
        definingClass:"object:Date",
        returns:{
            type:"String",
            description:"Abbreviated day name"
        },
        groups:[
            "dateFormatting"
        ],
        deprecated:null,
        ref:"method:Date.getShortDayName",
        params:[
            {
                defaultValue:null,
                optional:false,
                type:"int",
                description:"Number of characters to return (Defaults to 3, can't be                                  longer than 3)",
                name:"length"
            }
        ],
        description:" Return the abbreviated (up to 3 chars) day of week name for this date (Mon, Tue, etc).\n To modify the value returned by this method, set ${isc.DocUtils.linkForRef('classAttr:DateUtil.shortDayNames')}\n\n",
        flags:"",
        name:"getShortDayName"
    },
    "method:FormItem.disable":{
        groups:[
            "enable"
        ],
        seeAlso:[
            {
                ref:"attr:FormItem.disabled",
                description:null
            }
        ],
        ref:"method:FormItem.disable",
        deprecated:null,
        type:"method",
        definingClass:"class:FormItem",
        description:" Set this item to be disabled at runtime.\n",
        flags:"",
        name:"disable"
    },
    "method:ColumnTree.selectRecords":{
        groups:[
            "selection"
        ],
        seeAlso:[
        ],
        ref:"method:ColumnTree.selectRecords",
        deprecated:null,
        type:"method",
        definingClass:"class:ColumnTree",
        params:[
            {
                defaultValue:null,
                optional:false,
                type:"Array of Record | number",
                description:"records (or row numbers) to select",
                name:"records"
            },
            {
                defaultValue:null,
                optional:true,
                type:"boolean",
                description:"new selection state (if null, defaults to true)",
                name:"newState"
            },
            {
                defaultValue:null,
                optional:true,
                type:"number",
                description:"Column number",
                name:"colNum"
            }
        ],
        description:"\n Select/deselect a list of ${isc.DocUtils.linkForRef('object:Record')}s passed in explicitly, or by index.\n\n",
        flags:"",
        name:"selectRecords"
    },
    "method:MultiGroupPanel.groupChanged":{
        seeAlso:[
        ],
        ref:"method:MultiGroupPanel.groupChanged",
        deprecated:null,
        type:"method",
        definingClass:"class:MultiGroupPanel",
        params:[
            {
                defaultValue:null,
                optional:false,
                type:"Array of GroupSpecifier",
                description:"The current group configuration, after any changes",
                name:"groupLevels"
            }
        ],
        description:" Fired whenever the group configuration changes.  The single parameter is an array of\n ${isc.DocUtils.linkForRef('object:GroupSpecifier')}s that represent the list of group-levels as they appear after \n whatever change has occurred.\n\n",
        flags:"",
        name:"groupChanged"
    },
    "classMethod:DateUtil.getEndOf":{
        seeAlso:[
        ],
        ref:"classMethod:DateUtil.getEndOf",
        deprecated:null,
        type:"classMethod",
        definingClass:"class:DateUtil",
        params:[
            {
                defaultValue:null,
                optional:false,
                type:"Date",
                description:"the base date to find the period end from",
                name:"date"
            },
            {
                defaultValue:null,
                optional:false,
                type:"String",
                description:"the period to return the end of, one of mn/h/d/w/m/y",
                name:"period"
            },
            {
                defaultValue:null,
                optional:true,
                type:"Boolean",
                description:"process and return a logicalDate with no time element",
                name:"logicalDate"
            },
            {
                defaultValue:null,
                optional:true,
                type:"Integer",
                description:"which day should be considered the firstDayOfWeek -                 overrides the default provided by the locale",
                name:"firstDayOfWeek"
            }
        ],
        description:" Returns the end of some period, like day, week or month, relative to a passed Date \n instance.\n",
        flags:"A",
        returns:{
            type:"Date",
            description:"a Date instance representing the end of the period relative to the                passed date"
        },
        name:"getEndOf"
    },
    "attr:DetailViewer.hiliteIconRightPadding":{
        seeAlso:[
        ],
        defaultValue:"2",
        type:"attr",
        definingClass:"class:DetailViewer",
        groups:[
            "hiliting"
        ],
        deprecated:null,
        ref:"attr:DetailViewer.hiliteIconRightPadding",
        valueType:"number",
        description:"How much padding should there be on the right of ${isc.DocUtils.linkForRef('attr:DetailViewer.hiliteIcons','hilite icons')} by default?\n Can be overridden at the field level",
        flags:"IRW",
        name:"hiliteIconRightPadding"
    },
    "attr:SelectItem.iconPlacement":{
        seeAlso:[
        ],
        ref:"attr:SelectItem.iconPlacement",
        defaultValue:"\"both\"",
        deprecated:null,
        type:"attr",
        definingClass:"class:SelectItem",
        valueType:"PickListItemIconPlacement",
        description:"For PickList items with ${isc.DocUtils.linkForRef('type:PickListItemIconPlacement')} set such that the pickList does\n not render near-origin, should specified ${isc.DocUtils.linkForRef('attr:FormItem.icons','icons')} be rendered inline within\n the formItem itself, or within the ${isc.DocUtils.linkForRef('attr:ComboBoxItem.pickerNavigationBar','pickerNavigationBar')}.\n <P>\n May be overridden at the icon level via ${isc.DocUtils.linkForRef('attr:FormItemIcon.iconPlacement')}.\n <P>\n For mobile browsing with limited available screen space, icons rendered in\n the navigation bar may be easier for the user to interact with.",
        flags:"IR",
        name:"iconPlacement"
    },
    "method:ColorPicker.getRed":{
        seeAlso:[
            {
                ref:"method:ColorPicker.setRed",
                description:null
            }
        ],
        ref:"method:ColorPicker.getRed",
        deprecated:null,
        type:"method",
        definingClass:"class:ColorPicker",
        description:" Returns the Red element of the currently-selected color, as an integer from 0-255\n",
        flags:"",
        returns:{
            type:"int",
            description:"red color component"
        },
        name:"getRed"
    },
    "classMethod:DMI.call":{
        seeAlso:[
        ],
        ref:"classMethod:DMI.call",
        deprecated:null,
        type:"classMethod",
        definingClass:"class:DMI",
        params:[
            {
                defaultValue:null,
                optional:false,
                type:"String | Object",
                description:"the appID (.app.xml file to look in) or comprehensive request                          object as documented above.",
                name:"appID"
            },
            {
                defaultValue:null,
                optional:false,
                type:"String",
                description:"${isc.DocUtils.linkForRef('attr:ServerObject.className')} or ${isc.DocUtils.linkForRef('attr:ServerObject.ID')}",
                name:"className"
            },
            {
                defaultValue:null,
                optional:false,
                type:"String",
                description:"the name of the method to call on the serverObject",
                name:"methodName"
            },
            {
                defaultValue:null,
                optional:false,
                type:"Any",
                description:"The next N-1 params specify arguments to the server-side method.",
                name:"args"
            },
            {
                defaultValue:null,
                optional:false,
                type:"RPCCallback",
                description:"The callback of the response.  If you do not want a callback, you                          must specify a <code>null</code> value for this parameter when\n                          using the first signature (documented above).",
                name:"callback"
            }
        ],
        description:"\n Calls a server-side DMI method.  At a minimum, you need to specify the appID \n (${isc.DocUtils.linkForRef('group:applicationDeclaration','.app.xml file')}), ${isc.DocUtils.linkForRef('attr:ServerObject.className')}\n or ${isc.DocUtils.linkForRef('attr:ServerObject.ID')} and methodName to call.\n Arguments and callback are optional.  There are two ways to invoke this method:\n <pre>\n DMI.call(appID, className, methodName, \n          arg1, arg2 ...argN, callback);\n </pre>\n or:\n <pre>\n DMI.call({\n     appID: appID,\n     className: className,\n     methodName: methodName,\n     arguments: [arg1, arg2, ...argN], //optional\n     callback: callback, //optional\n     requestParams: requestProps // optional\n });\n </pre>\n If you use the first signature, you must either specify a callback or if you don't want a\n callback, pass a <code>null</code> as the last argument.  The second signature allows you to\n specify requestParams that are applied to the ${isc.DocUtils.linkForRef('object:RPCRequest')} generated by this DMI call.\n This allows you to override some defaults - for example to suppress the \"Contacting Server\"\n prompt, change it's text; change the timeout or set any other property settable on\n ${isc.DocUtils.linkForRef('object:RPCRequest')}.\n <p>\n Arguments to be passed to the server method may be specified.\n If present, each argument will be serialized into JSON, \n sent to the server and translated to an equivalent Java object to be passed into the\n method. The translation follows the same rules as for data passed to the server as \n part of a standard ${isc.DocUtils.linkForRef('attr:RPCRequest.data','RPCRequest')}. <br>\n For example if a server side method has the signature\n <pre>\n someMethod(String title, Map overrides);\n </pre>\n a DMI call to that method would could pass in a standard String and JavaScript object -\n for example:\n <pre>\n isc.DMI.call({\n     appID: \"someApp\",\n     className: \"com.smartclient.demo.MyClass\",\n     methodName: \"someMethod\",\n     arguments: [\"Title String\", {field1:\"Value 1\", field2:\"Value 2\"}]\n });\n </pre>\n <p>\n Note that you can use the ${isc.DocUtils.linkForRef('group:loadDMIStubsTag')} tag to bind all methods of\n <code>ServerObjects</code> defined in a given .app.xml file and call methods on them\n directly.\n\n",
        flags:"",
        returns:{
            type:"RPCRequest",
            description:"the RPCRequest that was sent to the server."
        },
        name:"call"
    },
    "method:DrawSector.setCenterPoint":{
        seeAlso:[
        ],
        ref:"method:DrawSector.setCenterPoint",
        deprecated:null,
        type:"method",
        definingClass:"class:DrawSector",
        params:[
            {
                defaultValue:null,
                optional:false,
                type:"Coordinate",
                description:"X coordinate of the center point (in the global coordinate system).",
                name:"left"
            },
            {
                defaultValue:null,
                optional:false,
                type:"Coordinate",
                description:"Y coordinate of the center point (in the global coordinate system.",
                name:"top"
            }
        ],
        description:" Change the center point for this sector.\n",
        flags:"",
        name:"setCenterPoint"
    },
    "attr:ListGrid.showHeaderSpanTitlesInSortEditor":{
        seeAlso:[
            {
                ref:"attr:ListGrid.sortEditorSpanTitleSeparator",
                description:null
            }
        ],
        ref:"attr:ListGrid.showHeaderSpanTitlesInSortEditor",
        defaultValue:"true",
        deprecated:null,
        type:"attr",
        definingClass:"class:ListGrid",
        valueType:"Boolean",
        description:"If this grid has specified ${isc.DocUtils.linkForRef('attr:ListGrid.headerSpans','headerSpans')}, should field titles be\n prefixed with the titles of the headerSpans in which they are contained when\n using the ${isc.DocUtils.linkForRef('class:MultiSortDialog','multi-sort editor')}.",
        flags:"IRW",
        name:"showHeaderSpanTitlesInSortEditor"
    },
    "attr:FieldPickerWindow.autoDismiss":{
        seeAlso:[
        ],
        ref:"attr:FieldPickerWindow.autoDismiss",
        defaultValue:"true",
        deprecated:null,
        type:"attr",
        definingClass:"class:FieldPickerWindow",
        valueType:"Boolean",
        description:"By default, a FieldPickerWindow will close automatically if the mouse is clicked outside\n of it.  To have the window shown with true modality, set this attribute to false.",
        flags:"IR",
        name:"autoDismiss"
    },
    "method:FormItem.setErrors":{
        groups:[
            "errorHandling"
        ],
        seeAlso:[
        ],
        ref:"method:FormItem.setErrors",
        deprecated:null,
        type:"method",
        definingClass:"class:FormItem",
        params:[
            {
                defaultValue:null,
                optional:false,
                type:"String | Array of String",
                description:"error message(s)",
                name:"errors"
            }
        ],
        description:" Set the error message(s) for this item\n",
        flags:"",
        name:"setErrors"
    },
    "attr:DataSourceField.canSortClientOnly":{
        seeAlso:[
        ],
        defaultValue:"false",
        type:"attr",
        definingClass:"object:DataSourceField",
        deprecated:null,
        ref:"attr:DataSourceField.canSortClientOnly",
        valueType:"boolean",
        description:"When true, this field can only be used for sorting if the data is entirely client-side.",
        flags:"IRW",
        serverDS:"allowed",
        name:"canSortClientOnly"
    },
    "method:DateItem.getEnteredValue":{
        seeAlso:[
        ],
        ref:"method:DateItem.getEnteredValue",
        deprecated:null,
        type:"method",
        definingClass:"class:DateItem",
        description:" Returns the raw text value typed into this items text field if ${isc.DocUtils.linkForRef('attr:DateItem.useTextField')} \n is true (otherwise returns the result of this.getValue()).\n",
        flags:"",
        returns:{
            type:"String",
            description:"value the user entered"
        },
        name:"getEnteredValue"
    },
    "attr:ListGrid.fieldPickerShowSampleValues":{
        seeAlso:[
        ],
        ref:"attr:ListGrid.fieldPickerShowSampleValues",
        defaultValue:"true",
        deprecated:null,
        type:"attr",
        definingClass:"class:ListGrid",
        valueType:"Boolean",
        description:"When set to false, sample values of the FieldPicker are never shown. This property applies to the entire FieldPicker.",
        flags:"IR",
        name:"fieldPickerShowSampleValues"
    },
    "classMethod:DateUtil.setShowChooserWeekPickers":{
        seeAlso:[
        ],
        ref:"classMethod:DateUtil.setShowChooserWeekPickers",
        deprecated:null,
        type:"classMethod",
        definingClass:"class:DateUtil",
        params:[
            {
                defaultValue:null,
                optional:false,
                type:"boolean",
                description:"whether to show Fiscal Week pickers in DateChoosers by default",
                name:"showChooserWeekPickers"
            }
        ],
        description:" Sets the global attribute that dictates whether the ${isc.DocUtils.linkForRef('class:DateChooser','choosers')} shelled\n from ${isc.DocUtils.linkForRef('class:DateItem','DateItems')} show a UI for working with Weeks.\n\n",
        flags:"",
        name:"setShowChooserWeekPickers"
    },
    "class:FieldPicker":{
        seeAlso:[
        ],
        type:"class",
        staticMethods:[
        ],
        inheritsFrom:"VLayout",
        classMethods:[
        ],
        classAttrs:[
        ],
        attrs:[
            "attr:FieldPicker.dataBoundComponent",
            "attr:FieldPicker.dataSource",
            "attr:FieldPicker.sampleRecord",
            "attr:FieldPicker.showHilitesButton",
            "attr:FieldPicker.showFieldOrderButtons",
            "attr:FieldPicker.hilitesText",
            "attr:FieldPicker.availableFieldsTitle",
            "attr:FieldPicker.currentFieldsTitle",
            "attr:FieldPicker.addCustomFieldsButtonTitle",
            "attr:FieldPicker.availableTitleTitle",
            "attr:FieldPicker.currentTitleTitle",
            "attr:FieldPicker.sampleValueTitle",
            "attr:FieldPicker.canFilterSampleValue",
            "attr:FieldPicker.confirmText",
            "attr:FieldPicker.removeText",
            "attr:FieldPicker.instructions",
            "attr:FieldPicker.instructionLabel",
            "attr:FieldPicker.saveAndExitButtonTitle",
            "attr:FieldPicker.cancelButtonTitle",
            "attr:FieldPicker.removeItemTitle",
            "attr:FieldPicker.emptyTitleHint",
            "attr:FieldPicker.availableFieldsHeaderControls",
            "attr:FieldPicker.availableFieldsGrid",
            "attr:FieldPicker.buttonLayout",
            "attr:FieldPicker.saveAndExitButton",
            "attr:FieldPicker.cancelChangesButton",
            "attr:FieldPicker.currentFieldsGrid"
        ],
        ref:"class:FieldPicker",
        deprecated:null,
        treeLocation:[
            "Client Reference/Data Binding"
        ],
        description:"FieldPicker provides a configuration dialog that displays, side-by-side, the available and\n currently-displayed fields of a ${isc.DocUtils.linkForRef('interface:DataBoundComponent')}. It allows for easy customization \n of the order in which the fields of a ${isc.DocUtils.linkForRef('interface:DataBoundComponent')} are displayed, and of which\n are visible.  If so configured, it also allows for convenient launching of the HiliteEditor,\n FormulaBuilder, and SummaryBuilder.  A FieldPicker instance runs in its own window, \n a ${isc.DocUtils.linkForRef('class:FieldPickerWindow')}",
        methods:[
            "method:FieldPicker.callback",
            "method:FieldPicker.setAvailableFields"
        ],
        name:"FieldPicker"
    },
    "attr:ColumnTree.fields":{
        seeAlso:[
            {
                ref:"object:ListGridField",
                description:null
            }
        ],
        defaultValue:"null",
        type:"attr",
        definingClass:"class:ColumnTree",
        groups:[
            "databinding"
        ],
        deprecated:null,
        ref:"attr:ColumnTree.fields",
        valueType:"Array of ListGridField",
        description:"An array of field objects, specifying the order, layout, dynamic calculation, and\n sorting behavior of each field in each column in the columnTree object. In ColumnTrees, \n the fields array specifies sub-columns within each main column. \n Each field in the fields array is a ListGridField object.\n <p>\n If ${isc.DocUtils.linkForRef('attr:ColumnTree.dataSource')} is also set, this value acts as a set of overrides as\n explained in ${isc.DocUtils.linkForRef('attr:DataBoundComponent.fields')}.",
        flags:"IRW",
        name:"fields"
    },
    "attr:DynamicForm.storeDisplayValues":{
        seeAlso:[
        ],
        ref:"attr:DynamicForm.storeDisplayValues",
        defaultValue:"true",
        deprecated:null,
        type:"attr",
        definingClass:"class:DynamicForm",
        valueType:"Boolean",
        description:"For editable fields with a specified ${isc.DocUtils.linkForRef('attr:FormItem.displayField')} and \n ${isc.DocUtils.linkForRef('attr:FormItem.optionDataSource')}, if the user selects a new value (typically from\n PickList based item such as a SelectItem), should the selected displayValue be updated\n on the record being edited in addition to the value for the actual item.<br>\n Note that this only applies for fields using \n ${isc.DocUtils.linkForRef('attr:FormItem.useLocalDisplayFieldValue','local display field values')} - typically\n ${isc.DocUtils.linkForRef('attr:DataSourceField.foreignKey','foreignKey fields')} where the display field is\n ${isc.DocUtils.linkForRef('attr:DataSourceField.includeFrom','included from')} another dataSource.\n <P>\n Default value is <code>true</code>. This is typically desirable for editing records\n with a displayField-mapped field, as it ensures the edited record will be be updated\n to contain the correct display value as well as the correct data value. As such, the\n expected display value is available on the record for display (for example in a ListGrid\n cell).\n <P>\n It may not be desirable for an interface specifically intended for \n ${isc.DocUtils.linkForRef('method:DynamicForm.getValuesAsCriteria','gathering criteria')} - in this case, results ought\n to be limited by an item's actual selected value, not by whatever text is displayed to \n the user.\n <P>\n See ${isc.DocUtils.linkForRef('attr:DataSourceField.displayField')} for more details.\n <P>\n Note: the modified display field value will be passed to the server along with the\n modified foreignKey field value if a \n ${isc.DocUtils.linkForRef('method:DynamicForm.saveData','databound update operation')} is performed. This occurs\n even if the displayField is\n ${isc.DocUtils.linkForRef('attr:DataSourceField.includeFrom','included from another DataSource')} and therefore\n read-only. In this case the server will simply ignore the modified display field value.\n This is as expected - a subsequent fetch for the same record would recalculate the\n displayField value on the server using the updated foreignKey field value (and return\n the same display value previously displayed to the user).\n <P>\n This attribute can also be set for ${isc.DocUtils.linkForRef('attr:FormItem.storeDisplayValues','individual items')}.",
        flags:"IRA",
        name:"storeDisplayValues"
    },
    "attr:OperationBinding.requiresRole":{
        seeAlso:[
        ],
        defaultValue:"null",
        requiresModules:[
            "SCServer"
        ],
        type:"attr",
        definingClass:"class:OperationBinding",
        groups:[
            "auth",
            "declarativeSecurity"
        ],
        ref:"attr:OperationBinding.requiresRole",
        deprecated:null,
        valueType:"String",
        description:"Comma-separated list of user roles that are allowed to invoke the operation described by\n this operationBinding. If the current user has any of the roles listed, they can\n invoke the operation. Also note that <code>authentication.superuserRole</code> can be \n specified in the ${isc.DocUtils.linkForRef('group:server_properties','server.properties')} file. If set this denotes a \"super user\" \n role - any user with that role will have access to all operations, regardless of the\n \"requiresRole\" settings for the operation.\n <P>\n Whether the current user has a given role is determined by calling the standard Java\n servlets method <code>httpServletRequest.isUserInRole()</code>, hence works with both simple\n J2EE security (realms and form-based authentication) and JAAS (Java Authentication &\n Authorization Service).\n <P>\n If you wish to use a role-based security scheme that does not make use of the servlet API's \n standards, SmartClient Server also implements the <code>setAuthenticated</code> and\n <code>setUserRoles</code> methods on <code>RPCManager</code>. \n You can use this API to tell SmartClient that all the requests in the queue currently \n being processed are associated with a user who has the roles you supply; in this case,\n SmartClient will not attempt to resolve the user's roles via \n <code>httpServletRequest.isUserInRole()</code>. When taking this approach, the \n <code>rpcManager.setUserRoles()</code> method should be called on the server for \n each transaction received from the client. We recommend doing this by overriding the \n special IDACall servlet and checking server side state to determine the current user's \n roles, calling the API, and then calling <code>handleDSRequest()</code> or\n <code>handleRPCRequest()</code> directly to handle the request(s) passed in.<br>\n Here's an example of this approach which assumes the current user's roles has been\n set directly on the HttpSession object as a comma-separated-string attribute \"roles\":\n <pre><code>\n  public class SecureIDACall extends IDACall {\n\t\t\n      public void processRequest(HttpServletRequest request,\n              HttpServletResponse response)\n       throws ServletException, IOException\n      {\n          HttpSession session = request.getSession();\n          Object roles = session == null ? null : session.getAttribute(\"roles\");\n \n          if (roles != null) {\n              try {\n                  RequestContext context = RequestContext.instance(this, request, response);   \n                  RPCManager rpc = new RPCManager(request, response);\n                  rpc.setAuthenticated(true);\n                  rpc.setUserRoles((String) roles); \n                  \n                  // call processRPCTransaction() to iterate through all RPCRequests and\n                  // DSRequests and execute them\n                  processRPCTransaction(rpc, context);\n \n              } catch (Throwable e) {\n                  handleError(response, e);\n              }\n          } else {\n              super.processRequest(request, response);\n          } \n      }\n  }\n </code></pre>\n <P>\n If there is an operationBinding declared for a given operationType which does not have an\n ${isc.DocUtils.linkForRef('attr:OperationBinding.operationId')}, that is, it is the default operationBinding for the type, then any other\n operationBinding of the same type is assumed to have the same setting for\n <code>requiresRole</code> as the default operationBinding for the operationType.  For\n example, given these declarations:\n <pre>\n     &lt;operationBinding operationType=\"fetch\" requiresRole=\"manager\"&gt;\n           ... settings ...\n      &lt;/operationBinding&gt;\n     &lt;operationBinding operationType=\"fetch\" operationId=\"fetchWithExtraFields\"&gt;\n           ... settings ...\n      &lt;/operationBinding&gt;\n </pre>\n The second operationBinding requires the \"manager\" role even though there is no explicit\n <code>requiresRole</code> declaration.  To prevent the \"manager\" role being required by the\n second operationBinding, add <code>requireRole=\"\"</code>.\n <P>\n Note that if ${isc.DocUtils.linkForRef('attr:DataSource.requiresRole')} is set, all operations on the DataSource require\n the roles set for the DataSource as a whole, even if they declare individual\n <code>requiresRole</code> attributes.\n <P>\n This property is valid only for a server-side DataSource when using the SmartClient Server.\n <P>\n <h3>Special rules for cache sync</h3>\n <P>\n After successfull \"add\" or \"update\" operation cache sync request is performed, which is using \n \"fetch\" operation of the same datasource. It may happen that user is allowed to add records, but \n is not allowed to fetch them, for example:\n <pre>\n     &lt;operationBinding operationType=\"fetch\" requiresRole=\"admin\"&gt;\n           ... settings ...\n     &lt;/operationBinding&gt;\n     &lt;operationBinding operationType=\"add\"&gt;\n           ... settings ...\n     &lt;/operationBinding&gt;\n </pre>\n User without \"admin\" role will be able to successfully add record, but the cache sync operation \n will fail due to security violation. In this case the record will be saved to database, but the \n added record will not be fetched from database, instead just ${isc.DocUtils.linkForRef('attr:DSRequest.oldValues','old values')} \n overlaid with submitted values will be returned. So, any changes made to the new record during \n request execution, including generated values for primary key fields of \"sequence\" type, will not \n be returned to the client.\n <p>\n However, if \"add\" or \"update\" operation explicitly declares ${isc.DocUtils.linkForRef('attr:OperationBinding.cacheSyncOperation')},\n cache sync request will be executed even if the user does not meet the security checks for the \n operationBinding. Note that field-level security still will be respected and disallowed fields will \n be excluded from returned data.",
        flags:"IR",
        serverDS:"only",
        name:"requiresRole"
    },
    "attr:CubeGrid.rowHeaderGridMode":{
        seeAlso:[
            {
                ref:"attr:CubeGrid.rowFacets",
                description:null
            },
            {
                ref:"attr:CubeGrid.canCollapseFacets",
                description:null
            }
        ],
        ref:"attr:CubeGrid.rowHeaderGridMode",
        defaultValue:"false",
        deprecated:null,
        type:"attr",
        definingClass:"class:CubeGrid",
        valueType:"Boolean",
        description:"If enabled row headers for this cubeGrid will be rendered using a ${isc.DocUtils.linkForRef('class:GridRenderer')}\n component. This improves performance for very large cubeGrids.\n <P>\n Note that this attribute must be set for hierarchical row facets to be indented properly.",
        flags:"IRA",
        name:"rowHeaderGridMode"
    },
    "attr:EditPane.selectedLabelBackgroundColor":{
        seeAlso:[
            {
                ref:"attr:EditContext.showSelectedLabel",
                description:null
            }
        ],
        ref:"attr:EditPane.selectedLabelBackgroundColor",
        defaultValue:"null",
        deprecated:null,
        type:"attr",
        definingClass:"class:EditPane",
        valueType:"String",
        description:"The background color for the selection outline label. The\n default is defined on ${isc.DocUtils.linkForRef('class:SelectionOutline')}.\n <P>\n This value is applied as a default to ${isc.DocUtils.linkForRef('attr:EditProxy.selectedLabelBackgroundColor')}.\n <P>\n NOTE: A selected component label is only supported when ${isc.DocUtils.linkForRef('attr:EditProxy.selectedAppearance')}\n is \"outlineEdges\".",
        flags:"IR",
        name:"selectedLabelBackgroundColor"
    },
    "attr:Window.maximizeButton":{
        seeAlso:[
        ],
        ref:"attr:Window.maximizeButton",
        defaultValue:"null",
        deprecated:null,
        type:"attr",
        definingClass:"class:Window",
        valueType:"AutoChild ImgButton",
        description:"Button that will make this Window fill the browser via ${isc.DocUtils.linkForRef('method:Window.maximize')}.",
        flags:"R",
        name:"maximizeButton"
    },
    "attr:Canvas.editNode":{
        seeAlso:[
        ],
        ref:"attr:Canvas.editNode",
        defaultValue:"null",
        deprecated:null,
        type:"attr",
        definingClass:"class:Canvas",
        valueType:"EditNode",
        description:"The component's ${isc.DocUtils.linkForRef('object:EditNode')} for a component that has been created by a\n ${isc.DocUtils.linkForRef('interface:Palette')} from a ${isc.DocUtils.linkForRef('object:PaletteNode')}.",
        flags:"R",
        name:"editNode"
    },
    "attr:DateItem.yearSelector":{
        seeAlso:[
            {
                ref:"attr:DateItem.selectorFormat",
                description:null
            }
        ],
        defaultValue:"null",
        type:"attr",
        definingClass:"class:DateItem",
        groups:[
            "dateItemAppearance"
        ],
        deprecated:null,
        ref:"attr:DateItem.yearSelector",
        valueType:"AutoChild SelectItem",
        description:"${isc.DocUtils.linkForRef('class:SelectItem')} for picking a year.\n <P>\n To control which selectors are visible and in what order, use ${isc.DocUtils.linkForRef('attr:DateItem.selectorFormat')}.",
        flags:"R",
        name:"yearSelector"
    },
    "attr:RelativeDateItem.secondsAgoTitle":{
        seeAlso:[
        ],
        defaultValue:"\"N seconds ago\"",
        type:"attr",
        definingClass:"class:RelativeDateItem",
        groups:[
            "i18nMessages"
        ],
        deprecated:null,
        ref:"attr:RelativeDateItem.secondsAgoTitle",
        valueType:"String",
        description:"The title to show for historical periods when the ${isc.DocUtils.linkForRef('type:TimeUnit')} is \"second\".",
        flags:"IR",
        name:"secondsAgoTitle"
    },
    "method:DrawLinePath.getCenter":{
        seeAlso:[
        ],
        ref:"method:DrawLinePath.getCenter",
        deprecated:null,
        type:"method",
        definingClass:"class:DrawLinePath",
        description:" Get the center point of the line path.\n",
        flags:"",
        returns:{
            type:"Point",
            description:"the center point"
        },
        name:"getCenter"
    },
    "attr:IPickTreeItem.button":{
        seeAlso:[
        ],
        ref:"attr:IPickTreeItem.button",
        defaultValue:"null",
        deprecated:null,
        type:"attr",
        definingClass:"class:IPickTreeItem",
        valueType:"AutoChild Canvas",
        description:"This item is an ${isc.DocUtils.linkForRef('type:AutoChild')} generated ${isc.DocUtils.linkForRef('class:Canvas')} displayed by\n the IPickTreeItem and is an instance of ${isc.DocUtils.linkForRef('class:ITreeMenuButton')} by default.",
        flags:"R",
        name:"button"
    },
    "attr:SectionStack.canCollapseAll":{
        seeAlso:[
        ],
        ref:"attr:SectionStack.canCollapseAll",
        defaultValue:"true",
        deprecated:null,
        type:"attr",
        definingClass:"class:SectionStack",
        valueType:"Boolean",
        description:"In ${isc.DocUtils.linkForRef('attr:SectionStack.visibilityMode','visibilityMode')}\n \"mutex\",\n whether to allow the last remaining expanded section to be collapsed.  If false, collapsing the\n last open section will open the next one (wrapping around at the end).",
        flags:"IRW",
        name:"canCollapseAll"
    },
    "attr:OperationBinding.recordName":{
        seeAlso:[
        ],
        defaultValue:"null",
        type:"attr",
        definingClass:"class:OperationBinding",
        groups:[
            "clientDataIntegration"
        ],
        ref:"attr:OperationBinding.recordName",
        deprecated:null,
        valueType:"String",
        description:"For an XML DataSource, tagName of the elements to be used as records.\n <p>\n This is a simple alternative to ${isc.DocUtils.linkForRef('attr:OperationBinding.recordXPath')} when the elements to be used as\n records all share a tagName.\n <p>\n When a DataSource has a WebService, <code>recordName</code> can also be set to the name\n of any <code>complexType</code> declared within the WebService's WSDL file.",
        flags:"IR",
        serverDS:"allowed",
        name:"recordName"
    },
    "attr:UserConfirmationGateway.failureElement":{
        seeAlso:[
        ],
        ref:"attr:UserConfirmationGateway.failureElement",
        defaultValue:"null",
        deprecated:null,
        type:"attr",
        definingClass:"class:UserConfirmationGateway",
        valueType:"String",
        description:"ID of the next sequence or element to proceed to if the criteria do not match.",
        flags:"IR",
        name:"failureElement"
    },
    "attr:ImgSplitbar.skinImgDir":{
        seeAlso:[
        ],
        defaultValue:"\"images/SplitBar/\"",
        type:"attr",
        definingClass:"class:ImgSplitbar",
        groups:[
            "images"
        ],
        deprecated:null,
        ref:"attr:ImgSplitbar.skinImgDir",
        valueType:"SCImgURL",
        description:"Default directory for skin images (those defined by the class), relative to the\n Page-wide ${isc.DocUtils.linkForRef('classMethod:Page.getSkinDir','skinDir')}.",
        flags:"IR",
        name:"skinImgDir"
    },
    "attr:TimeItem.secondItemTitle":{
        seeAlso:[
        ],
        defaultValue:"\"Sec\"",
        type:"attr",
        definingClass:"class:TimeItem",
        groups:[
            "i18nMessages"
        ],
        deprecated:null,
        ref:"attr:TimeItem.secondItemTitle",
        valueType:"HTMLString",
        description:"Title to show for the ${isc.DocUtils.linkForRef('attr:TimeItem.secondItem','second picker')}.",
        flags:"IRW",
        name:"secondItemTitle"
    },
    "attr:Canvas.autoDraw":{
        seeAlso:[
        ],
        defaultValue:"true",
        type:"attr",
        definingClass:"class:Canvas",
        groups:[
            "drawing"
        ],
        ref:"attr:Canvas.autoDraw",
        deprecated:null,
        valueType:"Boolean",
        description:"\n If true, this canvas will draw itself immediately after it is created.\n <P>\n <b>Note</b> that you should turn this OFF for any canvases that are provided as children\n of other canvases, or they will draw initially, then be clear()ed and drawn again when\n added as children, causing a large performance penalty.\n <P>\n For example, the following code is incorrect and will cause extra draw()s:\n <P>\n <pre>\n     isc.Layout.create({\n         members : [\n             isc.ListGrid.create()\n         ]\n     });\n </pre>\n It should instead be:\n <pre>\n     isc.Layout.create({\n         members : [\n             isc.ListGrid.create(<b>{ autoDraw: false }</b>)\n         ]\n     });\n </pre>\n In order to avoid unwanted autoDrawing systematically, it is recommend that you call\n ${isc.DocUtils.linkForRef('staticMethod:isc.setAutoDraw','isc.setAutoDraw(false)')} immediately after SmartClient is loaded\n and before any components are created, then set <code>autoDraw:true</code> or call\n draw() explicitly to draw components.\n <P>\n Otherwise, if the global setting for autoDraw remains <code>true</code>, you must set\n autoDraw:false, as shown above, on every component in your application that\n should not immediately draw: all Canvas children, Layout members, Window items, Tab\n panes, etc, however deeply nested.  Forgetting to set autoDraw:false will result in one\n more clear()s - these are reported on the Results tab of the\n ${isc.DocUtils.linkForRef('group:debugging','Developer Console')}, and can be tracked to individual components by\n using the \"clears\" log category in the Developer Console.\n ",
        flags:"IR",
        examples:[
            "${isc.DocUtils.linkForExampleId('autodraw')}"
        ],
        name:"autoDraw"
    },
    "attr:SelectItem.pickerExitButtonTitle":{
        seeAlso:[
        ],
        defaultValue:"\"Done\"",
        type:"attr",
        definingClass:"class:SelectItem",
        groups:[
            "i18nMessages",
            "panelPlacement"
        ],
        deprecated:null,
        ref:"attr:SelectItem.pickerExitButtonTitle",
        valueType:"HTMLString",
        description:"The title for the ${isc.DocUtils.linkForRef('attr:SelectItem.pickerExitButton')}.",
        flags:"IR",
        name:"pickerExitButtonTitle"
    },
    "method:FormItem.getPageTop":{
        groups:[
            "positioning"
        ],
        seeAlso:[
        ],
        ref:"method:FormItem.getPageTop",
        deprecated:null,
        type:"method",
        definingClass:"class:FormItem",
        description:" Returns the drawn page-top coordinate of this form item in pixels.\n",
        flags:"",
        returns:{
            type:"int",
            description:"page-top coordinate in px"
        },
        name:"getPageTop"
    },
    "method:ListGridField.getGroupSummary":{
        seeAlso:[
        ],
        ref:"method:ListGridField.getGroupSummary",
        deprecated:null,
        type:"method",
        definingClass:"object:ListGridField",
        params:[
            {
                defaultValue:null,
                optional:false,
                type:"Array of ListGridRecord",
                description:"records for which a summary is being generated  (so all records in the group).",
                name:"records"
            },
            {
                defaultValue:null,
                optional:false,
                type:"ListGridField",
                description:"pointer to the field for which summary value is being generated",
                name:"field"
            },
            {
                defaultValue:null,
                optional:true,
                type:"Object",
                description:"object with specified groupValue and groupName for this group",
                name:"groupNode"
            }
        ],
        description:" If ${isc.DocUtils.linkForRef('attr:ListGrid.showGroupSummary')} is true, and this method is specified it will be\n called to generate the field summary value to be displayed for each group level summary row.\n Note that this is called instead of making use of the ${isc.DocUtils.linkForRef('attr:ListGridField.summaryFunction')}.\n <P>\n This method may return an array of results - in this case the group will show multiple summary\n rows, with each entry in the array showing up in a different record.\n\n",
        flags:"A",
        returns:{
            type:"Any",
            description:"summary value to display"
        },
        name:"getGroupSummary"
    },
    "method:DrawItem.setStartArrow":{
        seeAlso:[
        ],
        ref:"method:DrawItem.setStartArrow",
        deprecated:null,
        type:"method",
        definingClass:"class:DrawItem",
        params:[
            {
                defaultValue:null,
                optional:false,
                type:"ArrowStyle",
                description:"style of arrow to use",
                name:"arrowStyle"
            }
        ],
        description:" Set the arrowhead at the beginning of this path.\n <p>\n <b>NOTE:</b> Not all DrawItem classes support arrowheads. You can use ${isc.DocUtils.linkForRef('method:DrawItem.supportsStartArrow')}\n to dynamically check whether a DrawItem instance supports this method.\n",
        flags:"",
        name:"setStartArrow"
    },
    "classMethod:EventHandler.setDragOffset":{
        groups:[
            "dragdrop"
        ],
        seeAlso:[
            {
                ref:"method:Canvas.dragStart",
                description:null
            }
        ],
        ref:"classMethod:EventHandler.setDragOffset",
        deprecated:null,
        type:"classMethod",
        definingClass:"class:EventHandler",
        params:[
            {
                defaultValue:null,
                optional:false,
                type:"int",
                description:"initial x-offset for the drag",
                name:"offsetX"
            },
            {
                defaultValue:null,
                optional:false,
                type:"int",
                description:"initial y-offset for the drag",
                name:"offsetY"
            }
        ],
        description:" Sets the initial coordinate offset of the last event, typically a mouseDown or touchStart,\n from the drag target.  For example, when grabbing and dragging a ${isc.DocUtils.linkForRef('class:Scrollbar')} thumb with\n the mouse, you'd expect positive coordinates that reflect your position relative to the top,\n left corner of the thumb.  If a drag tracker will be used, call ${isc.DocUtils.linkForRef('classMethod:EventHandler.setDragTracker')}\n instead, which takes optional arguments <code>offsetX</code> and <code>offsetY</code> that\n act similarly to those passed to this method.\n <P>\n Your canvas can call this method to set the initial drag offset to whatever you want like so:\n <pre>\n    dragStart : function () {\n        isc.EventHandler.setDragOffset(5, 20);\n    }</pre>\n\n",
        flags:"",
        name:"setDragOffset"
    },
    "attr:MetricSettings.gradationZeroLineProperties":{
        seeAlso:[
        ],
        ref:"attr:MetricSettings.gradationZeroLineProperties",
        defaultValue:"null",
        deprecated:null,
        type:"attr",
        definingClass:"object:MetricSettings",
        valueType:"DrawLine Properties",
        description:"Properties for the gradation line drawn for zero (slightly thicker by default).",
        flags:"IR",
        name:"gradationZeroLineProperties"
    },
    "attr:DetailViewer.printLabelStyle":{
        seeAlso:[
        ],
        defaultValue:"null",
        type:"attr",
        definingClass:"class:DetailViewer",
        groups:[
            "printing"
        ],
        deprecated:null,
        ref:"attr:DetailViewer.printLabelStyle",
        valueType:"CSSStyleName",
        description:"Optional CSS style for a label cell in printable HTML for this component. If unset\n ${isc.DocUtils.linkForRef('attr:DetailViewer.labelStyle')} will be used for printing as well as normal presentation.",
        flags:"IRW",
        name:"printLabelStyle"
    },
    "attr:FormItem.foreignDisplayField":{
        seeAlso:[
            {
                ref:"method:FormItem.getDisplayFieldName",
                description:null
            }
        ],
        ref:"attr:FormItem.foreignDisplayField",
        defaultValue:"null",
        deprecated:null,
        type:"attr",
        definingClass:"class:FormItem",
        valueType:"String",
        description:"For items with an ${isc.DocUtils.linkForRef('attr:FormItem.optionDataSource')}, this property specifies an explicit\n display field for records within the option dataSource. Typically this property\n will be set in conjunction with ${isc.DocUtils.linkForRef('attr:FormItem.displayField')} in the case where\n the name of the displayField within the record being edited differs from the \n displayField in the optionDataSource.\n <P>\n See ${isc.DocUtils.linkForRef('attr:DataSourceField.foreignDisplayField')} for additional details.",
        flags:"IR",
        name:"foreignDisplayField"
    },
    "method:DataBoundComponent.editFormulaField":{
        groups:[
            "formulaFields"
        ],
        seeAlso:[
        ],
        ref:"method:DataBoundComponent.editFormulaField",
        deprecated:null,
        type:"method",
        definingClass:"interface:DataBoundComponent",
        params:[
            {
                defaultValue:null,
                optional:false,
                type:"Field",
                description:"Field to edit or null to add a new formula field",
                name:"field"
            }
        ],
        description:" Method to display a ${isc.DocUtils.linkForRef('class:FormulaBuilder')} to edit a formula Field.  If the function is called\n without a parameter, a new field will be created when the formula is saved.\n\n",
        flags:"",
        name:"editFormulaField"
    },
    "attr:SplitPane.listPaneTitleTemplate":{
        seeAlso:[
            {
                ref:"attr:SplitPane.detailPaneTitleTemplate",
                description:null
            }
        ],
        defaultValue:"\"${titleField}\"",
        type:"attr",
        definingClass:"class:SplitPane",
        groups:[
            "i18nMessages"
        ],
        ref:"attr:SplitPane.listPaneTitleTemplate",
        deprecated:null,
        valueType:"HTMLString",
        setter:[
            "setListPaneTitleTemplate"
        ],
        description:"Default value chosen for ${isc.DocUtils.linkForRef('method:SplitPane.setListTitle','listPaneTitle')} when ${isc.DocUtils.linkForRef('method:SplitPane.navigateListPane')} is called.\n <p>\n Available variables are:\n <ul>\n <li> \"titleField\" - the value of the ${isc.DocUtils.linkForRef('attr:DataSource.titleField')} in the selected record from\n the ${isc.DocUtils.linkForRef('attr:SplitPane.navigationPane')}\n <li> \"index\" - position of the selected record\n <li> \"totalRows\" - total number of rows in the component where the record is selected\n <li> \"record\" - the entire selected Record\n </ul>",
        flags:"IRW",
        examples:[
            "${isc.DocUtils.linkForExampleId('layoutSplitPane')}"
        ],
        name:"listPaneTitleTemplate"
    },
    "attr:DSRequest.startRow":{
        seeAlso:[
        ],
        defaultValue:"null",
        type:"attr",
        definingClass:"object:DSRequest",
        groups:[
            "paging"
        ],
        deprecated:null,
        ref:"attr:DSRequest.startRow",
        valueType:"number",
        description:"Starting row of requested results, used only with fetch operations.  If unset, 0 is assumed.\n <p>\n Note that startRow and endRow are zero-based, inclusive at the beginning and exclusive at\n the end (like substring), so startRow: 0, endRow: 1 is a request for the first record.",
        flags:"IR",
        name:"startRow"
    },
    "attr:ColorPicker.cancelButton":{
        seeAlso:[
        ],
        ref:"attr:ColorPicker.cancelButton",
        defaultValue:"null",
        deprecated:null,
        type:"attr",
        definingClass:"class:ColorPicker",
        valueType:"AutoChild IButton",
        description:"Cancel button for the ColorPicker",
        flags:"R",
        name:"cancelButton"
    },
    "attr:MenuItem.disabledIcon":{
        seeAlso:[
        ],
        defaultValue:"null",
        type:"attr",
        definingClass:"object:MenuItem",
        groups:[
            "menuIcons"
        ],
        ref:"attr:MenuItem.disabledIcon",
        deprecated:null,
        valueType:"String",
        description:"The filename for this item's custom icon when the item is disabled. If both this property\n and ${isc.DocUtils.linkForRef('attr:MenuItem.checked')} are both specified, only the icon specified by this property\n will be displayed. The path to the loaded skin directory and the skinImgDir are prepended\n to this filename to form the full URL.\n <p>\n If you need to set this state dynamically, use ${isc.DocUtils.linkForRef('method:MenuItem.dynamicIcon')} instead.",
        flags:"IR",
        examples:[
            "${isc.DocUtils.linkForExampleId('fullMenu')}"
        ],
        name:"disabledIcon"
    },
    "attr:Calendar.renderEventsOnDemand":{
        seeAlso:[
        ],
        ref:"attr:Calendar.renderEventsOnDemand",
        defaultValue:"true",
        deprecated:null,
        type:"attr",
        definingClass:"class:Calendar",
        valueType:"boolean",
        description:"When set to true, the default, each ${isc.DocUtils.linkForRef('class:EventCanvas','event')} is rendered as it \n appears in the viewport.  If set to false, all events are rendered up-front, whenever the \n current range changes.\n <P>\n Has no effect when ${isc.DocUtils.linkForRef('attr:Calendar.showColumnLayouts','showColumnLayouts')} is true.",
        flags:"IR",
        name:"renderEventsOnDemand"
    },
    "classAttr:GroupingMessages.byDateTitle":{
        seeAlso:[
        ],
        defaultValue:"\"by Date\"",
        type:"classAttr",
        definingClass:"class:GroupingMessages",
        groups:[
            "i18nMessages"
        ],
        deprecated:null,
        ref:"classAttr:GroupingMessages.byDateTitle",
        valueType:"String",
        description:"Title to use for the menu option which groups a date field by specific dates.  All \n values that are within the 24 hours of a specific date in a given year are \n grouped together.",
        flags:"IRW",
        name:"byDateTitle"
    },
    "attr:JSONEncoder.strictQuoting":{
        seeAlso:[
        ],
        ref:"attr:JSONEncoder.strictQuoting",
        defaultValue:"true",
        deprecated:null,
        type:"attr",
        definingClass:"class:JSONEncoder",
        valueType:"Boolean",
        description:"Whether all property names should be quoted, or only those property names that are not valid\n identifiers or are JavaScript reserved words (such as \"true\").\n <P>\n Encoding only where required produces slightly shorter, more readable output which is still\n compatible with JavaScript's eval():\n <pre>\n {\n     someProp : \"someValue\",\n     \"true\" : \"otherValue\",\n     otherProp : \"otherValue\"\n }\n </pre>\n .. but is not understood by many server-side JSON parser implementations.",
        flags:"IR",
        name:"strictQuoting"
    },
    "method:Canvas.containsEvent":{
        groups:[
            "events",
            "positioning"
        ],
        seeAlso:[
        ],
        ref:"method:Canvas.containsEvent",
        deprecated:null,
        type:"method",
        definingClass:"class:Canvas",
        description:" Return true if the last event's mouse coordinates are within the bounds of this component.\n <P>\n NOTE: Z-ordering is not considered for the purposes of this test.  If the coordinate you're\n testing is occluded by other component, but the X,Y coordinates are still within the bounds\n that component, this method will return true.\n <P>\n See the related ${isc.DocUtils.linkForRef('method:Canvas.containsEventTarget')} method for checking whether a canvas \n contains the target canvas for the current mouse event.\n\n",
        flags:"",
        returns:{
            type:"Boolean",
            description:"true if the event occurred within the bounds of this component"
        },
        name:"containsEvent"
    },
    "method:Array.contains":{
        seeAlso:[
        ],
        type:"method",
        definingClass:"object:Array",
        returns:{
            type:"boolean",
            description:"true == item was found, false == not found"
        },
        groups:[
            "access"
        ],
        deprecated:null,
        ref:"method:Array.contains",
        params:[
            {
                defaultValue:null,
                optional:false,
                type:"Any",
                description:"item to look for",
                name:"obj"
            },
            {
                defaultValue:null,
                optional:true,
                type:"number",
                description:"optional position in the list to look after",
                name:"pos"
            }
        ],
        description:" Return if this list contains the specified object.\n <P>\n If pos is specified, starts looking after that position.\n\n",
        flags:"",
        name:"contains"
    },
    "method:ListGridField.formatInactiveCellValue":{
        seeAlso:[
            {
                ref:"method:ListGrid.formatInactiveCellValue",
                description:null
            }
        ],
        ref:"method:ListGridField.formatInactiveCellValue",
        deprecated:null,
        type:"method",
        definingClass:"object:ListGridField",
        params:[
            {
                defaultValue:null,
                optional:false,
                type:"Any",
                description:"raw value for the cell, from the record for the row",
                name:"value"
            },
            {
                defaultValue:null,
                optional:false,
                type:"ListGridRecord",
                description:"Record object for the cell. Note: If this is a new row that has not been saved, in an\n   editable grid, it has no associated record object. In this case the edit values will\n   be passed in as this parameter (see ${isc.DocUtils.linkForRef('method:ListGrid.getEditValues')})",
                name:"record"
            },
            {
                defaultValue:null,
                optional:false,
                type:"number",
                description:"row number for the cell",
                name:"rowNum"
            },
            {
                defaultValue:null,
                optional:false,
                type:"number",
                description:"column number for the cell.",
                name:"colNum"
            },
            {
                defaultValue:null,
                optional:false,
                type:"ListGrid",
                description:"the ListGrid displaying the cell",
                name:"grid"
            }
        ],
        description:" Field-level formatter for inactive content.\n <P>\n If present, this method will be invoked instead of ${isc.DocUtils.linkForRef('method:ListGridField.formatCellValue')} in cases \n where the grid is rendering non-interactive content outside. \n See ${isc.DocUtils.linkForRef('method:ListGrid.formatInactiveCellValue')} for more details.\n <P>\n",
        flags:"",
        returns:{
            type:"HTMLString",
            description:"HTML to display in the cell"
        },
        name:"formatInactiveCellValue"
    },
    "attr:Calendar.eventHeaderHeight":{
        seeAlso:[
        ],
        ref:"attr:Calendar.eventHeaderHeight",
        defaultValue:"14",
        deprecated:null,
        type:"attr",
        definingClass:"class:Calendar",
        valueType:"int",
        description:"When ${isc.DocUtils.linkForRef('attr:Calendar.eventHeaderWrap','eventHeaderWrap')} is false and \n ${isc.DocUtils.linkForRef('attr:Calendar.showEventDescriptions','showEventDescriptions')} is true, this is the fixed \n height for the ${isc.DocUtils.linkForRef('attr:EventCanvas.showHeader','header area')} in event canvases.",
        flags:"IR",
        name:"eventHeaderHeight"
    },
    "attr:ComboBoxItem.pickerClearButtonTitle":{
        seeAlso:[
        ],
        defaultValue:"\"Clear\"",
        type:"attr",
        definingClass:"class:ComboBoxItem",
        groups:[
            "i18nMessages",
            "panelPlacement"
        ],
        deprecated:null,
        ref:"attr:ComboBoxItem.pickerClearButtonTitle",
        valueType:"HTMLString",
        description:"The title for the ${isc.DocUtils.linkForRef('attr:ComboBoxItem.pickerClearButton')}.",
        flags:"IR",
        name:"pickerClearButtonTitle"
    },
    "attr:FilterBuilder.operatorPickerWidth":{
        seeAlso:[
        ],
        ref:"attr:FilterBuilder.operatorPickerWidth",
        defaultValue:"150",
        deprecated:null,
        type:"attr",
        definingClass:"class:FilterBuilder",
        valueType:"Integer | String",
        description:"Width for the operator picker formItem displayed in clauses within this FilterBuilder.",
        flags:"IR",
        name:"operatorPickerWidth"
    },
    "attr:UserConfirmationGateway.textFormula":{
        seeAlso:[
        ],
        ref:"attr:UserConfirmationGateway.textFormula",
        defaultValue:"null",
        deprecated:null,
        type:"attr",
        definingClass:"class:UserConfirmationGateway",
        valueType:"UserSummary",
        description:"Formula to be used to calculate the message contents. Use ${isc.DocUtils.linkForRef('attr:UserConfirmationGateway.message')} property\n to assign a static message instead.\n <p> \n Available fields for use in the formula are the current ${isc.DocUtils.linkForRef('attr:Canvas.ruleScope','rule context')}.",
        flags:"IR",
        name:"textFormula"
    },
    "method:ListGrid.setShowGroupSummary":{
        seeAlso:[
        ],
        ref:"method:ListGrid.setShowGroupSummary",
        deprecated:null,
        type:"method",
        definingClass:"class:ListGrid",
        params:[
            {
                defaultValue:null,
                optional:false,
                type:"boolean",
                description:"new value for this.showGroupSummary",
                name:"showGroupSummary"
            }
        ],
        description:" Setter for the ${isc.DocUtils.linkForRef('attr:ListGrid.showGroupSummary')} attribute\n",
        flags:"",
        name:"setShowGroupSummary"
    },
    "method:ButtonItem.setShowFocusedAsOver":{
        seeAlso:[
        ],
        ref:"method:ButtonItem.setShowFocusedAsOver",
        deprecated:null,
        type:"method",
        definingClass:"class:ButtonItem",
        params:[
            {
                defaultValue:null,
                optional:false,
                type:"boolean",
                description:null,
                name:"showFocusedAsOver"
            }
        ],
        description:" Sets showFocusedAsOver.\n",
        flags:"",
        name:"setShowFocusedAsOver"
    },
    "attr:ImgSplitbar.vertical":{
        seeAlso:[
        ],
        ref:"attr:ImgSplitbar.vertical",
        defaultValue:"null",
        deprecated:null,
        type:"attr",
        definingClass:"class:ImgSplitbar",
        valueType:"Boolean",
        description:"Is this split bar vertically orientated?<br>\n When a <code>Splitbar</code> is created by a layout to be the resizeBar for some\n member of the layout, the <code>vertical</code> property will be set to <code>true</code>\n if the layout is horizontal, meaning this resizeBar will be taller than it is wide, \n and will allow horizontal resizing of the member.",
        flags:"R",
        name:"vertical"
    },
    "method:ToolStripGroup.getControlColumn":{
        seeAlso:[
        ],
        ref:"method:ToolStripGroup.getControlColumn",
        deprecated:null,
        type:"method",
        definingClass:"class:ToolStripGroup",
        params:[
            {
                defaultValue:null,
                optional:false,
                type:"Canvas",
                description:"the control to find in this group",
                name:"control"
            }
        ],
        description:" Return the ${isc.DocUtils.linkForRef('attr:ToolStripGroup.columnLayout','column widget')} that contains the passed \n control.\n \n",
        flags:"",
        returns:{
            type:"Layout",
            description:"the column widget containing the passed control"
        },
        name:"getControlColumn"
    },
    "attr:FacetChart.extraAxisLabelAlign":{
        seeAlso:[
        ],
        defaultValue:"\"left\"",
        type:"attr",
        definingClass:"class:FacetChart",
        groups:[
            "labelsAndTitles"
        ],
        deprecated:null,
        ref:"attr:FacetChart.extraAxisLabelAlign",
        valueType:"Alignment",
        description:"Horizontal alignment of labels shown in extra y-axes, shown to the right of the chart.",
        flags:"IRW",
        name:"extraAxisLabelAlign"
    },
    "attr:RichTextCanvas.styleName":{
        seeAlso:[
        ],
        defaultValue:"\"normal\"",
        type:"attr",
        definingClass:"class:RichTextCanvas",
        deprecated:null,
        ref:"attr:RichTextCanvas.styleName",
        setter:[
            "setStyleName"
        ],
        valueType:"CSSStyleName",
        description:"The CSS class applied to this widget as a whole. The editable HTML within this widget\n will appear with this styling applied to it, but it should be noted that this css class\n is not part of that HTML, so applying the generated content to other components will not\n pick up styling attributes defined in this class automatically.",
        flags:"IRW",
        name:"styleName"
    },
    "attr:Button.iconAlign":{
        seeAlso:[
        ],
        defaultValue:"null",
        type:"attr",
        definingClass:"class:Button",
        groups:[
            "buttonIcon"
        ],
        deprecated:null,
        ref:"attr:Button.iconAlign",
        valueType:"String",
        description:"If this button is showing an icon should it be right or left aligned?",
        flags:"IR",
        name:"iconAlign"
    },
    "attr:IconButton.valign":{
        seeAlso:[
        ],
        defaultValue:"null",
        type:"attr",
        definingClass:"class:IconButton",
        groups:[
            "appearance"
        ],
        deprecated:null,
        ref:"attr:IconButton.valign",
        valueType:"VerticalAlignment",
        description:"Vertical alignment of this button's content.  If unset, \n ${isc.DocUtils.linkForRef('attr:IconButton.orientation','vertical buttons')} are top-aligned and horizontal\n buttons center-aligned by default.",
        flags:"IRW",
        name:"valign"
    },
    "method:DrawItem.setFillOpacity":{
        seeAlso:[
        ],
        ref:"method:DrawItem.setFillOpacity",
        deprecated:null,
        type:"method",
        definingClass:"class:DrawItem",
        params:[
            {
                defaultValue:null,
                optional:false,
                type:"float",
                description:"new opacity, as a number between 0 (transparent) and 1 (opaque).",
                name:"opacity"
            }
        ],
        description:" Update fillOpacity for this drawItem.\n",
        flags:"",
        name:"setFillOpacity"
    },
    "method:Canvas.animateScroll":{
        groups:[
            "animation"
        ],
        seeAlso:[
        ],
        ref:"method:Canvas.animateScroll",
        deprecated:null,
        type:"method",
        definingClass:"class:Canvas",
        params:[
            {
                defaultValue:null,
                optional:false,
                type:"Integer",
                description:"desired final left scroll position",
                name:"scrollLeft"
            },
            {
                defaultValue:null,
                optional:false,
                type:"Integer",
                description:"desired final top scroll position",
                name:"scrollTop"
            },
            {
                defaultValue:null,
                optional:true,
                type:"AnimationCallback",
                description:"When the scroll completes this callback will be                       fired. Single 'earlyFinish' parameter will be passed if the\n                       animation was cut short, for example by a call to the non-animated\n                       APIs ${isc.DocUtils.linkForRef('method:Canvas.scrollTo')} or ${isc.DocUtils.linkForRef('method:Canvas.scrollBy')}.",
                name:"callback"
            },
            {
                defaultValue:null,
                optional:true,
                type:"Integer",
                description:"Duration in ms of the animated scroll",
                name:"duration"
            },
            {
                defaultValue:null,
                optional:true,
                type:"AnimationAcceleration",
                description:"Optional acceleration to bias the animation ratios",
                name:"acceleration"
            }
        ],
        description:" Animate a scroll from the current scroll position to the specified position.\n",
        flags:"",
        name:"animateScroll"
    },
    "attr:DynamicForm.readOnlyDisplay":{
        seeAlso:[
        ],
        defaultValue:"\"readOnly\"",
        type:"attr",
        definingClass:"class:DynamicForm",
        groups:[
            "appearance",
            "readOnly"
        ],
        ref:"attr:DynamicForm.readOnlyDisplay",
        deprecated:null,
        setter:[
            "setReadOnlyDisplay"
        ],
        valueType:"ReadOnlyDisplayAppearance",
        description:"If ${isc.DocUtils.linkForRef('attr:DynamicForm.canEdit')} is set to <code>false</code>, how should the items in this\n form be displayed to the user?\n <p>\n Can be overridden via ${isc.DocUtils.linkForRef('attr:FormItem.readOnlyDisplay')} on individual form items.",
        flags:"IRW",
        name:"readOnlyDisplay"
    },
    "attr:EdgedCanvas.edgeStyleName":{
        seeAlso:[
        ],
        defaultValue:"null",
        type:"attr",
        definingClass:"class:EdgedCanvas",
        groups:[
            "imageEdgeStyles",
            "imageEdges"
        ],
        deprecated:null,
        ref:"attr:EdgedCanvas.edgeStyleName",
        valueType:"CSSStyleName",
        description:"Optional property specifying the CSS ClassName to apply to the various parts of this edged canvas\n (top, bottom, corners, sides and center). To\n apply separate styles for each part, use ${isc.DocUtils.linkForRef('attr:EdgedCanvas.addEdgeStyleSuffix')}.",
        flags:"IRW",
        name:"edgeStyleName"
    },
    "attr:DataBoundComponent.dataField":{
        seeAlso:[
        ],
        ref:"attr:DataBoundComponent.dataField",
        defaultValue:"null",
        deprecated:null,
        type:"attr",
        definingClass:"interface:DataBoundComponent",
        valueType:"String",
        description:"Name of the field that has the most pertinent numeric, date, or enum value, for use when a\n ${isc.DocUtils.linkForRef('interface:DataBoundComponent')} needs to show a short summary of a record.\n <P>\n This attribute has the same function as ${isc.DocUtils.linkForRef('attr:DataSource.dataField')} but can be\n set for a component with no dataSource, or can be used to override the dataSource setting.",
        flags:"IR",
        name:"dataField"
    },
    "staticMethod:isc.warn":{
        groups:[
            "Prompting"
        ],
        seeAlso:[
            {
                ref:"classAttr:Dialog.Warn",
                description:null
            },
            {
                ref:"staticMethod:isc.say",
                description:null
            },
            {
                ref:"staticMethod:isc.ask",
                description:null
            },
            {
                ref:"method:Dialog.okClick",
                description:null
            },
            {
                ref:"classAttr:Dialog.WARN_TITLE",
                description:null
            }
        ],
        ref:"staticMethod:isc.warn",
        deprecated:null,
        type:"staticMethod",
        definingClass:"object:isc",
        params:[
            {
                defaultValue:null,
                optional:false,
                type:"String",
                description:"message to display",
                name:"message"
            },
            {
                defaultValue:null,
                optional:true,
                type:"Callback",
                description:"Optional Callback to fire when the user                                      dismisses the dialog. This has the single parameter\n                                      'value', indicating the value returned by the Warn\n                                      dialog from 'okClick()' etc.",
                name:"callback"
            },
            {
                defaultValue:null,
                optional:true,
                type:"Dialog Properties",
                description:"additional properties for the Dialog.                                      To set ${isc.DocUtils.linkForRef('attr:Dialog.buttons','custom buttons')} for\n                                      the Dialog, set properties.buttons to\n                                      an array of buttons\n\t\t\t\t\t\t\t\t\t\teg:\t{ buttons : [Dialog.OK, Dialog.CANCEL] }",
                name:"properties"
            }
        ],
        description:" Show a modal dialog with a message, icon, and \"OK\" button. See ${isc.DocUtils.linkForRef('attr:Dialog.warnIcon')}.\n <P>\n The callback will receive boolean true for an OK button click, or null if the Dialog is\n dismissed via the close button.\n\n",
        flags:"",
        name:"warn"
    },
    "group:communication":{
        refs:[
            "type:SendMethod"
        ],
        seeAlso:[
        ],
        ref:"group:communication",
        deprecated:null,
        type:"group",
        description:null,
        name:"communication"
    },
    "attr:IconButton.showMenuIconDown":{
        seeAlso:[
        ],
        ref:"attr:IconButton.showMenuIconDown",
        defaultValue:"false",
        deprecated:null,
        type:"attr",
        definingClass:"class:IconButton",
        valueType:"Boolean",
        description:"Whether to show a Down version of the ${isc.DocUtils.linkForRef('attr:IconButton.menuIconSrc','menuIcon')}.",
        flags:"IRW",
        name:"showMenuIconDown"
    },
    "method:FormItem.mapDisplayToValue":{
        seeAlso:[
            {
                ref:"method:FormItem.mapValueToDisplay",
                description:null
            }
        ],
        ref:"method:FormItem.mapDisplayToValue",
        deprecated:null,
        type:"method",
        definingClass:"class:FormItem",
        params:[
            {
                defaultValue:null,
                optional:false,
                type:"String",
                description:"display value",
                name:"value"
            }
        ],
        description:" Given a display value for this FormItem, return the underlying data value.  This is \n done by reverse value-mapping, and/or parsing.\n <p>\n This method is called by the framework to derive an underlying data value for a given \n display value (ie, the value the user sees and interacts with) in a FormItem.  Your own \n code can call this method if you need to programmatically obtain the underlying data  \n value for a given display value.  However,\n it is <b>not</b> intended as an override point, and you should not treat \n it as one.\n \n If you have a field that requires the stored value to be different from the displayed \n value, and the requirement cannot be satisfied with a ${isc.DocUtils.linkForRef('attr:FormItem.valueMap','valueMap')}\n for some reason, you can add custom parsing logic by \n implementing ${isc.DocUtils.linkForRef('method:FormItem.parseEditorValue','parseEditorValue()')}\n \n <p>\n This method is also <b>not</b> intended as a place where you can validate, sanitize, \n transform or canonicalize user input<ul>\n <li>To ensure you get well-formed input values, use ${isc.DocUtils.linkForRef('attr:TextItem.mask','input masks')} or \n the ${isc.DocUtils.linkForRef('method:FormItem.change','change() event')}\n \n </li>\n <li>To transform or canonicalize input values, use a ${isc.DocUtils.linkForRef('type:ValidatorType','mask validator')}\n with \"transformTo\".  See the link to \"mask validator\" for more details and an example of this</li>\n <li>To transform or canonicalize input character-by-character as the user types, use \n ${isc.DocUtils.linkForRef('method:FormItem.transformInput','transformInput()')}\n \n </li></ul>\n <h3>Deriving the data value</h3>\n The process of deriving an underlying data display value from a display value involves \n the following steps:<ul>\n <li>If the formItem \n     declares a ${isc.DocUtils.linkForRef('method:FormItem.parseEditorValue')}\n     method,\n     \n      it is called</li>\n <li>Otherwise, if the formItem is of a ${isc.DocUtils.linkForRef('class:SimpleType')} that \n     declares a ${isc.DocUtils.linkForRef('method:SimpleType.parseInput','parseInput()')} method, it\n     \n     is called</li>\n <li>If the formItem is of a <code>SimpleType</code> that \n     ${isc.DocUtils.linkForRef('attr:SimpleType.inheritsFrom','inheritsFrom')} \"date\", \"time\" or \"datetime\", it will \n     be parsed as a date, time or datetime.  Note, this parsing step is applied on top of \n     custom SimpleType- and FormItem-level parsing</li>\n <li>If the formItem declares a ${isc.DocUtils.linkForRef('attr:FormItem.valueMap','valueMap')}, a value is derived by \n looking up the display value (including the effects of any parsing we may have done so far)\n in the valueMap</li>\n </ul>\n <b>Note:</b> Unlike the corollary method ${isc.DocUtils.linkForRef('method:FormItem.mapValueToDisplay','mapValueToDisplay()')},\n there is no special built-in handling of <code>${isc.DocUtils.linkForRef('attr:DataSourceField.multiple')}:true</code> \n fields.  If you want an array to be parsed out of some user input, you must write the\n parser method to do so.\n",
        flags:"",
        returns:{
            type:"Any",
            description:"value re-mapped for storing"
        },
        name:"mapDisplayToValue"
    },
    "method:TileGrid.setHilites":{
        groups:[
            "hiliting"
        ],
        seeAlso:[
        ],
        ref:"method:TileGrid.setHilites",
        deprecated:null,
        type:"method",
        definingClass:"class:TileGrid",
        params:[
            {
                defaultValue:null,
                optional:false,
                type:"Array of Hilite",
                description:"Array of hilite objects",
                name:"hilites"
            }
        ],
        description:" Only supported on ListGrid for now.\n",
        flags:"",
        name:"setHilites"
    },
    "attr:FacetChart.extraAxisMetrics":{
        seeAlso:[
        ],
        ref:"attr:FacetChart.extraAxisMetrics",
        defaultValue:"[]",
        deprecated:null,
        type:"attr",
        definingClass:"class:FacetChart",
        valueType:"Array of String",
        description:"Defines the set of metrics that will be plotted as additional vertical axes.  See the\n main ${isc.DocUtils.linkForRef('class:FacetChart')} docs for an overview of how multi-axis charts are used.\n <p>\n Each metric corresponds to different value property\n of the data records and superimposes its drawn data onto the chart rectangle.\n The value properties are called metrics, and they can be either the ${isc.DocUtils.linkForRef('attr:FacetChart.valueProperty')}\n or the \"id\" of a ${isc.DocUtils.linkForRef('object:FacetValue')} of the inlined ${isc.DocUtils.linkForRef('class:Facet')} (which is then called the\n metric facet).  Each value axis has its own gradations that are shown as tick marks\n along the length of the axis.  This property, extraAxisMetrics, specifies the metrics\n to use for additional value axes to the main value axis.\n <p>\n The additional value axis may have their own gradations, chart type, log scale, data colors\n and gradients, and other chart properties.  These properties are specified with\n the ${isc.DocUtils.linkForRef('attr:FacetChart.extraAxisSettings')} property.\n <p>\n Value axes, including the main value axis, are labelled in the legend along with\n representations of the charted data.  The labels are taken from the ${isc.DocUtils.linkForRef('attr:FacetValue.title')} of\n each metric's FacetValue (or the ${isc.DocUtils.linkForRef('attr:FacetChart.valueTitle')} if the metric is the ${isc.DocUtils.linkForRef('attr:FacetChart.valueProperty')}).\n <p>\n The order of the metrics determines the position of the corresponding axes on\n the chart as well as the z-ordering of the corresponding data lines.\n The first and second extra value axes are placed to the right of the chart rectangle,\n and any remaining extra value axes are placed to the left of the main value axis\n (and therefore to the left of the chart rectangle).",
        flags:"IR",
        name:"extraAxisMetrics"
    },
    "class:Time":{
        seeAlso:[
        ],
        type:"class",
        staticMethods:[
        ],
        inheritsFrom:"Class",
        classMethods:[
            "classMethod:Time.setDefaultDisplayTimezone",
            "classMethod:Time.getDefaultDisplayTimezone",
            "classMethod:Time.toTime",
            "classMethod:Time.toShortTime",
            "classMethod:Time.parseInput",
            "classMethod:Time.createDate",
            "classMethod:Time.createLogicalTime",
            "classMethod:Time.setShortDisplayFormat",
            "classMethod:Time.setNormalDisplayFormat",
            "classMethod:Time.compareTimes"
        ],
        classAttrs:[
            "classAttr:Time.UTCHoursOffset",
            "classAttr:Time.displayFormat",
            "classAttr:Time.shortDisplayFormat",
            "classAttr:Time.AMIndicator",
            "classAttr:Time.PMIndicator",
            "classAttr:Time.adjustForDST",
            "classAttr:Time.use24HourTime",
            "classAttr:Time.defaultTimeSeparator",
            "classAttr:Time.defaultMillisecondSeparator"
        ],
        attrs:[
        ],
        ref:"class:Time",
        deprecated:null,
        treeLocation:[
            "Client Reference/System"
        ],
        description:"Helper methods and system-wide defaults for dealing with time values and time display formats.\n <P>\n This class includes utility methods for the creation and display of logical time values, as well\n as modifying the default display timezone for datetime type values. See\n ${isc.DocUtils.linkForRef('group:dateFormatAndStorage')} for more information on working with dates, times and datetimes\n in SmartClient.",
        methods:[
        ],
        name:"Time"
    },
    "attr:DynamicForm.longTextEditorThreshold":{
        seeAlso:[
        ],
        defaultValue:"255",
        type:"attr",
        definingClass:"class:DynamicForm",
        groups:[
            "appearance"
        ],
        deprecated:null,
        ref:"attr:DynamicForm.longTextEditorThreshold",
        valueType:"number",
        description:"When creating form items for fields with text type data, if the specified length of the\n field exceeds this threshold we will create form item of type \n <code>this.longTextEditorType</code> (a TextAreaItem by default), rather than a simple\n text item.  Overridden by explicitly specifying <code>editorType</code> for the field.",
        flags:"IRW",
        name:"longTextEditorThreshold"
    },
    "method:SplitPane.setListPane":{
        seeAlso:[
        ],
        ref:"method:SplitPane.setListPane",
        deprecated:null,
        type:"method",
        definingClass:"class:SplitPane",
        params:[
            {
                defaultValue:null,
                optional:false,
                type:"Canvas",
                description:"new list pane for this widget.",
                name:"pane"
            }
        ],
        description:" Sets a new ${isc.DocUtils.linkForRef('attr:SplitPane.listPane','listPane')} at runtime.\n",
        flags:"",
        name:"setListPane"
    },
    "method:TileGrid.filterData":{
        groups:[
            "dataBoundComponentMethods"
        ],
        seeAlso:[
            {
                ref:"method:DataBoundComponent.willFetchData",
                description:null
            }
        ],
        ref:"method:TileGrid.filterData",
        deprecated:null,
        type:"method",
        definingClass:"class:TileGrid",
        params:[
            {
                defaultValue:null,
                optional:true,
                type:"Criteria",
                description:"Search criteria.                       If a ${isc.DocUtils.linkForRef('class:DynamicForm')} is passed in as this argument\n                      instead of a raw criteria object, will be derived by calling\n                      ${isc.DocUtils.linkForRef('method:DynamicForm.getValuesAsCriteria')}",
                name:"criteria"
            },
            {
                defaultValue:null,
                optional:true,
                type:"DSCallback",
                description:"callback to invoke when a fetch is complete.  Fires                                          only if server contact was required; see\n                                          ${isc.DocUtils.linkForRef('method:ListGrid.fetchData','fetchData()')} for details",
                name:"callback"
            },
            {
                defaultValue:null,
                optional:true,
                type:"DSRequest",
                description:"for databound components only - optional                            additional properties to set on the DSRequest that will be issued",
                name:"requestProperties"
            }
        ],
        description:" Retrieves data that matches the provided criteria and displays the matching data in this\n component.\n <P>\n This method behaves exactly like ${isc.DocUtils.linkForRef('method:ListGrid.fetchData')} except that\n ${isc.DocUtils.linkForRef('attr:DSRequest.textMatchStyle')} is automatically set to \"substring\" so that String-valued\n fields are matched by case-insensitive substring comparison.\n\n",
        flags:"",
        name:"filterData"
    },
    "attr:Window.modalMaskStyle":{
        seeAlso:[
            {
                ref:"attr:Window.modalMask",
                description:null
            }
        ],
        defaultValue:"\"modalMask\"",
        type:"attr",
        definingClass:"class:Window",
        groups:[
            "modal",
            "appearance"
        ],
        deprecated:null,
        ref:"attr:Window.modalMaskStyle",
        valueType:"String",
        description:"Specifies the CSS style for the modal mask.",
        flags:"IR",
        name:"modalMaskStyle"
    },
    "attr:ModalWindow.autoCenter":{
        seeAlso:[
        ],
        defaultValue:"true",
        type:"attr",
        definingClass:"class:ModalWindow",
        groups:[
            "appearance",
            "location"
        ],
        deprecated:null,
        ref:"attr:ModalWindow.autoCenter",
        valueType:"boolean",
        description:"If true, this Window widget will automatically be centered on the page when shown.\n      If false, it will show up in the last position it was placed (either programmatically,\n      or by user interaction).\n      <P>\n      <b>Note:</b> If an auto-centering Window is either programmatically moved or dragged \n      by an end user, auto-centering behavior is automatically turned off. To manually center \n      a Window, you can use ${isc.DocUtils.linkForRef('method:Window.centerInPage','centerInPage()')}.",
        flags:"IRW",
        name:"autoCenter"
    },
    "method:DrawItem.showAllKnobs":{
        seeAlso:[
        ],
        ref:"method:DrawItem.showAllKnobs",
        deprecated:null,
        type:"method",
        definingClass:"class:DrawItem",
        description:" Shows all supported control knobs for this drawItem. Updates ${isc.DocUtils.linkForRef('attr:DrawItem.knobs')} to include the\n supported knobTypes and if necessary draws out the appropriate control knobs.\n",
        flags:"",
        name:"showAllKnobs"
    },
    "method:FormItem.titleHoverHTML":{
        seeAlso:[
            {
                ref:"attr:FormItem.prompt",
                description:null
            },
            {
                ref:"method:FormItem.titleHover",
                description:null
            },
            {
                ref:"method:FormItem.itemHoverHTML",
                description:null
            },
            {
                ref:"attr:FormItem.showClippedTitleOnHover",
                description:null
            }
        ],
        type:"method",
        definingClass:"class:FormItem",
        returns:{
            type:"HTMLString",
            description:"HTML to be displayed in the hover"
        },
        groups:[
            "Hovers"
        ],
        deprecated:null,
        ref:"method:FormItem.titleHoverHTML",
        params:[
            {
                defaultValue:null,
                optional:false,
                type:"FormItem",
                description:"Pointer to this item",
                name:"item"
            },
            {
                defaultValue:null,
                optional:false,
                type:"DynamicForm",
                description:"This items form",
                name:"form"
            }
        ],
        description:" If defined, this method should return the HTML to display in a hover canvas when the \n user holds the mousepointer over this item's title.  Return null to suppress the hover \n canvas altogether.\n <P>\n If not defined, ${isc.DocUtils.linkForRef('method:DynamicForm.titleHoverHTML')} will be evaluated to determine\n hover content instead.\n\n",
        flags:"A",
        name:"titleHoverHTML"
    },
    "classAttr:ListGrid.BOTH":{
        seeAlso:[
        ],
        defaultValue:"\"both\"",
        type:"classAttr",
        definingClass:"class:ListGrid",
        deprecated:null,
        ref:"classAttr:ListGrid.BOTH",
        valueType:"Constant",
        description:"A declared value of the enum type  \n ${isc.DocUtils.linkForRef('type:RecordDropAppearance','RecordDropAppearance')}.",
        flags:"R",
        name:"BOTH",
        constant:true
    },
    "staticMethod:Date.compareLogicalDates":{
        seeAlso:[
        ],
        ref:"staticMethod:Date.compareLogicalDates",
        deprecated:"Use ${isc.DocUtils.linkForRef('classMethod:DateUtil.compareLogicalDates')}.",
        type:"staticMethod",
        definingClass:"object:Date",
        params:[
            {
                defaultValue:null,
                optional:false,
                type:"Date",
                description:"first date to compare",
                name:"date1"
            },
            {
                defaultValue:null,
                optional:false,
                type:"Date",
                description:"second date to compare",
                name:"date2"
            }
        ],
        description:" Compare two dates, normalizing out the time elements so that only the date elements are\n considered; returns 0 if equal, -1 if the first date is greater (later), or 1 if\n the second date is greater.\n",
        flags:"",
        returns:{
            type:"int",
            description:"0 if equal, -1 if first date &gt; second date, 1 if second date &gt;                      first date.  Returns false if either argument is not a date"
        },
        name:"compareLogicalDates"
    },
    "attr:DataSource.autoDiscoverTree":{
        seeAlso:[
        ],
        ref:"attr:DataSource.autoDiscoverTree",
        defaultValue:"false",
        deprecated:null,
        type:"attr",
        definingClass:"class:DataSource",
        valueType:"boolean",
        description:"Causes ${isc.DocUtils.linkForRef('classMethod:Tree.discoverTree')} to be called on dsResponse.data in order to automatically\n discover tree structures in the response data.\n <P>\n If autoDiscoverTree is set, discoverTree() is called after the default dsResponse.data\n has been derived (${isc.DocUtils.linkForRef('attr:OperationBinding.recordXPath','recordXPath')} and\n ${isc.DocUtils.linkForRef('attr:DataSourceField.valueXPath','valueXPath')} have been applied) and after\n ${isc.DocUtils.linkForRef('method:DataSource.transformResponse')} has been called.\n <P>\n If a DataSourceField is declared with\n ${isc.DocUtils.linkForRef('attr:DataSourceField.childrenProperty','childrenProperty:true')}, discoverTree() will be invoked with\n ${isc.DocUtils.linkForRef('attr:DiscoverTreeSettings.newChildrenProperty','settings.newChildrenProperty')} set to the name of\n the field marked as the childrenField.  Similarly, if the DataSource has a\n ${isc.DocUtils.linkForRef('attr:DataSource.titleField')} it will be used as the\n ${isc.DocUtils.linkForRef('attr:DiscoverTreeSettings.nameProperty','settings.nameProperty')}.",
        flags:"IR",
        name:"autoDiscoverTree"
    },
    "method:Callbacks.HasFileVersionCallback":{
        groups:[
            "fileSource"
        ],
        seeAlso:[
        ],
        ref:"method:Callbacks.HasFileVersionCallback",
        deprecated:null,
        type:"method",
        definingClass:"class:Callbacks",
        params:[
            {
                defaultValue:null,
                optional:false,
                type:"DSResponse",
                description:"A ${isc.DocUtils.linkForRef('class:DSResponse')} instance with metadata about the                                returned data.",
                name:"dsResponse"
            },
            {
                defaultValue:null,
                optional:false,
                type:"boolean",
                description:"Whether the file version exists.",
                name:"data"
            },
            {
                defaultValue:null,
                optional:false,
                type:"DSRequest",
                description:"The ${isc.DocUtils.linkForRef('object:DSRequest')} that was sent.",
                name:"dsRequest"
            }
        ],
        description:" A ${isc.DocUtils.linkForRef('type:Callback')} fired when ${isc.DocUtils.linkForRef('method:DataSource.hasFileVersion')} completes.\n\n",
        flags:"",
        name:"HasFileVersionCallback"
    },
    "attr:TreeGrid.animateFolderSpeed":{
        seeAlso:[
            {
                ref:"attr:TreeGrid.animateFolderTime",
                description:null
            }
        ],
        defaultValue:"3000",
        type:"attr",
        definingClass:"class:TreeGrid",
        groups:[
            "animation"
        ],
        ref:"attr:TreeGrid.animateFolderSpeed",
        deprecated:null,
        valueType:"number",
        description:"When animating folder opening / closing, this property designates the speed of the\n animation in pixels shown (or hidden) per second. Takes precedence over the \n ${isc.DocUtils.linkForRef('attr:TreeGrid.animateFolderTime')} property, which allows the developer to specify a\n duration for the animation rather than a speed.",
        flags:"IRW",
        examples:[
            "${isc.DocUtils.linkForExampleId('animateTree')}"
        ],
        name:"animateFolderSpeed"
    },
    "classAttr:Operators.isNullTitle":{
        seeAlso:[
        ],
        defaultValue:"\"is null\"",
        type:"classAttr",
        definingClass:"class:Operators",
        groups:[
            "i18nMessages"
        ],
        deprecated:null,
        ref:"classAttr:Operators.isNullTitle",
        valueType:"String",
        description:"Title for the \"isNull\" operator",
        flags:"IR",
        name:"isNullTitle"
    },
    "classMethod:AutoTest.setTestRoot":{
        groups:[
            "autoTest"
        ],
        seeAlso:[
        ],
        ref:"classMethod:AutoTest.setTestRoot",
        deprecated:null,
        type:"classMethod",
        definingClass:"class:AutoTest",
        params:[
            {
                defaultValue:null,
                optional:false,
                type:"Canvas",
                description:"the implicit root",
                name:"canvas"
            }
        ],
        description:" Sets the implicit root canvas available in scLocators starting \"//testRoot[]\".\n Setting this property may enable one to use the same script to test identical\n widget hierarchies that are rooted under different base widgets.\n",
        flags:"",
        name:"setTestRoot"
    },
    "attr:MultiSortPanel.descendingTitle":{
        seeAlso:[
        ],
        defaultValue:"\"Descending\"",
        type:"attr",
        definingClass:"class:MultiSortPanel",
        groups:[
            "i18nMessages"
        ],
        deprecated:null,
        ref:"attr:MultiSortPanel.descendingTitle",
        valueType:"String",
        description:"The title-text to appear in the \"direction\" field's SelectItem for a \"descending\" sort",
        flags:"IR",
        name:"descendingTitle"
    },
    "classAttr:Operators.regexpTitle":{
        seeAlso:[
        ],
        defaultValue:"\"matches expression (match case)\"",
        type:"classAttr",
        definingClass:"class:Operators",
        groups:[
            "i18nMessages"
        ],
        deprecated:null,
        ref:"classAttr:Operators.regexpTitle",
        valueType:"String",
        description:"Title for the \"regexp\" operator",
        flags:"IR",
        name:"regexpTitle"
    },
    "classMethod:Log.setDefaultPriority":{
        seeAlso:[
        ],
        ref:"classMethod:Log.setDefaultPriority",
        deprecated:null,
        type:"classMethod",
        definingClass:"class:Log",
        params:[
            {
                defaultValue:null,
                optional:false,
                type:"LogPriority",
                description:"priority level to set",
                name:"priority"
            },
            {
                defaultValue:null,
                optional:true,
                type:"Class | Instance Object",
                description:"Optional ISC class or instance - if passed the default priority will be set for logging \n      occurring on the class or instance only.",
                name:"object"
            }
        ],
        description:" Set the default priority of messages that will be visible.\n\n",
        flags:"",
        name:"setDefaultPriority"
    },
    "method:MultiLinkSelection.getSelection":{
        groups:[
            "selection"
        ],
        seeAlso:[
        ],
        ref:"method:MultiLinkSelection.getSelection",
        deprecated:null,
        type:"method",
        definingClass:"class:MultiLinkSelection",
        description:" Returns the selected nodes in this grid as a list of ${isc.DocUtils.linkForRef('object:NodeLocator')}s.\n\n",
        flags:"",
        returns:{
            type:"Array of NodeLocator",
            description:"The list of selected node occurences in the grid"
        },
        name:"getSelection"
    },
    "attr:Button.canAdaptWidth":{
        seeAlso:[
            {
                ref:"attr:Canvas.canAdaptWidth",
                description:null
            }
        ],
        defaultValue:"false",
        type:"attr",
        definingClass:"class:Button",
        deprecated:null,
        ref:"attr:Button.canAdaptWidth",
        valueType:"Boolean",
        description:"This flag enables ${isc.DocUtils.linkForRef('attr:Canvas.canAdaptWidth','adaptive width')} for the button.\n <P>\n If enabled the button will support rendering in a 'collapsed' view if there isn't enough\n space in a layout to render it at normal size. There are a couple of ways this can be achieved.\n <ul>\n <li>If ${isc.DocUtils.linkForRef('attr:Button.adaptWidthShowIconOnly')} is true and this button shows an icon, the title\n     will be hidden if there isn't enough space to render it, allowing it to shrink to either\n     the rendered icon width, or any specified ${isc.DocUtils.linkForRef('attr:Canvas.minWidth','minWidth')}, whichever is larger.</li>\n <li>Otherwise, if the button has a specified ${isc.DocUtils.linkForRef('attr:Canvas.minWidth','minWidth')}, and \n     ${isc.DocUtils.linkForRef('attr:Button.autoFit')} is true, autoFit will be temporarily disabled, if there isn't enough\n     room, allowing the title to be clipped</li>\n </ul>\n In either case the title will show on hover unless an explicit hover has been\n specified such as by overriding ${isc.DocUtils.linkForRef('method:Button.titleHoverHTML')}.",
        flags:"IR",
        examples:[
            "${isc.DocUtils.linkForExampleId('buttonAdaptiveWidth')}"
        ],
        name:"canAdaptWidth"
    },
    "attr:DateChooser.cancelButtonTitle":{
        seeAlso:[
        ],
        defaultValue:"\"Cancel\"",
        type:"attr",
        definingClass:"class:DateChooser",
        groups:[
            "i18nMessages"
        ],
        deprecated:null,
        ref:"attr:DateChooser.cancelButtonTitle",
        valueType:"String",
        description:"Title for the cancellation button.",
        flags:"IRW",
        name:"cancelButtonTitle"
    },
    "attr:ShowNextToComponentTask.canOcclude":{
        seeAlso:[
        ],
        ref:"attr:ShowNextToComponentTask.canOcclude",
        defaultValue:"null",
        deprecated:null,
        type:"attr",
        definingClass:"class:ShowNextToComponentTask",
        valueType:"Boolean",
        description:"Can this component can be positioned on top of the other\n component if there isn't room to show next to it?",
        flags:"IR",
        name:"canOcclude"
    },
    "attr:ListGrid.showSelectionCanvas":{
        seeAlso:[
            {
                ref:"attr:ListGrid.showSelectionUnderCanvas",
                description:null
            }
        ],
        defaultValue:"null",
        type:"attr",
        definingClass:"class:ListGrid",
        groups:[
            "rowEffects"
        ],
        deprecated:null,
        ref:"attr:ListGrid.showSelectionCanvas",
        valueType:"Boolean",
        description:"If ${isc.DocUtils.linkForRef('attr:ListGrid.selectionType','selectionType')} is set to\n \"single\",\n \n setting this property to <code>true</code> means selection will be displayed to the\n user with the ${isc.DocUtils.linkForRef('attr:ListGrid.selectionCanvas','selectionCanvas')} and/or\n ${isc.DocUtils.linkForRef('attr:ListGrid.selectionUnderCanvas','selectionUnderCanvas')} rather than with CSS styling.\n <p>\n If <code>showSelectionCanvas</code> is set to <code>true</code>, then the\n <code>selectionUnderCanvas</code> will automatically be enabled unless\n ${isc.DocUtils.linkForRef('attr:ListGrid.showSelectionUnderCanvas','showSelectionUnderCanvas')} is set to <code>false</code>.\n <p>\n NOTE: It is recommended to use the <code>selectionUnderCanvas</code> rather than the\n <code>selectionCanvas</code> if possible because the <code>selectionCanvas</code> is\n stacked on top of the selected record and this may interfere with event handling in rare\n cases. If no interactive components are shown in the <code>selectionCanvas</code> and it\n simply provides custom styling, then the <code>selectionUnderCanvas</code> should be used\n instead.\n <p>\n With ${isc.DocUtils.linkForRef('attr:ListGrid.canFreezeFields','frozen fields')}, the <code>selectionCanvas</code>\n is displayed only over the non-frozen fields of the selected row.",
        flags:"IRWA",
        name:"showSelectionCanvas"
    },
    "classAttr:Authentication.logOutURL":{
        seeAlso:[
        ],
        ref:"classAttr:Authentication.logOutURL",
        defaultValue:"null",
        deprecated:null,
        type:"classAttr",
        definingClass:"class:Authentication",
        valueType:"String",
        description:"URL to open for logging the current user out.\n <P>\n This is a dynamic string - text within <code>&#36;{...}</code> are dynamic variables and will \n be evaluated as JS code when the message is displayed.\n <P>\n The dynamic variables available are the fields in the ${isc.DocUtils.linkForRef('classMethod:Authentication.getCurrentUser')} record.",
        flags:"IR",
        name:"logOutURL"
    },
    "method:Canvas.getWidth":{
        groups:[
            "sizing"
        ],
        seeAlso:[
        ],
        ref:"method:Canvas.getWidth",
        deprecated:null,
        type:"method",
        definingClass:"class:Canvas",
        description:" Return the width of this object, in pixels.\n",
        flags:"",
        returns:{
            type:"Number",
            description:"width"
        },
        name:"getWidth"
    },
    "class:NativeCheckboxItem":{
        seeAlso:[
        ],
        type:"class",
        staticMethods:[
        ],
        inheritsFrom:"FormItem",
        classMethods:[
        ],
        classAttrs:[
        ],
        attrs:[
            "attr:NativeCheckboxItem.textBoxStyle",
            "attr:NativeCheckboxItem.showLabel"
        ],
        ref:"class:NativeCheckboxItem",
        deprecated:null,
        description:"A checkbox for manipulating 2-valued fields based on the native checkbox element.",
        methods:[
        ],
        name:"NativeCheckboxItem"
    },
    "group:autoChildren":{
        refs:[
            "type:AutoChild",
            "method:Class.addAutoChild",
            "method:Class.createAutoChild",
            "attr:Class.creator",
            "attr:Class.autoCreator",
            "attr:Canvas.autoParent"
        ],
        seeAlso:[
            {
                ref:"attr:Canvas.autoParent",
                description:null
            },
            {
                ref:"attr:Class.autoCreator",
                description:null
            }
        ],
        ref:"group:autoChildren",
        deprecated:null,
        type:"group",
        description:"An autoChild is an automatically generated subcomponent that a component creates to\n handle part of its presentation or functionality.\n <P>\n An example is the Window component and its subcomponent the \"header\".\n <P>\n AutoChildren support a standard set of properties that can be used to customize or skin\n them.\n <P>\n This topic explains how to use the autoChild system when creating custom components in\n order to create maximum flexibility.  To learn how to use the autoChild system with \n pre-existing components, ${isc.DocUtils.linkForRef('group:autoChildUsage','go here')}.  \n <P>\n Before reading this topic, be sure you have read the ${isc.DocUtils.linkForDocNode('QuickStart Guide')}\n material on creating custom components and have reviewed the provided examples.\n <P>\n <h3>Basics</h3>\n <P>\n The following is an example of creating subcomponents <b>without</b> using the AutoChild\n pattern.  In this case a fictitious \"Portlet\" class is being created, which uses an\n instance of isc.Label to serve as it's header.\n <pre>\n isc.defineClass(\"Portlet\", \"VLayout\").addProperties({\n     initWidget : function () {\n         this.Super(\"initWidget\", arguments);\n\n         this.headerLabel = isc.Label.create({\n             autoDraw:false,\n             contents: this.title, \n             styleName: this.titleStyleName,\n             portlet:this,\n             click : function () { this.portlet.bringToFront() },\n             wrap:false,  \n             overflow:\"hidden\", \n             width:\"100%\"\n         });\n         this.addMember(this.headerLabel);\n         ...\n </pre>\n While straightforward, this approach provides limited flexibility to someone using the\n \"Portlet\" class.  There is no way to:\n <ol>\n <li> avoid creating the headerLabel, for a \"headerless\" portlet\n <li> use a different, more advanced class as a header (eg, StretchImgButton or a custom \n class)\n <li> skin the headerLabel, other than CSS (rounded corners, animations, etc, wouldn't be\n possible)\n <li> change it's layout behavior (eg enable autoSize)\n <li> add or override event handlers\n </ol>\n Let's imagine we wanted to add some of the above features.  We could change the code\n like so:\n <P>\n <pre>\n isc.defineClass(\"Portlet\", \"VLayout\").addProperties({\n     <b>showHeaderLabel:true,</b>\n     <b>headerLabelConstructor:isc.Label,</b>\n     initWidget : function () {\n         this.Super(\"initWidget\", arguments);\n\n         <b>if (this.showHeaderLabel) {</b>\n             this.headerLabel = this.headerLabelConstructor.create({\n                 autoDraw:false,\n                 contents: this.title, \n                 styleName: this.titleStyleName,\n                 portlet:this,\n                 click : function () { this.portlet.bringToFront() },\n                 wrap:false,  \n                 overflow:\"hidden\", \n                 width:\"100%\"\n             }<b>, this.headerLabelProperties</b>);\n             this.addMember(this.headerLabel);\n         <b>}</b>\n         ...\n </pre>\n Our additions solve our initial concerns:\n <ul>\n <li> <code>showHeaderLabel:false</code> can be set to suppress the header label\n <li> <code>headerLabelConstructor</code> allows you to switch to a different class\n <li> <code>headerLabelProperties</code> give you a means to add arbitrary properties\n (skinning properties, sizing properties, event handlers, etc)\n </ul>\n However, the code is becoming more verbose and repetitive, and we've created a few\n additional properties that now need documentation and testing.  This extra work is going\n to be multiplied by every subcomponent we create where we want this kind of flexibility.\n <P>\n Enter the AutoChild system: the purpose of the AutoChild system is to define a standard\n pattern for creating subcomponents with maximum flexibility.  This means:\n <ul>\n <li> developers creating custom components write less code, have less to test and less\n to document\n <li> developers can more easily understand each other's code for custom components,\n because it follows a standard pattern\n <li> developers <b>using</b> custom components have a standard pattern for\n customization, instead of learning customization APIs for every component separately\n </ul>\n The code below uses the autoChild system to create the \"headerLabel\" subcomponent.  This\n version of the code would still respect all of the customization properties from earlier\n examples (<code>headerLabelProperties</code> et al) and offers several additional degrees\n of flexibility still to be explained, yet it's significantly shorter.  More importantly,\n this code is less redundant; the \"boilerplate\" code is gone and what's left is just the\n actual settings for the headerLabel subcomponent.\n <pre>\n isc.defineClass(\"Portlet\", \"VLayout\").addProperties({\n     headerLabelDefaults : {\n         _constructor:isc.Label,\n         click : function () { this.creator.bringToFront() },\n         wrap:false,  \n         overflow:\"hidden\", \n         width:\"100%\"\n     },\n     initWidget : function () {\n         this.Super(\"initWidget\", arguments);\n\n         this.addAutoChild(\"headerLabel\", {\n             contents: this.title, \n             styleName: this.titleStyleName\n         });\n         ...\n </pre>\n <P>\n The documentation for ${isc.DocUtils.linkForRef('method:Class.addAutoChild','addAutoChild()')} explains why this code\n will still respect the <code>showHeaderLabel</code> flag and other customization\n properties even though they aren't mentioned specifically.\n <P>\n Note that AutoChildren are not always created as soon as the parent component, and may \n be created only when the parent is drawn, or in some cases, only when needed.  \n For the best chance of forward compatibility, use properties and defaults instead of \n accessing the live reference, and if you do access the live reference, access it only \n when it is clear that the AutoChild must have been created by that point.  \n For example, even if you determined by experimentation that the Window class currently \n creates it's \"header\" AutoChild when the Window is created, you should avoid accessing \n it until the Window has drawn, to leave room for the Window's implementation to change \n such that creation of the \"header\" AutoChild is deferred until draw.\n <P>\n <h3>AutoChildren lifecycle</h3>\n <P>\n By default any auto-children created by ${isc.DocUtils.linkForRef('method:Class.addAutoChild')} or \n ${isc.DocUtils.linkForRef('method:Class.createAutoChild')} will be ${isc.DocUtils.linkForRef('method:Canvas.destroy','destroyed')} when the\n canvas that created them is destroyed. You can suppress this behavior by setting\n <code>dontAutoDestroy</code> to <code>true</code> on the auto child. To do this you\n could add the property to the defaults or properties block for the autoChild, or\n pass it into the creating method in the dynamic set of properties.\n <p>\n <h3>Subclassing a component with autoChildren</h3>\n <P>\n If you are subclassing a component that has an autoChild and you want to change\n defaults for that autoChild, the correct way to do so is to use\n ${isc.DocUtils.linkForRef('classMethod:Class.changeDefaults','changeDefaults()')}:\n <pre>\n isc.defineClass(\"MyWindow\", \"Window\");\n isc.MyWindow.changeDefaults(\"headerDefaults\", { layoutMargin:10 });\n isc.MyWindow.addProperties({ \n    ...\n </pre>\n <P>\n <code>changeDefaults()</code> creates a copy of the superclass defaults and applies your\n changes, which is important because you want to inherit the superclass behavior without\n affecting the superclass, and yet apply overrides.\n <P>\n The following code sample indicates two common \n <span style=\"color:red;font-weight:bold\">incorrect</span> patterns for working with\n defaults, and the consequences of each: \n <pre>\n isc.defineClass(\"MyWindow\", \"Window\").addProperties({\n     // NO.  Superclass behavior / settings for autoChild\n     // won't be inherited.  Use changeDefaults() instead.\n     headerDefaults : { ... },\n \n     initWidget : function () {\n         this.Super(\"initWidget\", arguments);\n\n         // NO.  \"headerDefaults\" object is shared across the class,\n         // changing it affects all instances created from here on.\n         // Pass dynamic defaults to addAutoChild() instead\n         this.headerDefaults.myProperty = this.newValue;\n         ...\n });\n </pre>\n <b>defaults vs properties</b>\n <P>\n For AutoChildren, defaults and properties both provide similar means of adding\n properties to an AutoChild, and the distinction between them is primarily one of\n convention: a class that uses AutoChildren should never define a default value for\n <i>autoChildName</i>Properties, so that instances can freely specify\n <i>autoChildName</i>Properties without overriding built-in behavior.\n <pre>\n isc.defineClass(\"MyWindow\", \"Window\").addProperties({\n     // NO.  Any further use of \"headerProperties\", in\n     // instances or in subclasses, would wipe out behavior\n     headerProperties : { ... },\n </pre>\n <P>\n By consistently using ${isc.DocUtils.linkForRef('classMethod:Class.changeDefaults')} whenever you override autoChild\n defaults in a subclass, you ensure that your classes can in turn be subclassed and\n extended uniformly.\n <P>\n <h3>autoParents and creation order</h3>\n <P>\n The AutoChild pattern can create an entire hierarchy of generated subcomponents.  For\n example, the ${isc.DocUtils.linkForRef('class:Window')} class included with SmartClient uses several AutoChildren as\n part of the overall header structure: separate autoChildren for the minimize button,\n close button, and then the header itself, a Layout-derived class that contains all other\n header controls. \n <P>\n To facilitate construction of hierarchies of autoChildren, the special\n <code>autoParent</code> property may appear in either defaults or properties for an\n autoChild, and indicates the name of another autoChild that should used as a parent.\n For example, to create a \"closeButton\" autoChild that will be a member of the \"header\"\n autoChild:\n <P>\n <pre>\n isc.defineClass(\"Portlet\", \"VLayout\").addProperties({\n     headerDefaults : {\n         _constructor:isc.HLayout,\n         ...\n     },\n     closeButtonDefaults : {\n         <b>autoParent:\"header\",</b>\n         _constructor:isc.ImgButton,\n         ...\n     },\n     initWidget : function () {\n         this.Super(\"initWidget\", arguments);\n\n         this.addAutoChild(\"header\");\n         this.addAutoChild(\"closeButton\");\n         ...\n </pre>\n <P>\n In addition to cutting down on code and making inter-autoChild relationships clearer,\n using <code>autoParent</code> rather than manual calls to addMember() allows a\n subclass of your component to potentially completely rearrange the autoChildren you have\n defined, while retaining their behavior.\n <P>\n When using <code>autoParent</code> to arrange autoChildren, create parents first, then\n children.\n <P>\n <b>Tip:</b> if you want all of the behaviors of\n ${isc.DocUtils.linkForRef('method:Class.addAutoChild','addAutoChild()')} <i>except</i> automatically adding the\n autoChild to a parent, set <code>autoParent:\"none\"</code>.\n <P>\n <b>special case: TabSets and SectionStacks</b>\n <p>\n An autoChild that appears as a ${isc.DocUtils.linkForRef('attr:Tab.pane')} or\n ${isc.DocUtils.linkForRef('attr:SectionStackSection.items','section item')} does not have a clear way to refer to it's\n tab or section via the <code>autoParent</code> property.  For this special case, the\n TabSet and SectionStack components allow tab.pane / section.items to contain the special\n string \"autoChild:<i>autoChildName</i>\".  This will cause the corresponding autoChild to\n be automatically created when the tab is selected or section expanded.\n <P>\n Generally, whatever component is creating the AutoChildren should be the logically\n reusable, self-contained component, and all the meaty logic should appear as methods on\n that component.  Then you know that the ${isc.DocUtils.linkForRef('attr:Class.creator','creator')} is always the same\n thing, and always where all the logic is.\n <P>\n For example:\n <pre>\n isc.defineClass(\"Portlet\", \"VLayout\").addProperties({\n     ...\n     mainTabsDefaults : {\n         _constructor:isc.TabSet,\n         tabs : [\n             { title:\"First Pane\", pane:\"autoChild:firstPane\" }\n         ]\n     },\n     firstPaneDefaults : {\n         ...\n     },\n     initWidget : function () {\n         this.Super(\"initWidget\", arguments);\n\n         // this automatically creates firstPane as an autoChild\n         this.addAutoChild(\"mainTabs\");\n         ...\n </pre>",
        name:"autoChildren"
    },
    "method:ValuesManager.showErrors":{
        groups:[
            "errors"
        ],
        seeAlso:[
        ],
        ref:"method:ValuesManager.showErrors",
        deprecated:null,
        type:"method",
        definingClass:"class:ValuesManager",
        description:" Method to explicitly show the latest set of validation errors present on this \n ValuesManager.<br>\n Will redraw all member forms to display (or clear) currently visible errors, and\n fire ${isc.DocUtils.linkForRef('method:ValuesManager.handleHiddenValidationErrors')} to allow custom handling of\n hidden errors.\n",
        flags:"",
        name:"showErrors"
    },
    "method:ListGridField.recordDoubleClick":{
        seeAlso:[
            {
                ref:"method:ListGrid.recordClick",
                description:null
            }
        ],
        type:"method",
        definingClass:"object:ListGridField",
        returns:{
            type:"boolean",
            description:"false to stop event bubbling"
        },
        groups:[
            "events"
        ],
        ref:"method:ListGridField.recordDoubleClick",
        deprecated:null,
        params:[
            {
                defaultValue:null,
                optional:false,
                type:"ListGrid",
                description:"the listGrid that contains doubleclick event",
                name:"viewer"
            },
            {
                defaultValue:null,
                optional:false,
                type:"ListGridRecord",
                description:"the record that was double-clicked",
                name:"record"
            },
            {
                defaultValue:null,
                optional:false,
                type:"number",
                description:"number of the record clicked on in the current set of                                  displayed records (starts with 0)",
                name:"recordNum"
            },
            {
                defaultValue:null,
                optional:false,
                type:"ListGridField",
                description:"the field that was clicked on (field definition)",
                name:"field"
            },
            {
                defaultValue:null,
                optional:false,
                type:"number",
                description:"number of the field clicked on in the listGrid.fields                                  array",
                name:"fieldNum"
            },
            {
                defaultValue:null,
                optional:false,
                type:"Object",
                description:"value of the cell (after valueMap, etc. applied)",
                name:"value"
            },
            {
                defaultValue:null,
                optional:false,
                type:"Object",
                description:"raw value of the cell (before valueMap, etc applied)",
                name:"rawValue"
            }
        ],
        description:"\n Executed when this field is double-clicked.  Note that if\n ${isc.DocUtils.linkForRef('method:ListGrid.recordDoubleClick')} is also defined, it will be fired for fields that define\n a recordDoubleClick handler if the field-level handler returns true. Return false to prevent\n the grid-level handler from firing.\n\n\n",
        flags:"",
        examples:[
            "${isc.DocUtils.linkForExampleId('recordClicks')}"
        ],
        name:"recordDoubleClick"
    },
    "classMethod:Page.ignore":{
        seeAlso:[
        ],
        ref:"classMethod:Page.ignore",
        deprecated:null,
        type:"classMethod",
        definingClass:"class:Page",
        params:[
            {
                defaultValue:null,
                optional:false,
                type:"String",
                description:"ID returned from ${isc.DocUtils.linkForRef('classMethod:Page.observe')} call we want to clear",
                name:"observerID"
            }
        ],
        description:" Clear an observation set up by ${isc.DocUtils.linkForRef('classMethod:Page.observe')}.\n <P>\n This method is available as <code>isc.Page.ignore()</code> or just <code>isc.ignore()</code>\n\n",
        flags:"",
        name:"ignore"
    },
    "class:ToolStripMenuButton":{
        seeAlso:[
        ],
        type:"class",
        staticMethods:[
        ],
        inheritsFrom:"MenuButton",
        classMethods:[
        ],
        classAttrs:[
        ],
        attrs:[
        ],
        ref:"class:ToolStripMenuButton",
        deprecated:null,
        treeLocation:[
            "Client Reference/Layout/ToolStrip"
        ],
        description:"Simple subclass of MenuButton with appearance appropriate for a ToolStrip menu button.\n Can be used to create an icon-only menu button, and icon with text, or a text only button by setting the \n icon and title attibutes as required.",
        methods:[
        ],
        name:"ToolStripMenuButton"
    },
    "attr:ToolStripGroup.titleProperties":{
        seeAlso:[
        ],
        ref:"attr:ToolStripGroup.titleProperties",
        defaultValue:"null",
        deprecated:"set these properties directly via the ${isc.DocUtils.linkForRef('attr:ToolStripGroup.label','label autoChild')}",
        type:"attr",
        definingClass:"class:ToolStripGroup",
        valueType:"AutoChild Label",
        description:"AutoChild properties for fine customization of the \n ${isc.DocUtils.linkForRef('attr:ToolStripGroup.label','title label')}.",
        flags:"IRW",
        name:"titleProperties"
    },
    "method:ListGrid.getDrawnRowHeight":{
        seeAlso:[
        ],
        type:"method",
        definingClass:"class:ListGrid",
        returns:{
            type:"number",
            description:"height"
        },
        groups:[
            "sizing",
            "positioning"
        ],
        deprecated:null,
        ref:"method:ListGrid.getDrawnRowHeight",
        params:[
            {
                defaultValue:null,
                optional:false,
                type:"number",
                description:null,
                name:"rowNum"
            }
        ],
        description:" Get the drawn height of a row.\n\n",
        flags:"A",
        name:"getDrawnRowHeight"
    },
    "attr:FacetChart.showRegressionLine":{
        seeAlso:[
            {
                ref:"attr:FacetChart.xAxisMetric",
                description:null
            },
            {
                ref:"attr:FacetChart.yAxisMetric",
                description:null
            },
            {
                ref:"attr:FacetChart.regressionLineProperties",
                description:null
            }
        ],
        defaultValue:"false",
        type:"attr",
        definingClass:"class:FacetChart",
        deprecated:null,
        ref:"attr:FacetChart.showRegressionLine",
        setter:[
            "setShowRegressionLine"
        ],
        valueType:"Boolean",
        description:"For scatter plots only, whether to display a regression curve that best fits the data of\n the two metric facet values.\n <P>\n The type of regression curve used depends on the ${isc.DocUtils.linkForRef('type:RegressionLineType')} property,\n which can be:\n <ul>\n <li><b>\"line\"</b> &ndash; to draw a linear regression curve, or</li>\n <li><b>\"polynomial\"</b> &ndash; to draw a polynomial regression curve (of degree\n ${isc.DocUtils.linkForRef('attr:FacetChart.regressionPolynomialDegree')}).<li>\n </ul>\n <P>\n Note that the regression is computed using all of the data points and it does not depend\n on the values of any non-metric facets.  For example, adding a legend facet will not\n change the regression curve.\n <P>\n See <a href=\"http://en.wikipedia.org/wiki/Simple_linear_regression\">http://en.wikipedia.org/wiki/Simple_linear_regression</a>.\n See <a href=\"http://en.wikipedia.org/wiki/Polynomial_regression\">http://en.wikipedia.org/wiki/Polynomial_regression</a>.",
        flags:"IRW",
        name:"showRegressionLine"
    },
    "attr:DynamicForm.titleWidth":{
        seeAlso:[
        ],
        defaultValue:"100",
        type:"attr",
        definingClass:"class:DynamicForm",
        groups:[
            "formTitles"
        ],
        deprecated:null,
        ref:"attr:DynamicForm.titleWidth",
        valueType:"number | \"*\"",
        description:"The width in pixels allocated to the title of every item in this form.  If you\n          don't specify explicit ${isc.DocUtils.linkForRef('attr:DynamicForm.colWidths')}, you can set this\n          value to the string \"*\" to divide the usable space evenly between titles and\n          fields.",
        flags:"IRW",
        name:"titleWidth"
    },
    "attr:Dialog.toolbarButtons":{
        seeAlso:[
        ],
        defaultValue:"null",
        type:"attr",
        definingClass:"class:Dialog",
        deprecated:null,
        ref:"attr:Dialog.toolbarButtons",
        setter:[
            "setToolbarButtons"
        ],
        valueType:"Array of Button | Array of Button Properties",
        description:"This is a synonym for ${isc.DocUtils.linkForRef('attr:Dialog.buttons')}",
        flags:"IR",
        name:"toolbarButtons"
    },
    "type:PreserveOpenState":{
        seeAlso:[
        ],
        ref:"type:PreserveOpenState",
        deprecated:null,
        type:"type",
        values:[
            {
                value:"never",
                description:"Never try to automatically preserve the openState.  Nodes will be initially open \n  or closed based solely on the ${isc.DocUtils.linkForRef('attr:Tree.openProperty')} optionally set by the server."
            },
            {
                value:"whenUnique",
                description:"If either the ${isc.DocUtils.linkForRef('attr:Tree.idField')} or ${isc.DocUtils.linkForRef('attr:Tree.nameProperty')} has been set on \n  the Tree, (so that nodes have either unique ids or unique paths), \n  preserve openState by respecting the ${isc.DocUtils.linkForRef('attr:Tree.openProperty')} set by the server, \n  then applying the openState."
            },
            {
                value:"always",
                description:"Like \"whenUnique\" but automatically preserves openState even if nodes cannot be\n  uniquely identified.  This means that nodes at the same tree positions \n  (eg 3rd child of 5th node under root) will be placed in the same openState, \n  regardless of whether that node has anything to do with the node that previously \n  was at that tree position."
            }
        ],
        description:null,
        name:"PreserveOpenState"
    },
    "method:Calendar.shouldShowEvent":{
        seeAlso:[
        ],
        ref:"method:Calendar.shouldShowEvent",
        deprecated:null,
        type:"method",
        definingClass:"class:Calendar",
        params:[
            {
                defaultValue:null,
                optional:false,
                type:"CalendarEvent",
                description:"the event to check",
                name:"event"
            },
            {
                defaultValue:null,
                optional:true,
                type:"CalendarView",
                description:"the view the event will be rendered in",
                name:"view"
            }
        ],
        description:" Indicates whether the passed ${isc.DocUtils.linkForRef('object:CalendarEvent','event')} should be visible in the \n passed ${isc.DocUtils.linkForRef('class:CalendarView')}.\n <P>\n The default implementation returns true - note that this method only runs for events that are \n known to be in the accessible range and is a mechanism for extended custom filtering.\n",
        flags:"",
        returns:{
            type:"boolean",
            description:"true if this event should be displayed in the passed view"
        },
        name:"shouldShowEvent"
    },
    "attr:DynamicForm.minColWidth":{
        seeAlso:[
        ],
        defaultValue:"20",
        type:"attr",
        definingClass:"class:DynamicForm",
        groups:[
            "formLayout"
        ],
        deprecated:null,
        ref:"attr:DynamicForm.minColWidth",
        valueType:"number",
        description:"Minimum width of a form column.",
        flags:"IRW",
        name:"minColWidth"
    },
    "attr:TabSet.bottomEdgeSizes":{
        seeAlso:[
        ],
        ref:"attr:TabSet.bottomEdgeSizes",
        defaultValue:"null",
        deprecated:null,
        type:"attr",
        definingClass:"class:TabSet",
        valueType:"EdgeSizes",
        description:"If this tabSet will ${isc.DocUtils.linkForRef('attr:TabSet.showPaneContainerEdges','show edges')} for the paneContainer,\n and ${isc.DocUtils.linkForRef('attr:TabSet.symmetricEdges')} is set to false, the <code>leftEdgeSizes</code>, \n <code>rightEdgeSizes</code>, <code>topEdgeSizes</code> and <code>bottomEdgeSizes</code> \n properties allow the sizes of edges for the paneContainer to be customized depending on\n the ${isc.DocUtils.linkForRef('attr:TabSet.tabBarPosition')}.\n <P>\n The attribute should be specified an ${isc.DocUtils.linkForRef('type:EdgeSizes','edgeSizes map')}, specifying the\n desired edge sizes where for the appropriate ${isc.DocUtils.linkForRef('attr:TabSet.tabBarPosition')}.",
        flags:"IR",
        name:"bottomEdgeSizes"
    },
    "classMethod:Page.getSampleThumbnailDir":{
        seeAlso:[
        ],
        type:"classMethod",
        definingClass:"class:Page",
        returns:{
            type:"String",
            description:"URL for root directory of sample-thumbnails."
        },
        groups:[
            "files"
        ],
        deprecated:null,
        ref:"classMethod:Page.getSampleThumbnailDir",
        params:[
            {
                defaultValue:null,
                optional:true,
                type:"String",
                description:"New URL for Showcase sample-thumbnails",
                name:"URL"
            }
        ],
        description:" Return the dir for skin-specific sample-thumbnails in the product Showcase.\n\n",
        flags:"",
        name:"getSampleThumbnailDir"
    },
    "method:Layout.removeMembers":{
        seeAlso:[
        ],
        ref:"method:Layout.removeMembers",
        deprecated:null,
        type:"method",
        definingClass:"class:Layout",
        params:[
            {
                defaultValue:null,
                optional:false,
                type:"Array of Canvas | Canvas",
                description:"array of members to be removed, or single member",
                name:"members"
            }
        ],
        description:"\n  Removes the specified members from the layout. If any of the removed members have resize\n  bars, the bars will be destroyed.\n\n",
        flags:"",
        name:"removeMembers"
    },
    "attr:ResultSet.useClientFiltering":{
        seeAlso:[
        ],
        ref:"attr:ResultSet.useClientFiltering",
        defaultValue:"true",
        deprecated:null,
        type:"attr",
        definingClass:"class:ResultSet",
        valueType:"boolean",
        description:"Whether to filter data locally when all DataSource records have been loaded (that is,\n criteria is blank and cache is complete).\n <P>\n This may need to be disabled if client-side filtering differs from server-side filtering\n in a way that affects functionality or is surprising.\n <P>\n This setting is distinct from <code>fetchMode:\"local\"</code>, which explicitly loads all\n available DataSource records up front and always performs all filtering on the client.\n <P>\n See ${isc.DocUtils.linkForRef('method:ResultSet.applyFilter')} for default filtering behavior.\n <P>\n <b>NOTE:</b> even with useClientFiltering false, client-side filtering will be used\n during cache sync to determine if an updated or added row matches the current criteria.\n To avoid relying on client-side filtering in this case, either:<br>\n - avoid returning update data when the updated row doesn't match the current filter<br>\n - set dropCacheOnUpdate<br>",
        flags:"IRWA",
        name:"useClientFiltering"
    },
    "type:PropertyIdentifier":{
        seeAlso:[
        ],
        ref:"type:PropertyIdentifier",
        deprecated:null,
        type:"type",
        values:[
            {
                value:"\"name\"",
                description:"Identify properties by internal name"
            },
            {
                value:"\"title\"",
                description:"Identify properties by localized descriptive title"
            }
        ],
        description:"A means of identifying the properties in an exported dataset - either the property name\n or its title.",
        name:"PropertyIdentifier"
    },
    "attr:SelectItem.pickButtonWidth":{
        seeAlso:[
        ],
        ref:"attr:SelectItem.pickButtonWidth",
        defaultValue:"null",
        deprecated:"As of SmartClient version 5.5, pickButtonWidth has been deprecated in   favor of ${isc.DocUtils.linkForRef('attr:SelectItem.pickerIconWidth')}.",
        type:"attr",
        definingClass:"class:SelectItem",
        valueType:"number",
        description:"How large should the pick button be rendered?",
        flags:"IRWA",
        name:"pickButtonWidth"
    },
    "attr:ToolStripGroup.columnLayout":{
        seeAlso:[
        ],
        ref:"attr:ToolStripGroup.columnLayout",
        defaultValue:"null",
        deprecated:null,
        type:"attr",
        definingClass:"class:ToolStripGroup",
        valueType:"MultiAutoChild VLayout",
        description:"AutoChild VLayouts created automatically by groups.  Each manages a single column of\n child controls in the group.  Child controls that support <code>rowSpan</code> may \n specify it in order to occupy more than one row in a single column.  See \n ${isc.DocUtils.linkForRef('attr:ToolStripGroup.numRows','numRows')} for related information.",
        flags:"IR",
        name:"columnLayout"
    },
    "attr:SelectItem.showOptionsFromDataSource":{
        seeAlso:[
        ],
        defaultValue:"null",
        type:"attr",
        definingClass:"class:SelectItem",
        groups:[
            "databinding"
        ],
        deprecated:null,
        ref:"attr:SelectItem.showOptionsFromDataSource",
        valueType:"boolean",
        description:"If this item is part of a databound form, and has a specified <code>valueMap</code>,\n by default we show the valueMap options in the pickList for the item.\n Setting this property to true will ensure that the options displayed in our pickList\n are derived from the form's <code>dataSource</code>.",
        flags:"IRWA",
        name:"showOptionsFromDataSource"
    },
    "method:EditContext.makePaletteNodeTree":{
        seeAlso:[
        ],
        ref:"method:EditContext.makePaletteNodeTree",
        deprecated:null,
        type:"method",
        definingClass:"class:EditContext",
        params:[
            {
                defaultValue:null,
                optional:false,
                type:"EditNode",
                description:"root editNode to make Tree of PaletteNodes from",
                name:"editNode"
            }
        ],
        description:" Creates a ${isc.DocUtils.linkForRef('class:Tree')} of ${isc.DocUtils.linkForRef('object:PaletteNode','PaletteNodes')} from an ${isc.DocUtils.linkForRef('object:EditNode')} in this\n context's ${isc.DocUtils.linkForRef('method:EditContext.getEditNodeTree','editNodeTree')}, by using ${isc.DocUtils.linkForRef('method:EditContext.makePaletteNode')} on the\n passed <code>EditNode</code> and its descendents within the\n ${isc.DocUtils.linkForRef('method:EditContext.getEditNodeTree','editNodeTree')}.\n <p>\n The root node of the returned ${isc.DocUtils.linkForRef('class:Tree')} will be a PaletteNode derived from the passed\n <code>EditNode</code>.\n\n",
        flags:"",
        returns:{
            type:"Tree",
            description:"a Tree of paletteNodes or null"
        },
        name:"makePaletteNodeTree"
    },
    "attr:EditProxy.hoopSelector":{
        seeAlso:[
        ],
        ref:"attr:EditProxy.hoopSelector",
        defaultValue:"null",
        deprecated:null,
        type:"attr",
        definingClass:"class:EditProxy",
        valueType:"AutoChild Canvas",
        description:"Hoop selector canvas used for selecting multiple components.\n <P>\n Common customization properties can be provided by ${isc.DocUtils.linkForRef('attr:EditContext.hoopSelectorProperties')}.",
        flags:"IR",
        name:"hoopSelector"
    },
    "attr:MultiGroupPanel.levelDownButtonTitle":{
        seeAlso:[
        ],
        defaultValue:"\"Move Level Down\"",
        type:"attr",
        definingClass:"class:MultiGroupPanel",
        groups:[
            "i18nMessages"
        ],
        deprecated:null,
        ref:"attr:MultiGroupPanel.levelDownButtonTitle",
        valueType:"String",
        description:"The hover-prompt for the Level Down button.",
        flags:"IR",
        name:"levelDownButtonTitle"
    },
    "attr:ResultSet.initialData":{
        seeAlso:[
            {
                ref:"attr:ResultSet.fetchMode",
                description:null
            },
            {
                ref:"attr:ResultSet.useClientFiltering",
                description:null
            }
        ],
        defaultValue:"null",
        type:"attr",
        definingClass:"class:ResultSet",
        groups:[
            "fetching",
            "cacheSync"
        ],
        deprecated:null,
        ref:"attr:ResultSet.initialData",
        valueType:"Array of Record",
        description:"Initial set of data for the ResultSet.\n <P>\n This data will be treated exactly as though it were the data returned from the\n ResultSet's first server fetch.\n <P>\n By default, <code>initialData</code> will be considered a complete response\n (all rows that match the ${isc.DocUtils.linkForRef('type:Criteria')} which the ResultSet was initialized with).\n <P>\n Set ${isc.DocUtils.linkForRef('attr:ResultSet.initialLength')} to treat <code>initialData</code> as a partial response,\n equivalent to receiving a ${isc.DocUtils.linkForRef('class:DSResponse')} with <code>startRow:0</code>,\n <code>endRow:initialData.length</code> and <code>totalRows:initialLength</code>.\n Normal data paging will then occur if data is requested for row indices not filled via \n <code>initialData</code>.\n <P>\n <code>initialData</code> may be provided as a \"sparse\" array, that is, slots may be left\n null indicating rows that have not been loaded.  In this way you can create a ResultSet\n that is missing rows at the beginning of the dataset, but has loaded rows toward the end,\n so that you can create a component that is scrolled to a particular position of a dataset\n without loading rows at the beginning.\n <P>\n To keep the logic simple and support partial <code>initialData</code>, the data is\n assumed to be already sorted and filtered according to the ${isc.DocUtils.linkForRef('attr:ResultSet.sortSpecifiers')} and\n ${isc.DocUtils.linkForRef('attr:ResultSet.criteria')} supplied to the ResultSet, since otherwise, for partial\n <code>initialData</code>, sorting or filtering would immediately cause the data to be\n discarded.\n <P>\n If <code>initialData</code> is complete and needs to be sorted or filtered, then don't\n pass the ${isc.DocUtils.linkForRef('attr:ResultSet.sortSpecifiers')} or ${isc.DocUtils.linkForRef('attr:ResultSet.criteria')}, respectively, when creating\n the ResultSet.  Instead, call ${isc.DocUtils.linkForRef('method:ResultSet.setCriteria')} or ${isc.DocUtils.linkForRef('method:ResultSet.setSort')}, respectively, on\n the instance afterwards.",
        flags:"IA",
        name:"initialData"
    },
    "attr:Canvas.proportionalResizing":{
        seeAlso:[
            {
                ref:"attr:Canvas.proportionalResizeModifiers",
                description:null
            }
        ],
        defaultValue:"\"none\"",
        type:"attr",
        definingClass:"class:Canvas",
        groups:[
            "dragdrop"
        ],
        deprecated:null,
        ref:"attr:Canvas.proportionalResizing",
        valueType:"ProportionalResizeMode",
        description:"If ${isc.DocUtils.linkForRef('attr:Canvas.canDragResize')} is true, this property specifies the conditions for when\n proportional resizing is used.  The default is \"none\"\n \n , which means that proportional resizing is disabled.",
        flags:"IR",
        name:"proportionalResizing"
    },
    "type:ValidatorType":{
        seeAlso:[
        ],
        ref:"type:ValidatorType",
        deprecated:null,
        type:"type",
        values:[
            {
                value:"isBoolean",
                description:"Validation will fail if this field is non-empty and has a non-boolean value."
            },
            {
                value:"isString",
                description:"Validation will fail if the value is not a string value."
            },
            {
                value:"isInteger",
                description:"Tests whether the value for this field is a whole number.  If \n <code>validator.convertToInteger</code> is true, float values will be converted \n into integers and validation will succeed."
            },
            {
                value:"isFloat",
                description:"Tests whether the value for this field is a valid floating point number."
            },
            {
                value:"isFunction",
                description:"Tests whether the value for this field is a valid expression or function; if it is\n valid, creates a ${isc.DocUtils.linkForRef('group:stringMethods','stringMethod')} object with the value\n and set the resultingValue to the StringMethod."
            },
            {
                value:"requiredIf",
                description:"RequiredIf type validators should be specified with an <code>expression</code>\n property set to a ${isc.DocUtils.linkForRef('group:stringMethods','stringMethod')}, which takes four\n parameters:<ul>\n <li>item - the DynamicForm item on which the error occurred (may be null)\n <li>validator - a pointer to the validator object\n <li>value - the value of the field in question\n <li>record - the \"record\" object - the set of values being edited by the widget\n </ul>\n When validation is performed, the expression will be evaluated (or executed). If it\n returns <code>true</code>, the field will be treated as a required field, so validation\n will fail if the field has no value, or, in the case of a ${isc.DocUtils.linkForRef('class:FileItem')} or ${isc.DocUtils.linkForRef('class:UploadItem')}\n and if client-side validation is supported by the browser, if no file is selected for upload\n or the selected file is empty.\n <p>To allow server-side enforcement, a <code>required</code> validator can be used instead.\n With the exception of \"binary\" fields, conditional criteria can be specified with the\n ${isc.DocUtils.linkForRef('attr:Validator.applyWhen','applyWhen')} property.\n <p>See ${isc.DocUtils.linkForExampleId('conditionallyRequired')}.\n <p>\n \n <p><strong>NOTE:</strong> A requiredIf validator cannot be used to guarantee that a non-empty\n file is uploaded. The user's browser might not support client-side file validation.\n Using a requiredIf validator on a \"binary\" field may be appropriate in scenarios where the\n application does not technically require a non-empty file to be uploaded by the user.\n For example, in a bug tracking application, a file upload may be required if the\n \"Have a test case?\" checkbox is checked, but the value of the \"Have a test case?\" checkbox is\n not actually saved by the application; instead, whether the user is providing a test case is\n inferred by whether a non-empty test case file was uploaded."
            },
            {
                value:"matchesField",
                description:"Tests whether the value for this field matches the value of some other field.\n The field to compare against is specified via the <code>otherField</code> property\n on the validator object (should be set to a field name).\n <p>See ${isc.DocUtils.linkForExampleId('matchValue')}."
            },
            {
                value:"equals",
                description:"Tests whether the value for this field matches some value specified via\n <code>value</code>."
            },
            {
                value:"notEqual",
                description:"Tests whether the value for this field does not match some value specified via\n <code>value</code>."
            },
            {
                value:"isOneOf",
                description:"Tests whether the value for this field matches any value from an arbitrary\n list of acceptable values.  The set of acceptable values is specified via\n the <code>list</code> property on the validator, which should be set to an array of\n values. If validator.list is not supplied, the valueMap for the field will be used.\n If there is no valueMap, not providing validator.list is an error."
            },
            {
                value:"inSet",
                description:"Tests whether the value for this field matches any value from an arbitrary\n list of acceptable values.  The set of acceptable values is specified via\n the <code>list</code> property on the validator, which should be set to an array of\n values. If validator.list is not supplied, the valueMap for the field will be used.\n If there is no valueMap, not providing validator.list is an error."
            },
            {
                value:"notInSet",
                description:"Tests whether the value for this field does not match any value from an arbitrary\n list of unacceptable values.  The set of unacceptable values is specified via\n the <code>list</code> property on the validator, which should be set to an array of\n values. Not providing validator.list is an error."
            },
            {
                value:"integerRange",
                description:"Tests whether the value for this field is a whole number within the range \n specified.  The <code>max</code> and <code>min</code> properties on the validator\n are used to determine the acceptable range, inclusive. To specify the range as\n exclusive of the min/mix values, set <code>exclusive</code> to <code>true</code>.\n <p>See ${isc.DocUtils.linkForExampleId('validationBuiltins')}."
            },
            {
                value:"lengthRange",
                description:"This validator type applies to string values only.  If the value is a string value\n validation will fail if the string's length falls outside the range specified by \n <code>validator.max</code> and <code>validator.min</code>.\n <p>\n Note that non-string values will always pass validation by this validator type.\n <p>\n Note that the <code>errorMessage</code> for this validator will be evaluated as\n a dynamicString - text within <code>&#36;{...}</code> will be evaluated as JS code\n when the message is displayed, with <code>max</code> and <code>min</code> available as\n variables mapped to <code>validator.max</code> and <code>validator.min</code>."
            },
            {
                value:"contains",
                description:"Determine whether a string value contains some substring specified via \n <code>validator.substring</code>."
            },
            {
                value:"doesntContain",
                description:"Determine whether a string value does <b>not</b> contain some substring specified via \n <code>validator.substring</code>."
            },
            {
                value:"substringCount",
                description:"Determine whether a string value contains some substring multiple times.\n The substring to check for is specified via <code>validator.substring</code>.\n The <code>validator.operator</code> property allows you to specify how to test\n the number of substring occurrences. Valid values for this property are\n <code>==</code>, <code>!=</code>, <code>&lt;</code>, <code>&lt;=</code>,\n <code>&gt;</code>, <code>&gt;=</code>.\n <p>\n The number of matches to check for is specified via <code>validator.count</code>."
            },
            {
                value:"regexp",
                description:"<code>regexp</code> type validators will determine whether the value specified \n matches a given regular expression.  The expression should be specified on the\n <code>validator</code> object as the <code>expression</code> property.\n <p>See ${isc.DocUtils.linkForExampleId('formsRegularExpression')}."
            },
            {
                value:"mask",
                description:"Validate against a regular expression mask, specified as <code>validator.mask</code>.\n If validation is successful a transformation can also be specified via the\n <code>validator.transformTo</code> property. This should be set to a string in the\n standard format for string replacement via the native JavaScript <code>replace()</code>\n method.\n <p>See ${isc.DocUtils.linkForExampleId('formsValueTransform')}."
            },
            {
                value:"dateRange",
                description:"Tests whether the value for a date field is within the range specified.\n Range is inclusive, and is specified via <code>validator.min</code> and\n <code>validator.max</code>, which should be specified in\n <a target=_blank href=\"http://www.w3.org/TR/xmlschema-2/#dateTime\">XML Schema\n date format</a> or as a live JavaScript Date object (for client-only validators only).\n To specify the range as exclusive of the min/mix values, set <code>exclusive</code>\n to <code>true</code>.\n <p>\n Note that the <code>errorMessage</code> for this validator will be evaluated as\n a dynamicString - text within <code>&#36;{...}</code> will be evaluated as JS code\n when the message is displayed, with <code>max</code> and <code>min</code> available as\n variables mapped to <code>validator.max</code> and <code>validator.min</code>."
            },
            {
                value:"floatLimit",
                description:"Validate a field as a valid floating point value within a value range.\n Range is specified via <code>validator.min</code> and <code>validator.max</code>.\n Also checks precision, specified as number of decimal places in \n <code>validator.precision</code>. If <code>validator.roundToPrecision</code> is set \n a value that doesn't match the specified number of decimal places will be rounded\n to the nearest value that does.        \n <p>\n For backwards compatibility only. Use \"floatRange\" and/or \"floatPrecision\" instead."
            },
            {
                value:"floatRange",
                description:"Tests whether the value for this field is a floating point number within the range \n specified.  The <code>max</code> and <code>min</code> properties on the validator\n are used to determine the acceptable range, inclusive. To specify the range as\n exclusive of the min/mix values, set <code>exclusive</code> to <code>true</code>.\n <p>\n Note that the <code>errorMessage</code> for this validator will be evaluated as\n a dynamicString - text within <code>&#36;{...}</code> will be evaluated as JS code\n when the message is displayed, with <code>max</code> and <code>min</code> available as\n variables mapped to <code>validator.max</code> and <code>validator.min</code>."
            },
            {
                value:"floatPrecision",
                description:"Tests whether the value for this field is a floating point number with the \n appropriate number of decimal places - specified in <code>validator.precision</code>\n If the value is of higher precision and <code>validator.roundToPrecision</code> \n is specified, the value will be rounded to the specified number of decimal places\n and validation will pass, otherwise validation will fail."
            },
            {
                value:"required",
                description:"A non-empty value is required for this field to pass validation.\n <p>In the case of a \"binary\" field, a non-empty file must be uploaded."
            },
            {
                value:"readOnly",
                description:"Disallows changes to this field, based on the ${isc.DocUtils.linkForRef('attr:Validator.applyWhen')} condition.  \n <p>\n In addition to server-side enforcement, this validator will automatically cause editors \n for the field to become read-only, by rendering in a disabled appearance, readOnly \n appearance, or even by becoming hidden.\n <p>\n The appearance of the read-only field can be controlled by validator.fieldAppearance.  \n See ${isc.DocUtils.linkForRef('type:FieldAppearance')} for choices. If <code>fieldAppearance</code> is not \n specified, the default is \"readOnly\"."
            },
            {
                value:"visibility",
                description:"Change the visibility of this field."
            },
            {
                value:"enable",
                description:"Change the enable/disable state of this field."
            },
            {
                value:"isUnique",
                description:"Returns true if the value for this field is unique.  The uniqueness check is performed across\n the whole DataSource unless you specify property <code>validator.criteriaFields</code> as a \n comma-separated string of field names; in that case, the uniqueness check is done in the \n context of those extra criteria, allowing you to check, for example, whether an employee \n number is unique for the department and location found on the record being validated.\n By default the uniqueness check is not case sensitive but this can be controlled through\n the ${isc.DocUtils.linkForRef('attr:Validator.caseSensitive','caseSensitive')} attribute.  You can specify the \n ${isc.DocUtils.linkForRef('attr:DataSource.operationBindings','operation')} to use for the uniqueness check with the \n ${isc.DocUtils.linkForRef('attr:Validator.operationId','operationId')} attribute.\n <p>\n Validators of this type have ${isc.DocUtils.linkForRef('attr:ValidatorDefinition.requiresServer','requiresServer')} \n set to <code>true</code> and do not run on the client.\n <p>\n Note when isUnique validator is executed as part of validation process during update \n operation, it will perform uniqueness check only for single row updates. If update targets \n ${isc.DocUtils.linkForRef('attr:OperationBinding.allowMultiUpdate','multiple records')}, then isUnique validator will \n be skipped. If uniqueness check is needed when updating multiple records, consider using \n ${isc.DocUtils.linkForRef('group:dmiOverview','custom DMI')} approach to add this check manually.\n <p>See ${isc.DocUtils.linkForExampleId('uniqueCheckValidation')}."
            },
            {
                value:"hasRelatedRecord",
                description:"Returns true if the record implied by a relation exists.  The relation can be \n derived automatically from the ${isc.DocUtils.linkForRef('attr:DataSourceField.foreignKey')} attribute of \n the field being validated, or you can specify it manually via \n <code>validator.relatedDataSource</code> and <code>validator.relatedField</code>.\n <p>\n You can specify at DataSource level that this validator should be automatically \n applied to all fields that specify a ${isc.DocUtils.linkForRef('attr:DataSourceField.foreignKey','foreignKey')} -\n see ${isc.DocUtils.linkForRef('attr:DataSource.validateRelatedRecords')}.\n <p>\n By default the uniqueness check is not case sensitive but this can be controlled through\n the ${isc.DocUtils.linkForRef('attr:Validator.caseSensitive','caseSensitive')} attribute.\n <p>\n Validators of this type have ${isc.DocUtils.linkForRef('attr:ValidatorDefinition.requiresServer','requiresServer')} \n set to <code>true</code> and do not run on the client.\n <p>\n Note that this validation is generally unnecessary for data coming from a UI.  The \n typical UI uses a ${isc.DocUtils.linkForRef('class:SelectItem')} or ${isc.DocUtils.linkForRef('class:ComboBoxItem')} with an \n ${isc.DocUtils.linkForRef('attr:FormItem.optionDataSource','optionDataSource')} for user entry, such that the user \n can't accidentally enter a related record if that doesn't exist, and a typical SQL \n schema will include constraints that prevent a bad insert if the user attempts to \n circumvent the UI.  The primary purpose of declaring this validation explicitly is \n to provide clear, friendly error messages for use cases such as ${isc.DocUtils.linkForRef('class:BatchUploader')}, \n where values aren't individually chosen by the user. See also the example\n ${isc.DocUtils.linkForExampleId('hasRelatedValidation', 'Related Records')}."
            },
            {
                value:"maxFileSize",
                description:"This validator type is not for direct usage, instead ${isc.DocUtils.linkForRef('attr:DataSourceField.maxFileSize')} can \n be set and <code>maxFileSize</code> validator will be added automatically. Use \n ${isc.DocUtils.linkForRef('classAttr:DataSource.maxFileSizeExceededMessage')} to customize validation error message.\n <p>\n In supported browsers (Internet Explorer 10+, Chrome, Firefox, Safari 6+, Opera 11.1+), returns\n <code>true</code> if the file(s) selected by the user are not larger than the field's\n ${isc.DocUtils.linkForRef('attr:DataSourceField.maxFileSize')}. If not supported by the browser, the validator will always\n return <code>true</code>.\n <p>\n Note that server-side enforcement of the <code>maxFileSize</code> is always required because\n the user's browser might not support client-side file size checks. Also, any client-side\n check can be bypassed by a malicious user."
            },
            {
                value:"custom",
                description:"Custom client-side validator.  \n ${isc.DocUtils.linkForRef('attr:Validator.condition')} will be called to verify data.\n "
            },
            {
                value:"serverCustom",
                description:"Custom server-side validator that either evaluates the Velocity expression provided in \n ${isc.DocUtils.linkForRef('attr:Validator.serverCondition','serverCondition')} (see ${isc.DocUtils.linkForExampleId('velocityValidation')})\n or makes DMI call to ${isc.DocUtils.linkForRef('attr:Validator.serverObject','serverObject')} to evaluate condition\n (see ${isc.DocUtils.linkForExampleId('dmiValidation')}).\n <p>\n Validators of this type have ${isc.DocUtils.linkForRef('attr:ValidatorDefinition.requiresServer','requiresServer')} \n set to <code>true</code> and do not run on the client."
            }
        ],
        description:"Used to name a validator or reference a standard, built-in ${isc.DocUtils.linkForRef('class:Validator')} - see list below.\n <p>\n To make use of a standard validator type for a field in a DataSource, or \n DynamicForm instance, specify the <code>validators</code> property to an array \n containing a validator definition where the <code>type</code> property is set to \n the appropriate type.  \n <p>\n A custom error message can be specified for any validator type by setting the\n <code>errorMessage</code> property on the validator definition object, and some\n validator types make use of additional properties on the validator definition \n object such as <code>max</code> or <code>min</code>.\n <p>\n For example, to use the <code>integerRange</code> validator type:<br><br><code>\n &nbsp;&nbsp;field:{<br>\n &nbsp;&nbsp;&nbsp;&nbsp;validators:[<br>\n &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;{type:\"integerRange\", min:1, max:100}<br>\n &nbsp;&nbsp;&nbsp;&nbsp;]<br>\n &nbsp;&nbsp;}\n </code>\n <p>\n Custom validators can be reused on the client by adding them to the global validator list,\n via the ${isc.DocUtils.linkForRef('classMethod:Validator.addValidatorDefinition')} method.",
        name:"ValidatorType"
    },
    "attr:DynamicForm.showErrorStyle":{
        seeAlso:[
        ],
        defaultValue:"true",
        type:"attr",
        definingClass:"class:DynamicForm",
        groups:[
            "validation"
        ],
        deprecated:null,
        ref:"attr:DynamicForm.showErrorStyle",
        valueType:"Boolean",
        description:"${isc.DocUtils.linkForRef('attr:DynamicForm.showErrorIcons','showErrorIcons')}, \n ${isc.DocUtils.linkForRef('attr:DynamicForm.showErrorText','showErrorText')}, and\n ${isc.DocUtils.linkForRef('attr:DynamicForm.showErrorStyle','showErrorStyle')} control how validation errors are\n displayed when they are displayed inline in the form (next to the form item where there\n is a validation error).  To instead display all errors at the top of the form, set\n ${isc.DocUtils.linkForRef('attr:DynamicForm.showInlineErrors','showInlineErrors')}:false.\n <P>\n <code>showErrorIcons</code>, <code>showErrorText</code> and <code>showErrorStyle</code>\n are all boolean properties, and can be set on a DynamicForm to control the behavior\n form-wide, or set on individual FormItems.  \n <P>\n The HTML displayed next to a form item with errors is generated by \n ${isc.DocUtils.linkForRef('method:FormItem.getErrorHTML')}.\n The default implementation of that method respects <code>showErrorIcons</code> and\n <code>showErrorText</code> as follows:\n <P>\n <code>showErrorIcons</code>, or <code>showErrorIcon</code> at the FormItem level controls\n whether an error icon should appear next to fields which have validation errors.  The icon's\n appearance is governed by ${isc.DocUtils.linkForRef('attr:FormItem.errorIconSrc')}, ${isc.DocUtils.linkForRef('attr:FormItem.errorIconWidth')} and\n ${isc.DocUtils.linkForRef('attr:FormItem.errorIconHeight')}\n <P>\n <code>showErrorText</code> determines whether the text of the validation error should be\n displayed next to fields which have validation errors. The attribute\n ${isc.DocUtils.linkForRef('attr:DynamicForm.showTitlesWithErrorMessages')} may be set to prefix error messages with the \n form item's title + <code>\":\"</code> (may be desired if the item has \n ${isc.DocUtils.linkForRef('attr:FormItem.showTitle')} set to false).\n <P>\n ${isc.DocUtils.linkForRef('attr:DynamicForm.errorOrientation')} controls where the error HTML should appear relative \n to form items. Therefore the combination of ${isc.DocUtils.linkForRef('attr:DynamicForm.showErrorText')}<code>:false</code> and\n ${isc.DocUtils.linkForRef('attr:DynamicForm.errorOrientation')}<code>:\"left\"</code> creates a compact validation error display\n consisting of just an icon, to the left of the item with the error message\n available via a hover (similar appearance to ListGrid validation error display).  \n <P>\n In addition to this, <code>showErrorStyle</code> determines whether fields  with validation\n errors should have special styling applied to them. Error styling is achieved by\n applying suffixes to existing styling applied to various parts of the form item.\n See ${isc.DocUtils.linkForRef('type:FormItemBaseStyle')} for more on this.",
        flags:"IRW",
        name:"showErrorStyle"
    },
    "attr:SpacerItem.showTitle":{
        seeAlso:[
        ],
        defaultValue:"false",
        type:"attr",
        definingClass:"class:SpacerItem",
        groups:[
            "appearance"
        ],
        deprecated:null,
        ref:"attr:SpacerItem.showTitle",
        valueType:"Boolean",
        description:"we never show a separate title cell for spacers",
        flags:"IRW",
        name:"showTitle"
    },
    "type:TEXTAREA_WRAP":{
        seeAlso:[
        ],
        ref:"type:TEXTAREA_WRAP",
        deprecated:null,
        type:"type",
        values:[
            {
                value:"TextAreaItem.OFF",
                description:"don't allow wrapping at all"
            },
            {
                value:"TextAreaItem.SOFT",
                description:"when the entered text reaches the edge of the text area,                                  wrap visibly but don't include line breaks in the textarea\n                                  value"
            },
            {
                value:"TextAreaItem.HARD",
                description:"when the entered text reaches the edge of the text area,                                   insert a line break"
            }
        ],
        description:null,
        name:"TEXTAREA_WRAP"
    },
    "attr:ComboBoxItem.pickerClearButton":{
        seeAlso:[
        ],
        defaultValue:"null",
        type:"attr",
        definingClass:"class:ComboBoxItem",
        groups:[
            "panelPlacement"
        ],
        deprecated:null,
        ref:"attr:ComboBoxItem.pickerClearButton",
        valueType:"AutoChild NavigationButton",
        description:"${isc.DocUtils.linkForRef('class:NavigationButton')} to clear the picker value, created when ${isc.DocUtils.linkForRef('attr:ComboBoxItem.pickListPlacement')}\n indicates that the search interface takes over the entire panel or screen.\n <P>\n This button will only be shown if ${isc.DocUtils.linkForRef('attr:ComboBoxItem.addUnknownValues')} or ${isc.DocUtils.linkForRef('attr:ComboBoxItem.allowEmptyValue')}\n is true.\n <p>\n The following ${isc.DocUtils.linkForRef('group:autoChildUsage','passthroughs')} apply:\n <ul>\n <li>${isc.DocUtils.linkForRef('attr:ComboBoxItem.pickerClearButtonTitle','pickerClearButtonTitle')} for ${isc.DocUtils.linkForRef('attr:Button.title')}</li>\n </ul>",
        flags:"IR",
        name:"pickerClearButton"
    },
    "attr:MockDataSource.mockData":{
        seeAlso:[
        ],
        ref:"attr:MockDataSource.mockData",
        defaultValue:"\"md\"",
        deprecated:null,
        type:"attr",
        definingClass:"class:MockDataSource",
        valueType:"String | Array of Record",
        description:"Data intended for a ${isc.DocUtils.linkForRef('class:ListGrid')} or ${isc.DocUtils.linkForRef('class:TreeGrid')}, expressed in a simple text\n format popularized by mockup tools such as <a href='http://balsamiq.com' target='_blank'>balsamiq</a> and now\n commonly supported in a variety of mockup tools.\n <p>\n Balsamiq publishes documentation of the grid format \n <a href='https://docs.balsamiq.com/cloud/editing-controls/#the-data-grid-table-control' target='_blank'>here</a>,\n with a simple example of using tree-specific formatting\n <a href='https://docs.balsamiq.com/cloud/editing-controls/#the-tree-pane' target='_blank'>here</a>.\n <p>\n MockData can also be provided as XML, CSV or JSON text by setting ${isc.DocUtils.linkForRef('type:MockDataFormat')} to\n the correct format.\n <p>\n An alternative format of data consisting of an array of ${isc.DocUtils.linkForRef('object:Record','Records')} can\n also be provided. In this case the records are converted to \"grid\" ${isc.DocUtils.linkForRef('type:MockDataType','format')}.",
        flags:"IR",
        name:"mockData"
    },
    "method:DetailViewer.exportData":{
        groups:[
            "dataBoundComponentMethods"
        ],
        seeAlso:[
            {
                ref:"group:exportFormatting",
                description:null
            }
        ],
        ref:"method:DetailViewer.exportData",
        deprecated:null,
        type:"method",
        definingClass:"class:DetailViewer",
        params:[
            {
                defaultValue:null,
                optional:true,
                type:"DSRequest",
                description:"additional properties to set on the DSRequest                                            that will be issued",
                name:"requestProperties"
            },
            {
                defaultValue:null,
                optional:true,
                type:"DSCallback",
                description:"callback to invoke on completion.  Note that this parameter                                  only applies where ${isc.DocUtils.linkForRef('attr:DSRequest.exportToClient')} is \n                                  explicitly set to false, because  file downloads do not \n                                  provide ordinary SmartClient callbacks",
                name:"callback"
            }
        ],
        description:" Sends the current filter criteria and sort direction to the server, then exports data in the\n requested ${isc.DocUtils.linkForRef('attr:DSRequest.exportAs','exportFormat')}.\n <P>\n A variety of DSRequest settings, such as \n ${isc.DocUtils.linkForRef('attr:DSRequest.exportAs','exportAs')} and ${isc.DocUtils.linkForRef('attr:DSRequest.exportFilename')}, affect the \n exporting process: see ${isc.DocUtils.linkForRef('attr:DSRequest.exportResults','exportResults')} for further detail.\n <P>\n Note that data exported via this method skips client-side fields defined only in\n the component, excludes any client-side formatting and\n relies on both the SmartClient server and server-side DataSources.  To export client-data \n including client-only fields and with client-side formatting applied, \n see ${isc.DocUtils.linkForRef('method:ListGrid.exportClientData','exportClientData')}, which still requires the\n SmartClient server but does not rely on server-side DataSource definitions (.ds.xml files).\n <P>\n For more information on exporting data, see ${isc.DocUtils.linkForRef('method:DataSource.exportData')}.\n\n",
        flags:"",
        name:"exportData"
    },
    "attr:Canvas.autoShowParent":{
        seeAlso:[
        ],
        defaultValue:"false",
        type:"attr",
        definingClass:"class:Canvas",
        groups:[
            "appearance"
        ],
        deprecated:null,
        ref:"attr:Canvas.autoShowParent",
        valueType:"Boolean",
        description:"If set to true, the widget's parent (if any) will automatically be shown whenever the\n      widget is shown.",
        flags:"IRWA",
        name:"autoShowParent"
    },
    "attr:HiliteRule.hiliteForm":{
        seeAlso:[
        ],
        ref:"attr:HiliteRule.hiliteForm",
        defaultValue:"null",
        deprecated:null,
        type:"attr",
        definingClass:"class:HiliteRule",
        valueType:"AutoChild DynamicForm",
        description:"AutoChild ${isc.DocUtils.linkForRef('class:DynamicForm')} displaying the ${isc.DocUtils.linkForRef('class:FormItem','formItems')} used to \n specify the hiliting properties of this rule.\n <P>\n This component is an ${isc.DocUtils.linkForRef('type:AutoChild')} and as such may be customized via \n <code>hiliteRule.hiliteFormProperties</code>.",
        flags:"IR",
        name:"hiliteForm"
    },
    "method:ValuesManager.isNewRecord":{
        seeAlso:[
        ],
        ref:"method:ValuesManager.isNewRecord",
        deprecated:null,
        type:"method",
        definingClass:"class:ValuesManager",
        description:" Returns true if ${isc.DocUtils.linkForRef('attr:ValuesManager.saveOperationType')} is currently \"add\".  See\n ${isc.DocUtils.linkForRef('attr:ValuesManager.saveOperationType')}.\n\n",
        flags:"",
        returns:{
            type:"Boolean",
            description:"whether this form will use an \"add\" operation when saving"
        },
        name:"isNewRecord"
    },
    "attr:TreeGrid.customIconDropProperty":{
        seeAlso:[
            {
                ref:"attr:TreeGrid.customIconProperty",
                description:null
            },
            {
                ref:"attr:TreeGrid.showCustomIconDrop",
                description:null
            }
        ],
        defaultValue:"\"showDropIcon\"",
        type:"attr",
        definingClass:"class:TreeGrid",
        groups:[
            "treeIcons"
        ],
        deprecated:null,
        ref:"attr:TreeGrid.customIconDropProperty",
        valueType:"String",
        description:"This property allows the developer to rename the \n ${isc.DocUtils.linkForRef('attr:TreeNode.showDropIcon','default node.showDropIcon')} property.",
        flags:"IRWA",
        name:"customIconDropProperty"
    },
    "attr:MultiSortDialog.levelUpButton":{
        seeAlso:[
        ],
        ref:"attr:MultiSortDialog.levelUpButton",
        defaultValue:"null",
        deprecated:null,
        type:"attr",
        definingClass:"class:MultiSortDialog",
        valueType:"AutoChild ImgButton",
        description:"Automatically generated ${isc.DocUtils.linkForRef('class:ImgButton')} providing a mechanism for moving existing\n sort-levels up in the sort configuration.\n <P>\n This component is an ${isc.DocUtils.linkForRef('type:AutoChild')} and as such may be customized via \n <code>multiSortPanel.levelUpButtonProperties</code> and \n <code>multiSortPanel.levelUpButtonDefaults</code>.",
        flags:"RA",
        name:"levelUpButton"
    },
    "method:DataSource.transformResponse":{
        seeAlso:[
        ],
        type:"method",
        definingClass:"class:DataSource",
        returns:{
            type:"DSResponse",
            description:"response derived"
        },
        deprecated:null,
        ref:"method:DataSource.transformResponse",
        params:[
            {
                defaultValue:null,
                optional:false,
                type:"DSResponse",
                description:"default DSResponse derived from the response data",
                name:"dsResponse"
            },
            {
                defaultValue:null,
                optional:false,
                type:"DSRequest",
                description:"DSRequest object that initiated this request",
                name:"dsRequest"
            },
            {
                defaultValue:null,
                optional:false,
                type:"XMLDocument | JSON",
                description:"XML document or JSON objects returned by the web                                   service",
                name:"data"
            }
        ],
        description:" Modify the DSResponse object derived from the response returned from the \n ${isc.DocUtils.linkForRef('attr:DataSource.dataURL','dataURL')}.\n <P>\n This is an override point that makes it possible to use DataSource features such as\n paging with web services that support such features, by allowing you to fill in metadata\n fields in the DSResponse object (such as ${isc.DocUtils.linkForRef('attr:DSResponse.startRow')}) based on\n service-specific metadata fields contained in the service's response.\n <P>\n The DSResponse passed to this method already has ${isc.DocUtils.linkForRef('attr:DSResponse.data')}, which is\n derived differently depending on the ${isc.DocUtils.linkForRef('attr:DataSource.dataFormat','dataFormat')} setting:\n <ul>\n <li> <code>dataFormat:\"xml\"</code> : either the\n ${isc.DocUtils.linkForRef('attr:OperationBinding.recordXPath','recordXPath')} or \n ${isc.DocUtils.linkForRef('attr:OperationBinding.recordName','recordName')} is used to select the XML elements\n that represent DataSource records.  The selected XML elements are passed to\n ${isc.DocUtils.linkForRef('method:DataSource.recordsFromXML')}, which transforms the XML elements to typed\n JavaScript data using the DataSource as a schema.\n <li> <code>dataFormat:\"json\"</code> : the\n ${isc.DocUtils.linkForRef('attr:OperationBinding.recordXPath','recordXPath')}, if specified, is used to select\n records from the returned JSON data via ${isc.DocUtils.linkForRef('classMethod:XMLTools.selectObjects')}.  \n ${isc.DocUtils.linkForRef('attr:DataSourceField.valueXPath')} is used to derive correctly typed field values.\n <li> <code>dataFormat:\"custom\"</code> : <code>dsResponse.data</code> is the raw response\n in String form.  It must be parsed into an Array of Objects for subsequent processing to\n work.\n </ul> \n <P>\n In addition to <code>dsResponse.data</code>, ${isc.DocUtils.linkForRef('attr:DSResponse.status')} is defaulted\n to 0 (indicating no error), and ${isc.DocUtils.linkForRef('attr:DSResponse.startRow')} is assumed to be zero,\n with ${isc.DocUtils.linkForRef('attr:DSResponse.endRow','endRow')} and ${isc.DocUtils.linkForRef('attr:DSResponse.totalRows','totalRows')}\n both set to <code>dsResponse.data.length - 1</code>, that is, the returned data is\n assumed to be all records that matched the filter criteria.\n <P>\n Examples of using this API include:\n <ul>\n <li> setting ${isc.DocUtils.linkForRef('attr:DSResponse.startRow','startRow')}, \n      ${isc.DocUtils.linkForRef('attr:DSResponse.endRow','endRow')} and ${isc.DocUtils.linkForRef('attr:DSResponse.totalRows','totalRows')}\n      to allow paging for a service that supports it.  For example, if an XML service\n      returns a \"resultRow\" tag that contained the row number of the first row of the\n      returned results:\n    <pre>\n      dsResponse.startRow = isc.XMLTools.selectNumber(xmlData, \"//resultRow\");\n    </pre>\n    \n <li> setting ${isc.DocUtils.linkForRef('attr:DSResponse.status')} to recognized ISC error values based on\n      service-specific errors, in order to trigger standard ISC error handling.  For\n      example, setting <code>dsResponse.status</code> to\n      ${isc.DocUtils.linkForRef('classAttr:RPCResponse.STATUS_VALIDATION_ERROR')} and filling in\n      ${isc.DocUtils.linkForRef('attr:DSResponse.errors')} in order to cause validation errors to be shown in\n      forms and grids.\n <li> for services that either do not return cache update data, or return partial data,\n      using ${isc.DocUtils.linkForRef('attr:DSRequest.oldValues')} to create cache update data (whether this is\n      appropriate is application-specific), or setting\n      ${isc.DocUtils.linkForRef('attr:DSResponse.invalidateCache')}.\n </ul>\n <P>\n <span STYLE=\"color:red\">NOTE:</span> this method is NOT an appropriate time to call\n methods on visual components such as grids, initiate new DSRequests or RPCRequests, or\n in general do anything other than fill in fields on the DSResponse based on data that is\n already available.  Any actions that need to be taken as a result of the web\n service response should be implemented exactly as for a DataSource where\n <code>transformResponse()</code> has not been overridden, that is, use the callback\n passed to high-level methods such as \n ${isc.DocUtils.linkForRef('group:dataBoundComponentMethods','<code>grid.fetchData()</code>')}, and do error\n handling via either ${isc.DocUtils.linkForRef('method:DataSource.handleError')} or by setting\n ${isc.DocUtils.linkForRef('attr:RPCRequest.willHandleError','willHandleError')}.\n\n",
        flags:"A",
        examples:[
            "${isc.DocUtils.linkForExampleId('xmlServerValidationErrors')}"
        ],
        name:"transformResponse"
    },
    "staticMethod:Date.setFirstDayOfWeek":{
        seeAlso:[
        ],
        ref:"staticMethod:Date.setFirstDayOfWeek",
        deprecated:"Use ${isc.DocUtils.linkForRef('classMethod:DateUtil.setFirstDayOfWeek')}.",
        type:"staticMethod",
        definingClass:"object:Date",
        params:[
            {
                defaultValue:null,
                optional:false,
                type:"int",
                description:"the number of the day to use as the first day of the week",
                name:"firstDayOfWeek"
            }
        ],
        description:" Sets the global attribute that dictates which day should be treated as the first day of the\n week in calendars and date calculations.  The parameter is expected to be an integer value \n between 0 (Sunday) and 6 (Saturday).\n <P>\n The default value is picked up from the current locale.\n\n",
        flags:"",
        name:"setFirstDayOfWeek"
    },
    "attr:ComboBoxItem.pendingTextBoxStyle":{
        seeAlso:[
        ],
        ref:"attr:ComboBoxItem.pendingTextBoxStyle",
        defaultValue:"null",
        deprecated:null,
        type:"attr",
        definingClass:"class:ComboBoxItem",
        valueType:"CSSStyleName",
        description:"Optional \"pending\" style for this item's text box.\n <P>\n If ${isc.DocUtils.linkForRef('attr:ComboBoxItem.addUnknownValues')} is false, when the user modifies the\n value displayed in the combobox item text box, the underlying data value (as returned\n from item.getValue()) is not immediately updated - instead the value is used to filter\n the set of results displayed in the comboBoxItem pickList.\n <P>\n While the comboBoxItem is in this pending state (where the result of getEnteredValue() will\n not necessarily match the display value for whatever is returned by getValue()), the \n pendingTextBoxStyle may be applied to the text box for the item.\n <P>\n When the element value is updated to display the actual value for the item (typically due\n to the user selecting a value from the pickList), the standard \n ${isc.DocUtils.linkForRef('attr:TextItem.textBoxStyle')} will be reapplied.\n <P>\n May be left unset in which case the standard text box style is always applied.\n Has no effect if ${isc.DocUtils.linkForRef('attr:ComboBoxItem.addUnknownValues')} is true.",
        flags:"IRW",
        name:"pendingTextBoxStyle"
    },
    "attr:DateItem.monthSelector":{
        seeAlso:[
            {
                ref:"attr:DateItem.selectorFormat",
                description:null
            }
        ],
        defaultValue:"null",
        type:"attr",
        definingClass:"class:DateItem",
        groups:[
            "dateItemAppearance"
        ],
        deprecated:null,
        ref:"attr:DateItem.monthSelector",
        valueType:"AutoChild SelectItem",
        description:"${isc.DocUtils.linkForRef('class:SelectItem')} for picking a month.\n <P>\n To control which selectors are visible and in what order, use ${isc.DocUtils.linkForRef('attr:DateItem.selectorFormat')}.",
        flags:"R",
        name:"monthSelector"
    },
    "attr:DynamicForm.hiliteRequiredFields":{
        seeAlso:[
        ],
        defaultValue:"true",
        type:"attr",
        definingClass:"class:DynamicForm",
        groups:[
            "formTitles"
        ],
        deprecated:null,
        ref:"attr:DynamicForm.hiliteRequiredFields",
        valueType:"Boolean",
        description:"Indicates whether the titles of required items in this form should use the special\n prefix and suffix specified by the ${isc.DocUtils.linkForRef('attr:DynamicForm.requiredTitlePrefix')} and \n ${isc.DocUtils.linkForRef('attr:DynamicForm.requiredTitleSuffix')} attributes, instead of the standard prefix and suffix.",
        flags:"IRW",
        name:"hiliteRequiredFields"
    },
    "attr:TimeItem.ampmItem":{
        seeAlso:[
        ],
        ref:"attr:TimeItem.ampmItem",
        defaultValue:"null",
        deprecated:null,
        type:"attr",
        definingClass:"class:TimeItem",
        valueType:"AutoChild SelectItem",
        description:"Select item to hold the AM/PM value for the timeItem when \n ${isc.DocUtils.linkForRef('attr:TimeItem.useTextField','useTextField')} is false.",
        flags:"R",
        name:"ampmItem"
    },
    "attr:Layout.align":{
        seeAlso:[
        ],
        defaultValue:"null",
        type:"attr",
        definingClass:"class:Layout",
        groups:[
            "layoutPolicy"
        ],
        ref:"attr:Layout.align",
        deprecated:null,
        valueType:"Alignment | VerticalAlignment",
        setter:[
            "setAlign"
        ],
        description:"Alignment of all members in this Layout on the length axis (vertical for a VLayout,\n horizontal for an HLayout).  Defaults to \"top\" for vertical Layouts, and \"left\" for\n horizontal Layouts.\n <p>\n Horizontal layouts should only be set to ${isc.DocUtils.linkForRef('type:Alignment')}, and vertical layouts to\n ${isc.DocUtils.linkForRef('type:VerticalAlignment')}, otherwise they will be considered invalid values, and assigning an\n invalid value here will log a warning to the Developer Console.\n <P>\n For alignment on the breadth axis, see ${isc.DocUtils.linkForRef('attr:Layout.defaultLayoutAlign')} and\n ${isc.DocUtils.linkForRef('attr:Canvas.layoutAlign')}.\n <P>\n When attempting to center components be sure that you have set a specific size on the\n component(s) involved.  If components fill all available space in the layout, centering\n looks the same as not centering.\n <P>\n Similarly, if a component has no visible boundary (like a border), it can appear similar\n to when it's not centered if the component is larger than you expect - use the Watch tab\n in the Developer Console to see the component's extents visually.",
        flags:"IRW",
        examples:[
            "${isc.DocUtils.linkForExampleId('layoutCenterAlign')}"
        ],
        name:"align"
    },
    "method:TabSet.setCanCloseTab":{
        seeAlso:[
        ],
        ref:"method:TabSet.setCanCloseTab",
        deprecated:null,
        type:"method",
        definingClass:"class:TabSet",
        params:[
            {
                defaultValue:null,
                optional:false,
                type:"Tab | GlobalId | TabName | number",
                description:"tab to change",
                name:"tab"
            },
            {
                defaultValue:null,
                optional:false,
                type:"boolean",
                description:"new value for the tab's canClose property, or null to clear it",
                name:"canClose"
            }
        ],
        description:" Sets the given tab's ${isc.DocUtils.linkForRef('attr:Tab.canClose','canClose')} property to the boolean parameter canClose.\n If canClose is null, this will have the effect of causing the tab to fall back on ${isc.DocUtils.linkForRef('attr:TabSet.canCloseTabs')}.\n",
        flags:"",
        name:"setCanCloseTab"
    },
    "type:ControlName":{
        seeAlso:[
        ],
        ref:"type:ControlName",
        deprecated:null,
        type:"type",
        values:[
            {
                value:"\"boldSelection\"",
                description:"A button to make the current selection bold."
            },
            {
                value:"\"italicSelection\"",
                description:"A button to make the current selection italic."
            },
            {
                value:"\"underlineSelection\"",
                description:"A button to make the current selection underlined."
            },
            {
                value:"\"fontSelector\"",
                description:"A select item allowing the user to change the font of the current text selection."
            },
            {
                value:"\"fontSizeSelector\"",
                description:"A select item allowing the user to change the font size of the current text selection."
            },
            {
                value:"\"alignLeft\"",
                description:"A button to left-align the selected text."
            },
            {
                value:"\"alignRight\"",
                description:"A button to right-align the selected text."
            },
            {
                value:"\"alignCenter\"",
                description:"A button to center the selected text."
            },
            {
                value:"\"justify\"",
                description:"A button to justify the selected line of text."
            },
            {
                value:"\"color\"",
                description:"A color-picker allowing the user to set the text color."
            },
            {
                value:"\"backgroundColor\"",
                description:"A color picker allowing the user to set the text background color."
            },
            {
                value:"\"indent\"",
                description:"Within text, indents the paragraph. Within a list, increases the list level."
            },
            {
                value:"\"outdent\"",
                description:"Within text, outdents the paragraph. Within a list, decreases the list level."
            },
            {
                value:"\"orderedList\"",
                description:"Turns the current selection into an ordered list (HTML &lt;ol&gt;) or converts an unordered list to an ordered list."
            },
            {
                value:"\"unorderedList\"",
                description:"Turns the current selection into an unordered list (HTML &lt;ul&gt;) or converts an ordered list to an unordered list."
            },
            {
                value:"\"listProperties\"",
                description:"Shows the ${isc.DocUtils.linkForRef('attr:RichTextEditor.listPropertiesDialog','listPropertiesDialog')} to allow configuring the options of the currently selected HTML list."
            }
        ],
        description:"Names for the standard controls built into the RichTextEditor.  You can use these\n <code>ControlNames</code> in APIs like ${isc.DocUtils.linkForRef('attr:RichTextEditor.styleControls')} to control\n the order in which controls appear, to omit default controls or to show controls that\n are not shown by default.\n <p>\n Every <code>ControlName</code> is also the name of an ${isc.DocUtils.linkForRef('type:AutoChild')}, so all the\n built-in controls can be skinned or otherwise customized via the\n ${isc.DocUtils.linkForRef('group:autoChildUsage','AutoChild system')}. ",
        name:"ControlName"
    },
    "method:FormItem.setIconShowOnFocus":{
        groups:[
            "formIcons"
        ],
        seeAlso:[
        ],
        ref:"method:FormItem.setIconShowOnFocus",
        deprecated:null,
        type:"method",
        definingClass:"class:FormItem",
        params:[
            {
                defaultValue:null,
                optional:false,
                type:"Identifier",
                description:"${isc.DocUtils.linkForRef('attr:FormItemIcon.name','name')} of the icon to update",
                name:"icon"
            },
            {
                defaultValue:null,
                optional:false,
                type:"Boolean",
                description:"new value of ${isc.DocUtils.linkForRef('attr:FormItemIcon.showOnFocus')}",
                name:"showOnFocus"
            }
        ],
        description:" Sets ${isc.DocUtils.linkForRef('attr:FormItemIcon.showOnFocus')} for the supplied icon, and causes that icon's\n visibility to be updated and the item redrawn as appropriate.\n\n",
        flags:"",
        name:"setIconShowOnFocus"
    },
    "method:Canvas.destroy":{
        seeAlso:[
            {
                ref:"method:Canvas.markForDestroy",
                description:null
            },
            {
                ref:"group:memoryLeaks",
                description:null
            }
        ],
        ref:"method:Canvas.destroy",
        deprecated:null,
        type:"method",
        definingClass:"class:Canvas",
        description:" Permanently destroy a Canvas and all of it's children / members, recursively.\n <P>\n Like ${isc.DocUtils.linkForRef('method:Canvas.clear')}, calling <code>destroy()</code> removes all HTML for the component;\n unlike clear(), a destroyed Canvas is permanently unusable: it cannot be draw()'n again,\n cannot be referenced by its global ID, and is eligible for garbage collection (assuming\n that application code is not holding a reference to the Canvas).\n <P>\n Any attempt to call a method on a destroyed Canvas will generally result in an error.  If your\n application is forced to hold onto Canvas's that might be destroy()d without warning, you can\n avoid errors by checking for the ${isc.DocUtils.linkForRef('attr:Canvas.destroyed')} property.  If you override certain Canvas\n methods, your code may be called while a Canvas is being destroy()d; in this case you can avoid\n extra work (and possibly errors) by checking for the ${isc.DocUtils.linkForRef('attr:Canvas.destroying')} property.\n <P>\n Note that <code>destroy()</code> should not be called directly in event handling code for this\n canvas. For this reason, wherever possible we recommend using ${isc.DocUtils.linkForRef('method:Canvas.markForDestroy')}\n instead of calling this method directly.\n <P>\n Also note that developers should not <code>destroy()</code> or <code>markForDestroy()</code> a component\n while it is in the middle of an asynchronous operation. For example, if you need to submit\n and then destroy a single-use dynamic form, the call to <code>markForDestroy()</code> should\n be invoked from the callback to ${isc.DocUtils.linkForRef('method:DynamicForm.saveData')}, rather than being invoked\n synchronously after the the call to <code>saveData()</code>.\n\n",
        flags:"A",
        name:"destroy"
    },
    "attr:FacetChart.logScalePointSize":{
        seeAlso:[
            {
                ref:"attr:FacetChart.pointSizeLogBase",
                description:null
            }
        ],
        defaultValue:"false",
        type:"attr",
        definingClass:"class:FacetChart",
        deprecated:null,
        ref:"attr:FacetChart.logScalePointSize",
        valueType:"boolean",
        description:"Whether to use logarithmic scaling for the ${isc.DocUtils.linkForRef('attr:FacetChart.pointSizeMetric','data point sizes')}.\n Defaults to the value of ${isc.DocUtils.linkForRef('attr:FacetChart.logScale')}.",
        flags:"IR",
        examples:[
            "${isc.DocUtils.linkForExampleId('bubbleChart')}"
        ],
        name:"logScalePointSize"
    },
    "attr:ImgButton.iconWidth":{
        seeAlso:[
        ],
        defaultValue:"null",
        type:"attr",
        definingClass:"class:ImgButton",
        groups:[
            "buttonIcon"
        ],
        deprecated:null,
        ref:"attr:ImgButton.iconWidth",
        valueType:"Integer",
        description:"Width in pixels of the icon image.\n <P>\n If unset, defaults to ${isc.DocUtils.linkForRef('attr:StatefulCanvas.iconSize','iconSize')}.",
        flags:"IR",
        name:"iconWidth"
    },
    "attr:Progressbar.percentDone":{
        seeAlso:[
        ],
        defaultValue:"0",
        type:"attr",
        definingClass:"class:Progressbar",
        groups:[
            "appearance"
        ],
        ref:"attr:Progressbar.percentDone",
        deprecated:null,
        setter:[
            "setPercentDone"
        ],
        valueType:"number",
        description:"Number from 0 to 100, inclusive, for the percentage to be displayed graphically in\n this progressbar.",
        flags:"IRW",
        name:"percentDone"
    },
    "attr:CheckboxItem.printCheckedImage":{
        seeAlso:[
            {
                ref:"attr:CheckboxItem.checkedImage",
                description:null
            }
        ],
        defaultValue:"null",
        type:"attr",
        definingClass:"class:CheckboxItem",
        groups:[
            "printing"
        ],
        deprecated:null,
        ref:"attr:CheckboxItem.printCheckedImage",
        valueType:"SCImgURL",
        description:"If set, the ${isc.DocUtils.linkForRef('attr:CheckboxItem.checkedImage')} to use when ${isc.DocUtils.linkForRef('group:printing','printing')}.",
        flags:"IRW",
        name:"printCheckedImage"
    },
    "object:AnimateShowEffect":{
        seeAlso:[
        ],
        type:"object",
        staticMethods:[
        ],
        classMethods:[
        ],
        classAttrs:[
        ],
        attrs:[
            "attr:AnimateShowEffect.effect",
            "attr:AnimateShowEffect.startFrom",
            "attr:AnimateShowEffect.endAt",
            "attr:AnimateShowEffect.endsAt"
        ],
        ref:"object:AnimateShowEffect",
        deprecated:null,
        treeLocation:[
            "Client Reference/System"
        ],
        description:"Configuration object for effect to apply during an animated show or hide.",
        methods:[
        ],
        name:"AnimateShowEffect"
    },
    "attr:ToolStripGroup.label":{
        seeAlso:[
        ],
        ref:"attr:ToolStripGroup.label",
        defaultValue:"null",
        deprecated:null,
        type:"attr",
        definingClass:"class:ToolStripGroup",
        valueType:"AutoChild Label",
        description:"AutoChild ${isc.DocUtils.linkForRef('class:Label','Label')} used to display the \n ${isc.DocUtils.linkForRef('attr:ToolStripGroup.title','title text')} for this group.\n <P>\n Can be customized via the standard ${isc.DocUtils.linkForRef('type:AutoChild')} pattern, and various \n convenience APIs exist for configuring it after initial draw: see \n ${isc.DocUtils.linkForRef('method:ToolStripGroup.setShowTitle','setShowTitle')}, \n ${isc.DocUtils.linkForRef('method:ToolStripGroup.setTitle','setTitle')}, \n ${isc.DocUtils.linkForRef('method:ToolStripGroup.setTitleAlign','setTitleAlign')},\n ${isc.DocUtils.linkForRef('method:ToolStripGroup.setTitleHeight','setTitleHeight')},\n ${isc.DocUtils.linkForRef('method:ToolStripGroup.setTitleOrientation','setTitleOrientation')} and\n ${isc.DocUtils.linkForRef('method:ToolStripGroup.setTitleStyle','setTitleStyle')}.",
        flags:"IR",
        name:"label"
    },
    "attr:FormItem.validators":{
        seeAlso:[
        ],
        ref:"attr:FormItem.validators",
        defaultValue:"null",
        deprecated:null,
        type:"attr",
        definingClass:"class:FormItem",
        valueType:"Array of Validator",
        description:"Validators for this form item.  \n <P>\n <b>Note:</b> these validators will only be run on the client; to\n do real client-server validation, validators must be specified via\n ${isc.DocUtils.linkForRef('attr:DataSourceField.validators')}.",
        flags:"IR",
        name:"validators"
    },
    "classAttr:Dialog.NO_BUTTON_TITLE":{
        seeAlso:[
            {
                ref:"type:DialogButtons",
                description:null
            }
        ],
        defaultValue:"\"No\"",
        type:"classAttr",
        definingClass:"class:Dialog",
        groups:[
            "i18nMessages"
        ],
        deprecated:null,
        ref:"classAttr:Dialog.NO_BUTTON_TITLE",
        valueType:"HTMLString",
        description:"Title for the <code>\"No\"</code> button.",
        flags:"IRW",
        name:"NO_BUTTON_TITLE"
    },
    "attr:ListGrid.rowSpanSelectionMode":{
        seeAlso:[
        ],
        ref:"attr:ListGrid.rowSpanSelectionMode",
        defaultValue:"\"forward\"",
        deprecated:null,
        type:"attr",
        definingClass:"class:ListGrid",
        valueType:"RowSpanSelectionMode",
        description:"Chooses the selection mode when ${isc.DocUtils.linkForRef('attr:ListGrid.useRowSpanStyling')} is enabled.  See\n ${isc.DocUtils.linkForRef('type:RowSpanSelectionMode')}.",
        flags:"IR",
        name:"rowSpanSelectionMode"
    },
    "attr:SelectItem.multipleAppearance":{
        seeAlso:[
        ],
        ref:"attr:SelectItem.multipleAppearance",
        defaultValue:"\"picklist\"",
        deprecated:null,
        type:"attr",
        definingClass:"class:SelectItem",
        valueType:"MultipleAppearance",
        description:"How should items with ${isc.DocUtils.linkForRef('attr:SelectItem.multiple')} set to 'true' be displayed?",
        flags:"IR",
        name:"multipleAppearance"
    },
    "attr:EventCanvas.showContextButton":{
        seeAlso:[
        ],
        ref:"attr:EventCanvas.showContextButton",
        defaultValue:"false",
        deprecated:null,
        type:"attr",
        definingClass:"class:EventCanvas",
        valueType:"Boolean",
        description:"When set to true, shows a ${isc.DocUtils.linkForRef('attr:Calendar.eventCanvasContextButton','small icon')} in the \n top corner of an EventCanvas, beside the \n ${isc.DocUtils.linkForRef('attr:Calendar.eventCanvasContextButton','close-icon')}.  When clicked, shows a \n ${isc.DocUtils.linkForRef('method:Calendar.getEventCanvasMenuItems','context menu')} containing items applicable to \n this canvas.",
        flags:"IRW",
        name:"showContextButton"
    },
    "attr:FormItem.alwaysShowControlBox":{
        seeAlso:[
        ],
        ref:"attr:FormItem.alwaysShowControlBox",
        defaultValue:"null",
        deprecated:null,
        type:"attr",
        definingClass:"class:FormItem",
        valueType:"Boolean",
        description:"A formItem showing a ${isc.DocUtils.linkForRef('attr:FormItem.showPickerIcon','pickerIcon')} will always\n write out a \"control box\" around the text box and picker icon. This is an HTML\n element styled using the specified ${isc.DocUtils.linkForRef('attr:FormItem.controlStyle')}.\n <P>\n This attribute controls whether the control box should be written out even\n if the picker icon is not being shown. If unset, default behavior will write out\n a control table if ${isc.DocUtils.linkForRef('attr:FormItem.showPickerIcon')} is true and the icon is\n not suppressed via ${isc.DocUtils.linkForRef('method:FormItemIcon.showIf')}. This means the control table\n can be written out with no visible picker if ${isc.DocUtils.linkForRef('attr:FormItem.showPickerIconOnFocus')}\n is true and the item does not have focus.\n <P>\n This attribute is useful for developers who wish to rely on styling specified\n via the ${isc.DocUtils.linkForRef('attr:FormItem.controlStyle')} even while the picker icon is not visible.\n <P>\n See the ${isc.DocUtils.linkForRef('group:formItemStyling','form item styling overview')} for details of the\n control table and other styling options.",
        flags:"IRA",
        name:"alwaysShowControlBox"
    },
    "attr:TextItem.selectOnFocus":{
        seeAlso:[
        ],
        defaultValue:"null",
        type:"attr",
        definingClass:"class:TextItem",
        groups:[
            "focus"
        ],
        deprecated:null,
        ref:"attr:TextItem.selectOnFocus",
        valueType:"boolean",
        description:"Allows the ${isc.DocUtils.linkForRef('attr:DynamicForm.selectOnFocus','selectOnFocus')} behavior to be configured on a\n per-FormItem basis.  Normally all items in a form default to the value of\n ${isc.DocUtils.linkForRef('attr:DynamicForm.selectOnFocus')}.",
        flags:"IRW",
        name:"selectOnFocus"
    },
    "method:Sound.setSrc":{
        seeAlso:[
        ],
        ref:"method:Sound.setSrc",
        deprecated:null,
        type:"method",
        definingClass:"class:Sound",
        params:[
            {
                defaultValue:null,
                optional:false,
                type:"String | Array of String",
                description:"URL of new audio file to be played by this sound instance.",
                name:"src"
            }
        ],
        description:" Update the ${isc.DocUtils.linkForRef('attr:Sound.src')} of this sound instance at runtime. Note that \n ${isc.DocUtils.linkForRef('attr:Sound.autoLoad')} and ${isc.DocUtils.linkForRef('attr:Sound.autoPlay')} govern whether this media will\n be loaded or played immediately when the src value is changed.\n",
        flags:"",
        name:"setSrc"
    },
    "attr:Progressbar.useCssStyles":{
        seeAlso:[
        ],
        ref:"attr:Progressbar.useCssStyles",
        defaultValue:"false",
        deprecated:null,
        type:"attr",
        definingClass:"class:Progressbar",
        valueType:"boolean",
        description:"When set to true, styles the Progressbar via the ${isc.DocUtils.linkForRef('attr:Progressbar.baseStyle','base')} and \n ${isc.DocUtils.linkForRef('attr:Progressbar.progressStyle','progress')} CSS styles.",
        flags:"IR",
        name:"useCssStyles"
    },
    "attr:ListGrid.selectionAppearance":{
        seeAlso:[
        ],
        defaultValue:"\"rowStyle\"",
        type:"attr",
        definingClass:"class:ListGrid",
        groups:[
            "selection"
        ],
        ref:"attr:ListGrid.selectionAppearance",
        deprecated:null,
        setter:[
            "setSelectionAppearance"
        ],
        valueType:"SelectionAppearance",
        description:"How selection of rows should be presented to the user.\n <P>\n For <code>selectionAppearance:\"checkbox\"</code> with multiple selection\n allowed, you would typically use ${isc.DocUtils.linkForRef('attr:ListGrid.selectionType')}:\"simple\" (the default).  Because\n <code>selectionType</code> and <code>selectionAppearance</code> are unrelated,\n the combination of <code>selectionAppearance:\"checkbox\"</code> and\n <code>selectionType:\"multiple\"</code> results in a grid where multiple selection can\n only be achieved via shift-click or ctrl-click.\n <P>\n If using <code>\"checkbox\"</code> for a ${isc.DocUtils.linkForRef('class:ListGrid')}, see also\n ${isc.DocUtils.linkForRef('attr:ListGrid.checkboxField')} for customization APIs.\n <P>\n If using <code>\"checkbox\"</code> for a ${isc.DocUtils.linkForRef('class:TreeGrid')}, an extra icon,\n ${isc.DocUtils.linkForRef('method:TreeGrid.getExtraIcon')} is not supported. Additionally only\n ${isc.DocUtils.linkForRef('attr:ListGrid.selectionType')}:\"simple\" and \"single\" are supported.\n You can also toggle the display of a disabled checkbox on a treeGrid, displayed\n when the node can't be selected, via ${isc.DocUtils.linkForRef('attr:TreeGrid.showDisabledSelectionCheckbox')}.\n <p>\n Note that the default behavior when you enable checkbox selection is to continue to show\n the selected style.  This can be changed by setting ${isc.DocUtils.linkForRef('attr:ListGrid.showSelectedStyle')} to false.",
        flags:"IRW",
        name:"selectionAppearance"
    },
    "class:Facet":{
        seeAlso:[
        ],
        requiresModules:[
            "Analytics"
        ],
        type:"class",
        staticMethods:[
        ],
        inheritsFrom:"Class",
        classMethods:[
        ],
        classAttrs:[
        ],
        attrs:[
            "attr:Facet.id",
            "attr:Facet.title",
            "attr:Facet.values",
            "attr:Facet.inlinedValues",
            "attr:Facet.rollupValue",
            "attr:Facet.isTree",
            "attr:Facet.showParentsLast",
            "attr:Facet.collapsed",
            "attr:Facet.minimized",
            "attr:Facet.canCollapse",
            "attr:Facet.canMinimize",
            "attr:Facet.width",
            "attr:Facet.height",
            "attr:Facet.labelHeight",
            "attr:Facet.align",
            "attr:Facet.titleAlign",
            "attr:Facet.cellAlign",
            "attr:Facet.borderBefore",
            "attr:Facet.borderAfter",
            "attr:Facet.indentVTree",
            "attr:Facet.selectionBoundary",
            "attr:Facet.summaryValue",
            "attr:Facet.summaryTitle",
            "attr:Facet.synchColumnLayout",
            "attr:Facet.proportionalTitle"
        ],
        ref:"class:Facet",
        deprecated:null,
        treeLocation:[
            "Optional Modules/Analytics/CubeGrid"
        ],
        description:"Facet definition object made use of by the ${isc.DocUtils.linkForRef('class:CubeGrid','CubeGrid')} and\n ${isc.DocUtils.linkForRef('class:FacetChart','FacetChart')} classes.",
        methods:[
        ],
        name:"Facet"
    },
    "attr:RelativeDateItem.showPastOptions":{
        seeAlso:[
        ],
        ref:"attr:RelativeDateItem.showPastOptions",
        defaultValue:"true",
        deprecated:null,
        type:"attr",
        definingClass:"class:RelativeDateItem",
        valueType:"Boolean",
        description:"Should we show time-unit options in the past? If set to false, for each \n ${isc.DocUtils.linkForRef('attr:RelativeDateItem.timeUnitOptions','timeUnitOption')} we will show only future options [for example\n \"N weeks from now\"].\n <P>\n Note: this does not change the ${isc.DocUtils.linkForRef('attr:RelativeDateItem.presetOptions')}, which show up in \n addition to the time-unit options (<i>\"N days from now\"</i>, etc). The default\n preset options include both past and future presets so developers may wish to modify the\n presets to ensure only past options are available.",
        flags:"IR",
        name:"showPastOptions"
    },
    "classAttr:Dialog.ASK_FOR_VALUE_TITLE":{
        seeAlso:[
        ],
        defaultValue:"\"Please enter a value\"",
        type:"classAttr",
        definingClass:"class:Dialog",
        groups:[
            "i18nMessages"
        ],
        deprecated:null,
        ref:"classAttr:Dialog.ASK_FOR_VALUE_TITLE",
        valueType:"HTMLString",
        description:"Default title for the dialog displayed by ${isc.DocUtils.linkForRef('staticMethod:isc.askForValue')}.\n A custom title can alternatively be specified as the <code>title</code> attribute of the\n <code>properties</code> parameter passed to that method.",
        flags:"IRW",
        name:"ASK_FOR_VALUE_TITLE"
    },
    "method:Img.getHoverHTML":{
        groups:[
            "hovers"
        ],
        seeAlso:[
            {
                ref:"attr:Canvas.showHover",
                description:null
            }
        ],
        ref:"method:Img.getHoverHTML",
        deprecated:null,
        type:"method",
        definingClass:"class:Img",
        description:" If <code>this.showHover</code> is true, when the user holds the mouse over this Canvas for\n long enough to trigger a hover event, a hover canvas is shown by default. This method returns\n the contents of that hover canvas.\n <P>\n Overridden from Canvas: <br>\n If ${isc.DocUtils.linkForRef('attr:Img.prompt')} is specified, and ${isc.DocUtils.linkForRef('attr:Img.altText')} is unset, default implementation is unchanged -\n the prompt text will be displayed in the hover.<br>\n If ${isc.DocUtils.linkForRef('attr:Img.altText')} and ${isc.DocUtils.linkForRef('attr:Img.prompt')} are set this method will return null to suppress\n the standard hover behavior in browsers where the alt attribute on an img tag causes\n a native tooltip to appear, such as Internet Explorer.\n On other browsers the altText value will be returned.\n\n",
        flags:"",
        returns:{
            type:"String",
            description:"the string to show in the hover"
        },
        name:"getHoverHTML"
    },
    "class:EdgedCanvas":{
        seeAlso:[
        ],
        type:"class",
        staticMethods:[
        ],
        inheritsFrom:"Canvas",
        classMethods:[
        ],
        classAttrs:[
        ],
        attrs:[
            "attr:EdgedCanvas.skinImgDir",
            "attr:EdgedCanvas.edgeImage",
            "attr:EdgedCanvas.edgeColor",
            "attr:EdgedCanvas.customEdges",
            "attr:EdgedCanvas.showCenter",
            "attr:EdgedCanvas.edgeSize",
            "attr:EdgedCanvas.edgeLeft",
            "attr:EdgedCanvas.edgeRight",
            "attr:EdgedCanvas.edgeTop",
            "attr:EdgedCanvas.edgeBottom",
            "attr:EdgedCanvas.edgeOffset",
            "attr:EdgedCanvas.edgeOffsetTop",
            "attr:EdgedCanvas.edgeOffsetBottom",
            "attr:EdgedCanvas.edgeOffsetLeft",
            "attr:EdgedCanvas.edgeOffsetRight",
            "attr:EdgedCanvas.centerBackgroundColor",
            "attr:EdgedCanvas.edgeStyleName",
            "attr:EdgedCanvas.addEdgeStyleSuffix"
        ],
        groups:[
            "imageEdges"
        ],
        ref:"class:EdgedCanvas",
        deprecated:null,
        treeLocation:[
            "Client Reference/Foundation"
        ],
        description:"EdgedCanvas acts as a decorative, image-based frame around another single Canvas.",
        methods:[
        ],
        name:"EdgedCanvas"
    },
    "method:DrawItem.drawStart":{
        seeAlso:[
        ],
        ref:"method:DrawItem.drawStart",
        deprecated:null,
        type:"method",
        definingClass:"class:DrawItem",
        description:" Called when we start drawing for this DrawItem to the ${isc.DocUtils.linkForRef('attr:DrawItem.drawPane')}'s underlying\n HTML5 &lt;canvas&gt; element.  Only called if the ${isc.DocUtils.linkForRef('type:DrawingType')} is\n \"bitmap\".\n \n <P>There is no default implementation of this method.\n",
        flags:"A",
        name:"drawStart"
    },
    "staticMethod:Date.setFiscalCalendar":{
        seeAlso:[
        ],
        ref:"staticMethod:Date.setFiscalCalendar",
        deprecated:"Use ${isc.DocUtils.linkForRef('classMethod:DateUtil.setFiscalCalendar')}.",
        type:"staticMethod",
        definingClass:"object:Date",
        params:[
            {
                defaultValue:null,
                optional:false,
                type:"FiscalCalendar",
                description:"the object representing the start month and date of           the fiscal year in the current locale",
                name:"fiscalCalendar"
            }
        ],
        description:" Sets the global fiscal calendar, which is used for all calls to\n getFiscalYear() / getFiscalWeek() if those methods aren't passed a fiscalCalander.\n\n",
        flags:"",
        name:"setFiscalCalendar"
    },
    "staticMethod:Date.setNormalDisplayFormat":{
        groups:[
            "dateFormatting"
        ],
        seeAlso:[
        ],
        ref:"staticMethod:Date.setNormalDisplayFormat",
        deprecated:"Use ${isc.DocUtils.linkForRef('classMethod:DateUtil.setNormalDisplayFormat')}.",
        type:"staticMethod",
        definingClass:"object:Date",
        params:[
            {
                defaultValue:null,
                optional:false,
                type:"FormatString | DateDisplayFormat | Function",
                description:"new formatter",
                name:"format"
            }
        ],
        description:" Set the default formatter for date objects to the method name passed in.  After calling this\n method, subsequent calls to ${isc.DocUtils.linkForRef('method:Date.toNormalDate')}\n  will return a string formatted\n according to this format specification. Note: this will be the standard long date format used\n by SmartClient components.\n <p>\n The <code>format</code> parameter may be a ${isc.DocUtils.linkForRef('type:FormatString')}, a ${isc.DocUtils.linkForRef('type:DateDisplayFormat')} \n string, or a function. If passed a function, this function will be executed in the scope of\n the Date and should return the formatted string.<br>\n <p>\n Initial default normalDisplayFormat is <code>\"toLocaleString\"</code>\n",
        flags:"",
        name:"setNormalDisplayFormat"
    },
    "attr:Menu.target":{
        seeAlso:[
        ],
        ref:"attr:Menu.target",
        defaultValue:"null",
        deprecated:null,
        type:"attr",
        definingClass:"class:Menu",
        valueType:"Canvas",
        description:"Optional target canvas for this menu.  Available as a parameter to dynamic menuItem configuration\n methods such as ${isc.DocUtils.linkForRef('method:MenuItem.checkIf')}.\n <P>\n Whenever a Menu is shown as a contextMenu by a widget due to ${isc.DocUtils.linkForRef('attr:Canvas.contextMenu')}\n being set, <code>menu.target</code> is automatically set to the widget that showed the\n contextMenu.\n <P>\n If this item has any ${isc.DocUtils.linkForRef('attr:MenuItem.submenu','submenus')} the <code>target</code> will be propagated down\n to these child menus.",
        flags:"IRW",
        name:"target"
    },
    "attr:Calendar.weekPrefix":{
        seeAlso:[
        ],
        defaultValue:"\"Week\"",
        type:"attr",
        definingClass:"class:Calendar",
        groups:[
            "i18nMessages"
        ],
        deprecated:null,
        ref:"attr:Calendar.weekPrefix",
        valueType:"HTMLString",
        description:"The text to appear before the week number in the title of ${isc.DocUtils.linkForRef('type:TimeUnit','week-based')} \n ${isc.DocUtils.linkForRef('object:HeaderLevel')}s when this calendar is showing a timeline.",
        flags:"IR",
        name:"weekPrefix"
    },
    "attr:TabSet.useIOSTabs":{
        seeAlso:[
        ],
        ref:"attr:TabSet.useIOSTabs",
        defaultValue:"false",
        deprecated:null,
        type:"attr",
        definingClass:"class:TabSet",
        valueType:"Boolean",
        description:"Setting this to true turns on a different appearance for tabs, similar to iOS tabs from \n the \"Music\" app, where the tab.icon is enlarged and shown as a black and white mask.  \n This mode does not support a clickable icon - clicking the enlarged icon just switches \n tabs.\n <P>\n This attribute only has an effect for tabs that are not ${isc.DocUtils.linkForRef('attr:Tab.canClose','closable')},\n and only for Mobile WebKit.",
        flags:"IR",
        name:"useIOSTabs"
    },
    "method:DrawPane.getDrawingX":{
        seeAlso:[
        ],
        ref:"method:DrawPane.getDrawingX",
        deprecated:null,
        type:"method",
        definingClass:"class:DrawPane",
        description:" Returns the X coordinate in the ${isc.DocUtils.linkForRef('class:DrawPane','drawing coordinate system')} of the last event.\n Note: If you need both the X and Y coordinates in the drawing coordinate system of the last event,\n it is more efficient to call ${isc.DocUtils.linkForRef('method:DrawPane.getDrawingPoint','getDrawingPoint()')} instead.\n <p>\n See the documentation of ${isc.DocUtils.linkForRef('method:DrawPane.getDrawingPoint','getDrawingPoint()')} for a clarifying\n example.\n",
        flags:"A",
        returns:{
            type:"int",
            description:"X coordinate in the drawing coordinate system of the last event."
        },
        name:"getDrawingX"
    },
    "type:ShowMessageType":{
        seeAlso:[
            {
                ref:"attr:ShowMessageTask.type",
                description:null
            }
        ],
        ref:"type:ShowMessageType",
        deprecated:null,
        type:"type",
        values:[
            {
                value:"\"normal\"",
                description:"Normal message"
            },
            {
                value:"\"warning\"",
                description:"Warning message"
            },
            {
                value:"\"error\"",
                description:"Error message"
            }
        ],
        description:"Type of message to display in ${isc.DocUtils.linkForRef('class:ShowMessageTask')}. Controls the display of the icon.",
        name:"ShowMessageType"
    },
    "method:Canvas.setClassName":{
        groups:[
            "appearance"
        ],
        seeAlso:[
        ],
        ref:"method:Canvas.setClassName",
        deprecated:"As of SmartClient version 5.5, use ${isc.DocUtils.linkForRef('method:Canvas.setStyleName')} instead.",
        type:"method",
        definingClass:"class:Canvas",
        params:[
            {
                defaultValue:null,
                optional:false,
                type:"CSSStyleName",
                description:"new CSS class name (must be defined previously)",
                name:"newClass"
            }
        ],
        description:" Sets the CSS class for this widget\n",
        flags:"A",
        name:"setClassName"
    },
    "attr:Class.creator":{
        seeAlso:[
            {
                ref:"attr:Class.autoCreator",
                description:null
            }
        ],
        defaultValue:"varies",
        type:"attr",
        definingClass:"class:Class",
        groups:[
            "autoChildren"
        ],
        deprecated:null,
        ref:"attr:Class.creator",
        valueType:"Class",
        description:"For an ${isc.DocUtils.linkForRef('group:autoChildren','AutoChild')}, a read-only reference to the component on\n which ${isc.DocUtils.linkForRef('method:Class.createAutoChild')} or ${isc.DocUtils.linkForRef('method:Class.addAutoChild')} was called to create it.\n Useful for authoring of event handlers (eg click:\"this.creator.doSomething()\")",
        flags:"R",
        name:"creator"
    },
    "classAttr:DrawLabel.defaultSerifFont":{
        seeAlso:[
        ],
        ref:"classAttr:DrawLabel.defaultSerifFont",
        defaultValue:"\"Times\"",
        deprecated:null,
        type:"classAttr",
        definingClass:"class:DrawLabel",
        valueType:"String",
        description:"This setting exists due to platform limitations in some versions of Internet Explorer\n where the browser does not recognize the five generic font families\n (<code>cursive</code>, <code>fantasy</code>, <code>monospace</code>,\n <code>sans-serif</code>, and <code>serif</code>) and instead uses a non-configurable,\n default font.  This setting specifies a specific font to replace the\n <code>serif</code> keyword should a DrawLabel list it in its\n ${isc.DocUtils.linkForRef('attr:DrawLabel.fontFamily','font family')}.",
        flags:"IRW",
        name:"defaultSerifFont"
    },
    "attr:PrintWindow.printButtonTitle":{
        seeAlso:[
        ],
        defaultValue:"\"Print\"",
        type:"attr",
        definingClass:"class:PrintWindow",
        deprecated:null,
        ref:"attr:PrintWindow.printButtonTitle",
        setter:[
            "setPrintButtonTitle"
        ],
        valueType:"String",
        description:"Title for the print button",
        flags:"IRW",
        name:"printButtonTitle"
    },
    "attr:AdaptiveMenu.partialInlining":{
        seeAlso:[
        ],
        defaultValue:"true",
        type:"attr",
        definingClass:"class:AdaptiveMenu",
        deprecated:null,
        ref:"attr:AdaptiveMenu.partialInlining",
        setter:[
            "setPartialInlining"
        ],
        valueType:"boolean",
        description:"Whether the AdaptiveMenu should show some menu items inline as soon as there is enough space,\n or should strictly switch between showing",
        flags:"IRW",
        name:"partialInlining"
    },
    "attr:DynamicForm.defaultSearchOperator":{
        seeAlso:[
        ],
        ref:"attr:DynamicForm.defaultSearchOperator",
        defaultValue:"null",
        deprecated:null,
        type:"attr",
        definingClass:"class:DynamicForm",
        valueType:"OperatorId",
        description:"Default ${isc.DocUtils.linkForRef('type:OperatorId','search operator')} to use for fields in a form that produces\n ${isc.DocUtils.linkForRef('object:AdvancedCriteria')}.  Default is \"iContains\" unless ${isc.DocUtils.linkForRef('attr:DynamicForm.allowExpressions')} is\n enabled for the form as a whole, in which case the default is\n ${isc.DocUtils.linkForRef('attr:DataSource.translatePatternOperators','\"iContainsPattern\"')}.\n <p>\n Does not apply to special fields where exact match is obviously the right default\n setting, such as fields of type:\"enum\", or fields with a\n ${isc.DocUtils.linkForRef('attr:FormItem.valueMap','valueMap')} or  ${isc.DocUtils.linkForRef('attr:FormItem.optionDataSource','optionDataSource')}.\n <p>\n <code>defaultSearchOperator</code> also has no effect in a form that does not produce\n <code>AdvancedCriteria</code> - see ${isc.DocUtils.linkForRef('method:DynamicForm.getValuesAsCriteria')} for\n settings that cause a form to produce AdvancedCriteria.",
        flags:"IR",
        name:"defaultSearchOperator"
    },
    "attr:ResultSet.reapplyUnchangedLocalFilter":{
        seeAlso:[
            {
                ref:"method:ResultSet.willFetchData",
                description:null
            }
        ],
        ref:"attr:ResultSet.reapplyUnchangedLocalFilter",
        defaultValue:"null",
        deprecated:null,
        type:"attr",
        definingClass:"class:ResultSet",
        valueType:"boolean",
        description:"To avoid needless work, the ResultSet by default doesn't refilter the data when methods such\n as ${isc.DocUtils.linkForRef('method:ListGrid.fetchData')} or ${isc.DocUtils.linkForRef('method:ListGrid.filterData')} are called with unchanged\n criteria.  However, this property can be set true for backward compatibility to force\n refiltering if we're ${isc.DocUtils.linkForRef('method:ResultSet.filterLocalData','filtering locally')} and the criteria haven't\n changed. but are narrower than the criteria used to fetch the current cache.\n <P>\n Going forward, we may deprecate this property, so you should move to approach that\n doesn't require such notification in the case of unchanged criteria.",
        flags:"IRWA",
        name:"reapplyUnchangedLocalFilter"
    },
    "method:DrawItem.moveBy":{
        seeAlso:[
        ],
        ref:"method:DrawItem.moveBy",
        deprecated:null,
        type:"method",
        definingClass:"class:DrawItem",
        params:[
            {
                defaultValue:null,
                optional:false,
                type:"int",
                description:"change to left coordinate in pixels",
                name:"dX"
            },
            {
                defaultValue:null,
                optional:false,
                type:"int",
                description:"change to top coordinate in pixels",
                name:"dY"
            }
        ],
        description:" Move the shape by the specified deltas for the left and top coordinate.\n\n",
        flags:"",
        name:"moveBy"
    },
    "classAttr:GroupingMessages.timezoneMinutesSuffix":{
        seeAlso:[
        ],
        defaultValue:"\"minutes\"",
        type:"classAttr",
        definingClass:"class:GroupingMessages",
        groups:[
            "i18nMessages"
        ],
        deprecated:null,
        ref:"classAttr:GroupingMessages.timezoneMinutesSuffix",
        valueType:"String",
        description:"Suffix to append to the timezoneMinutes grouping mode",
        flags:"IRW",
        name:"timezoneMinutesSuffix"
    },
    "attr:Mail.messageTemplate":{
        seeAlso:[
        ],
        defaultValue:"null",
        type:"attr",
        definingClass:"class:Mail",
        groups:[
            "mail"
        ],
        ref:"attr:Mail.messageTemplate",
        deprecated:null,
        valueType:"VelocityExpression",
        description:"The text that will form the body of the mail message.  Like all other <code>String</code> \n properties of <code>Mail</code>, you can use Velocity substitution variables in this property.\n <p>\n You must specify either this property or ${isc.DocUtils.linkForRef('attr:Mail.templateFile','templateFile')}, but clearly\n it makes no sense to specify them both.",
        flags:"IR",
        serverDS:"only",
        name:"messageTemplate"
    },
    "method:CubeGrid.getColumnFacetValues":{
        seeAlso:[
        ],
        ref:"method:CubeGrid.getColumnFacetValues",
        deprecated:null,
        type:"method",
        definingClass:"class:CubeGrid",
        params:[
            {
                defaultValue:null,
                optional:false,
                type:"number",
                description:"index of the column",
                name:"colNum"
            }
        ],
        description:" Return a ${isc.DocUtils.linkForRef('object:FacetValueMap')} indicating the facet values for a specific \n column in the grid.\n",
        flags:"",
        returns:{
            type:"FacetValueMap",
            description:"facet values for the specified column. Returns null if the specified       column is not present in the grid."
        },
        name:"getColumnFacetValues"
    },
    "type:RowSpanSelectionMode":{
        seeAlso:[
        ],
        ref:"type:RowSpanSelectionMode",
        deprecated:null,
        type:"type",
        values:[
            {
                value:"\"forward\"",
                description:"when a cell is clicked on, select any cells in subsequent columns which                  are at least partially spanned by the clicked cell"
            },
            {
                value:"\"both\"",
                description:"when a cell is clicked on, selects any cells in any other columns which                  are at least partially spanned by the clicked cell"
            },
            {
                value:"\"outerSpan\"",
                description:"behaves like \"forward\", except as though the cell in the first column                    was clicked instead.  If the largest row spans are in the first\n                    column and all cells in subsequent columns do not extend out of the\n                    first cell's span, this creates a row-like selection model where the\n                    span of the left-most cell defines the \"row\" of cells being selected."
            }
        ],
        description:"Behavior of selection when row spanning is active.  See ${isc.DocUtils.linkForRef('attr:ListGrid.useRowSpanStyling')}.",
        name:"RowSpanSelectionMode"
    },
    "classAttr:FieldPickerField.alignTitle":{
        seeAlso:[
        ],
        defaultValue:"\"Header Text Alignment\"",
        type:"classAttr",
        definingClass:"class:FieldPickerField",
        groups:[
            "i18nMessages"
        ],
        deprecated:null,
        ref:"classAttr:FieldPickerField.alignTitle",
        valueType:"String",
        description:"The title displayed for the align property",
        flags:"IR",
        name:"alignTitle"
    },
    "method:Calendar.getWorkdayEnd":{
        seeAlso:[
        ],
        ref:"method:Calendar.getWorkdayEnd",
        deprecated:null,
        type:"method",
        definingClass:"class:Calendar",
        params:[
            {
                defaultValue:null,
                optional:false,
                type:"Date",
                description:"a Date instance",
                name:"date"
            },
            {
                defaultValue:null,
                optional:true,
                type:"String",
                description:"the name of the relevant lane - only passed for dayView with                             showDayLanes: true",
                name:"laneName"
            }
        ],
        description:" Returns the end of the working day on the passed date.  By default, this method returns\n the value of ${isc.DocUtils.linkForRef('attr:Calendar.workdayEnd','workdayEnd')}.\n",
        flags:"",
        returns:{
            type:"String",
            description:"any parsable time-string"
        },
        name:"getWorkdayEnd"
    },
    "type:Float":{
        seeAlso:[
            {
                ref:"type:float",
                description:null
            }
        ],
        ref:"type:Float",
        treeLocation:[
            "Client Reference/System"
        ],
        deprecated:null,
        type:"type",
        description:"A decimal (or \"floating point\") number, for example, 5.5.  Null is allowed.",
        name:"Float",
        baseType:"Number"
    },
    "attr:FilterBuilder.operatorPickerProperties":{
        seeAlso:[
        ],
        ref:"attr:FilterBuilder.operatorPickerProperties",
        defaultValue:"null",
        deprecated:null,
        type:"attr",
        definingClass:"class:FilterBuilder",
        valueType:"FormItem Properties",
        description:"Properties to combine with the ${isc.DocUtils.linkForRef('attr:FilterBuilder.operatorPicker')} autoChild FormItem.",
        flags:"IR",
        name:"operatorPickerProperties"
    },
    "method:DynamicForm.setValues":{
        groups:[
            "formValues"
        ],
        seeAlso:[
        ],
        ref:"method:DynamicForm.setValues",
        deprecated:null,
        type:"method",
        definingClass:"class:DynamicForm",
        params:[
            {
                defaultValue:null,
                optional:true,
                type:"Object",
                description:"values for the form, or null to reset all items to default values",
                name:"newData"
            }
        ],
        description:" Replaces the current values of the entire form with the values passed in.\n <P>\n Note: when working with a form that is saving to a DataSource, you would typically call\n either ${isc.DocUtils.linkForRef('method:DynamicForm.editRecord')} for an existing record, or ${isc.DocUtils.linkForRef('method:DynamicForm.editNewRecord')} for a new\n record.  In addition to setting the current values of the form, these APIs establish the\n ${isc.DocUtils.linkForRef('attr:DSRequest.operationType')} used to save (\"update\" vs \"add\").\n <P>\n Values should be provided as an Object containing the new values as properties, where each\n propertyName is the name of a ${isc.DocUtils.linkForRef('group:Items','form item')} in the form, and each property value is\n the value to apply to that form item via ${isc.DocUtils.linkForRef('method:FormItem.setValue')}. \n <P>\n Values with no corresponding form item may also be passed, will be tracked by the form\n and returned by subsequent calls to ${isc.DocUtils.linkForRef('method:DynamicForm.getValues')}.\n <P>\n Any ${isc.DocUtils.linkForRef('class:FormItem')} for which a value is not provided will revert to its\n ${isc.DocUtils.linkForRef('attr:FormItem.defaultValue','defaultValue')}.  To cause all FormItems to revert to default\n values, pass null.\n <P>\n This method also calls ${isc.DocUtils.linkForRef('method:DynamicForm.rememberValues')} so that a subsequent later call to\n ${isc.DocUtils.linkForRef('method:DynamicForm.resetValues')} will revert to the passed values.\n\n",
        flags:"",
        name:"setValues"
    },
    "type:PositiveInteger":{
        seeAlso:[
        ],
        ref:"type:PositiveInteger",
        treeLocation:[
            "Client Reference/System"
        ],
        deprecated:null,
        type:"type",
        description:"A positive whole number or 0, for example, 5.  Negative values are not allowed.  Null is\n allowed.",
        name:"PositiveInteger",
        baseType:"Integer"
    },
    "method:Calendar.showNewEventEditor":{
        seeAlso:[
        ],
        ref:"method:Calendar.showNewEventEditor",
        deprecated:null,
        type:"method",
        definingClass:"class:Calendar",
        params:[
            {
                defaultValue:null,
                optional:true,
                type:"CalendarEvent",
                description:"defaults for the new event to show in the Editor",
                name:"event"
            }
        ],
        description:" Show an Event Editor for a new event.  If an ${isc.DocUtils.linkForRef('object:CalendarEvent','event')} is passed as the \n parameter, it is used as defaults for the new event.\n \n",
        flags:"",
        name:"showNewEventEditor"
    },
    "attr:TreeMenuButton.dataProperties":{
        seeAlso:[
        ],
        defaultValue:"null",
        type:"attr",
        definingClass:"class:TreeMenuButton",
        groups:[
            "databinding"
        ],
        deprecated:null,
        ref:"attr:TreeMenuButton.dataProperties",
        valueType:"Tree",
        description:"For a <code>TreeMenuButton</code> that uses a DataSource, these properties will be passed to\n the automatically-created ResultTree.  This can be used for various customizations such as\n modifying the automatically-chosen ${isc.DocUtils.linkForRef('attr:Tree.parentIdField')}.",
        flags:"IR",
        name:"dataProperties"
    },
    "classAttr:Operators.iEqualsTitle":{
        seeAlso:[
        ],
        defaultValue:"\"equals\"",
        type:"classAttr",
        definingClass:"class:Operators",
        groups:[
            "i18nMessages"
        ],
        deprecated:null,
        ref:"classAttr:Operators.iEqualsTitle",
        valueType:"String",
        description:"Title for the \"iEquals\" operator",
        flags:"IR",
        name:"iEqualsTitle"
    },
    "attr:FacetChart.valueAxisLabelProperties":{
        seeAlso:[
        ],
        ref:"attr:FacetChart.valueAxisLabelProperties",
        defaultValue:"null",
        deprecated:null,
        type:"attr",
        definingClass:"class:FacetChart",
        valueType:"DrawLabel Properties",
        description:"Properties for labels of value axis.",
        flags:"IRW",
        name:"valueAxisLabelProperties"
    },
    "attr:ListGrid.wrapHeaderSpanTitles":{
        seeAlso:[
            {
                ref:"attr:ListGrid.minFieldWidth",
                description:null
            }
        ],
        ref:"attr:ListGrid.wrapHeaderSpanTitles",
        defaultValue:"null",
        deprecated:null,
        type:"attr",
        definingClass:"class:ListGrid",
        valueType:"Boolean",
        description:"If ${isc.DocUtils.linkForRef('attr:HeaderSpan.wrap')} is not explicitly set, should fields wrap?  If autofitting,\n see the docs on that property for the details of how the minimum width for a field is\n determined.",
        flags:"IR",
        name:"wrapHeaderSpanTitles"
    },
    "method:List.indexOf":{
        seeAlso:[
        ],
        type:"method",
        definingClass:"interface:List",
        returns:{
            type:"number",
            description:"position of the item, if found, -1 if not found"
        },
        groups:[
            "access"
        ],
        deprecated:null,
        ref:"method:List.indexOf",
        params:[
            {
                defaultValue:null,
                optional:false,
                type:"Any",
                description:"object to look for",
                name:"obj"
            },
            {
                defaultValue:null,
                optional:true,
                type:"number",
                description:"earliest index to consider",
                name:"pos"
            },
            {
                defaultValue:null,
                optional:true,
                type:"number",
                description:"last index to consider",
                name:"endPos"
            }
        ],
        description:" Return the position in the list of the first instance of the specified object.\n <p>\n If pos is specified, starts looking after that position.\n <p>\n Returns -1 if not found.\n\n",
        flags:"",
        name:"indexOf"
    },
    "attr:Hilite.fieldName":{
        seeAlso:[
        ],
        defaultValue:"null",
        type:"attr",
        definingClass:"object:Hilite",
        groups:[
            "hiliting"
        ],
        deprecated:null,
        ref:"attr:Hilite.fieldName",
        valueType:"FieldName | Array of FieldName",
        description:"Name of the field, or array of fieldNames, this hilite should be applied to.  \n <P>\n If unset, hilite is applied to every field of the record.",
        flags:"IR",
        name:"fieldName"
    },
    "method:DynamicForm.getFieldErrors":{
        seeAlso:[
        ],
        type:"method",
        definingClass:"class:DynamicForm",
        returns:{
            type:"String | Array of String",
            description:"Error message string, or if there is more than one error      associated with this field, array of error message strings."
        },
        groups:[
            "errors"
        ],
        deprecated:null,
        ref:"method:DynamicForm.getFieldErrors",
        params:[
            {
                defaultValue:null,
                optional:false,
                type:"String",
                description:"fieldName to check for errors",
                name:"fieldName"
            }
        ],
        description:" Returns any errors that are currently visible to the user for the specified field in this\n form, without performing validation.\n\n",
        flags:"",
        name:"getFieldErrors"
    },
    "attr:Slider.flipValues":{
        seeAlso:[
        ],
        defaultValue:"false",
        type:"attr",
        definingClass:"class:Slider",
        deprecated:null,
        ref:"attr:Slider.flipValues",
        setter:[
            "setFlipValues"
        ],
        valueType:"Boolean",
        description:"Specifies whether the value range of the slider should be flipped so that values increase as\n the thumb is moved down (for a ${isc.DocUtils.linkForRef('attr:Slider.vertical','vertical')} slider) or to the left \n (for a horizontal slider).",
        flags:"IRW",
        name:"flipValues"
    },
    "method:GridRenderer.rowOut":{
        seeAlso:[
        ],
        type:"method",
        definingClass:"class:GridRenderer",
        returns:{
            type:"boolean",
            description:"whether to cancel the event"
        },
        groups:[
            "events"
        ],
        deprecated:null,
        ref:"method:GridRenderer.rowOut",
        params:[
            {
                defaultValue:null,
                optional:false,
                type:"ListGridRecord",
                description:"cell record as returned by getCellRecord",
                name:"record"
            },
            {
                defaultValue:null,
                optional:false,
                type:"number",
                description:"row number for the cell",
                name:"rowNum"
            },
            {
                defaultValue:null,
                optional:false,
                type:"number",
                description:"column number of the cell",
                name:"colNum"
            }
        ],
        description:" Called when the mouse pointer leaves a row\n\n",
        flags:"A",
        name:"rowOut"
    },
    "method:ValuesManager.getValuesAsCriteria":{
        seeAlso:[
        ],
        type:"method",
        definingClass:"class:ValuesManager",
        returns:{
            type:"Criteria | AdvancedCriteria",
            description:"a ${isc.DocUtils.linkForRef('type:Criteria')} object, or ${isc.DocUtils.linkForRef('object:AdvancedCriteria')}"
        },
        groups:[
            "criteriaEditing"
        ],
        deprecated:null,
        ref:"method:ValuesManager.getValuesAsCriteria",
        params:[
            {
                defaultValue:null,
                optional:false,
                type:"boolean",
                description:"if true, return an ${isc.DocUtils.linkForRef('object:AdvancedCriteria')} object even if the   form item values could be represented in a simple ${isc.DocUtils.linkForRef('object:Criterion')} object.",
                name:"advanced"
            },
            {
                defaultValue:null,
                optional:true,
                type:"TextMatchStyle",
                description:"This parameter may be passed to indicate whether   the criteria are to be applied to a substring match (filter) or exact match (fetch).\n   When advanced criteria are returned this parameter will cause the appropriate\n   <code>operator</code> to be generated for individual fields' criterion clauses.",
                name:"textMatchStyle"
            }
        ],
        description:" Retrieves the combined ${isc.DocUtils.linkForRef('method:DynamicForm.getValuesAsCriteria','criteria values')} \n for all member forms.\n <P>\n As with the DynamicForm getValuesAsCriteria, this method may return\n ${isc.DocUtils.linkForRef('object:AdvancedCriteria')} or simple ${isc.DocUtils.linkForRef('type:Criteria')} depending on whether\n the <code>advanced</code> parameter was passed, whether the ${isc.DocUtils.linkForRef('attr:ValuesManager.operator')}\n is set to <code>\"or\"</code> rather than <code>\"and\"</code>, and whether any member\n forms return ${isc.DocUtils.linkForRef('object:AdvancedCriteria')}.\n <P>\n Note that developers can also use ${isc.DocUtils.linkForRef('classMethod:DataSource.combineCriteria')} to combine\n sub-criteria from various sources, including member forms of a ValuesManager, into\n a combined criteria object.\n\n",
        flags:"",
        name:"getValuesAsCriteria"
    },
    "attr:SpinnerItem.mask":{
        seeAlso:[
        ],
        ref:"attr:SpinnerItem.mask",
        defaultValue:"null",
        deprecated:null,
        type:"attr",
        definingClass:"class:SpinnerItem",
        valueType:"String",
        description:"Not applicable to a SpinnerItem.",
        flags:"IRWA",
        name:"mask"
    },
    "attr:ListGrid.escapeKeyEditAction":{
        seeAlso:[
        ],
        defaultValue:"\"cancel\"",
        type:"attr",
        definingClass:"class:ListGrid",
        groups:[
            "editing"
        ],
        deprecated:null,
        ref:"attr:ListGrid.escapeKeyEditAction",
        valueType:"EscapeKeyEditAction",
        description:"What to do when a user hits escape while editing a cell:<ul>\n <li>\"cancel\": close the editor and discard the current set of edit values\n <li>\"done\": just close the editor (the edit is complete, but the edited values are retained).\n </ul>\n Note that if ${isc.DocUtils.linkForRef('attr:ListGrid.autoSaveEdits')} is true, this may cause a save of the current edit values",
        flags:"IRW",
        name:"escapeKeyEditAction"
    },
    "group:creation":{
        refs:[
            "method:Tree.duplicate"
        ],
        seeAlso:[
        ],
        ref:"group:creation",
        deprecated:null,
        type:"group",
        description:null,
        name:"creation"
    },
    "attr:MetricSettings.logScale":{
        seeAlso:[
        ],
        ref:"attr:MetricSettings.logScale",
        defaultValue:"false",
        deprecated:null,
        type:"attr",
        definingClass:"object:MetricSettings",
        valueType:"Boolean",
        description:"Whether to use logarithmic scaling for values.\n <P>\n Logarithmic scale charts show an equivalent percentage increase as equivalent distance\n on the chart.  That is, 10 and 100 are the same distance apart as 100 and 1000 (each\n being a 10 times or 1000% increase).",
        flags:"IR",
        name:"logScale"
    },
    "method:EditContext.getRootEditNode":{
        seeAlso:[
        ],
        ref:"method:EditContext.getRootEditNode",
        deprecated:null,
        type:"method",
        definingClass:"class:EditContext",
        description:" Returns the root ${isc.DocUtils.linkForRef('object:EditNode')} of the EditContext typically created from ${isc.DocUtils.linkForRef('attr:EditContext.rootComponent')}.\n\n",
        flags:"",
        returns:{
            type:"EditNode",
            description:"the root EditNode"
        },
        name:"getRootEditNode"
    },
    "type:AutoSelectionModel":{
        seeAlso:[
        ],
        ref:"type:AutoSelectionModel",
        deprecated:null,
        type:"type",
        values:[
            {
                value:"\"both\"",
                description:"Rows and Columns will be selected on header selection"
            },
            {
                value:"\"rows\"",
                description:"Rows will be selected on row-header selection"
            },
            {
                value:"\"cols\"",
                description:"Columns will be selected on column-header selection"
            },
            {
                value:"\"none\"",
                description:"Selecting row or column headers will not select cells in the body."
            }
        ],
        description:"Selection model for ${isc.DocUtils.linkForRef('class:CubeGrid')} indicating which cells in the body should\n be selected when row or column headers are selected.",
        name:"AutoSelectionModel"
    },
    "attr:Portlet.canDrop":{
        seeAlso:[
        ],
        defaultValue:"true",
        type:"attr",
        definingClass:"class:Portlet",
        deprecated:null,
        ref:"attr:Portlet.canDrop",
        valueType:"boolean",
        description:"Portlets have canDrop set to true to enable drag/drop reposition within the portalLayout",
        flags:"IRW",
        examples:[
            "${isc.DocUtils.linkForExampleId('repositionPortlets')}"
        ],
        name:"canDrop"
    },
    "group:facetLayout":{
        refs:[
            "method:CubeGrid.getFacetValueLayout",
            "method:CubeGrid.getRowFacetLayout",
            "method:CubeGrid.getColumnFacetLayout",
            "method:CubeGrid.addRowFacet",
            "method:CubeGrid.addColumnFacet",
            "method:CubeGrid.removeFacet",
            "method:CubeGrid.setFixedFacetValue",
            "method:CubeGrid.facetValueReordered",
            "method:CubeGrid.facetAdded",
            "method:CubeGrid.facetRemoved",
            "method:CubeGrid.facetMoved",
            "attr:CubeGrid.columnFacets",
            "attr:CubeGrid.rowFacets",
            "attr:CubeGrid.hideEmptyFacetValues",
            "attr:CubeGrid.hideEmptyAxis",
            "attr:CubeGrid.canReorderColumns",
            "attr:CubeGrid.canMoveFacets"
        ],
        seeAlso:[
        ],
        ref:"group:facetLayout",
        deprecated:null,
        type:"group",
        description:null,
        name:"facetLayout"
    },
    "classMethod:Page.isAddVersionToSkinCSS":{
        groups:[
            "skins",
            "files"
        ],
        seeAlso:[
        ],
        ref:"classMethod:Page.isAddVersionToSkinCSS",
        deprecated:null,
        type:"classMethod",
        definingClass:"class:Page",
        description:" Returns true if add version to skin CSS is currently turned on.\n\n",
        flags:"",
        returns:{
            type:"Boolean",
            description:"true == add version to skin CSS is turned on"
        },
        name:"isAddVersionToSkinCSS"
    },
    "method:NativeScrollbar.setScrollTarget":{
        groups:[
            "scroll"
        ],
        seeAlso:[
        ],
        ref:"method:NativeScrollbar.setScrollTarget",
        deprecated:null,
        type:"method",
        definingClass:"class:NativeScrollbar",
        params:[
            {
                defaultValue:null,
                optional:true,
                type:"Canvas",
                description:"target canvas to be scrolled",
                name:"newTarget"
            }
        ],
        description:"          Sets or clears the scrollbar's scrollTarget. If no argument is provided, then the\n          scrollTarget will be set to the scrollbar itself.\n\n",
        flags:"",
        name:"setScrollTarget"
    },
    "attr:DrawItem.resizeViaLocalTransformOnly":{
        seeAlso:[
        ],
        ref:"attr:DrawItem.resizeViaLocalTransformOnly",
        defaultValue:"false",
        deprecated:null,
        type:"attr",
        definingClass:"class:DrawItem",
        valueType:"boolean",
        description:"If this DrawItem is showing \"resize\"\n \n ${isc.DocUtils.linkForRef('attr:DrawItem.knobs','control knobs')}, should resizing the shape solely update the local\n transform (for example, the DrawItem's ${isc.DocUtils.linkForRef('attr:DrawItem.scale','scale')} or\n ${isc.DocUtils.linkForRef('attr:DrawItem.translate','translation')})?.\n <p>\n The default is <code>false</code>, which means that the DrawItem is allowed to modify\n its shape properties in order to fit within a given width and height.  Some examples:\n <ul>\n <li>A ${isc.DocUtils.linkForRef('class:DrawOval','DrawOval')} might decrease its ${isc.DocUtils.linkForRef('attr:DrawOval.radius','radius')}\n when resized to a smaller size.</li>\n <li>A ${isc.DocUtils.linkForRef('class:DrawPath','DrawPath')} might change its ${isc.DocUtils.linkForRef('attr:DrawPath.points','points')}\n to lengthen all line segments in the path by some proportion so that it fits into a\n larger size.</li>\n </ul>\n This approach allows a DrawItem to maintain the same\n ${isc.DocUtils.linkForRef('attr:DrawItem.lineWidth','line width')} even as it is being resized.\n <p>\n If this property is set to <code>true</code> then all visual aspects of the DrawItem,\n including the line width and the fill, will be magnified or reduced during resizes\n as if the DrawItem were placed under a lens.",
        flags:"IR",
        name:"resizeViaLocalTransformOnly"
    },
    "attr:MultiFileItem.pickerUploadButtonInitialTitle":{
        seeAlso:[
            {
                ref:"attr:MultiFileItem.pickerUploadButtonTitle",
                description:null
            }
        ],
        defaultValue:"\"OK\"",
        type:"attr",
        definingClass:"class:MultiFileItem",
        groups:[
            "i18nMessages"
        ],
        deprecated:null,
        ref:"attr:MultiFileItem.pickerUploadButtonInitialTitle",
        valueType:"String",
        description:"The initial title of the upload button in the picker lauched by the\n ${isc.DocUtils.linkForRef('attr:MultiFileItem.editButton','edit button')} that is used before the form is saved.",
        flags:"IR",
        name:"pickerUploadButtonInitialTitle"
    },
    "attr:PaletteNode.editNodeProperties":{
        seeAlso:[
        ],
        ref:"attr:PaletteNode.editNodeProperties",
        defaultValue:"null",
        deprecated:null,
        type:"attr",
        definingClass:"object:PaletteNode",
        valueType:"EditNode Properties",
        description:"Properties to be applied to the ${isc.DocUtils.linkForRef('object:EditNode','editNode')} when created.",
        flags:"IR",
        name:"editNodeProperties"
    },
    "attr:DynamicForm.fileAccessFailedWarning":{
        seeAlso:[
        ],
        defaultValue:"\"Unable to access the selected file(s) for upload. Please re-select the file and try again.\"",
        type:"attr",
        definingClass:"class:DynamicForm",
        groups:[
            "i18nMessages"
        ],
        deprecated:null,
        ref:"attr:DynamicForm.fileAccessFailedWarning",
        valueType:"String",
        description:"Warning to display to the user if a selected file in an UploadItem cannot be accessed.\n This will be displayed on form submission when the browser is unable to access the\n selected file for upload.\n <P>\n Typically this indicates a browser-level security restriction - for example the file has been edited\n on the disk, or had its permissions changed after the user selected it, but before they \n attempted to submit the form.\n <P>\n When this occurs the selected file will be cleared from the upload item and this message will be\n displayed to the user in a ${isc.DocUtils.linkForRef('staticMethod:isc.warn','warn dialog')}.",
        flags:"IRW",
        name:"fileAccessFailedWarning"
    },
    "group:tabBar":{
        refs:[
            "attr:TabSet.tabBarPosition",
            "attr:TabSet.tabBarAlign",
            "attr:TabSet.tabBarThickness",
            "attr:TabSet.selectedTab",
            "attr:TabSet.canCloseTabs"
        ],
        seeAlso:[
        ],
        ref:"group:tabBar",
        deprecated:null,
        type:"group",
        description:null,
        name:"tabBar"
    },
    "attr:DrawItem.titleAutoFitRotationMode":{
        seeAlso:[
            {
                ref:"attr:DrawItem.titleLabel",
                description:null
            },
            {
                ref:"attr:DrawItem.titleAutoFit",
                description:null
            }
        ],
        ref:"attr:DrawItem.titleAutoFitRotationMode",
        defaultValue:"\"auto\"",
        deprecated:null,
        type:"attr",
        definingClass:"class:DrawItem",
        valueType:"TitleAutoFitRotationMode",
        description:"Whether to rotate the ${isc.DocUtils.linkForRef('attr:DrawItem.titleLabel')} 90 degrees clockwise while trying to maximize its\n size in accordance with ${isc.DocUtils.linkForRef('attr:DrawItem.titleAutoFit')}.  If automatic rotation is specified, the\n default, the label will be rotated if and only if it allows the label to become larger.",
        flags:"IR",
        name:"titleAutoFitRotationMode"
    },
    "method:EventCanvas.getBodyHTML":{
        groups:[
            "appearance"
        ],
        seeAlso:[
        ],
        ref:"method:EventCanvas.getBodyHTML",
        deprecated:null,
        type:"method",
        definingClass:"class:EventCanvas",
        description:" Return the HTML to show in the body of this EventCanvas.  The default implementation \n calls ${isc.DocUtils.linkForRef('method:Calendar.getEventBodyHTML')}, which returns the value of the \n ${isc.DocUtils.linkForRef('attr:Calendar.descriptionField','description field')} for the current \n ${isc.DocUtils.linkForRef('object:CalendarEvent','event')}.\n\n",
        flags:"",
        returns:{
            type:"HTMLString",
            description:"HTML to display in the body of the canvas"
        },
        name:"getBodyHTML"
    },
    "attr:FormItem.rowSpan":{
        seeAlso:[
        ],
        defaultValue:"1",
        type:"attr",
        definingClass:"class:FormItem",
        groups:[
            "formLayout"
        ],
        deprecated:null,
        ref:"attr:FormItem.rowSpan",
        valueType:"number",
        description:"Number of rows that this item spans",
        flags:"IRW",
        name:"rowSpan"
    },
    "attr:DSRequest.additionalOutputs":{
        seeAlso:[
        ],
        ref:"attr:DSRequest.additionalOutputs",
        defaultValue:"null",
        deprecated:null,
        type:"attr",
        definingClass:"object:DSRequest",
        valueType:"String",
        description:"For fetch, add or update operation, an optional comma separated list of fields to fetch from another,\n related DataSource.\n <P>\n Fields should be specified in the format \n <code>\"localFieldName!relatedDataSourceID.relatedDataSourceFieldName\"</code>.\n where <code><i>relatedDataSourceID</i></code> is the ID of the related dataSource, and\n <code><i>relatedDataSourceFieldName</i></code> is the field for which you want to\n fetch related values. The returned field values will be stored on \n the data returned to the client under the specified <code><i>localFieldName</i></code>.\n Note that this will be applied in addition to any specified ${isc.DocUtils.linkForRef('attr:DSRequest.outputs')}.\n <P>\n Note that as with ${isc.DocUtils.linkForRef('attr:DataSourceField.includeFrom')}, the related dataSource must be\n linked to the primary datasource via a foreignKey relationship.\n <P>\n Note additionalOutputs sent in request from the browser can be completely disabled in \n ${isc.DocUtils.linkForRef('group:server_properties','server.properties')} by setting\n <code>datasource.allowClientAdditionalOutputs</code>:\n <pre>\n     datasource.allowClientAdditionalOutputs: false\n </pre>\n In this case ${isc.DocUtils.linkForRef('attr:DSRequest.additionalOutputs')} sent from the browser will be cleared before \n executing request. Note that programatically configured additionalOutputs are always allowed, but \n you can't modify them from within a DMI method, so the only way to execute a request \n with additionalOutputs that differ from what was sent by the client is to create a new DSRequest",
        flags:"IRA",
        name:"additionalOutputs"
    },
    "method:ColumnTree.getSelectedRecord":{
        seeAlso:[
        ],
        ref:"method:ColumnTree.getSelectedRecord",
        deprecated:null,
        type:"method",
        definingClass:"class:ColumnTree",
        description:" Get the selected record, that is, the parent of the nodes in the rightmost visible column.\n <P>\n This is generally the most recently clicked node unless programmatic navigation has taken\n place.\n <P>\n If only the first column is showing, the root node is returned (which can be detected via\n ${isc.DocUtils.linkForRef('method:Tree.isRoot')}).\n\n",
        flags:"",
        returns:{
            type:"Record",
            description:"the selected record"
        },
        name:"getSelectedRecord"
    },
    "attr:UploadItem.textBoxStyle":{
        seeAlso:[
            {
                ref:"attr:FormItem.cellStyle",
                description:null
            }
        ],
        defaultValue:"\"uploadItem\"",
        type:"attr",
        definingClass:"class:UploadItem",
        groups:[
            "formItemStyling"
        ],
        deprecated:null,
        ref:"attr:UploadItem.textBoxStyle",
        valueType:"FormItemBaseStyle",
        description:"Base CSS class name for this <code>UploadItem</code>'s native file input element.\n <p>\n Note that the customization via CSS of a native file input element allowable by the\n browser varies widely; in some browsers on certain platforms, it may be possible to\n customize certain CSS properties, but not in others; or, it may be that the CSS property\n (e.g. border) is applied differently in some browsers.\n <p>\n If the textBoxStyle is changed at runtime, ${isc.DocUtils.linkForRef('method:FormItem.updateState')} must be called\n to update the visual state. However, calling updateState() will clear any file selected\n by the user to be uploaded.",
        flags:"IRW",
        name:"textBoxStyle"
    },
    "method:StatefulCanvas.getStateSuffix":{
        seeAlso:[
        ],
        ref:"method:StatefulCanvas.getStateSuffix",
        deprecated:null,
        type:"method",
        definingClass:"class:StatefulCanvas",
        description:" Returns the suffix that will be appended to the ${isc.DocUtils.linkForRef('attr:StatefulCanvas.baseStyle')}  \n as the component changes ${isc.DocUtils.linkForRef('attr:StatefulCanvas.state')} and/or is selected / focused.\n <P>\n Note that suffixes will only be included if the relevant <code>show<i>[StateName]</i></code>\n attributes (EG ${isc.DocUtils.linkForRef('attr:StatefulCanvas.showRollOver')}, ${isc.DocUtils.linkForRef('attr:StatefulCanvas.showFocused')}, etc) are set to true.\n <P>\n The following table lists out the standard set of suffixes which may be applied \n to the base style:\n <table border=1>\n <tr><td><b>CSS Class Applied</b></td><td><b>Description</b></td></tr>\n <tr><td><code><i>baseStyle</i></code></td><td>Default css style</td></tr>\n <tr><td><code><i>baseStyle</i>+Selected</code></td>\n      <td>Applied when ${isc.DocUtils.linkForRef('attr:StatefulCanvas.selected')} is set to true.</td></tr>\n <tr><td><code><i>baseStyle</i>+Focused</code></td>\n      <td>Applied when the component has keyboard focus, if \n      ${isc.DocUtils.linkForRef('attr:StatefulCanvas.showFocused')} is true, and \n      ${isc.DocUtils.linkForRef('attr:StatefulCanvas.showFocusedAsOver')} is not true.</td></tr>\n <tr><td><code><i>baseStyle</i>+Over</code></td>\n      <td>Applied when ${isc.DocUtils.linkForRef('attr:StatefulCanvas.showRollOver')} is set to true and either the user\n      rolls over the component or ${isc.DocUtils.linkForRef('attr:StatefulCanvas.showFocusedAsOver')} is true and the\n      component has keyboard focus.</td></tr>\n <tr><td><code><i>baseStyle</i>+Down</code></td>\n      <td>Applied when the user presses the mouse button on the component if\n          ${isc.DocUtils.linkForRef('attr:StatefulCanvas.showDown')} is set to true</td></tr>\n <tr><td><code><i>baseStyle</i>+Disabled</code></td>\n      <td>Applied when the component is ${isc.DocUtils.linkForRef('attr:Canvas.disabled','disabled')}\n       if ${isc.DocUtils.linkForRef('attr:StatefulCanvas.showDisabled')} is true.</td></tr>\n <tr><td colspan=2><i>Combined styles</i></td></tr>\n <tr><td><code><i>baseStyle</i>+SelectedFocused</code></td>\n      <td>Combined Selected and focused styling</td></tr>\n <tr><td><code><i>baseStyle</i>+SelectedOver</code></td>\n      <td>Combined Selected and rollOver styling</td></tr>\n <tr><td><code><i>baseStyle</i>+FocusedOver</code></td>\n      <td>Combined Focused and rollOver styling</td></tr>\n <tr><td><code><i>baseStyle</i>+SelectedFocusedOver</code></td>\n      <td>Combined Selected, Focused and rollOver styling</td></tr>\n <tr><td><code><i>baseStyle</i>+SelectedDown</code></td>\n      <td>Combined Selected and mouse-down styling</td></tr>\n <tr><td><code><i>baseStyle</i>+FocusedDown</code></td>\n      <td>Combined Focused and mouse-down styling</td></tr>\n <tr><td><code><i>baseStyle</i>+SelectedFocusedDown</code></td>\n      <td>Combined Selected, Focused and mouse-down styling</td></tr>\n <tr><td><code><i>baseStyle</i>+SelectedDisabled</code></td>\n      <td>Combined Selected and Disabled styling</td></tr>\n </table>\n\n",
        flags:"",
        returns:{
            type:"String",
            description:"suffix to be appended to the baseStyle"
        },
        name:"getStateSuffix"
    },
    "class:AutoFitTextAreaItem":{
        seeAlso:[
        ],
        type:"class",
        staticMethods:[
        ],
        inheritsFrom:"TextAreaItem",
        classMethods:[
        ],
        classAttrs:[
        ],
        attrs:[
            "attr:AutoFitTextAreaItem.maxHeight"
        ],
        ref:"class:AutoFitTextAreaItem",
        deprecated:null,
        description:"Class for editable multi-line text areas (uses HTML <code>&lt;TEXTAREA&gt;</code> object)\n automatically expands to accomodate its content",
        methods:[
        ],
        examples:[
            "${isc.DocUtils.linkForExampleId('textAreaItem')}"
        ],
        name:"AutoFitTextAreaItem"
    },
    "classMethod:Class.logIsInfoEnabled":{
        seeAlso:[
        ],
        ref:"classMethod:Class.logIsInfoEnabled",
        deprecated:null,
        type:"classMethod",
        definingClass:"class:Class",
        params:[
            {
                defaultValue:null,
                optional:true,
                type:"String",
                description:"category to log in",
                name:"category"
            }
        ],
        description:" Check whether a message logged at \"info\" priority would be visible in the log.\n <P>\n As with logDebug, category is defaulted to the current className.  Use this method to avoid\n putting together expensive log messages if they will never appear in the log.\n\n",
        flags:"",
        name:"logIsInfoEnabled"
    },
    "attr:FieldPickerWindow.title":{
        seeAlso:[
        ],
        defaultValue:"\"Field Picker\"",
        type:"attr",
        definingClass:"class:FieldPickerWindow",
        groups:[
            "i18nMessages"
        ],
        deprecated:null,
        ref:"attr:FieldPickerWindow.title",
        valueType:"String",
        description:null,
        flags:"IR",
        name:"title"
    },
    "method:EditContext.setNodeProperties":{
        seeAlso:[
            {
                ref:"method:EditContext.removeNodeProperties",
                description:null
            }
        ],
        ref:"method:EditContext.setNodeProperties",
        deprecated:null,
        type:"method",
        definingClass:"class:EditContext",
        params:[
            {
                defaultValue:null,
                optional:false,
                type:"EditNode",
                description:"the editNode to update",
                name:"editNode"
            },
            {
                defaultValue:null,
                optional:false,
                type:"Canvas Properties",
                description:"the properties to apply",
                name:"properties"
            },
            {
                defaultValue:null,
                optional:true,
                type:"Boolean",
                description:"whether to skip updating the                                         ${isc.DocUtils.linkForRef('attr:EditNode.liveObject','liveObject')},\n                                         e.g. if you have already updated the liveObject",
                name:"skipLiveObjectUpdate"
            }
        ],
        description:" Update an editNode's serializable \"defaults\" with the supplied properties. If you\n wish to remove a property from the defaults (rather than setting it to null), then\n use ${isc.DocUtils.linkForRef('method:EditContext.removeNodeProperties','removeNodeProperties()')} instead.\n",
        flags:"",
        name:"setNodeProperties"
    },
    "attr:Calendar.sizeToWorkday":{
        seeAlso:[
            {
                ref:"attr:Calendar.styleWorkday",
                description:null
            },
            {
                ref:"attr:Calendar.scrollToWorkday",
                description:null
            },
            {
                ref:"attr:Calendar.limitToWorkday",
                description:null
            },
            {
                ref:"attr:Calendar.minRowHeight",
                description:null
            }
        ],
        defaultValue:"false",
        type:"attr",
        definingClass:"class:Calendar",
        groups:[
            "workday"
        ],
        deprecated:null,
        ref:"attr:Calendar.sizeToWorkday",
        valueType:"Boolean",
        description:"When ${isc.DocUtils.linkForRef('attr:Calendar.showWorkday','showWorkday')} is true, attempt to resize rows in the \n day and week views so that the ${isc.DocUtils.linkForRef('attr:Calendar.workdayStart','workday hours')} fill the visible \n viewport-height, and the whole workday is visible without scrolling.  If the Calendar is \n resized, the row-size is recalculated to keep the workday hours visible.\n <P>\n Note that row-heights will not shrink below the ${isc.DocUtils.linkForRef('attr:Calendar.minRowHeight')}, so the entire workday \n may not be visible without scrolling if the workday is long or the viewport-height is \n insufficient.",
        flags:"IRW",
        name:"sizeToWorkday"
    },
    "attr:Canvas.edgeSize":{
        seeAlso:[
        ],
        defaultValue:"10",
        type:"attr",
        definingClass:"class:Canvas",
        groups:[
            "imageEdges"
        ],
        ref:"attr:Canvas.edgeSize",
        deprecated:null,
        valueType:"number",
        description:"Size in pixels for corners and edges",
        flags:"IR",
        examples:[
            "${isc.DocUtils.linkForExampleId('edges')}"
        ],
        name:"edgeSize"
    },
    "attr:Canvas.htmlElement":{
        seeAlso:[
        ],
        defaultValue:"null",
        type:"attr",
        definingClass:"class:Canvas",
        groups:[
            "htmlElement",
            "positioning"
        ],
        ref:"attr:Canvas.htmlElement",
        deprecated:null,
        setter:[
            "setHtmlElement"
        ],
        valueType:"DOMElement",
        description:"If specified as a pointer to an HTML element present in the DOM, this canvas will be\n rendered inside that element on ${isc.DocUtils.linkForRef('method:Canvas.draw','draw()')}.\n <P>\n <i>NOTES:</i><br>\n This feature is intended for temporary integration with legacy page architectures only;\n the native browser's reaction to DOM insertion is unspecified and unsupported. For\n consistent cross-browser layout and positioning semantics, use Canvas parents\n (especially Layouts) and use absolute positioning at top level.\n <P>\n Persistence of htmlElement: If ${isc.DocUtils.linkForRef('attr:Canvas.htmlPosition')} is set to <code>\"replace\"</code>\n the htmlElement will be removed from the DOM when the canvas is drawn - therefore the\n htmlElement attribute will be cleared at this time.\n Otherwise if a Canvas is clear()d and then draw()n again it will\n be rendered inside the same htmlElement.<br>\n If a Canvas is added as a child to Canvas parent, its htmlElement will be dropped.\n <P>\n ${isc.DocUtils.linkForRef('attr:Canvas.position')} should typically be set to <code>\"relative\"</code> if the widget\n is to be rendered inline within a standard page.",
        flags:"IRWA",
        name:"htmlElement"
    },
    "attr:ListGrid.includeHilitesInSummaryFields":{
        seeAlso:[
            {
                ref:"method:ListGrid.shouldIncludeHiliteInSummaryField",
                description:null
            }
        ],
        ref:"attr:ListGrid.includeHilitesInSummaryFields",
        defaultValue:"true",
        deprecated:null,
        type:"attr",
        definingClass:"class:ListGrid",
        valueType:"boolean",
        description:"When assembling a value for a ${isc.DocUtils.linkForRef('attr:ListGrid.canAddSummaryFields','summary field')}, if a referenced\n field is hilited, should the hilite HTML be included in the summary field value?\n <P>\n To control hilites showing in group summaries, see ${isc.DocUtils.linkForRef('attr:ListGrid.showHilitesInGroupSummary','showHilitesInGroupSummary')}.",
        flags:"IRWA",
        name:"includeHilitesInSummaryFields"
    },
    "classAttr:Canvas.defaultPageSpace":{
        seeAlso:[
        ],
        defaultValue:"0",
        type:"classAttr",
        definingClass:"class:Canvas",
        groups:[
            "positioning"
        ],
        ref:"classAttr:Canvas.defaultPageSpace",
        deprecated:null,
        setter:[
            "setDefaultPageSpace"
        ],
        valueType:"int",
        description:"A fixed number of pixels at the top of the page in which components will not be placed.\n This is overridable per-instance via the ${isc.DocUtils.linkForRef('attr:Canvas.leavePageSpace')} attribute.\n Essentially, the effect is that all top-level components are shifted down this number of\n pixels, and the page height is treated as this number of pixels <em>less</em> than the\n real page height.\n <p>\n This attribute can be useful on certain mobile devices, when components should not be\n placed in a top portion of the screen. For example, on iOS devices in certain configurations,\n this can be set to 20 to avoid placing any component into the status bar area. Or, if\n using iOS 7.1's 'minimal-ui' viewport parameter, this can be set to 20 to avoid placing\n any component into the top 20px area of the screen, which if tapped on iPhone in landscape,\n causes Mobile Safari's address bar and tab bar to be shown.\n <p>\n This setting can be changed at runtime by calling ${isc.DocUtils.linkForRef('classMethod:Canvas.setDefaultPageSpace')}.\n <p>\n <strong>Note:</strong> As documented by the ${isc.DocUtils.linkForRef('group:mobileDevelopment','Mobile Application Development')}\n page, when the SmartClient application is running in Mobile Safari on iPhone running iOS 7.1 or\n later, and neither the <code>isc_useDefaultViewport</code> nor the <code>isc_useMinimalUI</code>\n global is set to <code>false</code> when the framework is loaded, then the framework\n will automatically set the <code>defaultPageSpace</code> to 0 in portrait orientation,\n and to 20 in landscape orientation.",
        flags:"IRA",
        name:"defaultPageSpace"
    },
    "attr:Calendar.sublaneNameField":{
        seeAlso:[
        ],
        defaultValue:"\"sublane\"",
        type:"attr",
        definingClass:"class:Calendar",
        groups:[
            "calendarEvent"
        ],
        deprecated:null,
        ref:"attr:Calendar.sublaneNameField",
        valueType:"String",
        description:"The name of the field which will determine the ${isc.DocUtils.linkForRef('attr:Lane.sublanes','sublane')} in which this \n event will be displayed, within its parent Lane, in ${isc.DocUtils.linkForRef('class:Timeline')}s and in the \n ${isc.DocUtils.linkForRef('attr:Calendar.dayView','day view')}, if ${isc.DocUtils.linkForRef('attr:Calendar.showDayLanes')} is true.",
        flags:"IR",
        name:"sublaneNameField"
    },
    "group:jspTags":{
        refs:[
        ],
        seeAlso:[
        ],
        ref:"group:jspTags",
        requiresModules:[
            "SCServer"
        ],
        deprecated:null,
        type:"group",
        title:"SmartClient JSP Tags",
        description:"The SmartClient Java Server component ships with a number of custom JSP tags designed to\n make development with SmartClient easier.  The custom tags are defined in\n <code>[webroot]/WEB-INF/iscTaglib.xml</code> in the SDK package.  To make use of these tags, \n you can use the standard JSP taglib directive with the uri as distributed (which requires no \n additional configuration):\n <pre>\n &lt;%@ taglib uri=\"http://www.smartclient.com/taglib\" prefix=\"isomorphic\" %&gt;\n </pre>\n or you can choose some other uri value if you have reason to - e.g., the following is still \n supported:\n <pre>\n &lt;%@ taglib uri=\"/WEB-INF/iscTaglib.xml\" prefix=\"isomorphic\" %&gt;\n </pre>\n but in that case you'll also need to make sure you have the following entry in your web.xml\n <pre>\n &lt;taglib&gt;\n     &lt;taglib-uri&gt;isomorphic&lt;/taglib-uri&gt; \n     &lt;taglib-location&gt;/WEB-INF/iscTaglib.xml&lt;/taglib-location&gt; \n &lt;/taglib&gt;\n </pre>\n <p>\n All SmartClient JSP tags produce either HTML or JavaScript output, so you can easily see\n what any given tag is generating by doing a \"View->Source\" in your browser after browsing to\n the JSP that contains your tag.  Tags that produce HTML must be located in the HTML BODY\n context in your JSP - that is, outside of any <code>&lt;SCRIPT&gt;</code> tags and inside\n <code>&lt;BODY&gt;</code> tags.  Tags that produce JavaScript must be located inside\n <code>&lt;SCRIPT&gt;</code> tags.",
        name:"jspTags"
    },
    "attr:HiddenItem.alwaysFetchMissingValues":{
        seeAlso:[
        ],
        defaultValue:"false",
        type:"attr",
        definingClass:"class:HiddenItem",
        groups:[
            "display_values"
        ],
        deprecated:null,
        ref:"attr:HiddenItem.alwaysFetchMissingValues",
        valueType:"Boolean",
        description:"If this form item has a specified ${isc.DocUtils.linkForRef('attr:FormItem.optionDataSource')} and \n ${isc.DocUtils.linkForRef('attr:FormItem.fetchMissingValues')} is true, when the item value changes, a fetch will be\n performed against the optionDataSource to retrieve the related record \n if ${isc.DocUtils.linkForRef('attr:FormItem.displayField')} is specified and the new item value is not present in any\n valueMap explicitly specified on the item.\n <P>\n Setting this property to true means that a fetch will occur against the optionDataSource \n to retrieve the related record even if ${isc.DocUtils.linkForRef('attr:FormItem.displayField')} is unset, or the\n item has a valueMap which explicitly contains this field's value.\n <P>\n An example of a use case where this might be set would be if ${isc.DocUtils.linkForRef('method:FormItem.formatValue')}\n or ${isc.DocUtils.linkForRef('method:FormItem.formatEditorValue')} were written to display properties from the\n ${isc.DocUtils.linkForRef('method:FormItem.getSelectedRecord','selected record')}.\n <P>\n Note - for efficiency we cache the associated record once a fetch has been performed, meaning\n if the value changes, then reverts to a previously seen value, we do not kick\n off an additional fetch even if this property is true. If necessary this cache may be\n explicitly invalidated via a call to ${isc.DocUtils.linkForRef('method:FormItem.invalidateDisplayValueCache')}\n <P>\n Note: For hiddenItem ${isc.DocUtils.linkForRef('attr:HiddenItem.fetchMissingValues','fetchMissingValues')} is defaulted\n to <code>false</code> so developers wishing to get access to the record related to\n the current hiddenItem value would need to explicitly set both that property, and this\n one to true.",
        flags:"IRWA",
        name:"alwaysFetchMissingValues"
    },
    "method:DrawItem.setPropertyValue":{
        seeAlso:[
            {
                ref:"method:Class.setProperty",
                description:null
            }
        ],
        ref:"method:DrawItem.setPropertyValue",
        deprecated:null,
        type:"method",
        definingClass:"class:DrawItem",
        params:[
            {
                defaultValue:null,
                optional:false,
                type:"String",
                description:"name of the property to set",
                name:"propertyName"
            },
            {
                defaultValue:null,
                optional:false,
                type:"Any",
                description:"new value for the property",
                name:"newValue"
            }
        ],
        description:" Sets a property on this DrawItem, calling the appropriate setter method if one is found and\n is ${isc.DocUtils.linkForRef('classMethod:Class.isMethodSupported','supported')}.\n",
        flags:"",
        name:"setPropertyValue"
    },
    "attr:Window.showStatusBar":{
        seeAlso:[
        ],
        defaultValue:"true",
        type:"attr",
        definingClass:"class:Window",
        groups:[
            "windowMembers",
            "appearance",
            "footer"
        ],
        deprecated:null,
        ref:"attr:Window.showStatusBar",
        valueType:"Boolean",
        description:"If true, show a statusBar for this Window, including resizer.\n Note that the status bar will only be displayed if the footer\n is showing for the window (${isc.DocUtils.linkForRef('attr:Window.showFooter')}).",
        flags:"IRW",
        name:"showStatusBar"
    },
    "type:double":{
        seeAlso:[
        ],
        ref:"type:double",
        treeLocation:[
            "Client Reference/System"
        ],
        deprecated:null,
        type:"type",
        description:"A decimal (or \"floating point\") number, for example, 5.5.  May not be null.",
        name:"double",
        baseType:"Double"
    },
    "classAttr:ListGrid.UP_ARROW_KEYPRESS":{
        seeAlso:[
        ],
        defaultValue:"\"arrow_up\"",
        type:"classAttr",
        definingClass:"class:ListGrid",
        deprecated:null,
        ref:"classAttr:ListGrid.UP_ARROW_KEYPRESS",
        valueType:"Constant",
        description:"A declared value of the enum type  \n ${isc.DocUtils.linkForRef('type:EditCompletionEvent','EditCompletionEvent')}.",
        flags:"R",
        name:"UP_ARROW_KEYPRESS",
        constant:true
    },
    "attr:UserConfirmationGateway.nextElement":{
        seeAlso:[
        ],
        ref:"attr:UserConfirmationGateway.nextElement",
        defaultValue:"null",
        deprecated:null,
        type:"attr",
        definingClass:"class:UserConfirmationGateway",
        valueType:"String",
        description:"Next ${isc.DocUtils.linkForRef('attr:Process.sequences','sequence')} or ${isc.DocUtils.linkForRef('attr:Process.elements','element')} to execute\n if the criteria match the process state.  \n <p>\n <code>nextElement</code> does not need to be specified if this gateway is part of a\n ${isc.DocUtils.linkForRef('attr:Process.sequences','sequence')} and has a next element in the sequence.\n <p>\n Note that if there is both a <code>sequence</code> and a normal <code>element</code>\n with the same name in the current <code>Process</code>, the <code>sequence</code> will\n be used.",
        flags:"IR",
        name:"nextElement"
    },
    "attr:ValuesManager.updateOperation":{
        seeAlso:[
        ],
        defaultValue:"null",
        type:"attr",
        definingClass:"class:ValuesManager",
        groups:[
            "operations"
        ],
        deprecated:null,
        ref:"attr:ValuesManager.updateOperation",
        valueType:"String",
        description:"${isc.DocUtils.linkForRef('attr:DSRequest.operationId','operationId')} to use when performing update operations.",
        flags:"IRW",
        name:"updateOperation"
    },
    "attr:StretchImgButton.showFocus":{
        seeAlso:[
        ],
        defaultValue:"false",
        type:"attr",
        definingClass:"class:StretchImgButton",
        groups:[
            "state"
        ],
        deprecated:"as of SmartClient version 6.1 in favor of ${isc.DocUtils.linkForRef('attr:StatefulCanvas.showFocused')}",
        ref:"attr:StretchImgButton.showFocus",
        valueType:"Boolean",
        description:"Should we visibly change state when the canvas receives focus?  Note that by default the\n <code>over</code> state is used to indicate focus.",
        flags:"IRW",
        name:"showFocus"
    },
    "method:FormItem.getVisibleWidth":{
        groups:[
            "sizing"
        ],
        seeAlso:[
        ],
        ref:"method:FormItem.getVisibleWidth",
        deprecated:null,
        type:"method",
        definingClass:"class:FormItem",
        description:"\tOutput the drawn width for this item in pixels. This method is only reliable after\n  the item has been drawn into the page.\n",
        flags:"A",
        returns:{
            type:"Integer",
            description:"width of the form item"
        },
        name:"getVisibleWidth"
    },
    "attr:DrawSector.startAngle":{
        seeAlso:[
        ],
        ref:"attr:DrawSector.startAngle",
        defaultValue:"0.0",
        deprecated:null,
        type:"attr",
        definingClass:"class:DrawSector",
        valueType:"float",
        description:"Start angle of the sector in degrees.  Default of 0.0 will create a sector that starts\n with a line from the ${isc.DocUtils.linkForRef('attr:DrawSector.centerPoint')} and extends horizontally to the right for the \n indicated ${isc.DocUtils.linkForRef('attr:DrawSector.radius')}, then sweeps clockwise toward the ${isc.DocUtils.linkForRef('attr:DrawSector.endAngle')}.\n <P>\n Note that the startAngle may validly be a greater numeric value than the endAngle.\n The sector will always be drawn clockwise from startAngle to endAngle, so \n a sector with startAngle of 350 and endAngle of 10 would draw a 20-degree\n segment sticking out to the right of the centerPoint.\n <P>\n Drawing a full circle: A developer may have a drawSector transcribe a full circle by using\n values of 360 or greater as the end point. For example a drawSector with startAngle set\n to 350 and endAngle set to 710 would transcribe a full circle which starts and ends on the\n same line (10 degrees above the horizontal, to the right of the centerPoint).",
        flags:"IR",
        name:"startAngle"
    },
    "attr:TileLayout.paddingAsLayoutMargin":{
        seeAlso:[
        ],
        defaultValue:"true",
        type:"attr",
        definingClass:"class:TileLayout",
        groups:[
            "layoutMargin"
        ],
        deprecated:null,
        ref:"attr:TileLayout.paddingAsLayoutMargin",
        valueType:"Boolean",
        description:"If this widget has padding specified (as ${isc.DocUtils.linkForRef('attr:Canvas.padding','this.padding')} or in the\n CSS style applied to this layout), should it show up as space outside the members,\n similar to layoutMargin?\n <P>\n If this setting is false, padding will not affect member positioning (as CSS padding\n normally does not affect absolutely positioned children).  Leaving this setting true\n allows a designer to more effectively control layout purely from CSS.\n <P>\n Note that ${isc.DocUtils.linkForRef('attr:Layout.layoutMargin')} if specified, takes precedence over this value.",
        flags:"IRWA",
        name:"paddingAsLayoutMargin"
    },
    "method:TabSet.setTabTitle":{
        seeAlso:[
        ],
        ref:"method:TabSet.setTabTitle",
        deprecated:null,
        type:"method",
        definingClass:"class:TabSet",
        params:[
            {
                defaultValue:null,
                optional:false,
                type:"Tab | number | GlobalId | TabName",
                description:null,
                name:"tab"
            },
            {
                defaultValue:null,
                optional:false,
                type:"HTMLString",
                description:"new title",
                name:"title"
            }
        ],
        description:" Changes the title of a tab\n",
        flags:"A",
        examples:[
            "${isc.DocUtils.linkForExampleId('titleChange')}"
        ],
        name:"setTabTitle"
    },
    "method:TileGrid.loadAllRecords":{
        seeAlso:[
        ],
        type:"method",
        definingClass:"class:TileGrid",
        returns:{
            type:"Boolean",
            description:"true if a fetch was made or was not needed - false otherwise"
        },
        groups:[
            "dataBoundComponentMethods"
        ],
        deprecated:null,
        ref:"method:TileGrid.loadAllRecords",
        params:[
            {
                defaultValue:null,
                optional:true,
                type:"Integer",
                description:"optional maximum record count - if passed, no fetch takes place                                if maxRecords is below the known length of the data",
                name:"maxRecords"
            },
            {
                defaultValue:null,
                optional:true,
                type:"DSCallback",
                description:"callback to fire if a fetch is issued - if all data was                                 already loaded, the callback is fired with no parameters",
                name:"callback"
            }
        ],
        description:" Loads all records that match this grid's current filter-criteria, optionally firing a \n callback when the data arrives.\n <p>\n If the length of the data is ${isc.DocUtils.linkForRef('method:ResultSet.lengthIsKnown','not known')}, or is greater than \n the passed <i>maxRecords</i>, this call returns false.  No fetch \n is issued and the <i>callback</i>, if passed, is not fired.\n <p>\n If all data is ${isc.DocUtils.linkForRef('method:ResultSet.allMatchingRowsCached','already loaded')}, no fetch is issued \n and this call returns true.  The <i>callback</i>, if passed, will be fired, but its \n parameters will be null, since there was no fetch to provide the values from.\n <p>\n In all other cases, this call returns true and a fetch is issued for all necessary records. \n When the data arrives, the <i>callback</i> is fired.\n\n",
        flags:"",
        name:"loadAllRecords"
    },
    "attr:SplitPane.detailToolStrip":{
        seeAlso:[
        ],
        ref:"attr:SplitPane.detailToolStrip",
        defaultValue:"null",
        deprecated:null,
        type:"attr",
        definingClass:"class:SplitPane",
        valueType:"AutoChild NavigationBar",
        description:"Toolstrip servicing the ${isc.DocUtils.linkForRef('attr:SplitPane.detailPane','detailPane')}.\n <p>\n In ${isc.DocUtils.linkForRef('attr:SplitPane.deviceMode','deviceMode')}\n \"desktop\"\n \n and <code>deviceMode</code>\n \"tablet\",\n \n the <code>detailToolStrip</code> is shown <em>above</em> the <code>detailPane</code>.\n In ${isc.DocUtils.linkForRef('attr:SplitPane.deviceMode','deviceMode')}\n \"handset\",\n \n the <code>detailToolStrip</code> is created <strong>only</strong> if\n ${isc.DocUtils.linkForRef('attr:SplitPane.detailToolButtons','detailToolButtons')} are specified, and is placed\n <em>underneath</em> the <code>detailPane</code>.",
        flags:"IR",
        name:"detailToolStrip"
    },
    "method:DataSource.xmlSerialize":{
        seeAlso:[
        ],
        ref:"method:DataSource.xmlSerialize",
        deprecated:null,
        type:"method",
        definingClass:"class:DataSource",
        params:[
            {
                defaultValue:null,
                optional:false,
                type:"Any",
                description:"data to be serialized",
                name:"data"
            },
            {
                defaultValue:null,
                optional:false,
                type:"SerializationContext",
                description:"options for the serialization engine",
                name:"flags"
            }
        ],
        description:" Serialize a JavaScript object as XML.\n <P>\n The JavaScript Object passed to ${isc.DocUtils.linkForRef('method:DataSource.xmlSerialize')} becomes an XML\n element named after the ${isc.DocUtils.linkForRef('attr:DataSource.tagName')} (or ${isc.DocUtils.linkForRef('attr:DataSource.ID')} if\n tagName is unset).  Each property of the object becomes a subElement.  For example,\n using a DataSource to serialize like this:\n <pre>\n     var inputObject = {\n        startRow : 5,\n        endRow : 50,\n        data : [\n           { field1 : \"value1\", field2: new Date() },\n           { field1 : \"value3\", field2: null }\n        ]\n     };\n     var myDS = isc.DataSource.create({ tagName:\"DSRequest\" });\n     myDS.xmlSerialize(inputObject);\n </pre>\n .. produces the following XML:\n <pre>\n     &lt;DSRequest&gt;\n         &lt;startRow&gt;5&lt;/startRow&gt;\n         &lt;endRow&gt;50&lt;/endRow&gt;\n         &lt;data&gt;\n             &lt;field1&gt;value1&lt;/field1&gt;\n             &lt;field2&gt;2005-10-14T18:01:16&lt;/field2&gt;\n         &lt;/data&gt;\n         &lt;data&gt;\n             &lt;field1&gt;value3&lt;/field1&gt;\n             &lt;field2&gt;&lt;/field2&gt;\n         &lt;/data&gt;\n     &lt;/DSRequest&gt;\n </pre>\n <P>\n Various properties on the DataSource and DataSourceField can affect how serialization is\n performed, see for example ${isc.DocUtils.linkForRef('attr:DataSource.tagName')},\n ${isc.DocUtils.linkForRef('attr:DataSource.schemaNamespace')}, \n ${isc.DocUtils.linkForRef('attr:DataSourceField.xmlAttribute')}, \n ${isc.DocUtils.linkForRef('attr:DataSourceField.multiple')} and ${isc.DocUtils.linkForRef('attr:DataSourceField.childTagName')}.\n By setting the ${isc.DocUtils.linkForRef('attr:DataSourceField.type','type of a field')} to the ID of another\n DataSource which has further XML serialization settings, you can control serialization of\n nested structures.\n <P>\n If you are working with a WSDL-described web service, XML serialization is performed\n automatically by APIs like ${isc.DocUtils.linkForRef('method:WebService.callOperation')} - you only need to\n know about serialization in order to understand how to put together JavaScript data that\n will fill in an XML message properly, and for simple messages, setting\n ${isc.DocUtils.linkForRef('attr:DSRequest.useFlatFields')} makes that unnecessary as well.   \n <P>\n <b>Note:</b> when trying to send data to a web service, it is best to avoid putting\n together any XML yourself, instead modify the JavaScript data being fed to SmartClient's\n SOAP engine.  This is because the WSDL and SOAP rules for correctly namespacing and\n encoding Web Service messages are very complex and are subject to change with new\n versions of the web service you are contacting, whereas the data itself is easy to\n manipulate and less likely to change.\n <P>\n To troubleshoot message formation, you can set the log category \"xmlSerialize\" to \n <code>INFO</code> or <code>DEBUG</code> level in order to see diagnostics about XML\n message formation, and you can use the RPC tab in the Developer Console to see the\n actual messages being passed to web services.\n\n",
        flags:"A",
        returns:{
            type:"String",
            description:"data as serialized to XML"
        },
        name:"xmlSerialize"
    },
    "attr:ListGrid.allowFilterOperators":{
        seeAlso:[
        ],
        ref:"attr:ListGrid.allowFilterOperators",
        defaultValue:"null",
        deprecated:null,
        type:"attr",
        definingClass:"class:ListGrid",
        valueType:"Boolean",
        description:"Causes a menu item titled ${isc.DocUtils.linkForRef('attr:ListGrid.filterUsingText','\"Filter using\"')} to appear in the\n ${isc.DocUtils.linkForRef('attr:ListGrid.showHeaderContextMenu','headerContextMenu')} that allows the end user to pick an advanced\n ${isc.DocUtils.linkForRef('type:OperatorId','search operator')} to use for this field.\n <p>\n Once an operator has been chosen, the active operator is indicated by an\n ${isc.DocUtils.linkForRef('attr:ListGrid.operatorIcon')} placed within the field (you can alternatively cause the\n icon to ${isc.DocUtils.linkForRef('attr:ListGrid.alwaysShowOperatorIcon','always be present')}).  The <code>operatorIcon</code> \n shows the same textual representation of the search operator as is used by the\n ${isc.DocUtils.linkForRef('attr:FormItem.allowExpressions')} feature.  Clicking on the icon provides a second way to \n modify the search operator.  \n <p>\n This feature is enabled by default if ${isc.DocUtils.linkForRef('method:DataSource.supportsAdvancedCriteria')} is true, \n for all fields where it is normally possible to filter by typing in a search string.  This \n excludes field types such as \"date\" or \"boolean\" which show specialized filter controls.  \n Use ${isc.DocUtils.linkForRef('attr:ListGridField.allowFilterOperators')} to disable this interface for individual \n fields, or set ${isc.DocUtils.linkForRef('attr:DataSourceField.canFilter')} to false to disallow filtering entirely for \n a field.\n <p>\n Note that this feature is similar to ${isc.DocUtils.linkForRef('attr:ListGrid.allowFilterExpressions')}, which allows \n the end users to directly type in characters such as \"&gt;\" to control filtering.\n <code>allowFilterOperators</code> is easier to use and more discoverable than\n <code>allowFilterExpressions</code>, and also avoids the drawback where special characters \n like \"&gt;\" cannot be used in filter values.  However, <code>allowFilterExpressions</code> \n allows users to make use of certain operators that <code>allowFilterOperators</code> does \n not support, such as using the \"betweenInclusive\" operator by typing \"5...10\".\n <P>\n When both <code>allowfilterExpressions</code> and <code>allowFilterOperators</code> are set,\n filter expressions entered in to the edit-area are parsed and the operator automatically \n applied to the ${isc.DocUtils.linkForRef('attr:ListGrid.operatorIcon')}.",
        flags:"IR",
        name:"allowFilterOperators"
    },
    "method:FilterBuilder.clearCriteria":{
        seeAlso:[
        ],
        ref:"method:FilterBuilder.clearCriteria",
        deprecated:null,
        type:"method",
        definingClass:"class:FilterBuilder",
        description:" Clear all current criteria.\n",
        flags:"",
        name:"clearCriteria"
    },
    "method:ListGrid.isExportingClientData":{
        seeAlso:[
            {
                ref:"method:ListGrid.exportClientData",
                description:null
            }
        ],
        ref:"method:ListGrid.isExportingClientData",
        deprecated:null,
        type:"method",
        definingClass:"class:ListGrid",
        description:" Returns true if this component is currently \n ${isc.DocUtils.linkForRef('method:ListGrid.exportClientData','exporting client data')}.  This method can be called from\n custom cell formatters if you need to return a different formatted value for an export\n than for a live ListGrid\n",
        flags:"",
        returns:{
            type:"boolean",
            description:"returns true if this component is currently exporting client data"
        },
        name:"isExportingClientData"
    },
    "attr:ListGrid.dragScrollRedrawDelay":{
        seeAlso:[
        ],
        defaultValue:"75",
        type:"attr",
        definingClass:"class:ListGrid",
        groups:[
            "performance"
        ],
        deprecated:null,
        ref:"attr:ListGrid.dragScrollRedrawDelay",
        valueType:"int",
        description:"Like ${isc.DocUtils.linkForRef('attr:ListGrid.scrollRedrawDelay')}, but applies when the component is being\n drag-scrolled (via a scrollbar).  This value is typically set higher than ${isc.DocUtils.linkForRef('attr:ListGrid.scrollRedrawDelay')}\n to avoid too many concurrent fetches to the server for ${isc.DocUtils.linkForRef('class:ResultSet')}-backed components\n since it's quite easy to induce such a case with a scrollbar and a grid bound to a large databaset.",
        flags:"IRW",
        name:"dragScrollRedrawDelay"
    },
    "class:TabSet":{
        seeAlso:[
        ],
        type:"class",
        staticMethods:[
        ],
        inheritsFrom:"Canvas",
        classMethods:[
        ],
        classAttrs:[
        ],
        attrs:[
            "attr:TabSet.tabs",
            "attr:TabSet.tabBar",
            "attr:TabSet.tabProperties",
            "attr:TabSet.defaultTabWidth",
            "attr:TabSet.defaultTabHeight",
            "attr:TabSet.useSimpleTabs",
            "attr:TabSet.simpleTabBaseStyle",
            "attr:TabSet.simpleTabIconOnlyBaseStyle",
            "attr:TabSet.tabBarPosition",
            "attr:TabSet.tabBarAlign",
            "attr:TabSet.tabBarThickness",
            "attr:TabSet.selectedTab",
            "attr:TabSet.canCloseTabs",
            "attr:TabSet.closeTabIcon",
            "attr:TabSet.closeTabIconSize",
            "attr:TabSet.ariaCloseableSuffix",
            "attr:TabSet.canReorderTabs",
            "attr:TabSet.showMoreTab",
            "attr:TabSet.moreTabCount",
            "attr:TabSet.moreTabTitle",
            "attr:TabSet.moreTabImage",
            "attr:TabSet.moreTab",
            "attr:TabSet.moreTabProperties",
            "attr:TabSet.moreTabPane",
            "attr:TabSet.moreTabPaneProperties",
            "attr:TabSet.moreTabPaneDefaults",
            "attr:TabSet.moreTabPaneNavBar",
            "attr:TabSet.moreTabPaneTable",
            "attr:TabSet.tabBarControls",
            "attr:TabSet.showTabScroller",
            "attr:TabSet.showTabPicker",
            "attr:TabSet.tabBarControlLayout",
            "attr:TabSet.animateTabScrolling",
            "attr:TabSet.scroller",
            "attr:TabSet.scrollerButtonSize",
            "attr:TabSet.tabPicker",
            "attr:TabSet.pickerButtonSize",
            "attr:TabSet.touchPickerButtonSize",
            "attr:TabSet.skinImgDir",
            "attr:TabSet.symmetricScroller",
            "attr:TabSet.scrollerSrc",
            "attr:TabSet.scrollerHSrc",
            "attr:TabSet.scrollerVSrc",
            "attr:TabSet.symmetricPickerButton",
            "attr:TabSet.pickerButtonSrc",
            "attr:TabSet.pickerButtonHSrc",
            "attr:TabSet.pickerButtonVSrc",
            "attr:TabSet.paneContainer",
            "attr:TabSet.paneContainerClassName",
            "attr:TabSet.paneContainerOverflow",
            "attr:TabSet.symmetricEdges",
            "attr:TabSet.leftEdgeSizes",
            "attr:TabSet.topEdgeSizes",
            "attr:TabSet.bottomEdgeSizes",
            "attr:TabSet.rightEdgeSizes",
            "attr:TabSet.leftEdgeOffsets",
            "attr:TabSet.rightEdgeOffsets",
            "attr:TabSet.topEdgeOffsets",
            "attr:TabSet.bottomEdgeOffsets",
            "attr:TabSet.showPaneContainerEdges",
            "attr:TabSet.paneMargin",
            "attr:TabSet.canEditTabTitles",
            "attr:TabSet.titleEditEvent",
            "attr:TabSet.titleEditor",
            "attr:TabSet.titleEditorProperties",
            "attr:TabSet.titleEditorLeftOffset",
            "attr:TabSet.titleEditorRightOffset",
            "attr:TabSet.titleEditorTopOffset",
            "attr:TabSet.useIOSTabs",
            "attr:TabSet.canAddTabs",
            "attr:TabSet.addTabButton",
            "attr:TabSet.addTabButtonIcon",
            "attr:TabSet.showTabBar",
            "attr:TabSet.simpleTabButtonConstructor",
            "attr:TabSet.tabBarProperties",
            "attr:TabSet.showPartialEdges",
            "attr:TabSet.destroyPanes",
            "attr:TabSet.locateTabsBy",
            "attr:TabSet.editProxyConstructor"
        ],
        ref:"class:TabSet",
        deprecated:null,
        treeLocation:[
            "Client Reference/Layout"
        ],
        description:"The TabSet class allows components on several panes to share the same space. The tabs at \n the top can be selected by the user to show each pane. \n <P>\n Tabs are configured via the <code>tabs</code> property, each of which has a\n <code>pane</code> property which will be displayed in the main pane when that tab is\n selected.",
        methods:[
            "method:TabSet.setPaneContainerOverflow",
            "method:TabSet.getPaneContainerEdges",
            "method:TabSet.setTabTitle",
            "method:TabSet.setTabPickerTitle",
            "method:TabSet.setTabIcon",
            "method:TabSet.enableTab",
            "method:TabSet.disableTab",
            "method:TabSet.setTabProperties",
            "method:TabSet.addTab",
            "method:TabSet.addTabs",
            "method:TabSet.setTabPane",
            "method:TabSet.removeTab",
            "method:TabSet.removeTabs",
            "method:TabSet.removeLastTab",
            "method:TabSet.reorderTab",
            "method:TabSet.setCanCloseTab",
            "method:TabSet.setCanCloseTabs",
            "method:TabSet.closeClick",
            "method:TabSet.tabIconClick",
            "method:TabSet.getTabObject",
            "method:TabSet.getTab",
            "method:TabSet.getTabPane",
            "method:TabSet.getTabNumber",
            "method:TabSet.updateTab",
            "method:TabSet.revealChild",
            "method:TabSet.scrollForward",
            "method:TabSet.scrollBack",
            "method:TabSet.getSelectedTab",
            "method:TabSet.getSelectedTabNumber",
            "method:TabSet.selectTab",
            "method:TabSet.tabForPane",
            "method:TabSet.editTabTitle",
            "method:TabSet.cancelTabTitleEditing",
            "method:TabSet.saveTabTitle",
            "method:TabSet.addTabClicked",
            "method:TabSet.tabSelected",
            "method:TabSet.tabDeselected",
            "method:TabSet.titleChanged",
            "method:TabSet.showTabContextMenu",
            "method:TabSet.tabsReordered"
        ],
        name:"TabSet"
    },
    "classMethod:XMLTools.selectNodes":{
        seeAlso:[
        ],
        type:"classMethod",
        definingClass:"class:XMLTools",
        returns:{
            type:"Array",
            description:"list of nodes matching XPath"
        },
        groups:[
            "xmlTransform"
        ],
        ref:"classMethod:XMLTools.selectNodes",
        deprecated:null,
        params:[
            {
                defaultValue:null,
                optional:false,
                type:"XMLElement | XMLDocument | String",
                description:"Native XMLElement,document, or xml string                                                      to select from",
                name:"element"
            },
            {
                defaultValue:null,
                optional:false,
                type:"XPath",
                description:"XPath expression to use to select nodes",
                name:"expression"
            },
            {
                defaultValue:null,
                optional:true,
                type:"Map<Prefix,URI>",
                description:"namespace mapping used by the expression",
                name:"namespaces"
            }
        ],
        description:" Retrieve a set of nodes from an XML element or document based on an XPath expression.\n <P>\n If the target document is namespaced, namespace prefixes declared in the document element of\n the target document will be available, as well as the default namespace, if declared, under\n the prefix \"default\".\n <P>\n To declare your own namespace prefixes, provide a prefix to URI mapping as a simple JS\n Object, for example:\n <pre>\n   {\n      az : \"http://webservices.amazon.com/AWSECommerceService/2005-03-23\",\n      xsd : \"http://www.w3.org/2001/XMLSchema\"\n   }\n </pre>\n <P>\n <b>NOTE:</b> this API cannot be supported on the Safari web browser for versions earlier\n than 3.0.3.\n\n",
        flags:"",
        examples:[
            "${isc.DocUtils.linkForExampleId('xmlServerValidationErrors')}"
        ],
        name:"selectNodes"
    },
    "attr:ComboBoxItem.editProxyConstructor":{
        seeAlso:[
        ],
        ref:"attr:ComboBoxItem.editProxyConstructor",
        defaultValue:"\"SelectItemEditProxy\"",
        deprecated:null,
        type:"attr",
        definingClass:"class:ComboBoxItem",
        valueType:"SCClassName",
        description:"Default class used to construct the ${isc.DocUtils.linkForRef('class:EditProxy')} for this component\n when the component is ${isc.DocUtils.linkForRef('method:Canvas.setEditMode','first placed into edit mode')}.",
        flags:"IR",
        name:"editProxyConstructor"
    },
    "attr:DataBoundComponent.editHilitesText":{
        seeAlso:[
        ],
        defaultValue:"\"Edit Highlights...\"",
        type:"attr",
        definingClass:"interface:DataBoundComponent",
        groups:[
            "i18nMessages"
        ],
        deprecated:null,
        ref:"attr:DataBoundComponent.editHilitesText",
        valueType:"String",
        description:"Text for a menu item allowing users to edit grid highlights.",
        flags:"IRW",
        name:"editHilitesText"
    },
    "attr:FacetChart.pointSizeLogGradations":{
        seeAlso:[
            {
                ref:"attr:FacetChart.logGradations",
                description:null
            }
        ],
        ref:"attr:FacetChart.pointSizeLogGradations",
        defaultValue:"[1, 5]",
        deprecated:null,
        type:"attr",
        definingClass:"class:FacetChart",
        valueType:"Array of float",
        description:"When ${isc.DocUtils.linkForRef('attr:FacetChart.usePointSizeLogGradations')} is set, this property specifies the\n ${isc.DocUtils.linkForRef('attr:FacetChart.pointSizeMetric','pointSizeMetric')} value gradations to show in the\n ${isc.DocUtils.linkForRef('attr:FacetChart.showPointSizeLegend','point size legend')} in between powers, expressed as a series\n of integer or float values between 1 and ${isc.DocUtils.linkForRef('attr:FacetChart.pointSizeLogBase')}.",
        flags:"IR",
        name:"pointSizeLogGradations"
    },
    "attr:DetailViewerField.imageHeight":{
        seeAlso:[
            {
                ref:"attr:DetailViewerField.imageSize",
                description:null
            },
            {
                ref:"attr:DetailViewerField.imageWidth",
                description:null
            }
        ],
        defaultValue:"null",
        type:"attr",
        definingClass:"object:DetailViewerField",
        groups:[
            "imageColumns"
        ],
        deprecated:null,
        ref:"attr:DetailViewerField.imageHeight",
        valueType:"Integer | String",
        description:"Height of image shown for fieldTypes image in this field.\n <P>\n If set to a String, assumed to be a property on each record that specifies the image\n height.  For example, if <code>field.imageHeight</code> is \"logoHeight\",\n <code>record.logoHeight</code> will control the height of the image.",
        flags:"IRW",
        name:"imageHeight"
    },
    "attr:DateRangeItem.absoluteItemConstructor":{
        seeAlso:[
            {
                ref:"type:FieldType",
                description:null
            }
        ],
        ref:"attr:DateRangeItem.absoluteItemConstructor",
        defaultValue:"\"DateItem\"",
        deprecated:null,
        type:"attr",
        definingClass:"class:DateRangeItem",
        valueType:"String",
        description:"The ${isc.DocUtils.linkForRef('class:FormItem')} class to create when ${isc.DocUtils.linkForRef('attr:DateRangeItem.allowRelativeDates')} is false,\n but the ${isc.DocUtils.linkForRef('class:DateRangeItem')} does not have type \"datetime\".",
        flags:"R",
        name:"absoluteItemConstructor"
    },
    "method:ListGrid.askForSort":{
        seeAlso:[
        ],
        ref:"method:ListGrid.askForSort",
        deprecated:null,
        type:"method",
        definingClass:"class:ListGrid",
        description:" Show a dialog to configure the sorting of multiple fields on this component.  Calls through\n to ${isc.DocUtils.linkForRef('classMethod:MultiSortDialog.askForSort')}, passing this component as the fieldSource and the\n current ${isc.DocUtils.linkForRef('method:DataBoundComponent.getSort','sort-specification')} if there is one.\n <P>\n The generated multiSortDialog can be customized via ${isc.DocUtils.linkForRef('attr:ListGrid.multiSortDialogDefaults')}, \n ${isc.DocUtils.linkForRef('attr:ListGrid.multiSortDialogProperties')}.\n\n",
        flags:"",
        name:"askForSort"
    },
    "attr:Splitbar.showClosedGrip":{
        seeAlso:[
        ],
        defaultValue:"null",
        type:"attr",
        definingClass:"class:Splitbar",
        groups:[
            "grip"
        ],
        deprecated:null,
        ref:"attr:Splitbar.showClosedGrip",
        valueType:"Boolean",
        description:"If ${isc.DocUtils.linkForRef('attr:Splitbar.showGrip')} is true, this property determines whether the grip image\n displayed should show the <code>\"Closed\"</code> state when the ${isc.DocUtils.linkForRef('attr:Splitbar.target')} \n is hidden. Note that if ${isc.DocUtils.linkForRef('attr:Splitbar.invertClosedGripIfTargetAfter')} is true, we\n may show the \"closed\" state when the target is visible, rather than when it is hidden.",
        flags:"IRA",
        name:"showClosedGrip"
    },
    "method:Tree.openFolder":{
        seeAlso:[
            {
                ref:"method:ResultTree.dataArrived",
                description:null
            }
        ],
        ref:"method:Tree.openFolder",
        deprecated:null,
        type:"method",
        definingClass:"class:Tree",
        params:[
            {
                defaultValue:null,
                optional:false,
                type:"TreeNode | String | Integer | NodeLocator",
                description:"the node to open, or its                                                                  ID, or a NodeLocator object",
                name:"node"
            },
            {
                defaultValue:null,
                optional:true,
                type:"Callback",
                description:"Optional callback (stringMethod) to fire when loading                       completes. Has a single param <code>node</code> - the node whose \n                      children have been loaded, and is fired in the scope of the Tree.",
                name:"callback"
            }
        ],
        description:"\n Open a particular node.  Note, for ${isc.DocUtils.linkForRef('method:Tree.isMultiLinkTree','multi-link tree')}s, passing a \n <code>NodeLocator</code> is the only unambiguous way to specify the node.\n\n",
        flags:"",
        name:"openFolder"
    },
    "attr:GridRenderer.showClippedValuesOnHover":{
        seeAlso:[
            {
                ref:"attr:GridRenderer.canHover",
                description:null
            },
            {
                ref:"method:GridRenderer.cellValueHoverHTML",
                description:null
            }
        ],
        defaultValue:"null",
        type:"attr",
        definingClass:"class:GridRenderer",
        groups:[
            "events"
        ],
        deprecated:null,
        ref:"attr:GridRenderer.showClippedValuesOnHover",
        valueType:"Boolean",
        description:"If true and a cell's value is clipped, then a hover containing the full cell value is\n enabled.\n <p>\n Note that standard cell hovers override clipped value hovers. Thus, to enable clipped value\n hovers, ${isc.DocUtils.linkForRef('attr:GridRenderer.canHover','canHover')} must be unset or null and the corresponding field must have\n ${isc.DocUtils.linkForRef('attr:ListGridField.showHover','showHover')} unset or null as well.",
        flags:"IRWA",
        name:"showClippedValuesOnHover"
    },
    "attr:Window.showShadow":{
        seeAlso:[
        ],
        ref:"attr:Window.showShadow",
        defaultValue:"null",
        deprecated:null,
        type:"attr",
        definingClass:"class:Window",
        valueType:"Boolean",
        description:"Whether to show a drop shadow for this Canvas. \n <P>\n Developers should be aware that the drop shadow\n is drawn outside the specified width and height of the widget meaning a widget with shadows \n takes up a little more space than it otherwise would. A full screen canvas with showShadow set \n to true as this would be likely to cause browser scrollbars to appear - developers can handle\n this by either setting this property to false on full-screen widgets, or by setting\n overflow to \"hidden\" on the &lt;body&gt; element  browser-level scrolling is never intended to occur.\n <P>\n <code>showShadow</code> dynamically defaults to false when the ${isc.DocUtils.linkForRef('attr:Window.placement')} setting\n indicates the Window will be filling a portion of the screen or a panel.",
        flags:"IR",
        name:"showShadow"
    },
    "class:DSUpdateTask":{
        seeAlso:[
        ],
        type:"class",
        staticMethods:[
        ],
        inheritsFrom:"ServiceTask",
        classMethods:[
        ],
        classAttrs:[
        ],
        attrs:[
        ],
        ref:"class:DSUpdateTask",
        deprecated:null,
        treeLocation:[
            "Client Reference/Workflow"
        ],
        description:"A ${isc.DocUtils.linkForRef('class:ServiceTask','ServiceTask')} configured to perform a update.",
        methods:[
        ],
        name:"DSUpdateTask"
    },
    "classAttr:Browser.isTouch":{
        seeAlso:[
        ],
        defaultValue:"auto-detected based on device",
        type:"classAttr",
        definingClass:"class:Browser",
        deprecated:null,
        ref:"classAttr:Browser.isTouch",
        setter:[
            "setIsTouch"
        ],
        valueType:"boolean",
        description:"Is the application running on a touch device (e.g. iPhone, iPad, Android device, etc.)?\n <p>\n SmartClient's auto-detected value for <code>isTouch</code> can be overridden via\n ${isc.DocUtils.linkForRef('classMethod:Browser.setIsTouch')}.",
        flags:"RW",
        name:"isTouch"
    },
    "attr:FilterBuilder.subClauseButtonTitle":{
        seeAlso:[
        ],
        defaultValue:"\"+()\"",
        type:"attr",
        definingClass:"class:FilterBuilder",
        groups:[
            "i18nMessages"
        ],
        deprecated:null,
        ref:"attr:FilterBuilder.subClauseButtonTitle",
        valueType:"String",
        description:"The title of the subClauseButton",
        flags:"IR",
        name:"subClauseButtonTitle"
    },
    "method:Array.findAll":{
        seeAlso:[
        ],
        type:"method",
        definingClass:"object:Array",
        returns:{
            type:"Array",
            description:"all matching Objects or null if none found"
        },
        groups:[
            "access",
            "find"
        ],
        deprecated:null,
        ref:"method:Array.findAll",
        params:[
            {
                defaultValue:null,
                optional:false,
                type:"String | Object | AdvancedCriteria",
                description:"property to match, or if an Object is passed, set of                                        properties and values to match",
                name:"propertyName"
            },
            {
                defaultValue:null,
                optional:true,
                type:"Any",
                description:"value to compare against (if propertyName is a string)",
                name:"value"
            }
        ],
        description:" Find all objects where property == value in the object.\n <P>\n Pass an Object as the <code>propertyName</code> argument to match multiple properties.\n\n",
        flags:"",
        name:"findAll"
    },
    "attr:TreeGrid.useAllDataSourceFields":{
        seeAlso:[
            {
                ref:"attr:FieldPicker.dataBoundComponent",
                description:null
            }
        ],
        defaultValue:"null",
        type:"attr",
        definingClass:"class:TreeGrid",
        groups:[
            "databinding"
        ],
        ref:"attr:TreeGrid.useAllDataSourceFields",
        deprecated:null,
        valueType:"boolean",
        description:"If true, the set of fields given by the \"default binding\" (see \n ${isc.DocUtils.linkForRef('attr:DataBoundComponent.fields')}) is used, with any fields specified in\n <code>component.fields</code> acting as overrides that can suppress or modify the\n display of individual fields, without having to list the entire set of fields that\n should be shown.\n <P>\n If <code>component.fields</code> contains fields that are not found in the DataSource,\n they will be shown after the most recently referred to DataSource field.  If the new\n fields appear first, they will be shown first.\n <P>\n ${isc.DocUtils.linkForExampleId('validationFieldBinding', 'This example')} shows a mixture of component\n fields and DataSource fields, and how they interact for validation.\n <P>\n This setting may be cleared if a ${isc.DocUtils.linkForRef('class:FieldPicker')} is used to edit the component's field\n order.",
        flags:"IRW",
        examples:[
            "${isc.DocUtils.linkForExampleId('validationFieldBinding')}"
        ],
        name:"useAllDataSourceFields"
    },
    "attr:ListPropertiesDialog.cancelButton":{
        seeAlso:[
        ],
        ref:"attr:ListPropertiesDialog.cancelButton",
        defaultValue:"null",
        deprecated:null,
        type:"attr",
        definingClass:"class:ListPropertiesDialog",
        valueType:"AutoChild IButton",
        description:"The Cancel button. When clicked, the ${isc.DocUtils.linkForRef('method:ListPropertiesDialog.cancelClick','cancelClick')}\n event is fired.\n <p>\n ${isc.DocUtils.linkForRef('attr:ListPropertiesDialog.cancelButtonTitle','cancelButtonTitle')} is a ${isc.DocUtils.linkForRef('group:autoChildUsage','passthrough')}\n for the button's ${isc.DocUtils.linkForRef('attr:Button.title','title')}.",
        flags:"R",
        name:"cancelButton"
    },
    "method:MetricSettings.getDataLineWidth":{
        seeAlso:[
            {
                ref:"attr:DrawItem.lineWidth",
                description:null
            },
            {
                ref:"method:MetricSettings.getDataLineColor",
                description:null
            }
        ],
        ref:"method:MetricSettings.getDataLineWidth",
        deprecated:null,
        type:"method",
        definingClass:"object:MetricSettings",
        params:[
            {
                defaultValue:null,
                optional:false,
                type:"Number",
                description:"index of the legend facet value to target",
                name:"index"
            },
            {
                defaultValue:null,
                optional:false,
                type:"String | Number | Date",
                description:"id of the legend facet value to target",
                name:"facetValueId"
            },
            {
                defaultValue:null,
                optional:false,
                type:"String",
                description:"purpose for the requested width - such as \"legend\", \"line\",                         \"area\", \"points\", etc.",
                name:"purpose"
            }
        ],
        description:" Specifies the width to use for data lines in the chart.  No default implementation.  If not\n defined or null is returned, the line width will be set by the appropriate chart properties,\n such as ${isc.DocUtils.linkForRef('attr:FacetChart.dataLineProperties')}, ${isc.DocUtils.linkForRef('attr:FacetChart.barProperties')}, or ${isc.DocUtils.linkForRef('attr:FacetChart.bubbleProperties')}.\n \n <P>\n Note that this method is simply an override point, since it has no default implementation.\n \n\n",
        flags:"",
        returns:{
            type:"int",
            description:"width to use for data lines or null to use ${isc.DocUtils.linkForRef('type:ChartType')} default"
        },
        name:"getDataLineWidth"
    },
    "attr:DatabaseBrowser.selectButton":{
        seeAlso:[
        ],
        ref:"attr:DatabaseBrowser.selectButton",
        defaultValue:"null",
        deprecated:null,
        type:"attr",
        definingClass:"class:DatabaseBrowser",
        valueType:"AutoChild Button",
        description:"Instance of Button used to continue once a table has been selected.",
        flags:"IR",
        name:"selectButton"
    },
    "type:GlobalId":{
        seeAlso:[
        ],
        ref:"type:GlobalId",
        deprecated:null,
        type:"type",
        description:"An ${isc.DocUtils.linkForRef('type:Identifier')} that's unique in the global scope.  For example, the \n ${isc.DocUtils.linkForRef('attr:Canvas.ID','ID')} of a ${isc.DocUtils.linkForRef('class:Canvas')} is a <code>GlobalId</code>.",
        name:"GlobalId",
        baseType:"Identifier"
    },
    "attr:FacetChart.facets":{
        seeAlso:[
        ],
        ref:"attr:FacetChart.facets",
        defaultValue:"null",
        deprecated:null,
        type:"attr",
        definingClass:"class:FacetChart",
        valueType:"Array of Facet | Facet",
        description:"An Array of facets, exactly analogous to ${isc.DocUtils.linkForRef('attr:CubeGrid.facets')}, except that:\n <ul>\n <li> the \"inlinedValues\" property can be set on a facet to change data representation\n as described under ${isc.DocUtils.linkForRef('attr:Chart.data')}.\n <li> for a non-inlined facet, Charts support auto-derivation of facetValues from the\n data.\n </ul>\n <p>\n In all chart types except \"Bubble\" and \"Scatter\", the chart displays a value for each\n discrete value of one facet (i.e. single-facet charts) or it displays a value for each\n combination of discrete values of two facets (multi-facet charts).  The two discrete\n facets are the ${isc.DocUtils.linkForRef('method:FacetChart.getDataLabelFacet','data label facet')} and the\n ${isc.DocUtils.linkForRef('method:FacetChart.getLegendFacet','legend facet')}.  They are named based on where the\n ${isc.DocUtils.linkForRef('attr:Facet.values','values')} of the facet appear in the chart.  The facet whose values\n are rendered as labels along the data axis or in the main chart area is the data label\n facet, and the facet whose values are rendered in the legend is the legend facet.\n <p>\n For single-facet charts, most chart types have a data label facet as the first facet\n but no legend facet.  Single-facet Pie charts have a legend facet as the first facet\n but no data label facet.  Bubble and Scatter plots may have a legend facet as the\n second facet, after the metric facet.\n <p>\n In all multi-facet charts, the data label facet is always first and the legend facet\n is second.  In most chart types the data label facet and the legend facet may be\n swapped on the fly by the user clicking on the \"Swap Facets\" item of the context menu.",
        flags:"IR",
        name:"facets"
    },
    "method:TileGrid.setDragTracker":{
        groups:[
            "dragTracker"
        ],
        seeAlso:[
        ],
        ref:"method:TileGrid.setDragTracker",
        deprecated:null,
        type:"method",
        definingClass:"class:TileGrid",
        description:" Sets the custom tracker HTML to display next to the mouse when the user initiates a drag\n operation on this component. Default implementation will examine ${isc.DocUtils.linkForRef('attr:ListGrid.dragTrackerMode')}\n and set the custom drag tracker to display the appropriate HTML based on the selected record.\n <br>\n To display custom drag tracker HTML, this method may be overridden - call \n ${isc.DocUtils.linkForRef('classMethod:EventHandler.setDragTracker')} to actually update the drag tracker HTML.\n",
        flags:"",
        returns:{
            type:"boolean",
            description:"returns false by default to suppress 'setDragTracker' on any ancestors                   of this component."
        },
        name:"setDragTracker"
    },
    "classMethod:DateUtil.combineLogicalDateAndTime":{
        seeAlso:[
        ],
        ref:"classMethod:DateUtil.combineLogicalDateAndTime",
        deprecated:null,
        type:"classMethod",
        definingClass:"class:DateUtil",
        params:[
            {
                defaultValue:null,
                optional:false,
                type:"Date",
                description:"a Date instance representing logical date value",
                name:"date"
            },
            {
                defaultValue:null,
                optional:false,
                type:"Date",
                description:"a Date instance representing logical time value",
                name:"time"
            }
        ],
        description:" Combine a logical date (a value appropriate for a DataSourceField of type \"date\") with a\n logical time (a value appropriate for a DataSourceField of type \"time\") into a datetime\n value (a value appropriate for a DataSourceField of type \"datetime\")\n <P>\n This method correctly takes into account the current\n ${isc.DocUtils.linkForRef('classMethod:Time.setDefaultDisplayTimezone','display timezone')}, specifically, the returned datetime\n value will show the same date and time as the passed date and time objects when rendered by\n a SmartClient component that has been configured with a field of type \"datetime\".\n <P>\n For further background on date, time and datetime types, storage and transmission, see\n ${isc.DocUtils.linkForRef('group:dateFormatAndStorage','this overview')}.\n\n",
        flags:"",
        returns:{
            type:"Date",
            description:"a Date instance representing a datetime value combining the logical date and                time passed"
        },
        name:"combineLogicalDateAndTime"
    },
    "method:DataSource.filterData":{
        groups:[
            "operations"
        ],
        seeAlso:[
        ],
        ref:"method:DataSource.filterData",
        deprecated:null,
        type:"method",
        definingClass:"class:DataSource",
        params:[
            {
                defaultValue:null,
                optional:true,
                type:"Criteria",
                description:"search criteria",
                name:"criteria"
            },
            {
                defaultValue:null,
                optional:true,
                type:"DSCallback",
                description:"callback to invoke on completion",
                name:"callback"
            },
            {
                defaultValue:null,
                optional:true,
                type:"DSRequest Properties",
                description:"additional properties to set on                                                       the DSRequest that will be issued",
                name:"requestProperties"
            }
        ],
        description:" Perform a \"fetch\" DataSource operation against this DataSource, sending search criteria\n and retrieving matching records.\n <P>\n This is identical to ${isc.DocUtils.linkForRef('method:DataSource.fetchData')} except that\n ${isc.DocUtils.linkForRef('attr:DSRequest.textMatchStyle')} is set to \"substring\" to cause case insensitive\n substring matching (if the server respects this setting).\n\n",
        flags:"",
        name:"filterData"
    },
    "attr:FacetChart.extraAxisSettings":{
        seeAlso:[
        ],
        ref:"attr:FacetChart.extraAxisSettings",
        defaultValue:"[]",
        deprecated:null,
        type:"attr",
        definingClass:"class:FacetChart",
        valueType:"Array of MetricSettings",
        description:"For charts will multiple vertical axes, optionally provides settings for how each\n ${isc.DocUtils.linkForRef('attr:FacetChart.extraAxisMetrics','extra axis metric')} is plotted.  See the main ${isc.DocUtils.linkForRef('class:FacetChart')}\n docs for an overview of how multi-axis charts are used.\n <p>\n The chart of each metric's values may be of any rectangular chart type that uses a\n vertical value axis (\"Column\", \"Area\", or \"Line\" - \"Histogram\" is not supported).\n Because the charts will be superimposed over the same drawing area, there can only\n be one \"Column\" chart and one \"Area\" chart.  The column chart is placed on the bottom\n followed by the area chart, and then the line charts are drawn on top in the\n order of their metric in the ${isc.DocUtils.linkForRef('attr:FacetChart.extraAxisMetrics')} array.\n If the ${isc.DocUtils.linkForRef('attr:MetricSettings.chartType','chartType')}s\n are left unspecified then by default the first metric will be drawn as\n columns and the remaining will be drawn as lines.",
        flags:"IR",
        name:"extraAxisSettings"
    },
    "attr:DynamicForm.errorItemProperties":{
        seeAlso:[
        ],
        defaultValue:"null",
        type:"attr",
        definingClass:"class:DynamicForm",
        groups:[
            "validation"
        ],
        deprecated:null,
        ref:"attr:DynamicForm.errorItemProperties",
        valueType:"Object",
        description:"If ${isc.DocUtils.linkForRef('attr:DynamicForm.showInlineErrors')} is false we show all errors for the form item in \n a single item rendered at the top of the form.<br>\n This attribute contains a properties block for this item.",
        flags:"IRA",
        name:"errorItemProperties"
    },
    "attr:DataSource.translatePatternOperators":{
        seeAlso:[
        ],
        ref:"attr:DataSource.translatePatternOperators",
        defaultValue:"false",
        deprecated:null,
        type:"attr",
        definingClass:"class:DataSource",
        valueType:"boolean",
        description:"${isc.DocUtils.linkForRef('type:OperatorId','Search operators')} like \"matchesPattern\" use patterns like\n \"foo*txt\" to match text values.  The patterns are similar to the patterns you use to\n match names of files in a command-line interface, or to the pattern allowed for the SQL\n \"LIKE\" operator.\n <p>\n <code>translatePatternOperators</code> controls whether these pattern operators should\n be translated to a nested series of \"startsWith\"/\"endsWidth\"/\"contains\" operators before\n being sent to the server.  This allows a server that only implements simple operators\n like \"startsWith\" to support pattern operators such as \"matchesPattern\" and\n \"containsPattern\", but with caveats:\n    <ul>\n        <li> single-character wildcards are not supported\n        <li> multiple wildcards are not truly order-dependent, for example *1*2*3* will\n             match 1,2,3 as interior characters in any order.  \n        <li> may be less efficient than a direct server-side implementation that is able to\n             translate the pattern directly to the underlying storage engine.\n    </ul>\n <p>\n Note that since \"containsPattern\" is essentially equivalent to \"matchesPattern\" but with\n \"*\" wildcards at the beginning and end of every pattern, the second limitation (pattern\n not really order dependent) may be fairly obvious to users when using this feature.  For\n example, \"m*t\" will match \"we meet\" and \"we teem\".\n <p>\n The following are examples of how patterns are translated to simpler operators.  Note\n that the case sensitive version of the operator is referred to below, but of course\n \"iMatchesPattern\" and \"iContainsPattern\" will be translated to case-insensitive versions\n of these operators, such as \"iStartsWith\".\n <p>\n *foo (endsWith)<br>\n foo* (startsWith)<br>\n *foo* (contains)<br>\n *foo*bar (contains and endsWith)<br>\n foo*bar* (startsWith and contains)<br>\n foo*bar (startsWith and endsWith)<br>\n *foo*bar* (multiple contains)\n <p>\n Also supported: one startsWith, multiple contains, one endsWith.",
        flags:"IR",
        name:"translatePatternOperators"
    },
    "method:MetricSettings.formatDataValue":{
        seeAlso:[
        ],
        type:"method",
        definingClass:"object:MetricSettings",
        returns:{
            type:"String",
            description:"the text to display."
        },
        groups:[
            "display_values"
        ],
        deprecated:null,
        ref:"method:MetricSettings.formatDataValue",
        params:[
            {
                defaultValue:null,
                optional:false,
                type:"Any",
                description:"raw value of the metric",
                name:"value"
            }
        ],
        description:" Return the text string to display in labels \n ${isc.DocUtils.linkForRef('attr:FacetChart.showDataValuesMode','in the chart-body or in hovers')}  given the raw value \n for the metric displayed on the value axis.\n <p>\n This method may also be passed the ${isc.DocUtils.linkForRef('type:FormattingContext','context')} for which the \n value is being formatted, the record associated with the value and the id of its \n ${isc.DocUtils.linkForRef('attr:FacetChart.facets','facet')}.\n <p>\n Note that the rendering of values for gradation labels is handled by\n ${isc.DocUtils.linkForRef('method:MetricSettings.formatAxisValue')}.\n",
        flags:"",
        name:"formatDataValue"
    },
    "attr:FacetChart.errorBarWidth":{
        seeAlso:[
        ],
        ref:"attr:FacetChart.errorBarWidth",
        defaultValue:"6",
        deprecated:null,
        type:"attr",
        definingClass:"class:FacetChart",
        valueType:"int",
        description:"Width of the horizontal line of the \"T\"-shape portion of the error bar).",
        flags:"IR",
        name:"errorBarWidth"
    },
    "attr:ListGrid.expansionFieldImageShowSelected":{
        seeAlso:[
        ],
        defaultValue:"false",
        type:"attr",
        definingClass:"class:ListGrid",
        groups:[
            "expansionField"
        ],
        deprecated:null,
        ref:"attr:ListGrid.expansionFieldImageShowSelected",
        valueType:"boolean",
        description:"Should a \"_selected\" suffix be added to the \n ${isc.DocUtils.linkForRef('attr:ListGrid.expansionFieldTrueImage','expansionFieldTrueImage')}\n and ${isc.DocUtils.linkForRef('attr:ListGrid.expansionFieldFalseImage','expansionFieldFalseImage')} image URLs for\n selected rows?\n <P>\n This allows developers to provide separate expansion field media for selected\n rows, in case the selected row style does not contrast well with the standard\n expansion field image media.\n <P>\n If both this property and ${isc.DocUtils.linkForRef('attr:ListGrid.expansionFieldImageShowRTL')} are true, and\n the grid is in RTL mode, both suffixes will be applied to selected rows'\n expansion field image (combined as \"selected_rtl\")",
        flags:"IRA",
        name:"expansionFieldImageShowSelected"
    },
    "attr:SelectOtherItem.separatorTitle":{
        seeAlso:[
        ],
        defaultValue:"\"--------------------\"",
        type:"attr",
        definingClass:"class:SelectOtherItem",
        groups:[
            "appearance"
        ],
        deprecated:null,
        ref:"attr:SelectOtherItem.separatorTitle",
        valueType:"String",
        description:"Title for the separator between normal items and the <code>Other...</code> item in the drop\n down list.  Selecting this item will not change the FormItem's value.",
        flags:"IRW",
        name:"separatorTitle"
    },
    "method:SelectItemEditProxy.setInlineEditText":{
        seeAlso:[
        ],
        ref:"method:SelectItemEditProxy.setInlineEditText",
        deprecated:null,
        type:"method",
        definingClass:"class:SelectItemEditProxy",
        params:[
            {
                defaultValue:null,
                optional:false,
                type:"String",
                description:"the new component valueMap",
                name:"newValue"
            }
        ],
        description:" Save the new value into the component's state. Called by the\n ${isc.DocUtils.linkForRef('attr:EditProxy.inlineEditForm')} to commit the change.\n <p>\n Updates the component's valueMap and current value.\n\n",
        flags:"",
        name:"setInlineEditText"
    },
    "method:ValuesManager.hasErrors":{
        groups:[
            "errors"
        ],
        seeAlso:[
        ],
        ref:"method:ValuesManager.hasErrors",
        deprecated:null,
        type:"method",
        definingClass:"class:ValuesManager",
        description:" Are there any errors associated with any fields in this valuesManager?\n",
        flags:"",
        returns:{
            type:"Boolean",
            description:"returns true if there are any outstanding validation errors, false                   otherwise."
        },
        name:"hasErrors"
    },
    "attr:DataSourceField.columnCode":{
        seeAlso:[
        ],
        requiresModules:[
            "SCServer"
        ],
        defaultValue:"null",
        type:"attr",
        definingClass:"object:DataSourceField",
        ref:"attr:DataSourceField.columnCode",
        deprecated:null,
        valueType:"String",
        description:"See ${isc.DocUtils.linkForRef('attr:DataSource.tableCode')}.",
        flags:"R",
        serverDS:"only",
        name:"columnCode"
    },
    "attr:ImgButton.showTitle":{
        seeAlso:[
        ],
        ref:"attr:ImgButton.showTitle",
        defaultValue:"false",
        deprecated:null,
        type:"attr",
        definingClass:"class:ImgButton",
        valueType:"Boolean",
        description:"Determines whether any specified ${isc.DocUtils.linkForRef('method:StatefulCanvas.getTitle','title')} will be \n displayed for this component.<br>\n Applies to Image-based components only, where the title will be rendered out in a label\n floating over the component",
        flags:"IRWA",
        name:"showTitle"
    },
    "attr:Window.showTitle":{
        seeAlso:[
        ],
        defaultValue:"true",
        type:"attr",
        definingClass:"class:Window",
        groups:[
            "windowHeader",
            "appearance",
            "headerLabel"
        ],
        ref:"attr:Window.showTitle",
        deprecated:null,
        setter:[
            "setShowTitle"
        ],
        valueType:"Boolean",
        description:"Show a title (typically just text) on the header for this window.",
        flags:"IRW",
        name:"showTitle"
    },
    "attr:DataSourceField.valueMap":{
        seeAlso:[
        ],
        defaultValue:"null",
        type:"attr",
        definingClass:"object:DataSourceField",
        groups:[
            "dataType"
        ],
        ref:"attr:DataSourceField.valueMap",
        deprecated:null,
        valueType:"ValueMap",
        description:"A ${isc.DocUtils.linkForRef('type:ValueMap')} is a set of legal values for a field.\n <p>\n The valueMap can be specified as either an Array of legal values, or as an\n ${isc.DocUtils.linkForRef('type:Object')} where each property maps a stored value to a user-displayable value.\n <p>\n To enforce that a field should be constrained to only the values in the valueMap, either\n declare ${isc.DocUtils.linkForRef('attr:DataSourceField.type','field.type')} as \"enum\", or use a\n ${isc.DocUtils.linkForRef('type:ValidatorType')} of \"isOneOf\" with explicitly listed values.  Otherwise,\n although a normal ${isc.DocUtils.linkForRef('class:SelectItem')} control will only allow values from the valueMap to be\n entered, other controls such as a ${isc.DocUtils.linkForRef('class:ComboBoxItem','ComboBox')} will allow other values \n to be entered.\n <p>\n In XML, a valueMap that specifies only a list of legal values is specified as follows:\n <pre>\n   &lt;valueMap&gt;\n   \t&lt;value&gt;Pens &amp; Pencils&lt;/value&gt;\n   \t&lt;value&gt;Stationery&lt;/value&gt;\n   \t&lt;value&gt;Computer Products&lt;/value&gt;\n   \t&lt;value&gt;Furniture&lt;/value&gt;\n   \t&lt;value&gt;Misc&lt;/value&gt;\n   &lt;/valueMap&gt;\n </pre>\n A ValueMap that specifies stored values mapped to user-visible values is specified as\n follows:\n <pre>\n   &lt;valueMap&gt;\n   \t&lt;value ID=\"1\"&gt;Pens &amp; Pencils&lt;/value&gt;\n   \t&lt;value ID=\"2\"&gt;Stationery&lt;/value&gt;\n   \t&lt;value ID=\"3\"&gt;Computer Products&lt;/value&gt;\n   \t&lt;value ID=\"4\"&gt;Furniture&lt;/value&gt;\n   \t&lt;value ID=\"5\"&gt;Misc&lt;/value&gt;\n   &lt;/valueMap&gt;\n </pre>",
        flags:"IR",
        serverDS:"allowed",
        name:"valueMap"
    },
    "attr:SplitPane.currentPane":{
        seeAlso:[
        ],
        defaultValue:"\"navigation\"",
        type:"attr",
        definingClass:"class:SplitPane",
        deprecated:null,
        ref:"attr:SplitPane.currentPane",
        setter:[
            "setCurrentPane"
        ],
        valueType:"CurrentPane",
        description:"The most recently shown pane.  In handset ${isc.DocUtils.linkForRef('type:DeviceMode')}, the\n <code>currentPane</code> is the only pane that is actually visible to the user.  In other\n modes more than one pane can be simultaneously visible, so the <code>currentPane</code> is\n the most recent pane that was brought into view via a call to ${isc.DocUtils.linkForRef('method:SplitPane.setCurrentPane')} or\n ${isc.DocUtils.linkForRef('method:SplitPane.showNavigationPane')}.\n <p>\n The default value of <code>currentPane</code> is \"navigation\".",
        flags:"IRW",
        name:"currentPane"
    },
    "classMethod:Log.getCallTrace":{
        groups:[
            "debug"
        ],
        seeAlso:[
        ],
        ref:"classMethod:Log.getCallTrace",
        deprecated:null,
        type:"classMethod",
        definingClass:"class:Log",
        params:[
            {
                defaultValue:null,
                optional:true,
                type:"Arguments",
                description:"arguments object from the call to trace. If ommitted, where supported,    arguments will be derived from the calling function, or if this is not supported, the method\n   will not function.",
                name:"args"
            }
        ],
        description:" Returns a one-line summary of the current method call, showing method name and passed\n arguments. \n This function is available as a static on every ISC Class and as an instance\n method on every instance of an ISC Class.<br>\n General best practice is to call the method as \"this.getCallTrace(arguments)\" whenever \"this\" is an\n instance, or call the static classMethod on the ${isc.DocUtils.linkForRef('class:Log')} class otherwise. \n <P>\n Note the <code>arguments</code> object is required in most cases for this method to function. In some\n browsers, it can be derived automatically, but developers looking to debug on multiple platforms\n should not rely on this.\n\n",
        flags:"",
        name:"getCallTrace"
    },
    "attr:NavPanel.headerStyle":{
        seeAlso:[
        ],
        ref:"attr:NavPanel.headerStyle",
        defaultValue:"\"navItemHeader\"",
        deprecated:null,
        type:"attr",
        definingClass:"class:NavPanel",
        valueType:"CSSStyleName",
        description:"CSS style used when ${isc.DocUtils.linkForRef('attr:NavItem.isHeader')} is set on an item.\n May be overridden for a specific header item by ${isc.DocUtils.linkForRef('attr:NavItem.customStyle')}.",
        flags:"IR",
        name:"headerStyle"
    },
    "attr:StretchImgButton.height":{
        seeAlso:[
            {
                ref:"attr:StatefulCanvas.autoFit",
                description:null
            }
        ],
        defaultValue:"null",
        type:"attr",
        definingClass:"class:StretchImgButton",
        groups:[
            "sizing"
        ],
        deprecated:null,
        ref:"attr:StretchImgButton.height",
        valueType:"Number | String",
        description:"Size for this component's vertical dimension.  See ${isc.DocUtils.linkForRef('attr:Canvas.height')} for more\n details.\n <P>\n Note that if ${isc.DocUtils.linkForRef('attr:StatefulCanvas.autoFit')} is set on non-${isc.DocUtils.linkForRef('class:StretchImgButton')} instances, this\n property will be ignored so that the widget is always sized just large enough to\n accommodate the title.",
        flags:"IRW",
        name:"height"
    },
    "attr:MiniDateRangeItem.fromDate":{
        seeAlso:[
        ],
        defaultValue:"today",
        type:"attr",
        definingClass:"class:MiniDateRangeItem",
        deprecated:null,
        ref:"attr:MiniDateRangeItem.fromDate",
        setter:[
            "setFromDate"
        ],
        valueType:"Date | RelativeDateString | TimeUnit",
        description:"Initial value for the \"from\" date.",
        flags:"IRW",
        name:"fromDate"
    },
    "method:FormItem.parseEditorValue":{
        seeAlso:[
        ],
        ref:"method:FormItem.parseEditorValue",
        deprecated:null,
        type:"method",
        definingClass:"class:FormItem",
        params:[
            {
                defaultValue:null,
                optional:false,
                type:"String",
                description:"value as entered by the user",
                name:"value"
            },
            {
                defaultValue:null,
                optional:false,
                type:"DynamicForm",
                description:"pointer to the dynamicForm containing this item",
                name:"form"
            },
            {
                defaultValue:null,
                optional:false,
                type:"FormItem",
                description:"pointer to this item",
                name:"item"
            }
        ],
        description:" Allows customization of how a used-entered text value is converted to the FormItem's\n logical stored value (the value available from ${isc.DocUtils.linkForRef('method:FormItem.getValue')}).  \n <p>\n This method only applies to form items which show an editable text entry area, such at\n the ${isc.DocUtils.linkForRef('class:TextItem')} or ${isc.DocUtils.linkForRef('class:TextAreaItem')}.\n <p>\n See also ${isc.DocUtils.linkForRef('method:FormItem.formatEditorValue')}\n\n",
        flags:"",
        returns:{
            type:"Any",
            description:"Data value to store for this item."
        },
        name:"parseEditorValue"
    },
    "type:LinePattern":{
        groups:[
            "line"
        ],
        seeAlso:[
        ],
        ref:"type:LinePattern",
        deprecated:null,
        type:"type",
        values:[
            {
                value:"\"solid\"",
                description:"Solid line"
            },
            {
                value:"\"dot\"",
                description:"Dotted line"
            },
            {
                value:"\"dash\"",
                description:"Dashed line"
            },
            {
                value:"\"shortdot\"",
                description:"Dotted line, with more tightly spaced dots"
            },
            {
                value:"\"shortdash\"",
                description:"Dashed line, with shorter, more tightly spaced dashes"
            },
            {
                value:"\"longdash\"",
                description:"Dashed line, with longer, more widely spaced dashes"
            }
        ],
        description:"Supported styles of drawing lines.",
        name:"LinePattern"
    },
    "attr:OperationBinding.exportFilename":{
        seeAlso:[
        ],
        defaultValue:"null",
        type:"attr",
        definingClass:"class:OperationBinding",
        deprecated:null,
        ref:"attr:OperationBinding.exportFilename",
        valueType:"String",
        description:"The name of the file to save the exported data into.",
        flags:"IR",
        serverDS:"allowed",
        name:"exportFilename"
    },
    "method:Canvas.setOpacity":{
        seeAlso:[
        ],
        type:"method",
        definingClass:"class:Canvas",
        groups:[
            "cues"
        ],
        deprecated:null,
        ref:"method:Canvas.setOpacity",
        params:[
            {
                defaultValue:null,
                optional:false,
                type:"number",
                description:"new opacity level",
                name:"newOpacity"
            }
        ],
        description:" Sets the opacity for the widget to the newOpacity value. This newOpacity\n value must be within the range of 0 (transparent) to 100 (opaque).\n Null means don't specify opacity directly.\n Note that heavy use of opacity may have a performance impact on some older\n browsers.\n <P>\n In older versions of Internet Explorer (Pre IE9 / HTML5), opacity is achieved\n through proprietary filters. If\n ${isc.DocUtils.linkForRef('classAttr:Canvas.neverUseFilters','filters have been disabled')} within this application\n developers must set ${isc.DocUtils.linkForRef('attr:Canvas.useOpacityFilter')} to true for specific components\n on which opacity support is required.\n <P>\n Also note that opacity is incompatible\n with ${isc.DocUtils.linkForRef('attr:Canvas.useBackMask','backMasks')}.\n",
        flags:"",
        examples:[
            "${isc.DocUtils.linkForExampleId('translucency')}"
        ],
        name:"setOpacity"
    },
    "attr:ListGrid.valueIconSize":{
        seeAlso:[
            {
                ref:"attr:ListGrid.valueIconWidth",
                description:null
            },
            {
                ref:"attr:ListGrid.valueIconHeight",
                description:null
            },
            {
                ref:"attr:ListGridField.valueIconSize",
                description:null
            }
        ],
        defaultValue:"16",
        type:"attr",
        definingClass:"class:ListGrid",
        groups:[
            "imageColumns"
        ],
        deprecated:null,
        ref:"attr:ListGrid.valueIconSize",
        valueType:"number",
        description:"Default width and height of value icons for this ListGrid.\n Can be overridden at the listGrid level via explicit ${isc.DocUtils.linkForRef('attr:ListGrid.valueIconWidth')} and\n ${isc.DocUtils.linkForRef('attr:ListGrid.valueIconHeight')}, or at the field level via ${isc.DocUtils.linkForRef('attr:ListGridField.valueIconSize')},\n ${isc.DocUtils.linkForRef('attr:ListGridField.valueIconWidth')} and {ListGridField.valueIconHeight}",
        flags:"IRW",
        name:"valueIconSize"
    },
    "classAttr:Dialog.Warn":{
        seeAlso:[
            {
                ref:"staticMethod:isc.warn",
                description:null
            },
            {
                ref:"staticMethod:isc.ask",
                description:null
            }
        ],
        defaultValue:"dialog instance properties",
        type:"classAttr",
        definingClass:"class:Dialog",
        groups:[
            "Prompting"
        ],
        deprecated:null,
        ref:"classAttr:Dialog.Warn",
        valueType:"Dialog Properties",
        description:"A singleton Dialog instance that will show text to the user and provide buttons for their\n response.  The Dialog will expand to show all the text that you put into it. This dialog\n is shown in response to calls to ${isc.DocUtils.linkForRef('staticMethod:isc.say')},\n ${isc.DocUtils.linkForRef('staticMethod:isc.warn')}, ${isc.DocUtils.linkForRef('staticMethod:isc.ask')} and\n ${isc.DocUtils.linkForRef('staticMethod:isc.confirm')}.\n <P>\n This can be used in cases where a developer would alternatively make use of the native\n JavaScript <code>alert()</code> and <code>confirm()</code> methods.  The main differences\n between those methods and using the Warn object are:<br>\n - The Warn object can be customized by modifying which buttons are visible, the style\n   applied to it, etc.<br>\n - The <code>isc.ask()</code> and <code>isc.warn()</code> methods are asynchronous - rather\n   than returning a value indicating the user's response, a callback method will be fired\n   when the user interacts with the dialog.<br><br>\n \n Notes:<br>\n  Because this is a singleton object, properties set on the Warn object directly will persist\n  each time it is shown.<br>\n  Developers should use the <code>warn()</code> or <code>ask()</code> methods to show and\n  hide this object rather than manipulating the Dialog directly.",
        flags:"A",
        name:"Warn"
    },
    "attr:CubeGrid.sortDirection":{
        seeAlso:[
        ],
        ref:"attr:CubeGrid.sortDirection",
        defaultValue:"\"ascending\"",
        deprecated:null,
        type:"attr",
        definingClass:"class:CubeGrid",
        valueType:"SortDirection",
        description:"Direction of sorting if sortedFacet or sortedFacetValues is specified.",
        flags:"IRW",
        name:"sortDirection"
    },
    "attr:ServiceTask.failureElement":{
        seeAlso:[
        ],
        ref:"attr:ServiceTask.failureElement",
        defaultValue:"null",
        deprecated:null,
        type:"attr",
        definingClass:"class:ServiceTask",
        valueType:"String",
        description:"ID of the next sequence or element to proceed to if a failure condition arises\n from DataSource operation.",
        flags:"IR",
        name:"failureElement"
    },
    "attr:DateChooser.baseWeekdayStyle":{
        seeAlso:[
        ],
        ref:"attr:DateChooser.baseWeekdayStyle",
        defaultValue:"\"dateChooserWeekday\"",
        deprecated:null,
        type:"attr",
        definingClass:"class:DateChooser",
        valueType:"CSSStyleName",
        description:"Base CSS style applied to weekdays. Will have \"Over\", \"Selected\" and \"Down\"\n suffix appended as the user interacts with buttons.  Defaults to ${isc.DocUtils.linkForRef('attr:DateChooser.baseButtonStyle')}.\n <P>\n See ${isc.DocUtils.linkForRef('group:cellStyleSuffixes')} for details on how stateful suffixes are combined with the\n base style to generate stateful cell styles in Grids.",
        flags:"IRW",
        name:"baseWeekdayStyle"
    },
    "attr:EditNode.liveObject":{
        seeAlso:[
        ],
        ref:"attr:EditNode.liveObject",
        defaultValue:"null",
        deprecated:null,
        type:"attr",
        definingClass:"object:EditNode",
        valueType:"Object",
        description:"Live version of the object created from the ${isc.DocUtils.linkForRef('attr:EditNode.defaults')}.  For example, \n if ${isc.DocUtils.linkForRef('attr:EditNode.type')} is \"ListGrid\", <code>liveObject</code> would be a ListGrid.",
        flags:"IR",
        name:"liveObject"
    },
    "attr:MetricSettings.proportional":{
        seeAlso:[
        ],
        defaultValue:"null",
        type:"attr",
        definingClass:"object:MetricSettings",
        ref:"attr:MetricSettings.proportional",
        deprecated:null,
        setter:[
            "setProportional"
        ],
        valueType:"boolean",
        description:"For multi-facet charts, render data values as a proportion of the sum of all data\n values that have the same label.\n <p>\n Gradation labels will be switched to show percentage instead of absolute values.\n <p>\n This setting is valid only for Column, Bar, Area and Radar chart types and only in\n ${isc.DocUtils.linkForRef('attr:MetricSettings.stacked','stacked')} mode.  Stacked columns will be as tall as the chart rect and\n stacked bars will be as wide as the chart rect.  Area and Radar charts will be\n completely filled except for facet values where all values are 0.",
        flags:"IRW",
        examples:[
            "${isc.DocUtils.linkForExampleId('multiSeriesChart')}"
        ],
        name:"proportional"
    },
    "classAttr:Layout.VERTICAL":{
        seeAlso:[
        ],
        defaultValue:"\"vertical\"",
        type:"classAttr",
        definingClass:"class:Layout",
        deprecated:null,
        ref:"classAttr:Layout.VERTICAL",
        valueType:"Constant",
        description:"A declared value of the enum type  \n ${isc.DocUtils.linkForRef('type:Orientation','Orientation')}.",
        flags:"R",
        name:"VERTICAL",
        constant:true
    },
    "attr:Gauge.dialRadius":{
        seeAlso:[
        ],
        defaultValue:"150",
        type:"attr",
        definingClass:"class:Gauge",
        deprecated:null,
        ref:"attr:Gauge.dialRadius",
        setter:[
            "setDialRadius"
        ],
        valueType:"float",
        description:"Radius in pixels of the dial.",
        flags:"IRW",
        name:"dialRadius"
    },
    "attr:ComboBoxItem.iconPlacement":{
        seeAlso:[
        ],
        ref:"attr:ComboBoxItem.iconPlacement",
        defaultValue:"\"both\"",
        deprecated:null,
        type:"attr",
        definingClass:"class:ComboBoxItem",
        valueType:"PickListItemIconPlacement",
        description:"For PickList items with ${isc.DocUtils.linkForRef('type:PickListItemIconPlacement')} set such that the pickList does\n not render near-origin, should specified ${isc.DocUtils.linkForRef('attr:FormItem.icons','icons')} be rendered inline within\n the formItem itself, or within the ${isc.DocUtils.linkForRef('attr:ComboBoxItem.pickerNavigationBar','pickerNavigationBar')}.\n <P>\n May be overridden at the icon level via ${isc.DocUtils.linkForRef('attr:FormItemIcon.iconPlacement')}.\n <P>\n For mobile browsing with limited available screen space, icons rendered in\n the navigation bar may be easier for the user to interact with.",
        flags:"IR",
        name:"iconPlacement"
    },
    "attr:DrawCurve.endPoint":{
        seeAlso:[
        ],
        defaultValue:"[100,100]",
        type:"attr",
        definingClass:"class:DrawCurve",
        deprecated:null,
        ref:"attr:DrawCurve.endPoint",
        setter:[
            "setEndPoint"
        ],
        valueType:"Point",
        description:"End point of the curve",
        flags:"IRW",
        name:"endPoint"
    },
    "attr:Calendar.cancelButton":{
        seeAlso:[
        ],
        ref:"attr:Calendar.cancelButton",
        defaultValue:"null",
        deprecated:null,
        type:"attr",
        definingClass:"class:Calendar",
        valueType:"AutoChild IButton",
        description:"An ${isc.DocUtils.linkForRef('type:AutoChild')} of type ${isc.DocUtils.linkForRef('class:IButton')}, used to cancel editing of an event and close the \n ${isc.DocUtils.linkForRef('attr:Calendar.eventEditor','eventEditor')}.",
        flags:"R",
        name:"cancelButton"
    },
    "class:DrawKnob":{
        seeAlso:[
        ],
        type:"class",
        staticMethods:[
        ],
        inheritsFrom:"Canvas",
        classMethods:[
        ],
        classAttrs:[
        ],
        attrs:[
            "attr:DrawKnob.knobShape",
            "attr:DrawKnob.knobShapeDefaults",
            "attr:DrawKnob.drawPane",
            "attr:DrawKnob.x",
            "attr:DrawKnob.y"
        ],
        ref:"class:DrawKnob",
        deprecated:null,
        treeLocation:[
            "Client Reference/Drawing"
        ],
        description:"Canvas that renders a ${isc.DocUtils.linkForRef('class:DrawItem')} into a ${isc.DocUtils.linkForRef('class:DrawPane')} and provides interactivity for\n that drawItem, including drag and drop.\n <P>\n A DrawKnob can either be initialized with a ${isc.DocUtils.linkForRef('attr:DrawKnob.knobShape','DrawItem knobShape')} or created via\n the ${isc.DocUtils.linkForRef('type:AutoChild')} pattern.\n <P>\n DrawKnobs are used by the ${isc.DocUtils.linkForRef('attr:DrawItem.knobs','drawItem control knobs')} subsystem.",
        methods:[
            "method:DrawKnob.setCenterPoint",
            "method:DrawKnob.updatePoints"
        ],
        name:"DrawKnob"
    },
    "attr:TabSet.symmetricEdges":{
        seeAlso:[
        ],
        defaultValue:"true",
        type:"attr",
        definingClass:"class:TabSet",
        groups:[
            "appearance"
        ],
        deprecated:null,
        ref:"attr:TabSet.symmetricEdges",
        valueType:"Boolean",
        description:"If this tabSet will ${isc.DocUtils.linkForRef('attr:TabSet.showPaneContainerEdges','show edges')} for the paneContainer,\n this property determines whether the same edge media will be used regardless of the tab\n bar position, or whether different media should be used (necessary if the edge appearance is\n not symmetrical on all sides).\n <P>\n If this property is set to false the paneContainer edge image URLs will be prefixed with\n the tabBarPosition of the tabSet - for example <code>\"[SKIN]edge_top_T.gif\"</code> rather\n than just <code>\"[SKIN]edge_T.gif\"</code>.\n <P>\n When <code>symmetricEdges</code> is false, custom edge sizes for the pane container may be\n specified via ${isc.DocUtils.linkForRef('attr:TabSet.topEdgeSizes')} et al, and custom edge offsets via \n ${isc.DocUtils.linkForRef('attr:TabSet.topEdgeOffsets')} et al.",
        flags:"IR",
        name:"symmetricEdges"
    },
    "object:isc":{
        seeAlso:[
        ],
        type:"object",
        staticMethods:[
            "staticMethod:isc.showPrompt",
            "staticMethod:isc.clearPrompt",
            "staticMethod:isc.showFadingPrompt",
            "staticMethod:isc.warn",
            "staticMethod:isc.say",
            "staticMethod:isc.ask",
            "staticMethod:isc.confirm",
            "staticMethod:isc.askForValue",
            "staticMethod:isc.dismissCurrentDialog",
            "staticMethod:isc.showLoginDialog",
            "staticMethod:isc.logWarn",
            "staticMethod:isc.echo",
            "staticMethod:isc.echoAll",
            "staticMethod:isc.echoLeaf",
            "staticMethod:isc.logEcho",
            "staticMethod:isc.logEchoAll",
            "staticMethod:isc.addProperties",
            "staticMethod:isc.getKeys",
            "staticMethod:isc.firstKey",
            "staticMethod:isc.getValues",
            "staticMethod:isc.sortObject",
            "staticMethod:isc.sortObjectByProperties",
            "staticMethod:isc.addDefaults",
            "staticMethod:isc.propertyDefined",
            "staticMethod:isc.defineClass",
            "staticMethod:isc.overwriteClass",
            "staticMethod:isc.eval",
            "staticMethod:isc.timeStamp",
            "staticMethod:isc.showConsole",
            "staticMethod:isc.getValueForKey",
            "staticMethod:isc.getKeyForValue",
            "staticMethod:isc.makeReverseMap",
            "staticMethod:isc.observe",
            "staticMethod:isc.ignore",
            "staticMethod:isc.setAutoDraw",
            "staticMethod:isc.clone",
            "staticMethod:isc.shallowClone",
            "staticMethod:isc.setScreenReaderMode",
            "staticMethod:isc.notify",
            "staticMethod:isc.getIconLeft",
            "staticMethod:isc.getIconTop",
            "staticMethod:isc.getIconRect",
            "staticMethod:isc.getIconPageRect",
            "staticMethod:isc.setRadioGroup"
        ],
        classMethods:[
        ],
        classAttrs:[
        ],
        attrs:[
        ],
        ref:"object:isc",
        deprecated:null,
        treeLocation:[
            "Client Reference/System"
        ],
        description:"<code>window.isc</code> is the base object for the Isomorphic SmartClient framework. \n Every SmartClient class is available on this object as <code>isc.<i>ClassName</i></code>.\n The <code>isc</code> also contains a number of static utility methods.\n <P>\n See also ${isc.DocUtils.linkForRef('group:simpleNamesMode','Simple Names mode')}.",
        methods:[
        ],
        name:"isc"
    },
    "attr:DataSourceField.initRequiresAuthentication":{
        seeAlso:[
            {
                ref:"attr:DataSourceField.editRequiresAuthentication",
                description:null
            }
        ],
        defaultValue:"null",
        requiresModules:[
            "SCServer"
        ],
        type:"attr",
        definingClass:"object:DataSourceField",
        groups:[
            "fieldLevelAuth",
            "declarativeSecurity"
        ],
        ref:"attr:DataSourceField.initRequiresAuthentication",
        deprecated:null,
        valueType:"boolean",
        description:"Whether a user must be authenticated in order to initialize to this field.  If this property is \n set and the user is not authenticated, the SmartClient Server will not allow this field to\n be initialized.",
        flags:"IR",
        serverDS:"only",
        name:"initRequiresAuthentication"
    },
    "method:CubeGrid.getCellRow":{
        seeAlso:[
        ],
        ref:"method:CubeGrid.getCellRow",
        deprecated:null,
        type:"method",
        definingClass:"class:CubeGrid",
        params:[
            {
                defaultValue:null,
                optional:false,
                type:"CellRecord",
                description:"record to find coordinates for",
                name:"cellRecord"
            }
        ],
        description:" Given a record in this grid, this method returns the rowNum on which the record is displayed.\n",
        flags:"",
        returns:{
            type:"int",
            description:"Row number for the record. Returns -1 if the record is not found."
        },
        name:"getCellRow"
    },
    "attr:FacetChart.dataColors":{
        seeAlso:[
        ],
        defaultValue:"see below",
        type:"attr",
        definingClass:"class:FacetChart",
        deprecated:null,
        ref:"attr:FacetChart.dataColors",
        setter:[
            "setDataColors"
        ],
        valueType:"Array of CSSColor",
        description:"An array of colors to use for a series of visual elements representing data (eg columns,\n bars, pie slices), any of which may be adjacent to any other.\n <P>\n Colors must be in the format of a leading hash (#) plus 6 hexadecimal digits, for example, \n \"#FFFFFF\" is white, \"#FF0000\" is pure red.",
        flags:"IRW",
        name:"dataColors"
    },
    "type:DSInheritanceMode":{
        groups:[
            "fields"
        ],
        seeAlso:[
        ],
        ref:"type:DSInheritanceMode",
        deprecated:null,
        type:"type",
        values:[
            {
                value:"\"full\"",
                description:"Inherit fields by copying them onto the inheriting DataSource's underlying table.  When we \n import a DataSource with this inheritanceMode, we create actual columns for inherited fields\n  on the table we create.  With this inheritanceMode, inherited fields are updatable."
            },
            {
                value:"\"none\"",
                description:"Do not physically inherit fields onto the inheriting DataSource's SQL table.  Columns will\n not be created for inherited fields on import, and all generated SQL operations will exclude\n inherited fields.  However, those fields are still part of the DataSource's schema so you\n can, for example, write ${isc.DocUtils.linkForRef('group:customQuerying','custom SQL')} that returns values for \n the inherited fields, and they will be delivered to the client."
            }
        ],
        description:"For DataSources of type \"sql\" and \"hibernate\", specifies the kind of inheritance to use when a dataSource\n specifies ${isc.DocUtils.linkForRef('attr:DataSource.inheritsFrom','inheritsFrom')}.",
        serverDS:"only",
        name:"DSInheritanceMode"
    },
    "attr:FormItem.criteriaField":{
        seeAlso:[
        ],
        ref:"attr:FormItem.criteriaField",
        defaultValue:"null",
        deprecated:null,
        type:"attr",
        definingClass:"class:FormItem",
        valueType:"FieldName",
        description:"When using ${isc.DocUtils.linkForRef('attr:FormItem.operator')}, the name of the DataSource field for the\n ${isc.DocUtils.linkForRef('object:Criterion')} this FormItem generates.  If not specified, defaults to\n ${isc.DocUtils.linkForRef('attr:FormItem.name')}.\n <P>\n Generally, because <code>criteriaField</code> defaults to <code>item.name</code>, you don't\n need to specify it.  However, if more than one FormItem specifies criteria for the same\n DataSource field, they will need unique values for ${isc.DocUtils.linkForRef('attr:FormItem.name')} but should set\n ${isc.DocUtils.linkForRef('attr:FormItem.criteriaField')} to the name of DataSource field they both target.\n <P>\n For example, if two DateItems are used to provide a min and max date for a single field called\n \"joinDate\", set ${isc.DocUtils.linkForRef('attr:FormItem.criteriaField')} to \"joinDate\" on both fields but give the fields\n distinct names (eg \"minDate\" and \"maxDate\") and use those names for any programmatic access,\n such as ${isc.DocUtils.linkForRef('method:DynamicForm.setValue')}.",
        flags:"IR",
        name:"criteriaField"
    },
    "method:DrawItem.setMoveKnobOffset":{
        seeAlso:[
        ],
        ref:"method:DrawItem.setMoveKnobOffset",
        deprecated:null,
        type:"method",
        definingClass:"class:DrawItem",
        params:[
            {
                defaultValue:null,
                optional:true,
                type:"Array of int[]",
                description:"the new move knob offset. This is a 2-element array of [left offset, top offset]. If null, then <code>[0,0]</code>\n  is assumed.",
                name:"newMoveKnobOffset"
            }
        ],
        description:" Setter for ${isc.DocUtils.linkForRef('attr:DrawItem.moveKnobOffset')}.\n",
        flags:"A",
        examples:[
            "${isc.DocUtils.linkForExampleId('drawKnobs')}"
        ],
        name:"setMoveKnobOffset"
    },
    "attr:TreeMenuButton.treeMenu":{
        seeAlso:[
        ],
        ref:"attr:TreeMenuButton.treeMenu",
        defaultValue:"null",
        deprecated:null,
        type:"attr",
        definingClass:"class:TreeMenuButton",
        valueType:"AutoChild Menu",
        description:"AutoChild menu displayed when the button is clicked.",
        flags:"IR",
        name:"treeMenu"
    },
    "attr:MiniDateRangeItem.shouldSaveValue":{
        seeAlso:[
        ],
        ref:"attr:MiniDateRangeItem.shouldSaveValue",
        defaultValue:"true",
        deprecated:null,
        type:"attr",
        definingClass:"class:MiniDateRangeItem",
        valueType:"Boolean",
        description:"Allow miniDateRangeItems' values to show up in the form's values array, or if \n ${isc.DocUtils.linkForRef('method:DynamicForm.getValuesAsCriteria')} is called, for the criterion to be included\n in the returned AdvancedCriteria object",
        flags:"IR",
        name:"shouldSaveValue"
    },
    "class:Label":{
        seeAlso:[
        ],
        type:"class",
        staticMethods:[
        ],
        inheritsFrom:"Button",
        classMethods:[
        ],
        classAttrs:[
        ],
        attrs:[
            "attr:Label.editProxyConstructor",
            "attr:Label.contents",
            "attr:Label.dynamicContents",
            "attr:Label.align",
            "attr:Label.valign",
            "attr:Label.wrap",
            "attr:Label.autoFit",
            "attr:Label.width",
            "attr:Label.height",
            "attr:Label.icon",
            "attr:Label.iconSize",
            "attr:Label.iconWidth",
            "attr:Label.iconHeight",
            "attr:Label.iconOrientation",
            "attr:Label.iconAlign",
            "attr:Label.iconSpacing",
            "attr:Label.showDisabledIcon",
            "attr:Label.showRollOverIcon",
            "attr:Label.showFocusedIcon",
            "attr:Label.showDownIcon",
            "attr:Label.showSelectedIcon",
            "attr:Label.styleName"
        ],
        ref:"class:Label",
        deprecated:null,
        treeLocation:[
            "Client Reference/Foundation"
        ],
        description:"Labels display a small amount of ${isc.DocUtils.linkForRef('attr:Label.align','alignable')} ${isc.DocUtils.linkForRef('attr:Label.contents','text')}\n with optional ${isc.DocUtils.linkForRef('attr:Label.icon','icon')} and ${isc.DocUtils.linkForRef('attr:Label.autoFit','autoFit')}.\n <P>\n For a general-purpose container for HTML content, use ${isc.DocUtils.linkForRef('class:HTMLFlow')} or ${isc.DocUtils.linkForRef('class:HTMLPane')}\n instead.",
        methods:[
            "method:Label.setIconOrientation",
            "method:Label.setIcon",
            "method:Label.setStyleName",
            "method:Label.setContents"
        ],
        examples:[
            "${isc.DocUtils.linkForExampleId('label')}"
        ],
        name:"Label"
    },
    "attr:ListGrid.frozenRollOverCanvas":{
        seeAlso:[
            {
                ref:"attr:ListGrid.rollOverCanvas",
                description:null
            },
            {
                ref:"attr:ListGrid.frozenRollUnderCanvas",
                description:null
            }
        ],
        defaultValue:"null",
        type:"attr",
        definingClass:"class:ListGrid",
        getter:[
            "getFrozenRollOverCanvas"
        ],
        groups:[
            "rowEffects"
        ],
        ref:"attr:ListGrid.frozenRollOverCanvas",
        deprecated:null,
        valueType:"Canvas",
        description:"Automatically generated canvas embedded in the grid's frozen body if \n ${isc.DocUtils.linkForRef('attr:ListGrid.showRollOver','showRollOver')}\n is <code>true</code> and ${isc.DocUtils.linkForRef('attr:ListGrid.showRollOverCanvas','showRollOverCanvas')} is\n <code>true</code> or for selected records, if\n ${isc.DocUtils.linkForRef('attr:ListGrid.showSelectedRollOverCanvas','showSelectedRollOverCanvas')} \n is true. This component will be created and displayed above the current rollOver\n row or cell in the frozen body.\n <P>\n The frozenRollOverCanvas will be created using the ${isc.DocUtils.linkForRef('type:AutoChild')} subsystem, and\n will derive its configuration from the ${isc.DocUtils.linkForRef('attr:ListGrid.rollOverCanvas')}\n autoChild properties (<code>\"rollOverCanvasProperties\"</code>, et al).\n <p>\n The <code>frozenRollOverCanvas</code> has the following read-only attributes set:<br>\n - <code>this.grid</code> - a pointer to the grid<br>\n - <code>this.record</code> - a pointer to the current roll over record object in the grid",
        flags:"RA",
        name:"frozenRollOverCanvas"
    },
    "attr:FusionChart.chartURL":{
        seeAlso:[
        ],
        ref:"attr:FusionChart.chartURL",
        defaultValue:"null",
        deprecated:null,
        type:"attr",
        definingClass:"class:FusionChart",
        valueType:"URL",
        description:"Full URL to the chart.  Needed only if you have renamed the charts such that automatic\n URL formation won't work.",
        flags:"IR",
        name:"chartURL"
    },
    "class:EventHandler":{
        seeAlso:[
            {
                ref:"type:PageEvent",
                description:null
            },
            {
                ref:"classMethod:Page.setEvent",
                description:null
            },
            {
                ref:"classMethod:Page.clearEvent",
                description:null
            },
            {
                ref:"class:Canvas#methods#widgetEvents",
                description:null
            }
        ],
        type:"class",
        staticMethods:[
        ],
        inheritsFrom:"Class",
        classMethods:[
            "classMethod:EventHandler.getNativeMouseTarget",
            "classMethod:EventHandler.getFocusCanvas",
            "classMethod:EventHandler.setDragTrackerImage",
            "classMethod:EventHandler.getNativeDragData",
            "classMethod:EventHandler.setNativeDragData",
            "classMethod:EventHandler.getWheelDelta",
            "classMethod:EventHandler.getWheelDeltaX",
            "classMethod:EventHandler.getWheelDeltaY",
            "classMethod:EventHandler.setDragOffset",
            "classMethod:EventHandler.setDragTracker",
            "classMethod:EventHandler.getDragRect",
            "classMethod:EventHandler.getTarget",
            "classMethod:EventHandler.getDragTarget",
            "classMethod:EventHandler.getX",
            "classMethod:EventHandler.getY",
            "classMethod:EventHandler.leftButtonDown",
            "classMethod:EventHandler.rightButtonDown",
            "classMethod:EventHandler.middleButtonDown",
            "classMethod:EventHandler.getKeyEventCharacterValue",
            "classMethod:EventHandler.getKeyEventCharacter",
            "classMethod:EventHandler.getKey",
            "classMethod:EventHandler.shiftKeyDown",
            "classMethod:EventHandler.ctrlKeyDown",
            "classMethod:EventHandler.altKeyDown",
            "classMethod:EventHandler.targetIsMasked"
        ],
        classAttrs:[
            "classAttr:EventHandler.IDLE_DELAY",
            "classAttr:EventHandler.STOP_BUBBLING",
            "classAttr:EventHandler.ALL_EDGES",
            "classAttr:EventHandler.showNoDropIndicator",
            "classAttr:EventHandler.synchronousFocusNotifications"
        ],
        attrs:[
        ],
        groups:[
            "eventHandling"
        ],
        ref:"class:EventHandler",
        deprecated:null,
        treeLocation:[
            "Client Reference/System"
        ],
        description:"\n The ISC system provides a predictable cross-browser event-handling mechanism for ISC\n widgets. Events can be handled both at the page level (i.e., globally), and at the level of\n individual widgets.\n <p>\n With the exception of a few page-specific events ('load', 'unload', 'idle' and 'resize'),\n events are processed in the following sequence:\n <p>\n 1. The event is sent to any global (page-level) event handlers. These handlers can cancel\n further propagation of the event by returning false.  You can register to listen for any of the\n events linked in the seeAlso section (below) by calling ${isc.DocUtils.linkForRef('classMethod:Page.setEvent')}\n method.\n <p>\n 2. If the event occurred on a form element or a link, it is passed on to the browser so that\n the element will perform its default action. No widget receives the event.\n <p>\n 3. If the event occurred on an enabled widget (but not on a form element or link inside\n the widget), it is sent to that widget's event handler, if any. This handler can cancel\n further propagation of the event by returning false.  An \"enabled\" widget is any widget that\n defines an event handler for one of the supported events.  Interceptable events are defined in\n the ${isc.DocUtils.linkForRef('class:Canvas#methods#events','\"widgetEvents\" section of Canvas')}.\n <p>\n 4. The event is \"bubbled\" up to the widget's parent in the containment hierarchy, if any.\n Again, the parent's handler for the event can cancel further propagation by returning\n false. This step is repeated, with the event \"bubbling\" up through the containment\n hierarchy, until a top-level widget is reached or the event is explicitly canceled.\n In brief, the ISC event model offers the best features of browser event models:\n <ul>\n <li> Page-first event handling allows you to reliably process or cancel any event before it\n      affects the objects on the page.\n <li> Event \"bubbling\" ensures that parent widgets receive events sent to their children,\n      and allows you to create generalized parent-level handlers rather than duplicating\n      code in each child.\n </ul>\n Note: Canceling propagation of an event may cancel its side effects as well, including the\n generation of other (synthetic) events. For example, if a global mouseDown handler returns\n false, drag-and-drop events will not be generated. Specific effects are discussed in the\n descriptions of the various events in the following sections.\n <p>\n SmartClient libraries will not interfere with native event handling when events occur\n outside of a target widget. You can therefore have HTML that is not ISC-based on the same\n page as widget objects that will react to native events as you would expect.\n <p>\n You can use isc.Event as an alias for isc.EventHandler.\n \n ",
        methods:[
        ],
        name:"EventHandler"
    },
    "attr:DynamicForm.clipItemTitles":{
        seeAlso:[
        ],
        ref:"attr:DynamicForm.clipItemTitles",
        defaultValue:"false",
        deprecated:null,
        type:"attr",
        definingClass:"class:DynamicForm",
        valueType:"boolean",
        description:"Should the titles for form items be clipped if they are too large for the available \n space?\n <p>\n Can be overridden for individual items via ${isc.DocUtils.linkForRef('attr:FormItem.clipTitle')}.",
        flags:"IRW",
        name:"clipItemTitles"
    },
    "attr:FormItem.accessKey":{
        seeAlso:[
        ],
        defaultValue:"null",
        type:"attr",
        definingClass:"class:FormItem",
        groups:[
            "focus"
        ],
        deprecated:null,
        ref:"attr:FormItem.accessKey",
        valueType:"String",
        description:"If specified this governs the HTML accessKey for the item.\n <P>\n This should be set to a character - when a user hits the html accessKey modifier for\n the browser, plus this character, focus will be given to the item.\n The accessKey modifier can vary by browser and platform. \n <P>\n The following list of default behavior is for reference only, developers should also\n consult browser documentation for additional information.\n <ul>\n <li><b>Internet Explorer (all platforms)</b>: <code>Alt</code> + <i>accessKey</i></li>\n <li><b>Mozilla Firefox (Windows, Unix)</b>: <code>Alt+Shift</code> + <i>accessKey</i></li>\n <li><b>Mozilla Firefox (Mac)</b>: <code>Ctrl+Opt</code> + <i>accessKey</i></li>\n <li><b>Chrome and Safari (Windows, Unix)</b>:  <code>Alt</code> + <i>accessKey</i></li>\n <li><b>Chrome and Safari (Mac)</b>:  <code>Ctrl+Opt</code> + <i>accessKey</i></li>\n </ul>",
        flags:"IRW",
        name:"accessKey"
    },
    "method:Layout.setLayoutMargin":{
        groups:[
            "layoutMargin"
        ],
        seeAlso:[
        ],
        ref:"method:Layout.setLayoutMargin",
        deprecated:null,
        type:"method",
        definingClass:"class:Layout",
        params:[
            {
                defaultValue:null,
                optional:true,
                type:"Integer",
                description:"optional new setting for layout.layoutMargin.  Regardless of whether a new                          layout margin is passed, the layout reflows according to the current settings\n                          for layoutStartMargin et al",
                name:"newMargin"
            }
        ],
        description:" Method to force a reflow of the layout after directly assigning a value to any of the\n layout*Margin properties. Takes no arguments.\n\n",
        flags:"",
        name:"setLayoutMargin"
    },
    "attr:Dialog.messageStyle":{
        seeAlso:[
        ],
        ref:"attr:Dialog.messageStyle",
        defaultValue:"\"normal\"",
        deprecated:null,
        type:"attr",
        definingClass:"class:Dialog",
        valueType:"CSSStyleName",
        description:"Style to apply to the message text shown in the center of the dialog",
        flags:"IR",
        name:"messageStyle"
    },
    "attr:ListGrid.expansionFieldImageShowRTL":{
        seeAlso:[
        ],
        defaultValue:"false",
        type:"attr",
        definingClass:"class:ListGrid",
        groups:[
            "RTL",
            "expansionField"
        ],
        deprecated:null,
        ref:"attr:ListGrid.expansionFieldImageShowRTL",
        valueType:"boolean",
        description:"If this grid is in RTL mode, should an \"_rtl\" suffix be added to the ${isc.DocUtils.linkForRef('attr:ListGrid.expansionFieldTrueImage','expansionFieldTrueImage')}\n and ${isc.DocUtils.linkForRef('attr:ListGrid.expansionFieldFalseImage','expansionFieldFalseImage')} image URLs? This should only\n be enabled if RTL media for the true and false expansion field images are available.\n <P>\n If both this property and ${isc.DocUtils.linkForRef('attr:ListGrid.expansionFieldImageShowSelected')} are true, and\n the grid is in RTL mode, both suffixes will be applied to selected rows'\n expansion field images (combined as \"selected_rtl\").",
        flags:"IRA",
        name:"expansionFieldImageShowRTL"
    },
    "type:KnobType":{
        seeAlso:[
        ],
        ref:"type:KnobType",
        deprecated:null,
        type:"type",
        values:[
            {
                value:"\"resize\"",
                description:"Display up to 8 control knobs at the corners specified by ${isc.DocUtils.linkForRef('attr:DrawItem.resizeKnobPoints')},\n  allowing the user to drag-resize the item.\n  See also ${isc.DocUtils.linkForRef('attr:DrawItem.cornerResizeKnob')} and ${isc.DocUtils.linkForRef('attr:DrawItem.sideResizeKnob')}."
            },
            {
                value:"\"move\"",
                description:"Display a control knob for moving the item around. See also ${isc.DocUtils.linkForRef('attr:DrawItem.moveKnobPoint')}\n  and ${isc.DocUtils.linkForRef('attr:DrawItem.moveKnobOffset')}"
            },
            {
                value:"\"startPoint\"",
                description:"Control knob  to manipulate ${isc.DocUtils.linkForRef('attr:DrawLine.startPoint')}."
            },
            {
                value:"\"endPoint\"",
                description:"Control knob to manipulate ${isc.DocUtils.linkForRef('attr:DrawLine.endPoint')}."
            },
            {
                value:"\"controlPoint1\"",
                description:"Display a draggable control knob along with a DrawLine indicating the angle between controlPoint1\n  and the startPoint. Dragging the knob will adjust controlPoint1."
            },
            {
                value:"\"controlPoint2\"",
                description:"Display a draggable control knob along with a DrawLine indicating the angle between controlPoint2\n  and the endPoint. Dragging the knob will adjust controlPoint2."
            },
            {
                value:"\"rotate\"",
                description:"Display a rotation knob above the top resize knob, allowing the user to rotate the item.\n  See also ${isc.DocUtils.linkForRef('attr:DrawItem.rotateKnob')}."
            }
        ],
        description:"Entries for the ${isc.DocUtils.linkForRef('attr:DrawItem.knobs')} array. Each specified knobType will enable some UI \n allowing the user to manipulate the DrawItem directly.\n <p>\n <b>NOTE:</b> Not all knob types are supported by each DrawItem type. Refer to the DrawItem\n type's ${isc.DocUtils.linkForRef('attr:DrawItem.knobs','knobs')} attribute documentation for a list of the supported knob types.",
        name:"KnobType"
    },
    "method:TileGrid.recordClick":{
        seeAlso:[
        ],
        type:"method",
        definingClass:"class:TileGrid",
        groups:[
            "events"
        ],
        deprecated:null,
        ref:"method:TileGrid.recordClick",
        params:[
            {
                defaultValue:null,
                optional:false,
                type:"TileGrid",
                description:"the TileGrid itself",
                name:"viewer"
            },
            {
                defaultValue:null,
                optional:false,
                type:"Canvas",
                description:"the tile that was clicked on",
                name:"tile"
            },
            {
                defaultValue:null,
                optional:false,
                type:"TileRecord",
                description:"the record that was clicked on",
                name:"record"
            }
        ],
        description:" Executed when the tileGrid receives a 'click' event on a\n tile. The default implementation does nothing -- override to perform some action\n when any record is clicked.<br>\n A record event handler can be specified either as\n a function to execute, or as a string of script to evaluate. If the handler is defined\n as a string of script, all the parameters below will be available as variables for use\n in the script.<br>\n If you want to cancel the click based on the parameters, return false. Otherwise, return \n true so that the click event be registered with the tile.\n\n",
        flags:"",
        examples:[
            "${isc.DocUtils.linkForExampleId('tilingEditing')}"
        ],
        name:"recordClick"
    },
    "method:Progressbar.percentChanged":{
        seeAlso:[
            {
                ref:"method:Class.observe",
                description:null
            }
        ],
        ref:"method:Progressbar.percentChanged",
        deprecated:null,
        type:"method",
        definingClass:"class:Progressbar",
        description:" This method is called when the percentDone value changes. Observe\n  this method to be notified upon\n a change to the percentDone value.\n\n",
        flags:"A",
        name:"percentChanged"
    },
    "attr:EditProxy.childrenSnapToGrid":{
        seeAlso:[
        ],
        ref:"attr:EditProxy.childrenSnapToGrid",
        defaultValue:"null",
        deprecated:null,
        type:"attr",
        definingClass:"class:EditProxy",
        valueType:"Boolean",
        description:"If not null the ${isc.DocUtils.linkForRef('attr:Canvas.childrenSnapToGrid')} on the component represented by this\n EditProxy is set to this value only while in edit mode. This allows snapToGrid functionality\n to be enforced during edit mode but not when live.",
        flags:"IRW",
        name:"childrenSnapToGrid"
    },
    "attr:TimeItem.hourItemPrompt":{
        seeAlso:[
        ],
        defaultValue:"\"Choose hours\"",
        type:"attr",
        definingClass:"class:TimeItem",
        groups:[
            "i18nMessages"
        ],
        deprecated:null,
        ref:"attr:TimeItem.hourItemPrompt",
        valueType:"HTMLString",
        description:"The hover prompt to show for the ${isc.DocUtils.linkForRef('attr:TimeItem.hourItem','hour picker')}.",
        flags:"IRW",
        name:"hourItemPrompt"
    },
    "attr:DataSource.resultBatchSize":{
        seeAlso:[
        ],
        defaultValue:"150",
        type:"attr",
        definingClass:"class:DataSource",
        deprecated:null,
        ref:"attr:DataSource.resultBatchSize",
        valueType:"int",
        description:"Very advanced: for servers that do not support paging, and must return large numbers of XML\n records in one HTTP response, SmartClient breaks up the processing of the response\n in order to avoid the \"script running slowly\" dialog appearing for an end user.\n <P>\n If you have a relatively small number of records with a great deal of properties or\n subobjects on each record, and you have not set ${isc.DocUtils.linkForRef('attr:DataSource.dropExtraFields')} to eliminate unused\n data, and you see the \"script running slowly\" dialog, you may need to set this number\n lower.",
        flags:"IRWA",
        serverDS:"allowed",
        name:"resultBatchSize"
    },
    "method:Toolbar.addButtons":{
        seeAlso:[
        ],
        ref:"method:Toolbar.addButtons",
        deprecated:null,
        type:"method",
        definingClass:"class:Toolbar",
        params:[
            {
                defaultValue:null,
                optional:true,
                type:"Array of Object",
                description:"list of button object initializers.",
                name:"buttons"
            },
            {
                defaultValue:null,
                optional:true,
                type:"number",
                description:"position to add the new buttons at",
                name:"position"
            }
        ],
        description:" Add a list of buttons to the toolbar\n",
        flags:"",
        name:"addButtons"
    },
    "attr:TextAreaItem.selectOnFocus":{
        seeAlso:[
        ],
        defaultValue:"null",
        type:"attr",
        definingClass:"class:TextAreaItem",
        groups:[
            "focus"
        ],
        deprecated:null,
        ref:"attr:TextAreaItem.selectOnFocus",
        valueType:"boolean",
        description:"Allows the ${isc.DocUtils.linkForRef('attr:DynamicForm.selectOnFocus','selectOnFocus')} behavior to be configured on a\n per-FormItem basis.  Normally all items in a form default to the value of\n ${isc.DocUtils.linkForRef('attr:DynamicForm.selectOnFocus')}.",
        flags:"IRW",
        name:"selectOnFocus"
    },
    "method:ValuesManager.removeMembers":{
        groups:[
            "members"
        ],
        seeAlso:[
            {
                ref:"method:ValuesManager.removeMember",
                description:null
            }
        ],
        ref:"method:ValuesManager.removeMembers",
        deprecated:null,
        type:"method",
        definingClass:"class:ValuesManager",
        params:[
            {
                defaultValue:null,
                optional:false,
                type:"Array of DynamicForm",
                description:"array of forms to remove",
                name:"members"
            }
        ],
        description:" Remove multiple member forms from this valuesManager.\n",
        flags:"",
        name:"removeMembers"
    },
    "object:SerializationSettings":{
        seeAlso:[
        ],
        type:"object",
        staticMethods:[
        ],
        classMethods:[
        ],
        classAttrs:[
        ],
        attrs:[
            "attr:SerializationSettings.serverless",
            "attr:SerializationSettings.indent",
            "attr:SerializationSettings.outputComponentsIndividually"
        ],
        groups:[
            "devTools"
        ],
        ref:"object:SerializationSettings",
        deprecated:null,
        treeLocation:[
            "Client Reference/Tools"
        ],
        description:"Settings to control ${isc.DocUtils.linkForRef('class:EditContext')} serialization.",
        methods:[
        ],
        name:"SerializationSettings"
    },
    "attr:Button.iconStyle":{
        seeAlso:[
        ],
        defaultValue:"null",
        type:"attr",
        definingClass:"class:Button",
        groups:[
            "buttonIcon"
        ],
        ref:"attr:Button.iconStyle",
        deprecated:null,
        setter:[
            "setIconStyle"
        ],
        valueType:"CSSStyleName",
        description:"Base CSS style applied to the icon image. If set, as the <code>StatefulCanvas</code> changes\n ${isc.DocUtils.linkForRef('attr:StatefulCanvas.state','state')} and/or is ${isc.DocUtils.linkForRef('attr:StatefulCanvas.selected','selected')},\n suffixes will be appended to <code>iconStyle</code> to form the className set on the\n image element.\n <p>\n The following table lists out the standard set of suffixes which may be appended:\n <table border=1>\n <tr><th>CSS Class Applied</th><th>Description</th></tr>\n <tr><td><code><i>iconStyle</i></code></td><td>Default CSS style</td></tr>\n <tr><td><code><i>iconStyle</i>+Selected</code></td>\n      <td>Applied when ${isc.DocUtils.linkForRef('attr:StatefulCanvas.selected')} and ${isc.DocUtils.linkForRef('attr:StatefulCanvas.showSelectedIcon')}\n      are true.</td></tr>\n <tr><td><code><i>iconStyle</i>+Focused</code></td>\n      <td>Applied when the component has keyboard focus, if\n      ${isc.DocUtils.linkForRef('attr:StatefulCanvas.showFocusedIcon')} is true, and\n      ${isc.DocUtils.linkForRef('attr:StatefulCanvas.showFocusedAsOver')} is not true.</td></tr>\n <tr><td><code><i>iconStyle</i>+Over</code></td>\n      <td>Applied when ${isc.DocUtils.linkForRef('attr:StatefulCanvas.showRollOverIcon')} is set to true and either\n      the user rolls over the component or ${isc.DocUtils.linkForRef('attr:StatefulCanvas.showFocusedAsOver')} is true\n      and the component has keyboard focus.</td></tr>\n <tr><td><code><i>iconStyle</i>+Down</code></td>\n      <td>Applied when the user presses the mouse button on the component if\n          ${isc.DocUtils.linkForRef('attr:StatefulCanvas.showDownIcon')} is set to true</td></tr>\n <tr><td><code><i>iconStyle</i>+Disabled</code></td>\n      <td>Applied when the component is ${isc.DocUtils.linkForRef('attr:Canvas.disabled','disabled')}\n       if ${isc.DocUtils.linkForRef('attr:StatefulCanvas.showDisabledIcon')} is true.</td></tr>\n <tr><td colspan=2><i>Combined styles</i></td></tr>\n <tr><td><code><i>iconStyle</i>+SelectedFocused</code></td>\n      <td>Combined Selected and focused styling</td></tr>\n <tr><td><code><i>iconStyle</i>+SelectedOver</code></td>\n      <td>Combined Selected and rollOver styling</td></tr>\n <tr><td><code><i>iconStyle</i>+FocusedOver</code></td>\n      <td>Combined Focused and rollOver styling</td></tr>\n <tr><td><code><i>iconStyle</i>+SelectedFocusedOver</code></td>\n      <td>Combined Selected, Focused and rollOver styling</td></tr>\n <tr><td><code><i>iconStyle</i>+SelectedDown</code></td>\n      <td>Combined Selected and mouse-down styling</td></tr>\n <tr><td><code><i>iconStyle</i>+FocusedDown</code></td>\n      <td>Combined Focused and mouse-down styling</td></tr>\n <tr><td><code><i>iconStyle</i>+SelectedFocusedDown</code></td>\n      <td>Combined Selected, Focused and mouse-down styling</td></tr>\n <tr><td><code><i>iconStyle</i>+SelectedDisabled</code></td>\n      <td>Combined Selected and Disabled styling</td></tr>\n </table>\n <p>\n In addition, if ${isc.DocUtils.linkForRef('attr:StatefulCanvas.showRTLIcon')} is true, then in RTL mode, a final\n \"RTL\" suffix will be appended.",
        flags:"IRW",
        name:"iconStyle"
    },
    "method:DetailViewer.viewSelectedData":{
        groups:[
            "dataBoundComponentMethods"
        ],
        seeAlso:[
        ],
        ref:"method:DetailViewer.viewSelectedData",
        deprecated:null,
        type:"method",
        definingClass:"class:DetailViewer",
        params:[
            {
                defaultValue:null,
                optional:false,
                type:"ListGrid | TileGrid | ID",
                description:"the ListGrid or TileGrid or ID of a ${isc.DocUtils.linkForRef('class:ListGrid')}/${isc.DocUtils.linkForRef('class:TileGrid')} whose currently\n     selected record(s) is/are to be edited",
                name:"selectionComponent"
            }
        ],
        description:"\n Displays the currently selected record(s) of the selectionComponent widget (typically a\n listGrid) in the detailViewer.\n\n",
        flags:"",
        name:"viewSelectedData"
    },
    "classAttr:Operators.notInSetTitle":{
        seeAlso:[
        ],
        defaultValue:"\"is not one of\"",
        type:"classAttr",
        definingClass:"class:Operators",
        groups:[
            "i18nMessages"
        ],
        deprecated:null,
        ref:"classAttr:Operators.notInSetTitle",
        valueType:"String",
        description:"Title for the \"notInSet\" operator",
        flags:"IR",
        name:"notInSetTitle"
    },
    "attr:Slider.valueStyle":{
        seeAlso:[
        ],
        ref:"attr:Slider.valueStyle",
        defaultValue:"\"sliderValue\"",
        deprecated:null,
        type:"attr",
        definingClass:"class:Slider",
        valueType:"CSSStyleName",
        description:"CSS style for the floating ${isc.DocUtils.linkForRef('attr:Slider.valueLabel','valueLabel')}, visible when\n ${isc.DocUtils.linkForRef('attr:Slider.showValue')} is true.",
        flags:"IR",
        name:"valueStyle"
    },
    "attr:FilterBuilder.allowEmpty":{
        seeAlso:[
        ],
        ref:"attr:FilterBuilder.allowEmpty",
        defaultValue:"false",
        deprecated:null,
        type:"attr",
        definingClass:"class:FilterBuilder",
        valueType:"Boolean",
        description:"If set to false, the last clause cannot be removed.",
        flags:"IR",
        name:"allowEmpty"
    },
    "class:MenuButton":{
        seeAlso:[
        ],
        type:"class",
        staticMethods:[
        ],
        inheritsFrom:"Button",
        classMethods:[
        ],
        classAttrs:[
        ],
        attrs:[
            "attr:MenuButton.editProxyConstructor",
            "attr:MenuButton.title",
            "attr:MenuButton.height",
            "attr:MenuButton.icon",
            "attr:MenuButton.showMenuButtonImage",
            "attr:MenuButton.menuButtonImage",
            "attr:MenuButton.menuButtonImageUp",
            "attr:MenuButton.hiliteAccessKey",
            "attr:MenuButton.showMenuBelow",
            "attr:MenuButton.menuAlign",
            "attr:MenuButton.menu",
            "attr:MenuButton.menuAnimationEffect",
            "attr:MenuButton.autoDestroyMenu",
            "attr:MenuButton.showMenuOnRollOver",
            "attr:MenuButton.rollOverMenuHideDelay"
        ],
        ref:"class:MenuButton",
        deprecated:null,
        treeLocation:[
            "Client Reference/Control"
        ],
        description:"Simple subclass of button associated with a menu widget (gets shown below the button).",
        methods:[
            "method:MenuButton.setShowMenuButtonImage",
            "method:MenuButton.setShowMenuBelow",
            "method:MenuButton.showMenu"
        ],
        name:"MenuButton"
    },
    "attr:ListGrid.clearAllSortingText":{
        seeAlso:[
        ],
        defaultValue:"\"Clear All Sorting\"",
        type:"attr",
        definingClass:"class:ListGrid",
        groups:[
            "i18nMessages"
        ],
        deprecated:null,
        ref:"attr:ListGrid.clearAllSortingText",
        valueType:"String",
        description:"If we're showing a ${isc.DocUtils.linkForRef('attr:ListGrid.showHeaderContextMenu','headerContextMenu')} for this grid, this\n attribute will be shown as the menu item title to clear any existing sort on all fields.  This\n menu-item is displayed only in the context menu for the sorter button.",
        flags:"IRW",
        name:"clearAllSortingText"
    },
    "attr:Canvas.childrenSnapAlign":{
        seeAlso:[
        ],
        ref:"attr:Canvas.childrenSnapAlign",
        defaultValue:"null",
        deprecated:null,
        type:"attr",
        definingClass:"class:Canvas",
        valueType:"Boolean",
        description:"If enabled while ${isc.DocUtils.linkForRef('attr:Canvas.childrenSnapToGrid')} is enabled, children dragged within this Canvas\n will also snap to positions where their edges or center lines would be aligned with the\n edges or centers of other components, and lines will be shown to point out the possible\n alignment (with appearance controlled by ${isc.DocUtils.linkForRef('attr:Canvas.snapAlignCenterLineStyle')} and\n ${isc.DocUtils.linkForRef('attr:Canvas.snapAlignEdgeLineStyle')} respectively.\n <p>\n By default, edge- or center-snapping is enabled for all components, but the set of eligible\n components can be explicitly set via ${isc.DocUtils.linkForRef('attr:Canvas.snapAlignCandidates')}.\n <p>\n See also ${isc.DocUtils.linkForRef('attr:Canvas.childrenSnapCenterAlign')} and ${isc.DocUtils.linkForRef('attr:Canvas.childrenSnapEdgeAlign')} for enabling or\n disabling center alignment or edge alignment individually.",
        flags:"IRW",
        name:"childrenSnapAlign"
    },
    "attr:ColorPicker.satFieldTitle":{
        seeAlso:[
        ],
        defaultValue:"\"Sat\"",
        type:"attr",
        definingClass:"class:ColorPicker",
        groups:[
            "i18nMessages"
        ],
        deprecated:null,
        ref:"attr:ColorPicker.satFieldTitle",
        valueType:"HTMLString",
        description:"The title for the 'Sat' field in the complex chooser.",
        flags:"IR",
        name:"satFieldTitle"
    },
    "attr:DataSource.beanClassName":{
        seeAlso:[
            {
                ref:"attr:OperationBinding.beanClassName",
                description:null
            }
        ],
        defaultValue:"null",
        type:"attr",
        definingClass:"class:DataSource",
        deprecated:null,
        ref:"attr:DataSource.beanClassName",
        valueType:"String",
        description:"This property has different meanings depending on the ${isc.DocUtils.linkForRef('attr:DataSource.serverType','serverType')}:\n <p>\n <b>For SQL DataSources (DataSources with serverType \"sql\")</b><br>\n If set, results from the database will be used to create one instance of the indicated Java\n bean per database row.  Otherwise a Map is used to represent each row retrieved from SQL.\n <P>\n With this feature active, a DSResponse from this DataSource will contain a Collection of\n instances of the indicated <code>beanClassName</code>, available via DSResponse.getData().\n This creates a couple of possibilities:\n <P>\n <dl>\n <dt>Add business logic for derived properties, such as computed formulas</dt>\n <dd>For example, declare a DataSourceField named \"revenueProjection\".  By default this\n field will call getRevenueProjection() on your bean to retrieve the value to send to the\n client.  Your implementation of getRevenueProjection() could apply some kind of formula to\n other values loaded from the database.</dd>\n <dt>Call business logic on retrieved beans via DMI</dt>\n <dd>By adding a ${isc.DocUtils.linkForRef('group:dmiOverview','DMI')} method that calls DSRequest.execute() to retrieve a DSResponse,\n you have an opportunity to call business logic methods on the beans representing each\n row affected by the DSRequest.  For example, notify a related BPEL process of changes to\n certain fields.</dd>\n </dl>\n <P>\n By using <code>beanClassName</code> on a specific ${isc.DocUtils.linkForRef('class:OperationBinding')}, you can:\n <ul>\n <li>Use a bean to represent your data only when it matters; for example, avoid the overhead\n     of using a bean for \"fetch\" operations, but do use a bean for \"update\" operations so\n     that you can execute relevant business logic after the update completes.</li>\n <li>Skip the use of beans for complex reporting queries that produce results unrelated to\n     your persistent object model.  Set beanClassName to blank (\"\") on a specific\n     operationBinding to override DataSource.beanClassName for that specific operation.</li>\n <li>For SQL joins that produce additional data fields, use a special, operation-specific\n     bean that represents a join of multiple entities and contains business logic specific\n     to that joined dataset</li>\n </ul>\n <P>\n Note that <code>beanClassName</code> affects what numeric field types will be used for \n inbound DSRequest data. For fields with numeric types, the ${isc.DocUtils.linkForRef('attr:DSRequest.data','record data')} \n in DSRequests will automatically be converted to the type of the target field, before the \n request is received in a ${isc.DocUtils.linkForRef('class:DMI')}.  For details, see ${isc.DocUtils.linkForRef('group:dsRequestBeanTypes')}.\n <p>\n Note that ${isc.DocUtils.linkForRef('group:dmiOverview','DMI')} also has a built-in facility for populating a bean \n with the inbound ${isc.DocUtils.linkForRef('attr:DSRequest.data')} - just declare the bean as a method argument.\n <p>\n <b>For generic DataSources (DataSources with serverType \"generic\")</b><br>\n ${isc.DocUtils.linkForRef('group:visualBuilder','Visual Builder')} sets this property when it creates a generic \n DataSource using the Javabean Wizard.  It has no built-in server-side effects.\n <p>\n <b>For Hibernate DataSources (DataSources with serverType \"hibernate\")</b><br>\n The name of the Java bean or POJO class that is mapped in Hibernate.  This will typically \n be the fully-qualified class name - eg <code>com.foo.MyClass</code> - but it may be the \n simple class name - just <code>MyClass</code> - or it may be some other value.  It all \n depends on how your classes have been mapped in Hibernate.\n <p>\n The declared Java bean will affect how its properties will be mapped to built-in numeric \n types, see ${isc.DocUtils.linkForRef('group:hibernateIntegration','Hibernate Integration overview')} for details.\n <p>\n Note:  If you are intending to use Hibernate as a data-access layer only, \n you do not need to create Hibernate mappings or Java objects: SmartClient will generate\n everything it needs on the fly.\n <p>\n <b>For JPA DataSources (DataSources with serverType \"jpa\" or \"jpa1\")</b><br>\n The fully qualified class name of the JPA annotated entity.\n <p>\n <b>NOTE for Hibernate and JPA users:</b> When you use JPA, or use Hibernate as a full ORM\n system (ie, not just allowing SmartClient Server to drive Hibernate as a data access layer),\n the beans returned on the server-side are <b>live</b>.  This means that if you make any \n changes to them, the ORM system will persist those changes.  This is true even if the beans\n were created as part of a fetch operation.\n <p>\n This causes a problem in the common case where you want to use a DMI or custom DataSource \n implementation to apply some post-processing to the beans fetched from the persistent \n store.  If you change the values in the beans directly, those changes will be persisted.\n <p>\n If you want to alter the data returned from a JPA or Hibernate persistent store as part of\n a fetch request just so you can alter what gets sent to the client, you can use the \n server-side <code>DSResponse</code>'s <code>getRecords()</code> method.  This will return\n your bean data in \"record\" format - ie, as a List of Maps.  You can alter these records \n without affecting your persistent store, and then call <code>setData()</code> on the \n <code>DSResponse</code>), passing the altered list of records.  See the server-side Javadocs\n for <code>DSResponse</code> for details of these two methods.",
        flags:"IR",
        serverDS:"only",
        name:"beanClassName"
    },
    "attr:RichTextEditor.justifyPrompt":{
        seeAlso:[
        ],
        defaultValue:"\"Full justify selection\"",
        type:"attr",
        definingClass:"class:RichTextEditor",
        groups:[
            "i18nMessages"
        ],
        deprecated:null,
        ref:"attr:RichTextEditor.justifyPrompt",
        valueType:"String",
        description:"The prompt for the built-in ${isc.DocUtils.linkForRef('type:ControlName','justify')} control.",
        flags:"IRW",
        name:"justifyPrompt"
    },
    "attr:StatefulCanvas.state":{
        seeAlso:[
            {
                ref:"type:State",
                description:null
            },
            {
                ref:"group:state",
                description:null
            }
        ],
        defaultValue:"\"\"",
        type:"attr",
        definingClass:"class:StatefulCanvas",
        getter:[
            "getState"
        ],
        groups:[
            "state"
        ],
        ref:"attr:StatefulCanvas.state",
        deprecated:null,
        valueType:"State",
        setter:[
            "setState"
        ],
        description:"Current \"state\" of this widget. The state setting is automatically updated as the \n user interacts with the component (see ${isc.DocUtils.linkForRef('attr:StatefulCanvas.showRollOver')}, \n ${isc.DocUtils.linkForRef('attr:StatefulCanvas.showDown')}, ${isc.DocUtils.linkForRef('attr:StatefulCanvas.showDisabled')}).\n <P>\n StatefulCanvases will have a different appearance based\n on their current state. \n By default this is handled by changing the css className applied to\n the StatefulCanvas - see ${isc.DocUtils.linkForRef('attr:StatefulCanvas.baseStyle')} and \n ${isc.DocUtils.linkForRef('method:StatefulCanvas.getStateSuffix')} for a description of how this is done.\n <P>\n For ${isc.DocUtils.linkForRef('class:Img')} or ${isc.DocUtils.linkForRef('class:StretchImg')} based subclasses of StatefulCanvas, the \n appearance may also be updated by changing the src of the rendered image. See\n ${isc.DocUtils.linkForRef('attr:Img.src')} and ${isc.DocUtils.linkForRef('attr:StretchImgButton.src')} for a description of how the URL \n is modified to reflect the state of the widget in this case.",
        flags:"IRWA",
        name:"state"
    },
    "attr:DetailViewerField.displayField":{
        seeAlso:[
        ],
        ref:"attr:DetailViewerField.displayField",
        defaultValue:"null",
        deprecated:null,
        type:"attr",
        definingClass:"object:DetailViewerField",
        valueType:"String",
        description:"If <code>displayField</code> is defined for the field then the DetailViewer will\n display the <code>displayField</code> attribute of records instead of the attribute\n given by the ${isc.DocUtils.linkForRef('attr:DetailViewerField.name')} of the field.",
        flags:"IR",
        name:"displayField"
    },
    "group:reflection":{
        refs:[
        ],
        seeAlso:[
        ],
        ref:"group:reflection",
        deprecated:null,
        type:"group",
        title:"Registering Classes for Reflection",
        description:"In order to specify a SmartGWT class as a constructor in\n ${isc.DocUtils.linkForRef('group:componentXML','Component XML')} or \n ${isc.DocUtils.linkForRef('group:componentSchema','Component Schema')},\n or for other purposes, such as for \n {@link com.smartgwt.client.docs.AutoChildUsage autoChildren} or for \n {@link com.smartgwt.client.data.DataSourceField#setEditorType(Class)}, \n you must first register the class with the \n {@link com.smartgwt.client.bean.BeanFactory} reflection mechanism.\n <p>\n If you want to register {@link com.smartgwt.client.widgets.Canvas}\n and all its subclasses found in the classpath (including your custom subclasses), \n you can use the {@link com.smartgwt.client.bean.BeanFactory.CanvasMetaFactory}\n interface to do this automatically:\n <blockquote><pre>\n GWT.create(BeanFactory.CanvasMetaFactory.class);</pre></blockquote>\n <p>\n Similarly, to register {@link com.smartgwt.client.widgets.form.fields.FormItem}\n and all its subclasses found in the classpath (including your custom subclasses),\n you can use the {@link com.smartgwt.client.bean.BeanFactory.FormItemMetaFactory}.\n <blockquote><pre>\n GWT.create(BeanFactory.FormItemMetaFactory.class);</pre></blockquote>\n <p>\n Alternatively, if only specific classes need to be instantiated and\n configured dynamically, you can register just those classes by annotating\n them with the {@link com.smartgwt.client.bean.BeanFactory.Generate}\n annotation instead. For instance:\n <blockquote><pre>\n {@literal @}BeanFactory.Generate\n public class MyCanvas extends Canvas {\n     ...\n }</pre></blockquote>\n <p>\n For framework classes (where you cannot annotate the class directly), you\n can supply an array of Class literals to the annotation. For instance:\n <blockquote><pre>\n {@literal @}BeanFactory.Generate({Canvas.class, TreeGrid.class})\n public interface EmptyInterface {\n     ...\n }</pre></blockquote>\n <p>\n When you supply an array of class literals, the class you annotate\n (here <code>EmptyInterface</code>) will <b>not</b> itself have a \n BeanFactory generated for it. Thus, you can use an empty inner\n interface for this purpose.\n <p>\n If there are only a limited number of classes which require dynamic\n configuration, it will save code size to use the\n {@link com.smartgwt.client.bean.BeanFactory.Generate} annotation to generate\n factories for those specific types, rather than using \n {@link com.smartgwt.client.bean.BeanFactory.CanvasMetaFactory} or\n {@link com.smartgwt.client.bean.BeanFactory.FormItemMetaFactory}. Once a factory\n is generated for a class, GWT's opportunities to prune dead code are more\n limited for that class, since it cannot know what properties will be set or\n retrieved at run-time.",
        name:"reflection"
    },
    "attr:MultiSortDialog.copyLevelButtonTitle":{
        seeAlso:[
        ],
        defaultValue:"\"Copy Level\"",
        type:"attr",
        definingClass:"class:MultiSortDialog",
        groups:[
            "i18nMessages"
        ],
        deprecated:null,
        ref:"attr:MultiSortDialog.copyLevelButtonTitle",
        valueType:"String",
        description:"The title-text to appear on the copyLevelButton\n <P>\n Note, this is a passthrough property which, when set, is passed through to the \n ${isc.DocUtils.linkForRef('class:MultiSortPanel','MultiSortPanel')} contained in this dialog.  You only need to\n consider the properties on the MultiSortPanel for i18n.",
        flags:"IR",
        name:"copyLevelButtonTitle"
    },
    "classMethod:Messaging.unsubscribe":{
        groups:[
            "messaging"
        ],
        seeAlso:[
        ],
        ref:"classMethod:Messaging.unsubscribe",
        deprecated:null,
        type:"classMethod",
        definingClass:"class:Messaging",
        params:[
            {
                defaultValue:null,
                optional:false,
                type:"String",
                description:null,
                name:"channel"
            }
        ],
        description:" Unsubscribes the client from the messaging channel identified by channel.\n <p>\n This will cause a reconnect to the server - for this reason\n we defer the actual reconnect to allow for multiple unsubscribe() calls in sequence.\n\n",
        flags:"",
        name:"unsubscribe"
    },
    "attr:ListGrid.booleanPartialImage":{
        seeAlso:[
            {
                ref:"attr:ListGrid.booleanTrueImage",
                description:null
            },
            {
                ref:"attr:ListGrid.booleanFalseImage",
                description:null
            },
            {
                ref:"attr:ListGrid.printBooleanPartialImage",
                description:null
            }
        ],
        defaultValue:"null",
        type:"attr",
        definingClass:"class:ListGrid",
        groups:[
            "imageColumns"
        ],
        deprecated:null,
        ref:"attr:ListGrid.booleanPartialImage",
        valueType:"SCImgURL",
        description:"Image to display for a partially true value in a boolean field (typically selection).\n The special value \"blank\" means that no image will be shown.\n <P>\n To turn this off explicitly set ${isc.DocUtils.linkForRef('attr:ListGridField.suppressValueIcon')} to true.\n <P>\n If this, ${isc.DocUtils.linkForRef('attr:ListGrid.booleanTrueImage')} and ${isc.DocUtils.linkForRef('attr:ListGrid.booleanFalseImage')}\n are unset, this will be set to the default ${isc.DocUtils.linkForRef('attr:CheckboxItem.partialSelectedImage')}.\n <P>\n ${isc.DocUtils.linkForRef('group:skinning','Spriting')} can be used for this image, by setting this property to\n a ${isc.DocUtils.linkForRef('type:SCSpriteConfig')} formatted string. Alternatively developers can\n omit this property and instead use CSS directly in the \n ${isc.DocUtils.linkForRef('attr:ListGrid.booleanBaseStyle')} property to provide a \"boolean true\" appearance.",
        flags:"IRWA",
        name:"booleanPartialImage"
    },
    "method:Calendar.setZones":{
        seeAlso:[
        ],
        ref:"method:Calendar.setZones",
        deprecated:null,
        type:"method",
        definingClass:"class:Calendar",
        params:[
            {
                defaultValue:null,
                optional:false,
                type:"Array of CalendarEvent",
                description:"array of zones to display",
                name:"zones"
            }
        ],
        description:" Sets the ${isc.DocUtils.linkForRef('attr:Calendar.zones','zones')} used to highlight areas of this calendar.\n\n",
        flags:"",
        name:"setZones"
    },
    "attr:ListGrid.headerButtonProperties":{
        seeAlso:[
        ],
        defaultValue:"null",
        type:"attr",
        definingClass:"class:ListGrid",
        groups:[
            "gridHeader",
            "appearance"
        ],
        deprecated:null,
        ref:"attr:ListGrid.headerButtonProperties",
        valueType:"Button Properties",
        description:"Properties to apply to all header buttons.\n Overrides defaults applied via  ${isc.DocUtils.linkForRef('attr:ListGrid.headerButtonDefaults')}.",
        flags:"IRA",
        name:"headerButtonProperties"
    },
    "classMethod:DateUtil.setShortDisplayFormat":{
        seeAlso:[
        ],
        type:"classMethod",
        definingClass:"class:DateUtil",
        groups:[
            "dateFormatting"
        ],
        deprecated:null,
        ref:"classMethod:DateUtil.setShortDisplayFormat",
        params:[
            {
                defaultValue:null,
                optional:false,
                type:"FormatString | DateDisplayFormat | Function",
                description:"new formatter",
                name:"format"
            }
        ],
        description:" Set the default short format for dates. After calling this method, subsequent calls to\n ${isc.DocUtils.linkForRef('method:Date.toShortDate')}\n  will return a string formatted\n according to this format specification. Note that this will be the standard short date\n format used by SmartClient components.\n <P>\n The <code>format</code> parameter may be a ${isc.DocUtils.linkForRef('type:FormatString')}, a ${isc.DocUtils.linkForRef('type:DateDisplayFormat')} \n string, or a function. If passed a function, this function will be executed in the scope of\n the Date and should return the formatted string.<br>\n <P>\n Initial default shortDateFormat is <code>\"toUSShortDate\"</code>. This property\n is commonly modified for localization of applications. See\n <a href='http://en.wikipedia.org/wiki/Date_format_by_country' target='_blank'>http://en.wikipedia.org/wiki/Date_format_by_country</a>\n for a useful overview of standard date formats per country.\n\n",
        flags:"",
        examples:[
            "${isc.DocUtils.linkForExampleId('dateFormat')}",
            "${isc.DocUtils.linkForExampleId('customDateFormat')}"
        ],
        name:"setShortDisplayFormat"
    },
    "method:ListGrid.cellErrorIconOut":{
        seeAlso:[
            {
                ref:"attr:ListGrid.showErrorIcons",
                description:null
            }
        ],
        type:"method",
        definingClass:"class:ListGrid",
        returns:{
            type:"boolean",
            description:"false to suppress the standard behavior (clear the standard error                    message hover if it is showing)"
        },
        groups:[
            "events"
        ],
        deprecated:null,
        ref:"method:ListGrid.cellErrorIconOut",
        params:[
            {
                defaultValue:null,
                optional:false,
                type:"ListGridRecord",
                description:"cell record as returned by getCellRecord()",
                name:"record"
            },
            {
                defaultValue:null,
                optional:false,
                type:"number",
                description:"row number for the cell",
                name:"rowNum"
            },
            {
                defaultValue:null,
                optional:false,
                type:"number",
                description:"column number of the cell",
                name:"colNum"
            }
        ],
        description:" Optional stringMethod to fire when the mouse moves off the error icon of a cell with \n validation errors.\n\n",
        flags:"A",
        name:"cellErrorIconOut"
    },
    "attr:FormItem.cellStyle":{
        seeAlso:[
        ],
        defaultValue:"\"formCell\"",
        type:"attr",
        definingClass:"class:FormItem",
        groups:[
            "formItemStyling"
        ],
        ref:"attr:FormItem.cellStyle",
        deprecated:null,
        setter:[
            "setCellStyle"
        ],
        valueType:"FormItemBaseStyle",
        description:"CSS style applied to the form item as a whole, including the text element, any icons, and\n any hint text for the item. Applied to the cell containing the form item.\n <P>\n See ${isc.DocUtils.linkForRef('group:formItemStyling')} for an overview of formItem styling, and \n the ${isc.DocUtils.linkForRef('group:CompoundFormItem_skinning')} discussion for special\n skinning considerations.",
        flags:"IRW",
        name:"cellStyle"
    },
    "attr:DynamicForm.canEdit":{
        seeAlso:[
            {
                ref:"attr:DynamicForm.readOnlyDisplay",
                description:null
            }
        ],
        defaultValue:"null",
        type:"attr",
        definingClass:"class:DynamicForm",
        groups:[
            "readOnly"
        ],
        ref:"attr:DynamicForm.canEdit",
        deprecated:null,
        valueType:"Boolean",
        setter:[
            "setCanEdit"
        ],
        description:"If set to <code>false</code>, the form will be marked read-only. A widget on the form\n is editable if either (1) beginning with the widget and continuing up the containment\n hierarchy, including the form, the first widget to have a non-null <code>canEdit</code>\n attribute has canEdit:true, or (2) neither the widget nor any parent has a non-null\n <code>canEdit</code> attribute. This setting allows you to enable or disable the default\n editability of the form's items at one time.\n <p>\n This setting differs from the enabled/disabled state in that most form items will\n allow copying of the contents while read-only but do not while disabled.\n <p>\n Note that a form is considered editable if <code>canEdit</code> is null (default) or\n <code>true</code>.\n\n ",
        flags:"IRWA",
        name:"canEdit"
    },
    "attr:ResultTree.linkDataAddOperation":{
        seeAlso:[
        ],
        defaultValue:"null",
        type:"attr",
        definingClass:"class:ResultTree",
        groups:[
            "multiLinkTree"
        ],
        deprecated:null,
        ref:"attr:ResultTree.linkDataAddOperation",
        valueType:"String",
        description:"The ${isc.DocUtils.linkForRef('attr:DSRequest.operationId','operationId')} this <code>ResultTree</code> should use \n when performing add operations on its ${isc.DocUtils.linkForRef('attr:ResultTree.linkDataSource')}.  Has no effect\n if this is not a ${isc.DocUtils.linkForRef('method:Tree.isMultiLinkTree','multi-link tree')}.\n <p>\n Note, this property wll be used by internal update operations when you drag-move or \n drag-reparent nodes in a multi-link tree.  Do not use it when adding records from \n application code by directly calling <code>addData()</code> on the \n ${isc.DocUtils.linkForRef('attr:ResultTree.linkDataSource','linkDataSource')}; instead just use the regular \n <code>operationId</code> property in your add request.  Also note, because this \n property is intended to allow your code to influence the operationId used by internal \n methods, and those methods never directly update link data (moved and re-parented links \n are always removed and then re-added), there is no corresponding \n <code>linkDataUpdateOperation</code> property.",
        flags:"IRW",
        name:"linkDataAddOperation"
    },
    "method:ValuesManager.saveData":{
        seeAlso:[
        ],
        type:"method",
        definingClass:"class:ValuesManager",
        groups:[
            "dataBoundComponentMethods"
        ],
        deprecated:null,
        ref:"method:ValuesManager.saveData",
        params:[
            {
                defaultValue:null,
                optional:true,
                type:"DSCallback",
                description:"callback to invoke on completion",
                name:"callback"
            },
            {
                defaultValue:null,
                optional:true,
                type:"DSRequest",
                description:"additional properties to set on the DSRequest                                            that will be issued",
                name:"requestProperties"
            }
        ],
        description:"\n Validate and then save the form's current values to the ${isc.DocUtils.linkForRef('class:DataSource')} this form is\n bound to.\n <p>\n If client-side validators are defined, they are executed first, and if any errors are\n found the save is aborted and the form will show the errors.\n <p>\n If client-side validation passes, a ${isc.DocUtils.linkForRef('object:DSRequest')} will be sent, exactly as though\n ${isc.DocUtils.linkForRef('method:DataSource.addData')} or ${isc.DocUtils.linkForRef('method:DataSource.updateData')} had been called with \n ${isc.DocUtils.linkForRef('method:DynamicForm.getValues','the form\\'s values')} as data.  The\n ${isc.DocUtils.linkForRef('attr:DSRequest.operationType')} will be either \"update\" or \"add\", depending on the\n current ${isc.DocUtils.linkForRef('attr:DynamicForm.saveOperationType')}.\n <P>\n On either a client-side or server-side validation failure, validation errors will be\n displayed in the form.  Visible items within a DynamicForm will be redrawn to display\n errors. Validation failure occurring on hidden items, or DataSource fields with no \n associated form items may be handled via ${isc.DocUtils.linkForRef('method:DynamicForm.handleHiddenValidationErrors')}\n or ${isc.DocUtils.linkForRef('method:ValuesManager.handleHiddenValidationErrors')}.\n <P>\n In the case of a validation error, the callback will <b>not</b> be called by default\n since the form has already handled the failed save by displaying the validation errors\n to the user.  If you need to do something additional in this case, you can set\n ${isc.DocUtils.linkForRef('attr:RPCRequest.willHandleError')} via the <code>requestProperties</code> parameter to\n force your callback to be invoked.  However, first consider:\n <ul>\n <li> if you are trying to customize display of validation errors, there are several\n ${isc.DocUtils.linkForRef('attr:DynamicForm.showErrorIcons','built-in modes')} and ${isc.DocUtils.linkForRef('method:DynamicForm.showErrors')} may be a better\n place to put customizations.\n <li> for unrecoverable general errors (eg server is down),\n ${isc.DocUtils.linkForRef('classMethod:RPCManager.handleError','central error handling')} in invoked, so consider placing\n customizations there unless an unrecoverable error should be handled specially by this\n specific form.\n </ul>\n <b>Note:</b> If a form is to be cleared after saving data, we recommend clearing the\n form from the callback rather than calling saveData() and then synchronously clearing\n the form. This gives users a chance to view and respond to any validation errors\n returned by the server. It is also required to ensure forms containing an\n ${isc.DocUtils.linkForRef('class:FileItem','upload field')}, have a chance to upload the file to the server.\n\n",
        flags:"",
        examples:[
            "${isc.DocUtils.linkForExampleId('addOperation')}"
        ],
        name:"saveData"
    },
    "classMethod:Time.toShortTime":{
        seeAlso:[
            {
                ref:"classMethod:Time.toTime",
                description:null
            }
        ],
        ref:"classMethod:Time.toShortTime",
        deprecated:null,
        type:"classMethod",
        definingClass:"class:Time",
        params:[
            {
                defaultValue:null,
                optional:false,
                type:"Date",
                description:"Date to convert to a time string.",
                name:"date"
            },
            {
                defaultValue:null,
                optional:true,
                type:"TimeDisplayFormat | FormatString | Function",
                description:"Optional custom  formatter to use. Will accept a function (which will be passed a pointer to the\n  Date to format), a format string, or a string designating a standard formatter",
                name:"formatter"
            },
            {
                defaultValue:null,
                optional:true,
                type:"boolean",
                description:"Is the date passed in a representation of a logical time value such as  a value from a <code>\"time\"</code> type field on a dataSource or a datetime value? \n  For datetime values the formatted string will respect any custom \n ${isc.DocUtils.linkForRef('classMethod:Time.setDefaultDisplayTimezone','display timezone')}.\n If not explicitly specified, the date passed in will be assumed to be a datetime unless\n it was created explicitly as a time via ${isc.DocUtils.linkForRef('classMethod:Time.createLogicalTime')} or similar APIs.",
                name:"logicalTime"
            }
        ],
        description:" Given a date object, return the time associated with the date as a short string.\n If no formatter is passed, use the standard formatter set up via ${isc.DocUtils.linkForRef('classMethod:Time.setShortDisplayFormat')}\n",
        flags:"",
        name:"toShortTime"
    },
    "attr:StatefulCanvas.showMenuOnClick":{
        seeAlso:[
        ],
        ref:"attr:StatefulCanvas.showMenuOnClick",
        defaultValue:"null",
        deprecated:null,
        type:"attr",
        definingClass:"class:StatefulCanvas",
        valueType:"Boolean",
        description:"If true, this widget will fire ${isc.DocUtils.linkForRef('method:Canvas.showContextMenu','showContextMenu()')} to\n show the ${isc.DocUtils.linkForRef('attr:Canvas.contextMenu','context menu')} if one is defined, rather than\n ${isc.DocUtils.linkForRef('method:Canvas.click','click()')}, when the left mouse is clicked.\n <P>\n Note that this property has a different interpretation in ${isc.DocUtils.linkForRef('class:IconButton')} as\n ${isc.DocUtils.linkForRef('attr:IconButton.showMenuOnClick')}.",
        flags:"IRW",
        name:"showMenuOnClick"
    },
    "method:ListGrid.setFieldHeaderBaseStyle":{
        seeAlso:[
        ],
        ref:"method:ListGrid.setFieldHeaderBaseStyle",
        deprecated:null,
        type:"method",
        definingClass:"class:ListGrid",
        params:[
            {
                defaultValue:null,
                optional:false,
                type:"String",
                description:"name of the field.",
                name:"name"
            },
            {
                defaultValue:null,
                optional:false,
                type:"CSSStyleName",
                description:"new baseStyle for the field header",
                name:"newStyle"
            }
        ],
        description:" Update the ${isc.DocUtils.linkForRef('attr:ListGridField.headerBaseStyle')} for a field within the grid at runtime.\n",
        flags:"",
        name:"setFieldHeaderBaseStyle"
    },
    "attr:ListGrid.booleanBaseStyle":{
        seeAlso:[
            {
                ref:"attr:ListGrid.printBooleanBaseStyle",
                description:null
            }
        ],
        defaultValue:"null",
        type:"attr",
        definingClass:"class:ListGrid",
        groups:[
            "imageColumns"
        ],
        deprecated:null,
        ref:"attr:ListGrid.booleanBaseStyle",
        valueType:"CSSStyleName",
        description:"An optional CSS style to apply to the checkbox image. If supplied, and the checkbox is\n enabled, the base style is suffixed with \"True\", \"False\", or \"Partial\" if the checkbox\n is selected, unselected, or partially selected; if the checkbox is disabled, the suffix\n is \"TrueDisabled\", \"FalseDisabled\", or \"PartialDisabled\".\n <p>\n <b>NOTE:</b> This attribute is not supported by ${isc.DocUtils.linkForRef('class:TreeGrid')}.",
        flags:"IRA",
        name:"booleanBaseStyle"
    },
    "method:DataBoundComponent.getFieldNum":{
        seeAlso:[
        ],
        ref:"method:DataBoundComponent.getFieldNum",
        deprecated:null,
        type:"method",
        definingClass:"interface:DataBoundComponent",
        params:[
            {
                defaultValue:null,
                optional:false,
                type:"FieldName | Field",
                description:"field name or field",
                name:"fieldName"
            }
        ],
        description:" Find the index of a currently visible field.\n\n",
        flags:"",
        returns:{
            type:"int",
            description:"index of field within currently visible fields, or -1 if not found."
        },
        name:"getFieldNum"
    },
    "attr:ListGrid.groupTitleColumnProperties":{
        seeAlso:[
        ],
        ref:"attr:ListGrid.groupTitleColumnProperties",
        defaultValue:"null",
        deprecated:null,
        type:"attr",
        definingClass:"class:ListGrid",
        valueType:"ListGridField Properties",
        description:"Custom properties for the automatically generated <code>groupTitleColumn</code>.\n <P>\n See ${isc.DocUtils.linkForRef('attr:ListGrid.showGroupTitleColumn')} for an overview of the groupTitleColumn.",
        flags:"IR",
        name:"groupTitleColumnProperties"
    },
    "attr:DrawnValue.barThickness":{
        seeAlso:[
        ],
        ref:"attr:DrawnValue.barThickness",
        defaultValue:"null",
        deprecated:null,
        type:"attr",
        definingClass:"object:DrawnValue",
        valueType:"int",
        description:"For bar and column charts, thickness of the bar representing this data value.",
        flags:"IR",
        name:"barThickness"
    },
    "classMethod:DataSource.makeFileSpec":{
        seeAlso:[
        ],
        type:"classMethod",
        definingClass:"class:DataSource",
        returns:{
            type:"FileSpec",
            description:"The equivalent FileSpec, e.g. {fileName: \"employees\", fileType: \"ds\",                    fileFormat: xml\"}"
        },
        groups:[
            "fileSource"
        ],
        deprecated:null,
        ref:"classMethod:DataSource.makeFileSpec",
        params:[
            {
                defaultValue:null,
                optional:false,
                type:"String",
                description:"The path to convert, e.g. \"employees.ds.xml\"",
                name:"path"
            }
        ],
        description:"\n Converts a file path to a ${isc.DocUtils.linkForRef('object:FileSpec')}.\n\n",
        flags:"",
        name:"makeFileSpec"
    },
    "class:GridTransferDataTask":{
        seeAlso:[
            {
                ref:"method:ListGrid.transferSelectedData",
                description:null
            }
        ],
        type:"class",
        staticMethods:[
        ],
        inheritsFrom:"ComponentTask",
        classMethods:[
        ],
        classAttrs:[
        ],
        attrs:[
            "attr:GridTransferDataTask.sourceComponent"
        ],
        ref:"class:GridTransferDataTask",
        deprecated:null,
        treeLocation:[
            "Client Reference/Workflow"
        ],
        description:"Transfer selected records from one grid to another.",
        methods:[
        ],
        name:"GridTransferDataTask"
    },
    "classAttr:Layout.HORIZONTAL":{
        seeAlso:[
        ],
        defaultValue:"\"horizontal\"",
        type:"classAttr",
        definingClass:"class:Layout",
        deprecated:null,
        ref:"classAttr:Layout.HORIZONTAL",
        valueType:"Constant",
        description:"A declared value of the enum type  \n ${isc.DocUtils.linkForRef('type:Orientation','Orientation')}.",
        flags:"R",
        name:"HORIZONTAL",
        constant:true
    },
    "attr:DrawLinePath.connectorOrientation":{
        seeAlso:[
        ],
        defaultValue:"\"auto\"",
        type:"attr",
        definingClass:"class:DrawLinePath",
        groups:[
            "line"
        ],
        deprecated:null,
        ref:"attr:DrawLinePath.connectorOrientation",
        valueType:"ConnectorOrientation",
        description:"The ConnectorOrientation controlling the orientation and behavior of this line's \n tail segments.",
        flags:"IR",
        name:"connectorOrientation"
    },
    "method:FacetChart.getDataLineWidth":{
        seeAlso:[
            {
                ref:"attr:DrawItem.lineWidth",
                description:null
            },
            {
                ref:"method:FacetChart.getDataLineColor",
                description:null
            }
        ],
        ref:"method:FacetChart.getDataLineWidth",
        deprecated:null,
        type:"method",
        definingClass:"class:FacetChart",
        params:[
            {
                defaultValue:null,
                optional:false,
                type:"Number",
                description:"index of the legend facet value to target",
                name:"index"
            },
            {
                defaultValue:null,
                optional:false,
                type:"String | Number | Date",
                description:"id of the legend facet value to target",
                name:"facetValueId"
            },
            {
                defaultValue:null,
                optional:false,
                type:"String",
                description:"purpose for the requested width - such as \"legend\", \"line\",                         \"area\", \"points\", etc.",
                name:"purpose"
            }
        ],
        description:" Specifies the width to use for data lines in the chart.  No default implementation.  If not\n defined or null is returned, the line width will be set by the appropriate chart properties,\n such as ${isc.DocUtils.linkForRef('attr:FacetChart.dataLineProperties')}, ${isc.DocUtils.linkForRef('attr:FacetChart.barProperties')}, or ${isc.DocUtils.linkForRef('attr:FacetChart.bubbleProperties')}.\n \n <P>\n Note that this method is simply an override point, since it has no default implementation.\n \n\n",
        flags:"",
        returns:{
            type:"int",
            description:"width to use for data lines or null to use ${isc.DocUtils.linkForRef('type:ChartType')} default"
        },
        name:"getDataLineWidth"
    },
    "classAttr:RPCResponse.STATUS_LOGIN_SUCCESS":{
        seeAlso:[
            {
                ref:"object:RPCRequest",
                description:null
            }
        ],
        defaultValue:"-8",
        type:"classAttr",
        definingClass:"class:RPCResponse",
        groups:[
            "statusCodes",
            "constant"
        ],
        deprecated:null,
        ref:"classAttr:RPCResponse.STATUS_LOGIN_SUCCESS",
        valueType:"int",
        description:"Indicates that the login succeeded.",
        flags:"R",
        name:"STATUS_LOGIN_SUCCESS"
    },
    "method:ListGridField.defaultDynamicValue":{
        groups:[
            "editing"
        ],
        seeAlso:[
        ],
        ref:"method:ListGridField.defaultDynamicValue",
        deprecated:null,
        type:"method",
        definingClass:"object:ListGridField",
        params:[
            {
                defaultValue:null,
                optional:false,
                type:"FormItem",
                description:"The editor for the cell itself (also available as \"this\").                              Note that in addition to the standard FormItem APIs available\n                              on the editor, it also has:<br>\n                              - a pointer back to the containing listGrid\n                              [<code>item.grid</code>]<br>\n                              - the colNum being edited [<code>item.colNum</code>]<br>\n                              - the rowNum being edited [<code>item.rowNum</code>]",
                name:"item"
            },
            {
                defaultValue:null,
                optional:false,
                type:"DynamicForm",
                description:"the managing DynamicForm instance",
                name:"form"
            },
            {
                defaultValue:null,
                optional:false,
                type:"Object",
                description:"the current set of values for the form as a whole",
                name:"values"
            }
        ],
        description:" ${isc.DocUtils.linkForRef('method:FormItem.defaultDynamicValue')} to be applied to the cell editor for this field\n when ${isc.DocUtils.linkForRef('attr:ListGridField.canEdit','editing')}.\n <P>\n Note that editors are only generated for fields that are actually written out, and\n as such <code>defaultDynamicValue</code> will not apply to\n ${isc.DocUtils.linkForRef('attr:ListGridField.hidden','hidden fields')}, or fields that are not drawn due to\n ${isc.DocUtils.linkForRef('attr:ListGrid.showAllColumns','incremental column rendering')}.\n <P>\n To apply arbitrary default values to the grid when editing new records, developers may\n use the ${isc.DocUtils.linkForRef('method:ListGrid.startEditingNew','newValues parameter of startEditingNew()')}.\n\n",
        flags:"",
        name:"defaultDynamicValue"
    },
    "attr:RecordEditor.filterImg":{
        seeAlso:[
        ],
        ref:"attr:RecordEditor.filterImg",
        defaultValue:"\"[SKIN]filter.png\"",
        deprecated:null,
        type:"attr",
        definingClass:"class:RecordEditor",
        valueType:"SCImgURL",
        description:"${isc.DocUtils.linkForRef('attr:Button.icon','Icon')} to show on the ${isc.DocUtils.linkForRef('attr:RecordEditor.actionButton')} if this \n component is being used as a ${isc.DocUtils.linkForRef('attr:ListGrid.filterEditor')}.\n <P>\n Note that this ${isc.DocUtils.linkForRef('type:SCImgURL')} will be resolved using the ${isc.DocUtils.linkForRef('attr:RecordEditor.skinImgDir')} defined\n for the RecordEditor.",
        flags:"IR",
        name:"filterImg"
    },
    "attr:DataSource.auditDataSourceID":{
        seeAlso:[
        ],
        defaultValue:"null",
        type:"attr",
        definingClass:"class:DataSource",
        deprecated:null,
        ref:"attr:DataSource.auditDataSourceID",
        valueType:"String",
        description:"For DataSources with ${isc.DocUtils.linkForRef('attr:DataSource.audit','auditing enabled')}, optionally specifies the ID of the audit\n DataSource.  If this property is not specified, the ID of the audit DataSource will\n be <code>audit_[OriginalDSID] </code>",
        flags:"IR",
        serverDS:"only",
        name:"auditDataSourceID"
    },
    "type:Double":{
        seeAlso:[
            {
                ref:"type:double",
                description:null
            }
        ],
        ref:"type:Double",
        treeLocation:[
            "Client Reference/System"
        ],
        deprecated:null,
        type:"type",
        description:"A decimal (or \"floating point\") number, for example, 5.5.  Null is allowed.",
        name:"Double",
        baseType:"Number"
    },
    "attr:DataBoundComponent.descriptionField":{
        seeAlso:[
        ],
        ref:"attr:DataBoundComponent.descriptionField",
        defaultValue:"null",
        deprecated:null,
        type:"attr",
        definingClass:"interface:DataBoundComponent",
        valueType:"String",
        description:"Name of the field that has a long description of the record, or has the primary text data\n value for a record that represents an email message, SMS, log or similar.\n <P>\n This attribute has the same function as ${isc.DocUtils.linkForRef('attr:DataSource.descriptionField')} but can be\n set for a component with no dataSource, or can be used to override the dataSource setting.",
        flags:"IR",
        name:"descriptionField"
    },
    "method:GridRenderer.refreshCellStyle":{
        groups:[
            "appearance"
        ],
        seeAlso:[
            {
                ref:"method:GridRenderer.refreshCell",
                description:"to update cell contents too"
            }
        ],
        ref:"method:GridRenderer.refreshCellStyle",
        deprecated:null,
        type:"method",
        definingClass:"class:GridRenderer",
        params:[
            {
                defaultValue:null,
                optional:false,
                type:"number",
                description:"row number of cell to refresh",
                name:"rowNum"
            },
            {
                defaultValue:null,
                optional:false,
                type:"number",
                description:"column number of cell to refresh",
                name:"colNum"
            }
        ],
        description:" Refresh the styling of an individual cell without redrawing the grid.\n <P>\n The cell's CSS class and CSS text will be refreshed, to the current values returned by\n getCellStyle() and getCellCSSText() respectively.\n <P>\n The cell's contents (as returned by getCellValue()) will <b>not</b> be refreshed.  To\n refresh both styling and contents, call refreshCell() instead.\n\n",
        flags:"",
        name:"refreshCellStyle"
    },
    "group:visualBuilder":{
        refs:[
            "class:VisualBuilder"
        ],
        seeAlso:[
            {
                ref:"group:toolsDeployment",
                description:null
            }
        ],
        ref:"group:visualBuilder",
        treeLocation:[
            "Concepts"
        ],
        deprecated:null,
        type:"group",
        title:"Visual Builder",
        description:"The SmartClient Visual Builder tool is intended for:\n <ul>\n <li> business analysts and others doing functional application design, who want to create\n functional prototypes in a codeless, \"what you see is what you get\" environment\n <li> developers new to SmartClient who want to get a basic familiarity with component\n layout, component properties and SmartClient code structure\n <li> developers building simple applications that can be completed entirely within Visual\n Builder\n </ul>\n <P>\n <b>Visual Builder for Functional Design</b>\n <P>\n Visual Builder has several advantages over other tools typically used for functional design:\n <ul>\n <li> Visual Builder allows simple drag and drop manipulation of components, form-based\n editing of component properties, and simple connection of events to actions - all without\n requiring any code to be written.  It is actually simpler to use than\n DreamWeaver or other code-oriented prototyping tools\n <li> because Visual Builder generates clean code, designs will not have to be converted to\n another technology before development can proceed.  This reduces both effort and the\n potential for miscommunication\n <li> developers can add custom skinning, components with custom behaviors, and custom\n DataSources with sample datasets to Visual Builder so that the design environment is an even\n closer match to the final application.  This helps eliminate many types of unimplementable\n designs \n <li> because Visual Builder is built in SmartClient itself, Visual Builder is simply a \n web page, and does not require installation.  Visual Builder can be deployed to \n an internal network to allow teams with a mixture of technical and semi-technical \n users to collaboratively build and share prototypes of SmartClient-based applications.  \n </ul>\n <P>\n <h4>Launching &amp; Using Visual Builder</h4>\n <P>\n The SmartClient SDK already has Visual Builder installed - access\n it from the SDK Explorer under Tools -&gt; Visual Builder (see QuickStart Guide for how to\n access the SDK Explorer).\n \n \n <P>\n Basic usage instructions are embedded in Visual Builder itself, in the \"About Visual\n Builder\" pane.  Click on it to open it.\n <P>\n <b>Loading and Saving</b>\n <P>\n The \"Project\" pane within Visual Builder allows screens to be saved and reloaded for further\n editing.  Saved screens <b>can</b> be edited outside of Visual Builder and successfully\n reloaded, however, as with any design tool that provides a drag and drop, dialog-driven\n approach to screen creation, Visual Builder cannot work with entirely free-form code.  In\n particular, when a screen is loaded and then re-saved:\n <ul>\n <li> any indenting or spacing changes are not preserved \n <li> order of property or method definitions will revert to Visual Builder's default\n <li> while method definitions on components are preserved, any code <b>outside of</b>\n      component definitions will be dropped (in some cases adding such code will cause\n      loading to fail)\n <li> each Canvas-based component will be output separately, in the order these components\n      appear in the project tree, deepest first\n </ul>\n Generally speaking, screen definitions that you edit within Visual Builder should consist of\n purely declarative code.  Rather than appearing in screen definitions, custom components and\n JavaScript libraries should be added to Visual Builder itself via the customization\n facilities described below.\n <P>\n \n <!-- applies only to SmartClient since SmartGWT has a GWT module listing these resources -->\n <h4>Installing Visual Builder</h4>\n <P>\n Visual Builder comes already installed and working in the SDK, and can be used from there out\n of the box.  This is the simplest thing to do during initial prototyping.\n <P>\n Further on in the development cycle, it may be advantageous to have Visual Builder available \n outside the SDK, for example in your test environment.  Installing Visual Builder into \n such an environment is very easy:\n <ul>\n <li>Perform a normal installation procedure, as discussed ${isc.DocUtils.linkForRef('group:iscInstall','here')}</li>\n <li>Copy the following .jar files from the SDK <code>lib</code> folder to the target \n <code>WEB-INF/lib</code> folder: \n <ul>\n <li><code>isomorphic_tools.jar</code></li>\n <li><code>isomorphic_sql.jar</code></li>\n <li><code>isomorphic_hibernate.jar</code></li>\n </ul></li>\n <li>Copy the SDK <code>tools</code> folder to the target application root</li>\n </ul>\n Note that it is safe to include Visual Builder even in a production environment, so long \n as you ensure that the <code>tools</code> folder is protected with any normal HTTP\n authentication/authorization mechanism - for example, an authentication filter.\n \n <P>\n <h4>Customizing Visual Builder</h4>\n <P>\n The rest of this topic focuses on how Visual Builder can be customized and deployed by\n developers to make it more effective as a functional design tool for a particular\n organization.\n <P>\n <b>Adding Custom DataSources to Visual Builder</b>\n <P>\n DataSources placed in the project dataSources directory ([webroot]/shared/ds by default)\n will be detected by Visual Builder whenever it is started, and appear in the DataSource\n listing in the lower right-hand corner automatically.\n <P>\n If you have created a custom subclass of DataSource (eg, as a base class for several\n DataSources that contact the same web service), you can use it with Visual Builder by:\n <ul>\n <li> creating an XML version of the DataSource using the XML tag &lt;DataSource&gt; and the\n <code>constructor</code> property set to the name of your custom DataSource subclass (as\n described ${isc.DocUtils.linkForRef('group:componentXML')} under the heading <i>Custom Components</i>)\n <li> modifying [webroot]/tools/visualBuilder/globalDependencies.xml to load the JavaScript\n code for your custom DataSource class.  See examples in that file.\n </ul>\n <P>\n <b>Adding Custom Components to Visual Builder</b>\n <P>\n The Component Library on the right hand side of Visual Builder loads component definitions\n from two XML files in the [webroot]/tools/visualBuilder directory: customComponents.xml and\n defaultComponents.xml.  customComponents.xml is empty and is intended for developers to add\n their own components.  defaultComponents.xml can also be customized, but the base version\n will change between SmartClient releases.\n <P>\n As can be seen by looking at defaultComponents.xml, components are specified using a tree\n structure similar to that shown in the \n ${isc.DocUtils.linkForExampleId('treeLoadXML', 'tree XML loading example')}.  The properties that can be set on\n nodes are:\n <ul>\n <li> <code>type</code>: name of the SmartClient Class on which ${isc.DocUtils.linkForRef('classMethod:Class.create','create()')} will be\n called in order to construct the component.  <code>type</code> can be omitted to create\n a folder that cannot be dropped\n <li> <code>title</code>: title for the node\n <li> <code>defaults</code>: an Object specifying defaults to be passed to\n ${isc.DocUtils.linkForRef('classMethod:Class.create','create()')}.\n For example, you could add an \"EditableGrid\" node by using <code>type: \"ListGrid\"</code>\n and specifying:\n <pre>\n &lt;defaults canEdit=\"true\"/&gt;</pre>\n NOTE: if you set any defaults that are not Canvas properties, you need to provide explicit\n type as documented under <i>Custom Properties</i> for ${isc.DocUtils.linkForRef('group:componentXML')}.\n <li> <code>children</code>: components that should appear as children in the tree under this\n node\n <li> <code>icon</code>: icon to show in the Visual Builder component tree (if desired)\n <li> <code>iconWidth/Height/Size</code>: dimensions of the icon in pixels (\"iconSize\" sets\n both)\n <li> <code>showDropIcon</code>: for components that allow children, whether to show a\n special drop icon on valid drop (like ${isc.DocUtils.linkForRef('attr:TreeGrid.showDropIcons')}).\n </ul>\n <P>\n In order to use custom classes in Visual Builder, you must modify\n <code>[webroot]/tools/visualBuilder/globalDependencies.xml</code> to include:\n <ul>\n <li> the JavaScript class definition for the custom class (in other words, the\n ${isc.DocUtils.linkForRef('staticMethod:isc.defineClass','defineClass()')} call)\n <li> a ${isc.DocUtils.linkForRef('group:componentSchema','component schema')} for the custom component\n </ul>\n See globalDependencies.xml for examples.\n <P>\n <h4>Component Schema and Visual Builder</h4>\n <P>\n When you provide ${isc.DocUtils.linkForRef('group:componentSchema','custom schema')} for a component, Visual Builder\n uses that schema to drive component editing (Component Properties pane) and to drive drag\n and drop screen building functionality.\n <P>\n <b>Component Editing</b>\n <P>\n Newly declared fields will appear in the Component Editor in the \"Other\" category at the\n bottom by default.  You can create your own category by simply setting field.group to the\n name of a new group and using this on multiple custom fields.\n <P>\n The ComponentEditor will pick a FormItem for a custom field by the\n ${isc.DocUtils.linkForRef('type:FormItemType','same rules')} used for ordinary databinding, including the ability to\n set field.editorType to use a custom FormItem.\n <P>\n When properties are changed by the user, Visual Builder will look for an appropriate \"setter\n function\" for the custom field, for example, for a field named \"myProp\", Visual Builder will\n look for \"setMyProp\".  The target component will also be ${isc.DocUtils.linkForRef('method:Canvas.redraw','redrawn')}.\n <P>\n <b>Event -&gt; Action Bindings</b>\n <P>\n The Component Properties pane contains an Events tab that allows you wire components events\n to actions on any other component currently in the project.\n <P>\n Events are simply ${isc.DocUtils.linkForRef('group:stringMethods','StringMethods')} defined on the component.  In\n order to be considered events, method definitions must have been added to the class via\n ${isc.DocUtils.linkForRef('classMethod:Class.registerStringMethods')} and either be publicly documented SmartClient methods or,\n for custom classes, have a methods definition in the ${isc.DocUtils.linkForRef('group:componentSchema','component schema')}.\n Examples of events are: ${isc.DocUtils.linkForRef('method:ListGrid.recordClick')} and ${isc.DocUtils.linkForRef('method:DynamicForm.itemChange')}.\n <P>\n Actions are methods on any component that have a method definition in the\n ${isc.DocUtils.linkForRef('group:componentSchema','component schema')} and specify action=\"true\".\n <P>\n All available events (stringMethods) on a component are shown in the Events tab of the\n Component Editor.  Clicking the plus (+) sign next to the event name brings up a menu that\n shows a list of all components currently in the project and their available actions.\n Selecting an action from this submenu binds the action to the selected event.  When an event\n is bound to an action in this manner, automatic type matching is performed to pass arguments\n from the event to the action as follows:\n <ul>\n <li>Only non-optional parameters of the action are bound.\n <li>For each non-optional parameter of the action method, every parameter of the\n event method is inspected in order to either directly match the type (for non-object types)\n or to match an isAssignableFrom type check via a SmartClient schema inheritance check.\n <li>The 'type' of a parameter is determined from the type documented in the SmartClient\n reference for built-in components, or from the <code>type</code> attribute on the method\n param in the ${isc.DocUtils.linkForRef('group:componentSchema','component schema')} definition of a custom component.\n <li>When a matching parameter is found, it is assigned to the current slot of the action and\n not considered for further parameter matching.\n <li>The above pattern is repeated until all non-optional parameters are exhausted, all\n event parameters are exhausted, or until no further type matches can be inferred.\n </ul>\n The \"actionBinding\" log category can be enabled in the Developer Console to troubleshoot\n issues with automatic binding for custom methods.\n <P>\n <b>Component Drag and Drop</b>\n <P>\n Visual Builder uses component schema to determine whether a given drop is allowed and what\n methods should be called to accomplish the drop.  For example, any Canvas-based component\n can be dropped on a VLayout because VLayout has a \"members\" field of type \"Canvas\", and an \n ${isc.DocUtils.linkForRef('method:Layout.addMember','addMember()')} function.\n <P>\n Because of these rules, any subclass of Canvas will be automatically eligible to be dropped\n into any container that accepts a Canvas (eg, a Layout or Tab).  Any subclass of a FormItem\n will be, likewise, automatically eligible to be dropped into a DynamicForm.\n <P>\n \n <!-- this capability is SmartClient-specific until we have a means for custom SmartGWT\n      components to be added to Visual Builder -->\n You can declare custom containment relations, such as a custom class \"Wizard\" that accepts\n instances of the custom class \"Pane\" by simply declaring a\n ${isc.DocUtils.linkForRef('group:componentSchema','component schema')} that says that Wizard has a property called\n \"panes\" of type \"Pane\".  Then, provide methods that allow components to be added and removed:\n <ul>\n <li> for a ${isc.DocUtils.linkForRef('attr:DataSourceField.multiple','multiple')} field, provide \"add\" and \"remove\"\n functions based on the name of the field.  For example, for a field \"panes\" of type \"Pane\",\n provide \"addPane()\" that takes a Pane instance, and \"removePane()\" that takes a pane\n instance or pane ID \n <li> for a singular field (such as ${isc.DocUtils.linkForRef('attr:Canvas.contextMenu')} or ${isc.DocUtils.linkForRef('attr:Tab.pane')}), provide a\n setter method named after the field (eg setContextMenu()) that takes either an instance of\n the component or null for removal\n </ul>\n <P>\n The \"editing\" log category can be enabled in the Developer Console to troubleshoot issues\n with schema-driven drag and drop and automatic lookup of getter/setter and adder/remover\n methods.\n \n <P>\n <B>NOTE:</B> after modifying component schema, it may be necessary to restart the servlet\n engine and reload Visual Builder\n <P>\n <b>Presenting simplified components</b>\n <P>\n SmartClient components expose many methods and properties.  For some environments, it is\n more appropriate to provide a simplified list of properties, events, and actions on either\n built-in SmartClient components or your custom components.  This can be done by providing a\n custom ${isc.DocUtils.linkForRef('group:componentSchema','component schema')} for an existing component that exposes\n your minimal set.  You also need to provide a trivial subclass of the class you're exposing\n so that it can be instantiated.\n <P>\n For example, let's say you want to make a simplified button called EButton that exposes only\n the 'title' property and the 'click' event of a standard Button.  The following steps will\n accomplish this:\n <p>\n 1. Edit /tools/visualBuilder/customComponents.xml and add a block similar to the following\n to make your custom component appear in the Component Library:\n <pre>\n &lt;PaletteNode&gt;\n     &lt;title&gt;EButton&lt;/title&gt;\n     &lt;type&gt;EButton&lt;/type&gt;\n     &lt;icon&gt;button.gif&lt;/icon&gt;\n &lt;/PaletteNode&gt;\n </pre>\n 2. Next, create a custom schema: /isomorphic/system/schema/EButton.ds.xml as follows:\n <pre>\n &lt;DataSource ID=\"EButton\" inheritsFrom=\"Button\" Constructor=\"EButton\"\n             showLocalFieldsOnly=\"true\" showSuperClassActions=\"false\"\n             showSuperClassEvents=\"false\"&gt;\n \t   &lt;fields&gt;\n         &lt;field name=\"title\"  type=\"HTML\"/&gt;\n     &lt;/fields&gt;\n     &lt;methods&gt;\n         &lt;method name=\"click\"&gt;\n             &lt;description&gt;Fires when this button is clicked.&lt;/description&gt;\n         &lt;/method&gt;\n     &lt;/methods&gt;\n &lt;/DataSource&gt;\n </pre>\n See documentation above and also ${isc.DocUtils.linkForRef('group:componentSchema','component schema')} for what the\n properties above do.\n 3.  Finally, you'll need to define an EButton class as a simple subclass of Button, as\n follows:\n <pre>\n isc.defineClass(\"EButton\", \"Button\");\n </pre>\n To make sure that the Visual Builder will load the above definition, you'll need to place it\n into a JavaScript file being loaded by the Visual Builder.  If you do not already have\n such a file, you can create one and add it to the list of Visual Builder dependencies by\n adding an entry in /tools/visualBuilder/globalDependencies.xml.  See examples in that file\n for specifics.",
        name:"visualBuilder"
    },
    "attr:CubeGrid.facetValueAlign":{
        seeAlso:[
        ],
        defaultValue:"\"center\"",
        type:"attr",
        definingClass:"class:CubeGrid",
        groups:[
            "gridLayout"
        ],
        deprecated:null,
        ref:"attr:CubeGrid.facetValueAlign",
        valueType:"Alignment",
        description:"Default alignment for facet values (in headers).",
        flags:"IRW",
        name:"facetValueAlign"
    },
    "attr:Canvas.animateScrollTime":{
        seeAlso:[
        ],
        defaultValue:"null",
        type:"attr",
        definingClass:"class:Canvas",
        groups:[
            "animation"
        ],
        deprecated:null,
        ref:"attr:Canvas.animateScrollTime",
        valueType:"number",
        description:"Default time for performing an animated scroll.  If unset, <code>this.animateTime</code>\n will be used by default instead",
        flags:"IRWA",
        name:"animateScrollTime"
    },
    "method:DynamicForm.getEditorType":{
        seeAlso:[
        ],
        type:"method",
        definingClass:"class:DynamicForm",
        returns:{
            type:"String",
            description:"form item type for the field"
        },
        groups:[
            "editing"
        ],
        deprecated:null,
        ref:"method:DynamicForm.getEditorType",
        params:[
            {
                defaultValue:null,
                optional:false,
                type:"Object",
                description:"field definition for which we are deriving form item type.",
                name:"field"
            },
            {
                defaultValue:null,
                optional:true,
                type:"Object",
                description:"Current set of values being edited by this form. May be null.",
                name:"values"
            }
        ],
        description:"\n Returns the form item type (Class Name) to be created for some field.<br>\n By default <code>field.editorType</code> will be used if present - otherwise backs off to\n deriving the appropriate form item type from the data type of the field (see\n ${isc.DocUtils.linkForRef('type:FormItemType')} for details.\n\n",
        flags:"A",
        name:"getEditorType"
    },
    "attr:Calendar.dateEditingStyle":{
        seeAlso:[
        ],
        ref:"attr:Calendar.dateEditingStyle",
        defaultValue:"null",
        deprecated:null,
        type:"attr",
        definingClass:"class:Calendar",
        valueType:"DateEditingStyle",
        description:"Indicates the type of controls to use in event-windows.  Valid values are those in the \n ${isc.DocUtils.linkForRef('type:DateEditingStyle','DateEditingStyle')} type.\n <P>\n If unset, the editing style will be set to the field-type on the DataSource, if there is one.\n If there's no DataSource, it will be set to \"date\" if the \n ${isc.DocUtils.linkForRef('attr:Calendar.timelineGranularity','granularity')} is \"day\" or larger and \"time\" if granularity \n is \"minute\" or smaller, otherwise \"datetime\".",
        flags:"IR",
        name:"dateEditingStyle"
    },
    "attr:Layout.layoutStartMargin":{
        seeAlso:[
        ],
        ref:"attr:Layout.layoutStartMargin",
        defaultValue:"null",
        deprecated:null,
        type:"attr",
        definingClass:"class:Layout",
        valueType:"Integer",
        description:"Equivalent to ${isc.DocUtils.linkForRef('attr:Layout.layoutLeftMargin')} for a horizontal layout, or ${isc.DocUtils.linkForRef('attr:Layout.layoutTopMargin')} \n for a vertical layout.\n <p>\n If both <code>layoutStartMargin</code> and the more specific properties (top/left margin) \n are both set, the more specific properties win.",
        flags:"IRW",
        name:"layoutStartMargin"
    },
    "method:Calendar.getMonthViewHoverHTML":{
        seeAlso:[
        ],
        ref:"method:Calendar.getMonthViewHoverHTML",
        deprecated:null,
        type:"method",
        definingClass:"class:Calendar",
        params:[
            {
                defaultValue:null,
                optional:false,
                type:"Date",
                description:"Date the user is hovering over",
                name:"date"
            },
            {
                defaultValue:null,
                optional:false,
                type:"Array of CalendarEvent",
                description:"array of events occurring on the current date. May be empty.",
                name:"events"
            }
        ],
        description:" This method returns the hover HTML to be displayed when the user hovers over a cell\n displayed in the calendar month view tab.\n <P>\n Default implementation will display a list of the events occurring on the date the user is\n hovering over. Override for custom behavior. Note that returning null will suppress the\n hover altogether.\n\n",
        flags:"",
        returns:{
            type:"HTMLString",
            description:"HTML string to display"
        },
        name:"getMonthViewHoverHTML"
    },
    "attr:ListGrid.showSelectedRollUnderCanvas":{
        seeAlso:[
        ],
        defaultValue:"false",
        type:"attr",
        definingClass:"class:ListGrid",
        groups:[
            "rowEffects"
        ],
        deprecated:null,
        ref:"attr:ListGrid.showSelectedRollUnderCanvas",
        valueType:"Boolean",
        description:"This setting causes the ${isc.DocUtils.linkForRef('attr:ListGrid.rollUnderCanvas','roll under canvas')} to be\n displayed when the user rolls over selected records in the grid (but not when\n rolling over other records). This can be useful to display a \"Selected Over\"\n appearance which can't be easily achieved via standard cell styling.\n <P>\n As with ${isc.DocUtils.linkForRef('attr:ListGrid.showRollUnderCanvas')}, if this property is unset, but\n the related ${isc.DocUtils.linkForRef('attr:ListGrid.showSelectedRollOverCanvas')} property is true, both the\n the roll under and roll under canvases will be displayed as the user rolls \n over selected records.",
        flags:"IRWA",
        name:"showSelectedRollUnderCanvas"
    },
    "attr:FieldPickerWindow.fieldPicker":{
        seeAlso:[
        ],
        ref:"attr:FieldPickerWindow.fieldPicker",
        defaultValue:"null",
        deprecated:null,
        type:"attr",
        definingClass:"class:FieldPickerWindow",
        valueType:"AutoChild FieldPicker",
        description:"A ${isc.DocUtils.linkForRef('class:FieldPicker','FieldPicker')} for altering the working field-set in a \n ${isc.DocUtils.linkForRef('interface:DataBoundComponent','Data-bound component')}.",
        flags:"IR",
        name:"fieldPicker"
    },
    "attr:SpinnerItem.increaseIcon":{
        seeAlso:[
        ],
        ref:"attr:SpinnerItem.increaseIcon",
        defaultValue:"null",
        deprecated:null,
        type:"attr",
        definingClass:"class:SpinnerItem",
        valueType:"FormItemIcon AutoChild",
        description:"In ${isc.DocUtils.linkForRef('attr:SpinnerItem.writeStackedIcons','stacked mode')}, the icon to increase the spinner's\n value (an up arrow by default). This icon is generated automatically using\n the ${isc.DocUtils.linkForRef('type:AutoChild')} pattern. For skinning purposes, <code>increaseIconDefaults</code>\n may be modified using ${isc.DocUtils.linkForRef('classMethod:Class.changeDefaults','changeDefaults()')}. \n <P>\n If sizes for the increase and decrease icons are not explicitly specified in their\n autoChild configuration, they will be derived from the specified \n ${isc.DocUtils.linkForRef('attr:SpinnerItem.stackedIconsHeight')} and ${isc.DocUtils.linkForRef('attr:SpinnerItem.stackedIconsWidth')} \n properties.\n <P>\n See the\n ${isc.DocUtils.linkForRef('group:skinning','skinning overview')} for details on how to provide a sprited\n image for these icons.",
        flags:"R",
        name:"increaseIcon"
    },
    "method:ResultSet.resort":{
        seeAlso:[
        ],
        ref:"method:ResultSet.resort",
        deprecated:null,
        type:"method",
        definingClass:"class:ResultSet",
        description:" Forcibly resort this ResultSet by the current list of ${isc.DocUtils.linkForRef('object:SortSpecifier')}s.\n",
        flags:"",
        name:"resort"
    },
    "attr:Calendar.zoneTitleOrientation":{
        seeAlso:[
        ],
        ref:"attr:Calendar.zoneTitleOrientation",
        defaultValue:"\"bottom\"",
        deprecated:null,
        type:"attr",
        definingClass:"class:Calendar",
        valueType:"VerticalAlignment",
        description:"The vertical alignment of the header-text in each ${isc.DocUtils.linkForRef('attr:Calendar.zones','zone')}.",
        flags:"IR",
        name:"zoneTitleOrientation"
    },
    "attr:OperationBinding.useFlatFields":{
        seeAlso:[
        ],
        defaultValue:"false",
        type:"attr",
        definingClass:"class:OperationBinding",
        groups:[
            "clientDataIntegration"
        ],
        ref:"attr:OperationBinding.useFlatFields",
        deprecated:null,
        valueType:"boolean",
        description:"Setting <code>useFlatFields</code> on an operationBinding is equivalent to setting\n ${isc.DocUtils.linkForRef('attr:DSRequest.useFlatFields')} on all DataSource requests with the same ${isc.DocUtils.linkForRef('attr:OperationBinding.operationType')}\n as this <code>operationBinding</code>.\n <P>\n Typical usage is to combine operationBinding.useFlatFields with \n ${isc.DocUtils.linkForRef('attr:DataBoundComponent.useFlatFields','searchForm.useFlatFields')}, with the ${isc.DocUtils.linkForRef('class:SearchForm')}\n bound to the ${isc.DocUtils.linkForRef('method:WebService.getInputDS','input message')} of the web service operation set\n as ${isc.DocUtils.linkForRef('attr:OperationBinding.wsOperation')}.  This allows gratuitous nesting to be consistently\n bypassed in both the user presentation and in the actual XML messaging.\n <P>\n Note that <code>useFlatFields</code> is not generally recommended for use with input messages\n where multiple simple type fields exist with the same name, however if used in this way,\n the first field to use a given name wins.  \"first\" means the first field encountered in a\n depth first search.  \"wins\" means only the first field will be available in data binding,\n and only the first field will be populated in the generated XML message.",
        flags:"IR",
        serverDS:"allowed",
        name:"useFlatFields"
    },
    "attr:MenuButton.showMenuButtonImage":{
        seeAlso:[
        ],
        defaultValue:"true",
        type:"attr",
        definingClass:"class:MenuButton",
        deprecated:null,
        ref:"attr:MenuButton.showMenuButtonImage",
        setter:[
            "setShowMenuButtonImage"
        ],
        valueType:"Boolean",
        description:"Show menu button image (up / down arrowhead) for this menu button.",
        flags:"IR",
        name:"showMenuButtonImage"
    },
    "attr:TimeItem.showMillisecondItem":{
        seeAlso:[
        ],
        ref:"attr:TimeItem.showMillisecondItem",
        defaultValue:"false",
        deprecated:null,
        type:"attr",
        definingClass:"class:TimeItem",
        valueType:"Boolean",
        description:"Controls whether to display the ${isc.DocUtils.linkForRef('attr:TimeItem.millisecondItem')} when ${isc.DocUtils.linkForRef('attr:TimeItem.useTextField')} is false.",
        flags:"IRW",
        name:"showMillisecondItem"
    },
    "attr:HiliteRule.removeButton":{
        seeAlso:[
        ],
        ref:"attr:HiliteRule.removeButton",
        defaultValue:"null",
        deprecated:null,
        type:"attr",
        definingClass:"class:HiliteRule",
        valueType:"AutoChild ImgButton",
        description:"The Hilite removal ImgButton that appears before this Hilite if ${isc.DocUtils.linkForRef('attr:HiliteRule.showRemoveButton')} \n is set.\n <P>\n This component is an ${isc.DocUtils.linkForRef('type:AutoChild')} and as such may be customized via \n <code>hiliteRule.removeButtonProperties</code>.",
        flags:"IR",
        name:"removeButton"
    },
    "attr:RangeSlider.vertical":{
        seeAlso:[
        ],
        ref:"attr:RangeSlider.vertical",
        defaultValue:"false",
        deprecated:null,
        type:"attr",
        definingClass:"class:RangeSlider",
        valueType:"boolean",
        description:"Whether the rangeSlider should be vertical or horizontal.  Default is horizontal.",
        flags:"IR",
        name:"vertical"
    },
    "staticMethod:History.setHistoryTitle":{
        seeAlso:[
        ],
        ref:"staticMethod:History.setHistoryTitle",
        deprecated:null,
        type:"staticMethod",
        definingClass:"object:History",
        params:[
            {
                defaultValue:null,
                optional:false,
                type:"String",
                description:"The title to show in the history drop-down.",
                name:"title"
            }
        ],
        description:"\n Sets the title associated with all history entries.  This is the string that appears in the\n history drop-down.  If left unset, this default to the history id that is passed into\n ${isc.DocUtils.linkForRef('staticMethod:History.addHistoryEntry')}.\n <p>\n Note: Currently, this works in IE only.  You may call this method in all other browsers,\n but it will not change what's displayed in the history drop-down.\n\n",
        flags:"",
        name:"setHistoryTitle"
    },
    "classMethod:Flashlet.flashAvailable":{
        seeAlso:[
        ],
        ref:"classMethod:Flashlet.flashAvailable",
        deprecated:null,
        type:"classMethod",
        definingClass:"class:Flashlet",
        description:" Is Shockwave Flash installed on this browser?\n",
        flags:"",
        returns:{
            type:"boolean",
            description:"<code>true</code> if Flash is installed; <code>false</code> otherwise."
        },
        name:"flashAvailable"
    },
    "class:SpinnerItem":{
        seeAlso:[
        ],
        type:"class",
        staticMethods:[
        ],
        inheritsFrom:"TextItem",
        classMethods:[
        ],
        classAttrs:[
        ],
        attrs:[
            "attr:SpinnerItem.mask",
            "attr:SpinnerItem.maskSaveLiterals",
            "attr:SpinnerItem.maskPadChar",
            "attr:SpinnerItem.maskPromptChar",
            "attr:SpinnerItem.maskOverwriteMode",
            "attr:SpinnerItem.unstackedTextBoxStyle",
            "attr:SpinnerItem.unstackedPrintTextBoxStyle",
            "attr:SpinnerItem.unstackedReadOnlyTextBoxStyle",
            "attr:SpinnerItem.step",
            "attr:SpinnerItem.max",
            "attr:SpinnerItem.min",
            "attr:SpinnerItem.increaseIcon",
            "attr:SpinnerItem.increaseIconProperties",
            "attr:SpinnerItem.decreaseIcon",
            "attr:SpinnerItem.decreaseIconProperties",
            "attr:SpinnerItem.writeStackedIcons",
            "attr:SpinnerItem.stackedIconsWidth",
            "attr:SpinnerItem.stackedIconsHeight",
            "attr:SpinnerItem.unstackedIncreaseIcon",
            "attr:SpinnerItem.unstackedDecreaseIcon"
        ],
        ref:"class:SpinnerItem",
        deprecated:null,
        treeLocation:[
            "Client Reference/Forms/Form Items"
        ],
        description:"Item for picking a number. Includes arrow buttons to increase / decrease the value",
        methods:[
            "method:SpinnerItem.getNextValue",
            "method:SpinnerItem.getPreviousValue"
        ],
        examples:[
            "${isc.DocUtils.linkForExampleId('spinnerItem')}"
        ],
        name:"SpinnerItem"
    },
    "class:IPickTreeItem":{
        seeAlso:[
        ],
        type:"class",
        staticMethods:[
        ],
        inheritsFrom:"PickTreeItem",
        classMethods:[
        ],
        classAttrs:[
        ],
        attrs:[
            "attr:IPickTreeItem.button"
        ],
        ref:"class:IPickTreeItem",
        deprecated:null,
        treeLocation:[
            "Client Reference/Forms/Form Items"
        ],
        description:"Subclass of ${isc.DocUtils.linkForRef('class:PickTreeItem')} which shows an ${isc.DocUtils.linkForRef('class:IMenuButton')} rather than a\n simple ${isc.DocUtils.linkForRef('class:MenuButton')} as it's main button.",
        methods:[
        ],
        name:"IPickTreeItem"
    },
    "method:LoginDialog.loginFunc":{
        seeAlso:[
        ],
        ref:"method:LoginDialog.loginFunc",
        deprecated:null,
        type:"method",
        definingClass:"class:LoginDialog",
        params:[
            {
                defaultValue:null,
                optional:false,
                type:"Object",
                description:"Login credentials supplied by the user",
                name:"credentials"
            },
            {
                defaultValue:null,
                optional:false,
                type:"Function",
                description:"Function that must be called once the login transaction completes",
                name:"dialogCallback"
            }
        ],
        description:" User-supplied callback function to process login transactions.\n <p>If the user clicks the \"Log in\" button, the credentials entered by the user are passed to\n loginFunc as an Object with properties \"username\" and \"password\" (NOTE: both\n property names are all lowercase), as the variable \"credentials\".  For example:\n <pre>{ username: \"barney\", password: \"rUbbL3\" }</pre>\n <P>\n This function should then attempt to log in by whatever means is necessary.  The second\n parameter to the loginFunc, \"dialogCallback\", is a function, which must be called <i>whether\n login succeeds or fails</i> with a true/false value indicating whether login succeeded.\n <P>\n If the login dialog is dismissable (settable as properties.dismissable, default false) and\n the user dismisses it, loginFunc will be fired with null for the credentials.\n <P>\n The following code shows typical usage.  This code assumes you have created a global\n function sendCredentials() that send credentials to some authentication system and fires a\n callback function with the result:\n <pre>\n ...\n loginFunc : function (credentials, dialogCallback) {\n     if (credentials == null) return; // dismissed\n\n     // send credentials\n     sendCredentials(credentials, function (loginSucceeded) {\n         // report success or failure\n         dialogCallback(loginSucceeded);\n     })\n })\n ...\n </pre>\n",
        flags:"",
        name:"loginFunc"
    },
    "attr:MetricSettings.fixedFacetValue":{
        seeAlso:[
        ],
        ref:"attr:MetricSettings.fixedFacetValue",
        defaultValue:"null",
        deprecated:null,
        type:"attr",
        definingClass:"object:MetricSettings",
        valueType:"String | Number",
        description:"For a ${isc.DocUtils.linkForRef('attr:MetricSettings.multiFacet','single-facet')} chart of an extra value axis, this property provides a constant facet value\n for the second facet.  By varying the value of the other facet in multi-facet data, the chart\n obtains the series of values to plot.  The default facet value is the first facet value of the second facet.",
        flags:"IR",
        name:"fixedFacetValue"
    },
    "attr:DateTimeItem.displayFormat":{
        seeAlso:[
            {
                ref:"attr:DateTimeItem.inputFormat",
                description:null
            }
        ],
        ref:"attr:DateTimeItem.displayFormat",
        defaultValue:"null",
        deprecated:null,
        type:"attr",
        definingClass:"class:DateTimeItem",
        valueType:"DateDisplayFormat",
        description:"This property can be used to customize the format in which datetimes are displayed.<br>\n Should be set to a standard ${isc.DocUtils.linkForRef('type:DateDisplayFormat')} or\n a function which will return a formatted date time string.\n <P>\n If unset, the standard shortDateTime format as set up in \n ${isc.DocUtils.linkForRef('classMethod:DateUtil.setShortDatetimeDisplayFormat')} will be used.\n <P>\n <B>NOTE: you may need to update the ${isc.DocUtils.linkForRef('attr:DateTimeItem.inputFormat','inputFormat')}\n to ensure the DateItem is able to parse user-entered date strings back into Dates</B>",
        flags:"IRW",
        name:"displayFormat"
    },
    "group:formLayout":{
        refs:[
            "attr:DynamicForm.itemLayout",
            "attr:DynamicForm.numCols",
            "attr:DynamicForm.fixedColWidths",
            "attr:DynamicForm.colWidths",
            "attr:DynamicForm.minColWidth",
            "attr:DynamicForm.cellPadding",
            "attr:DynamicForm.cellBorder",
            "attr:DynamicForm.sectionVisibilityMode",
            "attr:FormItem.width",
            "attr:FormItem.height",
            "attr:FormItem.staticHeight",
            "attr:FormItem.titleColSpan",
            "attr:FormItem.colSpan",
            "attr:FormItem.rowSpan",
            "attr:FormItem.startRow",
            "attr:FormItem.endRow",
            "attr:ButtonItem.startRow",
            "attr:ButtonItem.endRow",
            "attr:SelectItem.height",
            "attr:TextAreaItem.staticHeight"
        ],
        seeAlso:[
            {
                ref:"attr:FormItem.width",
                description:null
            },
            {
                ref:"attr:FormItem.height",
                description:null
            },
            {
                ref:"attr:DynamicForm.itemLayout",
                description:null
            }
        ],
        ref:"group:formLayout",
        treeLocation:[
            "Client Reference/Forms"
        ],
        deprecated:null,
        type:"group",
        title:"Form Layout",
        description:"<b>FormItem Placement in Columns and Rows</b>\n <P>\n With the default tabular layout mechanism, items are laid out in rows from left to\n right until the number of columns, specified by ${isc.DocUtils.linkForRef('attr:DynamicForm.numCols','form.numCols')},\n is filled, then a new row is begun.  Flags on FormItems, including\n ${isc.DocUtils.linkForRef('attr:FormItem.startRow','startRow')}, ${isc.DocUtils.linkForRef('attr:FormItem.endRow','endRow')},\n ${isc.DocUtils.linkForRef('attr:FormItem.colSpan','colSpan')} and ${isc.DocUtils.linkForRef('attr:FormItem.rowSpan','rowSpan')}, control row and\n column placement and spanning.  \n <P>\n Note that the most common form items (TextItem, SelectItem, etc) take up <b>two</b>\n columns by default: one for the form control itself, and one for it's title.  The\n default setting of ${isc.DocUtils.linkForRef('attr:DynamicForm.numCols','form.numCols:2')} will result in one TextItem\n or SelectItem per row.\n <P>\n Note also that ButtonItems have both startRow:true and endRow:true by default.  You must\n set startRow and/or endRow to <code>false</code> on a ButtonItem in order to place a\n button in the same row as any other item.\n <P>\n The log category \"tablePlacement\" can be enabled from the Developer Console to watch\n items being placed.  You can also set ${isc.DocUtils.linkForRef('attr:DynamicForm.cellBorder','form.cellBorder:1')} to\n reveal the table structure for layout troubleshooting purposes.\n <P>\n <b>Row and Column Sizing</b>\n <P>\n ${isc.DocUtils.linkForRef('attr:DynamicForm.colWidths')} controls the widths of form columns.  FormItems that have\n \"*\" for ${isc.DocUtils.linkForRef('attr:FormItem.width')} will fill the column.  FormItems with a numeric width will\n have that width in pixels regardless of the column's specified width, which may cause the\n column to overflow as described under ${isc.DocUtils.linkForRef('attr:DynamicForm.fixedColWidths')}.\n <P>\n For row heights, the largest pixel height specified on any item in the row is taken as a\n minimum size for the row.  Then, any rows that have \"*\" or \"%\" height items will share\n any height not taken up by fixed-sized items.\n <P>\n Individual item heights are controlled by ${isc.DocUtils.linkForRef('attr:FormItem.height','item.height')}. This may be specified as\n an integer (pixel value), or a percentage string, or the special string \"*\", which \n indicates an item should fill the available space.<br>\n Percentages allow developers to determine how the available space in the form\n is split amongst items. For example if a form has 4 items in a single column,\n 2 of which have an  absolute pixel height specified, and 2 of which are have\n heights of <code>\"30%\"</code> and <code>\"70%\"</code> respectively, the percentage\n sized items will split up the available space after the fixed size items have been\n rendered.<br>\n Note that ${isc.DocUtils.linkForRef('attr:FormItem.cellHeight','item.cellHeight')} may be specified to explicitly control the height of \n an item's cell. In this case the specified ${isc.DocUtils.linkForRef('attr:FormItem.height','item.height')} will govern the size\n of the item within the cell (and if set to a percentage, this will be interpreted as\n a percentage of the cellHeight).\n <P>\n <b>Managing Overflow</b>\n <P>\n Forms often contain labels, data values, or instructional text which can vary in\n size based on the skin, data values, or internationalization settings.  There are a few\n ways to deal with a form potentially varying in size:\n <ol>\n <li> Allow scrolling when necessary, using ${isc.DocUtils.linkForRef('attr:Canvas.overflow','overflow:auto')}, either\n on the immediate form, or on some parent.\n <li> Place the form in a Layout along with a component that can render any specified\n size, such as a ${isc.DocUtils.linkForRef('class:ListGrid')}.  In this case, the Layout will automatically shrink the\n grid in order to accommodate the form.\n <li> Ensure that the form can always render at a designed minimum size by reducing\n the number of cases of variable-sized text, and testing remaining cases across all\n supported skins.  For example, move help text into hovers on help icons, or clip \n long text values at a maximum length and provide a hover to see the rest.\n </ol>\n\n Several examples of Form Layout are available ${isc.DocUtils.linkForExampleId('formsLayout', 'here')}.",
        name:"formLayout"
    },
    "attr:Tree.showRoot":{
        seeAlso:[
        ],
        defaultValue:"false",
        type:"attr",
        definingClass:"class:Tree",
        deprecated:null,
        ref:"attr:Tree.showRoot",
        setter:[
            "setShowRoot"
        ],
        valueType:"Boolean",
        description:"Controls whether the implicit root node is returned as part of the visible tree,\n specifically, whether it is returned in ${isc.DocUtils.linkForRef('method:Tree.getOpenList')}, which is the API view\n components typically use to get the list of visible nodes.\n <p>\n Default is to have the root node be implicit and not included in the open list, which means\n that the visible tree begins with the children of root.  This allows multiple nodes to\n appear at the top level of the tree.\n <P>\n You can set <code>showRoot:true</code> to show the single, logical root node as the only\n top-level node.  This property is only meaningful for Trees where you supplied a value for\n ${isc.DocUtils.linkForRef('attr:Tree.root')}, otherwise, you will see an automatically generated root node that is\n meaningless to the user.",
        flags:"IRW",
        name:"showRoot"
    },
    "attr:FacetChart.bandedBackground":{
        seeAlso:[
        ],
        ref:"attr:FacetChart.bandedBackground",
        defaultValue:"true",
        deprecated:null,
        type:"attr",
        definingClass:"class:FacetChart",
        valueType:"Boolean",
        description:"Whether to show alternating color bands in the background of chart.  See\n ${isc.DocUtils.linkForRef('attr:FacetChart.backgroundBandProperties')}.",
        flags:"IR",
        name:"bandedBackground"
    },
    "method:Canvas.setBottom":{
        groups:[
            "sizing"
        ],
        seeAlso:[
        ],
        ref:"method:Canvas.setBottom",
        deprecated:null,
        type:"method",
        definingClass:"class:Canvas",
        params:[
            {
                defaultValue:null,
                optional:false,
                type:"number",
                description:"new bottom coordinate",
                name:"bottom"
            }
        ],
        description:" Resizes the widget vertically to position its bottom edge at the specified coordinate.\n <P>\n NOTE: if you're setting multiple coordinates, use setRect(), moveTo() or resizeTo()\n instead\n\n",
        flags:"",
        name:"setBottom"
    },
    "attr:RPCRequest.useXmlHttpRequest":{
        seeAlso:[
            {
                ref:"classAttr:RPCManager.useXmlHttpRequest",
                description:null
            },
            {
                ref:"classMethod:RPCManager.xmlHttpRequestAvailable",
                description:null
            }
        ],
        ref:"attr:RPCRequest.useXmlHttpRequest",
        defaultValue:"RPCManager.useXmlHttpRequest",
        deprecated:"As of SmartClient 5.5, use ${isc.DocUtils.linkForRef('attr:RPCRequest.transport')}.  If you specify a value for this property, it will take precedence over ${isc.DocUtils.linkForRef('attr:RPCRequest.transport')}.",
        type:"attr",
        definingClass:"object:RPCRequest",
        valueType:"boolean",
        description:"Selects the default http transport for this RPCRequest.  If set to true, this request will use\n XMLHttpRequest for the transport to the server.  If set to false it will use a hidden frame.  If\n left unset, the transport mechanism is determined from the RPCManager default set in \n ${isc.DocUtils.linkForRef('classAttr:RPCManager.useXmlHttpRequest')}\n <p>\n If you're using queueing, note that all requests in the queue must use the same transport.\n If you attempt to send a request via a different transport than those that are currently on\n the queue, it will be sent to the server separately, ahead of the queue, and a warning will\n be logged to the Developer Console.\n <p>\n If you specify <code>true</code> for this attribute and XMLHttp is not available, a warning\n will be logged to the Developer Console and RPCManager will attempt to use the frames\n transport for this request.  Note that some features like\n ${isc.DocUtils.linkForRef('attr:RPCRequest.serverOutputAsString')} require the XMLHttp transport and will not work if the\n XMLHttp transport is unavailable (this can happen if the end user is using Internet Explorer\n and has disabled ActiveX).  You can query the availability of XMLHttp by calling\n ${isc.DocUtils.linkForRef('classMethod:RPCManager.xmlHttpRequestAvailable')}",
        flags:"IRWA",
        name:"useXmlHttpRequest"
    },
    "method:FormItem.getGridColNum":{
        seeAlso:[
        ],
        ref:"method:FormItem.getGridColNum",
        deprecated:null,
        type:"method",
        definingClass:"class:FormItem",
        description:" If this formItem is part of a ${isc.DocUtils.linkForRef('class:ListGrid')}'s \n ${isc.DocUtils.linkForRef('attr:ListGrid.canEdit','inline edit form')}, returns the number of the grid column this \n formItem is responsible for editing, but <b>only</b> if a row is currently being\n edited.  If the formItem is not part of a ListGrid inline edit for any reason, this \n method returns null.  Reasons for a formItem not being part of an inline edit include<ul>\n <li>The item is part of an ordinary DynamicForm, not an inline edit form</li>\n <li>There is no row in the grid currently being edited</li>\n <li>A row is being edited, but this formItem is not currently visible and is being \n excluded because of horizontal incremental rendering (where SmartClient avoids drawing\n grid columns that would not be visible without scrolling)</li>\n </ul>\n\n",
        flags:"",
        returns:{
            type:"Integer",
            description:"The grid column number being edited by this formItem, or null, as                    described above"
        },
        name:"getGridColNum"
    },
    "attr:FacetChart.zoomChartHeight":{
        seeAlso:[
        ],
        ref:"attr:FacetChart.zoomChartHeight",
        defaultValue:"100",
        deprecated:null,
        type:"attr",
        definingClass:"class:FacetChart",
        valueType:"float",
        description:"Height of the ${isc.DocUtils.linkForRef('attr:FacetChart.zoomChart')}.  The zoomChart is always as wide as the main chart.",
        flags:"IR",
        name:"zoomChartHeight"
    },
    "classMethod:TabIndexManager.focusInTarget":{
        seeAlso:[
        ],
        ref:"classMethod:TabIndexManager.focusInTarget",
        deprecated:null,
        type:"classMethod",
        definingClass:"class:TabIndexManager",
        params:[
            {
                defaultValue:null,
                optional:false,
                type:"String",
                description:"target to shift focus to",
                name:"ID"
            }
        ],
        description:" Request the TabIndexManager shift focus to a registered focus target.\n <P>\n This method does not directly change the focus within the DOM - instead it invokes the \n <code>shiftFocusCallback</code> registered for the specified target if it is marked as\n <code>canFocus:true</code>.\n <P>\n Returns false if the target had no no <code>shiftFocusCallback</code>, \n the <code>shiftFocusCallback</code> returned false, or if the target is marked\n as not <code>canFocus:true</code>\n",
        flags:"",
        returns:{
            type:"boolean",
            description:"returns false to indicate failure to shift focus."
        },
        name:"focusInTarget"
    },
    "classAttr:Log.WARN":{
        seeAlso:[
        ],
        defaultValue:"3",
        type:"classAttr",
        definingClass:"class:Log",
        deprecated:null,
        ref:"classAttr:Log.WARN",
        valueType:"int",
        description:"A declared value of the enum type  \n ${isc.DocUtils.linkForRef('type:LogPriority','LogPriority')}.",
        flags:"R",
        name:"WARN",
        constant:true
    },
    "method:ResultTree.getOpenState":{
        groups:[
            "viewState"
        ],
        seeAlso:[
            {
                ref:"method:ResultTree.setOpenState",
                description:null
            }
        ],
        ref:"method:ResultTree.getOpenState",
        deprecated:null,
        type:"method",
        definingClass:"class:ResultTree",
        description:" Returns a snapshot of the current open state of this tree's data as\n a ${isc.DocUtils.linkForRef('type:TreeGridOpenState')} object.\n <P>\n This object can be passed to ${isc.DocUtils.linkForRef('method:ResultTree.setOpenState')} or\n ${isc.DocUtils.linkForRef('method:TreeGrid.setOpenState')} to open the same set of folders\n within the tree's data (assuming the nodes are still present in the data).\n",
        flags:"",
        returns:{
            type:"TreeGridOpenState",
            description:"current open state for the grid."
        },
        name:"getOpenState"
    },
    "object:FacetValue":{
        seeAlso:[
        ],
        requiresModules:[
            "Analytics"
        ],
        type:"object",
        staticMethods:[
        ],
        classMethods:[
        ],
        classAttrs:[
        ],
        attrs:[
            "attr:FacetValue.id",
            "attr:FacetValue.title",
            "attr:FacetValue.parentId",
            "attr:FacetValue.canEdit",
            "attr:FacetValue.collapsed",
            "attr:FacetValue.minimized",
            "attr:FacetValue.canCollapse",
            "attr:FacetValue.canMinimize",
            "attr:FacetValue.isMinimizeValue",
            "attr:FacetValue.width",
            "attr:FacetValue.align",
            "attr:FacetValue.cellAlign",
            "attr:FacetValue.borderBefore",
            "attr:FacetValue.borderAfter",
            "attr:FacetValue.selectionBoundary",
            "attr:FacetValue.titleHilite"
        ],
        ref:"object:FacetValue",
        deprecated:null,
        treeLocation:[
            "Optional Modules/Analytics/CubeGrid"
        ],
        description:"Facet value definition object made use of by the ${isc.DocUtils.linkForRef('class:CubeGrid','CubeGrid')} and\n ${isc.DocUtils.linkForRef('class:FacetChart','FacetChart')} classes (contained by facets).",
        methods:[
            "method:FacetValue.getCellValue",
            "method:FacetValue.formatCellValue"
        ],
        name:"FacetValue"
    },
    "attr:TabSet.animateTabScrolling":{
        seeAlso:[
        ],
        defaultValue:"true",
        type:"attr",
        definingClass:"class:TabSet",
        groups:[
            "tabBarControls"
        ],
        deprecated:null,
        ref:"attr:TabSet.animateTabScrolling",
        valueType:"Boolean",
        description:"If ${isc.DocUtils.linkForRef('attr:TabSet.showTabScroller')} is true, should tabs be scrolled into view via an \n animation when the user interacts with the scroller buttons?",
        flags:"IR",
        name:"animateTabScrolling"
    },
    "method:ListGrid.setHeaderSpans":{
        groups:[
            "headerSpan"
        ],
        seeAlso:[
        ],
        ref:"method:ListGrid.setHeaderSpans",
        deprecated:null,
        type:"method",
        definingClass:"class:ListGrid",
        params:[
            {
                defaultValue:null,
                optional:false,
                type:"Array of HeaderSpan",
                description:"same configuration block as that passed to                                          ${isc.DocUtils.linkForRef('attr:ListGrid.headerSpans')}.",
                name:"headerSpans"
            }
        ],
        description:" Update the headerSpans configuration on the grid dynamically.\n\n",
        flags:"",
        name:"setHeaderSpans"
    },
    "method:ProcessElement.getElementDescription":{
        seeAlso:[
        ],
        ref:"method:ProcessElement.getElementDescription",
        deprecated:null,
        type:"method",
        definingClass:"class:ProcessElement",
        description:" Returns a text description of the element derived from\n the configuration.\n <p>\n If no override is provided by the concrete ProcessElement\n implementation the ${isc.DocUtils.linkForRef('attr:ProcessElement.description')} or ${isc.DocUtils.linkForRef('attr:ProcessElement.ID')} is\n returned.\n\n",
        flags:"",
        returns:{
            type:"String",
            description:"the derived element description"
        },
        name:"getElementDescription"
    },
    "class:BaseWidget":{
        seeAlso:[
        ],
        type:"class",
        staticMethods:[
        ],
        inheritsFrom:"Class",
        classMethods:[
        ],
        classAttrs:[
        ],
        attrs:[
        ],
        ref:"class:BaseWidget",
        deprecated:null,
        treeLocation:[
            "Client Reference/Foundation"
        ],
        description:"Base class for ${isc.DocUtils.linkForRef('class:Canvas')} and ${isc.DocUtils.linkForRef('class:DrawItem')}.",
        methods:[
        ],
        name:"BaseWidget"
    },
    "classAttr:FileLoader.defaultModules":{
        seeAlso:[
            {
                ref:"staticMethod:FileLoader.cacheISC",
                description:null
            },
            {
                ref:"staticMethod:FileLoader.loadISC",
                description:null
            }
        ],
        ref:"classAttr:FileLoader.defaultModules",
        defaultValue:"\"Core,Foundation,Containers,Grids,Forms,DataBinding\"",
        deprecated:null,
        type:"classAttr",
        definingClass:"object:FileLoader",
        valueType:"String",
        description:"Default list of modules for\n ${isc.DocUtils.linkForRef('staticMethod:FileLoader.loadISC')}/${isc.DocUtils.linkForRef('staticMethod:FileLoader.cacheISC')} to use if none are\n provided by the user.",
        flags:"RW",
        name:"defaultModules"
    },
    "type:DSOperationType":{
        seeAlso:[
        ],
        ref:"type:DSOperationType",
        deprecated:null,
        type:"type",
        values:[
            {
                value:"\"fetch\"",
                description:"Fetch one or more records that match a set of search criteria."
            },
            {
                value:"\"add\"",
                description:"Store new records"
            },
            {
                value:"\"update\"",
                description:"Update an existing record"
            },
            {
                value:"\"remove\"",
                description:"Remove (delete) an existing record"
            },
            {
                value:"\"custom\"",
                description:"perform some arbitrary custom logic that is not a CRUD operation.                       Format of the inputs and outputs is unconstrained, and the operation\n                       will be ignored for cache sync purposes by ${isc.DocUtils.linkForRef('class:ResultSet')}s.  See \n                       ${isc.DocUtils.linkForRef('method:DataSource.performCustomOperation')}."
            },
            {
                value:"\"validate\"",
                description:"Run server-side validation for \"add\" or \"update\" without actually                       adding or updating anything.  See ${isc.DocUtils.linkForRef('method:DataSource.validateData')}."
            },
            {
                value:"\"viewFile\"",
                description:"Retrieve a file stored in a binary field in a DataSource record, and                       allow the browser to choose whether to view it directly or prompt the\n                       user to save.  See ${isc.DocUtils.linkForRef('group:binaryFields')}."
            },
            {
                value:"\"downloadFile\"",
                description:"Like \"viewFile\", but the HTTP header Content-Disposition is used to                       suggest that the browser show a save dialog.  See ${isc.DocUtils.linkForRef('group:binaryFields')}."
            },
            {
                value:"\"storeTestData\"",
                description:"Takes a List of Maps and stores the data in Admin Console XML test                       data format"
            },
            {
                value:"\"clientExport\"",
                description:"Upload formatted client data and export it to Excel, XML and other                        formats.  Used automatically by \n                       ${isc.DocUtils.linkForRef('method:DataSource.exportClientData','exportClientData()')} \n                       and cannot be used directly.  Usable only with the SmartClient server\n                       framework."
            },
            {
                value:"\"getFile\"",
                description:"Use the DataSource as a ${isc.DocUtils.linkForRef('group:fileSource','source for files')}.                       Used automatically by ${isc.DocUtils.linkForRef('method:DataSource.getFile')}, and\n                       would not normally be used directly. Usable only with\n                       the SmartClient server framework."
            },
            {
                value:"\"hasFile\"",
                description:"Use the DataSource as a ${isc.DocUtils.linkForRef('group:fileSource','source for files')}.                       Used automatically by ${isc.DocUtils.linkForRef('method:DataSource.hasFile')}, and\n                       would not normally be used directly. Usable only with\n                       the SmartClient server framework."
            },
            {
                value:"\"listFiles\"",
                description:"Use the DataSource as a ${isc.DocUtils.linkForRef('group:fileSource','source for files')}.                       Used automatically by ${isc.DocUtils.linkForRef('method:DataSource.listFiles')}, and\n                       would not normally be used directly. Usable only with\n                       the SmartClient server framework."
            },
            {
                value:"\"removeFile\"",
                description:"Use the DataSource as a ${isc.DocUtils.linkForRef('group:fileSource','source for files')}.                       Used automatically by ${isc.DocUtils.linkForRef('method:DataSource.removeFile')}, and\n                       would not normally be used directly. Usable only with\n                       the SmartClient server framework."
            },
            {
                value:"\"saveFile\"",
                description:"Use the DataSource as a ${isc.DocUtils.linkForRef('group:fileSource','source for files')}.                       Used automatically by ${isc.DocUtils.linkForRef('method:DataSource.saveFile')}, and\n                       would not normally be used directly. Usable only with\n                       the SmartClient server framework."
            },
            {
                value:"\"renameFile\"",
                description:"Use the DataSource as a ${isc.DocUtils.linkForRef('group:fileSource','source for files')}.                       Used automatically by ${isc.DocUtils.linkForRef('method:DataSource.renameFile')}, and\n                       would not normally be used directly. Usable only with\n                       the SmartClient server framework."
            },
            {
                value:"\"getFileVersion\"",
                description:"Use the DataSource as a ${isc.DocUtils.linkForRef('group:fileSource','source for files')}.                       Used automatically by ${isc.DocUtils.linkForRef('method:DataSource.getFileVersion')}, and\n                       would not normally be used directly. Usable only with\n                       the SmartClient server framework."
            },
            {
                value:"\"hasFileVersion\"",
                description:"Use the DataSource as a ${isc.DocUtils.linkForRef('group:fileSource','source for files')}.                       Used automatically by ${isc.DocUtils.linkForRef('method:DataSource.hasFileVersion')}, and\n                       would not normally be used directly. Usable only with\n                       the SmartClient server framework."
            },
            {
                value:"\"listFileVersions\"",
                description:"Use the DataSource as a ${isc.DocUtils.linkForRef('group:fileSource','source for files')}.                       Used automatically by ${isc.DocUtils.linkForRef('method:DataSource.listFileVersions')}, and\n                       would not normally be used directly. Usable only with\n                       the SmartClient server framework."
            },
            {
                value:"\"removeFileVersion\"",
                description:"Use the DataSource as a ${isc.DocUtils.linkForRef('group:fileSource','source for files')}.                       Used automatically by ${isc.DocUtils.linkForRef('method:DataSource.removeFileVersion')}, and\n                       would not normally be used directly. Usable only with\n                       the SmartClient server framework."
            }
        ],
        description:"One of the four basic operations that can be performed on DataSource data: \"fetch\",\n \"add\", \"update\", \"remove\".  Elsewhere called CRUD operations, where CRUD stands for\n \"create\", \"retrieve\", \"update\", \"delete\", which correspond to \"add\", \"fetch\", \"update\" and\n \"remove\" in SmartClient terminology.  See ${isc.DocUtils.linkForRef('group:dataSourceOperations')} for a full\n description.\n <p>\n There are also additional, non-CRUD operations explained below.",
        name:"DSOperationType"
    },
    "classMethod:Page.isLoaded":{
        seeAlso:[
        ],
        ref:"classMethod:Page.isLoaded",
        deprecated:null,
        type:"classMethod",
        definingClass:"class:Page",
        description:"\t\tHas the page finished loading?\n\n",
        flags:"",
        returns:{
            type:"Boolean",
            description:"true == page is done loading"
        },
        name:"isLoaded"
    },
    "method:Gauge.setDialRadius":{
        seeAlso:[
        ],
        ref:"method:Gauge.setDialRadius",
        deprecated:null,
        type:"method",
        definingClass:"class:Gauge",
        params:[
            {
                defaultValue:null,
                optional:false,
                type:"float",
                description:"Radius in pixels of the dial",
                name:"dialRadius"
            }
        ],
        description:" All DrawItems currently associated with this Gauge are destroyed and \n new DrawItems are created instead.\n\n",
        flags:"",
        name:"setDialRadius"
    },
    "class:SectionItem":{
        seeAlso:[
            {
                ref:"attr:DynamicForm.sectionVisibilityMode",
                description:null
            }
        ],
        type:"class",
        staticMethods:[
        ],
        inheritsFrom:"CanvasItem",
        classMethods:[
        ],
        classAttrs:[
        ],
        attrs:[
            "attr:SectionItem.defaultValue",
            "attr:SectionItem.itemIds",
            "attr:SectionItem.sectionVisible",
            "attr:SectionItem.sectionExpanded",
            "attr:SectionItem.sectionHeaderClass",
            "attr:SectionItem.canCollapse",
            "attr:SectionItem.canTabToHeader"
        ],
        ref:"class:SectionItem",
        deprecated:null,
        treeLocation:[
            "Client Reference/Forms/Form Items"
        ],
        description:"Header item for a collapsible section in a ${isc.DocUtils.linkForRef('class:DynamicForm')}.  Each <code>SectionItem</code>\n is associated with a number of other <code>item</code>s in the form, which will be shown or\n hidden as a group when the section is expanded or collapsed.  Clicking on a\n <code>SectionItem</code> will expand or collapse the section.\n <P>\n To make a form where only one section is expanded at a time, set\n ${isc.DocUtils.linkForRef('attr:DynamicForm.sectionVisibilityMode')} to \"mutex\".",
        methods:[
            "method:SectionItem.isExpanded",
            "method:SectionItem.expandSection",
            "method:SectionItem.collapseSection"
        ],
        examples:[
            "${isc.DocUtils.linkForExampleId('formSections')}"
        ],
        name:"SectionItem"
    },
    "method:Canvas.encloses":{
        seeAlso:[
        ],
        type:"method",
        definingClass:"class:Canvas",
        returns:{
            type:"Boolean",
            description:"true if this canvas encloses other; false otherwise"
        },
        groups:[
            "positioning"
        ],
        deprecated:null,
        ref:"method:Canvas.encloses",
        params:[
            {
                defaultValue:null,
                optional:false,
                type:"Canvas",
                description:"other canvas to test for enclosure",
                name:"other"
            }
        ],
        description:" Returns true if the rectangle of this widget encloses the rectangle of the specified widget.\n",
        flags:"",
        name:"encloses"
    },
    "method:PortalLayout.setCanShrinkColumnWidths":{
        groups:[
            "sizing"
        ],
        seeAlso:[
            {
                ref:"attr:PortalLayout.canShrinkColumnWidths",
                description:null
            },
            {
                ref:"attr:PortalLayout.canStretchColumnWidths",
                description:null
            }
        ],
        ref:"method:PortalLayout.setCanShrinkColumnWidths",
        deprecated:null,
        type:"method",
        definingClass:"class:PortalLayout",
        params:[
            {
                defaultValue:null,
                optional:false,
                type:"boolean",
                description:"Whether columns can shrink to avoid overflowing the PortalLayout's width.",
                name:"canShrink"
            }
        ],
        description:" Sets ${isc.DocUtils.linkForRef('attr:PortalLayout.canShrinkColumnWidths')} and reflows to reflect the new setting.\n",
        flags:"",
        name:"setCanShrinkColumnWidths"
    },
    "staticMethod:isc.showConsole":{
        groups:[
            "debug"
        ],
        seeAlso:[
        ],
        ref:"staticMethod:isc.showConsole",
        deprecated:null,
        type:"staticMethod",
        definingClass:"object:isc",
        description:"\n\tMethod available on the isc object to open the Developer Console.\n\n",
        flags:"",
        name:"showConsole"
    },
    "attr:DynamicForm.target":{
        seeAlso:[
        ],
        defaultValue:"null",
        type:"attr",
        definingClass:"class:DynamicForm",
        groups:[
            "submitting"
        ],
        ref:"attr:DynamicForm.target",
        deprecated:null,
        setter:[
            "setTarget"
        ],
        valueType:"String",
        description:"The name of a window or frame that will receive the results returned by the form's\n action. The default null indicates to use the current frame.\n <p>\n <b>NOTE:</b> this is used only in the very rare case that a form is used to submit data\n directly to a URL.  Normal server contact is through\n ${isc.DocUtils.linkForRef('group:dataBoundComponentMethods','DataBound Component Methods')}.",
        flags:"IRWA",
        name:"target"
    },
    "method:SectionItem.isExpanded":{
        seeAlso:[
        ],
        ref:"method:SectionItem.isExpanded",
        deprecated:null,
        type:"method",
        definingClass:"class:SectionItem",
        description:" Returns a boolean indicating whether this SectionItem is expanded.\n\n",
        flags:"",
        returns:{
            type:"Boolean",
            description:"true if the section is expanded false if not"
        },
        name:"isExpanded"
    },
    "method:ListGrid.setFieldIcon":{
        seeAlso:[
        ],
        ref:"method:ListGrid.setFieldIcon",
        deprecated:null,
        type:"method",
        definingClass:"class:ListGrid",
        params:[
            {
                defaultValue:null,
                optional:false,
                type:"String",
                description:"field to update",
                name:"fieldName"
            },
            {
                defaultValue:null,
                optional:false,
                type:"SCImgURL",
                description:"icon for the field",
                name:"icon"
            }
        ],
        description:" Change the ${isc.DocUtils.linkForRef('attr:ListGridField.icon')} for a field after the grid is created\n",
        flags:"",
        name:"setFieldIcon"
    },
    "attr:Tab.pane":{
        seeAlso:[
            {
                ref:"group:autoChildren",
                description:null
            },
            {
                ref:"method:TabSet.updateTab",
                description:null
            }
        ],
        ref:"attr:Tab.pane",
        defaultValue:"null",
        deprecated:null,
        type:"attr",
        definingClass:"object:Tab",
        valueType:"Canvas | ID | AutoChildShortcut",
        description:"Specifies the pane associated with this tab.  You have three options for the value of\n the pane attribute:\n <ul>\n <li><b>ID</b> - The global ID of an already created Canvas (or subclass).\n <li><b>Canvas</b> - A live instance of a Canvas (or subclass).\n <li><b>AutoChildShortcut</b> - String with format \"autoChild:<i>autoChildName</i>\"\n </ul>\n You can change the pane associated with a given tab after the TabSet has\n been created by calling ${isc.DocUtils.linkForRef('method:TabSet.updateTab')}.",
        flags:"IR",
        name:"pane"
    },
    "attr:DateItem.autoUseTextField":{
        seeAlso:[
        ],
        defaultValue:"true",
        type:"attr",
        definingClass:"class:DateItem",
        groups:[
            "basics"
        ],
        deprecated:null,
        ref:"attr:DateItem.autoUseTextField",
        valueType:"Boolean",
        description:"When set to true, the default, and when ${isc.DocUtils.linkForRef('attr:DateItem.useTextField','useTextField')} is \n set to false, such that the item displays multiple separate pickers, \n <code>useTextField</code> is automatically switched\n on when the item is rendering in a non-interactive way, such as when printing, or when \n ${isc.DocUtils.linkForRef('attr:FormItem.canEdit','canEdit')} is false and the read-only display-mode is \n ${isc.DocUtils.linkForRef('attr:FormItem.readOnlyDisplay','static')}.",
        flags:"IR",
        name:"autoUseTextField"
    },
    "classMethod:MathFunction.getRegisteredFunctionIndex":{
        groups:[
            "formulaFields"
        ],
        seeAlso:[
        ],
        ref:"classMethod:MathFunction.getRegisteredFunctionIndex",
        deprecated:null,
        type:"classMethod",
        definingClass:"class:MathFunction",
        description:" Returns an index of all registered functions by name\n \n",
        flags:"",
        returns:{
            type:"int",
            description:null
        },
        name:"getRegisteredFunctionIndex"
    },
    "method:Button.getState":{
        groups:[
            "state"
        ],
        seeAlso:[
        ],
        ref:"method:Button.getState",
        deprecated:null,
        type:"method",
        definingClass:"class:Button",
        description:" Return the state of this StatefulCanvas\n",
        flags:"",
        returns:{
            type:"State",
            description:null
        },
        name:"getState"
    },
    "method:ListGrid.setCanRemoveRecords":{
        seeAlso:[
        ],
        ref:"method:ListGrid.setCanRemoveRecords",
        deprecated:null,
        type:"method",
        definingClass:"class:ListGrid",
        params:[
            {
                defaultValue:null,
                optional:false,
                type:"boolean",
                description:"new canRemoveRecords value",
                name:"canRemove"
            }
        ],
        description:" Updates the ${isc.DocUtils.linkForRef('attr:ListGrid.canRemoveRecords')} property for this listGrid at runtime.\n",
        flags:"",
        name:"setCanRemoveRecords"
    },
    "attr:Img.imageWidth":{
        seeAlso:[
        ],
        defaultValue:"null",
        type:"attr",
        definingClass:"class:Img",
        groups:[
            "appearance"
        ],
        deprecated:null,
        ref:"attr:Img.imageWidth",
        valueType:"Integer",
        description:"Explicit size for the image, for ${isc.DocUtils.linkForRef('attr:Img.imageType')} settings that would normally use the\n image's natural size (applies to ${isc.DocUtils.linkForRef('attr:Img.imageType')} \"center\" and \"normal\" only).",
        flags:"IR",
        name:"imageWidth"
    },
    "attr:DetailViewer.fieldPickerFieldProperties":{
        seeAlso:[
        ],
        ref:"attr:DetailViewer.fieldPickerFieldProperties",
        defaultValue:"null",
        deprecated:null,
        type:"attr",
        definingClass:"class:DetailViewer",
        valueType:"Array of String",
        description:"Names of properties on ${isc.DocUtils.linkForRef('object:DetailViewerField')} for which the ${isc.DocUtils.linkForRef('class:FieldPicker')} should\n show an editing interface, for convenience.\n <P>\n For example, specify [\"decimalPad\", \"decimalPrecision\"] to allow end users to modify\n ${isc.DocUtils.linkForRef('attr:DetailViewerField.decimalPad')} and ${isc.DocUtils.linkForRef('attr:DetailViewerField.decimalPrecision')} respectively.",
        flags:"IR",
        name:"fieldPickerFieldProperties"
    },
    "attr:SelectItem.controlStyle":{
        seeAlso:[
            {
                ref:"attr:FormItem.cellStyle",
                description:null
            }
        ],
        defaultValue:"\"selectItemControl\", [IRA]",
        type:"attr",
        definingClass:"class:SelectItem",
        groups:[
            "appearance"
        ],
        deprecated:null,
        ref:"attr:SelectItem.controlStyle",
        valueType:"FormItemBaseStyle",
        description:"Base CSS class name for a form item's \"control box\". This is an HTML element\n which contains the text box and picker icon for the item.\n <P>\n See ${isc.DocUtils.linkForRef('attr:FormItem.alwaysShowControlBox')} for details on when the control box\n is written out.\n <P>\n See ${isc.DocUtils.linkForRef('group:formItemStyling')} for an overview of formItem styling, and \n the ${isc.DocUtils.linkForRef('group:CompoundFormItem_skinning')} discussion for special\n skinning considerations.",
        flags:"IRW",
        name:"controlStyle"
    },
    "attr:MultiSortPanel.otherSortLevelTitle":{
        seeAlso:[
        ],
        defaultValue:"\"Then by\"",
        type:"attr",
        definingClass:"class:MultiSortPanel",
        groups:[
            "i18nMessages"
        ],
        deprecated:null,
        ref:"attr:MultiSortPanel.otherSortLevelTitle",
        valueType:"String",
        description:"The title-text to appear in the first column for all sort-levels other than the first.",
        flags:"IR",
        name:"otherSortLevelTitle"
    },
    "attr:ListGrid.applyFormulaAfterSummary":{
        seeAlso:[
        ],
        ref:"attr:ListGrid.applyFormulaAfterSummary",
        defaultValue:"false",
        deprecated:null,
        type:"attr",
        definingClass:"class:ListGrid",
        valueType:"Boolean",
        description:"If ${isc.DocUtils.linkForRef('attr:ListGridField.userFormula')} is set for some field, and this grid is showing\n ${isc.DocUtils.linkForRef('attr:ListGrid.showGroupSummary','group summaries')} or a\n ${isc.DocUtils.linkForRef('attr:ListGrid.showGridSummary','grid summary')}, this property determines what field value\n should be present in those summary rows. Should the field apply the user-formula to the\n calculated summary row, or should it apply a standard grid or group summary to the\n user-formula values displayed in the grid?\n <P>\n May be overridden at the field level via ${isc.DocUtils.linkForRef('attr:ListGridField.applyAfterSummary')}",
        flags:"IRW",
        name:"applyFormulaAfterSummary"
    },
    "attr:RelativeDateItem.daysAgoTitle":{
        seeAlso:[
        ],
        defaultValue:"\"N days ago\"",
        type:"attr",
        definingClass:"class:RelativeDateItem",
        groups:[
            "i18nMessages"
        ],
        deprecated:null,
        ref:"attr:RelativeDateItem.daysAgoTitle",
        valueType:"String",
        description:"The title to show for historical periods when the ${isc.DocUtils.linkForRef('type:TimeUnit')} is \"day\".",
        flags:"IR",
        name:"daysAgoTitle"
    },
    "attr:SpinnerItem.maskSaveLiterals":{
        seeAlso:[
        ],
        ref:"attr:SpinnerItem.maskSaveLiterals",
        defaultValue:"null",
        deprecated:null,
        type:"attr",
        definingClass:"class:SpinnerItem",
        valueType:"boolean",
        description:"Not applicable to a SpinnerItem.",
        flags:"IRWA",
        name:"maskSaveLiterals"
    },
    "classAttr:DrawLabel.defaultCursiveFont":{
        seeAlso:[
        ],
        ref:"classAttr:DrawLabel.defaultCursiveFont",
        defaultValue:"\"Zapf-Chancery\"",
        deprecated:null,
        type:"classAttr",
        definingClass:"class:DrawLabel",
        valueType:"String",
        description:"This setting exists due to platform limitations in some versions of Internet Explorer\n where the browser does not recognize the five generic font families\n (<code>cursive</code>, <code>fantasy</code>, <code>monospace</code>,\n <code>sans-serif</code>, and <code>serif</code>) and instead uses a non-configurable,\n default font.  This setting specifies a specific font to replace the\n <code>cursive</code> keyword should a DrawLabel list it in its\n ${isc.DocUtils.linkForRef('attr:DrawLabel.fontFamily','font family')}.",
        flags:"IRW",
        name:"defaultCursiveFont"
    },
    "attr:FormItem.applyHeightToTextBox":{
        seeAlso:[
        ],
        ref:"attr:FormItem.applyHeightToTextBox",
        defaultValue:"null",
        deprecated:null,
        type:"attr",
        definingClass:"class:FormItem",
        valueType:"Boolean",
        description:"If ${isc.DocUtils.linkForRef('attr:FormItem.height')} is specified, should it be applied to the\n item's text box element?\n <P>\n If unset, behavior is determined as described in ${isc.DocUtils.linkForRef('method:FormItem.shouldApplyHeightToTextBox')}",
        flags:"IRA",
        name:"applyHeightToTextBox"
    },
    "class:CancelItem":{
        seeAlso:[
        ],
        type:"class",
        staticMethods:[
        ],
        inheritsFrom:"ButtonItem",
        classMethods:[
        ],
        classAttrs:[
        ],
        attrs:[
            "attr:CancelItem.title"
        ],
        ref:"class:CancelItem",
        deprecated:null,
        description:"Button that cancels any changes in the form, by calling ${isc.DocUtils.linkForRef('method:DynamicForm.cancelEditing')} \n when clicked.\n See ${isc.DocUtils.linkForRef('method:DynamicForm.cancelEditing')} for details on what happens when a form editing is \n cancelled.",
        methods:[
        ],
        name:"CancelItem"
    },
    "attr:RadialGradient.r":{
        seeAlso:[
        ],
        ref:"attr:RadialGradient.r",
        defaultValue:"null",
        deprecated:null,
        type:"attr",
        definingClass:"object:RadialGradient",
        valueType:"String",
        description:"radius",
        flags:"IR",
        name:"r"
    },
    "group:databinding":{
        refs:[
            "attr:CubeGrid.autoFetchData",
            "attr:CubeGrid.autoFetchTextMatchStyle",
            "attr:Calendar.dataSource",
            "attr:Calendar.autoFetchData",
            "attr:Calendar.autoFetchTextMatchStyle",
            "attr:Calendar.showDetailFields",
            "attr:Calendar.dataFetchMode",
            "attr:DataBoundComponent.dataSource",
            "attr:DataBoundComponent.dataFetchMode",
            "attr:DataBoundComponent.dataPageSize",
            "attr:DataBoundComponent.dataFetchDelay",
            "attr:DataBoundComponent.fields",
            "attr:DataBoundComponent.useAllDataSourceFields",
            "attr:DataBoundComponent.showHiddenFields",
            "attr:DataBoundComponent.showDetailFields",
            "attr:DataBoundComponent.showComplexFields",
            "attr:ListGrid.autoFetchData",
            "attr:DetailViewer.autoFetchData",
            "attr:DynamicForm.autoFetchData",
            "attr:DynamicForm.autoFetchTextMatchStyle",
            "attr:ResultSet.dataSource",
            "attr:ResultTree.dataSource",
            "attr:DynamicForm.dataFetchMode",
            "attr:DynamicForm.dataSource",
            "attr:FormItem.optionCriteria",
            "attr:FormItem.optionTextMatchStyle",
            "attr:FormItem.optionOperationId",
            "attr:FormItem.valueField",
            "attr:FormItem.displayField",
            "attr:PickListMenu.dataProperties",
            "attr:PickList.valueField",
            "attr:PickList.displayField",
            "attr:PickList.showOptionsFromDataSource",
            "attr:SelectItem.optionOperationId",
            "attr:SelectItem.displayField",
            "attr:SelectItem.valueField",
            "attr:SelectItem.showOptionsFromDataSource",
            "attr:ComboBoxItem.optionOperationId",
            "attr:ComboBoxItem.displayField",
            "attr:ComboBoxItem.valueField",
            "attr:ComboBoxItem.showOptionsFromDataSource",
            "attr:MultiComboBoxItem.optionOperationId",
            "attr:PickTreeItem.dataProperties",
            "attr:DetailViewer.dataFetchMode",
            "attr:DetailViewer.dataSource",
            "attr:DetailViewer.showDetailFields",
            "attr:ListGrid.fields",
            "attr:ListGrid.dataSource",
            "attr:ListGrid.saveLocally",
            "attr:ListGrid.useRemoteValidators",
            "attr:ListGrid.useAllDataSourceFields",
            "attr:ListGrid.showDetailFields",
            "attr:ListGrid.dataProperties",
            "attr:ListGrid.dataFetchMode",
            "attr:ListGrid.dataFetchDelay",
            "attr:TreeGrid.dataSource",
            "attr:TreeGrid.loadDataOnDemand",
            "attr:TreeGrid.treeRootValue",
            "attr:TreeGrid.fields",
            "attr:TreeGrid.dataProperties",
            "attr:TreeGrid.useAllDataSourceFields",
            "attr:Menu.initialCriteria",
            "attr:Menu.autoFetchData",
            "attr:Menu.dataProperties",
            "attr:TreeMenuButton.dataProperties",
            "attr:TileGrid.dataSource",
            "attr:TileGrid.autoFetchData",
            "attr:TileGrid.autoFetchTextMatchStyle",
            "attr:TileGrid.dataFetchMode",
            "attr:ColumnTree.dataSource",
            "attr:ColumnTree.dataProperties",
            "attr:ColumnTree.autoFetchData",
            "attr:ColumnTree.autoFetchTextMatchStyle",
            "attr:ColumnTree.showDetailFields",
            "attr:ColumnTree.dataFetchMode",
            "attr:ColumnTree.loadDataOnDemand",
            "attr:ColumnTree.fields"
        ],
        seeAlso:[
            {
                ref:"interface:DataBoundComponent",
                description:null
            }
        ],
        ref:"group:databinding",
        deprecated:null,
        type:"group",
        title:"DataBinding",
        description:"DataBinding means the automatic, highly customizable process of 'binding' a UI component\n to a DataSource, so that a UI component displays, edits and saves DataSource records\n using appropriate formatters, editors, validation rules, and persistence logic.",
        name:"databinding"
    },
    "attr:DateRangeItem.fromTitle":{
        seeAlso:[
        ],
        defaultValue:"\"From\"",
        type:"attr",
        definingClass:"class:DateRangeItem",
        groups:[
            "i18nMessages"
        ],
        deprecated:null,
        ref:"attr:DateRangeItem.fromTitle",
        valueType:"String",
        description:"The title for the ${isc.DocUtils.linkForRef('attr:DateRangeItem.fromField','from')} part of the range.",
        flags:"IR",
        name:"fromTitle"
    },
    "method:RadioGroupItem.setTextBoxStyle":{
        seeAlso:[
        ],
        ref:"method:RadioGroupItem.setTextBoxStyle",
        deprecated:null,
        type:"method",
        definingClass:"class:RadioGroupItem",
        params:[
            {
                defaultValue:null,
                optional:false,
                type:"FormItemBaseStyle",
                description:"new <code>textBoxStyle</code>.",
                name:"newTextBoxStyle"
            }
        ],
        description:" Setter for ${isc.DocUtils.linkForRef('attr:RadioGroupItem.textBoxStyle')}.\n",
        flags:"",
        name:"setTextBoxStyle"
    },
    "attr:Layout.managePercentBreadth":{
        seeAlso:[
        ],
        ref:"attr:Layout.managePercentBreadth",
        defaultValue:"true",
        deprecated:null,
        type:"attr",
        definingClass:"class:Layout",
        valueType:"Boolean",
        description:"If set, a Layout with breadthPolicy:\"fill\" will specially interpret a percentage breadth on\n a member as a percentage of available space excluding the ${isc.DocUtils.linkForRef('attr:Layout.layoutMargin')}.  If false,\n percentages work exactly as for a non-member, with layoutMargins, if any, ignored.",
        flags:"IR",
        name:"managePercentBreadth"
    },
    "attr:ComboBoxItem.completeOnEnter":{
        seeAlso:[
        ],
        ref:"attr:ComboBoxItem.completeOnEnter",
        defaultValue:"null",
        deprecated:null,
        type:"attr",
        definingClass:"class:ComboBoxItem",
        valueType:"Boolean",
        description:"If true, when the pickList is showing, the user can select the current value by hitting\n the <code>Enter</code> key.\n <P>\n If not explicitly set, completeOnEnter will default to false for items embedded\n in a ${isc.DocUtils.linkForRef('class:SearchForm','filtering interface')}, true otherwise.",
        flags:"IRW",
        name:"completeOnEnter"
    },
    "attr:DiscoverTreeSettings.scanMode":{
        seeAlso:[
        ],
        ref:"attr:DiscoverTreeSettings.scanMode",
        defaultValue:"ScanMode.BRANCH",
        deprecated:null,
        type:"attr",
        definingClass:"object:DiscoverTreeSettings",
        valueType:"ScanMode",
        description:"Determines how to scan for the ${isc.DocUtils.linkForRef('attr:Tree.childrenProperty')}",
        flags:"IRW",
        name:"scanMode"
    },
    "attr:MultiSortDialog.fields":{
        seeAlso:[
        ],
        ref:"attr:MultiSortDialog.fields",
        defaultValue:"null",
        deprecated:null,
        type:"attr",
        definingClass:"class:MultiSortDialog",
        valueType:"Array of DataSourceField",
        description:"The list of fields which the user can choose to sort by.",
        flags:"IR",
        name:"fields"
    },
    "attr:XORGateway.failureElement":{
        seeAlso:[
        ],
        ref:"attr:XORGateway.failureElement",
        defaultValue:"null",
        deprecated:null,
        type:"attr",
        definingClass:"class:XORGateway",
        valueType:"String",
        description:"ID of the next sequence or element to proceed to if the criteria do not match.",
        flags:"IR",
        name:"failureElement"
    },
    "attr:StretchItem.height":{
        seeAlso:[
        ],
        ref:"attr:StretchItem.height",
        defaultValue:"null",
        deprecated:null,
        type:"attr",
        definingClass:"object:StretchItem",
        valueType:"number | String",
        description:"The height of the image. This can either be a number (for the number of pixels tall), the string\n \"*\" (remaining space, divided amongst all items that specify height:\"*\"), or the name of a property\n on the StretchImg component, such as \"capSize\" for the StretchImg's ${isc.DocUtils.linkForRef('attr:StretchImg.capSize','capSize')}.\n <p>\n <b>NOTE:</b> The height is only used if the StretchImg stacks its images vertically\n (${isc.DocUtils.linkForRef('attr:StretchImg.vertical')} is true).",
        flags:"IR",
        name:"height"
    },
    "attr:FacetChart.logScalePointColor":{
        seeAlso:[
            {
                ref:"attr:FacetChart.pointColorLogBase",
                description:null
            }
        ],
        defaultValue:"false",
        type:"attr",
        definingClass:"class:FacetChart",
        deprecated:null,
        ref:"attr:FacetChart.logScalePointColor",
        valueType:"boolean",
        description:"Whether to use logarithmic scaling for the ${isc.DocUtils.linkForRef('attr:FacetChart.colorScaleMetric','color scale')} of the\n data points.  Defaults to the value of ${isc.DocUtils.linkForRef('attr:FacetChart.logScale')}.",
        flags:"IR",
        examples:[
            "${isc.DocUtils.linkForExampleId('colorScaleChart')}"
        ],
        name:"logScalePointColor"
    },
    "method:Canvas.pageScrollUp":{
        seeAlso:[
        ],
        ref:"method:Canvas.pageScrollUp",
        deprecated:null,
        type:"method",
        definingClass:"class:Canvas",
        description:" This method is the programmatic equivalent of the user pressing the \"Page Up\" key while \n this widget has the focus.  It scrolls the widget's content upwards by the viewport \n height, if the content can be scrolled that far upwards\n",
        flags:"",
        name:"pageScrollUp"
    },
    "attr:EventCanvas.showHeader":{
        seeAlso:[
        ],
        ref:"attr:EventCanvas.showHeader",
        defaultValue:"null",
        deprecated:null,
        type:"attr",
        definingClass:"class:EventCanvas",
        valueType:"Boolean",
        description:"Renders a header DIV above the main body of the event, an area of limited\n height, styled to stand out from the main ${isc.DocUtils.linkForRef('attr:EventCanvas.showBody','body')} of the \n event, and typically showing a ${isc.DocUtils.linkForRef('attr:CalendarEvent.name','name')} or title - like a Window.\n This header area can be styled via ${isc.DocUtils.linkForRef('attr:EventCanvas.headerStyle')} and the HTML it shows \n is retrieved from a call to ${isc.DocUtils.linkForRef('method:EventCanvas.getHeaderHTML','getHeaderHTML()')}.  \n The default is taken from ${isc.DocUtils.linkForRef('attr:Calendar.showEventHeaders')}.",
        flags:"IRW",
        name:"showHeader"
    },
    "attr:DynamicForm.revertValueKey":{
        seeAlso:[
        ],
        defaultValue:"null",
        type:"attr",
        definingClass:"class:DynamicForm",
        deprecated:null,
        ref:"attr:DynamicForm.revertValueKey",
        valueType:"KeyIdentifier",
        description:"Keyboard shortcut that causes the value of the currently focused form item to be reverted\n to whatever value would be shown if ${isc.DocUtils.linkForRef('method:DynamicForm.resetValues')} were called.",
        flags:"IR",
        examples:[
            "${isc.DocUtils.linkForExampleId('pendingValues')}"
        ],
        name:"revertValueKey"
    },
    "attr:DataSourceField.includeFrom":{
        seeAlso:[
        ],
        defaultValue:"null",
        type:"attr",
        definingClass:"object:DataSourceField",
        groups:[
            "dataSourceRelations"
        ],
        ref:"attr:DataSourceField.includeFrom",
        deprecated:null,
        valueType:"String",
        description:"Indicates that this field should be fetched from another, related DataSource.\n <P>\n The <code>incluedFrom</code> attribute should be of the form\n \"<i>dataSourceId</i>.<i>fieldName</i>\", for example:\n <pre>\n    &lt;field includeFrom=\"supplyItem.itemName\"/&gt;\n </pre>\n <P>\n A ${isc.DocUtils.linkForRef('attr:DataSourceField.foreignKey')} declaration must exist between the two DataSources, establishing either\n a 1-to-1 relationship or a many-to-1 relationship from this DataSource to the related\n DataSource. The inclusion can be indirect (traverse multiple DataSources) so long as there\n is a chain of <code>foreignKey</code> declarations from the target DataSource to the\n DataSource where the <code>includeFrom</code> field is declared.  You may use dot-notation\n to provide an explicit path between DataSources, or provide the name of only the last\n DataSource in the chain to have the complete path calculated for you at runtime.\n i.e., either of the following are acceptable forms, where foreign keys\n are defined to link records in the current DataSource to Employee records and in turn to\n Office records:\n <pre>\n   &lt;field includeFrom=\"Employee.Office.territory\"/&gt;\n   &lt;!-- OR --&gt;\n   &lt;field includeFrom=\"Office.territory\"/&gt;\n </pre>\n Note that when using the shorthand form, there is potential ambiguity: there could be \n multiple ways in which two DataSources are related via different intervening DataSources, \n so the auto-discovered relation may be different depending on which other DataSources are \n loaded in the page. For this reason, explicitly spelling out the inclusion path is \n preferred.\n <p>\n For including from a\n related DataSource where there are multiple related records, see\n ${isc.DocUtils.linkForRef('attr:DataSourceField.includeSummaryFunction','includeSummaryFunction')}.\n <p>\n In all cases, ${isc.DocUtils.linkForRef('attr:DataSourceField.name')} will default to the name of the included field,\n or you can specify a different name.\n <p>\n If both DataSources are SQLDataSources, HibernateDataSources or JPADataSources (with\n Hibernate as the provider) the related data will be retrieved via a SQL join and criteria\n and sort directions applied to the field work normally (they become part of the generated\n SQL query).\n <p>\n Related data will be retrieved via performing a DSRequest against\n the related DataSource once the data from the primary DataSource has been retrieved.  In\n this case, criteria or sorting directions applied to the included field are only allowed if\n data paging is not in use (for example ${isc.DocUtils.linkForRef('attr:ListGrid.dataFetchMode')}:\"basic\"); otherwise,\n criteria and sort direction are ignored for the included field and a warning is logged on\n the server.\n <P>\n <b>Editing included fields</b>\n <p>\n An included field is ${isc.DocUtils.linkForRef('attr:DataSourceField.canEdit','canEdit:false')} by default.  Note that \n included fields are not updatable, even if you set canEdit:true; the server will simply drop\n values for included fields if client code sends them. \n <p>\n When thinking about editing an included field value, typically what is really intended is to\n edit the value of the <code>foreignKey</code> field.  For example, take the scenario of a\n system that tracks accounts and the employees assigned to manage them.  Given a DataSource\n \"account\" related one-to-one with DataSource \"employee\" by a \"managerId\" foreignKey field,\n we might declare an <code>includeFrom</code> so that the name of the account manager can\n be shown with each \"account\" record.  \n <p>\n Editing the manager's name while viewing the account would be intended to pick a new account\n manager, and <b>not</b> to change the legal name of the employee who happens to be the\n current account manager. \n <p>\n To correctly set up this scenario, declare an <code>includeFrom</code> field that is hidden,\n but is used as the ${isc.DocUtils.linkForRef('attr:DataSourceField.displayField','displayField')} for the foreign key\n field:\n <pre>\n &lt;field name=\"managerId\" foreignKey=\"employee.id\" displayField=\"managerName\" /&gt; \n &lt;field name=\"managerName\" includeFrom=\"employee.name\" hidden=\"true\"/&gt; \n </pre>\n Now:\n <ul>\n <li> the \"managerId\" foreignKey field is shown in grids and forms, but takes its displayed\n value from the hidden <code>includeFrom</code> field. Note that when the\n <code>foreignKey</code> and <code>displayField</code> are specified, the \n framework automatically defaults ${isc.DocUtils.linkForRef('attr:DataSourceField.useLocalDisplayFieldValue')} to \n true to ensure the displayed value is picked up from the record being edited.\n <li> the automatically chosen editor will be a SelectItem with\n ${isc.DocUtils.linkForRef('attr:SelectItem.optionDataSource','optionDataSource')} set to \"employees\": it will allow\n picking a different \"employee\" record from the \"employee\" DataSource.\n <li> saving will save the ID of a new \"employee\" record to the \"managerId\" foreign key\n field, as intended\n </ul>\n\n You can alternatively set <code>editorType=\"ComboBoxItem\"</code> on the\n \"managerId\" field to allow typeahead search of the \"employee\" DataSource.\n <P>\n Note that the ${isc.DocUtils.linkForRef('attr:DataSourceField.foreignDisplayField')} attribute allows developers to have a different\n fieldName be used locally as a displayField from the field name for the display field\n in the foreign dataSource.\n <P>\n <b>Including fields that use summary functions</b>\n <p>\n The ${isc.DocUtils.linkForRef('attr:DataSourceField.includeSummaryFunction','Include Summary Function')} feature is used\n for including from a related DataSource where there are multiple related records. It applies\n a ${isc.DocUtils.linkForRef('type:SummaryFunction')} to the related records aggregating them into single value.\n It is regularly used on directly included fields, but it supports indirect inclusions as well,\n when entire <code>includeFrom</code>+<code>includeSummaryFunction</code> setup is included from\n another DataSource. See ${isc.DocUtils.linkForRef('attr:DataSourceField.includeSummaryFunction')} docs for more details.",
        flags:"IR",
        serverDS:"only",
        examples:[
            "${isc.DocUtils.linkForExampleId('sqlIncludeFrom')}"
        ],
        name:"includeFrom"
    },
    "attr:StatefulCanvas.icon":{
        seeAlso:[
        ],
        defaultValue:"null",
        type:"attr",
        definingClass:"class:StatefulCanvas",
        groups:[
            "buttonIcon"
        ],
        ref:"attr:StatefulCanvas.icon",
        deprecated:null,
        setter:[
            "setIcon"
        ],
        valueType:"SCImgURL",
        description:"Optional icon to be shown with the button title text.  \n <P>\n Specify as the partial URL to an image, relative to the imgDir of this component.\n A sprited image can be specified using the ${isc.DocUtils.linkForRef('type:SCSpriteConfig')} format.\n <P>\n Note that the string \"blank\" is a valid setting for this attribute and will always \n result in the system blank image, with no state suffixes applied.  Typically, this \n might be used when an iconStyle is also specified and the iconStyle renders the icon via \n a stateful background-image or other CSS approach.",
        flags:"IRW",
        name:"icon"
    },
    "attr:EditProxy.inlineEditInstructions":{
        seeAlso:[
        ],
        ref:"attr:EditProxy.inlineEditInstructions",
        defaultValue:"null",
        deprecated:null,
        type:"attr",
        definingClass:"class:EditProxy",
        valueType:"HTMLString",
        description:"Instructions that appear below the text entry area if inline editing is enabled.  See\n ${isc.DocUtils.linkForRef('attr:EditProxy.inlineEditEvent')} and ${isc.DocUtils.linkForRef('attr:EditProxy.inlineEditInstructionLabel')}.",
        flags:"IR",
        name:"inlineEditInstructions"
    },
    "method:RangeSlider.changed":{
        seeAlso:[
        ],
        ref:"method:RangeSlider.changed",
        deprecated:null,
        type:"method",
        definingClass:"class:RangeSlider",
        params:[
            {
                defaultValue:null,
                optional:false,
                type:"float",
                description:"new start value",
                name:"startValue"
            },
            {
                defaultValue:null,
                optional:false,
                type:"float",
                description:"new end value",
                name:"endValue"
            },
            {
                defaultValue:null,
                optional:false,
                type:"boolean",
                description:"whether the user is still in the middle of a drag, so that  expensive operations can be avoided if needed",
                name:"isDragging"
            }
        ],
        description:" Notification fired when the selected range is changed by the end user.\n\n",
        flags:"",
        name:"changed"
    },
    "method:ResultSet.invalidateCache":{
        seeAlso:[
        ],
        ref:"method:ResultSet.invalidateCache",
        deprecated:null,
        type:"method",
        definingClass:"class:ResultSet",
        description:" Manually invalidate this ResultSet's cache.\n <P>\n Generally a ResultSet will observe and incorporate updates to the DataSource that provides its\n records, but when this is not possible, <code>invalidateCache()</code> allows manual cache\n invalidation.\n <P>\n <code>invalidateCache()</code> fires <code>dataChanged()</code>, which may cause components \n using this ResultSet to request new data for display, triggering server fetches.\n",
        flags:"A",
        name:"invalidateCache"
    },
    "group:title":{
        refs:[
            "classMethod:DataSource.getAutoTitle",
            "method:DataSource.getAutoTitle",
            "attr:FormItem.showTitle",
            "attr:FormItem.titleOrientation",
            "attr:FormItem.titleAlign",
            "attr:FormItem.titleVAlign",
            "attr:FormItem.clipTitle",
            "attr:FormItem.wrapTitle",
            "attr:FormItem.vAlign",
            "attr:FormItem.titleClassName",
            "attr:FormItem.titleErrorClassName"
        ],
        seeAlso:[
        ],
        ref:"group:title",
        deprecated:null,
        type:"group",
        description:null,
        name:"title"
    },
    "method:DynamicForm.valuesAreValid":{
        seeAlso:[
        ],
        type:"method",
        definingClass:"class:DynamicForm",
        returns:{
            type:"boolean | Map",
            description:"Boolean value indicating validation success, or if  <code>returnErrors</code> was specified, an object mapping\n  field names to the associated errors, for those fields that\n failed validation, or null if validation succeeded."
        },
        groups:[
            "validation"
        ],
        deprecated:null,
        ref:"method:DynamicForm.valuesAreValid",
        params:[
            {
                defaultValue:null,
                optional:false,
                type:"boolean",
                description:"Should validators be processed for non-visible fields         such as dataSource fields with no associated item or fields with visibility set to\n         <code>\"hidden\"</code>?",
                name:"validateHiddenFields"
            },
            {
                defaultValue:null,
                optional:true,
                type:"boolean",
                description:"If unset, this method returns a simple boolean value indicating success or failure of validation. If this parameter is passed, this method will return\n an object mapping each field name to the errors(s) encountered on validation failure, or null\n if validation was successful.",
                name:"returnErrors"
            }
        ],
        description:" Method to determine whether the current form values would pass validation.\n This method operates client-side, without contacting the server, running validators on the\n form's values and returning a value indicating whether validation was successful.  \n <P>\n Unlike ${isc.DocUtils.linkForRef('method:DynamicForm.validate')} this method will not store the errors on the DynamicForm\n or display them to the user.\n <P>\n Note that ${isc.DocUtils.linkForRef('method:DynamicForm.checkForValidationErrors')} allows for checking for server-side errors, and\n finding out what those errors are via a callback.\n\n",
        flags:"",
        name:"valuesAreValid"
    },
    "attr:Tree.titleProperty":{
        seeAlso:[
        ],
        ref:"attr:Tree.titleProperty",
        defaultValue:"\"title\"",
        deprecated:null,
        type:"attr",
        definingClass:"class:Tree",
        valueType:"String",
        description:"Name of the property on a ${isc.DocUtils.linkForRef('object:TreeNode')} that holds the title of the node as it should be\n shown to the user.  Default value is \"title\".  See ${isc.DocUtils.linkForRef('attr:TreeNode.title')} for usage.",
        flags:"IRW",
        name:"titleProperty"
    },
    "attr:Window.headerControls":{
        seeAlso:[
        ],
        defaultValue:"(see below)",
        type:"attr",
        definingClass:"class:Window",
        groups:[
            "windowHeader"
        ],
        ref:"attr:Window.headerControls",
        deprecated:null,
        valueType:"Array of String",
        description:"Array of members to show in the Window header.  \n <P>\n The default value of <code>headerControls</code> is an Array of Strings listing the\n standard header controls in their default order:\n <pre>\n    headerControls : [\"headerIcon\", \"headerLabel\", \n                      \"minimizeButton\", \"maximizeButton\", \"closeButton\"]\n </pre>\n You can override <code>headerControls</code> to change the order of standard controls in\n the header.  You can also omit standard controls this way, although it more efficient to\n use the related \"show\" property if available (eg ${isc.DocUtils.linkForRef('attr:Window.showMinimizeButton')}).  \n <P>\n By embedding a Canvas directly in this list you can add arbitrary additional controls to\n the header, for example, an additional button (eg return to dock) or a DynamicForm with\n various kinds of input controls.  \n <P>\n Note that having added controls to headerControls, you can still call APIs directly on\n those controls to change their appearance, and you can also show() and hide() them if\n they should not be shown in some circumstances.\n <P>\n Tip: custom controls need to set layoutAlign:\"center\" to appear vertically centered.\n <P>\n <B>Component XML:</B>\n <P>\n To define <code>headerControls</code> in Component XML a special set of components\n are used as markers. The standard header controls can be explicitly specified as: \n <pre>\n  &lt;headerControls&gt;\n      &lt;WindowHeaderIcon/&gt;\n      &lt;WindowHeaderLabel/&gt;\n      &lt;WindowMinimizeButton/&gt;\n      &lt;WindowMaximizeButton/&gt;\n      &lt;WindowCloseButton/&gt;\n  &lt;/headerControls&gt;\n </pre>",
        flags:"IR",
        examples:[
            "${isc.DocUtils.linkForExampleId('windowHeaderControls')}"
        ],
        name:"headerControls"
    },
    "attr:DataSource.serverConstructor":{
        seeAlso:[
        ],
        defaultValue:"null",
        type:"attr",
        definingClass:"class:DataSource",
        deprecated:null,
        ref:"attr:DataSource.serverConstructor",
        valueType:"String",
        description:"This property allows you to write and use custom DataSource subclasses on the server, by \n specifying either <ul>\n <li>the fully-qualified name of the DataSource subclass that should be instantiated\n server-side for this dataSource, or</li>\n <li>the token \"spring:\" followed by a valid Spring bean ID, if you wish to instantiate \n your custom dataSource object using Spring dependency injection.  For example, \n <code>\"spring:MyDataSourceBean\"</code>.  See also ${isc.DocUtils.linkForRef('group:serverInit')} for special\n concerns with framework initialization when using Spring.  It is also particularly important\n that you read the discussion of caching and thread-safety linked to below, as there are \n special considerations in this area when using Spring.</li>\n <li>the token \"cdi:\" followed by a valid CDI bean name, if you wish to instantiate \n your custom dataSource object using CDI dependency injection.  For example, \n <code>\"cdi:MyDataSourceBean\"</code>.</li>\n </ul>\n <p>\n One reason you might wish to do this would be to override the validate() method to provide \n some arbitrary custom validation (such as complex database lookups, validation embedded in \n legacy applications, etc).  It is also possible - though obviously a more substantial task -\n to override the execute() method in your custom DataSource.  This is one way of creating \n a completely customized DataSource implementation.\n <p>\n <b>Note:</b> If you use this property, you are responsible for making sure that it refers to\n a valid server-side class that extends <code>com.isomorphic.datasource.BasicDataSource</code>,\n or to a Spring bean of the same description.\n If your implementation relies on methods or state only present in certain specialized \n subclasses of DataSource (for example, you want the normal behavior and features of a \n HibernateDataSource, but with a specialized validate() method), then you should extend the \n subclass rather than the base class.\n <P>\n NOTE: Please take note of the points made in \n ${isc.DocUtils.linkForRef('group:serverDataSourceImplementation','this discussion')} of caching and thread-safety\n issues in server-side DataSources.",
        flags:"IR",
        serverDS:"only",
        name:"serverConstructor"
    },
    "attr:ListGrid.dataProperties":{
        seeAlso:[
        ],
        defaultValue:"null",
        type:"attr",
        definingClass:"class:ListGrid",
        groups:[
            "databinding"
        ],
        deprecated:null,
        ref:"attr:ListGrid.dataProperties",
        valueType:"ResultSet",
        description:"For databound ListGrids, this attribute can be used to customize the ${isc.DocUtils.linkForRef('class:ResultSet')}\n object created for this grid when data is fetched",
        flags:"IRWA",
        name:"dataProperties"
    },
    "classAttr:Dialog.ASK_TITLE":{
        seeAlso:[
        ],
        defaultValue:"\"Question\"",
        type:"classAttr",
        definingClass:"class:Dialog",
        groups:[
            "i18nMessages"
        ],
        deprecated:null,
        ref:"classAttr:Dialog.ASK_TITLE",
        valueType:"HTMLString",
        description:"Default title for the dialog displayed in response to the ${isc.DocUtils.linkForRef('staticMethod:isc.ask')} method.\n Note that a custom title can be specified as the <code>title</code> attribute of the\n <code>properties</code> parameter passed to that method.",
        flags:"IRW",
        name:"ASK_TITLE"
    },
    "attr:GridRenderer.cellPadding":{
        seeAlso:[
        ],
        defaultValue:"2",
        type:"attr",
        definingClass:"class:GridRenderer",
        groups:[
            "cellStyling"
        ],
        deprecated:null,
        ref:"attr:GridRenderer.cellPadding",
        valueType:"number",
        description:"The amount of empty space, in pixels, surrounding each value in its cell.",
        flags:"IRW",
        name:"cellPadding"
    },
    "attr:FacetChart.colorMutePercent":{
        seeAlso:[
        ],
        ref:"attr:FacetChart.colorMutePercent",
        defaultValue:"null",
        deprecated:null,
        type:"attr",
        definingClass:"class:FacetChart",
        valueType:"float",
        description:"Should be set to a number between -100 and 100.  If set, all colors in the chart are \"muted\" by\n this percentage by shifting them toward white (or for negative numbers, toward black).",
        flags:"IR",
        name:"colorMutePercent"
    },
    "attr:Canvas.leavePageSpace":{
        seeAlso:[
        ],
        defaultValue:"null",
        type:"attr",
        definingClass:"class:Canvas",
        groups:[
            "positioning"
        ],
        ref:"attr:Canvas.leavePageSpace",
        deprecated:null,
        setter:[
            "setLeavePageSpace"
        ],
        valueType:"Integer",
        description:"If set, overrides the global ${isc.DocUtils.linkForRef('classAttr:Canvas.defaultPageSpace')}.",
        flags:"IRWA",
        name:"leavePageSpace"
    },
    "type:FieldName":{
        seeAlso:[
        ],
        ref:"type:FieldName",
        deprecated:null,
        type:"type",
        description:"Name for a field.\n <P>\n Must be unique across all fields within its container as well as a valid JavaScript\n identifier, as specified by ECMA-262 Section 7.6.\n <P>\n <B>NOTE:</B> The ${isc.DocUtils.linkForRef('staticMethod:String.isValidID')}\n \n function can be used to test whether a name is a valid JavaScript identifier.",
        serverDS:"allowed",
        name:"FieldName",
        baseType:"String"
    },
    "attr:ListGridField.maxWidth":{
        seeAlso:[
            {
                ref:"attr:ListGridField.width",
                description:null
            }
        ],
        defaultValue:"null",
        type:"attr",
        definingClass:"object:ListGridField",
        groups:[
            "appearance"
        ],
        deprecated:null,
        ref:"attr:ListGridField.maxWidth",
        valueType:"Number",
        description:"When ${isc.DocUtils.linkForRef('attr:ListGrid.showHeader')} is false and a field is subject to autofitting (see\n ${isc.DocUtils.linkForRef('attr:ListGrid.autoFitFieldWidths')}), sets the maximum width of the field.  The actual\n effective maximum will be the largest of this property, ${isc.DocUtils.linkForRef('attr:ListGridField.minWidth')}, and \n ${isc.DocUtils.linkForRef('attr:ListGrid.minFieldWidth')}.  That is, ${isc.DocUtils.linkForRef('attr:ListGridField.minWidth')} and \n ${isc.DocUtils.linkForRef('attr:ListGrid.minFieldWidth')} dominate this property.",
        flags:"IRW",
        name:"maxWidth"
    },
    "attr:DateRangeDialog.rangeItem":{
        seeAlso:[
        ],
        ref:"attr:DateRangeDialog.rangeItem",
        defaultValue:"null",
        deprecated:null,
        type:"attr",
        definingClass:"class:DateRangeDialog",
        valueType:"AutoChild DateRangeItem",
        description:null,
        flags:"IR",
        name:"rangeItem"
    },
    "method:ValuesManager.getValuesAsAdvancedCriteria":{
        seeAlso:[
        ],
        type:"method",
        definingClass:"class:ValuesManager",
        returns:{
            type:"AdvancedCriteria",
            description:"a ${isc.DocUtils.linkForRef('object:AdvancedCriteria')} based on the form's current values"
        },
        groups:[
            "criteriaEditing"
        ],
        deprecated:null,
        ref:"method:ValuesManager.getValuesAsAdvancedCriteria",
        params:[
            {
                defaultValue:null,
                optional:true,
                type:"TextMatchStyle",
                description:"If specified the text match style will be used to   generate the appropriate <code>operator</code> for per field criteria.",
                name:"textMatchStyle"
            }
        ],
        description:" Return an AdvancedCriteria object based on the current set of values within memberForms.\n <p>\n Similar to ${isc.DocUtils.linkForRef('method:ValuesManager.getValuesAsCriteria')}, except the returned criteria object\n is guaranteed to be an AdvancedCriteria object, even if none of the form's fields has a\n specified ${isc.DocUtils.linkForRef('attr:FormItem.operator')}\n\n",
        flags:"",
        name:"getValuesAsAdvancedCriteria"
    },
    "attr:DetailViewer.showDetailFields":{
        seeAlso:[
        ],
        defaultValue:"true",
        type:"attr",
        definingClass:"class:DetailViewer",
        groups:[
            "databinding"
        ],
        deprecated:null,
        ref:"attr:DetailViewer.showDetailFields",
        valueType:"Boolean",
        description:"Whether to show fields marked <code>detail:true</code> when a DataBoundComponent is \n given a DataSource but no <code>component.fields</code>.\n <p>\n The <code>detail</code> property is used on DataSource fields to mark fields that \n shouldn't appear by default in a view that tries to show many records in a small space.",
        flags:"IR",
        name:"showDetailFields"
    },
    "method:TreeGrid.getDropFolder":{
        groups:[
            "events"
        ],
        seeAlso:[
        ],
        ref:"method:TreeGrid.getDropFolder",
        deprecated:null,
        type:"method",
        definingClass:"class:TreeGrid",
        description:" When the user is dragging a droppable element over this grid, this method returns the folder\n which would contain the item if dropped. This is the current drop node if the user is hovering\n over a folder, or the node's parent if the user is hovering over a leaf.\n",
        flags:"",
        returns:{
            type:"TreeNode | NodeLocator",
            description:"If this is a regular treeGrid, the target drop folder; if this                               is a treeGrid based on a ${isc.DocUtils.linkForRef('attr:Tree.multiLinkTree','multiLink tree')},\n                               a NodeLocator unambiguously identifying the specific occurence\n                               of the drop folder in the tree"
        },
        name:"getDropFolder"
    },
    "method:TimeItem.setSelectionRange":{
        seeAlso:[
        ],
        ref:"method:TimeItem.setSelectionRange",
        deprecated:null,
        type:"method",
        definingClass:"class:TimeItem",
        params:[
            {
                defaultValue:null,
                optional:false,
                type:"int",
                description:"character index for start of new selection",
                name:"start"
            },
            {
                defaultValue:null,
                optional:false,
                type:"int",
                description:"character index for end of new selection",
                name:"end"
            }
        ],
        description:" If ${isc.DocUtils.linkForRef('attr:TimeItem.useTextField')} is true, falls through to standard\n ${isc.DocUtils.linkForRef('method:TextItem.setSelectionRange','setSelectionRange')} implementation on this items freeform text entry field.\n Otherwise has no effect.\n",
        flags:"",
        name:"setSelectionRange"
    },
    "classAttr:FacetChart.invalidPolynomialDegreeMessage":{
        seeAlso:[
        ],
        defaultValue:"\"The regression polynomial degree must be a positive integer.\"",
        type:"classAttr",
        definingClass:"class:FacetChart",
        groups:[
            "i18nMessages"
        ],
        deprecated:null,
        ref:"classAttr:FacetChart.invalidPolynomialDegreeMessage",
        valueType:"String",
        description:"Warning message issued when an invalid polynomial degree is entered into the prompt dialog created\n by the <code>\"Polynomial Degree...\"</code> option in the context menu for scatter plots.",
        flags:"IRW",
        name:"invalidPolynomialDegreeMessage"
    },
    "attr:Layout.members":{
        seeAlso:[
        ],
        defaultValue:"null",
        type:"attr",
        definingClass:"class:Layout",
        getter:[
            "getMembers"
        ],
        ref:"attr:Layout.members",
        deprecated:null,
        setter:[
            "setMembers"
        ],
        valueType:"Array of Canvas",
        description:"An array of canvases that will be contained within this layout. You can set the\n following properties on these canvases (in addition to the standard component\n properties):\n <ul>\n  <li>${isc.DocUtils.linkForRef('attr:Canvas.layoutAlign','layoutAlign')} -- specifies the member's alignment along the\n      breadth axis; valid values are \"top\", \"center\" and \"bottom\" for a horizontal layout\n      and \"left\", \"center\" and \"right\" for a vertical layout (see\n      ${isc.DocUtils.linkForRef('attr:Layout.defaultLayoutAlign')} for default implementation.)\n  <li>${isc.DocUtils.linkForRef('attr:Canvas.showResizeBar','showResizeBar')} -- set to true to show a resize bar\n      (default is false)\n </ul>\n Height and width settings found on members are interpreted by the Layout according to\n the ${isc.DocUtils.linkForRef('attr:Layout.vPolicy','layout policy')}.\n <p>\n Note that it is valid to have null slots in the provided <code>members</code> Array,\n and the Layout will ignore those slots. This can be useful to keep code compact, for\n example, when constructing the <code>members</code> Array, you might use an expression\n that either returns a component or null depending on whether the component should be\n present. If the expression returns null, the null slot will be ignored by the Layout.",
        flags:"IRW",
        name:"members"
    },
    "attr:DataSource.dataFormat":{
        seeAlso:[
        ],
        defaultValue:"\"iscServer\"",
        type:"attr",
        definingClass:"class:DataSource",
        groups:[
            "clientDataIntegration",
            "serverDataIntegration"
        ],
        ref:"attr:DataSource.dataFormat",
        deprecated:null,
        valueType:"DSDataFormat",
        description:"Indicates the format to be used for HTTP requests and responses when\n fulfilling DSRequests (eg, when ${isc.DocUtils.linkForRef('method:DataSource.fetchData')} is called).",
        flags:"IR",
        serverDS:"allowed",
        examples:[
            "${isc.DocUtils.linkForExampleId('jsonDataSource')}",
            "${isc.DocUtils.linkForExampleId('simpleJSON')}"
        ],
        name:"dataFormat"
    },
    "attr:EditNode.canDuplicate":{
        seeAlso:[
        ],
        ref:"attr:EditNode.canDuplicate",
        defaultValue:"null",
        deprecated:null,
        type:"attr",
        definingClass:"object:EditNode",
        valueType:"Boolean",
        description:"See ${isc.DocUtils.linkForRef('attr:PaletteNode.canDuplicate')}.",
        flags:"IRW",
        name:"canDuplicate"
    },
    "attr:PortalLayout.numColumns":{
        seeAlso:[
            {
                ref:"attr:PortalLayout.portlets",
                description:null
            }
        ],
        defaultValue:"2",
        type:"attr",
        definingClass:"class:PortalLayout",
        getter:[
            "getNumColumns"
        ],
        deprecated:null,
        ref:"attr:PortalLayout.numColumns",
        valueType:"int",
        description:"Initial number of columns to show in this PortalLayout. Note that after initialization\n columns should be added / removed via ${isc.DocUtils.linkForRef('method:PortalLayout.addColumn')} and ${isc.DocUtils.linkForRef('method:PortalLayout.removeColumn')}.\n numColumns is ignored if you initialize the ${isc.DocUtils.linkForRef('attr:PortalLayout.portlets')} attribute, since the portlets\n attribute will imply how many columns to create.",
        flags:"IR",
        name:"numColumns"
    },
    "method:DrawGroup.scaleBy":{
        seeAlso:[
        ],
        ref:"method:DrawGroup.scaleBy",
        deprecated:null,
        type:"method",
        definingClass:"class:DrawGroup",
        params:[
            {
                defaultValue:null,
                optional:false,
                type:"float",
                description:"scale in the x direction",
                name:"x"
            },
            {
                defaultValue:null,
                optional:false,
                type:"float",
                description:"scale in the y direction",
                name:"y"
            }
        ],
        description:" Scale all drawItem[] shapes by the x, y multipliers\n",
        flags:"",
        name:"scaleBy"
    },
    "attr:TextItem.height":{
        seeAlso:[
        ],
        defaultValue:"19",
        type:"attr",
        definingClass:"class:TextItem",
        groups:[
            "appearance"
        ],
        deprecated:null,
        ref:"attr:TextItem.height",
        valueType:"number",
        description:"Default height for text items.",
        flags:"IRW",
        name:"height"
    },
    "method:Gauge.setDrawnClockwise":{
        seeAlso:[
        ],
        ref:"method:Gauge.setDrawnClockwise",
        deprecated:null,
        type:"method",
        definingClass:"class:Gauge",
        params:[
            {
                defaultValue:null,
                optional:false,
                type:"boolean",
                description:"whether the sectors are drawn clockwise.",
                name:"drawnClockwise"
            }
        ],
        description:" Sets the ${isc.DocUtils.linkForRef('attr:Gauge.drawnClockwise','drawnClockwise')} property and redraws the gauge.\n\n",
        flags:"",
        name:"setDrawnClockwise"
    },
    "class:ResetItem":{
        seeAlso:[
        ],
        type:"class",
        staticMethods:[
        ],
        inheritsFrom:"ButtonItem",
        classMethods:[
        ],
        classAttrs:[
        ],
        attrs:[
        ],
        ref:"class:ResetItem",
        deprecated:null,
        description:"Button that resets the form to default values, by calling\n <code>DynamicForm.resetValues()</code>\n \n If you define a click handler on this item, you can return false to cancel the reset.",
        methods:[
        ],
        name:"ResetItem"
    },
    "attr:ImgSplitbar.src":{
        seeAlso:[
        ],
        defaultValue:"null",
        type:"attr",
        definingClass:"class:ImgSplitbar",
        groups:[
            "appearance"
        ],
        deprecated:null,
        ref:"attr:ImgSplitbar.src",
        valueType:"String",
        description:"The base filename or stateful image configuration for the image. \n Note that as the ${isc.DocUtils.linkForRef('attr:StatefulCanvas.state','state')} \n of the component changes, the image displayed will be updated as described in\n ${isc.DocUtils.linkForRef('group:statefulImages')}.",
        flags:"IR",
        name:"src"
    },
    "attr:ListGrid.canMultiGroup":{
        seeAlso:[
        ],
        defaultValue:"false",
        type:"attr",
        definingClass:"class:ListGrid",
        deprecated:null,
        ref:"attr:ListGrid.canMultiGroup",
        valueType:"boolean",
        description:"When true, indicates that this ListGrid supports grouping on multiple fields.",
        flags:"IRW",
        serverDS:"allowed",
        name:"canMultiGroup"
    },
    "attr:ListGridField.defaultGroupingMode":{
        seeAlso:[
        ],
        defaultValue:"null",
        type:"attr",
        definingClass:"object:ListGridField",
        groups:[
            "grouping"
        ],
        deprecated:null,
        ref:"attr:ListGridField.defaultGroupingMode",
        valueType:"Identifier",
        description:"Default groupingMode used when the user does not specify a mode or grouping is triggered\n programmatically and ${isc.DocUtils.linkForRef('attr:ListGridField.groupingMode','field.groupingMode')} is unset.\n See ${isc.DocUtils.linkForRef('attr:ListGridField.groupingModes','field.groupingModes')}.",
        flags:"IR",
        name:"defaultGroupingMode"
    },
    "method:PickTreeItem.setValueTree":{
        seeAlso:[
        ],
        ref:"method:PickTreeItem.setValueTree",
        deprecated:null,
        type:"method",
        definingClass:"class:PickTreeItem",
        params:[
            {
                defaultValue:null,
                optional:false,
                type:"Tree",
                description:"new value tree for the item",
                name:"valueTree"
            }
        ],
        description:" Setter to change the ${isc.DocUtils.linkForRef('attr:PickTreeItem.valueTree')} at runtime\n",
        flags:"",
        name:"setValueTree"
    },
    "classMethod:ClassFactory.overwriteClass":{
        seeAlso:[
        ],
        ref:"classMethod:ClassFactory.overwriteClass",
        deprecated:null,
        type:"classMethod",
        definingClass:"object:ClassFactory",
        description:"\n Intentionally clobber an existing SmartClient Class, if it already exists.  Works \n identically to ${isc.DocUtils.linkForRef('classMethod:ClassFactory.defineClass')}, except that no warning is logged to the\n console.\n\n",
        flags:"",
        name:"overwriteClass"
    },
    "attr:ListGrid.invalidSummaryValue":{
        seeAlso:[
        ],
        ref:"attr:ListGrid.invalidSummaryValue",
        defaultValue:"\"&amp;nbsp;\"",
        deprecated:null,
        type:"attr",
        definingClass:"class:ListGrid",
        valueType:"String",
        description:"Value to display to the user if showing summary values (through ${isc.DocUtils.linkForRef('attr:ListGrid.showGridSummary')},\n ${isc.DocUtils.linkForRef('attr:ListGrid.showGroupSummary')} or ${isc.DocUtils.linkForRef('type:ListGridFieldType','listGridFieldType:\"summary\"')}), and\n the summary function returns <code>\"null\"</code> (implying it was unable to calculate a\n valid summary value). This property will only be used in the default formatting behavior. If\n an explicit formatter has been specified - via ${isc.DocUtils.linkForRef('method:ListGrid.formatCellValue')} or\n ${isc.DocUtils.linkForRef('attr:ListGridField.formatGridSummary','formatGridSummary()')}, for example - this property has\n no effect.",
        flags:"IRWA",
        name:"invalidSummaryValue"
    },
    "method:MenuButton.setShowMenuBelow":{
        seeAlso:[
        ],
        ref:"method:MenuButton.setShowMenuBelow",
        deprecated:null,
        type:"method",
        definingClass:"class:MenuButton",
        params:[
            {
                defaultValue:null,
                optional:false,
                type:"boolean",
                description:"True if the menu should be shown below the menubutton.",
                name:"below"
            }
        ],
        description:" Setter for the 'showMenuButtonBelow' property - determines whether the menu will be\n shown above or below the menubutton.\n",
        flags:"",
        name:"setShowMenuBelow"
    },
    "attr:FormItem.showValueIconOnly":{
        seeAlso:[
        ],
        defaultValue:"null",
        type:"attr",
        definingClass:"class:FormItem",
        groups:[
            "valueIcons"
        ],
        deprecated:null,
        ref:"attr:FormItem.showValueIconOnly",
        valueType:"boolean",
        description:"If ${isc.DocUtils.linkForRef('attr:FormItem.valueIcons')} is set, this property may be set to show the valueIcon\n only and prevent the standard form item element or text from displaying",
        flags:"IRWA",
        name:"showValueIconOnly"
    },
    "group:sqlDataSource":{
        refs:[
            "attr:DataSourceField.sequenceName",
            "attr:DataSourceField.implicitSequence"
        ],
        seeAlso:[
        ],
        ref:"group:sqlDataSource",
        treeLocation:[
            "Client Reference/Data Binding/DataSource"
        ],
        requiresModules:[
            "SCServer"
        ],
        deprecated:null,
        type:"group",
        title:"SQL DataSources",
        description:"The SmartClient Server supports comprehensive, codeless SQL connectivity for DataSources\n defined in XML.  Our SQL connectivity is mature, feature-rich, protected against injection\n attacks and easily customizable to support user-written SQL and additional business logic\n of any complexity.  ${isc.DocUtils.linkForRef('group:sqlVsJPA','This article')} compares the built-in SQL DataSource\n to other persistence approaches based on Javabeans.\n <P>\n To use the built-in SQL engine, declare a ${isc.DocUtils.linkForRef('class:DataSource')} in XML format with\n ${isc.DocUtils.linkForRef('attr:DataSource.serverType')} set to \"sql\", and place it in the shared dataSources directory\n ([webroot]/shared/ds by default) in a file called \"[dataSourceId].ds.xml\".\n <p>\n You can then use the ${isc.DocUtils.linkForRef('group:adminConsole','Admin Console')} to configure database access,\n as well as to automatically create and populate a database table based on your DataSource.\n By default, DataSources will use the \"default database\" from the admin console, however you\n can set ${isc.DocUtils.linkForRef('attr:DataSource.dbName')} to the name of a specific database configuration you have\n configured via the Admin Console.\n <P>\n The list of databases known to work with the the built-in SQL logic is as follows:\n <p>\n <table class='normal'>\n <tr><td width=40></td><td width=400><i>HSQLDB 1.7.x, 1.8.x, 2.0.x, 2.2.x, 2.3.x, 2.4.x, 2.5.x</i></td><td></td></tr>\n <tr><td></td><td><i>IBM DB2 8.x, 9.x, 10.x, 11.x</i></td><td></td></tr>\n <tr><td></td><td><i>IBM DB2 for i (formerly known as DB2 for i5/OS) V5R4M0 onwards</i></td><td></td></tr>\n <tr><td></td><td><i>Firebird 2.5.x, 3.x</i></td><td></td></tr>\n <tr><td></td><td><i>Informix 11.5+, 12.1</i></td><td></td></tr>\n <tr><td></td><td><i>MS SQL Server 2000, 2005, 2008, 2008 R2, 2012, 2014, 2016, 2017</i></td><td></td></tr>\n <tr><td></td><td><i>MySQL 5.0.x, 5.1.x, 5.5.x, 5.6.x, 5.7.x, 8.x</i></td><td></td></tr>\n <tr><td></td><td><i>MariaDB 5.x, 10.x</i></td><td></td></tr>\n <tr><td></td><td><i>Oracle 8.0.5, 8i, 9i, 10g, 11g, 12c, 18c, 19c</i></td><td></td></tr>\n <tr><td></td><td><i>PostgreSQL 7.x, 8.x, 9.x, 10.x, 11.x, 12.x</i></td><td></td></tr>\n </table>\n <p>We also support a generic SQL92 database connection which works for basic CRUD operations\n with any database product that supports standard SQL92 syntax and data types, plus a couple \n of widely-implemented features that are not actually part of the standard.  Specifically,\n this means we do not support:<ul>\n <li>Sequences</li>\n <li>Paging via SQL limit queries</li>\n <li>${isc.DocUtils.linkForRef('attr:DataSource.autoJoinTransactions','Automatic transaction management')}\n <li>Long text values (there is no real definition of \"long\" here - we try to use a standard\n VARCHAR, but different databases will support different maximum values for this)</li>\n <li>Databases that do not implement the widely-supported LOWER() function</li>\n <li>Databases that do not support the ability to perform string-type operations on numeric\n columns - for example, <code>myNumericColumn LIKE '%5%'</code></li>\n </ul>\n <p>You will also need a JDBC driver for your specific database. Licensing restrictions\n prevent us including any JDBC driver other than the one for HSQLDB.  However, you\n can download these drivers for free from the vendors' websites.  If your specific database\n server or version is not listed above, please go to the\n <a href=\"http://forums.smartclient.com\">SmartClient forums</a> for assistance.\n <P>\n You can also connect to an existing database table - the Visual Builder DataSource Wizard\n (\"New\" button in DataSources pane) allows you to pick an existing database table and have a\n DataSource generated from it.  The Batch DataSource Generator tool will allow you to\n generate DataSources for any number of SQL DataSources, and customize the process so that\n organization-specific rules are applied (eg ignoring certain columns, or using naming\n conventions to generate more complete DataSources).\n <P>\n Once you have your SQL DataSource connected to a table, in a default SDK installation,\n DSRequests for your DataSource will be sent to the default\n ${isc.DocUtils.linkForRef('classAttr:RPCManager.actionURL','actionURL')}, and hence handled automatically, without you having\n to write any Java code, by the ${isc.DocUtils.linkForRef('group:servletDetails','IDACall servlet registered in web.xml')}.\n IDACall is a very simple servlet that just calls the server-side method\n dsRequest.execute() for all inbound requests.  For more details on how DataSource requests\n are processed by SmartClient Server, and how you can alter and add to this processing, see\n this description of ${isc.DocUtils.linkForRef('group:serverDataIntegration','server data integration')}.",
        name:"sqlDataSource"
    },
    "classAttr:GroupingMessages.byMillisecondsTitle":{
        seeAlso:[
        ],
        defaultValue:"\"by Milliseconds\"",
        type:"classAttr",
        definingClass:"class:GroupingMessages",
        groups:[
            "i18nMessages"
        ],
        deprecated:null,
        ref:"classAttr:GroupingMessages.byMillisecondsTitle",
        valueType:"String",
        description:"Title to use for the menu option which groups a time field by milliseconds.",
        flags:"IRW",
        name:"byMillisecondsTitle"
    },
    "attr:FormItem.optionTextMatchStyle":{
        seeAlso:[
        ],
        defaultValue:"\"exact\"",
        type:"attr",
        definingClass:"class:FormItem",
        groups:[
            "databinding",
            "searchCriteria"
        ],
        deprecated:null,
        ref:"attr:FormItem.optionTextMatchStyle",
        valueType:"TextMatchStyle",
        description:"If this item has a specified <code>optionDataSource</code>, this property determines\n the textMatchStyle to use when interpretating any ${isc.DocUtils.linkForRef('attr:FormItem.optionCriteria')} during the\n fetch to map valueField values to displayField values.",
        flags:"IRA",
        name:"optionTextMatchStyle"
    },
    "attr:Slider.minValue":{
        seeAlso:[
            {
                ref:"attr:Slider.flipValues",
                description:null
            }
        ],
        defaultValue:"1",
        type:"attr",
        definingClass:"class:Slider",
        ref:"attr:Slider.minValue",
        deprecated:null,
        valueType:"float",
        setter:[
            "setMinValue"
        ],
        description:"The minimum slider value. The slider value is equal to minValue when the thumb is at the\n bottom or left of the slider (unless flipValues is true, in which case the minimum value\n is at the top/right of the slider)",
        flags:"IRW",
        examples:[
            "${isc.DocUtils.linkForExampleId('slider')}"
        ],
        name:"minValue"
    },
    "attr:SplitPane.navigationTitle":{
        seeAlso:[
        ],
        defaultValue:"null",
        type:"attr",
        definingClass:"class:SplitPane",
        deprecated:null,
        ref:"attr:SplitPane.navigationTitle",
        setter:[
            "setNavigationTitle"
        ],
        valueType:"HTMLString",
        description:"The title for the ${isc.DocUtils.linkForRef('attr:SplitPane.navigationPane','navigationPane')}, displayed in the\n ${isc.DocUtils.linkForRef('attr:SplitPane.navigationBar','navigationBar')} and also used for the title of a back\n button in some configurations.",
        flags:"IRW",
        name:"navigationTitle"
    },
    "method:ColumnTree.getColumn":{
        seeAlso:[
        ],
        ref:"method:ColumnTree.getColumn",
        deprecated:null,
        type:"method",
        definingClass:"class:ColumnTree",
        params:[
            {
                defaultValue:null,
                optional:false,
                type:"int | TreeNode",
                description:"column number, or parent node of the nodes shown in the column",
                name:"column"
            }
        ],
        description:" Advanced API - get the ListGrid representing the indicated column.\n",
        flags:"A",
        returns:{
            type:"ListGrid",
            description:"ListGrid that renders the indicated column, or null if column is not shown"
        },
        name:"getColumn"
    },
    "attr:SectionItem.canTabToHeader":{
        seeAlso:[
        ],
        ref:"attr:SectionItem.canTabToHeader",
        defaultValue:"null",
        deprecated:null,
        type:"attr",
        definingClass:"class:SectionItem",
        valueType:"boolean",
        description:"If true, the header for this Section will be included in the page's tab\n order for accessibility.\n May also be set at the ${isc.DocUtils.linkForRef('class:DynamicForm')} level via \n ${isc.DocUtils.linkForRef('attr:DynamicForm.canTabToSectionHeaders')}.\n <P>\n See ${isc.DocUtils.linkForRef('group:accessibility')}.",
        flags:"IR",
        name:"canTabToHeader"
    },
    "attr:CubeGrid.indentVTreeFacets":{
        seeAlso:[
            {
                ref:"attr:Facet.indentVTree",
                description:null
            },
            {
                ref:"attr:CubeGrid.vTreeFacetIndent",
                description:null
            },
            {
                ref:"attr:CubeGrid.vTreeFacetIndentDirection",
                description:null
            }
        ],
        ref:"attr:CubeGrid.indentVTreeFacets",
        defaultValue:"false",
        deprecated:null,
        type:"attr",
        definingClass:"class:CubeGrid",
        valueType:"boolean",
        description:"Turns on indenting of any ${isc.DocUtils.linkForRef('attr:Facet.isTree','hierarchical')} column facets.  This can be\n overridden at the facet level via ${isc.DocUtils.linkForRef('attr:Facet.indentVTree')}.  Setting this property also\n ensures that the header is sized tall enough to accommodate the fully expanded facet.  \n <P>\n The amount of indenting per level can be set with ${isc.DocUtils.linkForRef('attr:CubeGrid.vTreeFacetIndent')}, and the\n direction of the indenting specified with ${isc.DocUtils.linkForRef('attr:CubeGrid.vTreeFacetIndentDirection')}.\n <P>\n Note that if you specify an explicit height for such a fscet, such as by setting\n ${isc.DocUtils.linkForRef('attr:Facet.height')} or ${isc.DocUtils.linkForRef('attr:Facet.labelHeight')}, then the greater of that or the space\n required to accommodate the fully expanded facet will determine the actual height used.",
        flags:"IR",
        name:"indentVTreeFacets"
    },
    "attr:GridEditProxy.generateEditableHilites":{
        seeAlso:[
        ],
        ref:"attr:GridEditProxy.generateEditableHilites",
        defaultValue:"true",
        deprecated:null,
        type:"attr",
        definingClass:"class:GridEditProxy",
        valueType:"Boolean",
        description:"Controls whether highlights created while in edit mode are editable by end users at\n runtime (when the grid is no longer in edit mode).  See ${isc.DocUtils.linkForRef('attr:Hilite.canEdit')}.",
        flags:"IR",
        name:"generateEditableHilites"
    },
    "attr:RPCRequest.willHandleError":{
        seeAlso:[
            {
                ref:"class:RPCManager",
                description:null
            }
        ],
        defaultValue:"false",
        type:"attr",
        definingClass:"object:RPCRequest",
        groups:[
            "errorHandling"
        ],
        deprecated:null,
        ref:"attr:RPCRequest.willHandleError",
        valueType:"Boolean",
        description:"With willHandleError:false, rpcResponses that indicate an error go through centralized\n handling in the RPCManager and rpcRequest.callback is never invoked.\n <P>\n Setting willHandleError:true means that your rpcRequest.callback will receive rpcResponses\n that have an error status and must handle them.\n <P>\n See also the error handling section in the ${isc.DocUtils.linkForRef('class:RPCManager')} docs.",
        flags:"IRW",
        name:"willHandleError"
    },
    "attr:Canvas.dragIntersectStyle":{
        seeAlso:[
        ],
        defaultValue:"\"mouse\"",
        type:"attr",
        definingClass:"class:Canvas",
        groups:[
            "dragdrop"
        ],
        deprecated:null,
        ref:"attr:Canvas.dragIntersectStyle",
        valueType:"DragIntersectStyle",
        description:"This indicates how the system will test for droppable targets: either by intersection\n with the mouse or intersection with the rectangle of the dragMoveTarget.",
        flags:"IRWA",
        name:"dragIntersectStyle"
    },
    "attr:Layout.paddingAsLayoutMargin":{
        seeAlso:[
        ],
        defaultValue:"true",
        type:"attr",
        definingClass:"class:Layout",
        groups:[
            "layoutMargin"
        ],
        deprecated:null,
        ref:"attr:Layout.paddingAsLayoutMargin",
        valueType:"Boolean",
        description:"If this widget has padding specified (as ${isc.DocUtils.linkForRef('attr:Canvas.padding','this.padding')} or in the\n CSS style applied to this layout), should it show up as space outside the members,\n similar to layoutMargin?\n <P>\n If this setting is false, padding will not affect member positioning (as CSS padding\n normally does not affect absolutely positioned children).  Leaving this setting true\n allows a designer to more effectively control layout purely from CSS.\n <P>\n Note that ${isc.DocUtils.linkForRef('attr:Layout.layoutMargin')} if specified, takes precedence over this value.",
        flags:"IRWA",
        name:"paddingAsLayoutMargin"
    },
    "attr:Layout.defaultLayoutAlign":{
        seeAlso:[
            {
                ref:"attr:Layout.overflow",
                description:null
            }
        ],
        defaultValue:"null",
        type:"attr",
        definingClass:"class:Layout",
        groups:[
            "layoutMember",
            "layoutPolicy"
        ],
        ref:"attr:Layout.defaultLayoutAlign",
        deprecated:null,
        valueType:"Alignment | VerticalAlignment",
        description:"Specifies the default alignment for layout members on the breadth axis (horizontal axis\n for a VLayout, vertical axis for an HLayout).  Can be overridden on a per-member basis\n by setting ${isc.DocUtils.linkForRef('attr:Canvas.layoutAlign')}.\n <P>\n If unset, default member layout alignment will be \"top\" for a horizontal layout, and\n \"left\" for a vertical layout, or \"right\" if in ${isc.DocUtils.linkForRef('classMethod:Page.isRTL','RTL')} mode.\n <P>\n When attempting to center components be sure that you have set a specific size on the\n component(s) involved.  If components fill all available space in the layout, centering\n looks the same as not centering.\n <P>\n Similarly, if a component has no visible boundary (like a border), it can appear similar\n to when it's not centered if the component is larger than you expect - use the Watch tab\n in the Developer Console to see the component's extents visually.",
        flags:"IRW",
        examples:[
            "${isc.DocUtils.linkForExampleId('layoutCenterAlign')}"
        ],
        name:"defaultLayoutAlign"
    },
    "method:ImgButton.setDisabled":{
        groups:[
            "enable",
            "state"
        ],
        seeAlso:[
        ],
        ref:"method:ImgButton.setDisabled",
        deprecated:null,
        type:"method",
        definingClass:"class:ImgButton",
        params:[
            {
                defaultValue:null,
                optional:false,
                type:"boolean",
                description:"true if this widget is to be disabled",
                name:"disabled"
            }
        ],
        description:" Enable or disable this object\n",
        flags:"",
        name:"setDisabled"
    },
    "attr:StaticTextItem.applyAlignToText":{
        seeAlso:[
        ],
        defaultValue:"true",
        type:"attr",
        definingClass:"class:StaticTextItem",
        groups:[
            "appearance"
        ],
        deprecated:null,
        ref:"attr:StaticTextItem.applyAlignToText",
        valueType:"boolean",
        description:"If the ${isc.DocUtils.linkForRef('attr:FormItem.textAlign','textAlign')} is unset, should the ${isc.DocUtils.linkForRef('attr:FormItem.align','align')}\n setting, if set, be used for this <code>StaticTextItem</code>'s <code>textAlign</code>?",
        flags:"IRA",
        name:"applyAlignToText"
    },
    "method:Gauge.addSector":{
        seeAlso:[
        ],
        ref:"method:Gauge.addSector",
        deprecated:null,
        type:"method",
        definingClass:"class:Gauge",
        params:[
            {
                defaultValue:null,
                optional:false,
                type:"GaugeSector | double",
                description:"the new GaugeSector or the new sector's value. This is formatted with ${isc.DocUtils.linkForRef('method:Gauge.formatLabelContents')} to get its label.",
                name:"newSector"
            }
        ],
        description:" Adds a new sector.\n\n",
        flags:"",
        returns:{
            type:"int",
            description:"the index of the newly-added sector."
        },
        name:"addSector"
    },
    "group:Hovers":{
        refs:[
            "method:DynamicForm.itemHoverHTML",
            "method:DynamicForm.titleHoverHTML",
            "method:DynamicForm.valueHoverHTML",
            "method:FormItem.stopHover",
            "method:FormItem.itemHover",
            "method:FormItem.titleHover",
            "method:FormItem.valueHover",
            "method:FormItem.titleHoverHTML",
            "method:FormItem.valueHoverHTML",
            "method:FormItem.itemHoverHTML",
            "method:RadioGroupItem.valueHoverHTML",
            "attr:DynamicForm.itemHoverDelay",
            "attr:DynamicForm.itemHoverWidth",
            "attr:DynamicForm.itemHoverHeight",
            "attr:DynamicForm.itemHoverAlign",
            "attr:DynamicForm.itemHoverVAlign",
            "attr:DynamicForm.itemHoverStyle",
            "attr:DynamicForm.itemHoverOpacity",
            "attr:FormItem.hoverDelay",
            "attr:FormItem.hoverWidth",
            "attr:FormItem.hoverHeight",
            "attr:FormItem.hoverAlign",
            "attr:FormItem.hoverVAlign",
            "attr:FormItem.hoverStyle",
            "attr:FormItem.hoverOpacity",
            "attr:FormItem.showClippedTitleOnHover",
            "attr:FormItem.showClippedValueOnHover"
        ],
        seeAlso:[
        ],
        ref:"group:Hovers",
        deprecated:null,
        type:"group",
        description:null,
        name:"Hovers"
    },
    "class:Window":{
        seeAlso:[
        ],
        exampleConfig:"Window.xml",
        type:"class",
        staticMethods:[
        ],
        inheritsFrom:"Layout",
        classMethods:[
        ],
        classAttrs:[
            "classAttr:Window.NONE",
            "classAttr:Window.VERTICAL",
            "classAttr:Window.HORIZONTAL"
        ],
        attrs:[
            "attr:Window.canDragReposition",
            "attr:Window.keepInParentRect",
            "attr:Window.canDragResize",
            "attr:Window.resizeFrom",
            "attr:Window.useBackMask",
            "attr:Window.opacity",
            "attr:Window.isModal",
            "attr:Window.modalMask",
            "attr:Window.showModalMask",
            "attr:Window.modalMaskOpacity",
            "attr:Window.modalMaskStyle",
            "attr:Window.autoCenter",
            "attr:Window.dismissOnOutsideClick",
            "attr:Window.dismissOnEscape",
            "attr:Window.body",
            "attr:Window.showBody",
            "attr:Window.bodyStyle",
            "attr:Window.printBodyStyle",
            "attr:Window.bodyColor",
            "attr:Window.hiliteBodyColor",
            "attr:Window.items",
            "attr:Window.src",
            "attr:Window.contentsType",
            "attr:Window.bodyConstructor",
            "attr:Window.bodyDefaults",
            "attr:Window.contentLayout",
            "attr:Window.autoSize",
            "attr:Window.header",
            "attr:Window.showHeader",
            "attr:Window.headerBackground",
            "attr:Window.showHeaderBackground",
            "attr:Window.headerStyle",
            "attr:Window.printHeaderStyle",
            "attr:Window.headerSrc",
            "attr:Window.headerControls",
            "attr:Window.hiliteHeaderStyle",
            "attr:Window.hiliteHeaderSrc",
            "attr:Window.headerLabel",
            "attr:Window.showTitle",
            "attr:Window.title",
            "attr:Window.headerLabelDefaults",
            "attr:Window.headerIcon",
            "attr:Window.showHeaderIcon",
            "attr:Window.headerIconDefaults",
            "attr:Window.canFocusInHeaderButtons",
            "attr:Window.closeButton",
            "attr:Window.showCloseButton",
            "attr:Window.minimizeButton",
            "attr:Window.showMinimizeButton",
            "attr:Window.minimized",
            "attr:Window.defaultMinimizeHeight",
            "attr:Window.minimizeHeight",
            "attr:Window.animateMinimize",
            "attr:Window.minimizeTime",
            "attr:Window.minimizeAcceleration",
            "attr:Window.restoreButton",
            "attr:Window.maximized",
            "attr:Window.maximizeButton",
            "attr:Window.showMaximizeButton",
            "attr:Window.footer",
            "attr:Window.showFooter",
            "attr:Window.footerHeight",
            "attr:Window.footerControls",
            "attr:Window.statusBar",
            "attr:Window.showStatusBar",
            "attr:Window.resizer",
            "attr:Window.showResizer",
            "attr:Window.placement",
            "attr:Window.showEdges",
            "attr:Window.showShadow",
            "attr:Window.fillSpaceStyleName",
            "attr:Window.bringToFrontOnMouseUp",
            "attr:Window.status",
            "attr:Window.editProxyConstructor"
        ],
        ref:"class:Window",
        deprecated:null,
        treeLocation:[
            "Client Reference/Layout"
        ],
        description:"A general purpose Window class for implementing dialogs, portlets, alerts, prompts, wizards\n and desktop-like windowing interfaces.\n <P>\n Windows can contain arbitrary SmartClient components, configured via the ${isc.DocUtils.linkForRef('attr:Window.items')}\n property.  Windows may be ${isc.DocUtils.linkForRef('attr:Window.isModal','modal')} or non-modal.\n <P>\n Windows provide a series of highly configurable and skinnable ${isc.DocUtils.linkForRef('type:AutoChild','autoChildren')}\n including a header, various header controls, footer, and corner resizer.\n <P>\n The more specialized ${isc.DocUtils.linkForRef('class:Dialog')} subclass of Window has additional functionality targetted\n at simple prompts and confirmations, such as buttons with default actions, and single-method\n ${isc.DocUtils.linkForRef('staticMethod:isc.warn','shortcuts')} for common application dialogs.",
        methods:[
            "method:Window.setHeaderStyle",
            "method:Window.setShowCloseButton",
            "method:Window.setShowMinimizeButton",
            "method:Window.setShowMaximizeButton",
            "method:Window.setShowHeaderIcon",
            "method:Window.setTitle",
            "method:Window.setShowTitle",
            "method:Window.setStatus",
            "method:Window.setSrc",
            "method:Window.setBodyStyle",
            "method:Window.setBodyColor",
            "method:Window.setHiliteBodyColor",
            "method:Window.addItem",
            "method:Window.removeItem",
            "method:Window.addItems",
            "method:Window.removeItems",
            "method:Window.addMember",
            "method:Window.addMembers",
            "method:Window.revealChild",
            "method:Window.setAutoSize",
            "method:Window.shouldDismissOnEscape",
            "method:Window.centerInPage",
            "method:Window.flash",
            "method:Window.minimize",
            "method:Window.restore",
            "method:Window.maximize",
            "method:Window.closeClick",
            "method:Window.close"
        ],
        name:"Window"
    },
    "classAttr:RPCResponse.STATUS_MAX_FILE_SIZE_EXCEEDED":{
        seeAlso:[
            {
                ref:"classAttr:RPCResponse.STATUS_FILE_REQUIRED_ERROR",
                description:null
            },
            {
                ref:"object:RPCRequest",
                description:null
            }
        ],
        defaultValue:"-11",
        type:"classAttr",
        definingClass:"class:RPCResponse",
        groups:[
            "statusCodes",
            "constant"
        ],
        deprecated:null,
        ref:"classAttr:RPCResponse.STATUS_MAX_FILE_SIZE_EXCEEDED",
        valueType:"int",
        description:"Indicates that an uploaded file's size exceeded the maximum file size allowed.",
        flags:"R",
        name:"STATUS_MAX_FILE_SIZE_EXCEEDED"
    },
    "attr:PortalPosition.position":{
        seeAlso:[
        ],
        ref:"attr:PortalPosition.position",
        defaultValue:"0",
        deprecated:null,
        type:"attr",
        definingClass:"object:PortalPosition",
        valueType:"int",
        description:"The position occupied by a ${isc.DocUtils.linkForRef('class:Portlet')} within a ${isc.DocUtils.linkForRef('class:PortalLayout')} row\n (generally 0, unless there is more than one Portlet in the row).",
        flags:"IR",
        name:"position"
    },
    "attr:FacetChart.dataPointProperties":{
        seeAlso:[
        ],
        ref:"attr:FacetChart.dataPointProperties",
        defaultValue:"null",
        deprecated:null,
        type:"attr",
        definingClass:"class:FacetChart",
        valueType:"DrawItem Properties",
        description:"Common properties to apply for all data points (see ${isc.DocUtils.linkForRef('attr:FacetChart.showDataPoints')}).",
        flags:"IR",
        name:"dataPointProperties"
    },
    "attr:RichTextEditor.moveFocusOnTab":{
        seeAlso:[
        ],
        defaultValue:"true",
        type:"attr",
        definingClass:"class:RichTextEditor",
        deprecated:null,
        ref:"attr:RichTextEditor.moveFocusOnTab",
        setter:[
            "setMoveFocusOnTab"
        ],
        valueType:"boolean",
        description:"If the user presses the \"Tab\" key, should focus be taken from this editor?\n If set to <code>false</code> a \"Tab\" keypress will cause a Tab character\n to be inserted into the text, and focus will be left in the edit area.",
        flags:"IRW",
        name:"moveFocusOnTab"
    },
    "attr:DateItem.useTextField":{
        seeAlso:[
        ],
        defaultValue:"null",
        type:"attr",
        definingClass:"class:DateItem",
        groups:[
            "basics"
        ],
        ref:"attr:DateItem.useTextField",
        deprecated:null,
        valueType:"Boolean",
        description:"When set to true, the item uses a ${isc.DocUtils.linkForRef('attr:DateItem.textField','single text field')} for \n working with the item's value.\n <P>\n When false or unset, the default, the item's value is represented by separate \n ${isc.DocUtils.linkForRef('attr:DateItem.daySelector','day')}, ${isc.DocUtils.linkForRef('attr:DateItem.monthSelector','month')}, \n and/or ${isc.DocUtils.linkForRef('attr:DateItem.yearSelector','year')} selectors.  In this mode, null values are not\n supported, and a default value of Today will be enforced if no \n ${isc.DocUtils.linkForRef('attr:FormItem.defaultValue','defaultValue')} is specified.  This means that a DateItem \n with <code>useTextField</code> set to false is effectively a \n ${isc.DocUtils.linkForRef('attr:FormItem.required','required')} field.\n <P>\n If you want to change the appearance of a DateItem, you will need to configure some\n autoChildren such as ${isc.DocUtils.linkForRef('attr:DateItem.textField')} via ${isc.DocUtils.linkForRef('attr:DateItem.textFieldProperties')},\n or in <code>useTextField:false</code> mode, the ${isc.DocUtils.linkForRef('attr:DateItem.daySelector')} and other selectors, \n configured via <code>daySelectorProperties</code> et al.",
        flags:"IR",
        examples:[
            "${isc.DocUtils.linkForExampleId('dateItem')}"
        ],
        name:"useTextField"
    },
    "attr:DrawSector.showTitleLabelBackground":{
        seeAlso:[
        ],
        ref:"attr:DrawSector.showTitleLabelBackground",
        defaultValue:"true",
        deprecated:null,
        type:"attr",
        definingClass:"class:DrawSector",
        valueType:"boolean",
        description:"If the ${isc.DocUtils.linkForRef('attr:DrawItem.titleLabel','titleLabel')} is showing, should the ${isc.DocUtils.linkForRef('attr:DrawItem.titleLabelBackground','titleLabelBackground')}\n be created and placed behind the <code>titleLabel</code>?\n <p>\n This defaults to true for ${isc.DocUtils.linkForRef('class:DrawSector')}s and shapes that are not commonly filled\n (e.g. ${isc.DocUtils.linkForRef('class:DrawLine')}s).",
        flags:"IRA",
        name:"showTitleLabelBackground"
    },
    "attr:SplitPane.showDetailToolStrip":{
        seeAlso:[
        ],
        ref:"attr:SplitPane.showDetailToolStrip",
        defaultValue:"null",
        deprecated:null,
        type:"attr",
        definingClass:"class:SplitPane",
        valueType:"Boolean",
        description:"If set to <code>false</code>, the ${isc.DocUtils.linkForRef('attr:SplitPane.detailToolStrip','detailToolStrip')}\n will not be shown.",
        flags:"IR",
        name:"showDetailToolStrip"
    },
    "attr:DataBoundComponent.addFormulaFieldText":{
        seeAlso:[
        ],
        defaultValue:"\"Add formula column...\"",
        type:"attr",
        definingClass:"interface:DataBoundComponent",
        groups:[
            "i18nMessages"
        ],
        deprecated:null,
        ref:"attr:DataBoundComponent.addFormulaFieldText",
        valueType:"String",
        description:"Text for a menu item allowing users to add a formula field",
        flags:"IRW",
        name:"addFormulaFieldText"
    },
    "attr:TileLayout.overflow":{
        seeAlso:[
        ],
        defaultValue:"\"auto\"",
        type:"attr",
        definingClass:"class:TileLayout",
        groups:[
            "sizing"
        ],
        deprecated:null,
        ref:"attr:TileLayout.overflow",
        valueType:"Overflow",
        description:"Normal ${isc.DocUtils.linkForRef('type:Overflow')} settings can be used on TileLayouts, for example, an\n overflow:auto TileLayout will scroll if members exceed its specified size, whereas an\n overflow:visible TileLayout will grow to accommodate members.",
        flags:"IRW",
        name:"overflow"
    },
    "attr:TextItem.width":{
        seeAlso:[
        ],
        defaultValue:"150",
        type:"attr",
        definingClass:"class:TextItem",
        groups:[
            "appearance"
        ],
        deprecated:null,
        ref:"attr:TextItem.width",
        valueType:"number",
        description:"Default width for fields.",
        flags:"IRW",
        name:"width"
    },
    "attr:Canvas.edgeShowCenter":{
        seeAlso:[
        ],
        defaultValue:"false",
        type:"attr",
        definingClass:"class:Canvas",
        groups:[
            "imageEdges"
        ],
        ref:"attr:Canvas.edgeShowCenter",
        deprecated:null,
        valueType:"Boolean",
        description:"Whether to show media in the center section, that is, behind the decorated Canvas.",
        flags:"IR",
        examples:[
            "${isc.DocUtils.linkForExampleId('corners')}"
        ],
        name:"edgeShowCenter"
    },
    "group:xmlCriteriaShorthand":{
        refs:[
        ],
        seeAlso:[
        ],
        ref:"group:xmlCriteriaShorthand",
        deprecated:null,
        type:"group",
        description:"A shorthand format for ${isc.DocUtils.linkForRef('object:AdvancedCriteria')} is supported for simple criteria\n where the outer criterion is assumed to be an \"and\" operator:\n <pre>\n &lt;!-- Simple format --&gt;\n &lt;criteria fieldName=\"restrictAge\" operator=\"equals\" value=\"true\"/&gt;\n </pre>\n This is equivalent to:\n <pre>\n &lt;!-- Normal format --&gt;\n &lt;criteria _constructor=\"AdvancedCriteria operator=\"and\"&gt;\n   &lt;criteria&gt;\n     &lt;criterion fieldName=\"restrictAge\" operator=\"equals\" value=\"true\"/&gt;\n   &lt;/criteria&gt; \n &lt;/criteria&gt;\n </pre>",
        name:"xmlCriteriaShorthand"
    },
    "group:cursor":{
        refs:[
            "attr:Splitbar.cursor",
            "attr:Splitbar.vResizeCursor",
            "attr:Splitbar.hResizeCursor"
        ],
        seeAlso:[
        ],
        ref:"group:cursor",
        deprecated:null,
        type:"group",
        description:null,
        name:"cursor"
    },
    "classMethod:Canvas.getPrintPreview":{
        groups:[
            "printing"
        ],
        seeAlso:[
        ],
        ref:"classMethod:Canvas.getPrintPreview",
        deprecated:null,
        type:"classMethod",
        definingClass:"class:Canvas",
        params:[
            {
                defaultValue:null,
                optional:false,
                type:"Array of Canvas",
                description:"components to get the print HTML for. May also include    raw HTML strings which will be folded into the generated print output",
                name:"components"
            },
            {
                defaultValue:null,
                optional:true,
                type:"PrintProperties",
                description:"PrintProperties object for customizing the print HTML output",
                name:"printProperties"
            },
            {
                defaultValue:null,
                optional:true,
                type:"Canvas Properties",
                description:"properties to apply to the generated printPreview Canvas.",
                name:"previewProperties"
            },
            {
                defaultValue:null,
                optional:true,
                type:"PrintCanvasCallback",
                description:"callback to fire when the print preview canvas has been populated    with the printable HTML. The generated canvas will be passed to the callback as a single \n    <code>printPreview</code> parameter.",
                name:"callback"
            },
            {
                defaultValue:null,
                optional:true,
                type:"String",
                description:"optional string of HTML to render between each component",
                name:"separator"
            }
        ],
        description:" Creates a printCanvas containing the full printHTML for a series of components, passing\n it as an argument to the callback (if supplied) when it fires. Note that the generated\n preview canvas will be drawn automatically by this method. Developers may also\n explicitly create a PrintCanvas instance and populate it with HTML derived from the\n ${isc.DocUtils.linkForRef('method:Canvas.getPrintHTML')} for finer grained control over when the print canvas is\n drawn.\n",
        flags:"",
        name:"getPrintPreview"
    },
    "method:ListGridField.cellChanged":{
        groups:[
            "editing"
        ],
        seeAlso:[
            {
                ref:"method:ListGrid.cellChanged",
                description:null
            }
        ],
        ref:"method:ListGridField.cellChanged",
        deprecated:null,
        type:"method",
        definingClass:"object:ListGridField",
        params:[
            {
                defaultValue:null,
                optional:false,
                type:"ListGridRecord",
                description:"record for the cell being changed",
                name:"record"
            },
            {
                defaultValue:null,
                optional:false,
                type:"Any",
                description:"new value for the cell",
                name:"newValue"
            },
            {
                defaultValue:null,
                optional:false,
                type:"Any",
                description:"old value for the cell",
                name:"oldValue"
            },
            {
                defaultValue:null,
                optional:false,
                type:"number",
                description:"row number for the cell",
                name:"rowNum"
            },
            {
                defaultValue:null,
                optional:false,
                type:"number",
                description:"column number of the cell",
                name:"colNum"
            },
            {
                defaultValue:null,
                optional:false,
                type:"ListGrid",
                description:"grid where cell was changed.",
                name:"grid"
            }
        ],
        description:" Callback fired when field changes value as the result of a cell edit.  Fired only on\n successful save of edit, when the new value doesn't match the value before editing.<br>\n <p>\n Same signature as ${isc.DocUtils.linkForRef('method:ListGrid.cellChanged')}, but defined on a per-field\n basis.\n\n",
        flags:"",
        name:"cellChanged"
    },
    "attr:ListGridField.valueField":{
        seeAlso:[
        ],
        defaultValue:"null",
        type:"attr",
        definingClass:"object:ListGridField",
        groups:[
            "display_values"
        ],
        deprecated:null,
        ref:"attr:ListGridField.valueField",
        valueType:"String",
        description:"Specifies the ${isc.DocUtils.linkForRef('attr:ListGridField.optionDataSource')} field used to retrieve the stored\n values that are to be mapped to the display values (specified by\n ${isc.DocUtils.linkForRef('attr:ListGridField.displayField')}). Note that if this field is editable this will also\n be applied to this field's editors.",
        flags:"IRW",
        name:"valueField"
    },
    "object:isA":{
        seeAlso:[
        ],
        type:"object",
        staticMethods:[
            "staticMethod:isA.emptyString",
            "staticMethod:isA.nonemptyString",
            "staticMethod:isA.Object",
            "staticMethod:isA.emptyObject",
            "staticMethod:isA.emptyArray",
            "staticMethod:isA.String",
            "staticMethod:isA.Array",
            "staticMethod:isA.Function",
            "staticMethod:isA.Number",
            "staticMethod:isA.Boolean",
            "staticMethod:isA.Date",
            "staticMethod:isA.RegularExpression",
            "staticMethod:isA.Instance",
            "staticMethod:isA.ClassObject",
            "staticMethod:isA.Interface",
            "staticMethod:isA.List"
        ],
        classMethods:[
        ],
        classAttrs:[
        ],
        attrs:[
        ],
        ref:"object:isA",
        deprecated:null,
        treeLocation:[
            "Client Reference/System"
        ],
        description:"A library of functions for determining the types of other objects.<br><br>\n\n  The \"isA\" methods for the basic JavaScript types are much faster and more consistent across\n  platforms than JavaScript's \"typeof\" operator.<br><br>\n\n  An isA method is automatically created for every ISC Class and Interface definition, for\n  example, isA.Canvas().<br><br>",
        methods:[
        ],
        examples:[
            "<code>if (isA.Number(myVariable)) ...</code>\n\tNote: <code>is</code> and <code>isAn</code> are synonyms of <code>isA</code> and can be used\n\t\t\tinterchangably when it looks better syntactically, eg:\n\t\t\t\t<code>if (myObject == null) ...</code>\n\t\t\tor\n\t\t\t\t<code>if (isAn.Array(myObject)) ...</code>"
        ],
        name:"isA"
    },
    "attr:ButtonItem.enableWhen":{
        seeAlso:[
        ],
        defaultValue:"null",
        type:"attr",
        definingClass:"class:ButtonItem",
        groups:[
            "ruleCriteria"
        ],
        deprecated:null,
        ref:"attr:ButtonItem.enableWhen",
        valueType:"AdvancedCriteria",
        description:"Criteria to be evaluated to determine whether this item should be enabled.  This\n property is incompatible with ${isc.DocUtils.linkForRef('attr:FormItem.readOnlyWhen','readOnlyWhen')} and any setting you provide for\n the latter will be ignored if this property is set.\n <P>\n Criteria are evaluated against the ${isc.DocUtils.linkForRef('method:DynamicForm.getValues','form\\'s current values')} as\n well as the current ${isc.DocUtils.linkForRef('attr:Canvas.ruleScope','rule context')}.  Criteria are re-evaluated\n every time form values or the rule context changes, whether by end user action or by\n programmatic calls.\n <P>\n A basic criteria uses textMatchStyle:\"exact\". When specified in\n ${isc.DocUtils.linkForRef('group:componentXML','Component XML')} this property allows\n ${isc.DocUtils.linkForRef('group:xmlCriteriaShorthand','shorthand formats')} for defining criteria.\n <p>\n Note: A ButtonItem using enableWhen must have a ${isc.DocUtils.linkForRef('attr:FormItem.name','name')} defined.\n ${isc.DocUtils.linkForRef('attr:CanvasItem.shouldSaveValue','shouldSaveValue')} can be set to <code>false</code> to prevent the field from storing\n its value into the form's values.",
        flags:"IR",
        name:"enableWhen"
    },
    "group:simpleNamesMode":{
        refs:[
        ],
        seeAlso:[
        ],
        ref:"group:simpleNamesMode",
        treeLocation:[
            "Client Reference/System"
        ],
        deprecated:null,
        type:"group",
        title:"Simple Names mode",
        description:"When SmartClient runs in \"simple names\" mode (the default), all ISC Classes and several\n global methods are installed as JavaScript global variables, that is, properties of the\n browser's \"window\" object.  When simple names mode is disabled (called \"portal mode\"),\n the framework uses only the global variable: \"isc\" and global variables prefixed with\n \"isc_\".  \n <P>\n Portal mode is intended for applications which must integrate with fairly arbitrary\n JavaScript code written by third-party developers, and/or third party JavaScript frameworks,\n where it is important that each framework stays within it's own namespace.\n <P>\n \n In portal mode, all references to ISC classes and global functions must be prefixed with\n \"isc.\", for example:<pre>\n \n      Canvas.create(addProperties({}, myDefaults))\n\n </pre>would become<pre>\n\n      isc.Canvas.create(isc.addProperties({}, myDefaults));\n\n </pre>\n \n Portal mode is enabled by setting <code>window.isc_useSimpleNames = false</code> <b>before</b>\n SmartClient is loaded, generally inside the &lt;head&gt; element.",
        name:"simpleNamesMode"
    },
    "attr:ToolStrip.groupTitleOrientation":{
        seeAlso:[
        ],
        ref:"attr:ToolStrip.groupTitleOrientation",
        defaultValue:"\"top\"",
        deprecated:null,
        type:"attr",
        definingClass:"class:ToolStrip",
        valueType:"VerticalAlignment",
        description:"If set, this attribute affects the orientation of the titles in \n ${isc.DocUtils.linkForRef('class:ToolStripGroup','ToolStripGroups')}.  You can override this at the \n ${isc.DocUtils.linkForRef('attr:ToolStripGroup.titleAlign','individual ToolStripGroup')} level.",
        flags:"IR",
        name:"groupTit