/*
 * Decompiled with CFR 0.152.
 */
package com.isomorphic.taglib;

import com.isomorphic.base.Reflection;
import com.isomorphic.js.JSTranslater;
import com.isomorphic.log.Logger;
import com.isomorphic.rpc.RPCDMI;
import com.isomorphic.taglib.BaseTag;
import com.isomorphic.taglib.LoadAppTag;
import com.isomorphic.util.DataTools;
import java.io.Writer;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.JspWriter;

public class LoadDMIStubsTag
extends BaseTag {
    public String ID = null;

    public int doStartTag() throws JspException {
        this.init();
        if (this.log == null) {
            this.log = new Logger(LoadAppTag.class.getName());
        }
        try {
            String appID = this.getID();
            if (appID == null) {
                throw new JspException("DMI App ID not set in tag - unable to proceed.");
            }
            Map appConfig = RPCDMI.loadAppConfig(appID);
            List rpcBindings = (List)appConfig.get("rpcBindings");
            if (appConfig == null) {
                throw new Exception("Unable to locate " + appID + ".app.xml - check to make sure it's in " + webRoot + "/shared/app");
            }
            if (rpcBindings == null) {
                throw new Exception(appID + ".app.xml does not define any rpcBindings - please add an <rpcBindings> section to the file");
            }
            JspWriter out = this.pageContext.getOut();
            JSTranslater jsTrans = new JSTranslater();
            for (Map serverObject : rpcBindings) {
                List visibleMethods;
                String soID = (String)serverObject.get("ID");
                String className = (String)serverObject.get("className");
                if (soID == null) {
                    soID = className;
                }
                if (soID == null) {
                    throw new Exception(appID + ".app.xml contains a ServerObject block with no ID or className - please fix this.");
                }
                int dotIndex = soID.lastIndexOf(".");
                if (dotIndex != -1) {
                    soID = soID.substring(dotIndex + 1);
                }
                if ((visibleMethods = (List)serverObject.get("visibleMethods")) == null) {
                    this.log.warn(appID + ".app.xml contains a ServerObject block with no <visibleMethods> - skipping.");
                    continue;
                }
                ArrayList<String> methodNames = new ArrayList<String>();
                for (Map method : visibleMethods) {
                    methodNames.add((String)method.get("name"));
                }
                if (methodNames.contains("*")) {
                    Class classObj = Reflection.classForName(className);
                    Method[] classMethods = classObj.getDeclaredMethods();
                    for (int ii = 0; ii < classMethods.length; ++ii) {
                        Method method = classMethods[ii];
                        String methodName = method.getName();
                        if (methodNames.contains(methodName)) continue;
                        methodNames.add(methodName);
                    }
                }
                out.write("isc.DMI.bind('" + this.getID() + "','" + soID + "',");
                jsTrans.toJS(methodNames, (Writer)out);
                out.write(");\n");
            }
        }
        catch (Throwable e) {
            this.log.error((Object)"Exception while attempting to process a loadApp tag.", e);
            throw new JspException(DataTools.getStackTrace(e));
        }
        return 0;
    }

    public void setID(String ID) {
        this.ID = ID;
    }

    public String getID() {
        return this.ID;
    }

    public void setName(String name) {
        this.ID = name;
    }

    public String getName() {
        return this.ID;
    }
}

