/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.ddf;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import org.apache.poi.ddf.EscherProperty;
import org.apache.poi.ddf.EscherPropertyFactory;
import org.apache.poi.ddf.EscherRecord;
import org.apache.poi.ddf.EscherRecordFactory;
import org.apache.poi.ddf.EscherSerializationListener;
import org.apache.poi.util.LittleEndian;

public abstract class AbstractEscherOptRecord
extends EscherRecord {
    private List<EscherProperty> properties = new ArrayList<EscherProperty>();

    public void addEscherProperty(EscherProperty prop) {
        this.properties.add(prop);
    }

    @Override
    public int fillFields(byte[] data, int offset, EscherRecordFactory recordFactory) {
        int bytesRemaining = this.readHeader(data, offset);
        short propertiesCount = AbstractEscherOptRecord.readInstance(data, offset);
        int pos = offset + 8;
        EscherPropertyFactory f = new EscherPropertyFactory();
        this.properties = f.createProperties(data, pos, propertiesCount);
        return bytesRemaining + 8;
    }

    public List<EscherProperty> getEscherProperties() {
        return this.properties;
    }

    public EscherProperty getEscherProperty(int index) {
        return this.properties.get(index);
    }

    private int getPropertiesSize() {
        int totalSize = 0;
        for (EscherProperty property : this.properties) {
            totalSize += property.getPropertySize();
        }
        return totalSize;
    }

    @Override
    public int getRecordSize() {
        return 8 + this.getPropertiesSize();
    }

    public <T extends EscherProperty> T lookup(int propId) {
        for (EscherProperty prop : this.properties) {
            if (prop.getPropertyNumber() != propId) continue;
            EscherProperty result = prop;
            return (T)result;
        }
        return null;
    }

    @Override
    public int serialize(int offset, byte[] data, EscherSerializationListener listener) {
        listener.beforeRecordSerialize(offset, this.getRecordId(), this);
        LittleEndian.putShort(data, offset, this.getOptions());
        LittleEndian.putShort(data, offset + 2, this.getRecordId());
        LittleEndian.putInt(data, offset + 4, this.getPropertiesSize());
        int pos = offset + 8;
        for (EscherProperty property : this.properties) {
            pos += property.serializeSimplePart(data, pos);
        }
        for (EscherProperty property : this.properties) {
            pos += property.serializeComplexPart(data, pos);
        }
        listener.afterRecordSerialize(pos, this.getRecordId(), pos - offset, this);
        return pos - offset;
    }

    public void sortProperties() {
        Collections.sort(this.properties, new Comparator<EscherProperty>(){

            @Override
            public int compare(EscherProperty p1, EscherProperty p2) {
                short s2;
                short s1 = p1.getPropertyNumber();
                return s1 < (s2 = p2.getPropertyNumber()) ? -1 : (s1 == s2 ? 0 : 1);
            }
        });
    }

    public void setEscherProperty(EscherProperty value) {
        Iterator<EscherProperty> iterator = this.properties.iterator();
        while (iterator.hasNext()) {
            EscherProperty prop = iterator.next();
            if (prop.getId() != value.getId()) continue;
            iterator.remove();
        }
        this.properties.add(value);
        this.sortProperties();
    }

    public void removeEscherProperty(int num) {
        Iterator<EscherProperty> iterator = this.getEscherProperties().iterator();
        while (iterator.hasNext()) {
            EscherProperty prop = iterator.next();
            if (prop.getPropertyNumber() != num) continue;
            iterator.remove();
        }
    }

    @Override
    protected Object[][] getAttributeMap() {
        ArrayList<Object> attrList = new ArrayList<Object>(this.properties.size() * 2 + 2);
        attrList.add("properties");
        attrList.add(this.properties.size());
        for (EscherProperty property : this.properties) {
            attrList.add(property.getName());
            attrList.add(property);
        }
        return new Object[][]{{"isContainer", this.isContainerRecord()}, {"numchildren", this.getChildRecords().size()}, attrList.toArray()};
    }
}

