/*
 * Decompiled with CFR 0.152.
 */
package com.isomorphic.sql;

import com.isomorphic.base.Base;
import com.isomorphic.datasource.DSField;
import com.isomorphic.datasource.DSRequest;
import com.isomorphic.datasource.DataSource;
import com.isomorphic.datasource.IncludeFromDefinition;
import com.isomorphic.datasource.Relation;
import com.isomorphic.log.Logger;
import com.isomorphic.sql.SQLDataSource;
import com.isomorphic.sql.SQLDriver;
import com.isomorphic.util.DataTools;
import com.isomorphic.velocity.Velocity;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class SQLJoinWhereClause
extends Base {
    private static Logger log = new Logger(SQLJoinWhereClause.class.getName());
    List dataSources = null;
    DSRequest dsRequest = null;
    boolean keepUndeclaredFields = false;
    private boolean qualifyColumnNames = true;
    private List includeFrom = null;
    private boolean isSubSelect = false;
    private Boolean useAnsiJoins = null;
    private boolean firstDSJoined = false;
    private List customValueFields = null;
    private List customCriteriaFields = null;
    List joinedDataSources;

    public SQLJoinWhereClause(DSRequest dsRequest, SQLDataSource ds) throws Exception {
        this(dsRequest, ds, false);
    }

    public SQLJoinWhereClause(DSRequest dsRequest, SQLDataSource ds, boolean qualifyColumnNames) throws Exception {
        this(dsRequest, DataTools.makeList((Object)((Object)ds)), qualifyColumnNames);
    }

    public SQLJoinWhereClause(DSRequest dsRequest, List dataSources) throws Exception {
        this(dsRequest, dataSources, false);
    }

    public SQLJoinWhereClause(DSRequest dsRequest, List dataSources, boolean qualifyColumnNames) throws Exception {
        this(dsRequest, dataSources, null, qualifyColumnNames);
    }

    public SQLJoinWhereClause(DSRequest dsRequest, List dataSources, IncludeFromDefinition includeFromDef, boolean qualifyColumnNames) throws Exception {
        this.qualifyColumnNames = qualifyColumnNames;
        this.dataSources = dataSources;
        this.dsRequest = dsRequest;
        if (includeFromDef != null) {
            this.isSubSelect = true;
            this.includeFrom = DataTools.makeList((Object)includeFromDef);
        } else {
            this.includeFrom = dsRequest.getIncludeFrom();
        }
        if (this.includeFrom == null) {
            this.includeFrom = new ArrayList();
        }
    }

    public boolean isEmpty() {
        return this.includeFrom.size() == 0;
    }

    public int size() {
        return this.includeFrom.size();
    }

    public String getSQLString() throws Exception {
        if (this.isEmpty()) {
            return "";
        }
        this.useAnsiJoins = DataTools.asBooleanObject((Object)this.dsRequest.getDataSource().getConfig().get((Object)"useAnsiJoins"));
        if (this.useAnsiJoins == null) {
            this.useAnsiJoins = config.getBoolean((Object)"sql.useAnsiJoins", false);
        }
        this.joinedDataSources = new ArrayList();
        SQLDataSource firstDS = (SQLDataSource)((Object)this.dataSources.get(0));
        String clause = "";
        for (IncludeFromDefinition incFrom : this.includeFrom) {
            String expression;
            Relation relation;
            String includeSummaryFunction;
            if (incFrom.isInError() || !(incFrom.getDataSource() instanceof SQLDataSource)) continue;
            String string = includeSummaryFunction = incFrom.getThisField() == null ? null : incFrom.getThisField().getProperty("includeSummaryFunction");
            if (!this.dsRequest.isSummary() && !this.isSubSelect && includeSummaryFunction != null && (!"CONCAT".equalsIgnoreCase(includeSummaryFunction) || !this.dsRequest.isConcatFetchRequest())) continue;
            DSField thisField = incFrom.getThisField();
            if (thisField != null && thisField.getBoolean("customSQL")) {
                Iterator j;
                String thisFieldName = incFrom.getThisFieldName();
                boolean skipField = true;
                if (this.customValueFields != null) {
                    j = this.customValueFields.iterator();
                    while (j.hasNext()) {
                        if (!j.next().equals(thisFieldName)) continue;
                        skipField = false;
                        break;
                    }
                }
                if (skipField && this.customCriteriaFields != null) {
                    j = this.customCriteriaFields.iterator();
                    while (j.hasNext()) {
                        if (!j.next().equals(thisFieldName)) continue;
                        skipField = false;
                        break;
                    }
                }
                if (skipField) continue;
            }
            if ((relation = incFrom.getRelation()) != null && (expression = this.buildExpression(incFrom, relation, firstDS.getDriver())) != null && !"".equals(expression)) {
                if (clause.length() > 0) {
                    clause = clause + " AND ";
                }
                clause = clause + expression;
            }
            IncludeFromDefinition target = incFrom.getTargetIncludeFrom();
            while (target != null) {
                String expression2;
                DataSource rds = target.getDataSource();
                relation = target.getRelation();
                if (relation == null) {
                    thisField = incFrom.getThisField();
                    String includeVia = null;
                    if (thisField != null) {
                        includeVia = thisField.getProperty("includeVia");
                    }
                    relation = incFrom.getDataSource().getRelation(rds, includeVia);
                }
                if (relation != null && (expression2 = this.buildExpression(target, relation, firstDS.getDriver())) != null && !"".equals(expression2)) {
                    if (clause.length() > 0) {
                        clause = clause + " AND ";
                    }
                    clause = clause + expression2;
                }
                incFrom = target;
                target = incFrom.getTargetIncludeFrom();
            }
        }
        return clause;
    }

    private String buildExpression(IncludeFromDefinition incFrom, Relation relation, SQLDriver driver) throws Exception {
        if (this.isSubSelect && this.useAnsiJoins.booleanValue() && this.firstDSJoined) {
            return null;
        }
        Object overrideTableName = null;
        StringBuffer joinClause = new StringBuffer();
        List fromFields = relation.getFromFields();
        List toFields = relation.getToFields();
        if (toFields.size() != fromFields.size()) {
            throw new Exception("Cannot join DataSources " + relation.getFromDataSource().getName() + " and " + relation.getToDataSource().getName() + " - are your foreignKey definitions correct?");
        }
        String toAlias = relation.getToAlias();
        String joinedDSKey = relation.getToDataSource().getName();
        if (!this.joinedDataSources.contains(joinedDSKey = joinedDSKey + (toAlias != null ? "*" + toAlias : ""))) {
            SQLDataSource relatedDS = (SQLDataSource)relation.getToDataSource();
            String toTable = relatedDS.getTable().getNameQuotedIfNecessary(relatedDS);
            if (toAlias != null) {
                toTable = toAlias;
            }
            relatedDS = (SQLDataSource)relation.getFromDataSource();
            String fromTable = relatedDS.getTable().getNameQuotedIfNecessary(relatedDS);
            String fromAlias = relation.getFromAlias();
            if (fromAlias != null) {
                fromTable = fromAlias;
            }
            for (int i = 0; i < fromFields.size(); ++i) {
                String to = this.getColumnNameForField((DSField)toFields.get(i));
                String from = this.getColumnNameForField((DSField)fromFields.get(i));
                String escapedTo = relatedDS.getDriver().escapeColumnName(to);
                escapedTo = toTable + "." + escapedTo;
                String escapedFrom = driver.escapeColumnName(from);
                escapedFrom = fromTable + "." + escapedFrom;
                if (((DSField)fromFields.get(i)).get((Object)"customSelectExpression") != null || ((DSField)fromFields.get(i)).get((Object)"customSQLExpression") != null) {
                    escapedFrom = this.getCustomSelectExpression((DSField)fromFields.get(i));
                }
                if (((DSField)toFields.get(i)).get((Object)"customSelectExpression") != null || ((DSField)toFields.get(i)).get((Object)"customSQLExpression") != null) {
                    escapedTo = this.getCustomSelectExpression((DSField)toFields.get(i));
                }
                if (joinClause.length() > 0) {
                    joinClause.append(" AND ");
                }
                joinClause.append(driver.generateJoinClause(escapedTo, escapedFrom, relation));
            }
            this.joinedDataSources.add(joinedDSKey);
            this.firstDSJoined = true;
        }
        while (relation.getNextRelation() != null) {
            String expression;
            if (!(relation = relation.getNextRelation()).isValid() || (expression = this.buildExpression(incFrom, relation, driver)) == null || "".equals(expression)) continue;
            if (joinClause.length() > 0) {
                joinClause.append(" AND ");
            }
            joinClause.append(expression);
        }
        return joinClause.toString();
    }

    private String getColumnNameForField(DSField field) {
        if (field.getNativeName() != null) {
            return field.getNativeName();
        }
        return field.getName();
    }

    public void setIsSubSelect(boolean isSubSelect) {
        this.isSubSelect = isSubSelect;
    }

    private String getCustomSelectExpression(DSField field) throws Exception {
        Map context = Velocity.getStandardContextMap((DSRequest)this.dsRequest);
        String expr = (String)field.get((Object)"customSelectExpression");
        if (expr == null) {
            expr = (String)field.get((Object)"customSQLExpression");
        }
        return Velocity.evaluateWithSnippets((String)expr, (Map)context, (String)"customSelectExpression", (DSRequest)this.dsRequest, (boolean)field.getBoolean("autoQuoteCustomExpressions", true), (boolean)false);
    }

    public List getCustomValueFields() {
        return this.customValueFields;
    }

    public void setCustomValueFields(List fields) {
        this.customValueFields = fields;
    }

    public List getCustomCriteriaFields() {
        return this.customCriteriaFields;
    }

    public void setCustomCriteriaFields(List fields) {
        this.customCriteriaFields = fields;
    }
}

