/*
 * Decompiled with CFR 0.152.
 */
package com.isomorphic.tools.dmi;

import com.isomorphic.auth.AuthenticatedUser;
import com.isomorphic.auth.Authentication;
import com.isomorphic.base.Config;
import com.isomorphic.criteria.AdvancedCriteria;
import com.isomorphic.criteria.Criterion;
import com.isomorphic.criteria.criterion.LogicalCriterion;
import com.isomorphic.criteria.criterion.SimpleCriterion;
import com.isomorphic.datasource.DSRequest;
import com.isomorphic.datasource.DSResponse;
import com.isomorphic.datasource.DataSource;
import com.isomorphic.datasource.FileSourceCaches;
import com.isomorphic.io.ISCFile;
import com.isomorphic.servlet.RequestContext;
import java.io.File;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.io.FileUtils;

public class CustomDataSourceOperations {
    public DSResponse findUniqueSuffixes(DSRequest req) throws Exception {
        List nameSet = (List)req.getValues().get("nameSet");
        List<Map> files = this.fetchMatchingFiles(req);
        nameSet.sort(new Comparator<String>(){

            @Override
            public int compare(String o1, String o2) {
                return o2.length() - o1.length();
            }
        });
        HashMap fileNames = new HashMap();
        int start = 0;
        for (int i = 0; i < nameSet.size(); ++i) {
            String baseName = (String)nameSet.get(i);
            ArrayList<String> existingNames = new ArrayList<String>();
            for (int j = start; j < files.size(); ++j) {
                if (!((String)files.get(j).get("fileName")).startsWith(baseName)) continue;
                existingNames.add((String)files.get(j).get("fileName"));
            }
            fileNames.put(baseName, existingNames);
        }
        ArrayList returnData = new ArrayList();
        Iterator iter = fileNames.keySet().iterator();
        while (iter.hasNext()) {
            int suffix;
            boolean foundUnique = false;
            String baseName = (String)iter.next();
            for (suffix = 1; suffix <= 999; ++suffix) {
                String candidate = baseName + "_" + suffix;
                if (((List)fileNames.get(baseName)).contains(candidate)) continue;
                HashMap<String, String> work = new HashMap<String, String>();
                work.put("dsName", baseName);
                work.put("suffix", "_" + suffix);
                returnData.add(work);
                foundUnique = true;
                break;
            }
            if (foundUnique) continue;
            HashMap<String, String> work = new HashMap<String, String>();
            work.put("dsName", baseName);
            work.put("suffix", "_" + suffix);
            returnData.add(work);
        }
        DSResponse resp = new DSResponse();
        resp.setData(returnData);
        return resp;
    }

    public DSResponse findCommonUniqueSuffix(DSRequest req) throws Exception {
        int suffix;
        List nameSet = (List)req.getValues().get("nameSet");
        List<Map> files = this.fetchMatchingFiles(req);
        ArrayList<String> fileNames = new ArrayList<String>();
        for (int i = 0; i < files.size(); ++i) {
            fileNames.add((String)files.get(i).get("fileName"));
        }
        boolean foundUnique = false;
        block1: for (suffix = 1; suffix <= 999; ++suffix) {
            for (int i = 0; i < nameSet.size(); ++i) {
                String candidate = (String)nameSet.get(i) + "_" + suffix;
                if (fileNames.contains(candidate)) continue block1;
            }
            foundUnique = true;
            break;
        }
        DSResponse resp = new DSResponse();
        resp.setData((Object)(foundUnique ? Integer.valueOf(suffix) : null));
        return resp;
    }

    public List<Map> fetchMatchingFiles(DSRequest req) throws Exception {
        List nameSet = (List)req.getValues().get("nameSet");
        ArrayList<SimpleCriterion> clauses = new ArrayList<SimpleCriterion>();
        for (int i = 0; i < nameSet.size(); ++i) {
            clauses.add(new SimpleCriterion("fileName", "iStartsWith", nameSet.get(i)));
        }
        LogicalCriterion orGroup = new LogicalCriterion("or", clauses);
        AdvancedCriteria ac = new AdvancedCriteria("and", new Criterion[]{orGroup, new SimpleCriterion("fileType", "equals", (Object)"ds"), new SimpleCriterion("fileFormat", "equals", (Object)"xml")});
        DSRequest find = new DSRequest(req.getDataSourceName(), "listFiles");
        find.setCriteria((Object)ac);
        find.setSortBy((Object)"fileName");
        return find.execute().getDataList();
    }

    public DSResponse findNonUniqueNames(DSRequest req) throws Exception {
        List<Map> files = this.fetchMatchingFiles(req);
        ArrayList<String> fileNames = new ArrayList<String>();
        for (int i = 0; i < files.size(); ++i) {
            fileNames.add((String)files.get(i).get("fileName"));
        }
        DSResponse resp = new DSResponse();
        resp.setData(fileNames);
        return resp;
    }

    public DSResponse copyDataSource(DSRequest req) throws Exception {
        int index;
        String from = (String)req.getValues().get("fromName");
        String to = (String)req.getValues().get("toName");
        DSRequest fetch = new DSRequest(req.getDataSourceName(), "fetch");
        HashMap<String, String> criteria = new HashMap<String, String>();
        criteria.put("fileName", from);
        criteria.put("fileType", "ds");
        criteria.put("fileFormat", "xml");
        fetch.setCriteria(criteria);
        List dsRecords = fetch.execute().getDataList();
        if (dsRecords.size() == 0) {
            throw new Exception("No dataSource " + from + ".ds.xml found in fileSource DS " + req.getDataSourceName());
        }
        if (dsRecords.size() > 1) {
            throw new Exception("DataSource name " + from + ".ds.xml is not unique in fileSource DS " + req.getDataSourceName());
        }
        Map dsRecord = (Map)dsRecords.get(0);
        String contents = (String)dsRecord.get("fileContents");
        String idToken = "ID=\"";
        if (contents != null && (index = contents.indexOf(idToken)) != -1) {
            int index2 = contents.indexOf("\"", index + idToken.length());
            contents = contents.substring(0, index + idToken.length()) + to + contents.substring(index2);
            Map renameMap = (Map)req.getValues().get("renameMap");
            contents = this.remapRenamedRefs(contents, renameMap);
            dsRecord.put("fileContents", contents);
            dsRecord.put("fileSize", contents.length());
        }
        dsRecord.put("fileName", to);
        dsRecord.put("fileLastModified", new Date());
        DSRequest add = new DSRequest(req.getDataSourceName(), "add");
        add.setValues((Object)dsRecord);
        DSResponse resp = add.execute();
        DataSource fileSourceDS = req.getDataSource();
        FileSourceCaches.removeFromNegativeCache((DataSource)fileSourceDS, (String)fileSourceDS.getFullFilename(req.getValues()));
        return resp;
    }

    public DSResponse renameDataSource(DSRequest req) throws Exception {
        DSResponse resp = this.copyDataSource(req);
        String from = (String)req.getValues().get("fromName");
        DSRequest remove = new DSRequest(req.getDataSourceName(), "remove");
        HashMap<String, String> criteria = new HashMap<String, String>();
        criteria.put("fileName", from);
        criteria.put("fileType", "ds");
        criteria.put("fileFormat", "xml");
        remove.setCriteria(criteria);
        remove.execute();
        return resp;
    }

    private String remapRenamedRefs(String xml, Map<String, String> renameMap) {
        ArrayList<String> names = new ArrayList<String>(renameMap.keySet());
        names.sort(new Comparator<String>(){

            @Override
            public int compare(String o1, String o2) {
                return o2.length() - o1.length();
            }
        });
        for (int i = 0; i < names.size(); ++i) {
            String oldName = (String)names.get(i);
            String newName = renameMap.get(oldName);
            xml = this.replaceRefs(xml, "foreignKey", oldName, newName);
            xml = this.replaceRefs(xml, "includeFrom", oldName, newName);
        }
        return xml;
    }

    private String replaceRefs(String text, String propName, String oldRef, String newRef) {
        String searchString = propName + "=\"";
        int startIndex = 0;
        while (startIndex != -1) {
            int endIndex;
            if ((startIndex = text.indexOf(searchString, startIndex)) == -1 || (endIndex = text.indexOf(34, startIndex += searchString.length())) == -1) continue;
            String propVal = text.substring(startIndex, endIndex);
            int oldPropLength = propVal.length();
            propVal = propVal.replace(oldRef + ".", newRef + ".");
            int lengthDelta = propVal.length() - oldPropLength;
            text = text.substring(0, startIndex) + propVal + text.substring(startIndex + oldPropLength);
            startIndex += oldPropLength + lengthDelta;
        }
        return text;
    }

    public DSResponse importDataSourceWithRename(DSRequest req) throws Exception {
        Config cfg = Config.getGlobal();
        String dir = cfg.getString((Object)"toolsDir") + "/visualBuilder/sampleDS/";
        String fileName = (String)req.getFieldValue((Object)"baseName");
        final String importName = (String)req.getFieldValue((Object)"importAsName");
        String ext = ".ds.xml";
        String path = ISCFile.canonicalizePath((String)(dir + fileName + ext));
        String contents = FileUtils.readFileToString((File)FileUtils.getFile((String[])new String[]{path}), (Charset)StandardCharsets.UTF_8);
        String idToken = "ID=\"";
        if (contents != null) {
            int index = contents.indexOf(idToken);
            if (index != -1) {
                int index2 = contents.indexOf("\"", index + idToken.length());
                contents = contents.substring(0, index + idToken.length()) + importName + contents.substring(index2);
            }
            Map renameMap = (Map)req.getValues().get("renameMap");
            contents = this.remapRenamedRefs(contents, renameMap);
        }
        final AuthenticatedUser user = (AuthenticatedUser)Authentication.getUser((RequestContext)req.getRequestContext());
        final String finalContents = contents;
        DSRequest writer = new DSRequest(req.getDataSourceName(), "add");
        writer.setValues((Object)new HashMap(){
            {
                this.put("fileName", importName);
                this.put("fileType", "ds");
                this.put("fileFormat", "xml");
                this.put("fileContents", finalContents);
                this.put("fileLastModified", new Date());
                this.put("fileSize", finalContents == null ? 0 : finalContents.getBytes().length);
                this.put("ownerId", user == null ? null : user.getName());
            }
        });
        DSResponse resp = writer.execute();
        DataSource fileSourceDS = writer.getDataSource();
        FileSourceCaches.removeFromNegativeCache((DataSource)fileSourceDS, (String)fileSourceDS.getFullFilename(writer.getValues()));
        return resp;
    }
}

