<#-- @ftlvariable name="ds" type="java.util.Map" -->
<#import "datasource-utils.ftl" as u>

<#--
components:
-->
<#--
  schemas:
-->
<#macro record>

    ${ds.id}:
      title: ${ds.title ! ds.id} Record
      type: object
      xml:
        name: record
      properties:
      <#list ds.fields as field>
        ${field.name}:
          <@u.fielddef indentation=10 field=field />
      </#list>
</#macro>

<#macro request operation prefix='${ds.id}'>
    ${prefix}RequestBodyModel:
      type: object
      xml:
        name: request
      properties:
        <#-- dataSource & operationId ommitted, as they are derived from the path  -->
        operationType:
          type: string
          description: |
            Type of operation being performed: 'fetch', 'add', 'remove', 'update' or 'custom'.
          enum: [fetch, add, update, remove, custom]
        startRow:
          type: integer
          description: |
            Starting row of requested results, used only with fetch operations. If unset, 0 is assumed.  Note that startRow and endRow are zero-based, inclusive at the beginning and exclusive at the end (like substring), so startRow=0&endRow=1 is a request for the first record.
        endRow:
          type: integer
          description: |
            End row of requested results, used only with fetch operations. Note that startRow and endRow are zero-based, inclusive at the beginning and exclusive at the end (like substring), so startRow=0&endRow=1 is a request for the first record.
        data:
          oneOf:
            - $ref: '#/components/schemas/AdvancedCriteria'
          description: |
            Data, such as search criteria or an updated record, to be used by the given operation. Contents differ by operationType:
              - **fetch**: Filter criteria, as an Object
              - **add**: New record, as an Object
              - **update**: Primary keys of record to update, and new values (or just complete updated record), as an Object
              - **remove**: Primary keys of record to delete, as an Object
              - **custom**: Whatever the custom operation requires

</#macro>

<#macro response operation>
  <#local prefix = operation.hasCustomOutput?then(operation.uid, '') />
    ${prefix}ResponseBodyModel:
      title: ${prefix}ResponseBodyModel
      type: object
      properties:
        response:
          type: object
          properties:
            affectedRows:
              type: integer
            status:
              type: integer
            queueStatus:
              type: integer
            startRow:
              type: integer
            endRow:
              type: integer
            totalRows:
              type: integer
            data:
              type: array
              nullable: true
              xml:
                wrapped: true
              items:
                type: object
                xml:
                  name: record
                properties:
                <#list operation.outputs as field>
                  ${field.name}:
                    <@u.describe indentation=34 field=field operation=operation context="response"/>
                    <@u.fielddef indentation=34 field=field />
                </#list>
            relatedUpdates:
              type: array
              items:
                $ref: '#/components/schemas/${prefix}ResponseBodyModel'


</#macro>

<#macro criteria op prefix=''>
  <#local title = prefix + 'Criteria' />
    ${title}:
      title: ${title}
      type: object
      required:
        - fieldName
        - operator
      properties:
        fieldName:
          description: Name of the field in each Record that this criterion applies to.
          type: string
        <#if op??>
          enum:
          <#list op.parameters as field>
            - ${field.name}
          </#list>
        </#if>
        operator:
          $ref: "#/components/schemas/Operator"
        value:
          description: Value to be used in the application of this criteria. Value may be required or not required, or may be an Array, according to the OperatorValueType of the operator.
        start:
          description: Start value of a criterion with an operator of type "valueRange".
          type: integer
        end:
          description: End value of a criterion with an operator of type "valueRange".
          type: integer
</#macro>

<#macro criterion op prefix=''>
    <#local title = prefix + 'Criterion' />
    ${title}:
      title: ${title}
      type: object
      required:
        - fieldName
        - operator
      properties:
        criteria:
          description: For a criterion with an operator that acts on other criteria (eg "and", "or"), a list of sub-criteria that are grouped together by the operator.
          type: array
          items:
            $ref: "#/components/schemas/${title}"
        fieldName:
          description: Name of the field in each Record that this criterion applies to.
          type: string
        <#if op??>
          enum:
          <#list op.parameters as field>
            - ${field.name}
          </#list>
        </#if>
        operator:
          $ref: "#/components/schemas/Operator"
        value:
          description: Value to be used in the application of this criterion. Value may be required or not required, or may be an Array, according to the OperatorValueType of the operator.
        start:
          description: Start value of a criterion with an operator of type "valueRange".
          type: integer
        end:
          description: End value of a criterion with an operator of type "valueRange".
          type: integer
</#macro>

<#macro advancedCriteria op prefix=''>
  <#local title = prefix + 'AdvancedCriteria' />
    ${title}:
      title: ${title}
      description: |
        A format for representing search criteria which may include operators on field values such as "less than", or
        may include sub-clauses such as several criteria applied to fields joined by an "OR" operator.
      type: object
      required:
        - _constructor
        - operator
        - criteria
      properties:
        _constructor:
          type: string
          enum:
            - AdvancedCriteria
        operator:
          type: string
          enum: [and, or]
        criteria:
          type: array
          items:
            $ref: "#/components/schemas/${prefix + 'Criterion'}"

      example:
        {
          "_constructor": "AdvancedCriteria",
          "operator": "and",
          "criteria": [
            { "fieldName": "salary", "operator": "lessThan", "value": 80000 },
            { "operator": "or", "criteria" : [
                  { "fieldName": "title", "operator": "iContains", "value": "Manager" },
                  { "fieldName": "reports", "operator": "notNull" }
              ]
            },
            { "fieldName": "startDate", "operator": "greaterThan", "value": "2018-03-20"}
          ]
        }
</#macro>

<#macro errorModel>
    ErrorModel:
      title: Error Object
      description: |
        When an error HTTP status (4XX or 5XX) is returned from the server, there will be an error object included.
        It will contain an error code and an array of error messages (even if there's just one message).
      type: object
      properties:
        code:
          type: number
        messages:
          type: array
          items:
            $ref: "#/components/schemas/ErrorMessage"
</#macro>

<#macro errorMessage>
    ErrorMessage:
      description: A short description of what went wrong
      type: object
      properties:
        message:
          type: string
</#macro>

<#macro operator>
    Operator:
      description: |
        An operator is used as part of a Criterion when specifying AdvancedCriteria.  This list of operators indicates the set of operators built into SmartClient DataSources, which can be used for both client and server-side filtering

        * equals: exactly equal to
        * notEqual: not equal to
        * iEquals: exactly equal to, if case is disregarded
        * iNotEqual: not equal to, if case is disregarded
        * greaterThan: Greater than
        * lessThan: Less than. Note that null is treated as equivalent to an arbitrarily small value, so null field values will always be returned by lessThan / lessOrEqual filter operations by default.
        * greaterOrEqual: Greater than or equal to
        * lessOrEqual: Less than or equal to
        * contains: Contains as sub-string (match case)
        * startsWith: Starts with (match case)
        * endsWith: Ends with (match case)
        * iContains: Contains as sub-string (case insensitive)
        * iStartsWith: Starts with (case insensitive)
        * iEndsWith: Ends with (case insensitive)
        * notContains: Does not contain as sub-string (match case)
        * notStartsWith: Does not start with (match case)
        * notEndsWith: Does not end with (match case)
        * iNotContains: Does not contain as sub-string (case insensitive)
        * iNotStartsWith: Does not start with (case insensitive)
        * iNotEndsWith: Does not end with (case insensitive)
        * iBetween: shortcut for "greaterThan" + "and" + "lessThan" (case insensitive)
        * iBetweenInclusive: shortcut for "greaterOrEqual" + "and" + "lessOrEqual" (case insensitive)
        * matchesPattern: Basic GLOB matching using wildcards (see DataSource.translatePatternOperators for more information on available patterns)
        * iMatchesPattern: Basic GLOB matching using wildcards (case insensitive) (see DataSource.translatePatternOperators for more information on available patterns)
        * containsPattern: GLOB matching using wildcards. Value is considered to meet the criterion if it contains the pattern. See DataSource.translatePatternOperators for more information on available patterns)
        * startsWithPattern: GLOB mathcing using wildcards. Value is considered to meet the criterion if it starts with the pattern.See DataSource.translatePatternOperators for more information on available patterns)
        * endsWithPattern: GLOB mathcing using wildcards. Value is considered to meet the criterion if it starts with the pattern.See DataSource.translatePatternOperators for more information on available patterns)
        * iContainsPattern: GLOB matching using wildcards. Value is considered to meet the criterion if it contains the pattern. Matching is case insensitive. See DataSource.translatePatternOperators for more information on available patterns)
        * iStartsWithPattern: GLOB matching using wildcards. Value is considered to meet the criterion if it starts with the pattern. Matching is case insensitive.See DataSource.translatePatternOperators for more information on available patterns)
        * iEndsWithPattern: GLOB matching using wildcards.Value is considered to meet the criterion if it ends with the pattern. Matching is case insensitive. See DataSource.translatePatternOperators for more information on available patterns)
        * regexp: Regular expression match
        * iregexp: Regular expression match (case insensitive)
        * isBlank: value is either null or the empty string. For numeric fields it behaves as isNull
        * notBlank: value is neither null nor the empty string ("")
        * isNull: value is null
        * notNull: value is non-null. Note empty string ("") is non-null
        * inSet: value is in a set of values. Specify criterion.value as an Array
        * notInSet: value is not in a set of values. Specify criterion.value as an Array
        * equalsField: matches another field (match case, specify fieldName as criterion.value)
        * notEqualField: does not match another field (match case, specify fieldName as criterion.value)
        * iEqualsField: matches another field (case insensitive, specify fieldName as criterion.value)
        * iNotEqualField: does not match another field (case insensitive, specify fieldName as criterion.value)
        * greaterThanField: Greater than another field (specify fieldName as criterion.value)
        * lessThanField: Less than another field (specify fieldName as criterion.value)
        * greaterOrEqualField: Greater than or equal to another field (specify fieldName as criterion.value)
        * lessOrEqualField:  Less than or equal to another field (specify fieldName as criterion.value)
        * containsField: Contains as sub-string (match case) another field value (specify fieldName as criterion.value)
        * startsWithField: Starts with (match case) another field value (specify fieldName as criterion.value)
        * endsWithField: Ends with (match case) another field value (specify fieldName as criterion.value)
        * iContainsField: Contains as sub-string (case insensitive) another field value (specify fieldName as criterion.value)
        * iStartsWithField: Starts with (case insensitive) another field value (specify fieldName as criterion.value)
        * iEndsWithField: Ends with (case insensitive) another field value (specify fieldName as criterion.value)
        * notContainsField: Does not contain as sub-string (match case) another field value (specify fieldName as criterion.value)
        * notStartsWithField: Does not start with (match case) another field value (specify fieldName as criterion.value)
        * notEndsWithField: Does not end with (match case) another field value (specify fieldName as criterion.value)
        * iNotContainsField: Does not contain as sub-string (case insensitive) another field value (specify fieldName as criterion.value)
        * iNotStartsWithField: Does not start with (case insensitive) another field value (specify fieldName as criterion.value)
        * iNotEndsWithField: Does not end with (case insensitive) another field value (specify fieldName as criterion.value)
        * and: all subcriteria (criterion.criteria) are true
        * not: all subcriteria (criterion.criteria) are false
        * or: at least one subcriteria (criterion.criteria) is true
        * between: shortcut for "greaterThan" + "lessThan" + "and". Specify criterion.start and criterion.end
        * betweenInclusive: shortcut for "greaterOrEqual" + "lessOrEqual" + "and". Specify criterion.start and criterion.end
      type: string
      enum:
        - equals
        - notEqual
        - iEquals
        - iNotEqual
        - greaterThan
        - lessThan
        - greaterOrEqual
        - lessOrEqual
        - contains
        - startsWith
        - endsWith
        - iContains
        - iStartsWith
        - iEndsWith
        - notContains
        - notStartsWith
        - notEndsWith
        - iNotContains
        - iNotStartsWith
        - iNotEndsWith
        - iBetween
        - iBetweenInclusive
        - matchesPattern
        - iMatchesPattern
        - containsPattern
        - startsWithPattern
        - endsWithPattern
        - iContainsPattern
        - iStartsWithPattern
        - iEndsWithPattern
        - regexp
        - iregexp
        - isBlank
        - notBlank
        - isNull
        - notNull
        - inSet
        - notInSet
        - equalsField
        - notEqualField
        - iEqualsField
        - iNotEqualField
        - greaterThanField
        - lessThanField
        - greaterOrEqualField
        - lessOrEqualField
        - containsField
        - startsWithField
        - endsWithField
        - iContainsField
        - iStartsWithField
        - iEndsWithField
        - notContainsField
        - notStartsWithField
        - notEndsWithField
        - iNotContainsField
        - iNotStartsWithField
        - iNotEndsWithField
        - and
        - not
        - or
        - between
        - betweenInclusive
</#macro>
