/*
 * Decompiled with CFR 0.152.
 */
package sun.security.ssl;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.security.Principal;
import java.security.PrivateKey;
import java.security.SecureRandom;
import java.security.cert.Certificate;
import java.security.cert.CertificateEncodingException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.List;
import java.util.Vector;
import javax.crypto.SecretKey;
import javax.net.ssl.ExtendedSSLSession;
import javax.net.ssl.SNIServerName;
import javax.net.ssl.SSLPeerUnverifiedException;
import javax.net.ssl.SSLPermission;
import javax.net.ssl.SSLSessionBindingEvent;
import javax.net.ssl.SSLSessionBindingListener;
import javax.net.ssl.SSLSessionContext;
import javax.security.cert.CertificateException;
import javax.security.cert.X509Certificate;
import sun.security.ssl.CipherSuite;
import sun.security.ssl.Debug;
import sun.security.ssl.ProtocolVersion;
import sun.security.ssl.SSLSessionContextImpl;
import sun.security.ssl.SecureKey;
import sun.security.ssl.SessionId;
import sun.security.ssl.SignatureAndHashAlgorithm;

final class SSLSessionImpl
extends ExtendedSSLSession {
    static final SSLSessionImpl nullSession = new SSLSessionImpl();
    private static final byte compression_null = 0;
    private final ProtocolVersion protocolVersion;
    private final SessionId sessionId;
    private java.security.cert.X509Certificate[] peerCerts;
    private byte compressionMethod;
    private CipherSuite cipherSuite;
    private SecretKey masterSecret;
    private final long creationTime = System.currentTimeMillis();
    private long lastUsedTime = 0L;
    private final String host;
    private final int port;
    private SSLSessionContextImpl context;
    private int sessionCount;
    private boolean invalidated;
    private java.security.cert.X509Certificate[] localCerts;
    private PrivateKey localPrivateKey;
    private String[] localSupportedSignAlgs;
    private String[] peerSupportedSignAlgs;
    private List<SNIServerName> requestedServerNames;
    private Principal peerPrincipal;
    private Principal localPrincipal;
    private static volatile int counter = 0;
    private static boolean defaultRejoinable = true;
    private static final Debug debug = Debug.getInstance("ssl");
    private Hashtable<SecureKey, Object> table = new Hashtable();
    private boolean acceptLargeFragments = Debug.getBooleanProperty("jsse.SSLEngine.acceptLargeFragments", false);

    private SSLSessionImpl() {
        this(ProtocolVersion.NONE, CipherSuite.C_NULL, null, new SessionId(false, null), null, -1);
    }

    SSLSessionImpl(ProtocolVersion protocolVersion, CipherSuite cipherSuite, Collection<SignatureAndHashAlgorithm> collection, SecureRandom secureRandom, String string, int n) {
        this(protocolVersion, cipherSuite, collection, new SessionId(defaultRejoinable, secureRandom), string, n);
    }

    SSLSessionImpl(ProtocolVersion protocolVersion, CipherSuite cipherSuite, Collection<SignatureAndHashAlgorithm> collection, SessionId sessionId, String string, int n) {
        this.protocolVersion = protocolVersion;
        this.sessionId = sessionId;
        this.peerCerts = null;
        this.compressionMethod = 0;
        this.cipherSuite = cipherSuite;
        this.masterSecret = null;
        this.host = string;
        this.port = n;
        this.sessionCount = ++counter;
        this.localSupportedSignAlgs = SignatureAndHashAlgorithm.getAlgorithmNames(collection);
        if (debug != null && Debug.isOn("session")) {
            System.out.println("%% Initialized:  " + this);
        }
    }

    void setMasterSecret(SecretKey secretKey) {
        if (this.masterSecret != null) {
            throw new RuntimeException("setMasterSecret() error");
        }
        this.masterSecret = secretKey;
    }

    SecretKey getMasterSecret() {
        return this.masterSecret;
    }

    void setPeerCertificates(java.security.cert.X509Certificate[] x509CertificateArray) {
        if (this.peerCerts == null) {
            this.peerCerts = x509CertificateArray;
        }
    }

    void setLocalCertificates(java.security.cert.X509Certificate[] x509CertificateArray) {
        this.localCerts = x509CertificateArray;
    }

    void setLocalPrivateKey(PrivateKey privateKey) {
        this.localPrivateKey = privateKey;
    }

    void setPeerSupportedSignatureAlgorithms(Collection<SignatureAndHashAlgorithm> collection) {
        this.peerSupportedSignAlgs = SignatureAndHashAlgorithm.getAlgorithmNames(collection);
    }

    void setRequestedServerNames(List<SNIServerName> list) {
        this.requestedServerNames = new ArrayList<SNIServerName>(list);
    }

    void setPeerPrincipal(Principal principal) {
        if (this.peerPrincipal == null) {
            this.peerPrincipal = principal;
        }
    }

    void setLocalPrincipal(Principal principal) {
        this.localPrincipal = principal;
    }

    boolean isRejoinable() {
        return this.sessionId != null && this.sessionId.length() != 0 && !this.invalidated && this.isLocalAuthenticationValid();
    }

    @Override
    public synchronized boolean isValid() {
        return this.isRejoinable();
    }

    boolean isLocalAuthenticationValid() {
        if (this.localPrivateKey != null) {
            try {
                this.localPrivateKey.getAlgorithm();
            }
            catch (Exception exception) {
                this.invalidate();
                return false;
            }
        }
        return true;
    }

    @Override
    public byte[] getId() {
        return this.sessionId.getId();
    }

    @Override
    public SSLSessionContext getSessionContext() {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkPermission(new SSLPermission("getSSLSessionContext"));
        }
        return this.context;
    }

    SessionId getSessionId() {
        return this.sessionId;
    }

    CipherSuite getSuite() {
        return this.cipherSuite;
    }

    void setSuite(CipherSuite cipherSuite) {
        this.cipherSuite = cipherSuite;
        if (debug != null && Debug.isOn("session")) {
            System.out.println("%% Negotiating:  " + this);
        }
    }

    @Override
    public String getCipherSuite() {
        return this.getSuite().name;
    }

    ProtocolVersion getProtocolVersion() {
        return this.protocolVersion;
    }

    @Override
    public String getProtocol() {
        return this.getProtocolVersion().name;
    }

    byte getCompression() {
        return this.compressionMethod;
    }

    public int hashCode() {
        return this.sessionId.hashCode();
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object instanceof SSLSessionImpl) {
            SSLSessionImpl sSLSessionImpl = (SSLSessionImpl)object;
            return this.sessionId != null && this.sessionId.equals(sSLSessionImpl.getSessionId());
        }
        return false;
    }

    @Override
    public Certificate[] getPeerCertificates() throws SSLPeerUnverifiedException {
        if (this.cipherSuite.keyExchange == CipherSuite.KeyExchange.K_KRB5 || this.cipherSuite.keyExchange == CipherSuite.KeyExchange.K_KRB5_EXPORT) {
            throw new SSLPeerUnverifiedException("no certificates expected for Kerberos cipher suites");
        }
        if (this.peerCerts == null) {
            throw new SSLPeerUnverifiedException("peer not authenticated");
        }
        return (Certificate[])this.peerCerts.clone();
    }

    @Override
    public Certificate[] getLocalCertificates() {
        return this.localCerts == null ? null : (Certificate[])this.localCerts.clone();
    }

    @Override
    public X509Certificate[] getPeerCertificateChain() throws SSLPeerUnverifiedException {
        if (this.cipherSuite.keyExchange == CipherSuite.KeyExchange.K_KRB5 || this.cipherSuite.keyExchange == CipherSuite.KeyExchange.K_KRB5_EXPORT) {
            throw new SSLPeerUnverifiedException("no certificates expected for Kerberos cipher suites");
        }
        if (this.peerCerts == null) {
            throw new SSLPeerUnverifiedException("peer not authenticated");
        }
        X509Certificate[] x509CertificateArray = new X509Certificate[this.peerCerts.length];
        for (int i = 0; i < this.peerCerts.length; ++i) {
            byte[] byArray = null;
            try {
                byArray = this.peerCerts[i].getEncoded();
                x509CertificateArray[i] = X509Certificate.getInstance(byArray);
                continue;
            }
            catch (CertificateEncodingException certificateEncodingException) {
                throw new SSLPeerUnverifiedException(certificateEncodingException.getMessage());
            }
            catch (CertificateException certificateException) {
                throw new SSLPeerUnverifiedException(certificateException.getMessage());
            }
        }
        return x509CertificateArray;
    }

    public java.security.cert.X509Certificate[] getCertificateChain() throws SSLPeerUnverifiedException {
        if (this.cipherSuite.keyExchange == CipherSuite.KeyExchange.K_KRB5 || this.cipherSuite.keyExchange == CipherSuite.KeyExchange.K_KRB5_EXPORT) {
            throw new SSLPeerUnverifiedException("no certificates expected for Kerberos cipher suites");
        }
        if (this.peerCerts != null) {
            return (java.security.cert.X509Certificate[])this.peerCerts.clone();
        }
        throw new SSLPeerUnverifiedException("peer not authenticated");
    }

    @Override
    public Principal getPeerPrincipal() throws SSLPeerUnverifiedException {
        if (this.cipherSuite.keyExchange == CipherSuite.KeyExchange.K_KRB5 || this.cipherSuite.keyExchange == CipherSuite.KeyExchange.K_KRB5_EXPORT) {
            if (this.peerPrincipal == null) {
                throw new SSLPeerUnverifiedException("peer not authenticated");
            }
            return this.peerPrincipal;
        }
        if (this.peerCerts == null) {
            throw new SSLPeerUnverifiedException("peer not authenticated");
        }
        return this.peerCerts[0].getSubjectX500Principal();
    }

    @Override
    public Principal getLocalPrincipal() {
        if (this.cipherSuite.keyExchange == CipherSuite.KeyExchange.K_KRB5 || this.cipherSuite.keyExchange == CipherSuite.KeyExchange.K_KRB5_EXPORT) {
            return this.localPrincipal == null ? null : this.localPrincipal;
        }
        return this.localCerts == null ? null : this.localCerts[0].getSubjectX500Principal();
    }

    @Override
    public long getCreationTime() {
        return this.creationTime;
    }

    @Override
    public long getLastAccessedTime() {
        return this.lastUsedTime != 0L ? this.lastUsedTime : this.creationTime;
    }

    void setLastAccessedTime(long l) {
        this.lastUsedTime = l;
    }

    public InetAddress getPeerAddress() {
        try {
            return InetAddress.getByName(this.host);
        }
        catch (UnknownHostException unknownHostException) {
            return null;
        }
    }

    @Override
    public String getPeerHost() {
        return this.host;
    }

    @Override
    public int getPeerPort() {
        return this.port;
    }

    void setContext(SSLSessionContextImpl sSLSessionContextImpl) {
        if (this.context == null) {
            this.context = sSLSessionContextImpl;
        }
    }

    @Override
    public synchronized void invalidate() {
        if (this == nullSession) {
            return;
        }
        this.invalidated = true;
        if (debug != null && Debug.isOn("session")) {
            System.out.println("%% Invalidated:  " + this);
        }
        if (this.context != null) {
            this.context.remove(this.sessionId);
            this.context = null;
        }
    }

    @Override
    public void putValue(String string, Object object) {
        SSLSessionBindingEvent sSLSessionBindingEvent;
        if (string == null || object == null) {
            throw new IllegalArgumentException("arguments can not be null");
        }
        SecureKey secureKey = new SecureKey(string);
        Object object2 = this.table.put(secureKey, object);
        if (object2 instanceof SSLSessionBindingListener) {
            sSLSessionBindingEvent = new SSLSessionBindingEvent(this, string);
            ((SSLSessionBindingListener)object2).valueUnbound(sSLSessionBindingEvent);
        }
        if (object instanceof SSLSessionBindingListener) {
            sSLSessionBindingEvent = new SSLSessionBindingEvent(this, string);
            ((SSLSessionBindingListener)object).valueBound(sSLSessionBindingEvent);
        }
    }

    @Override
    public Object getValue(String string) {
        if (string == null) {
            throw new IllegalArgumentException("argument can not be null");
        }
        SecureKey secureKey = new SecureKey(string);
        return this.table.get(secureKey);
    }

    @Override
    public void removeValue(String string) {
        if (string == null) {
            throw new IllegalArgumentException("argument can not be null");
        }
        SecureKey secureKey = new SecureKey(string);
        Object object = this.table.remove(secureKey);
        if (object instanceof SSLSessionBindingListener) {
            SSLSessionBindingEvent sSLSessionBindingEvent = new SSLSessionBindingEvent(this, string);
            ((SSLSessionBindingListener)object).valueUnbound(sSLSessionBindingEvent);
        }
    }

    @Override
    public String[] getValueNames() {
        Vector<Object> vector = new Vector<Object>();
        Object object = SecureKey.getCurrentSecurityContext();
        Enumeration<SecureKey> enumeration = this.table.keys();
        while (enumeration.hasMoreElements()) {
            SecureKey secureKey = enumeration.nextElement();
            if (!object.equals(secureKey.getSecurityContext())) continue;
            vector.addElement(secureKey.getAppKey());
        }
        Object[] objectArray = new String[vector.size()];
        vector.copyInto(objectArray);
        return objectArray;
    }

    protected synchronized void expandBufferSizes() {
        this.acceptLargeFragments = true;
    }

    @Override
    public synchronized int getPacketBufferSize() {
        return this.acceptLargeFragments ? 33305 : 16921;
    }

    @Override
    public synchronized int getApplicationBufferSize() {
        return this.getPacketBufferSize() - 5;
    }

    @Override
    public String[] getLocalSupportedSignatureAlgorithms() {
        if (this.localSupportedSignAlgs != null) {
            return (String[])this.localSupportedSignAlgs.clone();
        }
        return new String[0];
    }

    @Override
    public String[] getPeerSupportedSignatureAlgorithms() {
        if (this.peerSupportedSignAlgs != null) {
            return (String[])this.peerSupportedSignAlgs.clone();
        }
        return new String[0];
    }

    @Override
    public List<SNIServerName> getRequestedServerNames() {
        if (this.requestedServerNames != null && !this.requestedServerNames.isEmpty()) {
            return Collections.unmodifiableList(this.requestedServerNames);
        }
        return Collections.emptyList();
    }

    public String toString() {
        return "[Session-" + this.sessionCount + ", " + this.getCipherSuite() + "]";
    }

    protected void finalize() throws Throwable {
        String[] stringArray = this.getValueNames();
        for (int i = 0; i < stringArray.length; ++i) {
            this.removeValue(stringArray[i]);
        }
    }
}

