/*

  SmartClient Ajax RIA system
  Version v13.1p_2026-01-29/LGPL Deployment (2026-01-29)

  Copyright 2000 and beyond Isomorphic Software, Inc. All rights reserved.
  "SmartClient" is a trademark of Isomorphic Software, Inc.

  LICENSE NOTICE
     INSTALLATION OR USE OF THIS SOFTWARE INDICATES YOUR ACCEPTANCE OF
     ISOMORPHIC SOFTWARE LICENSE TERMS. If you have received this file
     without an accompanying Isomorphic Software license file, please
     contact licensing@isomorphic.com for details. Unauthorized copying and
     use of this software is a violation of international copyright law.

  DEVELOPMENT ONLY - DO NOT DEPLOY
     This software is provided for evaluation, training, and development
     purposes only. It may include supplementary components that are not
     licensed for deployment. The separate DEPLOY package for this release
     contains SmartClient components that are licensed for deployment.

  PROPRIETARY & PROTECTED MATERIAL
     This software contains proprietary materials that are protected by
     contract and intellectual property law. You are expressly prohibited
     from attempting to reverse engineer this software or modify this
     software for human readability.

  CONTACT ISOMORPHIC
     For more information regarding license rights and restrictions, or to
     report possible license violations, please contact Isomorphic Software
     by email (licensing@isomorphic.com) or web (www.isomorphic.com).

*/
// This is an implementation of a Shuttle interface: https://download.oracle.com/tech/blaf/specs/shuttle.html
// Used for the "Shuttle" view of the MultiPickerItem

isc.defineClass("Shuttle", "HLayout");
isc.Shuttle.addProperties({


    
    


    


    


    
    


     
    getValueFieldName : function () {
        var valueField = this.valueField;
        if (valueField == null && this.dataSource) {
            valueField = this.getDataSource().getPrimaryKeyFieldName();
        }
        if (valueField == null && !this._warnedOnMissingValueField) {
            this.logWarn("Shuttle requires either an explicit valueField or a dataSource with a primary key field");
            this._warnedOnMissingValueField = true;
        }
        return valueField
    },


    


    


    


    



    


    


    


    
    setImplicitCriteria : function (criteria) {
        this.implicitCriteria = criteria;
        this.updateGrids();
    },

    // Getter for the implicit criteria
    getImplicitCriteria : function () {
        return this.implicitCriteria;
    },
    


    
    sourceGridConstructor:"ListGrid",
    sourceGridDefaults:{

        isGroup:true,
        showFilterEditor:true,

        dragDataAction:"none",
        canDragRecordsOut:true,
        canAcceptDroppedRecords:true,
        canReorderRecords:false,
        recordDrop : function (dropRecords, targetRecord, index, sourceWidget) {
            if (sourceWidget == this.creator.targetGrid) {
                this.creator.deselectRecords(dropRecords, true);
            } else {
                return this.Super("recordDrop", arguments);
            }
        }
        
    },


    
    
    targetGridConstructor:"ListGrid",
    targetGridDefaults:{

        isGroup:true,

        // We're not getting our data from the DS so don't show the filterEditor by default
        
        canShowFilterEditor:false,

        dragDataAction:"none",
        canDragRecordsOut:true,
        canAcceptDroppedRecords:true,
        canReorderRecords:false,
        recordDrop : function (dropRecords, targetRecord, index, sourceWidget) {
            if (sourceWidget == this.creator.sourceGrid) {
                this.creator.selectRecords(dropRecords, true);
            } else {
                return this.Super("recordDrop", arguments);
            }
        }
    },


    
    sourceGridTitle:"Unselected Values",


    
    targetGridTitle:"Selected Values",
    


    
    
    selectRecords : function (records, fireSelectionChanged) {
        if (records == null) return;

        if (this.selectedRecords == null) {
            this.selectedRecords = [];
        }
        
        var valueField = this.getValueFieldName();
        for (var i = 0; i < records.length; i++) {
            var record = records[i],
                value = record[valueField];

            // If we have any outstanding fetch marked for a target
            // record's value, we can clean this up now
            
            this._clearFetchingValue(value);

            // Avoid duplicates - if we already have a record
            // in the target-data array with the same value, replace it
            var index = this.selectedRecords.findIndex(valueField, value);
            if (index == -1) index = this.selectedRecords.length;
            this.selectedRecords.set(index, record); // array.set will cause dataChanged to fire so the grid will refresh!

        }
        this.updateGrids();
        if (fireSelectionChanged) this.selectionUpdated();
    },


            
    deselectRecords : function (records, fireSelectionChanged) {
        if (records == null) return;

        if (this.selectedRecords == null) {
            this.selectedRecords = [];
        }
        this.selectedRecords.removeList(records);

        // If we have any outstanding fetch marked for a target
        // record's value, we can clean this up now - the 
        // value is no longer logically selected.
        var valueField = this.getValueFieldName();
        for (var i = 0; i < records.length; i++) {
            var value = records[valueField];
            this._clearFetchingValue(value);
        }

        this.updateGrids();
        if (fireSelectionChanged) this.selectionUpdated();
    },


    
    clearSelection : function (fireSelectionChanged) {
        var targetGrid = this.targetGrid;
        var records = targetGrid.data.getRange(0, targetGrid.getTotalRows());
        this.deselectRecords(records, fireSelectionChanged);
        // Invalidate any outstanding values-fetches
        delete this._pendingFetchValues;
    },


    
    selectionUpdated : function () {

    },


    
    
    setSelectedByValue : function (value, add) {
        if (value == null || value.length == 0) {
            return;
        }
        // We may issue 2 fetches here - one 'notInSet' to exclude things from the source grid
        // and one inSet to pick up unrecognized values for the target grid
        var wasQueuing = isc.RPCManager.startQueue()

        // Note: The records may not be present in the source or target grid data
        // due to filter criteria, a pending fetch or data paging
        var originalValue = value;
        value = value.duplicate();
        var valueField = this.getValueFieldName();
        // Adding to selection
        // - find the record(s) in our source grid and select them
        // - if we can't find them, we have to perform a fetch in order to show them
        //   in the target grid
        if (add) {

            if (this.targetGrid.data) {
                // remove any duplicates!
                for (var i = 0; i < value.length; i++) {
                    if (this.targetGrid.data.find(valueField, value[i])) {
                        value[i] = null;
                    }
                }
                value.removeEmpty();
            }
            // Already selected? We're done!
            if (value.length == 0) {
                if (!wasQueuing) isc.RPCManager.sendQueue();
                return;
            }
            
            var mustFetch = !this.sourceGrid.data || !this.sourceGrid.data.lengthIsKnown || 
                            !this.sourceGrid.data.lengthIsKnown(),
                records = [];

            if (!mustFetch) {
                var dataSet = this.sourceGrid.data;
                // If we have an 'allRows' cache, reach directly into it to avoid
                // extra fetches for a value that is currently filtered out of view!
                var cache = dataSet.allRows;// || dataSet.localData;
                if (cache != null) dataSet = cache;

                for (var i = 0; i < value.length; i++) {
                    var sourceRecord = dataSet.find(valueField, value[i]);
                    if (sourceRecord != null) {
                        records.add(isc.addProperties({},sourceRecord));
                        value[i] = null;
                    }
                }
                if (records.length != value.length) {
                    mustFetch = true;
                }
            }
            if (records.length > 0) {
                this.selectRecords(records);
            }
            // If there were some values for which we couldn't
            // find records, we need to fetch them to display
            // them in the "target grid"
            
            if (mustFetch) {

                for (var i = 0; i < value.length; i++) {
                    if (this.valuesFetchInProgress(value)) value[i] = null;
                }

                value.removeEmpty();
                if (value.length > 0) {

                    this._addToFetchingValues(value);

                    var dsRequest = {clientContext:{requestedValues:value}};
                    if (this.filterContext) isc.addProperties(dsRequest, this.filterContext);
                    if (this.fetchOperation != null) dsRequest.operationId = this.fetchOperation;
                    if (this.textMatchStyle != null) dsRequest.textMatchStyle = this.textMatchStyle;

                    var missingRecordCriteria = this.getDataSource().combineCriteria(
                                                    this.getImplicitCriteria(), 
                                                    {operator:"inSet", fieldName:valueField, value:value},
                                                    "and",
                                                    this.textMatchStyle
                                                );
                    this.getDataSource().fetchData(
                        missingRecordCriteria, 
                        {
                            target:this, methodName:"fetchMissingValuesForSelectionReply"
                        },
                        dsRequest
                    );
                }
            }

        // We're deselecting value(s). Remove from the
        // target grid and update criteria on the source grid.
        } else {
            var criteriaRecords = [];
            var data = this.targetGrid.data || [];

            for (var i = 0; i < value.length; i++) {
                // If we have an outstanding fetch for this value's record
                // ignore it
                this._clearFetchingValue(value);

                var record = data.find(valueField, value[i]);
                if (record != null) {
                    criteriaRecords.add(record);
                } else {
                    // We don't need a true record to update the source grid's criteria!
                    record = {};
                    record[valueField] = value[i];
                    criteriaRecords.add(record);
                }
            }

            
            this.deselectRecords(criteriaRecords);
        }   
        if (!wasQueuing) isc.RPCManager.sendQueue();
    },
    addMissingPlaceholders:true,
    missingPlaceholderAttribute:"_isMissingPlaceholder",

    // notification when we've fetched records thanks to 'setSelectedByValue()' with an
    // unknown value.
    fetchMissingValuesForSelectionReply : function (dsResponse, data, dsRequest) {
        var requestedValues = dsRequest.clientContext.requestedValues,
            hasActiveValue = false;
        var valueField = this.getValueFieldName();
        for (var i = 0; i < requestedValues.length; i++) {

            var record = data.find(valueField, requestedValues[i]);

            // If the value is still marked as 'in progress' [hasn't been deselected]
            // we will add the record to our target grid.
            if (this.valuesFetchInProgress(requestedValues[i])) {
                hasActiveValue = true;
                // If we didn't find a record for the value in the dataSource
                // we add a dummy record to the grid so the user has a visual
                // indication of selection, and getSelectedRecords() / getSelectedValues()
                // is impacted by the attempt to set the value.
                
                if (this.addMissingPlaceholders && record == null) {
                    record = {};
                    record[this.missingPlaceholderAttribute] = true;
                    record.valueField = requestedValues[i];
                    data.add(record);
                }

            // If the dev has cleared selection for the specified value we don't
            // want to add it to our target grid!
            } else {
                data.removeWhere(this.getValueFieldName(), requestedValues[i]);
            }
        }
        if (data.length > 0) {
            
            this.selectRecords(data);
        }

        // If
        // - we no longer have any outstanding fetches for value-records
        // - the dev has not called clearSelection / setSelectedByValue(val,false) for
        //   all the requested values
        // Fire the valuesFetchComplete callback
        // Note that we're doing this even if the fetch failed to find an associated
        // record.
        if (hasActiveValue && !this.valuesFetchInProgress()) {
            this.valuesFetchComplete();
        }
    },

    // Update the _pendingFetchValues array
    _addToFetchingValues : function (values) {
        if (this._pendingFetchValues == null) {
            this._pendingFetchValues = [];
        }
        this._pendingFetchValues.addList(values);
    },
    _clearFetchingValue : function (value) {
        if (!this._pendingFetchValues) return;
        this._pendingFetchValues.remove(value);
    },


    
    valuesFetchInProgress : function (value) {
        if (value == null) {
            return this._pendingFetchValues && this._pendingFetchValues.length > 0;
        } else {
            return this._pendingFetchValues && this._pendingFetchValues.indexOf(value) != -1;
        }
    },


        
        
    valuesFetchComplete : function () {
    },


    


    
    getSelectedRecords : function (includeLoadingPlaceholders) {
        var records = [];
        records.addList(this.selectedRecords);
        if (includeLoadingPlaceholders && this._pendingFetchValues) {
            var valueField = this.getValueFieldName();
            for (var i = 0; i < this._pendingFetchValues.length; i++) {
                var pendingRecord = {};
                pendingRecord[this.loadingPlaceholderAttribute] = true;
                pendingRecord[valueField] = this._pendingFetchValues[i];
                records.add(pendingRecord);
            }
        }
        return records;
    },


    
    loadingPlaceholderAttribute:"_isLoadingPlaceholder",


    
    

    
    getSelectedValues : function (includeUnloadedValues) {
        var selectedRecords = this.getSelectedRecords(includeUnloadedValues);
        return selectedRecords && selectedRecords.getProperty(this.getValueFieldName());
    },

    
    updateGrids : function () {
        
        
        
        var selection = this.selectedRecords || [];
        
        this.targetGrid.setData(selection);

        
        var implicitCriteria = this.getSourceGridImplicitCriteria();

        var mustFetch = !this.sourceGrid.dataObjectSupportsFilter(this.sourceGrid.data);
        this.sourceGrid.setImplicitCriteria(implicitCriteria);
        if (mustFetch) {
            var dsRequest = isc.addProperties({}, this.filterContext);
            this.sourceGrid.fetchData(
                this.sourceGrid.getCriteria(), 
                {target:this, methodName:"sourceGridFetchComplete"},
                dsRequest
            );
        }
    },

    // (Unused) notification fired after initial fetch
    sourceGridFetchComplete : function (dsResponse, data, dsRequest) {
    },

    // Combine this.implicitCriteria with the 'notInSet' criteria required to
    // hide selected values in the source grid.
    getSourceGridImplicitCriteria : function () {
        var implicitCriteria = this.getImplicitCriteria();

        var selection = this.selectedRecords || [];

        var dataSource = this.getDataSource();
        var valueField = this.getValueFieldName();
        if (valueField == null) {
            
            this.logWarn("Shuttle requires a valueField");
            return;
        }

        if (selection.length > 0) {
            var excludes = selection.getProperty(this.getValueFieldName());
            var excludeCriteria = {operator:"notInSet", fieldName:valueField, value:excludes};
            implicitCriteria = dataSource.combineCriteria(implicitCriteria, excludeCriteria, "and", "substring");
        }
        return implicitCriteria;
    },

    // Autochildren


    
    controlBarConstructor:"VLayout",
    controlBarDefaults:{
        align:"center",
        defaultLayoutAlign:"center",
        width:50,
        membersMargin:10
    },


    


    
    selectAllButtonIcon:"[SKINIMG]TransferIcons/right_all.png",


    
    selectAllButtonWidth:24,
    

    
    selectAllButtonHeight:22,


    
    incompleteDataWarning:"Unable to select all - the data set does not have all matching records loaded from the dataSource.",
    
    selectAllButtonConstructor:"ImgButton",
    selectAllButtonDefaults:{
        showDown:false,
        click : function () {
            var sourceGrid = this.creator.sourceGrid;
            if (!sourceGrid.data.allMatchingRowsCached()) {
                isc.warn(this.creator.incompleteDataWarning);
                return;
            }
            var records = sourceGrid.data.getRange(0, sourceGrid.getTotalRows());
            this.creator.selectRecords(records, true);
        }
    },


    
    selectButtonConstructor:"ImgButton",


    
    selectButtonIcon:"[SKINIMG]TransferIcons/right.png",


    
    selectButtonWidth:24,
    

    
    selectButtonHeight:22,    

    selectButtonDefaults:{
        showDown:false,
        click : function () {
            var records = this.creator.sourceGrid.getSelectedRecords();
            this.creator.selectRecords(records, true);
        }
    },


    
    deselectButtonConstructor:"ImgButton",


    
    deselectButtonIcon:"[SKINIMG]TransferIcons/left.png",


    
    deselectButtonWidth:24,
    

    
    deselectButtonHeight:22,

    deselectButtonDefaults:{
        showDown:false,
        click : function () {
            var records = this.creator.targetGrid.getSelectedRecords();
            this.creator.deselectRecords(records, true);
        }
    },


    


    
    deselectAllButtonIcon:"[SKINIMG]TransferIcons/left_all.png",


    
    deselectAllButtonWidth:24,
    

    
    deselectAllButtonHeight:22,   

    deselectAllButtonConstructor:"ImgButton",
    deselectAllButtonDefaults:{
        showDown:false,
        click : function () {
            this.creator.clearSelection(true);
        }
    },

    // If we don't have an explicitly specified dataSource, create a
    // clientOnly DS to filter against our data object
    _createClientOnlyDataSource : function () {
        this.dataSource = isc.DataSource.create({
            _generated:true,
            clientOnly:true,
            fields:[
                {name:this.getValueFieldName(), primaryKey:true}
            ],
            dropUnknownCriteria:false,
            cacheData:this.data ? this.data.duplicate() : [] // if we have neither data nor dataSource we can't show any options
        });

    },

    initWidget : function () {

        
        var shuttleSupported = window.isc_supportsMultiPickerItem;
        
        if (!shuttleSupported) {
            this.logWarn("Shuttle is not supported in this build");
            return;
        }


        if (this.dataSource == null) {
            this._createClientOnlyDataSource();
        } else if (this.data != null) {
            this.logWarn("Shuttle instantiated with both dataSource and data properties. " +
                         "The static data object will be ignored and options will be retrieved by fetching against the dataSource.");
        }

        var dynamicSourceDefaults = {

            textMatchStyle:this.textMatchStyle,
            fetchOperation:this.fetchOperation,

            groupTitle:this.sourceGridTitle,
            fields:(this.fields ? isc.clone(this.fields) : null),
            dataSource:this.dataSource
            
        }
        var staticSourceDefaults = isc.addProperties({}, this.sourceGridDefaults, this.sourceGridProperties);

        if (this.sortField && staticSourceDefaults.sortField == null) {
            dynamicSourceDefaults.sortField = this.sortField;
        }
        if (this.sortDirection && staticSourceDefaults.sortDirection == null) {
            dynamicSourceDefaults.sortField = this.sortDirection;
        }
        if (this.initialSort && staticSourceDefaults.initialSort == null) {
            dynamicSourceDefaults.initialSort = this.initialSort;
        }
        this.sourceGrid = this.createAutoChild("sourceGrid", dynamicSourceDefaults);

        var dynamicTargetDefaults = {
            groupTitle:this.targetGridTitle,
            fields:(this.fields ? isc.clone(this.fields) : null),
            dataSource:this.dataSource
        };

        var staticTargetDefaults = isc.addProperties({}, this.targetGridDefaults, this.targetGridProperties);
        
        if (this.sortField && staticTargetDefaults.sortField == null) {
            dynamicTargetDefaults.sortField = this.sortField;
        }
        if (this.sortDirection && staticTargetDefaults.sortDirection == null) {
            dynamicTargetDefaults.sortField = this.sortDirection;
        }
        if (this.initialSort && staticTargetDefaults.initialSort == null) {
            dynamicTargetDefaults.initialSort = this.initialSort;
        }
        this.targetGrid = this.createAutoChild("targetGrid", dynamicTargetDefaults);

        this.selectAllButton = this.createAutoChild(
                                "selectAllButton",
                                {
                                    width:this.selectAllButtonWidth,
                                    height:this.selectAllButtonHeight,
                                    src:this.selectAllButtonIcon
                                
                                }
                               );
        this.selectButton = this.createAutoChild("selectButton",                                
                                {
                                    width:this.selectButtonWidth,
                                    height:this.selectButtonHeight,
                                    src:this.selectButtonIcon
                                }
                            );

        this.deselectButton = this.createAutoChild("deselectButton",
                                    {
                                        width:this.deselectButtonWidth,
                                        height:this.deselectButtonHeight,
                                        src:this.deselectButtonIcon
                                    }
                              );

        this.deselectAllButton = this.createAutoChild("deselectAllButton",
                                    {
                                        width:this.deselectAllButtonWidth,
                                        height:this.deselectAllButtonHeight,
                                        src:this.deselectAllButtonIcon
                                    }
                                );
        
        this.controlBar = this.createAutoChild("controlBar", {
            members:[
                this.selectAllButton,
                this.selectButton,
                this.deselectButton,
                this.deselectAllButton
            ]
        });
        
        this.setMembers([
            this.sourceGrid, this.controlBar, this.targetGrid
        ]);

        this.updateGrids();

        // this.selectedValues - initialization property for default selection
        // If set, call setSelectedByValue and clear the property - getSelectedValues will
        // update 
        
        if (this.selectedValues != null && this.selectedRecords == null) {
            this.setSelectedByValue(this.selectedValues);
        }
        delete this.selectedValues;

        return this.Super("initWidget", arguments);
    }

});

isc.Shuttle.registerStringMethods({
    // Documented above
    selectionUpdated : ""
});
