/*
 * Decompiled with CFR 0.152.
 */
package com.isomorphic.examples.server.summaries;

import com.isomorphic.datasource.DSRequest;
import com.isomorphic.datasource.DSResponse;
import com.isomorphic.log.Logger;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class OrderItemDMI {
    private static Logger log = new Logger(OrderItemDMI.class.getName());

    public DSResponse fetch(DSRequest req) throws Exception {
        Map summaryFunctions = req.getRawSummaryFunctions();
        boolean hasCustomFunction = false;
        for (String functionName : summaryFunctions.values()) {
            if (!"countDistinct".equals(functionName) && !"concatDistinct".equals(functionName)) continue;
            hasCustomFunction = true;
            break;
        }
        if (!hasCustomFunction) {
            return req.execute();
        }
        List data = new DSRequest(req.getDataSource(), "fetch").execute().getDataList();
        final List groupFields = req.getGroupBy();
        data.sort(new Comparator<Map<String, Object>>(){

            @Override
            public int compare(Map<String, Object> o1, Map<String, Object> o2) {
                for (String field : groupFields) {
                    int res = 0;
                    Object v1 = o1.get(field);
                    Object v2 = o2.get(field);
                    if (v1 instanceof String) {
                        res = ((String)v1).compareTo((String)v2);
                    }
                    if (v1 instanceof Date) {
                        res = ((Date)v1).compareTo((Date)v2);
                    }
                    if (res == 0) continue;
                    return res;
                }
                return 0;
            }
        });
        ArrayList aggregatedData = new ArrayList();
        HashMap lastRecord = null;
        for (Map map : data) {
            boolean nextRecord = lastRecord == null;
            for (String field : groupFields) {
                if (nextRecord) break;
                nextRecord = !lastRecord.get(field).equals(map.get(field));
            }
            if (nextRecord) {
                lastRecord = new HashMap();
                aggregatedData.add(lastRecord);
                for (String field : groupFields) {
                    lastRecord.put(field, map.get(field));
                }
            }
            for (String field : summaryFunctions.keySet()) {
                ArrayList list = (ArrayList)lastRecord.get(field);
                if (list == null) {
                    list = new ArrayList();
                    lastRecord.put(field, list);
                }
                list.add(map.get(field));
            }
        }
        for (Map map : aggregatedData) {
            for (String field : summaryFunctions.keySet()) {
                String function = (String)summaryFunctions.get(field);
                List values = (List)map.get(field);
                if ("count".equals(function)) {
                    map.put(field, values.size());
                    continue;
                }
                if ("countDistinct".equals(function)) {
                    ArrayList uniqueValues = new ArrayList();
                    for (Object value : values) {
                        if (uniqueValues.contains(value)) continue;
                        uniqueValues.add(value);
                    }
                    map.put(field, uniqueValues.size());
                    continue;
                }
                if (!"concatDistinct".equals(function)) continue;
                ArrayList seen = new ArrayList();
                String result = "";
                for (Object value : values) {
                    if (seen.contains(value)) continue;
                    seen.add(value);
                    result = result + ("".equals(result) ? value : ", " + value);
                }
                map.put(field, result);
            }
        }
        return new DSResponse(aggregatedData);
    }
}

