/*
 * Decompiled with CFR 0.152.
 */
package com.isomorphic.examples.server.validation;

import com.isomorphic.datasource.DSRequest;
import com.isomorphic.datasource.DataSource;
import com.isomorphic.datasource.Validator;
import com.isomorphic.log.Logger;
import com.isomorphic.util.DataTools;
import java.util.Map;

public class ValidatorDMI {
    Logger log = new Logger(ValidatorDMI.class.getName());

    public boolean condition(Object value, Validator validator, String fieldName, Map record, DataSource ds) throws Exception {
        this.log.warn((Object)("validating value: '" + value + "' for fieldName: '" + fieldName + "' in DataSource: '" + ds.getID() + "'\nin record: " + DataTools.prettyPrint((Object)record) + "\nvalidator definition: " + DataTools.prettyPrint((Object)validator)));
        if (value == null) {
            return false;
        }
        int quantityOrdered = Integer.valueOf(value.toString());
        DSRequest dsRequest = new DSRequest("StockItem", "fetch");
        Object itemId = record.get("itemId");
        if (itemId == null) {
            return true;
        }
        dsRequest.setCriteria((Object)DataTools.buildMap((Object[])new Object[]{"id", record.get("itemId")}));
        Map dataMap = dsRequest.execute().getDataMap();
        if (dataMap == null) {
            throw new Exception("Unrecognized stock item ID");
        }
        long quantityAvailable = ((Integer)dataMap.get("quantity")).intValue();
        if ((long)quantityOrdered > quantityAvailable) {
            validator.addErrorMessageVariable("available", "" + quantityAvailable);
            return false;
        }
        return true;
    }
}

