/*

  SmartClient Ajax RIA system
  Version v14.1p_2026-02-03/LGPL Deployment (2026-02-03)

  Copyright 2000 and beyond Isomorphic Software, Inc. All rights reserved.
  "SmartClient" is a trademark of Isomorphic Software, Inc.

  LICENSE NOTICE
     INSTALLATION OR USE OF THIS SOFTWARE INDICATES YOUR ACCEPTANCE OF
     ISOMORPHIC SOFTWARE LICENSE TERMS. If you have received this file
     without an accompanying Isomorphic Software license file, please
     contact licensing@isomorphic.com for details. Unauthorized copying and
     use of this software is a violation of international copyright law.

  DEVELOPMENT ONLY - DO NOT DEPLOY
     This software is provided for evaluation, training, and development
     purposes only. It may include supplementary components that are not
     licensed for deployment. The separate DEPLOY package for this release
     contains SmartClient components that are licensed for deployment.

  PROPRIETARY & PROTECTED MATERIAL
     This software contains proprietary materials that are protected by
     contract and intellectual property law. You are expressly prohibited
     from attempting to reverse engineer this software or modify this
     software for human readability.

  CONTACT ISOMORPHIC
     For more information regarding license rights and restrictions, or to
     report possible license violations, please contact Isomorphic Software
     by email (licensing@isomorphic.com) or web (www.isomorphic.com).

*/

if(window.isc&&window.isc.module_Core&&!window.isc.module_DataBinding){isc.module_DataBinding=1;isc._moduleStart=isc._DataBinding_start=(isc.timestamp?isc.timestamp():new Date().getTime());if(isc._moduleEnd&&(!isc.Log||(isc.Log && isc.Log.logIsDebugEnabled('loadTime')))){isc._pTM={ message:'DataBinding load/parse time: ' + (isc._moduleStart-isc._moduleEnd) + 'ms', category:'loadTime'};
if(isc.Log && isc.Log.logDebug)isc.Log.logDebug(isc._pTM.message,'loadTime');
else if(isc._preLog)isc._preLog[isc._preLog.length]=isc._pTM;
else isc._preLog=[isc._pTM]}isc.definingFramework=true;


if (window.isc && isc.version != "v14.1p_2026-02-03/LGPL Deployment" && !isc.DevUtil) {
    isc.logWarn("SmartClient module version mismatch detected: This application is loading the core module from "
        + "SmartClient version '" + isc.version + "' and additional modules from 'v14.1p_2026-02-03/LGPL Deployment'. Mixing resources from different "
        + "SmartClient packages is not supported and may lead to unpredictable behavior. If you are deploying resources "
        + "from a single package you may need to clear your browser cache, or restart your browser."
        + (isc.Browser.isSGWT ? " SmartGWT developers may also need to clear the gwt-unitCache and run a GWT Compile." : ""));
}




//> @class TextSettings
// Common base class of +link{TextImportSettings()}.
// @treeLocation Client Reference/System
// @visibility external
//<
isc.ClassFactory.defineClass("TextSettings");

isc.TextSettings.addClassProperties({
    //> @type EscapingMode
    // Mode for escaping text values when using +link{DataSource.recordsAsText()} or
    // +link{DataSource.recordsFromText()}.
    DOUBLE: "double",
    // @value "double" Literal double quotes in data values are doubled (""), as expected by Microsoft
    //                 Excel when pasting text values
    BACKSLASH: "backslash"
    // @value "backslash" double quotes in data values have a blackslash (\) prepended, similar to
    //                    String escaping in JavaScript and Java
    // @visibility external
    //<
});

isc.TextSettings.addProperties({

    //> @attr textSettings.fieldList (Array of String : null : IR)
    // For export, a set of fields to export.  Default is to export all DataSource fields.
    // <P>
    // Fields may be specified that are not in the DataSource but for which data values are present
    // in the provided Records.  In this case the field is assumed to be of type "text".
    // <p>
    // For import, names of DataSource fields to use to parse values, in order.
    // <P>
    // If <code>fieldList</code> is unset, DataSource fields are used, in order.
    // <P>
    // If more values exist in a given Record than the listed fields or than all DataSource fields,
    // remaining values are ignored.
    // @visibility external
    //<
    fieldList: null,

    //> @attr textSettings.fieldSeparator (String : "," : IR)
    // Separator between field values.  Default is a comma character, producing CSV
    // (comma-separated values) format.
    // @visibility external
    //<
    fieldSeparator: ",",

    //> @attr textSettings.lineSeparator (String : null : IR)
    // Separator between Records.  For import, default of null means that either the Unix/Mac
    // format of just a newline ("\n") or the typical DOS/Windows format of a carriage return
    // and newline ("\r\n") will be accepted.  For export, overridden in +link{TextExportSettings}.
    // @visibility external
    //<
    lineSeparator: null,

    //> @attr textSettings.escapingMode (EscapingMode : "backslash" : IR)
    // +link{EscapingMode} expected for escaping special characters embedded in text values.
    // @visibility external
    //<
    escapingMode: isc.TextSettings.BACKSLASH
});

isc.TextSettings.addMethods({

    getEscapingModeEscapeChar : function () {
        switch (this.escapingMode) {
        case isc.TextSettings.DOUBLE:
            return "\"";
            break;
        case isc.TextSettings.BACKSLASH:
            return "\\";
            break;
        }
        return "";
    }

});




//> @class TextExportSettings
// Settings for use with +link{DataSource.recordsAsText()}.
// @inheritsFrom TextSettings
// @treeLocation Client Reference/System
// @visibility external
//<
isc.ClassFactory.defineClass("TextExportSettings", "TextSettings");

isc.TextExportSettings.addClassProperties({
    //> @type ForceTextApproach
    // Approach to force a text value to be interpreted as text rather than parsed as a date, time
    // or other structured types, as can happen with Microsoft Excel.  For background information,
    // see +link{group:excelPasting}.
    //
    LEADING_SPACE: "leadingSpace",
    // @value "leadingSpace" a leading space character is added
    FORMULA: "formula"
    // @value "formula" text value is turned into a trivial Excel formula (eg "car" becomes ="car").
    // In Excel, this renders just the value "car" but editing the cell reveals the formula.
    // @visibility external
    //<
});

isc.TextExportSettings.addProperties({
    //> @attr textExportSettings.lineSeparator (String : "\n" : IR)
    // Separator between Records.  Default is a newline character ("\n").
    // @visibility external
    //<
    lineSeparator: "\n",

    //> @attr textExportSettings.quoteValues (Boolean : true : IR)
    // Whether to surround each value with quotes ("").
    // @visibility external
    //<
    quoteValues: true,

    //> @attr textExportSettings.nullValueText (String : "": IR)
    // Text to export for a field with a null value.  If this property is null, then
    // null fields will be assumed to have the default value for their field type.
    // @visibility external
    //<
    nullValueText: "",

    //> @attr textExportSettings.useDisplayValue (Boolean : false : IR)
    // Whether to convert each field's value to the corresponding display value
    // for export.  Default of false will directly export the field's value.
    // @visibility external
    //<
    useDisplayValue: false,

    //> @attr textExportSettings.forceText (ForceTextApproach : null : IR)
    // If set, all text fields will use the indicated +link{ForceTextApproach} unless they have
    // a specific setting for +link{dataSourceField.exportForceText}.
    // @visibility external
    //<
    forceText: null,

    //> @attr textExportSettings.dateFormat (DateDisplayFormat : null : IR)
    // Format to use when outputting date values.  Default is to use the format expected by
    // Microsoft Excel (eg 1-2-2011), which Excel will turn into a real date value (see
    // +link{group:excelPasting}).  The current month-day-year order as set by
    // +link{DateUtil.setInputFormat()} will be used.
    // @visibility external
    //<
    dateFormat: null,

    //> @attr textExportSettings.dateTimeFormat (DateDisplayFormat : null : IR)
    // Format to use when outputting datetime values.  Default is to combine the configured date
    // and time formats with a space (" ").
    // @visibility external
    //<
    dateTimeFormat: null,

    //> @attr textExportSettings.timeFormat (TimeDisplayFormat : null : IR)
    // Format to use when outputting time values.  Default is 24 hour time.
    // @visibility external
    //<
    timeFormat: null
});




//> @class TextImportSettings
// Settings for use with +link{DataSource.recordsFromText()}.
// @inheritsFrom TextSettings
// @treeLocation Client Reference/System
// @visibility external
//<
isc.ClassFactory.defineClass("TextImportSettings", "TextSettings");

isc.TextImportSettings.addClassProperties({

    // This internal property configures the parser to accept JSON object records.
    // The header items are used directly as field names, without checking or
    // matching against DataSource titles or fields, and the records are returned
    // without converting them to objects via +link{DataSource.validateJSONRecord()}.
    _importAsJsonObjects : false
});

isc.TextImportSettings.addProperties({

    //> @attr textImportSettings.hasHeaderLine (Boolean : false : IR)
    // If set to true, the data is assumed to have a header line that lists titles for each field,
    // which should be parsed.
    // <P>
    // <code>recordsFromText</code> will then try to find a same-named
    // DataSourceField by checking parsed titles against both +link{DataSourceField.title} and
    // +link{DataSourceField.name} (titles first), doing a case-insensitive comparison with any
    // leading or trailing whitespace removed from the title.  If no field matches, data will
    // appear in the returned Records under the exact title parsed from the header line.
    // <P>
    // If this approach will not find appropriate DataSourceFields, parse the header line before
    // calling <code>recordsFromText()</code>, and provide the list of field names to use when
    // parsing data as +link{TextSettings.fieldList}.
    // @visibility external
    //<
    hasHeaderLine: false,

    //> @attr textImportSettings.trim (boolean : false : IR)
    // If set to true, calls +link{String.trim} to remove whitespace before and after
    // the value before removing any quotes.
    //<
    trim: false
});

isc.TextImportSettings.addMethods({

    getSpecialCharactersRegExp : function (flags) {
        var expression = this.lineSeparator ? "\\" + this.lineSeparator : "(\r)?\n";
        expression += "|\\" + this.getEscapingModeEscapeChar() + "\"";
        expression += "|\\" + this.fieldSeparator;
        expression += "|\\\"";
        return new RegExp(expression, flags);
    },

    removeUnescapedQuotes : function (value) {
        var escapeChar = this.getEscapingModeEscapeChar();

        var reEscapedQuotes = new RegExp("\\" + escapeChar + "\"", "g");

        var reUnEscapedQuotes = escapeChar == "\"" ?
            new RegExp("([^\"]|^)\"(?!\")", "g") :
            new RegExp("\"\"|([^\\" + escapeChar + "]|^)\"", "g");

        return value.replace(reUnEscapedQuotes, "$1").replace(reEscapedQuotes, "\"");
    },

    addFinalLineSeparatorIfNotPresent : function (text) {
        var lineSeparator = this.lineSeparator || "\n";
        var regExp = new RegExp(lineSeparator + "$");
        if (!text.match(regExp, text)) text += lineSeparator;
        return text;
    },

    parseTextAndApplyFunctions : function (text, fieldFunction, lineFunction) {

        var fieldSeparator = this.fieldSeparator;
        var escapedQuote = this.getEscapingModeEscapeChar() + "\"";
        var boundaryRegExp = this.getSpecialCharactersRegExp();

        var startPos = 0, quoted = false;;

        for (var hit, target = text, offset = 0; null != (hit = target.match(boundaryRegExp));
             target = target.substring(increment), offset += increment) {

            var increment = hit[0].length + hit.index;
            switch(hit[0]) {
            case escapedQuote:
                break;
            case "\"":
                quoted = !quoted;
                break;
            default:
                if (quoted) continue;

                var value = text.substring(startPos, offset + hit.index);
                if (this.trim) value = value.trim();
                // disambiguate single set of double quotes as empty value rather than
                // one escaped quote when TextExportSettings escaping mode is DOUBLE
                if (value == "\"\"" && this.escapingMode == isc.TextSettings.DOUBLE) {
                    value = "";
                }
                value = this.removeUnescapedQuotes(value);
                startPos = offset + increment;

                fieldFunction(value);

                if (hit[0] != fieldSeparator) {
                    if (lineFunction()) target = "";
                }
                break;
            }
        }
        return text.substring(startPos);
    }
});







//
//=    @object    XMLSerialize
//
//    xml serialize() methods for the comm package
//

// XXX this package must not be dependant on the Comm package, because serialization is a useful
// feature completely apart from Comm.  Unfortunately, the methods are currently expected to be on
// the Comm class, so if the Comm class doesn't exist we need to define it.
if (!isc.Comm) isc.defineClass("Comm");

isc.Comm.addClassProperties( {
    // prefixes for special object types

    //>    @classAttr    Comm.XML_BACKREF_PREFIX (String : "$$BACKREF$$:" : IR)
    //        @group    serialization
    //            Prefix for back-references in serialized object references.
    //<
    XML_BACKREF_PREFIX : "$$BACKREF$$:",

    _xmlIdentifierRegex : /^([_:A-Za-z])([_:.A-Za-z0-9]|-)*$/,
    // this property only applies to XMLSerialize
    serializeBackrefs : true
});


isc.Comm.addClassMethods( {

//>    @classMethod    Comm.xmlSerialize()
//            Serialize an object of any type into an xml string, in a form that
//             can be read by server-side code via schemaless transform
//
//        Note: You should call this routine to serialize any type of object,
//                 rather than calling the custom routines on that object...
//
//        @group    xml serialization
//        @param    name        (Any)        name of object to be serialized (used for outer XML tag)
//        @param    object        (Any)        object to be serialized
//        @param    [indent]    (boolean)    true == output should be indented for reading,
//                                      false == no indentation
//
//        @return                (String)    serialization form of the object
//<
xmlSerialize : function (name, object, indent) {
    return isc.Comm._xmlSerialize(name, object, indent ? "" : null);
},
//>    @classMethod    Comm._xmlSerialize()    (IA)
//            Internal routine that actually does the serialization.
//        @group    serialization
//
//        @param    name    (String)    name of the object for XML tags
//        @param    object    (Any)        object to serialize
//        @param    prefix    (String)    string to put before each line of serialization output
//        @param    context (Object)    context tracking objects already serialized and path
//                                  traversed so far
//
//        @return    (String)            serialized object as a string
//<
_xmlSerialize : function (name, object, prefix, context) {

    // Avoid attempting to manipulate SGWT Java objects
    if (isc.Browser.isSGWT && window.SmartGWT.isNativeJavaObject(object)){

        if (object == null) object = null;
        // If the global flag has been set to warn when we hit an unconvertible
        // object, do this.
        else {
            if (window.SmartGWT.warnOnSerializeError) {
                window.SmartGWT.throwUnconvertibleObjectException(
                    object, window.SmartGWT.serializeErrorMessage
                );
            }
            object = String.asSource(object + "");
        }
    }

    // record whether a name was explicitly passed
    var namePassed = name != null;

    // NOTE: allow context as a partial object, so eg isRoot can be set
    if (!context || !context.objRefs) {
        context = isc.addProperties({}, context);
        context.objRefs = {obj:[],path:[]};
        if (!context.objPath) {
            if (object && object.getID) context.objPath = object.getID();
            else context.objPath = "";
        }
        if (name == null) {
            if (isc.isA.Class(object)) name = object.getClassName();
            else if (isc.isAn.Array(object)) name = "Array";
            else if (isc.isA.Object(object)) name = object.$schemaId || "Object";
            else name = "ISC_Auto";
        }
    }

    // handle simple types

    // NOTE: in some use cases we need be able to send null, which potentially has a distinct
    // meaning from empty string (""), for example, nulling out a text field vs setting to
    // empty string.  In this case null is encoded distinctly by setting the attribute xsi:nil.
    // Note schema-driven serialization in DataSource.js does a similar thing but only for
    // fields marked nillable:true in schema.
    if (object == null) {
        if (isc.Comm.xmlSchemaMode || !isc.Comm._explicitNils) {
            return isc.Comm._xmlValue(name, "");
        } else {
            // send explicit null
            return isc.Comm._xmlValue(name, null, "nil");
        }
    }

    if (isc.isA.String(object))    {
        return isc.Comm._xmlValue(name, this._makeXMLValueSafe(object, prefix),
                                  isc.Comm.xmlSchemaMode ? "string" : null);
    }
    if (isc.isA.Function(object)) {
        if (object.iscAction) return isc.StringMethod._xmlSerializeAction(object.iscAction);
        return null;
    }

    if (object == window) {
        this.logWarn("Serializer encountered the window object at path: " + context.objPath
                    +" - returning null for this slot.");
        return null;
    }

    // XML comm supports strong typing of numbers and booleans, but JS comm does not (the type
    // information is not propagated). Preserving the type is useful, so we default to that - but
    // this can be disabled
    if (isc.RPCManager.preserveTypes) {
        // for numbers, distinguish between float and integer
        // NOTE: special numbers like NaN and Infinity aren't allowed in the XML Schema numeric
        // types - the XML schema approach here would be to declare a union type between a
        // numeric base type and an enum of NaN, Infinity, etc.
        if (isc.isA.Number(object) || isc.isA.SpecialNumber(object)) {
            if (object.toString().contains("."))
                return isc.Comm._xmlValue(name, object, "double");
            return isc.Comm._xmlValue(name, object, "long");
        }
        if (isc.isA.Boolean(object)) return isc.Comm._xmlValue(name, object, "boolean");
    } else {
        // old approach
        if (isc.isA.Number(object) || isNaN(object)) {
            return isc.Comm._xmlValue(name, object);
        }
        if (isc.isA.Boolean(object))    return isc.Comm._xmlValue(name, object);
    }

    // for complex types:

    // detect infinite loops by checking if we've seen this object before.
    // disambiguate between true loops vs the same leaf object being encountered twice
    // (such as a simple Array containing two Strings which appears in two spots).  Only
    // consider this a loop if the preceding occurrence of the object was some parent of
    // ours.
    var prevPath = isc.JSONEncoder._serialize_alreadyReferenced(context.objRefs, object);
    if (prevPath != null && context.objPath.contains(prevPath)) {
        // Note: check that the first char after "prevPath" is a path separator char in order
        // to avoid false loop detection with "prop" and "prop2" having the same non-looping
        // object (since "prop2" contains "prop").
        var nextChar = context.objPath.substring(prevPath.length, prevPath.length+1);
        //this.logWarn("backref: prevPath: " + prevPath + ", current: " + context.objPath +
        //             ", char after prevPath: " + nextChar);
        if (nextChar == "." || nextChar == "[" || nextChar == "]") {
            if (this.serializeBackrefs) {
                return isc.Comm._xmlOpenTag(name) +
                                isc.Comm.XML_BACKREF_PREFIX + prevPath +
                       isc.Comm._xmlCloseTag(name);
            }
            return isc.emptyString;
        }
    }

    // remember Objects and Arrays to avoid infinite loops
    isc.JSONEncoder._serialize_remember(context.objRefs, object, context.objPath);

    // if there is an xmlSerialize method associated with this object, call that
    if (isc.isA.Function(object._xmlSerialize)) {
        return object._xmlSerialize(name, null, null, prefix, context.objRefs, context.objPath);
    } else if (isc.isA.Class(object)) {
        this.logWarn("Attempt to serialize class of type: " + object.getClassName()
                     + " at path: " + context.objPath + " - returning null for this slot.");
        return null;
    }

    // we define the xsi namespace on the first nested object that we encounter.  The first such
    // object sets the value isRoot on the context to 'false' explicitly.  If it's not defined, then
    // it's true.
    var isRoot = context.isRoot == false ? false : true;

    // handle arrays as a special case
    if (isc.isAn.Array(object))
        return isc.Comm._xmlSerializeArray(name, object, context.objPath,
                                           context.objRefs, prefix, isRoot);

    var data;
    // if the object has a getSerializeableFields, use whatever it returns, otherwise just use the object
    if (object.getSerializeableFields) {

        data = object.getSerializeableFields([], []);
    } else {
        data = object;
    }

    return isc.Comm._xmlSerializeObject(name, data, context.objPath,
                                        context.objRefs, prefix, isRoot,
                                        context.fieldCanBeFormula, context.xmlExplicitSimpleType);
},

_makeXMLValueSafe : function (value, indent) {
    value = isc.makeXMLSafe(value, null, null, null, false, false);
    if (indent && value.endsWith("\n")) value += indent;
    return value;
},

//>    @classMethod    Comm._xmlSerializeArray()    (A)
//            Internal routine to serialize an array.
//
//        @group    serialization
//        @param    name    (String)    name of the object for XML tags
//        @param    object    (Any)        object to serialize
//        @param    prefix    (String)    string to put before each line of serialization output
//        @param    objRefs    (Array of Object[])    array of objects that have been serialized already so
//                                     we don't get into endless loops
//        @param    objPath    (String)    global variable path to this object, for serializing object references
//
//        @return    (String)            serialized object as a string
//<
_xmlSerializeArray : function (name, object, objPath, objRefs, prefix, isRoot) {

    //isc.logWarn("Starting _xmlSerializeArray() for array with " + object.length + " elements");


    // Use SB.append() - quicker and more memory efficient than concat if we have a lot of elements
    var buffer = isc.StringBuffer.newInstance();
    buffer.append(isc.Comm._xmlOpenTag(name, "List", null, null, null, isRoot));

    // Previously, we were doing these each time around the loop
    var decoratedPrefix = prefix != null ? isc.StringBuffer.concat("\n", prefix, "\t") : "";
    var prefixPlusTab = prefix != null ? isc.StringBuffer.concat(prefix, "\t") : null;
    var context = {
        objRefs : objRefs,
        isRoot : false
    };

    // spin through the array and create <elem>value</elem> strings
    for (var i = 0, len = object.length; i < len; i++) {
        var value = object[i];
        context.objPath = isc.JSONEncoder._serialize_addToPath(objPath, i),

        buffer.append(
                decoratedPrefix,
                isc.Comm._xmlSerialize((value != null ? value.$schemaId : null) || "elem",
                                       value,
                                       prefixPlusTab,
                                       context)
                );
    }

    // close xml tag
    buffer.append(
            (prefix != null ? isc.StringBuffer.concat("\n", prefix) : ""),
            isc.Comm._xmlCloseTag(name)
            );

    //isc.logWarn("In _xmlSerializeArray(), ready to call toString()");
    var result = buffer.toString();
    //isc.logWarn("In _xmlSerializeArray(), returning result");
    return result;
},



_xmlSerializeArrayWithConcat : function (name, object, objPath, objRefs, prefix, isRoot) {

    //isc.logWarn("Starting _xmlSerializeArrayWithConcat() for array with " + object.length + " elements");

    // open xml tag
    var result = isc.Comm._xmlOpenTag(name, "List", null, null, null, isRoot);

    // spin through the array and create <elem>value</elem> strings
    for (var i = 0, len = object.length; i < len; i++) {
        var value = object[i];
        var context = {
            objRefs : objRefs,
            objPath : isc.JSONEncoder._serialize_addToPath(objPath, i),
            isRoot : false
        };
        result = isc.StringBuffer.concat(
                result,
                (prefix != null ? isc.StringBuffer.concat("\n", prefix, "\t") : ""),
                isc.Comm._xmlSerialize((value != null ? value.$schemaId : null) || "elem",
                                       value,
                                       (prefix != null ? isc.StringBuffer.concat(prefix, "\t") : null),
                                       context)
                );
    }

    // close xml tag
    result = isc.StringBuffer.concat(
            result,
            (prefix != null ? isc.StringBuffer.concat("\n", prefix) : ""),
            isc.Comm._xmlCloseTag(name)
            );

    //isc.logWarn("In _xmlSerializeArrayWithConcat(), returning result");
    return result;
},


_isValidXMLIdentifier : function (name) {
    // XMLSerialize is used to transform arbitrary JS structures, including object literals
    // with strings for keys.  XML accepts only a subset of characters that are valid in a
    // string.  We encode them in an attribute value and have the server reconstitute them via
    // the special _isc_name encoding.  But requests sent out of band of our server (direct
    // webservices for example) can't be helped in this manner.  For those, we simply punt and
    // expect users to provide valid identifiers.
    //
    // It would be useful to report bad identifiers to the DeveloperConsole.  Unfortunately,
    // the JS regexp character classes aren't powerful enough for us to do this without
    // recapitulating the unicode character ranges verbatim from the spec, which would be slow
    // and take up a lot of space.
    //
    // Note that our regexp matches a subset of the valid identifiers, but this is harmless
    // since our server reconstitues these.
    //
    // Spec is here:
    // http://www.w3.org/TR/REC-xml/#NT-Letter
    return isc.Comm.xmlSchemaMode || name.match(this._xmlIdentifierRegex);
},

//>    @classMethod    Comm._xmlSerializeObject()    (A)
//            Internal routine to serialize an object.
//
//        @group    serialization
//        @param    object    (Any)        object to serialize
//        @param    prefix    (String)    string to put before each line of serialization output
//        @param    objRefs    (Array of Object[])    array of objects that have been serialized already so
//                                     we don't get into endless loops
//        @param    objPath    (String)    global variable path to this object, for serializing object references
//
//        @return    (String)            serialized object as a string
//<
_xmlSerializeObject : function (name, object, objPath, objRefs, prefix, isRoot, canBeFormula, xmlExplicitSimpleType) {

    // if it's a class or has the special _constructor property, then the name is the class name
    // this allows us to hand the output of this method to the server-side xml parser and get back
    // a DataSource-validated object back.
    // Aug 2008 - moved this check before the call to isc.Comm._xmlOpenTag, to ensure that it
    // uses the correct name for non-Class objects with a _constructor - without this change,
    // it was returning mismatched open and close tags
    // April 2010 - added "RelativeDate" as a class-name to ignore, so that relative dates
    // can be sent up to the server as part of criteria without having their "value" property
    // renamed
    if (isc.isAn.Instance(object)) name = object.getClassName();
    else if (object._constructor && object._constructor != "AdvancedCriteria" &&
        object._constructor != "RelativeDate") name = object._constructor;

    // open xml tag
    //
    // NOTE: we do need to explicitly label the structure we're about to write out as an "Object",
    // because for a single-property object like { values : { locale : 10 } } we'd currently write:
    // <container>
    //   <values>
    //     <someProperty>10</someProperty>
    //   </values>
    // </container>
    // Without an explicit declaration that "values" is of Object type, this could be
    // interpreted as values being a subobject with a single property someProperty, or
    // <someProperty> being a *type name* which will be the value of the property "values".
    // Adding "Object" below causes us to write values as <values xsi:type="xsd:Object" .. >,
    // removing the ambiguity.
    var type = (xmlExplicitSimpleType ? null : "Object");

    var isFormula = (canBeFormula && (object.formula || object.template));

    var result = isc.Comm._xmlOpenTag(name, type, null, null, isFormula, isRoot);

    if (isFormula) {
        for (var key in object) {
            if (key == null) continue;


            if (key == isc.gwtRef || key == isc.gwtModule) continue;

            // XML identifiers can't start with $ (parser crashes)
            if (key.startsWith('$')) continue;

            var value = object[key];

            result += " " + key + "=\"" + value + "\"";
        }
        return result + "/>";
    }

    // If a formula (UserFormula or UserSummary) is allowed as a field value and an object
    // is found with the "text" property, add UserFormula/UserSummary type wrapping so it can
    // be deserialized later.
    var innerTag = "";
    if (canBeFormula && object.text) {
        // Attempt to serialize with a schema so contained properties are written correctly
        // (formulaVars/summaryVars in particular)
        var tag = object.formulaVars ? "UserFormula" : "UserSummary",
            schema = isc.DS.get(tag);
        if (schema) {
            var formulaXML = schema.xmlSerialize(object,null,(prefix != null ? isc.StringBuffer.concat(prefix, "\t") : ""),tag);
            if (name == tag) {
                return formulaXML;
            }
            result = isc.StringBuffer.concat(
                result + formulaXML,
                (prefix != null ? isc.StringBuffer.concat("\n", prefix) : ""),
                innerTag,
                isc.Comm._xmlCloseTag(name)
                );
            return result;
        }
        // If schema isn't found, fall back to just a wrapping
        result += isc.Comm._xmlOpenTag(tag, tag, null, null, null, isRoot);
        innerTag = isc.Comm._xmlCloseTag(tag);
    }
    if (canBeFormula && object.valueFrom) {
        // Serialize with a schema so contained valueFrom mappings are written correctly
        var tag = "case",
            schema = isc.DS.get("ValueFromMapping")
        ;
        if (schema) {
            var inner = isc.SB.create();
            var innerPrefix = (prefix != null ? isc.StringBuffer.concat(prefix, "\t") : "");
            inner.append("\n", innerPrefix,
                isc.Comm._xmlOpenTag("valueFrom", null, null, null, isFormula, isRoot));

            var cases = object.valueFrom;
            if (!isc.isAn.Array(cases)) cases = [cases];
            for (var i = 0; i < cases.length; i++) {
                inner.append(schema.xmlSerialize(cases[i],null,(innerPrefix != null ? isc.StringBuffer.concat(innerPrefix, "\t") : ""),tag));
            }
            inner.append("\n", innerPrefix, isc.Comm._xmlCloseTag("valueFrom"));

            result = isc.StringBuffer.concat(
                result,
                (prefix != null ? isc.StringBuffer.concat(prefix, "\t") : ""),
                inner.release(false),
                (prefix != null ? isc.StringBuffer.concat("\n", prefix) : ""),
                isc.Comm._xmlCloseTag(name)
                );
            return result;
        }
        // If schema isn't found, fall back to just a wrapping
        result += isc.Comm._xmlOpenTag(tag, tag, null, null, null, isRoot);
        innerTag = isc.Comm._xmlCloseTag(tag);
    }

    object = isc.JSONEncoder._serialize_cleanNode(object);

    // for each key in the object
    for (var key in object) {

        if (key == null) continue;


        if (key == isc.gwtRef || key == isc.gwtModule) continue;

        // XML identifiers can't start with $ (parser crashes)
        if (key.startsWith('$')) continue;

        var value = object[key];

        // NOTE: null is a real value. undefined should be treated as null for cases where
        // a field's value is cleared.


        // if the value is a function, skip it
        // Exception - we can serialize actions by looking at function.iscAction - in this
        // case retain it
        if (isc.isA.Function(value) && !value.iscAction) continue;

        // convert the key to a string
        var keyStr = key.toString();

        var context = {
            objRefs: objRefs,
            objPath: isc.JSONEncoder._serialize_addToPath(objPath, key),
            isRoot: false,
            fieldCanBeFormula: canBeFormula
        };

        // transform the value
        result = isc.StringBuffer.concat(
                result,
                (prefix != null ? isc.StringBuffer.concat("\n", prefix, "\t") : ""),
                isc.Comm._xmlSerialize(keyStr, value,
                                       (prefix != null ? isc.StringBuffer.concat(prefix, "\t") : null),
                                       context)
                );
    }

    // close xml tag
    result = isc.StringBuffer.concat(
            result,
            (prefix != null ? isc.StringBuffer.concat("\n", prefix) : ""),
            innerTag,
            isc.Comm._xmlCloseTag(name)
            );

    return result;
},

_getPrefix : function (prefixes, namespace) {
    if (prefixes[namespace] != null) {
        // re-use a declared prefix
        return prefixes[namespace];
    } else {
        // establish a new NSURI -> prefix mapping
        if (prefixes._nsCount == null) prefixes._nsCount = 0;
        return (prefixes[namespace] = "ns" + prefixes._nsCount++);
    }
},


// helper method - returns an xml open tag with the (optional) type.
_xmlOpenTag : function (tagName, type, namespace, prefix, leaveOpen, isRoot) {

    var output = isc.SB.create();

    var writeNamespace = namespace != null;

    // if "prefix" is passed as an object, use it to accrue a map from namespace to namespace
    // prefix, but don't actually write out any namespaces, relying on the calling code to do
    // so
    if (namespace != null && isc.isAn.Object(prefix)) {
        writeNamespace = false;
        prefix = this._getPrefix(prefix, namespace);
    }

    // encode the name in '_isc_name' if it's not a valid XML identifier
    var extraXML = '';
    if (!this._isValidXMLIdentifier(tagName)) {
        extraXML = ' _isc_name="' + isc.makeXMLSafeAttribute(tagName) + '"';
        tagName = "Object";
    }

    if (namespace) {
        prefix = prefix || "schNS";
        output.append("<", prefix, ":", tagName);
        if (writeNamespace) output.append(" xmlns:", prefix, "=\"", namespace, "\"");
    } else {
        output.append("<", tagName);
    }
    if (extraXML) output.append(extraXML);

    // if the object is root-level, we add the xsi namespace declaration to
    // allow usage of xsi types inline

    if (isRoot && (!this.omitXSI || this.writeDatetimeXSI) && !this.omitXMLNS) {
        output.append(" xmlns:xsi=\"http://www.w3.org/2000/10/XMLSchema-instance\"");
    }

    // if an xsi type is passed in for this object, mark the object with that type
    if (type &&
          (!this.omitXSI || (this.writeDatetimeXSI && isc.SimpleType.inheritsFrom(type, "datetime"))) &&
          (!this.omitStringXSI || !isc.SimpleType.inheritsFrom(type, "text")))
    {
        output.append(" xsi:type=\"xsd:", isc.makeXMLSafeAttribute(type), "\"");
    }

    if (!leaveOpen) output.append(">");

    return output.release(false);
},

// helper method - returns an xml close tag
_xmlCloseTag : function (name, namespace, prefix) {

    if (namespace != null && isc.isAn.Object(prefix)) {
        prefix = this._getPrefix(prefix, namespace);
    }

    if (!this._isValidXMLIdentifier(name)) name = "Object";

    if (namespace) {
        prefix = prefix || "schNS";
        return isc.SB.concat("</", prefix, ":", name, ">");
    } else {
        return isc.SB.concat("</", name, ">");
    }
},

// helper method - returns the passed in value verbatim, sandwiched between the outputs of
// _xmlOpenTag and _xmlClosetTag methods with the optional type.
_xmlValue : function (name, value, type, namespace, prefix) {
        if (type == "base64Binary") {
            value = "<xop:Include xmlns:xop=\"http://www.w3.org/2004/08/xop/include\" href=\""
                + value + "\"/>";
        }
        if (type == "nil") {
            return isc.Comm._xmlOpenTag(name, null, namespace, prefix, true)
                        + " xsi:nil=\"true\"/>";

        }
        return isc.StringBuffer.concat(
                isc.Comm._xmlOpenTag(name, type, namespace, prefix),
                value,
                isc.Comm._xmlCloseTag(name, namespace, prefix)
                );
}

});    // END isc.addMethods(isc.Comm, {})



//> @type XMLDocument
// XMLDocument is the "parsed" or object form of XML, which allows XML to be navigated as
// a tree of nodes with attributes, namespaces and other metadata, as opposed to being
// manipulated as just a String.
// <P>
// XMLDocument is a native object supplied directly by the browser.  The SmartClient-supported
// interfaces for this object are methods that take an XMLDocument as an argument (such as
// +link{XMLTools.selectNodes()}).  If you want to retrieve XML data and display it in a
// SmartClient component, read about +link{group:clientDataIntegration,XML Data Binding}.  To
// extract data as JavaScript Objects from XML, see +link{XMLTools.toJS()}.  Direct
// manipulation of XMLDocument is subject to cross-browser inconsistencies, bugs, memory leaks
// and performance issues.
//
// @visibility xmlBinding
//<

//> @type XMLElement
// An XMLElement represents one complete XML tag, including any subelements contained between
// the start and end tags.
// <P>
// XMLElement is a native object supplied directly by the browser.  The SmartClient-supported
// interfaces for this object include methods that take an XMLElement as an argument (such as
// +link{XMLTools.selectNodes()}).  If you want to retrieve XML data and display it in a
// SmartClient component, read about +link{group:clientDataIntegration,XML Data Binding}.  To
// extract data as JavaScript Objects from XML, see +link{XMLTools.toJS()}.  Direct
// manipulation of XMLElements objects is subject to cross-browser inconsistencies, bugs,
// memory leaks and performance issues.
//
// @visibility xmlBinding
//<




isc.defineClass("XMLDoc").addMethods({
    addPropertiesOnCreate:false,
    init : function (xmlDoc, namespaces) {
        this.nativeDoc = xmlDoc;
        this.namespaces = namespaces;
        // the most common property access
        this.documentElement = this.nativeDoc.documentElement;
    },
    hasParseError : function () {
        if (isc.Browser.isIE) {
            var parseError = this.nativeDoc.parseError;
            // IE8 now returns zero for no error
            return parseError != null && parseError != 0;
        }
        return this.nativeDoc.documentElement &&
                this.nativeDoc.documentElement.tagName == "parsererror"; //FF
    },
    addNamespaces : function (namespaces) {
        this.namespaces = this._combineNamespaces(namespaces);
        // HACK: in the Comm watcher, for experimenting with XPath selection against XML
        // replies, it's key that any namespaces added to the XMLDoc are available.
        if (this._responseID) {
            var xmlResponse = isc.xml.xmlResponses.find("ID", this._responseID);
            if (xmlResponse) xmlResponse.xmlNamespaces = this.namespaces;
            //this.logWarn("looked up response: " + this._responseID +
            //             " and grabbed namespaces : " + this.echo(this.namespaces));
        }
    },
    _combineNamespaces : function (namespaces) {
        if (namespaces == null) return this.namespaces;
        if (this.namespaces == null) return namespaces;
        return isc.addProperties({}, this.namespaces, namespaces);
    },
    // convenience methods
    selectNodes : function (xPath, namespaces, single) {
        return isc.xml.selectNodes(this.nativeDoc, xPath,
                                   this._combineNamespaces(namespaces), single);
    },
    selectString : function (xPath, namespaces) {
        return isc.xml.selectString(this.nativeDoc, xPath,
                                    this._combineNamespaces(namespaces));
    },
    selectNumber : function (xPath, namespaces) {
        return isc.xml.selectNumber(this.nativeDoc, xPath,
                                    this._combineNamespaces(namespaces));
    },
    selectScalar : function (xPath, namespaces, asNumber) {
        return isc.xml.selectScalar(this.nativeDoc, xPath,
                                    this._combineNamespaces(namespaces), asNumber);
    },
    selectScalarList : function (xPath, namespaces) {
        return isc.xml.selectScalarList(this.nativeDoc, xPath,
                                        this._combineNamespaces(namespaces));
    },

    // passthroughs (consider writePassthroughFunctions() if this expands)
    getElementById : function (id) { return this.nativeDoc.getElementById(id) },
    getElementsByTagName : function (tagName) {
        return this.nativeDoc.getElementsByTagName(tagName)
    }
});
isc.XMLDoc.getPrototype().toString = function () {
    return "[XMLDoc <" + this.documentElement.tagName + ">]";
};

//> @class XMLTools
// Utility methods for dealing with XML elements, XML Schema, WSDL files, XSLT, and other
// XML-related functionality.
//
// @treeLocation Client Reference/Data Binding
// @visibility external
//<
isc.defineClass("XMLTools").addClassProperties({

// Retrieval and Parsing
// ---------------------------------------------------------------------------------------



//> @classMethod XMLTools.loadXML()
// Load an XML document from the origin server or from a foreign server by relaying through the
// origin server.  An asynchronous callback provides both the XML document and raw text of the
// response.
// <P>
// Relaying through the origin server requires that the ISC HttpProxyServlet be installed and
// accessible.
//
// @param URL      (URL)       URL to load the schema from
// @param callback (Callback)  callback to fire when the XML is loaded.  Signature is
//                             callback(xmlDoc, xmlText)
// @param [requestProperties] (RPCRequest) additional properties to set on the RPCRequest
//                                         that will be issued
//
// @visibility external
//<
loadXML : function (url, callback, requestProperties) {
    requestProperties = requestProperties || {};
    requestProperties.operationType = requestProperties.operationType || "loadXML";

    this.getXMLResponse(isc.addProperties({
        actionURL : url,
        httpMethod:"GET",
        callback:callback
    }, requestProperties));
},

// getXMLResponse: like rpc.sendProxied(), but parses the result as XML and gives an
// XML-specific callback of (xmlDoc,xmlText)
getXMLResponse : function (request) {
    // do an indirect callback
    request._xmlIndirectCallback = request.callback;
    request.callback = { target : this, methodName : "_getXMLResponseReply" };

    // default to POST
    request.httpMethod = request.httpMethod || "POST";

    this.logInfo("loading XML from: " + request.actionURL, "xmlComm");
    isc.rpc.sendProxied(request);
},

xmlResponses : [],
_nextResponseID : 0,
// Undocumented attribute to handle the case where we check for an empty (whitespace-only)
// response. We don't want to "trim" a massive XML doc which could be expensive, so
// avoid the call if the text exceeds this length.
trimEmptyXMLThreshold:100,
_getXMLResponseReply : function (rpcResponse, data, rpcRequest) {
    // if we already have a structured response don't try to parse it as XML
    // XXX - unless it's a RestRequest, in which case this is normal (the structured response
    // has been broken up into response specific XML substrings by RPCManager._performTransactionReply)
    // This can occur if an operation timed out
    if (rpcResponse.isStructured && !rpcRequest.isRestRequest) {
        this.fireCallback(rpcRequest._xmlIndirectCallback,
                      // NOTE: request/response probably only for internal callers
                      "xmlDoc,xmlText,rpcResponse,rpcRequest",
                      [null,null,rpcResponse,rpcRequest]);
        return;
    }

    var xmlText = rpcRequest.isRestRequest ? rpcResponse.results : rpcResponse.httpResponseText,
        xmlDoc = this.parseXML(xmlText);

    if (this.logIsInfoEnabled("xmlComm")) {
        this.logInfo("XML reply with text: " +
                     (this.logIsDebugEnabled("xmlComm") ? xmlText : this.echoLeaf(xmlText)),
                    "xmlComm");
    }

    // if the parsedXML failed parsing, set a status of -1 and fire callback
    // Exception - allow a totally empty response to continue - this is useful for
    // REST dataSources where the request kicks off server logic but the service doesn't
    // actually return meaningful response text.
    var isEmptyResponse = false;
    if (xmlText == null ||
        (xmlText.length < this.trimEmptyXMLThreshold && xmlText.trim() == ""))
    {
        isEmptyResponse = true;
    }

    if(!isEmptyResponse && (!xmlDoc || xmlDoc.getElementsByTagName("parsererror").length>0)) {
        rpcResponse.status = -1;
    } else {
        // retain last 5 responses in an Array for programmatic debugging
        var responses = this.xmlResponses;

        // NOTE: with the log window permanently open, you only need to enable xmlComm to catch
        // comm responses before page load
        if (this.logIsDebugEnabled("xmlComm") ||
            (isc.Page.isLoaded() && isc.debugMaster))
        {
            var responseID = this._nextResponseID++;
            responses.add({
                ID : responseID,
                text : xmlText
            });
            // HACK: label the XMLDoc created from this xmlText with the id of the response - this
            // allows the XMLDoc to tack xml namespaces onto the response later
            if (xmlDoc) xmlDoc._responseID = responseID;

            // keep a limited number of responses
            if (responses.length > 10) responses.shift();

            // update log window if showing
            if (isc.debugMaster) isc.debugMaster.call("window.updateCommWatcher", [responses]);
        } else {
            responses.length = 0;
        }
    }
    this.fireCallback(rpcRequest._xmlIndirectCallback,
                      // NOTE: request/response probably only for internal callers
                      "xmlDoc,xmlText,rpcResponse,rpcRequest",
                      [xmlDoc,xmlText,rpcResponse,rpcRequest]);
},

useIEXMLHackaround: isc.Browser.isIE,

//> @classMethod XMLTools.disableIEXMLHackaround()
// Disables an Internet Explorer-specific work around for the MSXML bug that the 'xml' namespace
// prefix cannot be explicitly declared.
// <p>
// Though redundant,
// the +externalLink{http://www.w3.org/TR/REC-xml-names/#xmlReserved,Namespaces in XML spec allows}
// XML documents to explicitly declare namespace prefix 'xml' bound to namespace name
// <code>http://www.w3.org/XML/1998/namespace</code>; e.g.
// <pre>xmlns:xml="http://www.w3.org/XML/1998/namespace"</pre>
// MSXML does not allow the 'xml' namespace prefix to be declared, and will raise the XML
// parse error: The namespace prefix is not allowed to start with the reserved string "xml".
// Microsoft has disclosed this bug as a Normative Variation in MSXML:
// +externalLink{http://msdn.microsoft.com/en-us/library/ff460535(v=vs.85).aspx}.
// A framework-level work around is used by default in +link{XMLTools.parseXML()} where if the
// string <code>xmlns:xml="http://www.w3.org/XML/1998/namespace"</code> or
// <code>xmlns:xml='http://www.w3.org/XML/1998/namespace'</code> is found in the first 1000
// characters of the <code>xmlText</code> parameter to parseXML(), then these two strings are
// removed from <code>xmlText</code> wherever they appear. This work around may be disabled by
// calling disableIEXMLHackaround() at any time before parseXML() is called.
// @visibility external
//<
disableIEXMLHackaround : function () {
    this.useIEXMLHackaround = false;
},


//                    IE6                   IE5.5                we used to use this
xmlDOMConstructors : ["MSXML2.DOMDocument", "MSXML.DOMDocument", "Microsoft.XMLDOM"],


//> @classMethod XMLTools.parseXML()
// Parse XML text into an +link{XMLDocument}.  Parse errors, if any, are reported to the log.
// <p>
// <strong>NOTE:</strong> Internet Explorer's XML parser implementation, MSXML, has a bug in its
// handling of namespace name <code>http://www.w3.org/XML/1998/namespace</code>. Though redundant,
// the +externalLink{http://www.w3.org/TR/REC-xml-names/#xmlReserved,Namespaces in XML spec allows}
// XML documents to explicitly declare namespace prefix 'xml' bound to namespace name
// <code>http://www.w3.org/XML/1998/namespace</code>; e.g.
// <pre>xmlns:xml="http://www.w3.org/XML/1998/namespace"</pre>
// MSXML does not allow the 'xml' namespace prefix to be declared, and will raise the XML
// parse error: The namespace prefix is not allowed to start with the reserved string "xml".
// Microsoft has disclosed this bug as a Normative Variation in MSXML:
// +externalLink{http://msdn.microsoft.com/en-us/library/ff460535(v=vs.85).aspx}.
// A framework-level work around is used by default where if the string
// <code>xmlns:xml="http://www.w3.org/XML/1998/namespace"</code> or
// <code>xmlns:xml='http://www.w3.org/XML/1998/namespace'</code> is found in the first 1000
// characters of <code>xmlText</code>, then these two strings are removed from <code>xmlText</code>
// wherever they appear. This work around may be disabled by calling +link{XMLTools.disableIEXMLHackaround()}
// at any time before parseXML() is called.
//
// @param xmlText (String) XML text to be parsed
// @return (XMLDocument) resulting XMLDocument
// @visibility external
//<

mozAnchorBug : isc.Browser.isMoz && (isc.Browser.geckoVersion < 20080205)
                && window.location.href.indexOf("#") != -1,
_xmlNamespaceDeclarationRegExp: /xmlns:xml=(?:"http:\/\/www.w3.org\/XML\/1998\/namespace"|'http:\/\/www.w3.org\/XML\/1998\/namespace')/g,
parseXML : function (xml, suppressErrors) {
    if (xml == null) return; // Moz will actually throw exceptions in this case

    xml = this.trimXMLStart(xml);

    if (this.useIEXMLHackaround) {
        if (this._xmlNamespaceDeclarationRegExp.test(xml.substring(0, 1000))) {
            xml = xml.replace(this._xmlNamespaceDeclarationRegExp, "");
        }
    }

    var doc;
    if (!isc.Browser.isIE) {
        try {

            if ((this.mozAnchorBug || this.useAnchorWorkaround) &&
                this.useAnchorWorkaround !== false)
            {
                var iframeHTML = "<IFRAME STYLE='position:absolute;visibility:hidden;top:-1000px'"
                                +" ID='isc_parseXMLFrame'></IFRAME>";
                if (!isc.Page.isLoaded()) {
                    document.write(iframeHTML);
                } else {
                    isc.Element.insertAdjacentHTML(document.getElementsByTagName("body")[0], "beforeEnd", iframeHTML)
                }
                var iframe = document.getElementById("isc_parseXMLFrame");
                var iframeWindow = iframe.contentWindow;


                window.isc.xmlSource = xml;
                iframeWindow.location.href = "javascript:top.isc.parsedXML="
                    + "new top.isc.XMLTools.getXMLParser().parseFromString(top.isc.xmlSource, 'text/xml')";
                doc = window.isc.parsedXML;

                isc.xmlSource = isc.parsedXML = null;

                // remove the iframe
                iframe.parentNode.removeChild(iframe);
            } else {
                doc = this.getXMLParser().parseFromString(xml, "text/xml");
            }
        } catch (e) {
            if (!suppressErrors) this._logParseError(this.echo(e));
            return null;
        }

        if (!suppressErrors && doc.documentElement &&
             doc.documentElement.tagName == "parsererror")
        {
            this._logParseError(doc.documentElement.textContent);
            return null;
        }

        return isc.XMLDoc.create(doc);
    }

    doc = this.getXMLParser();
    if (!doc) {
        this._warnIfNativeXMLUnavailable("XMLTools.parseXML()");
        return;
    }

    doc.loadXML(xml);
    if (doc.parseError != 0) {
        var error = doc.parseError;
        if (!suppressErrors) {
            this._logParseError(
                "\rReason: " + error.reason +
                "Line number: " + error.line + ", character: " + error.linepos +
                "\rLine contents: " + error.srcText +
                (!isc.isA.emptyString(error.url) ? "\rSource URL: " + error.url : ""));
        }
        return null;
    }
    return isc.XMLDoc.create(doc);
},

// NOTE: don't obfuscate "trimXMLStart", used by dev console
trimXMLStart : function (xml) {


    if (xml.indexOf("<?xml") != -1)
    {

        var match = xml.match(new RegExp("^\\s*<\\?[^?]*\\?>"));
        if (match) {
            xml = xml.substring(match[0].length);
            //this.logWarn("match is: " + this.echoAll(match) + ", trimming by: " + match[0].length);
        }
    }


    if (isc.Browser.isIE && xml.indexOf("<!DOCTYPE") != -1) {
        var match = xml.match(new RegExp("^\\s*<!DOCTYPE .*>"));
        if (match) {
            xml = xml.substring(match[0].length);
            //this.logWarn("match is: " + this.echoAll(match) + ", trimming by: " + match[0].length);
        }
    }
    return xml;
},

_logParseError : function (errorText, xml) {
    this.logWarn("Error parsing XML: " + errorText +
                 (this.logIsDebugEnabled("parseXML") ?
                  "\rXML was:\r" + xml + "\rTrace:" + this.getStackTrace() : ""),
                 "parseXML");
},


getXMLParser : function () {
    // Moz/Firefox, Safari support a native DOMParser
    if (!isc.Browser.isIE) {
        if (!this._parser) this._parser = new DOMParser();
        return this._parser;
    }

    var parser;
    if (this._xmlDOMConstructor) {
        parser = new ActiveXObject(this._xmlDOMConstructor);
    } else {
        for (var i = 0; i < this.xmlDOMConstructors.length; i++) {
            try {
                var cons = this.xmlDOMConstructors[i];
                parser = new ActiveXObject(cons);
                if (parser) {
                    this.logInfo("Using XML DOM constructor: " + cons);
                    this._xmlDOMConstructor = cons;
                    break;
                }
            } catch (e) { }
        }
        if (!parser) {
            this.logWarn("Couldn't create XML DOM parser - tried the following"
                         +" constructors: "+this.echoAll(this.xmlDOMConstructors));
        }
    }
    return parser;
},

//> @classMethod XMLTools.nativeXMLAvailable()
//
// Returns true if the current browser exposes an XML parser that can be used for SmartClient
// XML operations like web service bindings and XML processing.  See
// +link{group:platformDependencies} for more information on when the XML parser may not
// available and what features are impacted as a result.
//
// @return (boolean) true if native XML processing is available, false otherwise.
//
// @visibility external
//<
nativeXMLAvailable : function () {

    if (isc.Browser.isSafari && !isc.Browser.isApollo && (isc.Browser.safariVersion < 522))
        return false;
    return this._parser != null || this.getXMLParser() != null;
},


_warnIfNativeXMLUnavailable : function (featureName) {
    if (this.nativeXMLAvailable() || !this.logIsWarnEnabled()) return false;

    var message = "Feature " + featureName + " requires a native XML parser which is "
                  + "not available ";
    if (isc.Browser.isSafari) {
        message += "because this version of Safari does not support native XML processing.";
    } else {
        // IE ActiveX
        message += "because ActiveX is currently disabled.";
    }
    message += " Please see the 'Features requiring ActiveX or Native support'"
              +" topic in the client-side reference under Client Reference/System"
              +" for more information";
    this.logWarn(message);
    return true;
},

// Access / serverToJS
// ---------------------------------------------------------------------------------------

// call the server to do an XML2JS conversion, evals result
serverToJS : function (xmlString, callback, evalVars) {
    isc.DMI.callBuiltin({
        methodName: "xmlToJS",
        callback: callback,
        arguments: xmlString,
        requestParams: {
            evalVars: evalVars,
            evalResult: true
        }
    });
},

// calls the server to do an XML2JS conversion, returns string as 'data' in callback
toJSCode : function (xmlString, callback) {
    isc.DMI.callBuiltin("xmlToJS", xmlString, callback);
},


// convert an XML or DOM element to a JavaScript object.  Attributes and subelements become
// properties.  Note: if nodeNames collide, last one wins.  Also note that getElementsByTagName(*)
// returns all children nodes recursively - not just the immediate children.  So you get a flat
// representation of a potentially nested object.  See the more expensive toJS() for a nested
// result.
_$star : "*",
elementToObject : function (element) {
    if (element == null) return null;

    var object = this.getAttributes(element);

    // transform subelements to properties
    var children = element.getElementsByTagName(this._$star);
    for (var i = 0; i < children.length; i++) {
        var child = children[i];
        object[child.tagName] = this.getElementText(child);
    }

    return object;
},

_$colon : ":",
// return the non-namespace-prefixed tagName, or #text / #comment / #cdata-section for text
// nodes
getLocalName : function (node) {
    // All: tagName/nodeName prefixed
    // Moz: localName is non-prefix'd
    if (!isc.Browser.isIE) {
        var localName = node.localName;
        if (localName == null) return node.nodeName; // for #text nodes in Moz
        return localName;
    }


    var name = node.nodeName,
        colonIndex = name.indexOf(this._$colon);
    if (colonIndex != -1) return name.substring(colonIndex + 1);
    return name;
},

//> @classMethod XMLTools.toJS()
// Translates an XML fragment to JavaScript collections.  This method works just like the
// server-side method XML.toJS(Element, Writer):
// <ul>
// <li>  Elements become JavaScript Objects with each attribute becoming a property
// <li>  Subelements with just text (no child elements or attributes) become properties
// <li>  Subelements with child elements or attributes become sub objects
// </ul>
// For example, if you pass the following fragment to this method:
// <pre>
// &lt;foo&nbsp;bar="zoo"&gt;
//     &nbsp;&nbsp;&lt;x&gt;y&lt;/x&gt;
// &lt;/foo&gt;
// </pre>
// You will get back the following JS structure:
// <pre>
// { bar:"zoo", x:"y"}
// </pre>
// All atomic property values will be of String type.  Use +link{DataSource.recordsFromXML()}
// to do schema-driven XML to JS transform, which can produce correctly typed values.
//
// @param element (XMLElement | XMLDocument) The element to transform to JS
// @return (Object) The resulting JavaScript collection.
//
// @visibility external
// @example xmlServerValidationErrors
//<
// deep transform XML to JS.  calls itself recursively.  subelements with just the value get
// collapsed, key collisions are turned into arrays.  There are almost certainly still
// differences from server-side transform but none are known at this time.
//
// You can supply an array of fieldNames to look for ("attrMask") - this limits the output data
// to those fields, and is substantially faster in IE for an XML representation that uses lots
// of attributes rather than subelements
_$List : "List",
_$xmlToJS : "xmlToJS",
toJS : function (element, attrMask, dataSource, widgetXML, context) {
    if (element == null) return null;
    if (isc.isAn.XMLDoc(element)) element = element.nativeDoc;
    if (element.documentElement) element = element.documentElement;
    context = context || isc.emptyObject;

    // handle arrays of elements
    if (isc.isAn.Array(element)) {
        var results = [];
        for (var i = 0; i < element.length; i++) {
            results[i] = this.toJS(element[i], attrMask, dataSource, widgetXML, context);
        }
        return results;

    }

    var object,
        fieldNames;

    // check explicit type

    var type = this.getExplicitType(element, widgetXML);
    if (widgetXML || !dataSource || (dataSource && isc.DS.get(type) == null)) {


        if (widgetXML) {
            // for widgetXML, detect <Canvas withID="someId"/>, the official way of referring to other
            // components
            var refId = this.isRefElement(element);
            if (refId)
            {
                var canvas = isc.Canvas.getById(refId);
                //this.logWarn("ref: " + refId + ", found related Canvas: " + canvas);
                if (canvas != null) return canvas;
            }
            // detect indirect refs <Canvas withID="someId"/>.  Eg if this schema is Menu.ds.xml
            // invoked from Canvas.contextMenu, we're being invoked on the <contextMenu>
            // element, and we need to check if it has a single child <Menu withID="someId"/>
            var firstChild = this.firstElementChild(element),
                refId = firstChild ? this.isRefElement(firstChild) : null;
            if (refId && this.getElementChildren(element).length == 1)
            {
                var canvas = isc.Canvas.getById(refId);
                //this.logWarn("withID: " + refId + ", found related Canvas: " + canvas);
                if (canvas != null) return canvas;
            }

            if (!type) {
                // in widgetXML mode, if there's no explicitly specified type on the element,
                // but the tag name matches any known complexType, treat this as a type
                // override.  Allows eg <ListGrid> to override the "members" field type being
                // "Canvas"
                var tagName = element.tagName;
                if (tagName == this._$List || isc.DS.get(tagName)) type = element.tagName;
            }
            // Special case of extracting a valueFrom.case which is really just a shorthand
            // for writing valueFrom mappings.
            if (!type && this.getLocalName(element) == "case") {
                var parent = element.parentElement;
                var parentName = this.getLocalName(parent);
                if (parentName == "valueFrom") {
                    type = isc.DS.get("ValueFromMapping");
                }
            }
        }


        // handle like field.multiple=true if List type explicitly specified.  In widgetXML
        // mode this includes a tag of <List>.
        if (type != null && type == this._$List) {
            var children = this.getElementChildren(element);
            return this.toJS(children, attrMask, dataSource, widgetXML, context);
        }

        // otherwise if explicit type is set (to something we recognize), honor it
        if (type) {
            if (isc.DS.get(type) != null) {
                // NOTE: this case currently occurs only for widgetXML mode and schemaless
                // mode, otherwise, you don't get into this block
                dataSource = isc.DS.get(type);
            } else if (isc.SimpleType.getType(type) != null) {
                // known simple type
                return isc.SimpleType.validateValue(type, this.getElementText(element));
            }
        }
    }

    // respect custom xmlToJS transform
    if (dataSource && dataSource.xmlToJS) return dataSource.xmlToJS(element, context);

    if (this.elementIsNil(element)) return null;

    // if a dataSource was passed, ask the DataSource to derive the field values for any field
    // that defines a valueXPath or getFieldValue function
    if (dataSource) {

        fieldNames = attrMask || dataSource.getFieldNames();
        object = {};
        for (var i = 0; i < fieldNames.length; i++) {
            var fieldName = fieldNames[i],
                field = dataSource.getField(fieldName);

            if (field == null ||
                (field.valueXPath == null && field.getFieldValue == null)) continue;

            var value = dataSource.getFieldValue(element, fieldName, field);
            if (value != null) {
                if (this.logIsDebugEnabled(this._$xmlToJS)) {
                    this.logDebug("valueXPath / getFieldValue() field: " +
                                  dataSource.ID + "." + fieldName +
                                  " on element: " + this.echoLeaf(element) +
                                  " got value: " + value, "xmlToJS");
                }
                object[fieldName] = value;
            }
        }
        //this.logWarn("object is now: " + this.echo(object));
    }

    // get attributes (or if a dataSource was passed, add to existing object without
    // clobbering)
    object = this.getAttributes(element, attrMask, object, dataSource != null, dataSource);

    // no attributes, no element children: convert to simple value

    if (!this._hasDataAttributes(object) &&
        !this.hasElementChildren(element) &&
        (!widgetXML || !dataSource || !isc.isAn.emptyObject(dataSource.fields)))
    {
        return this.getElementText(element);
    }


    if (object[this._$xsiType] && object[this._$xsiType] == "xsd:Object") {
        delete object[this._$xsiType];
    }

    // transform subelements to properties
    var children = element.childNodes;

    if (this.logIsDebugEnabled(this._$xmlToJS)) {
        this.logDebug("using DataSource: " + dataSource +
                      " for complex element: " + this.echoLeaf(element) +
                      " childNodes: " + this.echoLeaf(children) +
                      " has attributes: " + this._hasDataAttributes(object)
                      ,"xmlToJS");
    }

    var hadElementChildren = false;
    for (var i = 0; i < children.length; i++) {
        var child = children[i];

        // we want the non-namespaced name
        var childName = this.getLocalName(child);

        // skip text nodes, which in FF we get every time the source XML has CRs
        if (this.isTextNode(child)) continue;

        hadElementChildren = true;

        // if we have an attrMask, ignore child elements not listed in the attrMask
        if (attrMask && !attrMask.contains(childName)) continue;

        var field = dataSource ? dataSource.getField(childName) : null;
        // if there was a field defined with this name that had a valueXPath or getFieldValue
        // function, ignore the subelement
        if (field && (field.valueXPath || field.getFieldValue)) continue;

        var childValue;
        if (this.logIsInfoEnabled(this._$xmlToJS)) {
            this.logInfo("dataSource: " + dataSource +
                         ", field: " + this.echoLeaf(field) +
                         (field != null ? " type: " + field.type : "") +
                         ", XML element: " + this.echoLeaf(child), "xmlToJS");
        }

        // field.multiple means the immediate child is just a container tag indicating
        // the property name - the indirect children are the elements that actually
        // conform to the declared type and provide the value
        var fieldValue = child;
        if (field && field.multiple) {
            // use the indirectChildren as the value, unless they're aren't any
            var indirectChildren = this.getElementChildren(child);
            if (indirectChildren.length > 0) fieldValue = indirectChildren;
        }


        if (!dataSource || field == null || field.type == null || field.type == "any") {
            if (this.logIsDebugEnabled(this._$xmlToJS)) {
                this.logDebug("applying schemaless transform at: " +
                              (dataSource ? dataSource.ID : "[schemaless]") + "." + childName,
                              "xmlToJS");
            }
            // if we have no source of type, perform recursive schemaless transform.
            // Note we'll do this even if we have a field, but the field is typeless (the field
            // may, eg, specify multiple:true)
            childValue = this.toJS(fieldValue, null, null, widgetXML, context);
        } else {

            var childSchema = dataSource.getSchema(field.type);
            // if the field is of dataSource type, do recursive transform
            if (childSchema != null) {
                var childContext = field.propertiesOnly ? {propertiesOnly: true} : context;
                childValue = this.toJS(fieldValue, null, childSchema, widgetXML, childContext);

                if (this.logIsDebugEnabled(this._$xmlToJS)) {
                    this.logDebug("complexType field: " + this.echoLeaf(field) +
                                  " got value: " + this.echoLeaf(childValue),
                                  "xmlToJS");
                }
            // otherwise, get the simple value
            } else {
                // NOTE: there's no way to use eg xsi:type to override an explicitly declared
                // simple type on a field (no known use case for this however)

                // field is multiple:true
                if (isc.isAn.Array(fieldValue)) {
                    childValue = [];
                    for (var j = 0; j < fieldValue.length; j++) {
                        childValue.add(
                            dataSource.validateFieldValue(field,
                                                          this.getElementText(fieldValue[j]))
                        );
                    }
                } else {
                    childValue = dataSource.validateFieldValue(field,
                                                               this.getElementText(fieldValue));
                }

                if (this.logIsDebugEnabled(this._$xmlToJS)) {
                    this.logDebug("simpleType field: " + this.echoLeaf(field) +
                                  " got value: " + this.echoLeaf(childValue),
                                  "xmlToJS");
                }
            }
        }

        if (field && field.multiple) {
            // null or the empty string, the result of a nil or empty element
            // respectively, should be considered an empty array for a multiple field
            if (childValue == null || isc.isA.emptyString(childValue)) childValue = [];
            // anything else should be wrapped in an Array if it's singular
            else if (!isc.isAn.Array(childValue)) childValue = [childValue];
        }
        // For a non-schema childValue for a valueFrom (case), roll these up because
        // case is just a shorthand for writing the mappings
        if (!field && childName == "valueFrom" &&
            isc.isAn.Object(childValue) && childValue.case && isc.isAn.Array(childValue.case))
        {
            childValue = childValue.case;
        }

        // collision on the tagName - make an array
        if (object[childName]) {
            if (!isc.isAn.Array(object[childName])) object[childName] = [object[childName]];

            if (field && field.multiple && isc.isAn.Array(childValue)) {
                // for "multiple" fields, avoid nested Arrays
                object[childName].addList(childValue);
            } else {
                object[childName].add(childValue);
            }
        } else {
            object[childName] = childValue;
        }
    }

    // for an element that has no element children, store it's textContent, if any, as a
    // special property.  Note that we still drop text content around element children, but
    // this is typically either whitespace/CRs used for formatting, or the relative order of
    // the text and subelements matters and hence a very different representation would be
    // needed.
    if (!hadElementChildren) {
        var textContent = this.getElementText(element),
            prop = context.textContentProperty ||
                      (dataSource ? dataSource.textContentProperty : "xmlTextContent");

        // if there's a field definition for textContent, validate against it
        if (dataSource) {
            field = dataSource.getTextContentField();
            //this.logWarn("validating against textContentField: " + this.echoLeaf(field) +
            //             ", with validators: " + this.echoAll(field.validators));
            if (field) textContent = dataSource.validateFieldValue(field, textContent);
        }
        if (textContent != null && !isc.isAn.emptyString(textContent)) {
            object[prop] = textContent;
        }
    }


    // if we have a dataSource with a instanceConstructor property that maps to an existing
    // class, create a new one of those with the data we've mined off the XML

    if (widgetXML) {
        if (!object._constructor && dataSource && (dataSource.instanceConstructor || dataSource.Constructor)) {
            object._constructor = dataSource.instanceConstructor || dataSource.Constructor;
        }

        if (!object.scClassName && dataSource && dataSource.scClassName) {
            object.scClassName = dataSource.scClassName;
        }

        if (
            object._constructor &&
            (context == null || !context.propertiesOnly) &&
            isc.ClassFactory.getClass(object._constructor)
        ) {
            var Constructor = object._constructor;
            delete object._constructor;
            //this.logWarn("toJS creating an instance of: " + Constructor +
            //             " with properties: " + isc.echo(object));
            return isc.ClassFactory.newInstance(Constructor, object);
        }
    }

    return object;
},

// copied from BasicDataSource.getExplicitType() in server code
_$type : "type",
_$xsiType : "xsi:type",
getExplicitType : function (element, widgetXML) {
    if (element == null || this.isTextNode(element)) return;

    var type = this.getXSIAttribute(element, this._$type);
    if (type) {
        if (type.contains(isc.colon)) type = type.substring(type.indexOf(isc.colon)+1);
    } else if (widgetXML) {
        type = element.getAttribute("constructor");

        // Only honor constructor as a type if there is actually a DataSource
        // for it. Otherwise, specifying <ListGrid constructor="SomeSubclass" />
        // doesn't work property, because the attributes don't get validated
        // against the ListGrid type.
        if (type && !isc.DS.get(type)) type = null;
    }

    return type;
},

// for widgetXML, detect <Canvas withID="someId"/>, the official way of referring to other
// components
_$ref:"ref",
_$withID:"withID",
isRefElement : function (element) {
    if (element == null || this.isTextNode(element)) {
        return false;
    }
    var refId = element.getAttribute(this._$ref) || element.getAttribute(this._$withID);
    if (refId && element.attributes.length == 1 && !this.hasElementChildren(element)) return refId;
},

// converts isomorphic:XML to components, complains about missing system schema
toComponents : function (xmlDoc, context) {

    if (isc.DS.get("Canvas") == null) {
        this.logWarn("Can't find schema for Canvas - make sure you've loaded"
                     +" component schema via <isomorphic:loadSystemSchema/> jsp tag"
                     +" or by some other mechanism");
    }

    // accept string or xml document
    if (isc.isA.String(xmlDoc)) {
        // accept non-well-formed documents that are just a bunch of ISC components with no
        // containing <isomorphicXML> tag by wrapping the components in an <isomorphicXML> tag
        // if initial parse run fails
        var doc = this.parseXML(xmlDoc, true);
        if (doc.hasParseError()) {
            this.logWarn("xml failed to parse xmlDoc, wrapping in root node");
            doc = this.parseXML("<isomorphicXML>"+xmlDoc+"</isomorphicXML>");
        }
        xmlDoc = doc;
    }

    return this.toJS(xmlDoc, null, null, true, context);
},


_$number : "number",
getFieldValue : function (record, fieldName, field, dataSource, namespaces) {

    if (record.ownerDocument == null) return record[fieldName];

    // if a field is passed, it's from a UI component, and is the complete field definition
    // whether the UI component was databound or not because databound components merge their
    // fields against dataSource fields
    field = field || (dataSource ? dataSource.getField(fieldName) : isc.emptyObject);

    try {
        var value;
        if (field.valueXPath) {
            // if the field is of DataSource type, use the valueXPath to select nodes (not a
            // scalar value), and do recursive transform on those elements
            var fieldDS = (dataSource ? dataSource.getSchema(field.type) :
                                        isc.DS.get(field.type));
            if (fieldDS) {
                var elements = isc.xml.selectNodes(record, field.valueXPath, namespaces),
                    records = isc.xml.toJS(elements, null, fieldDS);

                // selectNodes always returns an Array, but we only want an Array value if the
                // field is declared multiple or if multiple nodes really did match.
                if (!field.multiple && records.length == 1) records = records[0];
                return records;
            } else {
                // otherwise simple scalar value
                value = isc.xml.selectScalar(record, field.valueXPath, namespaces);
            }
        } else {
            value = isc.xml.getXMLFieldValue(record, fieldName);
        }
        // the value retrieved from XML is always just a string, so we need to convert it
        // to the proper type.  NOTE: call instance method to allow overrides.
        dataSource = dataSource || isc.DS.get("Object");
        value = dataSource.validateFieldValue(field, value);
        //this.logWarn("At field: " + dataSource.ID + "." + field.name +
        //             " got value: " + this.echoLeaf(value));
        return value;
    } catch (e) {
       this.logWarn("error getting value for field: '" + fieldName +
                    (field.valueXPath ? "', valueXPath: '" + field.valueXPath : "") +
                    "' in record: " + this.echo(record) +
                    "\r: " + this.echo(e) + this.getStackTrace());
       return null;
    }
},

// given an XML element, get the value for the given fieldName by checking attributes, then
// subelements.  Returned value is always a String or null.
getXMLFieldValue : function (element, fieldName) {
    // attribute representation

    var attrValue = element.getAttribute(fieldName);
    if (attrValue != null) return attrValue;

    // subElement representation
    // NOTE: a tagName of "record" matches <foo:record> in Moz, but NOT in IE
    var subElement = element.getElementsByTagName(fieldName)[0];
    if (subElement == null) return null;
    return (isc.Browser.isIE ? subElement.text : subElement.textContent);
},

// whether the element has any attributes that should be considered data, as opposed to
// encoding directives like "xsi:type"
_hasDataAttributes : function (attributes) {
    for (var attrName in attributes) {
        if (attrName == this._$xsiType) continue;
        return true;
    }
    return false;
},


_$xmlnsColon: "xmlns:",
getAttributes : function (element, attrMask, object, dontClobber, dataSource) {
    // NOTE: hasAttributes() doesn't exist in IE

    // optionally add to existing object
    object = object || {};

    var undef;

    // look up the attributes specified by attrMask
    if (attrMask) {
        if (!isc.isAn.Array(attrMask)) attrMask = [attrMask];
        for (var i = 0; i < attrMask.length; i++) {
            var attrName = attrMask[i];
            if (dontClobber && object[attrName] !== undef) continue;
            var attrValue = element.getAttribute(attrName);
            if (attrValue == null || isc.isAn.emptyString(attrValue)) continue;

            if (dataSource && dataSource.getField(attrName)) {
                attrValue = dataSource.validateFieldValue(dataSource.getField(attrName),
                                                          attrValue);
            }
            object[attrName] = attrValue;
        }
        return object;
    }

    // transform attributes to properties
    var attrs = element.attributes;
    if (attrs != null) {
        for (var i = 0; i < attrs.length; i++) {
            var attr = attrs[i],
                attrName = attr.name;

            // Change constructor to _constructor, because constructor
            // has a special meaning for Javascript
            if (attrName == "constructor") attrName = "_constructor";

            if (dontClobber && object[attrName] !== undef) continue;

            // whether to include namespace declarations in JS data
            if (isc.startsWith(attrName, this._$xmlnsColon) &&
                dataSource && dataSource.dropNamespaceDeclarations) continue;

            var attrValue = attr.value;
            if (attrValue == null || isc.isAn.emptyString(attrValue)) continue;

            if (dataSource && dataSource.getField(attrName)) {
                attrValue = dataSource.validateFieldValue(dataSource.getField(attrName),
                                                          attrValue);
            }
            object[attrName] = attrValue;
        }
    }
    return object;
},



_$xsi : {
    nil : "xsi:nil",
    "null" : "xsi:null",
    type : "xsi:type"
},
xsiNamespaces : [
    "http://www.w3.org/2001/XMLSchema-instance",
    "http://www.w3.org/1999/XMLSchema-instance"
],
getXSIAttribute : function (element, attrName) {
    var value;
    // Opera requires that we call getAttributeNS to get the xsi elements, using e.g:
    // getAttribute("xsi:type") returns null, even if set.  Probably should use this code
    // with other browser as well, but it's slower (because we have to try all the
    // xsiNamespaces) and untested on other platforms.
    if (isc.Browser.isOpera) {
        for (var i = 0; i < this.xsiNamespaces.length; i++) {
            value = element.getAttributeNS(this.xsiNamespaces[i], attrName);
            if (value != null) return value;
        }
        return value;
    }

    return element.getAttribute(this._$xsi[attrName]);
},

_$nil : "nil",

_$null : "null",
_$false : "false",
_$zero : "0",
elementIsNil : function (element) {

    if (element == null || !isc.isA.XMLNode(element) || element.nodeType != 1) return false;


    var nilAttribute = this.getXSIAttribute(element, this._$nil);


    if (nilAttribute && nilAttribute != this._$false && nilAttribute != this._$zero) return true;

    var nilAttribute = this.getXSIAttribute(element, this._$null);
    if (nilAttribute && nilAttribute != this._$false && nilAttribute != this._$zero) return true;

    return false;
},


getElementText : function (element) {
    if (this.elementIsNil(element)) return null;
    if (!element) return null;
    var child = element.firstChild;
    if (!child) {
        // from Firefox 13 to Firefox 14 XML nodes representing attributes were changed to no
        // longer have a #text child.

        if ((isc.Browser.isMoz || isc.Browser.isChrome) && element.nodeType == 2) return element.value;
        return isc.emptyString; // empty element, but not marked nil
    }
    var text = child.data;

    if (isc.Browser.isMoz && text != null && text.length > 4000) return element.textContent;
    return text;
},

// whether an element is a text node
isTextNode : function (element) {
    if (element == null) return false;
    var nodeType = element.nodeType;
    // 3:text, 4:cdata, 8:comment
    return (nodeType == 3 || nodeType == 4 || nodeType == 8);
},

// whether an element has an element child (as opposed to only text children)
hasElementChildren : function (element) {
    return this.firstElementChild(element) != null;
},

// return the first element child (as opposed to text node child) if there is one, otherwise
// null
firstElementChild : function (element) {

    if (element == null ||
        (element.hasChildNodes != null && element.hasChildNodes() == false)) return null;

    var childNodes = element.childNodes;
    if (!childNodes) return null;
    var length = childNodes.length;
    for (var i = 0; i < length; i++) {
        var child = childNodes[i];
        if (!this.isTextNode(child)) return child;
    }
    return null;
},

// JS -> XML
// ---------------------------------------------------------------------------------------
setAttributes : function (element, values) {
    var undef;
    for (var propName in values) {
        var value = values[propName];

        if (value == null) {
            element.removeAttribute(propName);
            continue;
        }

        // setAttribute("attr", true) in IE stores "-1" (yes, seriously)
        if (isc.Browser.isIE && (value === true || value === false)) {
            value = isc.emptyString + value;
        }

        element.setAttribute(propName, values[propName]);
    }
},

// XPath
// ---------------------------------------------------------------------------------------

// make all namespaces declared on the document element available under the same prefix used in
// the document itself, and make the default namespace, if there is one, available as
// "default".  "namespaces" can be passed it to avoid redeclaration of existing prefixes.
_makeIEDefaultNamespaces : function (doc, namespaces) {

    var buffer = isc.SB.create(),
        docElement = doc.documentElement,
        namespaces = namespaces || isc.emptyObject,
        defaultNamespace;

    // if it hasn't been specified explicitly, try to figure out the default namespaces
    // NOTE: default is a keyword in IE
    if (!namespaces["default"]) {
        defaultNamespace = this._deriveDefaultNamespace(docElement);
        if (defaultNamespace) buffer.append('xmlns:default="', defaultNamespace, '" ');
    }

    // add all the namespaces on the document element
    var attrs = doc.documentElement.attributes;
    for (var i = 0; i < attrs.length; i++) {
        var attr = attrs[i],
            prefix = attr.prefix;
        // NOTE: attr.name is the full name of the attribute, including prefix, so for a
        // non-default namespace declaration attr.name will be eg xmlns:somePrefix
        if (prefix == "xmlns" && prefix != attr.name) {
            // don't redefine already defined selection namespaces
            // NOTE: baseName is IE-only
            if (namespaces[attr.baseName] != null) continue;
            buffer.append(attr.name, '="', attr.value, '" ');
        }
    }
    return buffer.release(false);
},


// Method to determine the "default" namespace by looking at the namespaceURI of the document
// element or (if appropriate) children of the documentElement.
// Used in IE as part of _makeIEDefaultNamespaces()
//
// Note: This handles the common case where the document element declares a namespace, but
// is itself in a different namespace
_deriveDefaultNamespace : function (docElement) {



    var shouldLog = this.logIsDebugEnabled("xmlSelect");
    if ((docElement.prefix == null || isc.isAn.emptyString(docElement.prefix)) &&
        docElement.namespaceURI)
    {
        if (shouldLog) {
            this.logWarn("using docElement ns, prefix: " + docElement.prefix,
                              "xmlSelect");
        }
        return docElement.namespaceURI;


    } else if (docElement.firstChild) {
        var defaultNamespace
        for (var i = 0; i < docElement.childNodes.length; i++) {
            var childNode = docElement.childNodes[i];
            // text nodes show up in the childNodes collection in Safari
            if (childNode.nodeType == 3) continue;

            var nsURI = childNode.namespaceURI;
            if (!nsURI) break;

            if (childNode.prefix == null || isc.isAn.emptyString(childNode.prefix)) {
                defaultNamespace = childNode.namespaceURI;
                break;
            }
        }
        if (defaultNamespace != null) {
            if (shouldLog) {
                this.logDebug("using default namespace detected on child: " +
                              defaultNamespace, "xmlSelect");
            }
        }
        // if there is no default namespace, still define the namespace prefix "default" as
        // the document element's namespace, for conveniece
        if (defaultNamespace == null && docElement.namespaceURI) {
            defaultNamespace = docElement.namespaceURI;
            if (shouldLog) {
                this.logDebug("using document element's namespace as default namespace: " +
                              defaultNamespace, "xmlSelect");
            }
        }
        // if no appropriate default namespace could be derived, still define one, so that
        // using "default:" doesn't create a JS error.  This allows an XPath like
        // "//default:item|//item" to handle both namespaced and non-namespaced RSS feeds
        if (!defaultNamespace) defaultNamespace = "http://openuri.org/defaultNamespace";
        return defaultNamespace;
    }
},


//> @classMethod xmlTools.selectObjects()   (A)
// Applies an XPath expression to JavaScript objects, returning matching objects.
// <P>
// Both child and attribute names are interpreted as property names, and array access notation
// can be used to select elements from Arrays.  For example:<pre>
//     var results = {
//        searchResults:[
//            { title:"Page One", relevance:6.3 },
//            { title:"Page Two", relevance:5.2,
//              summary: "Summary of Page One" }
//        ]
//     };
//
//     // returns the "searchResults" two-item Array
//     isc.XMLTools.selectObjects(results, "/searchResults");
//
//     // returns the first item under "searchResults", in an Array (NOTE: in XPath, Array
//     // index starts at 1, not 0)
//     isc.XMLTools.selectObjects(results, "/searchResults[1]");
//
//     // returns ["Page One"]
//     isc.XMLTools.selectObjects(results, "/searchResults[1]/title");
//
//     // also returns ["Page One"]
//     isc.XMLTools.selectObjects(results, "/searchResults[1]@title");
// </pre>
// A limited form of XPath "predicates", that is, expressions with brackets that filter
// returned objects, is allowed.  A predicate can be either:
// <ul>
// <li> a number only, eg [5], for Array access
// <li> the XPath function call "last()", eg [last()], to retrieve the last item
// <li> a property name (*without* any leading "@"), meaning that the property contains a value
//      that is considered "true" in JavaScript.  For example: [summary]
// <li> a property name, comparison operator, and either a number or String literal, for
//      example, [name = "bob"].  In this case the property can also be the XPath function
//      position(), for example, [position() > 5]
// </ul>
// Some examples of using simple predicates with the sample data above:
// <pre>
//     // returns an Array with only the first result
//     isc.XMLTools.selectObjects(results, "/searchResults[relevance > 5.5]");
//
//     // return an Array with only the second result, since the first has no summary
//     isc.XMLTools.selectObjects(results, "/searchResults[summary]");
// </pre>
// Details of the XPath -> Objects mapping:
// <ul>
// <li> JavaScript Object properties are considered element children, and text children do not
//      exist (in the XML model, text children exist *between* element children, but nothing
//      exists between JavaScript properties)
// <li> The contents of Array-valued properties are considered immediate element children (this
//      is consistent with the predicate "[5]" acting like Array access)
// <li> "*" in XML selects all element children, so "*" in Object XPath selects the values of
//      all properties, that is, +link{staticMethod:isc.getValues(),isc.getValues(object)}, except
//      that Array-valued properties are "flattened" into the returned list.
// </ul>
//
// @param object (Object) Object to select results from
// @param xPath (String) XPath expression
// @return (Array) Array of matching objects, or null for no match
// @visibility external
//<


_$leftBracket : "[",
selectObjects : function (object, xPath, singleValue) {
    if (isc.contains("|")) {
        var subExpressions = xPath.split(/|/),
            results = [];
        for (var i = 0; i < subExpressions.length; i++) {
            results.addList(this.selectObjects(subExpressions[i], object));
        }
        return results;
    }
    // canonicalize to an Array
    var objects = isc.isAn.Array(object) ? object : [object];

    if (xPath != isc.slash) {
        if (isc.startsWith(xPath, isc.slash)) {
            xPath = xPath.substring(1);

            if (isc.startsWith(xPath, isc.slash)) {
                this.logWarn("Selector '" + isc.slash + isc.slash + "' is not supported. It was truncated.");
                xPath = xPath.substring(1);
            }
        }

        var segments = xPath.split(/[\/@]/);

        //this.logWarn("segments: " + this.echo(segments));

        objects = this._selectObjects(segments, objects, isc.slash);
    }

    // return the single value, or null on no match
    if (singleValue && objects.length <= 1) return objects[0];

    return objects;
},

_selectObjects : function (segments, objects, path) {

    var segment = segments[0];
    segments = segments.length > 1 ? segments.slice(1) : null;
    //this.logWarn("at path: " + path +
    //             ", applying segment: '" + segment +
    //             "' to " + this.echoLeaf(objects));

    if (objects == null) return null;

    // break segment into nodeTest and predicate
    var predicate,
        nodeTest = segment,
        bracketIndex = segment.indexOf(this._$leftBracket);

    if (bracketIndex != -1) {
        nodeTest = segment.substring(0, bracketIndex);
        // extract predicate expression (NOTE: assume one only)
        predicate = segment.substring(bracketIndex + 1, segment.length-1);
        //this.logWarn("nodeTest: " + nodeTest + ", predicate: " + predicate);
    }

    // apply nodeTest to each node
    var resultObjects = [];
    for (var i = 0; i < objects.length; i++) {
        var object = objects[i];

        // apply the node test
        if (nodeTest != isc.star) {
            object = object[nodeTest];
        } else {
            var properties = isc.getValues(object);
            object = [];
            for (var i = 0; i < properties.length; i++) {
                if (!isc.isAn.Array(properties[i])) object.add(properties[i]);
                else object.addList(properties[i]);
            }
        }

        //this.logWarn("nodeTest: " + nodeTest + ", result: " + this.echoLeaf(object));

        if (object == null) continue;

        if (!isc.isAn.Array(object)) {
            resultObjects.add(object);
        } else {
            resultObjects.addList(object);
        }
    }

    // filter result by predicate
    if (predicate) {
        // canonicalize object to an Array if we have a predicate
        var predResult = this._applyPredicateExpression(resultObjects, predicate);

        //this.logWarn("predicate expression: '" + predicate +
        //             "' applied to: " + this.echoLeaf(resultObjects) +
        //             ", with result: " + this.echoLeaf(predResult));
        resultObjects = predResult;
    }

    if (segments == null || segments.length == 0) return resultObjects;

    //this.logWarn("recursing with remaining path: " + segments.join("/"));

    // recurse if there are more segments
    path += segment + isc.slash;
    return this._selectObjects(segments, resultObjects, path);
},

_applyPredicateExpression : function (objects, expr) {
    // check for simple index (this will actually accept anything that starts with a
    // number)
    var index = parseInt(expr);
    if (!isNaN(index)) {
        // xPath indices are 1-based
        return [objects[index - 1]];
    }

    if (expr == "last()") return [objects.last()];

    // NOTE: not making property first char vs remaining chars distinction in XML "QName"
    // identifier.  Allowing () as a quick way to allow the position() function
    var parts = expr.match(/^([a-zA-Z_0-9:\-\.\(\)]*)\s*(<|>|!=|=|<=|>=|)\s*(.*)$/),
        property, operator, value;
    //this.logWarn("predicate parts: " + parts);

    if (parts == null) {
        // assume just an identifier
        if (!expr.match(/^[a-zA-Z_0-9:\-\.]*$/)) {
            this.logWarn("couldn't parse predicate expression: " + expr);
            return null;
        }
        property = expr;
    } else {
        property = parts[1], // parts[0] is the entire match
        operator = parts[2],
        value = parts[3];
    }

    // convert this simple expression to a JavaScript expression we can apply to each object


    // XPath uses single = operator
    if (operator == "=") operator = "==";

    // XPath uses functions for true and false literals
    if (value == "true()") value = true;
    else if (value == "false()") value = false;

    // support the position() function specially, by passing in params
    if (property == "position()") property = "position";

    //this.logWarn("property: " + property + ", operator: " + operator + ", value: " + value);
    var predFunc = isc._makeFunction("item,position",
        "return " +
            (property != "position" ? "item." : "") + property +
            (operator ? operator + value : ""));

    // apply the function to each object
    var matchingObjects = [];
    //this.logWarn("predicate function: " + predFunc);
    for (var i = 0; i < objects.length; i++) {
        if (predFunc(objects[i], i+1)) matchingObjects.add(objects[i]);
    }
    return matchingObjects;
},

//> @classMethod XMLTools.selectNodes()
// Retrieve a set of nodes from an XML element or document based on an XPath expression.
// <P>
// If the target document is namespaced, namespace prefixes declared in the document element of
// the target document will be available, as well as the default namespace, if declared, under
// the prefix "default".
// <P>
// To declare your own namespace prefixes, provide a prefix to URI mapping as a simple JS
// Object, for example:
// <pre>
//   {
//      az : "http://webservices.amazon.com/AWSECommerceService/2005-03-23",
//      xsd : "http://www.w3.org/2001/XMLSchema"
//   }
// </pre>
// <P>
// <b>NOTE:</b> this API cannot be supported on the Safari web browser for versions earlier
// than 3.0.3.
//
// @param element (XMLElement | XMLDocument | String)  Native XMLElement,document, or xml string
//                                                     to select from
// @param expression (XPath)   XPath expression to use to select nodes
// @param [namespaces] (Map<Prefix,URI>) namespace mapping used by the expression
// @return (Array) list of nodes matching XPath
//
// @group xmlTransform
// @visibility xmlBinding
// @example xmlServerValidationErrors
//<
selectNodes : function (element, expression, namespaces, single) {
    if (isc.isA.String(element)) {
        element = this.parseXML(element);
    }

    if (isc.Browser.isSafari && (isc.Browser.isApollo || (isc.Browser.safariVersion < 522)))
    {
        this._warnIfNativeXMLUnavailable("XPath");
        return this.safariSelectNodes(element, expression, namespaces, single);
    }

    if (isc.isAn.XMLDoc(element)) {
        return element.selectNodes(expression, namespaces, single);
    }
    var start = isc.timestamp();
    var returnValue = this._selectNodes(element, expression, namespaces, single);
    var end = isc.timestamp();

    if (this.logIsInfoEnabled("xmlSelect")) {
        this.logInfo("selectNodes: expression: " + expression +
                     " returned " + this.echoLeaf(returnValue) +
                      ": " + (end-start) + "ms", "xmlSelect");
    }

    return returnValue;
},

// Do very crude emulation of XPath for older Safari and older WebKit (like Adobe AIR)
// where native XPath is not available.

safariSelectNodes : function (element, expression, namespaces, single) {

    var elements = [];

    if (!expression) {
        return null;
    }
    var recordName = expression.substring(expression.indexOf(":")+1);
    var pickUpSubElements;
    if (recordName.endsWith("/*")) {
        pickUpSubElements = true;
        recordName = recordName.substring(0, recordName.indexOf("/*"));
    }

    // NOTE: a tagName of "record" matches <foo:record> in Moz, but NOT in IE
    var nodeList = element.getElementsByTagName(recordName);

    if (pickUpSubElements && nodeList.length > 0) {
        var parent = nodeList[0];
        nodeList = parent.childNodes;
    }


    for (var i = 0; i < nodeList.length; i++) {
        // don't pick up text nodes -- can happen when iterating through childNode array
        // to simulate /* xpath
        if (nodeList[i].nodeType == 3) continue;
        elements.add(nodeList[i]);
    }
    // don't create a spurious Array for the most common case of a singular body
    // element

    if (pickUpSubElements && elements.length == 1) elements = elements[0];
    return elements;
},


// namespaces: map from prefix -> namespaceURI
// prefixes: option list of prefixes
_generateNamespaces : function (namespaces, prefixes, indent) {
    if (namespaces == null) return isc.emptyString;

    if (prefixes == null) prefixes = isc.getKeys(namespaces);

    var buffer = isc.SB.create(),
        indent = (indent != null ? "\n" + indent : "");
    for (var i = 0; i < prefixes.length; i++) {
        var prefix = prefixes[i];
        buffer.append(indent, " xmlns:", prefix, '="', namespaces[prefix], '"');
    }
    return buffer.release(false);
},

// called for Moz and Safari only - return a namespace to use for the "default:" prefix in
// XPath selection
_getDefaultNamespace : function (docElement) {
    // check for a default namespace on the document element.  Note this will get
    // the default namespace established by the document element, even if the
    // document element itself is in another namespace
    var docNS = docElement.lookupNamespaceURI("");

    if (isc.Browser.isSafari && (docNS == null || docNS == "")) {
        docNS = docElement.getAttribute("xmlns");
    }
    // fall back to the namespace of the document element, even if it's not a
    // default namespace
    if (docNS == null) docNS = docElement.namespaceURI;
    // fall back to non-namespaced elements
    if (docNS == null) docNS = "";

    return docNS
},

_selectNodes : function (element, expression, namespaces, single) {


    if (element == null) return;
    var doc = element.ownerDocument;
    if (doc == null && element.documentElement) {
        // a document object was passed
        doc = element;
        element = doc.documentElement;
    }
    // in the case of an empty response, doc could still be null, so return
    if (doc == null) return null;
    if (isc.Browser.isIE) {

        if (isc.Browser.version > 5.5) {
            doc.setProperty("SelectionLanguage", "XPath");

            var nsString = this._makeIEDefaultNamespaces(doc, namespaces);
            if (namespaces) nsString += this._generateNamespaces(namespaces);
            if (this.logIsDebugEnabled("xmlSelect")) {
                this.logDebug("selectNodes: expression: " + expression +
                              ", using namespaces: " + nsString, "xmlSelect");
            }
            doc.setProperty("SelectionNamespaces", nsString);
        }

        // if "single" was passed, select a single node
        if (single) return element.selectSingleNode(expression);

        // otherwise return an Array of nodes
        var nodes = element.selectNodes(expression);

        // convert native NodeList object to a JavaScript Array
        return this._nodeListToArray(nodes);
    }


    var baseResolver = doc.createNSResolver(doc.documentElement),
        defaultNamespace = this._getDefaultNamespace(doc.documentElement);
    if (this.logIsDebugEnabled("xmlSelect")) {
        this.logDebug("Using namespaces: " + isc.echo(namespaces) +
                      ", defaultNamespace: '" + defaultNamespace + "'", "xmlSelect");
    }
    var resolver = function (prefix) {
        // supplied namespaces first
        if (namespaces && namespaces[prefix]) return namespaces[prefix];
        if (prefix == "default") return defaultNamespace;
        return baseResolver.lookupNamespaceURI(prefix);
    };
    // 0 is resultType = XPathResult.ANY_TYPE
    var results = doc.evaluate(expression, element, resolver, 0, null);

    // if "single" was passed, just return the first node
    if (single) return results.iterateNext();

    // convert native nodeList object to JavaScript Array
    return this._nodeListToArray(results);
},

// convert a native NodeList object to a JavaScript Array.
// NodeLists are returned by native selectNodes() in IE or document.evaluate(xpath) in other
// browsers.  xmlElement.childNodes is also a NodeList
_nodeListToArray : function (nodeList) {
    var output = [];


    if (isc.Browser.isIE || nodeList.iterateNext == null) {
        for (var i = 0; i < nodeList.length; i++) {
            output.add(nodeList.item(i));

        }
    } else {
        var resultNode;
        while (resultNode = nodeList.iterateNext()) {
            output.add(resultNode);
        }
    }
    return output;
},

getElementChildren : function (element) {
    var output = [],
        childNodes = element.childNodes;
    for (var i = 0; i < childNodes.length; i++) {
        var child = childNodes[i];
        if (this.isTextNode(child)) continue;
        output.add(child);
    }
    return output;
},

//> @classMethod XMLTools.selectString() [A]
// Retrieve a string value from an XML element or document based on an XPath expression.
// <P>
// If more than one node matches, only the first node's value will be returned.
// <P>
// Namespacing works as described under +link{XMLTools.selectNodes()}
// <P>
// <b>NOTE:</b> this API cannot be supported on the Safari web browser for versions prior to
// 3.0.3.
//
// @param element (XMLElement | XMLDocument | String)  Native XMLElement,document, or xml string
//                                                     to select from
// @param expression (XPath)   XPath expression to use to select nodes
// @param [namespaces] (Map<Prefix,URI>) namespace mapping used by the expression
//
// @return (String) result of the XPath, in String form
//
// @group xmlTransform
// @visibility xmlBinding
// @example xmlServerValidationErrors
//<
selectString : function (element, expression, namespaces) {
    return this.selectScalar(element, expression, namespaces);
},

//> @classMethod XMLTools.selectNumber() [A]
// Retrieve a numeric value from an XML element or document based on an XPath expression.
// <P>
// If more than one node matches, only the first node's value will be returned.
// <P>
// Namespacing works as described under +link{XMLTools.selectNodes()}
// <P>
// <b>NOTE:</b> this API cannot be supported on the Safari web browser for versions prior to
// 3.0.3.
//
// @param element (XMLElement | XMLDocument | String)  Native XMLElement,document, or xml string
//                                                     to select from
// @param expression (XPath)   XPath expression to use to select nodes
// @param [namespaces] (Map<Prefix,URI>) namespace mapping used by the expression
//
// @return (Number) result of the XPath, in Number form
//
// @group xmlTransform
// @visibility xmlBinding
//<
selectNumber : function (element, expression, namespaces) {
    return this.selectScalar(element, expression, namespaces, true);
},

selectScalar : function (element, expression, namespaces, asNumber) {
    if (isc.isA.String(element)) element = this.parseXML(element);
    if (isc.isAn.XMLDoc(element)) return element.selectScalar(expression, namespaces, asNumber);

    // NOTE: the XPath standard allows you to ask for a specific "resultType", eg String or
    // Number, instead of a NodeSet.  Moz does implement this.  However, for both
    // resultType:String and resultType:Number, Moz returns identical results for absence of an
    // element vs empty element, whereas we'd like to be able to return null vs "" for these
    // two cases respectively.
    //
    // In IE we can get a singular node from selectSingleNode(), and we grab the and parseInt.
    //
    // NOTE also: in Moz at least, if we don't ask for a scalar type, Moz will never return it
    // for XPathResult.ANY: single text node results and single attribute results still return
    // unordered_node_iterator by default, with crashing stringValue and numberValue accessors

    // pass "true" to ask for a single node


    var value;
    if (isc.Browser.isSafari && isc.Browser.isApollo || (isc.Browser.safariVersion < 522)) {
        var name=expression.substring(expression.indexOf(":")+1);
        value = element.getElementsByTagName(name)[0];
    } else {
        value = this.selectNodes(element,expression,namespaces,true);
    }

    if (value == null) return null;
    var text = this.getElementText(value);
    return asNumber ? parseInt(text) : text;
},

// performs xpath select and returns array of strings that are the values of selected nodes.
//
// expects result of xpath select to be a list of Attribute or Text nodes.  Performs an in-place
// replacement on the list with the node values and returns that.
// XXX internal until this handles simple elements in addition to attributes
selectScalarList : function (element, expression, namespaces) {
    if (isc.isA.String(element)) element = this.parseXML(element);
    if (isc.isAn.XMLDoc(element)) return element.selectScalarList(expression, namespaces);

    var values = this.selectNodes(element, expression, namespaces);
    // Thank god attributes and text elements share the 'nodeValue' attribute that has the data.
    for (var i = 0; i < values.length; i++) {
        values[i] = values[i].nodeValue;
    }
    return values;
},

// XSLT
// ---------------------------------------------------------------------------------------

//> @classMethod XMLTools.transformNodes()
// Apply an XSLT Stylesheet to an XML Document.
// <P>
// This method cannot currently be supported on the Safari web browser versions prior to
// 3.0.3.
//
// @param inputDocument (XMLDocument) XML document to apply the transform to
// @param styleSheet    (XMLDocument) XSLT stylesheet to use for transform
// @return (String) stylesheet output
//
// @group xmlTransform
// @visibility xmlBinding
//<
transformNodes : function (inputDocument, styleSheet) {
    if (isc.isAn.XMLDoc(inputDocument)) inputDocument = inputDocument.nativeDoc;
    if (isc.isAn.XMLDoc(styleSheet)) styleSheet = styleSheet.nativeDoc;
    if (isc.Browser.isIE) {
        if (inputDocument) {
            return inputDocument.transformNode(styleSheet);
        }
        return null;
    }


    var processor = new XSLTProcessor();
    processor.importStylesheet(styleSheet);


    if (isc.Browser.isMoz && this.mozAnchorBug && isc.Browser.geckoVersion < 20051107) {
        var ownerDocument = document.implementation.createDocument("", "test", null);
        var newFragment = processor.transformToFragment(inputDocument, ownerDocument);
        return new XMLSerializer().serializeToString(newFragment);
    }

    if (inputDocument) {
        var outputDocument = processor.transformToDocument(inputDocument);
        return new XMLSerializer().serializeToString(outputDocument);
    }

    return null;

    // transformToFragment can produce something that is not a well-formed document, for
    // example, just a text node.  However this doesn't really mean that Mozilla supports XSLT
    // to text, since any tags within the fragment become actual elements.  XMLSerializer can
    // be used to convert to String, but for some reason in also converts tags to eg "&lt;"
    //var fragment = processor.transformToFragment(inputDocument, inputDocument);
    //return new XMLSerializer().serializeToString(fragment);
},

// XML Serialize
// ---------------------------------------------------------------------------------------
//> @classMethod XMLTools.serializeToString()
// Takes an XMLDocument and returns it as a String.
// <P>
// This method is not supported on the Safari web browser versions prior to 3.0.3.
//
// @param inputDocument (XMLDocument) XML document to apply the transform to
// @return (String) XML document as a String
//
// @group xmlTransform
// @visibility xmlBinding
//<
serializeToString : function (inputDocument) {
    this._serializerXSL = this._serializerXSL || isc.xml.parseXML(
'<xsl:stylesheet version=\'1.0\' xmlns:xsl=\'http://www.w3.org/1999/XSL/Transform\'>\r' +
'<xsl:output method="xml" indent="yes"/>\r' +
'<xsl:strip-space elements="*"/>\r' +
'<xsl:template match="/">\r' +
'  <xsl:copy-of select="."/>\r' +
'</xsl:template>\r' +
'</xsl:stylesheet>');

    return this.transformNodes(inputDocument, this._serializerXSL);
},

// Schema Translation
// ---------------------------------------------------------------------------------------

//> @classMethod XMLTools.loadXMLSchema()       [A]
// Load an XML file containing XML schema definitions and create DataSource and SimpleType
// objects to represent the schema.  You can use to loaded schema to bind ISC components,
// perform validation, create editing interfaces, and build other metadata-driven interfaces.
// You can also use +link{dataSource.inheritsFrom,schema inheritance} to overlay
// presentation-specific data (such as user-visible titles) on top of XML Schema.
// <p>
// In the loaded XML Schema, all &lt;xsd:complexType&gt; declarations become SmartClient
// DataSources, and all &lt;xsd:simpleType&gt; definitions become SmartClient
// +link{SimpleType,atomic type definitions}.
// <p>
// By default, named complexType definitions and named element definitions containing
// complexTypes become global DataSources, that is, they can be fetched with
// +link{classMethod:DataSource.getDataSource()}.  Inline complexType definitions get
// automatically generated names.
// <p>
// Named simpleType declarations become global +link{SimpleType,atomic types}, that is,
// subsequently defined DataSources can use them for +link{attr:DataSourceField.type}.  XML
// schema "restrictions" for simple types are automatically translated to
// +link{attr:DataSourceField.valueMap} or +link{attr:DataSourceField.validators} as
// appropriate.
// <P>
// The created SchemaSet object is available in the callback as the single parameter
// "schemaSet", or can retrieved via <code>SchemaSet.get(schemaNamespace)</code>.
// <P>
// NOTE: unless you are building an application that dynamically loads XML Schema
// without prior knowledge, instead of calling loadXMLSchema(), you should either:
// <ul>
// <li> use the +link{group:loadXMLSchemaTag} tag to eliminate the need for an asynchronous
// download of an XML Schema file as part of application startup, <b>OR</b>
// <li> use the "WSDL" tab in the Developer Console to obtain the XML Schema definition as a
// JavaScript file that can be loaded via a normal HTML &lt;SCRIPT SRC=&gt; tag and/or
// combined with other JavaScript files.
// </ul>
// <P>
// NOTE: required fields: the XML Schema concept of "required" for an attribute or subelement,
// expressed via use="required" (for an attribute) or minOccurs > 0 (for a subelement), is
// that the attribute or element must be present in the XML document <i>but can have any
// value</i>, including being empty or null.  The SmartClient notion of required means
// non-null.  You can express the SmartClient notion of required in XML Schema with the
// combination of minOccurs>0 and a minLength or length "restriction", and SmartClient
// will recognize the field as SmartClient-required, with all of the behaviors that implies
// (eg, specially styled form titles, automatic validation, etc).
//
// @param schemaURL (URL) URL to load the schema from
// @param callback  (Callback) signature is callback(schemaSet)
// @param requestProperties (RPCRequest) additional properties to set on the RPCRequest
//                                         that will be issued
// @param autoLoadImports (boolean) if set, xsd:import statements will be processed
//                                  automatically to load dependent XSD files where a
//                                  "location" is specified.  The callback will not fire until
//                                  all dependencies have been loaded

//
// @group xmlSchema
// @visibility xmlBinding
// @example xmlSchemaImport
//<
loadXMLSchema : function (xmlSchemaURL, callback, requestProperties, autoLoadImports, wsProperties) {
    requestProperties = requestProperties || {};
    requestProperties.operationType = requestProperties.operationType || "loadXMLSchema";

    this.loadWSDL(xmlSchemaURL, callback, requestProperties, autoLoadImports, wsProperties, true);
},

//> @classMethod XMLTools.loadWSDL()      [A]
// Load a WSDL file and create an instance of WebService that allows invoking operations and
// binding DataSources to web service operations.
// <P>
// The created WebService object is available in the callback as the single parameter
// "service", or can be retrieved via <code>WebService.get(serviceNamespace)</code>.
// <P>
// XML Schema present in the WSDL file will also be processed as described in
// +link{XMLTools.loadXMLSchema()}.  However note that <b>imported</b> XML Schema
// (&lt;xs:import&gt; tag) will not be automatically loaded and must be loaded manually using
// +link{loadXMLSchema()} before the loaded service will be usable.  This is because the WSDL
// spec allows but does not require a valid URL to be provided for loading imported XML Schema.
// <P>
// NOTE: unless you are building an application that dynamically contacts WSDL web services
// without prior knowledge, instead of calling loadWSDL(), you should either:
// <ul>
// <li> use the +link{group:loadWSDLTag} tag to eliminate the need for an asynchronous
// download of a WSDL file as part of application startup, <b>OR</b>
// <li> use the "WSDL" tab in the Developer Console to obtain the WebService definition as a
// JavaScript file that can be loaded via a normal HTML &lt;SCRIPT SRC=&gt; tag and/or combined
// with other JavaScript files.
// </ul>
// Platform notes:
// <ul>
// <li> loadWSDL() is not supported in Safari 2.0 (but is supported in Safari 3.0.3 and greater)
// However, you can use either approach mentioned above (loadWSDLTag or JavaScript file) with
// Safari pre 3.0.3.
// <li> if you are using a non-Java server, in order to obtain a JavaScript file representing a
// web service, you must run the Developer Console in the Java-based SmartClient SDK
// </ul>
//
// @param wsdlURL  (URL) URL to load the WSDL file from
// @param callback (Callback) signature is callback(service)
// @param requestProperties (RPCRequest) additional properties to set on the RPCRequest
//                                         that will be issued
// @param autoLoadImports (boolean) if set, xsd:import statements will be processed
//                                  automatically to load dependent XSD files where a
//                                  "location" is specified.  The callback will not fire until
//                                  all dependencies have been loaded
//
// @group xmlSchema
// @visibility xmlBinding
// @example WSDLDataSource
//<
// NOTE: returnSchemaSet is an internal parameter to allow the loadWSDL logic to also be used
// by loadXMLSchema()
loadWSDL : function (xmlSchemaURL, callback, requestProperties, autoLoadImports, wsProperties, returnSchemaSet) {
    // load the schema translator if it hasn't been loaded, not doing translation until it's
    // done loading
    if (!this._schemaTranslator) {
        var url = isc.Page.getIsomorphicClientDir() + "schema/schemaTranslator.xsl";
        // get rid of the http://, or loadXML will assume it has to use the HTTPProxy to load
        // the file
        url = url.replace(/https?:\/\/[^\/]*\//, "/");
        // this shouldn't be necessary, but appears so depending on the format of the URL
        if (url.startsWith("//")) url = url.substring(1);
        this._schemaTranslator = "LOADING"; // prevent multiple attempts to load translator
        isc.xml.loadXML(url, function (xmlDoc, xmlText, rpcResponse) {
            isc.xml.logDebug("schema translator loaded");

            if (isc.Browser.isMoz && rpcResponse.xmlHttpRequest &&
                rpcResponse.xmlHttpRequest.responseXML)
            {
                isc.xml._schemaTranslator =
                        isc.XMLDoc.create(rpcResponse.xmlHttpRequest.responseXML);
            } else {
                isc.xml._schemaTranslator = xmlDoc;
            }
            isc.xml.loadWSDL(xmlSchemaURL, callback, requestProperties,
                             autoLoadImports, wsProperties, returnSchemaSet);
        });
        return;
    }

    requestProperties = requestProperties || {};
    requestProperties.operationType = requestProperties.operationType || "loadWSDL";

    var context = {
        location: xmlSchemaURL,
        callback : callback,
        autoLoadImports: autoLoadImports,
        wsProperties: wsProperties || {},
        returnSchemaSet: returnSchemaSet
    };

    isc.xml.loadXML(xmlSchemaURL, function (xmlDoc,xmlText,rpcResponse,rpcRequest) {
                        context.rpcResponse = rpcResponse;
                        context.rpcRequest = rpcRequest;
                        isc.xml._loadSchemaReply(xmlDoc, context);
                    },
                    requestProperties);
},

// load a WSDL service from XML text, an XMLDoc or XML elements that are already loaded
loadWSDLFromXML : function (xmlDoc, callback, autoLoadImports, wsProperties, returnSchemaSet) {
    if (isc.isA.String(xmlDoc)) xmlDoc = isc.xml.parseXML(xmlDoc);

    this._loadSchemaReply(xmlDoc, { callback:callback, autoLoadImports:autoLoadImports,
                                    wsProperties:wsProperties, returnSchemaSet:returnSchemaSet });
},

// whether to use client-side XML2JS to translate WSDL/XMLSchema definitions to live objects
useClientXML : true,
_loadSchemaReply : function (xmlDoc, context) {
    // NOTE: check that translator is an XML doc, not null, since we use a loading marker
    if (!isc.isAn.XMLDoc(this._schemaTranslator)) {
        this.logInfo("deferred schema translator, schema translator not loaded", "xmlComm");
        isc.Timer.setTimeout({ methodName: "_loadSchemaReply", target:this,
                               args:[xmlDoc, context] });
        return;
    }
    this.logInfo("transforming schema: " + this.echoLeaf(xmlDoc) +
                 " with translator " + this.echoLeaf(this._schemaTranslator), "xmlComm");
    var xmlText = this.transformNodes(xmlDoc, this._schemaTranslator);

    if (this.logIsDebugEnabled("xmlComm")) {
        this.logWarn("XML service definition is: \n" + xmlText);
    }

    var wsProperties = context.wsProperties,
        initiator = wsProperties.initiator;
    if (wsProperties.captureXML) {
        wsProperties.xmlSource = xmlText;
        if (initiator) initiator.addImportXMLSource(xmlText, context.location);
    }

    if (this.useClientXML) {
        var xmlDoc = isc.xml.parseXML(xmlText),
            elements = xmlDoc ? this._nodeListToArray(xmlDoc.documentElement.childNodes) : null,
            jsResult = elements ? this.toJS(elements, null, null, true) : null
        ;

        //this.logWarn("XML service definition is: \n" + xmlText);

        //this.logWarn("js result: \n" + this.echoFull(this.toJS(elements)));

        this._loadSchemaToJSReply(context);
        return;
    }

    this.logInfo("about to call serverToJS with: " + this.echoLeaf(xmlText) +
                 ", callback: " + this.echo(context.callback), "xmlComm");
    this.serverToJS(xmlText, function () {
                        isc.Log.logWarn("serverToJS returned");
                        isc.xml._loadSchemaToJSReply(context);
                    });
},
_loadSchemaToJSReply : function (context) {

    var loadedObject;
    if (context.returnSchemaSet) {
        loadedObject = isc.SchemaSet._lastLoaded;
    } else {
        // fallback covers us in case someone loads a WSDL that really don't have a workable
        // service definition but contains schema
        loadedObject = isc.WebService._lastLoaded || isc.SchemaSet._lastLoaded;
    }
    isc.WebService._lastLoaded = isc.SchemaSet._lastLoaded = null;

    // if we didn't load an object and willHandleError is false, return without firing the
    // callback
    if (!loadedObject && context.rpcRequest.willHandleError == false) return;

    // tell the service/schemaSet the location it was loaded from - needed for knowing the
    // correct relative path to load imported schema
    if (loadedObject) loadedObject.location = context.location;

    if (context.wsProperties && loadedObject) loadedObject.setProperties(context.wsProperties);

    // tack on the RPCRequest - allows context to be kept across a loadWSDL call
    var argNames = (isc.isA.WebService(loadedObject) ? "service" : "schemaSet") + ",rpcRequest";
    var args = [loadedObject,context.rpcRequest];

    // if autoLoadImports was passed, tell the service/schemaSet to load imported schema
    if (context.autoLoadImports && loadedObject && loadedObject.loadImports) {
        var _this = this;
        loadedObject.loadImports(function () {
            _this._completeLoad(context.callback, argNames, args);
        });
    } else {
        this._completeLoad(context.callback, argNames, args);
    }
},

_completeLoad : function (callback, argNames, args) {
    //this.logWarn("firing callback: " + this.echo(callback) +
    //             " with argName: " + argName +
    //             " value: " + arg);

    this.fireCallback(callback, argNames, args);
},

getCompleteSource : function (service, callback, asXML) {
    var importSources = service.importSources;
    if (!importSources) return "";

    importSources = importSources.getProperty("xmlText");
    // include the source of the webService or schemaSet that imported all of these
    // dependencies
    importSources.unshift(service.xmlSource);
    // remove <?xml directives
    importSources = this.map("trimXMLStart", importSources);
    var source = importSources.join("\n");

    //this.logWarn("sources: " + this.echo(importSources));

    if (asXML) {
        this.fireCallback(callback, "source", [source]);
        return;
    }

    this.toJSCode(source, function (rpcResponse, data) {
        this.fireCallback(callback, "source", [data]);
    })
}

// SmartClient Component XML
// ---------------------------------------------------------------------------------------

//> @groupDef componentXML
// <smartclient>
// As covered in the <i>QuickStart Guide</i> Chapter 4, <i>Coding</i>, SmartClient
// components can be created in either XML or JavaScript format.  This section covers further
// details of using the XML format, called "SmartClient component XML".
// <P>
// </smartclient>
// <smartgwt>
// Component XML is an XML format for declaring Smart GWT components and screen definitions.
// Available with Smart GWT Pro and above, Component XML is the same format used by Reify
// to save screens.
// <P>
// By allowing you to keep layout information and property settings in an XML format, Component
// XML enables non-developers to build and maintain portions of your application, either by
// editing screens within Reify or by directly editing the XML itself.
// <P>
// Unlike the similar GWT "UIBinder" technology, Component XML does not require a compilation
// step.  XML screen definitions can be generated on the fly, modified at runtime, stored in a
// database, and in all other ways treated as a dynamic resource.  See the section "Dynamic
// Component XML" for details.
// <P>
// <h3>Basic Usage</h3>
// <P>
// To create a Smart GWT component in XML code, you create a tag with the component's class
// name. You can set that component's properties either as tag attributes:
// <pre>
//   &lt;Button title="Click me" width="200" /&gt;
// </pre>
// or in nested tags:
// <pre>
//   &lt;Button&gt;
//     &lt;title&gt;Click me&lt;/title&gt;
//     &lt;width&gt;200&lt;/width&gt;
//   &lt;/Button&gt;
// </pre>
// <P>
// To set a property that is an Array of simple types (like int, or String), repeat tags like
// so (for +link{dynamicForm.colWidths}):
// <P>
// <pre>
// &lt;DynamicForm&gt;
//     &lt;numCols&gt;2&lt;/numCols&gt;
//     &lt;colWidths&gt;250&lt;/colWidths&gt;
//     &lt;colWidths&gt;*&lt;/colWidths&gt;
// &lt;/DynamicForm&gt;
// </pre>
// To set a property that takes an Array of complex objects, use the property name as a
// container tag, then create further nested tags for the objects in the array, like so (for
// +link{listGrid.fields}):
// <P>
// <pre>
// &lt;ListGrid&gt;
//     &lt;fields&gt;
//         &lt;ListGridField name="accountName" ... /&gt;
//         &lt;ListGridField name="accountType" ... /&gt;
//     &lt;/fields&gt;
// &lt;/ListGrid&gt;
// </pre>
// <P>
// This same approach works for creating nested layouts, such as placing a ListGrid in a
// VLayout:
// <P>
// <pre>
// &lt;VLayout&gt;
//     &lt;members&gt;
//         &lt;ListGrid .. /&gt;
//     &lt;/members&gt;
// &lt;VLayout&gt;
// </pre>
// <P>
// </smartgwt>
// <b>Referring to previously defined components</b>
// <P>
// To refer to another component by ID in XML, use &lt;Canvas withID=/&gt;.  For example:
// <pre>
// &lt;Canvas ID="myCanvas"/&gt;
// &lt;Canvas ID="myCanvas2"/&gt;
// &lt;VLayout&gt;
//     &lt;members&gt;
//         &lt;Canvas withID="myCanvas"/&gt;
//         &lt;Canvas withID="myCanvas2"/&gt;
//     &lt;/members&gt;
// &lt;/VLayout&gt;
// </pre>
// <P>
// <h3>Loading screens stored in Component XML</h3>
// <P>
// Save your Component XML as a file called <i>screenName</i>.ui.xml under
// <i>webroot</i>/shared/ui/.  Placing your .ui.xml file in this directory makes it visible to
// the system; the location of this directory can be configured in +link{server_properties,server.properties}
// by setting
// the <i>project.ui</i> property.  <i>screenName</i> can be any valid identifier (no spaces,
// dashes or periods - underscores OK).
// <P>
// If you have multiple top-level tags (eg, your code is similar to the example above under
// "Referring to previousy defined components") use &lt;isomorphicXML&gt; as a top-level
// container tag - this has no impact on processing and is just an idiom to make your file valid
// XML, since XML does not allow multiple top-level tags in a document.
// <P>
// Component XML screens are then loaded using the ScreenLoaderServlet.  The default SDK comes
// with this servlet already registered at
// <smartclient><i>projectBase</i>/isomorphic/screenLoader</smartclient>
// <smartgwt><i>projectBase</i>/sc/screenLoader</smartgwt>.  If you've modified web.xml
// or only included some of the default servlets, you may need to add it now - see the
// <smartclient>+link{group:iscInstall,Installation Instructions}</smartclient>
// <smartgwt>+link{group:sgwtEESetup,Installation Instructions}</smartgwt>.
// <P>
// To create an application that consists of <i>just</i> the imported mockup, just add a
// &lt;script src&gt; tag pointing to the ScreenLoader servlet and referring to the
// <i>screenName</i> you used when you saved your file.
// <smartclient>
// For example, if your application launches from a directory next to the "isomorphic"
// directory from the SDK:
// <pre>
//    &lt;script src="../isomorphic/screenLoader?screenName=<i>screenName</i>"&gt;&lt;/script&gt;
// </pre>
// </smartclient>
// <smartgwt>
// For example, add the following to your bootstrap .html file:
// <pre>
//    &lt;script src="sc/screenLoader?screenName=<i>screenName</i>"&gt;&lt;/script&gt;
// </pre>
// </smartgwt>
// If you want to load screens dynamically, or if you want to load more than one screen, use
// +link{RPCManager.loadScreen()}.  See the section on "Multiple screens and global IDs"
// below.
// <P>
// <smartclient>
// <p>
// You can optionally enable "strict validation" for Component XML and DataSource files,
// which helps avoid typos, misspellings and other basic errors in your XML.  See
// the +link{strictMode,Strict Mode overview} for details.
// <h3>Embedding JavaScript code</h3>
// <P>
// To embed a JavaScript expression into component XML, use the &lt;JS&gt; tag.  For example:
// <pre>
// &lt;VLayout&gt;
//     &lt;width&gt;&lt;JS&gt;isc.Page.getWidth() - 20&lt;/JS&gt;&lt;/width&gt;
// &lt;/VLayout&gt;
// </pre>
// Note that, like all component XML properties, the <code>width</code> property can be
// specified either as an XML attribute or as a subelement.  Expressing it as a subelement, as
// shown above, allows the &lt;JS&gt; tag to be used.
// <P>
// <b>Embedding Methods</b>
// <P>
// For +link{group:stringMethods,StringMethods} such as +link{listGrid.recordClick()},
// JavaScript code can be used as an ordinary element value:
// <pre>
// &lt;ListGrid&gt;
//     &lt;recordClick&gt;if (record.age &gt; 65) doSomething()&lt;/recordClick&gt;
// &lt;/ListGrid&gt;
// </pre>
// To embed an actual function definition, use the &lt;JS&gt; tag described above.  For
// example:
// <pre>
// &lt;ListGrid&gt;
//     &lt;recordClick&gt;&lt;JS&gt;function (viewer, record, recordNum, field) {
//          if (record.age &gt; 65) doSomething();
//     }&lt;/JS&gt;&lt;/recordClick&gt;
// &lt;/ListGrid&gt;
// </pre>
// Unfortunately, characters commonly used in JavaScript code, such as ampersand (&amp;), are
// not legal inside XML element or attribute values.  For example, the expression "record !=
// null && record.age &gt; 65" must be written as shown below, or it is not considered valid XML:
// <P>
// <pre>
// &lt;ListGrid&gt;
//     &lt;recordClick&gt;
//         if (record.status != null &amp;amp;&amp;amp; record.age &gt; 65) doSomething()
//     &lt;/recordClick&gt;
// &lt;/ListGrid&gt;
// </pre>
// An alternative, for larger blocks of code, is to use the XML standard "CDATA" (character
// data) processing directive, which allows ampersand and other characters to be used without
// special notation:
// <pre>
// &lt;ListGrid&gt;
//     &lt;recordClick&gt;&lt;![CDATA[
//         if (record.status != null && record.age &gt; 65) doSomething()
//     ]]&gt;&lt;/recordClick&gt;
// &lt;/ListGrid&gt;
// </pre>
// <P>
// Overall, embedding code in XML can be awkward.  Isomorphic generally recommends that
// significant chunks of JavaScript code, such as non-trivial custom components, be moved to
// separate, purely JavaScript files, while code embedded in component XML is limited to simple
// expressions and short functions.  See the next section for details on keeping code in a
// separate file.
// </smartclient>
// <P>
// <h3>Event Handlers &amp; Scripting loaded components</h3>
// <P>
// You can retrieve the components in your loaded screen in order to add event handlers to
// them, call APIs on them, place them into layouts you programmatically create, and in general
// add dynamic behavior.  Retrieve the components via the +link{Canvas.getById()} API
// (note, when working with multiple screens, be sure to see the upcoming section about managing
// global IDs).
// <P>
// You can then add event handlers normally.  For example, say there is a ListGrid with ID
// "mainGrid" and a DynamicForm with ID "editForm" in the same screen, and you want to populate
// the form with whatever record is clicked on in the grid:
// <P>
// <smartclient>
// <pre>
//   isc.Canvas.getById("mainGrid").addMethods({
//       recordClick : "editForm.editRecord(record)"
//   });
// </pre>
// </smartclient>
// <smartgwt>
// <pre>
//   ListGrid grid = (ListGrid)Canvas.getById("mainGrid");
//   final DynamicForm form = (DynamicForm)Canvas.getById("editForm");
//   grid.addRecordClickHandler(new RecordClickHandler() {
//       public void onRecordClick(RecordClickEvent event) {
//           form.editRecord(event.getRecord());
//       }
//   });
// </pre>
// </smartgwt>
// <P>
// You can also add a loaded screen to an existing layout container.  For example, perhaps you've
// already written parts of the application via normal coding techniques, and now you want to take
// a screen defined in Component XML and place it in a particular Layout you've already created
// ("existingLayout" below) - just use +link{layout.addMember()} as usual:
// <smartgwt>
// <pre>
//    existingLayout.addMember(Canvas.getById("<i>componentId</i>"));
// </pre>
// </smartgwt>
// <smartclient>
// <pre>
//    existingLayout.addMember(isc.Canvas.getById("<i>componentId</i>"));
// </pre>
// </smartclient>
// Component XML files can also refer to components you have created programmatically, and incorporate
// them into layouts.  For example, if you have created a ListGrid component with ID "theGrid", you could
// refer to that grid using a <code>&lt;Canvas withID=""/&gt;</code> tag, which can be used anywhere a
// Canvas is expected.  For example:
// <pre>
// &lt;VLayout ... &gt;
//     &lt;members&gt;
//           &lt;Canvas withID="theGrid"/&gt;
//     &lt;/members&gt;
// &lt;/VLayout&gt;
// </pre>
// Note that this approach requires that the referenced component has been created <b>before</b>
// <code>loadScreen</code> is called.
// <P>
// <h3>Declarative Actions</h3>
// <P>
// Component XML files can declare <code>Action</code>s to take in response to events.  An
// <code>Action</code> is a declarative method call on this or some other component, with or
// without parameters.  Being declarative, actions have some advantages over procedural code:
// they make your application easier to understand and easier to maintain, and they allow
// tools such as Reify to understand and edit your event handling logic.
// <p>
// To take a simple example, this is how you would declare an <code>Action</code> to display
// a record in a +link{class:DetailViewer} when that record is clicked in a +link{class:ListGrid}.
// <pre>
//   &lt;ListGrid dataSource="Customer" autoID="customerGrid"&gt;
//      ...
//     &lt;recordClick&gt;
//       <b>&lt;Action target="customerDetailGrid" name="viewSelectedData" mapping="viewer"/&gt;</b>
//     &lt;/recordClick&gt;
//   &lt;/ListGrid&gt;
// </pre>
// The three elements of this declaration:<ul>
// <li><b>target</b> is the global ID of the component on which the action will be called</li>
// <li><b>name</b> is the name of the method to call</li>
// <li><b>mapping</b> is an optional definition of the parameters to pass to the method.  See
//     the separate section on parameters below</li>
// </ul>
// <code>target</code> and <code>name</code> are both required attributes of any <code>Action</code>,
// and they must be valid.  If <code>target</code> does not refer to a valid component, or
// <code>name</code> is not the name of a valid method on that component, you will generate a
// runtime error.  Note, the rules around describing valid actions in the
// <i><b>Declaring Events and Actions</b></i> section of the +link{group:componentSchema}
// article apply to Reify only.  When building applications through Reify,
// only methods marked <code>action="true"</code> will appear in the list of valid actions for
// a given target component.  However, <i>any</i> documented method can be called as an
// <code>Action</code> in manually-created Component XML, as can any registered
// +link{group:stringMethods(),string method},
// <p>
// Event handlers can also invoke +link{class:Process,workflow processes}, which are a special
// kind of multi-step <code>Action</code>.  You specify a workflow process like this (see the
// +link{class:Process,Process documentation} for details of what goes inside the
// <code>&lt;Process&gt;</code> tag)
// <pre>
//   &lt;ListGrid dataSource="Customer" autoID="customerGrid"&gt;
//      ...
//     &lt;recordClick&gt;
//       <b>&lt;Process&gt;
//          ...
//       &lt;/Process&gt;</b>
//     &lt;/recordClick&gt;
//   &lt;/ListGrid&gt;
// </pre>
// <p>
// Finally, you are not limited to one <code>Action</code> per event: you can declare any
// number of <code>Action</code>s and/or <code>Process</code>es inside an event handler
// declaration.
// <P>
// <h3>Parameters and Actions</h3>
// <P>
// Parameters are defined in an <code>Action</code> declaration in the <code>mapping</code>
// attribute.  This attribute is optional; if the target action method does not require
// parameters, this attribute can be omitted.  If provided, <code>mapping</code> should be a
// comma-separated list of values.  Each of these values is either:<ul>
// <li>A variable name</li>
// <li>The special variable <code>this</code>, which is a reference to the source component
//     (ie, the component upon which the <code>Action</code> is being defined)</li>
// <li>A literal, like 'foo' or 17.  Note, string literals must be enclosed in quotes, or they
//     will be interpreted as variable names</li>
// <li>A valid Javascript expression, like <code>new Date()</code></li>
// </ul>
// Of these, the most interesting and most commonly-used are the first two. <code>Action</code>s
// are declared inside event handler declarations that correspond to SmartClient event methods.
// These methods are passed parameters, and these parameters are available,
// via the <code>mapping</code>, to any contained <code>Action</code>.  Providing the correct
// mapping requires that you know the name of the parameter you are interested in, and this
// information is present in the documentation.
// <p>
// To take the above example, we want to call <code>viewSelectedData()</code> on the
// +link{class:DetailViewer}, so looking at the documentation for
// +link{DetailViewer.viewSelectedData()}, we can see that it takes a single parameter of
// type +link{class:ListGrid} or +link{class:TileGrid}, or the ID of a <code>ListGrid</code>
// or <code>TileGrid</code>.  This parameter tells the <code>DetailViewer</code> which
// component's selected data to show, so we want to pass in the <code>ListGrid</code> itself,
// the component we are declaring this <code>Action</code> on.
// <p>
// One way to do this would be to use a mapping of <code>"this"</code>.  As you can see from
// the example above, though, there is another way.  If we look at the documentation for the
// event method wrapping our <code>Action</code> - +link{listGrid.recordClick()} - we will see
// that it is passed a number of parameters, the first of which is a pointer to the
// <code>ListGrid</code> itself.  As the documentation shows, this parameter is called "viewer".
// Therefore, we can use a <code>mapping</code> of "viewer".  If we were declaring an
// <code>Action</code> to call a method that requires a +link{object:Record} parameter, we can
// look at the documentation for <code>recordClick()</code> again and note that it is also
// passed the record just clicked, in a parameter called <code>record</code>.  So our mapping
// for that <code>Action</code> would be "record".
// <!--
// Note, Reify is able to wire the incoming event method params up to the outgoing
// Action method params automatically, by inspecting the parameter types declared in the JSDoc
// for each method.  This happens at design time, in EditContext.createActionBinding().  It
// isn't currently done at runtime, because of the dependency on JSDoc; maybe we will extend
// this in the future?
// -->
// <P>
// <h3>Component XML and global IDs</h3>
// <P>
// A Component XML screen created in Reify or via the
// +link{group:balsamiqImport,Balsamiq importer} will assign global IDs to all components
// generated from your mockup so that you can retrieve them by ID to add event handlers and
// call APIs.   However if you build an application out of multiple screens built at different
// times, these IDs can collide, which will cause components to overwrite each other as they
// each try to use the same ID.
// <P>
// To solve this, the +link{RPCManager.loadScreen()} API will <i>ignore</i> global IDs on loaded
// components, assigning them sequential generated IDs instead (which will never collide).
// Instead of using global IDs, the callback for <i>loadScreen()</i> will automatically provide
// you with the outermost component of a loaded screen, and that outermost component will
// provide access to other components by their original IDs via +link{canvas.getByLocalId()}.
// <P>
// This allows you to add loaded screens to existing layouts, attach event handlers and take
// other programmatic actions, all without ever establishing global IDs.
// <P>
// <h3>Loading multiple screens</h3>
// <P>
// A typical application that uses screens stored in Component XML will have several such
// screens, or in some cases, hundreds or thousands.  +link{RPCManager.cacheScreens()} can be
// used to load a set of screen definitions without actually creating any UI components - a
// subsequent call to +link{RPCManager.createScreen()} is used to actually create the screen
// when needed.  These two APIs provide the same global ID management facilities as
// +link{RPCManager.loadScreen(),loadScreen()}.
// <P>
// As discussed in the +link{group:smartArchitecture,SmartClient Architecture overview}, screen
// definitions are typically very small, and should be loaded entirely up front or in very
// large batches.  Further, screen <i>definitions</i> have essentially negligible runtime
// overhead until the screen is actually created.
// <P>
// Therefore, use the following best practices for screen loading, even if you have very few or
// only one screen defined in Component XML:
// <ul>
// <li> at application startup, load all screens using +link{RPCManager.cacheScreens()}
// <li> create screens lazily (when they are about to be shown to the end user) using
//      +link{RPCManager.createScreen()}.
// <li> for applications with very very large numbers of screens where loading all screen
//      definitions up front creates a very large download, consider multiple calls to
//      <code>cacheScreens()</code>, loading sets of screens that are likely to be used
//      together.
// </ul>
// <P>
// <h3>Dynamic Component XML</h3>
// <P>
// Components can be dynamically provided on the server side by using the API defined in
// +externalLink{http://www.smartclient.com/smartgwtee/server/javadoc/com/isomorphic/servlet/ScreenLoaderServlet.html#addDynamicScreenGenerator(com.isomorphic.servlet.DynamicScreenGenerator),<code>ScreenLoaderServlet.addDynamicScreenGenerator()</code>}
// which allows adding DynamicScreenGenerators to the system for providing the .ui.xml files on the fly:
// <pre>
// ScreenLoaderServlet.addDynamicScreenGenerator(new DynamicScreenGenerator() {
//      public String getScreen(String id) {
//
//        if (id.equals("testDynamicScreenPrefix3")) {
//            return null;
//        }
//
//        id=id.replace("testDynamicScreen","");
//        return "<VLayout ID=\""+id+"\" border=\"1px solid blue\"/>";
//      }
//  }, "testDynamicScreenPrefix");
// </pre>
// <P>
// Whenever the system needs a screen in future, it will first call the registered DynamicScreenGenerator's
// <code>getScreen(String)</code> method for providing the given screen; Only if all queried
// DynamicScreenGenerators returns <code>null</code>, will proceed to use the normal system for obtaining
// the screen instances.
// <P>
// NOTE:<ul>
// <li>If this API is used, DynamicScreenGenerator will be called for <b>every</b> screen that
// the framework needs. Instead of this, the API contains alternative methods which will allow
// adding DynamicScreenGenerators only for a given string prefix or a regular expression.
// </ul>
// <P>
// In the provided example we register a DynamicScreenGenerator which will be called for each screen
// the system tries to load, if it starts with "testDynamicScreenPrefix", except the screen with id
// "testDynamicScreenPrefix3" for which we return null.
// <P>
// While registering a DynamicScreenGenerator is the first choice since is compatible
// with ScreenLoaderServlet's ability to load several screens in a single HTTPRequest,
// there are two additional ways to load Component XML screens - you can create a .jsp that
// uses the JSP tags that come with the SDK:
// <pre>
//    &lt;%@ taglib uri="http://www.smartclient.com/taglib" prefix="isomorphic" %&gt;
//    &lt;isomorphic:XML&gt;
//       ... Component XML ...
//    &lt;/isomorphic:XML&gt;
// </pre>
// <P>
// Or you can use the server-side API com.isomorphic.XML.toJS():
// <pre>
//     XML.toJS("&lt;isomorphicXML xmlns:xsi=\"nativeType\"&gt;" +
//                  componentXMLCode +
//                  "&lt;/isomorphicXML&gt;");
// </pre>
// However these two approaches will allow to only load one screen at a time.
// The JSP code above and the programmatic call to XML.toJS() both return a JavaScript code,
// which is the response that +link{RPCManager.loadScreen()} expects.  The
// <code>XML.toJS()</code> API can be easily combined with
// +link{group:standaloneDataSourceUsage,direct use of the server-side DataSource API} to build
// a version of the ScreenLoaderServlet that can retrieve Component XML from a database
// or any Java API.
// <P>
// For static Component XML screens (cannot be changed at runtime), you can optionally run the
// XML.toJS() process as a build step to save a small amount of runtime overhead in XML to JS
// translation.  Use +link{RPCManager.loadScreen()} to load the resulting JavaScript by
// overriding the +link{rpcRequest.actionURL} to point to the generated JavaScript file.
// Note that the overhead is minor enough that this is not worth doing unless you have a very
// large deployment and a very large number of static Component XML files.
// <P>
// <h3>Troubleshooting</h3>
// <P>
// XML parsing errors, which happen when XML is not well-formed and would be rejected by any
// standard XML parser, are reported in the server-side log, and, when possible, also in the
// client-side log within the "Results" tab of the Developer Console.
// <P>
// If you are loading a screen via the +link{RPCManager.loadScreen()} API, you can see the
// response from the server in the RPC tab of the Developer Console - this will show you issues
// such as a misplaced ScreenLoaderServlet (HTTP response code will be 404 - Not Found) or
// responses that contain server exception details instead of the expected JavaScript response.
// <P>
// <smartclient>
// Other issues with component XML can result from incorrect use of SmartClient component XML
// tags.  For example, you may specify a property and it may appear to have no effect even
// though it clearly works in other, JavaScript-based examples.  If you get this symptom, you
// can troubleshoot by looking at the JavaScript code SmartClient generates from component XML.
// <P>
// </smartclient>
// <P>
// You can also use the "Eval XML" section in the "Results" tab of the Developer Console to
// interactively experiment with Component XML ("Eval XML" button) and as a means of seeing the
// generated JavaScript ("Show JS" button).
// <P>
// <h3>Localization / Internationalization</h3>
// <P>
// Component XML files support embedding references to messages loaded from ResourceBundles via
// the same JSTL-like &lt;fmt&gt; syntax as is used for DataSource .ds.xml files.  See
// +link{group:dataSourceLocalization,DataSource localization for details}.
// <P>
// <smartclient>
// <h3>Custom Properties</h3>
// <P>
// If you specify a custom property on a component in XML, for example:
// <pre>
// &lt;Canvas myProperty="false"/&gt;
// </pre>
// The value of the property will be a JavaScript String.  In the above example, it would be
// the string "false", which is considered a boolean true value in the JavaScript language.
// If you want a different JavaScript type, you can force a property to be interpreted as a
// given type by using the "xsi:type" attribute:
// <pre>
// &lt;Canvas&gt;
//     &lt;myProperty xsi:type="xsd:boolean"&gt;false&lt;/myProperty&gt;
// &lt;/Canvas&gt;
// </pre>
// The same notation works when you want to declare that an entire subobject has a given type.
// For example, this would cause the custom property "myListGrid" to have a live
// +link{ListGrid} instance as it's value.  All of the properties on the &lt;myListGrid&gt; tag
// will be correctly interpreted as ListGrid properties and have the correct types.
// <pre>
// &lt;Canvas&gt;
//     &lt;myListGrid xsi:type="ListGrid" width="500" height="600"/&gt;
// &lt;/Canvas&gt;
// </pre>
// If you do not want an actual live ListGrid, but rather a JavaScript Object containing
// properties for later construction of a ListGrid, use the <code>propertiesOnly</code>
// attribute.  For example, this code would cause the property "listGridProperties" to be a
// JavaScript Object with properties "width" and "height", whose values would be JavaScript
// Numbers.
// <pre>
// &lt;Canvas&gt;
//     &lt;listGridProperties xsi:type="ListGrid" propertiesOnly="true"
//                          width="500" height="600"/&gt;
// &lt;/Canvas&gt;
// </pre>
// For your reference: "xsi" stands for "XML Schema Instance"; this notation derives from XML
// Schema standards for explicitly specifying type inline.
// <P>
// <h3>Custom Components</h3>
// <P>
// If you use +link{classMethod:ClassFactory.defineClass(),defineClass()} to define a new component class
// "MyListGrid" which is a subclass of the built-in component ListGrid, you can create it in
// XML as shown below:
// <pre>
// &lt;ListGrid constructor="MyListGrid" width="500"/&gt;
// </pre>
// By using the &lt;ListGrid&gt; tag you advertise that properties should be interpreted
// as <code>ListGrid</code> properties.  By specifying <code>constructor</code>
// you tell SmartClient what class to +link{Class.create,create()}.
// <P>
// <h3>Component Schema</h3>
// <P>
// Instead of using the <code>constructor</code> and <code>xsi:type</code> attributes for
// custom components and custom properties, you can create a +link{group:componentSchema} that
// describes the custom component.  Declaring a component schema allows you to use your
// component just like the built-in SmartClient components, and also allows your component to
// be used within +link{group:reify,Reify}.
// </smartclient>
//
// <smartgwt>
// <h3>Custom Components</h3>
// <p>
// If you define a new component class <code>com.mycompany.MyListGrid</code> which is a subclass of the
// built-in component <code>ListGrid</code>, and you +link{group:reflection,register your class for reflection},
// you can create it in XML as shown below:
// <pre>
//    &lt;ListGrid constructor="com.mycompany.MyListGrid" width="500"/&gt;
// </pre>
// <p>
// By using the &lt;ListGrid&gt; tag you advertise that properties should be interpreted
// as <code>ListGrid</code> properties.  By specifying <code>constructor</code>
// you tell SmartGWT what class to create.
// <p>
// <h3>Custom Properties</h3>
// <p>
// Your custom component (e.g. <code>com.mycompany.MyListGrid</code>) may have additional
// properties which are not present in the standard superclass (e.g. <code>ListGrid</code>).
// You can set such properties in XML as if they were pre-defined properties:
// <pre>
//    &lt;ListGrid constructor="com.mycompany.MyListGrid" myProperty="false"/&gt;
// </pre>
// <p>
// In this case, the {@link com.smartgwt.client.bean.BeanFactory} code
// will ultimately call <code>MyListGrid.setMyProperty(false);</code> in order
// to set the property. Since <code>BeanFactory</code> knows that the property
// takes a boolean, it will automatically convert the string value "false" to a
// boolean, using the type conversions described below.
// <p>
// Instead of relying on the automatic type conversions, you can force a
// property to be interpreted as a given type by using the "xsi:type"
// attribute:
// <pre>
// &lt;ListGrid&gt;
//     &lt;constructor&gt;com.mycompany.MyListGrid&lt;/constructor&gt;
//     &lt;myProperty xsi:type="xsd:boolean"&gt;false&lt;/myProperty&gt;
// &lt;/ListGrid&gt;
// </pre>
// <p>
// The same notation works when you want to declare that an entire subobject has a given type.
// For example, this would cause the custom property "myListGrid" to have a live
// +link{ListGrid} instance as its value.  All of the properties on the &lt;myListGrid&gt; tag
// will be correctly interpreted as ListGrid properties and have the correct types.
// <pre>
// &lt;Canvas&gt;
//     &lt;myListGrid xsi:type="ListGrid" width="500" height="600"/&gt;
// &lt;/Canvas&gt;
// </pre>
// <p>
// For your reference: "xsi" stands for "XML Schema Instance"; this notation derives from XML
// Schema standards for explicitly specifying type inline.
// <p>
// <h3>Component Schema</h3>
// <p>
// Instead of using the <code>constructor</code> and <code>xsi:type</code> attributes for
// custom components and custom properties, you can create a +link{group:componentSchema} that
// describes the custom component.  Declaring a component schema allows you to use your
// component just like the built-in SmartGWT components, and also allows your component to
// be used within +link{group:reify,Reify}.
// <p>
// <h3>Type Conversions</h3>
// <p>
// The {@link com.smartgwt.client.bean.BeanFactory} code
// uses a reflection-like mechanism to discern the type which a SmartGWT
// property requires, and automatically
// converts supplied values to the required type when possible. In cases where
// conversion is impossible, an {@link IllegalArgumentException} is
// thrown.
// <p>
// Where the setter for a property takes a <b>primitive type</b> (boolean,
// double, float, int, or long), any "null" value supplied will be converted to
// 0 (for the numeric types) or false (for boolean). Conversely, if the setter
// takes the boxed version of the type (Boolean, Double, etc.), any primitive
// value supplied will be auto-boxed. Note that byte, short and char properties
// are not currently handled.
// <p>
// Properties which take <b>numeric types</b> will convert other numeric
// types, as well as strings, using standard Java APIs (e.g.
// <code>Integer.valueOf()</code>).  Boolean "true" will be converted to 1, and false to 0.
// If the supplied value cannot be converted to the numeric type, an
// {@link IllegalArgumentException} will be thrown.
// <p>
// Properties which take a <b>Date</b> type will convert from strings using
// {@link com.smartgwt.client.util.DateUtil#parseInput(String)}.
// <p>
// Properties which take <b>Enum</b> types will convert from strings using <code>Enum.valueOf()</code>.
// However, any dashes ("-") in the string will be converted to underscores, and
// the string will be converted to upper-case if necessary. If the string does not match
// one of the <code>Enum</code> values, an {@link IllegalArgumentException} will be thrown.
// <p>
// Properties which take <b>Array</b> types will convert arrays where the individual
// values can be converted to the appropriate type. If a single value is supplied,
// it will be wrapped in an array.
// </smartgwt>
//
// @treeLocation Concepts/Reify
// @title Component XML
// @visibility external
//<

// <smartgwt>
//> @groupDef reflection
//
// In order to specify a SmartGWT class as a constructor in
// +link{group:componentXML, Component XML} or
// +link{group:componentSchema, Component Schema},
// or for other purposes, such as for
// {@link com.smartgwt.client.docs.AutoChildUsage autoChildren} or for
// {@link com.smartgwt.client.data.DataSourceField#setEditorType(Class)},
// you must first register the class with the
// {@link com.smartgwt.client.bean.BeanFactory} reflection mechanism.
// <p>
// If you want to register {@link com.smartgwt.client.widgets.Canvas}
// and all its subclasses found in the classpath (including your custom subclasses),
// you can use the {@link com.smartgwt.client.bean.BeanFactory.CanvasMetaFactory}
// interface to do this automatically:
// <blockquote><pre>
// GWT.create(BeanFactory.CanvasMetaFactory.class);</pre></blockquote>
// <p>
// Similarly, to register {@link com.smartgwt.client.widgets.form.fields.FormItem}
// and all its subclasses found in the classpath (including your custom subclasses),
// you can use the {@link com.smartgwt.client.bean.BeanFactory.FormItemMetaFactory}.
// <blockquote><pre>
// GWT.create(BeanFactory.FormItemMetaFactory.class);</pre></blockquote>
// <p>
// Alternatively, if only specific classes need to be instantiated and
// configured dynamically, you can register just those classes by annotating
// them with the {@link com.smartgwt.client.bean.BeanFactory.Generate}
// annotation instead. For instance:
// <blockquote><pre>
// {@literal @}BeanFactory.Generate
// public class MyCanvas extends Canvas {
//     ...
// }</pre></blockquote>
// <p>
// For framework classes (where you cannot annotate the class directly), you
// can supply an array of Class literals to the annotation. For instance:
// <blockquote><pre>
// {@literal @}BeanFactory.Generate({Canvas.class, TreeGrid.class})
// public interface EmptyInterface {
//     ...
// }</pre></blockquote>
// <p>
// When you supply an array of class literals, the class you annotate
// (here <code>EmptyInterface</code>) will <b>not</b> itself have a
// BeanFactory generated for it. Thus, you can use an empty inner
// interface for this purpose.
// <p>
// If there are only a limited number of classes which require dynamic
// configuration, it will save code size to use the
// {@link com.smartgwt.client.bean.BeanFactory.Generate} annotation to generate
// factories for those specific types, rather than using
// {@link com.smartgwt.client.bean.BeanFactory.CanvasMetaFactory} or
// {@link com.smartgwt.client.bean.BeanFactory.FormItemMetaFactory}. Once a factory
// is generated for a class, GWT's opportunities to prune dead code are more
// limited for that class, since it cannot know what properties will be set or
// retrieved at run-time.
//
// @title Registering Classes for Reflection
// @visibility external
//<
// </smartgwt>

});

// shortcut
isc.xml = isc.XML = isc.XMLTools;






//> @class DataSource
// A DataSource is data-provider-independent description of a set of objects
// that will be loaded, edited and saved within the user interface of your application.
// <P>
// Each DataSource consists of a list of +link{dataSource.fields,fields} that make up a
// DataSource <code>record</code>, along with +link{dataSourceField.type,field types},
// +link{dataSourceField.validators,validation rules},
// +link{dataSourceField.foreignKey,relationships} to other DataSources, and other
// metadata.
// <P>
// The abstract object description provided by a DataSource is easily mapped to a variety of
// backend object models and storage schemes.  The following table shows analogous terminology
// across systems.
// <table border=1 class="normal">
// <tr>
//   <td>Isomorphic SmartClient</td>
//   <td>Relational Database</td>
//   <td>Enterprise Java Beans (EJB)</td>
//   <td>Entity/Relationship Modeling</td>
//   <td>OO/UML</td>
//   <td>XML Schema/WSDL</td>
//   <td>LDAP</td>
// </tr><tr>
//   <td>DataSource</td>
//   <td>Table</td>
//   <td>EJB class</td>
//   <td>Entity</td>
//   <td>Class</td>
//   <td>Element Schema (ComplexType)</td>
//   <td>Objectclass</td>
// </tr><tr>
//   <td>Record</td>
//   <td>Row</td>
//   <td>EJB instance</td>
//   <td>Entity instance</td>
//   <td>Class instance/Object</td>
//   <td>Element instance (ComplexType)</td>
//   <td>Entry</td>
// </tr><tr>
//   <td>Field</td>
//   <td>Column</td>
//   <td>Property</td>
//   <td>Attribute</td>
//   <td>Property/Attribute</td>
//   <td>Attribute or Element (SimpleType)</td>
//   <td>Attribute</td>
// </tr></table>
// <P>
// DataSources can be +link{group:dataSourceDeclaration,declared} in either JavaScript or XML
// format, and can also be +link{group:metadataImport,imported} from existing metadata formats,
// including XML Schema.
// <P>
// <i>Data Binding</i> is the process by which
// +link{dataBoundComponent,Data Binding-capable UI components} can automatically configure
// themselves for viewing, editing and saving data described by DataSources.  DataBinding is
// covered in the +docTreeLink{QuickStartGuide,QuickStart Guide}, Chapter 6, <i>Data
// Binding</i>.
// <P>
// +link{group:clientServerIntegration,Data Integration} is the process by which a DataSource
// can be connected to server systems such as SQL DataBases, Java Object models, WSDL web
// services and other data providers.  Data Integration comes in two variants: client-side and
// server-side.  +link{group:serverDataIntegration,Server-side integration} uses the
// SmartClient Java-based server to connect to data represented by Java Objects or
// JDBC-accessible databases.  +link{group:clientDataIntegration,Client-side integration}
// connects SmartClient DataSources to XML, JSON or other formats accessible via HTTP.
// <P>
// DataSources have a concept of +link{group:dataSourceOperations,4 core operations} ("fetch",
// "add", "update" and "remove") that can be performed on the set of objects represented by a
// DataSource.  Once a DataSource has been integrated with your data store, databinding-capable
// UI components can leverage the 4 core DataSource operations to provide many complete user
// interactions without the need to configure how each individual component loads and saves
// data.
// <P>
// These interactions include +link{listGrid,grid views}, +link{TreeGrid,tree views},
// +link{detailViewer,detail views}, +link{DynamicForm,form}-based
// +link{dynamicForm.editRecord,editing} and +link{dynamicForm.saveData,saving},
// grid-based +link{listGrid.canEdit,editing} and +link{listGrid.saveByCell,saving},
// and custom interactions provided by +explorerExample{patternReuse} custom
// databinding-capable components.
//

// @see interface:DataBoundComponent for information on DataBound Components
// @see group:dataSourceDeclaration for how to create DataSources
// @treeLocation Client Reference/Data Binding
// @serverDS allowed
// @visibility external
//<
isc.defineClass("DataSource", null, "FieldContainer");

isc.DataSource.addClassProperties({
    _nothingCriterion: {_constructor: "AdvancedCriteria", operator: "or", criteria: [], fixedValue: false},
    _everythingCriterion: {_constructor: "AdvancedCriteria", operator: "and", criteria: [], fixedValue: true}
});

//> @type DSOperationType
// One of the four basic operations that can be performed on DataSource data: "fetch",
// "add", "update", "remove".  Elsewhere called CRUD operations, where CRUD stands for
// "create", "retrieve", "update", "delete", which correspond to "add", "fetch", "update" and
// "remove" in SmartClient terminology.  See +link{group:dataSourceOperations} for a full
// description.
// <p>
// There are also additional, non-CRUD operations explained below.
//
//
// @value "fetch"        Fetch one or more records that match a set of search criteria.
// @value "add"          Store new records
// @value "update"       Update an existing record
// @value "remove"       Remove (delete) an existing record
// @value "custom"       perform some arbitrary custom logic that is not a CRUD operation.
//                       Format of the inputs and outputs is unconstrained, and the operation
//                       will be ignored for cache sync purposes by +link{ResultSet}s.  See
//                       +link{DataSource.performCustomOperation()}.
// @value "validate"     Run server-side validation for "add" or "update" without actually
//                       adding or updating anything.  See +link{DataSource.validateData()}.
// @value "viewFile"     Retrieve a file stored in a binary field in a DataSource record, and
//                       allow the browser to choose whether to view it directly or prompt the
//                       user to save.  See +link{group:binaryFields}.
// @value "downloadFile" Like "viewFile", but the HTTP header Content-Disposition is used to
//                       suggest that the browser show a save dialog.  See +link{group:binaryFields}.
// @value "storeTestData" Takes a List of Maps and stores the data in Admin Console XML test
//                       data format
// @value "clientExport" Upload formatted client data and export it to Excel, XML and other
//                       formats.  Used automatically by
//                       +link{method:dataSource.exportClientData(),exportClientData()}
//                       and cannot be used directly.  Usable only with the SmartClient server
//                       framework.
// @value "getFile"      Use the DataSource as a +link{group:fileSource,source for files}.
//                       Used automatically by +link{DataSource.getFile()}, and
//                       would not normally be used directly. Usable only with
//                       the SmartClient server framework.
// @value "hasFile"      Use the DataSource as a +link{group:fileSource,source for files}.
//                       Used automatically by +link{DataSource.hasFile()}, and
//                       would not normally be used directly. Usable only with
//                       the SmartClient server framework.
// @value "listFiles"    Use the DataSource as a +link{group:fileSource,source for files}.
//                       Used automatically by +link{DataSource.listFiles()}, and
//                       would not normally be used directly. Usable only with
//                       the SmartClient server framework.
// @value "removeFile"   Use the DataSource as a +link{group:fileSource,source for files}.
//                       Used automatically by +link{DataSource.removeFile()}, and
//                       would not normally be used directly. Usable only with
//                       the SmartClient server framework.
// @value "saveFile"     Use the DataSource as a +link{group:fileSource,source for files}.
//                       Used automatically by +link{DataSource.saveFile()}, and
//                       would not normally be used directly. Usable only with
//                       the SmartClient server framework.
// @value "renameFile"   Use the DataSource as a +link{group:fileSource,source for files}.
//                       Used automatically by +link{DataSource.renameFile()}, and
//                       would not normally be used directly. Usable only with
//                       the SmartClient server framework.
// @value "getFileVersion" Use the DataSource as a +link{group:fileSource,source for files}.
//                       Used automatically by +link{DataSource.getFileVersion()}, and
//                       would not normally be used directly. Usable only with
//                       the SmartClient server framework.
// @value "hasFileVersion" Use the DataSource as a +link{group:fileSource,source for files}.
//                       Used automatically by +link{DataSource.hasFileVersion()}, and
//                       would not normally be used directly. Usable only with
//                       the SmartClient server framework.
// @value "listFileVersions" Use the DataSource as a +link{group:fileSource,source for files}.
//                       Used automatically by +link{DataSource.listFileVersions()}, and
//                       would not normally be used directly. Usable only with
//                       the SmartClient server framework.
// @value "removeFileVersion" Use the DataSource as a +link{group:fileSource,source for files}.
//                       Used automatically by +link{DataSource.removeFileVersion()}, and
//                       would not normally be used directly. Usable only with
//                       the SmartClient server framework.
//
// @visibility external
//<

//> @object Record
// A Record is an ordinary JavaScript Object with properties that are treated as data to
// be displayed and edited by a +link{DataBoundComponent}.
// <P>
// +link{DataBoundComponent}s have a concept of +link{dataBoundComponent.fields,named fields},
// where values for each field are found under the same-named property in a Record.
// <P>
// A Record is always an ordinary JavaScript Object regardless of how the record is
// loaded (static data, java server, XML web service, etc), and so supports the
// normal behaviors of JavaScript Objects, including accessing and assigning to properties
// via dot notation:
// <pre>
//     var fieldValue = record.<i>fieldName</i>;
//     record.<i>fieldName</i> = newValue;
// </pre>
// <P>
// The concept of working with Records is common to all +link{DataBoundComponent}s, although
// individual DataBoundComponents may work with singular records (+link{DynamicForm}) or
// may work with lists (+link{ListGrid}), trees (+link{TreeGrid}), or cubes
// (+link{CubeGrid}) of records.
// <P>
// Individual DataComponents may also look for special properties on Records which
// control styling or behavior for those records, such as
// +link{listGrid.recordEditProperty,<code>record.canEdit</code>}.
//
// @treeLocation Client Reference/Data Binding/DataSource
// @visibility external
//<

//> @groupDef dataSourceDeclaration
// DataSources can be specified in XML format, in which case the SmartClient server is used to
// load the DataSource, or DataSources can be programmatically created on the client.
// <P>
// Whether a DataSource is loaded via the SmartClient server or programmatically created
// client-side, identical requests will ultimately be submitted to the server.  However,
// DataSources defined in XML are loaded and used by the SmartClient Server, enabling many
// features including synchronized client-server validation, request bundling, file upload, and
// optional automatic SQL/JPA/Hibernate connectivity (see the
// +link{group:iscServer,Server Summary} for details).
// <P>
// <smartclient>
// DataSources created on the client use the same style of creation as DataBound components:
// <pre>
//    isc.DataSource.create({
//        ID:"supplyItem",
//        fields:[
//            {name:"itemName", ... }
//            ...
//        ]
//    });
// </pre>
// </smartclient>
// <smartgwt>
// DataSources can be programmatically created on the client like so:
// <pre>
//    DataSource ds = new DataSource();
//    ds.setID("supplyItem");
//    DataSourceTextField nameField = new DataSourceTextField("itemName", "Name");
//    // create other fields
//    ds.setFields(nameField, ...);
// </pre>
// </smartgwt>
// Reference for all properties that can be set for DataSources, their fields and validators is
// given in the +link{class:DataSource} class reference.
// <P>
// DataSources defined in XML declare fields, validators and other settings using XML tags:
// <pre>
//     &lt;DataSource ID="supplyItem"&gt;
//         &lt;fields&gt;
//             &lt;field name="itemName" type="text" title="Item"/&gt;
//             &lt;field name="SKU"      type="text" title="SKU"&gt;
//                 &lt;validators&gt;
//                     &lt;validator type="integerRange" ... /&gt;
//                 &lt;/validators&gt;
//             &lt;/field&gt;
//         &lt;/fields&gt;
//     &lt;/DataSource&gt;
// </pre>
// DataSources defined in XML are loaded by using the <code>DataSourceLoader</code>
// servlet provided by the SmartClient Server.  This can be done as an ordinary HTML
// &lt;script&gt; tag as you application first loads:
// <pre>
//     &lt;SCRIPT SRC=isomorphic/DataSourceLoader?dataSource=supplyItem,employees,worldDS&gt;&lt;/SCRIPT&gt;
// </pre>
// .. or can be done on the fly via +link{DataSource.load()}.
// <P>
// Alternatively, in JSP environments, XML DataSources can be loaded via a special JSP tag
// supported by the SmartClient Server:
// <pre>
//     &lt;%&#64; taglib uri="http://www.smartclient.com/taglib" prefix="isomorphic" %&gt;
//     ...
//     &lt;SCRIPT&gt;
//     &lt;isomorphic:loadDS ID="supplyItem"/&gt;
//     &lt;/SCRIPT&gt;
// </pre>
// <P>
// When loading an XML DataSource, by default, the ISC Server will look for a file named
// <code>&lt;dataSourceId&gt;.ds.xml</code> in the <code>project.datasources</code> directory
// as configured in <code>[webroot]/WEB-INF/classes/server.properties</code> .
// By default this may be set to <code>/shared/ds</code> or <code>/WEB-INF/ds</code> under webroot.<br>
// The location of this directory can be changed, or individual DataSources can be
// placed in arbitrary locations.  For more information, see the documentation for
// +link{group:server_properties,server.properties}
// <P>
// The directory containing dataSource defintions should not be made publicly accessible via the
// webserver. DataSource configuration files can contain sensitive data that should only be read
// by the server. When loading a dataSource via the <code>loadDS</code> tag or by hitting the
// <code>DataSourceLoader</code> servlet such data will not be passed to the client.
//
// <P>
// XML DataSources can also be generated on the fly in case the entire DataSource or portions
// of it are based on dynamic data.  See the server API
// com.isomorphic.DataSource.addDynamicDSGenerator().
//
// @see class:DataSource
// @see group:loadDSTag
// @treeLocation Client Reference/Data Binding/DataSource
// @title Creating DataSources
// @visibility external
//<



//> @groupDef i18n
//
// <b><u>Internationalizing SmartClient Applications</u></b>
// <p>
// Internationalizing a SmartClient application involves creating locale-specific
// versions of all strings, images, and possibly colors.  In some cases, component layout may
// be affected as well (for example date field order differs between some locales).
// <p>
// <u><b>Character Encodings</b></u>
// <p>
// In order to deliver content in different languages to the browser and have it be displayed
// correctly, it is important that the browser and server agree on the character encoding being
// used to send the page.
// <p>
// Generally speaking, you can use whatever character encoding you prefer, so long as
// you're consistent about serving your files to the browser with exactly the same encoding
// as was used to save the file to disk.  Keep in mind though that the character encoding you
// choose must be supported by all browsers you intend to support.  Isomorphic recommends that,
// where possible, you use the UTF-8 encoding.  Regardless of which character encoding you
// choose, keep in mind that for the browser to correctly display non-ASCII characters, you
// <b>must</b> explicitly set the character encoding of your page to match the encoding you
// used to save the file.  Browsers have built-in heuristics to guess the character encoding,
// but they can't be relied upon to work 100% of the time.
// <p>
// There are two ways to explicitly tell the browser what character
// encoding is being used for a given page.  One is to set the "Content-Type" HTTP header, for
// example:
// <pre>
// Content-Type: text/html; charset=UTF-8
// </pre>
// If you're using JSP on the back-end, you can set this header as follows:
// <pre>
// &lt;%@ page contentType="text/html; charset=UTF-8"%&gt;
// </pre>
// Or using Java Servlet APIs in a Servlet as follows:
// <pre>
// response.setContentType("text/html; charset=UTF-8");
// </pre>
// Note that the latter needs to be done before any content is written to the response output
// stream.
// <p>
// The other approach to setting the content encoding is to use an HTML META tag to embed it
// in the page itself (note that this applies to HTML documents only).  The META tag must go
// inside the &lt;HEAD&gt; HTML element - e.g. as follows:
// <pre>
// &lt;HEAD&gt;
// &lt;META HTTP-EQUIV="Content-Type" CONTENT="text/html; charset=UTF-8"&gt;
// &lt;/HEAD&gt;
// </pre>
// In addition, for a .html or other static (non-.jsp) file, you must also ensure that the file
// itself is saved in UTF-8 encoding.  Advanced text editors (including the Eclipse IDE) can
// show you the encoding of a text file and allow you to change it.  In Eclipse this is in the
// Preferences area (search for "Encoding") and UTF-8 is <b>not the default</b> for .html
// files, and should be changed.
// <P>
// Isomorphic recommends that you follow <b>all</b> of the above approaches for maximum
// compatibility.  For example, if you omit the META tag approach, pages saved by the user
// using the browser save function may not render correctly when subsequently read from disk
// because HTTP headers are not available in that context.  Conversely, not providing the
// HTTP header or not saving the file in UTF-8 can result in application servers delivering the
// file in the encoding in which it is saved, or in their own default and incorrect content
// encoding.
// <p>
// If you're using a given character encoding pervasively in your pages, you can also configure
// your web server or application server to use that character encoding as the default for all
// pages of a given mime type or some other criteria (depending on the capability of your
// server) - for example on a per-directory basis.
// <p>
// For more information on character encodings, character sets, and working with HTML, please
// see W3C's tutorial here:
// +externalLink{http://www.w3.org/International/tutorials/tutorial-char-enc/}
// <p>
// <b>NOTE: Default Encoding</b>
// <p>
// As mentioned above, Isomorphic recommends the use of UTF-8 encoding.  However, it is
// not possible to configure some servlet engines to do this by default.  Both Tomcat and Jetty
// default to the ISO-8859-1 character set (commonly known as Latin-1), even if the Java VM
// specifies a different encoding (the Tomcat documentation claims that this behavior is a
// requirement of the Servlet specification).
// <p>
// To work around this, we change charset encoding to UTF-8 on every request/response that
// goes through two core Isomorphic servlets: <code>IDACall</code> and <code>DataSourceLoader</code>.
// If you need to change this, you can do so by adding <code>init-param</code> settings to your
// <code>web.xml</code> file.  Please see the Javadocs for those two servlets for examples of
// how to do this.
// <p>
// <u><b>Framework Message Localization</b></u>
// <p>
// SmartClient components include standard prompts and error messages in various cases, and all
// such messages support localization.
// <P>
// <smartclient>
// Language packs are included in the directory smartclientSDK/isomorphic/locales.  To load a
// language pack, simply include the desired locale via a
// standard HTML &lt;script src=&gt; tag, for example:
// <pre>
//    &lt;SCRIPT SRC="isomorphic/locales/frameworkMessages_pt.properties"&gt;&lt;/SCRIPT&gt;
// </pre>
// .. to load the Portuguese locale.
// <p>
// Alternatively can use the <code>locale</code> attribute on the <code>loadISC</code> or
// <code>loadModules</code> jsp tags:
// <pre>
//   &lt;isomorphic:loadISC skin="Enterprise" locale="pt"/&gt;
// </pre>
// Or, if you have the +link{group:networkPerformance,Network Performance}, you can use the
// +link{FileLoader.loadLocale}/+link{FileLoader.cacheLocale} APIs:
// <pre>
//   isc.FileLoader.loadLocale("pt");
// </pre>
// <p>
// To see various locales, have a look at the
// +explorerExample{changeLocales,Localization example}.
// </smartclient>
// <smartgwt>
// SmartGWT ships with pre-built language packs for many languages.  These are automatically
// used by the framework: all you have to do is ensure that the appropriate locale has been
// set using one of the
// <a href=https://developers.google.com/web-toolkit/doc/latest/DevGuideI18nLocale#LocaleSpecifying>standard GWT mechanisms</a>.
// In brief, either:<ul>
// <li>Add a meta tag to your bootstrap page: <code>&lt;meta name="gwt:property" content="locale=ja_JP"&gt;</code></li>
// <li>Specify the locale in a query parameter: <code>http://www.example.org/myapp.html?locale=fr_CA</code></li>
// </ul>
// </smartgwt>
// <P>
// If you find that the language pack you are using has any incorrect or missing translations,
// or you want to add a new language pack, please visit
// +externalLink{http://forums.smartclient.com/showthread.php?t=9987,this forums thread} for
// instructions on how to contribute translations so that they will be added to future
// SmartClient builds.
// <P>
// You can alternatively maintain your own private additions or overrides to the default
// language packs.
// <smartclient>
// A complete list of standard messages is presented +link{group:i18nMessages, here}.<br>
// To customize these messages, use +link{Class.addProperties()} or
// +link{Class.addClassProperties()} to override default values at the instance or class level
// respectively.  For example, the class property
// +link{classAttr:RPCManager.timeoutErrorMessage} is displayed to the user in a warning dialog
// when a SmartClient operation fails to complete.  This can be modified using the
// +link{Class.addClassProperties()} method, as follows:
// <pre>
// isc.RPCManager.addClassProperties({timeoutErrorMessage:"Custom Timeout Message"});
// </pre>
// </smartclient>
// <smartgwt>
// Use the standard GWT technique for selectively overriding Messages: create a
// subclass of <code>SmartGwtMessages</code> that overrides specific methods, and a
// .properties file with your overridden messages.  Then create your overridden Messages
// instance and call <code>I18nUtil.initMessages()</code> with it.  For example:
// <pre>
//    public class CustomizedSgwtMessages extends com.smartgwt.client.i18n.SmartGwtMessages {
//       // override button_title
//       String button_title();
//    }
//
//    // then in a new file CustomizedSgwtMessages.properties
//    button_title=My Title
//
//    // and in a new file CustomizedSgwtMessages_fr.properties
//    button_title=French translation
//
//    // then in your onModuleLoad() call
//    CustomizedSgwtMessages myMessages = GWT.create(CustomizedSgwtMessages);
//    I18nUtil.initMessages(myMessages);
// </pre>
// </smartgwt>
// <p>
// <u><b>Application Message Localization</b></u>
// <p>
// <smartclient>
// Text such as button titles typically appears in the middle of JavaScript code:
// <pre>
//     isc.Button.create({ title: "Click me!"});
// </pre>
// If you are on the Java platform and your JavaScript code appears in a .jsp, you can use the
// JSTL Core package (Java Server Pages Standard Tag Library) to replace that static "Click
// me!" text with a localized reference.  This can be done as follows:
// <pre>
//     &lt;%@ taglib prefix="fmt" uri="/WEB-INF/fmt.tld" %&gt;
//     &lt;SCRIPT&gt;
//     isc.Button.create({ title: &lt;fmt:message key="buttonTitle"&gt; });
//     &lt;/SCRIPT&gt;
// </pre>
// Assuming you've set the current Locale and provided a resource bundle with the relevant
// translated text, the above would create a button with a title that comes from the locale-specific
// bundle you provided.  For more information, see Sun's i18n tutorial:
// +externalLink{http://java.sun.com/docs/books/tutorial/i18n/}.
// <P>
// Note that this approach does not imply that your JavaScript must appear in the midst of an
// HTML page.  A .jsp file can be used to return a pure JavaScript response via just removing
// the &lt;SCRIPT&gt; tags in the example above, and targetting the .jsp with a &lt;SCRIPT
// SRC=&gt; tag from another .jsp or .html file.
// <P>
// A second common technique is to load internationalized messages as a JavaScript Object
// mapping from a message name to the internationalized message.  For example, if your messages
// are stored in Java .properties format, you could load your .properties file as a standard Java
// +externalLink{http://docs.oracle.com/javase/6/docs/api/java/util/Properties.html,Properties object},
// and use the server-side com.isomorphic.js.JSTranslater.toJSVariable() API to output the
// properties as a JavaScript variable.
// <P>
// If the variable name chosen was 'i18nMessages', code to make use of the .properties data
// would look like:
// <pre>
//     isc.Button.create({ title: i18nMessages["buttonTitle"] });
// </pre>
// <P>
// Approaches for non-Java platforms are similar, and generally any approach that works for
// HTML or JavaScript files works with SmartClient.  See the end of this section for pointers
// to additional resources.
// </smartclient>
// <smartgwt>
// String localization in SmartGWT is best done using <a href=http://code.google.com/webtoolkit/doc/latest/DevGuideI18n.html>
// standard GWT approaches</a>.  Although GWT supports various ways of localizing strings,
// Isomorphic recommends the use of an approach based on Resource Bundles.  Other parts of
// SmartGWT - for example, <code>.ds.xml</code> files - are best localized using resource
// bundles, so using resource bundles makes it easier to share messages that are used both
// client and server side.
// </smartgwt>
// <p>
// <u><b>Localizing Server-side Error Messages</b></u>
// <p>
// If you are providing error messages from server-side code, use standard Java techniques to
// determine the locale (<code>servletRequest.getLocale()</code>) and load ResourceBundles.
// Note that if you are using +link{validator.serverObject,DMI validation}, the
// HttpServletRequest is available via the standard +link{dmiOverview,DMI} approach: just
// declare it as an additional parameter, and it is provided.
// <p>
// <u><b>Support for Right-to-Left (RTL) languages</b></u>
// <p>
// SmartClient includes support for RTL languages.  To enable, simply set
// <code>dir="rtl"</code> on the HTML element:
// <pre>
//    &lt;HTML dir="rtl"&gt;
// </pre>
// ListGrid columns, horizontal layouts, scrolling directions, etc will reverse order
// automatically.
// <p>
// Because RTL in some cases requires additional media files, RTL is only supported for the
// Enterprise, EnterpriseBlue and Graphite skins.
// <p>
// <u><b>DataSource and Component XML localization</b></u>
// <p>
// Please see the separate article on
// +link{group:dataSourceLocalization,DataSource and Component XML Localization}
// <p>
// <u><b>Localized Number and Currency Formatting</b></u>
// <p>
// Please see the separate article on
// +link{group:localizedNumberFormatting,Localized Number Formatting}
// <p>
// <smartclient>
// <u><b>Image, CSS localization</b></u>
// <p>
// Most SmartClient components use a mixture of text, CSS and images to render.  If you wish to
// provide locale-specific images or use locale-specific CSS, you can create localized copies
// of a SmartClient skin named after the locale and modify images as you see fit.  A skin is
// specified at load time using either the <code>skin</code> attribute of the
// <code>&lt;isomorphic:loadISC&gt;</code> tag or by loading the skin
// directly using a script tag like so: &lt;SCRIPT SRC=/isomorphic/skins/[skin]/load_skin.js&gt;.
// If you're using the <code>loadISC</code> tag, you can specify a locale-specific skin like so:
// <pre>
// &lt;isomorphic:loadISC skin="[localeName]"/&gt;
// </pre>
// Or you can use a script tag like so:
// <pre>
// &lt;SCRIPT SRC=/isomorphic/skins/[localeName]/load_skin.js&gt;&lt;/SCRIPT&gt;
// </pre>
// Where the <code>[localeName]</code> is the name of the current locale - you'll have this in the
// current page context as you'll need it to use the JSTL &lt;fmt:setLocale&gt; tag.
// <p>
// </smartclient>
// Resources:
// <p>
// <b><u>Java</u></b>
// <ul>
// <li>Sun's i18n tutorial: +externalLink{http://java.sun.com/docs/books/tutorial/i18n/}
// <li>JSTL documentation home page: +externalLink{https://www.oracle.com/java/technologies/jstl-documentation.html}
// <li>Apache taglibs: +externalLink{https://tomcat.apache.org/taglibs/index.html}
// </ul>
// <p>
//
// <b><u>.NET</u></b>
// <ul>
// <li>MSDN Developer Resource: "Developing World-Ready Applications":
// +externalLink{https://docs.microsoft.com/en-us/dotnet/core/extensions/best-practices-for-developing-world-ready-apps}
// </ul>
//
// <b><u>PHP</u></b>
// <ul>
// <li>PHP Gettext manual: +externalLink{http://us2.php.net/gettext}
// </ul>
// <p>
//
// @treeLocation Concepts
// @title Internationalization and Localization
// @visibility external
//<





//> @groupDef dataSourceLocalization
// <smartclient>
// DataSources can be created in +link{group:dataSourceDeclaration,several ways}.
// DataSources created directly in JavaScript can be
// internationalized via the techniques described in the main +link{group:i18n,i18n article}.
// </smartclient>
// DataSources which are declared in XML (.ds.xml files) and are read by the SmartClient
// server, which are normally loaded <smartclient>into a .jsp page via the
// <code>&lt;isomorphic:loadDS&gt;</code> JSP tag,</smartclient>
// <smartgwt>by the <code>DataSourceLoader</code> servlet,</smartgwt> can instead be
// internationalized using an approach similar to the internationalization of JSP files with
// JSTL tags.  This approach is also supported for screens defined using
// +link{group:componentXML,Component XML}.
// <p>
// <b>Note: </b>The tags we use for internationalizing SmartClient XML files look like
// standard JSTL tags; this is intentional, simply because developers are familiar with JSTL.
// However, the tags are being processed by SmartClient code, <b>not</b> JSTL, so only the
// specific tags documented here are supported.
// <P>
// Given the following DataSource located in /shared/ds/supplyItem.ds.xml:
// <pre>
// &lt;DataSource ID="supplyItem"&gt;
//     &lt;fields&gt;
//         &lt;field name="itemName"&gt;
//             &lt;title&gt;Item Name&lt;/title&gt;
//             &lt;validators&gt;
//                 &lt;Validator type="lengthRange" max="40"&gt;
//                     &lt;errorMessage&gt;Must be 40 characters or less.&lt;/errorMessage&gt;
//                 &lt;/Validator&gt;
//             &lt;/validators&gt;
//         &lt;/field&gt;
//     &lt;/fields&gt;
// &lt;/DataSource&gt;
// </pre>
// To localize the title and validator error string of the <code>itemName</code> field,
// change the DataSource definition as follows:
// <pre>
// &lt;DataSource ID="supplyItem" xmlns:fmt="WEB-INF/"&gt;
//     &lt;fields&gt;
//         &lt;field name="itemName"&gt;
//             &lt;title&gt;&lt;fmt:message key="itemTitle"/&gt;&lt;/title&gt;
//             &lt;validators&gt;
//                 &lt;Validator type="lengthRange" max="40"&gt;
//                     &lt;errorMessage&gt;&lt;fmt:message key="itemLengthRangeValidator"/&gt;&lt;/errorMessage&gt;
//                 &lt;/Validator&gt;
//             &lt;/validators&gt;
//         &lt;/field&gt;
//     &lt;/fields&gt;
// &lt;/DataSource&gt;
// </pre>
// This will cause SmartClient Server to look for a
// <a href=http://docs.oracle.com/javase/8/docs/api/java/util/ResourceBundle.html#getBundle-java.lang.String-java.util.Locale->ResourceBundle</a>
// called "supplyItem", containing keys "itemTitle" and "itemLengthRangeValidator", and
// replace the <code>&lt;fmt:message&gt;</code> tags with the values from the resource bundle
// in the expected way.  It obtains the user's <code>Locale</code> from the servlet request,
// but you can override this if you want to force an application-specific locale, regardless of
// the user's operating system settings.  To do this, <smartclient> either specify
// a "locale" attribute in the &lt;loadDS&gt; tag, like this:<br>
// <code>&lt;loadDS ID="myDataSource" locale="es" /&gt;</code><p>
// or </smartclient> specify a "locale" parameter on HTTP requests to the <code>DataSourceLoader</code>
// and <code>IDACall</code> servlets (the latter is typically done via
// +link{RPCManager.actionURL}).
// <p>
// <smartclient> In both of these cases, the </smartclient>
// <smartgwt>The </smartgwt> locale parameter should be an underscore-separated string
// conforming to the rules described in
// <a href=https://docs.oracle.com/javase/8/docs/api/java/util/Locale.html>this article</a>
// on Java internationalization.  For example, "fr" (French language) or "en_US" (English
// language, US location).
// <p>
// As mentioned, SmartClient Server will look for a <code>ResourceBundle</code> called
// "supplyItem" in this case because it defaults to the name of the DataSource.  It is
// possible to override this default at both the DataSource and field levels:
// <ul>
// <li>Specify <code>&lt;fmt:bundle&gt;</code> as a top-level DataSource tag, like this:<br>
// <pre>   &lt;DataSource  xmlns:fmt="WEB-INF/" ID="supplyItem"&gt;
//      &lt;fmt:bundle basename="com.isomorphic.test.i18n" /&gt;
//      ...
// &lt;/DataSource&gt;</pre></li>
// <li>Specify the bundle name in the individual <code>&lt;fmt:message&gt;</code> tags, like this:<br>
// <pre>   &lt;title&gt;&lt;fmt:message key='title1' bundle="com.mycompany.MyProperties" /&gt;&lt;/title&gt;</pre></li>
// </ul>
// When you name a resource bundle manually like this, if you qualify the name it influences
// where we expect to find that resource bundle.  In the above example, we would look in the
// <code>com.mycompany</code> package.  For unqualified names (including the default of the
// DataSource name that we use in the absence of an override), we look in the so-called
// "default package", which corresponds to the root of your classes directory or the root of
// a .JAR file.
// <p>
// Note that the <code>xmlns:fmt</code> attribute in the DataSource definition is required by
// the XML parser if you intend to use our <code>fmt:message</code> features.  However, the
// actual value you use is unimportant as long as it is present.
// <p>
// Although these examples don't show it, note that it is also possible to internationalize
// DataSource-level values in the same way as field-level values - for example:<pre>
//   &lt;DataSource  xmlns:fmt="WEB-INF/" ID="i18nTest"&gt;
//     &lt;title&gt;&lt;fmt:message key="dsTitle" /&gt;&lt;/title&gt;
//      ...
// &lt;/DataSource&gt;
// </pre>
// <p>
// Any property on a DataSource or on a UI component that is documented to be of "String" type
// or any derived type (such as "URL") supports the <code>fmt:message</code> tags.
// <p>
// Note that any amount of whitespace around &lt;fmt&gt; tag is ignored, unless there is also
// some text, then whitespace becomes significant as well. A declaration like this one:
// <pre>
//   &lt;DataSource  xmlns:fmt="WEB-INF/" ID="i18nTest"&gt;
//     &lt;title&gt;
//         <b>Some text</b> &lt;fmt:message key="dsTitle" /&gt;
//     &lt;/title&gt;
//      ...
// &lt;/DataSource&gt;
// </pre>
// .. will cause linefeed / carriage return characters to be embedded in your title as well as the
// text. This can be useful in situations where you want to embed small amounts of static text in
// a localized attribute, but most of the time, you will want the &lt;fmt&gt; tag on one line with the
// surrounding tag (eg "title").
// <p>
// If any HTML tags are needed around a &lt;fmt&gt; value, you can place them into the resource bundle
// or use the <i>CDATA section</i> to escape them in the XML file:
// <pre>
//  &lt;DataSource  xmlns:fmt="WEB-INF/" ID="i18nTest"&gt;
//     &lt;title&gt;<b>&lt;![CDATA[&lt;b&gt;]]&gt;</b>&lt;fmt:message key="dsTitle" /&gt;<b>&lt;![CDATA[&lt;/b&gt;]]&gt;</b>&lt;/title&gt;
//      ...
// &lt;/DataSource&gt;
// </pre>
//
// <h4>Unicode support</h4>
// The Java language insists that <code>.properties</code> files be encoded with ISO-8859-1 -
// in other words, that they be plain ASCII files.  This means that any non-ASCII characters
// have to be escaped, like so: <b>\u1234</b>.  For languages like Russian or Japanese, that
// are based on completely non-ASCII character sets, this obviously leads to
// <code>.properties</code> files that are entirely escaped references, and are not
// human-readable.  Although the <code>nativetoascii</code> tool is provided with Java to make
// the creation of these escaped files less tedious, it is still inconvenient that this
// "compilation step" is required.
// <p>
// SmartClient avoids the need for this when localizing DataSources and Component XML by
// directly supporting <code>.properties</code> files encoded with UTF-8.  To make use of this:
// <ul>
// <li>Encode your <code>.properties</code> file with UTF-8, preferably without a BOM (Byte
// Order Marker).  SmartClient Server will simply ignore the BOM in a <code>.properties</code>
// file if it is present, but you may see odd behavior from other software if the BOM is
// present in other types of file - for example, JSP snippets that are included in other pages.
// The BOM has no meaning in a UTF-8 file anyway, so we recommend just omitting it from all
// your UTF-8 files (though note that doing this may confuse some editing software,
// particularly on Windows)</li>
// <li>Encode your bootstrap file(s) in UTF-8 and set headers or meta tags to inform the
// browser that the file is UTF-8 encoded, as described in +link{group:i18n,this article}</li>
// <li>In your <code>&lt;fmt:bundle&gt;</code> tag, specify an <code>encoding</code> attribute.
// There are only two supported values for this attribute: "utf-8" and "iso-8859"</li>
// <li>You can also override the encoding in individual <code>&lt;fmt:message&gt;</code> tags,
// just like to can override the bundle to use.  Again, just specify an <code>encoding</code>
// attribute</li>
// <li>You can make UTF-8 encoding the global default by setting attribute
// <code>i18n.resourceBundle.parse.utf-8</code> to true in your <code>server.properties</code>
// file.  This prevents you from having to explicitly specify <code>encoding="utf-8"</code>
// in all your <code>.ds.xml</code> and <code>.ui.xml</code> files</li>
// <li>Note that <code>.properties</code> files are located and parsed by SmartClient framework
// code when <code>encoding="utf-8"</code> is in force.  Our parsing code only supports
// the naming conventions explained in the article linked to above; specifically, it does not
// support the additional "script" and "extension" elements introduced in Java 7.  File names
// must be of the form "basename_language_COUNTRY_VARIANT", where "COUNTRY" and "VARIANT" are
// optional.  Examples: "fr", "en_US", "en_GB_POSIX"</li>
// </ul>
//
// <h4>Component XML</h4>
// All of the above applies similarly for localizing screens defined using
// +link{group:componentXML,Component XML}.  For example:<pre>
// &lt;isomorphicXML xmlns:fmt="WEB-INF/"&gt;
//   &lt;fmt:bundle basename="com.isomorphic.test.i18n.test" /&gt;
//   &lt;Window ID="testWin1"&gt;
//     &lt;title&gt;&lt;fmt:message key='title1' /&gt;&lt;/title&gt;
//   &lt;/Window&gt;
// &lt;/isomorphicXML&gt;
// </pre>
// Note the following differences between localizing <code>.ds.xml</code> (DataSource) files and
// localizing <code>.ui.xml</code> (component XML) files: <ul>
// <li>The <code>&lt;isomorphicXML&gt;</code> tag, which is ordinarily only used to wrap
// multiple widget definitions to give a valid XML file, is required if you are using this
// internationalization technique.</li>
// <li>Because there is no concept of an "ID" associated with a <code>.ui.xml</code> file,
// there is no default bundle like there is with DataSource definitions.  Instead, you have to
// specify the bundle by hand, either by adding a <code>&lt;fmt:bundle&gt;</code> tag as an
// immediate child of the <code>&lt;isomorphicXML&gt;</code> tag, or by specifying
// <code>bundle</code> attributes in your individual <code>&lt;fmt:message&gt;</code> tags.</li>
// <li>Locale can be overridden, as described for DataSources above, by
// specifying a "locale" parameter on HTTP requests to the <code>ScreenLoaderServlet</code>
// (this is done for you when you pass a locale to the +link{RPCManager.loadScreen} method).</li>
// </ul>
//
// <h4>Custom localization provider support</h4>
// Custom localization providers can be configured for the entire framework or for specific
// DataSource and Component XML instances based on their names. For more details see
// javadoc for <code>com.isomorphic.util.LocaleMessageProviderRegistry</code> server-side API.
//
// <h4>Troubleshooting</h4>
// If something went wrong, we use fmt string as a value:
// <code>&lt;fmt:message key="message_key"&gt;</code>.
// Getting similar value instead of localized message means that either <code>bundle</code>
// could not be found or the <code>key</code> is incorrect, look for warnings in server logs
// for specific details.<br>
//
// @treeLocation Concepts/Internationalization and Localization
// @title DataSource and Component XML Localization
// @visibility external
//<

//> @groupDef localizedNumberFormatting
//
// Use the special +link{dataSourceField.type,field types} "localeInt", "localeFloat" and
// "localeCurrency" to have locale-specific formatting applied to numeric values, as well as
// automatic parsing of user inputs that use locale-specific decimal and grouping separators.
// <p>
// <smartclient>
// These special types rely on the settings +link{numberUtil.decimalSymbol},
// +link{numberUtil.groupingSymbol} and +link{numberUtil.currencySymbol}.  These are normally
// set automatically when you load a language pack for the current locale.
// <p>
// See +link{group:i18n} for more background on internationalization and loading language packs
// for the current locale.
// </smartclient>
// <smartgwt>
// These special types automatically use GWT's NumberFormat logic, using the default locale.
// Additional +link{SimpleType,SimpleTypes} can be created that call GWT's NumberFormat if more
// variations are needed.
// <p>
// Note that language packs shipped with SmartGWT contain properties such as "decimalSymbol"
// that seemingly would control localized number formatting.  These are inactive for SmartGWT
// and should be ignored.
// <p>
// See +link{group:i18n} for more background on internationalization.
// </smartgwt>
//
// @title Localized Number Formatting
// @visibility external
//<

//> @groupDef featureExplorerOverview
//
// The +docTreeLink{FeatureExplorer, Feature Explorer} is an example shell designed to help you
// explore the capabilities of SmartClient.  Read on for a brief overview, including specific
// instructions for using the example code in your own standalone application.
// <p>
// The tree on the left of the Feature Explorer contains examples grouped by logical
// categories.  Selecting an example brings it up on the right side of the screen, inside a
// tabbed view.  The default "View" tab shows the interactive example itself, while other
// tabs show the underlying source.  The "JS" tab shows the source for the example.  There is
// sometimes also an "XML" tab that shows the corresponding version in
// +link{componentXML, Component XML} format.  For databound examples, there are also
// frequently additional tabs that show the +link{dataSource, DataSources} associated with the
// example.
// <p>
// <b><u>How to create a standalone application using code from the Feature Explorer</u></b>
// <p>
// The Feature Explorer shell is designed to show many examples in one place and to enable
// experimentation by providing a way for you to modify example code and try out your changes.
// As a result, the Feature Explorer requires some basic server support and its examples omit
// the usual SmartClient module includes that have to be in place for using SmartClient
// components standalone.
// <p>
// If you'd like to use example code in your application to get started quickly, create a page
// with SmartClient includes and then take the code from the "JS" tab and place it between
// &lt;SCRIPT&gt; blocks as described +link{group:nonJavaBackend, here}.  If the example also
// includes a datasource, place the datasource definitions in the same file before the
// component code.  Note that DataSources (and components) written in XML require the optional
// SmartClient server.  If you're using the server, you can include them on your page using the
// +link{group:loadDSTag} tag.
// <p>
// <b><u>Feature Explorer difference in the LGPL package</u></b>
// <p>
// The LGPL edition of SmartClient does not include the SmartClient Java Server as part of the
// licensed software, but a trimmed down server is included in the package to support the
// Feature Explorer shell.  There are some examples that use DataSources that would normally
// use the SmartClient server for persistence.  In the LGPL package, these DataSources are
// automatically turned into +link{group:clientOnlyDataSources, Client Only DataSources} and
// the Feature Explorer loads the data for these one-time from the dataURL or testFileName
// attributes specified on the DataSource.  Subsequent DataSource operations work against this
// client-side dataset, which is why changes to the data aren't permanent in these examples.
// <p>
// Check out the +link{clientServerIntegration, Client-Server Integration} overview topic for
// an overview of your DataBinding options.
//
// @title Feature Explorer Overview
// @visibility external
//<



//> @groupDef iscInstall
// The SmartClient framework is distributed with both client and server components.  JavaScript components run on the
// client, in the browser, and integrate with optional server components that run in a standards-compliant
// +externalLink{https://docs.oracle.com/javaee/5/tutorial/doc/bnabo.html, web container},
// like +externalLink{https://tomcat.apache.org/index.html, Tomcat}.  Client components don't necessarily require the
// server, but server components are designed to make many complicated tasks trivial.  See the SmartClient
// +externalLink{https://www.smartclient.com/product/, feature matrix} for details.
// <p>
// In all cases, Isomorphic strongly recommends using some form of
// +externalLink{https://devopedia.org/dependency-manager, dependency management} in your project, as it dramatically
// simplifies framework installation and upgrades.  Those not using the SmartClient server might consider using the
// built-in +link{npmjs, support for Node Package Manager}, but most teams with Java experience are at least familiar
// with +externalLink{https://maven.apache.org/guides/index.html, Maven} so SmartClient also
// +link{mavenSupport, includes support} for publishing both client and server components
// to a Maven repository.  Note that your project doesn't necessarily need to be built with Maven, it just needs to be
// able to retrieve its dependencies from that repository.
// +externalLink{https://gradle.org, Gradle} and
// +externalLink{http://ant.apache.org/ivy/index.html, Ivy} are two popular alternatives, for example.
// <p>
// Those who might prefer to evaluate SmartClient using a self-contained SDK, or still wish to manage the installation
// manually should refer to the separate documentation topic covering the +link{sdkInstall, SDK Installation}.  The rest
// of this overview touches briefly on context, tips, and tricks for those who want to follow best practices but may not
// necessarily have experience with Java web application development or with Maven.
// <p>
// +externalLink{https://maven.apache.org/what-is-maven.html, "Maven is a software project management and comprehension tool"},
// whose key features include
// +externalLink{https://maven.apache.org/guides/introduction/introduction-to-dependency-mechanism.html, a mechanism for dependency resolution}
// as recommended above.  In short, Maven attempts to retrieve these resources first from a local
// +externalLink{https://maven.apache.org/guides/introduction/introduction-to-repositories.html, repository}.  If the
// resource isn't found, it attempts to retrieve it from one or more remote repositories, and caches it for subsequent
// attempts.
// <p>
// Most open source Java libraries can be found on the (remote) +externalLink{https://search.maven.org, Maven Central}
// repository, which requires no configuration to use.  Occasionally, however, the library you need isn't published to
// any public repository, and you'll need to
// +externalLink{https://maven.apache.org/guides/mini/guide-3rd-party-jars-local.html, install it locally} or
// +externalLink{https://maven.apache.org/guides/mini/guide-3rd-party-jars-remote.html, deploy it to a remote repository}.
// Most environments should be using a remote repository
// +externalLink{https://maven.apache.org/repository-management.html, provided by a repository manager} set up and
// maintained by your organization.
// <p>
// SmartClient is not published to any public repository, and so will need to be installed or deployed before you're able
// to use it in any project.  This can be quite tedious when it has to be done for as many
// +externalLink{https://www.smartclient.com/smartclient-release/isomorphic/system/reference/mavendoc/maven-usage.html, artifacts}
// as are provided in current distributions, so
// +externalLink{http://github.smartclient.com/isc-maven-plugin/, an open source Maven "Plugin"} is made available with
// +externalLink{http://github.smartclient.com/isc-maven-plugin/install-mojo.html, install} and
// +externalLink{http://github.smartclient.com/isc-maven-plugin/deploy-mojo.html, deploy} goals that each are capable of
// downloading, unpacking, and installing or deploying
// +externalLink{https://www.smartclient.com/builds/index.jsp, Patch &amp; Development Builds} in a single step.
// After Maven has been +externalLink{https://maven.apache.org/download.cgi, downloaded},
// +externalLink{https://maven.apache.org/install.html, installed}, and
// +externalLink{http://github.smartclient.com/isc-maven-plugin/examples/configuration.html, configured}
// (some configuration required for other than LGPL or EVAL SmartClient builds), this whole process takes no more
// than a few minutes on a reasonably fast network.  Refer to +link{mavenSupport} documentation for a command that you
// can copy and paste to install the most recent evaluation version of SmartClient, and another to get you started by
// +externalLink{https://maven.apache.org/archetype/maven-archetype-plugin/usage.html, generating a skeleton project}
// from a +externalLink{https://maven.apache.org/archetype/index.html, Maven archetype}, or template.
// <p>
// Having run both of those commands, your newly created project will contain a
// +externalLink{https://maven.apache.org/guides/introduction/introduction-to-the-pom.html, pom.xml file}, which details
// among other things the libraries, or dependencies, needed to compile, package, and run the app.  In this case, you'll
// find a reference to the version of SmartClient you used to create the project.  To upgrade, you'll just change the
// value of the ${smartclient.version} property to reflect another build number that you've installed or deployed using
// the process outlined above and rebuild.  To add another JAR to your project, you just add the dependency to your POM.
// To add one of the SmartClient +link{loadingOptionalModules, optional modules}, for example, you'd first use the plugin
// to install / deploy it to your own repository and then add the appropriate block to your POM's dependencies section.
// <p>
// Your project will also contain a README file containing a copy/paste command line for installing, deploying to and
// starting a local 'embedded' +externalLink{https://www.eclipse.org/jetty/, Jetty} server, as well as detailed
// instructions for +externalLink{https://help.eclipse.org/latest/index.jsp, Eclipse} integration, and even automated
// conversion to an +externalLink{https://ant.apache.org, Ant} based build (complete with Ivy configuration).
// Isomorphic generally recommends starting with the Jetty command to see things working quickly before experimentation
// with other approaches.  The plugin provides an
// +externalLink{http://github.smartclient.com/isc-maven-plugin/faq.html, FAQ} for reference, and posting
// questions / issues to the public +externalLink{https://forums.smartclient.com, forum}
// for help is always appropriate.
//
// @treeLocation Concepts
// @title Installing the SmartClient runtime
//<

//> @groupDef sdkInstall
// Isomorphic currently recommends leveraging the +link{mavenSupport, support for Maven}, for
// those who are comfortable with it, as it dramatically simplifies initial installs,
// acquiring patched builds, and upgrading to new versions.  Those not using Java might also
// consider using the built-in support for +link{npmjs, Node Package Manager}.
// <p>
// For those unable or unwilling to do so, however, this overview serves as a how-to for
// installing SmartClient into your web application.
// Evaluators are urged to use the SmartClient SDK with the embedded tomcat servlet engine
// during evaluation rather than pursue installation into an existing web application up front,
// however, reading this document and the related +link{group:clientServerIntegration,server
// integration} materials is recommended to get an overview.
// <P>
// SmartClient has two pieces - the client components that run in the browser and the server
// components that run in a J2SE-compatible container.  You don't need to use a Java back-end
// to use SmartClient, but the SDK comes with some examples that assume the presence of the
// Java back-end and, for some examples, a SQL Database.  If you will be using SmartClient with
// a Java back-end, see below for the list of J2SE application servers supported by the Java
// implementation of the SmartClient server.
// <p>
// The SDK contains two top-level directories: <code>smartclientSDK</code> and
// <code>smartclientRuntime</code>.  The <code>smartclientSDK</code> directory contains the
// embedded servlet engine, embedded database, examples, and documentation.  The
// <code>smartclientRuntime</code> directory contains just the client and server components of
// the SmartClient product - use the contents of this directory when deploying SmartClient into
// your application environment.
// <p>
// <u><b>Client integration</b></u>
// <p>
// To install the client-side portion of SmartClient, simply copy the <code>isomorphic</code>
// directory from the smartclientRuntime webroot to the webroot of your application.  Having
// done this you can use SmartClient components on your pages regardless of the technologies
// used on your back-end and you can bind to server-side componentry backed by arbitrary
// technology - see the <i>Data Integration</i> section of the
// +link{group:clientServerIntegration} section for more information.
// <p>
// <u><b>Server integration</b></u>
// <p>
// <span style='color:red'>Note:</span> Some of the instructions below ask you to copy files
// into the WEB-INF/classes folder.  If you're using an IDE such as Eclipse that attempts to
// manage the WEB-INF/classes folder, we recommend that you copy these files to the src/
// directory of your project (next to the top-level folder for your java namespace) such that
// your IDE auto-deploys them to the WEB-INF/classes folder.  We have seen cases of tools like
// Eclipse periodically deleting files that are checked into to WEB-INF/classes directly.
// <p>
// <ul>
// <li> Copy all files from the WEB-INF/lib directory of the smartclientRuntime to your
// WEB-INF/lib.  The set of libs in the smartclientRuntime/WEB-INF/lib folder is a minimal set;
// smartclient<b>SDK</b>/WEB-INF/lib contains all other .jars you might need, including third-party
// libraries bundled for convenience.  See
// +link{group:javaModuleDependencies,Java Module Dependencies} for details of the .JAR files that
// comprise the SmartClient Server, and their dependencies on various third-party libraries.
// Generally, if there are conflicts with the versions of third-party libraries you want to
// use, you can use the versions you want - SmartClient has minimal dependencies on these
// libraries.
// <li> Copy the WEB-INF/classes/log4j.isc.config.xml from the smartclientRuntime to your
// WEB-INF/classes
// directory.  This file contains the SmartClient server log configuration.
// See +link{group:serverLogging} for information on server-side logging and how to configure it.
// <li> Copy the +link{group:server_properties,WEB-INF/classes/server.properties}
// from the smartclientRuntime to your WEB-INF/classes
// directory.  This file contains settings for basic file locations such the location of
// webroot, the SmartClient SQL engine and DMI.  The version under smartclientRuntime has a
// basic, secure configuration.  See the version of +link{group:server_properties,server.properties}
// under the smartclientSDK directory for sample SQL and other settings.
// <li> Merge portions of the WEB-INF/web.xml into your application's web.xml; there are
// mandatory and optional servlets and filters to consider - see below.
// <li> <b>Power and Enterprise Editions only</b>.  Copy the shared/ds/batchUpload.ds.xml file
// to the same location in your target webapp directory.  This file is a utility DataSource
// that is used to provide the initial upload functionality of the +link{BatchUploader}
// component - strictly speaking, you only need to perform this step if you intend to use that
// component.
// </ul>
// <p>
// See +link{servletDetails,Core and Optional SmartClient servlets} for details of additional
// changes you may need to make to your applications <code>web.xml</code> file.  See
// +link{group:javaModuleDependencies,Java Module Dependencies} for details of the .JAR files that
// comprise the SmartClient Server, and their dependencies on various third-party libraries.
// <p>
// <u><b>Multiple Applications / WARs</b></u>
// <p>
// To integrate the server portion of SmartClient, you need to follow the steps below for each
// application (WAR) that uses SmartClient.  Note that, if installing into an environment that
// uses multiple WARs, installation of SmartClient JARs into a directory shared by multiple
// applications is not supported.  Installation of a separate WAR with client-side SmartClient
// modules for maintaining cache coherence across applications using the same version of ISC is
// supported - contact Isomorphic support for more details on how to set that up.
// <p>
// <u><b>Troubleshooting</b></u>
// <p>
// This section covers some common problems with possible solutions.  You may also need to refer to the
// documentation for your specific application server, web server, or database. If you experience any problems
// installing and configuring SmartClient in your environment, please post on the
// <a href="http://forums.smartclient.com/" target='_blank'>SmartClient forums</a> for
// assistance.
// <p>
// <table width="90%" class="normal" align="center" border="1" cellpadding="5">
// <tr bgcolor="#808080">
//     <td width="30%"><b>Problem</b></td>
//     <td width="30%"><b>Possible Causes</b></td>
//     <td width="40%"><b>Solution</b></td>
// </tr><tr>
//     <td rowspan='3'>Browser displays a generic "page cannot be displayed" or "unable to locate the server" message.</td>
//     <td>Servlet engine not started.</td>
//     <td>Start your application server.</td>
// </tr><tr>
//     <td>Missing/incorrect port for servlet engine in URL.</td>
//     <td>Check the startup messages, logs, or documentation for the servlet engine to determine what port it is using.</td>
// </tr><tr>
//     <td>Host name is incorrect.</td>
//     <td>Check whether other pages on the host can be accessed.
//         Try the base URL http://[host name]:[port number] to see whether the servlet engine or webserver is functioning.</td>
// </tr><tr>
//     <td>Browser displays a 404 or other page/file not found error.</td>
//     <td>Incorrect URL.</td>
//     <td>Check for errors in the URL, including capitalization.</td>
// </tr><tr>
//  <td>ClassNotFound or other Java Exceptions in the server log.</td>
//  <td>Missing JAR files</td>
//  <td>Verify every required .jar has been copied into the WEB-INF/lib directory of your
//  deployment.  Use +link{group:javaModuleDependencies,these docs} to double-check.  If in
//  doubt, copy every available .jar, verify this is working, then trim off .jars you are
//  definitely not using.</td>
// </tr><tr>
//  <td>"isc" is not defined JS error</td>
//  <td>Incorrect URLs to SmartClient modules</td>
//  <td>Use View Source to look at SCRIPT includes (e.g. for ISC_Core.js), try those URLs
//  directly in the browser to verify the files are correctly deployed</td>
// </tr>
// </table>
// <P>
// <u><b>Caching Considerations</b></u>
// <p>
// When upgrading from one SmartClient release to the next, you want to make sure that the user
// picks up the new version on next access, but you also want to keep the ISC modules cacheable
// so they're not refetched on every access.
// <p>
// SmartClient deals with this problem by appending a version string as a query parameter to
// each module load directive.  This is done by the &lt;isomorphic:loadISC&gt; and
// &lt;isomorphic:loadModules&gt; tags automatically.  As long as you make sure that the file
// that contains these tags is non-cacheable, you will get the desired behavior.
// <p>
// <u><b>Supported J2SE/J2EE Containers</b></u>
// <p>
// Below is the list of J2SE/J2EE containers that have been tested to be compatible with this
// version of SmartClient.  Installation in these containers is supported for deployment by
// Isomorphic.  If your application server is not on this list, please contact us at the
// <a href="http://forums.smartclient.com" target='_blank'>SmartClient forums</a> to see if we can support
// your deployment.  In general, the Java portion of ISC should work on servlet containers that
// comply with servlet specification version 2.3 and up and utilize a JVM no older than version
// 1.8.  Older, currently supported versions require Java 1.6, but support for even older JVMs
// may be possible via special
// <a href="https://www.smartclient.com/services/index.jsp#consulting">contract with Isomorphic</a>.
// <p>
// Supported J2SE/J2EE Containers:
// <p>
// <table class='normal'>
// <tr><td width=40></td><td width=400><i>Apache Tomcat 7.x, 8.x, 9.x</i></td><td></td></tr>
// <tr><td></td><td><i>Apache Geronimo 2.x, 3.x</i></td><td></td></tr>
// <tr><td></td><td><i>Apache TomEE 7.x, 8.x</i></td><td></td></tr>
// <tr><td></td><td><i>Oracle WebLogic 12c Release x, 14.x</i></td><td></td></tr>
// <tr><td></td><td><i>Caucho Resin 3.1.x, 4.x</i></td><td></td></tr>
// <tr><td></td><td><i>IBM WebSphere 8.x, 9.x</i></td><td></td></tr>
// <tr><td></td><td><i>IBM WebSphere Community Edition ${IBM_WebSphere_Community_Edition_versions}</i></td><td></td></tr>
// <tr><td></td><td><i>JBoss ${JBoss_versions}</i></td><td></td></tr>
// <tr><td></td><td><i>WildFly 8.x, 9.x, 10.x, 11.x, 12.x, 13.x, 14.x, 15.x, 16.x, 17.x, 18.x, 19.x, 20.x, </i></td><td></td></tr>
// <tr><td></td><td><i>Mortbay Jetty 9.x</i></td><td></td></tr>
// <tr><td></td><td><i>Glassfish 5.x</i></td><td></td></tr>
// </table>
//
// @title Deploying the SmartClient SDK
// @visibility external
//<



//> @groupDef sgwtEESetup
// The Smart GWT framework is distributed with both client and server components.  GWT components run on the
// client, in the browser, and integrate with optional server components that run in a standards-compliant
// +externalLink{https://docs.oracle.com/javaee/5/tutorial/doc/bnabo.html, web container},
// like +externalLink{https://tomcat.apache.org/index.html, Tomcat}.  Client components don't necessarily require the
// server, but server components are designed to make many complicated tasks trivial.  See the SmartGWT
// +externalLink{https://www.smartclient.com/product/, feature matrix} for details.
// <p>
// In all cases, Isomorphic strongly recommends using some form of
// +externalLink{https://devopedia.org/dependency-manager, dependency management} in your project, as it dramatically
// simplifies framework installation and upgrades.  Most teams with Java experience are at least familiar
// with +externalLink{https://maven.apache.org/guides/index.html, Maven} so Smart GWT also
// +link{mavenSupport, includes support} for publishing both client and server components
// to a Maven repository.  Note that your project doesn't necessarily need to be built with Maven, it just needs to be
// able to retrieve its dependencies from that repository.
// +externalLink{https://gradle.org, Gradle} and
// +externalLink{http://ant.apache.org/ivy/index.html, Ivy} are two popular alternatives, for example.
// <p>
// Those who still wish to manage the installation manually should refer to the separate documentation topic covering
// the +link{sgwtEEManualSetup, manual installation}.  The rest of this overview touches briefly on context, tips, and
// tricks for those who want to follow best practices but may not necessarily have experience with Maven.
// <p>
// +externalLink{https://maven.apache.org/what-is-maven.html, "Maven is a software project management and comprehension tool"},
// whose key features include
// +externalLink{https://maven.apache.org/guides/introduction/introduction-to-dependency-mechanism.html, a mechanism for dependency resolution}
// as recommended above.  In short, Maven attempts to retrieve these resources first from a local
// +externalLink{https://maven.apache.org/guides/introduction/introduction-to-repositories.html, repository}.  If the
// resource isn't found, it attempts to retrieve it from one or more remote repositories, and caches it for subsequent
// attempts.
// <p>
// Most open source Java libraries can be found on the (remote) +externalLink{https://search.maven.org, Maven Central}
// repository, which requires no configuration to use.  Occasionally, however, the library you need isn't published to
// any public repository, and you'll need to
// +externalLink{https://maven.apache.org/guides/mini/guide-3rd-party-jars-local.html, install it locally} or
// +externalLink{https://maven.apache.org/guides/mini/guide-3rd-party-jars-remote.html, deploy it to a remote repository}.
// Most environments should be using a remote repository
// +externalLink{https://maven.apache.org/repository-management.html, provided by a repository manager} set up and
// maintained by your organization.
// <p>
// Smart GWT is not published to any public repository, and so will need to be installed or deployed before you're able
// to use it in any project.  This can be quite tedious when it has to be done for as many
// +externalLink{https://www.smartclient.com/smartclient-release/isomorphic/system/reference/mavendoc/maven-usage.html, artifacts}
// as are provided in current distributions, so
// +externalLink{http://github.smartclient.com/isc-maven-plugin/, an open source Maven "Plugin"} is made available with
// +externalLink{http://github.smartclient.com/isc-maven-plugin/install-mojo.html, install} and
// +externalLink{http://github.smartclient.com/isc-maven-plugin/deploy-mojo.html, deploy} goals that each are capable of
// downloading, unpacking, and installing or deploying
// +externalLink{https://www.smartclient.com/builds/index.jsp, Patch &amp; Development Builds} in a single step.
// After Maven has been +externalLink{https://maven.apache.org/download.cgi, downloaded},
// +externalLink{https://maven.apache.org/install.html, installed}, and
// +externalLink{http://github.smartclient.com/isc-maven-plugin/examples/configuration.html, configured}
// (some configuration required for other than LGPL or EVAL Smart GWT builds), this whole process takes no more
// than a few minutes on a reasonably fast network.  Refer to +link{mavenSupport} documentation for a command that you
// can copy and paste to install the most recent evaluation version of Smart GWT, and another to get you started by
// +externalLink{https://maven.apache.org/archetype/maven-archetype-plugin/usage.html, generating a skeleton project}
// from a +externalLink{https://maven.apache.org/archetype/index.html, Maven archetype}, or template.
// <p>
// Having run both of those commands, your newly created project will contain a
// +externalLink{https://maven.apache.org/guides/introduction/introduction-to-the-pom.html, pom.xml file}, which details
// among other things the libraries, or dependencies, needed to compile, package, and run the app.  In this case, you'll
// find a reference to the version of Smart GWT you used to create the project.  To upgrade, you'll just change the
// value of the ${smartgwt.version} property to reflect another build number that you've installed or deployed using
// the process outlined above and rebuild.  To add another JAR to your project, you just add the dependency to your POM.
// To add one of the Smart GWT +link{loadingOptionalModules, optional modules}, for example, you'd first use the plugin
// to install / deploy it to your own repository and then add the appropriate block to your POM's dependencies section.
// <p>
// Your project will also contain a README file containing a copy/paste command line for installing, deploying to and
// starting a local 'embedded' +externalLink{https://www.eclipse.org/jetty/, Jetty} server, as well as detailed
// instructions for +externalLink{https://help.eclipse.org/latest/index.jsp, Eclipse} integration, and even automated
// conversion to an +externalLink{https://ant.apache.org, Ant} based build (complete with Ivy configuration).
// Isomorphic generally recommends starting with the Jetty command to see things working quickly before experimentation
// with other approaches.  The plugin provides an
// +externalLink{http://github.smartclient.com/isc-maven-plugin/faq.html, FAQ} for reference, and posting
// questions / issues to the public +externalLink{https://forums.smartclient.com, forum}
// for help is always appropriate.
// @title Smart GWT Pro/EE Project Setup
// @visibility sgwt
//<

//> @groupDef sgwtEEManualSetup
// Isomorphic recommends starting most new projects from one of the provided templates, and in any case using some form of
// dependency management as covered in documentation for the +link{sgwtEESetup, standard setup}.  For those unable or
// unwilling to do so, however, this overview serves as a how-to for adding Smart GWT to your project manually.
//
// <h3>Creating a new project from scratch</h3>
// If you are starting a new project from scratch, we recommend starting with one of the sample
// projects included with SmartGWT EE under the "samples" directory.  Use the project that most
// closely matches your integration strategy and follow the instructions in the "readme" file
// within the sample directory.  If you have a choice, most projects will benefit from the use
// of SQLDataSources, illustrated in the BuiltInDS sample.
//
// <h3>Adding SmartGWT EE to an existing project</h3>
// <B>Important:</b> If you have created a project using the GWT Plugin for Eclipse, a Maven archetype, or
// similar tool, first get rid of unused resources typically included in such "starter projects":
// <ul>
//   <li> from your [i]moduleName[/i].gwt.xml file, remove imports of any GWT themes, leaving
//        only the import of com.google.gwt.user.User.  Proper imports to add for SmartGWT
//        Pro/EE are shown below.
//   <li> get rid of any sample servlets or GWT-RPC services (delete both web.xml entries and
//        server-side source)
// </ul>
// <P>
// Now add SmartGWT EE: all of these steps are required.  <b>Do not skip steps or omit
// resources you think you may not need</b>.  Get a working project first, then think about
// trimming resources, as needed, once you understand the system.
// <P>
// In the steps below, copying from eg "war/WEB-INF/..." means copying from the "war"
// subdirectory of whichever sample project is closest to your desired integration strategy.
// <P>
// <ol>
// <li>Unless you're <a href="http://github.smartclient.com/isc-maven-plugin/">using Maven</a>
//     to manage dependencies, you'll need to add all jars from the SmartGWT Pro/EE
//     distribution (under smartgwtee-<i>version</i>/lib)
//     to your CLASSPATH.  You can copy the '.classpath' file from the appropriate sample
//     project for a working set of includes (it's in the same directory as the <i>war/</i>
//     folder). There are both client- and server-side jars, both kinds go in the classpath.
//     For server-side .jars, dependencies are documented +link{group:javaModuleDependencies,here}.
// <li>update your <i>modulename</i>.gwt.xml file with these imports:
//    <pre>
//    &lt;inherits name="com.smartgwtee.SmartGwtEE"/&gt;
//    &lt;inherits name="com.smartgwtee.tools.Tools"/&gt;
//    </pre>
//    <b>NOTE:</b> if you were previously using SmartGWT LGPL, <b>remove</b> the
//    &lt;inherit&gt; of 'com.smartgwt.SmartGWT' and ensure the &lt;inherit&gt; of
//    'com.smartgwt.tools.SmartGwtTools' appears <b>before</b> the imports above.  Also ensure
//    that all SmartGWT-related inherits appear *before* your &lt;entry-point&gt; declaration.
// <li> if you are using Optional Modules such as AI, Analytics or RealtimeMessaging, see
//      +link{group:loadingOptionalModules} for additional inherits
// <li> Copy log4j.isc.config.xml across to the "src" dir of your project (it's
//      placed in the "src" dir as a means of getting it into the CLASSPATH).  This file is
//      either in the "src/" dir of a given sample project or in war/WEB-INF/classes.  This
//      enables default log4 categories for server-side logs appropriate for development.
//      See +link{group:serverLogging} for information on server-side logging and how to configure it.
// <li> Copy +link{group:server_properties,server.properties} across to the "src" dir of your project.
//      This file is either in the "src/" dir of a given sample project or in war/WEB-INF/classes.
//      This contains miscellaneous server settings - see the file itself for documentation.
//    <ul>
//       <li><b>server.properties contains server-side paths that contain the GWT module name</b>.
//           Replace the module name from the sample project (eg "builtinds") with the module
//           name of your actual GWT project
//       <li> if you're using SQLDataSource, enter your JDBC settings (start with a
//            server.properties from a project that uses a database to see the required format for
//            settings)
//    </ul>
// <li> If you plan to use JPA, copy src/META-INF/persistence.xml into your src/META-INF directory.
//      This file will be copied into war/WEB-INF/classes/META-INF directory during build process.
//      Make sure you specify your entity classes in persistence.xml. If you change persistence unit
//      name you have to update "jpa.persistenceUnitName" property in
//      +link{group:server_properties,server.properties} file. More
//      information on JPA configuration can be found in +link{group:jpaIntegration}.
// <li> merge web.xml, starting with the web.xml from the sample project that is closest to
//      your target application (under war/WEB-INF in the sample project).  The list of
//      servlets and what they do is documented +link{group:servletDetails,here}.  See the
//      server-side JavaDoc for further details on servlet APIs and override points.
// <li> (SmartGWT Power or Enterprise only) If using the BatchUpload functionality, copy
//      war/ds/batchUpload.ds.xml from the Showcase sample project to the shared.datasources
//      directory you configured in +link{group:server_properties,server.properties}.
// </ol>
//
// <h4>Extra Step Required for GWT 2.8+</h4>
// If you're using GWT 2.8 or later, attempting to run SuperDevMode in Eclipse may lead to an
// exception being reported such as:<p><pre>
//     org.apache.xerces.parsers.XIncludeAwareParserConfiguration cannot be cast to
//         org.apache.xerces.xni.parser.XMLParserConfiguration</code></pre><p>
// This is due to xerces classes being included in GWT 2.8+, in addition to being in the JRE.
// To solve, add the following extra VM arguments to either your launch configuration or JRE in
// Eclipse:
// <p><pre>
//     -Djavax.xml.parsers.SAXParserFactory=com.sun.org.apache.xerces.internal.jaxp.SAXParserFactoryImpl
//     -Djavax.xml.parsers.DocumentBuilderFactory=com.sun.org.apache.xerces.internal.jaxp.DocumentBuilderFactoryImpl
// </pre><p>
// <u><b>Troubleshooting</b></u>
// <table width="90%" class="normal" align="center" border="1" cellpadding="5">
// <tr bgcolor="#808080">
//     <td width="30%"><b>Problem</b></td>
//     <td width="30%"><b>Possible Causes</b></td>
//     <td width="40%"><b>Solution</b></td>
// </tr><tr>
//  <td>ClassNotFound or other Java Exceptions in the server log.</td>
//  <td>Missing JAR files</td>
//  <td>Verify every .jar from the smartgwtee-<i>version</i>/lib directory has been added to your CLASSPATH.
//  Although you might later be able to remove some .jars, for initial installation testing,
//  copy every .jar</td>
// </tr><tr>
//     <td>Client-side error about attempting to use "iscServer" request without server installed</td>
//     <td>Wrong imports in <i>moduleName</i>.gwt.xml</td>
//     <td>See correct imports above, note <b>remove</b> com.smartgwt.SmartGWT import and be sure
//      imports are in the correct order</td>
// </tr><tr>
//     <td>Client-side error about "$debox is not defined"</td>
//     <td>Wrong order of imports in <i>moduleName</i>.gwt.xml</td>
//     <td>Make sure all SmartGWT-related imports appear before &lt;entry-point&gt; in your
//      .gwt.xml file</td>
// </tr><tr>
//     <td>Missing images or failure to load page</td>
//     <td>Didn't set isomorphicDir in .html bootstrap file</td>
//     <td>See step above for setting isomorphicDir</td>
// </tr><tr>
//     <td>Server error: "adminConsole" app not found when launching tools such as Reify</td>
//     <td>Bad filesystem paths configured in +link{group:server_properties,server.properties}</td>
//     <td>Correct paths in +link{group:server_properties,server.properties}.
//      <b>NOTE</b> the samples include the GWT module
//      name in some settings, search and replace this value with your GWT module name</td>
// </tr><tr>
//     <td>Server error: Can't find DataSource with ID <i>yourDataSourceID</i></td>
//     <td>Bad filesystem paths in +link{group:server_properties,server.properties} or
//      bad DataSource .ds.xml file</td>
//     <td>Correct paths in +link{group:server_properties,server.properties} - search for
//      "project.datasources".  Also check that
//      the DataSource ID you are using matches the "ID" attribute in the .ds.xml file (NOTE:
//      ID attribute is uppercase "ID" not "id") and that the file is named
//      <i>dataSourceId</i>.ds.xml.  DataSource IDs are <b>case sensitive</b>, including the
//      file name.  For more in-depth troubleshooting steps, see
//      +link{http://forums.smartclient.com/showthread.php?t=8159#aDSLoad,this FAQ answer}.</td>
// </tr><tr>
//     <td>Server unable to load builtinTypes.xml as it starts up, possibly hitting a
//      NullPointerException</td>
//     <td>Modules have been added to your GWT project (.gwt.xml) but you haven't run
//      another GWT compile</td>
//     <td>GWT compile your project again</td>
// </tr>
// </table>
// <P>
// For further troubleshooting steps, see
// +externalLink{http://forums.smartclient.com/showthread.php?t=8159,the SmartGWT FAQ} and, if
// still stuck, try posting in the Forums. <B>NOTE:</B> gather all the information indicated in
// the FAQ before posting.
// <p>
// <b>NOTE:</b>  It is possible to create a server-only SmartGWT EE project that will run
// standalone (ie, not inside a servlet container or application server).  Please see
// +link{groupDef:standaloneDataSourceUsage,Standalone DataSource Usage} for details.
//
// @title Manual Setup & Deployment of Smart GWT Pro/EE
// @visibility sgwt
//<

//> @groupDef server_properties
//
// The <code>server.properties</code> file is a configuration file read by the SmartClient
// server - see the file itself for more information and default or sample settings.
// <P>
// Note that this is a standard Java Properties file, except it allows variable substitution
// from other properties defined earlier in the file.
// <P>
// It's loaded from the <code>CLASSPATH</code>, so it can be anywhere in the
// <code>CLASSPATH</code>, but is typically either in the projects java "src" directory or
// in <code>WEB-INF/classes</code>.
// <P>
// Server side code can access and modify the properties specified in this file via the
// <code>com.isomorphic.base.Config</code> class.
// <P>
// When modifying <code>server.properties</code> developers should restart the servlet engine
// after changing this file to pick up changes.
// <P>
// The following settings are used by SmartClient server features.<br>
// <i>Note that this is not intended to be an exhaustive list</i>:
// <ul>
// <li><code>project.datasources</code> specifies the location for
//     +link{group:dataSourceDeclaration,server-backed DataSource configuration files <i>(*.ds.xml files)</i>}
//     as well as +link{class:SimpleType,server-backed SimpleType declarations <i>(*.type.xml files)</i>}
// </li>
// <li><code>project.ui</code> specifies the location for
//     +link{classMethod:RPCManager.loadScreen(),XML Screen definitions <i>(*.ui.xml files)</i>}</li>
// <li><code>project.project</code> specifies the location for
//     +link{classMethod:RPCManager.loadProject(),XML Project definitions <i>(*.project.xml files)</i>}</li>
// <li><code>project.apps</code> specifies the location for
//     +link{group:applicationDeclaration,Application declarations <i>(*.app.xml files)</i>}</li>
// <li><code>modulesDir</code> specifies the location for modules files if using the
//     +link{group:loadISCTag,loadISC} or +link{group:loadModulesTag,loadModules} jsp tags.</li>
// <li><code>isc.addVersionToLoadTags</code> (boolean) May be set to false to disable the
//     automatic versioning applied to URLs written out by
//     +link{group:loadISCTag,loadISC} or +link{group:loadModulesTag,loadModules} jsp tags.</li>
// <li><code>isc.defaultVersionStyle</code> specifies the default <code>versionStyle</code>
//     for +link{group:loadISCTag,loadISC} or +link{group:loadModulesTag,loadModules} jsp tags.
//     Default value is "params".</li>
// <li><code>isc.versionPathSegmentPrefix</code> Specifies a standard path segment prefix written out
//     by +link{group:loadISCTag,loadISC} or +link{group:loadModulesTag,loadModules} jsp tags
//     with <code>versionStyle</code> set to "pathSegment". The generated path segment will
//     consist of this prefix combined with the current SmartClient version.
//     The default value is <code>"isc_version."</code>.</li>
// <li><code>isc.stripVersionPathSegments</code> (boolean) When set to true, any URL containing
//     a path segment that starts with the <code>isc.pathSegmentPrefix</code> will be automatically
//     stripped by the SmartClient FileDownloadServlet, or the dedicated VersionedURLFilter
//     when resolving the URL to a resource on the filesystem.<br>
//     This may be disabled if you want to use a different strategy such as using Apache mod_rewrite on a
//     dedicated web server to resolve URLs including versioned path segments.</li>
// <li><code>authentication.defaultRequired</code> can be used to require
//     +link{attr:DataSource.requiresAuthentication,authentication} for all dataSources by default</li>
// <li><code>authentication.superuserRole</code> can be used to identify a
//     +link{attr:operationBinding.requiresRole,user role} as the super user role.</li>
// <li>This file can contain +link{group:dbConfigTool,DataBase configuration settings for SQL DataSources}.
//     Note that the +link{group:adminConsole,Admin Console tool} provides an interface
//     for adding database configuration blocks to server.properties without the need to
//     edit the file by hand.</li>
// <li>This file can contain +link{group:sqlConnectionPooling,SQL Connection pooling} settings
//     for SQL DataSources.</li>
// <li>This file can contain various configuration properties used for +link{group:jpaIntegration}</li>
// <li>This file can contain SMTP configuration settings for the
//     +link{class:Mail,OperationBinding.mail} feature.</li>
// <li>This file can contain configuration settings for the
//     +link{group:messaging, optional RealTimeMessaging module}.</li>
// <li><code>enabledBuiltins</code> can be used to configure access to methods provided
//     by the server side <code>BuiltInRPC</code> class. (See server side JavaDoc for that
//     class as well as the +link{group:toolsDeployment,tools deployment overview} for more
//     information).</li>
// <li><code>domainSync.disabled</code> and <code>domainSync.baseDomains</code> can be used to
//     +link{group:xssAndCSRFSecurity,configure domain synching behavior}.</li>
// <li><code>import.consume.bom</code> can be set to false to switch off automatic consumption
//     of Byte Order Markers when importing UTF data (see the server Javadocs for the DataImport
//     class for more details)</li>
// <li><code>datasources.autoConvertRelativeDates</code> can be used to change when relative dates
//     are converted or to entirely disable the automatic conversion
//     (see +link{DataSource.autoConvertRelativeDates} for more details)</li>
// <li><code>sql.log.formatQueries</code> can be set to <code>true</code> to enable the SQL queries formatting
// in +link{serverLogging,server logs} under <code>com.isomorphic.sql.SQLDriver</code> category</li>
// <li><code>sql.log.compactFormatting</code> can be set to <code>true</code> to make formatted SQL queries more compact</li>
// <li><code>sql.log.maxLength</code> can be set to an integer controlling the maximum length of formatted SQL queries</li>
// <li><code>sql.log.queriesSlowerThan</code> can be set to an integer controlling SQL query execution time threshold in
// milliseconds (defaults to 10000), which if exceeded query is identified as "slow" and may be logged under specific logging
// category. See +link{dataSource.logSlowSQL} for more details.</li>
// <li><code>reflection.classCache</code> specifies how (if enabled) Smartclient Reflection library caches loaded classes,
//     availables values are "global", "classloader" (default), "jdk" and "off". See comment in server.properties for more
//     details.</li>
// <li><code>sql_comment_mdc_key</code> if specified is used as a logging MDC key to get the configurable "log_correlation_id"
//     third party tools, like Dynatrace, Graylog etc., use for the context. Smartclient picks that from the logging MDC and
//     adds as a comment to the end of generated SQL queries, so those can be connected to the context.</li>
// </ul>
//
// @visibility external
// @title <code>server.properties</code> file
// @treeLocation Concepts/Deploying SmartClient
//<

//> @groupDef servletDetails
//
// The following is a description of the servlets and filters you'll find in the web.xml file
// contained in the smartclientRuntime and what they do:
// <p>
// <i>Core Functionality</i>
// <ul>
// <li>Init servlet - see the article on +link{group:serverInit,SmartClient Server Initialization}</li>
// <li>IDACall servlet - <b>required</b> for +link{group:dmiOverview,DMI}, built-in RPC operations and built-in DataSource
// operations to work.  All databound examples in the SDK use this servlet.  If you're planning on
// using a custom actionURL for all your RPC requests, then you don't need this servlet.
// <li>FileDownload servlet - required for serving the Isomorphic framework code compressed and with
// caching headers as well as for serving skin images with caching headers.  It is highly
// recommended that you use this for production but is not required.
// <li>PreCache servlet - loads resources into memory on container startup.  Not required, but if you
// exclude this servlet there may be a slow response to the very first request.
// </ul>
// <p>
// <i>Optional Functionality</i>
// <ul>
// <li>RESTHandler servlet - handles SmartClient Server DataSource operations issued by
// REST clients: it's like IDACall, but for the REST protocol.  Typically,  the clients
// of this servlet would not be ordinary SmartClient/SmartGWT applications (though they
// could be), but other client technologies that need to access SmartClient DataSource
// operations as reusable services.  If you do not plan to connect to the server using the
// REST protocol, then you don't need this servlet.
// <li>AxisServlet - exposes all DataSource operations via a WSDL service described by
// SmartClientOperations.wsdl.  This is effectively the same as the RESTHandler servlet, but
// for SOAP clients.  If you do not plan to connect to the server using webservice protocols,
// then you don't need this servlet.
// <li>HttpProxy - used by the RPCManager when sending AJAX RPCs to a server other than the
// server that serves the main application page.  You need to install this servlet if, for
// example, your application will be querying web services exposed by servers other than the
// server that is serving the rest of the application.  See the javadoc for this servlet for
// various configuration options, such as how to restrict the URLs that are allowed to be
// proxied.
// <li>MessagingServlet - used by the realtime messaging system.  If you're planning
// on using this subsystem, you'll need this servlet.
// <li>CompressionFilter - required if you want to use dynamic compression of html and js
// files.
// <li>JSSyntaxScannerFilter - development tool that looks for trailing commas in JS
// source (scans html files for &lt;script&gt; tags and scans .js files in their entirety).
// This is a useful development tool, but should not be included in production.
// <li>NoCacheFilter - development tool that makes any content it intercepts non-cacheable in
// order to ensure developers are looking at the latest version of a file when modifying
// examples.  Not for production use.
// <li>DataSourceLoader - a servlet that returns the definition of one or more DataSources in
// JavaScript notation.  This servlet is provided as an alternative to using the
// <code>&lt;isomorphic:loadDS&gt;</code> JSP tag, and is particularly suitable in environments
// where JSP tags can't be used for some reason (such as with SmartGWT).  See
// +link{group:dataSourceDeclaration,Creating DataSources} for more details.
// <li>ScreenLoaderServlet - a servlet that returns the definition of one or more screens in
// JavaScript notation.
// Can be invoked using a traditional HTTP GET, the +link{group:loadUITag,loadUI JSP tag},
// or the +link{rpcManager.loadScreen} function.</li>
// <li>ProjectLoaderServlet - returns a JavaScript fragment that when executed loads a named project
// and +link{rpcManager.cacheScreens,caches} all (or a specified subset) of its screens up-front.
// Can be invoked using a traditional HTTP GET, or the +link{rpcManager.loadProject} function.
// Refer to +serverDocLink{com.isomorphic.servlet.ProjectLoaderServlet,javadoc}  for parameter names
// and their meanings.
// </li>
// </ul>
// Note that not all of the servlets and filters listed under <i>Optional Functionality</i>
// above are present in the web.xml that ships with the smartclientRuntime - if you need to use
// any of these, copy their configuration from the web.xml available under the WEB-INF
// directory of smartclientSDK.  Other servlets, filters and configuration files from the
// smartclientSDK should not be copied to your deployment, simply because the SDK includes many
// developer tools that are not extensively audited from a security standpoint.
//
// @treeLocation Concepts/Deploying SmartClient
// @title The Core and Optional SmartClient servlets
// @visibility external
//<


//> @groupDef serverInit
//
// The SmartClient Server framework must be initialized from its config files at startup
// time, before user code invokes <em>any</em> framework functionality.  If you are running
// standalone (ie, outside of a servlet container), you should call the static utility method
// <code>ISCInit.go()</code> early in your bootstrap code (eg, from the top of your
// <code>main()</code> method).
// <p>
// If you are running inside a servlet engine, install the following listener in your web.xml.
// Ideally this should be the first listener registered in web.xml because part of the init
// logic exports database connections configured via server.properties via JNDI for consumption
// by other frameworks (Spring, Hibernate, etc).  See also below for other rationale related to
// Spring.
// <ul>
// <li>Install <code>InitListener</code>, which is a <code>ServletContextListener</code>:<br>
// <pre>   &lt;listener&gt;
//        &lt;listener-class&gt;com.isomorphic.base.InitListener&lt;/listener-class&gt;
//    &lt;/listener&gt;</pre></li>
// </ul>
//
// <h4>Interaction with Spring initialization</h4>
// The Spring framework attempts to initialize itself in similar ways to the SmartClient
// framework, and similarly it wants its own initialization to be the very first thing that
// happens.  This can cause problems in certain cases.  For example, one known problem occurs
// when you define DataSource instances as Spring beans, and Spring gets to initialize itself
// first: it attempts to instantiate a instance of the bean, which ultimately calls into
// our framework code before the framework has been initialized.
// <p>
// The solution to this is to use the <code>InitListener</code>, and to ensure that it is
// declared in your <code>web.xml</code> file before the Spring
// <code>ContextLoaderListener</code>.  The Servlet 2.3 spec states (SRV.10.3.3):<p>
// <em>&nbsp;&nbsp;"During Web application execution, listeners are invoked in the order of their
// registration."</em>
// <p>
// Therefore, declaring the SmartClient listener before the Spring one ensures that
// things run in the correct order in Servlet 2.4-compatible containers, and in those Servlet
// 2.3 containers that enforce the rule of running listeners before initializing filters or
// servlets.
//
// @treeLocation Concepts/Deploying SmartClient
// @title Server Framework Initialization
// @visibility external
//<





//> @groupDef reifyMaven
// <smartclient>SmartClient</smartclient><smartgwt>SmartGWT</smartgwt>
// +link{group:mavenSupport, support for Maven} includes the ability to
// +externalLink{http://github.smartclient.com/isc-maven-plugin/reify-import-mojo.html, import}
// (and optionally,
// +externalLink{http://github.smartclient.com/isc-maven-plugin/reify-validate-mojo.html, verify}
// ) assets from +externalLink{http://reify.com, reify.com} into your project either on-demand
// or during your build process.  Using the
// +externalLink{http://github.smartclient.com/isc-maven-plugin/examples/configuration.html, example configuration},
// the import command might look something like the following:
// <p>
// <pre>
//   mvn com.isomorphic:isc-maven-plugin:1.4.5:reify-import -Pisc
// </pre>
// <strong>Important:</strong> This flow is unidirectional.  That is, whatever changes are to
// be made to these resources should be made using the collaborative Reify environment and then
// re-imported.  There is, by design, no reason to modify them locally, and the plugin takes
// steps to notify you when that happens.
// Refer to the +link{group:reifyForDevelopers, Reify for Developers} documentation topic for
// further discussion.
//
// @treeLocation Concepts
// @title Importing from Reify
// @visibility external
//<

//> @groupDef mavenSupport
// <smartclient>SmartClient</smartclient><smartgwt>SmartGWT</smartgwt> artifacts are not
// published to any public repository, but a POM for each is included in the SDK, and can be
// used to install them to your own private Maven repository.  The official
// +externalLink{http://github.smartclient.com/isc-maven-plugin/,Isomorphic plugin for Maven}
// contains a handful of targets intended to simplify that process through automation.  Please
// refer to the plugin's documentation for usage and examples.
// <p />
// For a complete listing of artifacts installed in your environment, consult your repository
// manager.  Where no repository manager is in use, a directory listing of your local
// repository can often provide all the detail you need.  Once you've made an artifact
// available to your build, you can use it just like you'd use any other dependency.
// <smartclient>
// <p />
// That said, typical installations of the current build will include the artifacts documented
// <a target="_blank" href="./mavendoc/maven-usage.html">here</a>, where coordinates in most
// cases will vary slightly by date and license.  A sample configuration using a few artifacts
// from an eval build released on November 14, 2016 follows:
// <p/>
//
// <pre>
// &lt;?xml version="1.0" encoding="UTF-8"?&gt;
// &lt;project  xmlns="http://maven.apache.org/POM/4.0.0"
//              xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance"
//              xsi:schemaLocation="http://maven.apache.org/POM/4.0.0 http://maven.apache.org/maven-v4_0_0.xsd"&gt;
//
//      &lt;modelVersion&gt;4.0.0&lt;/modelVersion&gt;
//
//      &lt;groupId&gt;com.isomorphic.smartclient.samples&lt;/groupId&gt;
//      &lt;artifactId&gt;component-databinding&lt;/artifactId&gt;
//      &lt;version&gt;1.0.0&lt;/version&gt;
//      &lt;packaging&gt;war&lt;/packaging&gt;
//
//      &lt;dependencies&gt;
//
//          &lt;!-- The SmartClient Evaluation edition --&gt;
//          &lt;dependency&gt;
//              &lt;groupId&gt;com.isomorphic.smartclient.eval&lt;/groupId&gt;
//              &lt;artifactId&gt;smartclient-eval&lt;/artifactId&gt;
//              &lt;version&gt;11.0-p20161114&lt;/version&gt;
//              &lt;type&gt;pom&lt;/type&gt;
//          &lt;/dependency&gt;
//
//          &lt;!-- Use SQLDataSources --&gt;
//          &lt;dependency&gt;
//              &lt;groupId&gt;com.isomorphic.smartclient.eval&lt;/groupId&gt;
//              &lt;artifactId&gt;isomorphic-sql&lt;/artifactId&gt;
//              &lt;version&gt;11.0-p20161114&lt;/version&gt;
//          &lt;/dependency&gt;
//
//      &lt;/dependencies&gt;
// &lt;/project&gt;
// </pre></smartclient>
//
// <smartgwt>
// <p/>
// You can of course declare these dependencies in your existing project as you would any other.
// Should you be working with a single-module project (as opposed to the
// +externalLink{https://maven.apache.org/guides/mini/guide-multiple-modules.html, multi-module}
// format recommended by authors of both
// +externalLink{https://tbroyer.github.io/gwt-maven-plugin/, GWT} and
// +externalLink{http://gwt-plugins.github.io/documentation/gwt-eclipse-plugin/maven/Maven.html, Eclipse}
// plugins), you may find that you need to take steps to remove server-side dependencies from your
// client-side classpath.  The older releases of the asm library, included transitively
// with isomorphic-tools by way of Hibernate, has been known to cause problems for developers
// working in single module projects, for example.  This really is unrelated to SmartGWT itself,
// so you can work around it using standard classpath manipulation techniques.  In the case of
// asm, this can be as simple as an exclusion on the tools dependency:
// <pre>
// &lt;dependency&gt;
//     &lt;groupId&gt;com.isomorphic.smartgwt.eval&lt;/groupId&gt;
//     &lt;artifactId&gt;isomorphic-tools&lt;/artifactId&gt;
//     &lt;version&gt;${smartgwt.version}&lt;/version&gt;
//     &lt;exclusions&gt;
//         &lt;exclusion&gt;
//             &lt;groupId&gt;asm&lt;/groupId&gt;
//             &lt;artifactId&gt;asm&lt;/artifactId&gt;
//         &lt;/exclusion&gt;
//     &lt;/exclusions&gt;
// &lt;/dependency&gt;
// </pre>
// <p/>
// Most users should at least consider converting existing projects to a multi-module format,
// and use one of the SmartGWT archetypes for new projects.  These archetypes are available
// following execution of the plugin's install or deploy goals.  To create a new project
// based on the smartgwt-quickstart archetype:
// <ol>
// <li><a href="https://maven.apache.org/install.html">Install Maven</a>, if necessary.</li>
//
// <li>Install SmartGWT, if necessary. <i>Note that when copy/pasting commands,
// you may need to substitute the backslash with the appropriate character to
// escape new lines in your command-line interface
// (eg: <code>^</code> for Windows command-line, <code>`</code>
//  for PowerShell, etc).</i>
// <pre>
// mvn com.isomorphic:isc-maven-plugin:1.4.5:install \
//    -Dproduct=SMARTGWT -Dlicense=EVAL -DbuildNumber=14.1p
// </pre>
// </li>
// <li>
// Generate a project (using LATEST as below, or the version installed for you in step 2).
// For example, If you used build number 13.0p in step 2, the version here should have the form
// 13.0-p&lt;date&gt;, where &lt;date&gt; is an eight digit date in the form of YYYYMMDD (e.g.
// 13.0-p20220525).
// <pre>
//  mvn archetype:generate \
//    -DartifactId=my-application \
//    -Dmodule=MyApplication -Dmodule-short-name=myapp \
//    -DgroupId=com.example -Dpackage=com.example.myapplication \
//    -DarchetypeGroupId=com.isomorphic.archetype \
//    -DarchetypeArtifactId=archetype-smartgwt-quickstart \
//    -DarchetypeVersion=LATEST -DinteractiveMode=false
// </pre>
// </li>
// </ol>
//
// and refer to the README in the new 'my-application' directory for further instructions
// around usage in Maven, Ant, and Eclipse environments.
// <p/>
// To generate a project from any of the following archetypes, provide its artifactId to the
// above command's archetypeArtifactId parameter:
// <p/>
// <ul>
//   <li><b>archetype-smartgwt-quickstart</b>:
//       The recommended approach for most applications, using data access / databinding with
//       "sql" datasources
//   </li>
//   <li><b>archetype-smartgwt-quickstart-relogin</b>:
//       Like archetype-smartgwt-quickstart, but includes integration with Spring
//       Security to illustrate the +link{group:relogin,relogin} pattern.
//   </li>
//   <p/>
//   <li><b>archetype-smartgwt-example-builtinds</b>:
//       Illustrates how a single databound component can be used (and re-used) with many
//       datasources
//   </li>
//   <li><b>archetype-smartgwt-example-customds</b>:
//       Illustrates setting up a DataSource accessing a servlet front controller (for example
//       Spring MVC controller) for the various DataSource operations
//   </li>
//   <li><b>archetype-smartgwt-example-dsdmi</b>:
//       llustrates setting up a DataSource that calls methods on your configured server bean
//       in response to DataSource operations (fetch, add, update, remove)
//   </li>
//   <li><b>archetype-smartgwt-example-dshibernate</b>:
//       llustrates the use of "hibernate" datasources in 'beanless mode'
//   </li>
//   <li><b>archetype-smartgwt-example-dshibernatederived</b>:
//       This example illustrates the use of "hibernate" datasources with 'autoDeriveSchema'
//       to inherit fields from a Hibernate mapping or bean
//   </li>
//   <li><b>archetype-smartgwt-example-dsjpa</b>:
//       llustrates the use of JPA DataSources
//   </li>
//   <li><b>archetype-smartgwt-example-gae</b>:
//       llustrates an approach to running a SmartGWT application on the Google App Engine
//       standard environment using SQL DataSources
//   </li>
//   <li><b>archetype-smartgwt-example-gaedatastore</b>:
//       llustrates an approach to running a SmartGWT application on the Google App Engine
//       standard environment using Google Cloud Datastore as a _limited_ JPA DataSource
//   </li>
//   <li><b>archetype-smartgwt-example-gaejpa</b>:
//       llustrates an approach to running a SmartGWT application on the Google App Engine
//       standard environment using JPA DataSources
//   </li>
//   <li><b>archetype-smartgwt-example-manualhibernate</b>:
//       llustrates setting up a DataSource that accesses your servlet controller, using
//       Hibernate to process the requests manually via a Spring MVC Controller class
//       (not recommended)
//   </li>
//   <li><b>archetype-smartgwt-example-restserver</b>:
//       llustrates use of the SmartClient +link{group:servletDetails,RESTHandler servlet} to
//       easily provide data access to clients other than SmartClient / SmartGWT (mobile,
//       Swing, native, etc).
//   </li>
//   <li><b>archetype-smartgwt-example-spring-hibernate3-dmi</b>:
//       llustrates a DataSource accessing a Spring bean using Direct Method Invocation (DMI),
//       which then services the request manually via Hibernate.
//   </li>
// </ul>
//
// </smartgwt>
// <smartclient>
// <p/>
// Following execution of the plugin's install or deploy goal, its
// +externalLink{http://github.smartclient.com/isc-maven-plugin/install-mojo.html#workdir, working directory}
// will contain a copy of the SDK that you can use to view doc and samples locally.
// Your Maven repository will also
// include a handful of archetypes meant to jump start development with the SmartClient
// framework.  Most users will want to start new projects with either the
// <b>archetype-smartclient-quickstart</b> or
// <b>archetype-smartclient-quickstart-relogin</b> archetypes.  To generate a new project
// based on the former:
//
// <ol>
// <li><a href="https://maven.apache.org/install.html">Install Maven</a>, if necessary.</li>
//
// <li>Install SmartClient, if necessary. <i>Note that when copy/pasting commands,
// you may need to substitute the backslash with the appropriate character to
// escape new lines in your command-line interface
// (eg: <code>^</code> for Windows command-line, <code>`</code>
//  for PowerShell, etc).</i>
// <pre>
// mvn com.isomorphic:isc-maven-plugin:1.4.5:install \
//    -Dproduct=SMARTCLIENT -Dlicense=EVAL -DbuildNumber=14.1p
// </pre>
// </li>
//
// <li>
// Generate a project (using LATEST as below, or the version installed for you in step 2).
// For example, If you used build number 13.0p in step 2, the version here should have the form
// 13.0-p&lt;date&gt;, where &lt;date&gt; is an eight digit date in the form of YYYYMMDD (e.g.
// 13.0-p20220525).
// <pre>
//  mvn archetype:generate \
//    -DartifactId=my-application \
//    -Dmodule=MyApplication -Dmodule-short-name=myapp \
//    -DgroupId=com.example -Dpackage=com.example.myapplication \
//    -DarchetypeGroupId=com.isomorphic.archetype \
//    -DarchetypeArtifactId=archetype-smartclient-quickstart \
//    -DarchetypeVersion=LATEST -DinteractiveMode=false
// </pre>
// </li>
// </ol>
//
// and refer to the README in the new 'my-application' directory for further instructions
// around usage in Maven, Ant, and Eclipse environments.
// <p/>
// To generate a project from any of the following archetypes, provide its artifactId to the
// above command's archetypeArtifactId parameter:
// <p/>
// <ul>
//   <li><b>archetype-smartclient-quickstart</b>:
//       The recommended approach for most applications, using data access / databinding with
//       "sql" datasources
//   </li>
//   <li><b>archetype-smartclient-quickstart-relogin</b>:
//       Like archetype-smartclient-quickstart, but includes integration with
//       Spring Security to illustrate the +link{group:relogin,relogin} pattern.
//   </li>
// </ul>
//
// </smartclient>
//
// @treeLocation Concepts/Deploying SmartClient
// @title Maven Support
// @visibility external
//<

//> @groupDef javaModuleDependencies
// Note that if you are using GWT, GWT itself also has an Apache 2.0 license, however tools and
// test environments that you may use during development have different license (such as
// Eclipse - Eclipse Public License).  Also, specific GWT widgets, not required by Smart GWT,
// have licenses different from core GWT (such as JFreeChart's LGPL license).  See
// +externalLink{http://code.google.com/webtoolkit/terms.html,Google's summary of terms} for
// details.
// <p>
// If you are using +link{group:serverScript,server scripting} with the Javascript language,
// dependencies are JVM-specific.  Java versions earlier than 6 do not include JSR223 support
// at all, so server scripting is not an option with those JVMs.  Versions of the Oracle and
// OpenJDK JVMs from 6 to 14 inclusive include a JS engine by default - Rhino in Java 6 and 7,
// and Nashorn from 8 to 14 - so Javascript server scripting works out of the box with no
// dependencies with those versions.  Oracle and OpenJDK JVMs from version 15 onwards do not
// include JS support automatically.  However, we ship the standalone OpenJDK implementation
// of Nashorn with SmartClient, so Javascript scripting still works out of the box as long as
// you leave that dependency in place.  You can also leave that dependency in place with JDK
// versions from 8 to 14 - the OpenJDK implementation will mask the built-in Oracle
// implementation, but you should not notice any difference.  See the Server Scripting
// documentation for more details of your options with this.
// <p>
// +link{group:mavenSupport,Maven} users should generally refer to the POMs bundled with the
// SDK, and installed for them by the official
// +externalLink{http://github.smartclient.com/isc-maven-plugin/,Isomorphic plugin for Maven}.
// For others,  the following is a short description of the functionality contained in each
// SmartClient server JAR, and a link to the documentation listing its dependencies.  Please
// refer to that documentation for more detail on the dependency graph, including version
// numbers, transitive dependencies, and licensing.
// <P>
// <style>
//   .jmd-module  {
//     width: 140px;
//     text-align: right;
//     vertical-align: top;
//     padding-right: 10px;
//   }
//   .jmd-optional  {
//     text-decoration: underline;
//     margin-top: 10px; margin-bottom: 8px;
//   }
// </style>
//
// <table width="100%" >
//   <tr>
//     <td class="jmd-module">
//       <a target="_blank" href="./mavendoc/isomorphic-core-rpc.html">isomorphic_core_rpc</a>
//     </td>
//     <td>
//       This is the core SmartClient module.  It provides the RPC, DMI, and DataSource
//       support. Please note that both commons-collections-3.x and commons-collections4-4.x
//       are required and safe to include side by side in the CLASSPATH (different third party
//       libs rely on one or the other).  The same is true of commons-lang and commons-lang3.
//       <div class="jmd-optional">
//         Optional Dependencies
//       </div>
//       <ul>
//         <li><i>freemarker</i>
//              - if you're using the built-in support for REST via the
//                +link{group:servletDetails,RESTHandler servlet} servlet
//         <li><i>isomorphic_js_parser</i>
//              - if you're using the built-in support for REST via the
//                +link{group:servletDetails,RESTHandler servlet} servlet with JSON payloads
//         <li><i>xercesImpl</i>
//              - if you're using JDK &lt; 1.5
//         <li><i>javax.mail</i>
//              - if you plan to use the Mail messaging feature
//         <li><i>javax.persistence</i>
//              - if you plan to use the metadata-from-annotations feature.  Note that if you
//                are using JPA, or a recent version of Hibernate, then you are probably
//                already using this library.
//         <li><i>poi and commons-math</i>
//              - if you plan to export datasets in Microsoft Excel 97 (xls) or 2007 (xlsx)
//                formats.
//         <li><i>poi-ooxml, poi-ooxml-schemas, and commons-compress</i>
//              - also needed if you plan to export data in Excel 2007 (xlsx) format
//         <li><i>isomorphic_contentexport</i>
//              - if you plan to export to PDF format
//         <li><i>isomorphic_jpa</i>
//              - if you plan to use BatchDS Generator (even if you are not using JPA,
//                although the generated DataSources will not require JPA at runtime if you
//                are not using JPA).
//         <li><i>log4j</i>
//              - if you plan to use log4j logging (used by default)
//         <li><i>slf4j-log4j12</i>
//              - if you plan to use slf4j with log4j (for example), or any other slf4j bridge
//                library depending on which logging framework will be used.  See
//                +link{group:serverLogging} for information on server-side logging and how to
//                configure it.
//         <li><i>groovy</i>
//              - if you plan to use Groovy with the +link{group:serverScript} feature.
//                Note, we also recommend that you use Groovy as the evaluation engine if you
//                intend to use Java as an inline scripting language.
//                See the "Server Scripting" documentation.
//         <li><i>commons-digester3 and commons-beanutils</i>
//              - if you plan to use Velocity Tools.
//         <li><i>nashorn-core and asm-util</i>
//              - if you are using server scripting with the Javascript language, and you want
//                out of the box support with JDK versions from 15 onwards, as described in
//                the paragraph above
//        </ul>
//      </td>
//   </tr>
//   <tr>
//     <td class="jmd-module"><a target="_blank"
//         href="./mavendoc/isomorphic-contentexport.html">isomorphic_contentexport</a>
//     </td>
//     <td>
//       Provides support for PDF Export.
//       <div class="jmd-optional">
//       Optional Dependencies
//       </div>
//       <ul>
//       <li><i>batik-anim, batik-awt-util, batik-bridge, batik-css, batik-dom, batik-ext,
//              batik-gvt, batik-parser, batik-script, batik-svg-dom, batik-util, batik-xml
//           </i> -
//           <p/>
//           These are all required to use +link{RPCManager.exportImage()}, or when using
//           +link{RPCManager.exportContent()} to export a DrawPane or FacetChart only
//           in IE8 or earlier, or if a DrawPane has a DrawImage which loads a cross-domain
//           image.
//           <p/>
//           <b>NOTE:</b>
//           Between iText 2.0.x and iText 2.1.x there is a binary (but not source)
//           incompatibility that causes a server-side <code>NoSuchMethodError</code>
//           when exporting, e.g., charts in Internet Explorer. This is a
//       +externalLink{http://code.google.com/p/flying-saucer/issues/detail?id=126,known issue}
//           with the Flying Saucer product that is fixed by using
//           core-renderer-R8-isomorphic.jar and iText-2.1.7.jar in the lib-iTextAlternate/
//           directory instead of core-renderer.jar and iText-2.0.8.jar in the lib/ directory.
//           To use iText 2.1.7 with the Server Framework, exclude lib/core-renderer.jar and
//           lib/iText-2.0.x.jar from the application's classpath and instead add
//           lib-iTextAlternate/core-renderer-R8-isomorphic.jar and
//           lib-iTextAlternate/iText-2.1.7.jar.
//       </ul>
//     </td>
// </tr>
// <tr>
//   <td class="jmd-module">
//      <a target="_blank" href="./mavendoc/isomorphic-tools.html">isomorphic_tools</a>
//   </td>
//   <td>
//     Contains back-end logic for the "Admin Console" tool visible in the Developer Console,
//     and also standalone from the SDK home page.  Also contains the various data importers
//     and exporters, and the server-side components of the BatchUploader.
//   </td>
// </tr>
// <tr>
//   <td class="jmd-module">
//     <a target="_blank" href="./mavendoc/isomorphic-cdi.html">isomorphic_cdi</a>
//   </td>
//   <td>
//     Support for +link{group:dmiOverview,DMI} dispatches to Spring beans
//     (via +link{serverObject.lookupStyle} : "cdi").
//   </td>
// </tr>
// <tr>
//   <td class="jmd-module">
//     <a target="_blank" href="./mavendoc/isomorphic-spring.html">isomorphic_spring</a>
//   </td>
//   <td>
//     Support for +link{group:dmiOverview,DMI} dispatches to Spring beans
//     (via +link{serverObject.lookupStyle} : "spring").
//   </td>
// </tr>
// <tr>
//   <td class="jmd-module">
//     <a target="_blank" href="./mavendoc/isomorphic-spring.html">isomorphic_spring_hibernate3</a>
//   </td>
//   <td>
//     Support for Spring + Hibernate 3, see the Compatibility section of +link{group:springIntegration} for more details.
//   </td>
// </tr>
// <tr>
//   <td class="jmd-module"><a target="_blank" href="./mavendoc/isomorphic-messaging.html">
//     isomorphic_realtime_messaging</a>
//   </td>
//   <td>
//     Server support required for the SmartClient Realtime Messaging Module.  Install this
//     if you're using this 'push' technology.  For more information, see
//     +link{group:messaging,Messaging}.
//   </td>
// </tr>
// <tr>
//   <td class="jmd-module">
//     <a target="_blank" href="./mavendoc/isomorphic-hibernate.html">isomorphic_hibernate</a>
//   </td>
//   <td>
//     Contains support for Hibernate DataSources as described here:
//     +link{group:hibernateIntegration}.
//   </td>
// </tr>
// <tr>
//   <td class="jmd-module">
//     <a target="_blank" href="./mavendoc/isomorphic-jpa.html">isomorphic_jpa</a>
//   </td>
//   <td>
//     Contains support for JPA DataSources as described +link{group:jpaIntegration,here}
//   </td>
// </tr>
// <tr>
//   <td class="jmd-module">
//     <a target="_blank" href="./mavendoc/isomorphic-sql.html">isomorphic_sql</a></td>
//   <td>
//     The SmartClient SQLDataSource.
//   </td>
// </tr>
// <tr>
//   <td class="jmd-module">
//     <a target="_blank" href="./mavendoc/isomorphic-autotest.html">isomorphic_autotest</a>
//   </td>
//   <td>
//     Support for +link{group:automatedTesting,automated testing and Continuous Integration}
//     <div class="jmd-optional">
//     Optional Dependencies
//     </div>
//     <ul>
//       <li><i>jna</i> - if testing with IE on Windows environments
//       <li><i>servlet-api</i> - needed only if you intend to run TestRunner from a standalone
//            process (ie, from a normal Java program, not a webapp).
//            <p/>
//            However, it should <u>not</u> be deployed to a servlet container such as Tomcat
//            or Jetty.  The best case is that the file will be unused and a source of
//            confusion for anybody looking at the webapp's library usage; the worst case is
//            that it will conflict with the container's own implementation of the Servlet API.
//     </ul>
//   </td>
// </tr>
// <tr>
//   <td class="jmd-module">
//     <a target="_blank" href="./mavendoc/isomorphic-js-parser.html">isomorphic_js_parser</a>
//   </td>
//   <td>
//     A parser capable of reading a JSON byte stream and creating an in-memory Java object
//     structure to match.  Used by any mechanism that relies on JSON-style configuration.
//     Examples include FileAssembly definitions in JSON format, any use of the rulesFile with
//     a URIRegexFilter (Java Servlet) or subclass.
//   </td>
// </tr>
// <tr>
//   <td class="jmd-module"><a target="_blank" href="./mavendoc/isomorphic-compression.html">
//     isomorphic_compression</a>
//   </td>
//   <td>
//     This is a part of the Network Performance Module.  The isomorphic_compression module is
//     required for dynamic and static compression of various assets delivered to the browser.
//     For more information, see: +link{group:compression}.
//   </td>
// </tr>
// <tr>
//   <td class="jmd-module"><a target="_blank" href="./mavendoc/isomorphic-assembly.html">
//     isomorphic_assembly</a>
//   </td>
//   <td>
//     This is part of the Network Performance Module.  The isomorphic_assembly module is
//     required for file assembly and stripping.  For more information, see:
//     +link{group:fileAssembly}.
//   </td>
// </tr>
// <tr>
//   <td class="jmd-module"><a target="_blank" href="./mavendoc/isomorphic-scheduler.html">
//     isomorphic_scheduler</a>
//   </td>
//   <td>
//     Server-side libraries providing +link{quartzAdapters, DataSource adapters} for the
//     +externalLink{http://www.quartz-scheduler.org, Quartz} API.
//   </td>
// </tr>
// <tr>
//   <td class="jmd-module"><a target="_blank" href="./mavendoc/isomorphic-m2pluginextras.html">
//     isomorphic_m2pluginextras</a>
//   </td>
//   <td>
//     A small collection of tools / utilities for use by Maven builds, Ant Scripts, and
//     command line invocation.
//   </td>
// </tr>
// <tr>
//   <td class="jmd-module">
//     <a target="_blank" href="./mavendoc/isomorphic-spring.html">isomorphic_spring_hibernate4</a>
//   </td>
//   <td>
//     Support for Spring + Hibernate 4, see the Compatibility section of +link{group:springIntegration} for more details.
//   </td>
// </tr>
// </table>
//
// @treeLocation Concepts/Deploying SmartClient
// @title Java Module Dependencies
// @visibility external
//<

//> @groupDef npmjs
// SmartClient client-side resources - the JavaScript runtime, skins, and schema - can be
// installed and updated via +externalLink{https://www.npmjs.com,npmjs}.  Select the
// appropriate package based on your licensing:<ul>
// <li> +externalLink{https://www.npmjs.com/package/smartclient-lgpl,      smartclient-lgpl}
// <li> +externalLink{https://www.npmjs.com/package/smartclient-eval,      smartclient-eval}
// <li> +externalLink{https://www.npmjs.com/package/smartclient-pro,       smartclient-pro}
// <li> +externalLink{https://www.npmjs.com/package/smartclient-power,     smartclient-power}
// <li> +externalLink{https://www.npmjs.com/package/smartclient-enterprise,smartclient-enterprise}
// </ul>
// <b>Note:</b> the SmartClient npm module requires an environment, such as
// +externalLink{https://en.wikipedia.org/wiki/React_(JavaScript_library),React} or
// +externalLink{https://en.wikipedia.org/wiki/Angular_(web_framework),Angular}, that defines
// "window" as a global with real browser document and navigator objects.
//
// <h2>Installation</h2>
// <b style="color:red">When installing a module in npm v7, console output is suppressed, and
// interactive output is not allowed. So by default, we now install without prompting wherever
// a default response is available. Please be patient as it may take a minute or more,
// depending on your connection and hardware, to finish, with no console updates to indicate
// progress.</b><p>
// To install one of these packages, use:
// <pre>
//   npm install &lt;package name&gt; [flags]</pre>
// where the flags are as follows:<p>
// <table border=1 class="normal">
// <tr bgcolor="#D0D0D0"><td>Option Name</td><td>Argument Value</td><td>Description</td></tr>
// <tr>
// <td><code>location</code></td><td>path</td>
// <td>A path (absolute or relative to the dependent module) specifying where to install
// the SmartClient runtime(s).  Default is to place the runtime root directory
// (<code>isomorphic</code>) in the dependent module directory.</td>
// </tr><tr>
// <td><code>branch</code></td><td>number</td>
// <td>Desired branch (e.g. 11.1).  Default is the latest release.</td>
// </tr><tr>
// <td><code>date</code></td><td>date in format YYYY-MM-DD | <code>latest</code>
// </td><td>Desired date.  Default is to use the latest build available.</td>
// </tr><tr>
// <td><code>runtime</code></td><td><code>release</code> | <code>debug</code> |
// <code>both</code></td><td>Desired runtime(s) to install.  Default is to install them both.
// </td></tr><tr>
// <td><code>reference</code></td><td><code>true</code> | <code>false</code></td>
// <td>Whether to keep the framework reference directory.  Default is to not install it to save
// disk space.</td>
// </tr><tr>
// <td><code>skins</code></td><td><code>Tahoe</code> | <code>all</code> | <code>none</code></td>
// <td>Which skins (if any) to install.  Default is to only install Tahoe.</td>
// </tr><tr>
// <td><code>username</code></td><td>string</td>
// <td>The username for your +externalLink{https://www.smartclient.com,SmartClient account}.
// Required for the +externalLink{https://www.npmjs.com/package/smartclient-pro,Pro},
// +externalLink{https://www.npmjs.com/package/smartclient-power,Power}, and
// +externalLink{https://www.npmjs.com/package/smartclient-enterprise,Enterprise} packages,
// and available subject to your licensing.</td>
// </tr><tr>
// <td><code>password</code></td><td>string</td>
// <td>The password for your +externalLink{https://www.smartclient.com,SmartClient account}.
// Required for the +externalLink{https://www.npmjs.com/package/smartclient-pro,Pro},
// +externalLink{https://www.npmjs.com/package/smartclient-power,Power}, and
// +externalLink{https://www.npmjs.com/package/smartclient-enterprise,Enterprise} packages,
// and available subject to your licensing.</td>
// </tr><tr>
// <td><code>analytics</code></td><td><code>true</code> | <code>false</code></td>
// <td>Whether to install the optional +link{group:loadingOptionalModules,Analytics Module}.
// Only available for the +externalLink{https://www.npmjs.com/package/smartclient-power,Power},
// and +externalLink{https://www.npmjs.com/package/smartclient-enterprise,Enterprise} packages,
// subject to your licensing.</td>
// </tr><tr>
// <td><code>rtm</code></td><td><code>true</code> | <code>false</code></td>
// <td>Whether to install the optional
// +link{group:loadingOptionalModules,RealtimeMessaging Module}.  Only available for the
// for the +externalLink{https://www.npmjs.com/package/smartclient-power,Power}, and
// +externalLink{https://www.npmjs.com/package/smartclient-enterprise,Enterprise} packages,
// subject to your licensing.</td>
// </tr><tr>
// <td><code>prompt</code></td><td><code>true</code> | <code>false</code></td> <td>Wait for
// input instead of assuming the default response to all queries during install; default is to
// not prompt to support newer npm releases.</td>
// </tr></table><p>
// After installation, command-line configuration is persisted, so command-line arguments only
// need to be supplied when updating if the desired configuration has changed. If a username and
// password aren't supplied via the above options, you will be prompted to enter them by the
// update script. A password typed in response to the script won't be persisted to your
// configuration, so you may choose to always enter it interactively for security.
//
// <h2>Updating</h2>
// Since 'npm update' no longer runs a package's update script if the version hasn't changed,
// and smartclient npm packages are versioned separately from nightly SDK builds, you must go
// to the smartclient npm module directory, and run using the syntax
// <pre>
//   npm run update [flags]</pre>
// to update your installation to the latest runtimes.  The supported flags are the same as
// during installation.
//
// <h2>Using npm v7</h2>
// The install script for a module is no longer allowed to write output in npm v7, which means
// that we can no longer interactively query for decisions or show zip download progress. So,
// to still have a complete install process, the module now proceeds automatically, without
// waiting, wherever a default response is available for what was formerly an interactive
// query. Please be patient as the zip download and installation of framework, skins, and other
// assets may take more than a minute, during which no additional output indicating progress
// will be printed.
// <P>
// You have a few alternatives to this default behavior:<ul>
// <li>You can pass "--prompt" to "npm install ...". Due to npm v7 rules, installing the module
// this way will skip the download and installation of the SmartClient framework and skins, and
// the isc-config.json configuration file won't be created. So afterwards, to install the
// missing assets you should navigate down to the module directory (under node_modules) and
// manually execute "npm run update [flags]", passing your install flags.
// <li>In addition to "--prompt", you can also pass "--foreground-scripts" as a flag to the
// install command to allow output as in npm v6, but in npm v7 this seems to trigger other
// timing logs that obfuscate what we print. Hopefully, support for the "--foreground-scripts"
// flag will improve in future npm releases.</ul>
// Note that since there are no default responses for the "username" and "password" flags, if
// they are required, installation of assets will be skipped (as in the first bullet above)
// unless you provide bindings on the command line initially for "npm install ...".
// <P>
// "Uninstall" is no longer a lifecycle event in npm v7, so a module's uninstall script
// declared in package.json no longer gets called during uninstallation. The recommended
// workaround is to run "npm run uninstall" from the module directory (under node_modules)
// before uninstalling.
//
// <h2>Examples</h2>
// New install of SmartClient Evaluation, selecting a specific branch and date:
// <pre>
//   npm install smartclient-eval --branch=11.1 --date=2018-12-30</pre>
// Update to latest nighlty build (run from package directory):
// <pre>
//   npm run update --date=latest</pre>
// Update to SmartClient 12.1 branch, installing all skins:
// <pre>
//   npm run update --branch=12.1 --skins=all</pre>
//
// <h2>Importing</h2>
// If you are building a new Angular, React or similar application, and plan to use SmartClient
// pervasively throughout, you can just add an import declaration to your <code>main.ts</code>
// or <code>App.tsx</code> to make the framework available.  However, if you are adding
// SmartClient to an existing application, and you only plan to use SmartClient for specific
// components like grids, or for +link{group:reifyForDevelopers,Reify screens}, consider using
// +link{group:backgroundDownload,background download} instead of importing SmartClient
// directly (importing causes SmartClient to load immediately on all pages).
// <p>
// To directly import the release or debug framework, respectively, in your application, you can
// write:
// <pre>
//   import 'smartclient-eval/debug';</pre>
// or
// <pre>
//   import 'smartclient-eval/release';</pre>
// To import a skin as well, such as "Tahoe", you can add:
// <pre>
//   import 'smartclient-eval/skins/Tahoe';</pre>
// To import one of the optional modules, you'd write something like:
// <pre>
//   import 'smartclient-eval/debug/rtm';</pre>
// or
// <pre>
//   import 'smartclient-eval/release/analytics';</pre>
// respectively, to import the debug version of the Realtime Messaging module or the release
// version of the Analytics module.
// <p>
// <b>Caution:</b> you can't mix debug and release imports in a single app.
//
// <h3>Importing skins in Angular</h3>
// In Angular,  if you directly import the skin, you may need to manually add the path to the
// <code>skin_styles.css</code> file for your skin to the <code>src/styles.css</code> file (or
// equivalent) for your app, in addition to importing the
// skin as described above.
// <p>
// For example, if you've installed the SmartClient runtime in the default location, and are
// importing Tahoe, you'd add the following to <code>src/style.css</code> in your app:
// <pre>
//   &commat;import '../isomorphic/skins/Tahoe/skin_styles.css';</pre>
// <b>Note:</b> if you are using the +link{FileLoader} to load a skin, it must be installed
// under <code>src/assets</code> (for example copied from <code>isomorphic/skins</code>) to
// work properly.
//
// <h3>Using SmartClient APIs</h3>
// If you want to refer to SmartClient APIs through your own constant, you can always issue a
// declaration such as:
// <pre>
//   const ISC: typeof isc = window['isc'];</pre>
// after importing this package.
//
// <h2>TypeScript</h2>
// To provide typescript support, the installation process should automatically augment your
// <code>tsconfig.json</code> file with an include directive targeting SmartClient's typescript
// file.
// <P>
// Alternatively, you can copy the typescript declaration file, <code>smartclient.d.ts</code>,
// from the installed resources under the <code>isomorphic</code> directory to your app's
// source directory, and then import it from your app like:
//
// <pre>
//   import 'smartclient.d.ts';</pre>
// SmartClient's TypeScript support is intended for IDE auto-completion and inline
// documentation, not for transpilation.  So, if you run into compile errors, you can always
// remove any reference to our TypeScript file from your own TS file and application, remove
// <code>smartclient.d.ts</code> from under <code>src/assets</code> (if present), and instead
// make TypeScript active for your IDE only.  For further details, see the TypeScript support
// documentation for +link{group:typeScriptSupport,our framework} or your IDE.
//
// @treeLocation Concepts/Deploying SmartClient
// @see group:iscInstall
// @title NPMJS Support
// @visibility external
//<


//> @groupDef openapiSupport
//
// If you allow access to your server-side DataSources via the
// +link{group:servletDetails, RESTHandler servlet}, the SmartClient server can also generate
// a standard +externalLink{https://github.com/OAI/OpenAPI-Specification, OpenAPI specification}
// of the REST interface supported by <code>RestHandler</code>. This allows any client system
// that supports OpenAPI to access the operations supported by your DataSources. Because details
// like +link{FieldType, field types} and +link{Validator, validators}) are automatically
// translated to OpenAPI, the OpenAPI specification (OAS) of your DataSource operations is much
// more specific and detailed than the general +link{RestDataSource} protocol spec, and
// can allow automatically generated UIs or automatically generated communication stubs to be
// much richer and easier to use.
// <p>
// Very often, a reasonably simple DataSource expresses more than can be easily translated to
// the current OpenAPI specification.  In such cases, efforts are made to use the OpenAPI
// +externalLink{https://swagger.io/docs/specification/openapi-extensions/, extensions}
// mechanism to provide that level of detail.  Validators are one common area of interest.
// It is worthwhile to inspect the raw YAML output at least once before relying solely on
// visual tooling, unless said tooling
// supports vendor extensions.  +externalLink{https://github.com/Redocly/redoc, ReDoc},
// for example, is able to render the generated spec well, and in fact powers the example
// specification (see link below), but leaves out important details found in the extensions,
// like the RESTHandler's JSON +link{RestDataSource.jsonPrefix, prefix} and
// +link{RestDataSource.jsonSuffix, suffix}.
//
// <h4>Tooling</h4>
// The generated specification makes extensive use of
// +externalLink{https://swagger.io/docs/specification/using-ref/, remote references} to make
// the spec more readable without tooling.  Unfortunately, a number of popular
// tools do not yet support the use of this OAS feature. Postman, for example, has at
// least one +externalLink{https://github.com/postmanlabs/openapi-to-postman/issues/38, issue}
// that you can watch for progress.  In the meantime, we've found that the hosted
// +externalLink{http://editor.swagger.io/, Swagger} tools seem to work well, if you make
// allowances for
// +externalLink{https://developer.mozilla.org/en-US/docs/Web/HTTP/CORS,Cross-Origin Resource Sharing}.
// One very simple way of doing so with Swagger Editor, for example, is to enable a CORS filter
// (perhaps temporarily) like the one provided by
// +externalLink{https://www.eclipse.org/jetty/javadoc/jetty-9/org/eclipse/jetty/servlets/CrossOriginFilter.html, Jetty}:
//
// <pre>
//     &lt;filter&gt;
//         &lt;filter-name&gt;cross-origin&lt;/filter-name&gt;
//         &lt;filter-class&gt;org.eclipse.jetty.servlets.CrossOriginFilter&lt;/filter-class&gt;
//     &lt;/filter&gt;
//     &lt;filter-mapping&gt;
//         &lt;filter-name&gt;cross-origin&lt;/filter-name&gt;
//         &lt;url-pattern&gt;/restapi/*&lt;/url-pattern&gt;
//     &lt;/filter-mapping&gt;
// </pre>
//
// allowing the Swagger Editor to access the YAML generated for you by SmartClient, through
// the use of its <code>url</code> query parameter.  e.g.,
// +externalLink{http://editor.swagger.io/?url=http://localhost:8080/api/Customer.yaml}
//
// <h4>Usage</h4>
// Configure the RESTHandler endpoint as usual (refer to server
// +serverDocLink{com/isomorphic/servlet/RESTHandler.html, javadoc} for details), and
// submit a GET request there for the <code>openapi.yaml</code> resource.
// For example, if your servlet is configured to respond to requests at <code>/restapi</code>
//
// <pre>
//   &lt;servlet-mapping&gt;
//       &lt;servlet-name&gt;RESTHandler&lt;/servlet-name&gt;
//       &lt;url-pattern&gt;/restapi/&lt;/url-pattern&gt;
//   &lt;/servlet-mapping&gt;
// </pre>
//
// then a GET request to <code>/restapi/openapi.yaml</code> will yield the automatically
// generated documentation, based on your application's DataSource (ds.xml) configurations.
// This specification is generated dynamically, so that each new request for the specification
// includes any changes made to new or updated DataSources since the last request.
// Alternatively, save the file to disk, with modifications if desired, and serve it statically
// from another location if that's more in line with your requirement.
//
// <h4>Structure</h4>
// By design, <code>openapi.yaml</code> by default includes a reference to every path exposed
// by every DataSource.ds.xml file found in your project.  The paths exposed by your DataSource
// are determined by the rules documented in the
// +link{group:servletDetails, RESTHandler servlet's} SimplifiedREST protocol.  For an Order
// DataSource with only default operationBindings, these references would look something like
// the following:
//
// <pre>
// paths:
//   /:
//     post:
//       summary: DataSource-agnostic POSTMessage protocol
//       # and so on... remainder clipped for brevity
//
//   /RESTDataSource/Order/fetch:
//     $ref: Order.yaml#/paths/~1RESTDataSource~1Order~1fetch
//   /RESTDataSource/Order/add:
//     $ref: Order.yaml#/paths/~1RESTDataSource~1Order~1add
//   /RESTDataSource/Order/update:
//     $ref: Order.yaml#/paths/~1RESTDataSource~1Order~1update
//   /RESTDataSource/Order/remove:
//     $ref: Order.yaml#/paths/~1RESTDataSource~1Order~1remove
//   /RESTDataSource/Order/batch:
//     $ref: Order.yaml#/paths/~1RESTDataSource~1Order~1batch
//   /Order:
//     $ref: Order.yaml#/paths/~1Order
//   /Order/{orderId}:
//     $ref: Order.yaml#/paths/~1Order~1%7BorderId%7D
// </pre>
//
// The first path in the above listing documents RESTHandler's singular AdvancedREST endpoint,
// described by the +link{RESTDataSource, RESTDataSource's} postMessage protocol and found in
// our example configuration at <code>/restapi/</code>.  As documented elsewhere, this should
// normally be the endpoint preferred by all but the simplest of integrations.
// <p>
// On the other hand, it is also the endpoint most difficult to document effectively,
// due in part to a handful of restrictions found in the OAS 3.x specification.  One such
// restriction is documented in an open issue around
// +externalLink{https://github.com/OAI/OpenAPI-Specification/issues/2031, request/response correlation},
// which in short points out that there is no good way to correlate a variation of some request
// to the matching variation on the response.  In the case of the AdvancedREST endpoint,
// of course, request and response formats both depend entirely on the values provided in
// <code>dataSource</code>, <code>operationType</code>, and <code>operationId</code> arguments.
// Ideally, we could document the inputs and outputs of a resource like
// <code>/restapi/?dataSource=Order&operationType=fetch&operationId=fetchByCustomer</code>
// separately from one like
// <code>/restapi/?dataSource=Order&operationType=fetch&operationId=fetchByUser</code>,
// but this is expressly
// +externalLink{https://swagger.io/docs/specification/paths-and-operations/, disallowed}.
// <p>
// In the absence of any spec-compliant mechanism like
// +externalLink{https://github.com/OAI/OpenAPI-Specification/issues/256#issuecomment-583476857, supporting interdependencies between query parameters}
// then, we also provide simplified variations of the AdvancedREST endpoint on each
// DataSource's specification, seen alongside the other SimplifiedREST endpoints with the
// <code>RESTDataSource</code> path.  These 'SimplifiedPOST' endpoints do allow for Criteria
// &amp; AdvancedCriteria, as well as batching of multiple operations against the same
// DataSource.
// <p>
// You can easily view all of the operations for a single DataSource by making the request to
// <code>{id}.yaml</code> instead of openapi.yaml, where <code>{id}</code> is the ID of any
// DataSource in your project.  Building on the examples above, a request for
// <code>/restapi/Order.yaml</code>would include every path except '/'.  Again, prefer
// the RestHandler's AdvancedREST endpoint to SimplifiedREST, with the caveat that
// SimplifiedREST documentation my be more explicit until a future version of the OAS spec
// addresses some of the issues discussed here.
// <p>
// A full example specification is too lengthy to include in documentation, so it is left to
// the reader to experiment with their own DataSources (sample DataSources are included with
// the SDK and in +link{group:mavenSupport, Maven archetypes} or with the example specification
// bundled in the SDK (link below), using this documentation as guidance.  Most of what is
// generated for you can be pretty easily traced back to your DataSource -
// +link{DataSource.description, description}, field names, required/optional attributes, and
// type mappings are all pretty straightforward, and the rest of it really should work the
// way you might expect it to.  A few specific examples include:
//
// <ul>
//     <li>A field's valueMaps are expressed as an enum and appended to the
//         +link{dataSourceField.description, description}, complete with
//         +link{dataSourceLocalization, i18n translations} as applicable, when a locale
//         can be derived from the servlet request or is specified explicitly with a 'locale'
//         query parameter (e.g., ?locale=es).
//     </li>
//     <li>
//       A note about authorization constraints is also appended, when any
//       +link{DataSource.requiresAuthentication, Declarative Security} rules are found
//       (rules themselves are not disclosed, by design).
//     </li>
//     <li>Any operationBinding with an explicit operationId is exposed on its own
//         path, where its binding-specific +link{OperationBinding.criteria, criteria},
//         +link{OperationBinding.description, description},
//         +link{OperationBinding.outputs, outputs}, etc. are respected.
//     </li>
// </ul>
//
// Note that multiple operations of the same operationType are supported.  The example below
// illustrates the same DataSource with multiple add operations:
//
// <h5>DataSource</h5>
// <pre>
// &lt;DataSource serverType="sql" schema="PUBLIC" dbName="ClassicModels"
//   ID="Order"
//   tableName="orders"&gt;
//
//   &lt;serverObject className="com.example.classicmodels.OrderOperations" /&gt;
//
//   &lt;fields&gt;
//     &lt;field name="orderNumber" type="sequence" primaryKey="true" /&gt;
//     &lt;field name="orderDate" type="date" required="true" /&gt;
//     &lt;field name="requiredDate" type="date" required="true" /&gt;
//     &lt;field name="shippedDate" type="date" /&gt;
//     &lt;field name="status" type="enum" length="15" required="true"&gt;
//       &lt;valueMap&gt;
//         &lt;value&gt;In Process&lt;/value&gt;
//         &lt;value&gt;Shipped&lt;/value&gt;
//         &lt;value&gt;Cancelled&lt;/value&gt;
//         &lt;value&gt;Disputed&lt;/value&gt;
//         &lt;value&gt;Resolved&lt;/value&gt;
//         &lt;value&gt;On Hold&lt;/value&gt;
//       &lt;/valueMap&gt;
//     &lt;/field&gt;
//     &lt;field name="comments" type="text" length="16777216" /&gt;
//     &lt;field name="customerNumber" title="Customer" type="integer" required="true"
//          foreignKey="Customer.customerNumber"
//          displayField="customerName" /&gt;
//     &lt;field name="customerName" includeFrom="Customer.customerName" hidden="true" /&gt;
//   &lt;/fields&gt;
//   &lt;operationBindings&gt;
//     &lt;binding operationType="add" operationId="addWithDiscountCode" serverMethod="addWithDiscountCode" /&gt;
//     &lt;binding operationType="add" operationId="addWithManualAdjustment" serverMethod="addWithManualAdjustment" /&gt;
//   &lt;/operationBindings&gt;
// &lt;/DataSource&gt;
// </pre>
//
// <h5>Paths</h5>
// <pre>
//   /Order:
//     $ref: Order.yaml#/paths/~1Order
//   /Order/{orderId}:
//     $ref: Order.yaml#/paths/~1Order~1%7BorderId%7D
//   /Order/add/addWithDiscountCode:
//     $ref: Order.yaml#/paths/~1Order~1add~1addWithDiscountCode
//   /Order/add/addWithManualAdjustment:
//     $ref: Order.yaml#/paths/~1Order~1add~1addWithManualAdjustment
// </pre>
//
// <h4>Customization</h4>
// A complete specification will normally require at least some content that cannot be derived,
// so most users will at minimum want to replace default values for things like application
// title, description, and version number attributes.
// <p>
// The simplest means for this kind of minimal customization is through
// +link{group:server_properties,server.properties} configuration.  Example
// values for supported properties include:
//
// <pre>
//   openapi.info.version: 1.0.0
//   openapi.info.title: New Application
//   openapi.info.description: A short description of New Application
//
//   ## default value derived from servlet context &amp; httpRequest
//   openapi.servers.servletUrl: http://localhost:8080/restapi
// </pre>
//
// You may also use configuration to control which DataSources are exposed to your
// specification. Three strategies are supported:
//
// <ul>
//   <li>Exclusion: Set an 'apidoc' attribute value to false on any DataSource definition to
//       exclude it from the list of documented DataSource operations.
//       <pre>&lt;DataSource ID="Order" tableName="orders" apidoc="false"&gt;</pre>
//   </li>
//   <li>Blacklisting: Exclude a (comma-separated) list of DataSources through server.properties
//       configuration:
//       <pre>openapi.ds.blacklisted: Order, OrderDetail</pre>
//   </li>
//   <li>Whitelisting: Exclude everything <strong>but</strong> a (comma-separated) list of
//       DataSources, also through server.properties configuration:
//       <pre>openapi.ds.whitelisted: Order, OrderDetail</pre>
//   </li>
// </ul>
//
// No matter which strategy you use,
// +serverDocLink{com/isomorphic/datasource/DynamicDSGenerator.html, Dynamic DataSources}
// must always be allowed explicitly, and are added to the list after whitelisting /
// blacklisting rules are applied.  Your DynamicDSGenerator must be able to resolve the given
// names, which may be supplied either through server.properties configuration or via
// an HttpServletRequest attribute, usually set by a filter that intercepts requests for the
// RESTHandler servlet.  The mechanism you use will depend on your requirement -
// DynamicDSGenerators registered using a simple
// +serverDocLink{com/isomorphic/datasource/DataSource.html#addDynamicDSGenerator-com.isomorphic.datasource.DynamicDSGenerator-java.lang.String-, prefix}
// may be easily configured using the former, while those registered using
// +serverDocLink{com/isomorphic/datasource/DataSource.html#addDynamicDSGenerator-com.isomorphic.datasource.DynamicDSGenerator-java.util.regex.Pattern, patterns}
// may need to be a little more dynamic, and better suited to the latter approach.
// The following are examples of both approaches, which work equally well:
//
// <pre>openapi.ds.dynamics: DYN_Environment, DYN_Status</pre>
// <pre>request.setAttribute("openapi.ds.dynamics", "DynamicOrder$Foo_0123, DynamicOrderItem$Foo_0123,");</pre>
//
// Finally, a DataSource is automatically excluded from the specification under the
// following circumstances:
// <ul>
//   <li>It is marked with serverOnly="true"</li>
//   <li>It is marked with requires="false"</li>
//   <li>It is marked with its type="component"</li>
//   <li>It has no fields (and inherits no fields)</li>
// </ul>
//
// Similarly, an explicitly defined operationBinding may also be excluded from the
// specification, if one or more of the following conditions are true:
// <ul>
//     <li>It is configured for exclusion with an 'apidoc' attribute value of false.
//       <pre>&lt;binding apidoc="false" operationType="add" operationId="addWithDiscountCode" serverMethod="addWithDiscountCode" /&gt;</pre>
//     </li>
//     <li>The operationType is 'update' or 'remove' and (neither of these are common scenarios):
//         <ul>
//             <li>No primaryKeys have been defined AND the binding is not configured to
//                 +link{OperationBinding.allowMultiUpdate, allowMultiUpdate}
//             </li>
//             <li>OR there are no non-key fields at all</li>
//         </ul>
//     </li>
// </ul>
//
//
// For very advanced customizations, a handful of
// +externalLink{https://freemarker.apache.org/,Freemarker}
// templates are bundled with the server runtime, and can be found in the
// <code>com.isomorphic.openapi</code> package of the isomorphic-core-rpc module.  Any of these
// templates may be overridden by placing a copy in a location known to the RESTHandler servlet
// (again, refer to server javadoc), but this kind of thing should normally be considered the
// last course of action.
// <p>
//
// <h4>FAQ</h4>
// As always, the <smartgwt>SmartGWT</smartgwt><smartclient>SmartClient</smartclient>
// +externalLink{https://forums.smartclient.com/, forums}
// are an appropriate place to seek guidance in unusual circumstances.
//
// <h4>Examples</h4>
// <ul>
// <li> <a target="_blank" href="../../../docs/resources/openapi.html">Example OpenAPI Specification</a>
// </ul>
// @title OpenAPI Specification (OAS) Support
// @treeLocation Concepts
// @visibility external
//<

//> @groupDef iscServer
//
// The SmartClient Server is a set of Java libraries, servlets and tools that provide the key
// server-side components needed to build a complete application in the modern web
// architecture.
// <P>
// The SmartClient Server can be +link{group:iscInstall,integrated} into any pre-existing Java
// application, and is designed to rapidly connect SmartClient visual components to
// pre-existing Java business logic or persistence engines.  SmartClient's Ajax request
// processing facilities can be easily integrated into
// +link{group:springIntegration,Spring controllers} or custom servlets and JSPs.
// <P>
// Alternatively, the SmartClient Server provides a complete SQL and Hibernate-based
// persistence engine for new applications, with out-of-the-box servlets for processing Ajax
// data requests.
// <P>
// The SmartClient Server is optional, and SmartClient's client-side Ajax engine can be
// integrated with any server that provides HTTP access, using XML, JSON, SOAP or proprietary
// data protocols.  However any server in a modern web application will be required to provide
// most or all of the features of the SmartClient Server (described below), and the SmartClient
// Server represents a best-of-breed implementation of these facilities with a long history of
// high-volume production deployments.
// <P>
// <h4>Server enforcement of +link{class:Validator,Validators}</h4>
// <P>
// Data passed from the browser can be automatically validated by the SmartClient Server.
// In contrast, when using +link{group:clientDataIntegration,client-side integration},
// data arrives as HTTP params or XML messages, and you must parse values into the correct
// types (eg java.util.Date) and validate them, or use a server framework that does so.
// <P>
// <h4>High Speed Data Delivery / Data Compression</h4>
// <P>
// The SmartClient Server delivers data to and from the browser using a proprietary, maximally
// efficient protocol, providing simple Java APIs for sending and receiving data.
// <P>
// SmartClient's data protocol is:
// <ul>
// <li> automatically compressed: provides 6-8x improvement in bandwidth utilization
// <li> efficient on the server: high speed data serialization for any Java Object
// <li> efficient in the browser: faster than ordinary XML or JSON data delivery
// <li> minimal: facilities for +link{dataSource.dropExtraFields,trimming} and
// +link{dataSourceField.valueXPath,extracting} only the data you want the browser to see
// </ul>
// <P>
// <h4>Transparent upload support</h4>
// <P>
// SmartClient provides special client and server-side support for +link{group:upload,file
// upload}, which allows single and multiple-file HTTP uploads to be performed as a background
// Ajax request without reloading the page or launching sub-windows.
// <P>
// Uploaded files arrive at the SmartClient server as Java InputStreams accessible from the
// DSRequest object, and can optionally be automatically stored via SmartClient's SQL
// subsystem.
// <P>
// <h4>Transparent Queuing / "Batch" Operations</h4>
// <P>
// Any request transmitted to the SmartClient Server can be combined into a "queue" transmitted
// as a single HTTP request, with in-order execution for all queued operations.
// +link{RPCManager.startQueue,startQueue()} starts a queue and
// +link{RPCManager.sendQueue,sendQueue()} transmits it; queuing is transparent to the code
// that initiates the individual requests.  This enables:
// <ul>
// <li> re-use of data access operations across different screens
// <li> easy implementation of transaction boundaries
// <li> simplified saving and loading of screens with complex, master-detail views
// <li> guaranteed in-order processing of operations
// <li> more efficient network usage
// </ul>
// <P>
// <h4>HTTP Response Headers for Top-Level Status Reporting</h4>
// <P>
// In addition to the existing SmartClient Server status reporting protocols, we have introduced
// HTTP response headers to provide top-level status reporting. These headers report status for
// both single requests and "queues" of requests transmitted as a single HTTP request:
// <P>
// <b>x-isc-server-status</b>: This header provides a single response status for individual requests.
// In the context of a "queue" of requests, it reports the status of the first "failure" response for
// non transactional "queues" of requests and general +link{RPCResponse.STATUS_FAILURE,STATUS_FAILURE}
// for the transactional "queue" of requests.<br>
// <b>x-isc-server-queue-status</b>: This header contains a comma-separated array of statuses. For single
// responses, it contains just one status. However, in the case of a "queue" of requests, it holds a
// comma-separated array of statuses, providing statuses for the entire "queue."
// <P>
// These headers report +link{group:statusCodes,RPC Response status codes}, for example headers:<br>
// <code>x-isc-server-status: -4</code><br>
// <code>x-isc-server-queue-status: 0,0,0,-4,0</code><br>
// report +link{RPCResponse.STATUS_VALIDATION_ERROR,STATUS_VALIDATION_ERROR} for one of requests in the
// "queue" of submitted requests.
// <P>
// These headers serve multiple purposes, including aiding in test scenarios by allowing you to access
// server status information without relying on the undocumented details of the iscServer protocol, which
// are subject to change without prior notice. Additionally, when dealing with download and export requests,
// these headers enable client-side code to skip the extraction of text from a blob in order to capture error
// responses efficiently.
// <P>
// <h4>Reify</h4>
// <P>
// +link{group:reify,Reify} is included with the SmartClient Server, and uses
// server features such as automatic SQL binding to provide a rapid prototyping environment.
// <P>
// <h4>Automatic Bi-directional Java &lt; - &gt; JavaScript serialization and translation</h4>
// <P>
// Provides a powerful, type-safe +link{rpcRequest.data,data transmission mechanism} for moving
// data between a Java server and the browser.
// <P>
// Any Java objects, including Java Beans, POJOs, Java Collections, XML DOMs and all Java
// primitives, with any level of nesting, can be automatically serialized and delivered as
// JavaScript Objects to the SmartClient client-side components.
// <P>
// JavaScript Objects existing in the browser can likewise be automatically transmitted to a
// Java Server and translated to Java Objects, with any level of nesting and automatic
// preservation of primitive types.
// <P>
// <h4>SQL and Hibernate connectors</h4>
// <P>
// DataSources of serverType:"sql" or serverType:"hibernate" can generate and execute queries
// against popular SQL engines or against the Hibernate ORM system, providing SmartClient's
// +link{DataBoundComponent}s with the four standard CRUD operations (create, retrieve, update,
// delete) without writing any server-side code.  For rapid prototyping, these DataSources can
// even generate SQL tables based on the DataSource declaration, using the
// +link{group:adminConsole,Admin Console} visual tool.
// <P>
// Server-side APIs allow server-side modification of the request before it is executed (for
// example, to enforce security) and post-processing of the request after execution (for
// example, to provide calculated values).
// <P>
// Both serverType:"sql" and serverType:"hibernate" support the field-operator-value queries
// that can be generated by using the +link{FilterBuilder} component (see
// +explorerExample{filterBuilderBracket,example}).
// <P>
// <h4>Rich, Standardized Request / Response protocol</h4>
// <P>
// The SmartClient Server provides a standardized request and response protocol designed for
// data-oriented "CRUD" operations (create, retrieve, update, delete).
// <P>
// This standardized protocol automatically handles +link{DSRequest,request metadata} (paging
// parameters, requested sort order, original values of data being modified) and
// +link{DSResponse,response metadata} (error handling, cache management, session expiration etc).
// <P>
// This standardized protocol avoids
// developers in different groups inventing their own incompatible and redundant
// request/response protocols, and allows developers to more easily learn code they didn't
// author.
// <P>
// <h4>Bi-directional XPath binding to Java Objects</h4>
// <P>
// Most UI designs do not directly reflect the underlying Object model and so some degree of
// translation is necessary in order to populate UI components with data and apply user changes
// to the Java Object model.  This is often accomplished with brittle, difficult to understand
// data translation code sprinkled throughout the system, done in a different way for every
// screen or component.
// <P>
// SmartClient provides a standard, +link{dataSourceField.valueXPath,XPath-based approach} to
// adapting any Java-based Object model to the requirements of the UI design.  Data relevant to
// the application UI is centrally extracted in the server-side +link{DataSource} layer, so
// that all UI components have a consistent, unified view of the data model for both loading
// <b>and</b> saving data.
// <P>
// <h4>Broadest possible browser support</h4>
// <P>
// The SmartClient Server can compensate for facilities
// +link{group:platformDependencies,missing or disabled in certain browsers},
// including ActiveX being disabled in IE6 and missing XML support in some versions
// of Apple's Safari browser.
// <P>
// <h4>Transparent Proxying</h4>
// <P>
// +link{RPCManager.sendProxied,Proxying} allows SmartClient applications to access web
// services, RSS feeds, HTML content and other data services in a secure manner regardless of
// where they are located: across the enterprise or publicly available.
// <P>
// <h4>Optional +link{group:networkPerformance,Network Performance} Module</h4>
// <P>
// Provides:
// <ul>
// <li> compressed delivery of SmartClient runtime, application logic and other assets such as CSS
// <li> +link{FileLoader,background download} of SmartClient and other assets for zero
// user-perceived load time
// <li> on-the-fly stripping and combining of JavaScript (application code and data)
// <li> browser cache control
// </ul>
// <P>
// <h4>Optional Messaging Module (aka server push)</h4>
// <P>
// The +link{group:messaging,Messaging} module allows the server to "push" messages to the client, without
// client polling, for real-time monitoring/dashboarding applications.
//
// @title SmartClient Server Summary
// @treeLocation Java Server Reference
// @visibility external
//<


//> @groupDef jsfIntegration
//
// SmartClient can be used within JSF applications to add AJAX richness and interactivity.
// <P>
// Because JSF is a pre-AJAX architecture, the recommended approach in adding
// SmartClient to JSF applications is to create pages that use SmartClient components exclusively,
// so that older, server-based JSF components do not introduce full-page refreshes.
// <P>
// JSF pages that render components on the server access data via JSF Expression Language.
// SmartClient-based JSF pages can similarly load initial data by using JSTL, as shown in
// +externalLink{/examples/server_integration/#jstlList,this example}, where a ListGrid is
// populated by JSTL access to Java Beans stored in the JSP <code>pageContext</code>.
// <P>
// Once a SmartClient JSF page has loaded, SmartClient components will request data via background
// HTTP requests that load only data, not a complete page.  The
// +link{group:dmiOverview,Direct Method Invocation} system can be used to declaratively map SmartClient's
// background data requests directly to Java Methods. The SmartClient server automatically
// translates inbound request data into Java Objects that are passed to the method you specify,
// and the Java method return value is automatically translated into data for SmartClient
// components.
// <P>
// <h4>Incorporating server-side JSF components into a SmartClient JSF page</h4>
// <P>
// An +link{HTMLFlow} or +link{HTMLPane} component can be used to incorporate server-generated
// content within a SmartClient-based page.  With +link{htmlFlow.contentsType,contentsType} set to
// "page", the HTMLPane/Flow will act like a standalone page-within-a-page (via a
// SmartClient-managed HTML IFRAME element), allowing interactive server-side JSF components to
// participate normally, with limitations as discussed under the documentation for
// +link{htmlFlow.contentsType,contentsType}.
//
// @title Integration with JSF
// @visibility external
//<

//> @groupDef springIntegration
// <b>Overview</b>
// <P>
// The Spring framework has many different parts, from integration with Object Relational
// Mapping (ORM) and transaction management systems, to a Model View Controller (MVC)
// architecture.
// <P>
// If you are building a new application from scratch and/or you are trying to
// modernize the presentation layer of an existing application, most of Spring MVC is
// inapplicable in the +link{group:smartArchitecture,SmartClient architecture}.  Specifically,
// SmartClient renders <b>all</b> HTML on the client, and the server is responsible only for
// retrieving data and enforcing business rules.  This means that Spring's ModelAndView and all
// functionality related to retrieving and rendering Views is unnecessary in SmartClient.
// SmartClient only needs the Model, and provides methods to deliver that Model to SmartClient
// components (the server side method DSResponse.setData()).
// <P>
// However, Spring's DispatchServlet, Handler chain, and Controller architecture is applicable
// to SmartClient.  See "Using Spring Controllers" below.
// <P>
// <b>Existing Spring Application</b>
// <P>
// As discussed under the general +link{group:clientServerIntegration,server integration}
// topic, integrating SmartClient into your application involves finding a way to provide data
// that fulfills the +link{DSRequest,DataSource requests} sent by SmartClient components.
// <P>
// There are 2 approaches for integrating SmartClient into an existing Spring application:
// <ul>
// <li> <b>call Spring beans via SmartClient DMI or custom DataSources</b>
// <span style="color:red">[Recommended]</span>: use SmartClient Direct Method Invocation
// (DMI) to map +link{dsRequest,DataSource requests} to beans managed by Spring, via
// +link{serverObject.lookupStyle}:"spring".   Return data to the browser by either simply
// returning it from your method, or via creating a DSResponse and calling DSResponse.setData()
// (server-side method).  Or, use a similar approach based on custom DataSource implementations
// where the +link{dataSource.serverConstructor,serverConstructor} is of the pattern
// <b>"spring:{bean_name}"</b>
// <P>
// This is the easiest method and produces the best result.  A Collection of Java Beans, such
// as EJB or Hibernate-managed beans, can be directly returned to SmartClient as the result of
// a DMI method, without the need to create an intervening
// +externalLink{http://en.wikipedia.org/wiki/Data_transfer_object,Data Transfer Object} to express
// which fields should be delivered to the browser - instead, only the fields declared on the
// DataSource are returned to the browser (see
// +link{DataSource.dropExtraFields,dropExtraFields}.  In this integration scenario, the
// majority of the features of the SmartClient Server framework still apply - see this
// +link{group:featuresCustomPersistence,overview}.
// <p>
// Note, there are special scoping considerations to bear in mind when using Spring-injected
// DataSources or DMIs - see +link{group:serverDataSourceImplementation,this discussion} of
// caching and thread-safety issues.
// <P>
// <li> <b>configure Spring to return XML or JSON responses</b>: create variants
// on existing Spring workflows that use a different type of View in order to output XML or
// JSON data instead of complete HTML pages.  The SmartClient +link{RestDataSource} provides a
// standard "REST" XML or JSON-based protocol you can implement, or you can adapt generic
// +link{DataSource,DataSources} to existing formats.
// <P>
// In some Spring applications, all existing Spring workflows can be made callable by
// SmartClient with a generic View class capable of serializing the Model to XML or JSON,
// combined with a Controller that always uses this View.  Consider the following Java
// anonymous class, which uses the SmartClient JSTranslater class to dump the entire
// Spring Model as a JSON response.
// <pre>
//  new View() {
//        public void render(Map model, HttpServletRequest request,
//                           HttpServletResponse response) throws IOException {
//                final ServletOutputStream outputStream = response.getOutputStream();
//                response.setContentType("application/x-javascript");
//                outputStream.println(JSTranslater.get().toJS(model));
//                outputStream.close();
//        }
//        public String getContentType() {
//                return "application/x-javascript";
//        }
//  }
// </pre>
// <P>
// If you use this approach, you do not need to install the SmartClient server, and can
// +link{iscInstall,deploy} SmartClient as simple web content (JS/media/HTML files).  If you
// are already familiar with how to generate XML from objects that typically appear in your
// Spring Models, this may be the easiest path.
// </ul>
// <P>
// <h3><b>Using Spring Controllers with SmartClient DMI</b></h3>
// <P>
// You can create a Controller that invokes standard SmartClient server request processing,
// including DMI, like so:
// <pre>
// public class <smartclient>SmartClientRPCController</smartclient><smartgwt>SmartGWTRPCController</smartgwt> extends AbstractController
// {
//     public ModelAndView handleRequest(HttpServletRequest request,
//                                       HttpServletResponse response)
//         throws Exception
//     {
//         // invoke SmartClient server standard request processing
//         com.isomorphic.rpc.RPCManager.processRequest(request, response);
//         return null; // avoid default rendering
//     }
// }
// </pre>
// This lets you use Spring's DispatchServlet, Handler chain and Controller architecture as a
// pre- and post-processing model wrapped around SmartClient DMI.
// <p>
// <h3><b>Using Spring Transactions with SmartClient DMI</b></h3>
// <p>
// You can make DMI's participate in Spring's transaction management scheme by setting the
// +link{dataSource.useSpringTransaction,useSpringTransaction} flag on your DataSources or
// +link{class:OperationBinding}s.  This makes your DMI method(s)
// transactional, and ensures that any DSRequests and Spring DAO operations executed within
// that DMI use the same Spring-managed transaction.  See the documentation for
// <code>useSpringTransaction</code> for more details.
// <p>
// In Power Edition and above, SmartClient Server has its own transaction management system.
// This allows you to send +link{RPCManager.startQueue(),queues} of
// +link{class:DSRequest,DSRequest}s to the server, and the entire queue will be treated as a
// single database transaction.  This is <b>not</b> the same thing as Spring transaction
// integration: SmartClient's built-in transaction management works across an entire queue of
// DSRequests, whereas Spring transactions are specific to a Java method that has been marked
// <code>&#x0040;Transactional</code> - the transaction starts and ends when the method starts and
// ends.
// <p>
// It is possible to have an entire SmartClient queue - including any <code>&#x0040;Transactional</code>
// DMIs that contain both Spring DAO operations and DSRequests - use the same Spring-managed
// transaction.  To do this:<ul>
// <li>Create a new Spring service bean with a <code>&#x0040;Transactional</code> method like this
// (note, the isolation level can vary as you please, but the propagation type must be REQUIRED
// to enable proper sharing of the transaction):<pre>
//    &#x0040;Transactional(isolation=Isolation.READ_COMMITTED, propagation=Propagation.REQUIRED)
//    public class MyServiceBean {
//
//        // invoke SmartClient server standard request processing
//        public void processQueue(RPCManager rpc) throws Exception {
//            rpc.processRPCTransaction();
//        }
//    }</pre></li>
// <li><b>Either:</b> Subclass the <code>com.isomorphic.servlet.IDACall</code> servlet and
// override its <code>processRPCTransaction</code> method to inject the service bean you just
// created and invoke its transactional method.  You will also have to change your
// <code>web.xml</code> file to point at this new servlet rather than <code>IDACall</code></li>
// <li><b>Or:</b> Use a Spring Controller, as described in the section <b>Using Spring
// Controllers with SmartClient DMI</b>, above.  Just follow the instructions for using a
// Spring Controller, but have your <code>handleRequest()</code> implementation inject your
// service bean and invoke its transactional method, as described for the <code>IDACall</code>
// subclass approach</li>
// </ul>
// Whether you choose the IDACall or Spring Controller approach, the important thing is that
// the call to <code>RPCManager.processRPCTransaction()</code> takes place from within a
// <code>&#x0040;Transactional</code> method of a Spring service bean.  This will place the
// processing of the entire SmartClient queue inside the transaction that is created by Spring
// to service that transactional method.
// <p>
// <h3><b>Using Spring DataSources with SmartClient SQLDataSource</b></h3>
// <p>
// Smartclient +link{group:sqlDataSource,SQL DataSources} may be configured to obtain JDBC
// connections from the <code>javax.sql.DataSource</code> implementation provided by
// Spring context. Search for <code>sql.MyDatabase.interface.type</code> in
// +link{group:sqlSettings,SQL settings} overview for the configuration details.
// <p>
// <h3><b>Spring Compatibility</b></h3>
// +externalLink{https://spring.io/projects/spring-framework#learn,Spring} &
// +externalLink{https://hibernate.org/,Hibernate} have gone through reworks recently in which backwards compatibility
// was lost, creating complexity and difficult tradeoffs for consumers of these libraries, where there may be conflicting
// requirements to use different, incompatible versions of those frameworks. We have tried to do the best we can in
// terms of supporting many possible combinations of versions, where feasible.
// <p>
// The +externalLink{https://spring.io/projects/spring-framework#learn,Spring} 5 framework
// integrated with SmartClient is only compatible with
// +externalLink{https://www.oracle.com/java/technologies/downloads/,Java} 8+,
// so you can't use older version of Java together with +link{group:springIntegration,SmartClient's built-in Spring support},
// such as the "spring:" DMI target. <b>If you have to use a Java version less than 8</b>, please see the "Using Java
// version less than 8" section at the end of this document.
// <h4>Using Hibernate 3 or 4 with Spring 5</h4>
// <p>
// The +externalLink{https://spring.io/projects/spring-framework#learn,Spring} 5 ships with
// +externalLink{https://hibernate.org/,Hibernate} 5 support only, i.e. without built-in Hibernate 3 and 4
// support it used to have.
// <p>
// SmartClient provides "bridges" that allow Spring 5 to be used with Hibernate 3 or 4.  To use this combination,
// include either <code>isomorphic_spring_hibernate-core-6.5.3.Final.jar</code> for Hibernate 3 support or
// <code>isomorphic_spring_hibernate4.jar</code> for Hibernate 4 support.
// <p>
// Smartclient bridge classes are based on Spring 4.3.26 <code>org.springframework.orm.hibernate3</code> and
// <code>org.springframework.orm.hibernate4</code> packages and are placed in corresponding packages:
// <code>com.isomorphic.springhibernate3</code> and <code>com.isomorphic.springhibernate4</code>. So, for example,
// to configure managed Hibernate SessionFactory <code><b>com.isomorphic.springhibernate3</b>.LocalSessionFactoryBean</code>
// class should be used instead of <code><s>org.springframework.orm.hibernate3</s>.LocalSessionFactoryBean</code> class:
// <pre>
// &lt;bean id="hbSpringSessionFactory"
//       className="<b>com.isomorphic.springhibernate3</b>.LocalSessionFactoryBean"&gt;
//     &lt;property name="configLocation" value="classpath:hibernate.cfg.xml"/&gt;
// &lt;/bean&gt;
// </pre>
// Other than that the usage is the same.
// <h4>Using Hibernate 5</h4>
// Hibernate 5 is not yet supported by Smartclient, but it still may be used via custom DataSource implementation, as
// is demonstrated in +externalLink{https://www.smartclient.com/smartclient/showcase/?id=ormDataSource,ORM DataSource} and
// +externalLink{https://www.smartclient.com/smartclient/showcase/?id=reusableORMDataSource,Resusable ORM DataSource}
// Showcase samples. Note that in this case Smartclient built-in Hibernate support would be lost and features like
// data pagination, server-side sorting and filtering, server summaries etc would also have to be implemented
// manually in custom DataSource if you need them.
// <p>
// <h4>Using Java version less than 8</h4>
// <p>
// With pre JDK8, you cannot use Spring 5 (according to
// +externalLink{https://github.com/spring-projects/spring-framework/wiki/Upgrading-to-Spring-Framework-5.x#upgrading-to-version-50,Spring docs}),
// so, you have to remove all Spring 5 related jars. Then, you could use Spring 4 or earlier, but without any of our framework support for Spring
// which, as of release 13.0, requires Spring 5+ (older releases work with Spring 4).
// <p>
// To remove Spring from the SmartClient server all Spring JARs must be removed from your WEB-INF/lib server directory:
// <ul>
// <li>spring-aop-6.1.15.jar
// <li>spring-beans-6.1.15.jar
// <li>spring-context-6.1.15.jar
// <li>spring-context-support-5.3.9.jar
// <li>spring-core-6.1.15.jar
// <li>spring-expression-6.1.15.jar
// <li>spring-jdbc-6.1.15.jar
// <li>spring-orm-6.1.15.jar
// <li>spring-tx-6.1.15.jar
// <li>spring-web-6.1.15.jar
// <li>spring-webmvc-6.1.15.jar
// <li>isomorphic_spring.jar
// <li>isomorphic_spring_hibernate-core-6.5.3.Final.jar
// <li>isomorphic_spring_hibernate4.jar</ul>
// <p>
// and Spring configuration must be removed from your WEB-INF/web.xml:
// <pre>
// &lt;!-- standard spring configuration --&gt;
// &lt;context-param&gt;
//     &lt;param-name&gt;contextConfigLocation&lt;/param-name&gt;
//     &lt;param-value&gt;/WEB-INF/applicationContext.xml&lt;/param-value&gt;
// &lt;/context-param&gt;
// &lt;listener&gt;
//     &lt;listener-class&gt;com.isomorphic.spring.ContextLoaderListener&lt;/listener-class&gt;
// &lt;/listener&gt;</pre>
//
// @treeLocation Concepts
// @title Integration with Spring
// @visibility external
//<



//> @groupDef hibernateIntegration
//
// SmartClient can integrate with Hibernate in two main ways, both of which are enabled by
// creating a DataSource descriptor (.ds.xml file) with
// +link{DataSource.serverType,serverType="hibernate"}:
// <ul>
// <li> Pre-existing beans: a SmartClient DataSource can be automatically derived from either a
// Hibernate-managed bean or the Hibernate mapping.  Use
// +link{dataSource.schemaBean,schemaBean} to derive from the bean or
// +link{DataSource.autoDeriveSchema} to derive from the mapping.  In this case you will
// initially have a very short .ds.xml per bean - no &lt;fields&gt; are required unless
// and until you want to override the automatically derived fields.
// <li> "Beanless" mode: SmartClient can drive Hibernate as a storage layer only, automatically
// generating Hibernate configuration from a SmartClient DataSource file
// (<i>dataSourceID</i>.ds.xml).  In this case, you do not write a Java bean or create
// Hibernate mappings; Hibernate's beanless
// +externalLink{http://docs.jboss.org/hibernate/orm/3.3/reference/en-US/html/persistent-classes.html#persistent-classes-dynamicmodels,"dynamic model"}
// mode is used.
// </ul>
// <P>
// Which mode to use is primarily a matter of preference and pre-existing code.  However, if
// you do not have pre-existing code or other special circumstances, the following approach is
// the most productive:
// <ol>
// <li> use "beanless" mode, specifying fields in SmartClient's .ds.xml format (far more
// compact than a Java bean with a getter and setter for each field)
// <li> add business logic as needed via DMI, Server Scripting, custom server validators, and
// other approaches covered in the QuickStart Guide
// <li> call any reusable DMI methods both via your SmartClient UI and via other, non-UI
// related Java logic (the DMI methods are now a reusable "data services tier")
// <li> only create an actual Java bean if you discover re-usable, bean-specific business
// logic that cannot be encapsulated as a data service (rare)
// </ol>
// <P>
// Note that the +link{group:adminConsole,Admin Console}'s
// "Import DataSources" section can be used to import test data into serverType:"hibernate"
// DataSources in the same manner as SQLDataSources.
// <p>
// HibernateDataSource supports operations with composite primary keys. Setting data source level property
// +link{attr:dataSource.idClassName,idClassName} to fully qualified class name indicates,
// that entity uses composite primary key.
// <p>
// <h3>Beans and the DSRequest / DSResponse</h3>
// <p>
// In case of "pre-existing beans" approach, see +link{hbBeans} for the information how incoming
// DSRequest data is used and what to expect in DSResponse.
// <p>
// <h3>Hibernate relations</h3>
// <p>
// For Hibernate integration where Java beans have been explicitly declared,
// HibernateDataSource supports automatic handling of Hibernate relations that don't declare a
// concrete field to hold ID values - see +link{group:jpaHibernateRelations}.
// <p>
// <h3>Hibernate Configuration</h3>
// <p>
// You can provide Hibernate configuration to the SmartClient server in three ways:
// <ul>
// <li>You can place a traditional <code>hibernate.cfg.xml</code> file somewhere on the
//     classpath</li>
// <li>You can have SmartClient look up a Hibernate <code>Configuration</code> to use.  This
//     works in the same way as a +link{ServerObject}, and in fact makes use of the
//     ServerObject code, though note that lookupStyle "attribute" is not supported.  To look
//     up a configuration, add ServerObject-compliant properties to your
//     +link{group:server_properties,server.properties} file, prefixed with <code>hibernate.config</code>.  For
//     example: <pre>
//        hibernate.config.lookupStyle: spring
//        hibernate.config.bean: mySessionFactory
// </pre></li>
// <li>You can provide a Hibernate configuration at the level of individual DataSources, by
//     specifying a +link{DataSource.configBean,configBean} on the dataSource (this is only
//     applicable if you are using Spring; see below)</li>
// </ul>
// If you choose to have SmartClient lookup the Hibernate configuration, and you specify a
// +link{serverObject.lookupStyle,lookupStyle} of "spring", SmartClient will make use of a
// Hibernate <code>SessionFactory</code> configured by Spring.  It is possible to set up multiple
// Hibernate configurations in Spring, and to map individual DataSources to different
// configurations by making use of the <code>dataSource.configBean</code> property mentioned
// above.  Please note the following caveats:
// <ul>
// <li>DataSource-level Hibernate configuration is intended for unusual cases, such as when the
//     physical data store for one DataSource is actually a different database.  Hibernate
//     relations between entities with different configurations do not work</li>
// <li>If you choose to configure Hibernate via Spring, "beanless" on-the-fly
//     mappings are not supported; all entities must be hand-mapped to a bean, either in the
//     properties of the Spring bean providing the configuration, in a <code>.cfg.xml</code>
//     file named in the Spring bean's <code>configLocation</code> property, or by use of
//     persistence annotations in the actual mapped beans themselves</li>
// </ul>
// <p>
// <h3>Inbound DSRequest data will use numeric field types from your bean</h3>
// <p>
// For fields with numeric types, the +link{dsRequest.data,record data} in DSRequests will
// automatically be converted to the type of the target field, before the request is received
// in a +link{DMI}.  For details, see +link{group:dsRequestBeanTypes}.
// <p>
// <h3>Manual Hibernate Integration</h3>
// <p>
// In some cases you may not be able to immediately use the built-in HibernateDataSource - in
// this case take a look at +link{group:manualJpaHibernate,manual Hibernate integration}.
//
// @see attr:dataSource.beanClassName
// @see group:sqlConnectionPooling
// @treeLocation Concepts/Persistence Technologies
// @title Integration with Hibernate
// @visibility external
//<

//> @groupDef jpaIntegration
// To use JPA, set serverType="jpa" in your .ds.xml file, then set
// +link{attr:dataSource.beanClassName,beanClassName} to the fully qualified class name of the
// JPA entity.  For example:
// <pre>
// &lt;DataSource
//     ID="countryDS"
//     serverType="jpa"
//     beanClassName="com.smartgwt.sample.showcase.server.jpa.Country"
// &gt;
//     &lt;fields&gt;
// &lt;!-- ... Fields definition ... --&gt;
//     &lt;/fields&gt;
// &lt;/DataSource&gt;
// </pre>
// +link{DataSource.autoDeriveSchema} is supported for deriving DataSource fields from JPA
// entities automatically (except with JPA 1.0; see below).
// <p>
// Full support is provided for executing simple +link{Criteria}, with +link{AdvancedCriteria}
// supported if you have Power Edition or above.  However, note that there are limitations with case
// sensitive search in MySQL since MySQL automatically uses the 'like' operator in a
// case-insensitive manner and JPA does not correct this.  See <a
// href="http://dev.mysql.com/doc/refman/5.5/en/case-sensitivity.html">MySQL Reference Manual
// :: C.5.5.1 Case Sensitivity in String Searches</a> for more information.<p/>
// <p>
// If create a custom DataSource based on the built-in JPA functionality, subclass
// <code>com.isomorphic.jpa.JPA2DataSource</code>.
// <p>
// <h3>Beans and the DSRequest / DSResponse</h3>
// <p>
// In case of "pre-existing beans" approach, see +link{hbBeans} for the information how incoming
// DSRequest data is used and what to expect in DSResponse.
// <p>
// <h3>JPA relations</h3>
// <p>
// For JPA integration where Java beans have been explicitly declared,
// JPADataSource supports automatic handling of JPA relations that don't declare a
// concrete field to hold ID values - see +link{group:jpaHibernateRelations}.
// <p>
// <h3>JPA configuration</h3>
// <p>
// JPA configuration should be specified in the <code>persistence.xml</code> file as usual, and placed
// in the <code>/WEB-INF/classes/META-INF</code> directory.  For JPA 2.0 make sure you correctly
// declare its usage in <code>persistence.xml</code>:<pre>
// &lt;persistence
//     version="2.0"
//     xmlns="http://java.sun.com/xml/ns/persistence"
//     xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance"
//     xsi:schemaLocation="http://java.sun.com/xml/ns/persistence
//                         http://java.sun.com/xml/ns/persistence/persistence_2_0.xsd"
// &gt;
// ...
// &lt;/persistence&gt;</pre><br/>
// <P>
// JPADataSource supports operations with composite primary keys. Setting data source level property
// +link{attr:dataSource.idClassName,idClassName} to fully qualified class name indicates,
// that entity uses composite primary key.
// <P>
// JPADataSource supports automatic handling of JPA relations that don't declare a concrete
// field to hold ID values - see +link{group:jpaHibernateRelations}.
// <P>
// <h3>JPA 1.0 compatibility</h3>
// <P>
// To use JPA 1.0, set serverType="jpa1" instead.  JPA 1.0 does not support
// +link{dataSource.autoDeriveSchema}.  For JPA 1.0, the concrete implementation class (for subclassing to
// create a custom DataSource) is <code>com.isomorphic.jpa.JPADataSource</code>.
// <p>
// <h3>JPA transactions</h3>
// <p>
// JPA provides three mechanisms for transactions: for JEE applications JPA provides integration
// with JTA (Bean Managed Transactions and Container Managed Transactions); for JSE applications JPA has a native
// <code>EntityTransaction</code> implementation (Locally Managed Transactions). Spring framework is another popular
// way for declaring transactions in application.
// The transaction mechanism should be configured in the +link{group:server_properties,server.properties}
// file by setting
// property <b><code>jpa.emfProvider</code></b> to the fully qualified class name of the provider
// (implementation of <code>com.isomorphic.jpa.EMFProviderInterface</code>). SmartClient comes
// with five implementations:<ul>
// <li><b><code>com.isomorphic.jpa.EMFProviderLMT</code></b> - for Locally Managed Transactions.
//      Every fetch or DML operation starts a new transaction and commits after successful
//      execution.<br/>
//      This implementation reads the <b><code>jpa.persistenceUnitName</code></b> property from
//      the +link{group:server_properties,server.properties} file.  The value of this property needs
//      to be set to
//      the name of the persistence unit configured in <code>persistence.xml</code> file. For example:<pre>
// jpa.persistenceUnitName: PERSISTENCE_UNIT_NAME
//      </pre></li>
// <li><b><code>com.isomorphic.jpa.EMFProviderBMT</code></b> - for Bean Managed Transactions.
//      Every fetch or DML operation acquires the transaction object from the container and starts it.<br/>
//      This implementation reads two properties from the +link{group:server_properties,server.properties}
//      file:
//      <b><code>jpa.entityManager</code></b> and <b><code>jpa.entityManagerFactory</code></b>
//      containing appropriate resource name references configured in
//      <code>/WEB-INF/web.xml</code>. Configuration example:<pre>
// &lt;!-- EntityManager resource reference name declaration --&gt;
// &lt;persistence-context-ref&gt;
//    &lt;persistence-context-ref-name&gt;persistence/em&lt;/persistence-context-ref-name&gt;
//    &lt;persistence-unit-name&gt;PERSISTENCE_UNIT_NAME&lt;/persistence-unit-name&gt;
// &lt;/persistence-context-ref&gt;
//
// &lt;!-- EntityManagerFactory resource reference name declaration --&gt;
//  &lt;persistence-unit-ref&gt;
//      &lt;persistence-unit-ref-name&gt;persistence/emf&lt;/persistence-unit-ref-name&gt;
//      &lt;persistence-unit-name&gt;PERSISTENCE_UNIT_NAME&lt;/persistence-unit-name&gt;
//  &lt;/persistence-unit-ref&gt;
//
// #Property values for sample references:
// jpa.entityManager: persistence/em
// jpa.entityManagerFactory: persistence/emf
//      </pre></li>
// <li><b><code>com.isomorphic.jpa.EMFProviderCMT</code></b> - for Container Managed Transactions.
//      Every fetch or DML operation acquires the transaction object from the JEE container.
//      After successful method execution the container commits the transaction. In case of execution
//      failure <code>tx.setRollbackOnly()</code> is used to notify container to rollback the
//      transaction.<br/>
//      This implementation reads two properties from the +link{group:server_properties,server.properties}
//      file:
//      <b><code>jpa.entityManager</code></b> and <b><code>jpa.entityManagerFactory</code></b>
//      containing appropriate resource name references configured in
//      <code>/META-INF/ejb-jar.xml</code>. Configuration example:<pre>
// &lt;?xml version="1.0" encoding="UTF-8"?&gt;
// &lt;ejb-jar
//      version = "3.0"
//      xmlns = "http://java.sun.com/xml/ns/javaee"
//      xmlns:xsi = "http://www.w3.org/2001/XMLSchema-instance"
//      xsi:schemaLocation = "http://java.sun.com/xml/ns/javaee http://java.sun.com/xml/ns/javaee/ejb-jar_3_0.xsd"&gt;
//      &lt;enterprise-beans&gt;
//          &lt;session&gt;
//              &lt;ejb-name&gt;TestEJB&lt;/ejb-name&gt;
//              &lt;persistence-context-ref&gt;
//                  &lt;persistence-context-ref-name&gt;persistence/em&lt;/persistence-context-ref-name&gt;
//                  &lt;persistence-unit-name&gt;PERSISTENCE_UNIT_NAME&lt;/persistence-unit-name&gt;
//              &lt;/persistence-context-ref&gt;
//              &lt;persistence-unit-ref&gt;
//                  &lt;persistence-unit-ref-name&gt;persistence/emf&lt;/persistence-unit-ref-name&gt;
//                  &lt;persistence-unit-name&gt;PERSISTENCE_UNIT_NAME&lt;/persistence-unit-name&gt;
//              &lt;/persistence-unit-ref&gt;
//         &lt;/session&gt;
//     &lt;/enterprise-beans&gt;
// &lt;/ejb-jar&gt;
//
// #Property values for sample references:
// jpa.entityManager: persistence/em
// jpa.entityManagerFactory: persistence/emf
//      </pre></li>
// <li><b><code>com.isomorphic.jpa.EMFProviderNoTransactions</code></b> - transactions are
//      not used.<br/>
//      From the +link{group:server_properties,server.properties} file this implementation reads the
//      <b><code>jpa.persistenceUnitName</code></b> property which must containt the name of persistence unit
//      configured in <code>persistence.xml</code> file. For example:<pre>
// jpa.persistenceUnitName: PERSISTENCE_UNIT_NAME
//      </pre></li>
// <li><b><code>com.isomorphic.jpa.EMFProviderSpring</code></b> - for Spring Framework managed Transactions.
//      Every fetch or DML operation acquires the transaction object from the Spring Application Context.<br/>
//      This implementation reads two properties from the +link{group:server_properties,server.properties}
//      file:
//      <b><code>jpa.entityManagerFactory</code></b> and <b><code>jpa.transaction</code></b>
//      containing appropriate bean names configured in Spring Application Context.
//      You have to declare additional bean in your Spring Application Context to allow SmartClient
//      to acquire reference to context.
//      Configuration example:<pre>
// &lt;!-- SpringApplicationContextProvider bean definition required to get access to application context. --&gt;
// &lt;bean id="springApplicationContextProvider" class="com.isomorphic.spring.SpringApplicationContextProvider" /&gt;
//
// &lt;!-- Connection to data base --&gt;
// &lt;bean id="dataSource"
//      class="org.springframework.jdbc.datasource.DriverManagerDataSource"
//      p:driverClassName="DRIVER_CLASS"
//      p:url="CONNECTION_URL"
//      p:username="DB_USER_NAME"
//      p:password="DB_USER_PASSWORD" /&gt;
//
// &lt;!-- Reference to JPA EntityManagerFactory --&gt;
// &lt;bean id="entityManagerFactory" class="org.springframework.orm.jpa.LocalContainerEntityManagerFactoryBean"&gt;
//     &lt;property name="dataSource" ref="dataSource" /&gt;
//     &lt;property name="jpaVendorAdapter"&gt;
//        &lt;bean class="org.springframework.orm.jpa.vendor.HibernateJpaVendorAdapter"&gt;
//            &lt;property name="database" value="DB_TYPE" /&gt;
//        &lt;/bean&gt;
//     &lt;/property&gt;
//     &lt;property name="persistenceUnitName" value="PERSISTENCE_UNIT_NAME" /&gt;
// &lt;/bean&gt;
//
// &lt;!-- Reference to JpaTransactionManager --&gt;
// &lt;bean id="transactionManager" class="org.springframework.orm.jpa.JpaTransactionManager"&gt;
//     &lt;property name="entityManagerFactory" ref="entityManagerFactory" /&gt;
// &lt;/bean&gt;
//
// #Property values for sample bean names:
// jpa.entityManagerFactory: entityManagerFactory
// jpa.transaction: transactionManager
//      </pre></li>
// </ul>
// You can set <b><code>jpa.emfProvider</code></b> to your own implementation of
// <code>com.isomorphic.jpa.EMFProviderInterface</code> if you have specific requirements for
// transaction handling. <code>EMF</code> will instantiate provided implementation on initialization (static) and
// will use same instance every time. By using own implementation you can have complete control over creating/using
// <code>EntityManagerFactory</code> and <code>EntityManager</code> instances.<p/>
// <b>Additional configurations:</b><p/>
// In case you have several persistence units defined in your <code>persistence.xml</code> you can have additional
// configurations in +link{group:server_properties,server.properties} file. Additional configurations
// (prefixed with <b><code>jpa.</code></b>) should have name, <b><code>emfProvider</code></b> property and other
// properties required by specified EMF provider implementation.
// For example:<pre>
// jpa.configName.emfProvider: com.isomorphic.jpa.EMFProviderLMT
// jpa.configName.persistenceUnitName: ANOTHER_PERSISTENCE_UNIT_NAME</pre>
// To use additional JPA configuration you have to set <b><code>jpaConfig</code></b> property in data source
// definition:<pre>
// &lt;DataSource
//     ID="countryDS"
//     serverType="jpa"
//     beanClassName="com.smartgwt.sample.showcase.server.jpa.Country"
//     jpaConfig="configName"
// &gt;</pre>
// <b>Transaction management:</b>
// <p/><ul>
// <li>Operating under +link{RPCManager} (<code>+link{DSRequest}</code> has reference to
//   <code>+link{RPCManager}</code>):<ul>
//      <li>If participating in automatic transactions:<ul>
//          <li>retrieves existing transaction from <code>+link{RPCManager}</code> (if available);</li>
//          <li>starts new transaction (if not found in <code>+link{RPCManager}</code>);</li></ul></li>
//      <li>If one transaction per operation is used - starts new transaction;</li>
//      <li>Registers itself to <code>DSRequest.registerCallback()</code> for <code>onSuccess()</code>/
//      <code>onFailure()</code> execution to commit/roll back transaction;</li>
//      <li>Sets <code>DSRequest.setFreeOnExecute()</code> to <code>false</code> to postpone releasing
//          of <code>EntityManager</code> avoiding lazy loading exceptions when creating JS response and
//          traversing through persistent object tree;</li>
//      <li>Registers itself to <code>RPCManager.registerFreeResourcesHandler()</code> for <code>freeResources()</code>
//      execution to release <code>EntityManager</code>.</li></ul><br/>
// If you want to use same <code>EntityManager</code> and transaction in your custom data source implementation you can
// acquire it by <pre>JPAConnectionHolder holder = DataSource.getTransactionObject(req, EMF.TRANSACTION_ATTR);</pre>
// <code>JPAConnectionHolder</code> instance contains references to entity manager and transaction object
// used by <code>JPADataSource</code>. You should never commit/rollback automatic transaction.
// Overall commit/rollback will be issued by <code>RPCManager</code> and will be handled by <code>JPADataSource</code>
// object which started transaction.
// </li>
// <li>Operating without +link{RPCManager}:<ul>
//      <li>starts new transaction;</li>
//      <li>commits/rolls back transaction and releases <code>EntityManager</code> if
//          <code>DSRequest.setFreeOnExecute()</code> is set to <code>true</code> (defalut);</li>
//      <li>relies on calling code to call <code>onSuccess()</code>/<code>onFailure()</code> to commit/roll back
//          transaction and to call <code>freeResources()</code> to release <code>EntityManager</code>.<br/>
//          Example code for data source operation execution with manual transaction handling:
//          <pre>
//              DSRequest req = new DSRequest("myDS", "fetch");
//              req.setFreeOnExecute(false);
//              DSResponse resp = req.execute();
//              List dataList = resp.getDataList();
//              //... traverse through persistent object tree
//              // Commit current transaction.
//              ((JPADataSource) r.getDataSource()).onSuccess();
//              // Release entity manager.
//              ((JPADataSource) r.getDataSource()).freeResources(req);
//          </pre></li></ul>
// </li></ul>
// <p>
// <h3>Inbound DSRequest data will use numeric field types from your bean</h3>
// <p>
// For fields with numeric types, the +link{dsRequest.data,record data} in DSRequests will automatically
// be converted to the type of the target field, before the request is received in a +link{DMI}.  For
// details, see +link{group:dsRequestBeanTypes}.
// <p>
// <h3>Manual JPA Integration</h3>
// <p>
// In some cases you may not be able to immediately use the built-in JPADataSource - in
// this case take a look at +link{group:manualJpaHibernate,manual Hibernate integration}.
//
// @see group:sqlConnectionPooling
// @treeLocation Concepts/Persistence Technologies
// @title Integration with JPA
// @visibility external
//<

//> @groupDef jpaHibernateRelations
// JPA and Hibernate allow relations to be declared between entities where there is no actual
// Java field for storing the ID of a related entity, even though such a column exists in the
// database.  For example:
// <pre>
//    &#64;ManyToOne
//    &#64;JoinColumn(name="countryId", referencedColumnName="countryId")
//    private Country country;
// </pre>
// JPADataSource and HibernateDataSource support this style of declaration and will
// automatically handle mapping between IDs and entities.
// <p>
// The example above and the following examples assume a DataSource "country" for a
// JPA/Hibernate entity "Country" with an Id field of "countryId", and a DataSource "city" for a
// JPA/Hibernate entity "City" with an Id field of "cityId".
// <p>
// <h3>Many-To-One Relations</h3>
// <p>
// An example of Many-To-One is that Many "City"s belong to One "Country".  In Java, each City
// bean has a field of type Country.  In the database, rows for cities and countries are linked
// by ID.
// <p>
// To specify a many-to-one relation, declare a DataSourceField named after the Java field that
// declares the relation ("country" above) with the property
// +link{attr:DataSourceField.foreignKey,foreignKey} pointing to related DataSource's primary key:
// <pre>
//    &lt;field name="country" foreignKey="country.countryId"/&gt;
// </pre>
// When delivered to the browser, the value of the <code>country</code> field will be the ID of
// the related Country entity.  The <code>country</code> field can be treated as a normal text
// or integer field value, for example, you can use a +link{SelectItem} that uses
// +link{SelectItem.optionDataSource} to allow selecting the ID of a different related
// entity.  Then, when the new ID is saved to the server, JPADataSource automatically looks up
// the related object and persists the new relation to JPA.
// <p>
// <b>NOTE:</b>: do not declare a "type" attribute for such a field - these fields provide
// specialized mapping between IDs and JPA/Hibernate entities, so don't really have a single
// concrete type.
// <p>
// If you want fields from a related entity to be included whenever your entity is fetched, for
// example, whenever a city is fetched you want the <code>countryName</code> fetched from the
// related <code>country</code> entity, use +link{DataSourceField.includeFrom}.
// <p>
// <b>Automatic Criteria translation</b>
// <p>
// If criteria are submitted for a ManyToOne relation field containing an ID value, this will
// correctly return Records that are associated with the related object that has that ID.
// <p>
// For example, given a countryId of "1", you can fetch all city Records that are related to
// that countryId as follows:
// <smartclient>
// <pre>
//   isc.DataSource.get("city").fetchData({ countryId: 1 }, &lt;callback/&gt);
// </pre>
// </smartclient>
// <smartgwt>
// <pre>
//    DataSource.get("city").fetchData(new Criteria("countryId", "1"), &lt;callback/&gt);
// </pre>
// </smartgwt>
// <p>
// <h3>One-to-Many Relations</h3>
// <p>
// An example of One-To-Many relation is that One "Country" has Many "City"'s.  Each "Country"
// has a list of cities within it, which may be declared as a Java bean property of Collection
// type (or List, Set, etc).
// <p>
// To specify a one-to-many relation, declare a DataSourceField that:
// <ul>
// <li> is named after the Java field that declares the OneToMany relation (whose type is a
//      Collection of the related entities)
// <li> declares its "type" to be the ID of the related DataSource
// <li> declares a +link{attr:DataSourceField.foreignKey,foreignKey} pointing to the related
//      DataSource's primaryKey field
// <li> sets multiple="true"
// </ul>
// For example, for a Country bean that has a Collection of City beans:
// <pre>
//     &lt;field name="cities" type="city" multiple="true" foreignKey="city.cityId"/&gt;
// </pre>
// With this declaration, whenever Records are loaded from the Country DataSource, they will
// contain a list of City Records as subobjects, accessible via
// <smartgwt><code>countryRecord.getAttributeAsRecordList("cities")</code></smartgwt>
// <span class="client">countryRecord.cities</span>
// <p>
// If loading all related "city" records is desirable in some circumstances and not others, you
// can use +link{operationBinding.outputs} to avoid loading "city" records for certain
// operations.
// <p>
// <h3>Many-To-Many Relations</h3>
// An example of Many-To-Many relation is that Students have multiple Courses and each Course has
// multiple Students. In Java each Student bean has a list of Courses and each Course bean has a
// list of Students. In database tables are linked using additional table holding references to
// both students and courses.
// <P>
// To set up Many-To-Many relation between data sources you need to set up One-To-Many relation on
// both sides.
// <P>
// For example students DataSourceField for CourseDS data source:
// <pre>
//     &lt;field name="students" type="integer" foreignKey="StudentDS.id" multiple="true" /&gt;
// </pre>
// and courses DataSourceField for StudentDS data source:
// <pre>
//     &lt;field name="courses" type="integer" foreignKey="CourseDS.id" multiple="true" /&gt;
// </pre>
// Note that type attribute can be safely omitted here.
// <P>
// <b>Note</b> that alternative type declaration to be ID of related data source (as in regular
// One-To-Many relation case) would work as expected, but is <b>not recommended</b> to use, cause
// it would result in getting lots of copies of same data. Smartclient server will prevent infinite
// loops, but still lots of unnecessary data will be sent to client.
// <P>
// <h3>Alternative: Many-To-One loading complete related object</h3>
// <p>
// For a Many-To-One relation, instead of loading just the ID of the related object, you can
// load the entire related object as a nested Record.  To do so, just declare the type of the
// field to be the ID of the related DataSource, rather than leaving type unset:
// <pre>
//     &lt;field name="country" type="country" foreignKey="country.countryId"/&gt;
// </pre>
// The nested "country" Record will be available on a "city" record via
// <smartgwt><code>cityRecord.getAttributeAsRecord("country")</code></smartgwt>
// <smartclient>cityRecord.country</smartclient>.
// Saving a City record that contains a nested Country record in the "country"
// attribute will result in the Country being updated in JPA/Hibernate.
// <P>
// This mode is not typically used, since loading just the ID of the related Country object is
// more efficient if many cities are being loaded, and the related Country object can always be
// loaded with a second fetchData() data, which can still be done in a single HTTP request via
// +link{isc.RPCManager.startQueue(),queuing}.
// <P>
// <h3>Alternative: One-To-Many loading related IDs</h3>
// <p>
// For a One-To-Many relation, instead of loading the complete list of related objects, you can
// load just a list of their IDs.  To do so, just omit the type declaration when declaring the
// relation:
// <pre>
//    &lt;field name="cities" multiple="true" foreignKey="city.cityId"/&gt;
// </pre>
// When saving, if a replacement list of IDs is included in the Record, the appropriate
// JPA/Hibernate relationships will be updated.
// <P>
// This is very rarely used, and would typically only be used by client-side code that plans to
// programmatically work with the list of related IDs rather than display them in a UI
// component.
// <p>
// <h3><b>NOTE:</b> Bidirectional relations</h3>
// <p>
// When relations are declared, JPA and Hibernate consider only one of the two entities to be
// the "owner" of the relation, meaning essentially that the references that make up the
// relationship are stored with that entity.  When performing updates, make sure you update the
// entity that "owns" the relation.  All changes to relations on "non-owning" entities are
// silently discarded.
// <p>
// <h3>Search criteria on One-to-Many and Many-to-Many relations</h3>
// <p>
// The following +link{Operator,search operators} are supported with the behaviors listed
// below.  For simple Criteria, criteria values are treated identically to the "equals"
// operator and the +link{dsRequest.textMatchStyle,textMatchStyle} is ignored.
// <P>
// Examples are given in terms of a "country" DataSource that has a one-to-many relation with a "city"
// DataSource through a relation field called "cities"
// <p>
// <table border=1 class="normal">
// <tr>
// <td>Operator</td><td>Behavior</td>
// </tr>
// <tr>
// <td><code>isNull</code></td><td>matches country records which have no related cities</td>
// </tr>
// <tr>
// <td><code>notNull</code></td><td>matches country records which have at least one related city</td>
// </tr>
// <tr>
// <td><code>equals, notEqual</code></td><td>
// <code>criterion.value</code> should be a primaryKey value for the related
// city DataSource.  This criterion matches any country which
// contains the passed city (or for "notEqual", matches any country which
// <b>does not</b> contain the passed city.
// </td>
// </tr>
// <tr>
// <td><code>inSet, notInSet</code></td><td>
// <code>criterion.value</code> should an array of primaryKey values for the
// related city DataSource.  This criterion matches any country which
// contains <b>any</b> of the passed cities (or for "notInSet", which
// contains <b>none</b> of the passed cities).</td>
// </tr>
// </table>
// The following is an example of a criterion for matching a "country" records which have related
// cities with primaryKey values 1, 2 or 3 (shown serialized as JSON):
// <pre>
//   {fieldName:"cities", operator:"inSet", value:[1,2,3]}
// </pre>
// As an alternative syntax, "equals", "notEqual", "inSet" and "notInSet" will also allow
// <code>criterion.value</code> to be specified as a list of Objects, each containing the
// primaryKey field and its value:
// <pre>
//      {fieldName:"cities",operator:"inSet",value:[{cityId:1},{cityId:2},{cityId:3}]}
// </pre>
// The operators explained above work the same way for Many-To-Many relation fields.
// <p>
// Any other operator applied to a relation field will cause a warning to be logged, and will be
// treated as though the criterion were not present (matches all records).
//
// @treeLocation Concepts/Persistence Technologies
// @title JPA &amp; Hibernate Relations
// @visibility external
//<

//> @groupDef manualJpaHibernate
// In some cases you may not be able to immediately use the built-in JPADataSource or
// HibernateDataSource.  For example, you have pre-existing business logic that already
// directly calls JPA or Hibernate APIs, and it may seem to be a large task to refactor this
// logic so that the built-in DataSources can be used.
// <p>
// In this case you can use the overall approach described in
// +link{group:serverDataIntegration} to connect to your pre-existing business logic.  You will
// not be leveraging any of the built-in JPA or Hibernate functionality, so the approach and level of
// effort will be the same as if you were using a non-Hibernate ORM or integrating with
// entirely custom Java classes.
// <P>
// +explorerExample{reusableORMDataSource,This example} shows a Hibernate-based implementation of
// a custom DataSource that implements support for simple Criteria, sorting and data paging,
// but not +link{AdvancedCriteria}, +link{dataSourceField.includeFrom,automatic joins},
// automatic transactions or many other features built into HibernateDataSource.
// <P>
// Because these features are very valuable and more features are added to the built-in
// DataSources all the time, it's recommended that you refactor your code to use the built-in
// DataSources as soon as you can; refactoring existing business logic as validators, DMIs, or
// custom DataSources is often easier than it looks.
// <P>
// You can also take the approach of using the built-in DataSources for new entities or
// entities where there is currently no significant business logic, while continuing to use
// your existing code where it's non-trivial to refactor.
//
// @title Manual JPA &amp; Hibernate Integration
// @treeLocation Concepts/Persistence Technologies
// @visibility external
//<

//> @groupDef hbBeans
//
// This section relates to JPA and Hibernate datasources and describes how submitted data
// is used and what to expect in <code>DSResponse</code> if Smartclient is integrated with
// Hibernate using "Pre-existing beans" approach (see +link{hibernateIntegration} for details).
// <p>
// Note that "beanless" integration mode is completely omitted here, since in that case data is
// represented by <code>Maps</code> instead of <code>Beans</code>.
// <p>
// <h3>Data sent in DSRequest</h3>
// In case of add or update operations +link{dsRequest.data,DSRequest data} is used to populate
// associated <code>Bean</code>:
// <ul>
//   <li>add - new <code>Bean</code> is created and filled with submitted data</li>
//   <li>update - existing <code>Bean</code> is retrieved and then submitted data is set overwriting
// existing values</li>
// </ul>
// New values are applied using <code>DataSource.setProperties(...)</code> server-side API, which performs
// automatic conversions of any types that can reasonably be auto-converted, supports inner beans and
// recursive data structures, see server-side javadocs for details.
// <p>
// <h3>Data returned in DSResponse</h3>
// In case of getting access to DSResponse (for example, by manually executing DSRequest in a +link{dmi}),
// DSResponse data can be accessed by calling <code>DSResponse.getData()</code> server-side API. See what
// data will be returned depending on +link{dsRequest.operationType,operation type} and other circumstances:
// <p>
// <table border="1" class="normal" width="90%" cellpadding="5">
// <tr>
//   <td>Operation type</td>
//   <td>DSResponse data</td>
// </tr><tr>
//   <td width="20%">Fetch</td>
//   <td>Generally fetch operation will return <code>List</code> of <code>Beans</code> or empty
// <code>List</code> if no records were found. However some features, if used, do break this rule:
//     <ul>
//       <li>If +link{dsRequest.outputs} (or +link{operationBinding.outputs}) is set, then only
// fields listed in outputs are fetched from Database and, accordingly, DSResponse data will return
// <code>List</code> of <code>Maps</code> each <code>Map</code> holding only requested set of
// field/value pairs.</li>
//       <li>If Server Summaries feature is used, then DSResponse data will also return
// <code>List</code> of <code>Maps</code> each <code>Map</code> holding only field/value pairs
// involved in summary query, i.e. only fields listed in +link{dsRequest.groupBy} and
// +link{dsRequest.summaryFunctions}, see +link{serverSummaries,Server Summaries overview} for details.<p>
//     </ul>
//   </td>
// </tr><tr>
//   <td width="20%">Add</td>
//   <td>
//     Add operation will return created <code>Bean</code>.
//   </td>
// </tr><tr>
//   <td width="20%">Update</td>
//   <td>
//     If multiple records update is allowed (see +link{operationBinding.allowMultiUpdate} and
// +link{MultiUpdatePolicy}}), then update operation will return <code>List</code> of <code>Beans</code>,
// or empty <code>List</code> if no records were actually updated. If multiple records update is not
// allowed, then update operation will return updated <code>Bean</code>, or <code>null</code> if
// record was not updated (for example, in case if it does not exist).
//   </td>
// </tr><tr>
//   <td width="20%">Remove</td>
//   <td>
//     If multiple records update is allowed, then remove operation will always return <code>null</code>. If
// multi records update is not allowed, then remove operation will return a <code>Map</code> holding field/value
// pairs for +link{dataSourceField.primaryKey, Primary Key fields} of the record requested to be removed, no matter
// if the record was actually removed. Consult <code>DSResponse.getAffectedRows()</code> server-side API to see if
// the record was removed, or how many records were removed in case of multiple records removal.
//   </td>
// </tr>
// </table>
//
// @treeLocation Concepts/Persistence Technologies
// @title Beans and the DSRequest / DSResponse
// @visibility external
//<

//> @groupDef dsRequestBeanTypes
//
// For fields with numeric types, the +link{dsRequest.data,record data} in DSRequests will
// automatically be converted to the type of the target field, before the request is received
// in a +link{DMI}.
// <p>
// For example, if +link{dataSource.beanClassName,your bean} has a field "price" of type Float,
// an "update" DSRequest with a new value for this field will use the Java Float type for the
// new value, whereas in the absence of a bean, the Double type would ordinarily be used
// (see +link{rpcRequest.data}).
// <p>
// This happens only for fields of type <i>integer</i>, <i>sequence</i>, <i>intEnum</i> and
// <i>float</i>. Because the conversion is performed as part of server-side validation, it
// applies only to "update" or "add" requests, and does not apply to +link{dsRequest.oldValues},
// which will continue to use the generic types listed in +link{rpcRequest.data}.
// <P>
// Note that, while values for non-numeric fields will still use basic Java types (for example,
// values for Java Enum fields will arrive +link{dataSource.enumTranslateStrategy,as Strings by
// default}), manual conversion of the remaining data is not necessary; the server-side API
// <code>DataSource.setProperties()</code> does all remaining conversion necessary to populate
// a bean from the request data (see that API's docs for details), and this conversion
// will be performed automatically if your DMI logic calls <code>execute()</code> on the DSRequest.
// <P>
// You may need to explicitly define what Java type must be used during conversion for a given
// field. This can be achieved by setting +link{dataSourceField.javaClass} property.
// <p>
// If conversion fails, because of target field using an abstract Java type or invalid
// class defined in DSField.javaClass property etc, conversion will fall back to its
// default behavior, i.e. Java type will be guessed from the actual field value.
// It would be Long for integer based types and Double for float type or, if the value would
// appear to exceed the ranges of these types, BigInteger and BigDecimal accordingly.
//
// @title DSRequest data auto-converted to bean types
// @visibility external
//<

//> @groupDef gaeIntegration
// Google App Engine (GAE) is a platform-as-a-service (PaaS) offering from Google, which
// supports cloud deployment of applications written in Java and other languages, as well as
// SQL or JPA access to highly scalable storage (both Google CloudSQL and BigTable-based
// solutions).
// <p>
// SmartClient applications, including those based on the SmartClient Server Framework, can be
// deployed to GAE and can integrate with Google CloudSQL either via SQLDataSource or via JPA,
// and can also use Google's BigTable-based storage via JPA.
// <P>
// For further information, setup instructions and example configuration, see our
// +externalLink{http://wiki.smartclient.com/display/Main/Google+App+Engine,public wiki}
//
// @see group:jpaIntegration
// @treeLocation Concepts/Persistence Technologies
// @title Google Application Engine (GAE)
// @visibility external
//<

//> @groupDef sqlConnectionPooling
// <b>This discussion applies primarily to the built-in SQL DataSource provided in Pro and
// better editions of SmartClient, though elements of it also apply to the built-in Hibernate
// and JPA DataSources</b>
// <p>
// SQLDataSource communicates with database products using
// <a href=http://docs.oracle.com/javase/7/docs/api/java/sql/Connection.html>JDBC Connection
// objects</a>.  These Connections are provided by the individual database products' JDBC
// drivers; they either wrap the database's native mechanism for a client-server connection,
// or they implement a pure Java equivalent of the same thing.  All read and update operations
// performed by SQL DataSource take place via one of these connections.  Also,
// +link{DataSource.autoJoinTransactions,SQL transactions} are implemented by having the queue
// of related updates take place through the same connection, with a single commit (or
// rollback) at the end of the queue.
// <p>
// Database connections are a limited resource, and they can also be expensive to acquire.  For
// both of these reasons, SmartClient by default uses the Apache DBCP pooling library to
// maintain a pool of resuable connections; alternatively, we can use the HikariCP library
// for the same purpose - see below.  Connections are borrowed from the pool as required,
// and returned to the pool when they are no longer needed, and the pooling library ensures that
// connections are only lent out to one borrowing process at any given time.  This arrangement
// is efficient in terms of both connection acquisition speed and the number of connections
// required<ul>
// <li>Reusing an existing connection is typically faster than asking the database for a new
// one; depending on the database, it can be much faster</li>
// <li>Reusing the same connections over and over means that applications require fewer
// connections to handle the same workload.  Even busy applications handling hundreds of
// concurrent users typically require a much smaller number of pooled connections than might
// be thought at first glance</li>
// </ul>
// For these reasons, we ship SmartClient with connection pooling switched on, and we recommend
// you leave it that way.
// <h3>Connection pool settings - DBCP</h3>
// You configure the behavior of DBCP-based SQL connection pooling with the following
// <code>server.properties</code> settings (note, many of these settings map directly to
// settings in the underlying DBCP library; you can find out more about their effects in the
// <a href=http://commons.apache.org/proper/commons-dbcp/configuration.html>DBCP docs</a>.
// Also note these settings are specific to DBCP and have no effect at all if you are using
// HikariCP as your connection pooling solution):
// <p>
// <table border="1">
// <tr><td><code>sql.pool.enabled</code></td><td>Set true/false to enable or disable the entire
// SQL connection pooling feature.  Defaults to true</td></tr>
// <tr><td><code>sql.pool.maxActive</code></td><td>Maximum number of "active" (ie, currently
// lent out) connections.  Defaults to -1, which means "no limit"</td></tr>
// <tr><td><code>sql.pool.maxIdle</code></td><td>Maximum number of "idle" (ie, currently
// sitting in the pool, not lent out) connections.  Defaults to -1, which means "no limit"</td></tr>
// <tr><td><code>sql.pool.minIdle</code></td><td>Minimum number of "idle" (ie, currently
// sitting in the pool, not lent out) connections.  If the pool drops below this number of
// idle connections, new ones will be created.  Defaults to -1, which means "no minimum"</td></tr>
// <tr><td><code>sql.pool.whenExhaustedAction</code></td><td>Specifies what the pool should do
// if the system attempts to borrow a connection and there are no idle connections to lend.<ul>
// <li>"fail" will throw an Exception and the SQL operation will fail</li>
// <li>"block" will cause the borrowing thread to block until a connection becomes available</li>
// <li>"grow" will create a new connection, add it to the pool, and then return it to the
// borrowing thread.  Note, if you use this strategy, the "maxActive" setting has no effect</li>
// </ul>The default value is "grow"</td></tr>
// <tr><td><code>sql.pool.testOnBorrow</code></td><td>If true, we attempt to validate the
// connection before lending it out.  This validation involves checking if the connection is
// marked as closed, and also running a "pingTest" query if one is defined (see the section on
// per-database configuration, below).  If validation fails, the connection is discarded and
// another one selected from the pool.  Defaults to true</td></tr>
// <tr><td><code>sql.pool.testOnReturn</code></td><td>The same as <code>testOnBorrow</code>,
// but the checking occurs when the connection is returned to the pool rather than when we are
// about to lend it out.  Defaults to false</td></tr>
// <tr><td><code>sql.pool.testWhileIdle</code></td><td>The same as <code>testOnBorrow</code>,
// but the checking is done by the idle connection evictor (see below) during its periodic
// inspection of the idle objects in the pool.  Defaults to false</td></tr>
// <tr><td><code>sql.pool.timeBetweenEvictionRunsMillis</code></td><td>DBCP can optionally run
// an "idle connection evictor" thread, which periodically checks the pool for connections
// that have been idle for more than a threshold time, and "evicts" them from the pool (ie,
// closes and then discards them).  The purpose of this is to keep the connection pool at the
// intended size, instead of allowing it to remain at whatever size it reached during the
// system's busiest time.  Without an evictor, it would not be unusual to see the number of
// connections in the pool grow towards <code>maxActive</code> over time, or even beyond it
// if the pool is configured to grow when exhausted.  If this is not what you want, configure
// an eviction thread.  However, note that the eviction thread contends with the main pooling
// code for access to the idle connections; if you set the evictor to run very frequently, it
// can introduce performance issues.
// <p>
// This property specifies the number of milliseconds to sleep between runs of the idle
// connection evictor.  If set to a negative value, no evictor will be run.  As shipped, this
// value is set to 30000, so the eviction thread runs every 30 seconds</td></tr>
// <tr><td><code>sql.pool.minEvictableIdleTimeMillis</code></td><td>The minimum time a
// connection may sit idle in the pool before it is eligible for eviction.  If set to a
// negative value, connections will never be evicted due to the length of time they have sat
// idle (a connection will only be evicted if <code>testWhileIdle</code> is true and it
// fails validation).  As shipped, this value is set to 120000, so connections that are idle
// for more than two minutes will become eligible for eviction</td></tr>
// <tr><td><code>sql.pool.numTestsPerEvictionRun</code></td><td>The number of connections to
// check during each eviction run.  As shipped, this value is set to 5, so up to 5 connections
// will be checked by the evictor thread each time it wakes.  Also, be aware that negative
// values of this setting are treated as the denominator in determining a fraction of the pool
// size, so -1 means check all connections, -2 means check half the connections, -3 means
// check a third, etc)</td></tr>
// </table>
// <p>
// In addition to the <code>sql.pool</code> configuration subtree, you can specify per-database
// configuration by adding the +link{dataSource.dbName,dbName} to the property, like so:<pre>
//     sql.mydatabase.pool.enabled: true
//     sql.mydatabase.pool.numTestsPerEvictionRun: 10
//     # etc...
// </pre>
// There is also a configuration property outside the <code>sql.pool</code> and
// <code>sql.{DBNAME}.pool</code> trees that is nevertheless part of SQL connection pooling
// configuration.  This property, <code>sql.{DBNAME}.pingTest</code>, should be a small SQL
// fetch query, ideally a dummy fetch that runs very quickly and returns a single row.  As
// discussed above, this "pingTest", if configured, is used to determine if a connection is
// valid before lending it out.  Most databases have a traditional, proprietary query that fits
// the bill, but it varies by database. Some example pingTest queries:<pre>
//     # Oracle
//     sql.OracleDatabase.pingTest: select 1 from dual
//     # SQL Server
//     sql.mssqlserverdb.pingTest: select 'x'
//     # DB2
//     sql.db2database.pingTest: select 'x' from SYSIBM.SYSDUMMY1
// </pre>
// <h3>Connection pool settings - Hikari</h3>
// <a href=https://github.com/brettwooldridge/HikariCP>HikariCP</a> is a popular lightweight
// JDBC connection pool library.  The project's README describes its aims:
// <p>
// <i>Fast, simple, reliable. HikariCP is a "zero-overhead" production ready JDBC connection
// pool</i>
// <p>
// To configure SmartClient Server to use HikariCP rather than DBCP for connection pooling,
// set the following flag in your <code>server.properties</code> file:<pre>
//    sql.pool.useHikari: true </pre>
// When you use Hikari directly in a Java project, there are a handful of mandatory
// configuration settings: <code>username</code>, <code>password</code>, and either
// <code>dataSourceClassName</code> or <code>jdbcUrl</code>.  However, when using the Hikari
// support in SmartClient Server, SmartClient provides those settings to Hikari based on its
// own database settings, as configured through the +link{group:adminConsole,Admin Console}
// or manually in properties in your <code>server.properties</code> file.  So you should not
// provide those settings in your own Hikari configuration - if you do, they will be ignored,
// but there is also scope for conflicts if both <code>dataSourceClassName</code> and
// <code>jdbcUrl</code> end up in the configuration at the same time.
// <p>
// One other thing to say about essential config is, some older DriverManager drivers require
// the name of the driver class in addition to the jdbc URL.  Quoting from the Hikari docs:
// <p>
// <i>When using this property with "old" drivers, you may also need to set the driverClassName
// property, but try it first without</i>
// <p>
// If you find that you need to work with one of these "old" JDBC drivers where the driver
// classname is required, specify it as property "driver" of your regular SmartClient database
// config; if that property is specified at the SmartClient level, we will automatically
// provide it to the Hikari config, and if it is unset in the SmartClient config, we will
// leave it unset in the Hikari config.  For example: <pre>
//    sql.PostgreSQL.driver:org.postgresql.Driver </pre>
// For non-essential config: Hikari is less configurable than some other connection pools (by
// design), and the authors recommend that you leave the library with default configuration,
// such that minimum and maximum sizes are the same, so Hikari maintains a fixed-size pool.
// If you do want to alter Hikari's configuration, you can do so by adding properties to your
// <code>server.properties</code> that follow the pattern
// <code>sql.{dbName}.hikari.{hikari-property-name}</code>, where <code>{dbName}</code> is the
// name of a SmartClient +link{group:dbConfigTool,database configuration}, and
// <code>{hikari-property-name}</code> is a valid Hikari configuration property, as documented
// on <a href=https://github.com/brettwooldridge/HikariCP#frequently-used>the project's homepage</a>.
// For example: <pre>
//    # For the "PostgreSQL" database config, set maximum pool size to 10, minimum pool size to 5,
//    # and retire connections after an hour
//    sql.PostgreSQL.hikari.maximumPoolSize: 10
//    sql.PostgreSQL.hikari.minimumIdle: 5
//    sql.PostgreSQL.hikari.maxLifetime: 360000 </pre>
// <b>WARNING</b>: Take care that any Hikari config properties you set are valid properties
// documented on the project page linked to above.  If you specify a property that Hikari
// doesn't know about, it won't just ignore it, it will throw Exceptions during initiation
// <p>
// <b>WARNING</b>: When moving from DBCP to Hikari, be careful to set the maximum pool size
// large enough, using the <code>sql.{dbName}.hikari.maximumPoolSize</code> setting.  This is
// especially important to avoid a problem the Hikari devs call "pool locking", if you have
// processes that run multiple database operations without combining them into a single
// transaction.  In this scenario, the default DBCP config would grow the pool as required to
// accomodate more connections than the pool was sized for, but Hikari has no option to do
// this. Again, this is by design - the authors of Hikari discuss their views on pool sizing in
// <a href=https://github.com/brettwooldridge/HikariCP/wiki/About-Pool-Sizing>this article</a>.
// That article also specifically covers this issue of pool locking:
// <a href=https://github.com/brettwooldridge/HikariCP/wiki/About-Pool-Sizing#pool-locking>Direct link</a>
//
// <h3>Troubleshooting issues related to connection pooling</h3>
// Many databases will automatically close inactive connections, which can interfere with
// connection pooling: if an application is not constantly using all of the connections in its
// pool, it may retrieve a closed connection from the pool.
// <P>
// In some cases you can disable the behavior of closing inactive connections.  For MySQL it's
// controlled by the
// +externalLink{http://dev.mysql.com/doc/refman/5.0/en/server-system-variables.html#sysvar_wait_timeout,wait_timeout}
// setting in your my.cnf file).  However, this could potentially cause leaked connections if
// applications terminate without cleaning up their database connections.
// <P>
// Intelligent connection pools compensate for unexpectedly closed connections automatically:
// <ul>
// <li>J2EE containers generally implement internal keepalives or staleness checks - this is
// the preferred solution if available.  If using SQLDataSource, use JNDI-based
// configuration as described +link{group:dbConfigTool,here}.
// <li>SQLDataSource uses DBCP (Apache Commons) pooling, which also compensates for connection
// closure automatically.  This is enabled by default with appropriate settings, but can be
// disabled system wide via setting <b>sql.pool.enabled</b> to false in
// +link{group:server_properties,server.properties}, or
// disabled for a specific database configuration via <b>sql.<i>dbName</i>.pool.enabled</b>.
// The following properties can also be set on sql.pool / sql.<i>dbName</i>.pool and control
// same-named DBCP properties, however, it is not recommended to set these properties unless
// you have experience with DBCP and are troubleshooting a specific pool-related performance
// problem: testOnBorrow, testOnReturn, testWhileIdle, timeBetweenEvictionRunsMillis,
// minEvictableIdleTimeMillis, numTestsPerEvictionRun.
// <p>
// When the pool is configured for connection validation, as it is by default, a SQL statement
// is run to verify the condition of its connection.  To control the timeout value on this statement,
// set the sql.validationQueryTimeout / sql.dbName.validationQueryTimeout property (in seconds, default value is 10).
// <p>
// If you are trying to diagnose an issue related to SQL connection pooling, you can enable
// DEBUG logging for the following classes in <code>log4j.isc.config.xml</code> (see
// installation instructions for details about this file).  All of these classes are in package
// <code>com.isomorphic.sql</code>:
// <ul>
// <li> PoolableSQLConnectionFactory: logs connection creation, and whether or not the
//      connections are pooled
// <li> SQLConnectionManager: logs when connections are borrowed
// <li> SQLDriver: logs the hashCode of the connection when SQL statements are executed
// <li> SQLTransaction: logs transactional open, commit, rollback and close.
// </ul>
// <li>JPA/Hibernate: Hibernate's built-in connection pool is <b>not</b> intended for
// production use according to Hibernate's own documentation.  This includes using JPA with
// Hibernate as the provider. If you get dead connections during development you can disable
// Hibernate's built-in connection pool by setting "hibernate.connection.pool_size" to 0. For
// production use you must use production-ready connection pool libraries for example
// C3P0. Here are recommended settings for C3P0 properties:
// <ul>
// <li>c3p0.acquireRetryDelay=1000</li>
// <li>c3p0.acquireRetryAttempts=60</li>
// <li>c3p0.breakAfterAcquireFailure=false</li>
// </ul>
// </li>
// </ul>
// @treeLocation Concepts/Persistence Technologies
// @title SQL Connection Pooling
// @visibility external
//<

//> @groupDef standaloneDataSourceUsage
// The DataSource layer can be used in a standalone application separate from a servlet engine,
// for use cases like offline batch data processing, sending emails based on database
// state, or integration of SmartClient Server logic into a standalone Java Swing application.
// <p>
// In addition, the section below on "Transactions in standalone applications" also applies to
// any transaction that is initiated separately from an RPCManager and/or the HttpServletRequest
// lifecycle.  This includes use cases like non-servlet web apps (using NIO servers like
// Grizzly), web apps that set timers to perform delayed actions (using frameworks such as
// Quartz), as well JMS or other Java frameworks that may introduce non-HttpServletRequest threads
// within a servlet container.
// <p>
// Note that we do still require <code>servlet-api.jar</code> to be on the classpath of
// standalone applications.  This is only to satisfy class-loading requirements; there are
// cases where running inside a servlet engine allows us to provide extra functionality, such
// as declarative authentication and authorization features, so some classes do have member
// variables or method parameters of types in the Servlet API.  They all operate correctly
// when these variables or parameters are null, but the JVM will still try to load the classes
// and will crash if they are missing.
// <p>
// Using the DataSource layer to run DataSource operations in your standalone applications is
// extremely straightforward.  This example fetches and prints every record from the
// "customers" DataSource:
// <pre>
//   public static void main(String[] args) {
//     DataSource ds = DataSourceManager.get("customers");
//     List records = ds.fetch();
//     for (Iterator i = records.iterator; i.hasNext(); ) {
//       System.out.println(i.next());
//     }
//   }
// </pre>
// To make this example fetch just customers in the United States:
// <pre>
//     Map criteria = new HashMap();
//     criteria.put("countryCode", "US");
//     List records = ds.fetch(criteria);
// </pre>
// This example shows how to run a specific fetch operation, specifying both selection
// criteria and a sort order, using a <code>DSRequest</code> rather than a <code>DataSource</code>
// convenience method:
// <pre>
//   public static void main(String[] args) {
//     DSRequest dsReq = new DSRequest("customers", "fetch");
//     dsReq.setOperationId("specialFetch");
//     Map criteria = new HashMap();
//     criteria.put("countryCode", "US");
//     criteria.put("region", "CA");
//     dsReq.setCriteria(criteria);
//     dsReq.setSortBy("customerName");
//     List records = dsReq.execute().getDataList();
//   }
// </pre>
// This example shows how to do a simple update:
// <pre>
//   public static void main(String[] args) {
//     DataSource ds = DataSourceManager.get("customers");
//     Map criteria = new HashMap();
//     criteria.put("customerNo", 12345);
//     Map values = new HashMap();
//     values.put("creditLimit", 10000);
//     values.put("currencyCode", "USD");
//     ds.update(criteria, values);
//   }
// </pre>
// Finally, this example shows how to perform a specific update operation via a
// <code>DSRequest</code>:
// <pre>
//   public static void main(String[] args) {
//     DSRequest dsReq = new DSRequest("customers", "update");
//     dsReq.setOperationId("specialUpdate");
//     Map criteria = new HashMap();
//     criteria.put("customerNo", 12345);
//     Map values = new HashMap();
//     values.put("creditLimit", 10000);
//     values.put("currencyCode", "USD");
//     dsReq.setCriteria(criteria);
//     dsReq.setValues(values);
//     dsReq.execute();
//   }
// </pre>
// <b>NOTES</b>
// <p>
// Because we are not running inside a servlet container, SmartClient's built-in logic to
// work out where its application root is does not work.  Therefore, you need to manually
// set a "webRoot" in your +link{group:server_properties,server.properties} file.
// The webRoot should point
// to the root folder of your application (note for SmartGWT applications, this is typically
// the "war" subfolder of your project).  Example entries:<p>
// <code>    webRoot: /home/testUser/myProject</code><p>
// or:<p>
// <code>    webRoot: C:\Projects\MyProject\war</code><p>
// Again in +link{group:server_properties,server.properties},
// you may need to set <code>isomorphicPathRootRelative</code>
// to match the standalone project's layout if you make the standalone mode separate:<p>
// <code>    isomorphicPathRootRelative: myProject/sc</code>
// <p>
// <smartgwt>
// Note that the directory structure that normally appears in "war/<i>myProject</i>/sc" in your
// GWT project is required to be present under the configured
// <i>webRoot</i>+<i>isomorphicPathRootRelative</i> directory when running standalone.  This structure is
// normally created by the GWT compiler, by processing &lt;inherits&gt; tags in your .gwt.xml
// that cause resources to be copied from smartgwtee.jar.  If your build/deployment scripts do
// not invoke the GWT compiler these files will not be present, so you will need to either add
// a step to invoke the GWT compiler or manually copy the files.
// </smartgwt>
// You should place the +link{group:server_properties,server.properties} file somewhere on your classpath.
// Typically, the root of your <code>bin</code> or <code>classes</code> folder structure is
// the most suitable place for it.
// <p>
// Both the built-in DataSources and custom DataSources can be used in standalone
// applications, <b>but only if you do not introduce dependencies on the servlet container in
// your DataSource code</b>. For example, if you have a security check in a DMI or custom
// DataSource that depends on checking the current logged-in user, code in a means of bypassing
// this, or create a parallel operationBinding that is accessible only to the superuser.
// <br>
// <h3>Declarative Security</h3>
// <p>
// When you use the DataSource layer in a standalone application,
// +link{dataSource.requiresAuthentication,Declarative Security} has to be explicitly controlled.
// <p>
// To enable a request for security checks you simply need to call <code>dsRequest.setUserId()</code>
// or <code>dsRequest.setUserRoles()</code>. If the request is apart of a transaction then security
// can also be defaulted using <code>dsTransaction.setClientRequest(true/false)</code>, however
// any value set on an individual request will still take priority. For instance if you call
// <code>dsTransaction.setClientRequest(false)</code> but then also call <code>dsRequest.setUserId(id)</code>,
// then security checks will still take place for that request as it has had security enabled which
// takes priority over the value on <code>DSTransaction</code>.
// <p>
// Note: If you have Declarative Security checks in your DataSources and/or enabled via your Java
// code, and you want to completely disable such checks system-wide, you can  set
// <code>security.disabled: true</code> in +link{group:server_properties}.  This causes API calls
// like <code>dsRequest.setClientRequest()</code> to be completely ignored.
//
// <h3>Transactions</h3>
// <p>
// In standalone mode, transactions cannot be automatically initiated with the HTTP request lifecyle,
// however you can still manually initiate and commit transactions (note, only available with a Power
// or better license).  To do so, create a <code>DSTransaction</code> object and associated each
// <code>DSRequest</code> with it via <code>dsRequest.setDSTransaction()</code>.  At the end of
// processing, call <code>DSTransaction.complete()</code> to ensure commits and rollbacks are
// executed and that resources are freed up.
// <p>
// Usage Example:
// <pre>
//     DSTransaction dst = new DSTransaction();
//     DSRequest req1 = new DSRequest("myDataSource", "update");
//     req1.setDsTransaction(dst);
//
//     DSRequest req2 = new DSRequest("myDataSource", "add");
//     req2.setDsTransaction(dst);
//
//     DSRequest req3 = new DSRequest("myDataSource", "update");
//     req3.setDsTransaction(dst);
//
//     try {
//         // This will process the queue of requests which have been registered with the transaction.
//         dst.processQueue();
//     } finally {
//         // We put this in a "finally" block to ensure it always runs even on exceptions.
//         dst.complete();
//     }
// </pre>
// <p>
// You can also handle the requests manually instead of using <code>dsTransaction.processQueue()</code>.
// This can be handy if you wish to perform another operation in between each request or if one
// request depends on data from the other.  At the end of processing, call
// <code>DSTransaction.complete()</code> to ensure commits and rollbacks are executed and that
// resources are freed up.
// <p>
// Usage Example:
// <pre>
//     DSTransaction dst = new DSTransaction();
//
//     try {
//         DSRequest req1 = new DSRequest("myDataSource", "fetch");
//         req1.setDsTransaction(dst);
//
//         DSRequest req2 = new DSRequest("myDataSource", "update");
//         req2.setDsTransaction(dst);
//
//         req1.execute();
//         // Use the response from req1 to modify req2 here
//         req2.execute();
//     } catch (Exception e) {
//         throw new RuntimeException(e);
//     } finally {
//         // We put this in a "finally" block to ensure it always runs even on exceptions.
//         dst.complete();
//     }
// </pre>
// <p>
// Please note that +link{group:transactionChaining,Transaction chaining} is supported while
// using transactions in a standalone use case - expressions such as <code>$responseData</code>
// will refer to results from previous <code>DSRequests</code> that are part of the same
// <code>DSTransaction</code>.
// <p>
// <b>Note the following about standalone transactions:</b>
// <ul>
// <li>DSRequests that have not had <code>setDSTransaction()</code> called will be outside of
// any transactional processing - they will be auto-committed at the end of request
// processing.</li>
// <li>You may partition your updates into multiple transactions, simply by creating multiple
// <code>DSTransaction</code> objects and assigning them to DSRequests as required.  Note, this
// will tie up a database connection per <code>DSTransaction</code> until the transactions are
// committed or rolled back.</li>
// <li>When using the DSTransaction's built in <code>processQueue()</code> method, error handling
// will be taken care of automatically for each <code>DSRequest.execute()</code> call and a
// proper <code>DSResponse</code> will always be returned.</li>
// <li>Your code is responsible for calling the <code>complete()</code> method, which will
// commit the transaction if every DSRequest was successful, or roll it back if there were any
// failures, and then release the database connection. If you do not call
// <code>complete()</code>, you will leak database connections, so consider placing the call
// inside a <code>finally</code> block</li>
// <li>If you do not want SmartClient Server's default behavior of automatically rolling back
// if any DSRequest failed, you can manually take over the transaction management by calling
// <code>commit()</code> or <code>rollback()</code> instead of <code>complete()</code>.  Note,
// if you do this you also take on responsibility for releasing the database connection by
// calling <code>freeQueueResources()</code> or <code>freeAllResources()</code>.  If you fail
// to do this, you will leak database connections</li>
// <li>A DSTransaction object can be re-used after <code>complete()</code> has been called.
// When you do this, a new database connection is borrowed or established, and a new
// transaction is started</li>
// </ul>
//
// <h3>Spring Framework</h3>
// <p>
// In a typical web application, Spring configuration is picked up from an "applicationContext"
// file by a servlet or listener, and then made available to the rest of the app via the
// servletContext.  When running standalone, this is not possible, so instead we read the
// applicationContext file manually when we need to, eg, create a DataSource object that is
// configured as a Spring bean.
// <p>
// By default, the framework will create an instance of Spring's
// <code>FileSystemXmlApplicationContext</code> from a configuration at
// <code>WEB-INF/applicationContext.xml</code>.  If you use another name or location for this
// file, and you want to run the application outside of a servlet engine, you can tell the
// framework where to find the configuration(s) by specifying a comma-separated list of paths
// via the <code>standalone.spring.applicationContext</code> property in your
// +link{group:server_properties,server.properties}. You may provide your locations with the
// <code>classpath:</code> or <code>file:</code> prefixes as shown
// +externalLink{https://docs.spring.io/spring-framework/docs/3.2.x/spring-framework-reference/html/resources.html#resources-app-ctx-construction, here}
// or without, in which case SmartClient will prepend the <code>file:</code> prefix for you at
// runtime.  The default setting for this property looks like this:
// <pre>
//    standalone.spring.applicationContext: $webRoot/WEB-INF/applicationContext.xml
// </pre>
//
// @treeLocation Client Reference/Data Binding/DataSource
// @title Standalone DataSource Usage
// @see transactionChaining
// @visibility external
//<



//> @groupDef sqlDataSource
// The SmartClient Server supports comprehensive, codeless SQL connectivity for DataSources
// defined in XML.  Our SQL connectivity is mature, feature-rich, protected against injection
// attacks and easily customizable to support user-written SQL and additional business logic
// of any complexity.  +link{group:sqlVsJPA,This article} compares the built-in SQL DataSource
// to other persistence approaches based on Javabeans.
// <P>
// To use the built-in SQL engine, declare a +link{DataSource} in XML format with
// +link{dataSource.serverType} set to "sql", and place it in the shared dataSources directory
// ([webroot]/shared/ds by default) in a file called "[dataSourceId].ds.xml".
// <p>
// You can then use the +link{group:adminConsole,Admin Console} to configure database access,
// as well as to automatically create and populate a database table based on your DataSource.
// By default, DataSources will use the "default database" from the admin console, however you
// can set +link{dataSource.dbName} to the name of a specific database configuration you have
// configured via the Admin Console.
// <P>
// The list of databases known to work with the built-in SQL logic is as follows:
// <p>
// <table class='normal'>
// <tr><td width=40></td><td width="80%"><i>HSQLDB 1.7.x, 1.8.x, 2.0.x, 2.2.x, 2.3.x, 2.4.x, 2.5.x</i></td><td></td></tr>
// <tr><td></td><td><i>IBM DB2 8.x, 9.x, 10.x, 11.x</i></td><td></td></tr>
// <tr><td></td><td><i>IBM DB2 for i (formerly known as DB2 for i5/OS) V5R4M0 onwards</i></td><td></td></tr>
// <tr><td></td><td><i>Firebird 2.5.x, 3.x</i></td><td></td></tr>
// <tr><td></td><td><i>Informix 12.10.x, 14.10.x</i></td><td></td></tr>
// <tr><td></td><td><i>MS SQL Server 2000, 2005, 2008, 2008 R2, 2012, 2014, 2016, 2017, 2019</i></td><td></td></tr>
// <tr><td></td><td><i>MySQL 5.0.x, 5.1.x, 5.5.x, 5.6.x, 5.7.x, 8.x</i></td><td></td></tr>
// <tr><td></td><td><i>MariaDB 5.x, 10.x</i></td><td></td></tr>
// <tr><td></td><td><i>Oracle 8.0.5, 8i, 9i, 10g, 11g, 12c, 18c, 19c</i></td><td></td></tr>
// <tr><td></td><td><i>PostgreSQL 7.x, 8.x, 9.x, 10.x, 11.x, 12.x</i></td><td></td></tr>
// <tr><td></td><td><i>Progress OpenEdge 11.7 (Note, DDL via JDBC operations are restricted by the product itself)</i></td><td></td></tr>
// <tr><td></td><td><i>Snowflake JDBC driver version 3.20</i></td><td></td></tr>
// </table>
// <p>We also support a generic SQL92 database connection which works for basic CRUD operations
// with any database product that supports standard SQL92 syntax and data types, plus a couple
// of widely-implemented features that are not actually part of the standard.  Specifically,
// this means we do not support:<ul>
// <li>Sequences</li>
// <li>Paging via SQL limit queries</li>
// <li>+link{DataSource.autoJoinTransactions,Automatic transaction management}
// <li>Long text values (there is no real definition of "long" here - we try to use a standard
// VARCHAR, but different databases will support different maximum values for this)</li>
// <li>Databases that do not implement the widely-supported LOWER() function</li>
// <li>Databases that do not support the ability to perform string-type operations on numeric
// columns - for example, <code>myNumericColumn LIKE '%5%'</code></li>
// </ul>
// <p>You will also need a JDBC driver for your specific database. Licensing restrictions
// prevent us including any JDBC driver other than the one for HSQLDB.  However, you
// can download these drivers for free from the vendors' websites.  If your specific database
// server or version is not listed above, please go to the
// <a href="http://forums.smartclient.com">SmartClient forums</a> for assistance.
// <P>
// You can connect to an existing database table by providing a +link{dataSource.tableName}
// attribute value.  Field-level details can be provided explicitly, if you choose, or these
// can be automatically inferred from your schema via +link{DataSource.autoDeriveSchema}.
// <strong>
// With autoDeriveSchema, you get full SQL connectivity / generation from a one-line .ds.xml
// file!.
// </strong>
// You can of course customize these automatically derived field definitions without
// having to reiterate the properties discovered by auto-derivation.  For example, the
// following field definition overrides an automatically +link{dataSource.autoDeriveTitles, derived title}
// while preserving metadata obtained from the table, such as type &amp; length:
// <pre>
//   &lt;field name="information" title="Interesting Facts" /&gt;
// </pre>
// <P>
// Once you have your SQL DataSource connected to a table, in a default SDK installation,
// DSRequests for your DataSource will be sent to the default
// +link{RPCManager.actionURL,actionURL}, and hence handled automatically, without you having
// to write any Java code, by the +link{servletDetails,IDACall servlet registered in web.xml}.
// IDACall is a very simple servlet that just calls the server-side method
// dsRequest.execute() for all inbound requests.  For more details on how DataSource requests
// are processed by SmartClient Server, and how you can alter and add to this processing, see
// this description of +link{group:serverDataIntegration,server data integration}.
//
// @treeLocation Client Reference/Data Binding/DataSource
// @title SQL DataSources
// @requiresModules SCServer
// @visibility external
//<

//>ISC_140

// ================================== RestConnector ===================================

//> @groupDef serverRestConnector
// <i><b>NOTE:</b> This article discusses SmartClient's server-side REST client implementation.
// It should not be confused with the client-side +link{class:RestDataSource} implementation;
// the client-side dataSource is intended for cases where you are creating the server API and
// thus have control over the format and protocols used, but you do not wish to use the
// SmartClient Server for some reason.  The server-side implementation, which is documented
// below, is intended for cases where you need to connect to existing third-party REST APIs
// (which, despite the impression that "REST" is a standardized approach, vary significantly
// from one to the other in their details)</i>
// <p>
// RestConnector is a built-in server-side +link{class:DataSource,DataSource}
// implementation.  It is able to convert a standard client-submitted or server-created
// +link{class:DSRequest,DSRequest} into an arbitrary REST webservice call, and convert the
// REST service response into a standard +link{class:DSResponse,DSResponse}.  These conversions
// are highly configurable, making use of any or all of the following:<ul>
// <li>+link{dataSource.recordXPath,Record-level} and +link{dataSourceField.valueXPath,field-level}
// XPath processing</li>
// <li>+link{group:velocitySupport,Velocity-based} templates providing powerful declarative data
// templating and conversion for both +link{DataSource.requestTemplate,requests} and
// +link{DataSource.responseTemplate,responses}.  These templates are evaluated at request/response
// execution time, so can include dynamic elements such as the criteria sent from the client</li>
// <li>Where declarative conversion is not sufficient, inline scripts written in Groovy, Javascript
// or other JSR-223 languages can add conversion of arbitrary complexity.  Again, we support
// scripts for converting both +link{dataSource.transformRequestScript,requests} and
// +link{dataSource.transformResponseScript,responses} at the record-level, and for response
// data at the +link{dataSourceField.fieldValueScript,field-level}</li>
// </ul>
// <h3>Pervasive Velocity support</h3>
// <code>RestController</code> was designed to be as flexible and configurable as possible.
// One of the ways we achieve this is with pervasive support for Velocity templating.  In the
// descriptor (<code>*.ds.xml</code> file) of a RestController dataSource, you can use Velocity
// expressions in any element, and they will be replaced at execution time.  This means that
// you can embed references to <code>server.properties</code> items, elements from the values
// and criteria of this operation, elements of other useful context objects, and arbitrary
// values that your code has set up in the Velocity template context (see the
// +link{group:velocitySupport,Velocity overview} for details of these latter two).  See the
// sample config below for examples of how this feature can be used.  Additional examples are
// also shown in the docs of individual config properties (+link{dataSource.headers,headers},
// for example)
// <p>
// <b>Important:</b> Because we allow references to <code>$criteria</code> and
// <code>$values</code> in <code>RestConnector</code> config, it follows that we re-evaluate
// Velocity expressions on every <code>DSRequest</code>; in fact, as the following section
// discusses, when there are multiple valueSets, we evaluate Velocity expressions multiple
// times per <code>DSRequest</code>.  However, we do <b>not</b> evaluate <code>$config</code>
// references per-<code>DSRequest</code>: <code>$config</code> references are evaluated during
// <code>DataSource</code> initialization, and are fixed thereafter.  The main implication of
// this is, if you are pooling and reusing <code>DataSource</code> instances (which is the
// default), <code>$config</code> references will be fixed after initial evaluation for the
// life of the JVM, so you should not expect to be able to change a config setting and have it
// picked up in <code>RestConnector</code> Velocity templates.
// <h3>Multiple ValueSets</h3>
// <code>RestController</code> has a general ability to handle multiple valueSets, but only
// for REST services where both the +link{DataSource.requestFormat,requestFormat} and the
// +link{DataSource.responseFormat,responseFormat} are "json".  For example, if we receive a
// +link{class:DSRequest,dsRequest} with two valueSets, like this:<pre>
//    [
//        {name:"Smith", ID:72},
//        {name:"Jones", ID:1044}
//    ]
// </pre>
// We will combine those two records into a single JSON block to send to the remote REST server:<pre>
//   [{"name":"Smith","ID": 72},{"name":"Jones","ID":1044}]
// </pre>
// <code>RestConnector</code> is also able to wrap singular records in a list, for remote
// services that want to treat all input as a list - see +link{DataSource.wrapInList,wrapInList}
// <p>
// +link{DataSource.requestTemplate,Request templates} are also able to handle multiple
// valueSets.  If there are multiple valueSets in the <code>DSRequest</code>, or if
// <code>wrapInList</code> is in force, we will apply each valueSet to the template,
// constructing a list of templated JSON blocks to send to the REST server.
// <h3>Authentication</h3>
// RestConnector provides the following standard authentication methods:<ul>
// <li>Basic Authorization with a username and password or API token</li>
// <li>Bearer Authorization with an API token</li>
// <li>Bearer Authorization with a refresh/access token scheme, such as JSON Web Tokens (JWT)</li>
// <li>Manually-constructed Authorization header</li>
// <li>Ad-hoc, informal auth schemes, like embedding an API token in the body of the request</li>
// </ul>
// The supported authentication methods are all secure as long as you are using HTTPS
// connections, but the refresh/access token approach adds an additional layer of security by
// using frequently-changed, short-lived tokens instead of credentials that remain valid for
// an extended period.  For this reason, we recommend using that approach if you have the
// choice.
// <p>
// As noted, <code>RestConnector</code> is flexible enough that it is able to connect with
// REST APIs that use non-standard authentication techniques, such as embedding a token
// or username/password credentials in the request body.  These non-standard authentication
// approaches are found more often than might be thought, and although they are non-standard,
// they are not any less secure than the standard approaches as long as you are using HTTPS.
// <p>
// See the +link{dataSource.auth,auth block} documentation for full details.
// <h3>Example configuration</h3>
// RestConnector configuration is typically expressed in the +link{dataSource.serverConfig,serverConfig}
// block of a DataSource descriptor (<code>.ds.xml</code> file) - the client has no need to
// know about this configuration, and generally should not be able to see it - although
// <code>serverConfig</code> is optional in nearly every cases; see the <code>serverConfig</code>
// documentation for details of this.
// <p>
// An example configuration is shown below.
// <pre>
//   &lt;DataSource
//       ID="SomeRestDataSource"
//       serverType="rest"
//   &gt;
//     &lt;serverConfig&gt;
//       &lt;requestFormat&gt;params&lt;/requestFormat&gt;
//       &lt;responseFormat&gt;json&lt;/responseFormat&gt;
//       &lt;recordXPath&gt;items&lt;/recordXPath&gt;
//
//       &lt;!-- This is the default URL to send REST requests to, if not overridden at the
//               OperationBinding level.  Note, this MUST be declared inside the serverConfig
//               block, otherwise client code in the browser will try to use it.  This example
//               just uses plain, untemplated config but there are lots more options - see the
//               operationBindings below --&gt;
//       &lt;dataURL&gt;https://somerestservice.com/api/search&lt;/dataURL&gt;
//
//       &lt;auth&gt;
//         &lt;type&gt;basic&lt;/type&gt;
//         &lt;username&gt;$config['rest.somerestservice.apiUser']&lt;/username&gt;
//         &lt;password&gt;$config['rest.somerestservice.apiToken']&lt;/password&gt;
//       &lt;/auth&gt;
//
//       &lt;operationBindings&gt;
//         &lt;operationBinding operationType="fetch" operationId="customerFetch"&gt;
//           &lt;!-- You can use values defined in your server.properties file with the
//                   "$config" context variable --&gt;
//           &lt;dataURL&gt;$config['rest.somerestservice.baseURL']/customers&lt;/dataURL&gt;
//         &lt;/operationBinding&gt;
//
//         &lt;operationBinding operationType="update" operationId="updateCustomer"&gt;
//           &lt;!-- And you can use values and criteria sent up from the client with "$values"
//                   and "$criteria" --&gt;
//           &lt;dataURL&gt;$config['rest.somerestservice.baseURL']/customer/$criteria['customerId']?name=$values['custName']&lt;/dataURL&gt;
//           &lt;requestFormat&gt;json&lt;/requestFormat&gt;
//         &lt;/operationBinding&gt;
//
//         &lt;operationBinding operationType="remove"&gt;
//           &lt;!-- And you can use arbitrary values placed in the template context, as with
//                   "$deletePath" here --&gt;
//           &lt;dataURL&gt;$config['rest.somerestservice.baseURL']/$deletePath/$values['itemKey']&lt;/dataURL&gt;
//         &lt;/operationBinding&gt;
//       &lt;/operationBindings&gt;
//     &lt;/serverConfig&gt;
//   &lt;/DataSource&gt;
// </pre>
//
// @treeLocation Client Reference/Data Binding/DataSource
// @title Server-side REST Connector
// @visibility external
//<


//> @groupDef odataDataSource
// <code>ODataDataSource</code> is a built-in server-side +link{class:DataSource,DataSource}
// implementation that extends +link{group:serverRestConnector,RestConnector} to add
// functionality for REST webservices that follow the
// <a href="https://www.odata.org/">OData protocol</a>.  Everything that applies to
// <code>RestConnector</code> also applies to <code>ODataDataSource</code> - it is configured
// in the same way, provides the same support for pervasive Velocity templating, etc.
// <p>
// In addition to the regular <code>RestConnector</code> facilities,
// <code>ODataDataSource</code> adds the following support, specifically for REST services
// that follow the OData protocol<ul>
// <li style="margin-bottom:1em">Generate an OData-compliant "$filter" query from standard SmartClient criteria.  Note,
// the generated filter query will convert +link{dsRequest.textMatchStyle,textMatchStyle} to
// the corresponding OData function ("<code>substring</code>" becomes "<code>contains</code>"
// and "<code>startsWith</code>" becomes "<code>startswith</code>"; other textMatchStyles just
// generate straight equality checks), but there is no current support for true
// +link{object:AdvancedCriteria}</li>
// <li style="margin-bottom:1em">Generate an OData "$orderby" parameter from the SmartClient sortBy information</li>
// <li style="margin-bottom:1em">Generate an OData "$select" parameter from the SmartClient "outputs" information</li>
// <li style="margin-bottom:1em">Derive "$skip" and "$top" attributes from the SmartClient startRow and endRow</li>
// <li style="margin-bottom:1em">Derive and apply the necessary "maxpagesize" Prefer header to encourage the remote
// server to allow the page size we would like to use</li>
// <li style="margin-bottom:1em">Request the OData "$count" property and make use of it to populate totalRows.
// <li style="margin-bottom:1em">Modify certain things to match the OData defaults, where that differs from the normal
// <code>RestConnector</code> defaults</li>
// <li style="margin-bottom:1em">Apply all these generated and derived properties to the REST call</li>
// </ul>
//
// @treeLocation Client Reference/Data Binding/DataSource
// @title Server-side OData DataSource
// @visibility external
//<

//> @attr dataSource.serverConfig (DataSource Properties : null : IR)
// Configuration settings that will be used purely on the the server-side.  Any properties
// declared within a <code>serverConfig</code> block will be overlaid onto the regular dataSource
// configuration, such that any property declared in <code>serverConfig</code> takes priority,
// <b>but only on the server</b>; the client never sees the <code>serverConfig</code> block.
// <p>
// <code>serverConfig</code> is primarily intended for use with the
// +link{group:serverRestConnector,RestConnector}, and is used for two related purposes.
// Firstly, it is a mechanism for declaring properties that only the server should see, to
// avoid information leakage to the client.  Typical usages of this type would be things like
// +link{dataSource.headers,headers} and +link{dataSource.params,params} - things that are
// specific to <code>restConnector</code>'s communication with the remote REST server, and no
// business of the client's.
// <p>
// Secondly, <code>serverConfig</code> is used in cases where you need the client and server
// to use different values for a property.  The only property for which this definitely arises
// is +link{dataSource.dataURL,dataURL} (and the
// +link{operationBinding.dataURL,same property on the OperationBinding}), because
// <code>dataURL</code> is used both on the client, to configure the endpoint for server
// requests, and by <code>RestController</code> on the server to configure the target URL(s)
// for REST request(s).  Thus, you should <b>always</b> specify a <code>dataURL</code> inside
// <code>serverConfig</code> if it is intended for use on the server-side by a
// <code>RestConnector</code> DataSource; failure to do so will cause the client to send its
// <code>DSRequest</code>s directly to the remote REST server, which obviously will not know
// how to handle them.
// <p>
// Sub-objects will be merged such that properties declared in <code>serverConfig</code>
// replace the same properties declared in the regular sub-object, but properties that are
// missing in the <code>serverConfig</code> remain in the merged sub-object.  For example:<pre>
// &lt;DataSource ... &gt;
//
//   &lt;operationBindings&gt;
//     &lt;operationBinding operationType="fetch" dataURL="specialIDACallURL" outputs="some,list,of,fields" /&gt;
//     &lt;!-- the browser can see this, so this works for the extremely rare case that a DataSource should
//             contact different versions of the IDACall servlet for different operations.  The browser is
//              also aware of the limited outputs --&gt;
//     &lt;/operationBindings&gt;
//
//     &lt;serverConfig&gt;
//       &lt;operationBindings&gt;
//         &lt;operationBinding operationType="fetch" dataURL="restServiceURL" /&gt;
//         &lt;!-- this is the actual URL of the REST service to contact from the server.  The browser never sees this
//               so its version of "dataURL" is retained.  At the same time, the "outputs" from the browser-visible
//               definition still apply, because the configs were merged --&gt;
//       &lt;/operationBindings&gt;
//     &lt;serverConfig&gt;
// </pre>
//
// @serverDS only
// @group serverRestConnector
// @visibility external
//<

//> @attr dataSource.headers (Object : null : IR)
// Applies to RestConnector dataSources (+link{dataSource.serverType,serverType} "rest") only,
// and is overridable per operationBinding (see +link{operationBinding.headers}).
// <p>
// Some REST servers require special HTTP headers to be sent to provide state or
// authentication details; this property can be used to set up one or more headers to be sent
// with the REST request.  Like other elements of RestConnector config, you typically define
// this property inside a +link{dataSource.serverConfig,serverConfig} block to keep the details
// from leaking to clients.  Also like other RestConnector config, you can include Velocity
// templates in your header definitions.
// <p>
// Headers are simple key/value pairs, defined like this:<pre>
//    &lt;headers&gt;
//        &lt;My-Custom-Header&gt;Some custom value&lt;/My-Custom-Header&gt;
//        &lt;Another-Special-Header&gt;$config['special.header.value']&lt;/Another-Special-Header&gt;
//    &lt;/headers&gt;</pre>
// Note, we automatically add a "Content-Type" header of either <code>application/json</code> or
// <code>application/xml</code> (depending on the +link{dataSource.responseFormat,responseFormat}),
// unless you define one by hand in your DataSource's <code>headers</code> definition
//
// @serverDS only
// @group serverRestConnector
// @visibility external
//<

//> @attr operationBinding.headers (String : null : IR)
// Applies to RestConnector dataSources (+link{dataSource.serverType,serverType} "rest") only.
// This is an operationBinding-level override of +link{DataSource.headers} - see
// that property's documentation for details
// @serverDS only
// @group serverRestConnector
// @visibility external
//<

//> @attr dataSource.params (Object : null : IR)
// Applies to RestConnector dataSources (+link{dataSource.serverType,serverType} "rest") only,
// and is overridable per operationBinding (see +link{operationBinding.params}).
// <p>
// A list of key/value pairs to pass as URL parameters when constructing the query part of the
// REST service URL.  These can include templating, as described in the
// +link{group:serverRestConnector,RestConnector overview}.  For example:<pre>
//    &lt;params&gt;
//      &lt;customParam&gt;$arbitraryVarInTemplateContext&lt;/customParam&gt;
//      &lt;userIdentifier&gt;$config['rest.service.user.identifier']&lt;/userIdentifier&gt;
//    &lt;/params&gt;</pre>
// Bear in mind that +link{dataSource.requestFormat,requestFormat} "params" implies by default
// a behavior that automatically adds parameters corresponding to values and/or criteria (see
// the +link{type:RESTRequestFormat} docs for details), so you would not normally use this
// property to specify parameters based on request values.  Any params explicitly specified
// with the <code>params</code> property at DataSource of operationBinding level will be added
// to the auto-created list of params implied if <code>requestFormat</code> is "params".
//
// @serverDS only
// @group serverRestConnector
// @visibility external
//<

//> @attr operationBinding.params (String : null : IR)
// Applies to RestConnector dataSources (+link{dataSource.serverType,serverType} "rest") only.
// This is an operationBinding-level override of +link{DataSource.params} - see
// that property's documentation for details
// @serverDS only
// @group serverRestConnector
// @visibility external
//<

//> @attr dataSource.httpMethod (String : null : IR)
// Applies to RestConnector dataSources (+link{dataSource.serverType,serverType} "rest") only,
// and is overridable per operationBinding (see +link{operationBinding.httpMethod}).
// <p>
// Allows you to configure the HTTP method to use for this DataSource.  Since REST services
// typically use different HTTP methods for different types of operation - it is common to use
// GET for fetches and PUT for updates, for example - this property is more commonly set at
// the +link{operationBinding.httpMethod,operationBinding level} than at the DataSource level.
// See <a href=https://developer.mozilla.org/en-US/docs/Web/HTTP/Methods>this Mozilla article</a>
// for a list of valid HTTP methods.
// <p>
// If this property is not provided at either DataSource or opBinding level,
// <code>RestConnector</code> uses a default HTTP method depending on the type of operation:
// <table width="400">
// <tr><td>Operation type</td><td>HTTP Method</td></tr>
// <tr><td>Fetch</td><td>GET</td></tr>
// <tr><td>Add</td><td>POST</td></tr>
// <tr><td>Update</td><td>PUT</td></tr>
// <tr><td>Remove</td><td>DELETE</td></tr>
// </table>
//
// @serverDS only
// @group serverRestConnector
// @visibility external
//<

//> @attr operationBinding.httpMethod (String : null : IR)
// Applies to RestConnector dataSources (+link{dataSource.serverType,serverType} "rest") only.
// This is an operationBinding-level override of +link{DataSource.httpMethod} - see
// that property's documentation for details
// @serverDS only
// @group serverRestConnector
// @visibility external
//<


//> @type RESTRequestFormat
//
// Indicates the request format to be used for a REST operation.  Is only applicable to
// +link{group:serverRestConnector,RestConnector DataSources}.  Note for all of these
// <code>RESTRequestFormat</code> options, only simple key-value criteria are supported; to
// handle +link{object:AdvancedCriteria}, you can use a
// +link{dataSource.requestTemplate,requestTemplate}, or subclass
// <code>com.isomorphic.dataSource.RestConnector</code> and override the
// <code>applyValuesOrCriteriaToRequest()</code> method.
//
// @value "params"
// Indicates that context is provided to the target REST service by setting parameter values
// in the URL.  With this request format, the +link{class:DSRequest}'s values or criteria will
// be added to the +link{DataSource.dataURL,target dataURL} as standard HTTP parameters values as
// follows:<ul>
// <li>For "add" and "update" requests the "values" will be added to the target URL (see
// the server-side Javadoc for <code>DSRequest.getValues()</code>)</li>
// <li>For "fetch" and "remove" requests, where the concept of "values" doesn't make sense,
// the "criteria" will be added to the target URL (see the server-side Javadoc for
// <code>DSRequest.getCriteria()</code>)</li>
// </ul>
// So if we had a fetch request that specified criteria like this:<pre>
//    {countryCode: "US", stateCode: "CA"}
// </pre>
// and a +link{operationBinding.dataURL,dataURL} like this:<pre>
//    <dataURL>https://somerestservice.com/customer/fetch</dataURL>
// </pre>
// we would end up with a target URL like this:<pre>
//    https://somerestservice.com/customer/fetch?countryCode=US&stateCode=CA
// </pre>
// Also, note that any explicitly declared +link{dataSource.params,params} will also be added
// to the target URL as standard HTTP parameters, as well as the request values/criteria (if
// there are any name collisions, the request values/criteria take precedence).
// <p>
// This format is often used to supply criteria to "fetch" operations, and primary-key values
// to "remove" operations.  However, this is by no means a universal approach; different REST
// services adopt different approaches, there is no generally-accepted "right way" to handle
// things
// <p>
// It is possible to suppress this automatic mapping - see +link{dataSource.suppressAutoMappings}
//
// @value "json"
// Indicates that context is provided to the target REST service by providing a block of
// JSON-encoded text in the body of the HTTP request sent to the REST server.  With this
// request format, <code>RestConnector</code> will render an incoming
// +link{class:DSRequest}'s values or criteria as a JSON object; for "add" and "update" requests,
// the "values" will be used, and for "fetch" and "remove" operations, the criteria will be
// used (see the server-side Javadoc for <code>DSRequest.getCriteria()</code>).
// <p>
// So if we had an add request with the following record:<pre>
//    {
//       customerId: 7023,
//       customerName: "Bay Financials inc",
//       city: "San Francisco",
//       countryCode: "US",
//       stateCode: "CA"
//    }
// </pre>
// those values would be included, in strict JSON form, in the body of the HTTP request that
// <code>RestConnector</code> sends to the REST webservice:<pre>
//    {"customerId": 7023,"customerName": "Bay Financials inc",
//     "city: "San Francisco","countryCode": "US", "stateCode": "CA"}
// </pre>
// <p>
// This format is most often used when you need to supply more extensive amounts of data, like
// entire records to "add" and "update" operations.  However, as mentioned above, this is by no
// means a universal approach, and some REST services use URL parameters even when specifying
// entire records of data.  Also, some REST services use XML rather than JSON
// <p>
// Note, if there is a +link{dataSource.requestTemplate,requestTemplate} in force, we use that
// to drive the content and format of the generated JSON block
//
// @value "xml"
// Indicates that context is provided to the target REST service by providing a block of
// XML text in the body of the HTTP request sent to the REST server.  With this
// request format, <code>RestConnector</code> will render an incoming
// +link{class:DSRequest}'s values or criteria as a snippet of XML text; for "add" and "update"
// requests, the "values" will be used, and for "fetch" and "remove" operations, the criteria
// will be used (see the server-side Javadoc for <code>DSRequest.getCriteria()</code>).  The
// name of the enclosing tag is specified in +link{dataSource.xmlTag}.
// <p>
// So if we had an add request with the following record:<pre>
//    {
//       customerId: 7023,
//       customerName: "Bay Financials inc",
//       city: "San Francisco",
//       countryCode: "US",
//       stateCode: "CA"
//    }
// </pre>
// those values would be included in the body of the HTTP request that <code>RestConnector</code>
// sends to the REST webservice (assuming the <code>xmlTag</code> is "customer"):<pre>
//    &lt;customer&gt;
//        &lt;customerId&gt;7023&lt;/customerId&gt;
//        &lt;customerName&gt;Bay Financials inc"&lt;/customerName&gt;
//        &lt;city&gt;San Francisco&lt;/city&gt;
//        &lt;countryCode&gt;US&lt;/countryCode&gt;
//        &lt;stateCode&gt;CA"&lt;/stateCode&gt;
//    &lt;/customer&gt;
// </pre>
// <p>
// Note, if there is a +link{dataSource.requestTemplate,requestTemplate} in force, we use that
// to drive the content and format of the generated XML
//
// @group serverRestConnector
// @visibility external
// @serverDS only
//<

//> @attr dataSource.requestFormat (RESTRequestFormat : null : IR)
// For a +link{group:serverRestConnector,RestConnector DataSource}, the request format to
// use when contacting the remote REST service.  Can be overridden at operationBinding level,
// see +link{operationBinding.requestFormat}.  Note, if <code>requestFormat</code> is not
// specified at either the DataSource or OperationBinding level, the request will be rejected.
// @serverDS only
// @group serverRestConnector
// @visibility external
//<

//> @attr operationBinding.requestFormat (RESTRequestFormat : null : IR)
// For a +link{group:serverRestConnector,RestConnector DataSource}, the request format to
// use for this specific operationBinding.  Overriddes any
// +link{dataSource.requestFormat,DataSource-level setting}.
// Note, if <code>requestFormat</code> is not specified at either the DataSource or
// OperationBinding level, the request will be rejected.
// @serverDS only
// @group serverRestConnector
// @visibility external
//<


//> @type RESTResponseFormat
//
// Indicates the response format to be used for a REST operation.  Is only applicable to
// +link{group:serverRestConnector,RestConnector DataSources}.
//
// @value "json"
// Indicates that the REST service response is a valid <a href=https://www.json.org/json-en.html>JSON</a>
// message.  We will parse the response text as JSON, and the resulting object structure can
// be further processed with +link{dataSource.recordXPath,XPaths},
// +link{dataSource.responseTemplate,templates} and
// +link{dataSource.transformResponseScript,scripting}
//
// @value "xml"
// Indicates that the REST service response is an XML message.  We will parse the response text
// as XML, and the resulting object structure can be further processed with
// XPaths, templates and scripting
//
// @value "csv"
// Indicates that the the REST service response is in delimited text format in the
// body of the HTTP response.  We will parse the response text as delimited flat text data,
// and the resulting object structure can be further processed with scripting.  Note, we do
// not support XPaths because they do not make sense with flat data, and we also do not
// support templating of CSV responses.  Record-level and field-level transformation scripts,
// however, are applicable, and field +link{dataSourceField.nativeName,nativeName}s are honored
// if the CSV text includes a header row
// <p>
// <code>RestConnector</code> only supports a couple options for CSV-based REST services - see
// +link{dataSource.csvDelimiter} and +link{dataSource.csvQuoteCharacter}
//
// @value "text"
// Indicates that REST service response is to be treated simply as a piece of text, with no
// parsing or other processing attempted.  Use this format for services that return simple
// strings or messages in some non-standard format; you can provide your own parsing logic in
// a +link{dataSource.transformResponseScript,transformResponseScript}
//
// @group serverRestConnector
// @visibility external
// @serverDS only
//<

//> @attr dataSource.responseFormat (RESTResponseFormat : null : IR)
// For a +link{group:serverRestConnector,RestConnector DataSource}, the response format to
// use.  Can be overridden at operationBinding level, see +link{operationBinding.responseFormat}
// Note, if <code>responseFormat</code> is not specified at either the DataSource or
// OperationBinding level, response processing will throw an exception.
// @serverDS only
// @group serverRestConnector
// @visibility external
//<

//> @attr operationBinding.responseFormat (RESTResponseFormat : null : IR)
// For a +link{group:serverRestConnector,RestConnector DataSource}, the response format to
// use for this specific operationBinding.  Overriddes any
// +link{dataSource.responseFormat,DataSource-level setting}.
// Note, if <code>responseFormat</code> is not specified at either the DataSource or
// OperationBinding level, response processing will throw an exception.
// @serverDS only
// @group serverRestConnector
// @visibility external
//<

//> @attr dataSource.wrapInList (Boolean : false : IR)
// Applies to RestConnector dataSources (+link{dataSource.serverType,serverType} "rest") only,
// and is overridable per operationBinding (see +link{operationBinding.wrapInList}).
// <p>
// When true, and the +link{dataSource.requestFormat,requestFormat} is "json", and the
// +link{class:DSRequest,dsRequest} only contains a single valueSet, we will wrap that single
// valueSet in a list before sending to the remote REST server.  This is useful if you have
// a remote service that wants data to be supplied as a list, even when there is only one
// entry in the list
//
// @serverDS only
// @group serverRestConnector
// @visibility external
//<

//> @attr operationBinding.wrapInList (Boolean : false : IR)
// Applies to RestConnector dataSources (+link{dataSource.serverType,serverType} "rest") only.
// This is an operationBinding-level override of +link{DataSource.wrapInList} - see
// that property's documentation for details
//
// @serverDS only
// @group serverRestConnector
// @visibility external
//<

//> @attr dataSource.xmlTag (String : null : IR)
// Applies to RestConnector dataSources (+link{dataSource.serverType,serverType} "rest") only,
// and is overridable per operationBinding (see +link{operationBinding.xmlTag}).
// <p>
// This property specifies the name of the enclosing tag when we are generating the XML block
// used to send context to a REST service where the +link{dataSource.requestFormat} is "xml"
//
// @serverDS only
// @group serverRestConnector
// @visibility external
//<

//> @attr operationBinding.xmlTag (String : null : IR)
// Applies to RestConnector dataSources (+link{dataSource.serverType,serverType} "rest") only.
// This is an operationBinding-level override of +link{DataSource.xmlTag} - see
// that property's documentation for details
//
// @serverDS only
// @group serverRestConnector
// @visibility external
//<

//> @attr dataSource.csvDelimiter (String : "," : IR)
// Applies to RestConnector dataSources (+link{dataSource.serverType,serverType} "rest") only,
// and is overridable per operationBinding (see +link{operationBinding.csvDelimiter}).
// <p>
// This property specifies the character to recognise as the delimiter when parsing REST
// service responses where the +link{dataSource.responseFormat} is "csv"
//
// @serverDS only
// @group serverRestConnector
// @visibility external
//<

//> @attr operationBinding.csvDelimiter (String : "," : IR)
// Applies to RestConnector dataSources (+link{dataSource.serverType,serverType} "rest") only.
// This is an operationBinding-level override of +link{DataSource.csvDelimiter} - see
// that property's documentation for details
//
// @serverDS only
// @group serverRestConnector
// @visibility external
//<

//> @attr dataSource.csvQuoteCharacter (String : '"' : IR)
// Applies to RestConnector dataSources (+link{dataSource.serverType,serverType} "rest") only,
// and is overridable per operationBinding (see +link{operationBinding.csvQuoteCharacter}).
// <p>
// This property specifies the character to treat a string quotation mechanism when parsing
// REST service responses where the +link{dataSource.responseFormat} is "csv".  Text in CSV
// responses does not have to quote string data, but many uses of CSV do quote strings because
// it allows text in the data to contain occurences of the +link{dataSource.csvDelimiter}.  For
// example, if the <code>csvDelimiter</code> is the default value of ",", quoting allows the
// following text, which would otherwise be ambiguous:<pre>
//   1,ABC,"This is a text string, with a comma in the middle"</pre>
//
// @serverDS only
// @group serverRestConnector
// @visibility external
//<

//> @attr operationBinding.csvQuoteCharacter (String : '"' : IR)
// Applies to RestConnector dataSources (+link{dataSource.serverType,serverType} "rest") only.
// This is an operationBinding-level override of +link{DataSource.csvQuoteCharacter} - see
// that property's documentation for details
//
// @serverDS only
// @group serverRestConnector
// @visibility external
//<


//> @attr dataSource.suppressAutoMappings (Boolean : false : IR)
// Applies to RestConnector dataSources (+link{dataSource.serverType,serverType} "rest") only,
// and is overridable per operationBinding (see +link{operationBinding.requestTemplate}).
// <p>
// By default, if you have a +link{dataSource.requestFormat,requestFormat} of "params",
// <code>RestConnector</code> will add your values or criteria as standard HTTP parameters to
// the the URL it generates for hitting the target REST server - this is described in more
// detail in the +link{type:RESTRequestFormat} documentation.
// <p>
// With a <code>requestFormat</code> of "json", <code>RestConnector</code> will generate a
// block of JSON from your criteria or values, again as described in the
// <code>RESTRequestFormat</code> docs
// <p>
// You can switch off both of these behaviors by setting this property true
//
// @serverDS only
// @group serverRestConnector
// @visibility external
//<

//> @attr operationBinding.suppressAutoMappings (Boolean : false : IR)
// Applies to RestConnector dataSources (+link{dataSource.serverType,serverType} "rest") only.
// This is an operationBinding-level override of +link{DataSource.suppressAutoMappings} - see
// that property's documentation for details
//
// @serverDS only
// @group serverRestConnector
// @visibility external
//<

//> @attr dataSource.requestTemplate (String : null : IR)
// Applies to +link{group:serverRestConnector,RestConnector dataSources}
// (+link{dataSource.serverType,serverType} "rest") only, and is overridable per
// operationBinding (see +link{operationBinding.requestTemplate}).
// <p>
// If you have a +link{dataSource.requestFormat,requestFormat} of "json" or "xml",
// <code>RestConnector</code> will generate a block of JSON or XML, as appropriate, from your
// criteria or values, as described in the +link{type:RESTRequestFormat} docs.  You can also
// specify a <code>requestTemplate</code>, and <code>RestConnector</code> will use the template
// to drive the generation of the JSON or XML, so you can use the full power of the Velocity
// Templating Language to perform mappings and other transformations, all declaratively.  The
// process involves the following steps:<ol>
// <li>We parse the template as JSON or XML, as appropriate, and convert it into an internal
// object structure</li>
// <li>Velocity templating is now performed on this structure, with the +link{class:DSRequest}
// values and criteria as context variables</li>
// <li>We serialize the result of this process back to JSON or XML</li>
// </ol>
// Note, if you provide a <code>requestTemplate</code>, it serves as the basis for the entire
// JSON or XML structure sent to the REST server, so you can include, omit, rename or transform
// values from the client request as required.  Also note, if the +link{class:DSRequest,dsRequest}
// has multiple valueSets (records), we will apply the template to each valueSet in turn, to
// construct a list for sending to the remote REST service (but note, this only works if the
// <code>requestFormat</code> is "json").
// <p>
// <h3>Example templates</h3>
// Templates can make use of all of the conditional and iteration features of the Velocity
// Template Language, so can be used to perform some fairly sophisticated transformations.
// Consider a case where we have an update request with data like this sent from the client:<pre>
// {
//      pk: 1234,
//      foo: 27,
//      bar: true,
//      abc: "String Value"
// }</pre>
// This record contains all the information you need to send an update request to the remote
// REST server, but that server requires things in a different format, with different field
// names, different representations of boolean values, and an additional field whose value
// is derived.  This record looks like this:<pre>
// {
//      id: 1234, // pk from our client record
//      FOO: 27,  // foo from our client record
//      BAR: 1,  // bar from our client record, true == 1, false == 0
//      def: "String value"  // abc from our client record
//      isTBD: 0  // should be 1 if "def" == "TBD", otherwise 0
// }</pre>
// The following template would declaratively handle the necessary mappings from one format
// to the other:<pre>
// &lt;requestTemplate&gt;
// {
//      "id": $values.pk,
//      "FOO": $values.foo,
//      "BAR": #if($values.bar) 1 #else 0 #end,
//      "def": "$values.abc",
//      "isTBD": #if($values.abc == "TBD") 1 #else 0 #end
// }
// &lt;/requestTemplate&gt;</pre>
// And the same thing in XML (this may require setting an +link{dataSource.xmlTag,xmlTag}
// and/or providing additional levels of containment to match the target server's structure -
// XML often requires more boilerplate than JSON):<pre>
// &lt;requestTemplate&gt;
//   &lt;record&gt;
//      &lt;id&gt;$values.pk&lt;/id&gt;
//      &lt;FOO&gt;$values.foo&lt;/FOO&gt;
//      &lt;BAR&gt;#if($values.bar)1#else0#end&lt;/BAR&gt;
//      &lt;def&gt;$values.abc&lt;/def&gt;
//      &lt;isTBD&gt;#if($values.abc == "TBD")1#else0#end&lt;/isTBD&gt;
//   &lt;/record&gt;
// &lt;/requestTemplate&gt;</pre>
// Templates can also be used to flatten structured data.  Say we have this incoming record:<pre>
// {
//      customerId: 2770
//      name: "Snape Networks Inc",
//      contacts: [
//          {name: "Isaura Lopez", title: "IT Manager"},
//          {name: "Ngozi Okoduwa", title: "VP Procurement"},
//          {name: "Andrew Jenkins", title: "Buyer"}
//      ]
// }</pre>
// The target REST server does not support a list of contact details, just two contact names:<pre>
// {
//      Id: 2770,
//      Name: "Snape Networks Inc",
//      Contact1: "Isaura Lopez",
//      Contact2: "Ngozi Okoduwa"
// }</pre>
// This transformation could be achieved with the following template:<pre>
// &lt;requestTemplate&gt;
// {
//      Id: $values.customerId,
//      Name: "$values.name",
//      #foreach ($contact in $values.contacts)
//        #if ($foreach.count > 2) #break  #end
//      Contact$foreach.count: "$contact.name"
//      #end
// }
// &lt;/requestTemplate&gt;</pre>
// See the +externalLink{https://velocity.apache.org/engine/2.3/user-guide.html, Velocity User Guide}
// for full details of Velocity's templating features
//
// @see operationBinding.requestTemplate
// @see dataSource.transformRequestScript
// @see dataSource.responseTemplate
//
// @serverDS only
// @group serverRestConnector
// @visibility external
//<

//> @attr operationBinding.requestTemplate (String : null : IR)
// Applies to RestConnector dataSources (+link{dataSource.serverType,serverType} "rest") only.
// This is an operationBinding-level override of the +link{DataSource.requestTemplate} - see
// that property's documentation for details
//
// @see dataSource.requestTemplate
// @see operationBinding.transformRequestScript
// @see operationBinding.responseTemplate
//
// @serverDS only
// @group serverRestConnector
// @visibility external
//<


//> @attr dataSource.responseTemplate (String : null : IR)
// Applies to RestConnector dataSources (+link{dataSource.serverType,serverType} "rest") only,
// and is overridable per operationBinding (see +link{operationBinding.responseTemplate}).
// <p>
// If you have a +link{dataSource.responseFormat,responseFormat} of "json" or "xml", this
// property allows you to specify a template for <code>RestConnector</code> to use in order
// to construct response data for the client, from the response data sent by the REST server.
// This allows you to use the full power of the Velocity Templating Language to perform mappings
// and other transformations, all declaratively.  The process involves the following steps:<ol>
// <li>We parse the REST response text as either JSON or XML, depending on the
// <code>responseFormat</code></li>
// <li>If a +link{dataSource.recordXPath,record-level XPath} is declared, it is applied to the
// parsed REST response data</li>
// <li>We parse the template as JSON and convert it into an internal object structure</li>
// <li>Velocity templating is now performed on this structure, with the processed REST response
// data provided as context variables.  Templates intended for use with multi-record datasets
// should be framed in terms of a single record - if the REST response data consists of multiple
// records, each record will be put through the template in turn</li>
// <li>If the original request came from a remote client (eg, a browser-based UI), the same
// downstream serialization logic as used for all other DataSource types will serialize this
// processed structure in accordance with the +link{DataSource.dataFormat,client-server dataFormat}
// in use; this is completely separate from the <code>responseFormat</code> used to process the
// response from the REST server</li>
// </ol>
// Note, if you provide a <code>responseTemplate</code>, it serves as the basis for the entire
// JSON or XML structure sent back the client, so you can include, omit, rename or transform values
// from the client request as required.
// <p>
// <h3>Example template</h3>
// Consider a case where the REST server sends back this structure:<pre>
// {
//      "ID": 1234,
//      "FOO": 27,
//      "BAR": "TRUE",
//      "ABC": "String Value"
// }</pre>
// Or, equivalently for a <code>responseFormat</code> of XML (note, this would also require
// a +link{dataSource.recordXPath,recordXPath} of "/ITEM" to navigate to the subvalues):<pre>
// &lt;?xml version="1.0" encoding="UTF-8"?&gt;
// &lt;ITEM&gt;
//     &lt;ID&gt;1234&lt;/ID&gt;
//     &lt;FOO&gt;27&lt;/FOO&gt;
//     &lt;BAR&gt;TRUE&lt;/BAR&gt;
//     &lt;ABC&gt;String value&lt;/ABC&gt;
// &lt;/ITEM&gt;</pre>
// You need to transform this into the record format required by your local dataSource, which
// looks like this:<pre>
// {
//      id: 1234, // ID from the REST response
//      zoo: 27,  // FOO from the REST response
//      baz: true,  // BAR from the REST response
//      def: "String value"  // abc from the REST response
//      isTBD: false  // should be true if "def" == "TBD", otherwise false
// }</pre>
// The following template would declaratively handle the necessary mappings from one format
// to the other:<pre>
// &lt;responseTemplate&gt;
// {
//      id: $restResponseData.ID,
//      zoo: $restResponseData.FOO,
//      baz: #if($restResponseData.BAR == "TRUE") true #else false #end,
//      def: "$restResponseData.ABC",
//      isTBD: #if($restResponseData.ABC == "TBD") true #else false #end
// }
// &lt;/responseTemplate&gt;</pre>
// Logically, it makes sense to express the template in JSON: XML is only the format of the
// data sent back by the remote REST server; by the time we come to apply the template, that
// XML has already been parsed into an internal memory structure based on Java Lists and Maps,
// and JSON is the simplest text-based analog of that data structure.
// <p>
// However, if you have a +link{dataSource.requestFormat} of "xml", you will be expressing your
// +link{dataSource.requestTemplate,requestTemplate} in XML; again, this makes sense because
// the <code>requestTemplate</code> is a representation of the actual text we are going to send
// to the remote REST server, whereas the <code>responseTemplate</code> is not a direct
// representation of anything (post-templating, it will be serialized in the format that the
// <i>client</i> requires, which unrelated to the format required by the remote REST server).
// <p>
// Even though this difference makes sense, it may seem confusing or inconsistent to express
// the <code>requestTemplate</code> as XML and the <code>responseTemplate</code> as JSON, so
// when <code>requestFormat</code> is "xml", we support expressing the
// <code>responseTemplate</code> in either JSON or XML.  So if you prefer, you could write
// this template in XML:<pre>
// &lt;responseTemplate&gt;&lt;![CDATA[
//   &lt;ITEM&gt;
//      &lt;id&gt;$restResponseData.ID&lt;is/id&gt;
//      &lt;zoo&gt;$restResponseData.FOO&lt;/zoo&gt;
//      &lt;baz&gt;#if($restResponseData.BAR == "TRUE") true #else false #end&lt;/baz&gt;
//      &lt;def&gt;$restResponseData.ABC&lt;/def&gt;
//      &lt;isTBD&gt;#if($restResponseData.ABC == "TBD") true #else false #end&lt;isTBD&gt;
//   &lt;/ITEM&gt;
// ]]&gt;&lt;/responseTemplate&gt;</pre>
// See the +externalLink{https://velocity.apache.org/engine/2.3/user-guide.html, Velocity User Guide}
// for full details of Velocity's templating features
//
// @see operationBinding.responseTemplate
// @see dataSource.transformResponseScript
// @see dataSource.requestTemplate
//
// @serverDS only
// @group serverRestConnector
// @visibility external
//<

//> @attr operationBinding.responseTemplate (String : null : IR)
// Applies to RestConnector dataSources (+link{dataSource.serverType,serverType} "rest") only.
// This is an operationBinding-level override of the +link{DataSource.responseTemplate} - see
// that property's documentation for details
//
// @see dataSource.responseTemplate
// @see operationBinding.transformResponseScript
// @see operationBinding.requestTemplate
//
// @serverDS only
// @group serverRestConnector
// @visibility external
//<


//> @attr dataSource.requiresCompleteRESTResponse (Boolean : false : IR)
// Applies to RestConnector dataSources (+link{dataSource.serverType,serverType} "rest") only,
// and is overridable per operationBinding (see
// +link{operationBinding.requiresCompleteRESTResponse}).
// <p>
// If true, this flag indicates that the DataSource requires access to the entire REST response,
// not just the data part configured by the +link{dataSource.recordXPath,recordXPath}.  This
// is often the case for REST services that send back useful metadata alongside the data itself.
// For example, some REST services limit the number of records that can be retrieved in one
// service call, and will return the total number of records actually available in some kind
// of metadata property.
// <p>
// This is useful information that a DataSource can use in custom logic to return a richer
// response to the client.  This custom logic can be written in Java in a
// +link{group:dmiOverview,DMI method} or
// +link{dataSource.serverConstructor,custom DataSource implementation}, or in any JSR223
// scripting language, as a +link{dataSource.script,server script} or
// +link{dataSource.transformResponseScript,response transformation script}.
// <p>
// When this flag is true, the complete REST response is available to your server-side custom
// code as follows:<ul>
// <li>For a DMI or custom dataSource implementation that invokes the <code>RestConnector</code>
// built-in logic by calling <code>execute()</code> on either the <code>DSRequest</code> or the
// <code>DataSource</code> itself (this would be a <code>super()</code> call for a custom impl),
// the <code>DSResponse</code> returned to your code will contain a property called
// "completeData"</li>
// <li>For a <code>&lt;script&gt;</code> or <code>&lt;transformResponseScript&gt;</code>, a
// variable called "completeData" will be available to your script (completeData is also
// available as <code>dsResponse.completeData</code>)</li>
// </ul>
// Note, for requests that came originally from a remote client, the "completeData" property of
// the <code>DSResponse</code> will be serialized and returned to the client.  If you do not
// want this, your custom server code should remove that property from the
// <code>DSResponse</code> when it has finished with it.
//
// @serverDS only
// @group serverRestConnector
// @visibility external
//<

//> @attr operationBinding.requiresCompleteRESTResponse (String : null : IR)
// Applies to RestConnector dataSources (+link{dataSource.serverType,serverType} "rest") only.
// This is an operationBinding-level override of +link{DataSource.requiresCompleteRESTResponse}
// - see that property's documentation for details
//
// @serverDS only
// @group serverRestConnector
// @visibility external
//<


//> @attr dataSource.auth (RESTAuthentication : null : IRW)
// For a +link{group:serverRestConnector,RestConnector DataSource}, authentication details
// for the REST service.  Note, although RestConnector-specific details would typically be
// wrapped in a +link{dataSource.serverConfig,serverConfig block} to prevent information
// leakage to the client, we automatically exclude the <code>auth</code> block even if it is
// not inside <code>serverConfig</code>, because this is information that is always sensitive,
// and never required on the client
// @serverDS only
// @group serverRestConnector
// @visibility external
//<

//> @object RESTAuthentication
// Authentication settings, applicable only to the +link{group:serverRestConnector,RestConnector}
//
// @serverDS only
// @group serverRestConnector
// @treeLocation Client Reference/Data Binding/DataSource
// @visibility external
//<

//> @attr RESTAuthentication.type (RESTAuthenticationType : null : IR)
// For a +link{group:serverRestConnector,RestConnector DataSource}, the authentication type
// to use.  Note, as well as the formal header-based authentication types used by most REST
// services, <code>RestConnector</code> can also support more ad-hoc auth schemes, such as
// sending a username/password or authentication token in the body of a request.  Whether or
// not such non-standard auth schemes are a good idea is academic; if the REST endpoint you
// need to target is expecting a token in a URL param, that's what you have to provide.
// <p>
// Because <code>RestConnector</code> is so configurable, it is easy to achieve this.
// Assuming you have an API token that must be passed as parameter "Token", and that token is
// stored in your <code>system.properties</code> file, achieving this is as easy as adding the
// following to your +link{dataSource.serverConfig,serverConfig}:<pre>
//    &lt;params&gt;
//        &lt;Token&gt;$config['myrestservice.apikey']&lt;/Token&gt;
//    &lt;/params&gt;
// </pre>
// Note, if the REST service you are targeting does have a non-standard auth scheme that does
// not use the HTTP Authorization header, you should simply omit the
// +link{dataSource.auth,auth block}
// @serverDS only
// @group serverRestConnector
// @visibility external
//<

//> @type RESTAuthenticationType
//
// Enumeration of the supported authentication types for the
// +link{group:serverRestConnector,RestConnector} implementation.  Note, all of these authentication
// types are secure, but only if you use HTTPS
//
// @value "basic"
// Use a "Basic" HTTP Authorization header.  Requires both a
// +link{restAuthentication.username,username} and a +link{restAuthentication.password,password},
// which are combined and Base64-encoded in the HTTP request header.  Note, you can also use
// this auth type for services that allow for Basic authentication using a combination of user
// and long-lived API key (ie, an API key or token that is generated by the auth server and is
// used instead of a password for this particular client application, but does not need to be
// regularly renewed)
//
// @value "bearerToken"
// Use a "Bearer" HTTP Authorization header with a bearer token obtained from an OAuth 2.0
// client credentials server or other auth scheme that can generate bearer tokens (also known
// as API tokens or API keys).  This auth type can handle both long-lived tokens, such as API
// keys that are generated once for an application and never change, and so-called
// "access tokens" that are only valid for a limited period of time - usually no more than a
// few hours - and must be refreshed when they expire.  See +link{restAuthentication.dataSource}
//
// @value "authHeader"
// Use a manually-constructed HTTP Authorization header.  This auth type requires an
// +link{restAuthentication.dataSource,authentication dataSource} that returns a record
// containing a well-formed Authorization header value in a field called
// "authorizationHeader" (this can be overridden, see the authentication dataSource docs
// mentioned above)
//
// @serverDS only
// @group serverRestConnector
// @visibility external
//<

//> @attr RESTAuthentication.username (String : null : IR)
// For a +link{group:serverRestConnector,RestConnector DataSource}, the username to authenticate
// with if you are using +link{type:RESTAuthenticationType,basic authentication}
//
// @serverDS only
// @group serverRestConnector
// @visibility external
//<

//> @attr RESTAuthentication.password (String : null : IR)
// For a +link{group:serverRestConnector,RestConnector DataSource}, the password to authenticate
// with if you are using +link{type:RESTAuthenticationType,basic authentication}.  Note, for
// services that support Basic authentication but require an API key rather than a password,
// you still use this property, just set it to the API key instead
//
// @serverDS only
// @group serverRestConnector
// @visibility external
//<

//> @attr RESTAuthentication.authToken (String : null : IR)
// For a +link{group:serverRestConnector,RestConnector DataSource} using
// +link{type:RESTAuthenticationType,bearerToken authentication}, the token to use.  This
// attribute is for use when you are using bearerToken auth with a long-lived token, such as
// a fixed API key, rather than a regularly changing refresh/accept pattern.  If you need to
// use the refresh/accept token pattern, omit this attribute and instead declare an
// +link{RESTAuthentication.dataSource,authentication dataSource}
//
// @serverDS only
// @group serverRestConnector
// @visibility external
//<

//> @attr RESTAuthentication.authHeader (String : null : IR)
// For a +link{group:serverRestConnector,RestConnector DataSource} using
// +link{type:RESTAuthenticationType,authHeader authentication}, the complete, well-formed
// header value to set for the "Authorization" HTTP header.  This attribute is for use when
// you are using authHeader authentication with a long-lived token, such as a fixed API key,
// rather than a regularly changing refresh/accept pattern.  If you need to use the
// refresh/accept token pattern, omit this attribute and instead declare an
// +link{RESTAuthentication.dataSource,authentication dataSource}
//
// @serverDS only
// @group serverRestConnector
// @visibility external
//<

//> @attr RESTAuthentication.dataSource (DataSource | ID : null : IR)
// For a +link{group:serverRestConnector,RestConnector DataSource}, a second dataSource that is capable
// of fetching tokens that this dataSource can use to authenticate requests.  This property is
// required for +link{type:RESTAuthenticationType,bearerToken} and
// +link{type:RESTAuthenticationType,authHeader} authentication types.
// <p>
// Typically, this dataSource will be a separate "rest" dataSource that connects to the token
// vending endpoint of an authorization server, passing in a "refresh" token and getting back
// an "access" token.  Access tokens are typically short-lived, to minimize their usefulness
// to attackers if the token should somehow be exposed.  When an access token expires it must
// be refreshed by again connecting to the token vending endpoint of the authorization server.
// <code>RestConnector</code> handles all the mechanics of this for you; you just have to
// provide a dataSource that can do the fetch.
// <p>
// Note, <code>RestConnector</code> will issue a straightforward fetch with null criteria on
// the authentication dataSource when it needs to refresh its access token.  This means that
// the authentication dataSource must be able to supply the refresh token to the REST auth
// endpoint without context from the dataSource fetch request.  As mentioned above, the
// authentication dataSource is typically another "rest" dataSource, so you can use
// <code>RestConnector</code>'s extensive request templating features to accomplish this - for
// example, by embedding a reference to a <code>server.properties</code> property in the
// +link{dataSource.dataURL,dataURL}
// <p>
// A <code>RestConnector</code> authentication dataSource should include the following fields.
// Note, the "Field name" shown in the table is just the default; you can override the name of
// any of these fields by setting the property shown in the "Customize" column.  So, eg, if
// you set <code>tokenField: "custom_token"</code> in the +link{object:RESTAuthentication,auth}
// config block, we will expect the dataSource to contain a field called "custom_token" instead
// of the default "access_token"
// <table>
// <tr style="background-color:#444444;color:#ffffff">
// <td>Field name</td><td>Description</td><td>Customize</td></tr>
// <tr>
// <td><code>access_token</code></td>
// <td>For "bearerToken" auth only, field containing the bearer token to be set in the
//     Authorization header (SmartClient will add the "Bearer" text)</td>
// <td><code>tokenField</code></td>
// </tr><tr>
// <td><code>authorizationheader</code></td>
// <td>For "authHeader" auth only, field containing the complete, well-formed header value to
//     be set in the Authorization header</td>
// <td><code>headerAuthorizationField</code></td>
// </tr><tr>
// <td><code>expires</code></td>
// <td>Absolute point in time when this token expires, expressed as milliseconds since the
//     epoch (midnight on January 1st 1970)</td>
// <td><code>expiresField</code></td>
// </tr><tr>
// <td><code>expires_in</code></td>
// <td>Length of time from now before this token expires, expressed as a number of seconds.
//     If "expires" is also present, "expires" is used in preference to "expires_in".  If
//     neither value is present, the token is considered to be one that does not expire</td>
// <td><code>expiresInField</code></td>
// </table>
//
// @serverDS only
// @group serverRestConnector
// @visibility external
//<



// ================================ RestConnector end =============================


// =============================== Basic DS Templating ============================


//> @type DataSourceTemplateReferenceMode
//
// Indicates the mode to use for resolving templated references in a DataSource's configuration
// file.  See +link{dataSource.allowTemplateReferences} for an overview of configuration
// templating.
//
// @value "none"
// Indicates that no resolution of templated references should be done
//
// @value "configOnly"
// Indicates that a simple find-and-replace process should resolve templated references.  In
// this mode, the system looks for references strictly like the one below, and replaces them
// with the referenced property from your <code>server.properties</code> file.  So if your
// <code>server.properties</code> file contained an entry like this:<pre>
//     database.name: MyDatabase
// </pre>
// the below example would cause <code>dbName</code> to be resolved as <code>MyDatabase</code><pre>
//     dbName="$config['database.name']"
// </pre>
// (Note, you can use a different token than "<code>$config</code>" if you need to - see
// +link{dataSource.templateConfigToken,templateConfigToken})
//
// @value "all"
// Indicates that full Velocity processing will be used to resolve templated references.  This
// allows you to use all of Velocity's template-handling features - for example, conditional
// blocks and iteration - and so is more powerful than the simple "configOnly" option above.
// Note, however, that this templating is necessarily limited by the fact that it takes place
// during DataSource initialization, when there is not a lot of context available for
// templating purposes - you have the "<code>$config</code>" object, as with "configOnly", and
// some of the other variables listed in the +link{group:velocitySupport,Velocity overview},
// but nothing relating to +link{class:DSRequest}s
//
// @see dataSource.templateConfigToken
//
// @serverDS only
// @visibility external
//<

//> @attr dataSource.allowTemplateReferences (DataSourceTemplateReferenceMode : See Below : IR)
// Indicates the mode to use for resolving templated references in this DataSource's
// configuration file.  A "templated reference" is a reference that makes use of a special
// token to indicate it is a placeholder that should be replaced with a value derived from
// the <code>server.properties</code> file - in "<code>all</code>" mode, other relatively
// static context available to the Velocity engine can also be used - during DataSource
// initialization.  You can place a templated reference inside any string property, anywhere
// in your <code>.ds.xml</code> file.
// <p>
// Templated references are a simple, lightweight way to introduce a level of dynamism to
// DataSource configuration.  For example, you could use a templated reference to dynamically
// set the +link{dataSource.dbName}
// <p>
// If you need more extensive support for dynamic DataSources than can be provided with
// templated references, you can completely customize configuration on-the-fly using a Dynamic
// DataSource Generator - see the server-side API
// <code>com.isomorphic.datasource.DataSource.addDynamicDSGenerator()</code>
// <p>
// The default value for this property is generally "<code>configOnly</code>" - any DataSource
// that extends <code>BasicDataSource</code>, including the built-in SQL, Hibernate and JPA
// DataSource implementations, will default to this setting.  You can override this across the
// board by adding a setting like this to your <code>server.properties</code> file:<pre>
//    dataSource.default.allowTemplateReferences: none
//    # or dataSource.default.allowTemplateReferences: all
// </pre>
// For +link{group:serverRestConnector,RestConnector} DataSources
// (+link{dataSource.serverType,serverType}s "rest" and "odata"), the default value for this
// property is "<code>all</code>", in keeping with that DataSource's extensive support for
// Velocity templating.
//
// @see dataSource.templateConfigToken
//
// @serverDS only
// @visibility external
//<

//> @attr dataSource.templateConfigToken (String : "$config" : IR)
// The special token to look for when trying to resolve template references when the
// +link{dataSource.allowTemplateReferences,template references mode} is
// "<code>configOnly</code>".  In this mode, the system looks for this token, followed by the
// strict pattern <code>["property_name"]</code> (single quotes are allowed instead of double
// quotes, but that is the only supoprted variation).
// <p>
// By default the template token is "<code>$config</code>" because that is the token used for
// Velocity templating, and is thus familiar.  If you need to use a different token - perhaps
// because the "$" symbol already has special significance in your system - you can do so by
// setting this property.  For example, if you set <code>templateConfigToken="#conf"</code>,
// your templated references would look like this:<pre>
//    someProperty="#conf['my.property.name']"
// </pre>
//
// @see dataSource.allowTemplateReferences
//
// @serverDS only
// @visibility external
//<

// ============================= Basic DS Templating end ==========================

//<ISC_140

//> @groupDef unionDataSource
// The UnionDataSource assimilates records from multiple member dataSources, matching fields
// by name and data type, or by explicit configuration.  Different types of member dataSource
// are allowed, so you can union SQL data with Hibernate data and generic data from a legacy
// system, for example.  For efficiency, SmartClient will use the SQL UNION keyword to achieve
// the data union for any members dataSources that are +link{group:sqlDataSource, SQL DataSource}s;
// data from any non-SQL members is combined in Java code as a post-process.
// <p>
// Like other dataSource types, unionDataSources can filter, sort and page their bonded data
// sets, and other dataSource features like +link{dataSourceField.viewRequires,declarative security}
// and +link{dataSourceField.includeFrom,included fields} work as you would expect.  However,
// +link{group:serverSummaries,Server Summaries} and grouping do not currently work with UnionDS.
// <p>
// <b>Example usage</b><br>
// UnionDataSource is useful when you need a unified view of data entities that, for whatever
// reason, you ordinarily keep separate.  A plausible example is Customers and Suppliers; those
// are two distinct entities, and would typically be implmented as separate database tables or
// Hibernate persistent classes, or whatever.  This makes sense: there are lots of things you
// want to know about a Customer that are not relevant for a Supplier, and vice versa.  In most
// ways, these are not similar things.
// <p>
// However, from a Customs point of view, Customers and Suppliers <i>are</i> similar - they are
// both Trading Partners.  As mentioned above, you probably store lots of things about
// Customers that you don't store about Suppliers and vice versa, but there will be a set of
// fields common to both - name, address, country, and financial details like total amount
// sold or purchased this year.  You can use UnionDataSource to provide a "Trading Partners"
// view of this data.
// <p>
// <b>Configuration</b><br>
// If your member dataSources are very similar, unionDataSource can work in an auto-config mode
// where all you specify is the list of member dataSource in the unionDataSource's
// +link{dataSource.unionOf,unionOf} property, and we derive a set of common fields amongst the
// members where the names and data types match (there is flexibility in this auto-derivation
// process - see +link{dataSource.defaultUnionFieldsStrategy,defaultUnionFieldsStrategy}).
// You can trim this by specifying the list of fields you want to union (again, assuming they
// have the same name in each member dataSource) using the
// +link{DataSource.unionFields,unionFields} property.  You can also refine the auto-derived
// configuration by specifying field definitions in the unionDataSource, using field-level
// +link{dataSourceField.unionOf,unionOf} definitions to explicitly declare which member fields
// should be unioned.
// You can also use unionDataSource field definitions to optionally rename the unioned field,
// and do more mundane things, like change the title.  Eg, <pre>
//    &lt;field name="tradingPartnerId" unionOf="customerDS.custId,vendorDS.vendorCode" title="Partner ID"/&gt;
// </pre>
// <b>Performance note</b><br>
// Ordering and paging with a UnionDataSource only makes sense when applied to the bonded
// dataset; in order to ensure that we can sort and page the overall dataset correctly, we
// must fetch every matching record from each member dataSource.  For this reason, you should
// not rely on the paging feature to keep the number of records in the working dataset small;
// always provide criteria for that purpose.  This is a good practice, and one we recommend
// for any type of dataSource, but it is particularly important with unionDataSource, to avoid
// situations where we have to fetch thousands or millions of rows from multiple member
// dataSources, in order to find out which of those rows are in positions 100 to 150 with the
// current sort settings.
//
// @treeLocation Client Reference/Data Binding/DataSource
// @title Union DataSources
// @requiresModules SCServer
// @visibility external
//<


//> @groupDef testData
// You can create a test file that contains a sample dataset which can be imported into your
// database table with the Admin Console.
// <p>
// Test data can come in a variety of flavours based on your personal preference.
// <p>
// <ul>
// <li>CSV - Comma Separated Values</li>
// <li>JSON - An array of JSON objects</li>
// <li>XML - Extensible Markup Language</li>
// </ul>
// <p>
// <h3>CSV</h3>
// <p>
// The test file to use with your DataSource is specified in the <code>testFileName</code>
// DataSource configuration property and will have the <code>.data.csv</code> extension.
// <p>
// The CSV file can contain an optional header line as the example below will show you. The headline
// names can be either DataSource title or field name and are not case sensitive. If the
// header line is missing it will be assumed that the data/columns are the same order as the field
// declaration in the DataSource file. This sample represents some moon landing data and you can
// also use double quotes around more complex values.
// <p>
// <pre>
// mission, duration, launchDate, commander, rover
// "Apollo 11", "195.31", 1969-07-16, "Neil Armstrong", false
// "Apollo 12", "244.61", 1969-11-14, "Charles Conard", false
// "Apollo 13", 142.91, "1970-04-11", "Jim Lovell", false
// "Apollo 14", 216.03, "1971-01-31", "Alan Shepard", false
// "Apollo 15", 295.20, "1971-07-26", "David Scott", true
// "Apollo 16", 265.85, "1972-04-16", "John W. Young", true
// "Apollo 17", "301.87", 1972-12-07, "Eugene Cernan", true
// </pre>
// <p>
// <h3>JSON</h3>
// <p>
// The test file to use with your DataSource is specified in the <code>testFileName</code>
// DataSource configuration property and will have the <code>.data.js</code> extension.
// <p>
// The JSON file needs to contain an array of objects. Each object represents a new record and
// will contain the properties in a JSON fashion. The names can be either DataSource title or
// field name and are not case senstive.
// <p>
// <pre>
// [
//   {
//     category: "Adding Machine/calculator Roll",
//     itemName: "Adding Machine Roll 57x57mm Lint Free",
//     sku: "226500",
//     unitCost: 0.52,
//     units: "Roll"
//   },
//   {
//     category: "Pastes and Gum",
//     itemName: "Glue UHU Clear Gum 250ml",
//     sku: "724800",
//     unitCost: 2.26,
//     description: "Ideal for paper and card. Dries clear. Easy to use. Washable &amp; Non-Toxic."
//   },
//   ...
// ]
// </pre>
// <p>
// <h3>XML</h3>
// <p>
// The test file to use with your DataSource is specified in the <code>testFileName</code>
// DataSource configuration property and will have the <code>.data.xml</code> extension.
// <p>
// The test data file should consist of a top-level element containing a series of XML
// elements, each of which creates one DataSource record. Values for each field are given
// within tags named after the field name or in the parent tag as an attribute.
// <p>
// For example, the following XML represents a list of supply items.
// <p>
// <pre>
// &lt;supplyItems&gt;
//  &lt;supplyItem&gt;
//      &lt;description&gt;A revolutionary cushion-grip ballpoint pen that reduces
//          required gripping power, relieving stress and alleviating writing
//          fatigue. Excellent for people who suffer from arthritis or carpal
//          tunnel syndrome. Medium point, black ink. Refillable.&lt;/description&gt;
//      &lt;category&gt;1&lt;/category&gt;
//      &lt;itemRef&gt;ODC 204-502-153&lt;/itemRef&gt;
//      &lt;maxQuantity&gt;5&lt;/maxQuantity&gt;
//      &lt;requiresJustification&gt;0&lt;/requiresJustification&gt;
//      &lt;itemName&gt;Dr. Grip Pens -- Blue Barrel&lt;/itemName&gt;
//      &lt;itemID&gt;1&lt;/itemID&gt;
//      &lt;unitCost&gt;4.99&lt;/unitCost&gt;
//  &lt;/supplyItem&gt;
//  &lt;supplyItem&gt;
//      &lt;description&gt;A revolutionary cushion-grip ballpoint pen that reduces
//          required gripping power, relieving stress and alleviating writing
//          fatigue. Excellent for people who suffer from arthritis or carpal
//          tunnel syndrome. Medium point, black ink. Refillable.&lt;/description&gt;
//      &lt;category&gt;1&lt;/category&gt;
//      &lt;itemRef&gt;ODC 204-708-834&lt;/itemRef&gt;
//      &lt;maxQuantity&gt;5&lt;/maxQuantity&gt;
//      &lt;requiresJustification&gt;0&lt;/requiresJustification&gt;
//      &lt;itemName&gt;Dr. Grip Pens -- Black Barrel&lt;/itemName&gt;
//      &lt;itemID&gt;2&lt;/itemID&gt;
//      &lt;unitCost&gt;4.99&lt;/unitCost&gt;
//  &lt;/supplyItem&gt;
//  &lt;supplyItem&gt;
//      &lt;description&gt;Personalized business cards for all your networking
//          needs.&lt;/description&gt;
//      &lt;category&gt;2&lt;/category&gt;
//      &lt;itemRef&gt;&lt;/itemRef&gt;
//      &lt;maxQuantity&gt;500&lt;/maxQuantity&gt;
//      &lt;requiresJustification&gt;1&lt;/requiresJustification&gt;
//      &lt;itemName&gt;Personalized business cards -- 500 count&lt;/itemName&gt;
//      &lt;itemID&gt;3&lt;/itemID&gt;
//      &lt;unitCost&gt;25.00&lt;/unitCost&gt;
//  &lt;/supplyItem&gt;
//  ...
// &lt;supplyItems/&gt;
// </pre>
// <p>
// You can name the root element anything you like when you describe its location using
// +link{DataSource.recordXPath}. The same sample could be written this way:
// <p>
// <pre>
// &lt;records&gt;
//  &lt;record&gt;
//      &lt;description&gt;A revolutionary cushion-grip ballpoint pen that reduces
//          required gripping power, relieving stress and alleviating writing
//          fatigue. Excellent for people who suffer from arthritis or carpal
//          tunnel syndrome. Medium point, black ink. Refillable.&lt;/description&gt;
//      &lt;category&gt;1&lt;/category&gt;
//      &lt;itemRef&gt;ODC 204-502-153&lt;/itemRef&gt;
//      &lt;maxQuantity&gt;5&lt;/maxQuantity&gt;
//      &lt;requiresJustification&gt;0&lt;/requiresJustification&gt;
//      &lt;itemName&gt;Dr. Grip Pens -- Blue Barrel&lt;/itemName&gt;
//      &lt;itemID&gt;1&lt;/itemID&gt;
//      &lt;unitCost&gt;4.99&lt;/unitCost&gt;
//  &lt;/record&gt;
//  &lt;record&gt;
//      &lt;description&gt;A revolutionary cushion-grip ballpoint pen that reduces
//          required gripping power, relieving stress and alleviating writing
//          fatigue. Excellent for people who suffer from arthritis or carpal
//          tunnel syndrome. Medium point, black ink. Refillable.&lt;/description&gt;
//      &lt;category&gt;1&lt;/category&gt;
//      &lt;itemRef&gt;ODC 204-708-834&lt;/itemRef&gt;
//      &lt;maxQuantity&gt;5&lt;/maxQuantity&gt;
//      &lt;requiresJustification&gt;0&lt;/requiresJustification&gt;
//      &lt;itemName&gt;Dr. Grip Pens -- Black Barrel&lt;/itemName&gt;
//      &lt;itemID&gt;2&lt;/itemID&gt;
//      &lt;unitCost&gt;4.99&lt;/unitCost&gt;
//  &lt;/record&gt;
//  &lt;record&gt;
//      &lt;description&gt;Personalized business cards for all your networking
//          needs.&lt;/description&gt;
//      &lt;category&gt;2&lt;/category&gt;
//      &lt;itemRef&gt;&lt;/itemRef&gt;
//      &lt;maxQuantity&gt;500&lt;/maxQuantity&gt;
//      &lt;requiresJustification&gt;1&lt;/requiresJustification&gt;
//      &lt;itemName&gt;Personalized business cards -- 500 count&lt;/itemName&gt;
//      &lt;itemID&gt;3&lt;/itemID&gt;
//      &lt;unitCost&gt;25.00&lt;/unitCost&gt;
//  &lt;/record&gt;
//  ...
// &lt;records/&gt;
// </pre>
//
// Data for a tree-like DataSource can be specified with the same format.
// The following code example is for supply categories. This will make use of attribute values
// instead of separate tags for each property on the supply category. The attribues are not
// case sensitive and can be named after either the DataSource title or field name.
//
// <pre>
// &lt;categories&gt;
//     &lt;category itemName="Office Paper Products" parentID="root" /&gt;
//     &lt;category itemName="Calculator Rolls" parentID="Office Paper Products" /&gt;
//     &lt;category itemName="Adding Machine/calculator Roll" parentID="Calculator Rolls" /&gt;
//     ...
// &lt;/categories&gt;
// </pre>
//
// Note that all records must define values for the itemName primary key field and for the
// parentID field that establishes the tree relationship.
// <p>
// <h3>Date, Time and DateTime considerations</h3>
// <p>
// When you have date, time or datetime fields these need to be formatted the same way they are expected
// to be formatted in REST responses. If data for a field does not match the expected format it
// will be parsed using JDK built-in DataFormat parsers, in lenient mode, in the server's default
// locale.
//
// Examples of date, time and datetime formats.
// <pre>
//    // date - YYYY-MM-DD
//    2014-12-06
//
//    // time - hh:mm:ss
//    22:01:45
//
//    // datetime - YYYY-MM-DDThh:mm:ssZ
//    2014-12-06T22:01:45-04:00
// </pre>
//
// @see dateFormatAndStorage
// @treeLocation Client Reference/Data Binding/DataSource
// @title Test Data
// @visibility external
//<

//> @groupDef sqlSettings
// Although the Admin Console provides a UI to let you to configure database access for
// DataSources that use SmartClient's built-in +link{group:sqlDataSource,SQL engine}, it is
// also possible to configure these DataSources with manual entries in your
// +link{group:server_properties,server.properties} file.
// <p>
// When you manually configure a DataSource like this, you do so by maintaining a set of
// properties with names structured like this:
// <pre>   sql.{dbName}.x.y
// </pre>
// where <code>{dbName}</code> is the name of the database configuration you are providing.
// Note that this database name is just an arbitrary name for a particular database
// configuration; many of the default ones provided with SmartClient are named after a database
// <em>type</em>, in order to make their intended use more immediately obvious, but this is
// not by any means a requirement.
// <p>
// For the remainder of this discussion, we will assume we are configuring a database with a
// name of "MyDatabase".
// <p>
// <h4>SQL configuration properties</h4><p>
// <b><code>sql.MyDatabase.database.type</code></b><br>
// This should be set to one of the supported database types.  These are:<p>
// <table style="font-size:10px">
// <tr><td><b>hsqldb</b></td><td>HSQLDB 1.7.x and greater</td></tr>
// <tr><td><b>db2</b></td><td>IBM DB2 8.x and greater</td></tr>
// <tr><td><b>db2iSeries</b></td><td>IBM DB2 for iSeries/i5, V5R4 and greater</td></tr>
// <tr><td><b>firebirdsql</b></td><td>Firebird 2.5 and greater</td></tr>
// <tr><td><b>informix</b></td><td>Informix 11.5 and greater</td></tr>
// <tr><td><b>sqlserver</b></td><td>Microsoft SQL Server 2000 and greater</td></tr>
// <tr><td><b>mysql</b></td><td>MySQL 3.2.x and greater</td></tr>
// <tr><td><b>mariadb</b></td><td>MariaDB 5.1 and greater</td></tr>
// <tr><td><b>oracle</b></td><td>Oracle 8.0.5, 8i and greater</td></tr>
// <tr><td><b>postgresql</b></td><td>PostgreSQL 7.x and greater</td></tr>
// <tr><td><b>generic</b></td><td>A generic SQL92 database, with limitations described in
// +link{group:sqlDataSource,this article}</td></tr>
// </table><p>
// <code><b>sql.MyDatabase.driver</b></code><br>
// The name of the JDBC driver implementation.  This depends upon your database product and
// version, and the specific JDBC driver you are using (JDBC drivers can usually be downloaded
// from your database vendor's website).  Bearing in mind the caveat that this information can
// vary by release and JDBC implementation, here are some suggested values for our supported
// databases:<p>
// <table style="font-size:10px">
// <tr><td><b>hsqldb</b></td><td><code>org.hsqldb.jdbcDriver</code></td></tr>
// <tr><td><b>db2</b></td><td><code>com.ibm.db2.jcc.DB2DataSource</code></td></tr>
// <tr><td><b>db2iSeries</b></td><td><code>com.ibm.as400.access.AS400JDBCDriver</code></td></tr>
// <tr><td><b>firebirdsql</b></td><td><code>org.firebirdsql.jdbc.FBDriver</code></td></tr>
// <tr><td><b>informix</b></td><td><code>com.informix.jdbc.IfxDriver</code></td></tr>
// <tr><td><b>sqlserver</b></td><td><code>com.microsoft.jdbc.sqlserver.SQLServerDriver</code> or
// <code>com.microsoft.sqlserver.jdbc.SQLServerDriver</code> (Microsoft changed the order of
// "jdbc" and "sqlserver" between the 2000 and 2005 editions of the product)</td></tr>
// <tr><td><b>mysql</b></td><td><code>com.mysql.jdbc.jdbc2.optional.MysqlDataSource</code></td></tr>
// <tr><td><b>mariadb</b></td><td><code>org.mariadb.jdbc.MariaDbDataSource</code></td></tr>
// <tr><td><b>oracle</b></td><td><code>oracle.jdbc.driver.OracleDriver</code></td></tr>
// <tr><td><b>postgresql</b></td><td><code>org.postgresql.Driver</code></td></tr>
// </table><p>
// <code><b>sql.MyDatabase.driver.serverName</b></code><br>
// The name or IP address of the database server
// <p>
// <code><b>sql.MyDatabase.driver.portNumber</b></code><br>
// The port on which the database server is listening
// <p>
// <code><b>sql.MyDatabase.driver.user</b></code><br>
// The user to connect as
// <p>
// <code><b>sql.MyDatabase.driver.password</b></code><br>
// The user's password
// <p>
// <code><b>sql.MyDatabase.driver.databaseName</b></code><br>
// The database to connect to.  A "database" in this context is a named collection of tables
// and other database resources that are somehow grouped together by the database product.
// The specifics of how this is implemented vary by database.  Note that some database
// products use the terms "catalog" or "schema" to refer to the same concept, and Oracle -
// although it does also have a concept of catalog - uses the term "SID" for this concept.<p>
// <code><b>sql.MyDatabase.interface.type</b></code><br>
// Indicates how the JDBC connection will be created or looked up; the value of this setting
// depends on the capabilities of the particular JDBC driver you are using, and is inherently
// connected to the value of <code>sql.MyDatabase.driver</code>.  The following settings are
// supported:<p>
// <b>dataSource</b> - the driver is an instance of <code>javax.sql.DataSource</code> and
// should be instantiated by SmartClient Server<br>
// <b>driverManager</b> - the driver is an instance of <code>java.sql.DriverManager</code><br>
// <b>jndi</b> - the driver is an instance of <code>javax.sql.DataSource</code> and should be
// looked up using JNDI<br>
// <b>spring</b> - the driver is an instance of <code>javax.sql.DataSource</code> and should
// be obtained from the Spring context using bean id defined in
// <code>sql.MyDatabase.spring.dataSourceBean</code> setting. For example:<br>
// <i>sql.MyDatabase.database.type: mysql</i><br>
// <i>sql.MyDatabase.interface.type: spring</i><br>
// <i>sql.MyDatabase.spring.dataSourceBean: springDataSourceBeanId</i><p>
// <code><b>sql.MyDatabase.driver.url</b></code><br>
// For configurations where <code>sql.MyDatabase.interface.type</code> is "driverManager",
// this property allows you to manually enter the URL we use to connect to the database.  If
// this property is not provided, we build the URL from other settings such as
// <code>sql.MyDatabase.driver.serverName</code> and
// <code>sql.MyDatabase.driver.databaseName</code>.<p>
//
// <b>Other properties</b><br>
// Different JDBC drivers support different properties to support product-specific quirks and
// features.  You can often specify these properties by embedding them as parameters in the
// URL used to connect to the database.<p>
//
// Alternatively, any subproperty you set on the "driver" in server.properties is applied to
// the JDBC driver object via Reflection. For example, the MySQL JDBC driver supports a property
// "useUnicode", which forces the database to use Unicode character encoding.  If
// <code>sql.MyDatabase.driver</code> is <code>com.mysql.jdbc.jdbc2.optional.MysqlDataSource</code>,
// setting <code>sql.MyDatabase.driver.useUnicode</code> to true means we'll attempt to call
// <code>setUseUnicode(true)</code> on this class.  This would have exactly the same effect as
// defining the connection URL manually and specifying the parameter <code>useUnicode=true</code>.<p>
//
// Mysql vs MariaDB: there is broad compatibility between these two databases as described in
// +externalLink{https://mariadb.com/kb/en/library/mariadb-vs-mysql-compatibility/}.  Within
// the bounds of that compatibility matrix, you can use database.type 'mysql' and 'mariadb'
// interchangeably, and likewise with the drivers that you use.  However for future compatibility
// it is recommended that you use <code>database.type: mariadb</code> for MariaDB.  This will ensure
// that as MariaDB implements new features and backompat breaking changes, your application won't
// run into any gotchas because the SmartClient server logic will automatically use the right feature
// set to accomplish documented behavior.<p>
//
// <h4>Smartclient properties</h4><p>
// <b><code>sql.mysql.optimizeCaseSensitiveCriteria</code></b><br>
// <i>This setting affects all <b>MySQL</b> connectors and it is set to <b>true</b> by default.</i>
// Depending on +link{type:TextMatchStyle,textMatchStyle} case
// sensitivity in text criteria is achieved by using LIKE BINARY sql comparison operator, which does not
// use indexed search. Indexes are used with regular "=" comparison operator, which does not ensure case
// sensitivity. With big amounts of data indexes are critical, so in order to use them and still have
// case sensitivity supported this setting must be set to <code>true</code> (default).
// This way we would generate comparison expression like:<br>
// <code>&lt;field&gt; = &lt;value&gt; AND &lt;field&gt; LIKE BINARY &lt;value&gt;</code><br>
// where first part ensures efficient indexed search and second part adds case sensitivity to significantly
// reduced amounts of data. This would be more efficient without indexes as well, cause LIKE BINARY
// conversion would be performed on less rows anyway.<br>
// Setting this property to <code>false</code> would bring back the old behavior, when only
// LIKE BINARY comparison would be used, which would return same results, but much slower.
// <p>
// <b><code>sql.MyDatabase.useHavingClause</code></b><br>
// By default SQL query is generated using traditional "having" clause approach:
// <pre>select <i>&lt;selectClause&gt;</i> from ... where ... group by <i>&lt;groupClause&gt;</i> <b>having <i>&lt;groupWhereClause&gt;</i></b></pre>
// Setting <code>sql.MyDatabase.useHavingClause</code> to <code>false</code> makes SQL query use subselect approach
// when main query becomes subselect and then it is filtered in outer "where" clause:
// <pre><b>select * from (</b>select <i>&lt;selectClause&gt;</i> from ... where ... group by <i>&lt;groupClause&gt;</i><b>) work where <i>&lt;groupWhereClause&gt;</i></b></pre>
// This may be overridden by setting +link{operationBinding.useHavingClause}.
// <p>
// <b><code>sql.likeIsCaseSensitive</code> and <code>sql.MyDatabase.likeIsCaseSensitive</code></b><br>
// The "LIKE" operator in the SQL standard is defined as being case-insensitive, however, some databases
// default to case-sensitive matching. This is not ultimately not technically in violation of the standard
// since the standard specifies that the comparison is based on the configured "collation" (the collation
// is basically the rules for comparing characters and deciding which is first when sorting).
// <p>
// If the default behavior of the LIKE operator is a case-sensitive comparison, then, to achieve a
// case-insensitive comparison, as required by +link{type:OperatorId,case insensitive operators} such as iEquals,
// iContains and so forth, the SmartClient server must generate SQL that uses LOWER() or similar SQL functions
// to ensure case-insensitive comparison.
// <p>
// In databases where the default behavior of the "LIKE" operator is already case-insensitive comparison,
// explicit use of the LOWER() function can be slower - certain databases do not realize that this is a
// "no-op" and perform the query poorly (fail to use indices, etc).
// <p>
// Note that above is true for the equality check as well, because usually databases treat the "LIKE" and "="
// operators in the same way, i.e. either they both are case-sensitive or both are case-insensitive.
// <p>
// Smartclient does its best to default this behavior for supported databases, so unless your database is
// configured to use other than the default "collation", nothing needs to be changed. In case you need to
// change the default behavior set <code>likeIsCaseSensitive</code> flag as follows:
// <ul>
// <li><code>likeIsCaseSensitive: true</code> enables Smartclient to convert both sides
// of comparison to lower/upper case to ensure case-insensitivity:<br>
// <code> LOWER(table.column) = LOWER('Value') </code>
// <br>and<br>
// <code> LOWER(table.column) LIKE LOWER('%Value%') </code>
// </li>
// <li><code>likeIsCaseSensitive: false</code> enables Smartclient to rely on database
// case-insensitivity and compare values directly:<br>
// <code> table.column = 'Value' </code>
// <br>and<br>
// <code> table.column LIKE '%Value%' </code></li>
// </ul>
// <p>
// <b><code>sql.forceInsensitive</code> and <code>sql.MyDatabase.forceInsensitive</code></b><br>
// <i><b>Deprecated.</b> Does the same as "likeIsCaseSensitive" described above, but will be removed
// soon. Please see "likeIsCaseSensitive" setting docs for the details what it affects exactly.</i>
// <p>
// <b><code>sql.aliasLengthLimit</code> and <code>sql.MyDatabase.aliasLengthLimit</code></b><br>
// These properties override the default table alias length limit when using features like
// +link{dataSourceField.includeVia} and +link{dataSourceField.otherFKs}.
// Default alias length limit is set accordingly to the documentation for supported databases
// and defaults to 128 characters, except these databases:<p>
// <table style="font-size:10px">
// <tr><td><b>firebirdsql</b></td>  <td>63</td></tr>
// <tr><td><b>mysql</b></td>        <td>256</td></tr>
// <tr><td><b>mariadb</b></td>      <td>256</td></tr>
// <tr><td><b>oracle</b></td>       <td>automatically set to 128 since DB version 12.2 and to 30 for older versions</td></tr>
// <tr><td><b>postgresql</b></td>   <td>63</td></tr>
// </table><p>
// In order to support portability across databases it is advised to keep alias length limit at
// the lowest supported value. Use global setting <code>sql.aliasLengthLimit</code> to apply limit
// across all DB drivers, or use DB specific setting <code>sql.MyDatabase.aliasLengthLimit</code>
// (overrides the global one).
// <p>
// <b><code>sql.postgresql.useILike</code></b><br>
// Starting with version 12.0, SmartClient Server supports the use of a Postgres-specific
// comparison keyword, ILIKE.  This keyword natively does a case-insensitive LIKE, so the
// SmartClient driver does not have to do what it normally does to enable this kind of
// comparison, which is to convert the filter value to lower case and then generate SQL like:
// <pre>WHERE LOWER(someField) LIKE 'united%'</pre>
// When ILIKE is in use, Postgres is able to make use of indexes, which it does not do when
// we use the "lowercase both sides" strategy, so this is a potentially significant performance
// enhancer, depending on your application:
// <pre> WHERE someField ILIKE 'United%'</pre>
// <p>
// <b><code>sql.log.queriesSlowerThan</code></b><br>
// Allows you to specify SQL query execution time threshold in milliseconds (defaults to 10000),
// which if exceeded query is identified as "slow" and may be logged under specific logging category.
// See +link{dataSource.logSlowSQL} for more details.
//
// @treeLocation Client Reference/Data Binding/DataSource
// @title SQL Database Settings in <code>server.properties</code>
// @requiresModules SCServer
// @visibility external
//<

//> @groupDef troubleshootingServerDeadlocks
// Java thread deadlocking can occur in a multi-threaded application when two or more threads
// need the same lock and block while waiting for it. These threads can be permanently blocked
// (deadlocked), waiting for each other.
// <P>
// For developers using the SmartClient server, if deadlocks are encountered we recommend the
// following troubleshooting steps:
// <ul>
// <li>Search server code for calls to DataSourceManager and audit whether you are
//     following the documented pooling rules for obtaining and releasing dataSources</li>
// <li>Look at the deadlocked thread ID and looked at the server logs for the logs for
//     the last request that thread serviced.<br>
//     Our default logging messages include the thread ID so you can easily correlate
//     the logs with the hung thread. You can also adjust server logging sensitivity via
//     settings in the log4j configuration file (<i>log4j.isc.config.xml</i>).<br>
//     Note that the logged thread IDs are shortened by default. If there isn't enough
//     information shown to correlate with the deadlocked thread you can also change the
//     logging format (pattern) in the log4j configuration file.<br>
//     If you are using some other log package, it should be easy to turn on logging of
//     thread IDs, and you should do so - this is a basic logging best practice.<br>
//     See documentation +link{group:serverLogging,here} for more information on server side
//     logging.</li>
//  <li>Attach a tool such as Dynatrace so that you can inspect the hung thread.</li>
//  <li>Examine any threaded code you may have, and made sure it likewise follows the
//      rules of pooling (see also +link{group:standaloneDataSourceUsage,Standalone DataSource Usage})</li>
// </ul>
//
// @treeLocation Java Server Reference/Debugging
// @title Troubleshooting thread deadlocks on the server
// @visibility external
//<

//> @groupDef clientOnlyDataSources
// For prototyping purposes, a "client-only" DataSource can be created that has no permanent
// storage and never contacts the server, instead using a set of test data to respond to
// requests in the same manner as a server-based DataSource might.
// <P>
// The client-side interface to a client-only DataSource is identical to a server-based
// DataSource, including asynchronous responses, so that a client-only DataSource can be
// replaced by a server-based DataSource without code changes.  The only difference is that
// changes to records belonging to the DataSource persist only until the page is reloaded.
// <p>
// Client-only DataSources allow you to create a complete prototype application in an .html
// file that does not require a server.
// <p>
// <smartclient>
// The <code>clientOnly</code> property is specified to create a client-only DataSource, and
// the <code>cacheData</code> property should contain the test dataset, as an Array of Objects,
// one per DataSource record.  For example:
// <pre>
//   isc.DataSource.create({
//       ID:"supplyItem",
//       fields: ...,
//       clientOnly:true,
//       cacheData:[
//          {itemName:"Pencil", cost:5.50},
//          ...
//       ]
//   });
// </pre>
// If you have existing test data in XML (see +link{group:dbConfigTool,Database Configuration} for
// expected format) and your client-only DataSource is defined in a .jsp file,
// you can use the XML->JS translation engine to populate the DataSource with data from XML, like so:
// <pre>
//   isc.DataSource.create({
//     ID:"solutions",
//     fields: ...,
//     clientOnly : true,
//     cacheData :
//         &lt;isomorphic:XML filename="shared/ds/test_data/solutions.data.xml"/&gt;
//   });
// </pre>
// Another useful practice is to specify both the clientOnly DataSource and its test data in
// XML, so that the +link{group:adminConsole,Admin Console} can later be used to import the
// DataSource and its test data into a SQL Database.  An idiom for accomplishing this is:
// <pre>
//   &lt;isomorphic:loadDS name="solutions"/&gt;
//   isc.DataSource.getDataSource("solutions").addProperties({
//     clientOnly : true,
//     cacheData :
//        &lt;isomorphic:XML filename="shared/ds/test_data/solutions.data.xml"/&gt;
//   });
// </pre>
// Finally test data can be included directly in the clientOnly DataSource
// XML.  An idiom for accomplishing this is:
// <pre>
// &lt;DataSource ID="supplyItem"&gt;
//   &lt;fields&gt;
//       &lt;field name="itemName" type="text" title="Item"/&gt;
//       &lt;field name="SKU"      type="text" title="SKU"/&gt;
//   &lt;/fields&gt;
//   &lt;cacheData&gt;
//       &lt;Object&gt;
//           &lt;itemName&gt;name&lt;/itemName&gt;
//           &lt;SKU&gt;112233&lt;/SKU&gt;
//       &lt;/Object&gt;
//       ...
//   &lt;/cacheData&gt;
// &lt;/DataSource&gt;
// </pre>
// If you specify your DataSource as <code>clientOnly: true</code>, omit cacheData
// entirely, and provide either a +link{attr:dataSource.dataURL} or a <code>testFileName</code>, the
// </smartclient>
// <smartgwt>
// The setClientOnly method is specified to create a client-only DataSource. For example:
// <pre>
//  DataSource dataSource = new DataSource();
//  dataSource.setID("stockQuotesDS");
//  DataSourceField idField = new DataSourceField("id", FieldType.INTEGER, "Id");
//  ........
//  dataSource.setFields(idField,.....);
//  dataSource.setClientOnly(true);
// </pre>
// If you have existing test data in XML (see the Admin Console for expected format),
// you can load it into a client-only DataSource using setDataURL method, like so:
// <pre>
//  DataSource dataSource = new DataSource();
//  dataSource.setID("stockQuotesDS");
//  dataSource.setRecordXPath("/List/stockQuotes");
//  DataSourceField idField = new DataSourceField("id", FieldType.INTEGER, "Id");
//  ........
//  dataSource.setFields(idField,.....);
//  dataSource.setDataURL("ds/test_data/stockQuotes.data.xml");
//  dataSource.setClientOnly(true);
// </pre>
// The
// </smartgwt>
// DataSource will lazily make a one-time fetch against the specified data file the first time
// an operation is called on it.  From then on, the DataSource will work against the local
// cache created from this initial request.  This is a quick way to prototype against some test
// data that may eventually be returned from an arbitrary back-end.
// <P>
// Finally, it is possible to have a DataSource which initially fetches the entire dataset and
// performs all subsequent fetching locally, while still visiting the server to perform all
// other operations.  See +link{dataSource.cacheAllData}.
//
// @treeLocation Client Reference/Data Binding/DataSource
// @title Client Only DataSources
// @visibility external
//<

//> @groupDef dataSourcesTab
// The DataSources tab, found in the +link{adminConsole,Admin Console} and +link{debugging,
// Developer Console}, lets you view, search and edit data from any DataSource in the currently
// loaded application, or, if you have the Pro edition or better, any DataSource defined on the
// server, even if the current application hasn't loaded it.
// <p>
// <b>Security</b>
// <p>
// If you are using our server product and you have +link{toolsDeployment,deployed the tools},
// then the DataSources tab bypasses normal security restrictions and allows any operation on
// any DataSource.  Otherwise, if the tools are not deployed or not accessible to the current
// user, then the DataSources tab only lets you do whatever the currently authorized user can
// do.
// <p>
// If you use the +link{DataSource.audit,DataSource auditing} feature, the DataSources tab also
// allows you to access the audit trail for any DataSource where auditing is enabled.
// <p>
// <b>Usage</b>
// <p>
// The DataSources tab will present you with a list of the available DataSources.  If you click
// on one, a new section will be opened showing the data from that DataSource in a ListGrid,
// offering filtering via the standard +link{listGrid.showFilterEditor,FilterEditor}, and
// editing via standard +link{editing,grid editing}.  At the bottom of the section, buttons are
// shown to add a new record, and export the data in various formats to a file (or the screen
// if not using the server product).
// <p>
// <b>Reify Export</b>
// <p>
// To upload data to +link{reifyForDevelopers,Reify}, a special "Reify Export" button is shown
// in the header of the DataSources list section.  When clicked, the behavior will temporarily
// change so that you can click DataSources to build up a selection without new sections
// opening.  To finalize your selection, click the same button again, which will appear as
// "Done Selecting".
// <p>
// When selection is complete, a configuration dialog will open to let you customize how
// many rows will be fetched for each DataSource (or how many levels for Tree DataSources).
// Both global and per-DataSource limits are allowed, with a section in the dialog shown for
// each selected DataSource.  If desired, additional per-DataSource criteria can be applied
// via a +link{FilterBuilder} in its dedicated configuration section.  Through a radio button
// at the top of the dialog, you can also select whether to save the export to a file, or show
// the output in a dialog.  Click the "Export" button to complete configuration and run the
// export.
//
// @treeLocation Client Reference/Tools
// @title DataSources Tab
// @visibility external
//<


//> @groupDef cacheSynchronization
// <i>Cache synchronization</i> is the mechanism used by SmartClient to ensure that updates
// made by +link{DataBoundComponent,dataBoundComponent}s or programmatically on
// +link{DataSource,dataSource}s directly, are reflected in the client-side caches of other
// <code>dataBoundComponent</code>s.  Automatic cache sync means that components update
// themselves to reflect data changes - so if you update a record in a
// +link{class:DynamicForm,form}, and the same information is currently visible in a
// +link{class:ListGrid,grid}, the grid data will change to reflect the updates automatically.
// <p>
// The SmartClient server is designed to retrieve cache sync data in the most optimal way,
// taking into account the capabilities of the target data store or data service and the
// context of the request, such as whether it came from a browser or was programmatically
// initiated on the server.  The cacheSyncStrategy setting can be used to manually control
// how cache sync is performed server-side, whenever that's necessary.
// <h3>CacheSyncStrategy</h3>
// Cache sync configuration revolves around the +link{type:CacheSyncStrategy} type, and to a
// lesser extent the +link{type:CacheSyncTiming}.  These settings allow you to define a
// default cache sync approach globally, overridable
// +link{dataSource.cacheSyncStrategy,per-DataSource},
// +link{operationBinding.cacheSyncStrategy,per-Operation} or
// +link{dsRequest.cacheSyncStrategy,per-request}.
// See the +link{type:CacheSyncStrategy,CacheSyncStrategy documentation} for details.
// <p>
// Note that DataSource-level, operation-level and request-level <code>cacheSyncStrategy</code>
// settings are honored in all cases (though see below for a caveat on that), but global
// settings are defaults only.  SmartClient will override the default if it detects that it
// might lead to problems in a given case.
// <p>
// For example, if a DataSource declares a field that specifies the
// +link{dataSourceField.autoGenerated,autoGenerated} flag, it is saying that field is not a
// sequence but its value is nevertheless generated by the database or ORM platform, so we
// would not expect a value for that field in the request values.  So if the global default
// <code>cacheSyncStrategy</code> is "requestValuesPlusSequences", that is going to lead to
// SmartClient returning an incomplete cache sync record, which might well look to your
// users like a broken application.
// <p>
// SmartClient will detect these cases where we would have possibly incomplete cache sync data,
// and automatically change the strategy to "refetch".  This is done when we have a field
// that is part of the expected outputs (see +link{dsRequest.outputs} and
// +link{operationBinding.outputs}) and specifies any of the following properties (because
// they all mean that the field's value is server-generated in some way):<ul>
// <li>autoGenerated</li>
// <li>customSQL</li>
// <li>customSelectExpression</li>
// </ul>
// Similarly, SmartClient will override the global <code>cacheSyncTiming</code> setting according
// to the requirements of a given request.  For example, if the global default is "lazy" and
// there is no DataSource-level, operation-level or request-level timing setting, SmartClient
// will override the timing to "immediate" for any client-originated request, amongst other
// things.  See the +link{type:CacheSyncTiming,CacheSyncTiming documentation} for further
// details.
// <p>
// If you do not want these intelligent fallback behaviors for a given DataSource, operation
// or request, set a <code>cacheSyncStrategy</code> or <code>cacheSyncTiming</code> on the
// DataSource, operation or request.  This will always be honored for
// <code>cacheSyncStrategy</code>, even when the system knows that it is going to lead to
// incomplete cache-sync data.  However, even an explicit <code>cacheSyncTiming</code> setting
// at the DataSource, operation or request level will be ignored in certain circumstances,
// where deferring the cache sync operation could break framework functionality.  An example
// of this is auditing: if your dataSource is configured for
// +link{dataSource.audit,automatic auditing}, the framework categorically <i>does</i> need
// the cache sync data in order to write an audit record, and when deferred cache sync is in
// force, we have no guarantee that cache sync will run at all.  So we ignore attempts to
// configure it for deferred cache sync.
// <h3>CacheSyncStrategy support with different DataSource types</h3>
// Different DataSource types may support only a subset of cacheSyncStrategy options, since
// some strategies are specific to the capabilities of specific data stores or remote services.
// The following section describes how <code>CacheSyncStrategy</code> applies to various
// built-in dataSource types
// <h4>SQLDataSource</h4>
// SQL databases accessed via JDBC do not return the record-as-saved, so extra work is required
// to retrieve database-generated fields, such as sequences (though sequences are a special
// case, see below)
// <p>
// With JDBC 3.0+ drivers and a +link{dataSource.sequenceMode,sequenceMode} of <code>jdbcDriver</code>,
// we can retrieve generated sequence values without requiring an explicit, separate SQL query
// to retrieve the generated keys.  With the default CacheSyncStrategy of
// <code>requestValuesPlusSequences</code>, SQLDataSource uses this JDBC approach to avoid a
// separate SQL query where possible - see the "requestValuesPlusSequences" section of the
// +link{type:CacheSyncStrategy} documentation for details.  With a <code>sequenceMode</code>
// of <code>native</code>, we will issue a separate SQL query to retrieve the generated keys,
// even if you are using "requestvaluesPlusSequences".  However, it is not a full refetch, it
// is just a special native query, specific to the database in use, to retrieve just the
// generated sequence values, so it is still likely to have a performance advantage over using
// "refetch" - in the refetch case, we perform an <i>additional</i> full fetch, using the
// retrieved keys as the criteria.
// <p>
// Note that sequences (or identity columns, or auto-increment columns - different databases
// use different mechanisms and terminology for the same concept) are not the only kind of
// database-generated value.  As well as the three DataSource field settings, mentioned above,
// that can explicitly denote a generated value -
// +link{dataSourceField.autoGenerated,autoGenerated},
// +link{dataSourceField.customSQL,customSQL} and
// +link{dataSourceField.customSelectExpression,customSelectExpression} - database-generated
// values can come from database-declared default values, UDFs and stored procedures, and
// triggers.  In addition, application code can modify data returned from the database in
// arbitrary ways, via logic in a +link{group:dmiOverview,DMI},
// +link{operationBinding.script,server script} or
// +link{dataSource.serverConstructor,custom DataSource implementation}.  So there are cases
// where "refetch" is necessary, and for some applications it may be that most or even all
// cases require it (if you make extensive use of triggers, or enhance many database responses
// in Java code, for example).
// <h4>Sequence field object type considerations</h4>
// SQL databases support different underlying column types for sequence fields.  Typically,
// you use either INTEGER or BIGINT, depending on the maximum number of rows you anticipate
// for a given table.  Unfortunately, the different database products are not always consistent
// in the way they convert values from the different underlying SQL types into Java objects.
// For example, MySQL returns values from SQL INTEGER columns as instances of
// <code>java.lang.Integer</code> in ordinary fetch ResultSets, but as instances of
// <code>java.lang.Long</code> from the <code>getGeneratedKeys()</code> API.
// <p>
// This is a problem if you have existing Java code that is expecting an instance of
// <code>Integer</code>; if you switch to the more efficient "requestValuesPlusSequences"
// cacheSyncStrategy, your code will be sent an instance of <code>Long</code> instead.  Note,
// this is only a problem for existing server-side Java code; client code is not affected
// because the SmartClient framework already coerces all integer-type values to type
// <code>Long</code> for serialization to the client.
// <p>
// The SmartClient framework offers a number of configurable mitigations for this problem:<ul>
// <li>We maintain a table of known Java types returned by each database product for "small"
// sequence columns (32-bit, SQL type INT or INTEGER) and "large" sequence columns (64-bit,
// SQL type BIGINT).  We also maintain a flag per database product indicating whether "small"
// or "large" sequence columns should be used (as mentioned in the bullet-point below, this
// applies to integer key fields generally, not just sequences).  You can override this flag
// in your <code>server.properties</code> file, per database product or per
// +link{dataSource.dbName,dbName} (the latter is more specific and wins if there is a
// conflict).  For example:<pre>
//    # Change all Postgres db connections to use small keys
//    sql.postgresql.defaultKeySize: small
//    # Change the db with the specific dbName "SalesDB" to use large keys
//    sql.SalesDB.defaultKeySize: large
// </pre>
// <li>If you need Java types other than the defaults described above
// (<code>java.lang.Integer</code> for "small" sequences, <code>java.lang.Long</code> for
// "large" sequences), you can declare entries in <code>server.properties</code> to override
// them, per database product or per dbName, like this:<pre>
//    # For Postgres, large key values should be returned as instances of BigInteger
//    sql.postgresql.javaTypeForLargeKey: java.math.BigInteger
//    # and small key values should be returned as instances of Short
//    sql.postgresql.javaTypeForSmallKey: java.lang.Short
//    # But small key values should be returned as type BigDecimal for AdminDB
//    sql.AdminDB.javaTypeForSmallKey: java.math.BigDecimal
// </pre>This is useful for new projects that may later switch database vendors, or for projects
// that use multiple database products in tandem, because it can be used to enforce
// cross-database type consistency.  We would recommend using <code>java.lang.Integer</code>
// and <code>java.lang.Long</code> for small and large sequences, respectively, since these
// cover exactly the same range of valid values as the corresponding SQL types, INTEGER and
// BIGINT</li>
// <br>
// <li>The <code>server.properties</code> flag <code>sql.transformGeneratedKeys</code>, on by
// default, causes the framework to transform the object returned by the getGeneratedKeys()
// API in accordance with the above.  So, if "SalesDB" and "AdminDB" are both PostgreSQL
// databases, the settings above would mean:<ul>
//   <li>Adding a record to a DataSource with <code>dbName="SalesDB"</code> would return an
//   instance of <code>java.math.BigInteger</code> for the sequence field</li>
//   <li>Adding a record to a DataSource with <code>dbName="AdminDB"</code> would return an
//   instance of <code>java.math.BigDecimal</code> for the sequence field (because of the
//   custom <code>javaTypeForSmallSequence</code> declared for that dbName)</li></ul></li>
// <br>
// <li>Note that the above rules are also applied by SmartClient's table-creation logic when
// you use the +link{group:adminConsole,Admin Console} to import SQL DataSources.  Additionally,
// we use these rules to decide on a column type for any integer field that is marked as
// +link{dataSourceField.primaryKey,primaryKey} or +link{dataSourceField.foreignKey,foreignKey},
// to ensure that the same SQL type is used at both ends of the relation (because some
// databases require this)</li>
// <br>
// <li>If <code>sql.transformGeneratedKeys</code> is explicitly set false, no transformation
// takes place; your code is directly returned whatever object type the JDBC dirver returned</li>
// <br>
// <li>If you have an existing project where a mix of large and small sequence types is already
// in place, the above approaches to provide consistency will not help.  In this case, the
// <code>server.properties</code> flag "sql.transformGeneratedKeysToFetchType" should be
// considered.  This flag is off by default; when switched on, it causes the framework to cast
// the generated value of a sequence field, as returned by the JDBC driver or native query, to
// the same Java type that a regular fetch of that field would have returned.  This is
// accomplished by running a basic fetch of a single row the first time the information is
// required, determining the underlying SQL type from the ResultSetMetadata, and then caching
// that information for future use.  The performance impact of this is minor, since it
// involves a single additional fetch per DataSource instance for the lifetime of the JVM.
// Note, this flag has no effect if <code>sql.transformGeneratedKeys</code> is false</li>
// <br>
// <li><code>sql.transformGeneratedKeysToFetchType</code> is only intended for existing
// projects that have a lot of server-side code that interacts with the SmartClient Server and
// may be affected by cacheSyncStrategy "requestValuesPlusSequences" returning a different
// Java object type for sequence fields than your existing code is expecting.  For any new
// project we would recommend using the other options outlined above to either match your
// database's return type for fetches, or to force consistency to types you specify</li>
// <br>
// <li>Finally, the Java type to use for a specific field can be set using the field's
// +link{dataSourceField.javaClass,javaClass} property.  Alternatively, SmartClient will
// automatically coerce values to match declared types if you are using Javabeans rather than
// Maps as your data model - see +link{dataSource.beanClassName,beanClassName}.  Both of these
// approaches take precedence over the mechanisms described above</li>
// </ul>
//
// <h4>HibernateDataSource and JPADataSource</h4>
// +link{group:hibernateIntegration,HibernateDataSource} and
// +link{group:jpaIntegration,JPADataSource} only support <code>refetch</code>.  These two
// implementations integrate with the underlying ORM system at the level of the ORM's API,
// allowing it to handle the details of database interaction.  With these two DataSource types,
// we are simply working with "persistent objects" - how the ORM manages things like changes
// made by the database during update queries, or sequence values in add operations, is the
// ORM's business.
// <p>
// For this reason, <code>HibernateDataSource</code> and <code>JPADataSource</code> install a
// special <code>CacheSyncStrategy</code> implementation under the <code>refetch</code>
// name, that just does nothing, leaving the response data returned by the update operation
// unchanged.
//>ISC_140
// <h4>RestConnector</h4>
// +link{group:serverRestConnector,RestConnector} supports all four of the default cache sync
// strategies.  Note that <code>refetch</code> involves a second round-trip to the REST
// service, so may be a performance concern.
// <p>
// <code>requestValuesPlusSequences</code> attempts to extract the values for any missing
// +link{dataSource.getPrimaryKeyFields(),primaryKey fields} from the response sent by the REST
// service to the add or update request, so it is obviously only of use if the REST service
// returns such values.
// <p>
// <code>responseValues</code>, the default strategy for <code>RestConnector</code>, just
// uses the response data sent by the REST service to the update or add request.  Again, this
// is only usable if the REST service returns such data, but if it does, this strategy is
// ideal.
//<ISC_140
// <h4>Custom/Generic DataSources</h4>
// In addition to the built-in DataSource types listed above, you can of course write your own
// +link{group:writeCustomDataSource,custom dataSource} implementations.  These custom
// DataSources will participate in cache sync like any other:<ul>
// <li>You can specify a <code>cacheSyncStrategy</code> on the +link{class:DataSource},
// +link{class:OperationBinding,operationBinding} or +link{class:DSRequest,dsRequest}</li>
// <li>The default strategy for a custom dataSource is "<code>responseValues</code>", because
// that was the prevailing behavior for custom DataSources before <code>cacheSyncStrategy</code>
// was introduced</li>
// <li>If you want to use "<code>refetch</code>" (ie, you override the default in your
// <code>server.properties</code>, or set the strategy explicitly on your DataSource or operation
// binding), you must implement a fetch operation, and if your dataSource has fields of type
// "sequence", your fetch mechanism must be able to resolve the values of such fields</li>
// </ul>
// Note that "<code>refetch</code>" with a custom dataSource is done lazily, and it is not
// done at all if nothing asks for the response data.  This is because the integration with
// cache sync happens when the server-side <code>DSResponse</code>'s <code>getData()</code>
// method is called.  This happens automatically and will work perfectly for most use cases.
// If, however, you have some unusual requirement which means you need "<code>refetch</code>"
// to cause an immediate cache sync fetch like it does with the built-in dataSources, you can
// do what they do: invoke the <code>CacheSyncStrategy</code> manually from your execution
// flow, like this:<pre>
//    CacheSyncStrategy strategy = dsRequest.getCacheSyncStrategy();
//    if (strategy.shouldRunCacheSync(dsRequest)) {
//        // Apply the cache sync data to the dsResponse, first fetching it if necessary
//        strategy.applyCacheSyncStrategy(dsRequest, dsResponse)
//    }
// </pre>
// <h3><code>canSyncCache</code>, <code>cacheSyncOperation</code> and <code>useForCacheSync</code></h3>
// These three long-standing +link{OperationBinding,operationBinding} flags interact with the
// above-documented behavior of <code>CacheSyncStrategy</code> as follows:<ul>
// <li>If +link{operationBinding.canSyncCache,canSyncCache} is false, no cache sync logic will
//     run at all</li>
// <li>If a +link{operationBinding.useForCacheSync,useForCacheSync} operation is in force, or
//     the update operation specifies a +link{operationBinding.cacheSyncOperation,cacheSyncOperation},
//     that operation will be run if we are refetching the updated record - ie, if the
//     <code>cacheSyncStrategy</code> is <code>refetch</code>.  Depending on the
//     +link{operationBinding.cacheSyncTiming,cacheSyncTiming} in force, the operation execution
//     may be deferred, and may not run at all.  If we are not refetching the updated record,
//     these two flags have no effect</li>
// </ul>
// <h3>Adding multiple records</h3>
// By default, cache sync is switched off for multi-insert requests (ie, add requests with more
// than one valueSet; cache sync is always off for
// +link{operationBinding.allowMultiUpdate,allowMultiUpdate} operations, unless you explicitly
// specify a <code>cacheSyncStrategy</code> on the request or operationBinding).  You can
// change this default behavior for multi-inserts by changing <code>server.properties</code>
// flag "<code>default.multi.update.cache.sync.strategy</code>" to "<code>sync</code>""; this
// will cause the system to use the same cacheSyncStrategy it would use for a regular
// single-record request on that DataSource.  Note that in this case, the default strategy can
//  be auto-overridden by the framework just like a normal single-update strategy.
// <p>
// You can also just set a specific <code>cacheSyncStrategy</code> on the DataSource, operation
// or DSRequest, just like with a regular single-record request, and again, these specific
// settings are not auto-overridden except in cases where they could potentially cause feature
// breakage, as described above.
//
// @see type:CacheSyncStrategy
// @see operationBinding.canSyncCache
// @see operationBinding.useForCacheSync
// @see operationBinding.cacheSyncOperation
// @treeLocation Client Reference/Data Binding/CacheSyncStrategy
// @title Automatic Cache Synchronization
// @visibility external
//<




//> @type CacheSyncStrategy
// Indicates the strategy to be used for
// +link{group:cacheSynchronization,automatic cache synchronization}, for a given
// +link{dataSource.cacheSyncStrategy,DataSource},
// +link{operationBinding.cacheSyncStrategy,OperationBinding} or
// +link{dsRequest.cacheSyncStrategy,DSRequest}.
// <P>
// @value "refetch"
// Obtain cache sync values by refetching the record we just updated or added.  If the
// DataSource contains +link{DataSource.getPrimaryKeyFields(),primary key fields} of type
// <code>sequence</code>, the framework will first attempt to obtain values for those
// fields - see +link{type:SequenceMode,sequenceMode}.
// <p>
// This is the most complete and foolproof way to get cache sync data, because we pick up any
// changes to the record that were applied by the persistence layer - for example database
// default values, values applied by database triggers or transformations applied to the
// record we sent by a remote REST service or legacy program call.  However, it is also the
// least performant, since it involves a full refetch of the data.
// This is the default strategy for +link{group:sqlDataSource,SQL DataSources} and
// +link{group:writeCustomDataSource,custom DataSources}.  It is also the strategy used for
// +link{group:hibernateIntegration,Hibernate} and +link{group:jpaIntegration,JPA} DataSources,
// though for these two, it is implemented inherently by the ORM system and you should not
// attempt to change it.  See the +link{group:cacheSynchronization,cache synchronization overview}
// for details
//
// @value "requestValuesPlusSequences"
// Obtain cache sync values by merging the request values on top of the request's
// +link{dsRequest.oldValues,oldValues}.  If the DataSource contains
// +link{DataSource.getPrimaryKeyFields(),primary key fields} of type <code>sequence</code>,
// the framework will then attempt to obtain values for those fields - see
// +link{type:SequenceMode,sequenceMode} - and merge those values into the cache sync data as
// well. This strategy avoids a data refetch, which may be a significant performance gain
// (though please see the note in the <code>sequenceMode</code> documentation regarding Oracle
// as a special case in this regard).
// Despite the name, this strategy is also suitable and effective for situations where
// your keys are not sequences - for example, when they are GUIDs or when they are user-entered
// codes.  In this case, we simply do not attempt to resolve sequence values, and since the
// key values are already included in the request values, everything works
// <p>
// Note, if no <code>oldValues</code> are available and the updated record is
// +link{dataSource.sparseUpdates,incomplete}, or if the combination of <code>oldValues</code>
// and values is missing a value for a +link{dataSourceField.required,required field} for any
// other reason, this strategy will return incomplete cache sync data.  For details of what we
// do in these circumstances, see the "CacheSyncStrategy" section of the
// +link{group:cacheSynchronization,cache synchronization overview}
//
// @value "responseValues"
// This strategy simply returns the data returned by the add or update operation, as the cache
// sync data.  This only makes sense for <code>DataSource</code> types that return a value for
// an update operation.  This may include generic DataSources
// <release14> and <code>RestConnector</code>s</release14>,
// depending entirely on what the implementation returns.  It specifically does not include
// +link{group:sqlDataSource,SQL DataSources}, because SQL/JDBC update operations do not return
// a value (other than the number of affected records).
// <p>
//>ISC_140
// This is the default strategy for +link{group:serverRestConnector,RestConnector}s, because
// it was the default way we did cache sync for that DataSource type before
// <code>CacheSyncStrategy</code> was introduced (and also because it is the ideal strategy
// for REST services that return the record-as-updated).  See +link{DataSource.cacheSyncStrategy}
// for details of how to change the default strategy for a given dataSource type.
//<ISC_140
//
// @value "none"
// This strategy does not attempt to derive cache sync data at all.  No response data is sent
// back to the caller, and the response is marked for
// +link{dsResponse.invalidateCache,cache invalidation}
//
// @see group:cacheSynchronization
// @visibility external
//<

//> @type CacheSyncTiming
// Indicates the timing strategy to be used for
// +link{group:cacheSynchronization,automatic cache synchronization}, for a given
// +link{dataSource.cacheSyncTiming,DataSource},
// +link{operationBinding.cacheSyncTiming,OperationBinding} or
// +link{dsRequest.cacheSyncTiming,DSRequest}.  This property controls the "when" of cache
// synchronization; the "how" is controlled by +link{type:CacheSyncStrategy}.
// <P>
// <b>NOTE:</b> <code>CacheSyncTiming</code> is intended to allow applications to defer cache
// synchronization to the point where response data is actually requested; the primary aim of
// this is to avoid doing cache sync altogether in cases where the response data is never
// requested.  There are some mainstream types of request where we know that the response data
// unequivocally <i>is</i> required, and for these requests a global
// default <code>CacheSyncTiming</code> will be overridden to "immediate" by SmartClient
// because there is no point in deferring cache sync when we know for sure it will eventually
// be needed.  Thus, cache sync will always run immediately regardless of the default
// <code>cacheSyncTiming</code> setting in these cases:<ul>
// <li>Requests sent from a client</li>
// <li>Server-created requests that copy an <code>RPCManager</code> across from a
//     client-originated request, either by specifying it in the <code>DSRequest</code>
//     constructor, or by calling <code>dsRequest.setRPCManager()</code></li>
// </ul>
// <p>
// The above only applies to the global default <code>cacheSyncTiming</code>: a
// <code>cacheSyncTiming</code> set explicitly at the +link{dataSource.cacheSyncTiming,DataSource},
// +link{operationBinding.cacheSyncTiming,operation} or +link{dsRequest.cacheSyncTiming,request}
// level will usually be honored.  However, even an explicit <code>cacheSyncTiming</code>
// setting on the DataSource, operation or request will be ignored in situations where it could
// break a framework feature if we honored it.  These situations are:
// <ul>
// <li>Requests where +link{dataSource.audit,automatic auditing} is in force</li>
// <li>Requests on a dataSource with one-to-many or many-to-many relations, where the update
//     means that SmartClient must update foreign keys on the related dataSources to maintain
//     relation integrity</li>
// </ul>
// In both these cases, we cannot allow the cache sync to be deferred because it is possible
// that a deferred cache sync fetch would never be invoked - indeed, that is the whole point
// of allowing cache sync to be deferred - and in that case, key processes would fail to run.
// <P>
// @value "immediate"
// Obtain cache sync values immediately after the update operation returns
//
// @value "lazy"
// Defer running cache sync until the first time <code>getData()</code> is called on the
// server-side <code>DSResponse</code>.  As described above, the point of deferring cache
// sync is to avoid running it at all in cases where nothing needs the response data (and thus
// nothing calls <code>getData()</code>).  In addition to the above-listed cases where we know
// that cache sync is <i>always</i> going to be required, there are other cases where
// <code>getData()</code> will be called, even if your application code doesn't do so.  Some
// examples:<ul>
// <li>If logging levels are set such that the framework is logging response data</li>
// <li>If you have a +link{dataSourceField.multiple,multiple} field in your dataSource and its
// value requires transformation because of +link{dataSourceField.multipleStorage,multipleStorage}
// or +link{dataSource.transformMultipleFields,transformMultipleFields} settings</li>
// </ul>
// In these cases, and others where the response data is required, the cache sync process will
// be deferred to later in the process, but it will run.
//
// @see group:cacheSynchronization
// @visibility external
//<



// synonym, isc namespace only (never a global)
isc.DS = isc.DataSource;

// static properties and methods
isc.DataSource.addClassProperties({


    // locating dataSources
    dataSourceObjectSuffix : "DS",            // suffix for the global to hold info about a dataSource,
                                            //    eg:  var myDataSourceDS = {...}

    _dataSources : {},                        // internal array to hold the list of dataSources we've loaded
    _elements : {},                            // internal array of XSElements
    _types : {},                            // internal array of XSComplexTypes
    _$element : "element", _$type:"type",
    _tableCodesToDatasourceIds: {},         // a map to find loaded sql datasource by it's tableCode
    _fkTableCodesToDatasourceIds: {},
    _constructorToDatasourceIds: {},        // a map from Constructor values in schemas to the Datasource ID,
                                            // so that we can determine the schema for a class if the schema ID
                                            // is different from the class name, but has a Constructor attribute
                                            // equal to the class name

    TABLE : "table",                        // table type of datasource
    VIEW : "view",                            // view type of datasource (virtual datasource)

    //> @classAttr DataSource.loaderURL (URL : DataSource.loaderURL : RW)
    //
    // The URL where the DataSourceLoader servlet has been installed.  Defaults to the
    // +link{Page.setIsomorphicDir,isomorphicDir} plus "/DataSourceLoader".  Change by calling
    // calling +link{DataSource.setLoaderURL()}
    //
    // @visibility external
    //<
    loaderURL:"[ISOMORPHIC]/DataSourceLoader",

    //> @classAttr DataSource.defaultStringInBrowser (Boolean : null : RW)
    // Default value if +link{dataSourceField.stringInBrowser} is not defined. See
    // <code>stringInBrowser</code> docs for details.<br>
    // Note this setting should be used only if you are *not* using the SmartClient Server.
    //
    // @see dataSourceField.stringInBrowser
    // @visibility external
    //<

    // deepCloneOnEdit: If we have nested dataSources, and have edit-components bound to these
    // DS's, using dataPath to extract values from inner objects, should the field values be
    // recursively duplicated on edit.
    // Default value is true - this is required to support standard functionality such as being
    // able to pass a ListGrid record to a DynamicForm for editing and avoiding having both
    // components referencing the same inner-objects in memory [thus leading to edits directly
    // effecting the ListGrid record with no save-step or other notification].

    deepCloneOnEdit:true,

    // See class method registerSgwtDS()
    DS_FN: {},

    // chunks of SOAP messages
    _soapEnvelopeStart : "<soap:Envelope xmlns:soap='http://schemas.xmlsoap.org/soap/envelope/' ",
    _soapEnvelopeEnd : "</soap:Envelope>",
    _soapHeaderStart : "<soap:Header>",
    _soapHeaderEnd : "</soap:Header>",
    _soapBodyStart : "<soap:Body", // intentionally unterminated
    _soapBodyEnd : "</soap:Body>",

    // Shallow clones the given DSRequest. The request data is also shallow cloned.
    _cloneDSRequest : function (dsRequest, dontIncludePromptProperties) {
        if (dsRequest == null) return null;

        if (dsRequest.unconvertedDSRequest != null) {
            dsRequest = dsRequest.unconvertedDSRequest;
        }

        var clonedDSRequest = {
            // Core DSRequest configuration
            operationId: dsRequest.operationId,
            operationType: dsRequest.operationType,
            data: isc.shallowClone(dsRequest.data),
            textMatchStyle: dsRequest.textMatchStyle,
            sortBy: dsRequest.sortBy,
            startRow: dsRequest.startRow,
            endRow: dsRequest.endRow,
            oldValues: dsRequest.oldValues,
            outputs: dsRequest.outputs,
            httpMethod: dsRequest.httpMethod,
            httpHeaders: dsRequest.httpHeaders,
            params: dsRequest.params,
            useHttpProxy: dsRequest.useHttpProxy,
            willHandleError: dsRequest.willHandleError,

            // Advanced or uncommonly-used DSRequest configuration properties
            actionURL: dsRequest.actionURL,
            dataProtocol: dsRequest.dataProtocol,
            additionalOutputs: dsRequest.additionalOutputs,
            allowIE9Leak: dsRequest.allowIE9Leak,
            bypassCache: ("_origBypassCache" in dsRequest ? dsRequest._origBypassCache : dsRequest.bypassCache),
            callbackParam: dsRequest.callbackParam,
            clientContext: dsRequest.clientContext,
            componentId: dsRequest.componentId,
            containsCredentials: dsRequest.containsCredentials,
            contentType: dsRequest.contentType,
            downloadResult: dsRequest.downloadResult,
            downloadToNewWindow: dsRequest.downloadToNewWindow,
            evalResult: dsRequest.evalResult,
            evalVars: dsRequest.evalVars,
            fallbackToEval: ("_origFallbackToEval" in dsRequest ? dsRequest._origFallbackToEval : dsRequest.fallbackToEval),
            generateRelatedUpdates: dsRequest.generateRelatedUpdates,
            groupBy: dsRequest.groupBy,
            headerData: dsRequest.headerData,
            ignoreTimeout: dsRequest.ignoreTimeout,
            keepParentsOnFilter: dsRequest.keepParentsOnFilter,
            lineBreakStyle: dsRequest.lineBreakStyle,
            omitNullMapValuesInResponse: dsRequest.omitNullMapValuesInResponse,
            paramsOnly: dsRequest.paramsOnly, // deprecated
            parentNode: ("_origParentNode" in dsRequest ? dsRequest._origParentNode : dsRequest.parentNode),
            pendingAdd: dsRequest.pendingAdd,
            progressiveLoading: dsRequest.progressiveLoading,
            resultSet: dsRequest.resultSet,
            resultTree: dsRequest.resultTree,
            sendNoQueue: dsRequest.sendNoQueue,
            serverOutputAsString: dsRequest.serverOutputAsString,
            shouldUseCache: dsRequest.shouldUseCache,
            streamResults: dsRequest.streamResults,
            tenantId: dsRequest.tenantId,
            summaryFunctions: dsRequest.summaryFunctions,
            suppressAutoDraw: dsRequest.suppressAutoDraw,
            timeout: dsRequest.timeout,
            transport: dsRequest.transport,
            useFlatFields: dsRequest.useFlatFields,
            useFlatHeaderFields: dsRequest.useFlatHeaderFields,
            useSimpleHttp: dsRequest.useSimpleHttp,
            useStrictJSON: ("_origUseStrictJSON" in dsRequest ? dsRequest._origUseStrictJSON : dsRequest.useStrictJSON),
            useXmlHttpRequest: dsRequest.useXmlHttpRequest, // deprecated
            validationMode: dsRequest.validationMode
        };

        if (!dontIncludePromptProperties) {
            clonedDSRequest.showPrompt = dsRequest.showPrompt;
        }

        // Copy the export* and prompt* properties
        for (var propName in dsRequest) {
            if (propName.startsWith("export") ||
                (!dontIncludePromptProperties && propName.startsWith("prompt")))
            {
                clonedDSRequest[propName] = dsRequest[propName];
            }
        }

        return clonedDSRequest;
    },

    _cloneDSResponse : function (dsResponse) {
        if (dsResponse == null) return null;

        return {
            clientContext: dsResponse.clientContext,
            data: isc.shallowClone(dsResponse.data),
            dataSource: dsResponse.dataSource,
            endRow: dsResponse.endRow,
            errors: dsResponse.errors,
            fromOfflineCache: dsResponse.fromOfflineCache,
            httpHeaders: dsResponse.httpHeaders,
            httpResponseCode: dsResponse.httpResponseCode,
            httpResponseText: dsResponse.httpResponseText,
            invalidateCache: dsResponse.invalidateCache,
            offlineTimestamp: dsResponse.offlineTimestamp,
            operationType: dsResponse.operationType,
            queueStatus: dsResponse.queueStatus,
            startRow: dsResponse.startRow,
            status: dsResponse.status,
            totalRows: dsResponse.totalRows,
            transactionNum: dsResponse.transactionNum
        };
    },

    _dsCallbackArgNames: "dsResponse,data,dsRequest"
});

isc.DataSource.addClassMethods({

    create : function (A,B,C,D,E,F,G,H,I,J,K,L,M) {
        var id = A ? A.ID : null;


        if (isc.DataSource._doNotClobber) {
            var instance;
            if (id) instance = isc.DataSource.get(id);
            if (instance) {
                if (this.logIsInfoEnabled()) {
                    this.logInfo("skipping create, returning existing DS for ID:'" + id + "'");
                }
                return instance;
            }
        }

        if (this.DS_FN) delete this.DS_FN[id];

        return this.invokeSuper(this, "create", A,B,C,D,E,F,G,H,I,J,K,L,M);
    },

    // Looking up and loading DataSources
    // --------------------------------------------------------------------------------------------

    //> @classMethod dataSource.verifyDataSourcePair()
    // A utility that checks for discrepancies between any two DataSources, typically used to
    // warn about issues commonly found during the Reify design / development cycle, and logs
    // its findings to the console.  Similar to the server-side
    // +serverDocLink{validator, ReifyDataSourceValidator} in scope, but with no support for
    // server-only attributes (e.g., Declarative Security).
    // <p>
    // INFO level messages are logged when any of the following conditions are discovered:
    // <ul>
    //   <li>A field defined in "live" is not also present in mock</li>
    //   <li>A field defined in "live" has a different title than mock (fields using i18n titles are not checked) </li>
    // </ul>
    // WARN level messages are logged when any of the following conditions are discovered:
    // <ul>
    //   <li>A field defined in mock is not also present in "live"</li>
    //   <li>A field defined in mock has a different type than in live (and the live type is a not a sub-type of the mock type)</li>
    //   <li>Fields in mock have a different order than in "live" (after ignoring any fields that mock lacks)</li>
    // </ul>
    // <p>
    //
    // @param live (DataSource) DataSource to compare using 'live' rules
    // @param mock (DataSource) DataSource to compare using 'mock' rules
    // @return (Array of Object) Each message logged, with its fieldName &amp; severity level
    // @visibility external
    //<

    verifyDataSourcePair : function(live, mock) {

        isc.Log.logDebug('Comparing mock ds ' + mock.ID + 'to live ds ' + live.ID, 'DataSource');

        var result = [];
        var mockFieldNames = mock.getFieldNames();
        var liveFieldNames = live.getFieldNames();
        var notPresentInLive = [];

        var buildMessage = function(name, severity, message) {
            return {
                fieldName: name,
                severity: severity,
                message: message.asHTML()
            };
        };

        for (var ele = 0; ele < mockFieldNames.length; ele++) {
            var mockName = mockFieldNames[ele];
            var mockField = mock.getField(mockName);
            var liveField = live.getField(mockName);

            var fqMockName = mock.ID.replace('isctmp_', '') + '.' + mockName;


            // field in mock is not present in live
            if (! liveField) {
                result.add(buildMessage(mockName, 'WARN', 'DataSource field "' +
                    fqMockName + '" is present in mock but not live.'));
                notPresentInLive.add(mockName);
                continue;
            }

            // field is mock has different type in live, and live type is a not a
            // sub-type of mock type
            var typesEqual = liveField.type == mockField.type;
            var typeInherited = false;
            if (!typesEqual) {
                var simpleType = isc.SimpleType.getType(liveField.type);
                if (simpleType && simpleType.inheritsFrom == mockField.type) {
                    typeInherited = true;
                }
            }
            if (!typesEqual && !typeInherited) {
                result.add(buildMessage(mockName, 'WARN', 'DataSource field "'+ fqMockName +
                    '" has different type in mock than live, and live type "' + liveField.type +
                    '" is a not a sub-type of mock type "' + mockField.type + '".'));
            }

        }

       // we've already warned about fields that were in mock but are not in live,
       // so just remove them prior to comparing field order
       mockFieldNames.removeList(notPresentInLive);

       /*
          If there are additional or reordered fields in the live DS, then as we look at
          remaining fields, we need to keep an offset in mind and not report reordering
          of fields if the fields have the same name and are offset by that expected amount.
          Example:

          Live:  ID, BottomNote, Building, ClientID, Commission, CommissionFrozen, CompleteDate
          Mock:  ID, BottomNote, ClientID, CompleteDate, Building, Commission, CommissionFrozen

          Should warn about Building & Commission field orders only.
        */
        var distance = 0;
        var blockIndex = 0;
        for (var idx = 0; idx < liveFieldNames.length; idx++) {
            var liveName = liveFieldNames[idx];
            var liveField = live.getField(liveName);
            var mockField = mock.getField(liveName);

            var fqLiveName = live.ID + '.' + liveName;

            // field in live is not present in mock
            if (! mockField) {
                result.add(buildMessage(liveName, 'INFO', 'DataSource field "' +
                    fqLiveName + '" is present in live but not in mock.'));
                continue;
            }

            // field in live has different title than mock
            var title = liveField.title;
            if (title != null && title != mockField.title) {
                result.add(buildMessage(liveName, 'INFO', 'DataSource field "' +
                    fqLiveName + '" has different title in live (' + title +
                    ') than mock (' + mockField.title + ').' ));
            }

            // fields in mock have different order in live [after ignoring fields that mock lacks]
            var mi = mockFieldNames.indexOf(liveName);

            /*
             Check that its either at the expected offset or otherwise found at the calculated
             distance from the last match (e.g. a block of fields are shifted forward)
             */
            if (mi != idx && mi != blockIndex+1 &&
                mi != idx+distance && mi != idx-distance) {

                distance = Math.abs(idx-mi);
                result.add(buildMessage(liveName, 'WARN', 'DataSource field "' +
                    fqLiveName + '" has different order in live (' + idx + ') than ' +
                    'mock (' + mi + ').'));

            } else {

                // change appears to be part of a previously detected shift
                if (mi == blockIndex + 1) {
                    blockIndex = mi;
                }
            }
        }

        return result;
    },

    isLoaded : function (name) {
        // if no name was passed to us, return false
        if (!name) return false;
        if (isc.isA.DataSource(name) || this._dataSources[name]) return true;
        return false;
    },

    //> @classMethod DataSource.getDataSource()
    // Lookup a DataSource by ID.
    //
    // @param ID (GlobalId) DataSource ID
    // @return (DataSource) the DataSource with this ID, if loaded, otherwise null.
    // @visibility external
    //<
    // If the dataSource does not exist locally and a callback is provided to this method, we
    // attempt to fetch the named datasource from the server and callback.
    _$refColon:"ref:",
    _$withIDColon:"withID:",
    getDataSource : function (name, callback, context, schemaType) {
        // if no name was passed to us, return null
        if (!name) return null;

//        if (isc.isA.DataSource(name)) {
//            alert("getting datasource: " + name);
//        } else {
//            alert("getting name: " + name);
//        }

        // handle being passed a DataSource instance
        if (isc.isA.DataSource(name)) return name;

        // strip off the "ref:" prefix used in the XML format.  Happens when a field of
        // DataSource type has been declared as an XML attribute (if it's not an attribute you
        // get <DataSource ref="dsId"/> and this is handled during XML->JS translation)
        if (isc.startsWith(name, this._$refColon)) {
            name = name.substring(4);
        } else if (isc.startsWith(name, this._$withIDColon)) {
            name = name.substring(7);
        }

        if (schemaType && isc.WebService) {
            if (schemaType == isc.DS._$element) return this._elements[name];
            if (schemaType == isc.DS._$type) return this._types[name];
            return null;
        }

        // load the ds (clientside)
        var ds = this._dataSources[name];
        if (!ds) {
            // If this is a DataSource that has been registered as having been created in
            // SmartGWT, create it JS-side now
            if (isc.DataSource.DS_FN && isc.DataSource.DS_FN[name]) {
                // Remove it from the SGWT pending list before calling into the create
                // method, otherwise we get a recursion loop
                var work = isc.DataSource.DS_FN[name];
                delete isc.DataSource.DS_FN[name];
                work.call(null);
            }
            ds = this._dataSources[name];
            if (!ds) {
                ds = this._loadDataSource(name, callback);
                if (ds) ds.ID = name; // tell the dataSource its name for later
            }
        }

        if (ds) {
            // if they've specified a callback, call the callback in addition to returning the ds
            // Note, the ability to provide a callback is not publicly documented, so changing
            // this from passing the DS instance to the DS ID is not a backompat issue
            if (callback) {
                this.fireCallback(callback, "dsID", [ds.ID], ds);
            }

            return ds;
        }

        // load from server if a callback was passed
        if (callback) {
            this.load(name, callback, context);
        }

        // let the caller know that we don't have the datasource.  if a callback was passed,
        // the caller will be notified via the callback.
        return null;
    },

    // loadSchema - attempt to load a remote dataSource schema from the server.
    // This is supported as part of the SmartClient server functionality
    loadSchema : function (name, callback, context) {
        this.logWarn("Attempt to load schema for DataSource '" + name +
            "'. This dataSource cannot be found. To load DataSources from the server without " +
            "explicit inclusion in your application requires optional SmartClient server " +
            "support - not present in this build.");
        return null;
    },


    //> @classMethod DataSource.get()
    // Synonym of +link{getDataSource()}: Lookup a DataSource by ID.
    //
    // @param ID (GlobalId) DataSource ID
    // @return (DataSource) the DataSource with this ID, if loaded, otherwise null.
    // @visibility external
    //<
    get : function (name, callback, context, schemaType) {
        return this.getDataSource(name, callback, context, schemaType);
    },

    _loadDataSource : function (name, callback) {
        if (callback) return null; // no error if we're going to try to load from server.

        //>DEBUG
        if (name != isc.auto && this.logIsDebugEnabled()) {
            this.logDebug("isc.DataSource '" + name + "' not present");
        }
        //<DEBUG

        // couldn't load the dataSource -- return null
        return null;
    },

    // returns a list of all registered datasources
    getRegisteredDataSources : function () {
        return isc.getKeys(this._dataSources);
    },

    getRegisteredDataSourceObjects : function (skipInternal, skipSchema, skipISC, skipAuto) {
        var keys = this.getRegisteredDataSources(),
            result = [];

        for (var i=0; i<keys.length; i++ ) {
            var ds = this.getDataSource(keys[i]);
            if (!ds || !ds.ID) continue;


            if (skipInternal && ds._internal || skipAuto && ds._autoAssignedID ||
                skipSchema && (ds.componentSchema || ds.builtinSchema) ||
                skipISC && !ds._autoAssignedID && ds.ID.startsWith("isc_"))
            {
                continue;
            }

            result.add(ds);
        }
        return result;
    },

    // returns true if the named DS is registered, false otherwise
    isRegistered : function (name) {
        if (this._dataSources[name]) return true;
        return false;
    },

    _excludeDSProperties: ["serverType", "apidoc", "isSampleDS", "sample", "clientOnly", "fromServer", "tableCode", "testFileName", "dbImportFileName"],
    _excludeDSFieldProperties: ["columnCode"],

    //> @classMethod DataSource.getProjectDataSourceDefinitions()
    // Returns a single string containing the XML definitions of all DataSources in the
    // current application excluding internal, schema and auto-assigned ID DataSources
    // along with those that have an ID prefixed with 'isc_'.
    // @return (String) the DataSource definitions in XML
    // @visibility internal
    //<
    getRegisteredDataSourceDefinitions : function (format, includeData, dataSources) {
        if (dataSources == null) dataSources = this.getRegisteredDataSourceObjects(true, true, true, true);
        var isJSON = (format == "json") || (format == "pseudocode");
        var encoder = (isJSON ? isc.JSONEncoder.create() : null),
            separator = (isJSON ? "\n" : "")
        ;

        return dataSources.map(function (ds) {
            var defaults = ds.getSerializeableFields(),
                dsClass = ds.getClassName(),
                schema
            ;

            if (isc.DS.isRegistered(dsClass)) {
                schema = isc.DS.get(dsClass);
            } else {
                schema = isc.DS.get("DataSource");
                defaults._constructor = dsClass;
            }

            // Remove excluded DS properties
            isc.DS._excludeDSProperties.map(function (property) {
                delete defaults[property];
            });
            for (var property in defaults) {
                if (property.startsWith("_")) {
                    delete defaults[property];
                }
            }

            // Remove auto-generated validators and remove any auto-generated
            // properties from the remaining ones
            if (defaults.fields) {
                var fields = defaults.fields;
                for (var i = 0; i < fields.length; i++) {
                    fields[i] = isc.DS._getSerializeableFieldObject(fields[i]);
                }
            }

            // Unless data is requested, drop it from the defaults
            if (!includeData) {
                delete defaults.testData;
                delete defaults.cacheData;
            }

            // serialize to XML
            // - don't include any xsi:type attributes on field values.
            var serializedDS = (isJSON ?
                encoder.encode(defaults) :
                schema.xmlSerialize(defaults, { ignoreExplicitTypes: true }));
            if (format == "pseudocode") {
                serializedDS = "isc.DataSource.create(" + serializedDS + ");"
            }
            return serializedDS;
        }).join(separator);
    },

    // Helper for getRegisteredDataSourceDefinitions() - clears unserializeable
    // properties from a dsField object
    _getSerializeableFieldObject : function (field) {
        var validators = field.validators;
        if (validators) {
            var basicValidators = [];
            for (var j = 0; j < validators.length; j++) {
                var validator = validators[j];
                if (validator._basic) {
                    basicValidators.add(validator);
                }
                delete validator.ID;
                if (!validator.defaultErrorMessage) {
                    delete validator.defaultErrorMessage;
                }
            }
            if (basicValidators.length > 0) {
                validators.removeAll(basicValidators);
            }
        }
        if (validators && validators.length == 0) {
            delete field.validators;
        }
        isc.DS._excludeDSFieldProperties.map(function (property) {
            delete field[property];
        });
        for (var property in field) {
            if (property.startsWith("_")) {
                delete field[property];
            }
        }
        return field;
    },

    // Foreign Key relationships
    // --------------------------------------------------------------------------------------------
    // field.foreignKey can be [dataSourceID].[fieldName] or just [dataSourceID], where the latter
    // form means it's a foreignKey on the other dataSource's primary key fields.

    // methods to break up field.foreignKey into the target DataSource and field name.  Factored in
    // case we ever want to change our somewhat hokey foreign key scheme
    getForeignFieldName : function (field) {
        var foreignKey = field.foreignKey,
            dotIndex = foreignKey.indexOf(".");

        // If there is no dot the foreignkey is a field within this dataSource.

        // If there are multiple dots, this is an indirect foreignKey
        while (dotIndex >= 0) {
            foreignKey = foreignKey.substring(dotIndex + 1);
            dotIndex = foreignKey.indexOf(".");
        }
        return foreignKey;
    },

    getForeignDSName : function (field, defaultDS, returnArray) {
        var foreignKey = field.foreignKey,
            dotIndex = foreignKey.lastIndexOf(".");

        var allDSs = [];

        // If there is no dot the foreignkey is a field within this dataSource.

        // If there are multiple dots, this is an indirect foreignKey - in this case we're interested in
        // the last dataSource in the chain
        if (dotIndex == -1) {
            if (defaultDS == null) return null;
            var dsID = isc.isA.String(defaultDS) ? defaultDS : defaultDS.ID;
            return (returnArray ? [dsID] : dsID);
        } else {
            foreignKey = foreignKey.substring(0,dotIndex);
            dotIndex = foreignKey.indexOf(".");
        }
        while (dotIndex >= 0) {
            if (returnArray) allDSs.push(foreignKey.substring(0,dotIndex));
            foreignKey = foreignKey.substring(dotIndex + 1);
            dotIndex = foreignKey.indexOf(".");
        }
        if (returnArray) allDSs.push(foreignKey);
        return returnArray ? allDSs : foreignKey;

    },

    registerDataSource : function (dataSource) {
        //>DEBUG
        if (this.logIsInfoEnabled()) {
            this.logInfo("Registered new isc.DataSource '" + dataSource.ID + "'");
        }
        //<DEBUG
        if (dataSource.ID) {
            var existingDS = this._dataSources[dataSource.ID];
            // overwrite any existing registered DataSource, unless we have a schemaNamespace.
            // This avoids XMLSchema-derived Schema cloberring ordinary DataSources, since
            // XMLSchema-derived DataSources can be looked up via other means
            // (SchemaSet.getSchema())
            if (!existingDS || !dataSource.schemaNamespace) {
                this._dataSources[dataSource.ID] = dataSource;
            }

            // Keep track of any Constructor or equivalent, if it isn't equal
            // to the ID.  That way, we can find a schema which can create
            // the class, even if the schema ID is not equal to the className.
            // The _constructor || Constructor || type is also what
            // getNearestSchemaClass() does.
            var cons = dataSource._constructor || dataSource.Constructor || dataSource.type;
            if (cons && (cons != dataSource.ID)) {
                this._constructorToDatasourceIds[cons] = dataSource.ID;
            }

            if (dataSource.tableCode) {
                this._tableCodesToDatasourceIds[dataSource.tableCode] = dataSource.ID;
                var linkedDatasources = this._fkTableCodesToDatasourceIds[dataSource.tableCode];
                if (linkedDatasources) {
                    for (var i = 0; i < linkedDatasources.length; i++) {
                        var linkedDSName = linkedDatasources[i];
                        var linkedDS = isc.DS.get(linkedDSName);
                        var linkedDSFields = linkedDS.getFields();
                        var dsFields = dataSource.getFields();
                        for (var linkedDSFieldName in linkedDSFields) {
                            for (var dsFieldName in dsFields) {
                                if (linkedDSFields[linkedDSFieldName].fkColumnCode == dsFields[dsFieldName].columnCode) {
                                    linkedDSFields[linkedDSFieldName].foreignKey = dataSource.ID + "." + dsFields[dsFieldName].name;
                                    break;
                                }
                            }
                        }
                        linkedDS.addChildDataSource(dataSource);
                        linkedDatasources.removeAt(i);
                        i--;
                    }
                    if (linkedDatasources.length == 0) {
                        delete this._fkTableCodesToDatasourceIds[dataSource.tableCode];
                    }
                }
            }
        }


        if (isc.Schema && isc.isA.Schema(dataSource)) {
            if (isc.isAn.XSElement(dataSource)) this._elements[dataSource.ID] = dataSource;
            else if (isc.isAn.XSComplexType(dataSource)) this._types[dataSource.ID] = dataSource;
            return;
        }



        // link DataSources with foreignKeys to each other as they are loaded
        // -----------------------------------------------------------------------------------

        var fields = dataSource.getLocalFields(true);

        var unlinkedChildren = this._unlinkedChildren = (this._unlinkedChildren || {});

        // try to satisfy this DS's foreignKey relationships
        for (var fieldName in fields) {
            var field = fields[fieldName];
            var targetDSName = null;
            if (field.fkTableCode) {
                targetDSName = this._tableCodesToDatasourceIds[field.fkTableCode];
                // check whether sql datasource with encoded tableName was already loaded
                if (targetDSName == null) {
                    if (this._fkTableCodesToDatasourceIds[field.fkTableCode] == null) {
                        this._fkTableCodesToDatasourceIds[field.fkTableCode] = [];
                    }
                    this._fkTableCodesToDatasourceIds[field.fkTableCode].add(dataSource.ID);
                    continue;
                }
                var ds = isc.DS.get(targetDSName);
                var dsFields = ds.getFields();
                for (var dsFieldName in dsFields) {
                    if (dsFields[dsFieldName].columnCode == field.fkColumnCode) {
                        field.foreignKey = ds.ID + "." + dsFields[dsFieldName].name;
                    }
                }
            } else if (field.foreignKey) {
                var targetDSName = this.getForeignDSName(field, dataSource);
            } else {
                continue;
            }
            if (isc.DS.isRegistered(targetDSName)) {
                //this.logWarn("dataSource: " + dataSource.ID + " found parent: " + targetDS.ID);
                // tell the other DataSource that this DS links to it in a 1 to many
                // relationship
                isc.DS.get(targetDSName).addChildDataSource(dataSource);
            } else {
                //this.logWarn("dataSource: " + dataSource.ID + " could not find parent: " +
                //             targetDSName);
                // add ourselves to the list of future children of targetDS, to be linked up
                // whenever it gets loaded
                if (unlinkedChildren[targetDSName] == null) {
                    unlinkedChildren[targetDSName] = [];
                }
                unlinkedChildren[targetDSName].add(dataSource);
            }
        }

        // see if this new DS satisfies any foreignKey relationships
        var children = unlinkedChildren[dataSource.ID];
        if (children != null) {
            //this.logWarn("dataSource: " + dataSource.ID + " found children: " + children);
            dataSource.map("addChildDataSource", children);
            unlinkedChildren[dataSource.ID] = null;
        }

        // Link DataSources that declare childRelations to their children
        // ---------------------------------------------------------------------------------
        var unfoundChildren = this._unfoundChildren = this._unfoundChildren || {};
        if (dataSource.childRelations) {
            for (var i = 0; i < dataSource.childRelations.length; i++) {
                var relation = dataSource.childRelations[i],
                    childDSName = relation.dsName,
                    childDS = isc.DS.get(childDSName);
                if (childDS) {
                    //this.logWarn("dataSource: " + dataSource.ID +
                    //             " found child: " + childDS.ID);
                    this._addChildRelation(dataSource, childDS, relation);
                } else {
                    //this.logWarn("dataSource: " + dataSource.ID +
                    //             " could not find child: " + childDSName);
                    if (unfoundChildren[childDSName] == null) {
                        unfoundChildren[childDSName] = [];
                    }
                    relation.parentDS = dataSource.ID;
                    unfoundChildren[childDSName].add(relation);
                }
            }
        }
        // eg User loaded, now Account is loaded
        var relations = unfoundChildren[dataSource.ID];
        if (relations) {
            for (var i = 0; i < relations.length; i++) {
                var relation = relations[i];
                this._addChildRelation(isc.DS.get(relation.parentDS), dataSource, relation);
            }
        }

    },

    _addChildRelation : function (parentDS, childDS, relation) {
        parentDS.addChildDataSource(childDS);

        // create foreignKey marker on field
        if (!relation.fieldName) return;

        var field = childDS.getField(relation.fieldName);
        if (!field.foreignKey) {
            // HACK allows getTreeRelationship to work
            field.foreignKey = parentDS.ID + "." +
                                    parentDS.getPrimaryKeyFieldNames()[0];
        }
    },

    _equals : function (ds1, ds2) {
        if (isc.isA.DataSource(ds1)) {
            if (!isc.isA.DataSource(ds2)) ds1 = ds1.getID();
        } else {
            if (isc.isA.DataSource(ds2))  ds2 = ds2.getID();
        }
        return ds1 == ds2;
    },

    // SmartGWT DataSource registration
    // ---------------------------------------------------------------------------------------

    registerSgwtDS : function (id, commandObject) {
        isc.DataSource.DS_FN[id] = commandObject;
    },
    unregisterSgwtDS : function (id) {
        delete isc.DataSource.DS_FN[id];
    },
    reregisterSgwtDS : function (oldId, newId) {
        isc.DataSource.DS_FN[newId] = isc.DataSource.DS_FN[oldId];
        delete isc.DataSource.DS_FN[oldId];
    },

    // Unique validator IDs

    _validatorIDCount:0,
    setupFieldValidatorID : function (validator) {
        if (validator.ID == null) {
            validator.ID = "_" + (this._validatorIDCount++);
        }
        return validator;
    },

    // Schema and types
    // ---------------------------------------------------------------------------------------

    //> @classMethod dataSource.getFieldValue()
    // Helper method to return the value of the supplied field from within the supplied record,
    // looking up the value from the supplied dataPath.  This method is only of real
    // use when you are dealing with complex nested data via +link{Canvas.dataPath,dataPath};
    // it is obviously a trivial matter to obtain a field value from a flat record directly.
    // <P>
    // If the dataPath is null, this method will follow any +link{listGridField.dataPath,dataPath}
    // specified on the component field instead.  In either case, it will also extract
    // +link{simpleType.getAtomicValue(),atomic values} from custom +link{SimpleType} fields
    // where this is required.
    //
    // @param field (DataSourceField | ListGridField | DetailViewerField | FormItem)
    //  Field definition from a dataSource or dataBoundComponent.
    // @param record (Record) The valueset in which to look up the field value
    // @param dataPath (String) Optionally, a string expressing the dataPath to use for value lookup.
    //                            If null, the dataPath from the field will be used
    // @param component (Canvas) Optionally, a component to prvide extra context for the dataPath
    //                             search.  This is typically required if the dataPath traverses a list
    // @param reason (String) An optional reason for the get request, to be passed into
    //                                   any +link{simpleType.getAtomicValue()} method - see that
    //                                   API for details
    // @return (Any)
    // @visibility external
    //<
    getFieldValue : function(field, record, dataPath, component, reason) {
        return isc.Canvas._getFieldValue(dataPath, field, record, component, true, reason);
    },

    //> @classMethod dataSource.saveValueViaDataPath()
    // Helper method to save the argument value inside the argument values record, storing the
    // value at the supplied dataPath, or at the field's declared dataPath if the argument
    // dataPath is null.  This method is only of real use when you are dealing with complex
    // nested data via +link{Canvas.dataPath,dataPath}; it is obviously a trivial matter
    // to store a field value in a flat record directly.
    // <P>
    // This method will call the +link{simpleType.updateAtomicValue(),updateAtomicValue()}
    // method of custom +link{SimpleType} fields where this is required.
    //
    // @param field (DataSourceField | ListGridField | DetailViewerField | FormItem)
    //  Field definition from a dataSource or dataBoundComponent.
    // @param dataPath (String) The dataPath to store the value at.  If null, the dataPath will
    //                          be picked up from the field
    // @param value (Any) The value to save
    // @param values (Record)The valueset in which to save the field value
    // @param reason (String) An optional reason for the save request, to be passed into
    //                                   any +link{SimpleType.updateAtomicValue()} method - see that
    //                                   API for details
    // @visibility external
    //<
    saveValueViaDataPath : function(field, dataPath, value, values, reason) {
        return isc.Canvas._saveFieldValue(dataPath, field, value, values, null, true, reason);
    },

    //> @classMethod dataSource.clearValueAtDataPath()
    // Helper method to save the argument value inside the argument values record, storing the
    // value at the supplied dataPath, or at the field's declared dataPath if the argument
    // dataPath is null.  This method is only of real use when you are dealing with complex
    // nested data via +link{Canvas.dataPath,dataPath}; it is obviously a trivial matter
    // to store a field value in a flat record directly.
    // <P>
    // This method will call the +link{simpleType.updateAtomicValue(),updateAtomicValue()}
    // method of custom +link{SimpleType} fields where this is required.
    //
    // @param field (DataSourceField | ListGridField | DetailViewerField | FormItem)
    //  Field definition from a dataSource or dataBoundComponent.
    // @param dataPath (String) The dataPath at which to clear the value.  If null, the dataPath will
    //                          be picked up from the field
    // @param values (Record)The valueset from which to clear the field value
    // @visibility external
    //<
    clearValueAtDataPath : function(field, dataPath, values) {
        if (dataPath == null) {
            dataPath = field;
        }
        isc.Canvas._clearFieldValue(dataPath, values, null, true);
    },

    // helper method that returns a shallow copy of requestProperties
    // we want to avoid side-effecting the requestProperties that application developers
    // pass into our APIs, since otherwise re-used requestProperties objects might carry over
    // settings like requestProperties.prompt or requestProperties.operationId between different
    // types of operations.
    dupRequest : function (requestProperties) {
        if (!requestProperties || requestProperties._alreadyDuped) return requestProperties;

        return isc.addProperties({_alreadyDuped:true}, requestProperties);
    },

    // helper method for getObjectField; returns inheritance distance or -1 on error
    getInheritanceDistance : function (superclass, subclass) {
        // check that the arguments are in fact classes, and confirm their relationship
        var superclassObj = isc.ClassFactory.getClass(superclass),
            subclassObj = isc.ClassFactory.getClass(subclass)
        ;
        if (superclassObj == null || subclassObj == null) {
            this.logWarn("Invalid superclass and/or subclass argument provided");
            return -1;
        }
        if (!subclassObj.isA(superclass)) {
            this.logWarn(subclass + " is not a subclass of " + superclass);
            return -1;
        }

        // The normal procedure works if both are Class or both are
        // SGWTFactory.  In the mixed case, we need to get the scClass for the
        // SGWTFactory and compute using that.
        if (isc.isA.SGWTFactoryObject(superclassObj)) {
            if (!isc.isA.SGWTFactoryObject(subclassObj)) {
                superclassObj = superclassObj.getDefaultScClass();
                if (!superclassObj) {
                    this.logWarn("Could not get defaultScClass for SGWTFactory " + superclass);
                    return -1;
                }
            }
        } else if (isc.isA.SGWTFactoryObject(subclassObj)) {
            // We only get here if the superclass is not an SGWTFactory
            subclassObj = subclassObj.getDefaultScClass();
            if (!subclassObj) {
                this.logWarn("Could not get defaultScClass for SGWTFactory " + subclass);
                return -1;
            }
        }

        for (var distance = 0; subclassObj && subclassObj != superclassObj; distance++) {
            subclassObj = subclassObj.getSuperClass();
        }

        return distance;
    },

    // simple: String, Number, Boolean, Date, Time, Function
    // non-simple: null, Object, Array

    isSimpleTypeValue : function (value) {
        if (value != null && (!isc.isAn.Object(value) || isc.isA.Date(value))) return true;
        return false;
    },

    // Given an object, find the nearest schema to be used to serialize it.
    // If there is a SmartClient Class, but no schema exists (eg custom class), we find the
    // nearest SmartClient super class that has a schema.
    getNearestSchema : function (object) {
        if (object == null) return null;

        var className;
        if (isc.isA.String(object)) className = object;
        else {
            className = isc.isAn.Instance(object) ? object.getClassName() :
                                                    object._constructor || object.type || object.$schemaId;
        }

        var schema = isc.DS.get(className);

        // If there is no schema whose ID is the class name, then check
        // for a schema which can be used to construct the class name
        if (!schema) {
            schema = isc.DS.get(this._constructorToDatasourceIds[className]);
        }

        // if no schema is loaded for this class, look for a superclass schema
        if (schema) return schema;

        var theClass = isc.ClassFactory.getClass(className);
        var originalClass = theClass;

        if (theClass != null) {
            var lastSuperClass = null;
            while (schema == null && (theClass = theClass.getSuperClass()) != null &&
                                      theClass != lastSuperClass)
            {

                schema = isc.DS.get(theClass.getClassName());
                if (schema == null) {
                    schema = isc.DS.get(this._constructorToDatasourceIds[className]);
                }

                lastSuperClass = theClass;
            }

            // If we have no schema, and we're looking at an SGWTFactoryObject,
            // then try again with the SC equivalent
            if (!schema) {
                if (isc.isA.SGWTFactoryObject(originalClass)) {
                    var scClassName = originalClass.getDefaultScClassName();
                    if (scClassName) return this.getNearestSchema(scClassName);
                }
            }
        }

        return schema || isc.DS.get("Object");
    },

    // Given a SmartClient component schema name, determine the associated SmartClient class

    getNearestSchemaClass : function (type) {
        if (type == null) return null;
        var theClass;

        while (theClass == null) {
            // Pick up the dataSource for the className passed in.
            // This will allow us to determine the correct SmartClient class for the object
            // by iterating up the datasource parent chain if necessary
            var schema = isc.DS.get(type);
            // Catch the case where we're passed a schema string that we don't recognize
            if (schema == null) {
                // Check if it represents an SGWT class ... in that case, use the SGWTFactory
                var sgwtClass = isc.ClassFactory.getClass(type);
                if (sgwtClass && isc.isA.SGWTFactoryObject(sgwtClass)) {
                    return sgwtClass;
                } else {
                    return null;
                }
            }
            theClass = isc.ClassFactory.getClass(schema._constructor || schema.Constructor
                                                                     || schema.type);
            //this.logWarn("schema is: " + schema + ", theClass: " + theClass +
            //             ", schema.inheritsFrom: " + schema.inheritsFrom);

            if (theClass != null) return theClass;
            type = schema.inheritsFrom;

            if (!type) return null;
        }
        return null;
    },

    // Standard Operations
    // ----------------------------------------------------------------------------------------

    // Centrally handle backcompat synonyms for operation types
    _getStandardOperationType : function (operationType) {
        switch (operationType) {
            case "fetch":
            case "select":
            case "filter":
                return "fetch";
            case "add":
            case "insert":
                return "add";
            case "update":
                return "update";
            case "remove":
            case "delete":
                return "remove";

            default:
                // cases not covered:
                // "replace": no longer supported, but not equivalent to any supported type
                // "validate": never had a synonym

            return operationType;
        }
    },

    isClientOnly : function (dataSource) {
        if (isc.isA.String(dataSource)) dataSource = this.getDataSource(dataSource);
        if (!dataSource) return false;
        return dataSource.clientOnly;
    },

    //> @classMethod DataSource.makeFileSpec()
    //
    // Converts a file path to a +link{FileSpec}.
    //
    // @param path (String) The path to convert, e.g. "employees.ds.xml"
    // @return (FileSpec) The equivalent FileSpec, e.g. {fileName: "employees", fileType: "ds",
    //                    fileFormat: xml"}
    // @group fileSource
    // @visibility external
    //<
    makeFileSpec : function (path) {
        var fileSpec = {};

        // Remove initial or trailing "/"
        path = path.trim();
        if (path.startsWith("/")) path = path.slice(1);
        if (path.endsWith("/")) path = path.slice(0, -1);

        // Split on "/"
        var parts = path.split("/");

        // Get just the filename portion ... i.e. after last "/"
        var onlyFileName = parts[parts.length - 1];

        // If the URL included query parameters, warn and ignore them - they aren't
        // supported for FileSource requests
        var queryIndex = onlyFileName.indexOf("?"),
            queryString;
        if (queryIndex != -1) {
            queryString = onlyFileName.substring(queryIndex);
            onlyFileName = onlyFileName.substring(0,queryIndex);

            this.logWarn("File path passed to getFile() or makeFileSpec() includes a query parameter:"
                + queryString + ". This will be ignored.");
        }

        // From something like employees.ds.xml, get "ds" as the fileType and "xml" as the fileFormat
        // Rules:
        // -- the fileType and fileFormat cannot have spaces in them (that is,
        //    a dot followed at some point by a space will be interpreted as belonging
        //    to the fileName, not as separating the fileName from the fileType or fileFormat)
        // -- fileType and fileFormat are separated from the fileName and each other by a dot "."
        // -- if there is only one specified, then it is the fileType
        var tokens = onlyFileName.split(".");
        var length = tokens.length;

        switch (length) {
            case 0:
            case 1:
                // No dots found, so no fileType or fileFormat specified
                // Just break
                break;

            case 2:
                // If there is one extension, it is the fileType, as long as it has no spaces
                if (!tokens[1].contains(" ")) {
                    fileSpec.fileType = tokens[1];
                }
                break;

            default:
                // If there are two or more extensions, then check the last two
                fileSpec.fileType = tokens[length - 2];
                fileSpec.fileFormat = tokens[length - 1];

                if (fileSpec.fileFormat.contains(" ")) {
                    // If the last token had a space, then assume the whole thing is fileName
                    delete fileSpec.fileType;
                    delete fileSpec.fileFormat;
                } else if (fileSpec.fileType.contains(" ")) {
                    // If the second-last token had a space, then assume the last token is the dsFileType
                    fileSpec.fileType = fileSpec.fileFormat;
                    delete fileSpec.fileFormat;
                }
                break;
        }

        // Strip the extensions from the path, +1 for the dot
        var extensionLength = (
            fileSpec.fileType ? fileSpec.fileType.length + 1 : 0
        ) + (
            fileSpec.fileFormat ? fileSpec.fileFormat.length + 1 : 0
        );
        // If there was a query string on the original URL, strip that too
        if (queryString != null) extensionLength += queryString.length;

        if (extensionLength == 0) {
            fileSpec.fileName = path;
        } else {
            fileSpec.fileName = path.slice(0, -extensionLength);
        }
        return fileSpec;
    },

    // ResultSets creation
    // --------------------------------------------------------------------------------------------

    // make a default operation for the specified dataSource, using the specified application.
    // if no application is specified, use the default application.
    makeDefaultOperation : function (dataSourceId, operationType, operationId)
    {
        // XXX this is really only intended for the standard set of operations (fetch, update,
        // add, remove): check that operationType is valid?

        var theApp = isc.rpc.app();

        if (isc.isA.DataSource(dataSourceId)) dataSourceId = dataSourceId.ID;
        if (!dataSourceId) {
            dataSourceId = "auto";
        } else if (operationId) {

            // If we have a valid dataSource and operationId, store/lookup against the
            // dataSource, not the app - so, eg, we can have an operationId "customFetch"
            // on more than one dataSource
            var dataSource = isc.DataSource.get(dataSourceId);
            if (isc.isA.DataSource(dataSource)) {
                if (!dataSource.createdOperations) dataSource.createdOperations = {};
                var operation = dataSource.createdOperations[operationType + " " + operationId];
                if (operation == null) {
                    operation = {ID:operationId,
                                 dataSource:dataSourceId,
                                 type:operationType,
                                 filterType:"paged",
                                 loadDataOnDemand:true};
                    dataSource.createdOperations[operationType + " " + operationId] = operation;
                }
                return operation;
            }
        }

        // NOTE: removed code that added the datasource to the application if it wasn't
        // already there so that it could be looked up when performing the operation;
        // now behavior is that if no datasources are defined on the app, it will just
        // look for a currently loaded datasource with that name

        // make sure the app has an operations array
        if (theApp.operations == null) theApp.operations = {};

        // create the default operation on this DataSource

        // allow an operationId, otherwise create one based on DS and operation type
        operationId = operationId || dataSourceId + "_" + operationType;
        var operation = theApp.operations[operationId];
        if (operation == null) {
            operation = {ID:operationId,
                         dataSource:dataSourceId,
                         type:operationType,
                         filterType:"paged",
                         loadDataOnDemand:true,
                         source:"auto"};
            theApp.operations[operationId] = operation;


        }

        // return the operation
        return operation;
    },

    // ResultSet cache sync
    // --------------------------------------------------------------------------------------------
    // NOTE: if an operation modifies more than one DataSource, obviously its not going to make
    // sense to pass the same updateData to ResultSets on different DataSources.  We assume you
    // know that you don't have a ResultSet on the second DataSource, or are dropping cache on
    // updates!

    handleUpdate : function (dsResponse, dsRequest) {
        if (!this.isUpdateOperation(dsRequest.operationType)) return;

        // notify the datasource that the operation affects
        var ds = this.get(dsRequest.dataSource);
        ds.updateCaches(dsResponse, dsRequest);
    },

    // is this an operation which alters data?
    isUpdateOperation : function (operation) {
        if (operation == "add" || operation == "update" || operation == "remove" ||
            operation == "replace"
            //>!BackCompat 2004.7.23 synonyms
            || operation == "delete" || operation == "insert"
            //<!BackCompat
           ) return true;
    },

    getUpdatedData : function (dsRequest, dsResponse, useDataFromRequest) {
        var ds = this.get(dsRequest.dataSource);
        return ds.getUpdatedData(dsRequest, dsResponse, useDataFromRequest);
    },

    // ---------------------------------------------------------------------------------------

    // given a set of values from a DynamicForm, return appropriate filter criteria
    filterCriteriaForFormValues : function (formValues) {
        if (isc.DS.isAdvancedCriteria(formValues)) return formValues;

        var filterValues = {};
        for (var fieldName in formValues) {
            var formValue = formValues[fieldName];
            // Form fields may have the value "" if they held a value and were cleared out.  A
            // blank field in a form used as a filter means "field can have any value", not
            // "field must be blank", so we eliminate blank field->value pairs.
            // This also goes for a selectList where a blank value is selected, which is
            // supposed to mean "Any".
            if (formValue == null || isc.is.emptyString(formValue)) continue;

            // multi-selects are returned as an array.
            if (isc.isAn.Array(formValue)) {

                // If nothing is selected we get [], meaning no criteria
                if (formValue.length == 0) continue;
                // If blank is selected, we get ["", "otherValue", ...], meaning "field can
                // have any value".

                for (var i = 0; i < formValue.length; i++) {
                    var orValue = formValue[i];
                    if (isc.isAn.emptyString(orValue)) continue;
                }
            }

            // use the formValue as is
            filterValues[fieldName] = formValue;

            // NOTE: we do this on the client rather than the server because otherwise the client
            // would be unable to express "field must be blank" - the server would discard the
            // criterion assuming it was an artifact of the filterValues having come from a
            // DynamicForm.
        }
        return filterValues;
    },

    checkEmptyCriteria : function (criteria, subCriterion) {

        if ((subCriterion || this.isAdvancedCriteria(criteria)) && criteria.criteria) {
            if (criteria.criteria.length == 0 ) return null;

            for (var i=criteria.criteria.length-1; i>=0; i--) {
                var subCrit = criteria.criteria[i],
                    shouldRemove = false;

                if (!subCrit) shouldRemove = true;
                else {
                    if (!subCrit.criteria) {
                        // is this an empty object?
                        if (isc.isA.emptyObject(subCrit)) shouldRemove = true;
                    } else {
                        var crit = this.checkEmptyCriteria(subCrit, true);
                        if (crit) criteria.criteria[i] = crit;
                        else shouldRemove = true;
                    }
                }

                if (shouldRemove) criteria.criteria.removeAt(i);
            }
        }

        return criteria;
    },

    //> @classAttr DataSource.serializeTimeAsDatetime (boolean : false : IRA)
    // Specifies how time field values should be serialized when being sent to the server for
    // dataSources with dataFormat <code>"xml"</code> or <code>"json"</code>.
    // If <code>false</code> the time field will be serialized as a logical time object in
    // UTC, using the standard truncated XML Schema format: <code>"HH:MM:SS"</code>.
    // If <code>true</code> the time field will be serialized as a complete dateTime object
    // matching the value of the underlying JavaScript date object representing this time on the
    // client.
    // @visibility external
    //<

    serializeTimeAsDatetime:false,

    //> @object DSLoadSettings
    // Settings to control optional +link{DataSource.load,DataSource loading} features.
    //
    // @treeLocation Client Reference/Data Binding/DataSource
    // @see dataSource.load()
    // @visibility external
    //<

    //> @attr dSLoadSettings.forceReload (Boolean : null : IRW)
    // Forcibly reload a dataSource if it's already loaded.
    // @visibility external
    //<
    //> @attr dSLoadSettings.loadParents (Boolean : null : IRW)
    // Load parent DataSources automatically for DataSources that have an
    // +link{DataSource.inheritsFrom,inheritsFrom} defined. Otherwise a DataSource
    // with inheritsFrom will be broken if the parent DataSource is not already loaded.
    // @visibility external
    //<
    //> @attr dSLoadSettings.mockMode (Boolean : null : IRW)
    // Place loaded DataSource into +link{dataSource.mockMode,mockMode}
    // @visibility external
    //<

    //> @classMethod DataSource.load()
    // Load a DataSource or an array of DataSources using the DataSourceLoader servlet.  When
    // a callback is specified, this is fired after the DataSources are loaded.  The callback
    // is passed a single parameter, the <code>dsID</code> list passed into the method.  If
    // no loading occurs because the requested DataSource(s) are already loaded, a warning is
    // logged and the callback is fired immediately.
    // <P>
    // To force reloading of DataSources that have already been loaded,
    // pass <code>true</code> for the forceReload parameter. Note that if a DataSource has been
    // created locally with the specified ID, even if this is a +link{MockDataSource}, the
    // <code>forceReload</code> parameter will be required to force the "real" dataSource
    // to be loaded.
    //
    // @param dsID (String | Array of String) DataSource ID or Array of DataSource IDs
    // @param callback (Function) Callback to fire after DataSource loading completes
    // @param [forceReload] (boolean | DSLoadSettings) Forcibly reload a dataSource if it's already loaded
    // @visibility external
    //<
    load : function (dsID, callback, forceReload, loadParents) {

        var mockMode;
        var fastFail;
        var requestProps;
        var sandboxContext;

        // DataSource.get() used to implicitly call loadSchema() if the requested DS is not
        // present.  This is now deprecated, and we use the standard load() method instead for
        // these internal dataSource loads.  However, DS.get() has an existing pattern of
        // accepting a context object, so we'll pull the parameter values out of that
        if (isc.isAn.Object(forceReload)) {
            mockMode = forceReload.mockMode;
            fastFail = forceReload.fastFail;
            loadParents = forceReload.loadParents;
            requestProps = forceReload.requestProps;
            sandboxContext = forceReload.sandboxContext;

            // finally reassign the obj
            forceReload = forceReload.forceReload;
        }

        // when sandboxContext is in effect, force load because only the server knows where
        // the definition will come from, so there's no way for us to know a priori whether or
        // not we have the right cached value (ultimately because the server sandboxing code
        // is what determins the ID of the resulting DS since sandboxing is encoded in the ID)
        if (sandboxContext) forceReload = true;

        var singleName,
            callbacks;

        if (!isc.isAn.Array(dsID)) {
            // If there is a single DataSource to load, we may have been called from DS.get(),
            // and it is possible that multiple framework calls to DS.get() for the same
            // DataSource will arrive while we are waiting for the server to respond.  In
            // this case, we will have a callbacks registry for the named datasource and all
            // we need to do is register our callback and wait for the server to reply.  This
            // way we suppress multiple server requests for the same dataSource.
            callbacks = isc.DataSource._getDataSourceCallbacks;
            if (callbacks[dsID]) {
                callbacks[dsID].add(callback);
                return null;
            } else {
                // this is the first request for this dataSource
                callbacks[dsID] = [];
                callbacks[dsID].add(callback);
            }
            singleName = dsID;
            dsID = [dsID];
        }

        if (dsID.length <= 0) {
            this.logWarn("No DataSource IDs passed in.");
            return;
        }

        var loadThese = [];

        for (var i=0; i<dsID.length; i++) {
            if (!this.isLoaded(dsID[i]) || forceReload) loadThese.add(dsID[i]);
        }

        var dsList = loadThese.join(","),
            url = isc.DataSource.loaderURL +
                    (isc.DataSource.loaderURL.contains("?") ? "&" : "?") +
                    (loadParents ? "loadParents=true&" : "") +
                    (fastFail == false ? "fastFail=false&" : "") +
                    (mockMode ? "mockMode=true&" : "") + "dataSource="+dsList;

        if (loadThese.length > 0) {

            var combinedRequestProps = {
                actionURL: url,
                httpMethod: "GET",
                willHandleError: true,
                clientContext : {
                    dsID : dsID
                }
            };
            if (requestProps) {
                combinedRequestProps = isc.combineObjects(
                    isc.addProperties({}, combinedRequestProps), requestProps);
            }

            if (sandboxContext) {
                // serialize sandboxContext to URL
                var requestParams = combinedRequestProps.params || {};
                combinedRequestProps.params = requestParams;
                for (var key in sandboxContext) {
                    // prefix each context value with special sbx_ to avoid conflicts
                    requestParams['sbx_'+key] = sandboxContext[key];
                }
                combinedRequestProps.clientContext.sandboxContext = sandboxContext;
            }

            // post out to the DataSourceLoader servlet
            isc.RPCManager.send(null,
                function (rpcResponse, data, rpcRequest) {
                    var dsID = rpcRequest.clientContext.dsID,
                        sandboxContext = rpcRequest.clientContext.sandboxContext,
                        failedIDs
                    ;
                    //!OBFUSCATEOK
                    if (rpcResponse.httpResponseCode == 404) {
                        isc.warn("The DataSourceLoader servlet is not available at the " +
                                 "configured DataSource.loaderURL ('" +
                                 isc.DataSource.loaderURL + "').");
                        return null;
                    }
                    if (loadParents && !forceReload) isc.DataSource._doNotClobber = true;
                    try {
                        // eval returned create() statement(s) and fire the callback if passed
                        if (sandboxContext) {
                            isc.DataSource._dsGlobalsRename = {};
                            for (var i = 0; i < dsID.length; i++) {
                                var ID = dsID[i],
                                    newID = isc.DS._getSandboxedID(ID, sandboxContext);
                                isc.DataSource._dsGlobalsRename[ID] = newID;

                                // replace for callback
                                dsID[i] = newID;
                            }
                        }
                        var lastExp = isc.Class.evaluate(data);

                        // if list is present, it's the failed DS IDs
                        if (isc.isA.List(lastExp)) {
                            failedIDs = lastExp;
                            this.logWarn("loadDS(): failed to load DataSources: " + failedIDs);
                        }

                    } catch(e) {
                        isc.logWarn("Response from DataSourceLoader caused exception " +
                                isc.echoAll(e) +
                                ", response was:\n" +
                                data);
                    }
                    delete isc.DataSource._dsGlobalsRename;
                    delete isc.DataSource._doNotClobber;
                    if (singleName) {
                        for (var i = 0; i < callbacks[singleName].length; i++) {
                            var cb = callbacks[singleName][i];
                            if (cb) this.fireCallback(cb, ["dsID"], [dsID]);
                        }
                        delete callbacks[singleName];
                    } else {
                        if (callback) this.fireCallback(callback, ["dsID", "failedIDs"],
                                                        [dsID, failedIDs]);
                    }
                },
                combinedRequestProps
            );
        } else {
            this.logWarn("DataSource(s) already loaded: " + dsID.join(",") +
                "\nUse forceReload to reload such DataSources");
            if (callback) this.fireCallback(callback, ["dsID"], [dsID]);


            if (singleName) delete callbacks[singleName];
        }
    },


    _getSandboxedID : function (id, sandboxContext) {
        var newID = id;
        for (var key in sandboxContext) {
            newID += "_sbx_" + key + "_" + sandboxContext[key];
        }
        return newID;
    },

    //> @classMethod dataSource.loadWithParents()
    // Variation of +link{DataSource.load()} that will also automatically load any DataSources that
    // the requested DataSources inherit from (via +link{DataSource.inheritsFrom}).
    // <P>
    // If the parent DataSource is already loaded, calling <code>loadWithParents</code> will not
    // automatically reload them unless the forceReload parameter is passed.
    //
    // @param dsID (String | Array of String) DataSource ID or Array of DataSource IDs
    // @param callback (Function) Callback to fire after DataSource loading completes
    // @param [forceReload] (boolean | DSLoadSettings) Forcibly reload a dataSource if it's already loaded
    //
    // @visibility external
    //<
    loadWithParents : function (dsID, callback, forceReload) {
        if (isc.isAn.Object(forceReload)) {
            forceReload.loadParents = true;
        }
        this.load(dsID, callback, forceReload, true);
    },

    //> @classMethod DataSource.getSortBy()
    // Given an array of +link{SortSpecifier}s, return a simple list of Strings in the format
    // expected by +link{dsRequest.sortBy}.
    //
    // @param sortSpecifiers (Array of SortSpecifier) The list of specifiers to return in
    // sortBy format
    // @return (Array of String) An array of sort-definitions in the format expected by
    // +link{dsRequest.sortBy}
    // @visibility external
    //<
    getSortBy : function (sortSpecifiers) {
        if (!isc.isA.Array(sortSpecifiers)) sortSpecifiers = [sortSpecifiers];

        var sortArray = [];
        for (var i=0; i<sortSpecifiers.length; i++) {
            var item=sortSpecifiers.get(i),
                property = isc.SortSpecifierUtil._getSortByProperty(item);
            if (!isc.isA.nonemptyString(property)) continue;
            sortArray.add((!Array.shouldSortAscending(item.direction) ? "-" : "") + property);
        }
        return sortArray;
    },

    //> @classMethod DataSource.getSortSpecifiers()
    // Return an array of +link{SortSpecifier}s, given an array of Strings in the format
    // expected by +link{dsRequest.sortBy}.
    //
    // @param sortBy (Array of String) A list of sortBy strings in the format expected by +link{dsRequest.sortBy}
    // @param [context] (DataSource | DataBoundComponent) Context dataSource or component.
    // @return (Array of SortSpecifier) An array of +link{SortSpecifier}s equivalent to the passed in string array
    // @visibility external
    //<
    getSortSpecifiers : function (sortBy, context) {
        if (!isc.isA.Array(sortBy)) sortBy = [sortBy];

        var specifierArray = [];
        for (var i=0; i<sortBy.length; i++) {
            var sortByString = sortBy[i];
            specifierArray.add(isc.SortSpecifierUtil.getSortSpecifier(sortByString, context));
        }
        return specifierArray;
    },

    //> @classMethod DataSource.isAdvancedCriteria()
    // Determines whether the passed criteria object is AdvancedCriteria or simple criteria.
    // <P>
    // Criteria with an explicit <code>_constructor: "AdvancedCriteria"</code> property are
    // always recognized as AdvancedCriteria. For criteria without this marker, heuristics are
    // used to detect AdvancedCriteria based on properties like <code>fieldName</code>,
    // <code>operator</code>, and <code>value</code>.
    // <P>
    // When a <code>dataSource</code> is provided, additional validation is performed - a
    // criterion with just a <code>fieldName</code> (no operator or value) is treated as
    // AdvancedCriteria shorthand if that fieldName is a valid field on the DataSource.
    // This supports the ruleScope shorthand format where <code>{fieldName: "someField"}</code>
    // means "someField equals true".
    // <P>
    // Without a DataSource, a criteria object must have a valid <code>operator</code> to be
    // detected as AdvancedCriteria (unless explicitly marked with <code>_constructor</code>).
    // This ensures that simple property-matching objects like <code>{fieldName: "X"}</code>
    // used in +link{Array.find()} are not incorrectly treated as AdvancedCriteria.
    //
    // @param criteria (Criteria) the criteria object to examine
    // @param [dataSource] (DataSource | String) optional DataSource (or DataSource ID) for
    //                     additional field validation
    // @return (Boolean) true if the criteria is AdvancedCriteria, false otherwise
    // @see method:DataSource.isAdvancedCriteria()
    // @visibility external
    //<

    isAdvancedCriteria : function (criteria, dataSource) {
        if (!criteria || isc.isAn.emptyObject(criteria)) return false;

        if (dataSource && !isc.isA.DataSource(dataSource)) dataSource = this.get(dataSource);

        if (criteria._constructor == "AdvancedCriteria") return true;

        // Not explicitly marked, so we'll make a guess.
        var returnVal = false,
            searchOp = this.getSearchOperator(criteria.operator, dataSource);

        // check if criteria.criteria is present and passed criteria is not a class instance
        // to exclude classes like ResultSet being treated as advanced criteria
        if (criteria.criteria && !isc.isA.Instance(criteria)) {
            var nestedFieldName;
            // check if criteria.criteria is:
            // - array of objects first object with fieldName
            // - single object with fieldName
            if (isc.isA.Array(criteria.criteria) && criteria.criteria[0]) {
                nestedFieldName = criteria.criteria[0].fieldName;
            } else if (isc.isA.Object(criteria.criteria)) {
                nestedFieldName = criteria.criteria.fieldName;
            }
            if (nestedFieldName && nestedFieldName != "") returnVal = true;
        }

        // if it was set to TRUE by the criteria.criteria check above, skip all other checks
        if (returnVal) {}


        else if (dataSource && dataSource.getField(criteria.fieldName) && searchOp) {
            returnVal = true;
        }

        // Before applying further heuristics, make sure that this DataSource
        // doesn't have any fields that are actually called "fieldName" or "operator"
        else if (dataSource && (dataSource.getField("fieldName") || dataSource.getField("operator"))) returnVal = false;

        // If criteria has fieldName and a valid operator, check whether it's AdvancedCriteria.
        // For operators with valueType "none" (like isNull, isBlank), no value is required.
        // For other operators, require criteria.value to be defined (not undefined).
        // Note: explicit null is allowed as a value (e.g., searching for null values).
        else if ((criteria.fieldName || criteria.fieldQuery) && (criteria.operator && searchOp)) {
            // Operators with valueType "none" don't require a value
            if (searchOp.valueType == "none") {
                returnVal = true;
            } else {
                // For operators that expect a value, require value to be defined (not undefined)
                var undef;
                if (criteria.value !== undef) {
                    returnVal = true;
                }
            }
        }

        // Treat fieldName-only (no operator, no value) as AdvancedCriteria shorthand ONLY when
        // a DataSource is provided AND the fieldName is a valid field on that DataSource.
        // This supports ruleScope shorthand like {fieldName: "Grid.anySelected"} when used with
        // a DataSource that has "Grid.anySelected" as a field. Without a DataSource, fieldName
        // alone is NOT treated as AdvancedCriteria, allowing Array.find({fieldName: "X"}) to
        // work as simple property matching.
        else if (dataSource && dataSource.getField(criteria.fieldName) &&
                 !criteria.operator && criteria.value == null) {
            returnVal = true;
        } else {
            // We'll also assume it's an AdvancedCriteria if there is no fieldName property and
            // the operator is either "and" or "or".
            var undef;
            if (criteria.operator != undef) {
                var op = searchOp;
                if (op != null && (op.isAnd || op.isOr)) {
                    returnVal = true;
                }
            }
        }

        if (this.logIsInfoEnabled()) {
            this.logInfo("Criteria object:" + this.echo(criteria) + " not explicitly marked as AdvancedCriteria" +
                (returnVal ? " but treating as Advanced based on format." : " - treating as SimpleCriteria."), "AdvancedCriteria");
        }

        return returnVal;
    },

    // class-level version of normalizeAdvancedCriteria - accepts a DS as a param, passed in by calls
    // from the instance-level method
    normalizeAdvancedCriteria : function (criteria, force, subCrit, dataSource) {
        if (!criteria) return;

        // already normalized and not forcing, return unchanged
        if (criteria.__normalized && !force) {
            return criteria;
        }

        var norm = {
            __normalized: true
        };
        if ((criteria.__normalized && criteria._constructor == "AdvancedCriteria") || !subCrit) {
            norm._constructor = "AdvancedCriteria";
            if (criteria.strictSQLFiltering) norm.strictSQLFiltering = true;
        }

        if (criteria.criteria) {
            // don't break on a single element rather than an array in the criteria slot
            if (!isc.isAn.Array(criteria.criteria)) {
                criteria.criteria = [criteria.criteria];
            }
            norm.operator = criteria.operator;
            norm.criteria = [];
            for (var i = 0; i < criteria.criteria.length; i++) {
                norm.criteria.add(isc.DS.normalizeAdvancedCriteria(criteria.criteria[i], force, true, dataSource));
            }
        } else {
            if (!isc.isAn.Array(criteria.value)) {
                isc.addProperties(norm, criteria);
            } else {
                var operator = this.getSearchOperator(criteria.operator, dataSource);

                if (!operator || !operator.canNormalize) {
                    isc.addProperties(norm, criteria);
                } else if (criteria.value.length == 1) {
                    // don't wrap a single-element array value with an outer criteria
                    criteria.value = criteria.value[0];
                    isc.addProperties(norm, criteria);
                } else {
                    norm.operator = operator.negate ? "and" : "or";
                    norm.criteria = [];
                    for (var i = 0; i < criteria.value.length; i++) {
                        norm.criteria.add({
                            __normalized: true,
                            fieldName: criteria.fieldName,
                            operator: criteria.operator,
                            value: criteria.value[i]
                        });
                    }
                }
            }
        }

        var undef;
        // For a criterion with fieldName but no operator, default the operator to "equals".
        if (!norm.operator && norm.fieldName) {
            norm.operator = "equals";
            // if value is also missing, default it to true
            if (norm.value == undef) norm.value = true;
        }

        // For a criterion with criteria but no operator, default the operator to "and".
        if (!norm.operator && norm.criteria) norm.operator = "and";

        return norm;
    },

    //> @classMethod DataSource.copyCriteria
    // Create a copy of a criteria.
    //
    // @param criteria (Criteria) criteria to copy
    // @return (Criteria) copy of criteria
    // @visibility external
    //<
    copyCriteria : function (criteria) {
        if (criteria == null) return null;
        return isc.clone(criteria);
    },

    getCriteriaFields : function (criteria, dataSource, isSubcriterion) {
        if (dataSource && !isc.isA.DataSource(dataSource)) dataSource = this.get(dataSource);
        if (isSubcriterion ||
            (dataSource ? dataSource.isAdvancedCriteria(criteria) :
                this.isAdvancedCriteria(criteria))
           )
        {
            var fieldNames = [];
            this._getAdvancedCriteriaFields(criteria, fieldNames);
            return fieldNames;
        }
        return isc.getKeys(criteria);
    },

    // Drill into advancedCriteria object extracting fields
    _getAdvancedCriteriaFields : function (criterion, fieldNames) {
        if (criterion.criteria) {
            for (var i = 0; i < criterion.criteria.length; i++) {
                isc.DS._getAdvancedCriteriaFields(criterion.criteria[i], fieldNames);
            }
        } else {
            fieldNames.add(criterion.fieldName);
        }
    },

    // Drill into advancedCriteria object extracting operators
    _getAdvancedCriteriaOperators : function (criterion, operators) {
        if (criterion.criteria) {
            for (var i = 0; i < criterion.criteria.length; i++) {
                isc.DS._getAdvancedCriteriaOperators(criterion.criteria[i], operators);
            }
        } else {
            operators.add(criterion.operator);
        }
    },

    collectTopLevelAsyncCriteria : function (criterion, dataSource, __asyncCriteria) {
        if (__asyncCriteria == null) __asyncCriteria = [];
        if (this.isAdvancedCriteria(criterion, dataSource)) {
            if (criterion.operator == "and") {
                // Require `criteria` to be an array because booleanOperator() (the Operator.condition()
                // implementation for the "and" operator) treats the case where `criteria` is not an array
                // as an error.
                if (isc.isAn.Array(criterion.criteria)) {
                    for (var i = 0; i < criterion.criteria.length; ++i) {
                        this.collectTopLevelAsyncCriteria(criterion.criteria[i], dataSource, __asyncCriteria);
                    }
                }
            } else {
                var op = this.getSearchOperator(criterion.operator, dataSource);
                if (op != null && op.asyncFilter != null) __asyncCriteria.add(criterion);
            }
        }
        return __asyncCriteria;
    },

    applyAsyncCriteria : function (asyncCriteria, records, recordsWereUpdated, strictSQLFiltering, givenCC, dataSource) {
        // In case the Promise rejected because an error was thrown, we will handle that by
        // translating the error into a type:"error" AsyncFilterResult.
        var defaultCatchCallback = isc.defaultAsyncOperationCatchCallback;

        var promises = [];
        for (var i = 0; i < asyncCriteria.length; /*empty*/) {
            var asyncCriterion = asyncCriteria[i],
                asyncFilterContext = {
                    cancellationController: givenCC,
                    dataSource: dataSource,
                    strictSQLFiltering: strictSQLFiltering,
                    recordsWereUpdated: recordsWereUpdated
                },
                op = this.getSearchOperator(asyncCriterion.operator, dataSource),
                promise = op.asyncFilter(asyncCriterion, records, asyncFilterContext);
            if (promise == null) {
                asyncCriteria.removeAt(i);
                continue;
            }
            promises[i++] = promise._catch(defaultCatchCallback);
        }

        if (promises.length == 0) return null;

        return Promise.all(promises)
            .then(function normalizeResults(results) {
                for (var i = 0; i < results.length; ++i) {
                    var result = results[i];
                    // set the type to "success" if the type is not set
                    if (result.type == null) result.type = "success";
                    // set the `criterion` property
                    if (result.criterion != null && result.criterion !== asyncCriteria[i]) {
                        isc.logWarn("found an AsyncFilterResult with the incorrect `criterion` property");
                    }
                    result.criterion = asyncCriteria[i];
                }
                return results;
            });
    },

    getCriterionDependencies : function (criterion, dataSource) {
        if (!this.isAdvancedCriteria(criterion, dataSource)) {
            return isc.getKeys(criterion);
        }

        var op = this.getSearchOperator(criterion.operator, dataSource);

        var dependencies = op && op.getDependencies && op.getDependencies(criterion);
        if (!dependencies) {
            var fieldName = op.fieldName;
            switch (op.valueType) {
                case "fieldType":
                case "none":
                case "valueRange":
                case "valueSet":
                    if (isc.isA.nonemptyString(fieldName)) {
                        dependencies = [fieldName];
                    }
                    break;

                case "fieldName":
                    if (isc.isA.nonemptyString(fieldName)) {
                        if (isc.isA.nonemptyString(op.value)) {
                            dependencies = [fieldName, op.value];
                        } else {
                            dependencies = [fieldName];
                        }
                    }
                    break;

                case "criteria":
                    var criteria = op.criteria;
                    if (!criteria) dependencies = [];
                    // booleanOperator() (the Operator.condition() implementation for the "and"
                    // operator) treats the case where `criteria` is not an array as an error.
                    else if (!isc.isAn.Array(criteria)) dependencies = null;
                    else if (criteria.length == 1) dependencies = this.getCriterionDependencies(criteria[0], dataSource);
                    else {
                        dependencies = [];
                        for (var c = 0; c < criteria.length; ++c) {
                            var subdependencies = this.getCriterionDependencies(criteria[c], dataSource);
                            if (!subdependencies) {
                                dependencies = null;
                                break;
                            }
                            dependencies.addList(subdependencies);
                        }
                    }
                    break;
            }
        }

        return dependencies;
    },


    // ---------- LOCAL RESPONSE CACHING ----------
    _responseCache: [],
    maxResponsesToCache: 100,
    cacheResponse : function (dsRequest, dsResponse) {
        if (isc.Offline) {
            var requestKey = isc.Offline.serialize(isc.Offline.trimRequest(dsRequest));
            var index = this._responseCache.findIndex("requestKey", requestKey);
            if (index != -1) {
                this._responseCache.set(index, dsResponse);
            } else {
                if (this._responseCache.length >= this.maxResponsesToCache) {
                    this._responseCache.removeAt(0);
                }
                this._responseCache.add({
                    requestKey: requestKey,
                    dsResponse: dsResponse
                });
            }
        }
    },

    getCachedResponse : function (dsRequest) {
        if (isc.Offline) {
            var requestKey = isc.Offline.serialize(isc.Offline.trimRequest(dsRequest));
            return this._responseCache.find("requestKey", requestKey);
        }
        return null;
    },


    //> @classAttr DataSource.offlineMessage  (String : "This data not available while offline" : IRW)
    // A message returned by a DataSource when it is returning an empty dataset for a fetch
    // because the browser is currently offline and there is no suitable cached offline response.
    // @group i18nMessages, offlineGroup
    // @visibility external
    //<
    offlineMessage: "This data not available while offline",

    //> @classAttr DataSource.maxFileSizeExceededMessage  (HTMLString : "Size of '${uploadedFileName}' (${uploadedFileSize}) exceeded maximum allowed file size of ${maxFileSize}" : IRW)
    // A message returned by a <code>DataSource</code> when an uploaded file's size exceeded
    // +link{DataSourceField.maxFileSize}.
    // <p>
    // If this is not set, then +link{Validator.maxFileSizeExceeded} value will be used.
    // @group i18nMessages
    // @visibility external
    //<
    maxFileSizeExceededMessage: "Size of '${uploadedFileName}' (${uploadedFileSize}) exceeded maximum allowed file size of ${maxFileSize}",

    //> @classAttr DataSource.requiredFileMessage (HTMLString : "'${uploadedFileName}' was empty, but empty files are not allowed." : IRW)
    // A message returned by a <code>DataSource</code> when an uploaded file was empty, but the
    // field is +link{DataSourceField.required,required}.
    // @group i18nMessages
    // @visibility external
    //<
    requiredFileMessage: "'${uploadedFileName}' was empty, but empty files are not allowed.",

    //> @classAttr DataSource.requiredCriterionMessage (HTMLString : "Operation requires criteria for the following field(s): [${requiredCriterion}]" : IRW)
    // A message returned by a <code>DataSource</code> when an operation requires criteria, but none was provided.
    // @group i18nMessages
    // @visibility external
    //<
    requiredCriterionMessage: "Operation requires criteria for the following field(s): [${requiredCriterion}]",


    getPathValue : function (record, fieldPath, field, reason) {
        //var field;
        //if (isc.isAn.Object(fieldPath)) {
        //    field = fieldPath;
        //    fieldPath = null;
        //}
        return isc.Canvas._getFieldValue(fieldPath, field, record, null, true, reason);
    },

    // setPathValue - corollary for getPathValue()
    setPathValue : function (record, fieldPath, field, value) {
        //var field;
        //if (isc.isAn.Object(field)) {
        //    field = fieldPath;
        //    fieldPath = null;
        //}
        isc.Canvas._saveFieldValue(fieldPath, field, value, record, null, true);
    },

    // format the path value using the associated dataSource field definition
    _formatPathValue : function (record, fieldPath, ruleScopeComponent) {
        var value = this.getPathValue(record, fieldPath);

        var details = ruleScopeComponent.getRuleContextPathDetails(fieldPath);
        if (details && details.field && isc.isA.DataSource(details.dataSource)) {
            return details.dataSource.formatFieldValue(details.field, value);
        }
        return value;
    },

    // Given an array of dataSources, return field identifiers for all fields in the dataSources
    // These will be of the form "dataSourceID.fieldName"
    getCombinedDataSourceFields : function (dataSources) {
        var fields = [];
        for (var i = 0; i < dataSources.length; i++) {
            var dataSource = dataSources[i];
            if (isc.isA.String(dataSource)) dataSource = isc.DataSource.get(dataSource);
            if (dataSource == null) {
                this.logWarn("getCombinedDataSourceFields() - unable to locate dataSource:"
                    + dataSources[i]);
                continue;
            }

            var dsID = (dataSource._useTagName ? dataSource.tagName : null) || dataSource.getID(),
                dsFields = isc.getKeys(dataSource.getFields());
            for (var j = 0; j < dsFields.length; j++) {
                fields[fields.length] = dsID + "." + dsFields[j];
            }
        }
        return fields;
    },

    // Given a ds field identifier like "dataSourceId.fieldName", extract the field definition
    // from the appropriate dataSource.
    // The dataSources array is optional - if present, pull from that set of dataSources
    // rather than doing a standard isc.DS.get()


    getFieldFromDataSources : function (combinedFieldId, dataSources, suppressWarning) {
        var dataSource = this.getDataSourceForField(combinedFieldId, dataSources, suppressWarning);
        if (dataSource == null) {
            if (!suppressWarning) {
                this.logWarn("getFieldFromDataSources() - unable to find dataSource " +
                    " from combined field ID " + combinedFieldId);
            }
            return null;
        }

        var splitFieldId = combinedFieldId.split("."),
            dsId = splitFieldId[0],
            dsFieldName = splitFieldId[splitFieldId.length-1];
        var field = dataSource.getField(dsFieldName);
        // If field was not found, check for a meta field of that name
        if (!field) field = dataSource.getField(isc.Canvas._makeRuleScopeMetaFieldName(dsFieldName));
        return field;
    },

    getDataSourceForField : function (combinedFieldId, dataSources, suppressWarning) {

        var splitFieldId = combinedFieldId.split("."),
            dsId = splitFieldId[0],
            dsFieldName = splitFieldId[splitFieldId.length-1];
        if (dsId == null || dsFieldName == null) {
            if (!suppressWarning) {
                this.logWarn("getDataSourceForField() passed invalid field ID:" + combinedFieldId +
                    ". Expected format is to use dot-notation to indicate the dataSource plus " +
                    "fieldName - for example 'countryDS.countryCode'");
            }
            return null;
        }
        var dataSource;
        if (dataSources == null) dataSource = isc.DataSource.get(dsId);
        else {
            // sanity check only
            if (!isc.isAn.Array(dataSources)) dataSources = [dataSources];
            for (var i = 0; i < dataSources.length; i++) {
                var ds = dataSources[i];
                if (ds && ds.getID() == dsId ||

                        (ds && ds._useTagName && ds.tagName == dsId) ||
                        (ds && ds.criteriaBasePath && combinedFieldId.startsWith(ds.criteriaBasePath)))
                {
                    dataSource = ds;
                    break;
                }
                var fieldSplit = combinedFieldId.split(".");
                if (ds && ds.criteriaBasePath) {
                    var fieldName = isc.Canvas._makeRuleScopeMetaFieldName(fieldSplit[fieldSplit.length-1]);
                    var field = ds.getField(fieldName);
                    if (field) {
                        if (field.criteriaPath && field.criteriaPath == combinedFieldId) {
                            dataSource = ds;
                            break;
                        }
                    }
                }
            }
        }
        return dataSource;
    },

    _getDefaultValueForFieldType : function (fieldType) {
        var value;
        switch (fieldType) {
            case "date":
            case "datetime":
            case "time":
                value = new Date(0);
                break;
            case "float":
                value = 0.0;
                break;
            case "integer":
                value = 0;
                break;
            case "boolean":
                value = false;
                break;
            case "text":
            default:
                value = "";
                break;
        }
        return value;
    },

    _getTypedValueAsString : function (value, fieldType, settings) {
        if (settings == null) settings = {};

        if (value == null) {
            var defaultText = settings.nullValueText;
            if (defaultText != null) return defaultText;
            // if textExportSettings.nullValueText is null, then
            // set value to the default value for the field's type
            value = this._getDefaultValueForFieldType(fieldType);
        }
        switch (fieldType) {
            case "date":
                var format = settings.dateFormat;
                return value.toShortDate(format);
            case "datetime":
                var format = settings.dateTimeFormat;
                return value.toShortDateTime(format);
            case "time":
                var format = settings.timeFormat;
                return isc.Time.toShortTime(value, format);
            case "float":
            case "integer":
            case "boolean":
            default:
                return value.toString();
            case "text":
                return value;
        }
    },

    //> @classMethod DataSource.isFlatCriteria(AdvancedCriteria)
    // Returns true if a given AdvancedCriteria is "flat." That is, the criteria consists of either:
    // <ul>
    // <li> a top-level "and" or "or" +link{Criterion}, where none of the
    //      +link{Criterion.criteria,subcriteria} use +link{LogicalOperator,logical operators},
    //      hence have no subcriteria of their own
    // <li> a single Criterion that is not a logical operator, hence has no subcriteria
    // </ul>
    //
    // @param criteria (AdvancedCriteria) the AdvancedCriteria to check for flatness
    // @return (boolean) true if criteria is flat
    // @visibility external
    //<
    isFlatCriteria : function (criteria) {
        if (!criteria) return false;

        var op = isc.DS._operators[criteria.operator];

        // Is criteria a single Criterion?
        if (isc.isA.emptyObject(criteria) || (criteria.fieldName && op && op.valueType != "criteria"))
        {
            return true;
        }

        // Does criteria have a top-level logical operator but no other
        // logical operators in sub-criteria?
        if (op && op.valueType == "criteria" && criteria.criteria) {
            var subCriteria = criteria.criteria;
            for (var i = 0; i < subCriteria.length; i++) {
                var criterion = subCriteria[i],
                    subOp = criterion.operator ? isc.DS._operators[criterion.operator] : null,
                    logical = subOp && subOp.valueType == "criteria"
                ;
                if (logical) {
                    return false;
                }
            }
            return true;
        }
        return false;
    },

    //> @classMethod DataSource.flattenCriteria(AdvancedCriteria)
    // Returns new criteria that has at most one top-level LogicalOperator ("and" or "or").
    // This new criteria will be considered "flat" by +link{isFlatCriteria}.
    // <p>
    // Not all AdvancedCriteria can be flattened and remain logically equivalent.  When
    // criteria will be logically modified by flattening, all criteria that appear anywhere in
    // the AdvancedCriteria structure will appear under a single top-level operator, which
    // will be the same top-level operator as the passed AdvancedCriteria.
    // <p>
    // For example, given criteria like this (in the JSON representation of AdvancedCriteria):
    // <pre>
    //      { operator: "and", criteria: [
    //         { fieldName: "continent", operator: "equals", value: "Europe"},
    //         { operator: "or", criteria: [
    //            { fieldName: "countryName", operator: "iEndsWith", value: "land"},
    //            { fieldName: "population", operator: "lessThan", value: 3000000}
    //         ]}
    //        ]
    //      }
    // </pre>
    // The returned criteria would be:
    // <pre>
    //      { operator: "and", criteria: [
    //         { fieldName: "continent", operator: "equals", value: "Europe"},
    //         { fieldName: "countryName", operator: "iEndsWith", value: "land"},
    //         { fieldName: "population", operator: "lessThan", value: 3000000}
    //       ]}
    // </pre>
    // This returned criteria is not logically equivalent to the passed criteria - the
    // "iEndsWith" and "lessThan" criteria that were formerly nested under a logical "or"
    // operator must now <i>both</i> be satisfied instead of <i>either</i> being satisfied.
    // You can use +link{canFlattenCriteria()} to detect whether an AdvancedCriteria is going
    // to be changed by <code>flattenCriteria()</code>.
    // <p>
    // Because the returned criteria may not be logically equivalent,
    // <code>flattenCriteria</code> should not be used as a means of simplifying criteria to
    // make server implementation easier or anything of the kind.  The primary purpose of
    // returning logically different criteria is to enable an end user to switch from an
    // interface for editing nested criteria to an interface that can't handle nested
    // criteria and convert the criteria while preserving as much as possible.
    //
    // @param criteria (AdvancedCriteria) the AdvancedCriteria to flatten
    // @return (AdvancedCriteria) flattened criteria
    // @visibility external
    //<
    flattenCriteria : function (criteria) {
        if (!criteria) return null;

        // Start with top-level criteria
        var flatCriteria = isc.addProperties({}, criteria);

        // Add all sub-criteria as a single criteria list
        if (flatCriteria.criteria) {
            flatCriteria.criteria = [];
            this._addSubCriteriaToList(flatCriteria.criteria, criteria);
        }

        return flatCriteria;
    },
    _addSubCriteriaToList : function (list, criteria) {
        if (!criteria.criteria) {
            list.add(isc.addProperties({}, criteria));
            return;
        }
        var subCriteria = criteria.criteria;
        for (var i = 0; i < subCriteria.length; i++) {
            var criterion = subCriteria[i];
            this._addSubCriteriaToList(list, criterion);
        }
    },

    //> @classMethod DataSource.canFlattenCriteria(AdvancedCriteria)
    // Returns true if calling +link{flattenCriteria()} on the passed criteria would produce
    // logically equivalent criteria.
    //
    // @param criteria (AdvancedCriteria) the AdvancedCriteria to check for flatness
    // @return (boolean) true if criteria can be flattened without logical change
    // @visibility external
    //<
    canFlattenCriteria : function (criteria) {
        if (!criteria) return false;

        // If criteria is already flat, it can be flattened.
        if (isc.DataSource.isFlatCriteria(criteria)) return true;

        // If top-level operator and all sub-criteria operators
        // are the same, the criteria can be flattened.
        var topLevelOperator = criteria.operator;
        if (this._criteriaHasSameLogicalOperators(criteria, topLevelOperator)) return true;

        return false;
    },
    _criteriaHasSameLogicalOperators : function (criteria, operator) {
        if (!criteria.criteria || criteria.criteria.isEmpty()) return true;

        if (criteria.operator != operator) {
            // if there's only one subCriteria, and it's not advanced (has no criteria
            // array of its own), it can still be flattened, whatever the operator (unless
            // the operator is "not") - otherwise, return false here
            if (criteria.criteria.length != 1 || criteria.criteria[0].criteria || criteria.operator == "not") return false;
        }

        var subCriteria = criteria.criteria;
        for (var i = 0; i < subCriteria.length; i++) {
            var criterion = subCriteria[i];
            if (!this._criteriaHasSameLogicalOperators(criterion, operator)) return false;
        }

        return true;
    },

    //> @object CriteriaOutputSettings
    // Settings for generation of AdvancedCriteria descriptions.
    // @treeLocation Client Reference/Data Binding/DataSource
    // @visibility external
    //<

    //> @attr criteriaOutputSettings.prefix (String : null : IR)
    // Prefix to be prepended to each criterion description.
    // @visibility external
    //<

    //> @attr criteriaOutputSettings.suffix (String : null : IR)
    // Suffix to be appended to each criterion description.
    // @visibility external
    //<

    //> @attr criteriaOutputSettings.escapeHTML (Boolean : null : IR)
    // By default HTML characters such as <code>"&lt;br&gt;"</code> will be written
    // into the output description to format the result. Setting
    // <code>escapeHTML</code> true will instead force HTML values in the output to be
    // displayed to the user instead.
    // @visibility external
    //<

    //> @attr criteriaOutputSettings.textMatchStyle (String : null : IR)
    // +link{TextMatchStyle} to use if converting from a simple criteria. This property,
    // if specified, is passed to +link{DataSource.convertCriteria,convertCriteria} to
    // override the default.
    // @visibility external
    //<

    //> @classMethod DataSource.getAdvancedCriteriaDescription()
    // Returns a human-readable string describing the clauses in this advanced criteria or criterion.
    //
    // @param criteria (AdvancedCriteria | Criterion) Criteria to convert to a readable string
    // @param dataSource (DataSource) DataSource to provide definitions of operators
    // @param [criteriaOutputSettings] (CriteriaOutputSettings) optional configuration settings for the output
    // @return (String) Human-readable string describing the clauses in the passed criteria
    // @visibility external
    //<
    getAdvancedCriteriaDescription : function (criteria, dataSource, criteriaOutputSettings, localComponent) {

        // if there's no criteria to describe, just bail and return empty string
        if (!criteria) return "";

        if (!criteriaOutputSettings) {
            criteriaOutputSettings = {};
        }

        var prefix = criteriaOutputSettings.prefix || '' ,
            suffix = criteriaOutputSettings.suffix || '';

        // support being passed an array of dataSources, and using dot-notation on the fieldNames
        // to extract field info
        if (!isc.isAn.Array(dataSource)) {
            if (!isc.isA.DataSource(dataSource)) dataSource = isc.DS.getDataSource(dataSource);
            if (!dataSource) return isc.Operators.noDataSourceDescription;
        }

        var result = "",
            desc;

        if (criteria.criteria && isc.isAn.Array(criteria.criteria)) {
            // complex criteria, call this method again with that criteria
            var opId = criteria.operator,
                FB = isc.FilterBuilder.getPrototype(),

                opTitle = FB["inline" +
                    opId.substring(0,1).toUpperCase() +
                    opId.substring(1,opId.length) + "Title"],
                subCriteria = criteria.criteria
            ;

            for (var i = 0; i<subCriteria.length; i++) {
                var subItem = subCriteria[i];

                result += prefix;

                if (i > 0) result += " " + opTitle + " ";
                desc = isc.DataSource.getCriterionDescription(subItem, dataSource,
                    localComponent, true);
                if (criteriaOutputSettings.escapeHTML) desc = desc.asHTML();
                result += desc;
                result += suffix;
            }
        } else if (criteria.fixedValue != null) {
            result += (criteria.fixedValue ? "Always" : "Never");
        } else {
            // simple criterion or regular criteria
            if (isc.isA.DataSource(dataSource)) {
                if (!dataSource.isAdvancedCriteria(criteria)) {
                    criteria = isc.DS.convertCriteria(criteria, criteriaOutputSettings.textMatchStyle, dataSource);
                }
            } else {
                if (!isc.DS.isAdvancedCriteria(criteria)) {
                    criteria = isc.DS.convertCriteria(criteria, criteriaOutputSettings.textMatchStyle);
                }
            }
            desc = isc.DataSource.getCriterionDescription(criteria, dataSource, localComponent);
            if (criteriaOutputSettings.escapeHTML) desc = desc.asHTML();
            result += prefix + desc + suffix;
        }

        return result;
    },

    //>ISC_140
    //> @classMethod DataSource.getAggregationDescription()
    // Returns a human-readable string describing the aggregation properties in the request:
    // +link{dsRequest.groupBy} and +link{dsRequest.summaryFunctions}.
    //
    // @param subquery (AdvancedCriterionSubquery) Subquery with aggregation to convert to a readable string
    // @param dataSource (DataSource) DataSource to provide field properties
    // @return (String) Human-readable string describing the aggregation in the passed request
    // @visibility external
    //<
    //<ISC_140
    getAggregationDescription : function (subquery, dataSource) {
        var requestDataSource = isc.DS.getDataSource(subquery.dataSource);
        dataSource = subquery.dataSource || dataSource;
        if (!isc.isA.DataSource(dataSource)) dataSource = isc.DS.getDataSource(dataSource);
        if (!dataSource) return isc.Operators.noDataSourceDescription;

        var getFieldTitle = function (fieldName) {
            var field = dataSource.getField(fieldName);
            return field && (field.title ? field.title : fieldName);
        };

        var result = "";

        if (subquery.groupBy) {
            var groupBy = (isc.isAn.Array(subquery.groupBy) ? subquery.groupBy : [subquery.groupBy]),
                fields = ""
            ;
            for (var i = 0; i < groupBy.length; i++) {
                if (fields.length > 0) {
                    fields += (i < groupBy.length-1 ? ", " : " and ");
                }
                fields += getFieldTitle(groupBy[i]);
            }
            result += "Combine " + (requestDataSource ? requestDataSource.ID + " " : "") + "records that have the same value for " + fields;
        }
        if (subquery.summaryFunctions) {
            var prefix = (subquery.groupBy ? "<br>" : ""),
                summaryFunctions = subquery.summaryFunctions,
                aggregations = "",
                first = true;
            for (var key in subquery.summaryFunctions) {
                var summaryFunction = summaryFunctions[key],
                    func = (isc.SummaryFunctionItem ?
                            isc.SummaryFunctionItem.getFunctionTitle(summaryFunction) :
                            summaryFunction);
                aggregations +=
                    (first ? prefix + (subquery.groupBy ? "Then calculate " : "Calculate ") : "<br>and ") +
                    "the value for " + getFieldTitle(key) +
                    (first && !subquery.groupBy && requestDataSource ? " from " + requestDataSource.ID : "") +
                    " as the " + func;
                first = false;
            }
            result += aggregations;
        }
        if (result == "" && !isc.isAn.emptyObject(subquery)) {
            var queryOutput = this._getQueryOutput(subquery, dataSource);
            if (queryOutput) {
                result = "Return " + getFieldTitle(queryOutput) + " from " + dataSource.getTitle();
            }
        }
        if (subquery.criteria) {
            result += " where " + isc.DS.getAdvancedCriteriaDescription(subquery.criteria, dataSource);
        }
        return result;
    },

    _getQueryOutput : function (subquery, dataSource) {
        dataSource = subquery.dataSource || dataSource;
        if (!isc.isA.DataSource(dataSource)) dataSource = isc.DS.getDataSource(dataSource);

        var value;
        if (subquery) {
            if (subquery.queryOutput) {
                value = subquery.queryOutput;
            } else if (subquery.summaryFunctions) {
                var summaryFunctions = subquery.summaryFunctions;
                if (summaryFunctions) {
                    for (var summaryFunction in summaryFunctions) {
                        value = summaryFunction;
                        break;
                    }
                }
            } else if (subquery.groupBy) {
                var groupBy = subquery.groupBy;
                value = (isc.isA.String(groupBy) ? groupBy : (groupBy.length > 0 ? groupBy[0] : null));
            }
        }
        if (!value) {
            if (dataSource) {
                value = dataSource.getPrimaryKeyFieldName();
                if (!value) {
                    var fields = dataSource.getFields();
                    for (var fieldName in fields) {
                        var field = fields[fieldName];
                        if (field.type == "integer" || field.type == "float") {
                            value = fieldName;
                            break;
                        }
                    }
                }
            }
        }
        return value;
    },


    _getFieldOperatorTitle : function (field, op) {
        if (isc.isA.String(op)) op = isc.DS._operators[op];
        if (!op) return null;

        if (isc.isA.String(field)) field = this.getField(field);

        var ops = isc.Operators;

        if (!field) {
            // no field, return the title or titleProperty from the op
            if (op) return op.titleProperty ? ops[op.titleProperty] : op.title;
            return "";
        }


        if (isc.SimpleType.inheritsFrom(field.type || "text", "text")) {
            // text data type, return the textTitleProperty, textTitle, titleProperty or title
            var result = ops[op.textTitleProperty] || op.textTitle;
            if (result) return result;
        }
        // not a text data type - return the titleProperty or title
        return op.titleProperty ? ops[op.titleProperty] : op.title;
    },

    // helper method to return the description of a single criterion
    getCriterionDescription : function (criterion, dataSource, localComponent, wrapAdvanced) {
        if (criterion == null) return "";
        var localValuePrefix = (localComponent != null) ? localComponent.ID + ".values." : null,
            fieldName = criterion.fieldName,
            fieldQuery = criterion.fieldQuery,
            operatorName = criterion.operator,
            start = criterion.start,
            end = criterion.end,
            field
        ;

        if (fieldName && isc.isAn.Array(dataSource)) {
            var dataSources = dataSource;
            dataSource = isc.DataSource.getDataSourceForField(fieldName, dataSources);
            if (!dataSource && localComponent && !fieldName.contains(".") && !fieldName.contains("/")) {
                fieldName = localValuePrefix + fieldName;
                dataSource = isc.DataSource.getDataSourceForField(fieldName, dataSources);
            }
            if (!dataSource) return isc.Operators.noDataSourceDescription;
            // At this point we've identified the dataSource, but the fieldName is dot-prefixed, so
            // use getFieldFromDataSources to get the field object.
            field = isc.DataSource.getFieldFromDataSources(fieldName, [dataSource]);
        } else {
            if (!isc.isA.DataSource(dataSource)) dataSource = isc.DS.getDataSource(dataSource);
            if (!dataSource) return isc.Operators.noDataSourceDescription;
            if (fieldName) {
                // For a shortcut format of fieldQuery (<ds>.<fieldName>), get field reference from the target DS
                var segments = fieldName.split("."),
                    dsID = segments[0];
                if (segments.length == 1) {
                    fieldName = segments[0];
                } else {
                    if (dsID != dataSource.ID) {
                        var ds = isc.DS.getDataSource(dsID);
                        if (ds) dataSource = ds;
                        fieldName = segments[1];
                    } else {
                        fieldName = segments[1];
                    }
                }
                field = dataSource.getField(fieldName);
                if (field == null) {
                    field = dataSource.getFieldForDataPath(fieldName);
                }
            }
        }

        var result = "";
        if (fieldName) {
            if (!field) {
                if (criterion.criteria && isc.isAn.Array(criterion.criteria)) {
                    // we've been passed an AdvancedCriteria as a simple criterion - log a warning and
                    // return the result of getAdvancedCriteriaDescription(), rather than just bailing
                    this.logInfo("DataSource.getCriterionDescription(): Passed an " +
                        "AdvancedCriteria - returning through getAdvancedCriteriaDescription.");
                    result = isc.DS.getAdvancedCriteriaDescription(criterion, dataSource, null,
                                                                        localComponent);
                    return wrapAdvanced ? result = "(" + result + ")" : result;
                }
                // just an unknown field - log a warning and bail
                isc.logWarn("DataSource.getCriterionDescription(): No such field '" + fieldName +
                            "' in DataSource '" + dataSource.ID + "'.");
                return fieldName + " " + isc.FilterBuilder.missingFieldPrompt + " ";

            } else {
                result = (criterion.fieldName != fieldName ? dataSource.getTitle() + " " : "") + (field.title ? field.title : fieldName) + " ";
            }
        } else if (fieldQuery != null) {
            result = isc.DS.getAggregationDescription(fieldQuery) + " ";
        }

        var operator = dataSource.getSearchOperator(operatorName);
        if (!operator) {
            if (result) result += " ";
            return result + "'" + operatorName + "'";
        }

        // It is possible for the single criterion to actually be an "and" criterion. For example,
        // a DateRangeItem will return an "and" criterion for its date range.
        if (operator.valueType == "criteria") {
            // If the operator is "and" or "or", and there is only one criterion in its `criteria`
            // array, then return the description of the single nested criterion.
            if ((operator.isAnd || operator.isOr) &&
                isc.isAn.Array(criterion.criteria) &&
                criterion.criteria.length == 1)
            {
                return this.getCriterionDescription(criterion.criteria[0], dataSource, localComponent, wrapAdvanced);
            }

            var advancedDesc = isc.DS.getAdvancedCriteriaDescription(criterion, dataSource, null, localComponent);
            if (wrapAdvanced) {
                advancedDesc = "(" + advancedDesc + ")";
            }
            return result + advancedDesc;
        }

        if (operator.getDescription) {
            if (result) result += " ";
            return result + String.htmlStringToString(operator.getDescription(criterion, dataSource));
        }

        var operatorMap = dataSource.getFieldOperatorMap(field, true, operator.valueType, false);

        result += (isc.Operators[operator.titleProperty] || operatorMap[operatorName] || operatorName);

        if (operator.valueType != "none") {
            var valuePath = criterion.valuePath,
                valueQuery = criterion.valueQuery;
            if (valueQuery != null) {
                result += " the calculated " + isc.DS.getAggregationDescription(valueQuery).replace("Calculate the ", "");
            } else if (valuePath != null) {
                if (valuePath.startsWith(localValuePrefix)) valuePath = valuePath.replace(localValuePrefix, "");
                result += " value of " + valuePath;
            } else {
                var value = criterion.value;
                if (isc.DateUtil.isRelativeDate(value)) {
                    // if passed a RelativeDate, convert it to an absolute one for display
                    var type = field ? field.type : null,
                            isLogicalDate = false,
                            sType = isc.SimpleType
                            ;
                    if (sType.inheritsFrom(type, "date")) {
                        isLogicalDate = true;
                    }

                    value = isc.DateUtil.getAbsoluteDate(value, null, null, isLogicalDate);
                }

                if (operator.valueType == "valueRange") {
                    // use the FilterBuilder shorthand translation of "and" - the general "and"
                    // operator has the title "Match All" which doesn't make sense in this context
                    var andTitle = isc.FilterBuilder.getPrototype().inlineAndTitle;
                    result += " " + start + " " + andTitle + " " + end;
                } else if (operator.valueType == "fieldName") {
                    // this is an operator like iEqualsField - we want to output the localized
                    // title of the field, not it's name
                    var targetField = dataSource.getField(value);
                    result += " " + (targetField ? targetField.title : null) || fieldName;
                } else if (operatorName != "notNull") {
                    result += " ";
                    if (isc.isA.Date(value)) {
                        // handle dates separately
                        if (value.isLogicalDate) result += value.toShortDate();
                        else result += value.toShortDatetime();
                    } else if (isc.isAn.Array(value)) {
                        // for arrays, use the default formItem separator for multiple values -
                        // falling back to ", " - for the last item, insert "or"
                        if (value.length > 1) {
                            var arr = value.duplicate();
                            //var lastItem = arr.pop();
                            var separator;
                            if (isc.FormItem) {
                                separator = isc.FormItem.getPrototype().multipleValueSeparator;
                            }
                            separator = separator || ", ";
                            result += arr.join(separator);

                            // not translated yet - join with the separator, using "or" with the last item
                            //result += arr.join(separator) + " or " + lastItem;
                        } else {
                            result += value.join();
                        }
                    } else {
                        result += value && value.toString ? value.toString() : value;
                    }
                }
            }
        }

        return result;
    },

    //> @classMethod DataSource.getLoaderURL()
    // Returns the +link{DataSource.setLoaderURL(),loaderURL}
    //
    // @return (String) The loaderURL
    // @visibility external
    //<
    getLoaderURL : function() {
        return isc.DataSource.loaderURL;
    },

    //> @classMethod DataSource.setLoaderURL()
    // Sets the URL where the DataSourceLoader servlet has been installed; this is used by the
    // +link{DataSource.load()} method.  Note, one reason you may wish to modify the loader URL
    // is to include a Cross-Site Request Forgery (CSRF) token, as described
    // +link{RPCManager.actionURL,here}
    //
    // @param url (String) The new loaderURL
    // @visibility external
    //<
    setLoaderURL : function(url) {
        isc.DataSource.addClassProperties({ loaderURL: url });
    },

    // if any criterions have operator:"equals", remove the operator setting - used to reduce
    // clutter in the output from getViewState() - restored by expandEqualsCriteria()
    collapseEqualsCriteria : function (criteria) {
        if (!criteria) return;
        if (criteria.criteria) {
            if (isc.isAn.Array(criteria.criteria)) criteria.criteria.forEach(this.collapseEqualsCriteria, this);
        } else if (criteria.operator == "equals") delete criteria.operator;
    },

    // if any criterions have a value but no operator, make them operator:"equals" - restores
    // operator settings removed by collapseEqualsCriteria() to reduce clutter in the output
    // from getViewState()
    expandEqualsCriteria : function (criteria) {
        if (!criteria) return;
        if (criteria.criteria) {
            if (isc.isAn.Array(criteria.criteria)) criteria.criteria.forEach(this.expandEqualsCriteria, this);
        } else if ((criteria.value != null || criteria.valuePath != null) && !criteria.operator) {
            criteria.operator = "equals";
        }
    },

    __defaultOperatorGetCleanCriterionImpl : function (operator, criterion, dataSource) {
        criterion = isc.addPropertiesWithAssign({}, criterion);

        var valueType = operator.valueType;
        // `null` valueType means "fieldType", but we don't do anything specifically for that
        // valueType, so we won't set `valueType` to "fieldType".

        // If valueType is "custom", then we don't know how the operator uses the properties
        // of the criterion. However, we'll duplicate the subcriteria and clean each one if
        // there are any.
        if (valueType == "custom" || valueType == "criteria") {
            var subcriteria = criterion.criteria;
            // If 'criteria' is not an array, then booleanOperator() (the "and"/"or"/"not"
            // operators' implementation of Operator.condition()) will treat this as no array
            // being specified. Consider that to be the standard behavior.
            if (!isc.isAn.Array(subcriteria)) {
                delete criterion.criteria;
            } else {
                subcriteria = criterion.criteria = subcriteria.duplicate();
                for (var i = 0; i < subcriteria.length; ++i) {
                    subcriteria[i] = this.getCleanCriterion(subcriteria[i], dataSource);
                }
            }
        } else delete criterion.criteria;
        if (valueType != "custom") {
            if (valueType == "criteria" || valueType == "none") delete criterion.value;

            if (valueType != "valueRange") {
                delete criterion.start;
                delete criterion.end;
            }
        }

        return criterion;
    },

    //> @classMethod dataSource.getCleanCriterion()
    // Calls in-use (by the criterion) Operators' +link{Operator.getCleanCriterion()} implementations
    // and returns a cleaned copy of the criterion.
    //
    // @param criterion (AdvancedCriteria) The criterion. This will not be modified.
    // @param [dataSource] (DataSource) The dataSource (if available).
    // @return (Object) Cleaned copy of the criterion.

    //<
    getCleanCriterion : function (criterion, dataSource) {
        if (!criterion) return;

        var op = this.getSearchOperator(criterion.operator, dataSource);
        if (op) {
            if (op.getCleanCriterion) criterion = op.getCleanCriterion(criterion, dataSource);
            else criterion = this.__defaultOperatorGetCleanCriterionImpl(op, criterion, dataSource);

        } else {
            criterion = isc.addPropertiesWithAssign({}, criterion);
            var subcriteria = criterion.criteria;
            if (!isc.isAn.Array(subcriteria)) {
                delete criterion.criteria;
            } else {
                subcriteria = criterion.criteria = subcriteria.duplicate();
                for (var i = 0; i < subcriteria.length; ++i) {
                    subcriteria[i] = this.getCleanCriterion(subcriteria[i], dataSource);
                }
            }
        }

        delete criterion._criterionId;

        return criterion;
    },

    //> @classMethod DataSource.getCleanCollapsedCriterion()
    // Calls in-use (by the criterion) Operators' +link{Operator.getCleanCriterion()} implementations,
    // "collapses" operator:"equals" (deletes to reduce clutter).
    // <p>
    // This method is called in a few places to prepare +link{Criterion}/+link{AdvancedCriteria}
    // for serialization into +linK{group:viewState, viewState}. As such, it needs to be able to
    // handle simple and advanced criteria.
    //
    // @param criterion (Criterion) The criterion.
    // @param [dataSource] (DataSource) The dataSource (if available).
    // @return (Object) Cleaned, collapsed copy of the criterion.

    //<
    getCleanCollapsedCriterion : function (criterion, dataSource) {
        if (!criterion || isc.isAn.emptyObject(criterion)) return;
        if (!this.isAdvancedCriteria(criterion, dataSource)) {
            return criterion;
        }

        criterion = this.getCleanCriterion(criterion, dataSource);
        this.collapseEqualsCriteria(criterion);
        // If isAdvancedCriteria() no longer returns `true`, then add an explicit _constructor:"AdvancedCriteria".
        if (!this.isAdvancedCriteria(criterion, dataSource)) {
            criterion._constructor = "AdvancedCriteria";
        }


        return criterion;
    },

    //> @classMethod dataSource.fromCleanCriterion()
    // Calls in-use (by the cleaned criterion object) Operators' +link{Operator.fromCleanCriterion()}
    // implementations and returns a criterion from the cleaned criterion object.
    //
    // @param cleanCriterion (Object) Cleaned criterion object. This object might be modified
    // by this class method.
    // @param [dataSource] (DataSource) The dataSource (if available).
    // @return (AdvancedCriteria) The restored criterion.

    //<
    fromCleanCriterion : function (criterion, dataSource) {
        if (!criterion) return;

        var origOperator = criterion.operator,
            op = this.getSearchOperator(origOperator, dataSource),
            subcriteria;
        if (op && op.fromCleanCriterion) {
            criterion = op.fromCleanCriterion(criterion, dataSource);
            if (criterion.operator != origOperator) {
                this.logWarn("The '" + origOperator + "' operator's fromCleanCriterion() did not preserve the 'operator'. Resetting...");
                criterion.operator = origOperator;
            }
        } else if (isc.isAn.Array(subcriteria = criterion.criteria)) {
            for (var i = 0; i < subcriteria.length; ++i) {
                subcriteria[i] = this.fromCleanCriterion(subcriteria[i], dataSource);
            }
        }

        return criterion;
    },

    fromCollapsedCleanCriterion : function (criterion, dataSource) {
        if (!criterion || isc.isAn.emptyObject(criterion)) return;
        if (!this.isAdvancedCriteria(criterion, dataSource)) {
            return criterion;
        }

        this.expandEqualsCriteria(criterion);
        criterion = this.fromCleanCriterion(criterion, dataSource);
        isc.ResultSet._addCriterionIds(criterion, dataSource);

        return criterion;
    },


    _getMinIndexability : function (indexability1, indexability2) {
        if (isc.isA.Number(indexability1)) {
            if (!isc.isA.Number(indexability2)) return indexability1;
        } else if (isc.isA.Number(indexability2)) {
            return indexability2;
        }

        return indexability1 < indexability2 ? indexability1 : indexability2;
    },
    getIndexability : function (field, fieldIndex, ds, ignoreFieldNames) {
        if (field._indexability) return field._indexability;

        var minIndexability = "z",
            indexability;

        var validators = field.validators,
            numValidators = !validators ? 0 : validators.length;

        var required = false;
        if (field.required) required = true;
        else {
            for (var v = 0; v < numValidators; ++v) {
                if (validators[v].type == "required") {
                    required = true;
                    break;
                }
            }
        }

        for (var v = 0; v < numValidators; ++v) {
            var validator = validators[v];
            if (validator.type == "isBoolean") {
                indexability = required ? 2 : 3;
                minIndexability = this._getMinIndexability(minIndexability, indexability);
            } else if (validator.type == "isInteger") {
                indexability = "b";
                minIndexability = this._getMinIndexability(minIndexability, indexability);
            } else if (validator.type == "integerRange" &&
                       "min" in validator &&
                       "max" in validator &&
                       validator.min <= validator.max)
            {
                if (validator.exclusive) {
                    if (validator.min + 1 >= validator.max) {
                        indexability = required ? 0 : 1;
                    } else {
                        indexability = validator.max - validator.min - 1 + (required ? 0 : 1);
                    }
                } else {
                    indexability = validator.max - validator.min + 1 + (required ? 0 : 1);
                }
                minIndexability = this._getMinIndexability(minIndexability, indexability);
            } else if ((validator.type == "isOneOf" || validator.type == "inSet") &&
                       isc.isAn.Array(validator.list))
            {
                indexability = validator.list.length + (required ? 0 : 1);
                minIndexability = this._getMinIndexability(minIndexability, indexability);
            } else if (validator.type == "matchesField" &&
                       validator.otherField &&
                       // protect against infinite recursion
                       field.name != validator.otherField &&
                       (!ignoreFieldNames || !ignoreFieldNames.contains(validator.otherField)))
            {
                var otherField = fieldIndex[validator.otherField];

                // makeIndex() will put objects having the same index property value into an
                // array. If they are all the same DataSourceField object, though, then it's okay.
                if (isc.isAn.Array(otherField)) {
                    var otherFields = otherField;
                    otherField = otherFields[0];
                    for (var i = 1; i < otherFields.length; ++i) {
                        if (otherField !== otherFields[i]) {
                            otherField = null;
                            break;
                        }
                    }
                }

                if (!otherField && ds) otherField = ds.getField(validator.otherField);
                if (otherField) {
                    if (!ignoreFieldNames) ignoreFieldNames = [field.name];
                    else ignoreFieldNames.push(field.name);
                    indexability = this.getIndexability(otherField, fieldIndex, ds, ignoreFieldNames);
                    minIndexability = this._getMinIndexability(minIndexability, indexability);
                }
            }
        }

        var valueMap = field.valueMap;
        if (isc.isAn.Object(valueMap)) {
            indexability = (isc.isAn.Array(valueMap) ? valueMap.length : isc.getKeys(valueMap).length) + (required ? 0 : 1);
            minIndexability = this._getMinIndexability(minIndexability, indexability);
        }

        indexability = "z";
        if (isc.SimpleType.inheritsFrom(field.type, "boolean", ds)) {
            indexability = required ? 2 : 3;
        } else if (isc.SimpleType.inheritsFrom(field.type, "phoneNumber", ds)) {
            indexability = "a";
        } else if (isc.SimpleType.inheritsFrom(field.type, "integer", ds)) {
            indexability = "b";
        } else if (isc.SimpleType.inheritsFrom(field.type, "date", ds) ||
                   isc.SimpleType.inheritsFrom(field.type, "time", ds))
        {
            indexability = "c";
        } else if (isc.SimpleType.inheritsFrom(field.type, "datetime", ds)) {
            indexability = "d";
        } else if (isc.SimpleType.inheritsFrom(field.type, "text", ds)) {
            indexability = "e";
        } else if (isc.SimpleType.inheritsFrom(field.type, "float", ds)) {
            indexability = "f";
        }
        minIndexability = this._getMinIndexability(minIndexability, indexability);

        return minIndexability;
    },
    // Sorts the given fields by their "indexability" - roughly how big an index of values
    // for the field would be expected to be - from smallest (most indexable) to largest (least indexable).
    sortByIndexability : function (fields, ds) {
        var fieldNames,
            fieldIndex,
            fields;
        if (isc.isAn.Array(fields)) {
            fieldNames = fields.getProperty("name");
            fieldIndex = fields.makeIndex("name");
        } else {
            fieldNames = isc.getKeys(fields);
            fieldIndex = fields;
            fields = isc.getValues(fields);
        }
        for (var i = 0; i < fields.length; ++i) {
            var field = fields[i];
            field._indexability = this.getIndexability(field, fieldIndex, ds);
        }

        fields.sort(function (field1, field2) {
            var indexability1 = field1._indexability,
                indexability2 = field2._indexability;
            if (isc.isA.Number(indexability1)) {
                if (!isc.isA.Number(indexability2)) return -1;
                return indexability1 - indexability2;
            } else if (isc.isA.Number(indexability2)) {
                return 1;
            }
            if (indexability1 == indexability2) return 0;
            return indexability1 < indexability2 ? -1 : 1;
        });
        return fields;
    },

    //>DEBUG
    __unnamedFieldsSkippedInRecordSummaryCalculations: isc.Set.create(),
    //<DEBUG
    _originalGetRecordSummaryFunctionFieldNamesToInclude : function (fields, summaryField, _component) {


        var dependencies = [];
        if (!fields) return dependencies;

        for (var f = 0; f < fields.length; ++f) {
            var field = fields[f],
                fieldName = field.name;

            // should a field be included in this summary calculation?

            if (!isc.isA.nonemptyString(fieldName)) continue;

            // Never include a field in its own calculation!
            if (field === summaryField) {
                // partial summary - only include fields up to this one (index < the summary field's index)
                if (summaryField.partialSummary) break;
                continue;
            }

            var shouldInclude = field.includeInRecordSummary;

            // If 'includeInRecordSummary' is unset, default to including numeric non-generated fields
            if (shouldInclude == null &&
                (isc.SimpleType.inheritsFrom(field.type, "integer") ||
                 isc.SimpleType.inheritsFrom(field.type, "float")) &&

                !_component._isFieldGenerated(field))
            {
                shouldInclude = true;
            }

            // if 'includeInRecordSummaryFields' is explicitly set, respect it as well
            if (shouldInclude && field.includeInRecordSummaryFields != null) {
                if ((isc.isA.String(field.includeInRecordSummaryFields) &&
                        field.includeInRecordSummaryFields != summaryField.name) ||
                    (isc.isAn.Array(field.includeInRecordSummaryFields) &&
                        !field.includeInRecordSummaryFields.contains(summaryField.name)))
                {
                    shouldInclude = false;
                }
            }
            if (shouldInclude) {
                dependencies.push(fieldName);
            }
        }

        return dependencies;
    }
});


isc.DataSource.addProperties({
    //> @attr dataSource.ID              (Identifier : null : [IR])
    // Unique identifier for this DataSource.  Required for all DataSources.
    //
    // <smartclient>DataSources will make themselves available as JavaScript globals under
    // the same name as their ID only if +link{addGlobalId} is set.</smartclient>
    //
    // @group identity
    // @serverDS allowed
    // @see group:memoryLeaks
    // @visibility external
    //<

    //> @attr dataSource.description              (String : null : [IR])
    // An optional description of the DataSource's content. It is not automatically exposed
    // on any component, but it is useful for developer documentation, and as such it is included on any
    // +link{group:openapiSupport, OpenAPI specification} generated by the framework.  Markdown is
    // a commonly-used syntax, but you may also embed HTML content. When embedding HTML in the
    // description in a .ds.xml file (see +link{group:dataSourceDeclaration}), it is recommended
    // to wrap the HTML in a CDATA tag.
    // <p>
    // This description is also provided to AI when AI is asked to work with the data source.
    // Best practices for the description are:
    // <ul>
    // <li>Start with a plain language explanation of what the data source and records within
    // it represent, their business concept or core purpose.
    // <li>Describe how the data source relates to other data sources in the application.
    // <li>Mention the approximate size of the data source and whether/when records are updated,
    // added, and removed, as well as the approximate rates of updates, additions, and removals.
    // <li>Identify any known data issues or anomalies.
    // </ul>
    // <p>
    // In addition to the data source-level description, each field can be described via
    // +link{DataSourceField.description}.
    // @see DataSource.sampleData
    // @serverDS allowed
    // @visibility external
    //<

    //> @attr dataSource.sampleData (Array of Record : null : IRW)
    // An optional array of sample data records. These may be actual records from the data source
    // or artificial data that is representative of records from the data source.
    // <p>
    // AI may be provided this sample data when AI is asked to work with the data source, to
    // give it a better idea of what the data in the data source "looks like".
    // <p>
    // When defining the data source in a .ds.xml file (see +link{group:dataSourceDeclaration}),
    // it will likely be helpful to use the XMLSchema-Instance <code>type</code> attribute to be
    // able to change the value type from the default (string) to boolean, int, float, date, etc.
    // For example:
    // <pre>
    // &lt;sampleData <strong style="color:green">xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance"</strong>&gt;
    //   &lt;country&gt;
    //     &lt;continent&gt;North America&lt;/continent&gt;
    //     &lt;countryName&gt;United States&lt;/countryName&gt;
    //     &lt;countryCode&gt;US&lt;/countryCode&gt;
    //     &lt;area <strong style="color:green">xsi:type="float"</strong>&gt;9372610&lt;/area&gt;
    //     &lt;population <strong style="color:green">xsi:type="int"</strong>&gt;266476278&lt;/population&gt;
    //     &lt;gdp <strong style="color:green">xsi:type="float"</strong>&gt;7247700&lt;/gdp&gt;
    //     &lt;independence <strong style="color:green">xsi:type="date"</strong>&gt;1776-07-04&lt;/independence&gt;
    //     &lt;government&gt;federal republic&lt;/government&gt;
    //     &lt;capital&gt;Washington&lt;/capital&gt;
    //     &lt;member_g8 <strong style="color:green">xsi:type="boolean"</strong>&gt;true&lt;/member_g8&gt;
    //   &lt;/country&gt;
    // ...
    // </pre>
    // @see DataSource.description
    // @see DataSourceField.description
    // @visibility external
    //<

    //> @attr dataSource.addGlobalId    (boolean : true : IRA)
    // Whether to make this DataSource available as a global variable for convenience.
    // @group identity
    // @visibility external
    //<
    addGlobalId:true,

    //> @attr dataSource.dataFormat (DSDataFormat : "iscServer" : [IR])
    // Indicates the format to be used for HTTP requests and responses when
    // fulfilling DSRequests (eg, when +link{DataSource.fetchData()} is called).
    //
    // @group clientDataIntegration
    // @group serverDataIntegration
    // @serverDS allowed
    // @visibility external
    // @example jsonDataSource
    // @example simpleJSON
    //<
    dataFormat:"iscServer",

    //> @attr dataSource.useStrictJSON (boolean : null : IR)
    // Should HTTP responses to requests by this dataSource be formatted using the
    // strict JSON subset of the javascript language?
    // If set to true, responses returned by the server should match the format described
    // +externalLink{https://www.json.org/json-en.html,here}.
    // <P>
    // Only applies to dataSources which send requests to a server and have
    // +link{dataSource.dataFormat} set to "json" or "iscServer".
    // <P>
    // <b>Note:</b> using strict JSON avoids a known issue in Internet Explorer 9 where
    // datasource transactions can leak memory due to a browser behavior where the native
    // <code>eval()</code> method fails to clean up references when the objects
    // go out of scope. See +link{isc.RPCManager.allowIE9Leak} for more on this.
    // @visibility external
    //<

    //> @attr dsRequest.useStrictJSON (boolean : null : IR)
    // Should the HTTP response to this request be formatted using the
    // strict JSON subset of the javascript language?
    // If set to true, responses returned by the server should match the format described
    // +externalLink{http://www.json.org/js.html,here}.
    // <P>
    // Only applies to requests sent a server with
    // +link{dataSource.dataFormat} set to "json" or "iscServer".
    // @visibility external
    //<



    //> @attr dataSource.dataProtocol (DSProtocol : null : [IR])
    // Controls the format in which inputs are sent to the dataURL when fulfilling DSRequests.
    // May be overridden for individual request types using
    // +link{OperationBinding.dataProtocol,operation bindings}.
    // @group clientDataIntegration
    // @group serverDataIntegration
    // @serverDS allowed
    // @visibility external
    //<

    //> @attr dataSource.useHttpProxy (boolean : null : IR)
    // Like +link{operationBinding.useHttpProxy}, but serves as a default for this DataSource
    // that may be overridden by individual operationBindings.
    //
    // @group clientDataIntegration
    // @visibility external
    //<

    //> @attr dataSource.callbackParam (String : "callback" : [IR])
    // Applies only to dataFormat: "json" and +link{dataTransport}:"scriptInclude".  Specifies
    // the name of the query parameter that tells your JSON service what function to call as
    // part of the response.
    //
    // @see dataSource.dataFormat
    // @see dataSource.operationBindings
    // @see operationBinding.callbackParam
    // @group clientDataIntegration
    // @visibility external
    // @serverDS allowed
    // @example xmlEditSave
    //<
    callbackParam : "callback",

    //> @attr dataSource.requestProperties (DSRequest Properties : null : [IRW])
    // Additional properties to pass through to the +link{DSRequest}s made by this
    // DataSource.  This must be set before any +link{DSRequest}s are issued and before
    // any component is bound to the DataSource.
    // <p>
    // These properties are applied before +link{dataSource.transformRequest} is called.
    //
    // @see DSRequest
    // @see operationBinding.requestProperties
    // @group clientDataIntegration
    // @group serverDataIntegration
    // @serverDS allowed
    // @visibility external
    //<

    //> @attr dataSource.dataTransport      (RPCTransport : RPCManager.defaultTransport : [IR])
    // Transport to use for all operations on this DataSource. Defaults to
    // +link{RPCManager.defaultTransport}.  This would typically only be set to
    // enable "scriptInclude" transport for contacting +link{DataSource.dataFormat,JSON} web
    // services hosted on servers other than the origin server.
    // <p>
    // When using the "scriptInclude" transport, be sure to set +link{dataSource.callbackParam} or
    // +link{operationBinding.callbackParam} to match the name of the query parameter name expected
    // by your JSON service provider.
    //
    // @see RPCTransport
    // @see dataSource.callbackParam
    // @group clientDataIntegration
    // @serverDS allowed
    // @visibility xmlBinding
    //<

    //> @attr dataSource.preventHTTPCaching (Boolean : true : IR)
    // If set, the DataSource will ensure that it never uses a cached HTTP response, even if the
    // server marks the response as cacheable.
    // <P>
    // Note that this does not disable caching at higher levels in the framework, for example, the
    // caching performed by +link{ResultSet}.
    // @serverDS allowed
    // @visibility external
    //<
    preventHTTPCaching:true,

    //> @type DSDataFormat
    // Indicates the format to be used for HTTP requests and responses when
    // fulfilling DSRequests (eg, when +link{DataSource.fetchData()} is called).
    // <P>
    // Note that +link{RPCManager.startQueue(),request queuing} is only available for
    // "iscServer" requests.
    //
    // @value "iscServer"
    // Make an HTTP request in a format recognized by the ISC server and expect ISC server
    // response format.  +link{group:serverDataIntegration,Server-side integration} can then be
    // used to connect to any kind of data store or web service.
    //
    // @value "xml"
    // Expect XML responses.  Request format depends on the setting for
    // +link{operationBinding.dataProtocol,protocol}.  This is the correct setting when
    // consuming RSS feeds, XML web services (whether SOAP, REST, XML-RPC or custom format),
    // and XML flat files directly from the browser.
    // <P>
    // Values for "date", "time" or "datetime" fields in responses should be specified in the
    // applicable <a target=_blank href="http://www.w3.org/TR/xmlschema-2/#dateTime">XML Schema
    // date format</a>.
    // If no timezone is explicitly specified, dates / datetimes received by the client are
    // assumed to be GMT. Note that "date" type fields represent logical dates and may omit
    // time information entirely, and "time" type fields may omit date information.
    // See +link{group:dateFormatAndStorage,Date and Time Format and storage} for more information
    // on how date values are serialized in requests sent to the server.
    //
    // <P>
    // A DSResponse will be derived from the returned XML via the process described under
    // +link{dataSource.transformResponse()}.
    //
    // @value "json"
    // Expect response in JSON +externalLink{http://json.org,(Java Script Object Notation)}
    // format, ready to be eval()'d. Response should either be a naked object literal:
    // <pre>
    //     { "property":"value1", "property2" : "value2", ... }
    // </pre>
    // or a string that evals to return a valid response object:
    // <pre>
    //     var response = { "property":"value1", "property2" : "value2", ... }
    //     response;
    // </pre>
    // <P>
    // A DSResponse will be derived from the returned JSON via the process described under
    // +link{dataSource.transformResponse()}.
    // <P>
    // As with <code>"xml"</code> responses, values for "date" or "datetime" fields should be
    // specified as a String in
    // <a target=_blank href="http://www.w3.org/TR/xmlschema-2/#dateTime">XML Schema date format</a>
    // and may include a timezone.  In the absence of a timezone they will be assumed to be GMT.
    // <P>
    // Request format depends on the setting for +link{operationBinding.dataProtocol,protocol}.
    // See also +link{XJSONDataSource}.
    //
    // @value "custom"
    // SmartClient will not attempt to parse the response, instead,
    // +link{dataSource.transformResponse()} must be implemented.
    // <code>transformResponse</code> will receive the "data" parameter as a String, and must
    // parse this String into an Array of Objects, which should be set as
    // +link{dsResponse.data}.  Request format depends on the setting for
    // +link{operationBinding.dataProtocol,protocol}.
    // <P>
    // Note that, unlike either the "json" or "xml" settings of <code>dataFormat</code>, you
    // are responsible for ensuring that parsed values are the correct type, for example, using
    // the JavaScript built-ins <code>parseInt</code> and <code>parseFloat</code> on integer
    // and decimal values respectively, and using <code>new Date()</code> to construct valid
    // Dates.
    //
    // @group clientDataIntegration
    // @group serverDataIntegration
    // @visibility external
    // @serverDS allowed
    // @example simpleJSON
    //<

    //> @attr dataSource.serverType (DSServerType : "generic" : [IR])
    // For a DataSource stored in .xml format on the SmartClient server, indicates what server-side
    // connector to use to execute requests, that is, what happens if you call
    // dsRequest.execute() in server code.
    //
    // @group serverDataIntegration
    // @requiresModules SCServer
    // @serverDS only
    // @visibility external
    //<

    //> @type DSServerType
    // Indicates what SmartClient Server will do with a DataSource request if you call
    // dsRequest.execute() in server code.
    // <P>
    // If you use a Java-based persistence layer not provided by SmartClient, such as
    // EJB or your own custom object model, you don't need to set
    // <code>dataSource.serverType</code> and should follow the
    // +link{group:serverDataIntegration,integration instructions}.
    //
    // @value "sql"
    // Use SmartClient's +link{group:sqlDataSource,built-in SQL connectors} to talk directly
    // to relational databases.
    //
    // @value "hibernate"
    // Use Hibernate, either using a real mapped bean or by automatically generating a
    // Hibernate configuration based on a SmartClient DataSource file
    // (<i>dataSourceID</i>.ds.xml).  See +link{group:hibernateIntegration} for details.
    //
    // @value "jpa"
    // Use SmartClient's built-in JPA 2.0 connector.
    //
    // @value "jpa1"
    // Use SmartClient's built-in JPA 1.0 connector.
    //
    //>ISC_140
    // @value "rest"
    // Use SmartClient's built-in +link{group:serverRestConnector,RestConnector}, which can
    // connect to many different types of REST webservice
    //
    // @value "odata"
    // Use SmartClient's built-in +link{group:odataDataSource,OData DataSource}.  This is a
    // specialized subclass of the <code>RestConnector</code> which adds functionality for
    // REST webservices that follow the <a href="https://www.odata.org/">OData protocol</a>
    //<ISC_140
    //
    // @value "generic"
    // Requests will be delivered to the server and you are expected to write Java code to
    // create a valid response.  Throws an error if the server side method dsRequest.execute()
    // is called. This is appropriate if you intend an entirely custom implementation, and you
    // want an error thrown if there is an attempt to call an operation you have not
    // implemented.
    //
    // @value "projectFile"
    // Requests will be delivered to the server and processed as
    // +link{group:fileSource,FileSource operations}, using directories or other DataSources
    // which you configure via +link{dataSource.projectFileKey} or +link{dataSource.projectFileLocations}
    //
    // @value "union"
    // Use SmartClient's built-in +link{group:unionDataSource,unionDataSource}, which assimilates
    // records from multiple member dataSources
    //
    // @group serverDataIntegration
    // @serverDS allowed
    // @visibility external
    //<

    //> @attr dataSource.tableName (String : null : [IR])
    // For DataSources using the +link{group:sqlDataSource,SmartClient SQL engine} for
    // persistence, what database table name to use.  The default is to use the DataSource ID
    // as the table name.
    //
    // @see dataSource.quoteTableName
    // @group serverDataIntegration
    // @requiresModules SCServer
    // @serverDS only
    // @visibility external
    //<

    //> @attr dataSource.schema (String : null : [IR])
    // <b>This property only applies to the built-in SQL DataSource provided in Pro and better
    // editions of SmartClient</b>
    // <p>
    // Defines the name of the schema we use to qualify the +link{tableName,tableName} in
    // generated SQL.  If you do not provide this property, we will try to use the SmartClient
    // default schema for this +link{group:dbConfigTool,dbName}; you specify this for a given
    // <code>dbName</code> in your <code>server.properties</code> file like this:<pre>
    //    sql.the_dbName.default.schema: myDefaultSchema
    // </pre>
    // If there is no DataSource-specific schema and no SmartClient default schema, table
    // names will not be qualified in generated SQL, and thus the database default schema will
    // be used.  Support for multiple schemas (or schemata) varies quite significantly across
    // the supported databases, as does the meaning of the phrase "default schema".  In
    // addition, some databases allow you to override the default schema in the JDBC connection
    // URL, which is a preferable approach if all your tables are in the same (non-default)
    // schema, because it makes the generated SQL simpler (no need to qualify every table)
    // <p>
    // The following table provides information by product:
    // <p>
    // <table border="1" class="normal" width="90%">
    // <tr><td> Product</td><td width="90%"> Notes</td></tr>
    // <tr><td> DB2</td><td>
    // Arbitrarily named schemas are supported.  The default schema is named after the connecting
    // user, though this can be overridden by specifying the "currentSchema" property on the JDBC
    // connection URL</td></tr>
    // <tr><td> DB2 for iSeries</td><td>
    // Arbitrarily named schemas are supported.  "Schema" is synonymous with "library".  The
    // default schema depends on the setting of the "naming" connection property.  When this is
    // set to "sql", behavior is similar to other DB2 editions: the default schema is named after
    // the connecting user, unless overridden by specifying a library name in the JDBC connection
    // URL.  When "naming" is set to "system", the schema of an unqualified table is resolved
    // using a traditional search of the library list; the library list can be provided in the
    // "libraries" property</td></tr>
    // <tr><td> Firebird</td><td>
    // Firebird does not support the concept of schema at all - all "schema objects" like tables
    // and indexes belong directly to the database.  In addition, Firebird actively rejects
    // qualified table names in queries as syntax errors; therefore, you should <b>not</b> set
    // the <code>schema</code> property for a DataSource that will be backed by a Firebird database
    // </td></tr>
    // <tr><td> HSQLDB</td><td>
    // Arbitrarily named schemas are supported.  The default schema is auto-created when the
    // database is created; by default it is called "PUBLIC", but can be renamed.  It is not
    // possible to set the default schema in the JDBC connection URL</td></tr>
    // <tr><td> Informix</td><td>
    // Informix databases can be flagged as "ANSI mode" at creation time.  ANSI-mode databases
    // behave similarly to DB2 for schema support: arbitrarily named schemas are supported, and
    // the default schema is the one named after the connected user.  Non-ANSI databases have no
    // real schema support at all. It is not possible to set the default schema in the JDBC
    // connection URL with either type of database</td></tr>
    // <tr><td> Microsoft SQL Server</td><td>
    // Prior to SQL Server 2005, schema support is similar to Oracle: "schema" is synonymous with
    // "owner".  As of SQL Server 2005, schema is supported as a separate concept, and a user's
    // default schema can be configured (though it still defaults to a schema with the same name
    // as the user).  It is not possible to set the default schema in the JDBC connection URL</td></tr>
    // <tr><td> MySQL</td><td>
    // MySQL does not have a separate concept of "schema"; it treats the terms "schema" and
    // "database" interchangeably.  In fact MySQL databases actually behave more like schemas, in
    // that a connection to database X can refer to a table in database Y simply by qualifying
    // the name in the query.  Also, because schema and database are the same concept in MySQL,
    // overriding the "default schema" is done implicitly when you specify which database to
    // connect to in your JDBC connection URL</td></tr>
    // <tr><td> Oracle</td><td>
    // Arbitrarily named schemas are not supported; in Oracle, "schema" is synonymous with "user",
    // so each valid user in the database is associated implicitly with a schema of the same name,
    // and there are no other schemas possible.  It is possible to refer to tables in another
    // user's schema (assuming you have the privileges to do so) by simply qualifying the table name.
    // The default schema is always implied by the connecting user and cannot be overridden.</td></tr>
    // <tr><td> Postgres</td><td>
    // Arbitrarily named schemas are supported.
    // Rather than the concept of a "default schema", Postgres supports the idea of a search path
    // of schemas, whereby unqualified table references cause a search of the list of schemas in
    // order, and the first schema in the path is the "current" one for creation purposes.
    // Unfortunately, there is no way to specify this search path on the JDBC connection URL, so
    // the default schema comes from the user definition, ultimately defaulting to the default
    // "public" schema</td></tr>
    // </table>
    // @serverDS only
    // @visibility external
    //<

    //> @attr dataSource.auditSchema (String : null : [IR])
    // For SQL DataSources only, where +link{dataSource.audit,automatic auditing} is enabled,
    // <code>auditSchema</code> tells the framework which database schema to use for the
    // automatically created audit tables.  If this property is not set, the framework will
    // fall back to using the same +link{dataSource.schema,schema} as this dataSource, with
    // the same default fallbacks described in that property's documentation
    //
    // @see dataSource.audit
    // @see dataSource.schema
    // @requiresModules SCServer
    // @serverDS only
    // @visibility internal
    //<

    //> @attr dataSource.quoteTableName (Boolean : null : [IRA])
    // For SQL DataSources, tells the framework whether to surround the associated
    // +link{dataSource.tableName,table name} with quotation marks whenever it appears in
    // generated queries.  This is only required if you have to connect to a table with a name
    // that is in breach of your database product's naming conventions.  For example, some
    // products (eg, Oracle) internally convert all unquoted references to upper case, so if
    // you create a table called <code><b>myTest</b></code>, the database actually calls it
    // <code><b>MYTEST</b></code> unless you quoted the name in the create command, like this:
    // <p>
    // <code><b>&nbsp;&nbsp;CREATE TABLE "myTest"</b></code>
    // <p>
    // If you <em>do</em> quote the name like this, or if you have to connect to a legacy table
    // that has been named in this way, then you must set this property to tell the SQL engine
    // that it must quote any references to this table name (this requirement depends on the
    // database in use - as noted below, some are not affected by this problem).  If you do
    // not, you will see exceptions along the lines of "Table or view 'myTest' does not exist".
    // <p>
    // Note, other database products (eg, Postgres) convert unquoted names to lower case, which
    // leads to the same issues.  Still others (eg, SQL Server) are not case sensitive and are
    // not affected by this issue.
    // <p>
    // Generally, we recommend that you avoid using this property unless you have a specific
    // reason to do so.  It is preferable to avoid the issue altogether by simply not quoting
    // table names at creation time, if you are able to do so.
    //
    // @see dataSource.tableName
    // @see dataSource.quoteColumnNames
    // @group serverDataIntegration
    // @requiresModules SCServer
    // @serverDS only
    // @visibility external
    //<

    //> @attr dataSource.relatedTableAlias (String : null : IR)
    // For a +link{group:sqlDataSource,SQL DataSource} that is referred by
    // +link{dataSourceField.otherFKs,additional foreign keys}, this property defines the table alias name to
    // use in generated SQL. If omitted +link{dataSource.ID,DataSource ID} will be used to construct the alias.
    // <p>
    // Aliasing is necessary when the same table appears more than once in a query. In addition
    // to use cases described in +link{dataSourceField.relatedTableAlias}, this may happen when
    // <code>includeFrom</code> field using +link{dataSourceField.otherFKs, foreign key defined in otherFKs}
    // would be included multiple times in a related DataSource.
    // <p>
    // See the "Automatically generated table aliases" section of the +link{group:customQuerying,SQL Templating}
    // for the complete set of general rules how aliases are generated. Also, see
    // +link{dataSourceField.otherFKs,dataSourceField.otherFKs} for more details and usage samples.
    //
    // @see dataSourceField.otherFKs
    // @see dataSourceField.includeVia
    // @see dataSourceField.relatedTableAlias
    // @serverDS only
    // @group dataSourceRelations
    // @visibility external
    //<

    //> @attr dataSource.dbName (String : null : [IR])
    // For DataSources using the +link{group:sqlDataSource,SmartClient SQL engine} for
    // persistence, which database configuration to use.  Database configurations can be
    // created using the +link{group:adminConsole, Admin Console}.  If unset, the default
    // database configuration is used (which is also settable using the "Databases" tab).
    //
    // @group serverDataIntegration
    // @requiresModules SCServer
    // @serverDS only
    // @visibility external
    //<

    //> @attr dataSource.configBean (String : null : [IRA])
    // For DataSources of +link{serverType,serverType} "hibernate", the name of a Spring
    // bean to query to obtain Hibernate Configuration for this particular DataSource.  Note
    // that this is intended for DataSource-specific configuration overrides for unusual
    // circumstances, such as a DataSource whose physical data store is a completely
    // different database to that used by other DataSources.  See the
    // +link{group:hibernateIntegration,Integration with Hibernate} article for more
    // information
    //
    // @group serverDataIntegration
    // @requiresModules SCServer
    // @serverDS only
    // @visibility external
    //<

    //> @attr dataSource.quoteColumnNames (boolean : null : [IR])
    // If set, tells the SQL engine to quote column names in all generated DML and DDL
    // statements for this dataSource.  This will ensure that queries generated against
    // tables that do not follow the database product's natural column-naming conventions
    // will still work.
    // <p>
    // In general we recommend that you allow the database to use its natural naming scheme
    // when creating tables (put more simply, just do not quote column names in the
    // <code>CREATE TABLE</code> statement); if you do this, you will not need to worry about
    // quoting column names when querying.  However, if you are dealing with pre-existing
    // tables, or do not have control over the database naming conventions used, this property
    // may become necessary.  This property may also be necessary if you are using field/column
    // names that clash with reserved words in the underlying database (these vary by database,
    // but a field called "date" or "timestamp" would have problems with most database products)
    // <p>
    // <b>Note:</b> Only applicable to dataSources of +link{attr:serverType,serverType} "sql".
    //
    // @serverDS only
    // @visibility external
    //<

    //> @attr dataSource.logSlowSQL (Integer : null : [IR])
    // Allows you to specify SQL query execution time threshold in milliseconds, which if exceeded
    // query is identified as "slow" and may be logged under specific logging category.
    // <p>
    // This setting applies to all SQL queries, unless more specific thresholds are set using
    // +link{attr:dataSource.logSlowFetch}, +link{attr:dataSource.logSlowAdd},
    // +link{attr:dataSource.logSlowUpdate}, +link{attr:dataSource.logSlowRemove},
    // +link{attr:dataSource.logSlowCustom} or even more specific affecting just the
    // operationBinding it is configured in your DS XML as operationBinding.logSlowSQL.
    // <p>
    // If none of the thresholds above are set, global <i>sql.log.queriesSlowerThan</i>
    // +link{group:sqlSettings,server.properties SQL setting} will be used.
    // <p>
    // For the details on how to setup the logging part see the
    // +link{group:serverLogging,Special logging category: com.isomorphic.SLOW_SQL}
    // @serverDS only
    // @visibility external
    //<

    //> @attr dataSource.logSlowFetch (Integer : null : [IR])
    // Allows you to specify +link{DSOperationType,"fetch" operation} SQL query execution
    // time threshold in milliseconds, which if exceeded query is identified as "slow" and
    // may be logged under specific logging category.
    // <p>
    // See +link{dataSource.logSlowSQL} for more details.
    // @serverDS only
    // @visibility external
    //<

    //> @attr dataSource.logSlowAdd (Integer : null : [IR])
    // Allows you to specify +link{DSOperationType,"add" operation} SQL query execution
    // time threshold in milliseconds, which if exceeded query is identified as "slow" and
    // may be logged under specific logging category.
    // <p>
    // See +link{dataSource.logSlowSQL} for more details.
    // @serverDS only
    // @visibility external
    //<

    //> @attr dataSource.logSlowUpdate (Integer : null : [IR])
    // Allows you to specify +link{DSOperationType,"update" operation} SQL query execution
    // time threshold in milliseconds, which if exceeded query is identified as "slow" and
    // may be logged under specific logging category.
    // <p>
    // See +link{dataSource.logSlowSQL} for more details.
    // @serverDS only
    // @visibility external
    //<

    //> @attr dataSource.logSlowRemove (Integer : null : [IR])
    // Allows you to specify +link{DSOperationType,"remove" operation} SQL query execution
    // time threshold in milliseconds, which if exceeded query is identified as "slow" and
    // may be logged under specific logging category.
    // <p>
    // See +link{dataSource.logSlowSQL} for more details.
    // @serverDS only
    // @visibility external
    //<

    //> @attr dataSource.logSlowCustom (Integer : null : [IR])
    // Allows you to specify +link{DSOperationType,"custom" operation} SQL query execution
    // time threshold in milliseconds, which if exceeded query is identified as "slow" and
    // may be logged under specific logging category.
    // <p>
    // See +link{dataSource.logSlowSQL} for more details.
    // @serverDS only
    // @visibility external
    //<

    //> @attr dataSource.jsonPrefix (String : null : [IRA])
    // Allows you to specify an arbitrary prefix string to apply to all json format responses
    // sent from the server to this application.
    // <P>
    // The inclusion of such a prefix ensures your code is not directly executable outside of
    // your application, as a preventative measure against
    // +externalLink{http://www.google.com/search?q=javascript+hijacking, javascript hijacking}.
    // <P>
    // Only applies to responses formatted as json objects. Does not apply to responses returned
    // via scriptInclude type transport.<br>
    // Note: If the prefix / suffix served by your backend is not a constant, you can use
    // +link{operationBinding.dataFormat, dataFormat:"custom"} instead and explicitly parse
    // the prefix out as part of +link{dataSource.transformResponse(), transformResponse()}.
    //
    // @see operationBinding.dataFormat
    // @see operationBinding.dataTransport
    // @serverDS allowed
    // @visibility external
    //<

    //> @attr dataSource.jsonSuffix (String : null : [IRA])
    // Allows you to specify an arbitrary suffix string to apply to all json format responses
    // sent from the server to this application.
    // <P>
    // The inclusion of such a suffix ensures your code is not directly executable outside of
    // your application, as a preventative measure against
    // +externalLink{http://www.google.com/search?q=javascript+hijacking, javascript hijacking}.
    // <P>
    // Only applies to responses formatted as json objects. Does not apply to responses returned
    // via scriptInclude type transport.
    //
    // @see operationBinding.dataFormat
    // @see operationBinding.dataTransport
    // @serverDS allowed
    // @visibility external
    //<

    //> @attr dataSource.forceSort (String : null : [IRA])
    // For DataSources of +link{DataSource.serverType,serverType} "sql" only, indicates whether
    // we should automatically add a sort field for +link{resultSet.fetchMode,paged fetches} on
    // this DataSource.  If left unset, this property defaults to the one of the global values
    // described in the +link{dataSource.defaultSortField,defaultSortField} documentation.
    // Also note, this property can be overridden
    // +link{operationBinding.forceSort,per-operationBinding}.
    // <p>
    // Note, the ability to set this property per-DataSource is only provided to allow for
    // complete configurability in unusual cases.  See the <code>defaultSortField</code> docs
    // for details of why use of this property should be considered a red flag.
    // @group serverDataIntegration
    // @requiresModules SCServer
    // @serverDS only
    // @visibility external
    //<

    //> @attr operationBinding.forceSort (String : null : [IRA])
    // For DataSources of +link{DataSource.serverType,serverType} "sql" only, indicates whether
    // we should automatically add a sort field for +link{resultSet.fetchMode,paged fetches}.
    // Only applies to +link{operationBinding.operationType,"fetch" operations}.  If left
    // unset, this property defaults first to the
    // +link{dataSource.forceSort,dataSource-level setting}, and then to one of the global
    // values described in the  +link{dataSource.defaultSortField,defaultSortField}
    // documentation.
    // <p>
    // Note, the ability to set this property per-operation is only provided to allow for
    // complete configurability in unusual cases.  See the <code>defaultSortField</code> docs
    // for details of why use of this property should be considered a red flag.
    // @group serverDataIntegration
    // @requiresModules SCServer
    // @serverDS only
    // @visibility external
    //<

    //> @attr dataSource.defaultSortField (String : null : [IRA])
    // For DataSources of +link{serverType,serverType} "sql" only, the name of a field to
    // include in the <code>ORDER BY</code> clause as a means of enforcing a stable sort
    // order, <i>for +link{resultSet.fetchMode,paged fetches} only</i>.  This property has no
    // effect for non-SQL dataSources, or for non-paged fetches.
    // <p>
    // Generally speaking, databases make no guarantee about the order of rows in a
    // resultset unless an <code>ORDER BY</code> clause was provided.  This is not usually a
    // problem if you actually don't care about the row order, but there is a catch if you
    // are using paged fetching: because the pages are fetched using completely different
    // queries, the database is at liberty to use different orderings from one fetch to another,
    // and in some cases, with some databases, that is what actually happens.  This leads to
    // broken paging behavior, with some records duplicated and others omitted.
    // <p>
    // Note that it is unusual for a database to change strategies between queries like this;
    // generally speaking, rows are ordered in some kind of natural ordering in the absence of
    // an explicit order - typically insertion order, or by primary key value.  However, it
    // does happen, and is more likely with some database products than others.
    // <p>
    // This property only has an effect if <code>forceSort</code> is in effect for the fetch
    // operation.  See below for DataSource- and operation-level options, but ordinarily this
    // is arranged by setting the <code>forceSort</code> property for the current database
    // configuration in your <code>server.properties</code> file:<pre>
    //   # Given this database definition
    //   sql.MyDB.database.type: mysql
    //
    //   # Either of these settings will enable automatic sorting
    //   sql.MyDB.forceSort: true
    //   # Or
    //   sql.mysql.forceSort: true
    // </pre>
    // Note, the <code>defaultSortField</code> should ideally provide a unique ordering: so
    // for an employee table, payroll number would be preferable to employee name.  A
    // non-unique ordering will usually be sufficient to ensure stablity of ordering from one
    // query to the next, because it will usually ensure that the database is forced to use the
    // same index in each case.  However, the database may still choose to order rows
    // differently within the confines of the non-unique ordering, so only a unique ordering
    // is guaranteed to ensure stability.
    // <p>
    // Fields of +link{type:FieldType,type} <code>creatorTimestamp</code> are also good
    // candidates for this purpose - assuming you have a suitable index in place, and assuming
    // sorting by temporal values does not introduce performance problems with your database of
    // choice - as they are often unique or near-to-unique, and they reflect the insertion
    // order, which is the "natural ordering" in some (not all) databases.
    // <p>
    // Note that this automatic sorting does not interfere with the ordinary sorting that your
    // application may do: it is applied <i>in addition to</i> any application sort order.  So
    // if your application imposes no +link{ListGrid.setSort(),sort order}, the resultset will
    // be sorted by the <code>defaultSortField</code>; if your application requests a sort
    // order of, eg, "state" then "city", the resultset will be ordered by "state", then
    // "city", and then the <code>defaultSortField</code>
    // <p>
    // If <code>forceSort</code> is enabled and you do not provide a
    // <code>defaultSortField</code> for a given database, SmartClient will instead use the
    // +link{dataSourceField.primaryKey,primaryKey} field(s).  If the dataSource does not
    // define a <code>primaryKey</code>, we will just use the dataSource's first defined
    // field.  <b>Recommendation</b>: Unless you have a reason to explicitly declare a
    // <code>defaultSortField</code>, we recommend that you leave it undefined for any
    // DataSource that declares a <code>primaryKey</code> (and we recommend that all
    // dataSources declare a <code>primaryKey</code>).  The <code>primaryKey</code> field is
    // usually the ideal candidate for this purpose, because it is unique and almost certainly
    // indexed.
    // <p>
    // Note that <code>forceSort</code> is enabled by default for PostgreSQL, because this
    // product is known to be less likely to retain a stable sort order between two similar,
    // unordered queries.
    // <h3>DataSource- and OperationBinding-level forceSort flag</h3>
    // As well as the above-mentioned global settings, it is possible to configure automatic
    // sorting behavior for paged fetches at both the individual
    // +link{DataSource.forceSort,DataSource level} and
    // +link{OperationBinding.forceSort,operationBinding level}.  However, this facility is
    // only provided to allow complete configurability in unusual cases.  Generally speaking,
    // if a database requires ordering for correct behavior with paged fetches, it
    // <i>always</i> requires ordering for correct behavior with paged fetches; you can't
    // ordinarily pick and choose which tables or which individual fetches need to be ordered.
    // <p>
    // That said, there may be real world cases where a database that normally requires
    // ordering for correct behavior, nevertheless has individual cases where that is not
    // required - maybe on tables that have only a single index, or in cases where there are
    // no joins involved, or maybe in other circumstances related to how that specific database
    // product works internally.  Or again, there may be unusual individual cases where a
    // database that ordinarily works fine for paged fetches without requiring ordering, needs
    // to apply an ordering.
    // <p>
    // We provide the DataSource- and operation-level <code>forceSort</code> flags to allow
    // you to work around or take advantage of these database-specific quirks.  However, use of
    // them should be considered a red flag because they might cause problems if things change
    // in the future (new database release, change in the underlying query, addition of a
    // foreignKey relation at the database level, etc).
    //
    // @group serverDataIntegration
    // @requiresModules SCServer
    // @serverDS only
    // @visibility external
    //<

    //> @attr dataSource.fields (Array of DataSourceField : null : [IR])
    // The list of fields that compose records from this DataSource.
    // <P>
    // Each DataSource field can have type, user-visible title, validators, and other metadata
    // attached.
    // <smartclient>
    // <p>
    // After a DataSource has been +link{class.create,created}, access the list of fields via
    // +link{dataSource.getFieldNames()} and access individual fields via
    // +link{dataSource.getField()}.
    // </smartclient>
    //
    // @group fields
    // @see class:DataSourceField
    // @serverDS allowed
    // @visibility external
    //<

    //> @attr dataSource.inheritsFrom (DataSource ID : null : IR)
    // ID of another DataSource this DataSource inherits its +link{fields} from.
    // <P>
    // Local fields (fields defined in this DataSource) are added to inherited fields
    // to form the full set of fields.  Fields with the same name are merged in the same way
    // that +link{DataBoundComponent.fields,databound component fields} are merged with
    // DataSource fields.
    // <P>
    // The default order of the combined fields is new local fields first (including any fields
    // present in the parent DataSource which the local DataSource re-declares), then parent
    // fields.  You can set +link{useParentFieldOrder} to instead use the parent's field
    // order, with new local fields appearing last.  You can set +link{showLocalFieldsOnly} to
    // have all non-local fields hidden.
    // <P>
    // Note that <b>only fields are inherited</b> - other properties such as dataURL and
    // dataFormat are not.  You can use ordinary inheritance, that is, creating a subclass of
    // DataSource, in order to share properties such as dataURL across a series of DataSources
    // that also inherit fields from each other via <code>inheritsFrom</code>.
    // <P>
    // This feature can be used for:
    // <ul>
    // <li>creating a customized view (eg, only certain fields shown) which will be used by
    // multiple +link{DataBoundComponent,databound components}.
    // <li>adding presentation-specific attributes to metadata that has been automatically
    // derived from +link{XMLTools.loadXMLSchema,XML Schema} or other metadata formats
    // <li>modeling object subclassing and extension in server-side code and storage systems
    // <li>modeling relational database joins, and the equivalents in other systems
    // <li>creating hooks for others to customize your application in a maintainable way.  For
    // example, if you have a dataSource "employee", you can create a dataSource
    // "customizedEmployee" which inherits from "employee" but does not initially define any
    // fields, and bind all +link{DataBoundComponent,databound components} to
    // "customizedEmployee".  Customizations of fields (including appearance changes, field
    // order, new fields, hiding of fields, and custom validation rules) can be added to
    // "customizedEmployee", so that they are kept separately from the original field data and
    // have the best possible chance of working with future versions of the "employee"
    // dataSource.
    // </ul>
    //
    // @group fields
    // @serverDS allowed
    // @visibility external
    // @example schemaChaining
    //<

    //> @attr dataSource.auditedDataSourceID (String : varies : [IR])
    // For audit DataSources, this required property specifies the ID of the
    // +link{DataSource.audit,audited} DataSource.  Automatically populated for
    // +link{generateAuditDS,auto-generated} audit DataSources.
    // @serverDS only
    // @visibility external
    //<

    //> @attr dataSource.generateAuditDS (boolean : true : [IR])
    // For an +link{DataSource.audit,audited} DataSource, controls whether the Framework will
    // attempt to auto-generate the audit DataSource.  Note that this property is independent of
    // +link{auditDataSourceID} so that, by default, even when the audit DataSource is given
    // a non-default ID, the Framework will still attempt to auto-generate it.
    // @serverDS only
    // @visibility external
    //<

    //> @attr dataSource.addedAuditFields (Array of DataSourceField : null : [IR])
    // The list of extra manually managed fields that will be added to the +link{dataSource.fields} of the
    // +link{dataSource.audit,Audit DataSource}.
    // <p>
    // This feature enables the storage of additional information in the <code>Audit DataSource</code> alongside the
    // standard audit data. In order to do that the audited DataSource needs to declare +link{dataSource.auditDSConstructor}
    // referring custom +link{dataSource.serverConstructor}, so that all requests to add data to the Audit DataSource
    // could be intercepted allowing to make changes to the new records (obtained using <code>DSRequest.getValues()</code>
    // server-side API). In this particular use case values for the <code>addedAuditFields</code> need to be provided.
    // <p>
    // Example of an audited DataSource (schematically):
    // <pre>
    // &lt;DataSource audit="true" auditDSConstructor="package.AuditDS"&gt;
    // &lt;fields&gt;....&lt;/fields&gt;
    // &lt;addedAuditFields&gt;
    //      &lt;addedAuditField name="altitude" type="float" /&gt;
    //      &lt;addedAuditField name="longitude" type="float" /&gt;
    //      &lt;addedAuditField name="logCorrelationId" type="text" /&gt;
    // &lt;/addedAuditFields&gt;
    // &lt;/DataSource&gt;
    // </pre>
    // An example implementation of AuditDS could be as follows:
    // <pre>
    // public class AuditDS extends SQLDataSource {
    //     public DSResponse executeAdd(DSRequest req) throws Exception {
    //         // populate additional fields
    //         Map values = req.getValues();
    //         values.put("altitude", 54.685);
    //         values.put("longitude", 25.286);
    //         values.put("logCorrelationId", "foobar");
    //         // execute "add" request
    //         return super.executeAdd(req);
    //     }
    // }
    // </pre>
    //
    // @group fields
    // @see class:DataSourceField
    // @serverDS allowed
    // @visibility external
    //<

    //> @type DSInheritanceMode
    // For DataSources of type "sql" and "hibernate", specifies the kind of inheritance to use when a dataSource
    // specifies +link{dataSource.inheritsFrom,inheritsFrom}.
    //
    // @value "full"
    // Inherit fields by copying them onto the inheriting DataSource's underlying table.  When we
    // import a DataSource with this inheritanceMode, we create actual columns for inherited fields
    //  on the table we create.  With this inheritanceMode, inherited fields are updatable.
    //
    // @value "none"
    // Do not physically inherit fields onto the inheriting DataSource's SQL table.  Columns will
    // not be created for inherited fields on import, and all generated SQL operations will exclude
    // inherited fields.  However, those fields are still part of the DataSource's schema so you
    // can, for example, write +link{group:customQuerying,custom SQL} that returns values for
    // the inherited fields, and they will be delivered to the client.
    //
    // @group fields
    // @serverDS only
    // @visibility external
    //<




    //> @attr dataSource.inheritanceMode (DSInheritanceMode : "full" : IR)
    // For dataSources of +link{serverType,serverType} "sql" and "hibernate", specifies the inheritance
    // mode to use.  This property has no effect for any other type of DataSource.
    //
    // @see dataSource.inheritsFrom
    // @group fields
    // @serverDS only
    // @visibility external
    //<


    //> @attr dataSource.sequenceMode         (SequenceMode : "native" : [IR])
    // For fields of +link{dataSourceField.type,type} "sequence" in a dataSource of
    // +link{DataSource.serverType,serverType} "sql", indicates the
    // +link{type:SequenceMode} to use.  This property has no effect for fields or dataSources of
    // other types.
    // <p>
    // You can set a default sequenceMode for all DataSources of a given database type by setting
    // property "sql.{database_type}.default.sequence.mode" in <code>server.properties</code>.
    // You set a global default sequenceMode that applies to all database types by setting property
    // "sql.default.sequence.mode".  For example:<pre>
    //   sql.mysql.default.sequence.mode: jdbcDriver
    // </pre>
    // <P>
    //
    // @serverDS only
    // @visibility external
    //<

    //> @type SequenceMode
    // The possible types of sequence handling SmartClient Server can apply.  This refers to the
    // technique used to obtain the primary keys of the most recent insert, which the product
    // uses to enable +link{group:cacheSynchronization,automatic cache synchronization}
    // (updating client-side components bound to a dataSource to reflect updates to that
    // dataSource).  Only applicable to +link{class:DataSourceField,fields} of
    // +link{type:FieldType,type} "sequence".
    // <P>
    // @value "jdbcDriver" Use the JDBC 3.0 API "getGeneratedKeys()" to get the most recent
    //                     sequence value.  Obviously, this is only an option for JDBC 3.0+ drivers.
    //                     <b>NOTE: Oracle special case</b> The Oracle JDBC driver provides a
    //                     "getGeneratedKeys" method, but that method does not actually return
    //                     the generated key values; instead, it returns a ROWID, which we must
    //                     use to fetch the inserted row, and obtain the generated key values
    //                     from it.  For this reason, you may find that "native" is slightly
    //                     faster to retrieve sequence values than "jdbcDriver" with Oracle (or
    //                     you may find that it makes no noticeable difference; it depends on
    //                     too many factors for us to give a concrete recommendation)

    //
    // @value "native"     Use a database-specific native technique to obtain the most recent
    //                     sequence value.  The actual technique used varies widely depending on
    //                     the vagaries of the underlying database (and sometimes the vagaries of
    //                     particular releases of a database product)
    // @value "none"       No automatic attempt is made to retrieve the most recent sequence value.
    //                     You are expected to handle this by providing a
    //                     +link{operationBinding.cacheSyncOperation,cacheSyncOperation} that is
    //                     able to return the entire row without needing generated PK values for
    //                     context. For example, a query that uses <code>MAX(pk)</code> would be
    //                     capable of this.  To give a more complex example, say you have a
    //                     sequence value that is retrieved from a legacy system: you could store
    //                     that sequence value in the HTTP session and then have your custom
    //                     <code>cacheSyncOperation</code> reference that session attribute in
    //                     its <code>WHERE</code> clause.  Also note that cacheSyncOperations,
    //                     like any other +link{class:OperationBinding,DataSource operation},
    //                     can be +link{operationBinding.serverObject,written in Java} or any
    //                     +link{operationBinding.script,JSR223-compliant scripting language} -
    //                     you do not have to use SQL
    // @serverDS only
    // @visibility external
    //<

    //> @attr dataSource.useSequences (Boolean : null : IR)
    // For a DataSource with +link{dataSource.serverType,serverType:"sql"}, this flag indicates
    // whether any fields of +link{DataSourceField.type,type} "sequence" should be backed by a
    // native database sequence (if the flag is true) or an auto-increment/identity column (if
    // it is false).  It is only applicable in cases where the database in use supports both
    // approaches, <i>and</i> SmartClient supports both strategies with that particular database.
    // For most databases, even those that natively support either approach, SmartClient uses
    // one or the other, and this cannot be configured.
    // <P>
    // Right now, the only supported database is Microsoft SQL Server.  If you specify this flag
    // on a non-SQL DataSource or if any database other than SQL Server is in use, the flag is
    // simply ignored.
    // <P>
    // If not set, this flag defaults to the <code>server.properties</code> setting
    // <code>sql.{dbName}.use.sequences</code>, which in turn defaults to false.
    //
    // @serverDS only
    // @visibility external
    //<

    //> @attr dataSource.useFlatFields (Boolean : null : IR)
    // Like +link{dataBoundComponent.useFlatFields}, but applies to all DataBound components
    // that bind to this DataSource.
    //
    // @group fields
    // @serverDS allowed
    // @visibility external
    //<

    //> @attr dataSource.showLocalFieldsOnly (boolean : null : IR)
    // For a DataSource that inherits +link{fields} from another DataSource
    // (via +link{inheritsFrom}), indicates that only the fields listed in this DataSource
    // should be shown.  All other inherited parent fields will be marked "hidden:true".
    //
    // @group fields
    // @serverDS allowed
    // @visibility external
    //<

    //> @attr dataSource.useParentFieldOrder (boolean : null : IR)
    // For a DataSource that inherits +link{fields} from another DataSource
    // (via +link{inheritsFrom}), indicates that the parent's field order should be used
    // instead of the order of the fields as declared in this DataSource.  New fields, if any,
    // are placed at the end.
    //
    // @group fields
    // @serverDS allowed
    // @visibility external
    // @example schemaChaining
    //<

    //> @attr dataSource.dropExtraFields     (boolean : null : IR)
    // Indicates that for server responses, for any data being interpreted as DataSource records,
    // only data that
    // corresponds to declared fields should be retained; any extra fields should be discarded.
    // <P>
    // For +link{DataSource.dataFormat,JSON} data, this means extra properties in selected
    // objects are dropped.
    // <P>
    // By default, for DMI DSResponses, DSResponse.data is filtered on the server to just
    // the set of fields defined on the DataSource (see the overview in +link{group:dmiOverview,DMI}).
    // <P>
    // This type of filtering can also be enabled for non-DMI DSResponses. By default it is enabled
    // for Hibernate and JPA datasources to avoid unintentional lazy loading too much of a data model.
    // For the rest of datasources this is disabled by default.
    // <P>
    // Explicitly setting this property to <code>false</code> disables (or to <code>true</code> enables)
    // this filtering for this DataSource only. This setting
    // overrides the configuration in +link{group:server_properties,server.properties}. This setting can
    // be overridden by +link{ServerObject.dropExtraFields}.
    //
    // @group clientDataIntegration
    // @serverDS allowed
    // @visibility external
    //<

    //> @attr dataSource.sendExtraFields     (Boolean : true : IR)
    // Analogous to +link{dataSource.dropExtraFields}, for data sent to the server.  Setting this
    // attribute to false ensures that for any records in the data object, only fields that
    // correspond to declared dataSource fields will be present on the dsRequest data object passed
    // to +link{dataSource.transformRequest()} and ultimately sent to the server.
    //
    // @group clientDataIntegration
    // @serverDS allowed
    // @visibility external
    //<
    sendExtraFields:true,

    //> @attr dataSource.autoDeriveSchema (boolean : null : IR)
    // This property allows you to specify that your DataSource's schema (field definitions) should
    // be automatically derived from some kind of metadata.  This causes SmartClient to create
    // a special super-DataSource, which is used purely as a source of default schema for this
    // DataSource; this is arranged by causing the autoDerived DataSource to automatically
    // +link{inheritsFrom,inherit from} the special super-DataSource.  This allows you to
    // auto-derive schema from existing metadata, whilst still being able to override any or all
    // of it as required. By default additional derived field definitions are placed at the end,
    // but that can be changed by +link{dataSource.useParentFieldOrder} flag. Also, derived field
    // definitions may be hidden using +link{dataSource.showLocalFieldsOnly}.<p>
    // This property has a different implementation depending upon the
    // +link{dataSource.serverType,serverType} of the DataSource:<ul>
    // <li>For a DataSource with serverType: "sql", automatically derive the dataSource's schema
    // from the Spring bean or Java class specified in +link{schemaBean,schemaBean}.  If
    // <code>schemaBean</code> is not specified, derive the schema from the columns in the SQL
    // table specified in +link{tableName,tableName}.  More information on SQL DataSources
    // is +link{group:sqlDataSource,here}</li>
    // <li>For a DataSource with serverType: "hibernate", automatically derive the dataSource's
    // schema from the Spring bean, Hibernate mapping or Java class named in the
    // +link{schemaBean,schemaBean} property.  If no such thing exists, derive the schema from
    // the Hibernate mapping or Java class specified in the +link{beanClassName,beanClassName}
    // property (this allows you to specify schema and mapping separately, in the unusual
    // circumstance that you have a need to do so).  Note that the "mappings" referred to here
    // can mean either <code>.hbm.xml</code> files or annotated classes; both are supported.
    // If neither of these is successful, derive the schema from the underlying SQL table
    // specified in +link{tableName,tableName}.  More information on Hibernate DataSources is
    // +link{group:hibernateIntegration,here}</li>
    // <li>For a DataSource with serverType: "jpa1" or "jpa", automatically derive the
    // dataSource's schema from the annotated JPA class named in the +link{schemaBean,schemaBean}
    // property.  If the schemaBean property is not defined, derive the schema from the
    // annotated JPA class named in the +link{beanClassName,beanClassName} property (as with
    // Hibernate, this allows you to specify schema and mapping separately if you need to do
    // so).  JPA DataSource generation relies on annotations (the orm.xml mapping file is not
    // supported).  More information on JPA DataSources is +link{group:jpaIntegration,here}</li>
    // <li>For other DataSource types, attempt to find a Spring bean with the name specified in
    // the +link{schemaBean,schemaBean} property.  If no such bean is found (or Spring is not
    // present), attempt to instantiate an object whose fully-qualified class name is the value
    // in the <code>schemaBean</code> property.  If one of these approaches succeeds, we derive
    // the schema from the discovered object (by treating it as a Java Bean and assuming that
    // each one of its getters corresponds to a like-named field in the DataSource).  More
    // information on custom DataSource implementations is +link{group:writeCustomDataSource,here}.</li>
    // </ul>
    // Note that when dataSource schema is derived by introspecting the Java class or Spring bean the
    // derived fields are sorted alphabetically, but with +link{dataSourceField.primaryKey,primary key}
    // fields at the top.
    // <h4>Field types</h4>
    // The following table shows how SQL types are derived into
    // +link{type:FieldType,DataSource types} when we use an SQL table as a source of metadata
    // for a SQL or Hibernate DataSource:
    // <table border="1" class="normal">
    // <tr><th>SQL type</th><th>+link{attr:DataSourceField.type,DataSource type}</th></tr>
    // <tr><td>CHAR, VARCHAR, LONGVARCHAR, TEXT, CLOB</td><td>text</td></tr>
    // <tr><td>BIT, TINYINT, SMALLINT, INTEGER, BIGINT, DECIMAL<sup>*</sup>, NUMBER<sup>**</sup></td><td>integer</td></tr>
    // <tr><td>REAL, FLOAT, DOUBLE, DECIMAL<sup>*</sup>, NUMBER<sup>**</sup></td><td>float</td></tr>
    // <tr><td>DATE</td><td>date</td></tr>
    // <tr><td>TIME</td><td>time</td></tr>
    // <tr><td>TIMESTAMP</td><td>datetime</td></tr>
    // <tr><td>BLOB, BINARY, VARBINARY, LONGVARBINARY</td><td>binary</td></tr>
    // </table>
    // <sup>*</sup>For DECIMAL types, we inspect the "DECIMAL_DIGITS" attribute of the JDBC
    // metadata and designate the field type "integer" if that attribute is 0, or "float" if
    // it is some other value.<br>
    // <sup>**</sup>NUMBER is an Oracle-only type that appears in the JDBC metadata as DECIMAL
    // and is handled exactly the same way as DECIMAL
    // <p>
    // The following table shows how Java types are derived into DataSource types when we use
    // an unannotated Java class (Spring bean, Hibernate mapping or POJO) as a source of
    // metadata for a SQL, Hibernate or custom DataSource:
    // <table border="1" class="normal">
    // <tr><th>Java type</th><th>+link{attr:DataSourceField.type,DataSource type}</th></tr>
    // <tr><td>boolean, Boolean</td><td>boolean</td></tr>
    // <tr><td>char, Character, String, Reader</td><td>text</td></tr>
    // <tr><td>byte, short, int, long, Byte, Short, Integer, Long, BigInteger</td><td>integer</td></tr>
    // <tr><td>float, double, Float, Double, BigDecimal</td><td>float</td></tr>
    // <tr><td>Enum</td><td>enum (see discussion below)</td></tr>
    // <tr><td>InputStream</td><td>binary</td></tr>
    // <tr><td>java.sql.Date, java.util.Date, java.util.Calendar</td><td>date</td></tr>
    // <tr><td>java.sql.Time</td><td>time</td></tr>
    // <tr><td>java.sql.Timestamp</td><td>datetime</td></tr>
    // </table>
    // <p>
    // Finally, this table shows how Java types are derived into DataSource types when we use an
    // annotated class as a source of metadata.  Note annotated classes are necessary for JPA
    // DataSources, but you can choose to use them for other types of DataSource as well.
    // For Hibernate DataSources, this is very worthwhile because Hibernate will also make use
    // of the annotations as config, meaning you don't need to specify <code>.hbm.xml</code>
    // files.  For SQL and custom DataSources, there is no benefit at the persistence level,
    // but it may still be worthwhile because the use of an annotated class gives us better
    // metadata and allows us to generate a better, closer-fitting autoDerive DataSource than
    // we can from examination of SQL schema or plain Java Beans:
    // <table border="1" class="normal">
    // <tr><th>Java type</th><th>+link{attr:DataSourceField.type,DataSource type}</th></tr>
    // <tr><td>boolean, Boolean</td><td>boolean</td></tr>
    // <tr><td>char, Character, String, Reader</td><td>text</td></tr>
    // <tr><td>byte, short, int, long, Byte, Short, Integer, Long, BigInteger</td><td>integer</td></tr>
    // <tr><td>float, double, Float, Double, BigDecimal</td><td>float</td></tr>
    // <tr><td>InputStream</td><td>binary</td></tr>
    // <tr><td>java.util.Date (with Temporal set to DATE), java.sql.Date</td><td>date</td></tr>
    // <tr><td>java.util.Date (with Temporal set to TIME), java.sql.Time</td><td>time</td></tr>
    // <tr><td>java.util.Date (with Temporal set to TIMESTAMP), java.util.Calendar, java.sql.Timestamp</td><td>datetime</td></tr>
    // <tr><td>Enum (with Enumerated set to STRING)</td><td>enum (see discussion below)</td></tr>
    // <tr><td>Enum (with Enumerated set to ORDINAL)</td><td>intEnum (see discussion below)</td></tr>
    // <tr><td>Field with Lob annotation</td><td>binary</td></tr>
    // <tr><td>Field with GeneratedValue annotation</td><td>sequence, if the field is an integer type (see discussion below)</td></tr>
    // </table>
    // <p>
    // <h4>Primary keys, sequences and identity columns</h4>
    // We attempt to derive information about primary keys from the metadata we have.
    // <p>
    // If the metadata source is an SQL table:
    // <ul>
    // <li>If the table does not have a native primary key constraint, no attempt is made to
    //     identify primary key fields.  Otherwise:
    // <li>The column or columns that make up the table's native primary key constraint are
    //     identified using the JDBC <code>DatabaseMetaData.getPrimaryKeys()</code> API</li>
    // <li>Each DataSource field that corresponds to one of these native primary key columns
    //     is marked <code>primaryKey: true</code></li>
    // <li>For each of these columns, the metadata returned by
    //     <code>DatabaseMetaData.getColumns()</code> is inspected.  If the metadata includes
    //     <code>IS_AUTOINCREMENT=YES</code>, we mark the corresponding field as
    //     <code>type="sequence"</code>.  This information should be reliably provided by
    //     databases that implement "auto-increment" or "identity" column types, such as MySQL
    //     or Microsoft SQL Server</li>
    // <li>If the previous step does not identify a column as a sequence, we inspect the
    //     <code>ResultSetMetaData</code> obtained by running a dummy query on the table.  If
    //     the <code>isAutoIncrement()</code> API returns true for that column, we mark the
    //     corresponding field as <code>type="sequence"</code></li>
    // <li>If the previous steps have not identified the column as a sequence, we check the
    //     <code>TYPE_NAME</code> in the column metadata.  If it is "serial", this means the
    //     column is a PostgreSQL "serial" or "serial8" type column.  Postgres does not
    //     transparently implement auto-increment columns, but it does provide this serial
    //     type, which causes the column to be implicitly bound to an underlying sequence.  So
    //     this type causes us to mark the field <code>type="sequence"</code>, and we also set
    //     +link{dataSourceField.implicitSequence,implicitSequence} true</li>
    // <li>If the previous steps have not identified the column as a sequence, we check the
    //     <code>COLUMN_DEF</code> in the column metadata.  If this contains the token "$$ISEQ"
    //     and ends with "NEXTVAL", this means the column is an Oracle "GENERATED AS IDENTITY"
    //     column.  This type of column was introduced in Oracle 12c and is conceptually
    //     exactly the same thing as the Postgres "serial" column described above.  We treat
    //     it the same way: mark it <code>type="sequence"</code> and
    //     <code>implicitSequence="true"</code></li>
    // <li>If the previous steps have not identified the column as a sequence, then you may
    //     be using a pure sequence database, such as an Oracle version earlier than 12c, or
    //     you may be using a database where both sequences and identity columns are available
    //     (Oracle, Postgres, DB2), and a sequence is being used either by design or because
    //     the table was created before the database product supported identity columns.  In
    //     this case, we cannot determine if the column should be a sequence or not.  However,
    //     in many applications, the fact that the column is an integer and is a primary key
    //     would imply that it is also a sequence.  Therefore, if the column is an integer and
    //     the <code>server.properties</code> flag <code>auto.derive.integer.pk.always.sequence</code>
    //     is true, we mark the field as <code>type="sequence"</code></li>
    // <li>If, after all this, SmartClient ends up incorrectly marking a primary key field as
    //     a sequence (or vice versa), you can always override it on a per-field basis by
    //     simply redeclaring the field with the correct type in your <code>.ds.xml</code>
    //     file:<pre>
    //  &lt;DataSource serverType="sql" tableName="myTable" autoDeriveSchema="true"&gt;
    //    &lt;fields&gt;
    //      &lt;!-- This field was incorrectly marked as a sequence --&gt;
    //      &lt;field name="notASeq" type="integer" /&gt;
    //      &lt;!-- This field was incorrectly marked as an integer when it should be a sequence --&gt;
    //      &lt;field name="isASeq" type="sequence" /&gt;
    //    &lt;/fields&gt;
    //  &lt;/DataSource&gt;</pre></li>
    // </ul>
    // <p>
    // If the metadata source is Hibernate mappings described in a <code>.hbm.xml</code> file:
    // <ul>
    // <li>The first field we encounter that is described in the mapping with an &lt;id&gt; tag
    //     is marked as a primaryKey</li>
    // <li>If that field is marked as being generated, we set its type to "sequence"</li>
    // </ul>
    // <p>
    // If the metadata source is an annotated object (whether JPA, Hibernate or just an
    // annotated POJO):
    // <ul>
    // <li>Any field with an <code>@Id</code> annotation is is marked as a primaryKey (this
    //     differs from the Hibernate <code>.hbm.xml</code> file case because that is specific
    //     to Hibernate, which does support composite keys, but not by specifying multiple
    //     &lt;id&gt; tags.  Annotations are supported, via annotated POJOs, for any kind of
    //     persistence strategy, so multiple <code>@Id</code> fields are perfectly valid)</li>
    // <li>Any field with a <code>@GeneratedValue</code> annotation is either marked as
    //     <code>type="sequence"</code> (if it is an integer type) or as
    //     <code>+link{dataSourceField.autoGenerated,autoGenerated}="true"</code> (for other
    //     field types)</li>
    // </ul>
    // Finally, if the metadata is a plain, unannotated Java object, no attempt is made to
    // derive primary key fields.
    // <h4>enums and valueMaps</h4>
    // When we come across Java <code>Enum</code> properties in plain or annotated classes,
    // as well as setting the field type as noted in the above tables, we also generate a
    // valueMap for the field, based on the <code>Enum</code> members.
    // <p>
    // For cases where we generate a field of SmartClient type "enum" (see the above tables),
    // the keys of the valueMap are the result of calling <code>name()</code> on each member
    // of the underlying Java Enum (in other words, its value exactly as declared in its
    // enum declaration).  For cases where we generate a field of SmartClient type "intEnum",
    // the keys of the valueMap are strings representing the ordinal number of each member
    // in the Java Enum - "0", "1", etc. Note that this behavior will be overriden by
    // +link{attr:DataSource.enumTranslateStrategy,DataSource.enumTranslateStrategy} if both are set.
    // <p>
    // In both of these case, the display values generated for the valueMap are the result
    // of calling <code>toString()</code> on each Enum member.  If that gives the same
    // value as calling <code>name()</code>, the value is passed through
    // <code>DataTools.deriveTitleFromName()</code>, which applies the same processing rules
    // as +link{classMethod:DataSource.getAutoTitle()} to derive a more user-friendly display value.
    // <h4>Further notes</h4>
    // <code>schemaBean</code> implies <code>autoDeriveSchema</code>, because it has no other
    // purpose than to name the bean to use for auto-derived schema.  Thus, if you specify
    // <code>schemaBean</code> you do not need to specify <code>autoDeriveSchema</code> as well
    // (though it does no harm to do so).  However, <code>tableName</code> and
    // <code>beanClassName</code> can be validly specified without implying
    // <code>autoDeriveSchema</code>, so in those cases you must explicitly specify
    // <code>autoDeriveSchema</code>.
    // <p>
    // The underlying super-DataSource is cached in server memory, so that it does
    // not have to be derived and created each time you need it.  However, the cache manager
    // will automatically refresh the cached copy if it detects that the deriving DataSource
    // has changed.  Thus, if you change the metadata your DataSource is deriving (if, for
    // example, you add a column to a table), all you need to do is touch the
    // <code>.ds.xml</code> file (ie, update its last changed timestamp - you don't actually
    // have to change it) and the cached copy will be refreshed next time it is needed.
    // <p>
    // When autoDeriveSchema is set, SQLDataSource will automatically discover foreignKeys and
    // deliver table and column name information to the client in hashed form so that two
    // DataSources that are linked by native SQL foreign keys will automatically discover each
    // other if loaded into the same application, and set
    // +link{dataSourceField.foreignKey,foreignKey} automatically.  Because the table and column
    // names are delivered as cryptohashes, there is no information leakage, but regardless,
    // the feature can be disabled via setting <code>datasource.autoLinkFKs</code> to false in
    // +link{group:server_properties,server.properties}.  This hashed linkage information is
    // delivered to the client in properties +link{dataSource.tableCode} and
    // +link{dataSourceField.fkTableCode}/+link{dataSourceField.fkColumnCode,fkColumnCode}
    //
    // @group fields
    // @serverDS only
    // @visibility external
    //<

    //> @attr dataSource.schemaBean (String : null : IR)
    // For DataSources that specify +link{autoDeriveSchema}, this property indicates the name
    // of the Spring bean, Hibernate mapping or fully-qualified Java class to use as parent
    // schema.
    //
    // @see autoDeriveSchema
    // @group fields
    // @serverDS only
    // @visibility external
    //<

    //> @attr dataSource.idClassName (String : null : IR)
    // For JPA and Hibernate DataSources this property indicates, that data source has composite primary key and
    // specifies fully-qualified Java class:<ul>
    // <li>with <b><code>@EmbeddedId</code></b> you have to specify class name of declared id</li>
    // <li>with <b><code>@IdClass</code></b> you have to specify class specified in annotation declaration</li></ul>
    //
    // @group fields
    // @serverDS only
    // @visibility external
    //<

    //> @attr dataSource.patternSingleWildcard (String | Array of String : ["?","%"] : IR)
    // When using the +link{group:patternOperators,pattern operators} +link{type:OperatorId,search operator},
    // character that matches any single character.
    // <p>
    // Pass multiple strings to provide multiple alternative wildcards.
    // @visibility external
    //<
    patternSingleWildcard: ["?","%"],

    //> @attr dataSource.patternMultiWildcard (String | Array of String : "*" : IR)
    // When using the +link{group:patternOperators,pattern operators} +link{type:OperatorId,search operator},
    // character that matches a series of one or more characters.
    // <p>
    // Pass multiple strings to provide multiple alternative wildcards.
    // @visibility external
    //<
    patternMultiWildcard: "*",

    //> @attr dataSource.patternEscapeChar (String : "\" : IR)
    // When using the +link{group:patternOperators,pattern operators} +link{type:OperatorId,search operator},
    // character that escapes the +link{patternSingleWildcard} or +link{patternMultiWildcard} if placed before
    // it, so that it is treated as a literal character.
    // @visibility external
    //<
    patternEscapeChar: "\\",

    //> @groupDef patternOperators
    // The +link{type:OperatorId,search operators}
    // use patterns like "foo*txt" to match text values.  The patterns are similar to the patterns you use to
    // match names of files in a command-line interface, or to the pattern allowed for the SQL
    // "LIKE" operator.
    // The supported search operators are:
    //  <ul>
    //      <li>"matchesPattern" Basic GLOB matching using wildcards.</li>
    //      <li>"iMatchesPattern" Basic GLOB matching using wildcards (case insensitive).</li>
    //      <li>"containsPattern" GLOB matching using wildcards. Value is considered to meet the
    //        criterion if it contains the pattern. </li>
    //      <li>"startsWithPattern" GLOB matching using wildcards. Value is considered to meet the
    //        criterion if it starts with the pattern.</li>
    //      <li>"endsWithPattern" GLOB matching using wildcards. Value is considered to meet the
    //        criterion if it starts with the pattern.</li>
    //      <li>"iContainsPattern" GLOB matching using wildcards. Value is considered to meet the
    //        criterion if it contains the pattern. Matching is case insensitive. </li>
    //      <li>"iStartsWithPattern" GLOB matching using wildcards. Value is considered to meet the
    //        criterion if it starts with the pattern.  Matching is case insensitive.</li>
    //      <li>"iEndsWithPattern" GLOB matching using wildcards.Value is considered to meet the
    //        criterion if it ends with the pattern. Matching is case insensitive.</li>
    //  </ul>
    //
    // See +link{DataSource.translatePatternOperators} for more information on available patterns)
    //
    // @visibility external
    //<

    //> @attr dataSource.translatePatternOperators (boolean : false : IR)
    // +link{type:OperatorId,Search operators} like "matchesPattern" use patterns like
    // "foo*txt" to match text values.  The patterns are similar to the patterns you use to
    // match names of files in a command-line interface, or to the pattern allowed for the SQL
    // "LIKE" operator.
    // <p>
    // <code>translatePatternOperators</code> controls whether these pattern operators should
    // be translated to a nested series of "startsWith"/"endsWidth"/"contains" operators before
    // being sent to the server.  This allows a server that only implements simple operators
    // like "startsWith" to support pattern operators such as "matchesPattern" and
    // "containsPattern", but with caveats:
    //    <ul>
    //        <li> single-character wildcards are not supported
    //        <li> multiple wildcards are not truly order-dependent, for example *1*2*3* will
    //             match 1,2,3 as interior characters in any order.
    //        <li> may be less efficient than a direct server-side implementation that is able to
    //             translate the pattern directly to the underlying storage engine.
    //    </ul>
    // <p>
    // Note that since "containsPattern" is essentially equivalent to "matchesPattern" but with
    // "*" wildcards at the beginning and end of every pattern, the second limitation (pattern
    // not really order dependent) may be fairly obvious to users when using this feature.  For
    // example, "m*t" will match "we meet" and "we teem".
    // <p>
    // The following are examples of how patterns are translated to simpler operators.  Note
    // that the case sensitive version of the operator is referred to below, but of course
    // "iMatchesPattern" and "iContainsPattern" will be translated to case-insensitive versions
    // of these operators, such as "iStartsWith".
    // <p>
    // *foo (endsWith)<br>
    // foo* (startsWith)<br>
    // *foo* (contains)<br>
    // *foo*bar (contains and endsWith)<br>
    // foo*bar* (startsWith and contains)<br>
    // foo*bar (startsWith and endsWith)<br>
    // *foo*bar* (multiple contains)
    // <p>
    // Also supported: one startsWith, multiple contains, one endsWith.
    // @visibility external
    //<
    translatePatternOperators: false,

    // XML
    // ---------------------------------------------------------------------------------------

    //> @attr dataSource.xmlNamespaces (Object : See below : IR)
    // Sets the XML namespace prefixes available for XPaths on a DataSource-wide basied.  See
    // +link{operationBinding.xmlNamespaces} for details.
    //
    // @group clientDataIntegration
    // @serverDS allowed
    // @visibility xmlBinding
    //<

    //> @attr dataSource.serviceNamespace (URN : null : IR)
    // For an XML DataSource, URN of the WebService to use to invoke operations.  This URN
    // comes from the "targetNamespace" attribute of the &lt;wsdl:definitions&gt; element in a
    // WSDL (Web Service Description Language) document, and serves as the unique identifier of
    // the service.
    // <P>
    // Having loaded a WebService using +link{XMLTools.loadWSDL()}, setting
    // <code>serviceNamespace</code> combined with specifying
    // +link{class:OperationBinding,operationBindings}
    // that set +link{attr:operationBinding.wsOperation} will cause a DataSource to invoke web
    // service operations to fulfill DataSource requests (+link{class:DSRequest,DSRequests}).
    // <P>
    // Setting <code>serviceNamespace</code> also defaults
    // +link{DataSource.dataURL,dataURL} to the service's location,
    // +link{DataSource.dataFormat,dataFormat} to "xml" and
    // +link{operationBinding.dataProtocol,dataProtocol} to "soap".
    //
    // @group wsdlBinding
    // @group clientDataIntegration
    // @serverDS allowed
    // @visibility xmlBinding
    //<

    //> @attr dataSource.schemaNamespace (URN : null : R)
    // For a DataSource derived from WSDL or XML schema, the XML namespace this schema belongs
    // to.  This is a read-only attribute automatically present on DataSources returned from
    // +link{schemaSet.getSchema()} and +link{webService.getSchema()}.
    //
    // @group wsdlBinding
    // @group clientDataIntegration
    // @serverDS allowed
    // @visibility xmlBinding
    //<

    //> @attr dataSource.recordXPath          (XPathExpression : null : [IR])
    // See +link{attr:operationBinding.recordXPath}.  <code>recordXPath</code> can be specified
    // directly on the DataSource for a simple read-only DataSource only capable of "fetch"
    // operations, <release13>or </release13>on clientOnly DataSources using
    // +link{group:testData}<release14>, or on +link{group:serverRestConnector,RestConnector}
    // dataSources</release14>
    //
    // @group clientDataIntegration
    // @serverDS allowed
    // @visibility xmlBinding
    // @example xmlDataSource
    // @example jsonXPath
    //<

    //> @attr dataSource.dataURL              (URL : null : [IR])
    // Default URL to contact to fulfill all DSRequests.  Can also be set on a
    // per-operationType basis via +link{attr:operationBinding.dataURL}.
    // <P>
    // NOTE: Best practice is to use the same <code>dataURL</code> for all DataSources which
    // fulfill DSRequests via the server-side RPCManager API.  Otherwise, cross-DataSource
    // +link{RPCManager.startQueue(),operation queuing} will not be possible.
    //>ISC_140
    // <h3>dataURL and +link{group:serverRestConnector,RestConnector}</h3>
    // <code>dataURL</code> is also used to configure the address of the target REST server
    // for a <code>RestConnector</code> DataSource.  Typically this is done at the
    // +link{attr:operationBinding.dataURL,operationBinding level}, because the URLs of REST
    // services often encode things about the service itself, like whether it is a fetch or an
    // update.  However, if your REST service does use the same URL for every service, or most
    // services, you can configure it here at the DataSource level.
    // <p>
    // As discussed in the +link{group:serverRestConnector,RestConnector overview}, many elements
    // of <code>RestConnector</code> config can be Velocity templates, and <code>dataURL</code>
    // is one such element.  For example:<pre>
    //   &lt;operationBinding operationType="fetch" operationId="fetchByPK"&gt;
    //       &lt;dataURL&gt;$config['rest.server.base.url']/fetch/$criteria.pk&lt;/dataURL&gt;
    //   &lt;/operationBinding&gt;</pre>
    // <b>NOTE:</b> Because the server-side <code>RestConnector</code> implementation
    // uses the <code>dataURL</code> property to configure the address of the target REST
    // server, and that property also has meaning on the client, if you are using a
    // <code>RestConnector</code> DataSource, you should specify the <code>dataURL</code> of
    // the target REST server inside the +link{dataSource.serverConfig,serverConfig} block
    //<ISC_140
    //
    // @group clientDataIntegration
    // @serverDS allowed
    // @visibility xmlBinding
    // @example jsonDataSource
    //<

    //> @attr dataSource.tagName             (String : null : IRA)
    // Tag name to use when serializing to XML.  If unspecified, the <code>dataSource.ID</code>
    // will be used.
    // @group clientDataIntegration
    // @serverDS allowed
    // @visibility xmlBinding
    //<


    //> @attr dataSource.useOfflineStorage (boolean : null : IRW)
    // Whether we store server responses for this DataSource into
    // +link{class:Offline,browser-based offline storage}, and then use those stored responses
    // at a later time if we are offline (ie, the application cannot connect to the server).
    // Note that by default we do NOT use offline storage for a dataSource.
    // @serverDS allowed
    // @group offlineGroup
    // @visibility external
    //<



// whether to transform XML responses to JS automatically, such that the client-side DSResponse
// is a JS object (whether the transform was performed on client or server is intended to be an
// implementation detail).
// At the moment 2005.7.5, some components can work directly with XML objects (eg read-only,
// selectable ListGrid), some can't.  Server XML->JS transform will always speed up the client.
// Aside from features that don't yet work with XML object, client XML->JS transform is a
// tradeoff between initial load vs later access time.
transformResponseToJS:true,

// whether this DataSource can queue requests to be submitted as a batch
supportsRequestQueuing: true,

// start value for sequence fields
firstGeneratedSequenceValue: 0,

    // Client Only DataSources
    // ----------------------------------------------------------------------------------------
    //> @attr dataSource.clientOnly     (Boolean : false : [IR])
    // A clientOnly DataSource simulates the behavior of a remote data store by manipulating a
    // static dataset in memory as +link{DSRequest,DSRequests} are executed on it.  Any changes
    // are lost when the user reloads the page or navigates away.
    // <P>
    // A clientOnly DataSource will return responses asynchronously, just as a DataSource
    // accessing remote data does.  This allows a clientOnly DataSource to be used as a
    // temporary placeholder while a real DataSource is being implemented - if a clientOnly
    // DataSource is replaced by a DataSource that accesses a remote data store, UI code for
    // components that used the clientOnly DataSource will not need be changed.
    // <P>
    // A clientOnly DataSource can also be used as a shared cache of modifiable data across
    // multiple UI components when immediate saving is not desirable.  In this case, several
    // components may interact with a clientOnly DataSource and get the benefit of
    // +link{ResultSet} behaviors such as automatic cache sync and in-browser data filtering
    // and sorting.  When it's finally time to save, +link{dataSource.cacheData} can be
    // inspected for changes and data can be saved to the original DataSource via
    // +link{addData()}, +link{updateData()} and +link{removeData()}, possibly in a
    // +link{rpcManager.startQueue,transactional queue}.  Note that
    // +link{DataSource.getClientOnlyDataSource()} lets you easily obtain a
    // <code>clientOnly</code> DataSource representing a subset of the data available from a
    // normal DataSource.
    // <P>
    // See also +link{cacheAllData} - a <code>cacheAllData</code> behaves like a write-through
    // cache, performing fetch and filter operations locally while still performing remote save
    // operations immediately.
    // <P>
    // ClientOnly DataSources can be populated programmatically via +link{cacheData} - see
    // +link{group:clientOnlyDataSources,this discussion} for other ways to populate a
    // client-only DataSource with data.
    //
    // @group clientOnlyDataSources
    // @serverDS allowed
    // @visibility external
    // @example localDataSource
    //<
    //clientOnly: false,

    // in clientOnly mode, whether to shallow copy results to more fully simulate a server.
    // This allows separate changes to be made to the "server data set" (testData) and
    // ResultSet caches.
    copyLocalResults:true,
    // Also support a mode where we explicitly clone the local-data. This will recursively
    // clone sub-objects. Off by default - not usually necessary and a little risky as
    // data may have references to non-serializable objects.
    deepCopyLocalResults:false,

    // Mock mode
    // ----------------------------------------------------------------------------------------

    //> @attr dataSource.mockMode (Boolean : null : IRW)
    // If set, causes this DataSource to use a read-only "mock" or "test" dataset, if specified, or if no test
    // data is available, then to load data normally but then operate similarly to a +link{clientOnly}
    // DataSource, never writing changes back to the server.
    // <p>
    // <code>mockMode</code> has no effect on +link{MockDataSource} or a +link{clientOnly} DataSource.
    // <p>
    // For other DataSources, a one-time fetch will be performed to retrieve sample data, similar to a
    // +link{cacheAllData} DataSource, except that changes will never be saved back to the server.  Only a
    // subset of data will be retrieved, based on +link{mockDataRows}.  +link{mockDataCriteria} can optionally
    // be set to retrieve specific data.
    // <p>
    // Alternatively, mock data can be provided with +link{cacheData}.
    // <p>
    // DataSources can be loaded in <code>mockMode</code> via passing settings to +link{DataSource.load()}, or
    // if loaded with a screen or project, by passing settings to +link{RPCManager.loadScreen()} or
    // the server-side Project.load() API.
    //
    // @visibility external
    //<

    //> @attr dataSource.mockDataRows (Integer : 75 : IR)
    // When +link{mockMode} is enabled, number of rows of data to retrieve via an initial "fetch" DSRequest, for
    // use as sample data.  Set to null to retrieve all available rows.
    // @serverDS allowed
    //
    // @visibility external
    //<
    mockDataRows:75,

    //> @attr dataSource.mockDataCriteria (Criteria : null : IR)
    // When +link{mockMode} is enabled, criteria to use in an initial "fetch" DSRequest to retrieve sample data.
    // @serverDS allowed
    //
    // @visibility external
    //<

    // Filtering
    // ----------------------------------------------------------------------------------------
    combineCriteria : function (criteria1, criteria2, outerOperator, textMatchStyle, subCriteria) {
        // instance-level method that passes itself to the class-level version
        return isc.DS.combineCriteria(criteria1, criteria2, outerOperator, textMatchStyle, subCriteria, this);
    },

    //> @attr dataSource.criteriaPolicy (CriteriaPolicy : "dropOnShortening" : IRWA)
    // Decides under what conditions the +link{ResultSet} cache should be dropped when the
    // +link{resultSet.criteria} changes.
    // @see compareCriteria()
    // @serverDS allowed
    // @visibility external
    //<
    criteriaPolicy:"dropOnShortening",

    //> @attr dataSource.defaultTextMatchStyle (TextMatchStyle : "exact" : [IR])
    // The default textMatchStyle to use for +link{DSRequest}s that do not explicitly state
    // a +link{dsRequest.textMatchStyle,textMatchStyle}.    Note, however, that DSRequests
    // issued by +link{ListGrid}s and other +link{DataBoundComponent,components} will
    // generally have a setting for textMatchStyle on the component itself (see
    // +link{ListGrid.autoFetchTextMatchStyle}, for example).
    //
    // @group clientDataIntegration
    // @group serverDataIntegration
    // @serverDS allowed
    // @visibility external
    // @example jsonDataSource
    // @example simpleJSON
    //<
    defaultTextMatchStyle:"exact",

    //> @attr dataSource.ignoreTextMatchStyleCaseSensitive (Boolean : false : [IR])
    // For fields on this dataSource that specify
    // +link{dataSourceField.ignoreTextMatchStyle,ignoreTextMatchStyle} true, the prevailing
    // textMatchStyle is ignored and SmartClient matches exact values.  This property dictates
    // whether that match is case-sensitive like the "exactCase" textMatchStyle, or
    // case-insensitive like the "exact" textMatchStyle (the default).  Please see the
    // +link{type:TextMatchStyle,TextMatchStyle documentation} for a discussion of the nuances
    // of case-sensitive matching.
    //
    // @serverDS allowed
    // @visibility external
    //<
    ignoreTextMatchStyleCaseSensitive:false,

    //> @attr dataSource.arrayCriteriaForceExact (Boolean : null : [IR])
    // With ordinary +link{type:Criteria,simple criteria}, it is possible to provide an array
    // of values for a given field, which means "any of these values".  For example:<pre>
    //  var criteria = {
    //    field1 : "value1",
    //    field2 : ["value2", "value3"]
    // }</pre>
    // At first glance, this criteria appears to mean "select records where 'field1' is 'value1'
    // and 'field2' is one of 'value2' or 'value3'".  However, if the prevailing
    // +link{dsRequest.textMatchStyle,textMatchStyle} is "substring" - as it would be if, for
    // example, you had issued a +link{dataSource.filterData,filterData()} call - then this
    // criteria means "select records where 'field1' contains 'value1' somewhere, and 'field2'
    // contains either 'value2' or 'value3'"
    // <p>
    // Depending on your requirement, this may or may not be what you want, and you can control
    // it by setting the <code>textMatchStyle</code> on your +link{class:DSRequest}, or by
    // setting a default <code>textMatchStyle</code> on the DataSource
    // (+link{DataSource.defaultTextMatchStyle}), or by specifying that the <code>textMatchStyle</code>
    // should be ignored for certain fields (+link{dataSourceField.ignoreTextMatchStyle})
    // <p>
    // However, a common use case is that you want "substring" style filtering on one or more
    // single-valued fields, but exact matching on a list-valued field.  For example, say you
    // want a list of customers based in certain cities, with a name matching the substring
    //"software":<pre>
    //  var criteria = {
    //    name : "software",
    //    city : ["York", "Newport", "Orleans"]
    // }</pre>
    // Here, using substring matching on the "city" field is likely to give incorrect results,
    // as it will match a number of US cities in addition to the three European cities
    // intended (New York, Yorktown, New Orleans, Newport News, and probably others).  And
    // even if this is not an issue for your particular use case, and correct results can be
    // obtained with a substring search, it is very likely to be more costly performance-wise
    // than the exact value match that you really need (potentially much more costly).
    // <p>
    // You could achieve exact matching in the above case by marking the "city" field as
    // <code>ignoreTextMatchStyle:true</code>, but that would mean you couldn't perform
    // substring searches on that field in other use cases where that might be desirable.
    // <p>
    // In cases like this, SmartClient by default treats list-valued simple criteria as
    // if <code>ignoreTextMatchStyle</code> is in force for that field.  If you want to switch
    // this behavior off, and have list-valued simple criteria handled with the prevailing
    // <code>textMatchStyle</code>, set <code>arrayCriteriaForceExact</code>
    // to false.  It is also possible to set this flag per-operationBinding and
    // per-DSRequest - see +link{operationBinding.arrayCriteriaForceExact} and
    // +link{dsRequest.arrayCriteriaForceExact}
    // <p>
    // If you want to switch this behavior off across the entire system, set the flag in your
    // <code>server.properties</code> file:<pre>
    //     arrayCriteriaForceExact: false
    // </pre>
    // This will only have an effect for server-side DataSources; if you want to change this
    // flag globally for +link{dataSource.clientOnly,clientOnly} dataSources, change the
    // default in the client-side +link{class:DataSource} class, like so:<pre>
    //     isc.DataSource.addProperties({arrayCriteriaForceExact: false});
    // </pre>
    // If you do change the global defaults, it is still possible to override per-dataSource
    // or per-operationBinding, as described above.
    // <p>
    // Note, all of this only applies to <i>simple</i> criteria.  If your dataSource
    // +link{dataSource.supportsAdvancedCriteria(),supports AdvancedCriteria}, that gives you
    // much finer and more complete control over the exact meaning of individual criterions.
    //
    // @group clientDataIntegration
    // @group serverDataIntegration
    // @serverDS allowed
    // @visibility external
    //<


    //> @attr operationBinding.arrayCriteriaForceExact (Boolean : null : [IR])
    // Operation-level override for the DataSource-level
    // +link{dataSource.arrayCriteriaForceExact,arrayCriteriaForceExact}
    // flag.  See the documentation for that flag for details.
    //
    // @group clientDataIntegration
    // @group serverDataIntegration
    // @serverDS allowed
    // @visibility external
    //<

    //> @attr dsRequest.arrayCriteriaForceExact (Boolean : null : [IR])
    // DSRequest-level override for the DataSource-level
    // +link{dataSource.arrayCriteriaForceExact,arrayCriteriaForceExact}
    // flag.  See the documentation for that flag for details.
    //
    // @group clientDataIntegration
    // @group serverDataIntegration
    // @serverDS allowed
    // @visibility external
    //<


    // ResultTrees
    // ----------------------------------------------------------------------------------------
    //> @attr dataSource.resultTreeClass (Class Object : null : [IRA])
    // Class for ResultTrees used by this datasource.  If null, defaults to using
    // +link{ResultTree}.
    // <P>
    // This can be set to a custom subclass of ResultTree that, for example, hangs on to extra
    // information necessary for integration with web services.
    //
    // @serverDS allowed
    //  @visibility external
    //<

    // ResultSets
    // ----------------------------------------------------------------------------------------
    //> @attr dataSource.resultSetClass (Class Object : null : [IRA])
    // Class for ResultSets used by this datasource.  If null, defaults to using
    // +link{ResultSet}.
    // <P>
    // This can be set to a custom subclass of ResultSet that, for example, hangs onto to extra
    // information necessary for integration with web services.
    //
    // @serverDS allowed
    // @visibility external
    //<

    // Validation
    // ----------------------------------------------------------------------------------------
    //> @attr dataSource.useLocalValidators (boolean : null : IRWA)
    // Whether to attempt validation on the client at all for this DataSource.  If unset (the
    // default), client-side validation is enabled.
    // <p>
    // Disabling client-side validation entirely is a good way to test server-side validation.
    //
    // @group validation
    // @serverDS allowed
    // @visibility external
    //<
    // NOTE: code that checks this property interprets null as true

    //> @attr dataSource.requiredMessage (HTMLString : null : [IRW])
    // The required message when a field that has been marked as
    // +link{DataSourceField.required,required} is not filled in by the user.
    // <p>
    // Note that +link{dataSourceField.requiredMessage} wins over this setting if both are set.
    // @group formTitles
    // @visibility external
    //<

    // ShowPrompt
    // ----------------------------------------------------------------------------------------
    //> @attr dataSource.showPrompt (Boolean : true : IRW)
    // Whether RPCRequests sent by this DataSource should enable
    // +link{attr:RPCRequest.showPrompt} in order to block user interactions until the
    // request completes.
    // <p>
    // DataSource requests default to blocking UI interaction because, very often, if the user
    // continues to interact with an application that is waiting for a server response, some
    // kind of invalid or ambiguous situation can arise.
    // <p>
    // Examples include pressing a "Save" button a second time before the first save completes,
    // making further edits while edits are still being saved, or trying to initiate editing on
    // a grid that hasn't loaded data.
    // <p>
    // Defaulting to blocking the UI prevents these bad interactions, or alternatively, avoids
    // the developer having to write repetitive code to block invalid interactions on every
    // screen.
    // <p>
    // If an operation should ever be non-blocking, methods that initiate DataSource requests
    // (such as +link{DataSource.fetchData()}) will generally have a
    // <code>requestProperties</code> argument allowing <code>showPrompt</code> to be set to
    // false for a specific request.
    //
    // @serverDS allowed
    // @visibility external
    //<
    showPrompt:true,

    // Selection
    // ----------------------------------------------------------------------------------------
    //> @attr dataSource.selectionClass (ClassName : null : [A])
    // Class to use as the Selection object for ResultSets derived from this DataSource.
    // @visibility serverSelection
    //<


    // Java enum translation
    // ----------------------------------------------------------------------------------------
    //> @type EnumTranslateStrategy
    // Determines how Java enums are translated to and from Javascript by the SmartClient server.
    //
    // @value "name"
    //   Translates to/from a String matching the constant name. This is the default if not set.
    // @value "string"
    //   Translates to/from a String matching the <code>enum.toString()</code>.
    // @value "ordinal"
    //   Translates to/from an integer matching the ordinal number of the constant within
    //   the enumeration
    // @value "bean"
    //   Translates to/from a Javascript object containing one property for each property defined
    //   within the enum. The constant itself and the ordinal number are included in the JS object.
    //   By default they are called "_constant" and "_ordinal", but this can be overridden with
    //   the +link{dataSource.enumOrdinalProperty} and +link{dataSource.enumConstantProperty}
    //   properties
    //
    // @see dataSource.enumTranslateStrategy
    // @serverDS allowed
    // @visibility external
    //<


    //> @attr dataSource.enumTranslateStrategy (EnumTranslateStrategy : null : IA)
    //
    // Sets the strategy this DataSource uses to translate Java enumerated types (objects of type
    // enum) to and from Javascript.
    //
    // This property is only applicable if you are using the SmartClient server
    // @serverDS allowed
    // @visibility external
    //<

    //> @attr dataSource.enumConstantProperty (String : null : IA)
    //
    // The name of the property this DataSource uses for constant name when translating
    // Java enumerated types to and from Javascript, if the +link{enumTranslateStrategy} is set
    // to "bean".  Defaults to "_constant" if not set.
    // <p>
    //  This property is only applicable if you are using the SmartClient server
    // @serverDS allowed
    // @visibility external
    //<

    //> @attr dataSource.enumOrdinalProperty (String : null : IA)
    //
    // The name of the property this DataSource uses for ordinal number when translating
    // Java enumerated types to and from Javascript, if the +link{enumTranslateStrategy} is set
    // to "bean".  Defaults to "_ordinal" if not set.
    // <p>
    //  This property is only applicable if you are using the SmartClient server
    // @serverDS allowed
    // @visibility external
    //<

    //> @attr dataSource.autoDeriveTitles (boolean : true : IR)
    // If set, titles are automatically derived from +link{dataSourceField.name,field.name} for any
    // field that does not have a +link{dataSourceField.title,field.title} and is not marked
    // +link{dataSourceField.hidden,hidden}:true, by calling the method +link{getAutoTitle()}.
    // @serverDS allowed
    // @visibility external
    //<
    autoDeriveTitles: true,

    // Multi-level Sorting
    //> @attr dataSource.canMultiSort (boolean : true : IR)
    // When true, indicates that this DataSource supports multi-level sorting.
    // @serverDS allowed
    // @visibility external
    //<
    canMultiSort: true,

    //> @attr dataSource.sparseUpdates (boolean : false : IR)
    // When true, indicates that any updates for this DataSource include only those fields
    // that have actually changed (and primaryKey fields); when false (the default), all
    // field values are included in updates, whether they have changed or not
    // @serverDS only
    // @visibility external
    //<

    //> @attr dataSource.noNullUpdates (boolean : false : IR)
    // When true, indicates that fields in this DataSource will never be positively updated
    // to the null value; they may arrive at null values by being omitted, but we will
    // not send actual null values in update requests.  When false (the default), null is
    // not treated in any special way.
    // <p>
    // Setting this value causes null-assigned fields to be replaced with the field's
    // +link{DataSourceField.nullReplacementValue,nullReplacementValue}, if one is declared.
    // If no <code>nullReplacementValue</code> is declared for the field, the null assignment
    // is replaced with the DataSource's +link{nullStringValue,nullStringValue},
    // +link{nullIntegerValue,nullIntegerValue}, +link{nullFloatValue,nullFloatValue}
    // or +link{nullDateValue,nullDateValue}, depending on the field type.
    // <p>
    // For "add" operations, setting +link{omitNullDefaultsOnAdd,omitNullDefaultsOnAdd} causes
    // null-valued fields to be removed from the request entirely, rather than replaced with
    // default values as described above.
    // @serverDS only
    // @visibility external
    //<

    //> @attr dataSource.omitNullDefaultsOnAdd (boolean : false : IR)
    // When true, and +link{noNullUpdates,noNullUpdates} is also true, indicates that "add"
    // requests on this DataSource will have null-valued fields removed from the request
    // entirely before it is sent to the server, as opposed to the default behavior of
    // replacing such null values with defaults.
    // @see noNullUpdates
    // @serverDS only
    // @visibility external
    //<

    //> @attr dataSource.nullStringValue (String : "" : IR)
    // If +link{noNullUpdates} is set, the value to use for any text field that has a null
    // value assigned on an update operation, and does not specify an explicit
    // +link{DataSourceField.nullReplacementValue,nullReplacementValue}.
    // @see noNullUpdates
    // @see DataSourceField.nullReplacementValue
    // @serverDS only
    // @visibility external
    //<
    nullStringValue: "",

    //> @attr dataSource.nullIntegerValue (int : 0 : IR)
    // If +link{noNullUpdates} is set, the value to use for any integer field that has a null
    // value assigned on an update operation, and does not specify an explicit
    // +link{DataSourceField.nullReplacementValue,nullReplacementValue}.
    // @see noNullUpdates
    // @see DataSourceField.nullReplacementValue
    // @serverDS only
    // @visibility external
    //<
    nullIntegerValue: 0,

    //> @attr dataSource.nullFloatValue (float : 0.0 : IR)
    // If +link{noNullUpdates} is set, the value to use for any float field that has a null
    // value assigned on an update operation, and does not specify an explicit
    // +link{DataSourceField.nullReplacementValue,nullReplacementValue}.
    // @see noNullUpdates
    // @see DataSourceField.nullReplacementValue
    // @serverDS only
    // @visibility external
    //<
    nullFloatValue: 0.0,

    //> @attr dataSource.nullBooleanValue (boolean : false : IR)
    // If +link{noNullUpdates} is set, the value to use for any boolean field that has a null
    // value assigned on an update operation, and does not specify an explicit
    // +link{DataSourceField.nullReplacementValue,nullReplacementValue}.
    // @see noNullUpdates
    // @see DataSourceField.nullReplacementValue
    // @serverDS only
    // @visibility external
    //<
    nullBooleanValue: false,

    //> @attr dataSource.nullDateValue (Date : See below : IR)
    // If +link{noNullUpdates} is set, the value to use for any date or time field that has a
    // null value assigned on an update operation, and does not specify an explicit
    // +link{DataSourceField.nullReplacementValue,nullReplacementValue}.
    // <p>
    // Unlike strings and numbers, there is no "natural" choice for a null replacement value
    // for dates.  The default value we have chosen is midnight on January 1st 1970, simply
    // because this is "the epoch" - the value that is returned by calling "new Date(0)"
    // @see noNullUpdates
    // @see DataSourceField.nullReplacementValue
    // @serverDS only
    // @visibility external
    //<
    nullDateValue: new Date(0),


    // Role-based security
    // ----------------------------------------------------------------------------------------

    //> @attr dataSource.requiresAuthentication (boolean : null : IR)
    // Whether a user must be authenticated in order to access this DataSource.  This establishes a
    // default for the DataSource as a whole; individual +link{operationBindings} within the
    // DataSource may still override this setting by explicitly setting
    // +link{operationBinding.requiresAuthentication}.
    // <P>
    // Whether the user is authenticated is determined by calling
    // <code>httpServletRequest.getRemoteUser()</code>, hence works with both simple J2EE security
    // (realms and form-based authentication) and JAAS (Java Authentication & Authorization
    // Service).
    // <P>
    // If you wish to use an authentication scheme that does not make use of the servlet API's
    // standards, SmartClient Server also implements the <code>setAuthenticated</code> method
    // on <code>RPCManager</code>.  You can use this API to tell SmartClient that all the
    // requests in the queue currently being processed are associated with an authenticated
    // user; in this case, SmartClient will not attempt to authenticate the user via
    // <code>httpServletRequest.getRemoteUser()</code>
    // <P>
    // You can set the default value for this property via setting "authentication.defaultRequired"
    // in +link{group:server_properties,server.properties}.  This allows you to, for example,
    // cause all DataSources to require
    // authentication for all operations by default.
    // <P>
    // Note that setting this property does not automatically cause an authentication mechanism to
    // appear - you still need to separately configure an authentication system.  Likewise, setting
    // requiresAuthentication="false" does not automatically allow users to bypass your authentication
    // mechanism - you need to set up a URL that will accept DSRequests and process them similar to
    // the default "IDACall" servlet, and which is not protected by the authentication system.  See
    // +link{group:servletDetails,Deploying SmartClient} for details on the IDACall servlet.
    //
    // @requiresModules SCServer
    // @group auth
    // @group declarativeSecurity
    // @serverDS only
    // @visibility external
    //<

    //> @attr dataSource.requiresRole (String : null : IR)
    // Similar to +link{operationBinding.requiresRole}, but controls access to the DataSource as a
    // whole.
    //
    // @requiresModules SCServer
    // @group auth
    // @group declarativeSecurity
    // @serverDS only
    // @visibility external
    //<

    //> @attr dataSource.requires (VelocityExpression : null : IR)
    // Indicates that the specified +link{type:VelocityExpression} must evaluate to true for a user
    // to access this DataSource.
    // <P>
    // See also +link{operationBinding.requires}.
    //
    // @requiresModules SCServer
    // @group auth
    // @group declarativeSecurity
    // @serverDS only
    // @visibility external
    //<

    //> @attr dataSource.creatorOverrides (boolean : null : IR)
    // Indicates that declarative security rules are waived for rows that were created by the
    // current user.  Practically, this means that when a security check fails, instead of a
    // security exception being thrown, we alter the criteria to ensure that the request can
    // only return or affect rows that were created by the current authenticated user.  This
    // allows you to create security regimes whereby users can see and edit data they created,
    // but have access to other users' data forbidden or limited.
    // <p>
    // In order for this to work, we require two things:<ul>
    // <li>The DataSource must specify a field of type "creator" - this field type is described
    //     on +link{type:FieldType,this page}</li>
    // <li>The authentication regime in use must include the idea of a "current user".  The
    //     authentication provided by the Servlet API is an example of such a regime.</li>
    // </ul>
    // This setting can be overridden at operationBinding and field level, allowing extremely
    // fine-grained control.
    //
    // @requiresModules SCServer
    // @see operationBinding.creatorOverrides
    // @see dataSourceField.creatorOverrides
    // @group fieldLevelAuth
    // @group declarativeSecurity
    // @serverDS only
    // @visibility external
    //<

    //> @attr dataSource.ownerIdField (String : null : IR)
    // Requires that the currently authenticated user match the contents of
    // this field, for client-initiated requests (i.e., where
    // <code>DSRequest.isClientRequest()</code> returns true on the server).
    //
    // <p>Note, the behaviors described below can be affected by the dataSource properties
    // +link{dataSource.ownerIdNullRole,ownerIdNullRole} and
    // +link{dataSource.ownerIdNullAccess,ownerIdNullAccess}, so please read the documentation
    // for those two properties in conjunction with this article.
    //
    // <p>When a new row is added by a client-initiated +link{DSRequest}, the
    // ownerIdField will be automatically populated with the currently
    // authenticated user (clobbering any value supplied by the client).
    // Client-initiated attempts to update the ownerIdField will also be
    // prevented.
    //
    // <p>If you wish to set the ownerIdField to a different value via an "add"
    // or "update" operation, you can do so in server-side DMI code (possibly
    // consulting <code>DSRequest.getClientSuppliedValues()</code> to get the
    // value that was clobbered).
    //
    // <p>For client-initiated "fetch", "update" or "remove" operations, the
    // server will modify client-supplied criteria so that only rows whose
    // ownerIdField matches the currently authenticated user can be read,
    // updated or deleted.  For built-in DataSource types (SQL, Hibernate and
    // JPA), the additional criteria required to match the <code>ownerIdField</code>
    // field will ignore the prevailing
    // +link{dsRequest.textMatchStyle,textMatchStyle} and always use exact
    // equality.  If you have a custom or generic DataSource implementation,
    // you will want to do the same thing, to avoid false positives on
    // partial matches (eg, a user with name "a" gets records where the owner
    // is any user with an "a" in the name).  You can determine when this is
    // necessary by looking for a +link{class:DSRequest} attribute called
    // "restrictedOwnerIdField".  For example, code similar to the following:<pre>
    //    String restrictedField = (String)dsRequest.getAttribute("restrictedOwnerIdField");
    //    if (field.getName() != null && field.getName().equals(restrictedField)) {
    //        // Use exact matching for this field
    //    } else {
    //        OK to use the textMatchStyle
    //    }
    // </pre>
    // Also note, for server-initiated requests, this  automatic criteria-narrowing is not
    // applied; if your application requires server-initiated "fetch", "update" and "remove"
    // requests to be limited to the currently-authenticated user, your code must add the
    // necessary criteria to the request.
    //
    // <p>The ownerIdField setting can be overridden at the
    // +link{operationBinding.ownerIdField} level.
    //
    // <p>If ownerIdField is specified,
    // +link{dataSource.requiresAuthentication,requiresAuthentication} will
    // default to <code>true</code>. If <code>requiresAuthentication</code> is
    // explicitly set to <code>false</code>, then unauthenticated users will be
    // able to see all records. To avoid this, you can use
    // +link{dataSource.guestUserId,guestUserId} to specify a default user to
    // apply when no one has authenticated.
    //
    // @requiresModules SCServer
    // @see operationBinding.ownerIdField
    // @see dataSource.guestUserId
    // @serverDS only
    // @visibility external
    //<

    //> @attr dataSource.guestUserId (String : null : IR)
    // Value to use for the +link{dataSource.ownerIdField,ownerIdField} if no one
    // has authenticated.
    //
    // <p>This setting can be overridden at the operationBinding level.
    //
    // @requiresModules SCServer
    // @see dataSource.ownerIdField
    // @see operationBinding.guestUserId
    // @see dataSource.ownerIdNullRole
    // @see dataSource.ownerIdNullAccess
    // @serverDS only
    // @visibility external
    //<

    //> @attr dataSource.ownerIdNullRole (String : null : IR)
    // If +link{dataSource.ownerIdField,ownerIdField} is in force, specifies a role that will
    // allow the <code>ownerIdField</code> to take a null value.  Any user that has that role
    // is allowed to create client-initiated "add" and "update" operations that specify a null
    // value for the <code>ownerIdField</code>, and the system will persist the null value
    // rather than forcing in the currently authenticated user's user id as it normally would.
    // If any client-initiated "add" or "update" request specifies <i>any</i> non-null value
    // for the <code>ownerIdField</code>, the normal behavior of the system will reassert and
    // the current user's user id will be forced into the <code>ownerIdField</code>.  This
    // allows authorised users (ie, those with the necessary role) to choose between saving
    // public or private records, just by sending a null or non-null value for the
    // <code>ownerIdField</code>.
    // <p>
    // This property has no effect if <code>ownerIdField</code> is not specified.
    // <p>
    // This property can be used in conjunction with +link{dataSource.ownerIdNullAccess} to
    // create the concept of shared, or public, records - see that property's documentation
    // for an example.
    //
    // @requiresModules SCServer
    // @see dataSource.ownerIdField
    // @see dataSource.ownerIdNullAccess
    // @serverDS only
    // @visibility external
    //<

    //> @type NullAccessType
    // The possible access types for records with a null +link{dataSource.ownerIdField,ownerIdField}
    // (only applicable if <code>ownerIdField</code> is specified)
    //
    // @value "none"
    //   The default value, means that users have no access to records with a null
    // <code>ownerIdField</code>.  In this case, users can only see their own records (ie,
    // those where the <code>ownerIdField</code> matches the currently authenticaed user's id)
    //
    // @value "view"
    //   Users are allowed read-only access to records with a null
    // <code>ownerIdField</code>.  In this case, users can see records with a null owner as
    // well as their own records.
    //
    // @value "edit"
    //   Users are allowed read, update and delete access to records with a null
    // <code>ownerIdField</code>.  In this case, users can see and fully manage records with
    // a null owner, as well as their own records.
    //
    // @see dataSource.ownerIdField
    // @see dataSource.ownerIdNullAccess
    // @see dataSource.ownerIdNullRole
    // @serverDS only
    // @visibility external
    //<

    //> @attr dataSource.ownerIdNullAccess (NullAccessType : null : IR)
    // If +link{dataSource.ownerIdField,ownerIdField} is in force, specifies the access that
    // is allowed to records with a null <code>ownerIdField</code>.  This property has no
    // effect if <code>ownerIdField</code> is not specified.
    // <p>
    // This property can be used in conjunction with +link{dataSource.ownerIdNullRole} to
    // create the concept of shared, or public, records.  For example, if you set
    // <code>ownerIdNullRole</code> to "administrator", any users with the "administrator"
    // role will be allowed to write records with a null <code>ownerIdField</code>.  If you
    // also set <code>ownerIdNullAccess</code> to "view", all those records with a null owner
    // will be viewable by all, in addition to their own records.  We use this functionality
    // with the +link{class:SavedSearches,Saved Searches feature}, to enable precisely this:
    // users can save their own searches, which are private to them, but administrators can
    // also save searches with a null <code>ownerIdField</code>, which become standard, shared
    // searches that appear to all users, in addition to their own private searches.
    //
    // @requiresModules SCServer
    // @see dataSource.ownerIdField
    // @see dataSource.ownerIdNullRole
    // @serverDS only
    // @visibility external
    //<

    // General Security
    // ----------------------------------------------------------------------------------------

    //> @attr dataSource.serverOnly (String : null : IR)
    // Setting a DataSource to be <code>serverOnly="true"</code> ensures that it will not be visible
    // to the client. Any request through IDACall to this DataSource will return a failure response.
    // Only requests which have been initiated on the server-side will be executed against this DataSource.
    //
    // @requiresModules SCServer
    // @serverDS only
    // @visibility external
    //<

    // Transactions
    // ----------------------------------------------------------------------------------------

    //> @attr dataSource.autoJoinTransactions (boolean : null : IR)
    // If true, causes all operations on this DataSource to automatically start or join a
    // transaction associated with the current HttpServletRequest.  This means that multiple
    // operations sent to the server in a +link{RPCManager.startQueue(),request queue} will be
    // committed in a single transaction.
    // <p>
    // Note that this includes fetch operations - setting this property to true has the same
    // effect as a transaction policy of ALL for just this DataSource's operations - see the
    // server-side <code>RPCManager.setTransactionPolicy()</code> for details of the different
    // TransactionPolicy settings.
    // <p>
    // If this property is explicitly false, this causes all operations on this DataSource
    // to be committed individually - the same as a transaction policy of NONE, just for this
    // DataSource's operations.
    // <p>
    // In either case, you can override the setting for individual operations - see
    // +link{OperationBinding.autoJoinTransactions}.
    // <P>
    // If this property if null or not defined, we fall back to the default setting for this
    // type of DataSource.  These are defined in +link{group:server_properties,server.properties}
    // as follows:
    // <ul>
    // <li><b>Hibernate:</b><code> hibernate.autoJoinTransactions</code></li>
    // <li><b>JPA/JPA2:</b><code> jpa.autoJoinTransactions</code></li>
    // <li><b>SQL:</b> There is one setting per configured database connection (+link{dbName,dbName}).
    // For example, the setting for the default MySQL connection is
    // <code> sql.Mysql.autoJoinTransactions</code></li>
    // </ul>
    // If the setting is not defined at the DataSource-type level, we use the system global
    // default, which is defined in <code>server.properties</code> as
    // <code>autoJoinTransactions</code>.
    // <P>
    // At the dbName and global system levels, you can set the autoJoinTransactions attribute
    // to a valid Transaction Policy, rather than a simple true or false (although these
    // values work too - true is the same as ALL, false is the same as NONE).  For valid
    // TransactionPolicy values and their meanings, see the server-side Javadoc for
    // <code>RPCManager.setTransactionPolicy()</code>
    // <P>
    // Note that the configuration settings discussed here can be overridden for a particular
    // queue of requests by setting the server-side RPCManager's transaction policy.  Look in
    // the server-side Javadoc for <code>RPCManager.getTransactionPolicy()</code>.
    // <P>
    // Transactions can also be initiated manually, separate from the
    // RPCManager/HttpServletRequest lifecycle, useful for both multi-threaded web
    // applications, and standalone applications that don't use a servlet container - see
    // +link{group:standaloneDataSourceUsage}.
    // <P>
    // NOTE: Setting this property to true does not cause a transactional persistence
    // mechanism to automatically appear - you have to ensure that your DataSource supports
    // transactions.  The SmartClient built-in SQL, Hibernate and JPA DataSources support transactions,
    // but note that they do so <b>at the provider level</b>.  This means that you can combine
    // updates to, say, an Oracle database and a MySQL database in the same queue, but they
    // will be committed in <em>two</em> transactions - one per database.  The SmartClient
    // server will commit or rollback these two transactions as if they were one, so a
    // failure in some Oracle update would cause all the updates to both databases to be
    // rolled back.  However, this is not a true atomic transaction; it is possible for one
    // transaction to be committed whilst the other is not - in the case of hardware failure,
    // for example.
    // <p>
    // NOTE: Not all the supported SQL databases are supported for transactions.  Databases
    // supported in this release are:
    // <ul>
    // <li>DB2</li>
    // <li>HSQLDB</li>
    // <li>Firebird</li>
    // <li>Informix</li>
    // <li>Microsoft SQL Server</li>
    // <li>MySQL (you must use InnoDB tables; the default MyISAM storage engine does not
    // support transactions)</li>
    // <li>MariaDB</li>
    // <li>Oracle</li>
    // <li>PostgreSQL</li>
    // </ul>
    //
    // @serverDS only
    // @see OperationBinding.autoJoinTransactions
    // @visibility transactions
    //<

    //> @attr dataSource.useSpringTransaction (boolean : null : IR)
    // This flag is part of the Automatic Transactions feature; it is only applicable in
    // Power Edition and above.
    // <p>
    // If true, causes all transactional operations on this DataSource to use the current
    // Spring-managed transaction, if one exists.  If there is no current Spring transaction
    // to use at the time of execution, a server-side Exception is thrown.  Note, a
    // "transactional operation" is one that would have joined the SmartClient shared
    // transaction in the absence of Spring integration - see
    // +link{dataSource.autoJoinTransactions,auotJoinTransactions}.
    // <p>
    // This feature is primarily intended for situations where you have
    // +link{group:dmiOverview,DMI methods} that make use of both Spring DAO operations and
    // SmartClient DSRequest operations, and you would like all of them to share the same
    // transaction.  An example of the primary intended use case:<pre>
    //   &#x0040;Transactional(isolation=Isolation.READ_COMMITTED, propagation=Propagation.REQUIRED)
    //   public class WorldService {
    //
    //     public DSResponse doSomeStuff(DSRequest dsReq, HttpServletRequest servletReq)
    //     throws Exception
    //     {
    //          ApplicationContext ac = (ApplicationContext)servletReq.getSession().getServletContext().getAttribute("applicationContext");
    //       WorldDao dao = (WorldDao)ac.getBean("worldDao");
    //       dao.insert(req.getValues());
    //       DSRequest other = new DSRequest("MyOtherDataSource", "add");
    //       // Set up the 'other' dsRequest with critiera, values, etc
    //       //  ...
    //
    //       // This dsRequest execution will use the same transaction that the DAO operation
    //       // above used; if it fails, the DAO operation will be rolled back
    //       other.execute();
    //
    //       return new DSResponse();
    //     }
    //   }</pre>
    // Note: if you want to rollback an integrated Spring-managed transaction, you can use
    // any of the normal Spring methods for transaction rollback:<ul>
    // <li>Programmatically mark the transaction for rollback with the
    // <code>setRollbackOnly()</code> API</li>
    // <li>Throw a <code>RuntimeException</code>, or</li>
    // <li>Throw an ordinary checked <code>Exception</code>. but configure Spring to rollback
    //     on that Exception.  This can be done in the @Transactional annotation:<pre>
    //     &#x0040;Transactional(isolation=Isolation.READ_COMMITTED, propagation=Propagation.REQUIRED, rollbackFor=MyRollbackException.class)</pre></li>
    // </ul>
    // Spring's exception-handling model is different from SmartClient's, so care must be
    // taken to get the correct error processing.  If a transactional DSRequest fails,
    // SmartClient code will throw an ordinary checked <code>Exception</code>; but Spring will
    // ignore that <code>Exception</code>.  So you can either:<ul>
    // <li>Wrap every <code>DSRequest.execute()</code> in a try/catch block.  Catch
    // <code>Exception</code> and throw a <code>RuntimeException</code> instead</li>
    // <li>Just use the "rollbackFor" annotation to make your transactional method rollback
    // for all instances of <code>Exception</code></li>
    // </ul>
    // <br>
    // Note: Spring transaction integration is conceptually different from SmartClient's
    // +link{dataSource.autoJoinTransactions,built-in transaction feature}, because SmartClient
    // transactions apply to a queue of DSRequests, whereas Spring transactions are scoped to
    // a single method invocation.  If you want to make a whole SmartClient queue share a
    // single Spring-managed transaction, you can wrap the processing of an entire queue in a
    // call to a transactional Spring method.  See the <em>Using Spring Transactions with
    // SmartClient DMI</em> section at the bottom of the
    // +link{group:springIntegration,Spring integration page} for more details.
    // <p>
    // You can set <code>useSpringTransaction</code> as the default setting for all dataSources
    // for a given database provider by adding the property
    // <code>{dbName}.useSpringTransaction</code> to your <code>server.properties</code> file.
    // For example, <code>Mysql.useSpringTransaction: true</code> or
    // <code>hibernate.useSpringTransaction: true</code>.  You can set it as the default for
    // all providers with a <code>server.properties</code> setting like this:
    // <code>useSpringTransaction: true</code>.  When <code>useSpringTransaction</code> is
    // the default, you can switch it off for a specific dataSource by explicitly setting the
    // flag to false for that DataSource.
    // <p>
    // Finally, this setting can be overridden at the operationBinding level - see
    // +link{operationBinding.useSpringTransaction}
    // <h3>Configuration</h3>
    // When using Spring transactions, SmartClient needs a way to lookup the JNDI connection
    // being used by Spring, and this needs to be configured.  First, register a bean like
    // this in your applicationContext.xml file:<pre>
    //   &lt;bean id="dataSource" class="org.springframework.jndi.JndiObjectFactoryBean"&gt;
    //       &lt;!-- Set this to the JNDI name Spring is using --&gt;
    //       &lt;property name="jndiName" value="isomorphic/jdbc/defaultDatabase"/&gt;
    //   &lt;/bean&gt;
    // </pre>
    // and then add a line like this to your server.properties:<pre>
    //   # Set this property to match the "id" of the JndiObjectFactoryBean registered in Spring
    //   sql.spring.jdbcDataSourceBean: dataSource
    // </pre>
    //
    // @serverDS only
    // @see DataSource.autoJoinTransactions
    // @see OperationBinding.useSpringTransaction
    // @see group:springIntegration
    // @visibility transactions
    //<

    // SQL Paging Strategy
    // ----------------------------------------------------------------------------------------
    //> @type SQLPagingStrategy
    // The technique SmartClient Server's SQL DataSource should use to select a "page" of data
    // from a table.
    //
    // @value "sqlLimit"
    //   Specify the paging directly in the SQL query we generate.  The way this is done varies
    // considerably from database to database: with some it is a straightforward built-in
    // facility while others require arcane tricks or simply don't support the idea.  This is
    // the most efficient method, where available.  Note that this strategy is not supported
    // for operations that make use of a +link{operationBinding.customSQL,customSQL} clause,
    // because it depends upon being able to determine the size of the whole dataset without
    // actually retrieving the whole dataset.  Ordinary operations do this by means of an
    // automatically-generated "row count query", but we cannot generate such a query for a
    // <code>customSQL</code> operation.
    //
    // @value "jdbcScroll"
    //   Implement the paging behavior by use of the <code>absolute()</code> method of the
    // JDBC <code>ResultSet</code>.
    //
    // @value "dropAtServer"
    //   Implement the paging behavior by fetching the entire resultset from the database and
    // dropping any unnecessary rows on the server before returning the data to the client.
    // This approach is extremely inefficient, but also extremely straightforward; it is
    // intended as a fallback option, for situations where the more sophisticated approaches
    // cause problems (a JDBC driver that throws vague exceptions when <code>absolute()</code>
    // is called, for example)
    //
    // @value "none"
    //   No paging behavior: we always return the entire resultset to the client.
    //
    // @see dataSource.sqlPaging
    // @see operationBinding.sqlPaging
    // @serverDS only
    // @visibility external
    //<

    //> @attr dataSource.sqlPaging (SQLPagingStrategy : null : IRW)
    // The paging strategy to use for this DataSource.  If this property is not set, the
    // default paging strategy, specified with the +link{group:server_properties,server.properties}
    // setting <code>sql.defaultPaging</code>, is used.
    // <p>
    // This setting can be overridden with the +link{OperationBinding.sqlPaging} property.
    // <P>
    // <b>NOTE:</b> Operations that involve a +link{operationBinding.customSQL,customSQL}
    // clause ignore this property, because customSQL operations usually need to be treated
    // as special cases.  For these operations, the paging strategy comes from the
    // +link{group:server_properties,server.properties} setting
    // <code>sql.defaultCustomSQLPaging</code> or
    // <code>sql.defaultCustomSQLProgressivePaging</code>, depending on whether or not
    // +link{dataSource.progressiveLoading,progressiveLoading} is in force.  Note that these
    // can always be overridden by a <code>sqlPaging</code> setting on the OperationBinding.
    //
    // @see operationBinding.sqlPaging
    // @serverDS only
    // @visibility external
    //<

    //> @attr dataSource.sqlUsePagingHint (boolean : null : IR)
    // If explicitly set true or left null, causes the server to use a "hint" in the SQL we
    // generate for paged queries.  If explicitly set false, forces off the use of hints.  This
    // property can be overridden per operationBinding - see
    // +link{operationBinding.sqlUsePagingHint}.
    // <p>
    // Note this property is only applicable to +link{dataSource.serverType,SQL} DataSources,
    // only when a +link{dataSource.sqlPaging,paging strategy} of "sqlLimit" is in force,
    // and it only has an effect for those specific database products where we employ a native
    // hint in the generated SQL in an attempt to improve performance.
    //
    // @requiresModules SCServer
    // @see operationBinding.sqlUsePagingHint
    // @group sqlPaging
    // @serverDS only
    // @visibility external
    //<

    //> @attr dataSource.useSubselectForRowCount (boolean : null : IR)
    // This property is only applicable to +link{dataSource.serverType,SQL} DataSources, and
    // only for +link{class:OperationBinding,operations} that express a
    // +link{operationBinding.customSQL,customSQL} clause.  In these circumstances, we
    // generally switch off paging because we are unable to generate a "row count" query that
    // tells the framework the size of the complete, unpaged resultset.
    // <p>
    // The <code>useSubselectForRowCount</code> flag causes the framework to derive a rowcount
    // query by simply wrapping the entire customSQL clause in a subselect, like so:<code><br>
    // &nbsp;&nbsp;&nbsp;&nbsp;SELECT COUNT(*) FROM ({customSQL clause here})</code>
    // <p>
    // However, this is not guaranteed to give good results.  Because the customSQL clause can
    // contain anything that you can write in SQL, running it inside a subselect in order to
    // count the rows might not work, might have unintended side-effects (if, for example, it
    // is a stored procedure call that performs updates as part of its function), or it might
    // just be a bad idea - for example, if the customSQL query is slow-running, you'll make
    // it twice as slow with this flag, simply because you'll be running it twice.  We
    // recommend using this flag with care.
    // <p>
    // NOTE: This setting can be overridden per-operation - see
    // +link{operationBinding.useSubselectForRowCount}.  You can also set a global default for
    // this setting, so you don't have to specify it in every dataSource - define
    // <code>useSubselectForRowCount</code> as true in your
    // +link{group:server_properties,server.properties} file.
    //
    // @requiresModules SCServer
    // @group sqlPaging
    // @serverDS only
    // @visibility external
    //<


    // SQL autoDeriveSchema auto-discovered FK relations
    // ----------------------------------------------------------------------------------------

    //> @attr dataSource.tableCode (String : null : R)
    // <b>Only applicable to the built-in SQL DataSource</b>
    // <p>
    // <code>tableCode</code> and the related properties +link{dataSourceField.columnCode},
    // +link{dataSourceField.fkTableCode} and +link{dataSourceField.fkColumnCode} are read-only
    // attributes that are secure and unique cryptographic hashes of table and column names
    // used by this DataSource.
    // <p>
    // These properties are used automatically by client-side framework code to
    // link dataSources together by +link{dataSourceField.foreignKey,foreign key} when a
    // <code>foreignKey</code> is not explicitly declared, but is found in the SQL schema via
    // the +link{autoDeriveSchema} feature.
    // <p>
    // A secure hash is used rather than the actual SQL table or column name for security
    // reasons - sending the actual SQL table or column name to the client could aid in
    // attempted SQL injection attacks.
    // <p>
    // This feature can be disabled system-wide via setting <code>datasource.autoLinkFKs</code>
    // to <code>false</code> in +link{group:server_properties,server.properties}.
    //
    // @requiresModules SCServer
    // @serverDS only
    // @visibility external
    //<

    //> @attr dataSourceField.fkTableCode (String : null : R)
    // See +link{dataSource.tableCode}.
    // @requiresModules SCServer
    // @serverDS only
    // @visibility external
    //<

    //> @attr dataSourceField.fkColumnCode (String : null : R)
    // See +link{dataSource.tableCode}.
    // @requiresModules SCServer
    // @serverDS only
    // @visibility external
    //<

    //> @attr dataSourceField.columnCode (String : null : R)
    // See +link{dataSource.tableCode}.
    // @requiresModules SCServer
    // @serverDS only
    // @visibility external
    //<


    // progressiveLoading
    // ----------------------------------------------------------------------------------------

    //> @groupDef progressiveLoading
    // The "Progressive Loading" pattern is a way to deal with incrementally retrieving
    // large data sets on demand (see the  <b>Paging and total dataset length</b>
    // section of the +link{ResultSet,ResultSet documentation}), when the total
    // data length is not available. For example - if a row-count database query to retrieve
    // an accurate data count would be prohibitively slow, you may opt to make use of
    // progressive loading instead.
    // <P>
    // In progressive loading mode, the reported +link{DSResponse.totalRows} from a fetch
    // will not be guaranteed to be accurate as long as there are more rows to be fetched
    // beyond the +link{dsRequest.endRow,requested endRow}. Instead the <code>response.totalRows</code>
    // will be set to the requested endRow plus the configured +link{DataSource.endGap}.
    // This indicates to the application that more rows are available, and as the user
    // scrolls to access these rows, additional fetch operations will occur to retrieve
    // the extra rows, and will report a new <code>totalRows</code> value.
    // <P>
    // Note that when progressive loading is active, the user will typically not be able to
    // cause direct movement to some arbitrary position in the dataset
    // (as is the case with ordinary, non-progressive loading).
    // <P>
    // When the user scrolls to the true end of the data-set, the <code>totalRows</code>
    // value is expected to be accurate.
    // <P>
    //
    // @title Progressive Loading
    // @visibility external
    //<

    //> @attr dataSource.progressiveLoading (boolean : null : IRW)
    // If true, causes SmartClient Server to use the "progressive loading" pattern for
    // fetches on this dataSource, as described in the <b>Paging and total dataset length</b>
    // section of the +link{ResultSet,ResultSet documentation}.  Essentially, this means that
    // we avoid issuing a row count query and instead advertise total rows as being slightly
    // more than the number of rows we have already read (see +link{endGap,endGap}).  This
    // allows users to load more of
    // a dataset by scrolling past the end of the currently-loaded rows, but it prevents them
    // from scrolling directly to the end of the dataset.
    // <p>
    // Generally, progressive loading is appropriate when you have to deal with very large
    // datasets. Note that by default, a dataSource will switch into progressive loading mode
    // automatically when it detects that it is dealing with a dataset beyond a certain size -
    // see +link{progressiveLoadingThreshold}.
    // <p>
    // This setting can be overridden for individual fetch operations with the
    // +link{OperationBinding.progressiveLoading} property, and also at the level of the
    // individual +link{DSRequest.progressiveLoading,DSRequest}.  You can also specify
    // <code>progressiveLoading</code> on
    // +link{DataBoundComponent.progressiveLoading,DataBoundComponents} and certain types of
    // <code>FormItem</code> - +link{SelectItem.progressiveLoading,SelectItem} and
    // +link{ComboBoxItem.progressiveLoading,ComboBoxItem}.
    // <p>
    // Currently, this property only applies to users of the built-in SQLDataSource, but you
    // could use it in custom DataSource implementations to trigger the server behavior
    // described in the <code>ResultSet</code> documentation linked to above.
    //
    // @see operationBinding.progressiveLoading
    // @see dataSource.progressiveLoadingThreshold
    // @see dataSource.lookAhead
    // @see dataSource.endGap
    // @serverDS allowed
    // @group progressiveLoading
    // @visibility external
    //<

    //> @attr dataSource.progressiveLoadingThreshold (int : 200000 : IRW)
    // Indicates the dataset size that will cause SmartClient Server to automatically
    // switch into +link{progressiveLoading,progressive loading mode} for this DataSource.
    // To prevent automatic switching to progressive loading, set this property to -1. This
    // may also be prevented on a per-request basis by setting +link{dsRequest.progressiveLoading}
    // to <code>false</code>.
    //
    // @see dataSource.progressiveLoading
    // @see dsRequest.progressiveLoading
    // @serverDS only
    // @group progressiveLoading
    // @visibility external
    //<

    //> @attr dataSource.lookAhead (int : 1 : IRW)
    // If we are +link{progressiveLoading,loading progressively}, indicates the number of
    // extra records SmartClient Server will read beyond the end record requested by the client,
    // in order to establish if there are more records to view.  This property has no effect
    // if we are not progressive-loading.
    // <p>
    // This property can be tweaked in conjunction with +link{endGap,endGap} to change behavior
    // at the end of a dataset.  For example, with the default values of <code>lookAhead: 1</code>
    // and <code>endGap: 20</code>, we can end up with the viewport shrinking if we get a case
    // where there really was only one more record (because the client was initially told there
    // were 20 more).  This is not a problem per se, but it may be surprising to the user.
    // You could prevent this happening (at the cost of larger reads) by setting
    // <code>lookAhead</code> to be <code>endGap+1</code>.
    //
    // @see dataSource.progressiveLoading
    // @see dataSource.endGap
    // @serverDS only
    // @group progressiveLoading
    // @visibility external
    //<

    //> @attr dataSource.defaultBooleanStorageStrategy (String : null : IR)
    // For +link{dataSource.serverType,serverType:"sql"} DataSources, sets the
    // default +link{dataSourceField.sqlStorageStrategy,sqlStorageStrategy} to use for boolean fields
    // where no <code>sqlStorageStrategy</code> has been declared on the field.
    // <P>
    // Can also be set system-wide via the +link{group:server_properties} setting
    // <code>sql.defaultBooleanStorageStrategy</code>, or for a particular database configuration by
    // setting <code>sql.<i>dbName</i>.defaultBooleanStorageStrategy</code> (see
    // +link{group:adminConsole,Admin Console overview} for more information on SQL configuration).
    // <p>
    // Note that when this property is unset, the default +link{dataSourceField.sqlStorageStrategy}
    // strategy is effectively "string".
    //
    // @group serverDataIntegration
    // @serverDS only
    // @visibility external
    //<

    //> @attr dataSource.endGap (int : 20 : IRW)
    // If we are +link{progressiveLoading,loading progressively}, indicates the number of
    // extra records SmartClient Server will advertise as being available, if it detects that
    // there are more records to view (see +link{lookAhead,lookAhead}).  This property has no
    // effect if we are not progressive-loading.
    // <P>
    // Note that when viewing DataSource data in a ListGrid, it is not recommended to have
    // the endGap be larger than the +link{ResultSet.resultSize}. This can result in a situation
    // where the entire range requested by the ResultSet is beyond the true end of the data set,
    // with unpredictable results.
    //
    //
    // @see dataSource.progressiveLoading
    // @see dataSOurce.lookAhead
    // @serverDS only
    // @group progressiveLoading
    // @visibility external
    //<


    // requestMaxRows
    // ----------------------------------------------------------------------------------------

    //> @attr dataSource.clientRequestMaxRows (int : -1 : IRW)
    // Applies to +link{group:sqlDataSource,SQL DataSources} only.
    // <p>
    // If this attribute is set to a non-negative value, it acts as a hard safety limit for
    // client-initiated +link{DSRequest}s for "all rows".  If the server encounters more rows
    // in a response than this safety limit, it will abort immediately with an Exception.
    // <p>
    // <b>This attribute is not meant to be a regular application facility.</b>  As mentioned
    // above, it is a safety mechanism, intended primarily to prevent bugs in development from
    // causing long delays or server Out Of Memory crashes by unintentionally issuing requests
    // that fetch huge numbers of rows (eg, by failing to specify filter criteria).
    // <p>
    // Note the following:<ul>
    // <li>This limit only has an effect when "all rows" are requested - ie, when the request
    // does not specify an +link{dsRequest.endRow,endRow}, or specifies <code>endRow:-1</code>.
    // If you specify a non-negative <code>endRow</code>, it will be honored even if that
    // means we need to return more than <code>clientRequestMaxRows</code> records</li>
    // <li>If you need to handle very large datasets in a manageable way, consider using
    // +link{group:progressiveLoading} to stream the data progressively</li>
    // <li>Note that this attribute applies to client-initiated requests only.  If you want to
    // provide a hard safety limit for all fetches, including requests initiated on the server,
    // set a +link{dataSource.requestMaxRows} instead.  If both properties are specified,
    // <code>clientRequestMaxRows</code> wins for client-initiated requests, so it is possible
    // to configure different limits for client- and server-initiated requests</li>
    // </ul>
    // <p>
    // To set a default <code>clientRequestMaxRows</code> that will apply to all dataSources
    // that do not specify the attribute, add the following to your <code>server.properties</code>
    // file:<pre>
    //     # Fail with an error if we try to fetch more than 10000 rows in a client request
    //     sql.clientRequestMaxRows: 10000
    // </pre>
    //
    // @see dataSource.clientRequestMaxRows
    // @see dataSource.progressiveLoading
    // @serverDS only
    // @visibility external
    //<

    //> @attr dataSource.requestMaxRows (int : -1 : IRW)
    // Applies to +link{group:sqlDataSource,SQL DataSources} only.
    // <p>
    // The same as +link{dataSource.clientRequestMaxRows,clientRequestMaxRows}, but applies
    // to all requests, not just client-initiated ones.  See the documentation for
    // <code>clientRequestMaxRows</code> for details.  To reiterate the warning given for
    // that property, this is a safety limit that results in an Exception being thrown: <b>it
    // is not intended to be used as a regular application facility</b>
    // <p>
    // To set a default <code>requestMaxRows</code> that will apply to all dataSources that do
    // not specify the attribute, add the following to your <code>server.properties</code>
    // file:<pre>
    //     # Fail with an error if we try to fetch more than 50000 rows in any request
    //     sql.clientRequestMaxRows: 50000
    // </pre>
    //
    // @see dataSource.clientRequestMaxRows
    // @see dataSource.progressiveLoading
    // @serverDS only
    // @visibility external
    //<



    // cacheAllData implementation
    // ----------------------------------------------------------------------------------------

    //> @attr dataSource.cacheAllData (Boolean : null : IRW)
    // Set this property to true to have a DataSource fetch all of its data client-side on the
    // first fetch request.  However, unlike a +link{dataSource.clientOnly,clientOnly} DataSource, this DataSource
    // will still save changes normally, sending remote requests.
    // <P>
    // You can manually set this attribute after initialization by calling
    // +link{setCacheAllData}; setting +link{autoCacheAllData}:true causes a DataSource to
    // automatically switch to <code>cacheAllData:true</code> when a fetch results in the
    // entire dataset being brought client-side.
    // <P>
    // To cause automatic cache updates, you can set +link{cacheMaxAge} to a number of seconds
    // and once data has been client-side for that length of time, the next fetch causes the
    // cache to be dropped and a new cache retrieved.
    // <P>
    // Note that multiple +link{operationBindings} of type "fetch" which return distinct
    // results will not work with <code>cacheAllData</code>: only one cache is created and is
    // used for all fetch operations, regardless of whether +link{dsRequest.operationId} has
    // been set.  However, "fetch" operationBindings used as a
    // +link{operationBinding.cacheSyncOperation} will work normally, so long as they return
    // all data fields that are returned by the default "fetch" operation, so that the cache
    // can be updated.
    // <P>
    // To specify which operationId to use for fetching all data, use
    // +link{dataSource.cacheAllOperationId, cacheAllOperationId}.
    // <p>
    // To use the cache only for requests that have the <code>cacheAllOperationId</code>,
    // allowing any other operationId (or absence of an operationId) to contact the server as
    // normal, set +link{dataSource.cacheAcrossOperationIds,cacheAcrossOperationIds}.
    //
    // @setter setCacheAllData
    // @group clientData
    // @visibility external
    //<

    //> @attr dataSource.cacheAllOperationId (String : null : IR)
    // +link{dsRequest.operationId} to use for fetching data in case +link{dataSource.cacheAllData, cacheAllData} is
    // true.  By default a standard fetch operation is used (with no <code>operationId</code>
    // specified).
    // @group clientData
    // @visibility external
    //<

    //> @attr dataSource.cacheAcrossOperationIds (Boolean : true : IR)
    // When +link{dataSource.cacheAllData,cacheAllData} mode is enabled and a
    // +link{dataSource.cacheAllOperationId} has been set, this flag affects whether cached
    // results are used for all "fetch" requests regardless of their
    // +link{dsRequest.operationId}, or are used only for "fetch" requests that use the
    // <code>cacheAllOperationId</code>, allowing other requests to go to server normally.
    // <p>
    // Default of <code>true</code> means that the <code>cacheAllOperationId</code> will be
    // used to fetch all rows, but the resulting cache will be used for all "fetch" operations
    // regardless of the <code>operationId</code> specified on the request.
    // <p>
    // Switching to "false" effectively creates caching just for one specific
    // <code>operationId</code> - the <code>cacheAllOperationId</code> - while allowing all
    // other requests to go to the server normally.
    //
    // @group clientData
    // @visibility external
    //<
    cacheAcrossOperationIds : true,

    //> @method dataSource.setCacheAllData()
    // Call this method to switch cacheAllData on or off after initialization.  Passing a
    // <code>shouldCache</code> value of false clears any existing client-side cache,
    // cancels any outstanding requests for a full cache and issues any other pending requests
    // normally.
    //
    // @param shouldCache (Boolean) New value for +link{cacheAllData}
    // @group clientData
    // @visibility external
    //<
    setCacheAllData : function (shouldCache) {
        if (!shouldCache) {
            if (this.cacheAllData == true) {
                if (this.logIsInfoEnabled("cacheAllData")) {
                    this.logInfo("setCacheAllData(false): clearing the cache and any "+
                        "deferred requests", "cacheAllData");
                }
                // TODO: reset to normal operation
                delete this._autoCacheAllData_timestamp;
                // 1) clear the cache if there is one
                this.invalidateCache();
                this.cacheAllData = false;
                // 2) cancel and ignore any outstanding "fetch" requests for a full cache
                this.clearDeferredRequests();

                if (this._insulatedTransforms == true) {
                    // remove these custom methods - sendDSRequest() has logic that differs for clientCustom
                    // request if _isServerRequest is present
                    delete this._insulatedTransforms;
                    delete this._isServerRequest;
                    if (this.transformServerRequest) {
                        this.transformRequest = this.transformServerRequest;
                        delete this.transformServerRequest;
                    }
                    if (this.transformServerResponse) {
                        this.transformResponse = this.transformServerResponse;
                        delete this.transformServerResponse;
                    }
                }
            }
        } else {
            if (this.logIsInfoEnabled("cacheAllData")) {
                this.logInfo("setCacheAllData(true): invalidate the cache", "cacheAllData");
            }
            this.cacheAllData = true;
            this._autoCacheAllData_timestamp = isc.timestamp();
            this.invalidateCache();
        }
    },

    //> @attr dataSource.cacheMaxAge (Number : 60 : IRW)
    // The maximum time, in seconds, to maintain the client-side cache.  If a fetch occurs after
    // the cacheMaxAge has expired, the current cache will be dropped and another complete
    // cache fetched.
    // @group clientData
    // @visibility external
    //<
    cacheMaxAge: 60,
    // cacheLastFetchTime - the time at which the client-side cache became valid - this value +
    // the cacheMaxAge determines when the cache will be invalidated.
    cacheLastFetchTime: 0,

    cacheNeedsRefresh : function () {
        var currentTime = new Date().getTime(),
            elapsedSeconds = ((currentTime - this.cacheLastFetchTime) / 1000),
            result = (this.cacheLastFetchTime == 0 || elapsedSeconds > this.cacheMaxAge)
        ;

        if (this.logIsInfoEnabled("cacheAllData")) {
            this.logInfo("cacheNeedsRefresh returns "+result, "cacheAllData");
        }

        return result;
    },

    //> @attr dataSource.cacheData (Array of Record : null : IRW)
    // For a +link{cacheAllData} or client-only DataSource, a set of records to use as a dataset,
    // specified as an Array of JavaScript Objects representing records.
    // <P>
    // See +link{group:clientOnlyDataSources,this discussion} for ways to populate a
    // client-only DataSource with cache data.
    // <P>
    // Additionally, when a DataSource is loaded in +link{mockMode}, <code>cacheData</code>,
    // if provided, is used as the mock data.
    // <P>
    // For any other DataSource, <code>cacheData</code> is dropped when loaded.
    // @setter setCacheData
    // @group clientData
    // @visibility external
    //<

    //> @method dataSource.setCacheData()
    // Call this method to set the data in the client-side cache after initialization.
    // @param data (Array of Record) Array of records to apply as the client-side cache
    // @group clientData
    // @visibility external
    //<

    updateCachesOnSetCacheData: true,
    setCacheData : function (data, skipUpdateCaches) {
        // Drop the indexed cache if we have one.
        this._updateIndexedCache();

        if (this.cacheAllData || this.clientOnly) {
            if (this.logIsInfoEnabled("cacheAllData")) {
                this.logInfo("setCacheData: invalidating the cache", "cacheAllData");
            }

            this.clearDeferredRequests();
            this.invalidateCache(this.updateCachesOnSetCacheData && !skipUpdateCaches);

            // set the cacheData

            this.cacheData = this.testData = data;

            // At this point our cacheData is fresh - reset the timer so the 'needsRefresh' method
            // returns false and doesn't ignore it!
            this.cacheLastFetchTime = new Date().getTime();

            if (this.logIsInfoEnabled("cacheAllData")) {
                this.logInfo("setCacheData: cacheData has been set", "cacheAllData");
            }

        }
    },

    //> @attr dataSource.testData (Array of Record : null : IRW)
    // For a client-only DataSource, a set of records to use as a dataset, specified as an
    // Array of JavaScript Objects.
    // <P>
    // See +link{group:clientOnlyDataSources,this discussion} for ways to populate a
    // client-only DataSource with test data.
    // @setter setTestData
    // @group clientData
    // @visibility external
    // @deprecated In favor of +link{dataSource.cacheData}.
    //<

    //> @method dataSource.setTestData()
    // Call this method to set the data in the client-side test-data after initialization.
    // @param data (Array of Record) Array of records to apply as the client-side test-data
    // @group clientData
    // @visibility external
    // @deprecated In favor of +link{dataSource.setCacheData()}.
    //<
    setTestData : function (data, invalidateCache) {
        this.setCacheData(data,invalidateCache);
    },

    //> @attr dataSource.sendParentNode (Boolean : false : IRWA)
    // Set this attribute if you need to send the dsRequest.parentNode to the server-side.
    // @visibility external
    //<
    sendParentNode : false,

    // clear deferred requests - support passing in requestTypes to cancel or "any" to clear
    // all pending requests - if no requestTypes passed, assume "any"
    clearDeferredRequests : function (requestTypes) {
        if (!this._deferredRequests) return;
        requestTypes = requestTypes || "any";
        if (!isc.isAn.Array(requestTypes)) requestTypes = [requestTypes];

        if (this.logIsInfoEnabled("cacheAllData")) {
            this.logInfo("clearDeferredRequests: "+this._deferredRequests.length+" requests, "+
                "clearing those of type "+isc.echoAll(requestTypes), "cacheAllData");
        }

        if (requestTypes.contains("any")) delete this._deferredRequests;
        else {
            if (this._deferredRequests) {
                var requests = this._deferredRequests;
                for (var i=requests.length; i>=0; i--) {
                    var type = requests[i].operationType || "fetch";
                    if (requestTypes.contains(type)) this._deferredRequests.removeAt(i);
                }
                if (this._deferredRequests.length == 0) delete this._deferredRequests;
            }
        }
    },

    // process any deferred requests that are still outstanding
    processDeferredRequests : function () {
        if (!this._deferredRequests) return;
        if (this.logIsInfoEnabled("cacheAllData")) {
            this.logInfo("processDeferredRequests: processing "+this._deferredRequests.length+
                " deferred requests", "cacheAllData");
        }

        var deferredRequests = this._deferredRequests;
        this.clearDeferredRequests();
        // call all deferred requests
        for (var i = 0; i < deferredRequests.length; i++) {
            this.sendDSRequest(deferredRequests[i]);
        }
    },

    //> @method dataSource.invalidateCache()
    // Drop the current dataSource cache. This has two effects:
    // <ul>
    // <li>For DataSources +link{cacheAllData} or +link{dataSource.clientOnly,clientOnly}, discard
    //     the current client-side cache data.</li>
    // <li>If <code>notify</code> is passed, cause all +link{ResultSet,data objects} associated with this
    //     dataSource to drop their caches. This occurs
    //     regardless of the dataSource type - and can be thought of as  equivalent to
    //     processing a response with +link{dsResponse.invalidateCache} set.</li>
    // </ul>
    // @param [notify] (boolean) Should data objects associated with this dataSource have their
    //   cache invalidated?
    // @group clientData
    // @visibility external
    //<
    invalidateCache : function (notify) {
        if (this.cacheAllData || this.clientOnly) {

            if (this.logIsInfoEnabled("cacheAllData")) {
                this.logInfo("invalidateCache: invalidating client-side cache", "cacheAllData");
            }

            delete this.cacheData;
            delete this.testData;
            this.cacheLastFetchTime = 0;
            if (this.cacheResultSet) {
                this.cacheResultSet.destroy();
                delete this.cacheResultSet;
            }
        }
        if (notify) {
            this.updateCaches({status:0, invalidateCache:true});
        }
    },

    //> @method dataSource.setClientOnly()
    // Switch into or out of clientOnly mode, taking the cache from the cacheAllData ResultSet
    // if it exists.
    // @group clientData
    // @visibility external
    //<

    setClientOnly : function (clientOnly, fetchCacheData) {

        //if (this.clientOnly == clientOnly) return;

        // entering clientOnly mode
        if (clientOnly) {
            this.clientOnly = true;

            if (this.enforceSecurityOnClient != false) this.enforceSecurityOnClient = true;

            // special handling for cacheAllData mode; try to populate cacheData/testData
            if (this.cacheAllData) {
                // if the cacheResultSet RS is present, just use it to populate the caches
                if (this.cacheResultSet) {
                    if (this.logIsInfoEnabled("cacheAllData")) {
                        this.logInfo("setClientOnly: sourcing from client-cache", "cacheAllData");
                    }
                    this.cacheData = this.testData = this.cacheResultSet.getAllRows();
                    return true;

                // otherwise, if legacy mode requested, we're done
                } else if (fetchCacheData == false) {
                    return false;
                }
                // temporarily revert clientOnly:true if server data requested
                if (fetchCacheData) this.clientOnly = false;
            }

            // clear in-flight requests, clear cache, and fetch data for cache
            this.clearDeferredRequests();
            this.invalidateCache();
            this.performDSOperation("fetch");

            // if clientOnly:true was cleared for server fetch, set it now
            if (!this.clientOnly) {
                this.clientOnly = true;
            }

        // leaving clientOnly mode
        } else {
            this.clearDeferredRequests();
            this.invalidateCache();
            this.clientOnly = false;
        }
    },

    //> @method dataSource.hasAllData()
    // When +link{dataSource.cacheAllData} is true, has all the data been retrieved to the client?
    // @return (Boolean) All data has been fetched from the server and is available client-side
    // @group clientData
    // @visibility external
    //<
    hasAllData : function () {
        if (this.cacheResultSet) return this.cacheResultSet.lengthIsKnown();
        else return false;
    },

    //> @attr dataSource.autoCacheAllData (Boolean : false : IR)
    // When a DataSource is not +link{dataSource.cacheAllData}:true and a fetch results in the
    // entire dataset being retrieved, this attribute being set to true causes the DataSource
    // to automatically switch to <code>cacheAllData:true</code> and prevent further server-trips for fetch
    // requests.
    // <p>
    // +link{dataSource.cacheAllData, cacheAllData} is automatically enabled in either of these conditions:
    // <ul>
    //   <li>
    //     The request has no criteria and no startRow/endRow request properties. The latter can
    //     be accomplished by disabling paging with a +link{dataBoundComponent.dataFetchMode,dataFetchMode}
    //     setting of "basic" or "local" or by an explicit fetchData request with those request properties
    //     excluded.
    //  </li>
    //  <li>
    //     The request has no criteria but has startRow/endRow specified and the response received has
    //     all data available (<code>startRow:0</code> and <code>endRow:totalRows</code>).
    //  </li>
    // </ul>
    // @group clientData
    // @visibility external
    //<
    autoCacheAllData: false,

    //> @attr dataSource.useTestDataFetch (boolean : null : IRW)
    // When set, causes a +link{clientOnly, client-only} or +link{cacheAllData} DataSource to
    // create a second DataSource to perform it's one-time fetch.  By default, this attribute
    // will be considered true when clientOnly is true, cacheAllData is false or unset and
    // a dataURL or testFileName is specified on the DataSource.
    // @group clientData
    // @visibility external
    //<


    criteriaContainsDates : function (criteria) {
        var fieldNames = this.getCriteriaFields(criteria);

        if (fieldNames && fieldNames.length > 0) {
            for (var i=0; i<fieldNames.length; i++) {
                var field = this.getField(fieldNames[i]);
                if (!field) continue;
                if (isc.SimpleType.inheritsFrom(field.type, "date") ||
                            isc.SimpleType.inheritsFrom(field.type, "datetime")) {
                    return true;
                }
            }
        }

        return false;
    },

    //> @method dataSource.convertRelativeDates ()
    // Takes all relative date values found anywhere within a Criteria / AdvancedCriteria object
    // and converts them to concrete date values, returning the new criteria object.
    // @param criteria (Criteria) criteria to convert
    // @param [timezoneOffset] (String) optional timezone offset.  Defaults to the current timezone
    // @param [firstDayOfWeek] (Integer) first day of the week (zero is Sunday).  Defaults to
    //                               +link{DateChooser.firstDayOfWeek}
    // @param [baseDate] (Date) base value for relative conversion - defaults to now
    // @return (Criteria) new copy of the criteria with all relative dates converted
    // @visibility external
    //<
    convertRelativeDates : function (criteria, timezoneOffset, firstDayOfWeek, baseDate) {
        // just bail if passed null criteria
        if (!criteria) return null;

        if (!this.criteriaContainsDates(criteria)) {
            // there are no date fields in the criteria - no point continuing, just return it
            return criteria;
        }

        if (!this.isAdvancedCriteria(criteria) && criteria.operator == null) {
            // this is neither an AdvancedCriteria nor a simple Criterion object so no point
            // parsing it, just return it as-is
            return criteria;
        }

        // get a copy of the criteria to alter and return - it's ok to use clone() here as
        // we've already confirmed the param is criteria above
        var result = isc.clone(criteria);

        baseDate = baseDate || new Date();

        if (firstDayOfWeek == null) firstDayOfWeek = isc.DateUtil.getFirstDayOfWeek();

        if (result.criteria && isc.isAn.Array(result.criteria)) {
            // complex sub-criteria, call this method again with that criteria
            var subCriteria = result.criteria;

            for (var i = subCriteria.length-1; i>=0; i--) {
                var subItem = subCriteria[i];

                if (!subItem) {
                    if (this.logIsInfoEnabled("relativeDates")) {
                        this.logInfo("Removing NULL subCriteria...", "relativeDates");
                    }
                    result.criteria.removeAt(i);
                } else {
                    if (subItem.criteria && isc.isAn.Array(subItem.criteria)) {
                        if (this.logIsInfoEnabled("relativeDates")) {
                            this.logInfo("Calling convertRelativeDates from convertRelativeDates "+
                                "- data is:\n\n"+isc.echoFull(subItem)+"\n\n"+
                                "criteria is: \n\n"+isc.echoFull(criteria)
                                ,"relativeDates"
                            );
                        }

                        result.criteria[i] = this.convertRelativeDates(subItem, timezoneOffset,
                            firstDayOfWeek, baseDate);

                        if (this.logIsInfoEnabled("relativeDates")) {
                            this.logInfo("Called convertRelativeDates from convertRelativeDates "+
                            "- data is\n\n" + isc.echoFull(result.criteria[i]), "relativeDates");
                        }
                    } else {
                        result.criteria[i] = this.mapRelativeDate(subItem, baseDate);
                    }
                }
            }
        } else {
            // simple criterion
            result = this.mapRelativeDate(result, baseDate);
        }

        if (this.logIsInfoEnabled("relativeDates")) {
            this.logInfo("Returning from convertRelativeDates - result is:\n\n"+
                isc.echoFull(result)+"\n\n"+
                "original criteria is: \n\n"+isc.echoFull(criteria)
                ,"relativeDates"
            );
        }

        return result;
    },

// helper method to map the relative date in a single criterion
    mapRelativeDate : function (criterion, baseDate) {
        var result = isc.addProperties({}, criterion),
            rangeStart,
            value
        ;

        baseDate = baseDate || new Date();

        var fieldName = result.fieldName,
            field = fieldName ? this.getField(fieldName) : null,
            type = field ? field.type : null
        ;



        var logicalDate = isc.SimpleType.inheritsFrom(type, "date");


        if (result.value && isc.isAn.Object(result.value) && result.value._constructor == "RelativeDate")
        {
            // we have a criterion with a "value" and it's a relativeDate - parse it now
            value = result.value.value;

            var tempValue = isc.DateUtil.getAbsoluteDate(value, baseDate,
                                            result.value.rangePosition, logicalDate || result.value.logicalDate);

            // if the field is a "datetime", we may want to manipulate the criteria a bit,
            // without losing the relativeDate original, and depending on the operator
            // -----
            // we only want to to this for some of the pre-defined internal relativeDate
            // strings, those that represent a specific day - $yesterday, $today and $tomorrow
            if (!logicalDate && ["$yesterday", "$today", "$tomorrow"].contains(value)) {
                switch (result.operator) {
                    case "equals":
                        // equals for a relativeDate needs to do a between dayStart/dayEnd
                        result.operator = "betweenInclusive";
                        result.start = isc.DateUtil.getStartOf(tempValue, "D");
                        result.end = isc.DateUtil.getEndOf(tempValue, "D");
                        delete result.value;
                        break;
                    case "notEqual":
                        // notEqual for a relativeDate needs to do a NOT between dayStart/dayEnd
                        result._constructor = "AdvancedCriteria";
                        result.operator = "not";
                        result.criteria = [
                            { operator: "betweenInclusive", fieldName: result.fieldName,
                                start: isc.DateUtil.getStartOf(tempValue, "D"),
                                end: isc.DateUtil.getEndOf(tempValue, "D")
                            }
                        ];
                        delete result.value;
                        delete result.fieldName;
                        break;
                    case "lessThan":
                    case "greaterOrEqual":
                        // less/greaterOrEqual for a relativeDate needs to do a dayStart
                        result.value = isc.DateUtil.getStartOf(tempValue, "D");
                        break;
                    case "greaterThan":
                    case "lessOrEqual":
                        // startsWith for a relativeDate needs to do a dayEnd
                        result.value = isc.DateUtil.getEndOf(tempValue, "D");
                        break;
                    default:
                        result.value = tempValue;
                }
            } else {
                result.value = tempValue;
            }
        } else {
            if (result.start && isc.isAn.Object(result.start) &&
                result.start._constructor == "RelativeDate")
            {
                // we have a criterion with a "start" and it's a relativeDate - parse it now
                // Always default to start of range for ambiguous shortcuts like "$today"
                value = result.start.value;
                result.start = rangeStart = isc.DateUtil.getAbsoluteDate(value, baseDate,
                                                    "start", logicalDate || result.start.logicalDate);
            }
            if (result.end && isc.isAn.Object(result.end) &&
                result.end._constructor == "RelativeDate")
            {
                // we have a criterion with an "end" and it's a relativeDate - convert it now
                // Default to end of ambiguous shortcuts like "$today"
                value = result.end.value;
                result.end = isc.DateUtil.getAbsoluteDate(value, baseDate, "end", logicalDate || result.end.logicalDate);
            }
        }

        return result;
    },


    embedTimezoneInRelativeDates : function (criteria, baseDate) {
        // just bail if passed null criteria
        if (!criteria) return null;

        if (!this.criteriaContainsDates(criteria)) {
            // there are no date fields in the criteria - no point continuing, just return it
            return criteria;
        }

        if (!this.isAdvancedCriteria(criteria) && criteria.operator == null) {
            // this is neither an AdvancedCriteria nor a simple Criterion object so no point
            // parsing it, just return it as-is
            return criteria;
        }

        // get a copy of the criteria to alter and return - it's ok to use clone() here as
        // we've already confirmed the param is criteria above
        var result = isc.clone(criteria);

        baseDate = baseDate || new Date();

        if (result.criteria && isc.isAn.Array(result.criteria)) {
            // complex sub-criteria, call this method again with that criteria
            var subCriteria = result.criteria;

            for (var i = subCriteria.length-1; i>=0; i--) {
                var subItem = subCriteria[i];

                if (!subItem) {
                    if (this.logIsInfoEnabled("relativeDates")) {
                        this.logInfo("Removing NULL subCriteria...", "relativeDates");
                    }
                    result.criteria.removeAt(i);
                } else {
                    if (subItem.criteria && isc.isAn.Array(subItem.criteria)) {
                        result.criteria[i] = this.embedTimezoneInRelativeDates(subItem, baseDate);
                    } else {
                        if (subItem.value && isc.isAn.Object(subItem.value) &&
                                        subItem.value._constructor == "RelativeDate")
                        {
                            result.criteria[i].value.browserTZ = isc.Time.getDefaultDisplayTimezone();
                        }
                    }
                }
            }
        } else {
            // simple criterion
            if (result.value && isc.isAn.Object(result.value) &&
                            result.value._constructor == "RelativeDate")
            {
                result.value.browserTZ = isc.Time.getDefaultDisplayTimezone();
            }
        }

        if (this.logIsInfoEnabled("relativeDates")) {
            this.logInfo("Returning from embedTimezoneInRelativeDates - result is:\n\n"+
                isc.echoFull(result)+"\n\n"+
                "original criteria is: \n\n"+isc.echoFull(criteria)
                ,"relativeDates"
            );
        }

        return result;
    },

    //> @attr dataSource.autoConvertRelativeDates (Boolean : true : IR)
    // Whether to convert relative date values to concrete date values before sending to the
    // server.  Default value is true, which means that the server does not need to understand
    // how to filter using relative dates - it receives all date values as absolute dates.
    // <p>
    // If the server would receive relative date values from the client, by default they would
    // be unchanged in DMI and automatically converted during the request execution. This may
    // be changed via <code>server.properties</code> setting <code>datasources.autoConvertRelativeDates</code>
    // which can be set to the following values:
    // <ul>
    // <li/><code>postDMI</code> - the default value described above
    // <li/><code>preDMI</code> - relative date values will be converted to absolute date values
    // right away, so they will be already converted in DMI
    // <li/><code>disabled</code> - relative date values will not be automatically converted, so it
    // must be done completely manually or by calling the
    // <code>DSRequest.convertRelativeDates()</code> server-side API.
    // </ul>
    // Normally there is no need to convert relative dates on the server, this is done by default on
    // the client before the request is sent to the server. The primary purpose for converting relative
    // dates on the server is when there is a need to store and use relative dates at a later point such
    // as in an automated job without any involvement from the client. See more details in the
    // javadoc for <code>DataSource.convertRelativeDates(Criterion)</code> server-side API.
    //
    // @serverDS allowed
    // @visibility external
    //<

    autoConvertRelativeDates: true,

    //> @attr dataSource.showFieldsAsTree (boolean : false : IR)
    // If set, certain components that show lists of fields from this DataSource (including the
    // +link{FieldPicker}) will show them as a tree.
    // <P>
    // The tree structure is created by using +link{tree.modelType,modelType:"parent"} with the
    // +link{dataSourceField.fieldTreeId} and +link{dataSourceField.fieldTreeParentId} properties.
    //<
    showFieldsAsTree: false,

    //> @attr dataSource.fieldTreeRootValue (boolean : null : IR)
    // Value of +link{tree.rootValue}} used if +link{dataSource.showFieldsAsTree} is true
    //<


    //> @attr DataSource.autoDiscoverTree (boolean : false : IR)
    //  Causes +link{Tree.discoverTree} to be called on dsResponse.data in order to automatically
    // discover tree structures in the response data.
    // <P>
    // If autoDiscoverTree is set, discoverTree() is called after the default dsResponse.data
    // has been derived (+link{operationBinding.recordXPath,recordXPath} and
    // +link{dataSourceField.valueXPath,valueXPath} have been applied) and after
    // +link{transformResponse()} has been called.
    // <P>
    // If a DataSourceField is declared with
    // +link{dataSourceField.childrenProperty,childrenProperty:true}, discoverTree() will be invoked with
    // +link{discoverTreeSettings.newChildrenProperty,settings.newChildrenProperty} set to the name of
    // the field marked as the childrenField.  Similarly, if the DataSource has a
    // +link{titleField} it will be used as the
    // +link{discoverTreeSettings.nameProperty,settings.nameProperty}.
    //
    // @visibility external
    //<
    autoDiscoverTree: false,

    //> @attr DataSource.discoverTreeSettings (DiscoverTreeSettings : null : IR)
    // Settings to use when discoverTree() is automatcially called because
    // +link{DataSource.autoDiscoverTree} is set to true for this DataSource
    //
    // @visibility external
    //<

    //> @attr dataSource.useAnsiJoins (boolean : null : [IR])
    // For DataSources using the +link{group:sqlDataSource,SmartClient SQL engine} for
    // persistence, whether to use ANSI-style joins (ie, joins implemented with JOIN directives
    // in the table clause, as opposed to additional join expressions in the where clause).
    // The default value of null has the same meaning as setting this flag to false.
    // <P>
    // Note, outer joins (see +link{dataSourceField.joinType,joinType}) do not work with all
    // supported database products unless you use ANSI joins.  Other than that, the join
    // strategies are equivalent.
    // <P>
    // If you wish to switch on ANSI-style joins for every DataSource, without the need to
    // manually set this property on all of them, set
    // +link{group:server_properties,server.properties} flag
    // <code>sql.useAnsiJoins</code> to true.
    //
    // @group serverDataIntegration
    // @see OperationBinding.includeAnsiJoinsInTableClause
    // @requiresModules SCServer
    // @serverDS only
    // @visibility external
    //<


    //> @attr dataSource.trimMilliseconds (boolean : null : IR)
    // For this dataSource, should the millisecond portion of time and datetime values be
    // trimmed off before before being sent from client to server or vice versa.  By default,
    // millisecond information is preserved (ie, it is not trimmed).  You only need to consider
    // trimming millisecond values if their presence causes a problem - for example, a custom
    // server that is not expecting that extra information and so fails parsing.
    // <p>
    // Note that there is no inherent support for millisecond precision in SmartClient widgets;
    // if you need millisecond-precise visibility and editability of values in your client,
    // you must write custom formatters and editors (or sponsor the addition of such things to
    // the framework).  Server-side, millisecond-precise values are delivered to and obtained
    // from DataSources, so DataSource implementations that are capable of persisting and
    // reading millisecond values should work transparently.  Of the built-in DataSource types,
    // the JPA and Hibernate DataSources will transparently handle millisecond-precise values
    // as long as the underlying database supports millisecond precision, and the underlying
    // column is of an appropriate type.  The SQLDataSource provides accuracy to the nearest
    // second by default; you can switch on millisecond precision per-field with the
    // +link{DataSourceField.storeMilliseconds,storeMilliseconds} attribute.
    //
    // @serverDS allowed
    // @visibility external
    //<

    // Used by getFilenameField(), getFilesizeField() and getDateCreatedField()
    _filenameField: {},
    _filesizeField: {},
    _dateCreatedField: {},

    sortByIndexability : function (fields) {
        isc.DS.sortByIndexability(fields, this);
    }

});

//> @type ValueMap
// A ValueMap defines the set of legal values for a field, and optionally allows you to provide
// a mapping from stored values to values as seen by the end user.
// <P>
// A valueMap can be specified as either an Array of legal values, or as an +link{type:Object}
// where each property maps a stored value to a user-displayable value.  See
// +link{DataSourceField.valueMap} for how to express a ValueMap in
// +link{group:componentXML,Component XML}.
// <P>
// A ValueMap can be entirely static or entirely dynamic, with many options in between.  For
// example, a ValueMap may be:
// <ul>
// <li> statically defined in a JavaScript or XML file.  Such a valueMap changes only when
// application code is upgraded.
// <li> generated dynamically by server code when the application first loads, for example,
// by generating JavaScript or XML dynamically in a .jsp or .asp file.  Such a valueMap may be
// different for each session and for each user.
// <li> loaded on demand from a DataSource, via the
// +link{PickList.optionDataSource,optionDataSource} property, or via a call to
// +link{dataSource.fetchData()} where a valueMap is derived dynamically from the returned data
// (see +link{dataSource.fetchData()} for an example).  Such a valueMap may be updated at any
// time, for example, every time the user changes a related field while editing data.
// </ul>
// See also the +link{group:smartArchitecture,SmartClient Architecture Overview} to understand
// the best architecture from a performance and caching perspective.
// @serverDS allowed
// @visibility external
//<

//> @object DataSourceField
// Metadata about a DataSourceField, including its type and validators.
// @inheritsFrom Field
// @treeLocation Client Reference/Data Binding/DataSource
// @serverDS allowed
// @visibility external
//<

//> @attr dataSourceField.name (FieldName : null : [IR])
// Name for this field.
// <P>
// Must be unique across all fields within the DataSource as well as a valid JavaScript
// identifier - see +link{FieldName} for details and how to check for validity.
// <P>
// The field name is also the property in each DataSource record which holds the value for this
// field.
// <P>
// Note: If this is a +link{dataSource.serverType,SQL-backed} dataSource, the field name should
// be a valid SQL colmn name, or the +link{dataSourceField.nativeName} property should
// be set to a valid column name.
//
// @group basics
// @serverDS allowed
// @visibility external
//<

//> @attr dataSourceField.description (String : null : [IRW])
// An optional description of the DataSourceField's meaning. It is not automatically exposed on any
// component, but it is useful for developer documentation, and as such it is included on any
// +link{group:openapiSupport, OpenAPI specification} generated by the framework.  Markdown is
// a commonly-used syntax, but you may also embed HTML content. When embedding HTML in the
// description in a .ds.xml file (see +link{group:dataSourceDeclaration}), it is recommended
// to wrap the HTML in a CDATA tag.
// <p>
// This description is also provided to AI when AI is asked to work with the field. Best practices
// for the description are:
// <ul>
// <li>Start with a plain language explanation of what the field represents in the real world,
// its business concept or core purpose. For example:
// <code>order_subtotal</code> might be "Total price of the customer's order before tax and shipping."
// <li>If the field involves time, clarify what moment in time the value applies to, and how
// the value relates to other timestamps in the record. For example:
// <code>updated_timestamp</code> might be "The last time when any value of the record was updated.
// Always greater or equal to 'created_timestamp'."
// <li>If a numeric field, clearly identify the units if there are any.
// <li>When not +link{DataSourceField.required, required} (i.e. the value may be <code>NULL</code>),
// describe the interpretation of a <code>NULL</code> value. Does the absence of a value have
// a specific meaning, or does it mean that the data is not available, unknown, or pending?
// <li>If values are constrained within a certain range or domain, identify the bounds or possible
// values.
// <li>If values take a certain format, identify this format and fully describe each part.
// <li>Include descriptions of how the field relates to or depends on others.
// <li>Give a brief note about how the field is populated. This might include the source of the
// data, formula(s) used to calculate the value, and the frequency and timing of updates.
// </ul>
// <p>
// Sample values in the description may be appropriate, but a better practice is to
// provide +link{DataSource.sampleData, sampleData} on the data source, which show AI sample
// values in the context of complete record(s) from the data source.
// @see DataSource.description
// @serverDS allowed
// @visibility external
//<

//> @attr dataSourceField.type                 (FieldType : null : [IR])
// Type of this field.  Required for all DataSource fields.
// <P>
// Field type may imply automatic validators (for example, an integer field cannot accept the
// value "foo").  Field type also affects the default behaviors of DataBound components, for
// example, if a field is declared as type "date", components that edit that field will
// automatically choose a date-editing interface with pop-up date picker.
// @group basics
// @serverDS allowed
// @visibility external
//<


//> @attr dataSourceField.mimeType (String : null : IR)
// For a +link{group:binaryFields,binary field}, sets a fixed mime type for all files stored
// to this field.  Should be set to a standard mime type string, for example, "text/plain" for
// a .txt file.
// <P>
// This is useful if a binary field only stored one type of file and you chose not to store
// filenames, since the extension of the file name is normally used to determine the mime type.
// @serverDS only
// @visibility external
//<

// Validation
// --------------------------------------------------------------------------------------------

//> @attr dataSourceField.required             (boolean : null : [IR])
// Indicates this field must be non-null in order for a record to pass validation. Or, in the
// case of a "binary" field, a non-empty file must be uploaded.  Setting this property has the
// same effect as giving the field a +link{type:ValidatorType,"required" validator}.
// <P>
// Note that <code>required</code> should not be set for a server-generated field, such as a
// sequence, or validation will fail on the client.
// <h3>Conditionally required fields</h3>
// Adding an +link{Validator.applyWhen,applyWhen} condition to a <code>required</code>
// validator introduces subtle complexities to the process of validating an existing record.
// The client is not guaranteed to know the full and complete state of the record it is
// editing because it is common for a +link{class:DynamicForm} to be editing a subset of
// fields.  When a field is <i>unconditionally</i> required, things are simple: if the
// DynamicForm has a +link{FormItem} for that field, then the <code>required</code> validation
// passes if that FormItem has a value, and fails if it does not.  If the form has no FormItem
// for the field, it can assume that the field has a value because otherwise it would have
// failed validation when we attempted to add it (when we are adding a record, we of course do
// know the full and complete state of the record - it is whatever we are about to add).
// <p>
// When a field is <i>conditionally</i> required, the client can no longer assume that all
// required fields will have a value.  It may be the case that the condition of requirement
// was not met when the record was added, but now it is.  For example, consider these field
// definitions:<pre>
//    &lt;field name="yearsAtCurrentAddress" type="integer" /&gt;
//    &lt;field name="previousAddress" type="text" &gt;
//      &lt;validator type="required" errorMessage="Previous address is required if you have been at your current address less than three years"&gt;
//        &lt;applyWhen operator="and"&gt;
//          &lt;criteria&gt;
//            &lt;criterion fieldName="yearsAtCurrentAddress" operator="lessThan" value="3" /&gt;
//          &lt;/criteria&gt;
//        &lt;/applyWhen&gt;
//      &lt;/validator&gt;
//    &lt;/field&gt;
// </pre>
// Imagine a record for this DataSource is added where the user has entered a value of "3" for
// "yearsAtCurrentAddress", and no previous address.  Later, the value of that field is
// changed to "2".  If this is done using a form that is also showing the "previousAddress"
// field, we will know that "previousAddress" has not been provided, so we can fail the
// validation and the user will get a helpful error message explaining what the problem is.
// <p>
// However, if the form does not also show the "previousAddress" field, we may choose to use an
// +link{class:operationBinding} that uses +link{operationBinding.outputs,outputs} to trim the
// record down to just the fields the form does contain, in the interests of avoiding
// information leakage.  Or perhaps that value is automatically culled from the record before
// the client sees it by the application of a +link{dataSourceField.viewRequires,declarative security rule}.
// Whatever the reason, if the client does not have the complete record, it is not possible
// for the client to sensibly apply this validation.  And because the client has no way of
// knowing if a value is missing because it is genuinely null, or because it has been trimmed
// away by the server, we must treat any null value with suspicion (unless it has a matching
// FormItem - the presence of the FormItem means that the user can edit the value, so it
// would make no sense to pair it with a trimmed record that excludes that field value).
// <p>
// When this happens, we mark the validation as having passed on the client, but in need of
// running on the server.  The server validation makes use of the "storedRecord" facility
// (look for the description of <b>$storedRecord</b> in the
// +link{group:velocitySupport,Velocity support overview}) to overlay the changed record on
// top of the existing record as it currently exists in the database.  This gives the validator
// the complete record including both changed and unchanged values, so it is able to carry
// out the required check in a meaningful way.  However, you should be aware that the
// combination of conditional "required" validators and DynamicForms that edit partial
// records can result in a validation that cannot run on the client and must do both a server
// roundtrip and a database fetch.
// @see Validator.applyWhen
// @group dataType
// @serverDS allowed
// @visibility external
//<

//> @attr dataSourceField.requiredMessage (String : null : [IRW])
// The required message when a field that has been marked as
// +link{DataSourceField.required,required} is not filled in by the user.
// <p>
// Note that this setting wins over +link{dataSource.requiredMessage} if both are set.
// @group formTitles
// @visibility external
//<

//> @attr dataSourceField.autoGenerated        (boolean : null : [IR])
// Indicates that values for this field are automatically generated by the database or ORM
// provider.  Setting this flag makes the field behave somewhat like a
// +link{sequenceName,sequence field}, in that server-side logic does not expect client code
// to provide values for the field on "add" operations.  However, it is not entirely the same
// as a sequence:<ul>
// <li>Sequences must be integers, whereas autoGenerated fields can be of any type</li>
// <li>SmartClient Server's DataSource implementations are capable of discovering the value
//     that was generated by the database for sequence fields, which may not be possible
//     with an autoGenerated field.  See the docs for
//     +link{dataSourceField.customInsertExpression,customInsertExpression} for a discussion
//     of this</li>
// </ul>
// Unrelated to the <code>autoGenerated</code> flag, you have a general ability for field
// values to be generated by application code (as opposed to being generated by the database
// or ORM provider).  For example, you can use +link{group:dmiOverview,DMI methods},
// +link{group:serverScript,server scripts}, or +link{group:customQuerying,custom SQL}.  (Note,
// if you want to have application code generate values for primaryKey fields, you may need to
// use an +link{OperationBinding,operationBinding} that specifies
// +link{operationBinding.providesMissingKeys,providesMissingKeys}).
// @group dataType
// @see sequenceName
// @see type:FieldType
// @see type:SequenceMode
// @serverDS only
// @visibility external
//<

//> @attr dataSourceField.nillable             (boolean : null : IR)
// Controls whether an explicit null-valued Record attribute for this field
// should result in <code>xsi:nil</code> being used to transmit the value when serializing
// to XML, like so:
// <pre>
// &lt;book&gt;
//     &lt;title&gt;Beowulf&lt;/title&gt;
//     &lt;author xsi:nil="true"/&gt;
// &lt;/book&gt;
// </pre>
// If <code>nillable</code> is not set, no XML element will be generated for
// the explicit null value.
// <p>
// A DataSourceField that specifies a <code>foreignKey</code> is automatically nillable
// unless this property is explicitly set to <code>false</code>.
// @group dataType
// @serverDS allowed
// @visibility external
//<

//> @attr dataSourceField.valueMap             (ValueMap : null : [IR])
// A +link{type:ValueMap} is a set of legal values for a field.
// <p>
// The valueMap can be specified as either an Array of legal values, or as an
// +link{type:Object} where each property maps a stored value to a user-displayable value.
// <p>
// To enforce that a field should be constrained to only the values in the valueMap, either
// declare +link{dataSourceField.type,field.type} as "enum", or use a
// +link{ValidatorType} of "isOneOf" with explicitly listed values.  Otherwise,
// although a normal +link{SelectItem} control will only allow values from the valueMap to be
// entered, other controls such as a +link{ComboBoxItem,ComboBox} will allow other values
// to be entered.
// <p>
// In XML, a valueMap that specifies only a list of legal values is specified as follows:
// <pre>
//   &lt;valueMap&gt;
//       &lt;value&gt;Pens &amp; Pencils&lt;/value&gt;
//       &lt;value&gt;Stationery&lt;/value&gt;
//       &lt;value&gt;Computer Products&lt;/value&gt;
//       &lt;value&gt;Furniture&lt;/value&gt;
//       &lt;value&gt;Misc&lt;/value&gt;
//   &lt;/valueMap&gt;
// </pre>
// A ValueMap that specifies stored values mapped to user-visible values is specified as
// follows:
// <pre>
//   &lt;valueMap&gt;
//       &lt;value ID="1"&gt;Pens &amp; Pencils&lt;/value&gt;
//       &lt;value ID="2"&gt;Stationery&lt;/value&gt;
//       &lt;value ID="3"&gt;Computer Products&lt;/value&gt;
//       &lt;value ID="4"&gt;Furniture&lt;/value&gt;
//       &lt;value ID="5"&gt;Misc&lt;/value&gt;
//   &lt;/valueMap&gt;
// </pre>
//
// @group dataType
// @serverDS allowed
// @visibility external
//<

//> @attr dataSourceField.valueMapEnum (String : null : IR)
// Fully qualified Java className of an Enum that should be used to derive this field's
// +link{valueMap}.
// <P>
// This has the same behavior of auto-deriving a <code>valueMap</code> from a Java Enum as
// +link{DataSource.autoDeriveSchema} except it applies only to one field.
// <P>
// If you enable <code>autoDeriveSchema</code> there is no need to set
// <code>valueMapEnum</code> for Enum fields unless you want to actually <i>override</i> the
// behavior to use a different Enum for the field (eg, a superclass Enum that is more
// restrictive).
//
// @serverDS only
// @visibility external
//<

//> @attr dataSourceField.validators           (Array of Validator : null : [IR])
// Validators to be applied to this field.
// <p>
// Validators are applied whenever there is an attempt to save changes to a field.
// <p>
// For the available set of built-in validators, and how to define a custom validator, see the
// +link{class:Validator} class.
//
// @see class:Validator
// @group dataType
// @group validation
// @serverDS allowed
// @visibility external
//<

//> @attr dataSourceField.length               (number : null : [IR])
// Maximum number of characters allowed.  Applicable only to fields of text type.
// For fields of this type a +link{ValidatorType,length range validator} will be automatically
// generated on both the client and server side to enforce this maximum length
// (unless such a validator is explicitly present for the field already).
// <P>
// The +link{TextItem.enforceLength} attribute can also
// explicitly limit user input for freeform text items editing fields with an explicit
// length specified.
// <P>
// <b>NOTE:</b> For DataSources of type "sql", this property has a bearing on the type of
// column we use when the underlying table is created by a DataSource
// +link{group:sqlDataSource,import} in the +link{group:adminConsole,Admin Console}.  Below
// a certain length (which is database-specific, see below), we use standard <code>VARCHAR</code>
// columns; above that length, we use an alternate strategy (again, database-specific).  For
// these long fields, we sometimes also generate different SQL for "update" and "add"
// operations, using JDBC "?" replacement parameters rather than embedding values directly in
// the generated SQL; whether or not this is done depends entirely on what the underlying
// database product and/or JDBC driver will allow.
// <P><br>
// <b>Table of field length limits for supported databases:</b><p>
// <table style="font-size:10px;text-align:center;border:1px solid black;">
// <tr><td style="color:white;background-color:black;"><b>Database product</b></td>
//     <td style="color:white;background-color:black;"><b>VARCHAR limit *</b></td>
//     <td style="color:white;background-color:black;"><b>Type used above limit</b></td></tr>
// <tr><td>HSQLDB</td><td>None</td><td>-</td></tr>
// <tr><td>IBM DB2</td><td>4000</td><td>CLOB</td></tr>
// <tr><td>Firebird</td><td>32767</td><td>BLOB with subtype 1</td></tr>
// <tr><td>Informix</td><td>255 / 32739</td><td>LVARCHAR / TEXT ** </td></tr>
// <tr><td> Microsoft SQL Server </td><td>8000</td><td>TEXT</td></tr>
// <tr><td>MySQL</td><td> 255 / 65535 / 16M </td><td> TEXT / MEDIUMTEXT / LONGTEXT *** </td></tr>
// <tr><td>MariaDB</td><td> 255 / 65535 / 16M </td><td> TEXT / MEDIUMTEXT / LONGTEXT *** </td></tr>
// <tr><td>Oracle</td><td>4000</td><td>CLOB</td></tr>
// <tr><td>PostgreSQL</td><td>4000</td><td>TEXT</td></tr>
// </table><br>
// <b>*</b> The "VARCHAR limit" referred to here is a limit used by the SmartClient Server; it
// is not necessarily imposed by the database.  For example, DB2's VARCHAR limit is not 4000
// characters; it actually varies from about 4K to about 32K, depending on how the server has
// been configured.<p>
// <b>**</b> Informix has a limit of just 255 characters for VARCHAR, but has a native LVARCHAR
// type which supports nearly 32K characters without needing to fall back on long datatypes.
// Therefore, with that one product, we have two thresholds for a change in storage type.<p>
// <b>***</b> MySQL has a limit of 255 characters for VARCHAR, 65,535 characters for TEXT and
// 16,777,215 for MEDIUMTEXT; therefore, with that one product, we have three thresholds for a
// change in storage type.
// @group dataType
// @serverDS allowed
// @see listGridField.width
// @visibility external
// @example longText
//<

// XML
// ---------------------------------------------------------------------------------------

//> @attr dataSourceField.valueXPath      (XPathExpression : null : [IR])
// XPath expression used to retrieve the field's value.
// <P>
// This XPath expression will be evaluated in the scope of the record objects selected by
// the +link{dataSource.recordXPath}.  For XML data
// (+link{DataSource.dataFormat,dataFormat:"xml"}) this means a call to
// +link{XMLTools.selectString()} passing the selected XML element.  For JSON data
// (+link{DataSource.dataFormat,dataFormat:"json"}), this means a call to
// +link{XMLTools.selectObjects()} passing the selected JSON object.
// <P>
// In the absence of a <code>valueXPath</code>, for JSON data the value for the field will
// be the value of the same-named property in the record object selected by
// +link{DataSource.recordXPath,recordXPath}.
// <P>
// For XML data, the value will be the attribute or subelement named after the field name.
// For example, for a field "author" on a record element &lt;book&gt;, the following structures
// require no valueXPath:
// <pre>
//    &lt;book author="Mark Jones"/&gt;
//
//    &lt;book&gt;
//        &lt;author&gt;Mark Jones&lt;/author&gt;
//    &lt;/book&gt;
// </pre>
// <P>
// If <code>valueXPath</code> is not required for your field because of the default handling
// described above, don't specify it, as it's slightly slower.
// <p>
// To learn about XPath, try the following search:
// <a href="http://www.google.com/search?q=xpath+tutorial" target="_blank"
// >http://www.google.com/search?q=xpath+tutorial</a>
// <P>
// <B>Using valueXPath with the SmartClient server</B>
// <p>
// If you're using the SmartClient server to return data via the DSResponse object (or
// indirectly doing so using DataSource DMI), the valueXPath you specify on the DataSource
// fields will be applied to the data you return via the
// +externalLink{http://commons.apache.org/jxpath/,JXPath} library.<br>
// See also the server side Java APIs <code>DataSource.setProperties()</code> and
// <code>DSResponse.setData()</code>.
// <P>
// If you are returning Java Beans as your DSResponse data, normally each dataSource field
// receives the value of the same-named Java Bean property, that is, a field "zipCode" is
// populated by looking for "getZipCode()" on the objects passed as DSResponse data.  You can
// use <code>valueXPath</code> to retrieve properties from subobjects, so long as a chain of
// getter methods exists that corresponds to the valueXPath.  For example, a valueXPath of
// "address/zipCode" expects to call "getAddress()" on the bean(s) passed to
// DSResponse.setData(), followed by "getZipCode()" on whatever object "getAddress()" returns.
// <P>
// When you are saving data, the inbound DSRequest values, available as a Java Map, will use
// just dataSource field names as Map keys, not the valueXPath used to derive them.  However,
// to achieve bidirectional valueXPath binding, you can use the server-side method
// dataSource.setProperties() to use the valueXPath when setting properties on your server
// object model.  When applied as a setter, an XPath like "address/zipCode" attempts
// "getAddress()" followed by "setZipCode()" on the returned object.  JXPath also has some
// ability to auto-create intervening objects if they are missing, such as auto-creating an
// "address" subobject when applying "address/zipCode" as a valueXPath.
// <P>
// See the
// +externalLink{http://jakarta.apache.org/commons/jxpath/,JXPath} library documentation for
// complete details, including other types of server object models supported, such as
// server-side XML.
//
// @group clientDataIntegration
// @serverDS allowed
// @visibility xmlBinding
// @example xpathBinding
//<

//> @attr dataSourceField.valueWriteXPath      (XPathExpression : null : [IR])
// Alternative XPath expression used to set the field's value.
// <P>
// If is not set, then +link{DataSourceField.valueXPath,dataSourceField.valueXPath} is
// used, see its description for details.
// <P>
// See also SmartClient server java APIs <code>DataSource.setProperties()</code> and
// <code>DSResponse.setData()</code>.
//
// @group clientDataIntegration
// @serverDS only
// @visibility xmlBinding
//<

//> @attr dataSourceField.getFieldValue (GetFieldValueCallback : null : IRA)
// A +link{Callback}, function, or JavaScript expression used to retrieve the field's value from
// the XML element or JSON record returned from a web service.
// <P>
// This is an advanced attribute for use when a +link{dataSourceField.valueXPath,valueXPath}
// setting is insufficient to derive a field's value, yet an implementation of
// +link{DataSource.transformResponse()} is overkill.
// <P>
// For the required parameters, see the documentation for
// +link{Callbacks.GetFieldValueCallback,GetFieldValueCallback}.
// @group clientDataIntegration
// @serverDS allowed
// @visibility xmlBinding
//<

//> @method Callbacks.GetFieldValueCallback
// +link{Callback} required for the property +link{dataSourceField.getFieldValue}.
//
// @param record (Object | XMLElement) record object selected from web service response data
//                                     by +link{operationBinding.recordXPath,recordXPath}
// @param value (Any) default value derived by the method described in
//                    +link{dataSourceField.valueXPath}
// @param field (DataSourceField) DataSourceField definition
// @param fieldName (FieldName) name of the DataSource field
//
// @group clientDataIntegration
// @serverDS allowed
// @visibility xmlBinding
//<

//> @attr dataSourceField.lenientXPath (boolean : null : IR)
// Indicates that getting +link{dataSourceField.valueXPath} for this field should
// not perform any validation at all and will return null for non existing XPaths.
// Otherwise warning message will be logged for non-existing XPath or with null objects
// in the middle of XPath.
// <P>
// NOTE: this applies to server-side processing of valueXPath only.
//
// @serverDS allowed
// @visibility external
// @deprecated No longer needs to be set since the framework now defaults to suppressing errors
// for null values in the middle of Xpath, and only invalid XPath will cause warning be logged.
//<

// Component Binding
// --------------------------------------------------------------------------------------------

//> @groupDef componentBinding
// Properties that control how a +link{DataBoundComponent} binds to this data source.
// @title Component Binding
// @visibility external
//<

//> @attr dataSourceField.title
// Default user-visible title for this field.
// <p>
// This will be picked up by +link{DataBoundComponent}s and other views over this data source.
// <p>
// Note this property frequently does not need to be set since +link{DataSource.autoDeriveTitles} (on by
// default) usually picks an appropriate user-visible title if you have a reasonable naming convention
// for your field names.
// <P>
// Note that if this field is being displayed in a +link{ListGrid} bound to this data source,
// the +link{listGridField.headerTitle} attribute may be used to specify a
// different string for display in the column header.
//
// @include Field.title
// @group componentBinding
// @serverDS allowed
// @visibility external
//<

//> @attr dataSourceField.escapeHTML    (Boolean : null : [IR])
// When data values are displayed in DataBound components, by default strings will be interpreted
// as HTML by the browser in most cases.
// <P>
// If set, this property will be picked up by components bound to this dataSource, notifying them
// that any HTML characters should be escaped when displaying values for this field.
// @see ListGridField.escapeHTML
// @serverDS allowed
// @visibility external
//<

//> @attr dataSourceField.canView              (boolean : null : [IR])
// If false, this property indicates that this field is considered "server only".  This means:
// <ul>
// <li>Components cannot bind to the field; even if you explicitly add a field with the same
//     name to your +link{DataBoundComponent,dataBoundComponent}, it will be dropped</li>
// <li>If you are using SmartClient Server, the client will never be sent a value for the
//     field</li>
// <li>If you are using SmartClient Server, then similar to +link{canEdit,canEdit}, no updates
//     to the field are allowed from the client.  If you explicitly add a value for the field
//     to, eg, a record you are passing to +link{dataSource.updateData}, the server will strip
//     the value out of the record before processing the update request.
// </ul>
// <code>canView:false</code> is <b>not</b> the same thing as +link{hidden,hidden}.  Use
// <code>canView:false</code> when you want to prevent the client from ever seeing a field's
// definition or values; use <code>hidden:true</code> if it is fine from a security perspective
// that a field's definition and values are sent to the browser, but the field should not by
// default appear in user interface elements (but could do in some cases, like a special screen
// for advanced users or administrators, for example).
// <p>
// Note that this property must be set explicitly to false to have an effect; a null or
// undefined setting is treated the same as true.
// <P>
// This property is used to implement field-level view security: failing a
// +link{viewRequiresAuthentication,viewRequiresAuthentication},
// +link{viewRequiresRole,viewRequiresRole} or +link{viewRequires,viewRequires} test is
// equivalent to setting <code>canView:false</code> on the field (and, indeed, from the
// client's perspective, the field <em>has</em> had <code>canView:false</code> set).
// @group componentBinding
// @serverDS allowed
// @visibility external
//<

//> @attr dataSourceField.canEdit              (boolean : null : [IR])
// Controls whether, by default, DataBoundComponents consider this field editable.
// Set to <code>false</code> to draw this field read-only.
// <p>
// For a field that should never be changed from the UI, consider using +link{canSave} instead,
// which will both mark a field as non-editable and reject any attempt to programmatically
// change the value on the server (when using the SmartClient Server).
// <P>
// This attribute may not effect all dataBoundComponents - the
// +link{databoundComponent.canEditFieldAttribute} may be set at the component level to look
// for a different attribute on the dataSourceField, and components allow developers to explicitly
// override this default (see +link{ListGridField.canEdit}. +link{FormItem.canEdit} for example).
//
// @group componentBinding
// @see dataSourceField.canFilter
// @see dataSourceField.canSave
// @serverDS allowed
// @visibility external
//<

//> @attr dataSourceField.canSave (boolean : null : [IR])
// Whether values in this field can be updated and saved to the dataSource.
// <P>
// If set to <code>false</code>, this field will default to being non-editable in standard editing
// components (+link{DynamicForm}, editable +link{ListGrid}), but will be editable when displayed
// for filtering purposes only (in a +link{SearchForm} or +link{ListGrid.showFilterEditor,ListGrid
// filter editor}.  If +link{dataSourceField.canEdit,canEdit} is explicitly specified it will take
// precedence over this client-side behavior, but the server will still enforce the no-save
// policy (described below).
// <p>
// NOTE: If you are using SmartClient Server and have specified <code>canSave: false</code>
// for a field in a DataSource definition (<code>.ds.xml</code> file), this is enforced on
// the server.  This means that we will strip out any attempt to set the value of such a
// field before trying to process any update or add request, similar to what happens when
// a +link{editRequiresAuthentication,field-level declarative security check} fails.
// @group componentBinding
// @serverDS allowed
// @visibility external
//<

//> @attr dataSourceField.canFilter (boolean : null : IR)
// Should the user be able to filter data by this field?
// Affects whether this field will show up in dataBoundComponents with UI for filtering data.
// <P>
// Note that setting <code>canFilter:false</code> only affects UI and is not a security
// feature.  Enforcing that filtering cannot be performed server side does not meaningfully
// increase security, since as long as a field can be viewed by an end user, they can
// effectively search the field themselves even if the UI doesn't offer a means to do so.
// If a field should be unable to be viewed entirely by some users, use
// +link{dataSourceField.viewRequiresRole} and related settings.
// <P>
// Rather than a security setting, <code>canFilter:false</code> is intended for situations
// where it would be redundant or nonsensical to be able to search on a field, or where
// searching isn't implemented for that field.
//
// @see SearchForm.showFilterFieldsOnly
// @see SearchForm.canEditFieldAttribute
//
// @serverDS allowed
// @visibility external
//<

//> @attr dataSourceField.editorType (FormItemClassName : null : [IR])
// Sets the default FormItem to be used whenever this field is edited (whether in a grid, form,
// or other component).
// <P>
// If unset, a FormItem will be automatically chosen based on the type of the field, by the
// rules explained +link{type:FormItemType,here}.
//
// @group componentBinding
// @serverDS allowed
// @visibility external
//<

//> @attr dataSourceField.readOnlyEditorType (FormItemClassName : null : [IR])
// Sets the default FormItem to be used if this field is marked as
// +link{dataSourceField.canEdit,canEdit false} and displayed in an editor component such
// as a DynamicForm.
// <P>
// This property may also be specified at the type level by specifying
// +link{SimpleType.readOnlyEditorType}.
//
// @group componentBinding
// @serverDS allowed
// @visibility external
//<

//> @attr dataSourceField.filterEditorType (FormItemClassName : null : [IR])
// Sets the default FormItem to be used for this field if it appears in a filter row,
// and +link{canFilter} is not false.
// <P>
// Note: If this is not specified, the edit-formItem type may be derived from the
// +link{editorType} property, or from the field's +link{type}.
//
// @group componentBinding
// @serverDS allowed
// @visibility external
//<



//>    @attr dataSourceField.dateFormatter (DateDisplayFormat : null : [IRWA])
// Preferred display format to use for date type values within this field.
// If this property is set on a field displayed in a databound component such as a
// +link{DynamicForm} or +link{ListGrid} it will be respected (See +link{formItem.dateFormatter} and
// +link{listGridField.dateFormatter}).
// <P>
// Note that this property is also honored when exporting directly to
// Excel spreadsheets (ie, when using XLS or XLSX/OOXML form, <b>not</b> CSV); "date" and
// "datetime" fields with this property set will deliver real dates and formatting information
// to Excel, rather than formatted strings or unformatted dates.
//
// @group appearance
// @visibility external
//<
//dateFormatter:null

//>    @attr dataSourceField.timeFormatter (TimeDisplayFormat : null : [IRWA])
// Preferred time-format to apply to date type values within this field.  If this property is
// specified on a field displayed within a dataBound component such as a +link{listGrid} or
// +link{dynamicForm}, any dates displayed in this field will be formatted as times using the
// appropriate format.
// <P>
// This is most commonly only applied to fields specified as type <code>"time"</code> though
// if no explicit +link{formItem.dateFormatter} is specified it will be respected for other
// fields as well.
// <P>
// See +link{listGridField.timeFormatter} and +link{formItem.timeFormatter} for more information.
//
// @group appearance
// @visibility external
//<
//timeFormatter:null

//> @attr dataSourceField.decimalPrecision (number : null : [IRW])
// Applies only to fields of type "float" and affects how many significant digits are shown.
// <P>
// For example, with decimalPrecision 3, if the field value is 343.672677, 343.673 is shown.
// <P>
// If the value is 125.2, 125.2 is shown - decimalPrecision will not cause extra zeros to be
// added.  Use +link{dataSourceField.decimalPad} for this.
// <P>
// A number is always shown with its original precision when edited.
//
// @group appearance
// @serverDS allowed
// @visibility external
//<

//> @attr dataSourceField.decimalPad (number : null : [IRW])
// Applies only to fields of type "float" and enforces a minimum number of digits shown after
// the decimal point.
// <P>
// For example, a field value of 343.1, 343.104 and 343.09872677 would all be shown as 343.10
// if decimalPad is 2.
// <P>
// The original unpadded value is always shown when the value is edited.
//
// @group appearance
// @serverDS allowed
// @visibility external
//<

//> @attr dataSourceField.precision (number : null : [IRW])
// Applies only to fields of type "float" or "integer" and affects how many significant
// digits are shown.
// <P>
// For example, a field value of 343.1, 343.104 and 343.09872677 would all be shown as 343.10
// if precision is 5.
// <P>
// The original value is always shown when the value is edited.
//
// @group appearance
// @serverDS allowed
// @visibility external
//<

//> @attr dataSourceField.hidden (boolean : false : [IR])
// Whether this field should be hidden from users by default within a DataBound component.
// This is generally used for internal IDs and other fields not meaningful to users.
// <P>
// See +link{dataSourceField.detail} for fields that should be hidden in a summary view such as
// a +link{ListGrid}, but still available to the user.
// <p>
// <b>NOTE:</b> This property is <b>not</b> a security setting - data for hidden fields is
// still delivered to the client, it just isn't shown to the user.  If you wish to make sure
// that only appropriate data reaches the client, use +link{operationBinding.outputs},
// +link{canView}:false on the field, or a field-level declarative security setting like
// +link{dataSourceField.viewRequiresRole}.
//
// @group componentBinding
// @serverDS allowed
// @visibility external
//<

//> @attr dataSourceField.ignore (boolean : false : [IR])
// Whether this field should be completely excluded from this dataSource, as if it had never been
// defined.
// <P>
// If set to true, the field will be entirely omitted when serving a DataSource derived
// from a server-side definition (typically a .ds.xml file) to the client.
//
// @group componentBinding
// @serverDS only
// @visibility external
//<

//> @attr dataSourceField.detail (boolean : false : [IR])
// Whether this field should be considered a "detail" field by a +link{DataBoundComponent}.
// <P>
// Detail fields won't be shown by default in a DataBoundComponent where
// +link{DataBoundComponent.showDetailFields} is false.  This allows for some DataBound
// components, like a +link{ListGrid}, to show a summary view of records which displays only
// the most commonly viewed fields by default, while other DataBoundComponents, like a
// +link{DetailViewer}, show all fields by default.
// <P>
// In addition, the +link{formItem.showIf,formItem.showIf} property is supported in multiple
// components for conditional visibility - see for example +link{listGridField.showIf} and
// +link{formItem.showIf}).
//
// @group componentBinding
// @serverDS allowed
// @visibility external
//<

//> @attr dataSourceField.excludeFromState (Boolean : null : IR)
// If true, then this field is excluded from the bound component's view state. In addition,
// the field will not be selected as the default title field
// by +link{DataBoundComponent.getTitleField()}
// if +link{DataBoundComponent.titleField} is not provided.
// @group viewState
// @visibility external
//<


//> @attr dataSourceField.excludeFromFieldPicker (Boolean : null : IR)
// If true, then this field is excluded from the +link{listGrid.useAdvancedFieldPicker,field picker}.
// Can also be set to false when +link{excludeFromState} is true to show the field in
// the field picker when it would normally be suppressed.
//<

//> @attr dataSourceField.emptyDisplayValue (HTMLString : null : [IR])
// Text to be used for display by client-side components when this field has a null or
// undefined value.  This value will be overridden by a component's emptyCellValue, if set.
//
// @group appearance
// @see formItem.emptyDisplayValue
// @see listGridField.emptyCellValue
// @see detailViewerField.emptyCellValue
// @serverDS allowed
// @visibility external
//<

//>ISC_140

// Relations
// --------------------------------------------------------------------------------------------


//> @groupDef dataSourceRelations
// SmartClient allows relations to be declared between dataSources using the
// +link{dataSourceField.foreignKey,foreignKey} property.  Declaring foreign key relations
// between dataSources enables multiple sophisticated and automatic behaviors.
// <h4>Relation types</h4>
// There are three types of dataSource relation:<ul>
// <li><b>Many-to-one</b>, where the dataSource at the "child" end of a relationship declares
// a foreignKey to the dataSource at the "parent" end.  The classic example is an OrderItem
// dataSource declaring a foreignKey relation to the Order dataSource.  Another example might
// be a City dataSource declaring a foreignKey to the Country dataSource
// <P>
// The default editor for Many-to-one relation fields is a +link{SelectItem}, allowing the user to
// select a new value for the field from the options available in the related dataSource.
// </li>
// <li><b>One-to-many</b>, which is the opposite of many-to-one - the foreignKey is declared
// at the "parent" end.  Examples of this kind of relation are simply the opposite of the
// many-to-one examples.
// <P>
// The default editor for one-to-many relation fields is a +link{MultiPickerItem},
// allowing the user to select a new set of values for the field from the
// options available in the related dataSource.
// </li>
// <li><b>Many-to-many</b>, where the dataSources at both ends of the relation declare a
// foreignKey to a third "middle" or "join" dataSource.  In a true many-to-many relation, the
// only information held in the "join" dataSource is the keys of the two related dataSources;
// if any other information is stored in the "join" dataSource, it is no longer a many-to-many
// relation but two separate many-to-one relations.  An example of a true many-to-many
// relation would be Employees to Teams: an Employee can be in multiple Teams, and a Team
// consists of multiple Emloyees
// <P>
// As with one-to-many relation fields, many-to-many fields will show a +link{MultiPickerItem}
// as the default editing interface.
// </li>
// </ul>
// For completeness, you could add <b>one-to-one</b> relations to this list, but in fact they
// are not particularly interesting.  Conceptually, a one-to-one relation is just a
// many-to-one relation that happens to have only one record at the many end; there are no
// other special considerations, like there are with the other relation types.
// <h4>Many-to-one relations</h4>
// Many-to-one relations, where the "child" dataSource declares a foreignKey to the
// "parent" dataSource, are the simplest type of relation, because they do not involve any
// requirement to handle multiple related records.  For these relations, SmartClient supports
// simple, code-free inclusion of fields from the parent into the child, with the
// +link{dataSourceField.includeFrom,includeFrom} mechanism.  <code>includeFrom</code> fields
// will be automatically included from the parent dataSource whenever data is fetched from the
// child dataSource
// <p>
// SmartClient does not support updating the "parent" dataSource fields across a many-to-one
// relation.  You can update the relation itself (by updating the <code>foreignKey</code>),
// but any fields that are included from the parent dataSource must be updated with a separate
// update operation on the parent dataSource
// <p>
// Many-to-one relations are supported for all dataSource types, both the built-in server
// dataSource types and +link{DataSource.clientOnly,clientOnly} dataSources.  They are also
// supported without any extra effort with your own custom dataSource implementations on the
// server
// <h4>One-to-many relations</h4>
// One-to-many relations, where the "parent" dataSource declares a foreignKey to the
// "child" dataSource, are more complicated than many-to-one relations because they involve a
// requirement to handle multiple related records.  You designate a one-to-many relation by
// declaring both the <code>foreignKey</code> to the other dataSource and the
// +link{dataSourceField.multiple,multiple} property on the field.
// <p>
// The way this idea of multiple related records is handled varies according  to the
// dataSource type:<ul>
// <li>+link{jpaIntegration,JPA} and +link{hibernateIntegration,Hibernate} dataSources, in
// keeping with the underlying ORM ethos, take an <i>object-based</i> approach: the
// related records are returned as a list of full-formed record objects, and it is possible
// to update across the relation simply by modifying the properties of the related record(s)
// and then updating the base record.  See the
// +link{jpaHibernateRelations,JPA and Hibernate Relations} article for more detail of
// JPA/Hibernate and relations</li>
// <li>+link{sqlDataSource,SQL} dataSources take a <i>relational</i> approach: the related
// records are not returned directly, but rather a list of the key values required to fetch
// the related records from the related dataSource.  Therefore, an additional fetch is needed
// to fetch the actual related data.  Updates are likewise relational: your code provides the
// "new" list of related keys, and SmartClient modifies the foreignKey values accordingly; no
// "child" records are created, updated or deleted in this process, the child records are
// assumed to exist, and here we are just updating the relational information to link to them.
// Updating the actual data on the child record(s) is done with separate update operation(s)
// on the child dataSource</li>
// <li>One-to-many relations are not supported by other dataSource types</li>
// </ul>
// <h4>Many-to-many relations</h4>
// Many-to-many relations have the same complexities as one-to-many relations - they both
// involve a requirement to handle multiple related records.  In addition, many-to-many
// relations must manage the existence of an entry in a "join" dataSource.  You designate a
// many-to-many relation by declaring the <code>foreignKey</code> to the related dataSource,
// via the "join" dataSource, and the +link{dataSourceField.multiple,multiple} property, on
// the foreignKey field of one of the dataSources in the many-to-many relation.  For example,
// declaring the <code>foreignKey</code> to Teams on the Employee dataSource (note the dots
// indicating that the relation path to use is EmployeeTeams-&gt;Teams):<pre>
//    &lt;field name="teams" multiple="true" foreignKey="EmployeeTeams.Teams.teamId" /&gt;
// </pre>
// The way this idea of multiple related records is handled is different according to
// dataSource type, similar to one-to-many relations:<ul>
// <li>JPA and Hibernate dataSources take the same object-based approach: the related records
// are returned as a list of full-formed record objects, and it is possible to update across
// the relation simply by modifying the properties of the related record(s) and then updating
// the base record</li>
// <li>SQL dataSources again take a relational approach: instead of the related records, a
// list of the key values required to fetch the related records from the related dataSource
// is returned.  Updates are also similar to one-to-many relations: your code provides the
// "new" list of related keys, and SmartClient creates and deletes record in the "join"
// dataSource as required.  No records are created, updated or deleted on the related
// dataSource in this process.  As with one-to-mny relations, updating the actual data on the
// related record(s) is done with separate update operation(s) on the related dataSource</li>
// <li>Many-to-many relations are not supported by other dataSource types</li>
// </ul>
// @see DataSourceField.foreignKey
// @see DataSourceField.multiple
// @see jpaHibernateRelations
// @title Relations
// @visibility external
//<

//<ISC_140

//> @attr dataSourceField.primaryKey
// If set to <code>true</code>, indicates <b>either</b> that this field holds a value unique
// across all records in this data source, <b>or</b> that it is one of a number of fields marked
// as primary keys, and the combination of the values held in all of those fields is unique
// across all records in the data source.  Note that the latter usage - so-called "composite"
// or "multipart" keys - is intended for support of legacy databases only: if you are able
// to choose an approach, Isomorphic recommends the use of one <code>primaryKey</code> field
// per data source, and ideally this field should be of +link{dataSourceField.type,type}
// <smartclient>"sequence"</smartclient><smartgwt>SEQUENCE</smartgwt>.  If you have
// control of the underlying tables, there is nothing to stop you from adding a field like
// this (a so-called "synthetic" or "surrogate" key), even for tables that already have a set
// of columns that could combine to make a composite key (a so-called "natural" key).  Also,
// it is neither necessary nor correct to use a composite primaryKey because you want to
// enforce uniqueness across that combination of fields.  You can achieve that by declaring
// a unique constraint in the table schema, or use an +link{type:ValidatorType,isUnique}
// validator with <code>validator.criteriaFields</code>, or both; there is no need to use a
// composite key to enforce uniqueness.
// <p>
// Note that composite primaryKeys are not supported in tree-structured datasets
// (+link{class:Tree} and +link{class:ResultTree}) or components (+link{class:TreeGrid},
// +link{class:ColumnTree}).  Tree-structured data requires that nodes have a unique
// +link{Tree.idField,idField}, with the parent/child relationship expressed through the
// +link{Tree.parentIdField,parentIdField}.  This implies that binding a Tree to a DataSource
// requires that the DataSource have a singular primaryKey, and that the primaryKey field is
// also the idField, as described in the +link{group:treeDataBinding,tree databinding overview}
// <p>
// A DataSource that can <i>only</i> perform the "fetch" operation does not require a
// primaryKey unless it contains +link{group:binaryFields,binary fields}.  If a DataSource
// allows modification of DataSource records through add, update and remove DataSource
// operations, or it contains one or more binary fields, one or more fields must be marked as
// the primary key.
// <P>
// SmartClient requires a primary key value to uniquely identify records when communicating
// updates or deletions to the server.  There is no requirement that the primaryKey field be
// mapped to an actual "primary key" in your object model, web service, or database (though
// this is the most obvious and natural thing to do, of course).  The only requirement is
// that the combined values of the primaryKey fields be unique for a given browser instance
// for the lifetime of the page.
// <P>
// If using SmartClient's +link{group:sqlDataSource,SQL engine} and generating SQL tables using
// the +link{group:dbConfigTool,Database Configuration Tool}, the table column generated from a
// primaryKey field will have a unique constraint applied in the database table and, if the field
// is of type "sequence", the database column will also be created as an "identity column" in those
// databases that implement sequence-type handling with identity columns.
//
// @include Field.primaryKey
// @group dataSourceRelations
// @serverDS allowed
// @visibility external
//<

//> @attr dataSourceField.foreignKey           (String : false : [IR])
// Declares that this field holds values that can be matched to values from another DataSource
// field, to create a relationship between records from different DataSources or even records
// within the same DataSource.
//>ISC_140
// Ordinarily, the relation to the other dataSource is a
// many-to-one relation, where multiple records on this dataSource refer to a single record on
// the other dataSource.  To declare a one-to-many or many-to-many relation, specify
// +link{dataSourceField.multiple,multiple}:true as well as <code>foreignKey</code>.  See
// +link{group:dataSourceRelations,the Relations overview} for more details
//<ISC_140
// <p>
// The format of <code>foreignKey</code> is
// <code><i>dataSourceId</i>.<i>fieldName</i></code>.
// <p>
// For a foreignKey within the same dataSource, you can omit the <code>dataSourceId</code>
// and just specify <code><i>fieldName</i></code>.  For example, to create a tree relationship
// within a DataSource:
// <smartclient>
// <pre>
//   isc.DataSource.create({
//     ID:"supplyItem",
//     fields : [
//       {name:"itemId", type:"sequence", primaryKey:true},
//       {name:"parentId", type:"integer", foreignKey:"itemId"},
//       ...
//     ]
//   });
// </pre>
// </smartclient>
// <smartgwt>
// <pre>
//      DataSource supplyItem = new DataSource();
//      DataSourceField itemId = new DataSourceField();
//      itemId.setType(FieldType.SEQUENCE);
//      itemId.setPrimaryKey(true);
//      DataSourceField parentId = new DataSourceField();
//      parentId.setType(FieldType.INTEGER);
//      parentId.setForeignKey("itemId");
//      supplyItem.setFields(itemId, parentId);
// </pre>
// </smartgwt>
// <P>
// <code>foreignKey</code> declarations also allow other automatic behaviors by
// +link{DataBoundComponent,DataBoundComponents}, such as +link{listGrid.fetchRelatedData()}.
// <p>
// For SQLDataSources foreign keys can be automatically discovered from SQL tables if
// +link{dataSource.autoDeriveSchema,autoDeriveSchema} is set.
//
// @see dataSourceField.joinType
// @group dataSourceRelations
// @serverDS allowed
// @visibility external
//<

//> @attr dataSourceField.childrenProperty (Boolean : false : [IR])
// If true, this property indicates that this field will hold an explicit array of child nodes
// for the current node.
// This has the same effect as specifying +link{dataSource.childrenField} to this field's
// name.
// @see dataSource.childrenField
// @group dataSourceRelations
// @serverDS allowed
// @visibility external
// @example treeLoadXML
//<


//> @attr dataSourceField.rootValue            (Any : null : [IR])
// For a field that is a foreignKey establishing a tree relationship, what value indicates a
// root-level node.  Defaults to null.
// <P>
// Note that the rootValue may be overridden on a specific ResultTree instance by setting
// +link{ResultTree.rootNode}, or if the ResultTree is auto-generated by a +link{TreeGrid},
// by setting +link{TreeGrid.treeRootValue}. This allows a component to navigate a subtree of
// the hierarchical data from this dataSource starting at a particular node.
// @group dataSourceRelations
// @serverDS allowed
// @visibility external
// @example treeLoadXML
//<

//> @attr dataSourceField.sequenceName (String : null : IR)
// For a DataSource with +link{dataSource.serverType,serverType:"sql"} with a field of type
// "sequence", the name of the SQL sequence that should be used when inserting new records into
// this table.
// <P>
// Note that this is never required for SQL tables that are generated from SmartClient
// DataSources (a default sequence name of tableName + "_" + columnName is chosen, but see the
// notes below regarding this), and is never required for databases where inserting null into a
// sequence column is sufficient (MySQL, SQL Server, DB2 and others).
// <P>
// You would only need to set sequenceName if you are integrating with a pre-existing table
// stored in a database where the sequence must be named for insertion to work (Oracle,
// Postgres, Firebird) OR you are trying to use the same sequence across multiple DataSources.
// <P>
// <b>Note:</b> If you specify the <code>sql.{database type}.sequence.name.prefix</code> and/or
// <code>sql.{database type}.sequence.name.suffix</code> properties in your
// +link{group:server_properties,server.properties} file,the generated sequence name will include the prefix and/or
// suffix.  For example, with a prefix of "order_system_" and a suffix of "_seq", the sequence
// generated for column "orderNumber" on table "orders" would be:<pre>
//     order_system_orders_orderNumber_seq
// </pre>
//
// @group sqlDataSource
// @serverDS allowed
// @visibility external
//<

//> @attr dataSourceField.implicitSequence (Boolean : null : IR)
// For a field of +link{type:FieldType,type} "sequence" on a DataSource with
// +link{dataSource.serverType,serverType:"sql"}, this flag indicates that the field is
// implicitly bound to a sequence.  This setting means that SmartClient does not expect to
// find a value for the field in "add" operations, even if it is marked as a
// +link{primaryKey,primaryKey}, as such fields usually are.  It also means that SmartClient
// does not attempt to retrieve the field value from an actual database sequence, instead
// relying on the JDBC driver to return the generated value (see the note on
// <code>sequenceMode</code> below).
// <P>
// Implicitly bound columns are a syntactic convenience provided by some databases to simulate
// the "auto-increment" or "identity" columns available natively in other products, without
// the underlying sequence having to be explicitly referenced in SQL queries.  Currently, these
// database products support this idea:<ul>
// <li>PostgreSQL has had a "serial" column type for a long time -
// <a href=http://www.postgresql.org/docs/9.3/static/datatype-numeric.html#DATATYPE-SERIAL>
// http://www.postgresql.org/docs/9.3/static/datatype-numeric.html#DATATYPE-SERIAL</a></li>
// <li>DB2 has long supported a "GENERATED AS IDENTITY" notation for numeric fields.  This may
// or may not be implemented with a sequence - the documentation does not specify - but we
// support it via the implicitSequence mechanism because it is so similar to the implicit
// sequence approach in Oracle.
// <a href="http://publib.boulder.ibm.com/infocenter/dzichelp/v2r2/index.jsp?topic=%2Fcom.ibm.db2z10.doc.apsg%2Fsrc%2Ftpc%2Fdb2z_identitycols.htm">
// http://publib.boulder.ibm.com/infocenter/dzichelp/v2r2/index.jsp?topic=%2Fcom.ibm.db2z10.doc.apsg%2Fsrc%2Ftpc%2Fdb2z_identitycols.htm</a></li>
// <li>Oracle introduced a "GENERATED AS IDENTITY" notation for numeric fields in version 12c -
// <a href=http://www.oracle-base.com/articles/12c/identity-columns-in-oracle-12cr1.php>
// http://www.oracle-base.com/articles/12c/identity-columns-in-oracle-12cr1.php</a></li>
// </ul>
// If you have columns like these in your database, declare them as type "sequence" and mark
// them with the <code>implicitSequence</code> flag.
// <P>
// <b>NOTE:</b> If you use this property, you should also set the
// +link{dataSource.sequenceMode,DataSource sequenceMode} to "jdbcDriver".  This is necessary
// because SmartClient cannot directly query the implicit sequence that is being used behind the
// scenes, so we must rely on the JDBC driver to do that.
// <p>
// If you use +link{dataSource.autoDeriveSchema,autoDeriveSchema} to automatically derive a
// dataSource from table metadata, SmartClient attempts to identify these special Oracle and
// Postgres columns by heuristic examination of the metadata.  When it identifies such a
// column, it marks the corresponding dataSourceField <code>implicitSequence: true</code>,
// and changes the sequenceMode on the DataSource to "jdbcDriver".  If your table contains
// one of these columns and SmartClient does not automatically identify it, bear in mind that
// you can always set this flag manually, even if you are using <code>autoDeriveSchema</code>.
// <P>
// This setting has no effect for non-SQL dataSources, or for databases other than those
// mentioned above.
//
// @group sqlDataSource
// @see dataSource.sequenceMode
// @serverDS only
// @visibility external
//<

//> @attr dataSourceField.includeFrom (String : null : IR)
// Indicates that this field should be fetched from another, related DataSource.
// <P>
// The <code>includeFrom</code> attribute should be of the form
// "<i>dataSourceId</i>.<i>fieldName</i>", for example:
// <pre>
//    &lt;field includeFrom="supplyItem.itemName"/&gt;
// </pre>
// <P>
// A +link{foreignKey} declaration must exist between the two DataSources, establishing either
// a 1-to-1 relationship or a many-to-1 relationship from this DataSource to the related
// DataSource. The inclusion can be indirect (traverse multiple DataSources) so long as there
// is a chain of <code>foreignKey</code> declarations from the target DataSource to the
// DataSource where the <code>includeFrom</code> field is declared.  You may use dot-notation
// to provide an explicit path between DataSources, or provide the name of only the last
// DataSource in the chain to have the complete path calculated for you at runtime.
// i.e., either of the following are acceptable forms, where foreign keys
// are defined to link records in the current DataSource to Employee records and in turn to
// Office records:
// <pre>
//   &lt;field includeFrom="Employee.Office.territory"/&gt;
//   &lt;!-- OR --&gt;
//   &lt;field includeFrom="Office.territory"/&gt;
// </pre>
// Note that when using the shorthand form, there is potential ambiguity: there could be
// multiple ways in which two DataSources are related via different intervening DataSources,
// so the auto-discovered relation may be different depending on which other DataSources are
// loaded in the page. For this reason, explicitly spelling out the inclusion path is
// preferred.
// <p>
// Nested inclusions, where an
// included field is itself an included field, are also supported - for details on this and
// other complex scenarios see +link{dataSourceField.includeVia} docs.
// <P>
// In all cases, +link{DataSourceField.name} will default to the name of the included field,
// or you can specify a different name.
// <p>
// If both DataSources are SQLDataSources, HibernateDataSources or JPADataSources (with
// Hibernate as the provider) the related data will be retrieved via a SQL join and criteria
// and sort directions applied to the field work normally (they become part of the generated
// SQL query).
// <p>
// Note that includeFrom is also supported between two clientOnly or MockDataSources, but not
// for any other combination (for example, a RestDataSource cannot use includeFrom with a
// clientOnly DataSource).  Here, the related data (including any values derived via
// +link{dataSourceField.includeSummaryFunction}) will be retrieved from cacheData after the
// primary (fetch, add, or update) operation has returned its response.
// <P>
// Otherwise, the related data will be retrieved via performing a DSRequest against
// the related DataSource once the data from the primary DataSource has been retrieved.  In
// this case, criteria or sorting directions applied to the included field are only allowed if
// data paging is not in use (for example +link{listGrid.dataFetchMode}:"basic"); otherwise,
// criteria and sort direction are ignored for the included field and a warning is logged on
// the server.
// <P>
// <b>Editing included fields</b>
// <p>
// An included field is +link{dataSourceField.canEdit,canEdit:false} by default.  Note that
// included fields are not updatable, even if you set canEdit:true; the server will simply drop
// values for included fields if client code sends them.
// <p>
// When thinking about editing an included field value, typically what is really intended is to
// edit the value of the <code>foreignKey</code> field.  For example, take the scenario of a
// system that tracks accounts and the employees assigned to manage them.  Given a DataSource
// "account" related one-to-one with DataSource "employee" by a "managerId" foreignKey field,
// we might declare an <code>includeFrom</code> so that the name of the account manager can
// be shown with each "account" record.
// <p>
// Editing the manager's name while viewing the account would be intended to pick a new account
// manager, and <b>not</b> to change the legal name of the employee who happens to be the
// current account manager.
// <p>
// To correctly set up this scenario, declare an <code>includeFrom</code> field that is hidden,
// but is used as the +link{dataSourceField.displayField,displayField} for the foreign key
// field:
// <pre>
// &lt;field name="managerId" foreignKey="employee.id" displayField="managerName" /&gt;
// &lt;field name="managerName" includeFrom="employee.name" hidden="true"/&gt;
// </pre>
// Now:
// <ul>
// <li> the "managerId" foreignKey field is shown in grids and forms, but takes its displayed
// value from the hidden <code>includeFrom</code> field. Note that when the
// <code>foreignKey</code> and <code>displayField</code> are specified, the
// framework automatically defaults +link{dataSourceField.useLocalDisplayFieldValue} to
// true to ensure the displayed value is picked up from the record being edited.
// <li> the automatically chosen editor will be a SelectItem with
// +link{SelectItem.optionDataSource,optionDataSource} set to "employees": it will allow
// picking a different "employee" record from the "employee" DataSource.
// <li> saving will save the ID of a new "employee" record to the "managerId" foreign key
// field, as intended
// </ul>

// You can alternatively set <code>editorType="ComboBoxItem"</code> on the
// "managerId" field to allow typeahead search of the "employee" DataSource.
// Note that the +link{foreignDisplayField} attribute allows developers to have a different
// fieldName be used locally as a displayField from the field name for the display field
// in the foreign dataSource.
// <P>
// <b>Including fields that use summary functions</b>
// <p>
// The +link{dataSourceField.includeSummaryFunction, Include Summary Function} feature is used
// for including from a related DataSource where there are multiple related records. It applies
// a +link{type:SummaryFunction} to the related records aggregating them into single value.
// It is regularly used on directly included fields, but it supports indirect inclusions as well,
// when entire <code>includeFrom</code>+<code>includeSummaryFunction</code> setup is included from
// another DataSource. See +link{dataSourceField.includeSummaryFunction} docs for more details.
//
// @example sqlIncludeFrom
// @serverDS only
// @group dataSourceRelations
// @visibility crossDS
//<


//> @attr dataSourceField.includeVia (String : null : IR)
// For a field that uses +link{dataSourceField.includeFrom}, specifies which
// +link{dataSourceField.foreignKey,foreignKey} field should be used to find records in the
// related DataSource.
// <p>
// <code>includeVia</code> only needs to be set when you have more than one
// <code>foreignKey</code> to the <i>same</i> related DataSource.  If you have multiple
// foreignKeys to multiple <i>different</i> DataSources, there is no need to set
// <code>includeVia</code>.
// <p>
// For example, perhaps you have a DataSource "moneyTransfer" where each record represents a
// money transfer, where the source and payment currencies are different, and the list of
// currencies is stored in a related DataSource "currency".  Each "moneyTransfer" record is
// linked to <b>2</b> "currency" records, through two different foreignKey fields,
// "sourceCurrencyId" and "paymentCurrencyId".
// <p>
// The following declarations would be required to use <code>includeFrom</code> to get a
// include the field "currencySymbol" from each of the two related "currency" records.
// <pre>
//   &lt;field name="sourceCurrencyId" foreignKey="currency.id"/&gt;
//   &lt;field name="paymentCurrencyId" foreignKey="currency.id"/&gt;
//   &lt;field name="sourceCurrencySymbol" includeFrom="currency.currencySymbol" includeVia="sourceCurrencyId"/&gt;
//   &lt;field name="paymentCurrencySymbol" includeFrom="currency.currencySymbol" includeVia="paymentCurrencyId"/&gt;
// </pre>
// <p>
// <h3>SQL Templating and <code>includeVia</code></h3>
// <p>
// The <code>includeVia</code> feature uses SQL table aliases in the generated SQL when generating multiple SQL joins
// to the same SQL table.  When using +link{group:customQuerying,SQL Templating}, it's sometimes necessary to know
// the names of the aliases in the generated SQL.  The table alias used can be configured via
// setting +link{dataSourceField.relatedTableAlias} on the <code>foreignKey</code> field, for
// example, using the declarations below, aliases "source" and "payment" would be used for the
// two "currency" tables.
// <pre>
//   &lt;field name="sourceCurrencyId" foreignKey="currency.id" relatedTableAlias="source"/&gt;
//   &lt;field name="paymentCurrencyId" foreignKey="currency.id" relatedTableAlias="payment"/&gt;
//   &lt;field name="sourceCurrencySymbol" includeFrom="currency.currencySymbol" includeVia="sourceCurrencyId"/&gt;
//   &lt;field name="paymentCurrencySymbol" includeFrom="currency.currencySymbol" includeVia="paymentCurrencyId"/&gt;
// </pre>
// <p>
// <h3>Multiple indirection and <code>relatedTableAlias</code></h3>
// <p>
// General rule is that if <code>relatedTableAlias</code> is present it is used as alias or its segment, otherwise
// <code>foreignKey</code> field name linked by <code>includeVia</code> is used instead. See the "Automatically
// generated table aliases" section of the +link{group:customQuerying,SQL Templating} for the complete set of
// general rules how aliases are generated. Also, see some samples below.
// <p>
// Sometimes you may have two <code>includeFrom</code> fields that include a field which is itself included from
// another DataSource, for example:
// <pre>
//   &lt;field name="sourceCurId" nativeName="sourceCurrencyId" foreignKey="currency.id" relatedTableAlias="source"/&gt;
//   &lt;field name="sourceCurrencySymbol" includeFrom="currency.currencySymbol" includeVia="sourceCurId"/&gt;
//   &lt;field name="sourceCurrencyGroup" includeFrom="currency.groupName" includeVia="sourceCurId"/&gt;
//   &lt;field name="paymentCurId" nativeName="paymentCurrencyId" foreignKey="currency.id" relatedTableAlias="payment"/&gt;
//   &lt;field name="paymentCurrencySymbol" includeFrom="currency.currencySymbol" includeVia="paymentCurId"/&gt;
//   &lt;field name="paymentCurrencyGroup" includeFrom="currency.groupName" includeVia="paymentCurId"/&gt;
// </pre>
// .. where the "currency" DataSource used above is related to the "currencyGroup" DataSource via fields:
// <pre>
//   &lt;field name="groupId" type="integer" foreignKey="currencyGroup.id" relatedTableAlias="group"/&gt;
//   &lt;field name="groupName" type="text" includeFrom="currencyGroup.groupName"/&gt;
// </pre>
// Fields "sourceCurrencyGroup" and "paymentCurrencyGroup" include a field that is itself an included field.
// In this case "currencyGroup" table will be referenced two times, and its <code>relatedTableAlias</code> defined in
// "currency" DataSource will be prefixed with the referenced by <code>includeVia</code> field's <code>relatedTableAlias</code>
// value to make aliases unique in generated SQL: "source_group" and "payment_group".
// <p>
// The same aliases would be used if "sourceCurrencyGroup" and "paymentCurrencyGroup" fields
// were to include "currencyGroup.groupName" <i>indirectly</i>:
// <pre>
//   &lt;field name="sourceCurrencyGroup" includeFrom="currency.currencyGroup.groupName" includeVia="sourceCurId"/&gt;
//   &lt;field name="paymentCurrencyGroup" includeFrom="currency.currencyGroup.groupName" includeVia="paymentCurId"/&gt;
// </pre>
// <p>
// This works the same for more complex relationships.  If we add a "moneyTransferDetail"
// DataSource to the sample above which has multiple references to "moneyTransfer"
// DataSource and would include fields from "currency" and "currencyGroup" DataSources:
// <pre>
//   &lt;field name="mtId" nativeName="moneyTransferId" type="integer" foreignKey="moneyTransfer.id" relatedTableAlias="main" /&gt;
//   &lt;field name="mainTransferName" includeFrom="moneyTransfer.name" includeVia="mtId" /&gt;
//   &lt;field name="mainSourceSymbol" includeFrom="moneyTransfer.sourceCurrencySymbol" includeVia="mtId" /&gt;
//   &lt;field name="mainSourceGroup" includeFrom="moneyTransfer.sourceCurrencyGroup" includeVia="mtId" /&gt;
//   &lt;field name="mainPaymentSymbol" includeFrom="moneyTransfer.paymentCurrencySymbol" includeVia="mtId" /&gt;
//   &lt;field name="mainPaymentGroup" includeFrom="moneyTransfer.paymentCurrencyGroup" includeVia="mtId" /&gt;
//   &lt;field name="mtPrevId" nativeName="moneyTransferPreviousId" type="integer" foreignKey="moneyTransfer.id" relatedTableAlias="prev" /&gt;
//   &lt;field name="previousTransferName" includeFrom="moneyTransfer.name" includeVia="mtPrevId" /&gt;
//   &lt;field name="previousSourceSymbol" includeFrom="moneyTransfer.sourceCurrencySymbol" includeVia="mtPrevId" /&gt;
//   &lt;field name="previousSourceGroup" includeFrom="moneyTransfer.sourceCurrencyGroup" includeVia="mtPrevId" /&gt;
//   &lt;field name="previousPaymentSymbol" includeFrom="moneyTransfer.paymentCurrencySymbol" includeVia="mtPrevId" /&gt;
//   &lt;field name="previousPaymentGroup" includeFrom="moneyTransfer.paymentCurrencyGroup" includeVia="mtPrevId" /&gt;
// </pre>
// In this scenario the "currencyGroup" table will be joined 4 times - for all main/prev transfer
// and payment/source currency combinations.  So, aliases will be prefixed with both
// intermediate <code>relatedTableAlias</code> values: "main_source_group",
// "main_payment_group", "prev_source_group", "prev_payment_group".
// <p>
// It is also allowed to specify a series of FK fields in <code>includeVia</code>, for example
// "moneyTransferDetail" could declare:
// <pre>
//   &lt;field name="mainSourceCurrencyGroup" includeFrom="moneyTransfer.currency.currencyGroup.groupName" includeVia="mtId.sourceCurId"/&gt;
//   &lt;field name="mainPaymentCurrencyGroup" includeFrom="moneyTransfer.currency.currencyGroup.groupName" includeVia="mtId.paymentCurId"/&gt;
// </pre>
// In this case the prefix used for table aliases will be the same, cause relations referenced in <code>includeVia</code>
// are the same as in previous example: "main_source_group" and "main_payment_group".
// <p>
// <b>Note</b> that if +link{dataSourceField.relatedTableAlias,related table alias} are completely missing then, according to general rule,
// <code>foreignKey</code> field names will be used in aliases: "mtId_sourceCurId_groupId" and "mtId_paymentCurId_groupId".
// <p>
// <h3>Ambiguous <code>includeFrom</code> definitions and logging</h3>
// Considering the flexibility and complexity of configuring relationships between Datasources, it is important to be aware
// of certain limitations. Specifically, when multiple fields attempt to include the same field from the same related Datasource
// via the same (default or specified) foreign key, such configurations are not permitted and may result in unpredictable
// behavior. This scenario is detected and reported as a warning in the server logs during both DataSource loading and DSRequest
// execution.
// <p>
// In example below, fields "sourceCurrencySymbol", "currency" and "currencySymbol" include the same "currencySymbol" field
// from the same "currency" DataSource via the same "currencyId" foreign key field. So, for the fields "currency" and
// "currencySymbol" warnings will be logged as they include the same value as does the "sourceCurrencySymbol" field.
// <pre>
//   &lt;field name="currencyId" foreignKey="currency.id"/&gt;
//   &lt;field name="sourceCurrencySymbol" includeFrom="currency.currencySymbol" /&gt;
//   &lt;field name="currency" includeFrom="currency.currencySymbol" /&gt;
//   &lt;field includeFrom="currency.currencySymbol" /&gt;
// </pre>
// Additionally there are two server logging categories that may be set to DEBUG level to log details of the entire
// <code>includeFrom</code> setup. Specifically <code>com.isomorphic.sql.SQLDataSource.Alias</code> category enables
// logging for all fields with <code>includeFrom</code>, exact direct or indirect include path to the target field,
// includeVia/aliases used and <code>com.isomorphic.sql.SQLDataSource.FK</code> category additionally enables logging
// for the foreign key fields relations are based on.
// <p>
// <h3>Extended <code>includeVia</code> syntax</h3>
// In complex cases involving composite foreign keys or indirect relation chains (multi-step paths across multiple
// DataSources), <code>includeVia</code> supports an extended syntax that allows explicit control over how relationships
// are resolved. See +link{group:includeViaSyntax} for more details.
//
// @see dataSourceField.relatedTableAlias
// @see includeViaSyntax
// @example sqlIncludeVia
// @serverDS only
// @group dataSourceRelations
// @visibility external
//<

//> @groupDef includeViaSyntax
// <h3>Overview</h3>
// The +link{attr:dataSourceField.includeVia,includeVia} attribute is used in conjunction with
// +link{attr:dataSourceField.includeFrom,includeFrom} to resolve ambiguity when multiple foreign keys point to the
// same related DataSource. It allows you to explicitly specify which foreign key path should be used to retrieve
// data from the related DataSource.
// <p>
// In its simplest form, includeVia references a single foreign key field, such as:
// <pre>
// &lt;field name="salesRepEmployeeNumber" type="integer" foreignKey="Employee.employeeNumber" /&gt;
// &lt;field name="salesRepLastName" includeFrom="Employee.lastName" includeVia="salesRepEmployeeNumber" /&gt;
// &lt;field name="accountMgrEmployeeNumber" type="integer" foreignKey="Employee.employeeNumber" /&gt;
// &lt;field name="accountMgrLastName" includeFrom="Employee.lastName" includeVia="accountMgrEmployeeNumber" /&gt;
// </pre>
// In more complex scenarios, where relationships span multiple DataSources or involve composite foreign keys,
// <code>includeVia</code> can define an indirect relation chain — a multi-step path of linked DataSources leading
// to the target field. This allows precise control over relation resolution, especially when there are multiple
// possible foreign key paths between DataSources, and you want deterministic control over how relations are resolved,
// overriding default SmartClient behavior.
// <p>
// For example, to resolve the chain <code>Order &gt; Customer &gt; Employee &gt; Office</code>, you can use
// <code>includeVia</code> to specify which foreign keys (single-field or composite) to follow at each step.
// <h3>Syntax</h3>
// <code>[dsName.]field1-field2:[dsName.]field3-field4...</code>
// <ul>
// <li/><code>"."</code> separates a DataSource ID from its field / composite key fields
// <li/><code>"-"</code> separates fields that are part of a composite key
// <li/><code>":"</code> separates relation steps across different DataSources
// </ul>
// Datasource names are optional if field names are unambiguous across the chain.
// <h3>Behavior & Rules</h3>
// <ul>
// <li/>Each segment must refer to a defined +link{attr:dataSourceField.foreignKey,foreignKey} (or listed in
// +link{attr:dataSourceField.otherFKs,otherFKs} in the corresponding DataSource.
// <li/>Once <code>includeVia</code> is used, the chain must follow the segments as specified, without skipping intermediate DataSources.
// <li/>After the last segment of includeVia, relation detection can proceed using default logic.
// <li/>The same format and rules apply whether keys are single-field or composite.
// <li/>Works identically for both includeVia and queryFK.
// </ul>
// <h3>Composite PK usage notes</h3>
// Support for composite primary keys in <code>includeVia</code> is available, but should be used with caution.
// While there are valid use cases — such as modeling compound identifiers or many-to-many relationships
// with additional attributes — the need for composite keys is relatively rare in modern schema design.
// <p>
// Composite keys are most often found in legacy systems, and their use typically reflects limitations or
// design choices made before more scalable patterns were available. For multi-tenancy specifically, we
// strongly recommend using +link{group:multiTenancy,SmartClient’s transparent multi-tenancy} approach, which
// provides clean tenant separation without duplicating schema or embedding tenancy logic in primary keys.
// <p>
// If you're working with a legacy system and need to preserve existing composite key structures,
// <code>includeVia</code> does support this pattern. For example, some systems use a <i>domainKey</i> or a similar
// field as part of composite keys to simulate multi-tenancy — this approach is supported, but not recommended
// for new development. See +link{group:includeViaAndDomainKey} for more details.
// <h3>Examples</h3>
// All examples are based on the DataSources shown at the end of this section.
// <p>
// Note that <code>Customer &gt; Employee</code> relation can use foreignKey field <code>accountMgrEmployeeNumber</code>
// (Account manager) or foreignKey field <code>salesRepEmployeeNumber</code> (Sales representative).
// <p>
// All examples below resolve the same relation chain:
// <pre>
// Order &gt; Customer (via accountMgrEmployeeNumber) &gt; Employee &gt; Office
// </pre>
// <h4>Example 1: Full path specified</h4>
// Explicit composite keys at every step.
// <pre>
// includeFrom="Customer.Employee.Office.city"
// includeVia="Order.customerNumber:Customer.accountMgrEmployeeNumber:Employee.officeCode"
// </pre>
// <h4>Example 2: Partial includeVia with omitted datasource names</h4>
// Unambiguous field names allow datasource names to be omitted.
// <pre>
// includeFrom="Customer.Employee.Office.city"
// includeVia="customerNumber:accountMgrEmployeeNumber"
// </pre>
// <h4>Example 3: Minimal includeVia</h4>
// Only the override for the non-default FK path is needed; the rest is resolved automatically.
// <pre>
// includeFrom="Customer.Employee.Office.city"
// includeVia="accountMgrEmployeeNumber"
// </pre>
// <h4>Example 4: Shorter includeFrom with full includeVia</h4>
// The includeFrom starts mid-chain, but includeVia ensures correct relation chain from the base DataSource.
// <pre>
// includeFrom="Employee.Office.city"
// includeVia="Order.customerNumber:Customer.accountMgrEmployeeNumber:Employee.officeCode"
// </pre>
// <h4>Example 5: Minimal includeFrom and includeVia</h4>
// System finds shortest valid path from base to target using the provided override.
// <pre>
// includeFrom="Office.city"
// includeVia="accountMgrEmployeeNumber"
// </pre>
// <h4>Datasources used in samples:</h4>
// <pre>
// &lt;DataSource ID="Order" serverType="sql"&gt;
//     &lt;fields&gt;
//         &lt;field name="orderNumber" type="integer" primaryKey="true" /&gt;
//         &lt;field name="orderDate" type="date" required="true"/&gt;
//         &lt;field name="customerNumber" type="integer" foreignKey="Customer.customerNumber" /&gt;
//     &lt;/fields&gt;
// &lt;/DataSource&gt;
// </pre>
// <pre>
// &lt;DataSource ID="Customer" serverType="sql"&gt;
//     &lt;fields&gt;
//         &lt;field name="customerNumber" type="integer" primaryKey="true" /&gt;
//         &lt;field name="customerName" type="text" required="true"/&gt;
//         &lt;field name="salesRepEmployeeNumber" type="integer" foreignKey="Employee.employeeNumber" /&gt;
//         &lt;field name="accountMgrEmployeeNumber" type="integer" foreignKey="Employee.employeeNumber" /&gt;
//     &lt;/fields&gt;
// &lt;/DataSource&gt;
// </pre>
// <pre>
// &lt;DataSource ID="Employee" serverType="sql"&gt;
//     &lt;fields&gt;
//         &lt;field name="employeeNumber" type="integer" primaryKey="true" /&gt;
//         &lt;field name="lastName" type="text" required="true"/&gt;
//         &lt;field name="firstName" type="text" required="true"/&gt;
//         &lt;field name="officeCode" type="text" foreignKey="Office.officeCode" /&gt;
//     &lt;/fields&gt;
// &lt;/DataSource&gt;
// </pre>
// <pre>
// &lt;DataSource ID="Office" serverType="sql"&gt;
//     &lt;fields&gt;
//         &lt;field name="officeCode" type="text" primaryKey="true" /&gt;
//         &lt;field name="city" type="text" /&gt;
//     &lt;/fields&gt;
// &lt;/DataSource&gt;
// </pre>
// @title <code>includeVia</code> syntax
// @visibility external
//<

//> @groupDef includeViaAndDomainKey
// In some legacy systems, composite primary keys are used to simulate multi-tenancy,
// often by including a <code>domainKey</code> or a similar field in the key. SmartClient
// supports this pattern by allowing <code>includeVia</code> to work with composite keys.
// <p>
// This usage is generally discouraged in modern development. We strongly recommend using
// +link{group:multiTenancy,SmartClient’s transparent multi-tenancy} approach instead, which
// provides true multi-tenant separation with less complexity and better long-term maintainability.
// <p>
// However, if you're working with an existing legacy system that uses this pattern, <code>includeVia</code>
// can be used to precisely define foreign key paths involving composite keys and indirect relation chains.
// <p>
// The examples below are based on the DataSources shown at the end of this section and are using the
// same data structure as in the +link{group:includeViaSyntax,<code>includeVia</code> syntax and behavior},
// but with an additional <i>domainKey</i> primary key field added to all DataSources to separate data into
// logical domains such as "live" and "test". Similarly all examples below also resolve the same relation chain:
// <pre>
// Order &gt; Customer (via accountMgrEmployeeNumber) &gt; Employee &gt; Office
// </pre>
// <h4>Example 1: Full path specified</h4>
// Explicit composite keys at every step.
// <pre>
// includeFrom="Customer.Employee.Office.city"
// includeVia="Order.customerNumber-domainKey:Customer.accountMgrEmployeeNumber-domainKey:Employee.officeCode-domainKey"
// </pre>
// <h4>Example 2: Partial includeVia with omitted datasource names</h4>
// Unambiguous field names allow datasource names to be omitted.
// <pre>
// includeFrom="Customer.Employee.Office.city"
// includeVia="customerNumber-domainKey:accountMgrEmployeeNumber-domainKey"
// </pre>
// <h4>Example 3: Minimal includeVia</h4>
// Only the override for the non-default FK path is needed; the rest is resolved automatically.
// <pre>
// includeFrom="Customer.Employee.Office.city"
// includeVia="accountMgrEmployeeNumber-domainKey"
// </pre>
// <h4>Example 4: Shorter includeFrom with full includeVia</h4>
// The includeFrom starts mid-chain, but includeVia ensures correct relation chain from the base DataSource.
// <pre>
// includeFrom="Employee.Office.city"
// includeVia="Order.customerNumber-domainKey:Customer.accountMgrEmployeeNumber-domainKey:Employee.officeCode-domainKey"
// </pre>
// <h4>Example 5: Minimal includeFrom and includeVia</h4>
// System finds shortest valid path from base to target using the provided override.
// <pre>
// includeFrom="Office.city"
// includeVia="accountMgrEmployeeNumber-domainKey"
// </pre>
// <h4>Datasources used in samples:</h4>
// <pre>
// &lt;DataSource ID="Order" serverType="sql"&gt;
//     &lt;fields&gt;
//         &lt;field name="orderNumber" type="integer" primaryKey="true" /&gt;
//         &lt;field name="domainKey" type="text" primaryKey="true" foreignKey="Customer.domainKey"/&gt;
//         &lt;field name="orderDate" type="date" required="true"/&gt;
//         &lt;field name="customerNumber" type="integer" foreignKey="Customer.customerNumber" /&gt;
//     &lt;/fields&gt;
// &lt;/DataSource&gt;
// </pre>
// <pre>
// &lt;DataSource ID="Customer" serverType="sql"&gt;
//     &lt;fields&gt;
//         &lt;field name="customerNumber" type="integer" primaryKey="true" /&gt;
//         &lt;field name="domainKey" type="text" primaryKey="true" foreignKey="Employee.domainKey" /&gt;
//         &lt;field name="customerName" type="text" required="true"/&gt;
//         &lt;field name="salesRepEmployeeNumber" type="integer" foreignKey="Employee.employeeNumber" /&gt;
//         &lt;field name="accountMgrEmployeeNumber" type="integer" foreignKey="Employee.employeeNumber" /&gt;
//     &lt;/fields&gt;
// &lt;/DataSource&gt;
// </pre>
// <pre>
// &lt;DataSource ID="Employee" serverType="sql"&gt;
//     &lt;fields&gt;
//         &lt;field name="employeeNumber" type="integer" primaryKey="true" /&gt;
//         &lt;field name="domainKey" type="text" primaryKey="true" foreignKey="Office.domainKey"/&gt;
//         &lt;field name="lastName" type="text" required="true"/&gt;
//         &lt;field name="firstName" type="text" required="true"/&gt;
//         &lt;field name="officeCode" type="text" foreignKey="Office.officeCode" /&gt;
//     &lt;/fields&gt;
// &lt;/DataSource&gt;
// </pre>
// <pre>
// &lt;DataSource ID="Office" serverType="sql"&gt;
//     &lt;fields&gt;
//         &lt;field name="officeCode" type="text" primaryKey="true" /&gt;
//         &lt;field name="domainKey" type="text" primaryKey="true" /&gt;
//         &lt;field name="city" type="text" /&gt;
//     &lt;/fields&gt;
// &lt;/DataSource&gt;
// </pre>
//
// @title Using <code>includeVia</code> with Composite Keys and <i>domainKey</i>
// @visibility external
//<

//> @attr dataSourceField.relatedTableAlias (String : null : IR)
// For a +link{group:sqlDataSource,SQL DataSource} field that specifies a
// +link{dataSourceField.foreignKey,foreignKey}, this property defines the table alias name to
// use in generated SQL.
// <p>
// Aliasing is necessary when the same table appears more than once in a query.  This can
// happen when using +link{dataSourceField.includeVia, Multiple <code>includeFrom</code>
// fields referring to the same related DataSource}.  It can also happen when a
// +link{dataSourceField.foreignKey,foreignKey} definition references the same dataSource
// that the field is defined in; this happens with hierarchical structures, for example where
// every Employee reports to another Employee, a so-called "self join", and it
// <em>always</em> requires <code>relatedTableAlias</code> to be specified; failure to do so
// will result in invalid SQL.
// <p>
// In case of indirect relationship, when more than single join is needed to join the target table, and
// +link{dataSourceField.includeVia,includeVia} is missing, generated alias is a concatenation of
// <code>relatedTableAlias</code> and FK field names starting with the first <code>relatedTableAlias</code>
// met in chain of relations leading to the target table.
// <p>
// See the "Automatically generated table aliases" section of the +link{group:customQuerying,SQL Templating}
// for more details.
//
// @see dataSource.relatedTableAlias
// @see dataSourceField.includeVia
// @example sqlIncludeVia
// @serverDS only
// @group dataSourceRelations
// @visibility external
//<

//> @attr dataSourceField.otherFKs (String : null : IR)
// In addition to regular +link{dataSourceField.foreignKey,foreignKey} this property allows
// defining multiple foreign keys if the field is related to more than one DataSource.
// <p>
// The format of the <code>otherFKs</code> is coma separated foreign key sets, for example:
// <i><code>"&lt;firstDS&gt;.&lt;fieldName&gt;,&lt;secondDS&gt;.&lt;fieldName&gt;"</code></i>.
// Note that this property works only in addition to the regular FK, i.e. if
// +link{dataSourceField.foreignKey,foreignKey} is not set, then foreign keys defined in <code>otherFKs</code>
// will be completely ignored. If <code>otherFKs</code> is specified, it can include the value of the
// <code>foreignKey</code> attribute or it can omit it, listing only additional foreignKeys.  There
// is no impact on functionality from doing it either way.
// <p>
// For example, perhaps you have a <code>moneyTransfer</code> DataSource where each record represents
// a money transfer, which has <code>receipt</code> and <code>invoice</code> information stored in
// <code>receiptDS</code> and <code>receiverDS</code> DataSources. Each money transfer is linked to a
// receipt and an invoice records through the same <code>transferDS.id</code> field via the foreign keys
// defined in <code>foreignKey</code> and <code>otherFKs</code> properties:
// <pre>
// &lt;DataSource ID="moneyTransfer" ... &gt;
//      &lt;field name="id" primaryKey="true"
//          foreignKey="receiptDS.id"
//          otherFKs="invoiceDS.id"/&gt;
//      &lt;field name="receiptInfo" includeFrom="receiptDS.info"/&gt;
//      &lt;field name="invoiceInfo" includeFrom="invoiceDS.info"/&gt;
// &lt;/DataSource&gt;
// </pre>
// Here, we are including from two different related <code>DataSources</code> using the same
// <code>foreignKey</code> field.
// <p>
// Note that <code>otherFKs</code> feature is meant to be used in more complex scenarios (see below), so if the
// example above is all that's needed, then there's no need to use <code>otherFKs</code> feature. The result
// would be the same as if foreign keys would be declared at the "other side", i.e. in <code>receiptDS</code>
// and <code>invoiceDS</code> DataSources via regular +link{dataSourceField.foreignKey} property.
// <p>
// If we extend the sample above with a <code>parentId</code> joining the <code>moneyTransfer</code> DataSource
// (so called "self-join" relation) and include from <code>receiptDS</code> and <code>invoiceDS</code> for
// the "parent" money transfer as well, then <code>otherFKs</code> feature must be used. The following
// declarations would be required to get receipt and invoice information for both the original money transfer
// and its "parent":
// <pre>
// &lt;field name="id" primaryKey="true" foreignKey="receiptDS.id" otherFKs="invoiceDS.id"/&gt;
// &lt;field name="receiptInfo" includeFrom="receiptDS.info"/&gt;
// &lt;field name="invoiceInfo" includeFrom="invoiceDS.info"/&gt;
// &lt;field name="parentId" foreignKey="moneyTransfer.id" relatedTableAlias="parent"/&gt;
// &lt;field name="parentReceiptInfo" includeFrom="moneyTransfer.receiptDS.info"/&gt;
// &lt;field name="parentInvoiceInfo" includeFrom="moneyTransfer.invoiceDS.info"/&gt;
// </pre>
// <p>
// <h3>SQL Templating and <code>otherFKs</code></h3>
// <p>
// Similar to the <code>includeVia</code>, <code>otherFKs</code> feature uses SQL table aliases in the
// generated SQL when generating multiple SQL joins to the same SQL table.  When using
// <code>SQL Templating</code>, it's sometimes necessary to know the names of the aliases in the generated
// SQL. See the "Automatically generated table aliases" section of the +link{group:customQuerying,SQL Templating}
// for the complete set of general rules how aliases are generated.
// <p>
// The <code>otherFKs</code> feature uses aliases constructed from two parts:<br>
// - the +link{dataSourceField.name,field name}, which otherFKs property is defined on;<br>
// - the related +link{dataSource.ID, DataSource ID} or the +link{dataSource.relatedTableAlias} if set.<p>
// So, in the extended sample above the aliases for the "parent" money transfer related tables would be
// "<i>parent_id</i>" (regular FK) and "<i>parent_<b>id_invoiceDS</b></i>" (other FK).
// <p>
// See below the same sample extended with the <code>detailDS</code> DataSource storing multiple records per money
// transfer, joined to <code>moneyTransfer</code> DataSource on a one-to-many basis, and include receipt and
// invoice information for money transfer and its "parent". Also, we'll add <code>relatedTableAliases</code>
// to the invoice DataSource, see all related declarations below:
// <pre>
// &lt;DataSource ID="detailDS" ... &gt;
//      &lt;field name="id" type="integer" primaryKey="true" &gt;
//      &lt;field name="name"/&gt;
//      &lt;field name="mtId" foreignKey="moneyTransfer.id" relatedTableAlias="main"/&gt;
//      &lt;field name="mainReceipt" includeFrom="moneyTransfer.receiptInfo" includeVia="mtId"/&gt;
//      &lt;field name="mainInvoice" includeFrom="moneyTransfer.invoiceInfo" includeVia="mtId"/&gt;
//      &lt;field name="mainParentReceipt" includeFrom="moneyTransfer.parentReceiptInfo" includeVia="mtId"/&gt;
//      &lt;field name="mainParentInvoice" includeFrom="moneyTransfer.parentInvoiceInfo" includeVia="mtId"/&gt;
// &lt;/DataSource&gt;
//
// &lt;DataSource ID="receiptDS" ... &gt;
//      &lt;fields&gt;
//          &lt;field name="id" primaryKey="true"/&gt;
//          &lt;field name="info"/&gt;
//      &lt;/fields&gt;
// &lt;/DataSource&gt;
//
// &lt;DataSource ID="invoiceDS" relatedTableAlias="invoice" ... &gt;
//      &lt;fields&gt;
//          &lt;field name="id" primaryKey="true"/&gt;
//          &lt;field name="info"/&gt;
//      &lt;/fields&gt;
// &lt;/DataSource&gt;
// </pre>
// Generated aliases for the receipt/invoice tables will be <code>main_id</code>, <code>main_<b>id_invoice</b></code>
// for the money transfer and <code>main_parent_id</code>, <code>main_parent_<b>id_invoice</b></code> for the "parent"
// money transfer.
// <p>
// <h3><code>otherFKs</code> + <code>includeVia</code></h3>
// <p>
// The <code>otherFKs</code> and the +link{dataSourceField.includeVia} features may be used together in even
// more complex scenarios. In the example below we extend <code>detailDS</code> DataSource with a link to
// the "previous" money transfer and include all of its receipt/invoice information:
// <pre>
// &lt;field name="mtPrevId" foreignKey="moneyTransfer.id" relatedTableAlias="prev"/&gt;
// &lt;field name="prevReceipt" includeFrom="moneyTransfer.receiptInfo" includeVia="mtPrevId"/&gt;
// &lt;field name="prevInvoice" includeFrom="moneyTransfer.invoiceInfo" includeVia="mtPrevId"/&gt;
// &lt;field name="prevParentReceipt" includeFrom="moneyTransfer.parentReceiptInfo" includeVia="mtPrevId"/&gt;
// &lt;field name="prevParentInvoice" includeFrom="moneyTransfer.parentInvoiceInfo" includeVia="mtPrevId"/&gt;
// </pre>
// Additionally generated aliases will be <code>prev_id</code>, <code>prev_<b>id_invoice</b></code>
// for the money transfer and <code>prev_parent_id</code>, <code>prev_parent_<b>id_invoice</b></code>
// for the "parent" money transfer.
// <p>
// The inclusions may as well be indirect like shown below and they would produce same chains of relations,
// so the generated SQL and table aliases will be the same as above.
// <pre>
// &lt;field name="mtPrevId" foreignKey="moneyTransfer.id" relatedTableAlias="prev"/&gt;
// &lt;field name="prevReceipt" includeFrom="<i>moneyTransfer.receiptDS.info</i>" includeVia="mtPrevId"/&gt;
// &lt;field name="prevInvoice" includeFrom="<i>moneyTransfer.invoiceDS.info</i>" includeVia="mtPrevId"/&gt;
// &lt;field name="prevParentReceipt" includeFrom="<i>moneyTransfer.moneyTransfer.receiptDS.info</i>" includeVia="mtPrevId"/&gt;
// &lt;field name="prevParentInvoice" includeFrom="<i>moneyTransfer.moneyTransfer.invoiceDS.info</i>" includeVia="mtPrevId"/&gt;
// </pre>
//
// @see dataSourceField.otherFKs
// @see dataSource.relatedTableAlias
// @see dataSourceField.includeVia
// @example sqlOtherFKs
// @serverDS only
// @group dataSourceRelations
// @visibility external
//<

//> @attr dataSourceField.formula (String : null : IR)
// If <code>field.formula</code> is set, this field's value in records will be
// calculated dynamically.
// <P>
// <code>DataSourceField.formula</code> is supported for
// +link{type:DSServerType,SQL DataSources} and for
// +link{dataSource.clientOnly,clientOnly dataSources} only.
// <P>
// Valid formula expressions may reference other field values directly by field name, or
// may reference the record object itself. Formula expressions may make use of standard
// +link{group:formulaFunction,FormulaFunctions}.
// <P>
// For example, given a dataSource with two numeric fields "population" and "area"
// you could easily add a "populationDensity" field with the following formula:
// <pre>
// &lt;field name="populationDensity" type="float"&gt;
//      &lt;formula&gt;round(population/area)&lt;/formula&gt;
// &lt;/field&gt;
// </pre>
// <P>
// For SQL DataSources, values are calculated on the server by modifying the
// generated SQL request as appropriate. For clientOnly dataSources, values are
// calculated as part of the
// +link{dataSource.getClientOnlyResponse(),standard fetch response flow}.
// Since the field values are calculated in the data source layer, standard
// capbilities like server side sorting of paged data sets are supported for these
// fields. This would not be the case for formula field values calculated
// +link{ListGridField.userFormula,at the component level}.
// <P>
// As with other
// +link{dataSource.isCalculated(),dynamically calculated}
// fields, fields with a specified formula are non editable.<br>
// When records are displayed in
// +link{dataBoundComponent,dataBoundComponents that support editing},
// formula field values will be re-calculated dynamically on the client as the user
// edits a record, so a user may preview the result of their changes.
// <P>
// Note that <code>formula</code> fields may not make use of
// +link{dataSourceField.includeFrom,fields included from related dataSources}.
// <b>DataSourceField.formula is available with Power or better licenses only.</b>  See
// <a href="http://smartclient.com/product">smartclient.com/product</a> for details.
//
// @group calculatedDataSourceFields
// @serverDS allowed
// @visibility external
//<


//> @attr dataSourceField.template (String : null : IR)
// If <code>field.template</code> is set, this field's value in records will be
// calculated dynamically via the specified +link{UserSummary,template}.
// <P>
// This property may be set to a valid +link{UserSummary.text,template expression}.
// <P>
// For example a composite field for a dataSource of citation references containing
// "volume", "issue", and "pages" fields might use the following template:
// <pre>
// &lt;field name="compositeLocation" title="Volume (issue), pages"&gt;
//      &lt;template&gt;#{volume} (#{issue}), #{pages}&lt;/template&gt;
// &lt;/field&gt;
// </pre>
// <i>[This example might produce output like <code>"12 (5), 121-137"</code>]</i>.
// <P>
// For SQL DataSources, values are calculated on the server by modifying the
// generated SQL request as appropriate. As with other
// +link{dataSource.isCalculated(),dynamically calculated}
// fields, fields with a specified template are non editable.<br>
// When records are displayed in
// +link{dataBoundComponent,dataBoundComponents that support editing},
// template field values will be re-calculated dynamically on the client as the user
// edits a record, so a user may preview the result of their changes.
// <P>
// Note that <code>template</code> fields may make use of
// +link{dataSourceField.formula,formula fields},
// +link{dataSourceField.includeFrom,fields included from related dataSources}
// +link{dataSourceField.includeSummaryFunction,aggregated values from related dataSources},
// and +link{dataSourceField.customSelectExpression,fields derived via customSQL}.
// <P>
// <code>DataSourceField.template</code> is supported for
// +link{type:DSServerType,SQL DataSources}, and for
// +link{dataSource.clientOnly,clientOnly dataSources} only.
// <P>
// <b>DataSourceField.formula is available with Power or better licenses only.</b>  See
// <a href="http://smartclient.com/product">smartclient.com/product</a> for details.
//
// @group calculatedDataSourceFields
// @visibility external
//<



//> @attr dataSourceField.displayField (String : null : IR)
// When records from this dataSource are displayed in a dataBoundComponent such as a
// +link{ListGrid}, the <code>displayField</code> attribute may be used to cause some
// field to display a value from another field in the record.
// <P>
// This is typically used for editable +link{dataSourceField.foreignKey} fields.
// In this scenario, a dataSource
// field has a foreignKey field which stores an ID value used to identify records in another,
// related dataSource. Rather than display this ID to users, developers may wish to display
// another, user-friendly field from the related record. This is easy to achieve by
// having a second field on the dataSource which will be populated with the "display value"
// from this related dataSource, and using <code>dataSourceField.displayField</code>
// to show this value.  The +link{DataSourceField.includeFrom} feature handles populating
// this field automatically for dataSources backed by the
// +link{group:serverDataIntegration,SmartClient Server}. See the "Editing included fields"
// section of the +link{dataSourceField.includeFrom} documentation
// for more on editing included foreignKey fields.
// <P>
// Editable dataSourceFields with a specified <code>displayField</code> and
// <code>foreignKey</code> will typically be edited using a +link{SelectItem}
// or +link{ComboBoxItem}. In this case, in addition to identifying the field to use as a
// static display value within the record being edited, <code>displayField</code>
// will also identify which field on the related dataSource
// to use as a display field when showing a set of options to the user. This behavior may
// be modified in a couple of ways:
// <ul>
//  <li>The +link{dataSourceField.foreignDisplayField} attribute may be used to handle the
//      case where the name of the field used as a displayField within the dataSource is
//      different from the name of the included/equivalent field in the related dataSource.</li>
//  <li>The +link{dataSourceField.useLocalDisplayFieldValue} attribute may be explicitly
//      set to false to avoid picking up a display value from the local record altogether.
//      Instead the displayField will be used only to derive the display value from
//      a related record from the optionDataSource</li>
// </ul>
// For more on how FormItems use the displayField property, see +link{FormItem.displayField}.
//
// @serverDS allowed
// @group dataSourceRelations
// @visibility external
//<

//> @attr dataSourceField.useLocalDisplayFieldValue (Boolean : null : IR)
// The +link{formItem.useLocalDisplayFieldValue} attribute may be specified
// within a dataSource configuration.
// <P>
// This property governs whether, when displaying a record in an editor component,
// the <code>displayField</code> value for this field should be picked up directly from
// the record value (as opposed to being retrieved via an explicit fetch operation against
// the +link{formItem.optionDataSource}). See +link{formItem.useLocalDisplayFieldValue}
// for further details.
// <P>
// If not explicitly set, dataSources backed by the
// +link{group:serverDataIntegration,SmartClient server} will set this property to true
// automatically for fields where the specified +link{dataSourceField.displayField} values
// are retrieved from another dataSource using the +link{dataSourceField.includeFrom}
// feature.
//
// @serverDS allowed
// @visibility external
//<

//> @attr dataSourceField.foreignDisplayField (String : null : IR)
// Name of another field in a separate dataSource that should be used as the display
// value for this field in the case where a <code>foreignKey</code> relationship
// exists.  Derived automatically when using the displayField / includeFrom pattern as
// illustrated in the following example.
// <P>
// For a general overview on picking up display values from a separate field,
// see +link{dataSourceField.displayField} property.
// <P>
// The <code>foreignDisplayField</code> property is useful for editable fields, where the
// name of the display field within the record being edited differs from the display field
// for related records in the option dataSource.<br>
// For example consider a "countryDS" dataSource with the following fields:
// <pre>
//  &lt;field name="id"     type="sequence"   hidden="true"     primaryKey="true" /&gt;
//  &lt;field name="name"   type="text"       title="Country"   required="true" /&gt;
// </pre>
// ...and a "city" dataSource which uses a foreignKey relationship identify associated
// country records:
// <pre>
//  &lt;field name="id"        type="sequence" hidden="true"   primaryKey="true" /&gt;
//  &lt;field name="name"      type="text"     title="City"    required="true" /&gt;
//  &lt;field name="countryId" type="integer"  editorType="SelectItem"
//             foreignKey="countryDS.id"
//             displayField="countryName" foreignDisplayField="name" title="Country" /&gt;
//  &lt;field name="countryName" includeFrom="countryDS.name"  hidden="true"   /&gt;
// </pre>
// A DynamicForm bound to this "city" dataSource would display a SelectItem editor by
// default for the country field. The initial display value would be the local value from
// the "countryName" field, populated from the related countryDS automatically via the
// +link{dataSourceField.includeFrom} feature.<br>
// If the user showed the drop-down list of options for this field, the display values
// within that list would be picked up from the "name" field values for the related
// "countryDS" records.  Again, note that the foreignDisplayField would have been derived in
// this case, and need not be specified explicitly.
// <P>
// Note that when specified, <code>foreignDisplayField</code> is always expected to be set to
// the related dataSource field containing equivalent values to the <code>displayField</code>
// in the local dataSource. This is important as, when editing the field, foreignDisplayField values from
// the related dataSource will be displayed to the user, and when a value is selected
// the local record's <code>displayField</code> value will be updated to match the selected
// <code>foreignDisplayField</code> value from the related dataSource's record. This behavior
// is documented under +link{formItem.displayField}.
//
// @serverDS allowed
// @group dataSourceRelations
// @visibility external
//<

//> @attr dataSourceField.joinType (JoinType : null : IR)
// This property is only applicable to fields of SQL DataSources that also specify a
// +link{foreignKey,foreignKey} property; it is ignored for all other fields.  Indicates the
// type of join to make between the tables underlying this DataSource and the other DataSource
// referred to in the <code>foreignKey</code> property, when resolving +link{includeFrom,includeFrom}
// fields.  The default value of null is the same as specifying "inner".
// <P>
// Note, outer joins are allowed for all supported database products only if you are using
// +link{dataSource.useAnsiJoins,ANSI-style joins}.  If you
// are using the older strategy of additional join expressions in the WHERE clause, outer
// joins are only supported for database products that provide a proprietary native syntax for
// expressing outer joins.  Those products are:<ul>
// <li>Oracle</li>
// <li>Versions of Microsoft SQL Server earlier than 2012, and running in compatibility mode 80</li>
// </ul>
//
// @serverDS only
// @group dataSourceRelations
// @visibility external
//<


//> @type JoinType
// The type of join to make between two SQL tables when resolving
// +link{dataSourceField.includeFrom,includeFrom} fields.
//
// @value "inner"    A regular inner join, whereby rows are only included in the resultset
//                   where the join can be satisified, so a missing row in the table being
//                   joined to results in the entire row being omitted.
// @value "outer"    An outer join.  All outer joins generated by SmartClient's SQL subsystem
//                   are left outer joins, meaning that every row in the join-from (or "left")
//                   table that matches the criteria is included, and missing rows in the
//                   join-to (or "right") table cause columns to be set to null.
//
// @serverDS only
// @group dataSourceRelations
// @visibility external
//<

//> @attr dataSourceField.sqlForceInsensitive (Boolean : null : IR)
// This property is only applicable to fields of SQL DataSources, it overrides default behavior
// of +link{type:OperatorId,iContains} case insensitive operator on the server-side. Set to
// <code>true</code> to force case insensitivity by changing case of both comparison expression
// sides or <code>false</code> to rely on database <code>LIKE</code> operator directly.<br>
// See +link{group:sqlSettings} for more details including database specific defaults and other
// configuration options.
//
// @serverDS only
// @group sqlSettings
// @visibility external
// @deprecated See the <code>sql.likeIsCaseSensitive</code> flag in +link{group:sqlSettings,SQL settings}.
//<

// Summary functions
// ---------------------------------------------------------------------------------------

//> @attr dataSourceField.summaryFunction (SummaryFunction : null : IR)
// @include listGridField.summaryFunction
// @visibility external
//<

//> @attr dataSourceField.summaryValueTitle (String : null : IR)
// Title to show in a +link{SummaryFunction,Summary of type "title"} for this field. If unspecified
// <code>title</code> summaries will show the +link{dataSourceField.title} for the field.
// @visibility external
//<



// XML binding / serialization
// ---------------------------------------------------------------------------------------

//> @attr dataSourceField.xmlAttribute (boolean : null : IR)
// Indicates that +link{dataSource.xmlSerialize()} should serialize this value as an XML
// attribute.
// <P>
// Note this does not need to be declared in order for DataSource records to be derived from
// XML data: a field will be populated with either an attribute or subelement with matching
// name.
//
// @group xmlSerialize
// @group componentSchema
// @serverDS allowed
// @visibility external
//<
//> @attr dataSourceField.childTagName (String : null : IR)
// For a field that is +link{multiple,multiple:"true"}, controls the name of the XML tag used for each
// subelement during +link{dataSource.xmlSerialize()}.
// <P>
// If unset, the default tag name is "value" for a field of simple type, and for a field of
// DataSource type, is the tagName or ID of the DataSource (as though
// <code>xmlSerialize()</code> were called on the child DataSource).
//
// @group xmlSerialize
// @group componentSchema
// @serverDS allowed
// @visibility external
//<

//> @attr dataSourceField.propertiesOnly (boolean : null : IR)
// For use in +link{group:componentSchema} for fields that contain other components, this flag
// suppresses auto-construction for subcomponents that appear under this field.
// <P>
// For example, the +link{VLayout} schema sets this for its +link{Layout.members,members}
// property, so that when a VLayout is constructed via XML as follows:
// <pre>
// &lt;VLayout&gt;
//     &lt;members&gt;
//         &lt;ListGrid ID="myGrid" .../&gt;
//         &lt;Toolstrip ID="myToolStrip" ... /&gt;
//     &lt;/members&gt;
// &lt;/VLayout&gt;
// </pre>
// The ListGrid and ToolStrip do not construct themselves automatically.  Instead, the VLayout
// receives the properties of the ListGrid and ToolStrip as ordinary JavaScript Objects, with
// the special property <code>_constructor</code> set to the name of the class that should be
// constructed.
//
// @group componentSchema
// @serverDS allowed
// @visibility external
//<

//> @attr dataSourceField.inapplicable (boolean : null : IR)
// For use in +link{group:componentSchema}, a field +link{dataSource.inheritsFrom,inherited} from
// another schema can be redeclared with this property set in order to indicate that the
// property should not be used.
// <P>
// This is primarily used to influence +link{group:reify,Reify}.  For simple type properties,
// this avoids the property appearing in the Component Editor.
// <P>
// For fields that hold subcomponents, this prevents inappropriate drag and drop.  For example,
// a custom class called <code>MyDialog</code> may automatically create a series of children,
// and not allow arbitrary other children to be added.  In this case, the inherited property
// +link{Canvas.children} should be marked inapplicable in order to prevent arbitrary
// components being dropped onto a <code>MyDialog</code> instance.
//
// @group componentSchema
// @serverDS allowed
// @visibility external
//<

//> @attr dataSourceField.group (String : null : IR)
// For use in +link{group:componentSchema}, indicates what group to place the property in when
// editing in Reify.
//
// @group componentSchema
// @serverDS allowed
// @visibility external
//<

//> @attr dataSourceField.recreateOnChange (Boo