/*
 * Decompiled with CFR 0.152.
 */
package com.isomorphic.autotest;

import com.isomorphic.autotest.BatchEvaluator;
import com.isomorphic.autotest.BuilderSpecifier;
import com.isomorphic.autotest.ConfiguredBase;
import com.isomorphic.autotest.InconsistentBatchRunTableException;
import com.isomorphic.autotest.TestRunner;
import com.isomorphic.autotest.TestRunnerLauncher;
import com.isomorphic.autotest.Utils;
import com.isomorphic.criteria.AdvancedCriteria;
import com.isomorphic.criteria.Criterion;
import com.isomorphic.criteria.DefaultOperators;
import com.isomorphic.criteria.criterion.NotNullCriterion;
import com.isomorphic.criteria.criterion.OrCriterion;
import com.isomorphic.criteria.criterion.SimpleCriterion;
import com.isomorphic.datasource.DSRequest;
import com.isomorphic.datasource.DSResponse;
import com.isomorphic.log.Logger;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TimeZone;

public class BatchRunDao
extends ConfiguredBase {
    private static Logger log = new Logger(BatchRunDao.class.getName());

    public static void add(Date batchStartTime, String user, String suiteName, String branch, String modifiedFiles, String log) throws Exception {
        DSRequest dsReq = new DSRequest(config.getBatchRunDS(), "add");
        HashMap<String, Object> dataMap = new HashMap<String, Object>();
        dataMap.put("batchStartTime", batchStartTime);
        dataMap.put("user", user);
        dataMap.put("branch", branch);
        TestRunnerLauncher launcher = (TestRunnerLauncher)config;
        if (BuilderSpecifier.isReifyCloud(suiteName)) {
            dataMap.put("reifyCloudTarget", launcher.getReifyCloudTarget());
        }
        if (launcher.canParseLog(suiteName)) {
            modifiedFiles = BatchRunDao.clipTextField("modifiedFiles", modifiedFiles);
            dataMap.put("modifiedFiles", modifiedFiles);
        }
        dataMap.put("log", BatchRunDao.clipTextField("log", log));
        dsReq.setValues(dataMap);
        dsReq.execute();
    }

    public static List<Date> getBatchTimes(String branch, AdvancedCriteria extraCriteria) throws Exception {
        SimpleCriterion branchCriterion;
        DSRequest dsReq = new DSRequest(config.getBatchRunDS(), "fetch");
        Object object = branchCriterion = branch != null ? new SimpleCriterion("branch", DefaultOperators.Equals, (Object)branch) : new NotNullCriterion("branch");
        if (extraCriteria != null) {
            extraCriteria.addCriteria((Criterion)branchCriterion);
        } else {
            extraCriteria = new AdvancedCriteria((Criterion)branchCriterion);
        }
        if ("reifyBatch".equals(config.getBatchRunDS())) {
            String reifyCloudTarget = ((TestRunnerLauncher)config).getReifyCloudTarget();
            SimpleCriterion targetCriteria = reifyCloudTarget != null ? new SimpleCriterion("reifyCloudTarget", DefaultOperators.Equals, (Object)reifyCloudTarget) : new NotNullCriterion("reifyCloudTarget");
            extraCriteria.addCriteria((Criterion)targetCriteria);
        }
        dsReq.setAdvancedCriteria(extraCriteria);
        dsReq.setOutputs(Arrays.asList("batchStartTime"));
        DSResponse dsResp = dsReq.execute();
        List data = dsResp.getDataList();
        ArrayList<Date> result = new ArrayList<Date>();
        for (Object dateRow : data) {
            Map row = (Map)dateRow;
            Date d = (Date)row.get("batchStartTime");
            result.add(d);
        }
        Collections.sort(result, Collections.reverseOrder());
        return result;
    }

    public static Date getLastBatchFromPreviousDay(String branch) throws Exception {
        Calendar calendar = Calendar.getInstance();
        calendar.set(11, calendar.getMaximum(11));
        calendar.set(12, calendar.getMaximum(12));
        calendar.set(13, calendar.getMaximum(13));
        calendar.set(14, calendar.getMaximum(14));
        String autobuildDate = config.getBuildDate();
        if (autobuildDate != null) {
            try {
                SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd");
                dateFormat.parse(autobuildDate);
                Calendar specifiedCalendar = dateFormat.getCalendar();
                calendar.set(specifiedCalendar.get(1), specifiedCalendar.get(2), specifiedCalendar.get(5));
                log.info((Object)("Using the specified BUILD_DATE of '" + autobuildDate + "' rather than actual date in getLastBatchFromPreviousDay()"));
            }
            catch (ParseException e) {
                log.error((Object)("Could not parse specified BUILD_DATE of '" + autobuildDate + "'; using the actual date  " + String.valueOf(calendar) + " instead"), (Throwable)e);
            }
        }
        TimeZone pacificZone = TimeZone.getTimeZone("America/Los_Angeles");
        long pacificUtcOffset = pacificZone.getOffset(new Date().getTime());
        long startOfToday = calendar.getTime().getTime() - 86400000L - pacificUtcOffset;
        long startOfYesterday = startOfToday - 86400000L;
        startOfToday = (long)((double)startOfToday + config.getNightlyBuildOffset() * 3600.0 * 1000.0);
        List<Date> batches = BatchRunDao.getBatchTimes(branch, null);
        for (int i = 0; i < batches.size(); ++i) {
            long kthBatchStartTime = batches.get(i).getTime();
            if (kthBatchStartTime <= startOfYesterday) {
                return null;
            }
            if (kthBatchStartTime > startOfToday) continue;
            return batches.get(i);
        }
        return null;
    }

    public static Date getLatestPassingBatchStartTime(Date batchStartTime, String suiteName, String branch, Double threshold) throws Exception {
        String camelSuite = TestRunner.getSuiteNameAsCamelCase(suiteName);
        ArrayList<SimpleCriterion> stateCheck = new ArrayList<SimpleCriterion>();
        stateCheck.add(new SimpleCriterion(camelSuite + "State", "contains", (Object)"T"));
        stateCheck.add(new SimpleCriterion(camelSuite + "State", "contains", (Object)"R"));
        List<Date> batches = BatchRunDao.getBatchTimes(branch, new AdvancedCriteria((Criterion)new OrCriterion(stateCheck)));
        for (int i = 0; i < batches.size(); ++i) {
            Date kthBatchStartTime = batches.get(i);
            if (kthBatchStartTime.compareTo(batchStartTime) >= 0 || threshold != null && !(BatchEvaluator.getPassRatio(kthBatchStartTime, suiteName, branch) >= threshold)) continue;
            return kthBatchStartTime;
        }
        return null;
    }

    public static Date getSuccessorBatchStartTime(Date batchStartTime, String branch) throws Exception {
        List<Date> commits = BatchRunDao.getBatchTimes(branch, null);
        if (commits == null) {
            return null;
        }
        int index = commits.indexOf(batchStartTime);
        if (index <= 0) {
            return null;
        }
        return commits.get(index - 1);
    }

    public static Date getPredecessorBatchStartTime(Date batchStartTime, String branch) throws Exception {
        List<Date> commits = BatchRunDao.getBatchTimes(branch, null);
        if (commits == null) {
            return null;
        }
        int index = commits.indexOf(batchStartTime);
        if (index < 0 || index + 1 >= commits.size()) {
            return null;
        }
        return commits.get(index + 1);
    }

    public static String getBranch(Date batchStartTime) throws Exception {
        DSRequest dsReq = new DSRequest(config.getBatchRunDS(), "fetch");
        dsReq.setCriteria("batchStartTime", (Object)batchStartTime);
        DSResponse dsResp = dsReq.execute();
        List data = dsResp.getDataList();
        if (data.size() != 1) {
            throw new InconsistentBatchRunTableException("not exactly one entry for batch " + String.valueOf(batchStartTime));
        }
        Map row = (Map)data.get(0);
        return (String)row.get("branch");
    }

    public static String getState(Date batchStartTime, String suiteName) throws Exception {
        DSRequest dsReq = new DSRequest(config.getBatchRunDS(), "fetch");
        dsReq.setCriteria("batchStartTime", (Object)batchStartTime);
        DSResponse dsResp = dsReq.execute();
        List data = dsResp.getDataList();
        if (data.size() != 1) {
            throw new InconsistentBatchRunTableException("not exactly one entry for batch " + String.valueOf(batchStartTime));
        }
        Map row = (Map)data.get(0);
        String camelSuite = TestRunner.getSuiteNameAsCamelCase(suiteName);
        return (String)row.get(camelSuite + "State");
    }

    public static void setState(Date batchStartTime, String suiteName, String newState) throws Exception {
        String camelSuite = TestRunner.getSuiteNameAsCamelCase(suiteName);
        DSRequest dsReq = new DSRequest(config.getBatchRunDS(), "update");
        dsReq.setCriteria("batchStartTime", (Object)batchStartTime);
        dsReq.setFieldValue((Object)(camelSuite + "State"), (Object)newState);
        dsReq.execute();
    }

    public static void assertState(Date batchStartTime, String suiteName, String stateValue) throws Exception {
        String actualState = BatchRunDao.getState(batchStartTime, suiteName);
        if (stateValue == null && actualState != null || stateValue != null && !stateValue.equals(actualState)) {
            throw new InconsistentBatchRunTableException("in batch " + String.valueOf(batchStartTime) + ", test suite " + suiteName + " doesn't have state " + stateValue);
        }
    }

    protected static boolean isStateSuccess(Date batchStartTime, String suiteName) throws Exception {
        return Utils.matchRegExp("(?i)T|R", BatchRunDao.getState(batchStartTime, suiteName));
    }

    public static String getBatchProperty(Date batchStartTime, String property) {
        try {
            DSRequest dsReq = new DSRequest(config.getBatchRunDS(), "fetch");
            dsReq.setCriteria("batchStartTime", (Object)batchStartTime);
            DSResponse dsResp = dsReq.execute();
            List data = dsResp.getDataList();
            if (data.size() != 1) {
                throw new InconsistentBatchRunTableException("not exactly one entry for batch " + String.valueOf(batchStartTime));
            }
            Map row = (Map)data.get(0);
            return (String)row.get(property);
        }
        catch (Exception e) {
            log.error((Object)("encountered exception finding " + property + " property for batch " + String.valueOf(batchStartTime) + ":"), (Throwable)e);
            return null;
        }
    }

    public static boolean getBatchPropertyAsBoolean(Date batchStartTime, String property) {
        try {
            DSRequest dsReq = new DSRequest(config.getBatchRunDS(), "fetch");
            dsReq.setCriteria("batchStartTime", (Object)batchStartTime);
            DSResponse dsResp = dsReq.execute();
            List data = dsResp.getDataList();
            if (data.size() != 1) {
                throw new InconsistentBatchRunTableException("not exactly one entry for batch " + String.valueOf(batchStartTime));
            }
            Map row = (Map)data.get(0);
            return row.get(property) != null;
        }
        catch (Exception e) {
            log.error((Object)("encountered exception finding " + property + " property for batch " + String.valueOf(batchStartTime) + ":"), (Throwable)e);
            return false;
        }
    }

    public static void setCurrentDateAsBatchProperty(Date batchStartTime, String property) throws Exception {
        DSRequest dsReq = new DSRequest(config.getBatchRunDS(), "update");
        dsReq.setAllowMultiUpdate(true);
        dsReq.setCriteria("batchStartTime", (Object)batchStartTime);
        dsReq.setFieldValue((Object)property, (Object)new Date());
        dsReq.execute();
    }

    public static String getAwsInstanceId(Date batchStartTime) {
        return BatchRunDao.getBatchProperty(batchStartTime, "instanceId");
    }

    public static void registerAwsInstanceId(Date batchStartTime, String instanceId) {
        String logMessage = "instance " + instanceId + " with batch " + String.valueOf(batchStartTime);
        try {
            DSRequest dsReq = new DSRequest(config.getBatchRunDS(), "update");
            dsReq.setCriteria("batchStartTime", (Object)batchStartTime);
            dsReq.setFieldValue((Object)"instanceId", (Object)instanceId);
            dsReq.execute();
            log.info((Object)("registered " + logMessage));
        }
        catch (Exception e) {
            log.error((Object)("failed to register " + logMessage), (Throwable)e);
        }
    }

    public static boolean isBatchValidated(Date batchStartTime) {
        return BatchRunDao.getBatchPropertyAsBoolean(batchStartTime, "validated");
    }

    public static void updateBatchStatus(Date batchStartTime, String newStatus, boolean validate) {
        try {
            DSRequest dsReq = new DSRequest(config.getBatchRunDS(), "update");
            dsReq.setCriteria("batchStartTime", (Object)batchStartTime);
            String oldStatus = BatchRunDao.getBatchProperty(batchStartTime, "completionStatus");
            if (oldStatus == null) {
                dsReq.setFieldValue((Object)"completionStatus", (Object)newStatus);
            }
            if (validate) {
                dsReq.setFieldValue((Object)"validated", (Object)new Date());
            }
            dsReq.execute();
        }
        catch (Exception e) {
            log.error((Object)("unable to validate batch " + String.valueOf(batchStartTime) + ":"), (Throwable)e);
        }
    }

    public static void setBatchEndTime(Date batchStartTime) throws Exception {
        BatchRunDao.setCurrentDateAsBatchProperty(batchStartTime, "batchEndTime");
    }

    public static String clipTextField(String fieldName, String text) throws Exception {
        return Utils.clipTextField(config.getBatchRunDS(), fieldName, text);
    }

    public static boolean isBatchAnalyzed(Date batchStartTime) {
        return BatchRunDao.getBatchPropertyAsBoolean(batchStartTime, "history");
    }

    public static void setBatchAsAnalyzed(Date batchStartTime) throws Exception {
        BatchRunDao.setCurrentDateAsBatchProperty(batchStartTime, "history");
    }

    public static boolean isTestSuiteDone(Date batchStartTime, String suiteName) throws Exception {
        String state = BatchRunDao.getState(batchStartTime, suiteName);
        if (Utils.matchRegExp("(?i)T|R", state)) {
            return true;
        }
        String status = BatchRunDao.getBatchProperty(batchStartTime, "completionStatus");
        if (!(status == null || "wrathJsDocFailure".equals(status) && suiteName == null)) {
            return true;
        }
        return BatchRunDao.isBatchAnalyzed(batchStartTime);
    }
}

