/*
 * Decompiled with CFR 0.152.
 */
package com.isomorphic.examples.server.reusableORMDataSource;

import com.isomorphic.base.Reflection;
import com.isomorphic.datasource.BasicDataSource;
import com.isomorphic.datasource.DSRequest;
import com.isomorphic.datasource.DSResponse;
import com.isomorphic.util.DataTools;
import jakarta.persistence.criteria.CriteriaBuilder;
import jakarta.persistence.criteria.CriteriaQuery;
import jakarta.persistence.criteria.Expression;
import jakarta.persistence.criteria.Order;
import jakarta.persistence.criteria.Predicate;
import jakarta.persistence.criteria.Root;
import jakarta.persistence.criteria.Selection;
import jakarta.persistence.metamodel.EntityType;
import jakarta.persistence.metamodel.Metamodel;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.hibernate.Transaction;
import org.hibernate.cfg.Configuration;
import org.hibernate.query.Query;
import org.hibernate.query.criteria.HibernateCriteriaBuilder;

public class ReusableORMDataSource
extends BasicDataSource {
    protected String entityName;
    protected Session currentSession;
    protected static Configuration hibernateConfig;
    protected static SessionFactory sessionFactory;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DSResponse execute(DSRequest req) throws Exception {
        if (hibernateConfig == null) {
            ReusableORMDataSource.createConfig();
        }
        this.currentSession = sessionFactory.openSession();
        if (this.entityName == null) {
            this.entityName = this.getProperty("mappedBeanClass");
            Metamodel metamodel = this.currentSession.getMetamodel();
            boolean isEntityMapped = metamodel.getEntities().stream().map(EntityType::getName).anyMatch(this.entityName::equals);
            if (!isEntityMapped) {
                // empty if block
            }
        }
        Transaction tx = this.currentSession.beginTransaction();
        try {
            DSResponse dSResponse = super.execute(req);
            return dSResponse;
        }
        finally {
            tx.commit();
            this.currentSession.close();
        }
    }

    public DSResponse executeFetch(DSRequest req) throws Exception {
        DSResponse dsResponse = new DSResponse();
        dsResponse.setSuccess();
        HibernateCriteriaBuilder cb = this.currentSession.getCriteriaBuilder();
        CriteriaQuery countQuery = cb.createQuery(Long.class);
        Class entityClass = this.currentSession.getMetamodel().entity(Class.forName(this.entityName)).getJavaType();
        CriteriaQuery criteriaQuery = cb.createQuery(entityClass);
        Root root = criteriaQuery.from(entityClass);
        Root countRoot = countQuery.from(entityClass);
        ArrayList<Predicate> criterions = new ArrayList<Predicate>();
        ArrayList<Predicate> countCriterions = new ArrayList<Predicate>();
        Map rCriteria = req.getCriteria();
        if (rCriteria != null) {
            boolean isFilter = "substring".equals(req.getOperationProperty("textMatchStyle"));
            for (String fieldName : rCriteria.keySet()) {
                Predicate criterion;
                ArrayList<Predicate> orPredicates;
                Object value = rCriteria.get(fieldName);
                String fieldType = this.getField(fieldName).getType();
                if (value instanceof List) {
                    orPredicates = new ArrayList<Predicate>();
                    for (Object val : (List)value) {
                        orPredicates.add(cb.equal((Expression)root.get(fieldName), val));
                    }
                    criterion = cb.or(orPredicates.toArray(new Predicate[0]));
                } else {
                    criterion = isFilter && ("text".equals(fieldType) || "string".equals(fieldType)) ? cb.like(root.get(fieldName).as(String.class), "%" + String.valueOf(value) + "%") : cb.equal((Expression)root.get(fieldName), value);
                }
                criterions.add(criterion);
                if (value instanceof List) {
                    orPredicates = new ArrayList();
                    for (Object val : (List)value) {
                        orPredicates.add(cb.equal((Expression)countRoot.get(fieldName), val));
                    }
                    criterion = cb.or(orPredicates.toArray(new Predicate[0]));
                } else {
                    criterion = isFilter && ("text".equals(fieldType) || "string".equals(fieldType)) ? cb.like(countRoot.get(fieldName).as(String.class), "%" + String.valueOf(value) + "%") : cb.equal((Expression)countRoot.get(fieldName), value);
                }
                countCriterions.add(criterion);
            }
        }
        this.addAllCriterions((CriteriaBuilder)cb, countQuery, countCriterions);
        long totalRows = -1L;
        if (req.isPaged()) {
            if (req.getEndRow() != -1L && req.getEndRow() - req.getStartRow() > req.getBatchSize()) {
                req.setBatchSize(req.getEndRow() - req.getStartRow());
            }
            countQuery.select((Selection)cb.count((Expression)countRoot));
            Long rowCount = (Long)this.currentSession.createQuery(countQuery).getSingleResult();
            totalRows = rowCount != null ? rowCount : 0L;
        }
        this.addAllCriterions((CriteriaBuilder)cb, criteriaQuery, criterions);
        List sortBy = req.getSortByFields();
        ArrayList<Order> orderList = new ArrayList<Order>();
        for (String sortByField : sortBy) {
            if (sortByField.startsWith("-")) {
                orderList.add(cb.desc((Expression)root.get(sortByField.substring(1))));
                continue;
            }
            orderList.add(cb.asc((Expression)root.get(sortByField)));
        }
        criteriaQuery.orderBy(orderList);
        Query query = this.currentSession.createQuery(criteriaQuery);
        if (req.isPaged()) {
            query.setFirstResult((int)req.getStartRow());
            query.setMaxResults((int)req.getBatchSize());
        }
        List results = query.getResultList();
        if (totalRows == -1L) {
            totalRows = results.size();
        }
        dsResponse.setTotalRows(totalRows);
        long startRow = 0L;
        long endRow = 0L;
        if (totalRows != 0L) {
            startRow = req.getStartRow();
            endRow = startRow + (long)results.size();
        }
        dsResponse.setStartRow(startRow);
        dsResponse.setEndRow(endRow);
        dsResponse.setData((Object)results);
        return dsResponse;
    }

    public DSResponse executeAdd(DSRequest req) throws Exception {
        DSResponse dsResponse = new DSResponse();
        dsResponse.setSuccess();
        Object record = Reflection.classForName((String)this.entityName).newInstance();
        DataTools.setProperties((Map)req.getValues(), record);
        this.currentSession.saveOrUpdate(this.entityName, record);
        dsResponse.setData(record);
        return dsResponse;
    }

    public DSResponse executeRemove(DSRequest req) throws Exception {
        DSResponse dsResponse = new DSResponse();
        dsResponse.setSuccess();
        String primaryKey = this.getPrimaryKey();
        Serializable id = (Serializable)req.getFieldValue((Object)primaryKey);
        Object record = this.currentSession.get(this.entityName, (Object)id);
        this.currentSession.delete(this.entityName, record);
        dsResponse.setData((Object)req.getCriteria());
        return dsResponse;
    }

    public DSResponse executeUpdate(DSRequest req) throws Exception {
        DSResponse dsResponse = new DSResponse();
        dsResponse.setSuccess();
        String primaryKey = this.getPrimaryKey();
        Serializable id = (Serializable)req.getFieldValue((Object)primaryKey);
        Object record = null;
        if (id != null) {
            record = this.currentSession.get(this.entityName, (Object)id);
        }
        DataTools.setProperties((Map)req.getValues(), record);
        this.currentSession.saveOrUpdate(this.entityName, record);
        dsResponse.setData(record);
        return dsResponse;
    }

    private CriteriaQuery<?> addAllCriterions(CriteriaBuilder cb, CriteriaQuery<?> criteriaQuery, List<Predicate> criterions) {
        return criteriaQuery.where((Expression)cb.and(criterions.toArray(new Predicate[0])));
    }

    private static synchronized void createConfig() {
        hibernateConfig = new Configuration();
        sessionFactory = hibernateConfig.configure().buildSessionFactory();
    }
}

