/* Auto-Generated React */
import React from 'react';
import 'smartclient-eval/release';
import 'smartclient-eval/skins/Tahoe';

import { SC, Button, FilterBuilder, HLayout, LGField, ListGrid, SearchForm, SelectItem, TextItem, VLayout } from 'smartclient-eval/react';

// a "render target" can be defined to allow JSX to be loaded dynamically into an existing application.  This Showcase sets a
// render target of "showcaseSample" so each JSX file can be loaded and later removed when the user is done with the sample.
let target = SC.getRenderTarget() || "showcaseSample";

let onToggleFilteringInterfaceClick = function () {
    if (searchForm.isVisible()) {
        searchForm.hide();
        filterBuilder.show();
    } else {
        filterBuilder.hide();
        searchForm.show();
    }
    supplyList.setData([]);
};
let onFilterGridClick = function () {
    var criteria = searchForm.isVisible() ? searchForm.getValuesAsCriteria() : filterBuilder.getCriteria();
    supplyList.filterData(criteria);
};

// SC.render() calls ReactDOM.render() in React pre-18, and
// ReactDOM.createRoot().render() in React 18+, to avoid deprecation warnings.
SC.render(
    <HLayout overflow="auto" membersMargin="20" ID="mainLayout" width="100%" height="100%">
        <members>
            <VLayout membersMargin="20">
                <members>
                    <SearchForm ID="searchForm" dataSource="supplyItem" groupTitle="Search Form" isGroup="true">
                        <fields>
                            <TextItem name="SKU"/>
                            <TextItem name="itemName"/>
                            <SelectItem name="category"/>
                            <SelectItem name="units"/>
                        </fields>
                    </SearchForm>
                    <FilterBuilder dataSource="supplyItem" ID="filterBuilder" isGroup="true" groupTitle="Filter Builder" visibility="hidden" topOperatorAppearance="none">
                        <allowedFields>SKU</allowedFields>
                        <allowedFields>itemName</allowedFields>
                        <allowedFields>category</allowedFields>
                        <allowedFields>units</allowedFields>
                    </FilterBuilder>
                    <HLayout membersMargin="5" height="1">
                        <members>
                            <Button title="Toggle Filtering Interface" width="200" click={onToggleFilteringInterfaceClick}/>
                            <Button title="Filter Grid" click={onFilterGridClick}/>
                        </members>
                    </HLayout>
                    <ListGrid ID="supplyList" dataSource="supplyItem" filterOnKeypress="true" fetchDelay="500" width="500" height="300">
                        <fields>
                            <LGField name="SKU"/>
                            <LGField name="itemName"/>
                            <LGField name="category"/>
                            <LGField name="units"/>
                        </fields>
                    </ListGrid>
                </members>
            </VLayout>
        </members>
    </HLayout>,
    document.getElementById(target)
);
