# ListGridField Documentation

[← Back to API Index](../reference.md)

---

## Attr: ListGridField.groupingMode

### Description
For a field that allows multiple [grouping modes](#attr-listgridfieldgroupingmodes), the current grouping mode.

This property is set when a user chooses a particular grouping mode, and may be set on ListGrid creation to affect the initial grouping.

### Groups

- grouping

**Flags**: IR

---
## Attr: ListGridField.valueIconWidth

### Description
Width for value icons for this listGrid field. Overrides [ListGrid.valueIconSize](ListGrid_1.md#attr-listgridvalueiconsize), [ListGrid.valueIconWidth](ListGrid_1.md#attr-listgridvalueiconwidth), and [ListGridField.valueIconSize](#attr-listgridfieldvalueiconsize).

### Groups

- imageColumns

**Flags**: IRW

---
## Attr: ListGridField.includeFrom

### Description
Indicates this field's values should be fetched from another, related DataSource. The individual field will inherit settings such as [field.type](#attr-listgridfieldtype) and [field.title](#attr-listgridfieldtitle) from the related DataSource just like fields from the primary DataSource.

When [fechData()](ListGrid_2.md#method-listgridfetchdata) is called, the automatically created [DSRequest](../reference_2.md#object-dsrequest) will specify [DSRequest.additionalOutputs](DSRequest.md#attr-dsrequestadditionaloutputs) requesting the field, and any [Criteria](../reference_2.md#type-criteria) generated by the component will likewise refer to the field from the related DataSource.

It's an error to use this property if the ListGrid does not have a DataSource at all. The related DataSource must be loaded or a warning will be logged and the field definition ignored.

This value is expected to be set to the following format `dataSourceID.fieldName` where _dataSourceID_ is the ID of the related dataSource and _fieldName_ is the name of the field from that dataSource from which you wish to retrieve values. Note that if this property is set and [field.name](#attr-listgridfieldname) is not explicitly specified, this field's `name` will default to the _fieldName_ value from this property.

Note about automatic cache updates: "update" and "add" operations submitted automatically by this ListGrid will include `dsRequest.additionalOutputs` to ensure all data necessary for cache updates is returned by the server.

If your grid shows data that can be edited elsewhere in the UI (not by inline editing), to avoid problems with [ResultSet](ResultSet.md#class-resultset) automatic cache synchronization, you may need to switch from using `listGridField.includeFrom` to `dataSourceField.includeFrom`. This is because server responses to "add" and "update" operations which are initiated outside of this grid do not know about the `listGridField.includeFrom` setting, and so will not automatically return data for fields included in this way. Switching to `dataSourceField.includeFrom` ensures the field is always included in server responses, avoiding the issue.

### Groups

- display_values

**Flags**: IR

---
## Attr: ListGridField.linkTextProperty

### Description
Name of the property in a ListGridRecord that holds the HTML to display in cells of this field if the fieldType is set to "link".

### Groups

- display_values

### See Also

- [ListGridFieldType](../reference.md#type-listgridfieldtype)
- [FieldType](../reference_2.md#type-fieldtype)
- [ListGridRecord.linkText](ListGridRecord.md#attr-listgridrecordlinktext)
- [ListGridField.linkText](#attr-listgridfieldlinktext)
- [ListGrid.linkTextProperty](ListGrid_1.md#attr-listgridlinktextproperty)

**Flags**: IRW

---
## Attr: ListGridField.maxWidth

### Description
When [ListGrid.showHeader](ListGrid_1.md#attr-listgridshowheader) is false and a field is subject to autofitting (see [ListGrid.autoFitFieldWidths](ListGrid_1.md#attr-listgridautofitfieldwidths)), sets the maximum width of the field. The actual effective maximum will be the largest of this property, [ListGridField.minWidth](#attr-listgridfieldminwidth), and [ListGrid.minFieldWidth](ListGrid_1.md#attr-listgridminfieldwidth). That is, [ListGridField.minWidth](#attr-listgridfieldminwidth) and [ListGrid.minFieldWidth](ListGrid_1.md#attr-listgridminfieldwidth) dominate this property.

### Groups

- appearance

### See Also

- [ListGridField.width](#attr-listgridfieldwidth)

**Flags**: IRW

---
## Attr: ListGridField.valueField

### Description
Specifies the [ListGridField.optionDataSource](#attr-listgridfieldoptiondatasource) field used to retrieve the stored values that are to be mapped to the display values (specified by [ListGridField.displayField](#attr-listgridfielddisplayfield)). Note that if this field is editable this will also be applied to this field's editors.

### Groups

- display_values

**Flags**: IRW

---
## Attr: ListGridField.showDownIcon

### Description
If using an icon for this button, whether to switch the icon image when the mouse goes down on the button.

### Groups

- buttonIcon

### See Also

- [ListGridField.icon](#attr-listgridfieldicon)

**Flags**: IR

---
## Attr: ListGridField.summaryValue

### Description
The value to display for a ListGridField when it appears in the [summaryRow](ListGrid_1.md#attr-listgridsummaryrow). The default for normal fields is null and for special fields, like the [checkboxField](ListGrid_1.md#attr-listgridcheckboxfield), the default is to show a blank value (a non-breaking space).

**Flags**: IRW

---
## Attr: ListGridField.editorValueIcons

### Description
When some cell in this field is being edited, setting this property will specify the value icons to display in the cell's editor. If unset, the editor's valueIcons will be determined in the same way as it would be for a static cell.

### Groups

- imageColumns

**Flags**: IRW

---
## Attr: ListGridField.sortByMappedValue

### Description
If [ListGridField.valueMap](#attr-listgridfieldvaluemap) is set, and the grid is [sorted](ListGrid_2.md#method-listgridsetsort) by this field, should the data be sorted by the underlying data value or the mapped display value. If unset, will sort by display value. Set to `false` to sort by underlying data value. Note that this has no effect if a [ListGridField.sortNormalizer](#method-listgridfieldsortnormalizer) has been specified.

**Flags**: IRW

---
## Attr: ListGridField.autoFit

### Description
When set, this attribute causes this field to be auto-sized directly by effectively setting [ListGridField.autoFitWidth](#attr-listgridfieldautofitwidth) to true and applying an [ListGridField.autoFitWidthApproach](#attr-listgridfieldautofitwidthapproach). This direct approach is different from and less verbose than applying [similar properties](ListGrid_1.md#attr-listgridautofitfieldwidths) on the [grid](ListGrid_1.md#class-listgrid) and overriding them on a per-field basis.

### Groups

- autoFitFields

**Flags**: IRW

---
## Attr: ListGridField.rotateTitle

### Description
Whether to rotate the field's title so it's rendered vertically from bottom to top. If unset, default behavior is derived from [ListGrid.rotateHeaderTitles](ListGrid_1.md#attr-listgridrotateheadertitles).

### See Also

- [ListGrid.rotateHeaderTitles](ListGrid_1.md#attr-listgridrotateheadertitles)

**Flags**: IR

---
## Attr: ListGridField.filterEditorType

### Description
If this ListGrid is showing a filter row, this property can be used to specify the form item class to use for the filter form item associated with this field (Only used if this field is not canFilter:false).  
Note: If this is not specified, the edit-form item type may be derived from the 'editorType' property, typically inherited from datasource fields, or from the 'type' of the field (showing the appropriate form item for the data-type).

### Groups

- filterEditor

**Flags**: IRWA

---
## Attr: ListGridField.sortByDisplayField

### Description
For a field with [ListGridField.displayField](#attr-listgridfielddisplayfield) configured, should client-side sorting be performed on the display field value? Unless explicitly set to `false`, the display field value is used.

### Groups

- display_values

**Flags**: IRW

---
## Attr: ListGridField.canToggle

### Description
Allows a boolean or [valueMapped](../reference_2.md#type-valuemap) field to be edited without going into edit mode. When this attribute is set, clicking on the field will change the value - for boolean fields toggling between `true` and `false`, and for valueMapped fields, advancing the value to the next option in the valueMap.

To enable this feature, [ListGrid.canEdit](ListGrid_1.md#attr-listgridcanedit) must be set to true. For boolean type fields `canToggle` is true by default, meaning setting `canEdit` to true implies the user can toggle the value via a single click without going into edit mode. You can disable this by explicitly setting `canToggle` to false for a boolean field.  
Note that you can enable toggling only (without allowing the user to edit other fields) by just setting [grid.editEvent:"none"](ListGrid_1.md#attr-listgrideditevent).

If [ListGrid.editEvent](ListGrid_1.md#attr-listgrideditevent) is set to "click", when the user clicks on the field, the value will be toggled, and inline editing will be triggered as usual. Otherwise the toggled value will be saved immediately to the server, or if [ListGrid.autoSaveEdits](ListGrid_1.md#attr-listgridautosaveedits) has been set to false, will be stored as an edit value for the record.

### Groups

- editing

**Flags**: IRWA

---
## Attr: ListGridField.optionOperationId

### Description
If this field has an optionDataSource specified and [autoFetchDisplayMap](#attr-listgridfieldautofetchdisplaymap) is set, this attribute provides a way to customize the [DSRequest.operationId](DSRequest.md#attr-dsrequestoperationid) passed to `dataSource.fetchData()` when retrieving the display map from the option dataSource.

### Groups

- display_values

**Flags**: IR

---
## Attr: ListGridField.includeInRecordSummaryFields

### Description
If this listGrid has any fields of type `"summary"` and this field will be [included](#attr-listgridfieldincludeinrecordsummary) in summary calculations by default, this attribute provides an opportunity to explicitly specify which summary fields the record should be displayed in.

Specified as an array of fieldNames. If set, this field value will only be included for record summary value calculations for summary fields whose name is included in this array.

**Flags**: IR

---
## Attr: ListGridField.showDefaultContextMenu

### Description
When set to false, this field will not show a context menu in its header.

**Flags**: IRW

---
## Attr: ListGridField.spannedHeaderBaseStyle

### Description
Custom base style to apply to this field's header button instead of [ListGrid.spannedHeaderBaseStyle](ListGrid_1.md#attr-listgridspannedheaderbasestyle) when the grid is showing header spans.

### Groups

- gridHeader
- appearance
- headerSpan

**Flags**: IRW

---
## Attr: ListGridField.validators

### Description
Array of [Validator](Validator.md#class-validator) objects for this field. When the user edits cells in this field, these validators will be applied to the edited value.  
Note: for databound listGrids, this property may be specified on the [DataSourceField](../reference_2.md#object-datasourcefield), enabling both client and server side validation.

### Groups

- gridValidation

### See Also

- [Validator](Validator.md#class-validator)
- [ListGridField.required](#attr-listgridfieldrequired)

**Flags**: IRW

---
## Attr: ListGridField.dateFormatter

### Description
Display format to use for date type values within this field.

The [ListGridField.timeFormatter](#attr-listgridfieldtimeformatter) may also be used to format underlying Date values as times (omitting the date part entirely). If both `dateFormatter` and `timeFormatter` are specified on a field, for fields specified as [type "time"](#attr-listgridfieldtype) the `timeFormatter` will be used, otherwise the `dateFormatter`

If `field.dateFormatter` and `field.timeFormatter` is unspecified, date display format may be defined at the component level via [ListGrid.dateFormatter](ListGrid_1.md#attr-listgriddateformatter), or for fields of type `"datetime"` [ListGrid.datetimeFormatter](ListGrid_1.md#attr-listgriddatetimeformatter). Otherwise the default is to use the system-wide default short date format, configured via [DateUtil.setShortDisplayFormat](DateUtil.md#classmethod-dateutilsetshortdisplayformat). Specify any valid [DateDisplayFormat](../reference.md#type-datedisplayformat) to change the format used by this item.

If this field is editable the dateFormatter will also be passed to the editor created to edit this field. Note that you can also specify an explicit [ListGridField.inputFormat](#attr-listgridfieldinputformat) which will be passed through to the editor as well, though this is not typically required as the input format should be automatically derived by the SmartClient system for standard DateDisplayFormats.

### See Also

- [ListGrid.dateFormatter](ListGrid_1.md#attr-listgriddateformatter)
- [ListGrid.datetimeFormatter](ListGrid_1.md#attr-listgriddatetimeformatter)
- [ListGridField.timeFormatter](#attr-listgridfieldtimeformatter)

**Flags**: IRW

---
## Attr: ListGridField.headerBaseStyle

### Description
Custom base style to apply to this field's header button instead of [ListGrid.headerBaseStyle](ListGrid_1.md#attr-listgridheaderbasestyle).  
Note that depending on the header button constructor, you may have to override [ListGridField.headerTitleStyle](#attr-listgridfieldheadertitlestyle) as well.

### Groups

- appearance

**Flags**: IRW

---
## Attr: ListGridField.autoComplete

### Description
Whether to allow browser autoComplete when editing this field.

If unset, defaults to listGrid.autoComplete

### See Also

- [ListGrid.autoComplete](ListGrid_1.md#attr-listgridautocomplete)

**Flags**: IRW

---
## Attr: ListGridField.ignoreKeyboardClicks

### Description
If the user is navigating through the grid using the keyboard, record click or double click events may be generated via keyboard interactions (see [ListGrid.generateClickOnSpace](ListGrid_1.md#attr-listgridgenerateclickonspace), [ListGrid.generateClickOnEnter](ListGrid_1.md#attr-listgridgenerateclickonenter), [ListGrid.generateDoubleClickOnSpace](ListGrid_1.md#attr-listgridgeneratedoubleclickonspace), [ListGrid.generateDoubleClickOnEnter](ListGrid_1.md#attr-listgridgeneratedoubleclickonenter) and [ListGrid.arrowKeyAction](ListGrid_1.md#attr-listgridarrowkeyaction)).

These synthetic events have both a target row and column. Setting this flag to true ensures that this field will never be considered the target for a keyboard click event.

### Groups

- events

**Flags**: IRW

---
## Attr: ListGridField.baseStyle

### Description
Custom base style to apply to all cells in this field instead of [ListGrid.baseStyle](ListGrid_1.md#attr-listgridbasestyle) To override the baseStyle at the row level, use [record\[listGrid.recordBaseStyleProperty\]](ListGrid_1.md#attr-listgridrecordbasestyleproperty) instead.

### Groups

- appearance

### See Also

- [ListGrid.recordBaseStyleProperty](ListGrid_1.md#attr-listgridrecordbasestyleproperty)

**Flags**: IRW

---
## Attr: ListGridField.canSortClientOnly

### Description
When true, this field can only be used for sorting if the data is entirely client-side.

**Flags**: IRW

---
## Attr: ListGridField.frozen

### Description
Whether this field should be "frozen" for the purposes of horizontal scrolling. See [frozenFields](../kb_topics/frozenFields.md#kb-topic-frozen-fields).

### Groups

- frozenFields

**Flags**: IR

---
## Attr: ListGridField.editorImageURLPrefix

### Description
When some cell in this field is being edited, this property can be used to apply an explicit [FormItem.imageURLPrefix](FormItem.md#attr-formitemimageurlprefix) to the editor in question. This can be used to modify the valueIcons within the editor.  
If unset, but [ListGridField.imageURLPrefix](#attr-listgridfieldimageurlprefix) is specified, that will be used instead.

### Groups

- editing

**Flags**: IRWA

---
## Attr: ListGridField.valueIcons

### Description
This property is a mapping from data values for this field to [urls](../reference.md#type-scimgurl) for icons to display for those data values.

For example, given a field named "status" with possible values "Normal", "Slow", "Offline", the follow definition would show various icons for that field:

```
 fields : [
     { name:"status",
       valueIcons: {
           Normal : "greenIcon.png",
           Slow : "yellowIcon.png",
           Offline : "redIcon.png"
       }
     },
     ... other fields ...
 ]
 
```

If a simple value-to-URL mapping is not enough, you can override [ListGrid.getValueIcon](ListGrid_2.md#method-listgridgetvalueicon) to customize the behavior. You can even specify an empty `valueIcons` map and use [ListGrid.getValueIcon](ListGrid_2.md#method-listgridgetvalueicon) to return arbitrary icons with no fixed mapping.

`valueIcons` can either be displayed alongside the normal value or can replace the normal field value so that only the icon is shown. See [ListGridField.showValueIconOnly](#attr-listgridfieldshowvalueicononly). When placed alongside the value, use [ListGridField.valueIconOrientation](#attr-listgridfieldvalueiconorientation) to control left- vs right-side placement.

If inline editing is enabled for this field, editors displayed for this field will also show valueIcons. This may be overridden by explicitly setting [ListGridField.editorValueIcons](#attr-listgridfieldeditorvalueicons).

Note that the following attributes related to valueIcon styling will also be picked up by the editor from the ListGridField object unless explicitly specified via the equivalent `editor_` attributes:  
[ListGridField.valueIconWidth](#attr-listgridfieldvalueiconwidth)  
[ListGridField.valueIconHeight](#attr-listgridfieldvalueiconheight)  
[ListGridField.valueIconSize](#attr-listgridfieldvalueiconsize)  
[ListGridField.valueIconLeftPadding](#attr-listgridfieldvalueiconleftpadding)  
[ListGridField.valueIconRightPadding](#attr-listgridfieldvalueiconrightpadding)  
[ListGridField.imageURLPrefix](#attr-listgridfieldimageurlprefix)  
[ListGridField.imageURLSuffix](#attr-listgridfieldimageurlsuffix)

If [ListGridField.valueIconClick](#method-listgridfieldvalueiconclick) is defined for the field, a pointer cursor will be shown when the user rolls over the valueIcon, and the valueIconClick method will execute when the user clicks the icon.

### Groups

- imageColumns

**Flags**: IRW

---
## Attr: ListGridField.hiliteHTMLAfterFormat

### Description
If set to true, custom HTML applied as part of hiliting will be applied after [formatting](ListGrid_2.md#method-listgridformatcellvalue) for each cell in this column. If false, hilite HTML will be applied before formatting.

This attribute overrides [ListGrid.hiliteHTMLAfterFormat](ListGrid_1.md#attr-listgridhilitehtmlafterformat) as defined at the component level.

**Flags**: IR

---
## Attr: ListGridField.visibleWhen

### Description
Criteria to be evaluated to determine whether this field should be visible.

This criteria is dynamic and will be renterpreted each time the rule context changes. Note that calling [ListGrid.showField](ListGrid_2.md#method-listgridshowfield) or [ListGrid.hideField](ListGrid_2.md#method-listgridhidefield) explicitly will cause any visibleWhen attribute to be dropped.

### Groups

- ruleCriteria

**Flags**: IR

---
## Attr: ListGridField.showFileInline

### Description
For a field of type:"imageFile", indicates whether to stream the image and display it inline or to display the View and Download icons.

**Flags**: IR

---
## Attr: ListGridField.hiliteIconWidth

### Description
Width for hilite icons for this field. Overrides [ListGrid.hiliteIconSize](ListGrid_1.md#attr-listgridhiliteiconsize), [ListGrid.hiliteIconWidth](ListGrid_1.md#attr-listgridhiliteiconwidth), and [ListGridField.hiliteIconSize](#attr-listgridfieldhiliteiconsize).

### Groups

- hiliting

**Flags**: IRW

---
## Attr: ListGridField.canExport

### Description
Dictates whether the data in this field be exported. Explicitly set this to false to prevent exporting. Has no effect if the underlying [dataSourceField](DataSourceField.md#attr-datasourcefieldcanexport) is explicitly set to canExport: false.

**Flags**: IR

---
## Attr: ListGridField.canFilter

### Description
If showing a filter row for this ListGrid, should the filter criteria for this field be editable

### Groups

- filterEditor

**Flags**: IRW

---
## Attr: ListGridField.autoFitWidth

### Description
Should this listGrid field autofit its width to either titles or content?

This overrides the [ListGrid.autoFitFieldWidths](ListGrid_1.md#attr-listgridautofitfieldwidths) attribute on a per-field basis.

Note that if [showing record components](ListGrid_1.md#attr-listgridshowrecordcomponents), per-cell record components are not taken into account when determining the size for column auto fit. The default [ListGrid.getDefaultFieldWidth](ListGrid_2.md#method-listgridgetdefaultfieldwidth) implementation looks at cell content only. We typically recommend that, for fields showing record-components, [ListGridField.autoFitWidth](#attr-listgridfieldautofitwidth) and [ListGridField.canAutoFitWidth](#attr-listgridfieldcanautofitwidth) be disabled, or if the record components are of a predictable size, a [ListGridField.defaultWidth](#attr-listgridfielddefaultwidth) be specified.  
This is particularly pertinent where [ListGrid.recordComponentPosition](ListGrid_1.md#attr-listgridrecordcomponentposition) is set to "within", in which case cells' content is often empty or completely covered by record-components.

For a more direct alternative, see [ListGridField.autoFit](#attr-listgridfieldautofit), which effectively turns on this setting and applies [ListGridField.autoFitWidthApproach](#attr-listgridfieldautofitwidthapproach) with a single property.

### Groups

- autoFitFields

### See Also

- [ListGrid.autoFitDateFields](ListGrid_1.md#attr-listgridautofitdatefields)
- [ListGrid.autoFitTimeFields](ListGrid_1.md#attr-listgridautofittimefields)

**Flags**: IR

---
## Attr: ListGridField.allowFilterExpressions

### Description
Field-level setting for [ListGrid.allowFilterExpressions](ListGrid_1.md#attr-listgridallowfilterexpressions):true - controls whether search expressions can be entered directly into the filter item for this field. You can also have parsing of the expression remove the operator symbol and apply it to an [icon](ListGrid_1.md#attr-listgridallowfilteroperators) in the editor.,

This attribute can also be set at the [ListGrid level](ListGrid_1.md#attr-listgridallowfilterexpressions).

For a discussion of the various filtering and criteria-management APIs and when to use them, see the [Grid Filtering overview](../kb_topics/gridFiltering.md#kb-topic-grid-filtering-overview).

### Groups

- advancedFilter

**Flags**: IR

---
## Attr: ListGridField.allowFilterOperators

### Description
Per-field setting for [ListGrid.allowFilterOperators](ListGrid_1.md#attr-listgridallowfilteroperators). Can be used to enable the filter operators UI for a particular field if the ListGrid-level setting is not enabled, or to disable filter operators for a particular field if the ListGrid-level setting is enabled.

For a discussion of the various filtering and criteria-management APIs and when to use them, see the [Grid Filtering overview](../kb_topics/gridFiltering.md#kb-topic-grid-filtering-overview).

**Flags**: IR

---
## Attr: ListGridField.operator

### Description
When [allowFilterOperators](ListGrid_1.md#attr-listgridallowfilteroperators) is true, this read-only property is set to the [filter/search operator](../reference.md#object-operator) currently assigned to this field. You can also retrieve a field's current operator by calling [ListGrid.getFieldSearchOperator](ListGrid_2.md#method-listgridgetfieldsearchoperator).

For a discussion of the various filtering and criteria-management APIs and when to use them, see the [Grid Filtering overview](../kb_topics/gridFiltering.md#kb-topic-grid-filtering-overview).

While this property can be affected by users, via the ["Filter using"](ListGrid_1.md#attr-listgridfilterusingtext) submenu of the grid's [headerContextMenu](ListGrid_1.md#attr-listgridshowheadercontextmenu), it can't be set directly in code.

However, developers can call [ListGrid.setFieldSearchOperator](ListGrid_2.md#method-listgridsetfieldsearchoperator) to modify a field's current operator, or [ListGrid.clearFieldSearchOperator](ListGrid_2.md#method-listgridclearfieldsearchoperator) to reset a field to it's default operator.

To specify a particular default operator for a field, see [ListGridField.filterOperator](#attr-listgridfieldfilteroperator).

### See Also

- [ListGridField.filterOperator](#attr-listgridfieldfilteroperator)

**Flags**: R

---
## Attr: ListGridField.linkURLPrefix

### Description
If this field has type \[[ListGridFieldType](../reference.md#type-listgridfieldtype)\] set to `"link"`, setting this property will apply a standard prefix to the link URL for cells in this field.

**Flags**: IRWA

---
## Attr: ListGridField.imageURLPrefix

### Description
If this field has type \[[ListGridFieldType](../reference.md#type-listgridfieldtype)\] set to `"image"` and the URL for the image displayed is not absolute, the path of the URL will be relative to this string  
Alternatively, if this field displays any valueIcons, this prefix will be applied to the beginning of any [ListGridField.valueIcons](#attr-listgridfieldvalueicons) when determining the URL for the image.

### Groups

- imageColumns

**Flags**: IRWA

---
## Attr: ListGridField.cellAlign

### Description
Horizontal alignment for cells in this field's column: "left", "right" or "center".  
If null, alignment is derived from [ListGridField.align](#attr-listgridfieldalign). If this field is editable, the alignment of cells in the body will also be reflected in any editors for the field.

### Groups

- appearance

**Flags**: IRW

---
## Attr: ListGridField.iconSize

### Description
If [ListGridField.icon](#attr-listgridfieldicon) is specified, this property can be used to specify the size of the icon to be displayed in the ListGrid header button. (See [StatefulCanvas.iconSize](StatefulCanvas.md#attr-statefulcanvasiconsize))

### See Also

- [ListGridField.icon](#attr-listgridfieldicon)

**Flags**: IR

---
## Attr: ListGridField.defaultIconSrc

### Description
If this field is editable, this property will be passed to editors displayed for cells within this field as [FormItem.defaultIconSrc](FormItem.md#attr-formitemdefaulticonsrc).

### Groups

- editing

### See Also

- [ListGridField.icons](#attr-listgridfieldicons)

**Flags**: IRA

---
## Attr: ListGridField.formatGridSummary

### Description
Optional stringMethod to format the summary value displayed in the [grid summary](ListGrid_1.md#attr-listgridshowgridsummary). Takes a single parameter `value` and should return the formatted version of that value. If specified this will be applied instead of any formatting logic applied via [ListGridField.formatCellValue](#method-listgridfieldformatcellvalue), [ListGrid.formatCellValue](ListGrid_2.md#method-listgridformatcellvalue), etc.

Note that for fields with a specified summary function of "count", if no custom formatting is applied, we default to formatting the count value by appending `field.pluralTitle` if defined, otherwise `field.title` to the numeric count value returned by the standard count function. To change this behavior for such fields, specify an explicit 'formatGridSummary' and/or 'formatGroupSummary' method

**Flags**: IR

---
## Attr: ListGridField.valueIconRightPadding

### Description
How much padding should there be on the right of valueIcons for this field Overrides [ListGrid.valueIconRightPadding](ListGrid_1.md#attr-listgridvalueiconrightpadding)

### Groups

- imageColumns

### See Also

- [ListGridField.valueIcons](#attr-listgridfieldvalueicons)

**Flags**: IRW

---
## Attr: ListGridField.recordSummaryFunction

### Description
Only applies to fields of type `"summary"`. Fields of this type will display a calculated value based on the other field values within the current record.

This attribute specifies how the summary field value will be calculated. See [RecordSummaryFunction](../reference_2.md#type-recordsummaryfunction) for valid options.

A subset of the ListGrid's fields will be passed to the RecordSummaryFunction.

The fields to be used for the summary calculation can be determined either by explicitly listing them ([ListGridField.includeInRecordSummaryFields](#attr-listgridfieldincludeinrecordsummaryfields)), or by setting [ListGridField.includeInRecordSummary](#attr-listgridfieldincludeinrecordsummary) to true on fields that should be included and false on fields that should not.

By default, all visible fields of numeric type are used. Note that, in this mode, if the user is able to hide some fields, this could change the formula. If this isn't desirable, consider setting [ListGridField.canHide](#attr-listgridfieldcanhide) to prevent fields from being hidden. Consider this even if fields to include in the summary are explicitly listed, as hidden fields involved in a visible calculation can be confusing for an end user.

If [ListGrid.showGridSummary](ListGrid_1.md#attr-listgridshowgridsummary) or [ListGrid.showGroupSummary](ListGrid_1.md#attr-listgridshowgroupsummary) is true, this field's value in the summary row\[s\] will still be calculated by calling this method. In this case, the record object passed in will contain summary values for each field. If custom handling is required for this case, it may be detected by checking the record object's [ListGridRecord.isGroupSummary](ListGridRecord.md#attr-listgridrecordisgroupsummary) and [ListGridRecord.isGridSummary](ListGridRecord.md#attr-listgridrecordisgridsummary) attributes.

### See Also

- [ListGrid.recordSummaryAttributePrefix](ListGrid_1.md#attr-listgridrecordsummaryattributeprefix)

**Flags**: IR

---
## Attr: ListGridField.hideOnTablet

### Description
Set this property to true to suppress showing this field on tablets (tablet-sized devices). To update this property at runtime use [ListGrid.setHideOnTablet](ListGrid_2.md#method-listgridsethideontablet)

Note that if [ListGridField.hidden](#attr-listgridfieldhidden) is set, or an explicit [ListGridField.showIf](#method-listgridfieldshowif) function exists that will take precedence over this setting. Similarly, an explicit call to [ListGrid.showField](ListGrid_2.md#method-listgridshowfield) or [ListGrid.hideField](ListGrid_2.md#method-listgridhidefield) will clear this setting.

See also the related property [ListGridField.hideOnPhone](#attr-listgridfieldhideonphone).

### Groups

- appearance

**Flags**: IRW

---
## Attr: ListGridField.summaryValueTitle

### Description
If [ListGrid.showGridSummary](ListGrid_1.md#attr-listgridshowgridsummary) or [ListGrid.showGroupSummary](ListGrid_1.md#attr-listgridshowgroupsummary) is true and the [ListGridField.summaryFunction](#attr-listgridfieldsummaryfunction) is set to `"title"`, this attribute may be set to a string to display in the group and/or grid summary. If unspecified the [ListGridField.title](#attr-listgridfieldtitle) will show up in the summary.

**Flags**: IR

---
## Attr: ListGridField.optionDataSource

### Description
Derive a [ValueMap](../reference_2.md#type-valuemap) by fetching records from another DataSource and extracting the [valueField](#attr-listgridfieldvaluefield) and [displayField](#attr-listgridfielddisplayfield) in the loaded records, to derive one valueMap entry per record loaded from the optionDataSource.

Unlike the similar use of [PickList.optionDataSource](PickList.md#attr-picklistoptiondatasource) for [pickLists](../reference_2.md#interface-picklist) used during editing or filtering, `listGridField.optionDataSource` causes the **entire set of records from the optionDataSource to be fetched**, without paging. Hence listGridField.optionDataSource is appropriate only for smaller valueMaps, and in this situation, [DataSource.cacheAllData](DataSource.md#attr-datasourcecachealldata) may be a better choice, since it creates a write-through cache usable across all components.

For very large valueMap situations, such as an accountId field that should be displayed as an accountName where there are thousands of accounts, the correct approach is:

*   do not set listGridField.optionDataSource
*   declare two fields in the DataSource, eg "accountId" and "accountName".
*   Set the [ListGridField.displayField](#attr-listgridfielddisplayfield) attribute on the data field to the name of the display field.
*   When fetching records for display in a grid, have your server send back values for both fields, but show only the data field ("accountId") in the grid.

In this case the cells in the accountId field will show the record value from the accountName field. This approach means the valueMap will never be loaded in its entirety, instead, each loaded record contains the valueMapping for that one record, as a pair of fields within the record.

If you are using the SmartClient Server Framework with the SQL or JPA/Hibernate built-in connectors, this entire approach can be achieved very easily using the [DataSourceField.includeFrom](DataSourceField.md#attr-datasourcefieldincludefrom) setting - see the [docs for includeFrom](DataSourceField.md#attr-datasourcefieldincludefrom) for details.

Notes:

*   When using the above approach, it is key that the server return **both** the underlying stored value **and** the display value, as suggested above. This approach allows the [PickList.optionDataSource](PickList.md#attr-picklistoptiondatasource) property to be used to provide paged valueMaps during inline editing and [inline filtering](ListGrid_1.md#attr-listgridshowfiltereditor). This can be achieved by setting the `optionDataSource` attribute on the form item used to edit the field via [ListGridField.editorProperties](#attr-listgridfieldeditorproperties) (for editing) or [field.filterEditorProperties](#attr-listgridfieldfiltereditorproperties) (for filtering), without specifying an optionDataSource at the listGridField level. Alternatively developers can use [ListGridField.autoFetchDisplayMap](#attr-listgridfieldautofetchdisplaymap) to suppress the fetch against the optionDataSource at the listGrid level.
*   Setting `listGridField.optionDataSource` to the same dataSource as the listGrid is not the same as omitting the optionDataSource setting entirely. Unless [ListGridField.autoFetchDisplayMap](#attr-listgridfieldautofetchdisplaymap) has been set to explicitly disable fetching, a fetch will be performed against the dataSource to build a valueMap which will be used as the definitive mapping from data to display values, rather than picking up the display values from the records themselves. This distinction is required to support cases where the [ListGridField.valueField](#attr-listgridfieldvaluefield) points to a different field in the grid (useful for hierarchical relationships, for example), or where [ListGridField.optionCriteria](#attr-listgridfieldoptioncriteria) or [ListGridField.optionOperationId](#attr-listgridfieldoptionoperationid) are specified and return different data from the records displayed within the grid.
*   If a displayField is specified, with no associated optionDataSource, and the field is editable, updating the edit value for the field may not automatically update the displayField edit value, meaning the user may not realize the edit value has been modified. If the new value came from the user editing the field, and the edit item has a valueMap or optionDataSource specified, the display value is picked up automatically and stored out on the displayField for the record. However if the value was set programmatically, the developer should also set the edit value for the display field to ensure the displayed value reflects the new edit value. Note that when this occurs, a warning will be logged which can be disabled via [ListGrid.warnOnUnmappedValueFieldChange](ListGrid_1.md#attr-listgridwarnonunmappedvaluefieldchange).
*   For very advanced usage a developer can use [ListGridField.displayValueFromRecord](#attr-listgridfielddisplayvaluefromrecord) to explicitly tell the grid whether or not to display the display field value for the record in this field when a displayField is specified. See documentation on that property for more information

### Groups

- display_values

**Flags**: IRW

---
## Attr: ListGridField.showDisabledIcon

### Description
If using an icon for this button, whether to switch the icon image if the button becomes disabled.

### Groups

- buttonIcon

### See Also

- [ListGridField.icon](#attr-listgridfieldicon)

**Flags**: IR

---
## Attr: ListGridField.sortDirection

### Description
Specifies the default sorting direction for this column. If specified on the [default sort field](ListGrid_1.md#attr-listgridsortfield) for the listGrid, sorting occurs automatically, otherwise this will be the default direction when the user clicks the field header, or calls [ListGrid.sort](ListGrid_2.md#method-listgridsort) without specifying an explicit sort direction.

Overrides [ListGrid.sortDirection](ListGrid_1.md#attr-listgridsortdirection).

Because the grid's `sortDirection` setting is updated whenever the grid is sorted, it is recommended to explicitly set the field's `sortDirection` if it is important to use a particular sorting direction as the default for the field.

### Groups

- sorting

### See Also

- [SortDirection](../reference_2.md#type-sortdirection)

**Flags**: IRW

---
## Attr: ListGridField.autoFreeze

### Description
Whether this field should be automatically frozen when other fields are frozen. When true, the field will be automatically frozen to the extreme of the grid. The automatically generated [checkbox](ListGrid_1.md#attr-listgridcheckboxfield), [expansion](ListGrid_1.md#attr-listgridexpansionfield) and [rowNumber](ListGrid_1.md#attr-listgridrownumberfield) fields are examples of fields that specify `autoFreeze: true`.

You can control the position of this field in the array of frozen fields by providing a [ListGridField.getAutoFreezePosition](#method-listgridfieldgetautofreezeposition) implementation.

### Groups

- frozenFields

**Flags**: IR

---
## Attr: ListGridField.editorTextFormula

### Description
Shortcut to configure a [FormItem.textFormula](FormItem.md#attr-formitemtextformula) for the [editor](#attr-listgridfieldeditortype) used when this field is [edited](ListGrid_1.md#attr-listgridcanedit).

**Flags**: IR

---
## Attr: ListGridField.hiliteIconSize

### Description
Default width and height of [hilite icons](ListGrid_1.md#attr-listgridhiliteicons) in this field. Takes precedence over hiliteIconWidth, hiliteIconHeight and hiliteIconSize specified at the component level. Can be overridden via [ListGridField.hiliteIconWidth](#attr-listgridfieldhiliteiconwidth) and [ListGridField.hiliteIconHeight](#attr-listgridfieldhiliteiconheight)

### Groups

- hiliting

### See Also

- [ListGrid.hiliteIconSize](ListGrid_1.md#attr-listgridhiliteiconsize)
- [ListGridField.hiliteIconWidth](#attr-listgridfieldhiliteiconwidth)
- [ListGridField.hiliteIconHeight](#attr-listgridfieldhiliteiconheight)

**Flags**: IRW

---
## Attr: ListGridField.canGroupBy

### Description
Determines whether this field will be groupable in the header context menu.

### See Also

- [ListGrid.groupBy](ListGrid_2.md#method-listgridgroupby)

**Flags**: IRW

---
## Attr: ListGridField.valueIconLeftPadding

### Description
How much padding should there be on the left of valueIcons for this field Overrides [ListGrid.valueIconLeftPadding](ListGrid_1.md#attr-listgridvalueiconleftpadding)

### Groups

- imageColumns

### See Also

- [ListGridField.valueIcons](#attr-listgridfieldvalueicons)

**Flags**: IRW

---
## Attr: ListGridField.isRemoveField

### Description
If set to true and [ListGrid.canRemoveRecords](ListGrid_1.md#attr-listgridcanremoverecords) is true, this field will be rendered as the remove-field for this grid. In most common usage scenarios this field will essentially be a placeholder indicating where the remove field should be rendered, meaning properties other than `isRemoveField`, such as `name` or `title`, may be left unset.

### See Also

- [ListGrid.canRemoveRecords](ListGrid_1.md#attr-listgridcanremoverecords)

**Flags**: IRA

---
## Attr: ListGridField.aiHoverRequest

### Description
If set and AI is [enabled](AI.md#classmethod-aiisenabled), the settings that configure requests to AI to generate the contents of the hover displayed when the user hovers the mouse pointer over a cell of the field.

Note: [ListGridField.showHover](#attr-listgridfieldshowhover) must be `true` on this field, or [ListGrid.showHover](ListGrid_1.md#attr-listgridshowhover) must be `true` on the grid for the hovers to be displayed.

While an AI request to generate hover text is pending, [ListGrid.placeholderAIHoverContents](ListGrid_1.md#attr-listgridplaceholderaihovercontents) is used as the hover contents.

If the AI request is successful, then [ListGrid.aiHoverContentsPrefix](ListGrid_1.md#attr-listgridaihovercontentsprefix) is prepended to the AI-generated hover text, which is always HTML-escaped.  
If, however, the AI request is not successful, then the error message (see [SummarizeValueResult.errorMessage](AsyncOperationResult.md#attr-asyncoperationresulterrormessage)) will be displayed if available, otherwise the [DataBoundComponent.defaultAsyncErrorHoverContents](DataBoundComponent.md#attr-databoundcomponentdefaultasyncerrorhovercontents) will be displayed. Additionally, properties on the hover when displaying error information can be specified with [DataBoundComponent.asyncErrorHoverProperties](DataBoundComponent.md#attr-databoundcomponentasyncerrorhoverproperties).

**Flags**: IR

---
## Attr: ListGridField.linkText

### Description
The HTML to display in cells of this field if the fieldType is set to link.

This property sets linkText that will be the same for all records. You can set linkText on a per-record basis via [ListGridRecord.linkText](ListGridRecord.md#attr-listgridrecordlinktext).

### Groups

- display_values

### See Also

- [ListGridFieldType](../reference.md#type-listgridfieldtype)
- [FieldType](../reference_2.md#type-fieldtype)
- [ListGridRecord.linkText](ListGridRecord.md#attr-listgridrecordlinktext)
- [ListGrid.linkTextProperty](ListGrid_1.md#attr-listgridlinktextproperty)
- [ListGridField.linkTextProperty](#attr-listgridfieldlinktextproperty)

**Flags**: IRW

---
## Attr: ListGridField.showHilitesInGroupSummary

### Description
Determines whether hiliting for this field is shown in a group summary. Set to false to prevent this field from showing hilite in a group summary.

All hilites in group summary rows can be controlled with the [ListGrid.showHilitesInGroupSummary](ListGrid_1.md#attr-listgridshowhilitesingroupsummary) property.

**Flags**: IRW

---
## Attr: ListGridField.showFocusedIcon

### Description
If using an icon for this button, whether to switch the icon image when the button receives focus.

If [StatefulCanvas.showFocusedAsOver](StatefulCanvas.md#attr-statefulcanvasshowfocusedasover) is true, the `"Over"` icon will be displayed when the canvas has focus, otherwise a separate `"Focused"` icon will be displayed

### Groups

- buttonIcon

### See Also

- [ListGridField.icon](#attr-listgridfieldicon)

**Flags**: IR

---
## Attr: ListGridField.hoverDelay

### Description
Delay in ms for hovers shown for cells in this field. If unset, the grid's hoverDelay will be used.

This property also governes the hoverDelay for the header button. Developers wishing to have a different delay for hovers on the header can use [ListGridField.headerHoverDelay](#attr-listgridfieldheaderhoverdelay) in addition to this property.

**Flags**: IRW

---
## Attr: ListGridField.enableWhen

### Description
[Rule Criteria](../kb_topics/ruleCriteria.md#kb-topic-dynamic-rules) to be evaluated that controls whether this field will be enabled.

When the criteria evaluates to false, the field is disabled:

*   The field header is disabled. Users cannot sort, resize, reorder, open the header context menu, or otherwise interact with the header.
*   The field’s cells are disabled for interaction. If the field is normally editable, it cannot be edited while disabled.
*   The field remains visible; to hide a field use visible, showIf, or visibleWhen.

What still works while disabled

*   Normal clicks that begin row editing still enter edit mode for the record, but the disabled field will not present an editor.
*   Normal row/record selection and navigation still work (for example, clicking cells to select rows).

Scope and re-evaluation

*   The rule is evaluated in the ListGrid’s ruleScope. When values in the ruleScope change, the rule is re-evaluated and the field’s enabled/disabled state updates accordingly.

Notes

*   Applies to the entire field (column). It does not provide per-record or per-cell enablement.
*   Use visibleWhen to control visibility instead of enablement.
*   Disabling affects user interaction on the field header and contents; programmatic API calls can still modify data unless your application logic prevents it.

Typical uses

*   Temporarily disable a column’s interactions until prerequisites are met (for example, a filter or selection is required).
*   Prevent edits to a column based on user role or application state while keeping the column visible.

### Groups

- ruleCriteria

**Flags**: IR

---
## Attr: ListGridField.wrap

### Description
Should the field title wrap if there is not enough space horizontally to accommodate it. If unset, default behavior is derived from [ListGrid.wrapHeaderTitles](ListGrid_1.md#attr-listgridwrapheadertitles). (This is a soft-wrap - if set the title will wrap at word boundaries.)

**Notes:**

*   If autofitting is active, [ListGridField.width](#attr-listgridfieldwidth) and [ListGridField.minWidth](#attr-listgridfieldminwidth) can be set to control the minimum field width - see the links for details.
*   This feature is incompatible with [ListGrid.clipHeaderTitles](ListGrid_1.md#attr-listgridclipheadertitles), and `clipHeaderTitles` will be disabled for wrapping fields.

### See Also

- [ListGrid.minFieldWidth](ListGrid_1.md#attr-listgridminfieldwidth)

**Flags**: IRW

---
## Attr: ListGridField.editorFormula

### Description
Shortcut to configure a [FormItem.formula](FormItem.md#attr-formitemformula) for the [editor](#attr-listgridfieldeditortype) used when this field is [edited](ListGrid_1.md#attr-listgridcanedit).

**Flags**: IR

---
## Attr: ListGridField.applyAfterSummary

### Description
If [ListGridField.userFormula](#attr-listgridfielduserformula) is set for this field, and this grid is showing [group summaries](ListGrid_1.md#attr-listgridshowgroupsummary) or a [grid summary](ListGrid_1.md#attr-listgridshowgridsummary), this property determines what field value should be present in those summary rows. Should the field's user-formula be applied to the calculated summary row (applyAfterSummary `true`), or should a standard grid or group summary be applied to the user-formula values displayed in the grid (applyAfterSummary `false`)?

Default behavior may be specified at the grid level via [ListGrid.applyFormulaAfterSummary](ListGrid_1.md#attr-listgridapplyformulaaftersummary)

**Flags**: IRW

---
## Attr: ListGridField.escapeKeyEditAction

### Description
What to do when a user hits escape while editing this field?  
Overrides the `escapeKeyEditAction` as specified at the listGrid level while focus is in this field.

### Groups

- editing

**Flags**: IRW

---
## Attr: ListGridField.editorValueMap

### Description
A valueMap to use for editors shown for this field. By default if this is not specified [field.valueMap](#attr-listgridfieldvaluemap) will be used instead.

Dynamic valueMaps can be provided by implementing [ListGrid.getEditorValueMap](ListGrid_2.md#method-listgridgeteditorvaluemap).

### Groups

- editing

### See Also

- [ListGrid.getEditorValueMap](ListGrid_2.md#method-listgridgeteditorvaluemap)
- [ListGrid.setEditorValueMap](ListGrid_2.md#method-listgridseteditorvaluemap)

**Flags**: IRW

---
## Attr: ListGridField.headerButtonAriaRole

### Description
[Aria role](Canvas.md#attr-canvasariarole) for the header button for this field.

**Flags**: IRA

---
## Attr: ListGridField.showValueIconOnly

### Description
If this field has a valueIcons property specified, setting this property causes the valueIcon for each value to be displayed in the cell without also showing the record's value for the field.

If unset the default behavior is to show the icon only if an explicit valueMap is specified as well in addition to a valueIcons map, otherwise show both the valueIcon and value for the cell.

Note that if this field is editable [FormItem.showValueIconOnly](FormItem.md#attr-formitemshowvalueicononly) will be passed through to editors displayed in this field.

### Groups

- imageColumns

### See Also

- [ListGridField.valueIcons](#attr-listgridfieldvalueicons)
- [ListGridField.suppressValueIcon](#attr-listgridfieldsuppressvalueicon)

**Flags**: IRW

---
## Attr: ListGridField.hiliteIconRightPadding

### Description
How much padding should there be on the right of [hilite icons](DataBoundComponent.md#attr-databoundcomponenthiliteicons) for this field? Overrides [ListGrid.hiliteIconRightPadding](ListGrid_1.md#attr-listgridhiliteiconrightpadding)

### Groups

- hiliting

**Flags**: IRW

---
## Attr: ListGridField.align

### Description
Horizontal alignment for field's column header: "left", "right" or "center". Applied to the column header title and cells by default. A separate alignment for cells can be specified via [ListGridField.cellAlign](#attr-listgridfieldcellalign).

If null, the default alignment depends on the field's declared [ListGridField.type](#attr-listgridfieldtype) - generally "left" except for numbers which are "right" - and if [ListGridField.rotateTitle](#attr-listgridfieldrotatetitle) has been specified, the default is always "center".

Note that if this field is editable, the alignment of cells in the body will also be reflected in any editors for the field.

### Groups

- appearance

**Flags**: IRW

---
## Attr: ListGridField.title

### Description
A title for this field, to display in the header for the field and in other contexts such as the [menu for picking visible fields](ListGrid_1.md#attr-listgridcanpickfields). Alternatively you can specify a [ListGridField.getFieldTitle](#method-listgridfieldgetfieldtitle) method on the field to return the HTML for the field title.

Note: To customize the display of just the title in the header, use the [ListGridField.headerTitle](#attr-listgridfieldheadertitle) property instead so that other places where the title appears in the UI are not affected. For example, you might set `headerTitle` to an empty string to suppress the header title on a narrow column, but you would retain the normal title in the `title` property to avoid a blank menu item in the field picker menu, [hilite editor](DataBoundComponent.md#method-databoundcomponentedithilites), and other contexts.

### Groups

- appearance

### See Also

- [Field.exportTitle](Field.md#attr-fieldexporttitle)

**Flags**: IRW

---
## Attr: ListGridField.validateOnChange

### Description
If set to true, any [ListGridField.validators](#attr-listgridfieldvalidators) for this field will be run whenever the value of the field is changed.

Analogous to the [FormItem.validateOnChange](FormItem.md#attr-formitemvalidateonchange) property.

### Groups

- gridValidation

**Flags**: IRW

---
## Attr: ListGridField.canHilite

### Description
Determines whether this field can be hilited. Set to false to prevent this field from appearing in HiliteEditor.

**Flags**: IRW

---
## Attr: ListGridField.filterOnKeypress

### Description
If set this will override the [filterOnKeypress setting at the grid level](ListGrid_1.md#attr-listgridfilteronkeypress)

For a discussion of the various filtering and criteria-management APIs and when to use them, see the [Grid Filtering overview](../kb_topics/gridFiltering.md#kb-topic-grid-filtering-overview).

### Groups

- filterEditor

### See Also

- [ListGrid.fetchDelay](ListGrid_1.md#attr-listgridfetchdelay)

**Flags**: IRWA

---
## Attr: ListGridField.valueIconSize

### Description
Default width and height of value icons in this field. Takes precedence over valueIconWidth, valueIconHeight and valueIconSize specified at the ListGrid level. Can be overridden via [ListGridField.valueIconWidth](#attr-listgridfieldvalueiconwidth) and {ListGridField.valueIconHeight}

### Groups

- imageColumns

### See Also

- [ListGrid.valueIconSize](ListGrid_1.md#attr-listgridvalueiconsize)
- [ListGridField.valueIconWidth](#attr-listgridfieldvalueiconwidth)
- [ListGridField.valueIconHeight](#attr-listgridfieldvalueiconheight)

**Flags**: IRW

---
## Attr: ListGridField.imageWidth

### Description
Width of images shown for fieldTypes image and imageFile in this field.

If set to a String, assumed to be a property on each record that specifies the image width. For example, if `field.imageWidth` is "logoWidth", `record.logoWidth` will control the width of the image.

### Groups

- imageColumns

### See Also

- [ListGrid.imageSize](ListGrid_1.md#attr-listgridimagesize)
- [ListGridField.imageSize](#attr-listgridfieldimagesize)
- [ListGridField.imageHeight](#attr-listgridfieldimageheight)

**Flags**: IRW

---
## Attr: ListGridField.headerHoverDelay

### Description
Delay in ms for hovers shown over this field's header.

If unset, any [ListGridField.hoverDelay](#attr-listgridfieldhoverdelay) will be used for both header hovers and hovers shown over cells in the grid's body.

**Flags**: IRW

---
## Attr: ListGridField.editorProperties

### Description
Properties to apply the the form item created to edit this field. (Only used if this field is editable).

For example, if you have a field "shoeSize" with [DataSourceField.editorType](DataSourceField.md#attr-datasourcefieldeditortype) set to "SpinnerItem" in order to use a SpinnerItem as your field editor, and you want to pass the [SpinnerItem.step](SpinnerItem.md#attr-spinneritemstep) property to the created SpinnerItem:

```
    fields : [
        { name:"shoeSize", editorType:"SpinnerItem",
          editorProperties : { step:0.5 } },
        ... other fields ...
    ]
 
```

### Groups

- editing

**Flags**: IRWA

---
## Attr: ListGridField.valueIconHeight

### Description
Height for value icons for this listGrid field. Overrides [ListGrid.valueIconSize](ListGrid_1.md#attr-listgridvalueiconsize), [ListGrid.valueIconHeight](ListGrid_1.md#attr-listgridvalueiconheight), and [ListGridField.valueIconSize](#attr-listgridfieldvalueiconsize).

### Groups

- imageColumns

**Flags**: IRW

---
## Attr: ListGridField.icons

### Description
If this field is editable, this property can be used to specify [icons](FormItem.md#attr-formitemicons) to be displayed in the editors displayed for this field

### Groups

- editing

**Flags**: IRA

---
## Attr: ListGridField.editorIconHeight

### Description
If this field is editable, this property will be passed to editors displayed for cells within this field as [FormItem.iconHeight](FormItem.md#attr-formitemiconheight).  
If this property unset, the iconHeight property from the editor can be picked up from [ListGridField.iconHeight](#attr-listgridfieldiconheight) instead.

### Groups

- editing

### See Also

- [ListGridField.icons](#attr-listgridfieldicons)

**Flags**: IRA

---
## Attr: ListGridField.editorIconWidth

### Description
If this field is editable, this property will be passed to editors displayed for cells within this field as [FormItem.iconWidth](FormItem.md#attr-formitemiconwidth).  
If this property unset, the iconWidth property from the editor can be picked up from [ListGridField.iconWidth](#attr-listgridfieldiconwidth) instead.

### Groups

- editing

### See Also

- [ListGridField.icons](#attr-listgridfieldicons)

**Flags**: IRA

---
## Attr: ListGridField.showEllipsisWhenClipped

### Description
Should ellipses be displayed when this field's cell content is clipped? To set this property at the grid level, use [ListGrid.showEllipsisWhenClipped](ListGrid_1.md#attr-listgridshowellipsiswhenclipped)

**Flags**: IRW

---
## Attr: ListGridField.required

### Description
When the user edits cells in this field, is this value required to be non-empty in order for validation to pass.  
Note: for databound listGrids, this property may be specified on the [DataSourceField](../reference_2.md#object-datasourcefield), enabling both client and server side validation.

### Groups

- gridValidation

### See Also

- [ListGridField.validators](#attr-listgridfieldvalidators)

**Flags**: IRW

---
## Attr: ListGridField.optionFilterContext

### Description
If this field has an optionDataSource specified and [autoFetchDisplayMap](#attr-listgridfieldautofetchdisplaymap) is set, this attribute provides a way to customize the dataSource request issued to fetch the display map from the option dataSource. This provides, among other capabilities, a way to trigger the server to return summary records.

### Groups

- display_values

### See Also

- [serverSummaries](../kb_topics/serverSummaries.md#kb-topic-server-summaries)

**Flags**: IR

---
## Attr: ListGridField.minWidth

### Description
When a field is subject to autofitting (see [ListGrid.autoFitFieldWidths](ListGrid_1.md#attr-listgridautofitfieldwidths)), sets the minimum width of the field. The actual allowed minimum will be the maximum of:

*   this property,
*   [ListGridField.width](#attr-listgridfieldwidth) (if a number),
*   the aufofit value determined by the widest value content in this field's column
*   [ListGrid.minFieldWidth](ListGrid_1.md#attr-listgridminfieldwidth)

### Groups

- appearance

### See Also

- [ListGridField.width](#attr-listgridfieldwidth)

**Flags**: IRW

---
## Attr: ListGridField.defaultValue

### Description
If this field [can be edited](#attr-listgridfieldcanedit), this property can be used to specify a default value for this field's editor when adding new rows to the grid.

### Groups

- editing

### See Also

- [ListGrid.startEditingNew](ListGrid_2.md#method-listgridstarteditingnew)

**Flags**: IRW

---
## Attr: ListGridField.iconWidth

### Description
If [ListGridField.icon](#attr-listgridfieldicon) is specified, this property can be used to specify the width of the icon to be displayed in the ListGrid header button. (See [StatefulCanvas.iconWidth](StatefulCanvas.md#attr-statefulcanvasiconwidth))  
If this field is editable, and [ListGridField.editorIconWidth](#attr-listgridfieldeditoriconwidth) is unset, this property will be passed onto the editors for this field as [FormItem.iconWidth](FormItem.md#attr-formitemiconwidth), which will effect the default size for [icons](#attr-listgridfieldicons) displayed in the editor.

### See Also

- [ListGridField.icon](#attr-listgridfieldicon)
- [ListGridField.icons](#attr-listgridfieldicons)

**Flags**: IR

---
## Attr: ListGridField.optionTextMatchStyle

### Description
For fields with an [ListGridField.optionDataSource](#attr-listgridfieldoptiondatasource), where [ListGridField.autoFetchDisplayMap](#attr-listgridfieldautofetchdisplaymap) is true, this property will govern the `textMatchStyle` attribute of the [DSRequest](../reference_2.md#object-dsrequest) parameter passed to [DataSource.fetchData](DataSource.md#method-datasourcefetchdata) when retrieving the remote data set to be used as a basis for this field's valueMap.

### Groups

- display_values

**Flags**: IR

---
## Attr: ListGridField.imageURLSuffix

### Description
If any cells in this field are showing a value icon (see: [ListGridField.valueIcons](#attr-listgridfieldvalueicons)) or this is has [ListGridFieldType](../reference.md#type-listgridfieldtype) set to `"image"`, the value of this property will be appended to the end of the URL for the icon displayed.  
Typical usage might be to append a file type such as `".gif"` to the filename of the image.  
For editable fields, this property will also be passed through to any editors as [FormItem.imageURLSuffix](FormItem.md#attr-formitemimageurlsuffix).

### Groups

- imageColumns

**Flags**: IRWA

---
## Attr: ListGridField.canAutoFitWidth

### Description
Should the user be allowed to perform one-time autofitting of this field via a header context-menu option?

When enabled, the default header context menu for this field will include an item to auto-fit the field and users will be able to autofit the field via the [ListGrid.headerAutoFitEvent](ListGrid_1.md#attr-listgridheaderautofitevent).

If unset, these behaviors are enabled when [ListGrid.canAutoFitFields](ListGrid_1.md#attr-listgridcanautofitfields) is true.

If this property is set to false, and [ListGrid.canAutoFitFields](ListGrid_1.md#attr-listgridcanautofitfields) is true, this field will be ommitted from auto-fit when the user selects the header menu option to [auto fit all fields](ListGrid_1.md#attr-listgridautofitalltext).

Note - this property governs user-initiated auto-fit only. It has no impact on autoFit set up via [ListGridField.autoFitWidth](#attr-listgridfieldautofitwidth) and [ListGrid.autoFitFieldWidths](ListGrid_1.md#attr-listgridautofitfieldwidths).

Note that if [showing record components](ListGrid_1.md#attr-listgridshowrecordcomponents), per-cell record components are not taken into account when determining the size for column auto fit. The default [ListGrid.getDefaultFieldWidth](ListGrid_2.md#method-listgridgetdefaultfieldwidth) implementation looks at cell content only. We typically recommend that, for fields showing record-components, [ListGridField.autoFitWidth](#attr-listgridfieldautofitwidth) and [ListGrid.canAutoFitFields](ListGrid_1.md#attr-listgridcanautofitfields) be disabled, or if the record components are of a predictable size, a [ListGridField.defaultWidth](#attr-listgridfielddefaultwidth) be specified.  
This is particularly pertinent where [ListGrid.recordComponentPosition](ListGrid_1.md#attr-listgridrecordcomponentposition) is set to "within", in which case cells' content is often empty or completely covered by record-components.

### See Also

- [ListGrid.autoFitDateFields](ListGrid_1.md#attr-listgridautofitdatefields)
- [ListGrid.autoFitTimeFields](ListGrid_1.md#attr-listgridautofittimefields)

**Flags**: IR

---
## Attr: ListGridField.aiHoverContentsPrefix

### Description
If set to a non-`null` value, override of [ListGrid.aiHoverContentsPrefix](ListGrid_1.md#attr-listgridaihovercontentsprefix) for this field.

**Flags**: IRW

---
## Attr: ListGridField.pendingAsyncCellValue

### Description
A field-specific value to display for cells whose value is pending asynchronous generation.

If set, this will override the grid-wide [ListGrid.pendingAsyncCellValue](ListGrid_1.md#attr-listgridpendingasynccellvalue) setting for the field.

### See Also

- [DataBoundComponent.isValuePendingAsync](DataBoundComponent.md#method-databoundcomponentisvaluependingasync)

**Flags**: IRW

---
## Attr: ListGridField.hoverWrap

### Description
This property may be set to customize the `wrap` attribute for the canvas shown when the mouse hovers over cells in this field. Note that this causes a soft-wrap - if set, the hover text will wrap at word boundaries.

If unset, default behavior is derived from [ListGrid.headerHoverWrap](ListGrid_1.md#attr-listgridheaderhoverwrap).

**Flags**: IRW

---
## Attr: ListGridField.defaultGroupingMode

### Description
Default groupingMode used when the user does not specify a mode or grouping is triggered programmatically and [field.groupingMode](#attr-listgridfieldgroupingmode) is unset. See [field.groupingModes](#attr-listgridfieldgroupingmodes).

### Groups

- grouping

**Flags**: IR

---
## Attr: ListGridField.skipLineBreaks

### Description
By default, when [escaping HTML](#attr-listgridfieldescapehtml), we convert line breaks (\\r\\n, \\r, and \\n) to HTML `<br>` tags so that visible cell content respects the original break characters. Set this property true to instead show the content as a single line (or potentially wrapped to avoid clipping if [ListGrid.wrapCells](ListGrid_1.md#attr-listgridwrapcells) is true).

If defaulted to null, behavior is determined by [ListGrid.skipLineBreaks](ListGrid_1.md#attr-listgridskiplinebreaks).

### See Also

- [ListGridField.escapeHTML](#attr-listgridfieldescapehtml)

**Flags**: IRW

---
## Attr: ListGridField.showAlternateStyle

### Description
When set to false, don't apply alternate-row styling to this field.

**Flags**: IRWA

---
## Attr: ListGridField.inputFormat

### Description
For fields of type `"date"` or `"datetime"`, if this is an editable listGrid, this property allows you to specify the [inputFormat](DateItem.md#attr-dateiteminputformat) applied to the editor for this field.

### See Also

- [ListGridField.dateFormatter](#attr-listgridfielddateformatter)

**Flags**: IRWA

---
## Attr: ListGridField.hiliteIconPosition

### Description
When [ListGrid.hiliteIcons](ListGrid_1.md#attr-listgridhiliteicons) are present, where the hilite icon will be placed relative to the field value. See [HiliteIconPosition](../reference_2.md#type-hiliteiconposition). Overrides [ListGrid.hiliteIconPosition](ListGrid_1.md#attr-listgridhiliteiconposition).

### Groups

- hiliting

**Flags**: IR

---
## Attr: ListGridField.displayField

### Description
Specifies the [ListGridField.optionDataSource](#attr-listgridfieldoptiondatasource) field used to retrieve the display values that are to be mapped from the internal values specified by [ListGridField.valueField](#attr-listgridfieldvaluefield).

If no `optionDataSource` is defined for the field and [ListGridField.displayValueFromRecord](#attr-listgridfielddisplayvaluefromrecord) is not set to `false`, the cell will display the displayField value for the current record instead of the underlying value for this field. This approach can be used for situations where field values need a stored-value-to-displayed-value mapping, but the set of all possible values is too large to load as a [ValueMap](../reference_2.md#type-valuemap) - see [ListGridField.optionDataSource](#attr-listgridfieldoptiondatasource) for more details on this approach. Note that if this field is editable this will also be applied to this field's editors. *This sample* illustrates this approach achieved via a server-side SQL join.

The display value for a record with a specified `displayField` can be picked up via [ListGrid.getDisplayValue](ListGrid_2.md#method-listgridgetdisplayvalue).

Unless [ListGridField.sortByDisplayField](#attr-listgridfieldsortbydisplayfield) is explicitly set to `false`, sorting by this field will sort by the display field value instead.

### Groups

- display_values

**Flags**: IRW

---
## Attr: ListGridField.exportRawNumbers

### Description
Dictates whether numeric values should be exported as raw numbers instead of formatted values when using [exportClientData()](ListGrid_2.md#method-listgridexportclientdata).

This property is only consulted if `exportRawValues` is not set to true at the [grid](ListGrid_1.md#attr-listgridexportrawvalues) or [field](#attr-listgridfieldexportrawvalues) level. That property causes all values, including numeric values, to be exported unformatted.

This is useful for cases where an explicit ListGrid formatter function simply displays the number as a formatted string for the user (for example "1,234"). Exporting that formatted string rather than the underlying numeric value causes spreadsheet applications such as Excel to lose some functionality.

If this property is not explicitly set, numeric values will be exported as raw numbers for [XLS and OOXML export](DSRequest.md#attr-dsrequestexportas) only.

This property overrides the setting at the [grid](ListGrid_1.md#attr-listgridexportrawnumbers) level.

**Flags**: IR

---
## Attr: ListGridField.exportFormat

### Description
[FormatString](../reference.md#type-formatstring) used during exports for numeric or date formatting. See [DataSourceField.exportFormat](DataSourceField.md#attr-datasourcefieldexportformat).

### Groups

- exportFormatting

**Flags**: IR

---
## Attr: ListGridField.hiliteIconLeftPadding

### Description
How much padding should there be on the left of [hilite icons](DataBoundComponent.md#attr-databoundcomponenthiliteicons) for this field? Overrides [ListGrid.hiliteIconLeftPadding](ListGrid_1.md#attr-listgridhiliteiconleftpadding)

### Groups

- hiliting

**Flags**: IRW

---
## Attr: ListGridField.editorValueIconWidth

### Description
When some cell in this field is being edited, setting this property will specify the width for value icons in the cell's editor. If unset, the editor's valueIcon width and height will be determined in the same way as it would be for a static cell.

### Groups

- imageColumns

**Flags**: IRW

---
## Attr: ListGridField.type

### Description
ListGrids picks a renderer for the view and edit mode of a field based on this attribute. See [ListGridFieldType](../reference.md#type-listgridfieldtype) for a summary of how types are rendered.

### Groups

- appearance

### See Also

- [ListGridFieldType](../reference.md#type-listgridfieldtype)
- [FieldType](../reference_2.md#type-fieldtype)

**Flags**: IR

---
## Attr: ListGridField.summaryTitle

### Description
Optional long summary title for this field, provided in addition to [ListGridField.title](#attr-listgridfieldtitle). This gives the developer an option to use a very short, or empty title for the ListGrid column (where space may be a factor), but have a longer value available to be used elsewhere.

By default this value will be used for the title of the context-menu item for showing/hiding the listGrid field when the user right-clicks on the ListGrid header.

### Groups

- appearance

### See Also

- [ListGridField.title](#attr-listgridfieldtitle)

**Deprecated**

**Flags**: IRWA

---
## Attr: ListGridField.displayValueFromRecord

### Description
If a [ListGridField.displayField](#attr-listgridfielddisplayfield) is set, should this field show record values from the `displayField`?

If [ListGridField.displayField](#attr-listgridfielddisplayfield) is specified, and there is no separate [ListGridField.optionDataSource](#attr-listgridfieldoptiondatasource), by default we will show display-field values from the same record. Setting this property to false would disable this behavior.

Alternatively, if there is a [ListGridField.optionDataSource](#attr-listgridfieldoptiondatasource) (and [ListGridField.autoFetchDisplayMap](#attr-listgridfieldautofetchdisplaymap) is false), the displayField would be ignored for the field and the underlying [record\[fieldName\] value](#attr-listgridfieldname) would be displayed to the user. This property may be set to true to override this behavior and pick up values from the `displayField` for display in this field even when there is an optionDataSource set.

Note that this property has no effect on fields with an explicitly specified valueMap, or with an optionDataSource where [ListGridField.autoFetchDisplayMap](#attr-listgridfieldautofetchdisplaymap) is true.

**Flags**: IRWA

---
## Attr: ListGridField.valueMap

### Description
Array of legal values for this field, or an Object where each property maps a stored value to a user-displayable value.  
Note that if this field is editable (see [ListGrid.canEdit](ListGrid_1.md#attr-listgridcanedit), [ListGridField.canEdit](#attr-listgridfieldcanedit)), editors displayed for this field will pick up their valueMap either from this value or from [ListGridField.editorValueMap](#attr-listgridfieldeditorvaluemap).

See also [DataSourceField.valueMap](DataSourceField.md#attr-datasourcefieldvaluemap).

### Groups

- display_values

### See Also

- [ListGrid.setValueMap](ListGrid_2.md#method-listgridsetvaluemap)
- [ListGrid.getDisplayValue](ListGrid_2.md#method-listgridgetdisplayvalue)

**Flags**: IRW

---
## Attr: ListGridField.exportFieldWidth

### Description
When exporting data to Excel/OpenOffice format using [ListGrid.exportData](ListGrid_2.md#method-listgridexportdata) or [ListGrid.exportClientData](ListGrid_2.md#method-listgridexportclientdata) with [ListGrid.exportFieldWidths](ListGrid_1.md#attr-listgridexportfieldwidths) set, set this flag false to cause this field to "opt out" of width export. Fields that opt out in this way have the corresponding spreadsheet column autosized (ie, made just wide enough that content is not clipped).

This setting has no effect if `listGrid.exportFieldWidths` is not set.

**Flags**: IRW

---
## Attr: ListGridField.name

### Description
Name of this field. Must be unique within the [ListGrid](ListGrid_1.md#class-listgrid) as well as a valid JavaScript identifier - see [FieldName](../reference.md#type-fieldname) for details and how to check for validity.

The name of the field is also the property in each record which holds the record's value for the field.

If a [ListGrid.dataSource](ListGrid_1.md#attr-listgriddatasource) is specified and the [DataSource](DataSource.md#class-datasource) has a field with the same [name](DataSourceField.md#attr-datasourcefieldname), the `ListGridField` and [DataSourceField](../reference_2.md#object-datasourcefield) are merged, with any properties on the `ListGridField` overriding those on the `DataSourceField`.

### Groups

- data

**Flags**: IR

---
## Attr: ListGridField.headerTitle

### Description
Optional title for the header button for this field. If specified this will be displayed in the header button instead of [ListGridField.title](#attr-listgridfieldtitle) or [ListGridField.name](#attr-listgridfieldname). Set to an empty string to suppress the title in the header button entirely.

### Groups

- appearance

### See Also

- [ListGridField.title](#attr-listgridfieldtitle)

**Flags**: IR

---
## Attr: ListGridField.canDragResize

### Description
Whether this field can be dragResized using the mouse. If unset, the default behavior is governed by [ListGrid.canResizeFields](ListGrid_1.md#attr-listgridcanresizefields).

**Flags**: IR

---
## Attr: ListGridField.excludeFromState

### Description
If true, then this field is excluded from the bound component's view state. In addition, the field will not be selected as the default title field by [DataBoundComponent.getTitleField](DataBoundComponent.md#method-databoundcomponentgettitlefield) if [DataBoundComponent.titleField](DataBoundComponent.md#attr-databoundcomponenttitlefield) is not provided.

### Groups

- viewState

### See Also

- [ListGrid.getViewState](ListGrid_2.md#method-listgridgetviewstate)

**Flags**: IR

---
## Attr: ListGridField.multiple

### Description
Indicates that this field should always be Array-valued. This property will be passed through to the generated edit-item when editing the field - so if [ListGridField.valueMap](#attr-listgridfieldvaluemap) is set, the default editor will be a [SelectItem](SelectItem.md#class-selectitem) with [SelectItem.multiple](SelectItem.md#attr-selectitemmultiple) set to true.

Note that for databound grids it typically makes sense to set [DataSourceField.multiple](DataSourceField.md#attr-datasourcefieldmultiple) rather than setting the property directly on the ListGridField object.

### Groups

- editing

**Flags**: IR

---
## Attr: ListGridField.alwaysShowOperatorIcon

### Description
Per-field setting for [ListGrid.alwaysShowOperatorIcon](ListGrid_1.md#attr-listgridalwaysshowoperatoricon). Can be used to force a particular field to always show it's [operatorIcon](ListGrid_1.md#attr-listgridoperatoricon), even if it has no filter-value, or is using the default [search operator](#attr-listgridfieldfilteroperator).

For a discussion of the various filtering and criteria-management APIs and when to use them, see the [Grid Filtering overview](../kb_topics/gridFiltering.md#kb-topic-grid-filtering-overview).

**Flags**: IR

---
## Attr: ListGridField.showTitle

### Description
This property may be set to `false` to explicitly suppress display of the field title in the column header button for the field.

**Flags**: IRW

---
## Attr: ListGridField.suppressValueIcon

### Description
If this field has a valueIcons property specified, setting this property to true will prevent the valueIcon being written out into this field's cells.

Note this property may also be set to false to avoid showing the standard [ListGrid.booleanTrueImage](ListGrid_1.md#attr-listgridbooleantrueimage) and [ListGrid.booleanFalseImage](ListGrid_1.md#attr-listgridbooleanfalseimage) for fields of type `boolean`.

### Groups

- imageColumns

### See Also

- [ListGridField.valueIcons](#attr-listgridfieldvalueicons)
- [ListGridField.showValueIconOnly](#attr-listgridfieldshowvalueicononly)

**Flags**: IRW

---
## Attr: ListGridField.formatGroupSummary

### Description
Optional stringMethod to format the group level summary values for this field displayed via [ListGrid.showGroupSummary](ListGrid_1.md#attr-listgridshowgroupsummary). Takes a single parameter `value` and should return the formatted version of that value. If specified this will be applied instead of any formatting logic applied via [ListGridField.formatCellValue](#method-listgridfieldformatcellvalue), [ListGrid.formatCellValue](ListGrid_2.md#method-listgridformatcellvalue), etc.

Note that for fields with a specified summary function of "count", if no custom formatting is applied, we default to formatting the count value by appending `field.pluralTitle` if defined, otherwise `field.title` to the numeric count value returned by the standard count function. To change this behavior for such fields, specify an explicit 'formatGridSummary' and/or 'formatGroupSummary' method

**Flags**: IR

---
## Attr: ListGridField.showGridSummary

### Description
If [ListGrid.showGridSummary](ListGrid_1.md#attr-listgridshowgridsummary) is true, should this field show a summary value. If unset, this field will show a summary value in the summary row if an explicit [ListGridField.summaryFunction](#attr-listgridfieldsummaryfunction) is specified or if a [default summary function](SimpleType.md#classmethod-simpletypegetdefaultsummaryfunction) is defined for the specified field type.

**Flags**: IR

---
## Attr: ListGridField.includeInRecordSummary

### Description
If a listGrid is showing a field of type summary, should this field be passed to the recordSummaryFunction when calculating the summary value to display. If unset, fields are included if they are of type "integer" or "float" only (since most summary functions perform numeric calculations). See also [ListGridField.includeInRecordSummaryFields](#attr-listgridfieldincludeinrecordsummaryfields).

**Flags**: IR

---
## Attr: ListGridField.headerButtonAriaState

### Description
[Aria state](Canvas.md#attr-canvasariastate) for the header button for this field.

**Flags**: IRA

---
## Attr: ListGridField.exportRawValues

### Description
Dictates whether the data in this field should be exported raw by [exportClientData()](ListGrid_2.md#method-listgridexportclientdata). If set to true for a field, the values in the field-formatters will not be executed for data in this field. Decreases the time taken for large exports.

**Flags**: IR

---
## Attr: ListGridField.groupGranularity

### Description
Granularity of grouping for numeric fields.

Groups will be formed based on ranges of values of size `groupGranularity`. For example, if groupGranularity were 1000, groups would be 0-1000, 1000-2000, etc.

### Groups

- grouping

**Flags**: IR

---
## Attr: ListGridField.hideOnPhone

### Description
Set this property to true to suppress showing this field on mobile phones (handset-sized devices). To update this property at runtime use [ListGrid.setHideOnPhone](ListGrid_2.md#method-listgridsethideonphone)

Note that if [ListGridField.hidden](#attr-listgridfieldhidden) is set, or an explicit [ListGridField.showIf](#method-listgridfieldshowif) function exists that will take precedence over this setting. Similarly, an explicit call to [ListGrid.showField](ListGrid_2.md#method-listgridshowfield) or [ListGrid.hideField](ListGrid_2.md#method-listgridhidefield) will clear this setting.

See also the related property [ListGridField.hideOnTablet](#attr-listgridfieldhideontablet).

### Groups

- appearance

**Flags**: IRW

---
## Attr: ListGridField.filterOperator

### Description
With the [FilterEditor](ListGrid_1.md#attr-listgridshowfiltereditor) showing, the default [Operator](../reference.md#object-operator) to use when matching values for this field.

For a discussion of the various filtering and criteria-management APIs and when to use them, see the [Grid Filtering overview](../kb_topics/gridFiltering.md#kb-topic-grid-filtering-overview).

Users can override this default operator, or revert to it, with the ["Filter using"](ListGrid_1.md#attr-listgridfilterusingtext) submenu, in the grid's [headerContextMenu](ListGrid_1.md#attr-listgridshowheadercontextmenu); developers can use [ListGrid.setFieldSearchOperator](ListGrid_2.md#method-listgridsetfieldsearchoperator) to modify the operator and [ListGrid.clearFieldSearchOperator](ListGrid_2.md#method-listgridclearfieldsearchoperator) to reset to the default.

Note that you can set all FilterEditor fields to default to either substring or exact match via [autoFetchTextMatchStyle](ListGrid_1.md#attr-listgridautofetchtextmatchstyle), but if you want a mix of exact vs substring match on different fields, you need to use this property, and your ListGrid will produce [AdvancedCriteria](../reference.md#object-advancedcriteria) rather than the simpler [Criteria](../reference_2.md#type-criteria) format. This is automatically and transparently handled by the SmartClient Server's SQLDataSource and HibernateDataSource in Power Edition or above, but if you have your own filtering implementation, it will need to be able to handle AdvancedCriteria.

### See Also

- [ListGridField.operator](#attr-listgridfieldoperator)

**Flags**: IR

---
## Attr: ListGridField.cellPrompt

### Description
HTML to show in a hover over cells in this field. Useful for fixed hover text, such as a tooltip for an icon in a field of type "icon". To show a custom prompt per cell, see [hoverHTML](#method-listgridfieldhoverhtml).

**Flags**: IRW

---
## Attr: ListGridField.canFreeze

### Description
Whether this field should display freezing/unfreezing options in its header context menu. See [frozenFields](../kb_topics/frozenFields.md#kb-topic-frozen-fields).

### Groups

- frozenFields

### See Also

- [ListGrid.getHeaderContextMenuItems](ListGrid_2.md#method-listgridgetheadercontextmenuitems)

**Flags**: IR

---
## Attr: ListGridField.hidden

### Description
Marks field as initially hidden.  
The user will still be able to show the field via a context menu. This may be suppressed by setting [ListGridField.canHide](#attr-listgridfieldcanhide) to false, or by setting [ListGrid.canPickFields](ListGrid_1.md#attr-listgridcanpickfields) to false to suppress the field-picker entirely.

To mark a field as completely hidden (not shown to a user at all, in any component), set [DataSourceField.hidden](DataSourceField.md#attr-datasourcefieldhidden) instead.

### Groups

- appearance

**Flags**: IR

---
## Attr: ListGridField.userFormula

### Description
Formula definition for this field.

Advanced applications that wish to save formulas separately from a grid's [viewState](ListGrid_2.md#method-listgridgetviewstate) can provide a [UserFormula](../reference.md#object-userformula) as part of the field definition, and may subsequently respond to an updated formula via the [ListGrid.formulaUpdated](ListGrid_2.md#method-listgridformulaupdated) notification.

Note that the current implementation of `UserFormula` simply executes [UserFormula.text](UserFormula.md#attr-userformulatext) as a JavaScript string after making special variables and methods available to the formula. It is safe to allow users to define formulas for themselves (since an end user can always execute whatever JavaScript they want via the browser's built-in developer tools), and is safe to allow formulas to be shared between trusted users. However it would not be safe to allow an untrusted user to create formulas that are shared to other users.

Also, while the current implementation would allow creation of a formula that calls JavaScript functions that are not part of the standard or custom [MathFunctions](MathFunction.md#class-mathfunction), this should not be relied upon, as future versions of the formula engine may prohibit such calls.

To change this field's formula, either call [ListGrid.setUserFormula](ListGrid_2.md#method-listgridsetuserformula) with a new `UserFormula` object or call [ListGrid.setUserFormulaText](ListGrid_2.md#method-listgridsetuserformulatext) to change just the [UserFormula.text](UserFormula.md#attr-userformulatext).

It is undefined behavior to share the same record objects, or the same [ResultSet](ResultSet.md#class-resultset) instances, among multiple grids if one of the grid's fields specifies a `userFormula`, [userSummary](#attr-listgridfieldusersummary), [aiFieldPrompt](#attr-listgridfieldaifieldprompt), or [aiHoverRequest](#attr-listgridfieldaihoverrequest), or if one of the grids has a [Hilite](../reference_2.md#object-hilite) with an asynchronous filter in the hilite's [criteria](Hilite.md#attr-hilitecriteria).

### Groups

- fieldGeneration

**Flags**: IRW

---
## Attr: ListGridField.valign

### Description
Specifies vertical alignment in the column header for this field: "top", "center", or "bottom". If unset, default behavior is derived from [ListGrid.headerTitleVAlign](ListGrid_1.md#attr-listgridheadertitlevalign).

### See Also

- [ListGrid.rotateHeaderTitles](ListGrid_1.md#attr-listgridrotateheadertitles)

**Flags**: IR

---
## Attr: ListGridField.hiliteIconHeight

### Description
Height for hilite icons for this field. Overrides [ListGrid.hiliteIconSize](ListGrid_1.md#attr-listgridhiliteiconsize), [ListGrid.hiliteIconHeight](ListGrid_1.md#attr-listgridhiliteiconheight), and [ListGridField.hiliteIconSize](#attr-listgridfieldhiliteiconsize).

### Groups

- hiliting

**Flags**: IRW

---
## Attr: ListGridField.filterEditorProperties

### Description
If this ListGrid is showing a filter row ([showFilterEditor](ListGrid_1.md#attr-listgridshowfiltereditor):true), this property can be used to specify properties for the appropriate filter form item.

### Groups

- filterEditor

**Flags**: IRWA

---
## Attr: ListGridField.groupingModes

### Description
If this field can be grouped, this attribute represents the set of grouping styles that are available. For example, a "date" field might be able to be grouped by week or month, as well as by the date itself.

If `groupingModes` are present and [grouping is enabled](ListGrid_1.md#attr-listgridcangroupby), the menu for this field includes a submenu of possible grouping modes generated from the `groupingModes` valueMap. When the user selects a particular grouping mode, [field.groupingMode](#attr-listgridfieldgroupingmode) is set to the user's chosen mode, and this choice can be detected via the `field` parameter to [ListGridField.getGroupValue](#method-listgridfieldgetgroupvalue) in order to provide different modes of grouping.

The user may also choose to group records without specifying a grouping mode, in this case, the [ListGridField.defaultGroupingMode](#attr-listgridfielddefaultgroupingmode) is used.

Note that `getGroupValue`, `groupingModes` et al can be specified on [SimpleType](SimpleType.md#class-simpletype) declarations. See this list of [builtin grouping modes](../kb_topics/builtinGroupingModes.md#kb-topic-built-in-grouping-modes) for more information.

### Groups

- grouping

**Flags**: IR

---
## Attr: ListGridField.asyncMissingCellValue

### Description
A field-specific value to display for cells whose value was not generated by the previous asynchronous operation to generate it, or will not be generated by an asynchronous operation due to currently being disabled.

If set, this will override the grid-wide [ListGrid.asyncMissingCellValue](ListGrid_1.md#attr-listgridasyncmissingcellvalue) setting for the field.

**Flags**: IRW

---
## Attr: ListGridField.imageSize

### Description
Size of images shown for fieldTypes image and imageFile in this field. This setting overrides the global ListGrid default [ListGrid.imageSize](ListGrid_1.md#attr-listgridimagesize).

If set to a String, assumed to be a property on each record that specifies the image height. For example, if `field.imageSize` is "logoSize", `record.logoSize` will control the size of the image.

### Groups

- imageColumns

### See Also

- [ListGridField.imageWidth](#attr-listgridfieldimagewidth)
- [ListGridField.imageHeight](#attr-listgridfieldimageheight)

**Flags**: IRW

---
## Attr: ListGridField.linkURLSuffix

### Description
If this field has type \[[ListGridFieldType](../reference.md#type-listgridfieldtype)\] set to `"link"`, setting this property will apply a standard suffix to the link URL for cells in this field.

**Flags**: IRWA

---
## Attr: ListGridField.canHide

### Description
If set to false, this field will be omitted from the column picker that appears in the header context menu when [ListGrid.canPickFields](ListGrid_1.md#attr-listgridcanpickfields) is enabled. This means that the end user will not be able to hide it if it's currently shown, or show it if it's currently hidden.

If this property is set to `false`, and the [advanced field picker](ListGrid_1.md#attr-listgriduseadvancedfieldpicker) is shown, if the field is [ListGridField.hidden](#attr-listgridfieldhidden), the field will not show in the list of available fields. If the field is visible, it will be displayed in the list of currently visible fields, but the advanced field picker user interface will disallow hiding it.

### Groups

- appearance

### See Also

- [ListGrid.getHeaderContextMenuItems](ListGrid_2.md#method-listgridgetheadercontextmenuitems)

**Flags**: IRW

---
## Attr: ListGridField.enterKeyEditAction

### Description
What to do when a user hits enter while editing this field?  
Overrides the `enterKeyEditAction` as specified at the listGrid level while focus is in this field.

### Groups

- editing

**Flags**: IRW

---
## Attr: ListGridField.showHoverComponents

### Description
When set to true and showHover is also true for the field, shows a widget hovering at the mouse point.

A number of builtin modes are provided - see [HoverMode](../reference.md#type-hovermode).

Also supported at the [ListGrid-level](ListGrid_1.md#attr-listgridshowhovercomponents).

### Groups

- hoverComponents

**Flags**: IRW

---
## Attr: ListGridField.aiFieldPrompt

### Description
The prompt to send to AI to generate the field's values.

Setting this property causes the field to be AI-generated, and the default value of [ListGridField.escapeHTML](#attr-listgridfieldescapehtml) will be `true`.

AI must be enabled in the application. See [AI.isEnabled](AI.md#classmethod-aiisenabled).

**Flags**: IR

---
## Attr: ListGridField.prompt

### Description
Causes a tooltip hover to appear on the header generated for this field (effectively sets [Canvas.prompt](Canvas.md#attr-canvasprompt) for the header).

**Flags**: IR

---
## Attr: ListGridField.asyncErrorCellValue

### Description
A field-specific value to display for cells when an error occurred during asynchronous generation.

If set, this will override the grid-wide [ListGrid.asyncErrorCellValue](ListGrid_1.md#attr-listgridasyncerrorcellvalue) setting for the field.

### See Also

- [DataBoundComponent.isValueAsyncError](DataBoundComponent.md#method-databoundcomponentisvalueasyncerror)

**Flags**: IRW

---
## Attr: ListGridField.summaryFunction

### Description
If [ListGrid.showGridSummary](ListGrid_1.md#attr-listgridshowgridsummary) or [ListGrid.showGroupSummary](ListGrid_1.md#attr-listgridshowgroupsummary) is true, this attribute can be used to specify an explicit [SummaryFunction](../reference_2.md#type-summaryfunction) for calculating the summary value to display.

If an array of summaryFunctions is specified, they will be executed in turn and the grid will show multiple summary rows at the grid or group level (or both) containing the resulting values.

**Flags**: IR

---
## Attr: ListGridField.showFilterEditorHovers

### Description
When set to false, no hover is shown for the field editor in this field. Otherwise, a hover shows the current field's criteria description along with the [ListGrid.filterWindowCriteria](ListGrid_1.md#attr-listgridfilterwindowcriteria) description if configured.

All hovers for the filter editor can be disabled using [ListGrid.showFilterEditorHovers](ListGrid_1.md#attr-listgridshowfiltereditorhovers).

The descriptive text for criteria is formatted by [DataSource.getAdvancedCriteriaDescription](DataSource.md#classmethod-datasourcegetadvancedcriteriadescription).

### See Also

- [ListGrid.showFilterEditorHovers](ListGrid_1.md#attr-listgridshowfiltereditorhovers)

**Flags**: IR

---
## Attr: ListGridField.shouldPrint

### Description
Whether this field should be included in the printable representation of the grid.

### Groups

- printing

**Flags**: IRW

---
## Attr: ListGridField.iconHeight

### Description
If [ListGridField.icon](#attr-listgridfieldicon) is specified, this property can be used to specify the height of the icon to be displayed in the ListGrid header button. (See [StatefulCanvas.iconHeight](StatefulCanvas.md#attr-statefulcanvasiconheight))  
If this field is editable, and [ListGridField.editorIconHeight](#attr-listgridfieldeditoriconheight) is unset, this property will be passed onto the editors for this field as [FormItem.iconWidth](FormItem.md#attr-formitemiconwidth), which will effect the default size for [icons](#attr-listgridfieldicons) displayed in the editor.

### See Also

- [ListGridField.icon](#attr-listgridfieldicon)
- [ListGridField.icons](#attr-listgridfieldicons)

**Flags**: IR

---
## Attr: ListGridField.imageHeight

### Description
Height of image shown for fieldTypes image and imageFile in this field.

If set to a String, assumed to be a property on each record that specifies the image height. For example, if `field.imageHeight` is "logoHeight", `record.logoHeight` will control the height of the image.

### Groups

- imageColumns

### See Also

- [ListGrid.imageSize](ListGrid_1.md#attr-listgridimagesize)
- [ListGridField.imageSize](#attr-listgridfieldimagesize)
- [ListGridField.imageWidth](#attr-listgridfieldimagewidth)

**Flags**: IRW

---
## Attr: ListGridField.defaultFilterValue

### Description
If this ListGrid is showing a filter row, this property can be used to apply a default value to show in the filter editor for this field.

### Groups

- filterEditor

**Flags**: IRWA

---
## Attr: ListGridField.canSort

### Description
Enables or disables sorting by this column. If false, interactive sorting via header-clicks or menu-items will have no effect, but direct scripted calls to [sort()](ListGrid_2.md#method-listgridsort) or [setSort()](ListGrid_2.md#method-listgridsetsort) will work as expected.

### Groups

- sorting

### See Also

- [ListGrid.sort](ListGrid_2.md#method-listgridsort)
- [ListGrid.canSort](ListGrid_1.md#attr-listgridcansort)

**Flags**: IRW

---
## Attr: ListGridField.groupPrecision

### Description
For fields of type:"float" or derived from float, number of digits after the decimal point to consider when grouping.

For example, `groupPrecision:2` indicates that 45.238 and 45.231 group together, but 45.22 and 45.27 are separate.

See also [groupGranularity](#attr-listgridfieldgroupgranularity) for grouping by broader ranges.

### Groups

- grouping

**Flags**: IR

---
## Attr: ListGridField.width

### Description
The width of this field, specified as either an absolute number of pixels, a percentage of the remaining space like "25%", or "\*" to split remaining space among all fields which have "\*".

Caution: stretch sizes are currently ignored if the field is being autofitted (see [ListGrid.autoFitFieldWidths](ListGrid_1.md#attr-listgridautofitfieldwidths)), unless [ListGrid.showHeader](ListGrid_1.md#attr-listgridshowheader) is false.

Note: if autofitting is active for a field, the width will default to the numerical autofit width for that field (so it will not be stretched larger to fill available space). Otherwise, if not autofitting, the width will default to "\*" causing it to be automatically stretched.

The width may be defaulted to a numerical value based on [DataSourceField.length](DataSourceField.md#attr-datasourcefieldlength) if no [ListGridField.valueMap](#attr-listgridfieldvaluemap) is set, subject to the initial values of [ListGridField.minWidth](#attr-listgridfieldminwidth) and [ListGrid.minFieldWidth](ListGrid_1.md#attr-listgridminfieldwidth). If you'd rather have the field stretched-sized to fit the available space, set its initial width to "\*".

See also [ListGrid.minFieldWidth](ListGrid_1.md#attr-listgridminfieldwidth) to ensure no field goes below a minimum size.

Use [ListGrid.resizeField](ListGrid_2.md#method-listgridresizefield) to programmatically change field width after creation.

Use [ListGrid.getFieldWidth](ListGrid_2.md#method-listgridgetfieldwidth) to access the rendered field width after the ListGrid is drawn.

### Groups

- appearance

### See Also

- [ListGrid.autoFitFieldWidths](ListGrid_1.md#attr-listgridautofitfieldwidths)
- [ListGridField.minWidth](#attr-listgridfieldminwidth)
- [ListGridField.maxWidth](#attr-listgridfieldmaxwidth)

**Flags**: IRW

---
## Attr: ListGridField.editorType

### Description
Name of form item class to use for the form item created to edit this field. (Only used if this field is editable).  
Note: If this is not specified, the edit-form item type may be derived from the `editorType` property, typically inherited from datasource fields, or from the `type` of the field (showing the appropriate form item for the data-type). See the [editing](../kb_topics/editing.md#kb-topic-grid-editing) overview for more on editing ListGrid fields.

### Groups

- editing

### See Also

- [ListGrid.canEdit](ListGrid_1.md#attr-listgridcanedit)

**Flags**: IRWA

---
## Attr: ListGridField.showSelectedIcon

### Description
If using an icon for this button, whether to switch the icon image when the button becomes selected.

### Groups

- buttonIcon

### See Also

- [ListGridField.icon](#attr-listgridfieldicon)

**Flags**: IR

---
## Attr: ListGridField.autoFitWidthApproach

### Description
When a user requests column autofitting via the [header contextMenu](ListGrid_2.md#method-listgridgetheadercontextmenuitems) or via a [mouse gesture](ListGrid_1.md#attr-listgridheaderautofitevent), what autofit approach is used. If set, this setting overrides the autoFitWidthApproach specified at the ListGrid level.

For a more direct alternative, see [ListGridField.autoFit](#attr-listgridfieldautofit), which effectively sets this attribute and turns on [ListGridField.autoFitWidth](#attr-listgridfieldautofitwidth).

### Groups

- autoFitFields

**Flags**: IRW

---
## Attr: ListGridField.editorImageURLSuffix

### Description
When some cell in this field is being edited, this property can be used to apply an explicit [FormItem.imageURLSuffix](FormItem.md#attr-formitemimageurlsuffix) to the editor in question. This can be used to modify the valueIcons within the editor.  
If unset, but [ListGridField.imageURLPrefix](#attr-listgridfieldimageurlprefix) is specified, that will be used instead.

### Groups

- editing

**Flags**: IRWA

---
## Attr: ListGridField.valueIconOrientation

### Description
If we're showing a valueIcon for this field should it appear to the left or the right of the text? By default the icon will appear to the left of the textual value - set this to "right" to show the icon on the right of the text. Has no effect if [ListGridField.showValueIconOnly](#attr-listgridfieldshowvalueicononly) is true

### Groups

- imageColumns

**Flags**: IRW

---
## Attr: ListGridField.canEditSummary

### Description
Can summary be edited from header context menu? Setting attribute to `false` prevents editing. A `null` or `true` value allows editing.

Has no effect when [ListGrid.canAddSummaryFields](ListGrid_1.md#attr-listgridcanaddsummaryfields) is `false`.

**Flags**: IR

---
## Attr: ListGridField.iconSpacing

### Description
Pixels between icon and title text.

### Groups

- buttonIcon

### See Also

- [ListGridField.icon](#attr-listgridfieldicon)

**Flags**: IR

---
## Attr: ListGridField.userSummary

### Description
Summary definition for this field.

Advanced applications that wish to save summaries separately from a grid's [viewState](ListGrid_2.md#method-listgridgetviewstate) can provide a [UserSummary](../reference.md#object-usersummary) as part of the field definition, and may subsequently respond to an updated summary via the [ListGrid.summaryUpdated](ListGrid_2.md#method-listgridsummaryupdated) notification.

To change this field's summary definition, either call [ListGrid.setUserSummary](ListGrid_2.md#method-listgridsetusersummary) with a new `UserSummary` object or call [ListGrid.setUserSummaryText](ListGrid_2.md#method-listgridsetusersummarytext) to change just the [UserSummary.text](UserSummary.md#attr-usersummarytext).

It is undefined behavior to share the same record objects, or the same [ResultSet](ResultSet.md#class-resultset) instances, among multiple grids if one of the grid's fields specifies a `userSummary`, [userFormula](#attr-listgridfielduserformula), [aiFieldPrompt](#attr-listgridfieldaifieldprompt), or [aiHoverRequest](#attr-listgridfieldaihoverrequest), or if one of the grids has a [Hilite](../reference_2.md#object-hilite) with an asynchronous filter in the hilite's [criteria](Hilite.md#attr-hilitecriteria).

### Groups

- fieldGeneration

**Flags**: IRW

---
## Attr: ListGridField.selectCellTextOnClick

### Description
Should the cell content be natively selected (ready for copying to clip-board) on click?

See [ListGrid.selectCellTextOnClick](ListGrid_1.md#attr-listgridselectcelltextonclick) for more information.

**Flags**: IRW

---
## Attr: ListGridField.showGroupSummary

### Description
If [ListGrid.showGroupSummary](ListGrid_1.md#attr-listgridshowgroupsummary) is true, should this field show a summary value in a summary row when the grid is grouped? If unset, this field will show a summary value in the summary row if an explicit [ListGridField.summaryFunction](#attr-listgridfieldsummaryfunction) is specified or if a [default summary function](SimpleType.md#classmethod-simpletypegetdefaultsummaryfunction) is defined for the specified field type.

**Flags**: IR

---
## Attr: ListGridField.headerTitleStyle

### Description
Custom titleStyle to apply to this field's header button instead of [ListGrid.headerTitleStyle](ListGrid_1.md#attr-listgridheadertitlestyle).  
Note that this will typically only have an effect if [ListGrid.headerButtonConstructor](ListGrid_1.md#attr-listgridheaderbuttonconstructor) is set to [StretchImgButton](StretchImgButton.md#class-stretchimgbutton) or a subclass thereof.

### Groups

- appearance

**Flags**: IRW

---
## Attr: ListGridField.target

### Description
By default, clicking a link rendered by this item opens it in a new browser window. You can alter this behavior by setting this property. The value of this property will be passed as the value to the `target` attribute of the anchor tag used to render the link.

If you set listGridField.target to "javascript", the default behavior is to catch and consume mouse-clicks that would result in the link being followed. Instead, the [ListGrid.cellClick](ListGrid_2.md#method-listgridcellclick) event is fired for the containing cell.

**Flags**: IRW

---
## Attr: ListGridField.editorValueIconHeight

### Description
When some cell in this field is being edited, setting this property will specify the height for value icons in the cell's editor. If unset, the editor's valueIcon width and height will be determined in the same way as it would be for a static cell.

### Groups

- imageColumns

**Flags**: IRW

---
## Attr: ListGridField.format

### Description
[FormatString](../reference.md#type-formatstring) for numeric or date formatting. See [DataSourceField.format](DataSourceField.md#attr-datasourcefieldformat).

### Groups

- exportFormatting

**Flags**: IR

---
## Attr: ListGridField.decimalPrecision

### Description
Applies only to fields of type "float" and affects how many significant digits are shown.

For example, with decimalPrecision 3, if the field value is 343.672677, 343.673 is shown.

If the value is 125.2, 125.2 is shown - decimalPrecision will not cause extra zeros to be added. Use [DataSourceField.decimalPad](DataSourceField.md#attr-datasourcefielddecimalpad) for this.

A number is always shown with its original precision when edited.

### Groups

- appearance

**Flags**: IRW

---
## Attr: ListGridField.hoverWidth

### Description
Specifies the width of the canvas shown when the mouse hovers over cells in this field.

If unset, default behavior is derived from [ListGrid.headerHoverWidth](ListGrid_1.md#attr-listgridheaderhoverwidth).

**Flags**: IRW

---
## Attr: ListGridField.escapeHTML

### Description
By default HTML values in ListGrid cells will be interpreted by the browser. Setting this flag to `true` will cause HTML characters to be escaped, meaning the raw value of the field (for example `"`<b>`AAA`</b>`"`) is displayed to the user rather than being interpreted as HTML (for example `"**AAA**"`)

If this field has an [ListGridField.aiFieldPrompt](#attr-listgridfieldaifieldprompt), then the default value of this setting is `true`.

### See Also

- [ListGridField.skipLineBreaks](#attr-listgridfieldskiplinebreaks)

**Flags**: IRW

---
## Attr: ListGridField.initialValue

### Description
In an editable ListGrid, initial value for this field when the user begins editing a new record.

`initialValue` applies only if a new record is created by end user action (such as navigating past the end of the data when [ListGrid.listEndEditAction](ListGrid_1.md#attr-listgridlistendeditaction) is "next") or by a call to [ListGrid.startEditingNew](ListGrid_2.md#method-listgridstarteditingnew) that _does not specify the `initialValues`_ argument.

### Groups

- editing

**Flags**: IR

---
## Attr: ListGridField.partialSummary

### Description
Only applies to fields of type `"summary"`. This attribute is set on a summary field, when calculating the summary value from some record, the summary function will only be passed the fields before this summary field. This may be useful for displaying running totals across a record.

Note that this feature would typically be used with [canReorderFields:false](ListGrid_1.md#attr-listgridcanreorderfields)

**Flags**: IR

---
## Attr: ListGridField.iconOrientation

### Description
If this field is showing an icon, should it appear to the left or right of the title?  
Valid options are `"left"` or `"right"`

### See Also

- [ListGridField.icon](#attr-listgridfieldicon)

**Flags**: IR

---
## Attr: ListGridField.canEditAISummary

### Description
Can this AI summary or sort field be edited from the header context menu? Setting this property to `false` prevents editing by the user.

**Flags**: IR

---
## Attr: ListGridField.canEditFormula

### Description
Can formula be edited from header context menu? Setting attribute to `false` prevents editing. A `null` or `true` value allows editing.

Has no effect when [ListGrid.canAddFormulaFields](ListGrid_1.md#attr-listgridcanaddformulafields) is `false`.

**Flags**: IR

---
## Attr: ListGridField.showRollOverIcon

### Description
If using an icon for this button, whether to switch the icon image on mouse rollover.

### Groups

- buttonIcon

### See Also

- [ListGridField.icon](#attr-listgridfieldicon)

**Flags**: IR

---
## Attr: ListGridField.arrowKeyEditAction

### Description
What to do when a user hits arrow key while editing this field?  
See [ListGrid.getArrowKeyEditAction](ListGrid_2.md#method-listgridgetarrowkeyeditaction).

### Groups

- editing

**Flags**: IRW

---
## Attr: ListGridField.showHover

### Description
Whether to show hovers for this field. The default hover will be the contents of the cell the user is hovering over, and can be customized via [field.hoverHTML()](#method-listgridfieldhoverhtml).

[ListGrid.showHover](ListGrid_1.md#attr-listgridshowhover) can be set to true to cause hovers to be shown for all fields by default. In this case, `field.showHover` can be set to false to suppress hovers for an individual field.

All hovers can be disabled, regardless of other settings, by setting [ListGrid.canHover](ListGrid_1.md#attr-listgridcanhover) to false.

**Flags**: IRW

---
## Attr: ListGridField.iconVAlign

### Description
If this field is editable, this property will be passed to editors displayed for cells within this field as [FormItem.iconVAlign](FormItem.md#attr-formitemiconvalign).

### Groups

- editing

### See Also

- [ListGridField.icons](#attr-listgridfieldicons)

**Flags**: IRA

---
## Attr: ListGridField.timeFormatter

### Description
Time-format to apply to date type values within this field. If specified, any dates displayed in this field will be formatted as times using the appropriate format. This is most commonly only applied to fields specified as type `"time"` though if no explicit [ListGridField.dateFormatter](#attr-listgridfielddateformatter) is specified it will be respected for other fields as well.

If unspecified, a timeFormatter may be defined [at the component level](ListGrid_1.md#attr-listgridtimeformatter) and will be respected by fields of type `"time"`.

If this field is editable, the timeFormatter will also be passed to the editor created to edit this field as [FormItem.timeFormatter](FormItem.md#attr-formitemtimeformatter).

### Groups

- appearance

**Flags**: IRWA

---
## Attr: ListGridField.iconCursor

### Description
Specifies the cursor to display when the mouse pointer is over an icon image in a cell for either a field of type [icon](#attr-listgridfieldicon) or a [valueIcon](#attr-listgridfieldvalueicons).

If not explicitly specified, see [ListGrid.getIconCursor](ListGrid_2.md#method-listgridgeticoncursor) for how `"icon"` fields determine icon image cursors, and [ListGrid.getValueIconCursor](ListGrid_2.md#method-listgridgetvalueiconcursor) for how value icon image cursors are determined.

**Flags**: IRWA

---
## Attr: ListGridField.canEdit

### Description
This property establishes default editability for the field. May be overridden by setting the 'canEdit' property at the listGrid level. If not explicitly set and this grid is bound to a dataSource, the [ListGrid.canEditFieldAttribute](DataBoundComponent.md#attr-databoundcomponentcaneditfieldattribute) may be used to set default editability at the field level.

An override of [ListGrid.canEditCell](ListGrid_2.md#method-listgridcaneditcell) can be used for more dynamic control over whether fields can be edited.

### Groups

- editing

### See Also

- [ListGrid.canEdit](ListGrid_1.md#attr-listgridcanedit)
- [ListGrid.recordEditProperty](ListGrid_1.md#attr-listgridrecordeditproperty)
- [ListGrid.canEditCell](ListGrid_2.md#method-listgridcaneditcell)

**Flags**: IRW

---
## Attr: ListGridField.emptyCellValue

### Description
The value to display for a cell whose value is null or the empty string after applying [formatting](#method-listgridfieldformatcellvalue) and valueMap (if any).

This is the field-specific attribute. You may also set the [ListGrid.emptyCellValue](ListGrid_1.md#attr-listgridemptycellvalue) at the grid level to define the emptyCellValue for all empty fields in the grid.

### Groups

- display_values

**Flags**: IRW

---
## Attr: ListGridField.optionCriteria

### Description
If [ListGridField.optionDataSource](#attr-listgridfieldoptiondatasource) is set for this ListGridField, criteria specified in this attribute will be passed to the dataSource when performing the fetch operation to determine data-value to display-value mappings

See also [ListGridField.optionTextMatchStyle](#attr-listgridfieldoptiontextmatchstyle).

### Groups

- display_values

**Flags**: IRW

---
## Attr: ListGridField.cellIcon

### Description
For a field of type:"icon" only, set the icon that appears in body cells. Unless setting [field.icon](#attr-listgridfieldicon), setting field.cellIcon will not show an icon in the header.

To change this property after fields have been passed to [ListGrid.setFields](ListGrid_2.md#method-listgridsetfields), use [ListGrid.setFieldCellIcon](ListGrid_2.md#method-listgridsetfieldcellicon).

**Flags**: IR

---
## Attr: ListGridField.autoFetchDisplayMap

### Description
If true, automatically fetches records and derives a valueMap from [ListGridField.optionDataSource](#attr-listgridfieldoptiondatasource).

Same as [ListGrid.autoFetchDisplayMap](ListGrid_1.md#attr-listgridautofetchdisplaymap), but defined on a per-field basis.

### Groups

- display_values

### See Also

- [ListGrid.autoFetchDisplayMap](ListGrid_1.md#attr-listgridautofetchdisplaymap)

**Flags**: IRW

---
## Attr: ListGridField.canReorder

### Description
Whether this field can be reordered using the mouse. If unset, the default behavior is governed by [ListGrid.canReorderFields](ListGrid_1.md#attr-listgridcanreorderfields). Note that setting this property to `false` will lock this field from being moved - that is, the user is prevented from moving this field directly by dragging with the mouse, or by dropping another field onto this field.

Note that setting `canReorder:false` on a field in the middle of a grid is mostly useless, since it's possible that such a "locked" field may still be reordered automatically, as a result of the user dragging one unlocked field onto another unlocked field.

Fields in [headerSpans](ListGrid_1.md#attr-listgridheaderspans) are treated as if they have `canReorder:false` to keep the fields in the span together, except that unlocked fields not in a span may be drag-reordered across them, even if they're at the header's extreme left or right. HeaderSpans themselves may not be drag-reordered.

### Groups

- dragging

**Flags**: IR

---
## Attr: ListGridField.defaultWidth

### Description
Optional "default width" for this field. If set, this value will be returned by the [ListGrid.getDefaultFieldWidth](ListGrid_2.md#method-listgridgetdefaultfieldwidth) method, and used as the autoFit size for the field's content.

### Groups

- autoFitFields

**Flags**: IR

---
## Attr: ListGridField.leaveHeaderMenuButtonSpace

### Description
If [ListGrid.showHeaderMenuButton](ListGrid_1.md#attr-listgridshowheadermenubutton) is true, when auto-fitting fields to the title width via [ListGrid.autoFitFieldWidths](ListGrid_1.md#attr-listgridautofitfieldwidths) or [ListGridField.autoFitWidth](#attr-listgridfieldautofitwidth), should the button be sized such that there is enough space for the header menu button to show without covering the field title?

May be explicitly specified at the [field level](#attr-listgridfieldleaveheadermenubuttonspace) or at the [grid level](ListGrid_1.md#attr-listgridleaveheadermenubuttonspace). If not explicitly specified space will be left for fields with [ListGridField.align](#attr-listgridfieldalign) set to `"left"` or `"right"`, but not for fields with align set to `"center"`.

### Groups

- headerMenuButton

**Flags**: IWA

---
## Attr: ListGridField.decimalPad

### Description
Applies only to fields of type "float" and enforces a minimum number of digits shown after the decimal point.

For example, a field value of 343.1, 343.104 and 343.09872677 would all be shown as 343.10 if decimalPad is 2.

The original unpadded value is always shown when the value is edited.

### Groups

- appearance

**Flags**: IRW

---
## Attr: ListGridField.filterEditorValueMap

### Description
If this listGrid is showing a filter row, this property can be used to specify a mapping of internal data to/from display values to be in the appropriate filter row form item.

### Groups

- filterEditor

**Flags**: IRW

---
## Attr: ListGridField.dataPath

### Description
dataPath for this field. This property allows the grid to display details of nested data structures in a flat list of columns.

### Groups

- data

**Flags**: IRA

---
## Attr: ListGridField.icon

### Description
Optional icon to show next to the title for this field. Should be set to a URL to an image. Relative paths will be evaluated starting at the imgDir of this component. This URL is partial - it may be updated to indicate the current disabled (etc) state of the field.

If [field.type](#attr-listgridfieldtype) is set to "icon", this icon will also be shown in every cell of this field - see also [field.cellIcon](#attr-listgridfieldcellicon).

To change this property after fields have been passed to [ListGrid.setFields](ListGrid_2.md#method-listgridsetfields), use [ListGrid.setFieldIcon](ListGrid_2.md#method-listgridsetfieldicon).

**Flags**: IR

---
## Method: ListGridField.formatInactiveCellValue

### Description
Field-level formatter for inactive content.

If present, this method will be invoked instead of [ListGridField.formatCellValue](#method-listgridfieldformatcellvalue) in cases where the grid is rendering non-interactive content outside. See [ListGrid.formatInactiveCellValue](ListGrid_2.md#method-listgridformatinactivecellvalue) for more details.

### Parameters

| Name | Type | Optional | Default | Description |
|------|------|----------|---------|-------------|
| value | [Any](#type-any) | false | — | raw value for the cell, from the record for the row |
| record | [ListGridRecord](#type-listgridrecord) | false | — | Record object for the cell. Note: If this is a new row that has not been saved, in an editable grid, it has no associated record object. In this case the edit values will be passed in as this parameter (see [ListGrid.getEditValues](ListGrid_2.md#method-listgridgeteditvalues)) |
| rowNum | [number](#type-number) | false | — | row number for the cell |
| colNum | [number](#type-number) | false | — | column number for the cell. |
| grid | [ListGrid](#type-listgrid) | false | — | the ListGrid displaying the cell |

### Returns

`[HTMLString](../reference.md#type-htmlstring)` — HTML to display in the cell

### See Also

- [ListGrid.formatInactiveCellValue](ListGrid_2.md#method-listgridformatinactivecellvalue)

---
## Method: ListGridField.recordDoubleClick

### Description
Executed when this field is double-clicked. Note that if [ListGrid.recordDoubleClick](ListGrid_2.md#method-listgridrecorddoubleclick) is also defined, it will be fired for fields that define a recordDoubleClick handler if the field-level handler returns true. Return false to prevent the grid-level handler from firing.

### Parameters

| Name | Type | Optional | Default | Description |
|------|------|----------|---------|-------------|
| viewer | [ListGrid](#type-listgrid) | false | — | the listGrid that contains doubleclick event |
| record | [ListGridRecord](#type-listgridrecord) | false | — | the record that was double-clicked |
| recordNum | [number](#type-number) | false | — | number of the record clicked on in the current set of displayed records (starts with 0) |
| field | [ListGridField](#type-listgridfield) | false | — | the field that was clicked on (field definition) |
| fieldNum | [number](#type-number) | false | — | number of the field clicked on in the listGrid.fields array |
| value | [Object](../reference.md#type-object) | false | — | value of the cell (after valueMap, etc. applied) |
| rawValue | [Object](../reference.md#type-object) | false | — | raw value of the cell (before valueMap, etc applied) |

### Returns

`[boolean](../reference.md#type-boolean)` — false to stop event bubbling

### Groups

- events

### See Also

- [ListGrid.recordClick](ListGrid_2.md#method-listgridrecordclick)

---
## Method: ListGridField.formatCellValue

### Description
Return the HTML to display in cells of this field.

Given the raw value for this field as taken from the record Formatter to apply to the static values displayed in cells for this field.

_Example usage_: formatting a currency value stored in cents (so "100" to "$1.00")  
The value passed to this method is the raw value for the cell.  
Takes precedence over `formatCellValue` defined at the grid level for cells in this field.

Note: this formatter will not be applied to the values displayed in cells being edited. The [formatEditorValue()](#method-listgridfieldformateditorvalue) is provided for that purpose.

### Parameters

| Name | Type | Optional | Default | Description |
|------|------|----------|---------|-------------|
| value | [Any](#type-any) | false | — | raw value for the cell, from the record for the row |
| record | [ListGridRecord](#type-listgridrecord) | false | — | Record object for the cell. Note: If this is a new row that has not been saved, in an editable grid, it has no associated record object. In this case the edit values will be passed in as this parameter (see [ListGrid.getEditValues](ListGrid_2.md#method-listgridgeteditvalues)) |
| rowNum | [number](#type-number) | false | — | row number for the cell |
| colNum | [number](#type-number) | false | — | column number for the cell. |
| grid | [ListGrid](#type-listgrid) | false | — | the ListGrid displaying the cell |

### Returns

`[HTMLString](../reference.md#type-htmlstring)` — HTML to display in the cell

### Groups

- display_values

### See Also

- [ListGrid.formatCellValue](ListGrid_2.md#method-listgridformatcellvalue)
- [ListGridField.formatEditorValue](#method-listgridfieldformateditorvalue)

---
## Method: ListGridField.getRecordSummary

### Description
Only applies to ["summary"-type](../reference.md#type-listgridfieldtype) fields. If specified, this method will be called to generate the record summary value to be displayed for each row in this field. When this method is called, current values for other record summary fields have not necessarily been stored on the record, but are accessible via [ListGrid.getRecordSummary](ListGrid_2.md#method-listgridgetrecordsummary).

The grid is passed to be able to evaluate dependency record summary values via ListGrid.getRecordSummary(). Other than that, the properties and state of the grid should not be used in the implementation of this method. To do so would be a source of undefined behavior.

Note that if implemented, this is called instead of making use of the [ListGridField.recordSummaryFunction](#attr-listgridfieldrecordsummaryfunction).

If [ListGrid.showGridSummary](ListGrid_1.md#attr-listgridshowgridsummary) or [ListGrid.showGroupSummary](ListGrid_1.md#attr-listgridshowgroupsummary) is true, this field's value in the summary row\[s\] will still be calculated by calling this method. In this case, the record object passed in will contain summary values for each field. If custom handling is required for this case, it may be detected by checking the record object's [ListGridRecord.isGroupSummary](ListGridRecord.md#attr-listgridrecordisgroupsummary) and [ListGridRecord.isGridSummary](ListGridRecord.md#attr-listgridrecordisgridsummary) attributes.

### Parameters

| Name | Type | Optional | Default | Description |
|------|------|----------|---------|-------------|
| record | [ListGridRecord](#type-listgridrecord) | false | — | record for which a summary is being generated |
| field | [ListGridField](#type-listgridfield) | false | — | this field |
| grid | [ListGrid](#type-listgrid) | false | — | the grid |

### Returns

`[Any](#type-any)` — summary value to display

**Flags**: A

---
## Method: ListGridField.showIf

### Description
An optional [stringMethod](../kb_topics/stringMethods.md#kb-topic-string-methods-overview) which if provided, is evaluated to conditionally determine whether this field should be displayed. Evaluated on initial draw, then reevaluated on explicit calls to `listGrid.refreshFields()` or `listGrid.setFields()`.

Use `[hidden](#attr-listgridfieldhidden):true` or `showIf:"false"` to set a ListGrid field to initially hidden.  
The user will still be able to show the field via a context menu. This may be suppressed by setting [ListGridField.canHide](#attr-listgridfieldcanhide) to false, or by setting [ListGrid.canPickFields](ListGrid_1.md#attr-listgridcanpickfields) to false to suppress the field-picker entirely.

Note that explicit calls to [grid.showField()](ListGrid_2.md#method-listgridshowfield) or hideField() will wipe out the `showIf` expression, as will the end user showing and hiding columns via the [header contextMenu](ListGrid_1.md#attr-listgridshowheadercontextmenu).

Also note that fields marked as [detail:true](DataSourceField.md#attr-datasourcefielddetail) will be hidden by default even if [ListGrid.showDetailFields](ListGrid_1.md#attr-listgridshowdetailfields) is `true`. To show detail fields inherited from a DataSource, include an explicit field definition for the field and set this property to return `true`.

Note that the [ListGridField.visibleWhen](#attr-listgridfieldvisiblewhen) attribute also exists as a criteria-based way to dynamically determine field visibility.

### Parameters

| Name | Type | Optional | Default | Description |
|------|------|----------|---------|-------------|
| list | [ListGrid](#type-listgrid) | false | — | A pointer to the listGrid containing the field |
| field | [ListGridField](#type-listgridfield) | false | — | the ListGridField object |
| fieldNum | [Integer](../reference_2.md#type-integer) | false | — | the index of the field |

### Returns

`[boolean](../reference.md#type-boolean)` — whether the field should be shown

### Groups

- appearance

### See Also

- [ListGrid.refreshFields](ListGrid_2.md#method-listgridrefreshfields)

---
## Method: ListGridField.editorExit

### Description
Callback fired when the user attempts to navigate away from the current edit cell, or complete the current edit.  
Return false from this method to cancel the default behavior (Saving / cancelling the current edit / moving to the next edit cell)

### Parameters

| Name | Type | Optional | Default | Description |
|------|------|----------|---------|-------------|
| editCompletionEvent | [EditCompletionEvent](../reference_2.md#type-editcompletionevent) | false | — | What interaction triggered this edit cell exit |
| record | [ListGridRecord](#type-listgridrecord) | false | — | record for the cell being edited |
| newValue | [Any](#type-any) | false | — | new edit value for the cell being edited. Note that if the user has not made any changes this will be undefined |
| rowNum | [int](../reference.md#type-int) | false | — | row number for the cell |
| colNum | [int](../reference.md#type-int) | false | — | column number of the cell |
| grid | [ListGrid](#type-listgrid) | false | — | ListGrid to which this field belongs |

### Returns

`[boolean](../reference.md#type-boolean)` — Returning false from this method will cancel the default behavior (for example saving the row) and leave the editor visible and focus in this edit cell.

### Groups

- editing

### See Also

- [ListGrid.editorExit](ListGrid_2.md#method-listgrideditorexit)

**Flags**: A

---
## Method: ListGridField.getGridSummary

### Description
If [ListGrid.showGridSummary](ListGrid_1.md#attr-listgridshowgridsummary) is true, and this method is specified it will be called to generate the summary value to be displayed in the grid summary row. Note that this is called instead of making use of the [ListGridField.summaryFunction](#attr-listgridfieldsummaryfunction).

As with [ListGrid.getGridSummary](ListGrid_2.md#method-listgridgetgridsummary) this method may return an array of results - in this case each result will show up in a separate row in the [ListGrid.summaryRow](ListGrid_1.md#attr-listgridsummaryrow) grid.

If this grid is grouped, and [ListGrid.showGroupSummary](ListGrid_1.md#attr-listgridshowgroupsummary) is true, this method will be passed a third parameter - an array of group-level summaries.

### Parameters

| Name | Type | Optional | Default | Description |
|------|------|----------|---------|-------------|
| records | [Array of ListGridRecord](#type-array-of-listgridrecord) | false | — | records for which a summary is being generated |
| field | [ListGridField](#type-listgridfield) | false | — | pointer to the field for which summary value is being generated |
| groupSummaries | [Array of Object](#type-array-of-object) | true | — | If this grid is grouped and [ListGrid.showGridSummary](ListGrid_1.md#attr-listgridshowgridsummary) is specified, this parameter contains an array of already- calculated summary values for each group in the grid. Each element in this array will be an object containing calculated summary values for each field in the grid, as well as a specified groupValue and groupName, allowing the developer to determine which group this summary value comes from |

### Returns

`[Any](#type-any)` — summary value to display.

**Flags**: A

---
## Method: ListGridField.recordClick

### Description
Executed when this field is clicked on. Note that if [ListGrid.recordClick](ListGrid_2.md#method-listgridrecordclick) is also defined, it will be fired for fields that define a recordClick handler if the field-level handler returns true. Return false to prevent the grid-level handler from firing.

### Parameters

| Name | Type | Optional | Default | Description |
|------|------|----------|---------|-------------|
| viewer | [ListGrid](#type-listgrid) | false | — | the listGrid that contains the click event |
| record | [ListGridRecord](#type-listgridrecord) | false | — | the record that was clicked on |
| recordNum | [number](#type-number) | false | — | number of the record clicked on in the current set of displayed records (starts with 0) |
| field | [ListGridField](#type-listgridfield) | false | — | the field that was clicked on (field definition) |
| fieldNum | [number](#type-number) | false | — | number of the field clicked on in the listGrid.fields array |
| value | [Any](#type-any) | false | — | value of the cell (after valueMap, etc. applied) |
| rawValue | [Any](#type-any) | false | — | raw value of the cell (before valueMap, etc applied) |
| editedRecord | [ListGridRecord](#type-listgridrecord) | false | — | the clicked record with any unsaved edit values overlaid (see `listGrid.getEditedRecord()`). |

### Returns

`[boolean](../reference.md#type-boolean)` — false to stop event bubbling

### Groups

- events

### See Also

- [ListGrid.recordClick](ListGrid_2.md#method-listgridrecordclick)

---
## Method: ListGridField.getEditorValueMap

### Description
Optional stringMethod to get a [ListGridField.valueMap](#attr-listgridfieldvaluemap) for a specific field. If present this method will be called from [ListGrid.getEditorValueMap](ListGrid_2.md#method-listgridgeteditorvaluemap) and the resulting valueMap will be used instead of any static specified valueMap for the field.

### Parameters

| Name | Type | Optional | Default | Description |
|------|------|----------|---------|-------------|
| values | [Object](../reference.md#type-object) | false | — | Field values for record being edited. Note that this will include the current edit values for fields that have not yet been saved. May be null, if editing a new record. |
| field | [ListGridField](#type-listgridfield) | false | — | pointer to the listGridField |
| grid | [ListGrid](#type-listgrid) | false | — | pointer back to this ListGrid instance. |

### Returns

`[ValueMap](../reference_2.md#type-valuemap)` — ValueMap for the field (or null if no valueMap required)

---
## Method: ListGridField.getFieldTitle

### Description
If your derivation of the field title is more complex than specifying a static string, you can specify a getFieldTitle() method on your field to return the title string. Otherwise you can use the [ListGridField.title](#attr-listgridfieldtitle) attribute on the field to specify the title.

### Parameters

| Name | Type | Optional | Default | Description |
|------|------|----------|---------|-------------|
| viewer | [ListGrid](#type-listgrid) | false | — | pointer back to the ListGrid |
| fieldNum | [number](#type-number) | false | — | index of this field in the grid's fields array. |

### Returns

`[HTMLString](../reference.md#type-htmlstring)` — Field title.

### Groups

- appearance

### See Also

- [ListGridField.title](#attr-listgridfieldtitle)

---
## Method: ListGridField.getGroupSummary

### Description
If [ListGrid.showGroupSummary](ListGrid_1.md#attr-listgridshowgroupsummary) is true, and this method is specified it will be called to generate the field summary value to be displayed for each group level summary row. Note that this is called instead of making use of the [ListGridField.summaryFunction](#attr-listgridfieldsummaryfunction).

This method may return an array of results - in this case the group will show multiple summary rows, with each entry in the array showing up in a different record.

### Parameters

| Name | Type | Optional | Default | Description |
|------|------|----------|---------|-------------|
| records | [Array of ListGridRecord](#type-array-of-listgridrecord) | false | — | records for which a summary is being generated (so all records in the group). |
| field | [ListGridField](#type-listgridfield) | false | — | pointer to the field for which summary value is being generated |
| groupNode | [Object](../reference.md#type-object) | true | — | object with specified groupValue and groupName for this group |

### Returns

`[Any](#type-any)` — summary value to display

**Flags**: A

---
## Method: ListGridField.defaultDynamicValue

### Description
[FormItem.defaultDynamicValue](FormItem.md#method-formitemdefaultdynamicvalue) to be applied to the cell editor for this field when [editing](#attr-listgridfieldcanedit).

Note that editors are only generated for fields that are actually written out, and as such `defaultDynamicValue` will not apply to [hidden fields](#attr-listgridfieldhidden), or fields that are not drawn due to [incremental column rendering](ListGrid_1.md#attr-listgridshowallcolumns).

To apply arbitrary default values to the grid when editing new records, developers may use the [newValues parameter of startEditingNew()](ListGrid_2.md#method-listgridstarteditingnew).

### Parameters

| Name | Type | Optional | Default | Description |
|------|------|----------|---------|-------------|
| item | [FormItem](#type-formitem) | false | — | The editor for the cell itself (also available as "this"). Note that in addition to the standard FormItem APIs available on the editor, it also has:  
\- a pointer back to the containing listGrid \[`item.grid`\]  
\- the colNum being edited \[`item.colNum`\]  
\- the rowNum being edited \[`item.rowNum`\] |
| form | [DynamicForm](#type-dynamicform) | false | — | the managing DynamicForm instance |
| values | [Object](../reference.md#type-object) | false | — | the current set of values for the form as a whole |

### Returns

`[Any](#type-any)` — dynamically calculated default value for this field's edit item.

### Groups

- editing

---
## Method: ListGridField.cellChanged

### Description
Callback fired when field changes value as the result of a cell edit. Fired only on successful save of edit, when the new value doesn't match the value before editing.  

Same signature as [ListGrid.cellChanged](ListGrid_2.md#method-listgridcellchanged), but defined on a per-field basis.

### Parameters

| Name | Type | Optional | Default | Description |
|------|------|----------|---------|-------------|
| record | [ListGridRecord](#type-listgridrecord) | false | — | record for the cell being changed |
| newValue | [Any](#type-any) | false | — | new value for the cell |
| oldValue | [Any](#type-any) | false | — | old value for the cell |
| rowNum | [number](#type-number) | false | — | row number for the cell |
| colNum | [number](#type-number) | false | — | column number of the cell |
| grid | [ListGrid](#type-listgrid) | false | — | grid where cell was changed. |

### Groups

- editing

### See Also

- [ListGrid.cellChanged](ListGrid_2.md#method-listgridcellchanged)

---
## Method: ListGridField.hoverHTML

### Description
StringMethod override point for returning HTML to be shown in hovers over cells in the column described by this field.

Called only when [canHover](ListGrid_1.md#attr-listgridcanhover) and [showHover](ListGrid_1.md#attr-listgridshowhover) are both true.

The value of "this" within the method will by the [field definition](../reference_2.md#object-listgridfield).

Note that the field described by the column might provide a custom [cellPrompt](#attr-listgridfieldcellprompt) which won't be applied unless you return it from your implementation.

### Parameters

| Name | Type | Optional | Default | Description |
|------|------|----------|---------|-------------|
| record | [ListGridRecord](#type-listgridrecord) | false | — | record being hovered over |
| value | [Any](#type-any) | false | — | value of the cell being hovered over |
| rowNum | [number](#type-number) | false | — | row number where hover occurred |
| colNum | [number](#type-number) | false | — | column number where hover occurred |
| grid | [ListGrid](#type-listgrid) | false | — | ListGrid this field is a part of |

### Returns

`[HTMLString](../reference.md#type-htmlstring)` — HTML to show in the hover

### Groups

- hovers

---
## Method: ListGridField.formatEditorValue

### Description
Return the value to display in cells of this field which are being edited.

_Example usage_: converting a stored value in cents (100) to a dollar-and-cents value in the editor (1.00)

The value passed to this method is the raw value for the cell.

`formatEditorValue` takes precedence over [ListGrid.formatEditorValue](ListGrid_2.md#method-listgridformateditorvalue) defined at the grid level for cells in this field.

To convert the formatted value displayed within an editor back to a raw value, implement [ListGridField.parseEditorValue](#method-listgridfieldparseeditorvalue) as well.

### Parameters

| Name | Type | Optional | Default | Description |
|------|------|----------|---------|-------------|
| value | [Any](#type-any) | false | — | raw value for the cell being edited |
| record | [ListGridRecord](#type-listgridrecord) | false | — | Record object for the cell. Note: If this is a new row that has not been saved, in an editable grid, it has no associated record object. In this case the edit values will be passed in as this parameter. |
| rowNum | [number](#type-number) | false | — | row number for the cell |
| colNum | [number](#type-number) | false | — | column number for the cell. |
| grid | [ListGrid Instance](#type-listgrid-instance) | false | — | A pointer to the ListGrid displaying the cell |

### Returns

`[Any](#type-any)` — formatted value to display in the editor

### Groups

- editing

### See Also

- [ListGridField.formatCellValue](#method-listgridfieldformatcellvalue)
- [ListGrid.formatEditorValue](ListGrid_2.md#method-listgridformateditorvalue)
- [ListGridField.parseEditorValue](#method-listgridfieldparseeditorvalue)

---
## Method: ListGridField.getGroupTitle

### Description
Return the title that should be shown to the user for the group with the `groupValue` passed as a parameter.

Default title is the groupValue itself.

### Parameters

| Name | Type | Optional | Default | Description |
|------|------|----------|---------|-------------|
| groupValue | [Any](#type-any) | false | — | the value from the group is created, the result of [ListGridField.getGroupValue](#method-listgridfieldgetgroupvalue) |
| groupNode | [GroupNode](#type-groupnode) | false | — | the node in the grid containing the group. |
| field | [Object](../reference.md#type-object) | false | — | Field object for which to get group value |
| fieldName | [String](#type-string) | false | — | The name of the field |
| grid | [ListGrid](#type-listgrid) | false | — | the ListGrid displaying the cell |

### Returns

`[Any](#type-any)` — Group value to which this record belongs

### Groups

- grouping

### See Also

- [ListGrid.groupBy](ListGrid_2.md#method-listgridgroupby)
- [ListGridField.getGroupValue](#method-listgridfieldgetgroupvalue)

---
## Method: ListGridField.sortNormalizer

### Description
Optional function to return the value that should be used when sorting this field.

Note that, if the dataset exceeds [ListGrid.dataPageSize](ListGrid_1.md#attr-listgriddatapagesize) and hence paging is introduced, the grid relies on the server to provide sorting, and the sortNormalizer will no longer be called.

For custom sort orders that can be executed both client and server, consider [DataSourceField.sortByField](DataSourceField.md#attr-datasourcefieldsortbyfield).

### Parameters

| Name | Type | Optional | Default | Description |
|------|------|----------|---------|-------------|
| recordObject | [Object](../reference.md#type-object) | false | — | record to normalize |
| fieldName | [String](#type-string) | false | — | name of the field on which sorting occurred |
| context | [ListGrid](#type-listgrid) | false | — | A pointer back to the list grid displaying this field will be available as the `context` argument. Note that you can also get a pointer to the field definition object by calling `context.getFieldByName(fieldName)` |

### Returns

`[Any](#type-any)` — normalized value for sorting

### Groups

- sorting

**Flags**: A

---
## Method: ListGridField.parseEditorValue

### Description
Method used to convert the value displayed in an editor for some cell in this field into a raw value for saving.  
Takes precedence over `parseEditorValue` defined at the grid level.

### Parameters

| Name | Type | Optional | Default | Description |
|------|------|----------|---------|-------------|
| value | [Any](#type-any) | false | — | value displayed in the editor for the cell |
| record | [Object](../reference.md#type-object) | false | — | record object for the row being edited. May be null if this is a new row being added to the end of the list. |
| rowNum | [number](#type-number) | false | — | row number for the cell |
| colNum | [number](#type-number) | false | — | column number for the cell. |
| grid | [ListGrid Instance](#type-listgrid-instance) | false | — | A pointer to the ListGrid displaying the cell |

### Returns

`[Any](#type-any)` — raw value for the field derived from formatted value in editor

### Groups

- editing

### See Also

- [ListGrid.parseEditorValue](ListGrid_2.md#method-listgridparseeditorvalue)
- [ListGridField.formatEditorValue](#method-listgridfieldformateditorvalue)

---
## Method: ListGridField.getSummaryTitle

### Description
Optional string method to return a long summary title for this field, if a dynamic summary title is required for this field.

### Parameters

| Name | Type | Optional | Default | Description |
|------|------|----------|---------|-------------|
| viewer | [ListGrid](#type-listgrid) | false | — | pointer back to the ListGrid |
| field | [ListGridField](#type-listgridfield) | false | — | pointer to the field object |

### Groups

- appearance

### See Also

- [ListGridField.summaryTitle](#attr-listgridfieldsummarytitle)
- [ListGridField.title](#attr-listgridfieldtitle)

**Deprecated**

**Flags**: A

---
## Method: ListGridField.getAutoFreezePosition

### Description
When a field has [autoFreeze](#attr-listgridfieldautofreeze) set to true, developers can implement this method to indicate where in the frozen-fields array this field should appear.

Some automatically generated fields, such as [rowNumberField](ListGrid_1.md#attr-listgridrownumberfield), [expansionField](ListGrid_1.md#attr-listgridexpansionfield) and [checkboxField](ListGrid_1.md#attr-listgridcheckboxfield), provide default implementations of this method.

### Returns

`[number](#type-number)` — the index at which this autoFreeze field should appear in the frozen body

### Groups

- frozenFields

---
## Method: ListGridField.change

### Description
If this field is editable, any [change](FormItem.md#method-formitemchange) handler specified on the ListGridField will be passed onto the editors for this field.

Note that if [ListGridField.canToggle](#attr-listgridfieldcantoggle) is true, the user may change the value of a boolean field without going into edit mode by single clicking on the field. In this case the [ListGridField.change](#method-listgridfieldchange) and [ListGridField.changed](#method-listgridfieldchanged) handlers will fire but the `form` and `item` parameters will be null.

### Parameters

| Name | Type | Optional | Default | Description |
|------|------|----------|---------|-------------|
| form | [DynamicForm](#type-dynamicform) | false | — | the managing DynamicForm instance |
| item | [FormItem](#type-formitem) | false | — | the editor (form item) itself (also available as "this"). Note that in addition to the standard FormItem APIs available on the editor, it also has:  
\- a pointer back to the containing listGrid \[`item.grid`\]  
\- the colNum being edited \[`item.colNum`\]  
\- the rowNum being edited \[`item.rowNum`\] |
| value | [Any](#type-any) | false | — | The new value of the form item |
| oldValue | [Any](#type-any) | false | — | The previous value of the form item |

### Returns

`[Boolean](#type-boolean)` — The change may be cancelled by returning false

### Groups

- editing

### See Also

- [ListGridField.changed](#method-listgridfieldchanged)
- [ListGrid.cellChanged](ListGrid_2.md#method-listgridcellchanged)

---
## Method: ListGridField.getGroupValue

### Description
Return the value which records should be grouped by.

All records for which getGroupValue() returns the same value appear in the same group. Default is the result of [ListGrid.getCellValue](ListGrid_2.md#method-listgridgetcellvalue).

While any type of value may be returned, avoiding the use of string values may result in improved performance. In this case, [ListGridField.getGroupTitle](#method-listgridfieldgetgrouptitle) may be implemented to map a numeric group value into a legible string.

### Parameters

| Name | Type | Optional | Default | Description |
|------|------|----------|---------|-------------|
| value | [Any](#type-any) | false | — | raw value for the cell, from the record for the row |
| record | [ListGridRecord](#type-listgridrecord) | false | — | Record object for the cell. Note: If this is a new row that has not been saved, in an editable grid, it has no associated record object. In this case the edit values will be passed in as this parameter (see [ListGrid.getEditValues](ListGrid_2.md#method-listgridgeteditvalues)) |
| field | [Object](../reference.md#type-object) | false | — | Field object for which to get group value |
| fieldName | [String](#type-string) | false | — | The name of the field |
| grid | [ListGrid](#type-listgrid) | false | — | the ListGrid displaying the cell |

### Returns

`[Any](#type-any)` — Group value to which this record belongs

### Groups

- grouping

### See Also

- [ListGrid.groupBy](ListGrid_2.md#method-listgridgroupby)
- [ListGridField.getGroupTitle](#method-listgridfieldgetgrouptitle)

---
## Method: ListGridField.editorEnter

### Description
Callback fired when the user first starts editing a cell.

This callback is typically used to establish dynamic default values via [ListGrid.setEditValue](ListGrid_2.md#method-listgridseteditvalue) or [ListGrid.setEditValues](ListGrid_2.md#method-listgridseteditvalues).

### Parameters

| Name | Type | Optional | Default | Description |
|------|------|----------|---------|-------------|
| record | [ListGridRecord](#type-listgridrecord) | false | — | record for the cell being edited. **Will be null** for a new, unsaved record. |
| value | [Any](#type-any) | false | — | value for the cell being edited |
| rowNum | [int](../reference.md#type-int) | false | — | row number for the cell |
| colNum | [int](../reference.md#type-int) | false | — | column number of the cell |
| grid | [ListGrid](#type-listgrid) | false | — | ListGrid to which this field belongs |

### Groups

- editing

**Flags**: A

---
## Method: ListGridField.changed

### Description
If this field is editable, any [changed](FormItem.md#method-formitemchanged) handler specified on the ListGridField will be passed onto the editors for this field. Note that if [ListGridField.canToggle](#attr-listgridfieldcantoggle) is true, the user may change the value of a boolean field without going into edit mode by single clicking on the field. In this case the [ListGridField.change](#method-listgridfieldchange) and [ListGridField.changed](#method-listgridfieldchanged) handlers will fire but the `form` and `item` parameters will be null.

### Parameters

| Name | Type | Optional | Default | Description |
|------|------|----------|---------|-------------|
| form | [DynamicForm](#type-dynamicform) | false | — | the managing DynamicForm instance |
| item | [FormItem](#type-formitem) | false | — | the editor (form item) itself (also available as "this"). Note that in addition to the standard FormItem APIs available on the editor, it also has:  
\- a pointer back to the containing listGrid \[`item.grid`\]  
\- the colNum being edited \[`item.colNum`\]  
\- the rowNum being edited \[`item.rowNum`\] |
| value | [Any](#type-any) | false | — | The current value (after the change). |

### Groups

- editing

### See Also

- [ListGridField.change](#method-listgridfieldchange)
- [ListGrid.cellChanged](ListGrid_2.md#method-listgridcellchanged)

---
## Method: ListGridField.valueIconClick

### Description
Executed when the user clicks on a [value icon](#attr-listgridfieldvalueicons) within this field. Return false to suppress default behavior of firing [ListGridField.recordClick](#method-listgridfieldrecordclick) handlers, etc.

### Parameters

| Name | Type | Optional | Default | Description |
|------|------|----------|---------|-------------|
| viewer | [ListGrid](#type-listgrid) | false | — | the listGrid that contains the click event |
| record | [ListGridRecord](#type-listgridrecord) | false | — | the record that was clicked on |
| recordNum | [number](#type-number) | false | — | number of the record clicked on in the current set of displayed records (starts with 0) |
| field | [ListGridField](#type-listgridfield) | false | — | the field that was clicked on (field definition) |
| rawValue | [Any](#type-any) | false | — | raw value of the cell (before valueMap, etc applied) |
| editor | [FormItem](#type-formitem) | false | — | If this cell is being [edited](ListGrid_1.md#attr-listgridcanedit), this method will fire when the user clicks the valueIcon on the edit item for the cell, passing in the editor item as the `editor` parameter. If the cell is not being edited, this value will be null. |

### Returns

`[boolean](../reference.md#type-boolean)` — false to stop event bubbling

### Groups

- events

### See Also

- [ListGridField.valueIcons](#attr-listgridfieldvalueicons)

---
