# Writing AutoTests for multiple environments

[← Back to API Index](../reference.md)

---

## KB Topic: Writing AutoTests for multiple environments

### Description
SmartClient has powerful features for integrating with a variety of third party testing tools. See the [Automated Testing overview](automatedTesting.md#kb-topic-automated-testing) for an overview of how to use testing tools with SmartClient.

The [AutoTestLocator](../reference_2.md#type-autotestlocator) system ensures that user interface elements can be reliably identified when recording or playing back tests independently of the DOM structure generated by SmartClient components. Using locators insulates developers from changes to the generated DOM structure due to different SmartClient builds, different browsers and different skins.

See the documentation topic [reliableLocators](reliableLocators.md#kb-topic-generating-reliable-autotestlocators) for best practices with respect to building applications that will generate robust and reliable locators.

The AutoTest system also has some advanced features to facilitate recording and playing back tests across environments with significant differences including:

*   Different data: multiple environments with different data sets (for example, test vs staging vs production)
*   Embedded UI: your application or user interface may be embedded within a larger application or portal
*   Per-User presentation: an application may present the same functionality differently per user. For example if an application has separately licensable modules, the user interface to navigate to some functional area may differ depending on which modules are available to the user
*   Customer customizations: an application may allow users to add additional UI or rearrange screens

**AutoTest variables**

The [variables](../classes/AutoTest.md#classmethod-autotestsetvariable) feature allows developers to specify explicit variable names and corresponding values for use when resolving AutoTest locators.

Variables may be used anywhere within a locator string, but a common use case would be handling different data in different deployments. For example the locator for a ListGrid cell element might be as follows:

`//ListGrid[ID="countryList"]/body/row[pk=47||countryCode=WS||countryName=Western%20Samoa||2]/col[fieldName=countryName||1]`

This locator includes various fallback attributes to identify the row and column (see the [AutoTestLocator overview](../reference_2.md#type-autotestlocator) for information about fallback attributes in locator segments).

If you want to identify the cell by primary key field value and column name only, this could be simplified to be just:

`//ListGrid[ID="countryList"]/body/row[pk=47]/col[fieldName=countryName]`

In a different data set, the equivalent record might have a different primary key field value, meaning any locators that referenced it via hardcoded values like `pk=47` would fail to resolve to the correct target. This can be handled by setting up an AutoTest variable before the test executes - for example recording the target record as `testRecord`, and referring to it directly in the locators:

`//ListGrid[ID="countryList"]/body/row[pk=${testRecord.pk}]/col[fieldName=countryName]`

**AutoTestLocator root**

The [AutoTest.testRoot](../classes/AutoTest.md#classattr-autotesttestroot) attribute allows developers to designate some component as the "root" for an autoTest. With this setting in place, locators for elements anywhere within that root component will be generated as a path from the testRoot to the target component. These locators will always start with the special prefix `//testRoot[]`.

If the same UI elements are then rendered inside another container in a different environment, configuring [AutoTest.testRoot](../classes/AutoTest.md#classattr-autotesttestroot) to point to this container will allow the locators to resolve correctly.

If no global testRoot was specified, any component with an explicit [ID](../classes/Canvas.md#attr-canvasid) will be treated as the root component for the elements it contains. This means that locators for components with explicit IDs will resolve correctly regardless of where these components are in the page's structure.

Components with an explicit ID are located by ID and widget class name by default. You can also set [Canvas.locateByIDOnly](../classes/Canvas.md#attr-canvaslocatebyidonly) - this will cause the generated locator for the component to omit the widget class name altogether and create a very compact locator of the format `///componentID`

---
