# DataSourceField Documentation

[← Back to API Index](../reference.md)

---

## Attr: DataSourceField.autoGenerated

### Description
Indicates that values for this field are automatically generated by the database or ORM provider. Setting this flag makes the field behave somewhat like a [sequence field](#attr-datasourcefieldsequencename), in that server-side logic does not expect client code to provide values for the field on "add" operations. However, it is not entirely the same as a sequence:

*   Sequences must be integers, whereas autoGenerated fields can be of any type
*   SmartClient Server's DataSource implementations are capable of discovering the value that was generated by the database for sequence fields, which may not be possible with an autoGenerated field. See the docs for [customInsertExpression](#attr-datasourcefieldcustominsertexpression) for a discussion of this

Unrelated to the `autoGenerated` flag, you have a general ability for field values to be generated by application code (as opposed to being generated by the database or ORM provider). For example, you can use [DMI methods](../kb_topics/dmiOverview.md#kb-topic-direct-method-invocation), [server scripts](../kb_topics/serverScript.md#kb-topic-server-scripting), or [custom SQL](../kb_topics/customQuerying.md#kb-topic-custom-querying-overview). (Note, if you want to have application code generate values for primaryKey fields, you may need to use an [operationBinding](OperationBinding.md#class-operationbinding) that specifies [providesMissingKeys](OperationBinding.md#attr-operationbindingprovidesmissingkeys)).

### Groups

- dataType

### See Also

- [DataSourceField.sequenceName](#attr-datasourcefieldsequencename)
- [FieldType](../reference_2.md#type-fieldtype)
- [SequenceMode](../reference.md#type-sequencemode)

**Flags**: IR

---
## Attr: DataSourceField.canSortClientOnly

### Description
When true, this field can only be used for sorting if the data is entirely client-side.

**Flags**: IRW

---
## Attr: DataSourceField.columnCode

### Description
See [DataSource.tableCode](DataSource.md#attr-datasourcetablecode).

**Flags**: R

---
## Attr: DataSourceField.valueMap

### Description
A [ValueMap](../reference_2.md#type-valuemap) is a set of legal values for a field.

The valueMap can be specified as either an Array of legal values, or as an [Object](../reference.md#type-object) where each property maps a stored value to a user-displayable value.

To enforce that a field should be constrained to only the values in the valueMap, either declare [field.type](#attr-datasourcefieldtype) as "enum", or use a [ValidatorType](../reference.md#type-validatortype) of "isOneOf" with explicitly listed values. Otherwise, although a normal [SelectItem](SelectItem.md#class-selectitem) control will only allow values from the valueMap to be entered, other controls such as a [ComboBox](ComboBoxItem.md#class-comboboxitem) will allow other values to be entered.

In XML, a valueMap that specifies only a list of legal values is specified as follows:

```
   <valueMap>
   	<value>Pens & Pencils</value>
   	<value>Stationery</value>
   	<value>Computer Products</value>
   	<value>Furniture</value>
   	<value>Misc</value>
   </valueMap>
 
```
A ValueMap that specifies stored values mapped to user-visible values is specified as follows:
```
   <valueMap>
   	<value ID="1">Pens & Pencils</value>
   	<value ID="2">Stationery</value>
   	<value ID="3">Computer Products</value>
   	<value ID="4">Furniture</value>
   	<value ID="5">Misc</value>
   </valueMap>
 
```

### Groups

- dataType

**Flags**: IR

---
## Attr: DataSourceField.initRequiresAuthentication

### Description
Whether a user must be authenticated in order to initialize to this field. If this property is set and the user is not authenticated, the SmartClient Server will not allow this field to be initialized.

### Groups

- fieldLevelAuth
- declarativeSecurity

### See Also

- [DataSourceField.editRequiresAuthentication](#attr-datasourcefieldeditrequiresauthentication)

**Flags**: IR

---
## Attr: DataSourceField.includeFrom

### Description
Indicates that this field should be fetched from another, related DataSource.

The `includeFrom` attribute should be of the form "_dataSourceId_._fieldName_", for example:

```
    <field includeFrom="supplyItem.itemName"/>
 
```

A [DataSourceField.foreignKey](#attr-datasourcefieldforeignkey) declaration must exist between the two DataSources, establishing either a 1-to-1 relationship or a many-to-1 relationship from this DataSource to the related DataSource. The inclusion can be indirect (traverse multiple DataSources) so long as there is a chain of `foreignKey` declarations from the target DataSource to the DataSource where the `includeFrom` field is declared. You may use dot-notation to provide an explicit path between DataSources, or provide the name of only the last DataSource in the chain to have the complete path calculated for you at runtime. i.e., either of the following are acceptable forms, where foreign keys are defined to link records in the current DataSource to Employee records and in turn to Office records:

```
   <field includeFrom="Employee.Office.territory"/>
   <!-- OR -->
   <field includeFrom="Office.territory"/>
 
```
Note that when using the shorthand form, there is potential ambiguity: there could be multiple ways in which two DataSources are related via different intervening DataSources, so the auto-discovered relation may be different depending on which other DataSources are loaded in the page. For this reason, explicitly spelling out the inclusion path is preferred.

Nested inclusions, where an included field is itself an included field, are also supported - for details on this and other complex scenarios see [DataSourceField.includeVia](#attr-datasourcefieldincludevia) docs.

In all cases, [DataSourceField.name](#attr-datasourcefieldname) will default to the name of the included field, or you can specify a different name.

If both DataSources are SQLDataSources, HibernateDataSources or JPADataSources (with Hibernate as the provider) the related data will be retrieved via a SQL join and criteria and sort directions applied to the field work normally (they become part of the generated SQL query).

Note that includeFrom is also supported between two clientOnly or MockDataSources, but not for any other combination (for example, a RestDataSource cannot use includeFrom with a clientOnly DataSource). Here, the related data (including any values derived via [DataSourceField.includeSummaryFunction](#attr-datasourcefieldincludesummaryfunction)) will be retrieved from cacheData after the primary (fetch, add, or update) operation has returned its response.

Otherwise, the related data will be retrieved via performing a DSRequest against the related DataSource once the data from the primary DataSource has been retrieved. In this case, criteria or sorting directions applied to the included field are only allowed if data paging is not in use (for example [ListGrid.dataFetchMode](ListGrid_1.md#attr-listgriddatafetchmode):"basic"); otherwise, criteria and sort direction are ignored for the included field and a warning is logged on the server.

**Editing included fields**

An included field is [canEdit:false](#attr-datasourcefieldcanedit) by default. Note that included fields are not updatable, even if you set canEdit:true; the server will simply drop values for included fields if client code sends them.

When thinking about editing an included field value, typically what is really intended is to edit the value of the `foreignKey` field. For example, take the scenario of a system that tracks accounts and the employees assigned to manage them. Given a DataSource "account" related one-to-one with DataSource "employee" by a "managerId" foreignKey field, we might declare an `includeFrom` so that the name of the account manager can be shown with each "account" record.

Editing the manager's name while viewing the account would be intended to pick a new account manager, and **not** to change the legal name of the employee who happens to be the current account manager.

To correctly set up this scenario, declare an `includeFrom` field that is hidden, but is used as the [displayField](#attr-datasourcefielddisplayfield) for the foreign key field:

```
 <field name="managerId" foreignKey="employee.id" displayField="managerName" /> 
 <field name="managerName" includeFrom="employee.name" hidden="true"/> 
 
```
Now:

*   the "managerId" foreignKey field is shown in grids and forms, but takes its displayed value from the hidden `includeFrom` field. Note that when the `foreignKey` and `displayField` are specified, the framework automatically defaults [DataSourceField.useLocalDisplayFieldValue](#attr-datasourcefielduselocaldisplayfieldvalue) to true to ensure the displayed value is picked up from the record being edited.
*   the automatically chosen editor will be a SelectItem with [optionDataSource](SelectItem.md#attr-selectitemoptiondatasource) set to "employees": it will allow picking a different "employee" record from the "employee" DataSource.
*   saving will save the ID of a new "employee" record to the "managerId" foreign key field, as intended

You can alternatively set `editorType="ComboBoxItem"` on the "managerId" field to allow typeahead search of the "employee" DataSource. Note that the [DataSourceField.foreignDisplayField](#attr-datasourcefieldforeigndisplayfield) attribute allows developers to have a different fieldName be used locally as a displayField from the field name for the display field in the foreign dataSource.

**Including fields that use summary functions**

The [Include Summary Function](#attr-datasourcefieldincludesummaryfunction) feature is used for including from a related DataSource where there are multiple related records. It applies a [SummaryFunction](../reference_2.md#type-summaryfunction) to the related records aggregating them into single value. It is regularly used on directly included fields, but it supports indirect inclusions as well, when entire `includeFrom`+`includeSummaryFunction` setup is included from another DataSource. See [DataSourceField.includeSummaryFunction](#attr-datasourcefieldincludesummaryfunction) docs for more details.

For best results, ensure that the field with `includeFrom` has its [DataSourceField.type](#attr-datasourcefieldtype) explicitly set to the included field's `type`.

**`includeFrom` combined with `[multiple](#attr-datasourcefieldmultiple):true`**

If you specify `[multiple](#attr-datasourcefieldmultiple):true` on an `includeFrom` field, it has one of two quite different meanings:

1.  It is including a field which is itself marked `multiple:true`, across a regular many-to-one or one-to-one [relation](../kb_topics/dataSourceRelations.md#kb-topic-relations). In this case, the value of the included field is likely to be a flattened list of text values stored in a regular text field - see [DataSourceField.multipleStorage](#attr-datasourcefieldmultiplestorage)
2.  It is including multiple related values across a one-to-many or many-to-many relation

The first of these is exactly the same as any other regular `includeFrom`, except that it will have normal `multiple:true` processing applied to the included value, so the client sees a true list of values rather than a flat string of text.

The second is more involved. With this type of `includeFrom` we will actually fetch multiple records from the included DataSource. You should read the **One-to-many** and **Many-to-many** sections of the [relations overview](../kb_topics/dataSourceRelations.md#kb-topic-relations) to make sure you understand how these relation types work, but essentially you declare a [foreignKey](#attr-datasourcefieldforeignkey) on a field that is also marked `multiple:true`, and this causes SmartClient to return a list of key values that your client-side code can use to obtain the related records (some SmartClient UI components will do this automatically).

Once one of these relation types is in place, it is also possible to declare `includeFrom` fields that make use of the relation to include fields other than the identifying key field, for convenience. For example, if a **Country** dataSource declared a one-to-many relation to a **City** dataSource, like this:

```
     <field name="majorCities" multiple="true" foreignKey="City.cityId" />
 
```
The same dataSource could make use of that relation to include the names of all related cities for convenience, so you can show a list of "Major Cities" against each country without having to go back to the server and fetch the actual City records. The declaration would look like this:
```
     <field name="cityNames" multiple="true" includeFrom="City.cityName" />
 
```
With **Many-to-many** related includeFroms - which require a "middle" dataSource, and thus a three-part `foreignKey` declaration - you may specify either the entire inclusion path, or just the endpoint. For example, if your **Country** dataSource has a many-to-many relation with a **River** dataSource - necessary, because most countries contain more than one river, and many rivers flow through more than one country - via the following `foreignKey` definition:
```
     <field name="rivers" multiple="true" foreignKey="CountryRivers.Rivers.riverId" />
 
```
you could `includeFrom` the list of related river names with either this:
```
     <field name="riverNames" multiple="true" includeFrom="CountryRivers.Rivers.name" />
 
```
or slightly simpler, this:
```
     <field name="riverNames" multiple="true" includeFrom="Rivers.name" />
 
```
If just the endpoint is specified, SmartClient will figure out the remainder of the path based on the available `foreignKey`s; if there is ambiguity that makes this impossible - ie, two `foreignKey` fields that target the same endpoint via different paths - you can either specify the entire include path in the `includeFrom` definition, or declare an [includeVia](#attr-datasourcefieldincludevia) setting on the field.

### Groups

- dataSourceRelations

**Flags**: IR

---
## Attr: DataSourceField.relatedTableAlias

### Description
For a [SQL DataSource](../kb_topics/sqlDataSource.md#kb-topic-sql-datasources) field that specifies a [foreignKey](#attr-datasourcefieldforeignkey), this property defines the table alias name to use in generated SQL.

Aliasing is necessary when the same table appears more than once in a query. This can happen when using [Multiple `includeFrom` \\n fields referring to the same related DataSource](#attr-datasourcefieldincludevia). It can also happen when a [foreignKey](#attr-datasourcefieldforeignkey) definition references the same dataSource that the field is defined in; this happens with hierarchical structures, for example where every Employee reports to another Employee, a so-called "self join", and it _always_ requires `relatedTableAlias` to be specified; failure to do so will result in invalid SQL.

In case of indirect relationship, when more than single join is needed to join the target table, and [includeVia](#attr-datasourcefieldincludevia) is missing, generated alias is a concatenation of `relatedTableAlias` and FK field names starting with the first `relatedTableAlias` met in chain of relations leading to the target table.

See the "Automatically generated table aliases" section of the [SQL Templating](../kb_topics/customQuerying.md#kb-topic-custom-querying-overview) for more details.

### Groups

- dataSourceRelations

### See Also

- [DataSource.relatedTableAlias](DataSource.md#attr-datasourcerelatedtablealias)
- [DataSourceField.includeVia](#attr-datasourcefieldincludevia)

**Flags**: IR

---
## Attr: DataSourceField.required

### Description
Indicates this field must be non-null in order for a record to pass validation. Or, in the case of a "binary" field, a non-empty file must be uploaded. Setting this property has the same effect as giving the field a ["required" validator](../reference.md#type-validatortype).

Note that `required` should not be set for a server-generated field, such as a sequence, or validation will fail on the client.

#### Conditionally required fields
Adding an [applyWhen](Validator.md#attr-validatorapplywhen) condition to a `required` validator introduces subtle complexities to the process of validating an existing record. The client is not guaranteed to know the full and complete state of the record it is editing because it is common for a [DynamicForm](DynamicForm.md#class-dynamicform) to be editing a subset of fields. When a field is _unconditionally_ required, things are simple: if the DynamicForm has a [FormItem](FormItem.md#class-formitem) for that field, then the `required` validation passes if that FormItem has a value, and fails if it does not. If the form has no FormItem for the field, it can assume that the field has a value because otherwise it would have failed validation when we attempted to add it (when we are adding a record, we of course do know the full and complete state of the record - it is whatever we are about to add).

When a field is _conditionally_ required, the client can no longer assume that all required fields will have a value. It may be the case that the condition of requirement was not met when the record was added, but now it is. For example, consider these field definitions:

```
    <field name="yearsAtCurrentAddress" type="integer" />
    <field name="previousAddress" type="text" >
      <validator type="required" errorMessage="Previous address is required if you have been at your current address less than three years">
        <applyWhen operator="and">
          <criteria>
            <criterion fieldName="yearsAtCurrentAddress" operator="lessThan" value="3" />
          </criteria>
        </applyWhen>
      </validator>
    </field>
 
```
Imagine a record for this DataSource is added where the user has entered a value of "3" for "yearsAtCurrentAddress", and no previous address. Later, the value of that field is changed to "2". If this is done using a form that is also showing the "previousAddress" field, we will know that "previousAddress" has not been provided, so we can fail the validation and the user will get a helpful error message explaining what the problem is.

However, if the form does not also show the "previousAddress" field, we may choose to use an [OperationBinding](OperationBinding.md#class-operationbinding) that uses [outputs](OperationBinding.md#attr-operationbindingoutputs) to trim the record down to just the fields the form does contain, in the interests of avoiding information leakage. Or perhaps that value is automatically culled from the record before the client sees it by the application of a [declarative security rule](#attr-datasourcefieldviewrequires). Whatever the reason, if the client does not have the complete record, it is not possible for the client to sensibly apply this validation. And because the client has no way of knowing if a value is missing because it is genuinely null, or because it has been trimmed away by the server, we must treat any null value with suspicion (unless it has a matching FormItem - the presence of the FormItem means that the user can edit the value, so it would make no sense to pair it with a trimmed record that excludes that field value).

When this happens, we mark the validation as having passed on the client, but in need of running on the server. The server validation makes use of the "storedRecord" facility (look for the description of **$storedRecord** in the [Velocity support overview](../kb_topics/velocitySupport.md#kb-topic-velocity-context-variables)) to overlay the changed record on top of the existing record as it currently exists in the database. This gives the validator the complete record including both changed and unchanged values, so it is able to carry out the required check in a meaningful way. However, you should be aware that the combination of conditional "required" validators and DynamicForms that edit partial records can result in a validation that cannot run on the client and must do both a server roundtrip and a database fetch.

### Groups

- dataType

### See Also

- [Validator.applyWhen](Validator.md#attr-validatorapplywhen)

**Flags**: IR

---
## Attr: DataSourceField.sequenceName

### Description
For a DataSource with [serverType:"sql"](DataSource.md#attr-datasourceservertype) with a field of type "sequence", the name of the SQL sequence that should be used when inserting new records into this table.

Note that this is never required for SQL tables that are generated from SmartClient DataSources (a default sequence name of tableName + "\_" + columnName is chosen, but see the notes below regarding this), and is never required for databases where inserting null into a sequence column is sufficient (MySQL, SQL Server, DB2 and others).

You would only need to set sequenceName if you are integrating with a pre-existing table stored in a database where the sequence must be named for insertion to work (Oracle, Postgres, Firebird) OR you are trying to use the same sequence across multiple DataSources.

**Note:** If you specify the `sql.{database type}.sequence.name.prefix` and/or `sql.{database type}.sequence.name.suffix` properties in your [server.properties](../kb_topics/server_properties.md#kb-topic-serverproperties-file) file,the generated sequence name will include the prefix and/or suffix. For example, with a prefix of "order\_system\_" and a suffix of "\_seq", the sequence generated for column "orderNumber" on table "orders" would be:

```
     order_system_orders_orderNumber_seq
 
```

### Groups

- sqlDataSource

**Flags**: IR

---
## Attr: DataSourceField.escapeHTML

### Description
When data values are displayed in DataBound components, by default strings will be interpreted as HTML by the browser in most cases.

If set, this property will be picked up by components bound to this dataSource, notifying them that any HTML characters should be escaped when displaying values for this field.

### See Also

- [ListGridField.escapeHTML](ListGridField.md#attr-listgridfieldescapehtml)

**Flags**: IR

---
## Attr: DataSourceField.updateRequiresAuthentication

### Description
Whether a user must be authenticated in order to update to this field. If this property is set and the user is not authenticated, the SmartClient Server will not allow this field to be updated.

### Groups

- fieldLevelAuth
- declarativeSecurity

### See Also

- [DataSourceField.editRequiresAuthentication](#attr-datasourcefieldeditrequiresauthentication)

**Flags**: IR

---
## Attr: DataSourceField.exportFormat

### Description
An optional [FormatString](../reference.md#type-formatstring) for this field, for use when [exporting](DataBoundComponent.md#method-databoundcomponentexportdata) data to spreadsheet formats (XLS and OOXML/XLSX), XML, JSON or CSV. You can use this property to override the normal [format](#attr-datasourcefieldformat) of this field, if any, specifically for exports, for both server-based and client-driven exports.

Note, for server-driven exports you can specify default formats for date, time and datetime fields by specifying properties `export.format.default.date`, `export.format.default.time` and `export.format.default.datetime` in your `server.properties` file. Similarly, default formats for float and integer fields can be specified with `export.format.default.float` and `export.format.default.integer`, respectively. These formats will be used for fields that do not have a "format" or "exportFormat" property specified in the `.ds.xml` file.

Specifically when exporting to spreadsheet formats, the `FormatString` is translated to the type of format string used by spreadsheet programs like Excel. A handful of features are not present in Excel format strings, and some features behave slightly differently. These differences are explained below.

#### Excel cannot handle dates prior to January 1st 1900
This is a well-known limitation of Excel dates; it is not a formatting issue as such.

#### Currency symbols become fixed to the current locale at export time
The placeholder currency symbol "¤" (\\u00A4) in a numeric format string is rendered as the [localized currency symbol](NumberUtil.md#classattr-numberutilcurrencysymbol). When exporting, the format string provided to Excel contains the currency symbol for the current locale of the SmartClient application, and not a placeholder currency symbol that would make Excel pick up a currency symbol based on the operating system locale. We do this to ensure that the spreadsheet reflects the _application's_ localization, rather than the localization of the current user's computer, because they may be different.

#### Rounding differences
The approach to rounding a positive number to a set number of decimal places is fairly universally agreed upon for non-specialized requirements: add 0.5 (or 0.05, or 0.005, or whatever) to the number and then truncate. This leads to the well understood convention that numbers exactly halfway between two possible rounding outcomes, go to the larger one. So 7.5 becomes 8 and 7.15 becomes 7.2.

However, there is no such universal agreement when it come to rounding negative numbers. Some take the view that you should round by taking the number to the larger absolute value, so -7.15 becomes -7.2. Others feel that you should round by taking the number to the larger value in the sense of it being "less negative", so -7.15 becomes -7.1.

SmartClient formatting takes the first approach and rounds negative numbers away from zero. We do this simply because that is what Java DecimalFormat does. Unfortunately, Excel does the opposite. Therefore, you will see rounding differences on negative numbers on exact 50% boundaries: SmartClient will format -7.15 as -7.2, while Excel will format the same value as -7.1.

#### Different treatment of '#'
Both SmartClient and Excel use '#' to mean "digit, do not show zeroes". However, Excel does not implement this strictly in the integer part when the number it is formatting has a value of 0 in the integer part. So, with a format of "#.##", the value 0.25 is formatted as "0.25". SmartClient (like Java DecimalFormat) is strict: with that format, 0.25 is formatted as ".25"; if you want to match Excel's output, you must use the format "0.##".

#### Miscellaneous edge cases
There is quite a lot of variation in behavior between Java DecimalFormat and Excel around the edges. For actual error cases - for example, a format string that just contains nonsense - it is normal and expected that the SmartClient behavior and the Excel behavior do not match - this is just two systems producing different garbage out for the same garbage in, which is to be expected. For valid but weird usages - for example, a format with multiple percent signs - SmartClient's formatting is in line with what DecimalFormat does, unless DecimalFormat throws an Exception, in which case we just do the thing that seems most sensible, or the thing that was easiest to implement.

Known differences in behavior in edge cases include:

*   SmartClient ignores formatting characters in the number part of the format string, whereas Excel rejects the format (this behavior may vary with different releases of Excel and supposedly compatible libraries: POI, for example, will accept such format strings). If you attempt to format 5.175 with the format string "#b0.#a#", SmartClient will return "5.72", and Excel will reject the format
*   SmartClient ignores quoted characters in the number part of the format string, whereas Excel preserves them. If you attempt to format 5.175 with the format string "#'b'0.#'a'#", SmartClient will return "5.72", and Excel will return "b5.7a2"
*   If you specify the empty string as a format string, SmartClient returns the result of calling toString() on the number; Excel uses the built-in "General" format. These two approaches will generally give the same or very similar results, but that is really a coincidence: the correct way to obtain matching results in the browser and the spreadsheet is to specify a valid format string
*   If you specify a format string that contains no number part (ie, no '#' or '0' characters), SmartClient does what DecimalFormat does, which is to output the integer part of the number alongside the fixed part of the format. Excel just outputs the fixed part. So, if you attempt to format -5.3 with the format string "'Hello world'", SmartClient will output "-Hello world5", whereas Excel will output just "Hello world"
*   If you specify multiple percent signs in the format, SmartClient treats all but the first one as static text, so 0.5 formatted with "#%%%" is "50%%%" (ie, all the signs are preserved but there is only one multiplcation by 100). Excel multiplies for each percent sign, so 0.5 formatted with "#%%%" is "500000%%%"

#### Date format functionality not supported by Excel
The following date/time/datetime functionality is not supported by Excel; if you use formatters that use any of this functionality, your values will be exported to Excel incorrectly formatted. In cases like this, we recommend that you use a separate `exportFormat`, with the intent of exporting your values in a way that is similar to your application formatting (which would be specified with the [format](#attr-datasourcefieldformat) property), but within the confines of what Excel supports.

*   Fiscal year, week and day (LL, LLLL, C, CC, c, cc)
*   Week in year (w, ww)
*   Day in year (D, DD)
*   Day number in week (u)
*   Explicit control over whether to use 12- or 24-hour notation. In Excel, this is implied by the presence or absence of the AM/PM designator
*   If the user's operating system locale is different to the locale in use in the SmartClient application, day and month names may be different in the spreadsheet

#### Number format functionality not supported by Excel
The only SmartClient number-formatting functionality not supported for export to Excel is "multiply by 1000 and show as per mille".

#### Limit on number of custom Excel formats
Excel limits the number of custom format strings in a single spreadsheet to somewhere between 200 and 250, depending on your locale and language. Hitting this limit in an export would require hundreds of field definitions, each defining unique `FormatStrings`. If you do hit the limit, the only workaround is to use fewer unique `FormatStrings`.

#### Controlling number format
If we give Excel a formatted number like "500,000" it will not treat that value as a number, so sums and other basic spreadsheet features won't work. So we use the heuristic that if your formatted value parses as a number, you probably want it treated as a number in the spreadsheet, so we give Excel the unformatted numeric value and tell Excel it's a numeric data value.

You might expect that we would give Excel _both_ the formatted value and the numeric value, but this is only possible by creating what's called a "custom format" for that cell, which as the section above mentions, is limited in that only a few hundred can be created.

With this Excel limitation in mind, it makes sense to just go with the default behavior. If you decide otherwise, one option is to use [exportNumbersAsFormattedString](DSRequest.md#attr-dsrequestexportnumbersasformattedstring), but see the docs for that property for the drawbacks of doing this.

### See Also

- [DataSourceField.format](#attr-datasourcefieldformat)

**Flags**: IRW

---
## Attr: DataSourceField.description

### Description
An optional description of the DataSourceField's meaning. It is not automatically exposed on any component, but it is useful for developer documentation, and as such it is included on any [OpenAPI specification](../kb_topics/openapiSupport.md#kb-topic-openapi-specification-oas-support) generated by the framework. Markdown is a commonly-used syntax, but you may also embed HTML content. When embedding HTML in the description in a .ds.xml file (see [dataSourceDeclaration](../kb_topics/dataSourceDeclaration.md#kb-topic-creating-datasources)), it is recommended to wrap the HTML in a CDATA tag.

This description is also provided to AI when AI is asked to work with the field. Best practices for the description are:

*   Start with a plain language explanation of what the field represents in the real world, its business concept or core purpose. For example: `order_subtotal` might be "Total price of the customer's order before tax and shipping."
*   If the field involves time, clarify what moment in time the value applies to, and how the value relates to other timestamps in the record. For example: `updated_timestamp` might be "The last time when any value of the record was updated. Always greater or equal to 'created\_timestamp'."
*   If a numeric field, clearly identify the units if there are any.
*   When not [required](#attr-datasourcefieldrequired) (i.e. the value may be `NULL`), describe the interpretation of a `NULL` value. Does the absence of a value have a specific meaning, or does it mean that the data is not available, unknown, or pending?
*   If values are constrained within a certain range or domain, identify the bounds or possible values.
*   If values take a certain format, identify this format and fully describe each part.
*   Include descriptions of how the field relates to or depends on others.
*   Give a brief note about how the field is populated. This might include the source of the data, formula(s) used to calculate the value, and the frequency and timing of updates.

Sample values in the description may be appropriate, but a better practice is to provide [sampleData](DataSource.md#attr-datasourcesampledata) on the data source, which show AI sample values in the context of complete record(s) from the data source.

### See Also

- [DataSource.description](DataSource.md#attr-datasourcedescription)

**Flags**: IRW

---
## Attr: DataSourceField.title

### Description
Default user-visible title for this field.

This will be picked up by [DataBoundComponent](../reference.md#interface-databoundcomponent)s and other views over this data source.

Note this property frequently does not need to be set since [DataSource.autoDeriveTitles](DataSource.md#attr-datasourceautoderivetitles) (on by default) usually picks an appropriate user-visible title if you have a reasonable naming convention for your field names.

Note that if this field is being displayed in a [ListGrid](ListGrid_1.md#class-listgrid) bound to this data source, the [ListGridField.headerTitle](ListGridField.md#attr-listgridfieldheadertitle) attribute may be used to specify a different string for display in the column header.

### Groups

- componentBinding

### See Also

- [Field.exportTitle](Field.md#attr-fieldexporttitle)

**Flags**: IRW

---
## Attr: DataSourceField.multipleStorageSeparator

### Description
For fields that are [multiple:true](#attr-datasourcefieldmultiple) and use [DataSourceField.multipleStorage](#attr-datasourcefieldmultiplestorage), the separator used in the "simpleString" [MultipleFieldStorage](../reference.md#type-multiplefieldstorage) mode.

Default value of null means the [DataSourceField.multipleValueSeparator](#attr-datasourcefieldmultiplevalueseparator) is used instead.

NOTE: "simpleString" storage concatenates the stringified forms of each of the multiple values together, delimited with the `multipleStorageSeparator` character(s). If you use this storage mode with String values that themselves contain the `multipleStorageSeparator`, they will not be correctly retrieved. To avoid this, use a multi-character delimiter that is not likely to occur in regular text, or switch to "json" storage

### Groups

- multipleField

**Flags**: IR

---
## Attr: DataSourceField.javaCollectionClass

### Description
See [DataSourceField.javaClass](#attr-datasourcefieldjavaclass) - when auto-populating of Java Beans / POJOs based on inbound DSRequest data, for a field of type Collection or Map, `javaCollectionClass` can be used to specify a particular concrete class to use. If not specified, and a concrete Collection or Map class cannot be discovered using Java Reflection, the following concrete classes are used:

*   `java.util.ArrayList` is used for fields of type `List`
*   `java.util.HashSet` is used for fields of type `Set`
*   `java.util.LinkedList` is used for fields of type `Queue`
*   `java.util.LinkedHashMap` is used for fields of type `Map`
*   `java.util.ArrayList` is used for fields that are otherwise of type `Collection`

Note that this value is used even if the target Collection or Map is declared as a concrete class. So, for example, if you set `javaCollectionClass` to `java.util.LinkedList` but your setter method accepts a `java.util.ArrayList`, you will get a ClassCastException.

**Flags**: IR

---
## Attr: DataSourceField.creatorOverrides

### Description
Indicates that normal declarative security rules specified on this field are waived for rows that were created by the current user, as described in the discussion of [dataSource.creatorOverrides](DataSource.md#attr-datasourcecreatoroverrides). This setting overrides `dataSource.creatorOverrides`, for this field only.

Note that field-level `creatorOverrides` is conceptually slightly different to the setting at DataSource and OperationBinding levels. To give the example of a fetch operation, at the other two levels, it results in a limited set of rows being returned, rather than a security exception being thrown. At the field-level, it results in values for individual fields being present in those rows, rather than them being stripped out on the server.

### Groups

- fieldLevelAuth
- declarativeSecurity

### See Also

- [DataSourceField.editRequires](#attr-datasourcefieldeditrequires)
- [DataSourceField.viewRequires](#attr-datasourcefieldviewrequires)
- [DataSource.creatorOverrides](DataSource.md#attr-datasourcecreatoroverrides)

**Flags**: IR

---
## Attr: DataSourceField.filterEditorType

### Description
Sets the default FormItem to be used for this field if it appears in a filter row, and [DataSourceField.canFilter](#attr-datasourcefieldcanfilter) is not false.

Note: If this is not specified, the edit-formItem type may be derived from the [DataSourceField.editorType](#attr-datasourcefieldeditortype) property, or from the field's [DataSourceField.type](#attr-datasourcefieldtype).

### Groups

- componentBinding

**Flags**: IR

---
## Attr: DataSourceField.editRequiresRole

### Description
Comma-separated list of user roles that are allowed to write to this field. If the current user does not have any of the roles listed, the system will not allow this field to be initialized or updated. Please see [OperationBinding.requiresRole](OperationBinding.md#attr-operationbindingrequiresrole) for further details of SmartClient's declarative role-based security. Please see [editRequiresAuthentication](#attr-datasourcefieldeditrequiresauthentication) \[or [viewRequiresAuthentication](#attr-datasourcefieldviewrequiresauthentication) for viewRequiresRole\] for the UI consequences if the user does not have the required roles, as well as for information on customizing field-level security.

**NOTE:** This property prevents both initialization and updates for a field. If you have a need to prevent _just_ initialization or _just_ updates, you can use [DataSourceField.initRequiresRole](#attr-datasourcefieldinitrequiresrole) or [DataSourceField.updateRequiresRole](#attr-datasourcefieldupdaterequiresrole).

### Groups

- fieldLevelAuth
- declarativeSecurity

### See Also

- [DataSourceField.editRequiresAuthentication](#attr-datasourcefieldeditrequiresauthentication)
- [DataSourceField.viewRequiresRole](#attr-datasourcefieldviewrequiresrole)
- [DataSourceField.initRequiresRole](#attr-datasourcefieldinitrequiresrole)
- [DataSourceField.updateRequiresRole](#attr-datasourcefieldupdaterequiresrole)

**Flags**: IR

---
## Attr: DataSourceField.batchUploadCaseSensitive

### Description
Applies to the "fetch" operation that is used to look up key values for fields with [importStrategy.display](#attr-datasourcefieldimportstrategy) while importing data using [BatchUploader](BatchUploader.md#class-batchuploader) or `DataImport` server-side API. Controls whether look up for key values is case sensitive or not. Default value is "false".

**Flags**: IR

---
## Attr: DataSourceField.canExport

### Description
Dictates whether the data in this field be exported. Explicitly setting _canExport_ to false overrides the setting on any component-fields, such as [ListGrid fields](ListGridField.md#attr-listgridfieldcanexport).

**Flags**: IR

---
## Attr: DataSourceField.imageWidth

### Description
Width of the image-content of this field. If set as a string, represents the name of another field in the record that holds the imageWidth. Applicable only to fields of image type or fields that use a [ViewFileItem](../reference.md#class-viewfileitem) as an editor.

**Flags**: IR

---
## Attr: DataSourceField.viewRequiresRole

### Description
Comma-separated list of user roles that are allowed to fetch this field. If the current user has any of the roles listed, values for the field will be fetched. Please see [OperationBinding.requiresRole](OperationBinding.md#attr-operationbindingrequiresrole) for further details of SmartClient's declarative role-based security. Please see [editRequiresAuthentication](#attr-datasourcefieldeditrequiresauthentication) \[or [viewRequiresAuthentication](#attr-datasourcefieldviewrequiresauthentication) for viewRequiresRole\] for the UI consequences if the user does not have the required roles, as well as for information on customizing field-level security.

### Groups

- fieldLevelAuth
- declarativeSecurity

### See Also

- [DataSourceField.viewRequiresAuthentication](#attr-datasourcefieldviewrequiresauthentication)
- [DataSourceField.editRequiresRole](#attr-datasourcefieldeditrequiresrole)

**Flags**: IR

---
## Attr: DataSourceField.exportForceText

### Description
When using [DataSource.recordsAsText](DataSource.md#method-datasourcerecordsastext), determines what approach (if any) should be used to force values to be intepreted as text instead of heuristically parsed as dates, times or other structured types.

### See Also

- [TextExportSettings.forceText](TextExportSettings.md#attr-textexportsettingsforcetext)

**Flags**: IR

---
## Attr: DataSourceField.sqlForceInsensitive

### Description
This property is only applicable to fields of SQL DataSources, it overrides default behavior of [iContains](../reference.md#type-operatorid) case insensitive operator on the server-side. Set to `true` to force case insensitivity by changing case of both comparison expression sides or `false` to rely on database `LIKE` operator directly.  
See [sqlSettings](../kb_topics/sqlSettings.md#kb-topic-sql-database-settings-in-serverproperties) for more details including database specific defaults and other configuration options.

### Groups

- sqlSettings

**Deprecated**

**Flags**: IR

---
## Attr: DataSourceField.mimeType

### Description
For a [binary field](../kb_topics/binaryFields.md#kb-topic-binary-fields), sets a fixed mime type for all files stored to this field. Should be set to a standard mime type string, for example, "text/plain" for a .txt file.

This is useful if a binary field only stored one type of file and you chose not to store filenames, since the extension of the file name is normally used to determine the mime type.

**Flags**: IR

---
## Attr: DataSourceField.valueXPath

### Description
XPath expression used to retrieve the field's value.

This XPath expression will be evaluated in the scope of the record objects selected by the [DataSource.recordXPath](DataSource.md#attr-datasourcerecordxpath). For XML data ([dataFormat:"xml"](DataSource.md#attr-datasourcedataformat)) this means a call to [XMLTools.selectString](XMLTools.md#classmethod-xmltoolsselectstring) passing the selected XML element. For JSON data ([dataFormat:"json"](DataSource.md#attr-datasourcedataformat)), this means a call to [XMLTools.selectObjects](XMLTools.md#classmethod-xmltoolsselectobjects) passing the selected JSON object.

In the absence of a `valueXPath`, for JSON data the value for the field will be the value of the same-named property in the record object selected by [recordXPath](DataSource.md#attr-datasourcerecordxpath).

For XML data, the value will be the attribute or subelement named after the field name. For example, for a field "author" on a record element `<book>`, the following structures require no valueXPath:

```
    <book author="Mark Jones"/>

    <book>
        <author>Mark Jones</author>
    </book>
 
```

If `valueXPath` is not required for your field because of the default handling described above, don't specify it, as it's slightly slower.

To learn about XPath, try the following search: [http://www.google.com/search?q=xpath+tutorial](http://www.google.com/search?q=xpath+tutorial)

**Using valueXPath with the SmartClient server**

If you're using the SmartClient server to return data via the DSResponse object (or indirectly doing so using DataSource DMI), the valueXPath you specify on the DataSource fields will be applied to the data you return via the [JXPath](http://commons.apache.org/jxpath/) library.  
See also the server side Java APIs `DataSource.setProperties()` and `DSResponse.setData()`.

If you are returning Java Beans as your DSResponse data, normally each dataSource field receives the value of the same-named Java Bean property, that is, a field "zipCode" is populated by looking for "getZipCode()" on the objects passed as DSResponse data. You can use `valueXPath` to retrieve properties from subobjects, so long as a chain of getter methods exists that corresponds to the valueXPath. For example, a valueXPath of "address/zipCode" expects to call "getAddress()" on the bean(s) passed to DSResponse.setData(), followed by "getZipCode()" on whatever object "getAddress()" returns.

When you are saving data, the inbound DSRequest values, available as a Java Map, will use just dataSource field names as Map keys, not the valueXPath used to derive them. However, to achieve bidirectional valueXPath binding, you can use the server-side method dataSource.setProperties() to use the valueXPath when setting properties on your server object model. When applied as a setter, an XPath like "address/zipCode" attempts "getAddress()" followed by "setZipCode()" on the returned object. JXPath also has some ability to auto-create intervening objects if they are missing, such as auto-creating an "address" subobject when applying "address/zipCode" as a valueXPath.

See the [JXPath](http://jakarta.apache.org/commons/jxpath/) library documentation for complete details, including other types of server object models supported, such as server-side XML.

### Groups

- clientDataIntegration

**Flags**: IR

---
## Attr: DataSourceField.initRequires

### Description
Indicates that the specified [VelocityExpression](../reference_2.md#type-velocityexpression) must evaluate to true if initializations of this field are to be allowed. If the specified expression does not evaluate to true, the field will be removed from the request as described for [editRequiresAuthentication](#attr-datasourcefieldeditrequiresauthentication).

In addition to the normal context variables available to Velocity expressions in SmartClient, expressions you write for field-level `requires` clauses - `initRequires`, [viewRequires](#attr-datasourcefieldviewrequires), [editRequires](#attr-datasourcefieldeditrequires) and [updateRequires](#attr-datasourcefieldupdaterequires) - can reference two additional variables: `$fieldName` and `$dsName`. These are the names of the dataSource and field currently undergoing `requires` checks. They are helpful because they allow you to write a generic checker function that can be used to handle `requires` checks for multiple fields and dataSources.

**NOTE:** This property only prevents initialization of a field; updates will still be allowed. You should only use this property if you have a special requirement; ordinarily, use [DataSourceField.editRequires](#attr-datasourcefieldeditrequires), which applies security for both types of write.

### Groups

- fieldLevelAuth
- declarativeSecurity

### See Also

- [DataSourceField.editRequiresAuthentication](#attr-datasourcefieldeditrequiresauthentication)
- [DataSourceField.editRequiresRole](#attr-datasourcefieldeditrequiresrole)
- [DataSourceField.viewRequires](#attr-datasourcefieldviewrequires)

**Flags**: IR

---
## Attr: DataSourceField.sortByField

### Description
Causes values for this field to be sorted according to values for another field, for both client- and server-side sorting.

This can be used to establish a sort order for a field that is not the normal sorting order indicated by the field value, typically by having the `sortByField` as a [hidden field](#attr-datasourcefieldhidden).

If using SQLDataSource, consider using a [DataSourceField.customSelectExpression](#attr-datasourcefieldcustomselectexpression) as an efficient way to populate the `sortByField` with the results of a SQL expression.

**Flags**: IR

---
## Attr: DataSourceField.translatorClassName

### Description
The fully-qualified name of a Java class that implements the `com.isomorphic.datasource.DataTranslator` interface. If a field declares this attribute, SmartClient Server will create an instance of the translator class and call its `translate()` method for that field value on every record in the response data during `DSResponse` creation.

Translators were originally provided as a mechanism for translating a plain text value of a field - for example, as provided in a CSV file or CSV REST server response - into a type-correct value. Now, however, they are integrated into the general response flow and are one of many ways in which you can modify response data; see also [Direct Method Invocation](DMI.md#class-dmi), [custom dataSources](DataSource.md#attr-datasourceserverconstructor), [transformResponseScript](OperationBinding.md#attr-operationbindingtransformresponsescript) and [fieldValueScript](#attr-datasourcefieldfieldvaluescript).

Because the orignal translator implementation was intended to derive type-correct values from plain text CSV values, the `DataTranslator` interface only specifies a single `translate()` method, that accepts a String and returns an Object. For reasons of backwards compatibility, this has been left in place, but we have implemented an additional subinterface, `com.isomorphic.datasource.FieldDataTranslator`. If your translator implements `FieldDataTranslator`, the framework will call that interface's two-parameter `translate()` method, passing in both the raw text value and a type-correct object coerced from the raw value by SmartClient's type validation subsystem (though this automatic type coercion can be switched off with the [skipTypeCoercion flag](#attr-datasourcefieldskiptypecoercion)). Hence, `FieldDataTranslator`s are intended for more sophisticated value manipulations than simple type coercion.

The following example shows a simple translator that parses a datetime using a non-standard format into a Java Date object and then alters that date to represent the first day of the month:

```
 package com.mycompany;

 import java.util.Date;
 import java.text.ParseException;
 import java.text.SimpleDateFormat;
 import com.isomorphic.datasource.FieldDataTranslator;
 import com.isomorphic.datasource.TranslaterException;

 public class FirstDayOfTheMonthTranslator implements FieldDataTranslator {
  	static SimpleDateFormat sdf = new SimpleDateFormat("MM/d/yyyy hh:mm:ss a z");

  	public Object translate(String raw, Object coerced) throws TranslaterException {
  		if (object == null) return null;

          // Because the raw text is in a weird format, standard type coercion will not have
          // been able to derive a real datetime, so we need to do that first
  		try {
  			Date theDate = sdf.parse(raw);
              // This API was deprecated a long time ago, but is still the easiest way to do this!
              theDate.setDate(1);
              return theDate;
  		} catch (ParseException e) {
  			// Exception handling code goes here
  			return null;
  		}
  	}
 }
 
```
To make use of this translator, you would use a field definition like this:
```
     <field name="myDateField" type="datetime" translatorClassName="com.mycompany.FirstDayOfTheMonthTranslator" />
 
```

**Flags**: IR

---
## Attr: DataSourceField.storeMilliseconds

### Description
For fields of type "datetime", indicates whether the framework should attempt to preserve the millisecond part when persisting to native SQL datetime-type columns. Whether this is possible depends on the type and version of the underlying database product; some databases - for example SQL Server earlier than 2008 and MySQL versions earlier than 5.6 - do not provide fractional seconds support. If you set this flag when your underlying database cannot support fractional seconds, it will be ignored.

Other than the two cases just mentioned which are known to fail, `storeMilliseconds` has been tested and is officially supported with the following products and minimum versions:

*   Oracle 10g
*   Microsoft SQL Server 2008
*   MySQL 5.6
*   MariaDB 5.3
*   PostgreSQL 9.1
*   HSQLDB 2.2
*   DB2 for Unix/Linux 9.7
*   Firebird 11.2
*   Informix IDS 11.5

Note that you can use [sqlStorageStrategy](#attr-datasourcefieldsqlstoragestrategy) to store a datetime value with sub-second precision in _any_ database - see below.

When the system generates SQL to insert or update datetime values including a millisecond element, it does so using a database-specific format string specified in property `defaultDateTimeFormatWithMilliseconds` in your `server.properties` file. These format strings should conform to the rules of the [Java SimpleDateFormat class](http://docs.oracle.com/javase/8/docs/api/java/text/SimpleDateFormat.html). Suitable format strings are provided for all default databases out of the box; if you need to override one or provide a new one, you do so as shown in this example:

```
   sql.MyNewDatabase.defaultDateTimeFormatWithMilliseconds: yy-MM-dd'T'hh.mm.ss.SSS
```

Note that this property only controls the persistence of milliseconds into the database; there is no built-in support for sub-second elements of datetimes in any SmartClient visual components. See also the documentation for [DataSource.trimMilliseconds](DataSource.md#attr-datasourcetrimmilliseconds) for more details of how sub-second datetime elements are handled in the client-server flow.

This property is only applicable to DataSources of [serverType](../reference_2.md#type-dsservertype) "sql" and fields of [type](../reference_2.md#type-fieldtype) "datetime". It is ignored in all other cases. However, note that the built-in JPA and Hibernate dataSources will always persist millisecond values automatically if the underlying Java type, database and column support it.

Finally, note that this property only has an effect on _native_ datetime-type fields. When you use [sqlStorageStrategy](#attr-datasourcefieldsqlstoragestrategy) to store a temporal value in a text or number column, it is the [sqlDateFormat](#attr-datasourcefieldsqldateformat) you use that dictates the precision. For example, a field with `sqlStorageStrategy:"text"` and `sqlDateFormat:"yyyy-MM-dd hh:mm:ss.SSS"` would store and retrieve with millisecond precsion; the same field with `sqlDateFormat:"yyyy-MM-dd hh:mm"` would store and retrieve with precision to the nearest minute only.

### See Also

- [DataSource.trimMilliseconds](DataSource.md#attr-datasourcetrimmilliseconds)

**Flags**: IR

---
## Attr: DataSourceField.canEdit

### Description
Controls whether, by default, DataBoundComponents consider this field editable. Set to `false` to draw this field read-only.

For a field that should never be changed from the UI, consider using [DataSourceField.canSave](#attr-datasourcefieldcansave) instead, which will both mark a field as non-editable and reject any attempt to programmatically change the value on the server (when using the SmartClient Server).

This attribute may not effect all dataBoundComponents - the [DataBoundComponent.canEditFieldAttribute](DataBoundComponent.md#attr-databoundcomponentcaneditfieldattribute) may be set at the component level to look for a different attribute on the dataSourceField, and components allow developers to explicitly override this default (see [ListGridField.canEdit](ListGridField.md#attr-listgridfieldcanedit). [FormItem.canEdit](FormItem.md#attr-formitemcanedit) for example).

### Groups

- componentBinding

### See Also

- [DataSourceField.canFilter](#attr-datasourcefieldcanfilter)
- [DataSourceField.canSave](#attr-datasourcefieldcansave)

**Flags**: IR

---
## Attr: DataSourceField.showFileInline

### Description
For a field of type:"imageFile", indicates whether to stream the image and display it inline or to display the View and Download icons.

**Flags**: IR

---
## Attr: DataSourceField.javaKeyClass

### Description
See [DataSourceField.javaClass](#attr-datasourcefieldjavaclass) - when auto-populating of Java Beans / POJOs based on inbound DSRequest data, for a field of Map type, `javaKeyClass` can be used to specify a particular concrete class for the map keys. If not specified, and a concrete type cannot be discovered using Java Reflection, `java.lang.Object` is used. Note that `javaKeyClass` take precedence over generics if both are used.

**Flags**: IR

---
## Attr: DataSourceField.fkColumnCode

### Description
See [DataSource.tableCode](DataSource.md#attr-datasourcetablecode).

**Flags**: R

---
## Attr: DataSourceField.recreateOnChange

### Description
For use in [componentSchema](../kb_topics/componentSchema.md#kb-topic-component-schema) for fields that, when changed in [reify](../kb_topics/reify.md#kb-topic-reify-overview), should discard the current live component and recreate it with the current configured properties.

This property is typically set when a custom component is being used that doesn't have a setter for the field.

### Groups

- componentSchema

### See Also

- [PaletteNode.recreateOnChange](PaletteNode.md#attr-palettenoderecreateonchange)

**Flags**: IR

---
## Attr: DataSourceField.childTagName

### Description
For a field that is [multiple:"true"](#attr-datasourcefieldmultiple), controls the name of the XML tag used for each subelement during [DataSource.xmlSerialize](DataSource.md#method-datasourcexmlserialize).

If unset, the default tag name is "value" for a field of simple type, and for a field of DataSource type, is the tagName or ID of the DataSource (as though `xmlSerialize()` were called on the child DataSource).

### Groups

- xmlSerialize
- componentSchema

**Flags**: IR

---
## Attr: DataSourceField.deepCloneOnEdit

### Description
Before we start editing this field in a DataBoundComponent, should we perform a deep clone of the underlying field value. See [DataSource.deepCloneOnEdit](DataSource.md#attr-datasourcedeepcloneonedit) for details of what this means.

If this value is not explicitly set, it defaults first to the value of [DataBoundComponent.deepCloneOnEdit](DataBoundComponent.md#attr-databoundcomponentdeepcloneonedit), then to the value of [DataSource.deepCloneOnEdit](DataSource.md#attr-datasourcedeepcloneonedit).

Like the other `deepCloneOnEdit` settings, this flag only has an effect if you are editing a values object that contains nested objects or arrays, using [dataPath](Canvas.md#attr-canvasdatapath)s.

### See Also

- [Canvas.dataPath](Canvas.md#attr-canvasdatapath)
- [FormItem.dataPath](FormItem.md#attr-formitemdatapath)
- [DataBoundComponent.deepCloneOnEdit](DataBoundComponent.md#attr-databoundcomponentdeepcloneonedit)
- [DataSource.deepCloneOnEdit](DataSource.md#attr-datasourcedeepcloneonedit)

**Flags**: IRWA

---
## Attr: DataSourceField.timeFormatter

### Description
Preferred time-format to apply to date type values within this field. If this property is specified on a field displayed within a dataBound component such as a [ListGrid](ListGrid_1.md#class-listgrid) or [DynamicForm](DynamicForm.md#class-dynamicform), any dates displayed in this field will be formatted as times using the appropriate format.

This is most commonly only applied to fields specified as type `"time"` though if no explicit [FormItem.dateFormatter](FormItem.md#attr-formitemdateformatter) is specified it will be respected for other fields as well.

See [ListGridField.timeFormatter](ListGridField.md#attr-listgridfieldtimeformatter) and [FormItem.timeFormatter](FormItem.md#attr-formitemtimeformatter) for more information.

### Groups

- appearance

**Flags**: IRWA

---
## Attr: DataSourceField.excludeFromState

### Description
If true, then this field is excluded from the bound component's view state. In addition, the field will not be selected as the default title field by [DataBoundComponent.getTitleField](DataBoundComponent.md#method-databoundcomponentgettitlefield) if [DataBoundComponent.titleField](DataBoundComponent.md#attr-databoundcomponenttitlefield) is not provided.

### Groups

- viewState

**Flags**: IR

---
## Attr: DataSourceField.canView

### Description
If false, this property indicates that this field is considered "server only". This means:

*   Components cannot bind to the field; even if you explicitly add a field with the same name to your [dataBoundComponent](../reference.md#interface-databoundcomponent), it will be dropped
*   If you are using SmartClient Server, the client will never be sent a value for the field
*   If you are using SmartClient Server, then similar to [canEdit](#attr-datasourcefieldcanedit), no updates to the field are allowed from the client. If you explicitly add a value for the field to, eg, a record you are passing to [DataSource.updateData](DataSource.md#method-datasourceupdatedata), the server will strip the value out of the record before processing the update request.

`canView:false` is **not** the same thing as [hidden](#attr-datasourcefieldhidden). Use `canView:false` when you want to prevent the client from ever seeing a field's definition or values; use `hidden:true` if it is fine from a security perspective that a field's definition and values are sent to the browser, but the field should not by default appear in user interface elements (but could do in some cases, like a special screen for advanced users or administrators, for example).

Note that this property must be set explicitly to false to have an effect; a null or undefined setting is treated the same as true.

This property is used to implement field-level view security: failing a [viewRequiresAuthentication](#attr-datasourcefieldviewrequiresauthentication), [viewRequiresRole](#attr-datasourcefieldviewrequiresrole) or [viewRequires](#attr-datasourcefieldviewrequires) test is equivalent to setting `canView:false` on the field (and, indeed, from the client's perspective, the field _has_ had `canView:false` set).

### Groups

- componentBinding

**Flags**: IR

---
## Attr: DataSourceField.viewRequiresAuthentication

### Description
Whether a user must be authenticated in order to fetch this field. If this property is set and the user is not authenticated, SmartClient Server will not return values for this field to the client.

The way this behavior works is to remove the field from the expressed or implied list of fields to return (note, this means the field is removed from the list of fields returned in _data records_; the actual field definition in the dataSource is still returned, but in a stripped-down state, as described below). A list of fields can be expressed using [OperationBinding.outputs](OperationBinding.md#attr-operationbindingoutputs) or [DSRequest.outputs](DSRequest.md#attr-dsrequestoutputs); in the absence of those, the entire set of fields defined in the DataSource is implied. You can override this behavior on a per-request basis by providing a DMI that just re-adds the names of the fields you want for that particular request to the "consolidated outputs". See the server-side Javadoc for `DSRequest.getConsolidatedOutputs()`.

In addition to this behavior of trimming off values in fetched records, a field that fails a field-level security check (either this one or one of the two more specific checks, [viewRequiresRole](#attr-datasourcefieldviewrequiresrole) and [viewRequires](#attr-datasourcefieldviewrequires)) will be altered in the version of the dataSource returned to the client by the [`<loadDS>` JSP tag](../kb_topics/loadDSTag.md#kb-topic-isomorphicloadds) or [DataSourceLoader servlet](../kb_topics/dataSourceDeclaration.md#kb-topic-creating-datasources).

*   If the field is also not editable (see the discussion of this below), it will be marked [canView](#attr-datasourcefieldcanview):false, and thus effectively be inert and unusable on the client
*   If the field is editable, it will be marked [hidden](#attr-datasourcefieldhidden). By default, this means that [DataBoundComponent](../reference.md#interface-databoundcomponent)s will not show the field, though this can be overridden for individual components. If you do choose to unhide the field, bear in mind that it will never actually show any data, because the underlying security test has still failed

By default, view constraints automatically imply edit constraints - almost all of the time, if a user is not allowed to view a field, he should not be allowed to update it either. If you specify a view constraint, the system behaves as if you had also specified the corresponding edit constraint - so `viewRequiresAuthentication` on a field implies `[editRequiresAuthentication](#attr-datasourcefieldeditrequiresauthentication)`. You override this behavior simply by specifying some kind of edit constraint for the field, either a different one (eg, "users" can view a field, but only "managers" can update it) or a blank one (if you have some unusual requirement whereby users are not allowed to view a field, but they can update it).

### Groups

- fieldLevelAuth
- declarativeSecurity

### See Also

- [DataSourceField.editRequiresAuthentication](#attr-datasourcefieldeditrequiresauthentication)

**Flags**: IR

---
## Attr: DataSourceField.foreignKey

### Description
Declares that this field holds values that can be matched to values from another DataSource field, to create a relationship between records from different DataSources or even records within the same DataSource. Ordinarily, the relation to the other dataSource is a many-to-one relation, where multiple records on this dataSource refer to a single record on the other dataSource. To declare a one-to-many or many-to-many relation, specify [multiple](#attr-datasourcefieldmultiple):true as well as `foreignKey`. See [the Relations overview](../kb_topics/dataSourceRelations.md#kb-topic-relations) for more details

The format of `foreignKey` is `_dataSourceId_._fieldName_`.

For a foreignKey within the same dataSource, you can omit the `dataSourceId` and just specify `_fieldName_`. For example, to create a tree relationship within a DataSource:

```
   isc.DataSource.create({
     ID:"supplyItem",
     fields : [
       {name:"itemId", type:"sequence", primaryKey:true},
       {name:"parentId", type:"integer", foreignKey:"itemId"},
       ...
     ]
   });
 
```

`foreignKey` declarations also allow other automatic behaviors by [DataBoundComponents](../reference.md#interface-databoundcomponent), such as [ListGrid.fetchRelatedData](ListGrid_2.md#method-listgridfetchrelateddata).

For SQLDataSources foreign keys can be automatically discovered from SQL tables if [autoDeriveSchema](DataSource.md#attr-datasourceautoderiveschema) is set.

### Groups

- dataSourceRelations

### See Also

- [DataSourceField.joinType](#attr-datasourcefieldjointype)

**Flags**: IR

---
## Attr: DataSourceField.validOperators

### Description
Set of search-operators valid for this field.

If not specified, all operators that are valid for the field type are allowed.

### Groups

- advancedFilter

**Flags**: IR

---
## Attr: DataSourceField.customSQL

### Description
For a DataSource with [serverType](DataSource.md#attr-datasourceservertype) "sql", "hibernate", or "jpa", indicates that this field should be omitted by default from all SQL operations, and will only be used with [custom queries](../kb_topics/customQuerying.md#kb-topic-custom-querying-overview).

Having marked a field as `customSQL` you can refer to it via $criteria._fieldName_ or $values._fieldName_ in customized queries.

The following are situations where you would **not** use `customSQL`:

*   simple joins where you want to enable users to see and search on a field from another table; consider [DataSourceField.includeFrom](#attr-datasourcefieldincludefrom) instead
*   fields where you want to calculate or transform values in SQL on load or save, but always perform the same calculation for each operationType; consider instead [DataSourceField.sqlStorageStrategy](#attr-datasourcefieldsqlstoragestrategy) for some common cases, or [DataSourceField.customSelectExpression](#attr-datasourcefieldcustomselectexpression), [DataSourceField.customUpdateExpression](#attr-datasourcefieldcustomupdateexpression) and [DataSourceField.customInsertExpression](#attr-datasourcefieldcustominsertexpression) for full customization
*   a special fetch is needed where the field needs to be excluded from the $defaultWhereClause so that it can be used in a custom `<whereClause>` - consider [OperationBinding.excludeCriteriaFields](OperationBinding.md#attr-operationbindingexcludecriteriafields) instead

Use customSQL in situations like:

*   there are multiple variations of the "fetch" operation with different [operationIds](OperationBinding.md#attr-operationbindingoperationid), and the field is only used in some of them; in that case, consider using [OperationBinding.customFields](OperationBinding.md#attr-operationbindingcustomfields) to selectively re-introduce SQL generation for the field only in operations where it's used.
*   the field represents hidden criteria on a field in another table where the field is never shown to the user
*   the field is a write-only value only saved in some operations
*   more than one data access strategy is in use (eg direct SQL for fetch and bean-based persistence accessed via DMI for saves) and certain fields are not available in SQL

**Flags**: IR

---
## Attr: DataSourceField.hidden

### Description
Whether this field should be hidden from users by default within a DataBound component. This is generally used for internal IDs and other fields not meaningful to users.

See [DataSourceField.detail](#attr-datasourcefielddetail) for fields that should be hidden in a summary view such as a [ListGrid](ListGrid_1.md#class-listgrid), but still available to the user.

**NOTE:** This property is **not** a security setting - data for hidden fields is still delivered to the client, it just isn't shown to the user. If you wish to make sure that only appropriate data reaches the client, use [OperationBinding.outputs](OperationBinding.md#attr-operationbindingoutputs), [DataSourceField.canView](#attr-datasourcefieldcanview):false on the field, or a field-level declarative security setting like [DataSourceField.viewRequiresRole](#attr-datasourcefieldviewrequiresrole).

### Groups

- componentBinding

**Flags**: IR

---
## Attr: DataSourceField.inapplicable

### Description
For use in [componentSchema](../kb_topics/componentSchema.md#kb-topic-component-schema), a field [inherited](DataSource.md#attr-datasourceinheritsfrom) from another schema can be redeclared with this property set in order to indicate that the property should not be used.

This is primarily used to influence [Reify](../kb_topics/reify.md#kb-topic-reify-overview). For simple type properties, this avoids the property appearing in the Component Editor.

For fields that hold subcomponents, this prevents inappropriate drag and drop. For example, a custom class called `MyDialog` may automatically create a series of children, and not allow arbitrary other children to be added. In this case, the inherited property [Canvas.children](Canvas.md#attr-canvaschildren) should be marked inapplicable in order to prevent arbitrary components being dropped onto a `MyDialog` instance.

### Groups

- componentSchema

**Flags**: IR

---
## Attr: DataSourceField.decimalPrecision

### Description
Applies only to fields of type "float" and affects how many significant digits are shown.

For example, with decimalPrecision 3, if the field value is 343.672677, 343.673 is shown.

If the value is 125.2, 125.2 is shown - decimalPrecision will not cause extra zeros to be added. Use [DataSourceField.decimalPad](#attr-datasourcefielddecimalpad) for this.

A number is always shown with its original precision when edited.

### Groups

- appearance

**Flags**: IRW

---
## Attr: DataSourceField.template

### Description
If `field.template` is set, this field's value in records will be calculated dynamically via the specified [template](../reference.md#object-usersummary).

This property may be set to a valid [template expression](UserSummary.md#attr-usersummarytext).

For example a composite field for a dataSource of citation references containing "volume", "issue", and "pages" fields might use the following template:

```
 <field name="compositeLocation" title="Volume (issue), pages">
      <template>#{volume} (#{issue}), #{pages}</template>
 </field>
 
```
_\[This example might produce output like `"12 (5), 121-137"`\]_.

For SQL DataSources, values are calculated on the server by modifying the generated SQL request as appropriate. As with other [dynamically calculated](DataSource.md#method-datasourceiscalculated) fields, fields with a specified template are non editable.  
When records are displayed in [dataBoundComponents that support editing](../reference.md#interface-databoundcomponent), template field values will be re-calculated dynamically on the client as the user edits a record, so a user may preview the result of their changes.

Note that `template` fields may make use of [formula fields](#attr-datasourcefieldformula), [fields included from related dataSources](#attr-datasourcefieldincludefrom) [aggregated values from related dataSources](#attr-datasourcefieldincludesummaryfunction), and [fields derived via customSQL](#attr-datasourcefieldcustomselectexpression).

`DataSourceField.template` is supported for [SQL DataSources](../reference_2.md#type-dsservertype), and for [clientOnly dataSources](DataSource.md#attr-datasourceclientonly) only.

**DataSourceField.formula is available with Power or better licenses only.** See [smartclient.com/product](http://smartclient.com/product) for details.

### Groups

- calculatedDataSourceFields

**Flags**: IR

---
## Attr: DataSourceField.primaryKey

### Description
If set to `true`, indicates **either** that this field holds a value unique across all records in this data source, **or** that it is one of a number of fields marked as primary keys, and the combination of the values held in all of those fields is unique across all records in the data source. Note that the latter usage - so-called "composite" or "multipart" keys - is intended for support of legacy databases only: if you are able to choose an approach, Isomorphic recommends the use of one `primaryKey` field per data source, and ideally this field should be of [type](#attr-datasourcefieldtype) "sequence". If you have control of the underlying tables, there is nothing to stop you from adding a field like this (a so-called "synthetic" or "surrogate" key), even for tables that already have a set of columns that could combine to make a composite key (a so-called "natural" key). Also, it is neither necessary nor correct to use a composite primaryKey because you want to enforce uniqueness across that combination of fields. You can achieve that by declaring a unique constraint in the table schema, or use an [isUnique](../reference.md#type-validatortype) validator with `validator.criteriaFields`, or both; there is no need to use a composite key to enforce uniqueness.

Note that composite primaryKeys are not supported in tree-structured datasets ([Tree](Tree.md#class-tree) and [ResultTree](ResultTree.md#class-resulttree)) or components ([TreeGrid](TreeGrid.md#class-treegrid), [ColumnTree](ColumnTree.md#class-columntree)). Tree-structured data requires that nodes have a unique [idField](Tree.md#attr-treeidfield), with the parent/child relationship expressed through the [parentIdField](Tree.md#attr-treeparentidfield). This implies that binding a Tree to a DataSource requires that the DataSource have a singular primaryKey, and that the primaryKey field is also the idField, as described in the [tree databinding overview](../kb_topics/treeDataBinding.md#kb-topic-tree-databinding)

A DataSource that can _only_ perform the "fetch" operation does not require a primaryKey unless it contains [binary fields](../kb_topics/binaryFields.md#kb-topic-binary-fields). If a DataSource allows modification of DataSource records through add, update and remove DataSource operations, or it contains one or more binary fields, one or more fields must be marked as the primary key.

SmartClient requires a primary key value to uniquely identify records when communicating updates or deletions to the server. There is no requirement that the primaryKey field be mapped to an actual "primary key" in your object model, web service, or database (though this is the most obvious and natural thing to do, of course). The only requirement is that the combined values of the primaryKey fields be unique for a given browser instance for the lifetime of the page.

If using SmartClient's [SQL engine](../kb_topics/sqlDataSource.md#kb-topic-sql-datasources) and generating SQL tables using the [Database Configuration Tool](../kb_topics/dbConfigTool.md#kb-topic-database-configuration), the table column generated from a primaryKey field will have a unique constraint applied in the database table and, if the field is of type "sequence", the database column will also be created as an "identity column" in those databases that implement sequence-type handling with identity columns.

### Groups

- dataSourceRelations

**Flags**: IR

---
## Attr: DataSourceField.allowClientRequestedSummaries

### Description
Affects whether client dsRequests can request summaries for this field.

Default setting of null means that the DataSource-wide default setting [DataSource.allowClientRequestedSummaries](DataSource.md#attr-datasourceallowclientrequestedsummaries) is used for this field.

### Groups

- serverSummaries

### See Also

- [DataSource.allowClientRequestedSummaries](DataSource.md#attr-datasourceallowclientrequestedsummaries)

**Flags**: IR

---
## Attr: DataSourceField.updateRequires

### Description
Indicates that the specified [VelocityExpression](../reference_2.md#type-velocityexpression) must evaluate to true if updates to this field are to be allowed. If the specified expression does not evaluate to true, the field will be removed from the request as described for [editRequiresAuthentication](#attr-datasourcefieldeditrequiresauthentication).

In addition to the normal context variables available to Velocity expressions in SmartClient, expressions you write for field-level `requires` clauses - `updateRequires`, [viewRequires](#attr-datasourcefieldviewrequires), [editRequires](#attr-datasourcefieldeditrequires) and [initRequires](#attr-datasourcefieldinitrequires) - can reference two additional variables: `$fieldName` and `$dsName`. These are the names of the dataSource and field currently undergoing `requires` checks. They are helpful because they allow you to write a generic checker function that can be used to handle `requires` checks for multiple fields and dataSources.

**NOTE:** This property only prevents update of a field; initialization will still be allowed. You should only use this property if you have a special requirement; ordinarily, use [DataSourceField.editRequires](#attr-datasourcefieldeditrequires), which applies security for both types of write.

### Groups

- fieldLevelAuth
- declarativeSecurity

### See Also

- [DataSourceField.editRequiresAuthentication](#attr-datasourcefieldeditrequiresauthentication)
- [DataSourceField.editRequiresRole](#attr-datasourcefieldeditrequiresrole)
- [DataSourceField.viewRequires](#attr-datasourcefieldviewrequires)

**Flags**: IR

---
## Attr: DataSourceField.validators

### Description
Validators to be applied to this field.

Validators are applied whenever there is an attempt to save changes to a field.

For the available set of built-in validators, and how to define a custom validator, see the [Validator](Validator.md#class-validator) class.

### Groups

- dataType
- validation

### See Also

- [Validator](Validator.md#class-validator)

**Flags**: IR

---
## Attr: DataSourceField.editorType

### Description
Sets the default FormItem to be used whenever this field is edited (whether in a grid, form, or other component).

If unset, a FormItem will be automatically chosen based on the type of the field, by the rules explained [here](../reference.md#type-formitemtype).

### Groups

- componentBinding

**Flags**: IR

---
## Attr: DataSourceField.autoQuoteCustomExpressions

### Description
If explicitly set to false, switches off automatic quoting and escaping of values in custom expressions that are derived from Velocity evaluations.

By default, any part of a [customSelectExpression](#attr-datasourcefieldcustomselectexpression), [customCriteriaExpression](#attr-datasourcefieldcustomcriteriaexpression), [customUpdateExpression](#attr-datasourcefieldcustomupdateexpression) or [customInsertExpression](#attr-datasourcefieldcustominsertexpression) that comes ultimately from evaluating a Velocity expression, will be automatically quoted and escaped according to the syntax of the underlying database. We do this because "raw" values are vulnerable to [SQL injection attacks](http://en.wikipedia.org/wiki/SQL_injection).

However, it is possible that the exact SQL logic you desire for a custom expression cannot be expressed without access to the raw, unquoted value. To work around this, you can either use the special [$rawValue](../kb_topics/velocitySupport.md#kb-topic-velocity-context-variables) context variable, or you can set this property to false to switch off auto-quoting completely for all custom expressions on this field.

**Warning**: Bear in mind that it is **dangerous** to use raw values. There are some cases where using the raw value is necessary, but even so, all such cases are likely to be vulnerable to injection attacks. Generally, the presence of `$rawValue` in a custom expression, or any fields with `autoQuoteCustomExpressions: false` specified, should be viewed as a red flag.

### See Also

- [DataSourceField.customSelectExpression](#attr-datasourcefieldcustomselectexpression)
- [DataSourceField.customUpdateExpression](#attr-datasourcefieldcustomupdateexpression)
- [DataSourceField.customInsertExpression](#attr-datasourcefieldcustominsertexpression)
- [DataSourceField.customCriteriaExpression](#attr-datasourcefieldcustomcriteriaexpression)

**Flags**: IR

---
## Attr: DataSourceField.xmlAttribute

### Description
Indicates that [DataSource.xmlSerialize](DataSource.md#method-datasourcexmlserialize) should serialize this value as an XML attribute.

Note this does not need to be declared in order for DataSource records to be derived from XML data: a field will be populated with either an attribute or subelement with matching name.

### Groups

- xmlSerialize
- componentSchema

**Flags**: IR

---
## Attr: DataSourceField.fieldValueScript

### Description
A scriptlet to be executed on the server when deriving values for this field. The script will run after the main operation (eg, SQL fetch) and after any [transformResponseScript](DataSource.md#attr-datasourcetransformresponsescript). It is intended to be used for fine-grained transformation at the field level, in cases where declarative approaches such as [customSelectExpression](#attr-datasourcefieldcustomselectexpression) are insufficient.

The script will be provided with the following variables:

*   **dsRequest** The current [DSRequest](../reference_2.md#object-dsrequest)
*   **field** The current field, as an instance of `com.isomorphic.datasource.DSField`
*   **record** The record containing the current field value, as either a Map or a Javabean, depending on your data model. See [beanClassName](DataSource.md#attr-datasourcebeanclassname)
*   **value** The untransformed field value. Note, this will only be provided if the containing record is a Map; if it is a Javabean, your script is expected to derive the value itself, and to apply the transformed value directly to the bean

Before the `fieldValueScript` is called, SmartClient will run type validations on the untransformed field value, to either confirm that the value is a valid one for the [declared field type](#attr-datasourcefieldtype), or to attempt to coerce it into such a valid value (for example, by parsing a number or date out of a string). Note, this validation/coercion step can be disabled - see [skipTypeCoercion](#attr-datasourcefieldskiptypecoercion) - but whether or not this step runs, and whether or not coercion was required, if the resulting value is valid for the declared field type, an additional variable of the appropriate type will be made available to your script

*   **valueString**, an instance of String
*   **valueInteger**, an instance of Long
*   **valueFloat**, an instance of Double
*   **valueBoolean**, an instance of Boolean
*   **valueDate/Time/Datetime**, an instance of java.util.Date

Your script can either manipulate the value directly in the record (if your record is a Javabean, this is the only supported option), or it can return the transformed value and SmartClient will apply it to the response data. If you change the value in the record directly, you should ensure that your script explicitly returns null.

**PERFORMANCE NOTE:** JSR223 script calls can involve an overhead, and since `fieldValueScript` will be called for every field that declares one, for every record in a resultset, that overhead can easily multiply to become a performance issue. For this reason, SmartClient implements script caching for any JSR223 script language that support pre-compilation, and we also recommend the use of Groovy as a scripting language when you are creating `fieldValueScript`s. See the "Caching" and "Relative Performance" sections of the [server scripting article](../kb_topics/serverScript.md#kb-topic-server-scripting) for more details.

### Groups

- serverScript

### See Also

- [DataSource.script](DataSource.md#attr-datasourcescript)
- [DataSource.transformRequestScript](DataSource.md#attr-datasourcetransformrequestscript)
- [DataSource.transformResponseScript](DataSource.md#attr-datasourcetransformresponsescript)

**Flags**: IR

---
## Attr: DataSourceField.initRequiresRole

### Description
Comma-separated list of user roles that are allowed to initialize this field. If the current user does not have any of the roles listed, the system will not allow this field to be initialized.

**NOTE:** This property only prevents initialization of a field; updates will still be allowed. You should only use this property if you have a special requirement; ordinarily, use [DataSourceField.editRequiresRole](#attr-datasourcefieldeditrequiresrole), which applies security for both types of write.

### Groups

- fieldLevelAuth
- declarativeSecurity

### See Also

- [DataSourceField.editRequiresAuthentication](#attr-datasourcefieldeditrequiresauthentication)
- [DataSourceField.editRequiresRole](#attr-datasourcefieldeditrequiresrole)
- [DataSourceField.updateRequiresRole](#attr-datasourcefieldupdaterequiresrole)
- [DataSourceField.initRequires](#attr-datasourcefieldinitrequires)

**Flags**: IR

---
## Attr: DataSourceField.summaryFunction

### Description
If [ListGrid.showGridSummary](ListGrid_1.md#attr-listgridshowgridsummary) or [ListGrid.showGroupSummary](ListGrid_1.md#attr-listgridshowgroupsummary) is true, this attribute can be used to specify an explicit [SummaryFunction](../reference_2.md#type-summaryfunction) for calculating the summary value to display.

If an array of summaryFunctions is specified, they will be executed in turn and the grid will show multiple summary rows at the grid or group level (or both) containing the resulting values.

**Flags**: IR

---
## Attr: DataSourceField.importStrategyFailedErrorMessage

### Description
Customizable and [localizable](../kb_topics/i18n.md#kb-topic-internationalization-and-localization) error message to use when "displayRequired" [importStrategy](#attr-datasourcefieldimportstrategy) fails to find corresponding key value. Default message: _Key mapping for display value is required, but was not found_.

### See Also

- [DataSourceField.importStrategy](#attr-datasourcefieldimportstrategy)

**Flags**: IR

---
## Attr: DataSourceField.length

### Description
Maximum number of characters allowed. Applicable only to fields of text type. For fields of this type a [length range validator](../reference.md#type-validatortype) will be automatically generated on both the client and server side to enforce this maximum length (unless such a validator is explicitly present for the field already).

The [TextItem.enforceLength](TextItem.md#attr-textitemenforcelength) attribute can also explicitly limit user input for freeform text items editing fields with an explicit length specified.

**NOTE:** For DataSources of type "sql", this property has a bearing on the type of column we use when the underlying table is created by a DataSource [import](../kb_topics/sqlDataSource.md#kb-topic-sql-datasources) in the [Admin Console](../kb_topics/adminConsole.md#kb-topic-admin-console). Below a certain length (which is database-specific, see below), we use standard `VARCHAR` columns; above that length, we use an alternate strategy (again, database-specific). For these long fields, we sometimes also generate different SQL for "update" and "add" operations, using JDBC "?" replacement parameters rather than embedding values directly in the generated SQL; whether or not this is done depends entirely on what the underlying database product and/or JDBC driver will allow.

  
**Table of field length limits for supported databases:**

| Database product | VARCHAR limit * | Type used above limit |
|---|---|---|
| HSQLDB | None | - |
| IBM DB2 | 4000 | CLOB |
| Firebird | 32767 | BLOB with subtype 1 |
| Informix | 255 / 32739 | LVARCHAR / TEXT ** |
| Microsoft SQL Server | 8000 | TEXT |
| MySQL | 255 / 65535 / 16M | TEXT / MEDIUMTEXT / LONGTEXT *** |
| MariaDB | 255 / 65535 / 16M | TEXT / MEDIUMTEXT / LONGTEXT *** |
| Oracle | 4000 | CLOB |
| PostgreSQL | 4000 | TEXT |

  
**\*** The "VARCHAR limit" referred to here is a limit used by the SmartClient Server; it is not necessarily imposed by the database. For example, DB2's VARCHAR limit is not 4000 characters; it actually varies from about 4K to about 32K, depending on how the server has been configured.

**\*\*** Informix has a limit of just 255 characters for VARCHAR, but has a native LVARCHAR type which supports nearly 32K characters without needing to fall back on long datatypes. Therefore, with that one product, we have two thresholds for a change in storage type.

**\*\*\*** MySQL has a limit of 255 characters for VARCHAR, 65,535 characters for TEXT and 16,777,215 for MEDIUMTEXT; therefore, with that one product, we have three thresholds for a change in storage type.

### Groups

- dataType

### See Also

- [ListGridField.width](ListGridField.md#attr-listgridfieldwidth)

**Flags**: IR

---
## Attr: DataSourceField.dateFormatter

### Description
Preferred display format to use for date type values within this field. If this property is set on a field displayed in a databound component such as a [DynamicForm](DynamicForm.md#class-dynamicform) or [ListGrid](ListGrid_1.md#class-listgrid) it will be respected (See [FormItem.dateFormatter](FormItem.md#attr-formitemdateformatter) and [ListGridField.dateFormatter](ListGridField.md#attr-listgridfielddateformatter)).

Note that this property is also honored when exporting directly to Excel spreadsheets (ie, when using XLS or XLSX/OOXML form, **not** CSV); "date" and "datetime" fields with this property set will deliver real dates and formatting information to Excel, rather than formatted strings or unformatted dates.

### Groups

- appearance

**Flags**: IRWA

---
## Attr: DataSourceField.valueOperation

### Description
**Note:** Currently, this feature only works with [SQL DataSources](../kb_topics/sqlDataSource.md#kb-topic-sql-datasources)

This property allows you to name an [operationBinding](OperationBinding.md#class-operationbinding) on a [related DataSource](../kb_topics/dataSourceRelations.md#kb-topic-relations) that should be executed to obtain a value for this field. The format of the property is

```
      dataSourceId.operationId.fieldName
 
```
The `fieldName` is used to disambiguate in case the operation returns more than one value and it is required, even if the operation only returns a single field

Typically, `valueOperation` names an operation that uses a [summaryFunction](OperationBinding.md#attr-operationbindingsummaryfunctions) to produce a single aggregated value from a DataSource with a one-to-many or many-to-many relation with this DataSource. Some examples of when `valueOperation` is appropriate:

*   To obtain a total order value from the OrderLines on an Order
*   To obtain the number of Employees reporting to a given manager
*   To obtain the date of the most recent Order for a given Customer
*   To obtain the average population of all Cities in a given Country

Note, SmartClient will convert the sub-operation into inline SQL, for maximum efficiency.

Because `valueOperations` are deriving a simple field value for a single field, they should return a single scalar value of the same type as the field. **Note that the requirement to return a single record is a strict one**: with most databases, failing to observe it will result in a SQL error, because most databases do not allow row limiting in the kind of subqueries we generate to implement `valueOperation` - so-called _correlated scalar subqueries_. MySQL is an exception in this, and with that one database we **do** limit the subquery to 1 row; but it is still better to ensure that the subquery can only return a single row (note, all [SummaryFunction](../reference_2.md#type-summaryfunction)s automatically return a single value)

However, we do tolerate data type discrepancies; in cases where the data types do not match, we attempt the most obvious conversion. For example, if the `valueOperation` field is of type "boolean" but the operation returns a number, we will convert 0 to false and any other number to true; this allows you to create boolean "virtual fields" that answer questions like "Has this Employee booked any orders this month?". With other data types, we will stringify the response value (if the field type is `text`), or parse the result of calling `toString()` on the response object (if the field is of a numeric type).

NOTE: Although `valueOperation` can be used to derive any singular value from any related dataSource, it is intended primarily as a mechanism for including summarized values across one-to-many or many-to-many relations. In cases where you want to go "the other way" and derive a value across a many-to-one or one-to-one relation, you would generally use [includeFrom](#attr-datasourcefieldincludefrom), which is conceptually simpler and more direct.

### See Also

- [AdvancedCriterionSubquery](../reference.md#object-advancedcriterionsubquery)
- [DataSourceField.includeFrom](#attr-datasourcefieldincludefrom)
- [OperationBinding.summaryFunctions](OperationBinding.md#attr-operationbindingsummaryfunctions)

**Flags**: IRA

---
## Attr: DataSourceField.valueMapEnum

### Description
Fully qualified Java className of an Enum that should be used to derive this field's [ValueMap](../reference_2.md#type-valuemap).

This has the same behavior of auto-deriving a `valueMap` from a Java Enum as [DataSource.autoDeriveSchema](DataSource.md#attr-datasourceautoderiveschema) except it applies only to one field.

If you enable `autoDeriveSchema` there is no need to set `valueMapEnum` for Enum fields unless you want to actually _override_ the behavior to use a different Enum for the field (eg, a superclass Enum that is more restrictive).

**Flags**: IR

---
## Attr: DataSourceField.readOnlyEditorType

### Description
Sets the default FormItem to be used if this field is marked as [canEdit false](#attr-datasourcefieldcanedit) and displayed in an editor component such as a DynamicForm.

This property may also be specified at the type level by specifying [SimpleType.readOnlyEditorType](SimpleType.md#attr-simpletypereadonlyeditortype).

### Groups

- componentBinding

**Flags**: IR

---
## Attr: DataSourceField.ignore

### Description
Whether this field should be completely excluded from this dataSource, as if it had never been defined.

If set to true, the field will be entirely omitted when serving a DataSource derived from a server-side definition (typically a .ds.xml file) to the client.

### Groups

- componentBinding

**Flags**: IR

---
## Attr: DataSourceField.canSave

### Description
Whether values in this field can be updated and saved to the dataSource.

If set to `false`, this field will default to being non-editable in standard editing components ([DynamicForm](DynamicForm.md#class-dynamicform), editable [ListGrid](ListGrid_1.md#class-listgrid)), but will be editable when displayed for filtering purposes only (in a [SearchForm](SearchForm.md#class-searchform) or [ListGrid\\n filter editor](ListGrid_1.md#attr-listgridshowfiltereditor). If [canEdit](#attr-datasourcefieldcanedit) is explicitly specified it will take precedence over this client-side behavior, but the server will still enforce the no-save policy (described below).

NOTE: If you are using SmartClient Server and have specified `canSave: false` for a field in a DataSource definition (`.ds.xml` file), this is enforced on the server. This means that we will strip out any attempt to set the value of such a field before trying to process any update or add request, similar to what happens when a [field-level declarative security check](#attr-datasourcefieldeditrequiresauthentication) fails.

### Groups

- componentBinding

**Flags**: IR

---
## Attr: DataSourceField.editRequiresAuthentication

### Description
Whether a user must be authenticated in order to write to this field. If this property is set and the user is not authenticated, the SmartClient Server will not allow this field to be updated or initialized.

This property affects two things. Firstly, the server determines when the DataSource is first loaded if we have an authenticated user; if we don't, the field is marked `canEdit: false`. Secondly, when an insert or update request is received from the client, the server removes the field from the `values` clause before the request is processed.

Note that you can override this behavior. The `canEdit` setting can be overridden on the client-side DataSource like any other client-side property. The value-removing behavior can be overridden on a per-request basis by providing a DMI that re-adds values for the fields you want for that particular request to the values object (the values originally sent up by the client are available on the DSRequest). See the server-side Javadocs for `DSRequest.getValues()` and `DSRequest.getClientSuppliedValues()`.

### Groups

- fieldLevelAuth
- declarativeSecurity

### See Also

- [DataSourceField.viewRequiresAuthentication](#attr-datasourcefieldviewrequiresauthentication)

**Flags**: IR

---
## Attr: DataSourceField.emptyDisplayValue

### Description
Text to be used for display by client-side components when this field has a null or undefined value. This value will be overridden by a component's emptyCellValue, if set.

### Groups

- appearance

### See Also

- [FormItem.emptyDisplayValue](FormItem.md#attr-formitememptydisplayvalue)
- [ListGridField.emptyCellValue](ListGridField.md#attr-listgridfieldemptycellvalue)
- [DetailViewerField.emptyCellValue](DetailViewerField.md#attr-detailviewerfieldemptycellvalue)

**Flags**: IR

---
## Attr: DataSourceField.maxFileSize

### Description
For fields of a type that are represented by binary data initially uploaded from a file (currently "binary" and "imageFile", see [FieldType](../reference_2.md#type-fieldtype)), this sets the maximum file size allowed, in bytes.

### See Also

- [DataSource.maxFileSizeExceededMessage](DataSource.md#classattr-datasourcemaxfilesizeexceededmessage)

**Flags**: IR

---
## Attr: DataSourceField.nativeName

### Description
Only applicable to "sql" dataSources. If set, this property indicates that the field is bound to the column named in the property. It is used to bind a DataSourceField to a database column with a different name.

`nativeName` is useful for disambiguating in cases where you have customized SQL. For example, assume you are joining two tables - call them `product` and `supplier` - that both contain a column called "name". Only one field in the DataSource can be called "name"; to disambiguate, we need to specify both [tableName](#attr-datasourcefieldtablename) and `nativeName`. A field declaration like this would be needed:  

```
    <field name="supplierName" type="text" tableName="supplier" nativeName="name" />
```

You may also wish to use this property to map legacy column names to more meaningful field names in the DataSource. For example:  

```
    <field name="productName" type="text" nativeName="PRDNM" />
```

Note that it is not allowed to have multiple fields with the same `nativeName` bound to the same database table.

### See Also

- [DataSourceField.tableName](#attr-datasourcefieldtablename)

**Flags**: IR

---
## Attr: DataSourceField.getFieldValue

### Description
A [Callback](../reference.md#type-callback), function, or JavaScript expression used to retrieve the field's value from the XML element or JSON record returned from a web service.

This is an advanced attribute for use when a [valueXPath](#attr-datasourcefieldvaluexpath) setting is insufficient to derive a field's value, yet an implementation of [DataSource.transformResponse](DataSource.md#method-datasourcetransformresponse) is overkill.

For the required parameters, see the documentation for [GetFieldValueCallback](Callbacks.md#method-callbacksgetfieldvaluecallback).

### Groups

- clientDataIntegration

**Flags**: IRA

---
## Attr: DataSourceField.useLocalDisplayFieldValue

### Description
The [FormItem.useLocalDisplayFieldValue](FormItem.md#attr-formitemuselocaldisplayfieldvalue) attribute may be specified within a dataSource configuration.

This property governs whether, when displaying a record in an editor component, the `displayField` value for this field should be picked up directly from the record value (as opposed to being retrieved via an explicit fetch operation against the [FormItem.optionDataSource](FormItem.md#attr-formitemoptiondatasource)). See [FormItem.useLocalDisplayFieldValue](FormItem.md#attr-formitemuselocaldisplayfieldvalue) for further details.

If not explicitly set, dataSources backed by the [SmartClient server](../kb_topics/serverDataIntegration.md#kb-topic-server-datasource-integration) will set this property to true automatically for fields where the specified [DataSourceField.displayField](#attr-datasourcefielddisplayfield) values are retrieved from another dataSource using the [DataSourceField.includeFrom](#attr-datasourcefieldincludefrom) feature.

**Flags**: IR

---
## Attr: DataSourceField.customUpdateExpression

### Description
This property specifies the value to use to update this column on "update" operations. The value of this property will be passed through Velocity evaluation and then embedded directly in the SQL generated to perform the update. It can be used in conjunction with [customSelectExpression](#attr-datasourcefieldcustomselectexpression) to provide bi-directional mapping between application data formats and persisted data formats. Or, it can be used unilaterally as a means of silently enforcing data rules - for example, ensuring that all values for a given field are in upper case.

You can use Velocity expressions in your `customUpdateExpression`s, and the [usual context variables](../kb_topics/velocitySupport.md#kb-topic-velocity-context-variables) are available. Note that the results of Velocity evaluations are automatically quoted and escaped by default; this behavior can be switched off - see [autoQuoteCustomExpressions](#attr-datasourcefieldautoquotecustomexpressions), and particularly note the warnings about its use.

The value must be a string that will end up as a valid SQL snippet after Velocity evaluation. The following examples are valid:

*   `"SUBSTR(ANOTHER_COLUMN, 1, 10)"`
*   `"SUBSTR($values.someTextField.toUpperCase(), 1, 10)"`
*   `"SOME_NUMERIC_COLUMN * 1000"`
*   `"$values.someTextField.toUpperCase()"` (this is a technically valid but incorrect usage - see below)

**NOTE:** although all these examples are valid, `customUpdateExpression` is intended to be used when you have a need to customize the actual SQL. If you simply want to use a server-derived value in the query (as is the case with the last of these examples), you should use [Transaction Chaining](../kb_topics/transactionChaining.md#kb-topic-transaction-chaining), [DMI](../kb_topics/dmiOverview.md#kb-topic-direct-method-invocation), or a [server script](../kb_topics/serverScript.md#kb-topic-server-scripting) instead.

In the examples above, the first is an actual SQL snippet and must not be enclosed in quotes. The second shows an SQL snippet containing a literal - because the literal is the result of a Velocity evaluation, it will be automatically quoted so there is no need to do so manually. The third example yields a number, so it must not be quoted. The last example is also the result of a Velocity evaluation and thus does not need to be quoted. Note, however, that this example involves no SQL customization - this kind of usage should be avoided, as noted above.

When an "update" operation runs, any fields that specify [customSelectExpression](#attr-datasourcefieldcustomselectexpression) but do **not** specify customUpdateExpression will be ignored. When an "add" operation runs, this property acts as a default for any fields that do not specify a [customInsertExpression](#attr-datasourcefieldcustominsertexpression); similar to update, any fields that specify a customSelectExpression but do not specify either a customUpdateExpression or customInsertExpression, will be ignored when "add" operations run.

Note that this property only applies to users of the SmartClient server using dataSources of type "sql".

### See Also

- [DataSourceField.customSelectExpression](#attr-datasourcefieldcustomselectexpression)
- [DataSourceField.customInsertExpression](#attr-datasourcefieldcustominsertexpression)
- [DataSourceField.customCriteriaExpression](#attr-datasourcefieldcustomcriteriaexpression)
- [DataSourceField.autoQuoteCustomExpressions](#attr-datasourcefieldautoquotecustomexpressions)

**Flags**: IR

---
## Attr: DataSourceField.skipTypeCoercion

### Description
Ordinarily, SmartClient server runs `DSResponse` values through type validation logic in order to ensure that values are of the correct type. Eg, for a field declared to be type "date", type validation will ensure that the value is an instance of `java.util.Date`; if it isn't, the server will attempt to coerce it into an instance of that class - for a date, this coercion attempt would take the form of trying to parse the `toString()` form of the raw value.

If `skipTypeCoercion` is true, the server skips this step. You may wish to do this if you have other value manipulation logic in place - for example in a [translator](#attr-datasourcefieldtranslatorclassname) or [fieldValueScript](#attr-datasourcefieldfieldvaluescript) - so you do not need the automatic type coercion, or don't want it for some other reason, such as performance. It may also be that you know the data is already in a correctly-typed form, so there is no point in running the type validation/coercion step. For example, data fetched by an `SQLDataSource` will have already been converted to the correct type in advance; similarly, data values coming out of Javabeans with strongly-typed accessor methods cannot help but be the correct type.

**Flags**: IR

---
## Attr: DataSourceField.customSelectExpression

### Description
This property indicates that this field represents a custom expression that should be embedded in the generated SQL instead of a reference to this field. For example, if you have a field `partialName` where this value is set to `SUBSTR(surname, 2)`, the generated SQL would look similar to this:
```
   SELECT ... SUBSTR(surname, 2) AS partialName ...
 
```
Note that adding "AS partialName" as shown above is required - this is how the framework identifies the expression as producing a value for this particular DataSourceField when results are received from the database.

Fields with `customSelectExpression` set can be used for sorting and filtering in the normal way, but they are only applicable to update-type operations if you also provide a corresponding [customUpdateExpression](#attr-datasourcefieldcustomupdateexpression) and/or [customInsertExpression](#attr-datasourcefieldcustominsertexpression). See the documentation for those methods for the rules of how they are applied.

You can use Velocity expressions in your `customSelectExpression`s, and the [usual context variables](../kb_topics/velocitySupport.md#kb-topic-velocity-context-variables) are available. Note that the results of Velocity evaluations are automatically quoted and escaped by default; this behavior can be switched off - see [autoQuoteCustomExpressions](#attr-datasourcefieldautoquotecustomexpressions), and particularly note the warnings about its use.

Note that this property only applies to users of the SmartClient server using dataSources of type "sql".

### See Also

- [DataSourceField.customUpdateExpression](#attr-datasourcefieldcustomupdateexpression)
- [DataSourceField.customInsertExpression](#attr-datasourcefieldcustominsertexpression)
- [DataSourceField.customCriteriaExpression](#attr-datasourcefieldcustomcriteriaexpression)
- [DataSourceField.autoQuoteCustomExpressions](#attr-datasourcefieldautoquotecustomexpressions)

**Flags**: IR

---
## Attr: DataSourceField.sqlDateFormat

### Description
For fields of type "date", "time", and "datetime" that specify an [sqlStorageStrategy](#attr-datasourcefieldsqlstoragestrategy) of "number" or "text", this property allows you to specify the format SmartClient should use to map to/from the underlying value stored in the database. The string provided must be a valid [SimpleDateFormat pattern string](http://download.oracle.com/javase/1.4.2/docs/api/java/text/SimpleDateFormat.html).

For fields of type "datetime" and "time" that specify an [sqlStorageStrategy](#attr-datasourcefieldsqlstoragestrategy) of "number", two special sqlDateFormat values are supported:

*   "epoch" - The datetime or time value is stored as the number of full seconds that have elapsed since January 1, 1970, 00:00:00 GMT.
*   "epochms" - The datetime or time value is stored as the number of milliseconds that have elapsed since January 1, 1970, 00:00:00 GMT. Millisecond precision is preserved through database roundtrips with this setting

This property and the "number" and "text" strategies for date/datetime fields are provided to allow transparent two-way mapping of legacy date values that are stored in numeric or text columns respectively rather than a true "date" column. You would not ordinarily use them in the absence of a legacy database.

Note that this property only applies to users of SmartClient server and data sources of type "sql".

**Flags**: IR

---
## Attr: DataSourceField.name

### Description
Name for this field.

Must be unique across all fields within the DataSource as well as a valid JavaScript identifier - see [FieldName](../reference.md#type-fieldname) for details and how to check for validity.

The field name is also the property in each DataSource record which holds the value for this field.

Note: If this is a [SQL-backed](DataSource.md#attr-datasourceservertype) dataSource, the field name should be a valid SQL colmn name, or the [DataSourceField.nativeName](#attr-datasourcefieldnativename) property should be set to a valid column name.

### Groups

- basics

**Flags**: IR

---
## Attr: DataSourceField.rootValue

### Description
For a field that is a foreignKey establishing a tree relationship, what value indicates a root-level node. Defaults to null.

Note that the rootValue may be overridden on a specific ResultTree instance by setting [ResultTree.rootNode](ResultTree.md#attr-resulttreerootnode), or if the ResultTree is auto-generated by a [TreeGrid](TreeGrid.md#class-treegrid), by setting [TreeGrid.treeRootValue](TreeGrid.md#attr-treegridtreerootvalue). This allows a component to navigate a subtree of the hierarchical data from this dataSource starting at a particular node.

### Groups

- dataSourceRelations

**Flags**: IR

---
## Attr: DataSourceField.storeWithHash

### Description
If set, causes the field to be securely hashed before saving on an "add" or "update" operation.

The default is null except for fields of [DataSourceField.type](#attr-datasourcefieldtype): "password", for which the default is "bcrypt". To disable hashing for password fields, you must set this property to "none".

**Flags**: IR

---
## Attr: DataSourceField.audit

### Description
Determines when the field value should be saved to the audit DataSource when [auditing](DataSource.md#attr-datasourceaudit) is enabled. Setting the property to "change" will conserve storage by only saving out the value when it's changed, and setting it to "never" will exclude the field values from ever being saved during auditing.
#### Binary fields
Because binary data can be very large compared to other data types, and in many use cases does not typically change (for example, an application that stores scanned documents), binary fields are treated specially for auditing purposes:

*   The default `audit` setting is "change"
*   The implied `_filename`, `_filesize` and `_date_created` metadata fields inherit their `audit` setting from the associated binary field, if no explicit setting is provided for the metadata field. This includes inheriting the the implicit "change" default. See the [binary fields overview](../kb_topics/binaryFields.md#kb-topic-binary-fields) for more details about the binary metadata fields, including how to provide explicit properties for them
*   By default, we determine if the binary content has changed by comparing the `_filename` and `_filesize` metadata values. If both those values are unchanged, we assume the content is also unchanged. If you want to compare the actual binary content instead, set `DataSource` property [DataSource.compareMetadataForAuditChangeStatus](DataSource.md#attr-datasourcecomparemetadataforauditchangestatus) to false, but bear in mind this may have performance implications, as described in the documentation for that property

**Flags**: IR

---
## Attr: DataSourceField.valueWriteXPath

### Description
Alternative XPath expression used to set the field's value.

If is not set, then [dataSourceField.valueXPath](#attr-datasourcefieldvaluexpath) is used, see its description for details.

See also SmartClient server java APIs `DataSource.setProperties()` and `DSResponse.setData()`.

### Groups

- clientDataIntegration

**Flags**: IR

---
## Attr: DataSourceField.includeVia

### Description
For a field that uses [DataSourceField.includeFrom](#attr-datasourcefieldincludefrom), specifies which [foreignKey](#attr-datasourcefieldforeignkey) field should be used to find records in the related DataSource.

`includeVia` only needs to be set when you have more than one `foreignKey` to the _same_ related DataSource. If you have multiple foreignKeys to multiple _different_ DataSources, there is no need to set `includeVia`.

For example, perhaps you have a DataSource "moneyTransfer" where each record represents a money transfer, where the source and payment currencies are different, and the list of currencies is stored in a related DataSource "currency". Each "moneyTransfer" record is linked to **2** "currency" records, through two different foreignKey fields, "sourceCurrencyId" and "paymentCurrencyId".

The following declarations would be required to use `includeFrom` to get a include the field "currencySymbol" from each of the two related "currency" records.

```
   <field name="sourceCurrencyId" foreignKey="currency.id"/>
   <field name="paymentCurrencyId" foreignKey="currency.id"/>
   <field name="sourceCurrencySymbol" includeFrom="currency.currencySymbol" includeVia="sourceCurrencyId"/>
   <field name="paymentCurrencySymbol" includeFrom="currency.currencySymbol" includeVia="paymentCurrencyId"/>
 
```

#### SQL Templating and `includeVia`

The `includeVia` feature uses SQL table aliases in the generated SQL when generating multiple SQL joins to the same SQL table. When using [SQL Templating](../kb_topics/customQuerying.md#kb-topic-custom-querying-overview), it's sometimes necessary to know the names of the aliases in the generated SQL. The table alias used can be configured via setting [DataSourceField.relatedTableAlias](#attr-datasourcefieldrelatedtablealias) on the `foreignKey` field, for example, using the declarations below, aliases "source" and "payment" would be used for the two "currency" tables.

```
   <field name="sourceCurrencyId" foreignKey="currency.id" relatedTableAlias="source"/>
   <field name="paymentCurrencyId" foreignKey="currency.id" relatedTableAlias="payment"/>
   <field name="sourceCurrencySymbol" includeFrom="currency.currencySymbol" includeVia="sourceCurrencyId"/>
   <field name="paymentCurrencySymbol" includeFrom="currency.currencySymbol" includeVia="paymentCurrencyId"/>
 
```

#### Multiple indirection and `relatedTableAlias`

General rule is that if `relatedTableAlias` is present it is used as alias or its segment, otherwise `foreignKey` field name linked by `includeVia` is used instead. See the "Automatically generated table aliases" section of the [SQL Templating](../kb_topics/customQuerying.md#kb-topic-custom-querying-overview) for the complete set of general rules how aliases are generated. Also, see some samples below.

Sometimes you may have two `includeFrom` fields that include a field which is itself included from another DataSource, for example:

```
   <field name="sourceCurId" nativeName="sourceCurrencyId" foreignKey="currency.id" relatedTableAlias="source"/>
   <field name="sourceCurrencySymbol" includeFrom="currency.currencySymbol" includeVia="sourceCurId"/>
   <field name="sourceCurrencyGroup" includeFrom="currency.groupName" includeVia="sourceCurId"/>
   <field name="paymentCurId" nativeName="paymentCurrencyId" foreignKey="currency.id" relatedTableAlias="payment"/>
   <field name="paymentCurrencySymbol" includeFrom="currency.currencySymbol" includeVia="paymentCurId"/>
   <field name="paymentCurrencyGroup" includeFrom="currency.groupName" includeVia="paymentCurId"/>
 
```
.. where the "currency" DataSource used above is related to the "currencyGroup" DataSource via fields:
```
   <field name="groupId" type="integer" foreignKey="currencyGroup.id" relatedTableAlias="group"/>
   <field name="groupName" type="text" includeFrom="currencyGroup.groupName"/>
 
```
Fields "sourceCurrencyGroup" and "paymentCurrencyGroup" include a field that is itself an included field. In this case "currencyGroup" table will be referenced two times, and its `relatedTableAlias` defined in "currency" DataSource will be prefixed with the referenced by `includeVia` field's `relatedTableAlias` value to make aliases unique in generated SQL: "source\_group" and "payment\_group".

The same aliases would be used if "sourceCurrencyGroup" and "paymentCurrencyGroup" fields were to include "currencyGroup.groupName" _indirectly_:

```
   <field name="sourceCurrencyGroup" includeFrom="currency.currencyGroup.groupName" includeVia="sourceCurId"/>
   <field name="paymentCurrencyGroup" includeFrom="currency.currencyGroup.groupName" includeVia="paymentCurId"/>
 
```

This works the same for more complex relationships. If we add a "moneyTransferDetail" DataSource to the sample above which has multiple references to "moneyTransfer" DataSource and would include fields from "currency" and "currencyGroup" DataSources:

```
   <field name="mtId" nativeName="moneyTransferId" type="integer" foreignKey="moneyTransfer.id" relatedTableAlias="main" />
   <field name="mainTransferName" includeFrom="moneyTransfer.name" includeVia="mtId" />
   <field name="mainSourceSymbol" includeFrom="moneyTransfer.sourceCurrencySymbol" includeVia="mtId" />
   <field name="mainSourceGroup" includeFrom="moneyTransfer.sourceCurrencyGroup" includeVia="mtId" />
   <field name="mainPaymentSymbol" includeFrom="moneyTransfer.paymentCurrencySymbol" includeVia="mtId" />
   <field name="mainPaymentGroup" includeFrom="moneyTransfer.paymentCurrencyGroup" includeVia="mtId" />
   <field name="mtPrevId" nativeName="moneyTransferPreviousId" type="integer" foreignKey="moneyTransfer.id" relatedTableAlias="prev" />
   <field name="previousTransferName" includeFrom="moneyTransfer.name" includeVia="mtPrevId" />
   <field name="previousSourceSymbol" includeFrom="moneyTransfer.sourceCurrencySymbol" includeVia="mtPrevId" />
   <field name="previousSourceGroup" includeFrom="moneyTransfer.sourceCurrencyGroup" includeVia="mtPrevId" />
   <field name="previousPaymentSymbol" includeFrom="moneyTransfer.paymentCurrencySymbol" includeVia="mtPrevId" />
   <field name="previousPaymentGroup" includeFrom="moneyTransfer.paymentCurrencyGroup" includeVia="mtPrevId" />
 
```
In this scenario the "currencyGroup" table will be joined 4 times - for all main/prev transfer and payment/source currency combinations. So, aliases will be prefixed with both intermediate `relatedTableAlias` values: "main\_source\_group", "main\_payment\_group", "prev\_source\_group", "prev\_payment\_group".

It is also allowed to specify a series of FK fields in `includeVia`, for example "moneyTransferDetail" could declare:

```
   <field name="mainSourceCurrencyGroup" includeFrom="moneyTransfer.currency.currencyGroup.groupName" includeVia="mtId.sourceCurId"/>
   <field name="mainPaymentCurrencyGroup" includeFrom="moneyTransfer.currency.currencyGroup.groupName" includeVia="mtId.paymentCurId"/>
 
```
In this case the prefix used for table aliases will be the same, cause relations referenced in `includeVia` are the same as in previous example: "main\_source\_group" and "main\_payment\_group".

**Note** that if [related table alias](#attr-datasourcefieldrelatedtablealias) are completely missing then, according to general rule, `foreignKey` field names will be used in aliases: "mtId\_sourceCurId\_groupId" and "mtId\_paymentCurId\_groupId".

#### Ambiguous `includeFrom` definitions and logging
Considering the flexibility and complexity of configuring relationships between Datasources, it is important to be aware of certain limitations. Specifically, when multiple fields attempt to include the same field from the same related Datasource via the same (default or specified) foreign key, such configurations are not permitted and may result in unpredictable behavior. This scenario is detected and reported as a warning in the server logs during both DataSource loading and DSRequest execution.

In example below, fields "sourceCurrencySymbol", "currency" and "currencySymbol" include the same "currencySymbol" field from the same "currency" DataSource via the same "currencyId" foreign key field. So, for the fields "currency" and "currencySymbol" warnings will be logged as they include the same value as does the "sourceCurrencySymbol" field.

```
   <field name="currencyId" foreignKey="currency.id"/>
   <field name="sourceCurrencySymbol" includeFrom="currency.currencySymbol" />
   <field name="currency" includeFrom="currency.currencySymbol" />
   <field includeFrom="currency.currencySymbol" />
 
```
Additionally there are two server logging categories that may be set to DEBUG level to log details of the entire `includeFrom` setup. Specifically `com.isomorphic.sql.SQLDataSource.Alias` category enables logging for all fields with `includeFrom`, exact direct or indirect include path to the target field, includeVia/aliases used and `com.isomorphic.sql.SQLDataSource.FK` category additionally enables logging for the foreign key fields relations are based on.

#### Extended `includeVia` syntax
In complex cases involving composite foreign keys or indirect relation chains (multi-step paths across multiple DataSources), `includeVia` supports an extended syntax that allows explicit control over how relationships are resolved. See [includeViaSyntax](../kb_topics/includeViaSyntax.md#kb-topic-includevia-syntax) for more details.

### Groups

- dataSourceRelations

### See Also

- [DataSourceField.relatedTableAlias](#attr-datasourcefieldrelatedtablealias)
- [advancedIncludeVia](#advancedincludevia)

**Flags**: IR

---
## Attr: DataSourceField.stringInBrowser

### Description
Server-side setting that causes values for fields of type "integer" or "float" to be represented as Strings when delivered to a web browser, in order to avoid mangling values which cannot be represented faithfully in JavaScript.

JavaScript has a single "Number" type which internally stores numbers in a format equivalent to Java's "Double" - double-precision floating point. This means it cannot represent the full range of Java's Long type: Java Longs can represent integral values between -2^63 to 2^63-1, whereas JavaScript Number can only represent exact integer values between -2^53 and 2^53. Similarly, JavaScript's Number type cannot represent Java's unlimited-size BigInteger or unlimited-precision BigDecimal objects at all.

The `stringInBrowser` setting can be used to deliver numeric values as Strings to the browser. This is intended to allow read-only display and successful round-tripping of the numeric value, however, it will not cause number-oriented features such as [SpinnerItem](SpinnerItem.md#class-spinneritem), [Slider](Slider.md#class-slider), [ListGrid summaries](ListGrid_1.md#attr-listgridshowgridsummary) or range-checking [validators](Validator.md#class-validator) or [criteria](../reference.md#object-advancedcriteria) to actually work.

If `stringInBrowser` is not set, the default behavior is configured by the `server.properties` setting `datasource.defaultStringInBrowser`. If this flag is false, numeric values are delivered to the client as numbers, _even where this will lead to a loss of precision_. If the flag is true (which is the default), the behavior is to prevent range overflow for numeric values:

*   Java values of type Long, BigInteger and BigDecimal will be delivered as String _only if_ they exceed JavaScript's number range.
*   Client-side validation will allow inputs that are outside of JavaScript's normal integer range, and such numbers will remain as Strings after validation, instead of being converted to Numbers
*   Values submitted to the server will be converted to BigInteger if they exceed the range of Java's Long type. This happens during DSRequest validation, before any defined [DMI methods](../kb_topics/dmiOverview.md#kb-topic-direct-method-invocation) are called.

This default set of behaviors is intended to automatically deal with cases like numeric [DataSourceField.primaryKey](#attr-datasourcefieldprimarykey) or [DataSourceField.foreignKey](#attr-datasourcefieldforeignkey) values that are never used as numbers, but happen to use the full Java Long range. To disable the above behaviors, set `stringInBrowser="false"`.

If `stringInBrowser` is explicitly set to true:

*   the value for the field will _always_ be delivered to the browser as a String (no attempt is made to detect the value as out of range / too high precision)
*   client-side validation will do a check for valid format only, and always leave the value as a String. Numeric range validators are ignored client-side (always pass), but are still active server-side.
*   AdvancedCriteria [operators](../reference.md#type-operatorid) that check if values are in a particular range will always pass
*   the field is treated as though [canFilter:false](#attr-datasourcefieldcanfilter) were set, to avoid showing non-functional search interfaces to the user. Set `canFilter="true"` to avoid this effect

This setting is recommended for presenting out-of-range issues or precision loss on fields that represent actual quantities (as opposed to primaryKey or foreignKey fields, which really represent IDs). To ensure unlimited-precision BigDecimal values are preserved, you should also set [DataSourceField.javaClass](#attr-datasourcefieldjavaclass).

Note that responses delivered as JSON or XML, such as responses from the [RESTHandler servlet](../kb_topics/servletDetails.md#kb-topic-the-core-and-optional-smartclient-servlets), are not affected. This setting applies only to responses delivered to a web browser.

The entirety of stringInBrowser processing can be completely disabled by setting `server.properties` flag `datasource.disableStringInBrowser` to true. This will cause all numeric values to be delivered as numbers without even attempting to detect if this will lead to a loss of precision. This setting overrides both the `stringInBrowser` field setting and the `datasource.defaultStringInBrowser server.properties` flag.

**`stringInBrowser` and client-side DataSources**

For DataSources that are not based on the SmartClient Server, the client-side behaviors described above (such as leaving user input in string form if precision would be lost) are active by default.

In addition, if [dataSource.dataFormat:"xml"](DataSource.md#attr-datasourcedataformat) is used, values that would lose precision remain as strings. For JSON, if behavior similar to `stringInBrowser` is desired, your server response must send the values as JSON strings rather than JSON numeric literals.

You can use [DataSource.defaultStringInBrowser](DataSource.md#classattr-datasourcedefaultstringinbrowser) to disable these behaviors. **NOTE:** don't use this setting if you are using the SmartClient Server, use the server.properties approach described above instead.

**Flags**: IR

---
## Attr: DataSourceField.joinType

### Description
This property is only applicable to fields of SQL DataSources that also specify a [foreignKey](#attr-datasourcefieldforeignkey) property; it is ignored for all other fields. Indicates the type of join to make between the tables underlying this DataSource and the other DataSource referred to in the `foreignKey` property, when resolving [includeFrom](#attr-datasourcefieldincludefrom) fields. The default value of null is the same as specifying "inner".

Note, outer joins are allowed for all supported database products only if you are using [ANSI-style joins](DataSource.md#attr-datasourceuseansijoins). If you are using the older strategy of additional join expressions in the WHERE clause, outer joins are only supported for database products that provide a proprietary native syntax for expressing outer joins. Those products are:

*   Oracle
*   Versions of Microsoft SQL Server earlier than 2012, and running in compatibility mode 80

### Groups

- dataSourceRelations

**Flags**: IR

---
## Attr: DataSourceField.group

### Description
For use in [componentSchema](../kb_topics/componentSchema.md#kb-topic-component-schema), indicates what group to place the property in when editing in Reify.

### Groups

- componentSchema

**Flags**: IR

---
## Attr: DataSourceField.canFilter

### Description
Should the user be able to filter data by this field? Affects whether this field will show up in dataBoundComponents with UI for filtering data.

Note that setting `canFilter:false` only affects UI and is not a security feature. Enforcing that filtering cannot be performed server side does not meaningfully increase security, since as long as a field can be viewed by an end user, they can effectively search the field themselves even if the UI doesn't offer a means to do so. If a field should be unable to be viewed entirely by some users, use [DataSourceField.viewRequiresRole](#attr-datasourcefieldviewrequiresrole) and related settings.

Rather than a security setting, `canFilter:false` is intended for situations where it would be redundant or nonsensical to be able to search on a field, or where searching isn't implemented for that field.

### See Also

- [SearchForm.showFilterFieldsOnly](SearchForm.md#attr-searchformshowfilterfieldsonly)
- [SearchForm.canEditFieldAttribute](SearchForm.md#attr-searchformcaneditfieldattribute)

**Flags**: IR

---
## Attr: DataSourceField.ignoreTextMatchStyle

### Description
**NOTE:** Only applicable to [clientOnly](DataSource.md#attr-datasourceclientonly) DataSources and the built-in [SQL](../kb_topics/sqlDataSource.md#kb-topic-sql-datasources), [JPA](../kb_topics/jpaIntegration.md#kb-topic-integration-with-jpa) and [Hibernate](../kb_topics/hibernateIntegration.md#kb-topic-integration-with-hibernate) DataSources available in Pro, Power and Enterprise versions of SmartClient.

Use this flag to inhibit the normal use of [TextMatchStyle](../reference_2.md#type-textmatchstyle) for this field. A field with this flag set will always be tested for exact equality in generated queries, even for filter-style queries where normal behavior would be to use a substring match or similar.

Whether or not the exact match is case-sensitive is determined by the DataSource's [ignoreTextMatchStyleCaseSensitive](DataSource.md#attr-datasourceignoretextmatchstylecasesensitive) setting.

**Flags**: IRW

---
## Attr: DataSourceField.includeSummaryFunction

### Description
When [field.includeFrom](#attr-datasourcefieldincludefrom) is specified and multiple records exist in the related DataSource per record in the including DataSource, `includeSummaryFunction` indicates which [SummaryFunction](../reference_2.md#type-summaryfunction) is used to produce the field value.

**This feature is available with Power or better licenses only.** See [smartclient.com/product](http://smartclient.com/product) for details.

For example, given a DataSource "order" and related DataSource "orderItem", the "itemCount" field below will show the total number of items in each order.

```
  <DataSource ID="order">
     <fields>
        <field name="orderID" type="integer" primaryKey="true" foreignKey="orderItem.orderID" />
        <field name="customerName" type="text" />
        <field name="orderDate" type="date" />
        <field name="itemsCount" includeFrom="orderItem.quantity" includeSummaryFunction="sum" />
     </fields>
  </DataSource>
 
```
This is analogous to the following SQL statement:
```
 SELECT
      order.orderID,
      order.customerName,
      order.orderDate,
      (select sum(_itemsCount.quantity)
          from orderItem _itemsCount
          where _itemsCount.orderID = order.orderID) as itemsCount
 FROM
      order
 
```
The `includeSummaryFunction` feature supports indirect inclusion as well, when the field using it is included from the other DataSource via regular `includeFrom`. For example, given the "order" DataSource above and related "orderItem" DataSource, the "orderItemsCount" field below will show the total number of items in the order each order item record belongs to:
```
  <DataSource ID="orderItem">
     <fields>
        <field name="id" type="integer" primaryKey="true" />
        <field name="orderID" type="integer" foreignKey="order.orderID"/>
        <field name="quantity" type="integer" />
        <field name="unitPrice" type="float" />
        <field name="orderItemsCount" includeFrom="order.itemsCount" />
     </fields>
  </DataSource>
 
```
This is analogous to the following SQL statement:
```
 SELECT
      orderItem.id,
      orderItem.orderID,
      orderItem.quantity,
      orderItem.unitPrice,
      (select sum(_orderItemsCount_orderID.quantity) AS itemsCount
         from order _orderItemsCount
                  join orderItem _orderItemsCount_orderID
                      on _orderItemsCount.orderID = _orderItemsCount_orderID.orderID
         where orderItem.orderID = _orderItemsCount.orderID) as orderItemsCount
 FROM
      orderItem
 
```

Note that tables in sub-select will always use [DataSourceField.relatedTableAlias](#attr-datasourcefieldrelatedtablealias) if set or automatically generated aliases. Automatic aliases are generated according to the rule: first table in possible chain of relations being the name of the field sub-select is getting value for (with underscore "\_" in front) and the rest aliases are built up using foreign key field names in the chained relations leading to the target table. This allows to avoid any conflicts with the tables/aliases from the main query. Like in the second example table "orderItem" is used in both main query without alias and sub-select under `_orderItemsCount_orderID` alias.

Some other common uses:

*   using "max" to show the most recent "order" for a "customer"
*   using "avg" to show the average order size for a "customer"
*   using "concat" to show the names of all "salesReps" involved in an "order" (note: "concat" has limited support - see [SummaryFunction](../reference_2.md#type-summaryfunction)).

**NOTE**: `includeSummaryFunction` and [Server Summaries](../kb_topics/serverSummaries.md#kb-topic-server-summaries) cannot be used in the same [DSRequest](../reference_2.md#object-dsrequest). If both configurations are present, Server Summaries settings always take priority.

### Groups

- serverSummaries

**Flags**: R

---
## Attr: DataSourceField.nullReplacementValue

### Description
If [DataSource.noNullUpdates](DataSource.md#attr-datasourcenonullupdates) is set, the value to use for this field when a null value is assigned to it on an update operation. This property overrides the DataSource-level properties [nullStringValue](DataSource.md#attr-datasourcenullstringvalue), [nullIntegerValue](DataSource.md#attr-datasourcenullintegervalue), [nullFloatValue](DataSource.md#attr-datasourcenullfloatvalue) and [nullDateValue](DataSource.md#attr-datasourcenulldatevalue), for this field only.

NOTE: If you use this property, you are responsible for ensuring that the replacement value is appropriate and valid.

### See Also

- [DataSource.noNullUpdates](DataSource.md#attr-datasourcenonullupdates)
- [DataSource.nullStringValue](DataSource.md#attr-datasourcenullstringvalue)
- [DataSource.nullIntegerValue](DataSource.md#attr-datasourcenullintegervalue)
- [DataSource.nullFloatValue](DataSource.md#attr-datasourcenullfloatvalue)
- [DataSource.nullDateValue](DataSource.md#attr-datasourcenulldatevalue)

**Flags**: IR

---
## Attr: DataSourceField.filterOn

### Description
This property limits where criteria for this field can be applied. By default, criteria can be applied either at the server, or at the [client](ResultSet.md#attr-resultsetuseclientfiltering) where possible, to avoid server round-trips.

When this property is set to `serverOnly`, any change to criteria for this field causes cache-invalidation and a trip to the server.

### Groups

- advancedFilter

**Flags**: IR

---
## Attr: DataSourceField.customCriteriaExpression

### Description
This property indicates that this field should be represented by a custom expression embedded in the WHERE clause of the generated SQL, instead of the generated expression containing this field name that would ordinarily be used. You use this property when you have to accommodate some special way of using a field's value in criteria, other than by directly comparing it to the criteria. For example, if you have a column that contains bit-packed information you will generally need to perform a bitwise AND to filter on that column, rather than an equality check. In this case, you would use a `customCriteriaExpression` something like this (in Oracle):

   `BITAND(myField, $criteria.myField)+0 = $criteria.myField`

Or this (in MySQL or SQL Server):

   `myField & $criteria.myField = $criteria.myField`

As this example shows, a `customCriteriaExpression` is expected to be a complete logical expression that provides both sides of the comparison. After Velocity processing, this example would result in SQL similar to this (for the MySQL case); the colored part comes entirely from the `customCriteriaExpression`:

`SELECT myField, myOtherField FROM myTable WHERE myField & 32 = 32`

`customCriteriaExpression` can also be used with `AdvancedCriteria`. Note that the point mentioned above, about a `customCriteriaExpression` being a complete logical expression that provides both sides of the comparison still applies. This means that when you use `customCriteriaExpression` in conjunction with `AdvancedCriteria`, you effectively switch off support for different [OperatorId](../reference.md#type-operatorid)s to be used on that field, unless you use Velocity expressions containing the special `$criteriaOperator` variable (see below).

When you use `customCriteriaExpression` with `AdvancedCriteria`, the way you access criteria values differs slightly. One option is to use the `$advancedCriteria` Velocity variable, as described in the "Using AdvancedCriteria" section of the [custom querying overview](../kb_topics/customQuerying.md#kb-topic-custom-querying-overview). However, this variable only returns the value from the first [Criterion](../reference_2.md#object-criterion) that uses the field, as found by depth-first search. If your `AdvancedCriteria` contains multiple references to this field, this will not be satisfactory. Therefore, specifically for `customCriteriaExpression`, we provide another Velocity variable, `$criteriaValue`. This variable means "the value on a Criterion referencing this field". An example may serve to clarify this:

Assume you need to extend the above example to filter records where a certain bit is set OR a certain other bit is set. An `AdvancedCriteria` like this would be required (note that the choice of "equals" as the operator in these clauses is completely arbitrary - as discussed above, the operator is ignored when we have a `customCriteriaExpression`, so it would make no difference to the end product if we had used different operators here):

```
   { _constructor: "AdvancedCriteria", operator: "or", criteria: [
       { fieldName: "myField", operator: "equals", value: 32 },
       { fieldName: "myField", operator: "equals", value: 64 },
     ]
   }       
 
```
If you used the `customCriteriaExpression` from above unchanged with this criteria, the following SQL would be generated (in the MySQL case):

`SELECT myField, myOtherField FROM myTable WHERE myField & null = null OR myField & null = null`

This is because `$criteria` is a variable that only works correctly with simple criteria. If you changed the `$criteria` references in the expression to `$advancedCriteria`, the generated SQL would be:

`SELECT myField, myOtherField FROM myTable WHERE myField & 32 = 32 OR myField & 32 = 32`

This is because `$advancedCriteria` always returns the first value it finds for a particular field, as described above. However, if you change the expression so it reads:

   `myField & $criteriaValue = $criteriaValue`

you will now get the correct SQL generated:

`SELECT myField, myOtherField FROM myTable WHERE myField & 32 = 32 OR myField & 64 = 64`

Similar to `$criteriaValue`, we provide a special variable, `$criteriaOperator`. This is intended for use in Velocity expressions, so that your `customCriteriaExpression` can process different operators in different ways. How you choose to interpret an operator is entirely up to you; this variable is both advanced and rarely used. This example is contrived and does not show a usage that would be remotely likely in a real application, but it does show how to use the variable in a Velocity expression:

   `myField #if ($criteriaOperator == "greaterThan") & #else | #end $criteriaValue = $criteriaValue`

For simple criteria, note that `$criteriaOperator` will vary depending on field type and the [textMatchStyle](../reference_2.md#type-textmatchstyle) in force, as follows:

*   Text fields with textMatchStyle "substring" - "iContains"
*   Text fields with textMatchStyle "startsWith" - "iStartsWith"
*   Text fields with textMatchStyle "exact" - "iEquals"
*   All other cases (including text fields with textMatchStyle "exactCase") - "equals"

You can use Velocity expressions in your `customCriteriaExpression`s, and the [usual context variables](../kb_topics/velocitySupport.md#kb-topic-velocity-context-variables) are available. Note that the results of Velocity evaluations are automatically quoted and escaped by default; this behavior can be switched off - see [autoQuoteCustomExpressions](#attr-datasourcefieldautoquotecustomexpressions), and particularly note the warnings about its use.

Note that this property only applies to users of the SmartClient server using dataSources of type "sql".

### See Also

- [DataSourceField.customSelectExpression](#attr-datasourcefieldcustomselectexpression)
- [DataSourceField.customUpdateExpression](#attr-datasourcefieldcustomupdateexpression)
- [DataSourceField.customInsertExpression](#attr-datasourcefieldcustominsertexpression)
- [DataSourceField.autoQuoteCustomExpressions](#attr-datasourcefieldautoquotecustomexpressions)

**Flags**: IR

---
## Attr: DataSourceField.imageHeight

### Description
Height of the image-content of this field. If set as a string, represents the name of another field in the record that holds the imageHeight. Applicable only to fields of image type or fields that use a [ViewFileItem](../reference.md#class-viewfileitem) as an editor.

**Flags**: IR

---
## Attr: DataSourceField.joinPrefix

### Description
Defines prefix before concatenated values if field is used with [Server summaries](../kb_topics/serverSummaries.md#kb-topic-server-summaries) feature and the [summary function](../reference_2.md#type-summaryfunction) is "concat".

### Groups

- serverSummaries

### See Also

- [DataSourceField.joinString](#attr-datasourcefieldjoinstring)
- [DataSourceField.joinSuffix](#attr-datasourcefieldjoinsuffix)
- [SummaryFunction](../reference_2.md#type-summaryfunction)

**Flags**: IR

---
## Attr: DataSourceField.javaClass

### Description
Explicitly declares the Java class that should be used when data from the client is validated by the SmartClient server and/or applied to Java Beans / POJOs via the server-side API `com.isomorphic.datasource.DataSource.setProperties()`. This includes auto-populating POJO arguments of a [DMI](../kb_topics/dmiOverview.md#kb-topic-direct-method-invocation) method, or populating JPA/Hibernate beans with data when using the built-in JPA and Hibernate DataSources.

For DataSources that do not use Java Beans, `javaClass` can be used to force a particular representation for validated DSRequest data (e.g. data passed to a DMI):

*   for fields declared to be of type "integer" or "float" valid settings include "BigInteger", "Long", "Integer", "Short", "Byte", "AtomicInteger", "AtomicLong", "BigDecimal", "Double"and "Float" (or rather, the fully-qualified versions of those classes, such as "java.lang.Integer" and "java.math.BigDecimal")
*   for fields declared to be of type "date" valid settings include basic "java.util.Date", "java.sql.Date" and "java.sql.Time" types as well as Joda-Time types "DateTime", "DateMidnight", "LocalDateTime", "LocalDate", "LocalTime" and Java 8 Date/Time API types "LocalDate", "LocalDateTime", "LocalTime".

When populating Java Beans/ POJOs, `javaClass` does not normally have to be specified: SmartClient will use Java reflection to inspect the type of argument expected by a setter method and will attempt conversion of inbound data to that type. As described in the documentation for `DataTools.setProperties()`, this works for almost all typical cases. However `field.javaClass` is useful for:

*   subobject of abstract or interface type: in this case Java Reflection is not sufficient to discover the concrete type that should be instantiated, and `javaClass` should be set instead.
*   subobject of Collection or Map type, when Java generics are not used or the Collection member type or Map value type is abstract. When Java generics are used (for example the setter takes an argument is of type Collection`<SomePOJO>` or Map<KeyType,SomePOJO>, SmartClient will automatically attempt to convert inbound data to the type of the members of the Collection or values of the Map. Without generics, `javaClass` needs to be specified. Note that `javaClass` will take precedence over generics if both are used. Also note that [DataSourceField.javaCollectionClass](#attr-datasourcefieldjavacollectionclass) can be specified if a particular Collection or Map type is needed, and [DataSourceField.javaKeyClass](#attr-datasourcefieldjavakeyclass) can be specified for a field of type `java.util.Map`.

**NOTE:** It is also possible to make SmartClient Server determine the javaClass to use dynamically at runtime. See the description of `DataSource.getPropertyJavaClass()` in the server documentation for details.

**Flags**: IR

---
## Attr: DataSourceField.sqlFalseValue

### Description
For fields of type "boolean" that specify a [sqlStorageStrategy](#attr-datasourcefieldsqlstoragestrategy) of "singleChar", this is the value to persist for false values. Note that the common use cases of storing booleans as T/F, Y/N and 1/0 are already catered for without the need for this property.  
For fields of type "boolean" that specify a [sqlStorageStrategy](#attr-datasourcefieldsqlstoragestrategy) of "string", this is the value to persist for false values that require using the entire value.  

You can specify NULL as a valid value for sqlFalseValue, using this XML notation:

```
 <sqlFalseValue xsi:nil="true"></sqlFalseValue>
 
```

### See Also

- [DataSourceField.sqlStorageStrategy](#attr-datasourcefieldsqlstoragestrategy)
- [DataSourceField.sqlTrueValue](#attr-datasourcefieldsqltruevalue)

**Flags**: IR

---
## Attr: DataSourceField.sqlStorageStrategy

### Description
For certain field types, indicates the strategy to be used to store values to the underlying SQL column.

**Fields of type "boolean"**  
The default strategy for boolean fields is to assume the underlying type of the field is text and store boolean true and false values as the character strings "true" and "false". The following additional strategies are available:

*   "number" or "integer": store true as 1, false as 0
*   "singleChar10": store true as "1", false as "0"
*   "singleCharYN": store true as "Y", false as "N"
*   "singleCharTF": store true as "T", false as "F"
*   "singleChar": store as a single character, using the values defined by [sqlTrueValue](#attr-datasourcefieldsqltruevalue) and [sqlFalseValue](#attr-datasourcefieldsqlfalsevalue)
*   "string": store the entire values defined by [sqlTrueValue](#attr-datasourcefieldsqltruevalue) and [sqlFalseValue](#attr-datasourcefieldsqlfalsevalue)

**Fields of type "date", "time", and "datetime"**  
The default strategy for these types is to use a native type that supports date and time values to the nearest second; the actual type used varies by database. The following additional strategies are available:

*   "nativeDate": Use a native SQL DATE type
*   "number" or "integer": Store the value as a plain numeric value
*   "text": Store the value as a plain text value

The "number" and "text" strategies for date/time/datetime fields are provided to allow transparent two-way mapping of legacy date values; you would not ordinarily use them in the absence of a legacy database. In both cases, the actual format of the number or text string is determined by specifying a [sqlDateFormat](#attr-datasourcefieldsqldateformat) on the field; if no format is specified, the framework defaults to "yyyyMMdd".

**Fields of type "text"**

_NOTE: This section is only applicable for users of Microsoft SQL Server. The "ntext" strategy is ignored for all other databases._

If you are integrating with Microsoft SQL Server, you may run into an issue with that database and double-byte character sets. Although the documentation indicates that string values are sent to the database as Unicode by default, they may undergo conversion at the database end, depending on the collation settings of the database. [This Microsoft support article](http://support.microsoft.com/kb/239530) describes the situation, which is that Unicode is converted to the code page of the database before being used, in order to "provide backward compatibility with existing applications".

To work around this, we provide an `sqlStorageStrategy` of "ntext". Fields that declare this strategy are inserted into queries using the "N syntax", like so:  
   `UPDATE MyTable SET MyTextColumn = N'some text' WHERE MyPK = N'some key'`

This syntax overrides defaults and forces the database to treat strings as Unicode.

Note that declaring a field to be of [type](../reference_2.md#type-fieldtype) "ntext" is exactly equivalent to specifying type "text" and an `sqlStorageStrategy` of "ntext". If you declare a field of type "ntext" when the back-end database is something other than SQL Server, it will be treated as a normal field of type "text".

This property only applies to users of the SmartClient server using dataSources of type "sql".

**Flags**: IR

---
## Attr: DataSourceField.unionOf

### Description
Only applicable to "union" dataSources, this is a comma-separated list of qualified field names, specifying how this unioned field is to be derived. This setting allows full control of the union process for fields that only exist on certain member dataSources, or that are not named in the same way on member dataSources. Consider this example:
```
   <DataSource type="union" unionOf="ds1,ds2,ds3">
     <fields>
       <field name="myRenamedField" unionOf="ds1.someField,ds2.someOtherField" />
     </fields>
   </DataSource> 
```
This field definition states that field `someField` from dataSource `ds1` should be unioned with field `someOtherField` from dataSource `ds2`, and call the resulting bonded field `myRenamedField`. Note that no reference to a field in dataSource `ds3` is provided: this means that the value of `myRenamedField` will be null for any records contributed by `ds3`.

Also note that the above example does not provide a DataSource-level [unionFields](DataSource.md#attr-datasourceunionfields) setting. This means that we will derive a list of fields to union by inspecting every member dataSource and unioning fields with matching names and data types (see [defaultUnionFieldsStrategy](DataSource.md#attr-datasourcedefaultunionfieldsstrategy) for more details of how this is done). However, fields `ds1.someField` and `ds2.someOtherField` will not be part of the auto-derivation, because the system will see that they are being explicitly referenced in a field's `unionOf` property.

### Groups

- unionDataSource

### See Also

- [DataSource.unionFields](DataSource.md#attr-datasourceunionfields)

**Flags**: IR

---
## Attr: DataSourceField.calculated

### Description
Boolean flag to indicate that a dataSource field has its values dynamically calculated rather than being populated in permanent storage.

If explicitly set, this property will be respected by [DataSource.isCalculated](DataSource.md#method-datasourceiscalculated)

**Flags**: IRA

---
## Attr: DataSourceField.joinSuffix

### Description
Defines suffix after concatenated values if field is used with [Server summaries](../kb_topics/serverSummaries.md#kb-topic-server-summaries) feature and the [summary function](../reference_2.md#type-summaryfunction) is "concat".

### Groups

- serverSummaries

### See Also

- [DataSourceField.joinPrefix](#attr-datasourcefieldjoinprefix)
- [DataSourceField.joinString](#attr-datasourcefieldjoinstring)
- [SummaryFunction](../reference_2.md#type-summaryfunction)

**Flags**: IR

---
## Attr: DataSourceField.multipleStorage

### Description
How values for a [multiple:true](#attr-datasourcefieldmultiple) field should be stored.

On the server, field values for `multiple:true` fields are represented as Java Lists in DSRequest and DSResponse objects, but when `multipleStorage` is used, are ultimately stored as Strings.

This storage mechanism is "denormalized" in the sense of [database normalization](http://en.wikipedia.org/wiki/Database_normalization) because the field contains a compound value rather than an atomic value. Specifically, this makes the field harder to use with database features like SQL joins, since its value cannot be directly compared to other, singular fields. For this reason, there's really only a narrow set of cases where it makes sense to use this storage mechanism, consider it if:

*   the values don't appear in any other tables or columns elsewhere in your database (so joins and other comparisons wouldn't be possible anyway)
*   there is no authoritative list of all possible values, or even of popular values; it's basically freeform, like arbitrary, uncurated "tags" applied to photos or links

A `multiple:true` field can be of any [SimpleType](SimpleType.md#class-simpletype), including "date", "time", "datetime", "float", "int" etc. Type will be preserved across a store and reload cycle, so for example a List of values for a field of type "int" will arrive at the server in a DSRequest as a List of Integer, be stored as a String, but appear again as a List of Integer inside a DSResponse. When storing "date", "time" or "datetime" values as Strings, XML schema formats are used - the same that are used for transmission in XML or JSON (see [Date and Time Format and Storage overview](../kb_topics/dateFormatAndStorage.md#kb-topic-date-and-time-format-and-storage) for details).

The `multipleStorage` feature works by transforming from List to String and back inside the server-side DataSource.execute() method. Specifically, inbound DSRequests are transformed before methods that perform actual storage are called (executeUpdate() et al), and DSResponses received from these methods have `multiple:true` field values transformed back into Lists before DataSource.execute() returns the DSResponse.

This transformation approach means that the built-in SQL, JPA and Hibernate connectors all support `multipleStorage`, and `multipleStorage` is also automatically available for any custom DataSource that is capable of storing String values, and implements its storage methods via overrides of executeUpdate(), executeAdd() et al as described in the [custom DataSource overview](../kb_topics/writeCustomDataSource.md#kb-topic-custom-server-datasources).

Note that when using the built-in SQL, JPA and Hibernate connectors, the underlying SQL column should be of 'text' type. The [Database Configuration Tool](../kb_topics/dbConfigTool.md#kb-topic-database-configuration) will automatically generate columns of the correct type for a SQLDataSource. For JPA or Hibernate DataSources, just ensure the type of the Java bean property on your Java object is String.

The default `multipleStorage` setting of null means that the "simpleString" [MultipleFieldStorage](../reference.md#type-multiplefieldstorage) approach will be used if:

*   the field is of a known [SimpleType](SimpleType.md#class-simpletype)
*   the field is not a [DataSourceField.foreignKey](#attr-datasourcefieldforeignkey)

Otherwise, [MultipleFieldStorage](../reference.md#type-multiplefieldstorage) "none" will be used.

#### Criteria and AdvancedCriteria handling

For the built-in SQL, JPA and Hibernate connectors, when `multipleStorage`:"simpleString" or "json" is used, criteria are transformed to replicate the client-side filtering behavior for multiple:true fields, where possible. The following operators are supported with the same behavior as client-side filtering:

*   all String-oriented operators including [pattern operators](../kb_topics/patternOperators.md#kb-topic-patternoperators)
*   regexp / iRegexp (built-in SQL only, JPA and Hibernate do not support these. Additionally, when using PostgreSQL, regexp operators are supported only starting from PostgreSQL version 9.3)
*   isBlank / notBlank
*   isNull / notNull
*   inSet / notInSet
*   equalsField / notEqualsField / iEqualsField / iNotEqualsField

The following operators, which are supported for client-side filtering of multiple:true fields, are not supported for server filtering when using `multipleStorage`:

*   greaterThan/lessThan(OrEqual)
*   "between" and all other operators with [OperatorValueType](../reference_2.md#type-operatorvaluetype) of "valueRange"
*   regexp / iRegexp as noted above

Note that for string-based filtering operators such as "equals", no characters which are part of the [DataSourceField.multipleStorageSeparator](#attr-datasourcefieldmultiplestorageseparator) may be used in the filter string. If any characters from the `multipleStorageSeparator` are present in the filter value, it will always fail to match. For "json" mode, the `multipleStorageSeparator` is effectively the String '","'.

### Groups

- multipleField

**Flags**: IR

---
## Attr: DataSourceField.otherFKs

### Description
In addition to regular [foreignKey](#attr-datasourcefieldforeignkey) this property allows defining multiple foreign keys if the field is related to more than one DataSource.

The format of the `otherFKs` is coma separated foreign key sets, for example: _`"`<firstDS>`.`<fieldName>`,`<secondDS>`.`<fieldName>`"`_. Note that this property works only in addition to the regular FK, i.e. if [foreignKey](#attr-datasourcefieldforeignkey) is not set, then foreign keys defined in `otherFKs` will be completely ignored. If `otherFKs` is specified, it can include the value of the `foreignKey` attribute or it can omit it, listing only additional foreignKeys. There is no impact on functionality from doing it either way.

For example, perhaps you have a `moneyTransfer` DataSource where each record represents a money transfer, which has `receipt` and `invoice` information stored in `receiptDS` and `receiverDS` DataSources. Each money transfer is linked to a receipt and an invoice records through the same `transferDS.id` field via the foreign keys defined in `foreignKey` and `otherFKs` properties:

```
 <DataSource ID="moneyTransfer" ... >
      <field name="id" primaryKey="true"
          foreignKey="receiptDS.id"
          otherFKs="invoiceDS.id"/>
      <field name="receiptInfo" includeFrom="receiptDS.info"/>
      <field name="invoiceInfo" includeFrom="invoiceDS.info"/>
 </DataSource>
 
```
Here, we are including from two different related `DataSources` using the same `foreignKey` field.

Note that `otherFKs` feature is meant to be used in more complex scenarios (see below), so if the example above is all that's needed, then there's no need to use `otherFKs` feature. The result would be the same as if foreign keys would be declared at the "other side", i.e. in `receiptDS` and `invoiceDS` DataSources via regular [DataSourceField.foreignKey](#attr-datasourcefieldforeignkey) property.

If we extend the sample above with a `parentId` joining the `moneyTransfer` DataSource (so called "self-join" relation) and include from `receiptDS` and `invoiceDS` for the "parent" money transfer as well, then `otherFKs` feature must be used. The following declarations would be required to get receipt and invoice information for both the original money transfer and its "parent":

```
 <field name="id" primaryKey="true" foreignKey="receiptDS.id" otherFKs="invoiceDS.id"/>
 <field name="receiptInfo" includeFrom="receiptDS.info"/>
 <field name="invoiceInfo" includeFrom="invoiceDS.info"/>
 <field name="parentId" foreignKey="moneyTransfer.id" relatedTableAlias="parent"/>
 <field name="parentReceiptInfo" includeFrom="moneyTransfer.receiptDS.info"/>
 <field name="parentInvoiceInfo" includeFrom="moneyTransfer.invoiceDS.info"/>
 
```

#### SQL Templating and `otherFKs`

Similar to the `includeVia`, `otherFKs` feature uses SQL table aliases in the generated SQL when generating multiple SQL joins to the same SQL table. When using `SQL Templating`, it's sometimes necessary to know the names of the aliases in the generated SQL. See the "Automatically generated table aliases" section of the [SQL Templating](../kb_topics/customQuerying.md#kb-topic-custom-querying-overview) for the complete set of general rules how aliases are generated.

The `otherFKs` feature uses aliases constructed from two parts:  
\- the [field name](#attr-datasourcefieldname), which otherFKs property is defined on;  
\- the related [DataSource ID](DataSource.md#attr-datasourceid) or the [DataSource.relatedTableAlias](DataSource.md#attr-datasourcerelatedtablealias) if set.

So, in the extended sample above the aliases for the "parent" money transfer related tables would be "_parent\_id_" (regular FK) and "_parent\_**id\_invoiceDS**_" (other FK).

See below the same sample extended with the `detailDS` DataSource storing multiple records per money transfer, joined to `moneyTransfer` DataSource on a one-to-many basis, and include receipt and invoice information for money transfer and its "parent". Also, we'll add `relatedTableAliases` to the invoice DataSource, see all related declarations below:

```
 <DataSource ID="detailDS" ... >
      <field name="id" type="integer" primaryKey="true" >
      <field name="name"/>
      <field name="mtId" foreignKey="moneyTransfer.id" relatedTableAlias="main"/>
      <field name="mainReceipt" includeFrom="moneyTransfer.receiptInfo" includeVia="mtId"/>
      <field name="mainInvoice" includeFrom="moneyTransfer.invoiceInfo" includeVia="mtId"/>
      <field name="mainParentReceipt" includeFrom="moneyTransfer.parentReceiptInfo" includeVia="mtId"/>
      <field name="mainParentInvoice" includeFrom="moneyTransfer.parentInvoiceInfo" includeVia="mtId"/>
 </DataSource>

 <DataSource ID="receiptDS" ... >
      <fields>
          <field name="id" primaryKey="true"/>
          <field name="info"/>
      </fields>
 </DataSource>

 <DataSource ID="invoiceDS" relatedTableAlias="invoice" ... >
      <fields>
          <field name="id" primaryKey="true"/>
          <field name="info"/>
      </fields>
 </DataSource>
 
```
Generated aliases for the receipt/invoice tables will be `main_id`, `main_**id_invoice**` for the money transfer and `main_parent_id`, `main_parent_**id_invoice**` for the "parent" money transfer.

#### `otherFKs` + `includeVia`

The `otherFKs` and the [DataSourceField.includeVia](#attr-datasourcefieldincludevia) features may be used together in even more complex scenarios. In the example below we extend `detailDS` DataSource with a link to the "previous" money transfer and include all of its receipt/invoice information:

```
 <field name="mtPrevId" foreignKey="moneyTransfer.id" relatedTableAlias="prev"/>
 <field name="prevReceipt" includeFrom="moneyTransfer.receiptInfo" includeVia="mtPrevId"/>
 <field name="prevInvoice" includeFrom="moneyTransfer.invoiceInfo" includeVia="mtPrevId"/>
 <field name="prevParentReceipt" includeFrom="moneyTransfer.parentReceiptInfo" includeVia="mtPrevId"/>
 <field name="prevParentInvoice" includeFrom="moneyTransfer.parentInvoiceInfo" includeVia="mtPrevId"/>
 
```
Additionally generated aliases will be `prev_id`, `prev_**id_invoice**` for the money transfer and `prev_parent_id`, `prev_parent_**id_invoice**` for the "parent" money transfer.

The inclusions may as well be indirect like shown below and they would produce same chains of relations, so the generated SQL and table aliases will be the same as above.

```
 <field name="mtPrevId" foreignKey="moneyTransfer.id" relatedTableAlias="prev"/>
 <field name="prevReceipt" includeFrom="moneyTransfer.receiptDS.info" includeVia="mtPrevId"/>
 <field name="prevInvoice" includeFrom="moneyTransfer.invoiceDS.info" includeVia="mtPrevId"/>
 <field name="prevParentReceipt" includeFrom="moneyTransfer.moneyTransfer.receiptDS.info" includeVia="mtPrevId"/>
 <field name="prevParentInvoice" includeFrom="moneyTransfer.moneyTransfer.invoiceDS.info" includeVia="mtPrevId"/>
 
```

### Groups

- dataSourceRelations

### See Also

- [DataSourceField.otherFKs](#attr-datasourcefieldotherfks)
- [DataSource.relatedTableAlias](DataSource.md#attr-datasourcerelatedtablealias)
- [DataSourceField.includeVia](#attr-datasourcefieldincludevia)

**Flags**: IR

---
## Attr: DataSourceField.joinString

### Description
Defines the delimiter between concatenated values if field is used with [Server summaries](../kb_topics/serverSummaries.md#kb-topic-server-summaries) feature and the [summary function](../reference_2.md#type-summaryfunction) is "concat". The default value is ", ".

### Groups

- serverSummaries

### See Also

- [DataSourceField.joinPrefix](#attr-datasourcefieldjoinprefix)
- [DataSourceField.joinSuffix](#attr-datasourcefieldjoinsuffix)
- [SummaryFunction](../reference_2.md#type-summaryfunction)

**Flags**: IR

---
## Attr: DataSourceField.implicitSequence

### Description
For a field of [type](../reference_2.md#type-fieldtype) "sequence" on a DataSource with [serverType:"sql"](DataSource.md#attr-datasourceservertype), this flag indicates that the field is implicitly bound to a sequence. This setting means that SmartClient does not expect to find a value for the field in "add" operations, even if it is marked as a [primaryKey](#attr-datasourcefieldprimarykey), as such fields usually are. It also means that SmartClient does not attempt to retrieve the field value from an actual database sequence, instead relying on the JDBC driver to return the generated value (see the note on `sequenceMode` below).

Implicitly bound columns are a syntactic convenience provided by some databases to simulate the "auto-increment" or "identity" columns available natively in other products, without the underlying sequence having to be explicitly referenced in SQL queries. Currently, these database products support this idea:

*   PostgreSQL has had a "serial" column type for a long time - [http://www.postgresql.org/docs/9.3/static/datatype-numeric.html#DATATYPE-SERIAL](http://www.postgresql.org/docs/9.3/static/datatype-numeric.html#DATATYPE-SERIAL)
*   DB2 has long supported a "GENERATED AS IDENTITY" notation for numeric fields. This may or may not be implemented with a sequence - the documentation does not specify - but we support it via the implicitSequence mechanism because it is so similar to the implicit sequence approach in Oracle. [http://publib.boulder.ibm.com/infocenter/dzichelp/v2r2/index.jsp?topic=%2Fcom.ibm.db2z10.doc.apsg%2Fsrc%2Ftpc%2Fdb2z\_identitycols.htm](http://publib.boulder.ibm.com/infocenter/dzichelp/v2r2/index.jsp?topic=%2Fcom.ibm.db2z10.doc.apsg%2Fsrc%2Ftpc%2Fdb2z_identitycols.htm)
*   Oracle introduced a "GENERATED AS IDENTITY" notation for numeric fields in version 12c - [http://www.oracle-base.com/articles/12c/identity-columns-in-oracle-12cr1.php](http://www.oracle-base.com/articles/12c/identity-columns-in-oracle-12cr1.php)

If you have columns like these in your database, declare them as type "sequence" and mark them with the `implicitSequence` flag.

**NOTE:** If you use this property, you should also set the [DataSource sequenceMode](DataSource.md#attr-datasourcesequencemode) to "jdbcDriver". This is necessary because SmartClient cannot directly query the implicit sequence that is being used behind the scenes, so we must rely on the JDBC driver to do that.

If you use [autoDeriveSchema](DataSource.md#attr-datasourceautoderiveschema) to automatically derive a dataSource from table metadata, SmartClient attempts to identify these special Oracle and Postgres columns by heuristic examination of the metadata. When it identifies such a column, it marks the corresponding dataSourceField `implicitSequence: true`, and changes the sequenceMode on the DataSource to "jdbcDriver". If your table contains one of these columns and SmartClient does not automatically identify it, bear in mind that you can always set this flag manually, even if you are using `autoDeriveSchema`.

This setting has no effect for non-SQL dataSources, or for databases other than those mentioned above.

### Groups

- sqlDataSource

### See Also

- [DataSource.sequenceMode](DataSource.md#attr-datasourcesequencemode)

**Flags**: IR

---
## Attr: DataSourceField.decimalPad

### Description
Applies only to fields of type "float" and enforces a minimum number of digits shown after the decimal point.

For example, a field value of 343.1, 343.104 and 343.09872677 would all be shown as 343.10 if decimalPad is 2.

The original unpadded value is always shown when the value is edited.

### Groups

- appearance

**Flags**: IRW

---
## Attr: DataSourceField.summaryValueTitle

### Description
Title to show in a [Summary of type "title"](../reference_2.md#type-summaryfunction) for this field. If unspecified `title` summaries will show the [DataSourceField.title](#attr-datasourcefieldtitle) for the field.

**Flags**: IR

---
## Attr: DataSourceField.customInsertExpression

### Description
This property is similar to [customUpdateExpression](#attr-datasourcefieldcustomupdateexpression); its value is used during "add" operations. If you do not specify this property, but do specify a `customUpdateExpression`, the `customUpdateExpression` is used instead.

Everything that applies to `customUpdateExpression` also applies to this property, including the observation that fields which specify a [customSelectExpression](#attr-datasourcefieldcustomselectexpression) but no corresponding `customUpdateExpression` or `customInsertExpression`, will be ignored when adding new records.

As with `customUpdateExpression`, this property is only intended to be used when you have a need to customize the actual SQL. If you simply want to use a server-derived value in the query, you should use [Transaction Chaining](../kb_topics/transactionChaining.md#kb-topic-transaction-chaining), [DMI](../kb_topics/dmiOverview.md#kb-topic-direct-method-invocation), or a [server script](../kb_topics/serverScript.md#kb-topic-server-scripting) instead.

#### `customInsertExpression` with `primaryKey` fields
if you use `customInsertExpression` to derive a value for a [primaryKey](#attr-datasourcefieldprimarykey) field, the key value will not by default be available to the framework, so the built-in cache synchronization system will not work. It may be possible to to work around this with the [autoGenerated](#attr-datasourcefieldautogenerated) flag, as described below, but otherwise you must also create a [cacheSyncOperation](OperationBinding.md#attr-operationbindingcachesyncoperation) which can retrieve the record just added to the database. Please also see the documentation for [SequenceMode "none"](../reference.md#type-sequencemode), which talks further about cacheSyncOperation.

Typically, `primaryKey` fields that need to be auto-generated are implemented using a sequence field, which at the database level translates to either an actual sequence, or an auto-increment or "identity" column. JDBC drivers have special support for such columns, so we are able to determine the generated value. This is important for primaryKey fields because, without it, we cannot re-fetch the record just inserted for cache synchronization purposes, as described above. Where a value is generated by something other than a sequence field, this special ability is lost - or at least, it is no longer guaranteed to be present.

There are use cases where this may seem to be a restriction. A common case would be where you wish to use a generated UUID as primaryKey value, rather than an ordinary ascending sequence. If you had intended to do this using the database itself - for example, specifying a `customInsertExpression` that calls something like MySQL's `UUID()` built-in function - this is potentially a problem. What we would recommend in this case and anything similar, is to use the general ability for field values to be generated by application code, as described above. (Note, if you want to have application code generate values for primaryKey fields, you may need to use an [operationBinding](OperationBinding.md#class-operationbinding) that specifies [providesMissingKeys](OperationBinding.md#attr-operationbindingprovidesmissingkeys)).

That said, different database vendors implement their JDBC drivers in different ways, and with the SQLDataSource and certain database products it _is_ possible to retrieve values that were generated at the database level by a `customInsertExpression` that expresses either a user-defined function call or an inline subselect, as long as the field is marked with the `autoGenerated` flag. Because this behavior is potentially useful, we do not inhibit it; however, we also do not recommend that you make use of it, because the behavior is not portable across databases, and may also not be portable across JDBC driver versions (because the behavior is unspecified and undocumented, and relies on implementation details that may change). Databases where this behavior has been observed to work include Oracle, Postgres and HSQLDB; databases where this behavior is known not to work include MySQL, SQL Server, DB2 and Firebird (the latter because its JDBC driver does not support the `getGeneratedKeys()` API). Note that in order to retrieve values that were generated at database level [SequenceMode](../reference.md#type-sequencemode) needs to be set to "jdbcDriver" via [DataSource.sequenceMode](DataSource.md#attr-datasourcesequencemode) or via "sql.MyDatabase.sequence.mode" [SQL setting](../kb_topics/sqlSettings.md#kb-topic-sql-database-settings-in-serverproperties).

Note that this property only applies to users of the SmartClient server using dataSources of type "sql".

### See Also

- [DataSourceField.customUpdateExpression](#attr-datasourcefieldcustomupdateexpression)
- [DataSourceField.customSelectExpression](#attr-datasourcefieldcustomselectexpression)
- [DataSourceField.customCriteriaExpression](#attr-datasourcefieldcustomcriteriaexpression)
- [DataSourceField.autoQuoteCustomExpressions](#attr-datasourcefieldautoquotecustomexpressions)

**Flags**: IR

---
## Attr: DataSourceField.sqlTrueValue

### Description
For fields of type "boolean" that specify a [sqlStorageStrategy](#attr-datasourcefieldsqlstoragestrategy) of "singleChar", this is the value to persist for true values. Note that the common use cases of storing booleans as T/F, Y/N and 1/0 are already catered for without the need for this property.  
For fields of type "boolean" that specify a [sqlStorageStrategy](#attr-datasourcefieldsqlstoragestrategy) of "string", this is the value to persist for true values that require using the entire value.

### See Also

- [DataSourceField.sqlStorageStrategy](#attr-datasourcefieldsqlstoragestrategy)
- [DataSourceField.sqlFalseValue](#attr-datasourcefieldsqlfalsevalue)

**Flags**: IR

---
## Attr: DataSourceField.requiredMessage

### Description
The required message when a field that has been marked as [required](#attr-datasourcefieldrequired) is not filled in by the user.

Note that this setting wins over [DataSource.requiredMessage](DataSource.md#attr-datasourcerequiredmessage) if both are set.

### Groups

- formTitles

**Flags**: IRW

---
## Attr: DataSourceField.multipleValueSeparator

### Description
For fields that are [multiple:true](#attr-datasourcefieldmultiple), the separator used between values when they are displayed.

### Groups

- multipleField

**Flags**: IR

---
## Attr: DataSourceField.updateRequiresRole

### Description
Comma-separated list of user roles that are allowed to update this field. If the current user does not have any of the roles listed, the system will not allow this field to be updated.

**NOTE:** This property only prevents a field from being updated; initialization will still be allowed. You should only use this property if you have a special requirement; ordinarily, use [DataSourceField.editRequiresRole](#attr-datasourcefieldeditrequiresrole), which applies security for both types of write.

### Groups

- fieldLevelAuth
- declarativeSecurity

### See Also

- [DataSourceField.editRequiresAuthentication](#attr-datasourcefieldeditrequiresauthentication)
- [DataSourceField.editRequiresRole](#attr-datasourcefieldeditrequiresrole)
- [DataSourceField.initRequires](#attr-datasourcefieldinitrequires)

**Flags**: IR

---
## Attr: DataSourceField.formula

### Description
If `field.formula` is set, this field's value in records will be calculated dynamically.

`DataSourceField.formula` is supported for [SQL DataSources](../reference_2.md#type-dsservertype) and for [clientOnly dataSources](DataSource.md#attr-datasourceclientonly) only.

Valid formula expressions may reference other field values directly by field name, or may reference the record object itself. Formula expressions may make use of standard [FormulaFunctions](../kb_topics/formulaFunction.md#kb-topic-datasourcefield-formula-functions).

For example, given a dataSource with two numeric fields "population" and "area" you could easily add a "populationDensity" field with the following formula:

```
 <field name="populationDensity" type="float">
      <formula>round(population/area)</formula>
 </field>
 
```

For SQL DataSources, values are calculated on the server by modifying the generated SQL request as appropriate. For clientOnly dataSources, values are calculated as part of the [standard fetch response flow](DataSource.md#method-datasourcegetclientonlyresponse). Since the field values are calculated in the data source layer, standard capbilities like server side sorting of paged data sets are supported for these fields. This would not be the case for formula field values calculated [at the component level](ListGridField.md#attr-listgridfielduserformula).

As with other [dynamically calculated](DataSource.md#method-datasourceiscalculated) fields, fields with a specified formula are non editable.  
When records are displayed in [dataBoundComponents that support editing](../reference.md#interface-databoundcomponent), formula field values will be re-calculated dynamically on the client as the user edits a record, so a user may preview the result of their changes.

Note that `formula` fields may not make use of [fields included from related dataSources](#attr-datasourcefieldincludefrom). **DataSourceField.formula is available with Power or better licenses only.** See [smartclient.com/product](http://smartclient.com/product) for details.

### Groups

- calculatedDataSourceFields

**Flags**: IR

---
## Attr: DataSourceField.editRequires

### Description
Indicates that the specified [VelocityExpression](../reference_2.md#type-velocityexpression) must evaluate to true if writes to this field are to be allowed. If the specified expression does not evaluate to true, the field will be removed from the request as described for [editRequiresAuthentication](#attr-datasourcefieldeditrequiresauthentication).

In addition to the normal context variables available to Velocity expressions in SmartClient, expressions you write for field-level `requires` clauses - `editRequires`, [viewRequires](#attr-datasourcefieldviewrequires), [initRequires](#attr-datasourcefieldinitrequires) and [updateRequires](#attr-datasourcefieldupdaterequires) - can reference two additional variables: `$fieldName` and `$dsName`. These are the names of the dataSource and field currently undergoing `requires` checks. They are helpful because they allow you to write a generic checker function that can be used to handle `requires` checks for multiple fields and dataSources.

**NOTE:** This property prevents both initialization and updates for a field. If you have a need to prevent _just_ initialization or _just_ updates, you can use [DataSourceField.initRequires](#attr-datasourcefieldinitrequires) or [DataSourceField.updateRequires](#attr-datasourcefieldupdaterequires).

### Groups

- fieldLevelAuth
- declarativeSecurity

### See Also

- [DataSourceField.editRequiresAuthentication](#attr-datasourcefieldeditrequiresauthentication)
- [DataSourceField.editRequiresRole](#attr-datasourcefieldeditrequiresrole)
- [DataSourceField.viewRequires](#attr-datasourcefieldviewrequires)

**Flags**: IR

---
## Attr: DataSourceField.foreignDisplayField

### Description
Name of another field in a separate dataSource that should be used as the display value for this field in the case where a `foreignKey` relationship exists. Derived automatically when using the displayField / includeFrom pattern as illustrated in the following example.

For a general overview on picking up display values from a separate field, see [DataSourceField.displayField](#attr-datasourcefielddisplayfield) property.

The `foreignDisplayField` property is useful for editable fields, where the name of the display field within the record being edited differs from the display field for related records in the option dataSource.  
For example consider a "countryDS" dataSource with the following fields:

```
  <field name="id"     type="sequence"   hidden="true"     primaryKey="true" />
  <field name="name"   type="text"       title="Country"   required="true" />
 
```
...and a "city" dataSource which uses a foreignKey relationship identify associated country records:
```
  <field name="id"        type="sequence" hidden="true"   primaryKey="true" />
  <field name="name"      type="text"     title="City"    required="true" />
  <field name="countryId" type="integer"  editorType="SelectItem" 
             foreignKey="countryDS.id" 
             displayField="countryName" foreignDisplayField="name" title="Country" />
  <field name="countryName" includeFrom="countryDS.name"  hidden="true"   />
 
```
A DynamicForm bound to this "city" dataSource would display a SelectItem editor by default for the country field. The initial display value would be the local value from the "countryName" field, populated from the related countryDS automatically via the [DataSourceField.includeFrom](#attr-datasourcefieldincludefrom) feature.  
If the user showed the drop-down list of options for this field, the display values within that list would be picked up from the "name" field values for the related "countryDS" records. Again, note that the foreignDisplayField would have been derived in this case, and need not be specified explicitly.

Note that when specified, `foreignDisplayField` is always expected to be set to the related dataSource field containing equivalent values to the `displayField` in the local dataSource. This is important as, when editing the field, foreignDisplayField values from the related dataSource will be displayed to the user, and when a value is selected the local record's `displayField` value will be updated to match the selected `foreignDisplayField` value from the related dataSource's record. This behavior is documented under [FormItem.displayField](FormItem.md#attr-formitemdisplayfield).

### Groups

- dataSourceRelations

**Flags**: IR

---
## Attr: DataSourceField.batchUploadOperationId

### Description
Used to look up key values for fields with [importStrategy.display](#attr-datasourcefieldimportstrategy) while importing data using [BatchUploader](BatchUploader.md#class-batchuploader) or `DataImport` server-side API.

Normally key values are looked up performing "fetch" operation on related data source, but setting `batchUploadOperationId` allows to control which operation will be performed. This can be useful to avoid unnecessary load when importing big data sets, if default "fetch" operation is too heavy.

By default the look up is not case sensitive but this can be controlled through the [batchUploadCaseSensitive](#attr-datasourcefieldbatchuploadcasesensitive) attribute.

**Flags**: IR

---
## Attr: DataSourceField.exportTitle

### Description
Optional different field-title used for exports.

**Flags**: IR

---
## Attr: DataSourceField.displayField

### Description
When records from this dataSource are displayed in a dataBoundComponent such as a [ListGrid](ListGrid_1.md#class-listgrid), the `displayField` attribute may be used to cause some field to display a value from another field in the record.

This is typically used for editable [DataSourceField.foreignKey](#attr-datasourcefieldforeignkey) fields. In this scenario, a dataSource field has a foreignKey field which stores an ID value used to identify records in another, related dataSource. Rather than display this ID to users, developers may wish to display another, user-friendly field from the related record. This is easy to achieve by having a second field on the dataSource which will be populated with the "display value" from this related dataSource, and using `dataSourceField.displayField` to show this value. The [DataSourceField.includeFrom](#attr-datasourcefieldincludefrom) feature handles populating this field automatically for dataSources backed by the [SmartClient Server](../kb_topics/serverDataIntegration.md#kb-topic-server-datasource-integration). See the "Editing included fields" section of the [DataSourceField.includeFrom](#attr-datasourcefieldincludefrom) documentation for more on editing included foreignKey fields.

Editable dataSourceFields with a specified `displayField` and `foreignKey` will typically be edited using a [SelectItem](SelectItem.md#class-selectitem) or [ComboBoxItem](ComboBoxItem.md#class-comboboxitem). In this case, in addition to identifying the field to use as a static display value within the record being edited, `displayField` will also identify which field on the related dataSource to use as a display field when showing a set of options to the user. This behavior may be modified in a couple of ways:

*   The [DataSourceField.foreignDisplayField](#attr-datasourcefieldforeigndisplayfield) attribute may be used to handle the case where the name of the field used as a displayField within the dataSource is different from the name of the included/equivalent field in the related dataSource.
*   The [DataSourceField.useLocalDisplayFieldValue](#attr-datasourcefielduselocaldisplayfieldvalue) attribute may be explicitly set to false to avoid picking up a display value from the local record altogether. Instead the displayField will be used only to derive the display value from a related record from the optionDataSource

For more on how FormItems use the displayField property, see [FormItem.displayField](FormItem.md#attr-formitemdisplayfield).

### Groups

- dataSourceRelations

**Flags**: IR

---
## Attr: DataSourceField.nillable

### Description
Controls whether an explicit null-valued Record attribute for this field should result in `xsi:nil` being used to transmit the value when serializing to XML, like so:
```
 <book>
     <title>Beowulf</title>
     <author xsi:nil="true"/>
 </book>
 
```
If `nillable` is not set, no XML element will be generated for the explicit null value.

A DataSourceField that specifies a `foreignKey` is automatically nillable unless this property is explicitly set to `false`.

### Groups

- dataType

**Flags**: IR

---
## Attr: DataSourceField.uploadFieldName

### Description
Used by the [BatchUploader](BatchUploader.md#class-batchuploader) to map a field in an upload file to this dataSourceField. This is only necessary if the dataSourceField's name and title differ from the name of the field in the upload file (SmartClient will automatically map upload fields using the dataSourceField's title, if possible, if it does not get a direct match on field name).

**Flags**: IR

---
## Attr: DataSourceField.encodeInResponse

### Description
When set for a field with binary data, binary data will be delivered as a Base64 encoded string.

When `encodeInResponse` is not set normal responses will not contain values for binary fields at all. Instead, UI components, such as [TileGrid](TileGrid.md#class-tilegrid) issue a second binary fetch for binary data when appropriate, and APIs such as [downloadFile()](DataSource.md#method-datasourcedownloadfile) and [viewFile()](DataSource.md#method-datasourceviewfile) can be used to programmatically trigger downloads.

Only applicable to fields of a type that are represented by binary data (currently "binary" and "imageFile", see [FieldType](../reference_2.md#type-fieldtype)).

**Flags**: IRW

---
## Attr: DataSourceField.imageSize

### Description
Width and height of the image-content of this field. If set as a string, represents the name of another field in the record that holds the imageSize. Applicable only to fields of image type or fields that use a [ViewFileItem](../reference.md#class-viewfileitem) as an editor.

**Flags**: IR

---
## Attr: DataSourceField.defaultOperator

### Description
The default search-operator for this field.

If not specified, falls back to the default specified for the field's [data-type](SimpleType.md#attr-simpletypedefaultoperator).

### Groups

- advancedFilter

**Flags**: IR

---
## Attr: DataSourceField.precision

### Description
Applies only to fields of type "float" or "integer" and affects how many significant digits are shown.

For example, a field value of 343.1, 343.104 and 343.09872677 would all be shown as 343.10 if precision is 5.

The original value is always shown when the value is edited.

### Groups

- appearance

**Flags**: IRW

---
## Attr: DataSourceField.importStrategy

### Description
Declares the `FieldImportStrategy` for this field. The default setting of null has the same meaning as "auto". Note, this attribute only has an effect if all of the following are true:

*   The field declares a [foreignKey](#attr-datasourcefieldforeignkey)
*   The field declares a [displayField](#attr-datasourcefielddisplayfield)
*   The displayField so declared is [included from](#attr-datasourcefieldincludefrom) the same DataSource that the `foreignKey` declaration refers to

In any other circumstances, this attribute is ignored.

`importStrategy` is applied by the server-side `DataImport.importToRows()` method, which is in turn used by [BatchUploader](BatchUploader.md#class-batchuploader) and several other DataImport APIs such as `importToDataSource()`, `importDataSourceRecords()` and `importAndValidateDSRows()`. See the server-side documentation for details of these APIs. The actual data transformation is carried out by the server-side API `DataSource.transformImportValue()`; this method can be overridden to carry out any other transformation you may require.

### See Also

- [DataSourceField.batchUploadOperationId](#attr-datasourcefieldbatchuploadoperationid)

**Flags**: IR

---
## Attr: DataSourceField.childrenProperty

### Description
If true, this property indicates that this field will hold an explicit array of child nodes for the current node. This has the same effect as specifying [DataSource.childrenField](DataSource.md#attr-datasourcechildrenfield) to this field's name.

### Groups

- dataSourceRelations

### See Also

- [DataSource.childrenField](DataSource.md#attr-datasourcechildrenfield)

**Flags**: IR

---
## Attr: DataSourceField.multiple

### Description
Indicates that this field should always be Array-valued. If the value derived from [XML or JSON data](DataSource.md#attr-datasourcedataformat) is singular, it will be wrapped in an Array.

JPA and Hibernate DataSources use `multiple:true` as part of the declaration of One-To-Many and Many-to-Many relations - see [jpaHibernateRelations](../kb_topics/jpaHibernateRelations.md#kb-topic-jpa--hibernate-relations) for details. On fields that also declare a [foreignKey](#attr-datasourcefieldforeignkey) `multiple:true` also indicates that this field is participating in a one-to-many or many-to-many relation - see [dataSourceRelations](../kb_topics/dataSourceRelations.md#kb-topic-relations) for details.

#### Criteria on multiple:true fields: client-side filtering

For simple Criteria, the criteria value is compared to _each_ field value in the `multiple:true` field, according to the [textMatchStyle](DSRequest.md#attr-dsrequesttextmatchstyle). If _any_ field value matches the j filter value, the field is considered to match the criteria.

For [AdvancedCriteria](../reference.md#object-advancedcriteria), for normal [search operators](../reference.md#type-operatorid) the field value is considered as matching the `Criterion` if _any_ of the field values match the Criterion. Specifically, this is true of all operators that have an [operatorValueType](../reference_2.md#type-operatorvaluetype) of "fieldType" or "valueRange".

For operators that compare against other fields in same record, such as "equalsField", if the other field is _not_ `multiple:true`, matching works the same as for normal operators, that is, as if `criterion.value` directly contained the value rather than the name of another field.

If the other field is _also_ multiple:true, only "equalsField", "notEqualsField", "iEqualsField" and "iNotEqualsField" are allowed (any other `operator` will cause a warning and be ignored) and the set of values in the field must be identical (aside from case, for operators prefixed with "i") and in identical order to match.

For the `inSet` operator, the field matches if there is any intersection between the field values and the array of values provided in `criterion.value`. `notInSet` is the reverse.

"Finally, for "isNull" and "notNull", an empty Array is considered non-null, however, for "isBlank" and "notBlank", an empty Array is considered blank, since a control such as a multiple:true SelectItem or MultiComboBoxItem would appear blank to the end user if it had an empty Array as its value.

#### Server-side Representation and Storage

Values for multiple:true fields appear as Java Lists when received in server code such as a DMI. The SmartClient Server supports simple storage of values that are multiple:true, controlled via the [DataSourceField.multipleStorage](#attr-datasourcefieldmultiplestorage) setting.

For server-side behavior of relation fields that are multiple:true, see +link{group:dataSourceRelations); for the specifics of JPA and Hibernate relation fields that are multiple:true, see [jpaHibernateRelations](../kb_topics/jpaHibernateRelations.md#kb-topic-jpa--hibernate-relations).

For non-relation fields, the SmartClient Server supports simple storage of values that are multiple:true, controlled via the [DataSourceField.multipleStorage](#attr-datasourcefieldmultiplestorage) setting, with some limited support for server-side filtering, as described in the [DataSourceField.multipleStorage](#attr-datasourcefieldmultiplestorage) docs.

For the built-in SQL, Hibernate and JPA connectors, if criteria are specified for a multiple:true field where `multipleStorage` is null or "none", the SmartClient server knows nothing about how the multiple values are stored, so as a fallback the criteria will operate as though the field were a normal, non-multiple "text" field. This will generally **not** match the client-side filtering behavior described above, so filtering should either be performed entirely on the client (for example, via [dataFetchMode:"local"](ListGrid_1.md#attr-listgriddatafetchmode) or entirely on the server (via [ResultSet.useClientFiltering](ResultSet.md#attr-resultsetuseclientfiltering):"false")

The server-side filtering is done through a criteria transform which happens with [transformMultipleFields](DataSource.md#attr-datasourcetransformmultiplefields).

#### XML Serialization

Specifically for XML serialization and deserialization, `multiple:true` behaves similarly to the [SOAP array idiom](http://www.google.com/search?hl=en&q=soap+array), that is, there will be a "wrapper element" named after the field name, whose contents will be several elements of the specified [field.type](#attr-datasourcefieldtype).

For example, [Layout.members](Layout.md#attr-layoutmembers) is declared with `type:"Canvas", multiple:true`. The correct XML format is thus:

```
 <VLayout>
     <members>
         <Canvas ID="myCanvas" ... />
         <ListGrid ID="myGrid" .../>
         <Toolstrip ID="myToolStrip" ... />
     </members>
 </VLayout>
 
```

See [DataSourceField.childTagName](#attr-datasourcefieldchildtagname) for customizing the tagName used for subelements.

### Groups

- xmlSerialize
- componentSchema

**Flags**: IR

---
## Attr: DataSourceField.outputWhen

### Description
Specifies, for this field only, the type of condition field must match to be fetched from underlying source of data and delivered to the client.

This setting overrides the [DSRequest.outputs](DSRequest.md#attr-dsrequestoutputs), meaning that if field is included in request.outputs, but does not match outputWhen condition, it won't be fetched and delivered to the client.

This setting does not affect [OperationBinding.outputs](OperationBinding.md#attr-operationbindingoutputs), meaning that if field is explicitly listed in operationBinding.outputs, then it will be fetched and delivered to the client regardless of outputWhen condition.

### See Also

- [OperationBinding.outputs](OperationBinding.md#attr-operationbindingoutputs)
- [DSRequest.outputs](DSRequest.md#attr-dsrequestoutputs)

**Flags**: IR

---
## Attr: DataSourceField.lenientXPath

### Description
Indicates that getting [DataSourceField.valueXPath](#attr-datasourcefieldvaluexpath) for this field should not perform any validation at all and will return null for non existing XPaths. Otherwise warning message will be logged for non-existing XPath or with null objects in the middle of XPath.

NOTE: this applies to server-side processing of valueXPath only.

**Deprecated**

**Flags**: IR

---
## Attr: DataSourceField.tableName

### Description
Only applicable to "sql" dataSources, setting `tableName` indicates that this field will be coming from another table by way of a [customized SQL query](../kb_topics/customQuerying.md#kb-topic-custom-querying-overview).

By default, the SQL generator will **not** include this field in generated SQL for "add" or "update" operations. It will include the field in the SELECT clause and WHERE clause of customized "fetch" operations, where it is expected that you will make the table available via a custom `<tableClause>` as shown in *this sample*.

The table name will also be used to qualifying the column name unless [DataSource.qualifyColumnNames](DataSource.md#attr-datasourcequalifycolumnnames) or [OperationBinding.qualifyColumnNames](OperationBinding.md#attr-operationbindingqualifycolumnnames) has been disabled.

**Note:** This property is only required when including fields from tables other than the default table specified by [DataSource.tableName](DataSource.md#attr-datasourcetablename).

### See Also

- [DataSourceField.nativeName](#attr-datasourcefieldnativename)

**Flags**: IR

---
## Attr: DataSourceField.type

### Description
Type of this field. Required for all DataSource fields.

Field type may imply automatic validators (for example, an integer field cannot accept the value "foo"). Field type also affects the default behaviors of DataBound components, for example, if a field is declared as type "date", components that edit that field will automatically choose a date-editing interface with pop-up date picker.

### Groups

- basics

**Flags**: IR

---
## Attr: DataSourceField.viewRequires

### Description
Indicates that the specified [VelocityExpression](../reference_2.md#type-velocityexpression) must evaluate to true if values for the field are to be fetched. If the specified expression does not evaluate to true, the field will be dropped as described for [viewRequiresAuthentication](#attr-datasourcefieldviewrequiresauthentication).

In addition to the normal context variables available to Velocity expressions in SmartClient, expressions you write for field-level `requires` clauses - `viewRequires`, [editRequires](#attr-datasourcefieldeditrequires), [initRequires](#attr-datasourcefieldinitrequires) and [updateRequires](#attr-datasourcefieldupdaterequires) - can reference two additional variables: `$fieldName` and `$dsName`. These are the names of the dataSource and field currently undergoing `requires` checks. They are helpful because they allow you to write a generic checker function that can be used to handle `requires` checks for multiple fields and dataSources.

### Groups

- fieldLevelAuth
- declarativeSecurity

### See Also

- [DataSourceField.viewRequiresAuthentication](#attr-datasourcefieldviewrequiresauthentication)
- [DataSourceField.viewRequiresRole](#attr-datasourcefieldviewrequiresrole)
- [DataSourceField.editRequires](#attr-datasourcefieldeditrequires)

**Flags**: IR

---
## Attr: DataSourceField.detail

### Description
Whether this field should be considered a "detail" field by a [DataBoundComponent](../reference.md#interface-databoundcomponent).

Detail fields won't be shown by default in a DataBoundComponent where [DataBoundComponent.showDetailFields](DataBoundComponent.md#attr-databoundcomponentshowdetailfields) is false. This allows for some DataBound components, like a [ListGrid](ListGrid_1.md#class-listgrid), to show a summary view of records which displays only the most commonly viewed fields by default, while other DataBoundComponents, like a [DetailViewer](DetailViewer.md#class-detailviewer), show all fields by default.

In addition, the [formItem.showIf](FormItem.md#method-formitemshowif) property is supported in multiple components for conditional visibility - see for example [ListGridField.showIf](ListGridField.md#method-listgridfieldshowif) and [FormItem.showIf](FormItem.md#method-formitemshowif)).

### Groups

- componentBinding

**Flags**: IR

---
## Attr: DataSourceField.fkTableCode

### Description
See [DataSource.tableCode](DataSource.md#attr-datasourcetablecode).

**Flags**: R

---
## Attr: DataSourceField.propertiesOnly

### Description
For use in [componentSchema](../kb_topics/componentSchema.md#kb-topic-component-schema) for fields that contain other components, this flag suppresses auto-construction for subcomponents that appear under this field.

For example, the [VLayout](../reference.md#class-vlayout) schema sets this for its [members](Layout.md#attr-layoutmembers) property, so that when a VLayout is constructed via XML as follows:

```
 <VLayout>
     <members>
         <ListGrid ID="myGrid" .../>
         <Toolstrip ID="myToolStrip" ... />
     </members>
 </VLayout>
 
```
The ListGrid and ToolStrip do not construct themselves automatically. Instead, the VLayout receives the properties of the ListGrid and ToolStrip as ordinary JavaScript Objects, with the special property `_constructor` set to the name of the class that should be constructed.

### Groups

- componentSchema

**Flags**: IR

---
## Attr: DataSourceField.format

### Description
Format string to use when rendering the value in any [DataBoundComponent](../reference.md#interface-databoundcomponent) or when exporting via [DataSource.exportData](DataSource.md#method-datasourceexportdata) or [ListGrid.exportData](ListGrid_2.md#method-listgridexportdata) or [ListGrid.exportClientData](ListGrid_2.md#method-listgridexportclientdata).

Supported for fields of type "date", "time", "datetime", "int", "float" or any derived [SimpleType](SimpleType.md#class-simpletype).

To configure a different format for export, use [DataSourceField.exportFormat](#attr-datasourcefieldexportformat).

This is a per-field setting; you can alternatively set a default format for all "date", "time" or "datetime" fields via [DateUtil.setNormalDatetimeDisplayFormat](DateUtil.md#classmethod-dateutilsetnormaldatetimedisplayformat) and related methods on [Date](../reference_2.md#object-date). See also [localizedNumberFormatting](../reference.md#kb-topic-localized-number-formatting) for built-in [FieldTypes](../reference_2.md#type-fieldtype) that handle localized currency formatting.

Also note, this property takes precedence over any specified [dateFormatter](#attr-datasourcefielddateformatter), but can be overridden on a per-component basis by providing a formatter directly on the component, for example, via [ListGrid.formatCellValue](ListGrid_2.md#method-listgridformatcellvalue) or [FormItem.formatValue](FormItem.md#method-formitemformatvalue).

### See Also

- [DataSourceField.exportFormat](#attr-datasourcefieldexportformat)

**Flags**: IRW

---
