# SortSpecifierUtil Documentation

[← Back to API Index](../reference.md)

---

## Class: SortSpecifierUtil

### Description
Utilities for working with [SortSpecifier](../reference_2.md#object-sortspecifier) objects.

---
## ClassAttr: SortSpecifierUtil.descendingSortDescription

### Description
The description of

### Groups

- i18nMessages

**Flags**: IRW

---
## ClassAttr: SortSpecifierUtil.valueMapNormalizationDescription

### Description
Description of sort value normalization using a [ValueMap](../reference_2.md#type-valuemap).

### Groups

- i18nMessages

**Flags**: IRW

---
## ClassAttr: SortSpecifierUtil.ascendingSortDescription

### Description
The description of

### Groups

- i18nMessages

**Flags**: IRW

---
## ClassAttr: SortSpecifierUtil.normalizationDescriptionSuffix

### Description
A suffix applied to the end of the sort specifier description generated by [SortSpecifierUtil.getDescription](#classmethod-sortspecifierutilgetdescription) when the sort specifier specifies a [normalizer](../reference.md#attr-sortspecifiernormalizer) and [SortSpecifierUtil.getNormalizationDescription](#classmethod-sortspecifierutilgetnormalizationdescription) returns a non-`null` normalization description.

### Groups

- i18nMessages

**Flags**: IRW

---
## ClassAttr: SortSpecifierUtil.customNormalizationDescription

### Description
Description of sort value normalization provided by a non-default normalizer.

### Groups

- i18nMessages

**Flags**: IRW

---
## ClassMethod: SortSpecifierUtil.getDescription

### Description
Returns a human-readable description of the given sort specifier.

### Parameters

| Name | Type | Optional | Default | Description |
|------|------|----------|---------|-------------|
| sortSpecifier | [SortSpecifier](#type-sortspecifier)|[String](#type-string) | false | — | The sort specifier. This may be a sortBy string. |
| fieldContainer | [DataBoundComponent](#type-databoundcomponent) | true | — | The field container for context. |

### Returns

`[HTMLString](../reference.md#type-htmlstring)` — A human-readable description of the sort specifier.

---
## ClassMethod: SortSpecifierUtil.getNormalizationDescription

### Description
Returns a human-readable description of the sort value normalization provided by the given normalizer. Applications may replace this with their own implementation.

### Parameters

| Name | Type | Optional | Default | Description |
|------|------|----------|---------|-------------|
| normalizer | [Any](#type-any) | true | — | The sort value normalizer. |

### Returns

`[HTMLString](../reference.md#type-htmlstring)` — A human-readable description of the sort value normalization provided by the given normalizer, or `null` or an empty string if the normalization should not be described.

### Groups

- i18nMessages

---
