# Generating Reliable AutoTestLocators

[← Back to API Index](../reference.md)

---

## KB Topic: Generating Reliable AutoTestLocators

### Description
The [locators](../reference_2.md#type-autotestlocator) generated by [AutoTest.getLocator](../classes/AutoTest.md#classmethod-autotestgetlocator) will always resolve uniquely back to the target element in a live application when they are first generated. However, changes to the structure of the application on subsequent visits, due to small changes to the application or certain types of dynamically generated UI can make some locator strategies less reliable than others. Most notably, if a locator is relying on simple parent-child (or layout-member) hierarchy to identify a component, any change to that hierarchy will break it, and if a locator is identifying a component by index, this locator can resolve incorrectly if the other children or members of the parent are modified, even with [fallback locator attributes](../reference_2.md#type-autotestlocator).

There are a few simple things a developer can do to allow the AutoTest system to generate reliable locators

## Explicit IDs

If a component has an explicitly specified [ID](../classes/Canvas.md#attr-canvasid), it will be used to identify the target component's UI elements, regardless of where it sits within an application widget hierarchy. By giving key components explicit IDs, you can ensure they will be found by recorded test scripts even if the application layout changes.

Exception: note that if [AutoTest.testRoot](../classes/AutoTest.md#classattr-autotesttestroot) is set, the ID will be ignored when generating locators in favor of identifying their position within the designated test root. You can explicitly override this by setting [Canvas.locateByIDOnly](../classes/Canvas.md#attr-canvaslocatebyidonly).

## Use AutoChildren to improve locator quality for custom components

When defining custom components for use in an application, using the [autoChild pattern](autoChildren.md#kb-topic-autochildren) will ensure that AutoTestLocators that target generated sub-components of a composite component will by identified by their `autoChildName`.

This is preferable to identifying them by pure parent-child relationships as it is unambiguous (does not rely on index or other strategies to identify a component within a group of sibling components), and will continue to work even if you restructure the composite component to change the interim hierarchy.

## Explicit locator parents

Any component can designate itself as a named locatorChild of some parent via [Canvas.setLocatorParent](../classes/Canvas.md#method-canvassetlocatorparent).

As long as this relationship has been defined, locators will directly use the specified locator name to identify the child when generating or resolving locators from the parent.

Note that a widget does not need to be a true descendant of another widget to mark it as its locator parent.

## Defining properties and search segments

As described in the [AutoTestLocator overview](../reference_2.md#type-autotestlocator), locators can include search segments to find descendants by [defining property value](../classes/Canvas.md#method-canvasgetdefiningpropertyname). Developers may choose to set an explicit defining property for some component or custom class to take advantage of this capability. Locators with search segments will reliably find their targets within their parent even if the intervening widget hierarchy has changed.

The SmartClient AutoTest system also provides capabilities for recording automated test scripts for playback on different environments with significant changes. See [portableAutoTests](portableAutoTests.md#kb-topic-writing-autotests-for-multiple-environments) for details.

---
