/*

  SmartClient Ajax RIA system
  Version SNAPSHOT_v15.0d_2025-12-03/LGPL Deployment (2025-12-03)

  Copyright 2000 and beyond Isomorphic Software, Inc. All rights reserved.
  "SmartClient" is a trademark of Isomorphic Software, Inc.

  LICENSE NOTICE
     INSTALLATION OR USE OF THIS SOFTWARE INDICATES YOUR ACCEPTANCE OF
     ISOMORPHIC SOFTWARE LICENSE TERMS. If you have received this file
     without an accompanying Isomorphic Software license file, please
     contact licensing@isomorphic.com for details. Unauthorized copying and
     use of this software is a violation of international copyright law.

  DEVELOPMENT ONLY - DO NOT DEPLOY
     This software is provided for evaluation, training, and development
     purposes only. It may include supplementary components that are not
     licensed for deployment. The separate DEPLOY package for this release
     contains SmartClient components that are licensed for deployment.

  PROPRIETARY & PROTECTED MATERIAL
     This software contains proprietary materials that are protected by
     contract and intellectual property law. You are expressly prohibited
     from attempting to reverse engineer this software or modify this
     software for human readability.

  CONTACT ISOMORPHIC
     For more information regarding license rights and restrictions, or to
     report possible license violations, please contact Isomorphic Software
     by email (licensing@isomorphic.com) or web (www.isomorphic.com).

*/
//>ISC_140
//> @class SetFilterItem
// Specialized +link{MultiPickerItem} used for generating search criteria in the
// +link{ListGrid.filterEditor,FilterEditor} and in SearchForms.
// <P>     
// SetFilterItem generates +link{OperatorId, inSet and notInSet} filter criteria 
// from a set of possible values, which can be provided via an explicit
// +link{FormItem.valueMap,valueMap} or 
// +link{MultiPickerItem.optionDataSource,optionDataSource}, or can be derived 
// from the +link{SetFilterItem.filterTargetComponent, target databound component} or 
// a +link{SetFilterItem.sourceList,list of records}.  
// <P>
// In particular, when attached to a databound component such as a ListGrid, 
// SetFilterItem can provide "Excel-style filtering", allowing the user to pick 
// from amongst whatever values are present in the dataset.  
// <P>
// For large datasets, SetFilterItem will also intelligently use locally cached 
// data when possible, deriving its set of options from loaded data without the 
// need for an extra dataSource fetch. Specifically, when 
// +link{ResultSet.allMatchingRowsCached(), all matching records} are loaded in the
// +link{SetFilterItem.filterTargetComponent}, the options are derived from already 
// loaded data. If the set of data is incomplete (due to 
// +link{ResultSet.fetchMode, data paging}), the SetFilterItem will derive options 
// from its optionDataSource.
// <P>
// Note that +link{SetFilterItem.deriveUniqueValues} defaults to <code>true</code>
// for setFilterItems.
// <P>
// When a SetFilterItem is used as a 
// +link{ListGridField.filterEditorType, ListGrid filterEditor},
// the filterTargetComponent will automatically be set to the grid being filtered.
// <p>
// The item's picker-component can be customized via settings such as 
// +link{multiPickerItem.sortField, sortField}, or by configuring 
// +link{type:AutoChild, auto-children} like the 
// +link{multiPickerItem.filterForm, search-form}, the 
// +link{multiPickerItem.pickList, main pickList-grid} or the separate list of 
// +link{multiPickerItem.selectionList, selected values}.  You can use 
// +link{multiPickerItem.optionFilterContext} to apply custom
// <code>requestProperties</code> to fetches from the main <code>pickList</code> grid.
// 
// @treeLocation Client Reference/Forms/Form Items
//
// @inheritsFrom MultiPickerItem
// @visibility external
//<
//<ISC_140
isc.defineClass("SetFilterItem", "MultiPickerItem");

isc.SetFilterItem.addClassProperties({
    // Instances of SetFilterItem will produce criteria with the following operators
    
    editorOperators:["inSet", "notInSet"]
});

isc.SetFilterItem.addProperties({


    //>ISC_140
    //> @attr SetFilterItem.selectionStyle (MultiPickerSelectionStyle : "pickList" : IR)
    // selectionStyle:"shuttle" is not supported for SetFilterItem
    // @visibility external
    //<
    //<ISC_140
    
    selectionStyle:"pickList",


    //>ISC_140
    //> @attr SetFilterItem.toggleUseUnselectedValuesOnSelectAll (Boolean : true : IRA)
    // Should this item toggle between tracking selected options and using them to
    // generate "inSet" criteria and unselected options and using them to generate
    // "notInSet" criteria when the user clicks the +link{multiPickerItem.selectAllButton} and
    // +link{multiPickerItem.deselectAllButton} on an unfiltered list of options.
    // <P>
    // See +link{useUnselectedValues} for more detail
    // @visibility external
    //<
    //<ISC_140
    toggleUseUnselectedValuesOnSelectAll:true,


    //>ISC_140
    //> @attr SetFilterItem.useUnselectedValues (Boolean : true : IRW)
    // The SetFilterItem has the capability to treat its set of options as 
    // selected by default, and explicitly track the options a user has unselected, or
    // treat them as unselected by default and explicitly track the user-selected objects.
    // This attribute denotes whether the item is currently tracking explicitly 
    // selected or unselected values.
    // <P>
    // While tracking selected values, this item will generate 
    // +link{selectedOperator,inSet} criteria. While tracking unselected values, it
    // will generate +link{unselectedOperator,notInSet} criteria.
    // <P>
    // If +link{toggleUseUnselectedValuesOnSelectAll} is true, if the current set of options
    // is unfiltered, the +link{multiPickerItem.selectAllButton} and +link{multiPickerItem.deselectAllButton} will
    // clear any current value and toggle useUnselectedValues - effectively switching
    // between tracking inclusive (inSet) values and exclusive (notInSet) values.
    //
    // @visibility external
    //<
    //<ISC_140
    useUnselectedValues:true,


    //>ISC_140
    //> @attr SetFilterItem.defaultUseUnselectedValues (Boolean : true : IRA)
    // Should this item track unselected or selected values by default?
    // <P>
    // If +link{toggleUseUnselectedValuesOnSelectAll}, for setFilterItems with no
    // current criteria (I.E. no explicitly selected or 
    // unselected values), this property will be evaluated when the pickList is 
    // shown and +link{useUnselectedValues} will be set to match this value.
    // This causes the options in the pickList to always show up checked (or
    // unchecked) by default, matching user expectations of what an "empty" filter
    // represents.
    // <P>
    // May be set to null, in which case useUnselectedValues will not be modified
    // when the pickList is shown for an empty SetFilterItem
    // @visibility external
    //<
    //<ISC_140
    defaultUseUnselectedValues:true,


    //>ISC_140
    //> @attr SetFilterItem.selectedOperator (OperatorId : "inSet" : IRA)
    // Operator for the criteria generated by this item when +link{useUnselectedValues} is 
    // false.
    // @visibility external
    //<
    //<ISC_140
    selectedOperator:"inSet",
    

    //>ISC_140
    //> @attr SetFilterItem.unselectedOperator (OperatorId : "notInSet" : IRA)
    // Operator for the criteria generated by this item when +link{useUnselectedValues} is 
    // true.
    // @visibility external
    //<
    //<ISC_140
    unselectedOperator:"notInSet",


    //>ISC_140
    //> @attr SetFilterItem.deriveUniqueValues (Boolean : true : IRA)
    // @include MultiPickerItem.deriveUniqueValues
    // @visibility external
    //<
    //<ISC_140
    deriveUniqueValues:true,

    //> @attr SetFilterItem.pickListFields (Array of ListGridField : null : IR)
    // @include MultiPickerItem.pickListFields
    // @visibility external
    //<
    
    //>ISC_140
    //> @attr SetFilterItem.canExpand (Boolean : false : IR)
    // @include MultiPickerItem.canExpand
    // @visibility external
    //<
    //<ISC_140


    //>ISC_140
    //> @attr SetFilterItem.expandedPickListFields (Array of ListGridField : null : IR)
    // @include MultiPickerItem.expandedPickListFields
    // @visibility external
    //<
    //<ISC_140


    //>ISC_140
    //> @attr SetFilterItem.sourceList (Array of Record | Tree | ResultSet : null : IRA)
    // If specified, this picker will derive its set of options from this list of records.
    // <P>
    // Note that if the <code>sourceList</code> list is a ResultSet that has not
    // got a complete +link{ResultSet.allMatchingRowsCached(),cache of data} for its
    // criteria, options will be derived by performing a fetch against the resultSet's
    // dataSource.
    // @visibility external
    //<
    //<ISC_140
    


    //>ISC_140
    //> @attr SetFilterItem.filterTargetComponent (DataBoundComponent : null : IR)
    // Target component for which this SetFilterItem is generating criteria.
    // By default the +link{sourceList} will be the +link{listGrid.data,data object}
    // for the target component, and the option dataSource, option criteria, option
    // fetch operation and so on will be derived from the target component's configuration.
    // <P>
    // For a setFilterItem embedded in a +link{listGrid.showFilterEditor,filter editor},
    // this will be the target listGrid.
    //
    // @visibility external
    //<
    //<ISC_140

    getSourceList : function () {
        // if we have an explicitly specified valueMap or sourceList, use it, otherwise
        // derive source list from filter target component if there is one.
        
        var sourceList = this.Super("getSourceList", arguments);
        if (sourceList == null && this.shouldDeriveOptionsFromFilterTargetComponent()) {
            sourceList = this.filterTargetComponent.data;
        }
        return sourceList;
    },

    shouldDeriveOptionsFromFilterTargetComponent : function () {
        if (this.shouldDeriveOptionsFromValueMap()) return false;
        var filterTargetData = this.filterTargetComponent && this.filterTargetComponent.data;
        // If a different explicit optionDataSource was specified we can't use the filter-target component's data set.
        var ODS = isc.DataSource.get(this.optionDataSource);
        return (filterTargetData && (isc.isA.ResultSet(filterTargetData) || isc.isA.ResultTree(filterTargetData)) && 
                (ODS == null || filterTargetData.dataSource == ODS));
    },

    
    showFilterList : function () {
        var sendQueue = false;
        if (isc.isA.ListGrid(this.filterTargetComponent) && 
            this.filterTargetComponent.filterEditor != null) 
        {
            if (this.filterTargetComponent.filterEditor.pendingActionOnPause("performFilter")) {
                // this.logWarn("Performing immediate filter on target component:" + this.filterTargetComponent);
                sendQueue = !isc.RPCManager.startQueue();
                this.filterTargetComponent.filterEditor.performFilter(null, null, null, true);
            }
        }
        this.Super("showFilterList", arguments);
        if (sendQueue) isc.RPCManager.sendQueue();
    },

    // setFilterItem may be used with an explicit filterTargetComponent 
    // In this mode, the set of options displayed are derived from the target component as follows:
    // - pick up implicitCriteria from the filterTargetComponent if we have one
    // - remove any criteria applied *by this item* to the filterTargetComponent's criteria
    //   so our value doesn't impact the available options for further filtering.
    //   [Note - this may be disabled via the undocumented clearComponentTargetFieldCriteria flag]
    // - ensure any explicitly selected values are present in the pickList options
    //
    // The selectionList, if visible, will show the list of selected values.
    // If this needs to be fetched from the server [because deriveUniqueValues is false and
    // we're showing multiple fields], the criteria to retrieve these items will be
    // - implicitCriteria from the filterTargetComponent (required to ensure we're not doing
    //   an unrestrictied fetch against the target DS)
    // - an inSet criteria for the currently selected values.
    // Override getOptionCriteria and getExtraOptionCriteria to handle this.

    clearComponentTargetFieldCriteria:true,
    shouldGetCriteriaFromFilterTarget : function () {

        // This differs from shouldDeriveOptionsFromFilterTargetComponent.
        // The target component may not have filtered yet, in which case data will be
        // null and we should not derive options from it, but we still want to pick up
        // the same criteria to show only the options that will show up in the grid when
        // the criteria is applied

        if (!this.filterTargetComponent || 
            this.optionCriteria != null || 
            this.shouldDeriveOptionsFromValueMap()) 
        {
            return false;
        }

        // If an explicit optionDataSource was specified
        // in which case we can't use the filter-target component's data set.
        var ODS = isc.DataSource.get(this.optionDataSource);
        return (ODS == null || ODS == this.filterTargetComponent.getDataSource());

    },
    // Base criteria applied to both the pickList and the selectionList
    getOptionCriteria : function () {

        if (this.shouldGetCriteriaFromFilterTarget()) {
            return this.filterTargetComponent.getImplicitCriteria(true);

        } else if (this.optionCriteria != null) {
            return this.optionCriteria;
        }

        return this.Super("getOptionCriteria", arguments);
    },
    // Additional criteria to restrict options displayed in the pickList
    getExtraOptionCriteria : function () {
        
        if (!this.shouldGetCriteriaFromFilterTarget()) return this.Super("getExtraOptionCriteria");

        var dataSource = this.getOptionDataSource();

        var criteria;
        var form = this.form,
            grid = this.form.grid;

        var isFilterEditor = grid != null && 
                            isc.isA.RecordEditor(grid) && grid.isAFilterEditor() && 
                            grid.sourceWidget == this.filterTargetComponent;

        if (isFilterEditor) {
            criteria = this.filterTargetComponent.getCriteria();
        } else {
            criteria = form.getValuesAsCriteria();
        }
        // copyCriteria does a recursive clone so it's safe to manipulate this object without
        // impacting the grid.
        criteria = isc.DataSource.copyCriteria(criteria);

        // Assertion: if we have ever contributed to the component's criteria, we expect to see
        // an AC with top-level "and", plus a single entry for the target field that is either inSet or 
        // notInSet
        // Yank this out to get the criteria, without whatever we contributed!
        
        if (this.clearComponentTargetFieldCriteria && 
            criteria && criteria._constructor == "AdvancedCriteria" && 
            criteria.operator == "and" && criteria.criteria) 
        {
            var subcriteria = criteria.criteria;
            for (var i = 0; i < subcriteria.length; i++) {
                if (this.canEditCriterion(subcriteria[i])) {
                    subcriteria.removeAt(i);
                    break;
                }
            }
        }

        // Limit the options to what's actually displayed in the ListGrid
        
        
        // Pick up any filterWindow target criteria
        var textMatchStyle = this.filterTargetComponent.autoFetchTextMatchStyle;
        if (this.filterTargetComponent.getFilterWindowCriteria) {
            var filterWindowCriteria = this.filterTargetComponent.getFilterWindowCriteria();
            if (filterWindowCriteria != null) {
                criteria = dataSource.combineCriteria(filterWindowCriteria, criteria, null,
                                                      textMatchStyle);
            }
        }

        // Pick up criteria from the filterEditor or searchForm (whichever one we aren't!)
        if (isFilterEditor) {
            this.filterTargetComponent.checkForSearchForm();
            if (this.filterTargetComponent.searchFormCriteria) {
                criteria = dataSource.combineCriteria(
                                this.filterTargetComponent.searchFormCriteria, 
                                criteria, 
                                null, 
                                textMatchStyle
                            );
            }
        } else {
            criteria = dataSource.combineCriteria(
                this.filterTargetComponent.getCriteria(), criteria, null, textMatchStyle
            );
        }
    
        //this.logWarn("Calculated extra optionCriteria for filterTargetComponent:" + isc.JSON.encode(optionCriteria));
        return criteria;

    },

    // Override getSourceListFilterContext to look directly at our target component's 
    // dataProperties.requestProperties if it has not yet created its ResultSet data object.
    getSourceListFilterContext : function () {
        
        var dataObject = this.getSourceList(),
            component = this.filterTargetComponent;
        
        if (component != null && 
            (dataObject == null || (dataObject.context == null && dataObject.requestProperties == null))) 
        {
            var fetchRequestProperties = component.fetchRequestProperties;

            var dataProps = component.dataProperties,
                dataRequestProps = dataProps && dataProps.requestProperties;

            if (fetchRequestProperties != null || dataRequestProps != null) {
                return isc.addProperties({}, fetchRequestProperties,dataRequestProps);
            }
        }
        return this.Super("getSourceListFilterContext", arguments);

    },

    // Override getSourceListOperationId to look at the filterTargetComponent if it has
    // not yet created its resultSet
    getSourceListOperationId : function () {

        var dataObject = this.getSourceList(),
            component = this.filterTargetComponent;
        if (component != null && 
            (dataObject == null || (dataObject.context == null && dataObject.requestProperties == null))) 
        {
            if (component.fetchOperation) return component.fetchOperation;
            
        }
        return this.Super("getSourceListOperationId", arguments);
    },


    getDisplayFieldName : function () {
        // If we defaulted the valueFieldName to optionDS.primaryKey,
        // ensure we also modify the displayField to display the
        // values for the field to which the filterEditor is applied!
        if (this.filterByPrimaryKey && this.valueField == null && this.displayField == null) 
        {
            return this.name;
        }
        return this.Super("getDisplayFieldName", arguments);        
    },


    getValueFieldName : function () {
        if (this.valueField != null) return this.valueField;

        // If filterByPrimaryKey is true, default to using the ds primary key
        // to identify records in our pickList selection, and as the criteria
        // fieldName
        
        if (this._usePickTree() && this.filterByPrimaryKey) {
            var ds = this.getOptionDataSource(),
                pk = ds && ds.getPrimaryKeyFieldName();
            
            if (pk != null) return pk;
        }


        
        if (this.filterTargetComponent != null) {
            return this.name;
        }
        return this.Super("getValueFieldName", arguments);
    },

    
    init : function (defaults, a, b, c) {

        if (this.isInGrid()) {
            var grid = this.getListGrid();
            var isFilterEditor = (isc.isA.RecordEditor(grid) && grid.sourceWidget && grid.sourceWidget.filterEditor == grid);
            if (isFilterEditor) {
                this.filterTargetComponent = grid.sourceWidget;
                if (isc.isA.TreeGrid(this.filterTargetComponent)) {
                    var field = this.filterTargetComponent.getField(this.name);
                    if (field != null && field.treeField) {
                        // Default to always filtering tree-fields by primary key rather than
                        // the specified field name.
                        // This ensures that the visible records in the target grid will be 
                        // the specific selected items from the pick tree, rather than there
                        // being ambiguity in the case of duplicate values
                        this.filterByPrimaryKey = true;
                        // If selectionStyle was explicitly specified, don't override it but
                        // if not, set up pickTree defaults
                        var explicitProps = isc.addProperties({},defaults,a,b,c);
                        if (explicitProps.selectionStyle == null) {
                            this.selectionStyle = "pickTree";
                        }
                    }
                }
            }
        }
        this.operator = this.useUnselectedValues ? this.unselectedOperator : this.selectedOperator;
        return this.Super("init", arguments);
    },

    // Override canEditCriterion to ensure we get inSet / notInSet criteria passed to us
    canEditCriterion : function (criterion) {
        return (criterion.fieldName == this.getCriteriaFieldName() && 
                (criterion.operator == this.selectedOperator || criterion.operator == this.unselectedOperator)
               );
    },
    // Override setCriterion to ensure we update our value, our operator and our UI
    setCriterion : function (criterion) {

        // No-op if criteria are unchanged
        var currentCriterion = this.getCriterion();
        var criterionChanged = true;
        if (currentCriterion == null) {
            if (criterion == null) criterionChanged = false;
        } else if (criterion != null) {
            var currentVal = currentCriterion.value || [];
            if (currentCriterion.operator == criterion.operator && 
                currentVal.equals(criterion.value)) 
            {
                criterionChanged = false;
            }
        }
        this._settingCriterion = true;
        if (criterionChanged) {

            var operator = criterion && criterion.operator;
            if (operator != this.selectedOperator && operator != this.unselectedOperator) {
                operator = this.defaultUseUnselectedValues ? this.unselectedOperator : this.selectedOperator;
            }
            // Second parameter tells the pickList to keep it's current selection [it's meaning will just be inverted]
            
            this.setUseUnselectedValues(operator == this.unselectedOperator, true);
        }
        
        var value = criterion && criterion.value;
        this.setValue(value);
        delete this._settingCriterion;

    },

    pickerSelectionUpdated : function () {
        // setCriterion changes useUnselectedValues which triggers a selection changed notification
        // don't run our changed handler!
        if (this._settingCriterion) return;
        return this.Super('pickerSelectionUpdated', arguments);
    },



    // Override getCriteriaFieldName to default to filtering by primaryKey if requested
     
    getCriteriaFieldName : function () {
        if (this.filterByPrimaryKey && this.criteriaField == null) {
            return this.getValueFieldName();
        }
        return this.Super("getCriteriaFieldName", arguments);
    },


    //>ISC_140
    //> @attr SetFilterItem.includePathInInSetCriteria (Boolean : null : IR)
    // When generating an +link{type:OperatorId,inSet} filter criteria, should the full path
    // to any selected nodes be included in the criteria value?
    // <P>
    // If true, when the user selects a node within the pickTree,
    // +link{formItem.getCriterion(),getCriterion()} will include all ancestors of the
    // selected node in any <code>"inSet"</code> criterion value it generates. This means
    // that if the criteria are applied to a target TreeGrid with 
    // +link{treeGrid.keepParentsOnFilter,keepParentsOnFilter:false}, the node (with all its 
    // ancestors) should be present in the TreeGrid's data set.
    // <P>
    // If not explicitly specified, this attribute value defaults to <code>true</code> if this
    // item has a specified +link{filterTargetComponent} where 
    // +link{TreeGrid.keepParentsOnFilter,keepParentsOnFilter} is set to <code>false</code>.
    // Otherwise the attribute value defaults to <code>false</code>.
    //
    // @visibility internal
    //<
    //<ISC_140
    
    includePathInInSetCriteria:false,
    shouldIncludePathInInSetCriteria : function () {
        if (this.includePathInInSetCriteria != null) return this.includePathInInSetCriteria;
        if (this.filterTargetComponent != null && !this.filterTargetComponent.keepParentsOnFilter) return true;
        return false;
    },

    // If a user picks explicit empty string only [ "" ], don't ignore this
    allowEmptyStringInArrayCriterion:true,

    // Override getCriteriaValue to support returning partially selected
    // values form our pickTree if so configured
    // This allows filter criteria to be applied to trees with keepParentsOnFilter:false
    getCriteriaValue : function () {

        // Pick up ancestor paths for pickTrees if necessary
        // Only applies to inSet operators where we need to explicitly include a node an all its 
        // ancestors on a keepParentsOnFilter:false target tree.
        // For notInSet operators we definitely don't want to exclude parents of excluded children!
        if (this._usePickTree() && this.operator == "inSet" && this.shouldIncludePathInInSetCriteria()) {
            var values = [];
            var pickTree = this.pickTree;
            if (pickTree != null) {
                var targetField = this.pickTree.targetField;
                var selection = this.pickTree.selectionManager.getSelectionByKeys(true, false);
                for (var i = 0; i < selection.length; i++) {
                    var value = selection[i][targetField];
                    if (value == null || values.contains(value)) continue; // May be null for autogen'd root node. 
                    values.add(value);

                    // If cascadeSelection is true, getSelectionByKeys() with excludePartialSelections:false
                    // will have picked up all the paths
                    // If not, we need to add the paths here.
                    if (!this.cascadeSelection) {
                        var ancestors = this.pickTree.data.getParents();
                        for (var ii = 0; ii < ancestors.length; ii++) {
                            var value = ancestors[i][targetField];
                            if (value == null || values.contains(value)) continue;
                            values.add(value);
                        }
                    }
                    
                }

                return values;
            }
        }
        return this.Super("getCriteriaValue", arguments);
    },


    //>ISC_140
    //> @method SetFilterItem.setUseUnselectedValues()
    // Clear any current value for this item and dynamically update +link{useUnselectedValues}.
    // @param useUnselectedValues (boolean) new value for useUnselectedValues
    // @visibility external
    //<
    //<ISC_140
    setUseUnselectedValues : function (useUnselectedValues) {
        this.operator = useUnselectedValues ? this.unselectedOperator : this.selectedOperator;
        this.Super("setUseUnselectedValues", arguments);
    }

});
