/*
 * Decompiled with CFR 0.152.
 */
package com.gargoylesoftware.htmlunit.javascript.host.event;

import com.gargoylesoftware.htmlunit.BrowserVersionFeatures;
import com.gargoylesoftware.htmlunit.ScriptResult;
import com.gargoylesoftware.htmlunit.html.DomNode;
import com.gargoylesoftware.htmlunit.html.HtmlBody;
import com.gargoylesoftware.htmlunit.html.HtmlPage;
import com.gargoylesoftware.htmlunit.javascript.host.event.Event;
import com.gargoylesoftware.htmlunit.javascript.host.event.EventTarget;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import net.sourceforge.htmlunit.corejs.javascript.Function;
import net.sourceforge.htmlunit.corejs.javascript.NativeObject;
import net.sourceforge.htmlunit.corejs.javascript.Scriptable;
import net.sourceforge.htmlunit.corejs.javascript.ScriptableObject;
import net.sourceforge.htmlunit.corejs.javascript.Undefined;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class EventListenersContainer
implements Serializable {
    private static final Log LOG = LogFactory.getLog(EventListenersContainer.class);
    private final Map<String, TypeContainer> typeContainers_ = new HashMap<String, TypeContainer>();
    private final EventTarget jsNode_;

    public EventListenersContainer(EventTarget jsNode) {
        this.jsNode_ = jsNode;
    }

    public boolean addEventListener(String type, Scriptable listener, boolean useCapture) {
        if (null == listener) {
            return true;
        }
        TypeContainer container = this.getTypeContainer(type);
        boolean added = container.addListener(listener, useCapture);
        if (!added) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)(type + " listener already registered, skipping it (" + listener + ")"));
            }
            return false;
        }
        return true;
    }

    private TypeContainer getTypeContainer(String type) {
        String typeLC = type.toLowerCase(Locale.ROOT);
        TypeContainer container = this.typeContainers_.get(typeLC);
        if (container == null) {
            container = new TypeContainer();
            this.typeContainers_.put(typeLC, container);
        }
        return container;
    }

    public List<Scriptable> getListeners(String eventType, boolean useCapture) {
        TypeContainer container = this.typeContainers_.get(eventType.toLowerCase(Locale.ROOT));
        if (container != null) {
            return container.getListeners(useCapture);
        }
        return null;
    }

    void removeEventListener(String eventType, Scriptable listener, boolean useCapture) {
        if (listener == null) {
            return;
        }
        TypeContainer container = this.typeContainers_.get(eventType.toLowerCase(Locale.ROOT));
        if (container != null) {
            container.removeListener(listener, useCapture);
        }
    }

    public void setEventHandler(String eventType, Object value) {
        Object handler = value;
        if (handler == Undefined.instance) {
            handler = null;
        }
        TypeContainer container = this.getTypeContainer(eventType);
        container.handler_ = handler;
    }

    private ScriptResult executeEventListeners(boolean useCapture, Event event, Object[] args) {
        DomNode node = this.jsNode_.getDomNodeOrNull();
        if (node == null || !node.handles(event)) {
            return null;
        }
        ScriptResult allResult = null;
        List<Scriptable> listeners = this.getListeners(event.getType(), useCapture);
        if (listeners != null && !listeners.isEmpty()) {
            event.setCurrentTarget((Scriptable)this.jsNode_);
            HtmlPage page = (HtmlPage)node.getPage();
            for (Scriptable listener : listeners) {
                Object handleEvent;
                Function function = null;
                EventTarget thisObject = null;
                if (listener instanceof Function) {
                    function = (Function)listener;
                    thisObject = this.jsNode_;
                } else if (listener instanceof NativeObject && (handleEvent = ScriptableObject.getProperty((Scriptable)listener, (String)"handleEvent")) instanceof Function) {
                    function = (Function)handleEvent;
                    thisObject = listener;
                }
                if (function != null) {
                    ScriptResult result = page.executeJavaScriptFunction((Object)function, thisObject, args, node);
                    if (event.isPropagationStopped()) {
                        allResult = result;
                    }
                    if (this.jsNode_.getBrowserVersion().hasFeature(BrowserVersionFeatures.EVENT_FALSE_RESULT)) {
                        if (ScriptResult.isFalse(result)) {
                            allResult = result;
                        } else {
                            Object eventReturnValue = event.getReturnValue();
                            if (eventReturnValue instanceof Boolean && !((Boolean)eventReturnValue).booleanValue()) {
                                allResult = new ScriptResult(Boolean.FALSE, page);
                            }
                        }
                    }
                }
                if (!event.isImmediatePropagationStopped()) continue;
                return allResult;
            }
        }
        return allResult;
    }

    private ScriptResult executeEventHandler(Event event, Object[] propHandlerArgs) {
        DomNode node = this.jsNode_.getDomNodeOrNull();
        if (node != null && !node.handles(event)) {
            return null;
        }
        Function handler = this.getEventHandler(event.getType());
        if (handler != null) {
            event.setCurrentTarget((Scriptable)this.jsNode_);
            HtmlPage page = (HtmlPage)(node != null ? node.getPage() : this.jsNode_.getWindow().getWebWindow().getEnclosedPage());
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Executing " + event.getType() + " handler for " + node));
            }
            return page.executeJavaScriptFunction((Object)handler, this.jsNode_, propHandlerArgs, (DomNode)page);
        }
        return null;
    }

    public ScriptResult executeBubblingListeners(Event event, Object[] args, Object[] propHandlerArgs) {
        ScriptResult newResult;
        ScriptResult result = null;
        DomNode domNode = this.jsNode_.getDomNodeOrNull();
        if (!(domNode instanceof HtmlBody)) {
            result = this.executeEventHandler(event, propHandlerArgs);
            if (event.isPropagationStopped()) {
                return result;
            }
        }
        if ((newResult = this.executeEventListeners(false, event, args)) != null) {
            result = newResult;
        }
        return result;
    }

    public ScriptResult executeCapturingListeners(Event event, Object[] args) {
        return this.executeEventListeners(true, event, args);
    }

    public Function getEventHandler(String eventType) {
        TypeContainer container = this.typeContainers_.get(eventType.toLowerCase(Locale.ROOT));
        if (container == null) {
            return null;
        }
        return (Function)container.handler_;
    }

    boolean hasEventListeners(String eventType) {
        TypeContainer container = this.typeContainers_.get(eventType);
        return container != null && (container.handler_ instanceof Function || !container.bubblingListeners_.isEmpty() || !container.capturingListeners_.isEmpty());
    }

    ScriptResult executeListeners(Event event, Object[] args, Object[] propHandlerArgs) {
        event.setEventPhase((short)1);
        ScriptResult result = this.executeEventListeners(true, event, args);
        if (event.isPropagationStopped()) {
            return result;
        }
        event.setEventPhase((short)2);
        ScriptResult newResult = this.executeEventHandler(event, propHandlerArgs);
        if (newResult != null) {
            result = newResult;
        }
        if (event.isPropagationStopped()) {
            return result;
        }
        event.setEventPhase((short)3);
        newResult = this.executeEventListeners(false, event, args);
        if (newResult != null) {
            result = newResult;
        }
        return result;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[node=" + this.jsNode_ + " handlers=" + this.typeContainers_.keySet() + "]";
    }

    static class TypeContainer
    implements Serializable {
        private List<Scriptable> capturingListeners_;
        private List<Scriptable> bubblingListeners_;
        private Object handler_;

        TypeContainer() {
            this.capturingListeners_ = Collections.unmodifiableList(new ArrayList());
            this.bubblingListeners_ = Collections.unmodifiableList(new ArrayList());
        }

        private TypeContainer(List<Scriptable> capturingListeners, List<Scriptable> bubblingListeners, Object handler) {
            this.capturingListeners_ = Collections.unmodifiableList(new ArrayList<Scriptable>(capturingListeners));
            this.bubblingListeners_ = Collections.unmodifiableList(new ArrayList<Scriptable>(bubblingListeners));
            this.handler_ = handler;
        }

        private List<Scriptable> getListeners(boolean useCapture) {
            if (useCapture) {
                return this.capturingListeners_;
            }
            return this.bubblingListeners_;
        }

        private synchronized boolean addListener(Scriptable listener, boolean useCapture) {
            List<Scriptable> listeners = this.getListeners(useCapture);
            if (listeners.contains(listener)) {
                return false;
            }
            List<Object> newListeners = new ArrayList<Scriptable>(listeners.size() + 1);
            newListeners.addAll(listeners);
            newListeners.add(listener);
            newListeners = Collections.unmodifiableList(newListeners);
            if (useCapture) {
                this.capturingListeners_ = newListeners;
            } else {
                this.bubblingListeners_ = newListeners;
            }
            return true;
        }

        private synchronized void removeListener(Scriptable listener, boolean useCapture) {
            List<Scriptable> listeners = this.getListeners(useCapture);
            int idx = listeners.indexOf(listener);
            if (idx < 0) {
                return;
            }
            List<Scriptable> newListeners = new ArrayList<Scriptable>(listeners);
            newListeners.remove(idx);
            newListeners = Collections.unmodifiableList(newListeners);
            if (useCapture) {
                this.capturingListeners_ = newListeners;
            } else {
                this.bubblingListeners_ = newListeners;
            }
        }

        protected TypeContainer clone() {
            return new TypeContainer(this.capturingListeners_, this.bubblingListeners_, this.handler_);
        }
    }
}

