#set( $symbol_pound = '#' )
#set( $symbol_dollar = '$' )
#set( $symbol_escape = '\' )
package ${package}.server.ds;

import com.isomorphic.criteria.DefaultOperators;
import com.isomorphic.datasource.DSRequest;
import com.isomorphic.datasource.DSResponse;
import com.isomorphic.datasource.DataSource;

/**
 * A collection of methods to be called during Employee CRUD operations.  See the DmiOverview documentation
 * topic for background.
 * 
 * https://www.smartclient.com/smartgwtee-latest/javadoc/com/smartgwt/client/docs/DmiOverview.html
 */
public final class EmployeeOperations {
	
	/**
	 * When an Employee is added, use their email address to create a user account with a temporary password
	 * and USER group enrollment.
	 */
	public DSResponse add(DSRequest dsRequest) throws Exception {

		DSResponse dsResponse = dsRequest.execute(); 
		
		DSRequest usersRequest = new DSRequest("Users", DataSource.OP_ADD, dsRequest.getRPCManager());
		usersRequest.setFieldValue("USERNAME", dsResponse.getFieldValue("EMAIL"));
		usersRequest.setFieldValue("PASSWORD", "nosecret");
		
		DSResponse usersResponse = usersRequest.execute();
		dsResponse.addRelatedUpdate(usersResponse);
		
		DSRequest rolesRequest = new DSRequest("UserRoles", DataSource.OP_ADD, dsRequest.getRPCManager());
		rolesRequest.setFieldValue("ID", usersResponse.getFieldValue("ID"));
		rolesRequest.setFieldValue("ROLE", "USER");
		
		DSResponse rolesResponse = rolesRequest.execute();
		dsResponse.addRelatedUpdate(rolesResponse);
		
		return dsResponse;
	}
	
	/**
	 * Cascade changes to an Employee's email address to the corresponding username.
	 */
	public DSResponse update(DSRequest dsRequest) throws Exception {
		
		DSResponse dsResponse = dsRequest.execute(); 

		Object email = dsRequest.getFieldValue("EMAIL");
		if (email == null) {
			return dsResponse;
		}

		DSRequest usersRequest = new DSRequest("Users", DataSource.OP_UPDATE, dsRequest.getRPCManager());
		usersRequest.setAllowMultiUpdate(true);
		usersRequest.setCriteriaValue("USERNAME", dsRequest.getOldValues().get("EMAIL"));
		usersRequest.setFieldValue("USERNAME", dsRequest.getFieldValue("EMAIL"));
		
		DSResponse usersResponse = usersRequest.execute();
		dsResponse.addRelatedUpdate(usersResponse);
		
		return dsResponse;
	}

	/**
	 * When an employee is removed, also delete their user profile and group enrollment.
	 */
	public DSResponse remove(DSRequest dsRequest) throws Exception {

		DSRequest userIdRequest = new DSRequest("Users", DataSource.OP_FETCH, dsRequest.getRPCManager());
		userIdRequest.addToCriteria("USERNAME", DefaultOperators.Equals, dsRequest.getOldValues().get("EMAIL"));
		Object userId = userIdRequest.execute().getDataMap().get("ID");
		
		DSResponse dsResponse = dsRequest.execute(); 

		DSRequest rolesRequest = new DSRequest("UserRoles", DataSource.OP_REMOVE, dsRequest.getRPCManager());
		rolesRequest.setFieldValue("ID", userId);
		rolesRequest.setAllowMultiUpdate(true);
		DSResponse rolesResponse = rolesRequest.execute();
		dsResponse.addRelatedUpdate(rolesResponse);
		
		DSRequest usersRequest = new DSRequest("Users", DataSource.OP_REMOVE, dsRequest.getRPCManager());
		usersRequest.setFieldValue("ID", userId);				
		DSResponse usersResponse = usersRequest.execute();
		dsResponse.addRelatedUpdate(usersResponse);
		
		return dsResponse;
	}
	
}