/*
 * Decompiled with CFR 0.152.
 */
package com.isomorphic.webdriver;

import com.isomorphic.webdriver.ByIdentifier;
import com.isomorphic.webdriver.ByScLocator;
import com.isomorphic.webdriver.SeleneseTestCaseParser;
import com.isomorphic.webdriver.SeleneseTestOptions;
import com.isomorphic.webdriver.SmartClientWebDriver;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.ClassUtils;
import org.apache.commons.lang.StringUtils;
import org.openqa.selenium.By;
import org.openqa.selenium.Keys;

class Operation {
    private String operator;
    private List<Object> operands;
    private String andStore;
    private boolean andWait;
    private boolean invert;
    private SeleneseTestCaseParser parser;
    private static String[] stringOnlyOperators = new String[]{"sendKeys", "type", "verifyText", "verifyTable", "waitForText", "waitForEval"};
    private static String[] setterApiVariables = new String[]{"valueTolerance", "elementTolerance", "canvasWidthTolerance", "canvasHeightTolerance", "maxDragPause", "defaultWaitTimeout", "defaultImplicitTimeout"};
    private static Map<String, String> operatorMap = new HashMap<String, String>(){
        {
            this.put("contextMenu", "contextClick");
            this.put("dragAndDropToObject", "dragAndDrop");
            this.put("verifyChecked", "verifyElementSelected");
            this.put("waitForNotElementClickable", "waitForElementNotClickable");
        }
    };

    public Operation(String operator, String operand1, String operand2, SeleneseTestCaseParser parser) {
        Object parsed2;
        this.parser = parser;
        this.operator = operator;
        this.operands = new ArrayList<Object>();
        this.preConvertSeleneseCommandToWebDriver();
        Object parsed1 = this.parse(operand1);
        if (parsed1 instanceof List) {
            for (Object operand : (List)parsed1) {
                this.operands.add(operand);
            }
        } else if (parsed1 != null) {
            this.operands.add(parsed1);
        }
        if ((parsed2 = this.parse(operand2)) instanceof List) {
            for (Object operand : (List)parsed2) {
                this.operands.add(operand);
            }
        } else if (parsed2 != null) {
            this.operands.add(parsed2);
        }
        this.postConvertSeleneseCommandToWebDriver();
    }

    private Object parse(String operand) {
        String lcOperand;
        if (operand == null) {
            return null;
        }
        String stringOperand = operand;
        if (operand.startsWith("\\")) {
            operand = operand.substring(1);
        }
        if (operand.startsWith("//")) {
            operand = "xpath=" + operand;
        }
        if ((lcOperand = operand.toLowerCase()).startsWith("sclocator=")) {
            Pattern pattern;
            Matcher matcher;
            operand = operand.substring(10);
            if (this.operator.endsWith("Table") && (matcher = (pattern = Pattern.compile("(.*)\\.(\\d+)\\.(\\d+)")).matcher(operand)).find()) {
                return new ArrayList<Object>(){
                    {
                        this.add(ByScLocator.scLocator(matcher.group(1)));
                        this.add(Long.parseLong(matcher.group(2)));
                        this.add(Long.parseLong(matcher.group(3)));
                    }
                };
            }
            return ByScLocator.scLocator(operand);
        }
        if (lcOperand.startsWith("id=")) {
            return By.ById.id((String)operand.substring(3));
        }
        if (lcOperand.startsWith("name=")) {
            return By.ByName.name((String)operand.substring(5));
        }
        if (lcOperand.startsWith("identifier=")) {
            return ByIdentifier.identifier(operand.substring(11));
        }
        if (lcOperand.startsWith("xpath=")) {
            return By.ByXPath.xpath((String)operand.substring(6));
        }
        if (this.isSendKeys()) {
            stringOperand = stringOperand.replaceAll("\\$\\{KEY_ESC\\}", "\\${KEY_ESCAPE}");
            stringOperand = stringOperand.replaceAll("\\$\\{KEY_CTRL\\}", "\\${KEY_CONTROL}");
        }
        if (this.isStore(false) && !this.isStore(true)) {
            return stringOperand;
        }
        for (int i = 0; i < stringOnlyOperators.length; ++i) {
            if (!this.operator.startsWith(stringOnlyOperators[i])) continue;
            return stringOperand;
        }
        if (("waitForHoverText".equals(this.operator) || this.takesJavaScript()) && this.operands.size() == 0) {
            return stringOperand;
        }
        if (Operation.isBoolean(operand)) {
            return Boolean.valueOf(operand);
        }
        return Operation.isLong(operand) ? Long.valueOf(Long.parseLong(operand)) : stringOperand;
    }

    protected static boolean isBoolean(String operand) {
        return "true".equalsIgnoreCase(operand) || "false".equalsIgnoreCase(operand);
    }

    protected static boolean isInteger(String operand) {
        try {
            Integer.parseInt(operand);
            return true;
        }
        catch (NumberFormatException nfe) {
            return false;
        }
    }

    protected static boolean isLong(String operand) {
        try {
            Long.parseLong(operand);
            return true;
        }
        catch (NumberFormatException nfe) {
            return false;
        }
    }

    protected static boolean isDouble(String operand) {
        try {
            Double.parseDouble(operand);
            return true;
        }
        catch (NumberFormatException nfe) {
            return false;
        }
    }

    protected static Integer parseInt(String input) {
        try {
            return Integer.parseInt(input.trim());
        }
        catch (NumberFormatException numberFormatException) {
            return 0;
        }
    }

    protected static Double parseDouble(String input) {
        try {
            return Double.parseDouble(input.trim());
        }
        catch (NumberFormatException numberFormatException) {
            return 0.0;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Lifted jumps to return sites
     */
    private static List<String> getElements(String content) {
        ArrayList<String> elements = new ArrayList<String>();
        int searchOffset = 0;
        int elementOffset = 0;
        while (elementOffset < content.length()) {
            int comma = content.indexOf(",", searchOffset);
            int array = content.indexOf("[", searchOffset);
            if (comma < 0) {
                elements.add(content.substring(elementOffset).trim());
                return elements;
            }
            if (array < 0 || comma < array) {
                elements.add(content.substring(elementOffset, comma).trim());
                searchOffset = elementOffset = comma + 1;
                continue;
            }
            int level = 0;
            searchOffset = array;
            block5: while (searchOffset < content.length()) {
                switch (content.charAt(searchOffset++)) {
                    case '[': {
                        ++level;
                        break;
                    }
                    case ']': {
                        if (--level == 0) break block5;
                    }
                }
            }
            if (level != 0) throw new ArrayFormatException();
        }
        return elements;
    }

    protected static boolean isDoubleList(String operand) {
        if (!operand.matches("(?:\\s)*\\[.*\\](?:\\s)*")) {
            return false;
        }
        operand = operand.replaceFirst("(?:\\s)*\\[(.*)\\](?:\\s)*", "$1");
        try {
            for (String element : Operation.getElements(operand)) {
                if (Operation.isDouble(element) || Operation.isDoubleList(element)) continue;
                return false;
            }
            return true;
        }
        catch (ArrayFormatException e) {
            return false;
        }
    }

    protected static List parseDoubleList(String operand) {
        operand = operand.replaceFirst("(?:\\s)*\\[(.*)\\](?:\\s)*", "$1");
        ArrayList<Object> result = new ArrayList<Object>();
        for (String element : Operation.getElements(operand)) {
            result.add(Operation.isDouble(element) ? Operation.parseDouble(element) : Operation.parseDoubleList(element));
        }
        return result;
    }

    private boolean useAdvancedVars() {
        return this.parser.getAdvancedVars() && this.operands.size() == 1;
    }

    public boolean isStore(boolean strict) {
        return strict ? "store".equals(this.operator) : this.operator.startsWith("store");
    }

    public boolean isVerify() {
        return this.operator.startsWith("verify");
    }

    public boolean isWaitFor() {
        return this.operator.startsWith("waitFor");
    }

    public boolean isAssert() {
        return this.operator.startsWith("assert");
    }

    public boolean isSendKeys() {
        return this.operator.startsWith("sendKeys");
    }

    public boolean isMouseUp() {
        return this.operator.startsWith("mouseUp");
    }

    public boolean isMouseDown() {
        return this.operator.startsWith("mouseDown");
    }

    public boolean isWaitForVisible() {
        return this.isWaitFor() && this.operator.contains("Visible");
    }

    public boolean isVerifyNotValue() {
        return this.operator.startsWith("verifyNotValue");
    }

    public boolean shouldSwapStoreOperands(Object operand1, Object operand2) {
        return (!(operand2 instanceof String) || !((String)operand2).matches("[A-Za-z_]+")) && operand1 instanceof String && ((String)operand1).matches("[A-Za-z_]+");
    }

    public boolean isVerifyNotElementSizeOrPosition() {
        return this.operator.startsWith("verifyNotElementwidth") || this.operator.startsWith("VerifyNotElementHeight") || this.operator.startsWith("verifyNotElementPosition");
    }

    public boolean takesJavaScript() {
        if (this.operator.contains("Eval")) {
            return true;
        }
        switch (this.operator) {
            case "runScript": 
            case "waitForCondition": {
                return true;
            }
        }
        return false;
    }

    public Object execute() throws Exception {
        ArrayList<Object> args = new ArrayList<Object>();
        ArrayList types = new ArrayList();
        for (Object operand : this.operands) {
            if (this.isSendKeys() && operand instanceof String) {
                operand = this.convertSeleneseKeysToWebDriver((String)operand);
            }
            if (operand instanceof String) {
                boolean targetJavaScript = this.takesJavaScript() && args.isEmpty();
                operand = this.parser.expandVariables((String)operand, targetJavaScript);
                if (targetJavaScript) {
                    operand = operand.toString();
                }
            }
            args.add(operand);
            types.add(operand.getClass());
        }
        if (this.isStore(true) && this.andStore != null) {
            this.parser.storeVariable(this.andStore, args.get(0), this.useAdvancedVars());
            return true;
        }
        Class[] typesArray = new Class[types.size()];
        typesArray = types.toArray(typesArray);
        Class<SmartClientWebDriver> driverClass = SmartClientWebDriver.class;
        for (Method method : driverClass.getDeclaredMethods()) {
            Class[] params;
            if (!method.getName().equals(this.operator) || (params = method.getParameterTypes()).length != typesArray.length || !ClassUtils.isAssignable((Class[])typesArray, (Class[])params, (boolean)true)) continue;
            try {
                if (this.parser.hasDriver()) {
                    Object result = method.invoke((Object)this.parser.getDriver(), args.toArray());
                    if (this.invert && result instanceof Boolean) {
                        result = (Boolean)result == false;
                    }
                    if (this.andStore != null) {
                        this.parser.storeVariable(this.andStore, result, this.useAdvancedVars());
                    }
                    Object object = result;
                    return object;
                }
                Boolean result = true;
                return result;
            }
            catch (Exception e) {
                System.err.println("!!! Problem executing: " + this);
                throw e;
            }
            finally {
                if (this.andWait) {
                    System.err.println("!!! Webdriver implictly waits and doesn't 100% support: " + this.operator + "AndWait");
                    if (this.parser.hasDriver()) {
                        Thread.sleep(3000L);
                    }
                }
            }
        }
        throw new NoSuchMethodException("No match for: " + this);
    }

    public boolean getAndWait() {
        return this.andWait;
    }

    private void preConvertSeleneseCommandToWebDriver() {
        if (this.operator.endsWith("AndWait")) {
            this.operator = this.operator.substring(0, this.operator.indexOf("AndWait"));
            this.andWait = true;
        }
        switch (this.operator.replace("Not", "")) {
            case "assertEval": {
                break;
            }
            default: {
                this.operator = this.operator.replace("assert", "verify");
            }
        }
        switch (this.operator) {
            case "verifyNotText": 
            case "verifyNotTitle": 
            case "verifyNotVisible": 
            case "verifyNotChecked": 
            case "verifyTextNotPresent": 
            case "verifyElementNotPresent": 
            case "verifyNotElementClickable": 
            case "verifyNotElementReadyForKeyPresses": {
                this.invert = true;
                this.operator = this.operator.replace("Not", "");
            }
        }
        if (this.isVerifyNotValue() || this.isVerifyNotElementSizeOrPosition()) {
            this.operator = this.operator.replace("Not", "");
            this.invert = true;
            return;
        }
        switch (this.operator) {
            case "verifyVisible": {
                this.operator = "verifyElement" + this.operator.substring(6);
            }
        }
        if (this.isWaitForVisible()) {
            this.operator = this.operator.replace("waitFor", "waitForElement");
            return;
        }
        if (this.isMouseUp()) {
            this.operator = this.operator.replace("mouseUp", "release");
            return;
        }
        if (this.isMouseDown()) {
            this.operator = this.operator.replace("mouseDown", "clickAndHold");
            return;
        }
        if (operatorMap.containsKey(this.operator)) {
            this.operator = operatorMap.get(this.operator);
        }
    }

    private void postConvertSeleneseCommandToWebDriver() {
        Object operand2;
        SeleneseTestOptions options = this.parser.getOptions();
        int nOperands = this.operands.size();
        Object operand1 = nOperands >= 1 ? this.operands.get(0) : null;
        Object object = operand2 = nOperands >= 2 ? this.operands.get(1) : null;
        if (this.isStore(false) && nOperands == 2 && this.shouldSwapStoreOperands(operand1, operand2)) {
            operand2 = this.operands.set(0, operand2);
            operand1 = this.operands.set(1, operand1);
        }
        switch (this.operator) {
            case "exampleOpen": {
                if (options != null && nOperands == 2) {
                    String mappedId;
                    String showcase = options.getShowcase();
                    if (showcase == null) {
                        showcase = (String)operand1;
                    }
                    if ((mappedId = options.getMappedId()) == null) {
                        mappedId = (String)operand2;
                    }
                    this.operands.clear();
                    String url = "smartgwt".equals(showcase) ? "index.html" : "SmartClient_Explorer.html";
                    this.operands.add(url + "?autotest=selenese#" + mappedId);
                }
            }
            case "open": {
                this.operator = "get";
                if (options == null) break;
                this.operands.add(options.getMaximize());
                break;
            }
            case "store": {
                if (nOperands != 2 || !(operand2 instanceof String) || !ArrayUtils.contains((Object[])setterApiVariables, (Object)operand2)) break;
                this.operator = "set" + StringUtils.capitalize((String)((String)operand2));
                this.operands.remove(1);
                break;
            }
            case "storeExpression": {
                String operand;
                if (!(operand1 instanceof String) || !(operand = (String)operand1).startsWith("javascript{") || !operand.endsWith("}")) break;
                this.operands.set(0, operand.substring(11, operand.length() - 1));
                this.operator = "storeEval";
                break;
            }
            case "runScript": {
                if (!(operand1 instanceof String)) break;
                String operand = (String)operand1;
                this.operands.set(0, "try { " + operand + "; return; } catch (e) {}");
                this.operator = "getEval";
                break;
            }
            case "setSpeed": {
                if (!(operand1 instanceof Long)) break;
                this.parser.setSpeed((Long)operand1);
                System.err.println("!!! Emulation will now add a " + operand1 + "ms delay between Selenese commands");
                break;
            }
            case "releaseAt": 
            case "mouseMoveAt": 
            case "clickAndHoldAt": {
                int xOffset = 0;
                int yOffset = 0;
                if (nOperands == 2) {
                    String[] xy = ((String)operand2).replace("+", "").split(",");
                    xOffset = Operation.parseInt(xy[0]);
                    yOffset = Operation.parseInt(xy[1]);
                    this.operands.remove(1);
                }
                this.operands.add(xOffset);
                this.operands.add(yOffset);
            }
        }
        nOperands = this.operands.size();
        operand1 = nOperands >= 1 ? this.operands.get(0) : null;
        Object object2 = operand2 = nOperands >= 2 ? this.operands.get(1) : null;
        if (this.isStore(false) && nOperands == 2) {
            switch (this.operator) {
                case "storeEval": 
                case "storeValue": {
                    if (this.parser.getAdvancedVars()) break;
                }
                default: {
                    this.operator = "get" + this.operator.substring(5);
                }
                case "store": {
                    this.operands.clear();
                    this.operands.add(operand1);
                }
            }
            this.andStore = (String)operand2;
        }
    }

    private String convertSeleneseKeysToWebDriver(String operand) {
        Pattern keyPattern = Pattern.compile("\\$\\{KEY_([A-Z_]+)\\}");
        Matcher keyMatcher = keyPattern.matcher(operand);
        while (keyMatcher.find()) {
            Keys currentKey = Keys.valueOf((String)keyMatcher.group(1));
            operand = keyMatcher.replaceFirst(currentKey.toString());
            keyMatcher = keyPattern.matcher(operand);
        }
        return operand;
    }

    public String toJavaString() {
        String result = "";
        for (int i = 0; i < this.operands.size(); ++i) {
            if (i > 0) {
                result = result + ", ";
            }
            Object operand = this.operands.get(i);
            result = result + this.toJavaString(operand, this.operator, i);
        }
        if (!this.isStore(true)) {
            result = "driver." + this.operator + "(" + result + ")";
        }
        if (this.invert) {
            result = "!" + result;
        }
        if (this.andStore != null) {
            if (this.useAdvancedVars()) {
                result = "driver.storeVariable(\"" + this.andStore + "\", " + result + ")";
            }
            result = this.andStore + " = " + result;
        }
        return result + ";";
    }

    private String toJavaString(Object operand, String operator, int index) {
        boolean targetJavaScript;
        boolean bl = targetJavaScript = index == 0 && this.takesJavaScript();
        if (operand instanceof ByScLocator) {
            return ((ByScLocator)((Object)operand)).toJavaString();
        }
        if (operand instanceof String) {
            operand = "\"" + ((String)operand).replace("\"", "\\\"") + "\"";
            if (this.isSendKeys()) {
                return this.seleneseKeysToJavaString((String)operand);
            }
            return this.parser.replaceVarsWithJava((String)operand, targetJavaScript);
        }
        if (operand instanceof Long) {
            return operand.toString() + "L";
        }
        return operand.toString();
    }

    private String seleneseKeysToJavaString(String operand) {
        Pattern keyPattern = Pattern.compile("\\$\\{KEY_([A-Z_]+)\\}");
        Matcher keyMatcher = keyPattern.matcher(operand);
        if (!keyMatcher.find()) {
            return operand;
        }
        String result = keyMatcher.replaceAll("\" + Keys.$1 + \"");
        result = result.replaceAll("^\"\"\\s*\\+\\s*|\\s*\\+\\s*\"\"$", "");
        if ((result = result.replaceAll("\\s*\\+\\s*\"\"\\s*\\+\\s*", " + ")).indexOf("\"") < 0) {
            result = "\"\" + " + result;
        }
        return result;
    }

    public String toString() {
        String result = this.operator + "(";
        for (int i = 0; i < this.operands.size(); ++i) {
            if (i > 0) {
                result = result + ", ";
            }
            Object operand = this.operands.get(i);
            result = result + operand + "/" + operand.getClass().getSimpleName();
        }
        return result + ")";
    }

    public String getOperator() {
        return this.operator;
    }

    private static class ArrayFormatException
    extends RuntimeException {
        private ArrayFormatException() {
        }
    }
}

