/*
 * Decompiled with CFR 0.152.
 */
package com.isomorphic.datasource;

import com.isomorphic.datasource.DSField;
import com.isomorphic.datasource.DSRequest;
import com.isomorphic.datasource.DataSource;
import com.isomorphic.datasource.DataSourceManager;
import com.isomorphic.datasource.IncludeFromInfo;
import com.isomorphic.datasource.Relation;
import com.isomorphic.log.Logger;
import com.isomorphic.util.DataTools;
import java.util.List;
import java.util.Map;

public class IncludeFromDefinition {
    public static final String DYNAMIC_NAME_TOKEN = "\\!";
    private static Logger log = new Logger(IncludeFromDefinition.class.getName());
    private DataSource thisDataSource;
    private String thisFieldName;
    private String includedFieldName;
    private DSField thisField;
    private DSField includedField;
    private String includePath;
    private DataSource[] dataSources;
    private String[] dataSourceNames;
    private IncludeFromDefinition targetIncludeFrom;
    private boolean isCriteria;
    private boolean isSortBy;
    private boolean isDynamic;
    private Relation relation;
    private DSRequest dsRequest;
    private boolean prepared = false;
    private boolean targetInspected = false;
    private String includeVia;
    private boolean inError;

    public static IncludeFromDefinition create(IncludeFromInfo info, DSRequest dsRequest) {
        if (info == null) {
            return null;
        }
        Map<String, DataSource> dsObjectsMap = dsRequest.getCachedDataSourceInstances();
        IncludeFromDefinition def = new IncludeFromDefinition();
        String dsName = info.getThisDataSourceName();
        DataSource ds = dsObjectsMap.get(dsName);
        if (ds == null) {
            try {
                ds = DataSourceManager.get(dsName, dsRequest);
                dsObjectsMap.put(dsName, ds);
            }
            catch (Exception ex) {
                log.warn((Object)("Failed to create data source '" + dsName + "'."), ex);
            }
        }
        def.thisDataSource = ds;
        def.thisFieldName = info.getThisFieldName();
        def.includedFieldName = info.getIncludedFieldName();
        def.includePath = info.getIncludePath();
        def.includeVia = info.getIncludeVia();
        def.dataSourceNames = info.getDataSourceNames();
        def.isCriteria = false;
        def.isSortBy = false;
        def.isDynamic = false;
        def.relation = Relation.create(info.getRelation(), dsObjectsMap, dsRequest);
        def.prepared = info.isPrepared();
        def.targetInspected = info.isTargetInspected();
        def.dataSources = new DataSource[def.dataSourceNames.length];
        for (int i = 0; i < def.dataSourceNames.length; ++i) {
            dsName = def.dataSourceNames[i];
            if (dsName == null || "".equals(dsName.trim())) continue;
            ds = dsObjectsMap.get(dsName);
            if (ds == null) {
                try {
                    ds = DataSourceManager.get(dsName, dsRequest);
                    dsObjectsMap.put(dsName, ds);
                }
                catch (Exception ex) {
                    log.warn((Object)("Failed to create data source '" + dsName + "'."), ex);
                }
            }
            def.dataSources[i] = ds;
        }
        def.thisField = def.thisDataSource.getField(def.thisFieldName);
        def.includedField = def.getDataSource().getField(def.includedFieldName);
        def.targetIncludeFrom = IncludeFromDefinition.create(info.getTargetIncludeFrom(), dsRequest);
        return def;
    }

    private IncludeFromDefinition() {
    }

    public static boolean isDynamicInclusion(String config) {
        String[] parsedDynamic = config.split(DYNAMIC_NAME_TOKEN);
        if (parsedDynamic.length == 2) {
            return true;
        }
        parsedDynamic = config.split("\\.");
        return parsedDynamic.length == 2;
    }

    public static IncludeFromDefinition forSortByField(List list, String fieldName, boolean isRelated) {
        return IncludeFromDefinition.forField(list, fieldName, null, isRelated, false, true);
    }

    public static IncludeFromDefinition forCriteriaField(List list, String fieldName) {
        return IncludeFromDefinition.forField(list, fieldName, null, true, true, false);
    }

    public static IncludeFromDefinition forThisField(List list, String fieldName, DataSource ds) {
        return IncludeFromDefinition.forField(list, fieldName, ds, false, false, false);
    }

    public static IncludeFromDefinition forRelatedField(List list, String fieldName, DataSource ds) {
        return IncludeFromDefinition.forField(list, fieldName, ds, true, false, false);
    }

    public static IncludeFromDefinition forField(List list, String fieldName, DataSource ds, boolean relatedField, boolean criteria, boolean sortBy) {
        if (list == null) {
            return null;
        }
        String dsName = null;
        if (relatedField) {
            String[] parsed = fieldName.split(DYNAMIC_NAME_TOKEN);
            parsed = parsed.length == 2 ? parsed[1].split("\\.") : fieldName.split("\\.");
            if (parsed.length > 1) {
                dsName = parsed[parsed.length - 2];
                fieldName = parsed[parsed.length - 1];
            } else {
                dsName = ds == null ? "" : ds.getName();
            }
        }
        IncludeFromDefinition bestSoFar = null;
        for (IncludeFromDefinition incFrom : list) {
            if (fieldName == null || (relatedField || !fieldName.equals(incFrom.getThisFieldName())) && (!relatedField || !fieldName.equals(incFrom.getIncludedFieldName()) || !dsName.equals(incFrom.getDataSourceName()))) continue;
            if (criteria) {
                if (incFrom.isCriteria()) {
                    return incFrom;
                }
                if (bestSoFar != null) continue;
                bestSoFar = incFrom;
                continue;
            }
            if (sortBy) {
                if (incFrom.isSortBy()) {
                    return incFrom;
                }
                if (bestSoFar != null) continue;
                bestSoFar = incFrom;
                continue;
            }
            if (incFrom.isCriteria()) continue;
            return incFrom;
        }
        return bestSoFar;
    }

    public IncludeFromDefinition(String text, DSRequest dsRequest) {
        this(null, text, dsRequest);
    }

    public IncludeFromDefinition(DSField field, String text, DSRequest dsRequest) {
        this.dsRequest = dsRequest;
        try {
            this.thisDataSource = dsRequest.getDataSource();
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (text != null) {
            String[] parsed;
            if (field == null) {
                String[] parsedDynamic = text.split(DYNAMIC_NAME_TOKEN);
                if (parsedDynamic.length == 2) {
                    this.thisFieldName = parsedDynamic[0];
                    text = parsedDynamic[1];
                } else {
                    parsedDynamic = text.split("\\.");
                    if (parsedDynamic.length > 1) {
                        this.thisFieldName = parsedDynamic[parsedDynamic.length - 1];
                    } else {
                        log.warn("Found invalid dynamic field definition '" + text + "'.  Should be of the form 'localName!dataSourceName.fieldName', or simply 'dataSourceName.fieldName' for criteria values or output fields where the desired localName is the same as thefield name on the related DataSource. You can also define multiple data sources to request certain path to connect indirectly related data source: 'dataSourceName1.dataSourceName2.fieldName'.");
                        return;
                    }
                }
            }
            if ((parsed = text.split("\\.")).length < 2) {
                if (field != null) {
                    log.warn("Field " + field.getName() + " has invalid IncludeFromDefinition definition: '" + text + "'.  Should be of the form 'dataSourceName.fieldName'. You can also define multiple data sources to request certain  path to connect indirectly related data sources: 'dataSourceName1.dataSourceName2.fieldName'.");
                    return;
                }
                log.warn("Found invalid dynamic field definition '" + text + "'.  Should be of the form 'localName!dataSourceName.fieldName', or simply 'dataSourceName.fieldName' for criteria values or output fields where the desired localName is the same as the field name on the related DataSource. You can also define multiple data sources to request certain path to connect indirectly related data source: 'dataSourceName1.dataSourceName2.fieldName'.");
                return;
            }
            this.includePath = text.substring(0, text.lastIndexOf("."));
            this.includedFieldName = text.substring(text.lastIndexOf(".") + 1);
            if (field != null) {
                this.thisField = field;
                this.thisFieldName = field.getName();
                this.includeVia = field.getProperty("includeVia");
            }
            this.dataSources = new DataSource[parsed.length - 1];
            this.dataSourceNames = new String[parsed.length - 1];
            try {
                for (int i = 0; i < parsed.length - 1; ++i) {
                    String dsName = parsed[i];
                    DataSource ds = dsRequest.getCachedDataSourceInstance(dsName);
                    if (ds == null) {
                        ds = DataSourceManager.get(dsName, dsRequest);
                        log.debug("Caching instance " + (ds == null ? "null" : Long.valueOf(ds.getInstanceId())) + " of DS '" + dsName + "' from IncFromDef constructor");
                        dsRequest.cacheDataSourceInstance(dsName, ds);
                    }
                    if (ds == null) {
                        return;
                    }
                    this.dataSources[i] = ds;
                    this.dataSourceNames[i] = dsName;
                }
            }
            catch (Exception e) {
                return;
            }
            this.includedField = this.dataSources[this.dataSources.length - 1].getField(this.includedFieldName);
        }
    }

    public void prepareField() {
        if (this.thisField == null || this.includedField == null) {
            return;
        }
        if (this.targetIncludeFrom != null) {
            this.targetIncludeFrom.prepareField();
        }
        if (this.isPrepared()) {
            return;
        }
        Map configField = null;
        Map configFieldsList = (Map)this.thisDataSource.getConfig().get("fields");
        if (configFieldsList != null) {
            configField = (Map)configFieldsList.get(this.thisField.getName());
        }
        if (!this.thisField.getBoolean("canEdit")) {
            this.thisField.put("canEdit", Boolean.FALSE);
            if (configField != null) {
                configField.put("canEdit", Boolean.FALSE);
            }
        }
        if (!this.thisField.getBoolean("lenientXPath")) {
            this.thisField.put("lenientXPath", Boolean.FALSE);
            if (configField != null) {
                configField.put("lenientXPath", Boolean.FALSE);
            }
        }
        for (Object propertyName : this.includedField.keySet()) {
            if (propertyName == null || "primaryKey".equals(propertyName) || "foreignKey".equals(propertyName) || "required".equals(propertyName) || "conditionallyRequired".equals(propertyName) || "validators".equals(propertyName) || "__cachedType".equals(propertyName) || propertyName.toString().startsWith("editRequires") || propertyName.toString().startsWith("updateRequires") || propertyName.toString().startsWith("initRequires") || "includeVia".equals(propertyName)) continue;
            if ("type".equals(propertyName)) {
                this.thisField.put(propertyName, this.includedField.get(propertyName));
                if (configField == null) continue;
                configField.put(propertyName, this.includedField.get(propertyName));
                continue;
            }
            if (this.thisField.containsKey(propertyName)) continue;
            this.thisField.put(propertyName, this.includedField.get(propertyName));
            if (configField == null) continue;
            configField.put(propertyName, this.includedField.get(propertyName));
        }
        if (this.thisDataSource.handlesRelations()) {
            Object propertyName;
            propertyName = null;
            for (Relation r = this.getRelation(); r != null; r = r.getNextRelation()) {
                propertyName = propertyName == null ? r.getFromFields().get(0).getName() : propertyName + "/" + r.getFromFields().get(0).getName();
            }
            propertyName = this.getTargetIncludeFrom() != null ? propertyName + "/" + this.includedField.getValueXPath() : propertyName + "/" + this.includedFieldName;
            this.thisField.put("valueXPath", propertyName);
            if (configField != null) {
                configField.put("valueXPath", propertyName);
            }
        }
        this.prepared = true;
    }

    public String getAlias() {
        return this.getAlias(true);
    }

    public String getAlias(boolean inspectTarget) {
        String alias = null;
        if (inspectTarget && this.targetIncludeFrom != null) {
            return this.targetIncludeFrom.getAlias();
        }
        for (Relation r = this.relation; r != null; r = r.getNextRelation()) {
            alias = r.getToAlias();
        }
        return alias;
    }

    public boolean isPrepared() {
        return this.prepared;
    }

    public void setPrepared(boolean prepared) {
        this.prepared = prepared;
    }

    public String getIncludeVia() {
        return this.includeVia;
    }

    public void setIncludeVia(String includeVia) {
        this.includeVia = includeVia;
    }

    public String getDataSourceName() {
        if (this.dataSourceNames == null || this.dataSourceNames.length == 0) {
            return null;
        }
        return this.dataSourceNames[this.dataSourceNames.length - 1];
    }

    public DataSource getDataSource() {
        if (this.dataSources == null || this.dataSources.length == 0) {
            return null;
        }
        return this.dataSources[this.dataSources.length - 1];
    }

    public DataSource[] getDataSources() {
        return this.dataSources;
    }

    public void setDataSources(DataSource[] dataSources) {
        this.dataSources = dataSources;
    }

    public String[] getDataSourceNames() {
        return this.dataSourceNames;
    }

    public void setDataSourceNames(String[] dataSourceNames) {
        this.dataSourceNames = dataSourceNames;
    }

    public String getIncludePath() {
        return this.includePath;
    }

    public void setIncludePath(String includePath) {
        this.includePath = includePath;
    }

    public DSField getIncludedField() {
        return this.includedField;
    }

    public void setIncludedField(DSField includedField) {
        this.includedField = includedField;
    }

    public String getIncludedFieldName() {
        return this.includedFieldName;
    }

    public void setIncludedFieldName(String includedFieldName) {
        this.includedFieldName = includedFieldName;
    }

    public DSField getThisField() {
        return this.thisField;
    }

    public void setThisField(DSField thisField) {
        this.thisField = thisField;
    }

    public String getThisFieldName() {
        return this.thisFieldName;
    }

    public void setThisFieldName(String thisFieldName) {
        this.thisFieldName = thisFieldName;
    }

    public IncludeFromDefinition getTargetIncludeFrom() {
        return this.targetIncludeFrom;
    }

    public void setTargetIncludeFrom(IncludeFromDefinition targetIncludeFrom) {
        this.targetIncludeFrom = targetIncludeFrom;
    }

    public boolean isCriteria() {
        return this.isCriteria;
    }

    public void setCriteria(boolean isCriteria) {
        this.isCriteria = isCriteria;
    }

    public boolean isDynamic() {
        return this.isDynamic;
    }

    public void setDynamic(boolean isDynamic) {
        this.isDynamic = isDynamic;
    }

    public boolean isSortBy() {
        return this.isSortBy;
    }

    public void setSortBy(boolean isSortBy) {
        this.isSortBy = isSortBy;
    }

    public Relation getRelation() {
        return this.relation;
    }

    public void setRelation(Relation relation) {
        this.relation = relation;
    }

    public boolean isInError() {
        return this.inError;
    }

    public void setInError(boolean inError) {
        this.inError = inError;
    }

    public DataSource getThisDataSource() {
        return this.thisDataSource;
    }

    public void setThisDataSource(DataSource thisDataSource) {
        this.thisDataSource = thisDataSource;
    }

    public boolean isTargetInspected() {
        return this.targetInspected;
    }

    public void setTargetInspected(boolean targetInspected) {
        this.targetInspected = targetInspected;
    }

    public String toString() {
        StringBuffer rtn = new StringBuffer();
        rtn.append("thisField: " + (this.thisField == null ? "null" : DataTools.prettyPrint(this.thisField)));
        rtn.append("\n");
        rtn.append("thisFieldName: " + (this.thisFieldName == null ? "null" : this.thisFieldName));
        rtn.append("\n");
        if (this.dataSources == null) {
            rtn.append("dataSources: null");
        } else {
            String s = "";
            for (DataSource ds : this.dataSources) {
                if (ds == null) continue;
                s = "".equals(s) ? ds.getName() : s + ", " + ds.getName();
            }
            rtn.append("[" + s + "]");
        }
        rtn.append("\n");
        rtn.append("includePath: " + (this.includePath == null ? "null" : this.includePath));
        rtn.append("\n");
        rtn.append("includeVia: " + (this.includeVia == null ? "null" : this.includeVia));
        rtn.append("\n");
        rtn.append("includedField: " + (this.includedField == null ? "null" : DataTools.prettyPrint(this.includedField)));
        rtn.append("\n");
        rtn.append("includedFieldName: " + (this.includedFieldName == null ? "null" : this.includedFieldName));
        rtn.append("\n");
        rtn.append("inError: " + this.inError);
        rtn.append("\n");
        rtn.append("isSortBy: " + this.isSortBy);
        rtn.append("\n");
        rtn.append("isDynamic: " + this.isDynamic);
        rtn.append("\n");
        rtn.append("relation: " + (this.relation == null ? "null" : this.relation.toString()));
        rtn.append("\n");
        rtn.append("targetIncludeFrom: " + (this.targetIncludeFrom == null ? "null" : this.targetIncludeFrom));
        return rtn.toString();
    }
}

