/*
 * Decompiled with CFR 0.152.
 */
package com.isomorphic.tools;

import com.isomorphic.auth.AuthenticatedUser;
import com.isomorphic.auth.Authentication;
import com.isomorphic.base.Config;
import com.isomorphic.datasource.BasicDataSource;
import com.isomorphic.datasource.DSRequest;
import com.isomorphic.datasource.DSResponse;
import com.isomorphic.servlet.RequestContext;
import com.isomorphic.store.DataStructCache;
import java.lang.constant.Constable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class ReifyToursDS
extends BasicDataSource {
    private static Config config = Config.getGlobal();
    private static final String TOURS_LIST_FILE = config.getString((Object)"reify.tours.xml.file", "reifyTours.xml");
    private static final String TOURS_LIST_PATH = config.getString((Object)"datasources.isc_reifyTours.location");
    private static List<Map> data;

    public DSResponse executeFetchForOtherUser(DSRequest req) throws Exception {
        AuthenticatedUser user = (AuthenticatedUser)Authentication.getUser((RequestContext)req.getRPCManager().getContext());
        String username = (String)req.getCriteriaValue((Object)"username");
        return this.fetchTourDataForUser(req, username);
    }

    public DSResponse executeFetch(DSRequest req) throws Exception {
        String username = null;
        if (config.getBoolean((Object)"websiteMode", false)) {
            AuthenticatedUser user = (AuthenticatedUser)Authentication.getUser((RequestContext)req.getRPCManager().getContext());
            username = user.getName();
        }
        return this.fetchTourDataForUser(req, username);
    }

    private DSResponse fetchTourDataForUser(DSRequest req, String username) throws Exception {
        List progressData;
        HashMap flags = new HashMap();
        Map map = (Map)DataStructCache.loadInstance((String)(TOURS_LIST_PATH + "/" + TOURS_LIST_FILE), (String)("__" + TOURS_LIST_FILE), (String)null, flags);
        if (data == null || Boolean.TRUE.equals(flags.get("objectWasStale"))) {
            data = this.transformData((List)map.get("tour"));
        }
        if (username != null) {
            DSRequest progress = new DSRequest("isc_reifyToursUser", "fetch");
            progress.setCriteria("username", (Object)username);
            progressData = progress.execute().getDataList();
        } else {
            progressData = new ArrayList<Map>();
        }
        List<Map> combinedData = this.applyUserData(data, progressData);
        DSResponse resp = new DSResponse(combinedData);
        resp.setStartRow(0L);
        resp.setEndRow((long)combinedData.size());
        resp.setTotalRows((long)combinedData.size());
        return resp;
    }

    private List<Map> transformData(List<Map> raw) {
        ArrayList<Map> rtn = new ArrayList<Map>();
        for (Map record : raw) {
            record.put("level", Integer.parseInt((String)record.get("level")));
            record.put("duration", Integer.parseInt((String)record.get("duration")));
            record.put("isNew", "true".equals(record.get("isNew")));
            record.put("isPopular", "true".equals(record.get("isPopular")));
            rtn.add(record);
        }
        return rtn;
    }

    private List<Map> applyUserData(List<Map> baseData, List<Map> userData) {
        ArrayList<Map> rtn = new ArrayList<Map>();
        Iterator<Map> i = baseData.iterator();
        while (i.hasNext()) {
            HashMap<String, Constable> baseRec = new HashMap<String, Constable>(i.next());
            boolean foundUser = false;
            for (Map userRec : userData) {
                if (!userRec.get("tutorialId").equals(baseRec.get("id"))) continue;
                Integer currObj = (Integer)userRec.get("currentStep");
                int curr = currObj == null ? 0 : currObj;
                Integer percentObj = (Integer)userRec.get("percentDone");
                int percentDone = percentObj == null ? 0 : percentObj;
                baseRec.put("currentStep", Integer.valueOf(curr));
                baseRec.put("percentDone", Integer.valueOf(percentDone));
                Boolean triggerObj = (Boolean)userRec.get("declinedTrigger");
                boolean trigger = triggerObj == null ? false : triggerObj;
                baseRec.put("declinedTrigger", Boolean.valueOf(trigger));
                foundUser = true;
                break;
            }
            if (!foundUser) {
                baseRec.put("currentStep", Integer.valueOf(0));
                baseRec.put("percentDone", Integer.valueOf(0));
            }
            rtn.add(baseRec);
        }
        return rtn;
    }
}

