/*
 * Decompiled with CFR 0.152.
 */
package com.isomorphic.tools;

import com.isomorphic.base.Base;
import com.isomorphic.base.Reflection;
import com.isomorphic.datasource.BasicDataSource;
import com.isomorphic.datasource.DSRequest;
import com.isomorphic.datasource.DSResponse;
import com.isomorphic.datasource.DataSource;
import com.isomorphic.datasource.DataSourceManager;
import com.isomorphic.datasource.MemoryDataSource;
import com.isomorphic.datasource.MemoryStore;
import com.isomorphic.datasource.ValidationContext;
import com.isomorphic.hibernate.HB;
import com.isomorphic.hibernate.HibernateDataSource;
import com.isomorphic.log.Logger;
import com.isomorphic.sql.DBType;
import com.isomorphic.sql.SQLConnectionManager;
import com.isomorphic.sql.SQLDataSource;
import com.isomorphic.sql.SQLDriver;
import com.isomorphic.sql.SQLTableCreator;
import com.isomorphic.store.DataStructCache;
import com.isomorphic.tools.BuiltinRPC;
import com.isomorphic.tools.DataImport;
import com.isomorphic.util.IOUtil;
import java.io.IOException;
import java.io.PrintStream;
import java.io.Reader;
import java.sql.Connection;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.DefaultParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.OptionBuilder;
import org.apache.commons.cli.Options;
import org.hibernate.exception.ConstraintViolationException;
import org.hibernate.tool.hbm2ddl.SchemaExport;
import org.hibernate.tool.hbm2ddl.SchemaUpdate;

public class SQLImport
extends Base {
    private static Logger log = new Logger(SQLImport.class.getName());
    static PrintStream out = System.out;
    static PrintStream err = System.err;
    public static boolean interactive = true;
    public static boolean debug = true;
    public static boolean doWork = true;
    public static boolean continueOnError = false;
    public static boolean dropTables = false;
    public static boolean createTables = true;
    public static boolean strictCreate = true;
    public static boolean schemaOnly = false;
    public static boolean showHelp = false;
    public static boolean onlySimpleModeList = false;
    public static boolean projectDataSources = false;
    public static DBType dbType = DBType.Generic;

    public static void main(String[] args) {
        DefaultParser parser = new DefaultParser();
        String cmdLineSyntax = "sqlImport [options] <dataSourceList>";
        Options options = new Options();
        options.addOption("b", "batch", false, "Enable non-interactive mode");
        options.addOption("d", "debug", false, "Output debugging messages");
        options.addOption("n", false, "Show what would be done only - do not make changes to db");
        options.addOption("k", false, "Do not exit on error");
        options.addOption("t", "droptables", false, "Drop (i.e. delete) tables if they already exist");
        options.addOption("s", "schemaonly", false, "Create tables only - do not import test data");
        options.addOption("h", "help", false, "Show usage message and exit");
        options.addOption("l", "simpleModeList", false, "Also import DataSources listed in config parameter datasources.simpleModeList");
        options.addOption("p", "projectDataSources", false, "Also import all datasources found in paths specified by the project.datasources config param");
        options.addOption("o", "onlySimpleModeList", false, "ONLY import DataSources from simpleModeList");
        OptionBuilder.withLongOpt((String)"dbName");
        OptionBuilder.withDescription((String)"SmartClient DB name to use for the import.  If left unspecified, the dbName is derived from the sql.defaultDatabase property value");
        OptionBuilder.hasArg();
        OptionBuilder.withArgName((String)"dbName");
        OptionBuilder.withValueSeparator((char)' ');
        options.addOption(OptionBuilder.create());
        OptionBuilder.withLongOpt((String)"checkpoint");
        OptionBuilder.withDescription((String)"Checkpoint db (HSQLDB only)");
        options.addOption(OptionBuilder.create());
        OptionBuilder.withLongOpt((String)"shutdown");
        OptionBuilder.withDescription((String)"Cleanly shutdown db (HSQLDB only)");
        options.addOption(OptionBuilder.create());
        OptionBuilder.withLongOpt((String)"backup");
        OptionBuilder.withDescription((String)"Backup db (HSQLDB only)");
        OptionBuilder.hasArg();
        OptionBuilder.withArgName((String)"pathToFile");
        OptionBuilder.withValueSeparator((char)' ');
        options.addOption(OptionBuilder.create());
        try {
            CommandLine line = parser.parse(options, args);
            String dbName = config.getString((Object)"sql.defaultDatabase");
            if (line.hasOption("dbName")) {
                dbName = line.getOptionValue("dbName");
                config.put((Object)"sql.defaultDatabase", (Object)dbName);
            }
            if (line.hasOption("checkpoint")) {
                SQLImport.checkpointDB(dbName);
                System.exit(0);
            }
            if (line.hasOption("shutdown")) {
                SQLImport.shutdownDB(dbName);
                System.exit(0);
            }
            if (line.hasOption("backup")) {
                SQLImport.backupDB(dbName, line.getOptionValue("backup"));
                System.exit(0);
            }
            if (line.hasOption("b")) {
                interactive = false;
            }
            if (line.hasOption("d")) {
                debug = true;
            }
            if (line.hasOption("n")) {
                doWork = false;
            }
            if (line.hasOption("k")) {
                continueOnError = true;
            }
            if (line.hasOption("t")) {
                dropTables = true;
            }
            if (line.hasOption("s")) {
                schemaOnly = true;
            }
            if (line.hasOption("o")) {
                onlySimpleModeList = true;
            }
            if (line.hasOption("p")) {
                projectDataSources = true;
            }
            if (line.hasOption("h")) {
                SQLImport.outputHelp(cmdLineSyntax, options);
                System.exit(1);
            }
            List dataSources = line.getArgList();
            if (line.hasOption("l") || line.hasOption("o")) {
                List l = config.getList((Object)"datasources.simpleModeList", new ArrayList());
                dataSources.addAll(l);
            }
            if (line.hasOption("p")) {
                List projectDataSourcePaths = config.getList((Object)"project.datasources", new ArrayList());
                for (String dsPath : projectDataSourcePaths) {
                    String project = config.getString((Object)"project");
                    if (config.getBoolean((Object)"devenv", false) && !"SDKPackage".equals(project) && (dsPath.contains("/SDKPackage/") || dsPath.contains("/QA/") || dsPath.contains("/webroot/tools/"))) continue;
                    dataSources.add(dsPath);
                }
            }
            if (dataSources.size() == 0) {
                System.err.println("No datasources specified");
                SQLImport.outputHelp(cmdLineSyntax, options);
                System.exit(1);
            }
            dataSources = DataSourceManager.getFullDSList((List)dataSources);
            LinkedList<String> hibernateDSNames = new LinkedList<String>();
            LinkedList<String> nonHBDSNames = new LinkedList<String>();
            for (String dsName : dataSources) {
                try {
                    DataSource ds = DataSourceManager.getDataSource((String)dsName, null);
                    if (ds != null && "hibernate".equals(ds.getType())) {
                        hibernateDSNames.add(dsName);
                        continue;
                    }
                    nonHBDSNames.add(dsName);
                }
                catch (Exception ee) {
                    if (!continueOnError) {
                        throw ee;
                    }
                    log.warn((Object)("Failed to instantiate ds: " + dsName + ", but continueOnError is set, so skipping"), (Throwable)ee);
                }
            }
            if (dropTables && hibernateDSNames.size() > 0) {
                if (interactive) {
                    System.out.println("You have specified that tables should be dropped, and at least one Hibernate DataSource is to be imported.");
                    System.out.println("This will cause ALL Hibernate-managed tables to be dropped and re-imported.  Is this OK? (y/n)");
                    int input = System.in.read();
                    if (input != 121 && input != 89) {
                        return;
                    }
                }
                SQLImport.recreateHibernateSchema();
                if (!onlySimpleModeList) {
                    List allDSList = BuiltinRPC.getDefinedDataSourcesAsList();
                    for (Map dsDef : allDSList) {
                        if (!"hibernate".equals(dsDef.get("dsType")) || hibernateDSNames.contains(dsDef.get("dsName"))) continue;
                        hibernateDSNames.add((String)dsDef.get("dsName"));
                    }
                }
            }
            ArrayList<String> failed = new ArrayList<String>();
            ArrayList<String> succeeded = new ArrayList<String>();
            for (String dsName : hibernateDSNames) {
                err.println("Importing datasource: " + dsName);
                try {
                    SQLImport.processDataSource(dsName);
                    succeeded.add(dsName);
                }
                catch (ConstraintViolationException cve) {
                    failed.add(dsName);
                }
                catch (Exception e) {
                    log.error((Object)("Attempt to process datasource '" + dsName + "' caught top-level exception"), (Throwable)e);
                }
            }
            log.warn((Object)("We successfully imported the following dataSources: " + succeeded));
            if (failed.size() > 0) {
                log.warn((Object)("We failed to import the following dataSources: " + failed));
            }
            for (String dsName : nonHBDSNames) {
                err.println("Importing datasource: " + dsName);
                try {
                    SQLImport.processDataSource(dsName);
                }
                catch (Exception e) {
                    log.error((Object)("Attempt to process datasource '" + dsName + "' caught top-level exception"), (Throwable)e);
                }
            }
        }
        catch (Throwable e) {
            log.warn(e);
            System.exit(1);
        }
        System.exit(0);
    }

    public static void outputHelp(String cmdLineSyntax, Options options) {
        HelpFormatter formatter = new HelpFormatter();
        formatter.printHelp(cmdLineSyntax, "", options, "\nUtility to create database table(s) in the current project's SQL database (as set up by the 'dev' script), from the datasource and test data files.\n\n Examples:\n> sqlImport -tk supplyItem\n> sqlImport --schemaonly task");
    }

    public static boolean processDataSource(String dsName) throws Exception {
        ValidationContext vc = new ValidationContext();
        boolean response = SQLImport.processDataSource(dsName, vc);
        vc.freeResources();
        return response;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean processDataSource(String dsName, ValidationContext vc) throws Exception {
        block17: {
            DataSource ds;
            if (dsName.endsWith(".ds.js")) {
                dsName = dsName.substring(0, dsName.length() - 6);
            } else if (dsName.endsWith(".ds.xml")) {
                dsName = dsName.substring(0, dsName.length() - 7);
            }
            DSRequest contextReq = vc.getDSRequest();
            boolean freeReq = false;
            if (contextReq == null) {
                contextReq = new DSRequest();
                vc.setDSRequest(contextReq);
                freeReq = true;
            }
            if ((ds = null) == null) {
                ds = DataSourceManager.get((String)dsName, (DSRequest)contextReq);
            }
            if (ds == null) {
                throw new Exception("Could not find datasource: " + dsName);
            }
            try {
                vc.addToTypeCache(dsName, (BasicDataSource)ds);
                contextReq.cacheDataSourceInstance(dsName, ds);
                if (ds instanceof SQLDataSource) {
                    SQLImport.processSQLDataSource((SQLDataSource)ds, contextReq);
                    String dbName = ((SQLDataSource)ds).getDBName();
                    if (dbName == null || ds.getSourceDataSourceID() != null) break block17;
                    try {
                        String initUsers = config.getString((Object)("sql." + dbName + ".init.users"));
                        if (initUsers != null) {
                            Reflection.invokeStaticMethod((String)"com.isomorphic.site.SandboxSQLImport", (String)"processSQLDataSource", (Object[])new Object[]{ds, initUsers});
                        }
                        break block17;
                    }
                    catch (Exception e) {
                        log.error((Object)("unable to import sandboxed test files for " + ds.getName()), (Throwable)e);
                    }
                    break block17;
                }
                if (ds instanceof HibernateDataSource) {
                    SQLImport.processHibernateDataSource((HibernateDataSource)ds);
                    break block17;
                }
                if (ds instanceof MemoryDataSource) {
                    if (dropTables) {
                        MemoryStore.deleteStore((String)((MemoryDataSource)ds).getStoreName());
                        MemoryStore.createStore((String)((MemoryDataSource)ds).getStoreName(), (DataSource)((MemoryDataSource)ds));
                    }
                    SQLImport.importData(ds);
                    break block17;
                }
                err.println("Skipping non-SQL DataSource: '" + dsName + "'");
                boolean bl = false;
                return bl;
            }
            finally {
                if (freeReq) {
                    contextReq.setRequestStarted(true);
                    contextReq.freeAllResources();
                }
            }
        }
        return true;
    }

    public static void recreateHibernateSchema() {
        try {
            SchemaExport se = HB.getSchemaExport();
            se.drop(debug, doWork);
            se.create(debug, doWork);
            List exceptions = se.getExceptions();
            if (exceptions != null && exceptions.size() > 0) {
                Iterator i = exceptions.iterator();
                while (i.hasNext()) {
                    log.warn((Object)"SchemaExport", i.next());
                }
            }
        }
        catch (Exception e) {
            log.error((Object)"Error recreating Hibernate schema", (Throwable)e);
        }
    }

    public static void processHibernateDataSource(HibernateDataSource ds) throws Exception {
        if (!dropTables) {
            SchemaUpdate su = HB.getSchemaUpdate();
            su.execute(debug, doWork);
        }
        if (!schemaOnly && doWork) {
            SQLImport.importData((DataSource)ds);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void checkpointDB(String dbName) throws Exception {
        DBType dbType = DBType.forDb((String)dbName);
        if (dbType != DBType.HSQLDB) {
            throw new Exception("Unable to checkpoint '" + dbName + "' - must be of type hsqldb, but is of type: " + dbType);
        }
        Connection conn = SQLConnectionManager.getConnection((String)dbName);
        Statement stmt = null;
        try {
            stmt = conn.createStatement();
            String command = "CHECKPOINT";
            log.info((Object)("Issuing JDBC command: " + command));
            stmt.execute(command);
        }
        finally {
            if (stmt != null) {
                try {
                    stmt.close();
                }
                catch (Exception exception) {}
            }
            if (conn != null) {
                try {
                    conn.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void backupDB(String dbName, String backupFile) throws Exception {
        DBType dbType = DBType.forDb((String)dbName);
        if (dbType != DBType.HSQLDB) {
            throw new Exception("Unable to backup '" + dbName + "' - must be of type hsqldb, but is of type: " + dbType);
        }
        Connection conn = SQLConnectionManager.getConnection((String)dbName);
        Statement stmt = null;
        try {
            stmt = conn.createStatement();
            String specifiedBackupFile = backupFile;
            if (!(backupFile.endsWith(".tar") || backupFile.endsWith(".tgz") || backupFile.endsWith(".tar.gz"))) {
                backupFile = backupFile + ".tar";
            }
            boolean compressed = !backupFile.endsWith(".tar");
            String command = "BACKUP DATABASE TO '" + backupFile + "' " + (compressed ? "COMPRESSED" : "NOT COMPRESSED") + " NOT BLOCKING";
            log.info((Object)("Issuing JDBC command: " + command));
            stmt.execute(command);
            if (!backupFile.equals(specifiedBackupFile)) {
                IOUtil.atomicMove((String)backupFile, (String)specifiedBackupFile);
            }
        }
        finally {
            if (stmt != null) {
                try {
                    stmt.close();
                }
                catch (Exception exception) {}
            }
            if (conn != null) {
                try {
                    conn.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void shutdownDB(String dbName) throws Exception {
        DBType dbType = DBType.forDb((String)dbName);
        if (dbType != DBType.HSQLDB) {
            throw new Exception("Unable to shutdown '" + dbName + "' - must be of type hsqldb, but is of type: " + dbType);
        }
        Connection conn = SQLConnectionManager.getConnection((String)dbName);
        Statement stmt = null;
        try {
            stmt = conn.createStatement();
            String command = "SHUTDOWN IMMEDIATELY";
            log.info((Object)("Issuing JDBC command: " + command));
            stmt.execute(command);
        }
        finally {
            if (stmt != null) {
                try {
                    stmt.close();
                }
                catch (Exception exception) {}
            }
            if (conn != null) {
                try {
                    conn.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    public static void processSQLDataSource(SQLDataSource ds) throws Exception {
        SQLImport.processSQLDataSource(ds, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void processSQLDataSource(SQLDataSource ds, DSRequest contextReq) throws Exception {
        dbType = ds.getDriver().getDBType();
        if (dbType == DBType.HSQLDB) {
            ds.executeNativeUpdate("SET FILES LOG FALSE", null);
            ds.executeNativeUpdate("CHECKPOINT", null);
        }
        SQLTableCreator.createTable((SQLDataSource)ds, (boolean)dropTables, (boolean)debug, (boolean)doWork, (boolean)strictCreate);
        boolean importSuccess = true;
        if (!schemaOnly && doWork) {
            importSuccess = SQLImport.importData((DataSource)ds);
        }
        if (dbType == DBType.MySQL || dbType == DBType.MariaDB) {
            ds.executeNativeUpdate("SET foreign_key_checks = 1", null);
        } else if (dbType == DBType.SQLServer) {
            ds.executeNativeUpdate("EXEC sp_msforeachtable \"ALTER TABLE ? WITH CHECK CHECK CONSTRAINT all\"");
        }
        DataSource auditDS = null;
        try {
            auditDS = ds.getAuditDataSource(contextReq);
            if (auditDS != null) {
                SQLImport.processSQLDataSource((SQLDataSource)auditDS, contextReq);
            }
        }
        finally {
            if (contextReq == null) {
                DataSourceManager.free((DataSource)auditDS);
            }
        }
        if (dbType == DBType.HSQLDB) {
            ds.executeNativeUpdate("SET FILES LOG TRUE", null);
            ds.executeNativeUpdate("CHECKPOINT", null);
        }
    }

    public static void rebuildSequences(SQLDataSource ds) throws Exception {
        Map sequences = ds.getTable().getSequences();
        for (String sequence : sequences.keySet()) {
            String sequenceFieldName = ds.getFieldNameFromColumnName(sequence);
            String sequenceName = SQLDriver.getSequenceName((String)sequence, (Map)sequences, (String)ds.getTable().getName(), (SQLDriver)ds.getDriver());
            try {
                Long newCount = 0L;
                String startString = (String)ds.getField(sequenceFieldName).get((Object)"sequenceStart");
                if (startString != null) {
                    newCount = Long.parseLong(startString);
                }
                if (newCount == 0L) {
                    Object count = ds.getDriver().executeScalar("SELECT MAX(" + ds.escapeColumnName((Object)sequence) + ") FROM " + ds.getTable().getName(), null);
                    Long currentCount = 0L;
                    if (count != null) {
                        currentCount = Long.valueOf(count.toString());
                    }
                    newCount = currentCount + 1L;
                }
                ds.executeNativeUpdate("DROP SEQUENCE " + sequenceName, null);
                String sequenceCreate = "CREATE SEQUENCE " + sequenceName;
                int increment = 0;
                String incrementString = (String)ds.getField(sequenceFieldName).get((Object)"sequenceIncrement");
                if (incrementString != null) {
                    increment = Integer.parseInt(incrementString);
                }
                if (increment == 0) {
                    increment = 1;
                }
                if (dbType == DBType.Oracle || dbType == DBType.DB2) {
                    sequenceCreate = sequenceCreate + " INCREMENT BY " + increment + " START WITH ";
                }
                if (dbType == DBType.PostgreSQL) {
                    sequenceCreate = sequenceCreate + " INCREMENT " + increment + " START ";
                }
                sequenceCreate = sequenceCreate + newCount.toString();
                ds.executeNativeUpdate(sequenceCreate, null);
            }
            catch (Exception ee) {
                out.println("unable to rebuild sequence: " + sequenceName + " for sequenced column: " + sequence);
                throw ee;
            }
        }
    }

    public static String dsTypeforDbType(Number dbType, String dbName) throws Exception {
        switch (dbType.intValue()) {
            case -1: 
            case 1: 
            case 12: 
            case 2005: {
                return "text";
            }
            case -7: 
            case -6: 
            case -5: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                return "number";
            }
            case 6: 
            case 7: 
            case 8: {
                return "float";
            }
            case 91: 
            case 92: 
            case 93: {
                return "date";
            }
        }
        return "text";
    }

    public static boolean dsTypeIsString(String dsType) {
        return "text".equals(dsType);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean importData(DataSource ds) throws Exception {
        if (ds == null) {
            return false;
        }
        String testFileName = ds.getTestFileName();
        if (testFileName == null) {
            log.warn((Object)("importData(" + ds.getName() + "): No test file"));
            return false;
        }
        log.warn((Object)("importData(" + ds.getName() + "): Got test filename " + testFileName));
        Object rowData = null;
        DataImport dataImport = null;
        if (testFileName.endsWith(".xml")) {
            dataImport = new DataImport(DataImport.ImportFormat.XML, null);
        } else if (testFileName.endsWith(".csv")) {
            dataImport = new DataImport();
        }
        if (dataImport != null) {
            DSRequest tempReq = new DSRequest();
            DSResponse resp = ds.executeGetTestData(tempReq);
            Reader testDataReader = (Reader)resp.getDataMap().get("testData");
            rowData = dataImport.importToRows(testDataReader, null, null, ds);
            if (rowData == null) {
                testDataReader.reset();
                dataImport.setInputType(DataImport.ImportFormat.CSV, null);
                rowData = dataImport.importToRows(testDataReader, null, null, ds);
            }
            if (rowData == null) {
                rowData = SQLImport.loadJSTestData(ds, testFileName);
            }
            try {
                testDataReader.close();
            }
            catch (IOException iOException) {
            }
            finally {
                tempReq.setRequestStarted(true);
                tempReq.freeAllResources();
            }
        } else {
            rowData = SQLImport.loadJSTestData(ds, testFileName);
        }
        if (!(rowData instanceof List)) {
            log.warn((Object)("Test data loaded for DS '" + ds.getName() + "' from file " + testFileName + (rowData == null ? " is null" : " is a " + rowData.getClass().getName()) + ".  Test data must be a list of records."));
            return false;
        }
        List rows = (List)rowData;
        rows = (List)ds.toRecords((Object)rows);
        log.warn((Object)("importData(" + ds.getName() + "): " + rows.size() + " rows"));
        DSRequest req = null;
        try {
            req = new DSRequest(ds.getName(), "insert");
            req.setSkipCacheSync(true);
            req.setSkipAudit(true);
            req.setValues((Object)rows);
            req.forceInvalidateCache(true);
            req.setAttribute("allowExplicitSequenceValues", (Object)ds.getConfig().getBoolean((Object)"allowExplicitSequenceValues", true));
            ds.execute(req);
            if ("hibernate".equals(ds.getType())) {
                ((HibernateDataSource)ds).freeResources(req);
            }
        }
        catch (Exception e) {
            if (!continueOnError) {
                throw e;
            }
            log.warn((Throwable)e);
        }
        finally {
            if (req != null) {
                req.freeAllResources();
            }
        }
        return true;
    }

    public static Object loadJSTestData(DataSource ds, String testFileName) throws Exception {
        Map dataMap = DataStructCache.getDataMap((String)testFileName);
        DataStructCache.cache.clearCacheEntry((Object)testFileName);
        String variableName = ds.getName() + "TestData";
        Object testData = dataMap.get(variableName);
        if (testData == null && dataMap.size() > 0) {
            log.warn((Object)("Variable " + variableName + " not found in test data file " + testFileName + " falling back to first declared variable"));
            variableName = (String)dataMap.keySet().iterator().next();
            testData = dataMap.get(variableName);
        }
        if (testData == null) {
            log.warn((Object)("No variables declared in test data file " + testFileName));
            return null;
        }
        return testData;
    }
}

