/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.jetty.util;

import java.io.InterruptedIOException;
import org.apache.commons.logging.Log;
import org.openqa.jetty.log.LogFactory;
import org.openqa.jetty.util.LifeCycle;
import org.openqa.jetty.util.LogSupport;

public abstract class LifeCycleThread
implements LifeCycle,
Runnable {
    private static Log log = LogFactory.getLog(LifeCycleThread.class);
    private volatile boolean _running;
    private boolean _daemon;
    private Thread _thread;

    public boolean isDaemon() {
        return this._daemon;
    }

    public void setDaemon(boolean d) {
        this._daemon = d;
    }

    public Thread getThread() {
        return this._thread;
    }

    @Override
    public boolean isStarted() {
        return this._running;
    }

    @Override
    public synchronized void start() throws Exception {
        if (this._running) {
            log.debug((Object)"Already started");
            return;
        }
        this._running = true;
        if (this._thread == null) {
            this._thread = new Thread(this);
            this._thread.setDaemon(this._daemon);
        }
        this._thread.start();
    }

    @Override
    public synchronized void stop() throws InterruptedException {
        this._running = false;
        if (this._thread != null) {
            this._thread.interrupt();
            this._thread.join();
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public final void run() {
        while (true) {
            if (!this._running) return;
            try {
                this.loop();
                continue;
            }
            catch (InterruptedException e) {
                LogSupport.ignore(log, e);
                continue;
            }
            catch (InterruptedIOException e) {
                LogSupport.ignore(log, e);
                continue;
            }
            catch (Exception e) {
                if (!this.exception(e)) continue;
                return;
            }
            catch (Error e) {
                if (this.error(e)) return;
                continue;
            }
            break;
        }
        finally {
            this._running = false;
        }
    }

    public boolean exception(Exception e) {
        log.warn((Object)"EXCEPTION ", (Throwable)e);
        return true;
    }

    public boolean error(Error e) {
        log.warn((Object)"EXCEPTION ", (Throwable)e);
        return true;
    }

    public abstract void loop() throws InterruptedException, InterruptedIOException, Exception;
}

