/*
 * Decompiled with CFR 0.152.
 */
package com.isomorphic.sql;

import com.isomorphic.datasource.DSRequest;
import com.isomorphic.log.Logger;
import com.isomorphic.sql.SQLDataSource;
import com.isomorphic.sql.SQLDriver;
import com.isomorphic.sql.SQLTable;
import java.util.List;
import java.util.Map;

public class DB2Driver
extends SQLDriver {
    private static Logger log = new Logger(DB2Driver.class.getName());

    public DB2Driver(String dbName, SQLTable table) throws Exception {
        super(dbName, table);
    }

    @Override
    public boolean supportsRegexp() throws Exception {
        return this.getDatabaseMajorVersion() > 11 || this.getDatabaseMajorVersion() == 11 && this.getDatabaseMinorVersion() >= 1;
    }

    @Override
    public String getExpressionForRegexp(String escapedColumnOrExpression, String operator, String regexp) throws Exception {
        return "REGEXP_LIKE(" + escapedColumnOrExpression + ", " + this.escapeRegexp(regexp) + ("iregexp".equals(operator) ? ", 'i' " : "") + ")";
    }

    @Override
    public boolean supportsNativeReplace() {
        return false;
    }

    public String getLastSequenceQuery() {
        return "VALUES(IDENTITY_VAL_LOCAL())";
    }

    @Override
    public Map fetchLastPrimaryKeys(Map primaryKeysPresent, List sequencesNotPresent, SQLDataSource ds, DSRequest req) throws Exception {
        log.debug((Object)("fetchLastRow data - primaryKeysPresent: " + primaryKeysPresent.toString() + "sequencesNotPresent: " + sequencesNotPresent.toString()));
        if (sequencesNotPresent.size() > 1) {
            throw new Exception("DB2 can't handle more than one auto_increment primary_key");
        }
        if (this.dbConnection == null && req == null) {
            throw new Exception("no connection exists for last row fetch");
        }
        Object sqlStatement = null;
        Map primaryKeys = primaryKeysPresent;
        if (!sequencesNotPresent.isEmpty()) {
            String sequenceName = (String)sequencesNotPresent.get(0);
            String obj = DB2Driver.getScalarResult(this.getLastSequenceQuery(), this.dbConnection, this.dbName, this, req).toString();
            Object transformed = this.getTransformedSequenceValue(obj, sequenceName, ds, req);
            if (transformed != null) {
                primaryKeys.put(sequenceName, transformed);
            } else {
                Long sequenceValue = Long.valueOf(obj.toString());
                primaryKeys.put(sequenceName, sequenceValue);
            }
        }
        return primaryKeys;
    }

    @Override
    public String formatValue(Object value) {
        return value.toString();
    }

    @Override
    public String sqlOutTransform(String columnName, String remapName, String tableName) throws Exception {
        String output = this.escapeColumnName(columnName);
        if (remapName != null && !columnName.equals(remapName)) {
            output = output + " AS " + this.escapeColumnName(remapName);
        }
        if (tableName != null) {
            output = tableName + "." + output;
        }
        return output;
    }

    @Override
    public String escapeValue(Object value) {
        if (value == null) {
            return null;
        }
        return "'" + this.escapeValueUnquoted(value.toString(), false) + "'";
    }

    @Override
    public String escapeValueForFilter(Object value, String filterStyle) {
        if (value == null) {
            return null;
        }
        String rtn = "'";
        if (!"startsWith".equals(filterStyle)) {
            rtn = rtn + "%";
        }
        return rtn + this.escapeValueUnquoted(value, true) + "%'";
    }

    @Override
    public String escapeValueUnquoted(Object value, boolean escapeForFilter) {
        if (value == null) {
            return null;
        }
        String escaped = this.matcher.reset(value.toString()).usePattern(SINGLE_QUOTE_PATTERN).replaceAll(SINGLE_QUOTE_ESCAPE);
        if (escapeForFilter) {
            escaped = this.matcher.reset(escaped).usePattern(BACKSLASH_PATTERN).replaceAll(BACKSLASH_ESCAPE);
            escaped = this.matcher.reset(escaped).usePattern(PERCENT_PATTERN).replaceAll(PERCENT_ESCAPE);
            escaped = this.matcher.reset(escaped).usePattern(UNDERSCORE_PATTERN).replaceAll(UNDERSCORE_ESCAPE);
        }
        return escaped;
    }

    @Override
    public String escapeClause(Object value) {
        return " {ESCAPE '\\'}";
    }

    @Override
    public String getNextSequenceValue(String columnName, SQLDataSource ds) throws Exception {
        return "null";
    }

    @Override
    protected String getExpressionForSortBy(String column, Map valueMap, DSRequest request) {
        if (valueMap == null || valueMap.size() == 0) {
            return column;
        }
        String expr = "CASE " + column;
        for (String rawValue : valueMap.keySet()) {
            String actualValue = this.transformActualValueForSort(rawValue, column, request);
            String displayValue = this.getLocalizedDisplayValue(valueMap.get(rawValue), request);
            displayValue = this.escapeValue(displayValue);
            expr = expr + " WHEN " + actualValue + " THEN " + displayValue;
        }
        expr = expr + " ELSE " + column + " END";
        return expr;
    }

    @Override
    public String getNaturalDatabaseObjectName(String objectName) {
        return objectName == null ? null : objectName.toUpperCase();
    }

    @Override
    public String getDummyQuery() {
        return "SELECT 1 FROM SYSIBM.SYSDUMMY1";
    }

    @Override
    public boolean shouldParameterizeNullValues(boolean isMultiInserting) {
        return false;
    }
}

