package ${package}.client;

import java.io.IOException;

import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.Request.Builder;
import okhttp3.RequestBody;
import okhttp3.Response;

import org.apache.commons.io.IOUtils;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SampleClient {

    private static final MediaType MEDIA_TYPE_XML = MediaType.parse("text/xml; charset=utf-8");
    private static final MediaType MEDIA_TYPE_JSON = MediaType.parse("application/json; charset=utf-8");
    
    private static final Logger LOGGER = LoggerFactory.getLogger(SampleClient.class);

    public static void main(String[] args) throws IOException {

        String url = "http://localhost:8080/restapi";
        String resource = "/fetchByAdvancedCriteria.xml";
        
        if (System.getProperty("url") != null) {
            url = System.getProperty("url");
        }
        if (System.getProperty("body") != null) {
            resource = System.getProperty("body");
        }
        
        Request request = buildHttpRequest(url, resource);
        LOGGER.info("Posting content of the resource at '{}' to '{}'", resource, request.url().toString());       
        
        OkHttpClient client = new OkHttpClient();
        Response response = client.newCall(request).execute();

        if (!response.isSuccessful()) {
            throw new IOException("Request Failed with response:\n" + response);
        }

        LOGGER.info("Server response: \n{}", response.body().string());
    }
    
    private static Request buildHttpRequest(String url, String resource) throws IOException {

        String body = IOUtils.toString(SampleClient.class.getResource(resource), "UTF-8");
        MediaType mediaType = MEDIA_TYPE_XML;
        Builder builder = new Request.Builder();

        if (resource.endsWith("json")) {
                
                String[] split = resource.split("/");
                if (split.length != 3) {
                    throw new IllegalArgumentException("This particular sample client is expecting to derive DataSource and operation from the filename.  E.g., /Customers/add.json");
                }
                String ds = split[1];
                String op = split[2];
            
                url += "/" + ds;
                mediaType = MEDIA_TYPE_JSON;
        
                if ("update".equals((op))) {
                    return builder.url(url).put(RequestBody.create(mediaType, body)).build();
                }
        }
        return builder.url(url).post(RequestBody.create(mediaType, body)).build();
    }
}