/*
 * Decompiled with CFR 0.152.
 */
package com.isomorphic.servlet;

import com.isomorphic.servlet.BaseFilter;
import com.isomorphic.servlet.ProxyHttpServletResponse;
import com.isomorphic.servlet.ProxyServletOutputStream;
import com.isomorphic.servlet.RequestContext;
import com.isomorphic.util.IOUtil;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.StringReader;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class TestRunnerFilter
extends BaseFilter {
    private static String filterName = "TestRunnerFilter";

    @Override
    public void init(FilterConfig filterConfig) throws ServletException {
        super.init(filterConfig);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void _doFilter(ServletRequest req, ServletResponse res, FilterChain chain) throws ServletException, IOException {
        HttpServletRequest request = (HttpServletRequest)req;
        HttpServletResponse response = (HttpServletResponse)res;
        try {
            boolean jsOnly;
            RequestContext context = RequestContext.instance(this.servletContext, (ServletRequest)request, (ServletResponse)response);
            context.setNoCacheHeaders();
            boolean bl = jsOnly = request.getParameter("jsOnly") != null;
            if (!jsOnly) {
                context.setContentType("text/html");
                chain.doFilter((ServletRequest)request, (ServletResponse)response);
                return;
            }
            ByteArrayOutputStream wrapBuf = new ByteArrayOutputStream();
            ProxyHttpServletResponse wrapResponse = new ProxyHttpServletResponse(response, new ProxyServletOutputStream(wrapBuf), filterName);
            chain.doFilter((ServletRequest)request, (ServletResponse)wrapResponse);
            try {
                wrapResponse.flushBuffer();
            }
            catch (Exception exception) {
                // empty catch block
            }
            wrapBuf.flush();
            String output = wrapBuf.toString();
            int testHeaderEndIndex = output.indexOf("//--testHeaderEnd--");
            int testFooterStartIndex = output.indexOf("//--testFooterStart--");
            if (testHeaderEndIndex == -1 || testFooterStartIndex == -1) {
                throw new Exception("Can't find header/footer end/start markers.  You must include the *.test include-perlude,include-coda jsp-property-group in your web.xml");
            }
            context.setContentType("text/javascript");
            String testCase = output.substring(testHeaderEndIndex, testFooterStartIndex);
            IOUtil.copyCharacterStreams(new StringReader(testCase), response.getWriter());
        }
        catch (Exception e) {
            this.log.error((Object)("Problem serving test case " + request.getRequestURI()), e);
        }
        finally {
            try {
                response.flushBuffer();
            }
            catch (Exception exception) {}
        }
    }
}

