/*
 * Decompiled with CFR 0.152.
 */
package com.isomorphic.rpc;

import com.isomorphic.base.Base;
import com.isomorphic.base.Config;
import com.isomorphic.base.Reflection;
import com.isomorphic.datasource.BasicDataSource;
import com.isomorphic.datasource.DSField;
import com.isomorphic.datasource.DataSource;
import com.isomorphic.log.Logger;
import com.isomorphic.rpc.DataExport;
import com.isomorphic.rpc.ExcelFormulaParser;
import com.isomorphic.rpc.OOXMLDataExport;
import com.isomorphic.util.DataTools;
import com.isomorphic.util.IOUtil;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringWriter;
import java.io.Writer;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.TimeZone;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.poi.hssf.usermodel.HSSFPalette;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.hssf.util.HSSFColor;
import org.apache.poi.ss.formula.FormulaParseException;
import org.apache.poi.ss.formula.eval.NotImplementedException;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.CellType;
import org.apache.poi.ss.usermodel.DataFormat;
import org.apache.poi.ss.usermodel.DateUtil;
import org.apache.poi.ss.usermodel.FillPatternType;
import org.apache.poi.ss.usermodel.Font;
import org.apache.poi.ss.usermodel.FormulaEvaluator;
import org.apache.poi.ss.usermodel.HorizontalAlignment;
import org.apache.poi.ss.usermodel.RichTextString;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.VerticalAlignment;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.util.CellRangeAddress;
import org.apache.poi.ss.util.CellReference;
import org.apache.poi.util.LocaleUtil;
import org.apache.poi.xssf.streaming.SXSSFSheet;

public class ExcelDataExport
extends Base {
    private static Logger log = new Logger(ExcelDataExport.class.getName());
    private static Logger memoryUsageLogger = new Logger("excel_export_memory_usage");
    private static final Pattern WORD_PATTERN = Pattern.compile("\\w+");
    private static final String DEFAULT_EXCEL_FORMAT = "General";
    private static final float BASE_PIXELS_TO_TWIPS_MULTIPLIER = 15.0f;
    private static final float PIXELS_TO_TWIPS_MULTIPLIER;
    private Workbook workbook;
    private DataExport export;
    List<String> headers;
    Map<String, String> otherFields;
    private boolean exportSpans;
    private boolean wrapHeaders;
    private boolean clientData;
    private boolean streaming;
    private boolean datesAsString;
    private boolean numbersAsString;
    private DecimalFormat defaultDecimalFormat = new DecimalFormat();
    private Config defaultformatsByType = Config.getGlobal().getSubtree("export.format.default");
    private Collection columns;
    protected Pattern pattern = Pattern.compile("<[Bb][Rr]\\s*/?>");
    HeaderStyle rowHeaderStyle;
    HeaderStyle columnHeaderStyle;
    int numberOfRowHeaderCells;
    List<HeaderSpan> headerSpans = new ArrayList<HeaderSpan>();
    private Map colorCache = new HashMap();
    private short colorIndex = (short)8;
    private Map styleCache = new HashMap();
    private Map fontCache = new HashMap();
    private Map formatCache = new HashMap();
    Pattern regex = Pattern.compile("YY?Y?Y?|LL?L?L?|CC?|cc?|w|D|u");
    private static Map<String, String> colorMap;

    public static Class getExportObjectType() throws ClassNotFoundException {
        return Reflection.classForName("org.apache.poi.ss.usermodel.Workbook");
    }

    static void exportResultSet(DataExport export, boolean ooxml, List dataRows, Map columnRemap, Writer out) throws Exception {
        new ExcelDataExport().export(export, ooxml, dataRows, columnRemap, out, null, null);
    }

    static void exportResultSet(DataExport export, boolean ooxml, List dataRows, Map columnRemap, Writer out, Map settings, DataSource dataSource) throws Exception {
        new ExcelDataExport().export(export, ooxml, dataRows, columnRemap, out, settings, dataSource);
    }

    static void exportResultSet(DataExport export, boolean ooxml, List dataRows, Map columnRemap, Writer out, OutputStream os, Map settings, DataSource dataSource) throws Exception {
        ExcelDataExport.exportResultSet(export, ooxml, dataRows.iterator(), columnRemap, out, os, settings, dataSource);
    }

    static void exportResultSet(DataExport export, boolean ooxml, Iterator dataIterator, Map columnRemap, Writer out, OutputStream os, Map settings, DataSource dataSource) throws Exception {
        new ExcelDataExport().export(export, ooxml, dataIterator, columnRemap, out, os, settings, dataSource);
    }

    public static void exportResultSet(DataExport export, boolean ooxml, List dataRows, Map columnRemap, OutputStream out) throws Exception {
        new ExcelDataExport().export(export, ooxml, dataRows, columnRemap, out, null, null);
    }

    void export(DataExport export, boolean ooxml, List dataRows, Map columnRemap, OutputStream out, Map settings, DataSource dataSource) throws Exception {
        this.export(export, ooxml, dataRows.iterator(), columnRemap, out, settings, dataSource);
    }

    void export(DataExport export, boolean ooxml, Iterator dataIterator, Map columnRemap, OutputStream out, Map settings, DataSource dataSource) throws Exception {
        this.export(export, ooxml, dataIterator, columnRemap, null, out, settings, dataSource);
    }

    void export(DataExport export, boolean ooxml, List dataRows, Map columnRemap, Writer out, Map settings, DataSource dataSource) throws Exception {
        this.export(export, ooxml, dataRows.iterator(), columnRemap, out, null, settings, dataSource);
    }

    void export(DataExport export, boolean ooxml, Iterator dataIterator, Map columnRemap, Writer out, Map settings, DataSource dataSource) throws Exception {
        this.export(export, ooxml, dataIterator, columnRemap, out, null, settings, dataSource);
    }

    public void export(DataExport export, boolean ooxml, Iterator dataIterator, Map columnRemap, Writer out, OutputStream os, Map settings, DataSource dataSource) throws Exception {
        this.writeExportObject(this.getExportObject(export, ooxml, dataIterator, columnRemap, settings, dataSource), out, os);
    }

    public Object getExportObject(DataExport export, boolean ooxml, Iterator dataIterator, Map<String, String> columnRemap, Map settings, DataSource dataSource) throws Exception {
        String exportFooter;
        Row row;
        Map record = null;
        this.export = export;
        String _exportTZ = (String)settings.get("exportTZ");
        if (_exportTZ == null || "server".equalsIgnoreCase(_exportTZ)) {
            LocaleUtil.setUserTimeZone((TimeZone)TimeZone.getDefault());
        } else {
            LocaleUtil.setUserTimeZone((TimeZone)TimeZone.getTimeZone("GMT" + _exportTZ));
        }
        if (ooxml) {
            this.streaming = config.getBoolean((Object)"excel.useStreaming", true);
            if (settings.get("exportStreaming") != null) {
                this.streaming = DataTools.getBoolean(settings, "exportStreaming", true);
            }
            try {
                this.workbook = OOXMLDataExport.getXSSFWorkbook(this.streaming);
            }
            catch (NoClassDefFoundError e) {
                log.error("Trouble loading Apache POI OOXML classes - are the poi-ooxml and poi-ooxml-schemas .jar files deployed?  These are required in addition to the base POI .jar if you want to export in Excel 2007 format");
                throw e;
            }
        } else {
            this.workbook = new HSSFWorkbook();
            this.streaming = false;
        }
        if (ooxml) {
            log.debug("Export streaming mode: " + this.streaming);
        }
        if (settings == null) {
            settings = new HashMap();
            if (export.settings == null) {
                export.settings = settings;
            }
        }
        this.clientData = DataTools.getBoolean(settings, "exportClientData");
        this.wrapHeaders = DataTools.getBoolean(settings, "exportWrapHeaderTitles");
        this.datesAsString = DataTools.getBoolean(settings, "exportDatesAsFormattedString");
        this.numbersAsString = DataTools.getBoolean(settings, "exportNumbersAsFormattedString");
        this.otherFields = (Map)export.settings.get("exportOtherFields");
        Sheet worksheet = this.workbook.createSheet();
        if (export.order != null) {
            this.columns = export.order;
            if (columnRemap == null) {
                this.headers = new ArrayList<String>(this.columns);
            } else {
                this.headers = new ArrayList<String>();
                for (String col : export.order) {
                    String remapped = (String)columnRemap.get(col);
                    if (remapped != null) {
                        this.headers.add(remapped);
                        continue;
                    }
                    this.headers.add(col);
                }
            }
        } else {
            if (columnRemap == null) {
                if (this.streaming || !(dataIterator instanceof ListIterator)) {
                    record = export.getRecord(dataIterator.next());
                    columnRemap = export.getColumnNames(record);
                } else {
                    ListIterator li = (ListIterator)dataIterator;
                    columnRemap = export.getColumnNames(li);
                    while (li.hasPrevious()) {
                        li.previous();
                    }
                }
            }
            this.columns = columnRemap.keySet();
            this.headers = new ArrayList<String>(columnRemap.values());
        }
        int rowIndex = 0;
        int cellIndex = 0;
        String exportHeader = (String)settings.get("exportHeader");
        if (exportHeader != null && !exportHeader.equals("")) {
            row = worksheet.createRow(rowIndex++);
            worksheet.addMergedRegion(new CellRangeAddress(0, 0, 0, this.headers.size() - 1));
            Cell cell = row.createCell(0, CellType.STRING);
            cell.setCellValue(exportHeader);
            row = worksheet.createRow(rowIndex++);
        }
        boolean headerless = false;
        int headerRow = rowIndex;
        if (settings.get("exportHeaderless") != null) {
            headerless = DataTools.asBoolean(settings.get("exportHeaderless"), false);
        }
        if (!headerless) {
            HeaderColors headerBGColors = new HeaderColors(settings, "BGColor");
            HeaderColors headerTextColors = new HeaderColors(settings, "TextColor");
            this.columnHeaderStyle = new HeaderStyle(headerBGColors.columnFacetColor, headerTextColors.columnFacetColor);
            Long rowFacetCount = (Long)settings.get("exportHeaderRowFacetCount");
            if (rowFacetCount != null && (headerBGColors.different() || headerTextColors.different())) {
                this.numberOfRowHeaderCells = rowFacetCount.intValue();
                this.rowHeaderStyle = new HeaderStyle(headerBGColors.rowFacetColor, headerTextColors.rowFacetColor);
            } else {
                this.rowHeaderStyle = this.columnHeaderStyle;
            }
            int rowIndexHeaderStart = rowIndex;
            rowIndex = this.calcHeaderSpans(worksheet, export, rowIndex);
            this.calcOtherFields(worksheet, export, rowIndexHeaderStart, rowIndex);
            headerRow = rowIndex++;
        }
        if (this.streaming) {
            this.outputHeaders(headerless, worksheet, settings, headerRow);
        }
        List formulaFields = (List)settings.get("formulaFields");
        List formulaRemap = (List)settings.get("formulaRemap");
        HashMap<String, Integer> indexedColumns = new HashMap<String, Integer>();
        Integer index = 0;
        Iterator i = this.columns.iterator();
        while (i.hasNext()) {
            indexedColumns.put((String)i.next(), index);
            Integer n = index;
            Integer n2 = index = Integer.valueOf(index + 1);
        }
        FormulaEvaluator evaluator = null;
        HashMap<String, Map> formulas = new HashMap<String, Map>();
        if (formulaFields != null) {
            evaluator = this.workbook.getCreationHelper().createFormulaEvaluator();
            for (int i2 = 0; i2 < formulaFields.size(); ++i2) {
                Map formulaField = (Map)formulaFields.get(i2);
                Map vars = (Map)formulaField.get("formulaVars");
                HashMap<String, Integer> newVars = new HashMap<String, Integer>();
                boolean ignoreFormulaField = false;
                if (vars != null) {
                    for (Map.Entry e : vars.entrySet()) {
                        String key = (String)e.getKey();
                        if (newVars.containsKey(key)) continue;
                        Integer columnIndex = (Integer)indexedColumns.get(e.getValue());
                        if (columnIndex == null) {
                            ignoreFormulaField = true;
                            break;
                        }
                        newVars.put(key, columnIndex);
                    }
                }
                if (ignoreFormulaField) continue;
                formulaField.put("newVars", newVars);
                formulas.put((String)formulaField.get("name"), formulaField);
            }
        }
        BackgroundColors bgColors = new BackgroundColors(settings);
        if (record == null && dataIterator.hasNext()) {
            record = export.getRecord(dataIterator.next());
        }
        while (ooxml || rowIndex < 65536) {
            if (record == null || record.size() == 0) {
                if (!dataIterator.hasNext()) break;
                record = export.getRecord(dataIterator.next());
                continue;
            }
            export.applyDisplayValues(record);
            row = worksheet.createRow(rowIndex++);
            cellIndex = 0;
            for (String columnName : this.columns) {
                boolean formulaWasSet;
                Map styleElements;
                ArrayList styles;
                Cell cell;
                String stringifiedValue;
                Object cellValue;
                block135: {
                    int offset;
                    String color;
                    if (columnName.indexOf("$style") != -1) continue;
                    cellValue = record.get(columnName);
                    stringifiedValue = cellValue == null ? null : cellValue.toString();
                    cell = null;
                    Object styleObj = record.get(columnName + "$style");
                    styles = null;
                    if (styleObj != null) {
                        if (styleObj instanceof List) {
                            styles = (ArrayList)styleObj;
                        } else {
                            styles = new ArrayList();
                            styles.add(styleObj);
                        }
                    }
                    this.normalizeBackgroundColor(styles);
                    styleElements = null;
                    if (styles != null) {
                        styleElements = (HashMap<String, String>)styles.get(0);
                    }
                    if (styleElements != null && styleElements.get("rawValue") != null) {
                        if (styleElements.get("format") != null || styleElements.get("exportFormat") != null || styleElements.get("dateFormatter") != null && styleElements.get("rawValue") instanceof Date) {
                            cellValue = styleElements.get("rawValue");
                        }
                        Object rawValue = styleElements.get("rawValue");
                        Boolean exportRawNumbers = DataTools.getBoolean(styleElements, "exportRawNumbers", false);
                        Boolean hasValueMap = DataTools.getBoolean(styleElements, "hasValueMap", false);
                        if (cellValue instanceof String && rawValue instanceof Number && !hasValueMap.booleanValue() && exportRawNumbers.booleanValue()) {
                            boolean exportNumber = true;
                            try {
                                Double.parseDouble((String)cellValue);
                            }
                            catch (NumberFormatException nfe) {
                                exportNumber = false;
                            }
                            if (exportNumber) {
                                cellValue = rawValue;
                            }
                        }
                    }
                    if ((color = bgColors.getColorForCell(rowIndex - (offset = 1 + (headerless ? 0 : headerRow + 1)), cellIndex)) != null) {
                        if (styleElements == null) {
                            styleElements = new HashMap<String, String>();
                        }
                        if (styleElements.get("backgroundColor") == null) {
                            styleElements.put("backgroundColor", color);
                        }
                    }
                    formulaWasSet = false;
                    Map formula = (Map)formulas.get(columnName);
                    if (formula != null) {
                        String text = (String)formula.get("text");
                        Map vars = (Map)formula.get("newVars");
                        Matcher matcher = WORD_PATTERN.matcher(text);
                        StringBuffer replaceBuffer = new StringBuffer();
                        while (matcher.find()) {
                            Integer mappedIndex = (Integer)vars.get(matcher.group());
                            if (mappedIndex == null) continue;
                            String newVar = new CellReference(row.getRowNum(), mappedIndex.intValue()).formatAsString();
                            matcher.appendReplacement(replaceBuffer, newVar);
                        }
                        matcher.appendTail(replaceBuffer);
                        String transformedFormula = ExcelFormulaParser.transform(replaceBuffer.toString());
                        cell = row.createCell(cellIndex, CellType.FORMULA);
                        try {
                            cell.setCellFormula(transformedFormula);
                            cell.setCellStyle(this.getCellStyle(styleElements, false, null, cellValue, cellIndex));
                            try {
                                if (evaluator.evaluateFormulaCell(cell) == CellType.ERROR) {
                                    cell.setCellFormula(null);
                                    break block135;
                                }
                                formulaWasSet = true;
                            }
                            catch (NotImplementedException nia) {
                                cell.setCellFormula(null);
                            }
                        }
                        catch (FormulaParseException ex) {
                            log.warn("Caught exception processing cell formula '" + transformedFormula + "'.  Error: " + ex.getMessage());
                        }
                    }
                }
                DSField field = null;
                if (dataSource != null) {
                    field = dataSource.getField(columnName);
                }
                if (!(formulaWasSet || cellValue == null && styleElements == null)) {
                    String formattedCellValue;
                    char trailing;
                    String work;
                    if (cellValue instanceof String && dataSource != null && field == null && ((String)cellValue).trim().indexOf("0") != 0 && (work = ((String)cellValue).trim()).length() > 0 && !Character.isLetter(trailing = work.charAt(work.length() - 1))) {
                        try {
                            cellValue = Double.valueOf((String)cellValue);
                        }
                        catch (NumberFormatException replaceBuffer) {
                            // empty catch block
                        }
                    }
                    if (cellValue instanceof Number) {
                        if (this.numbersAsString) {
                            formattedCellValue = this.clientData ? stringifiedValue : null;
                            cell = row.createCell(cellIndex, CellType.STRING);
                            if (formattedCellValue == null && dataSource != null && field != null) {
                                String exportFormat = field.getProperty("exportFormat");
                                if (exportFormat == null) {
                                    String fieldType = field.getType();
                                    if (fieldType == null) {
                                        fieldType = "float";
                                    }
                                    Config formatsByType = Config.getGlobal().getSubtree("export.format");
                                    exportFormat = formatsByType.getString(fieldType);
                                }
                                if (exportFormat != null) {
                                    DecimalFormat df = new DecimalFormat(exportFormat);
                                    formattedCellValue = df.format(cellValue);
                                }
                            }
                            if (formattedCellValue == null) {
                                formattedCellValue = this.defaultDecimalFormat.format(cellValue);
                            }
                            cell.setCellValue(formattedCellValue);
                        } else {
                            cell = row.createCell(cellIndex, CellType.NUMERIC);
                            cell.setCellValue(((Number)cellValue).doubleValue());
                        }
                    } else if (cellValue instanceof Date) {
                        if (this.datesAsString) {
                            formattedCellValue = this.clientData ? stringifiedValue : null;
                            cell = row.createCell(cellIndex, CellType.STRING);
                            Date cellValueAsDate = (Date)cellValue;
                            if (formattedCellValue == null) {
                                BasicDataSource bds;
                                DSField dtField;
                                if (dataSource instanceof BasicDataSource && (dtField = (bds = (BasicDataSource)dataSource).getField(columnName)) != null && bds.simpleTypeInheritsFrom(dtField.getType(), "datetime")) {
                                    String exportTZ = (String)settings.get("exportTZ");
                                    int offsetMillis = 0;
                                    offsetMillis = exportTZ == null || "server".equalsIgnoreCase(exportTZ) ? TimeZone.getDefault().getRawOffset() : DataTools.parseTimeZoneOffset(exportTZ);
                                    cellValueAsDate = new Date(cellValueAsDate.getTime() + (long)offsetMillis);
                                }
                                if (dataSource != null && field != null) {
                                    String exportFormat = field.getProperty("exportFormat");
                                    if (exportFormat == null) {
                                        String fieldType = field.getType();
                                        if (fieldType == null || dataSource.simpleTypeInheritsFrom(fieldType, "datetime")) {
                                            fieldType = "datetime";
                                        } else if (dataSource.simpleTypeInheritsFrom(fieldType, "date")) {
                                            fieldType = "date";
                                        } else if (dataSource.simpleTypeInheritsFrom(fieldType, "time")) {
                                            fieldType = "time";
                                        }
                                        Config formatsByType = Config.getGlobal().getSubtree("export.format");
                                        exportFormat = formatsByType.getString(fieldType);
                                    }
                                    if (exportFormat != null) {
                                        SimpleDateFormat sdf = new SimpleDateFormat(exportFormat);
                                        formattedCellValue = sdf.format(cellValueAsDate);
                                    }
                                }
                            }
                            if (formattedCellValue == null) {
                                formattedCellValue = DataTools.fastDateFormat(cellValueAsDate);
                            }
                            cell.setCellValue(formattedCellValue);
                        } else {
                            cell = row.createCell(cellIndex, CellType.NUMERIC);
                            double excelDateValue = DateUtil.getExcelDate((Date)((Date)cellValue));
                            cell.setCellValue(excelDateValue);
                        }
                    } else if (cellValue instanceof Collection) {
                        String value = null;
                        if (dataSource != null && dataSource.getField(columnName) != null && field.isMultiple()) {
                            String separator = field.getProperty("multipleValueSeparator");
                            if (separator == null) {
                                separator = ",";
                            }
                            for (Object element : (Collection)cellValue) {
                                if (element == null) continue;
                                if (value == null) {
                                    value = element.toString();
                                    continue;
                                }
                                value = value + separator + element.toString();
                            }
                        }
                        if (value == null) {
                            value = cellValue == null ? null : cellValue.toString();
                        }
                        cell = row.createCell(cellIndex, CellType.STRING);
                        cell.setCellValue(value);
                    } else if (cellValue instanceof Reader) {
                        StringWriter sw = new StringWriter();
                        IOUtil.copyCharacterStreams((Reader)cellValue, sw);
                        cell = row.createCell(cellIndex, CellType.STRING);
                        cell.setCellValue(this.trimStringValue(sw.toString()));
                    } else if (cellValue instanceof InputStream) {
                        cell = row.createCell(cellIndex, CellType.STRING);
                        String strValue = IOUtil.inputStreamToString((InputStream)cellValue);
                        cell.setCellValue(this.trimStringValue(strValue));
                    } else {
                        cell = row.createCell(cellIndex, CellType.STRING);
                        cell.setCellValue(this.trimStringValue(cellValue == null ? null : cellValue.toString()));
                    }
                    if (styleElements != null) {
                        if (styleElements.get("style") != null) {
                            styleElements = (Map)styleElements.get("style");
                        }
                        if (cellValue instanceof Date) {
                            String dsfFormat = null;
                            dsfFormat = (String)styleElements.get("exportFormat");
                            if (dsfFormat == null) {
                                dsfFormat = (String)styleElements.get("format");
                            }
                            if (dsfFormat == null) {
                                dsfFormat = (String)styleElements.get("dateFormatter");
                            }
                            if (dsfFormat != null) {
                                cell.setCellStyle(this.getCellStyle(styleElements, false, null, cellValue, cellIndex));
                            } else {
                                cellValue = stringifiedValue;
                            }
                        } else {
                            boolean exportRawNumbers = DataTools.getBoolean(styleElements, "exportRawNumbers", false);
                            cell.setCellStyle(this.getCellStyle(styleElements, false, null, cellValue, cellIndex, exportRawNumbers));
                        }
                    } else if (cellValue instanceof Date || cellValue instanceof Number) {
                        String dsfFormat = null;
                        if (dataSource != null) {
                            if (field != null) {
                                dsfFormat = field.getProperty("exportFormat");
                                if (dsfFormat == null) {
                                    dsfFormat = field.getProperty("format");
                                }
                                if (dsfFormat == null && cellValue instanceof Date) {
                                    dsfFormat = field.getProperty("dateFormatter");
                                }
                                if (dsfFormat == null && cellValue instanceof Date) {
                                    String fieldType = field.getType();
                                    if (fieldType == null || dataSource.simpleTypeInheritsFrom(fieldType, "datetime")) {
                                        fieldType = "datetime";
                                    } else if (dataSource.simpleTypeInheritsFrom(fieldType, "date")) {
                                        fieldType = "date";
                                    } else if (dataSource.simpleTypeInheritsFrom(fieldType, "time")) {
                                        fieldType = "time";
                                    }
                                    dsfFormat = this.defaultformatsByType.getString(fieldType);
                                    if (dsfFormat == null) {
                                        dsfFormat = "toString";
                                    }
                                }
                            }
                        } else if (cellValue instanceof Date) {
                            dsfFormat = "toString";
                        }
                        cell.setCellStyle(this.getCellStyle(null, true, dsfFormat, cellValue, cellIndex));
                    } else {
                        cell.setCellStyle(this.getCellStyle(null, false, null, cellValue, cellIndex));
                    }
                    if (styles != null && styles.size() > 1) {
                        cell.setCellValue(this.buildRichTextString(styles, stringifiedValue));
                    }
                }
                ++cellIndex;
            }
            if (!dataIterator.hasNext()) break;
            record = export.getRecord(dataIterator.next());
            if (!memoryUsageLogger.isDebugEnabled() || rowIndex % 1000 != 0) continue;
            Runtime runtime = Runtime.getRuntime();
            runtime.gc();
            long memory = runtime.totalMemory() - runtime.freeMemory();
            DecimalFormat df = new DecimalFormat("0.00");
            memoryUsageLogger.debug((this.streaming ? "Streaming" : "Building in memory") + " row " + rowIndex + ": Used memory: " + df.format((float)memory / 1048576.0f) + "MB; Free memory: " + df.format((float)runtime.freeMemory() / 1048576.0f) + "MB");
        }
        if (!ooxml && rowIndex >= 65536) {
            log.warn("Dataset contains more than 65535 rows, making it too large for the XLS format.  Exporting just the first 65535 rows");
        }
        if ((exportFooter = (String)settings.get("exportFooter")) != null && !exportFooter.equals("") && (ooxml || rowIndex < 65535)) {
            row = worksheet.createRow(rowIndex++);
            row = worksheet.createRow(rowIndex);
            worksheet.addMergedRegion(new CellRangeAddress(rowIndex, rowIndex, 0, this.headers.size() - 1));
            Cell cell = row.createCell(0, CellType.STRING);
            cell.setCellValue(exportFooter);
        }
        if (!this.streaming) {
            this.outputHeaders(headerless, worksheet, settings, headerRow);
        }
        if (export.settings.get("exportFieldPixelWidths") instanceof List) {
            List pxWidths = (List)export.settings.get("exportFieldPixelWidths");
            float scale = ((Double)export.settings.get("exportWidthScale")).floatValue();
            for (int i3 = 0; i3 < this.columns.size(); ++i3) {
                int pxWidth = ((Long)pxWidths.get(i3)).intValue();
                if (pxWidth != -1) {
                    worksheet.setColumnWidth(i3, (int)((float)(pxWidth * 256) * scale));
                    continue;
                }
                try {
                    if (worksheet instanceof SXSSFSheet) {
                        ((SXSSFSheet)worksheet).trackColumnForAutoSizing(i3);
                    }
                    worksheet.autoSizeColumn(i3);
                    continue;
                }
                catch (Exception e) {
                    log.warn((Object)"Failed to autoSizeColumn", e);
                }
            }
        } else {
            for (int i4 = 0; i4 < this.columns.size(); ++i4) {
                try {
                    if (worksheet instanceof SXSSFSheet) {
                        ((SXSSFSheet)worksheet).trackColumnForAutoSizing(i4);
                    }
                    worksheet.autoSizeColumn(i4);
                    continue;
                }
                catch (Exception e) {
                    log.warn((Object)"Failed to autoSizeColumn", e);
                }
            }
        }
        return this.workbook;
    }

    private String trimStringValue(String str) {
        if (str == null) {
            return null;
        }
        if (str.length() <= Short.MAX_VALUE) {
            return str;
        }
        log.warn("Export value of " + str.length() + " length will be trimmed to 32.767 characters, which is the maximum length of text cell contents supported by Excel.");
        return str.substring(0, Short.MAX_VALUE);
    }

    protected void outputHeaders(boolean headerless, Sheet worksheet, Map settings, int headerRow) {
        if (!headerless) {
            if (this.exportSpans) {
                this.outputHeaderSpans(worksheet);
            } else {
                Row row = worksheet.createRow(headerRow);
                if (settings.get("exportHeaderHeight") != null) {
                    int pixelHeight = ((Long)settings.get("exportHeaderHeight")).intValue();
                    row.setHeight((short)((float)pixelHeight * PIXELS_TO_TWIPS_MULTIPLIER));
                }
                int cellIndex = 0;
                for (String header : this.headers) {
                    if (header.indexOf("$style") != -1) continue;
                    if (header != null) {
                        Cell cell = row.createCell(cellIndex, CellType.STRING);
                        cell.setCellValue(header);
                        HeaderStyle headerStyle = cellIndex < this.numberOfRowHeaderCells ? this.rowHeaderStyle : this.columnHeaderStyle;
                        HorizontalAlignment alignment = this.getHorizontalAlignment(cellIndex, true);
                        cell.setCellStyle(headerStyle.getStyle(true, alignment));
                    }
                    ++cellIndex;
                }
            }
        }
    }

    protected String replaceBreakTags(String input) {
        Matcher matcher = this.pattern.matcher(input);
        return matcher.replaceAll(this.wrapHeaders ? "\n" : " ");
    }

    protected int calcHeaderSpans(Sheet worksheet, DataExport export, int rowIndex) {
        List spans = (List)export.settings.get("exportHeaderSpans");
        boolean bl = this.exportSpans = spans != null && spans.size() > 0;
        if (this.exportSpans && export.settings.get("exportShowHeaderSpanTitles") != null) {
            this.exportSpans = DataTools.asBoolean(export.settings.get("exportShowHeaderSpanTitles"));
        }
        if (!this.exportSpans) {
            return rowIndex;
        }
        return this._calcHeaderSpans(worksheet, spans, rowIndex, 0);
    }

    protected int _calcHeaderSpans(Sheet worksheet, List spans, int rowIndex, int colIndex) {
        int tmpRowIndex = rowIndex + 1;
        spans.sort(new Comparator<Map>(){

            @Override
            public int compare(Map o1, Map o2) {
                List<Integer> list1 = ExcelDataExport.this.getColumnsSpanned(o1);
                int i1 = list1 != null && !list1.isEmpty() ? list1.get(0) : -1;
                List<Integer> list2 = ExcelDataExport.this.getColumnsSpanned(o2);
                int i2 = list2 != null && !list2.isEmpty() ? list2.get(0) : -1;
                return i1 - i2;
            }
        });
        for (Map span : spans) {
            List fields;
            String title = (String)span.get("title");
            Short height = -1;
            Long temp = (Long)span.get("height");
            if (temp != null) {
                height = temp.shortValue();
            }
            List<Integer> columnsSpanned = this.getColumnsSpanned(span);
            List subSpans = (List)span.get("spans");
            if (subSpans != null) {
                tmpRowIndex = Math.max(tmpRowIndex, rowIndex + this._calcHeaderSpans(worksheet, subSpans, rowIndex + 1, colIndex));
            }
            colIndex += columnsSpanned.size();
            int first = -1;
            int last = -1;
            for (int j = 0; j < columnsSpanned.size(); ++j) {
                int colNum = columnsSpanned.get(j);
                if (first == -1) {
                    first = colNum;
                } else if (colNum != last + 1) {
                    this.rearrangeSpannedColumns(columnsSpanned);
                    last = first + columnsSpanned.size() - 1;
                    this.columns = this.headers;
                    break;
                }
                last = colNum;
            }
            if (first <= -1 || last <= -1) {
                last = first = colIndex;
            }
            HeaderSpan hs = new HeaderSpan();
            hs.row = rowIndex;
            hs.startCol = first;
            hs.endCol = last;
            hs.title = title;
            hs.height = height;
            this.headerSpans.add(hs);
            if (this.otherFields != null) {
                this.otherFields.remove(span.get("name"));
            }
            if (subSpans != null || (fields = (List)span.get("fields")) == null) continue;
            for (Map field : fields) {
                String fieldName;
                int colNum;
                if (field == null || (colNum = this.headers.indexOf(fieldName = (String)field.get("name"))) == -1 && (colNum = this.headers.indexOf(fieldName = (String)field.get("title"))) == -1) continue;
                hs = new HeaderSpan();
                hs.row = rowIndex + 1;
                hs.endCol = hs.startCol = this.headers.indexOf(fieldName);
                hs.title = (String)field.get("title");
                hs.height = (short)-1;
                this.headerSpans.add(hs);
                if (this.otherFields == null) continue;
                this.otherFields.remove(field.get("name"));
            }
        }
        return tmpRowIndex;
    }

    protected List<Integer> getColumnsSpanned(Map span) {
        ArrayList<Integer> columns = new ArrayList<Integer>();
        List subSpans = (List)span.get("spans");
        if (subSpans != null) {
            Iterator i = subSpans.iterator();
            while (i.hasNext()) {
                columns.addAll(this.getColumnsSpanned((Map)i.next()));
            }
        } else {
            List fields = (List)span.get("fields");
            if (fields == null) {
                log.warn("Found a headerSpan definition with neither spans nor fields defined - ignoring");
            } else {
                for (Map field : fields) {
                    if (field == null) continue;
                    String fieldName = (String)field.get("name");
                    int colNum = this.headers.indexOf(fieldName);
                    if (colNum == -1) {
                        fieldName = (String)field.get("title");
                        colNum = this.headers.indexOf(fieldName);
                        if (colNum == -1) {
                            log.warn("headerSpan definition names an unknown field '" + fieldName + "' - ignoring");
                            continue;
                        }
                        columns.add(colNum);
                        continue;
                    }
                    columns.add(colNum);
                }
            }
        }
        Collections.sort(columns);
        return columns;
    }

    protected void rearrangeSpannedColumns(List<Integer> cols) {
        int first;
        ArrayList<String> copyHeaders = new ArrayList<String>(this.headers);
        int last = first = cols.get(0).intValue();
        for (int i = 1; i < cols.size(); ++i) {
            int colNum = cols.get(i);
            if (colNum != last + 1) {
                String colName = this.headers.get(colNum);
                String lastColName = this.headers.get(last + 1);
                copyHeaders.remove(colName);
                copyHeaders.add(copyHeaders.indexOf(lastColName), colName);
                continue;
            }
            last = colNum;
        }
        this.headers = copyHeaders;
    }

    protected void calcOtherFields(Sheet worksheet, DataExport export, int rowIndexHeaderStart, int rowIndex) {
        if (this.otherFields != null) {
            ArrayList<String> copyHeaders = this.exportSpans ? this.headers : new ArrayList<String>(this.headers);
            for (Map.Entry<String, String> e : this.otherFields.entrySet()) {
                int pos = copyHeaders.indexOf(e.getKey());
                if (pos == -1) {
                    pos = copyHeaders.indexOf(e.getValue());
                }
                if (pos < 0) continue;
                String title = e.getValue();
                if (this.exportSpans) {
                    HeaderSpan hs = new HeaderSpan();
                    hs.row = rowIndexHeaderStart;
                    hs.endRow = rowIndex;
                    hs.endCol = hs.startCol = pos;
                    hs.title = title;
                    this.headerSpans.add(hs);
                    continue;
                }
                this.headers.set(pos, title);
            }
        }
    }

    protected void outputHeaderSpans(Sheet worksheet) {
        int headerHeight = -1;
        if (this.export.settings.get("exportHeaderHeight") != null) {
            headerHeight = ((Long)this.export.settings.get("exportHeaderHeight")).shortValue();
        }
        HashMap<Integer, Short> rowHeights = new HashMap<Integer, Short>();
        int defaultHeight = 23;
        int maxRow = 0;
        if (headerHeight != -1) {
            for (HeaderSpan hs : this.headerSpans) {
                if (hs.row > maxRow) {
                    maxRow = hs.row;
                }
                if (!rowHeights.containsKey(hs.row)) {
                    rowHeights.put(hs.row, hs.height);
                    continue;
                }
                if (hs.height == -1 || (Short)rowHeights.get(hs.row) != -1) continue;
                rowHeights.put(hs.row, hs.height);
            }
            int explicitHeight = 0;
            int implicitRows = 0;
            for (Short height : rowHeights.values()) {
                if (height == -1) {
                    implicitRows = (short)(implicitRows + 1);
                    continue;
                }
                explicitHeight = (short)(explicitHeight + height);
            }
            defaultHeight = (short)((headerHeight - explicitHeight) / implicitRows);
        }
        ArrayList<Row> rows = new ArrayList<Row>();
        for (HeaderSpan hs : this.headerSpans) {
            Row row = worksheet.getRow(hs.row);
            if (row == null) {
                row = worksheet.createRow(hs.row);
            }
            if (headerHeight != -1 && !rows.contains(row)) {
                if (hs.height != -1) {
                    row.setHeight((short)((float)hs.height * PIXELS_TO_TWIPS_MULTIPLIER));
                } else {
                    row.setHeight((short)((float)defaultHeight * PIXELS_TO_TWIPS_MULTIPLIER));
                }
                rows.add(row);
            }
            for (int j = hs.startCol; j <= hs.endCol; ++j) {
                Cell cell = row.createCell(j, CellType.STRING);
                if (j == hs.startCol) {
                    cell.setCellValue(hs.title);
                }
                HeaderStyle headerStyle = j < this.numberOfRowHeaderCells ? this.rowHeaderStyle : this.columnHeaderStyle;
                cell.setCellStyle(headerStyle.getStyle(hs.row == maxRow, this.getHorizontalAlignment(hs.startCol, true)));
            }
            if (hs.startCol == hs.endCol && (hs.endRow < 0 || hs.row == hs.endRow)) continue;
            worksheet.addMergedRegion(new CellRangeAddress(hs.row, hs.endRow >= 0 ? hs.endRow : hs.row, hs.startCol, hs.endCol));
        }
        if (headerHeight != -1) {
            Row row = worksheet.getRow(maxRow);
            short height = 0;
            for (Row r2 : rows) {
                if (r2.getRowNum() == maxRow) continue;
                height = (short)(height + r2.getHeight());
            }
            if ((height = (short)((float)headerHeight * PIXELS_TO_TWIPS_MULTIPLIER - (float)height)) > 0) {
                row.setHeight(height);
            }
        }
    }

    public void writeExportObject(Object exportObject, Writer out, OutputStream os) throws Exception {
        if (!this.workbook.getClass().isAssignableFrom(exportObject.getClass())) {
            throw new Exception("The supplied export object is of type " + exportObject.getClass().getName() + ".  We were expecting an object of type " + this.workbook.getClass().getName() + " (or a subclass)");
        }
        if (os != null) {
            this.workbook.write(os);
        } else {
            ByteArrayOutputStream stream = new ByteArrayOutputStream();
            this.workbook.write((OutputStream)stream);
            byte[] byteArray = stream.toByteArray();
            char[] charArray = new char[byteArray.length];
            for (int i = 0; i < byteArray.length; ++i) {
                charArray[i] = (char)(byteArray[i] & 0xFF);
            }
            out.write(charArray);
        }
        if (this.streaming) {
            OOXMLDataExport.disposeWorkbook(this.workbook);
        }
    }

    public void setExportObject(Object exportObject) throws Exception {
        if (!ExcelDataExport.getExportObjectType().isAssignableFrom(exportObject.getClass())) {
            throw new Exception("The supplied export object is of type " + exportObject.getClass().getName() + ".  We were expecting an object of type " + ExcelDataExport.getExportObjectType().getName() + " (or a subclass)");
        }
        this.workbook = (Workbook)exportObject;
    }

    private void normalizeBackgroundColor(List styles) {
        if (styles == null) {
            return;
        }
        Map firstStyle = (Map)styles.get(0);
        if (firstStyle.get("value") == null) {
            return;
        }
        if ((firstStyle = (Map)firstStyle.get("style")) != null && firstStyle.get("backgroundColor") != null) {
            return;
        }
        for (int i = 0; i < styles.size(); ++i) {
            Map style = (Map)((Map)styles.get(i)).get("style");
            if (style == null || style.get("backgroundColor") == null) continue;
            if (firstStyle == null) {
                firstStyle = (Map)styles.get(0);
                firstStyle.put("style", new HashMap());
                firstStyle = (Map)firstStyle.get("style");
            }
            firstStyle.put("backgroundColor", style.get("backgroundColor"));
            break;
        }
    }

    private void setBackgroundColor(CellStyle style, String backgroundColor) {
        style.setFillForegroundColor(this.getColor(backgroundColor));
        style.setFillPattern(FillPatternType.SOLID_FOREGROUND);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private short getColor(String targetColor) {
        if (this.colorCache.get(targetColor) != null) {
            return (Short)this.colorCache.get(targetColor);
        }
        int[] rgb = this.parseColorString(targetColor);
        if (this.workbook instanceof HSSFWorkbook && this.colorIndex < 64) {
            HSSFWorkbook hssfWorkbook = (HSSFWorkbook)this.workbook;
            HSSFPalette palette = hssfWorkbook.getCustomPalette();
            HSSFColor hssfColor = palette.findColor((byte)rgb[0], (byte)rgb[1], (byte)rgb[2]);
            if (hssfColor == null) {
                try {
                    hssfColor = palette.addColor((byte)rgb[0], (byte)rgb[1], (byte)rgb[2]);
                }
                catch (Exception ignored) {
                    while (this.colorCache.containsValue(this.colorIndex)) {
                        this.colorIndex = (short)(this.colorIndex + 1);
                    }
                    try {
                        if (this.colorIndex < 64) {
                            palette.setColorAtIndex(this.colorIndex, (byte)rgb[0], (byte)rgb[1], (byte)rgb[2]);
                            hssfColor = palette.getColor(this.colorIndex);
                        }
                    }
                    catch (Exception exception) {
                    }
                    finally {
                        this.colorIndex = (short)(this.colorIndex + 1);
                    }
                }
            }
            if (hssfColor != null) {
                this.colorCache.put(targetColor, hssfColor.getIndex());
                return hssfColor.getIndex();
            }
        }
        int[] targetHsl = this.rgbToHsl(rgb[0], rgb[1], rgb[2]);
        Map excelColors = HSSFColor.getIndexHash();
        float smallestDelta = 960.0f;
        short closestColor = 64;
        for (Map.Entry e : excelColors.entrySet()) {
            float lumDelta;
            float satDelta;
            Integer excelColorIndex = (Integer)e.getKey();
            HSSFColor excelColor = (HSSFColor)e.getValue();
            short[] triplet = excelColor.getTriplet();
            int[] hsl = this.rgbToHsl(triplet[0], triplet[1], triplet[2]);
            float hueDelta = Math.abs(targetHsl[0] - hsl[0]);
            if (!(hueDelta + (satDelta = (float)Math.abs(targetHsl[1] - hsl[1])) + (lumDelta = (float)Math.abs(targetHsl[2] - hsl[2])) < smallestDelta)) continue;
            smallestDelta = hueDelta + satDelta + lumDelta;
            closestColor = (short)excelColorIndex.intValue();
        }
        this.colorCache.put(targetColor, new Short(closestColor));
        return closestColor;
    }

    private int[] rgbToHsl(int r, int g, int b) {
        double wr = (double)r / 255.0;
        double wg = (double)g / 255.0;
        double wb = (double)b / 255.0;
        double min2 = Math.min(Math.min(wr, wg), wb);
        double max2 = Math.max(Math.max(wr, wg), wb);
        double delta = max2 - min2;
        double h = 0.0;
        double s = 0.0;
        double l = 0.0;
        l = (max2 + min2) / 2.0;
        if (max2 == min2) {
            s = 0.0;
            h = 0.0;
        } else {
            s = l < 0.5 ? (max2 - min2) / (max2 + min2) : (max2 - min2) / (2.0 - max2 - min2);
            h = wr == max2 ? (wg - wb) / delta : (wg == max2 ? 2.0 + (wb - wr) / delta : 4.0 + (wr - wg) / delta);
        }
        h = Math.floor(h * 40.0 + 0.5);
        if (h < 0.0) {
            h += 240.0;
        }
        s = Math.floor(s * 40.0 + 0.5);
        l = Math.floor(l * 40.0 + 0.5);
        int[] rtnVal = new int[]{(int)h, (int)s, (int)l};
        return rtnVal;
    }

    private CellStyle getCellStyle(Map cellStyleElements, boolean justApplyFormat, String dsfFormat, Object valueToFormat, int index) {
        return this.getCellStyle(cellStyleElements, justApplyFormat, dsfFormat, valueToFormat, index, false);
    }

    private CellStyle getCellStyle(Map cellStyleElements, boolean justApplyFormat, String dsfFormat, Object valueToFormat, int index, boolean exportRawNumbers) {
        Font font = null;
        DataFormat xlFormat = null;
        CellStyle style = null;
        String color = null;
        String backgroundColor = null;
        String format = null;
        HorizontalAlignment alignment = this.getHorizontalAlignment(index, false);
        if (cellStyleElements != null) {
            color = (String)cellStyleElements.get("color");
            backgroundColor = (String)cellStyleElements.get("backgroundColor");
            if (!exportRawNumbers && (format = (String)cellStyleElements.get("format")) == null) {
                format = (String)cellStyleElements.get("dateFormatter");
            }
        }
        if (format == null) {
            format = dsfFormat;
        }
        boolean formatAsString = this.datesAsString && valueToFormat instanceof Date || this.numbersAsString && valueToFormat instanceof Number;
        String combo = "color:" + color + ",bg:" + backgroundColor + ",format:" + format + ",align:" + alignment + ",coerce:" + formatAsString;
        if (this.styleCache.get(combo) != null) {
            style = (CellStyle)this.styleCache.get(combo);
        } else {
            font = this.getFont(cellStyleElements);
            if (formatAsString) {
                if (alignment == null) {
                    alignment = HorizontalAlignment.RIGHT;
                }
            } else if (format != null || justApplyFormat) {
                if (this.formatCache.get(format) != null) {
                    xlFormat = (DataFormat)this.formatCache.get(format);
                } else {
                    xlFormat = this.workbook.createDataFormat();
                    this.formatCache.put(format, xlFormat);
                }
            }
            style = this.workbook.createCellStyle();
            if (backgroundColor != null) {
                this.setBackgroundColor(style, backgroundColor);
            }
            if (font != null) {
                style.setFont(font);
            }
            if (xlFormat != null) {
                String converted = this.excelFormatFromSmartClientDateFormatter(format);
                if (converted == null) {
                    converted = valueToFormat instanceof Number ? this.excelFormatFromSmartClientNumberFormat(format) : this.excelFormatFromSmartClientDateFormat(format);
                }
                short dataFormat = xlFormat.getFormat(converted);
                style.setDataFormat(dataFormat);
            }
            if (alignment != null) {
                style.setAlignment(alignment);
            }
            style.setWrapText(true);
            this.styleCache.put(combo, style);
        }
        return style;
    }

    private HorizontalAlignment getHorizontalAlignment(int index, boolean headerAlignment) {
        String alignment = null;
        List alignments = (List)this.export.settings.get("exportAlignments");
        if (alignments != null && (alignments = (List)alignments.get(index)) != null) {
            alignment = (String)alignments.get(headerAlignment ? 0 : 1);
        }
        if ("left".equals(alignment)) {
            return HorizontalAlignment.LEFT;
        }
        if ("right".equals(alignment)) {
            return HorizontalAlignment.RIGHT;
        }
        if ("center".equals(alignment)) {
            return HorizontalAlignment.CENTER;
        }
        return null;
    }

    private Font cloneFont(Workbook workbook, Font font) {
        if (font == null) {
            return null;
        }
        Font clone = workbook.createFont();
        clone.setColor(font.getColor());
        clone.setItalic(font.getItalic());
        clone.setFontName(font.getFontName());
        clone.setBold(font.getBold());
        clone.setFontHeightInPoints(font.getFontHeightInPoints());
        return clone;
    }

    private Font getFont(Map cellStyleElements) {
        Font font = null;
        if (cellStyleElements != null) {
            String color = (String)cellStyleElements.get("color");
            String fontFamily = (String)cellStyleElements.get("fontFamily");
            String fontWeight = (String)cellStyleElements.get("fontWeight");
            String fontSize = (String)cellStyleElements.get("fontSize");
            String fontStyle = (String)cellStyleElements.get("fontStyle");
            if (color != null || fontFamily != null || fontWeight != null || fontSize != null || fontStyle != null) {
                String key = color + fontFamily + fontWeight + fontSize + fontStyle;
                if (this.fontCache.get(key) != null) {
                    font = (Font)this.fontCache.get(key);
                } else {
                    font = this.workbook.createFont();
                    if (color != null) {
                        font.setColor(this.getColor(color));
                    }
                    if (fontFamily != null) {
                        font.setFontName(this.mapFontFamily(fontFamily));
                    }
                    if (fontWeight != null) {
                        font.setBold(this.mapFontWeight(fontWeight));
                    }
                    if (fontSize != null) {
                        font.setFontHeightInPoints(this.mapFontSize(fontSize));
                    }
                    if (fontStyle != null) {
                        font.setItalic(this.isFontItalic(fontStyle));
                    }
                    this.fontCache.put(key, font);
                }
            }
        }
        return font;
    }

    protected String mapFontFamily(String cssFontName) {
        return cssFontName;
    }

    protected boolean mapFontWeight(String fontWeight) {
        return "bold".equals(fontWeight) || "bolder".equals(fontWeight) || "500".compareTo(fontWeight) <= 0 && "900".compareTo(fontWeight) >= 0;
    }

    protected short mapFontSize(String fontSize) {
        return Short.parseShort(fontSize);
    }

    protected boolean isFontItalic(String fontStyle) {
        return "italic".equals(fontStyle) || "oblique".equals(fontStyle);
    }

    private String excelFormatFromSmartClientDateFormatter(String scFormatter) {
        String excelFormat = null;
        if ("toUSShortDate".equals(scFormatter)) {
            excelFormat = "MM/DD/YYYY";
        } else if ("toUSShortDateTime".equals(scFormatter) || "toUSShortDatetime".equals(scFormatter)) {
            excelFormat = "MM/DD/YYYY HH:MM";
        } else if ("toEuropeanShortDate".equals(scFormatter)) {
            excelFormat = "DD/MM/YYYY";
        } else if ("toEuropeanShortDateTime".equals(scFormatter) || "toEuropeanShortDatetime".equals(scFormatter)) {
            excelFormat = "DD/MM/YYYY HH:MM";
        } else if ("toJapanShortDate".equals(scFormatter)) {
            excelFormat = "YYYY/MM/DD";
        } else if ("toJapanShortDateTime".equals(scFormatter) || "toJapanShortDatetime".equals(scFormatter)) {
            excelFormat = "YYYY/MM/DD HH:MM";
        } else if ("toSerializeableDate".equals(scFormatter)) {
            excelFormat = "YYYY-MM-DD HH:MM:SS";
        } else if ("toDateStamp".equals(scFormatter)) {
            excelFormat = "YYYYMMDDTHHMMSS";
        } else if ("toString".equals(scFormatter)) {
            excelFormat = "DDD MMM DD YYYY HH:MM:SS";
        }
        return excelFormat;
    }

    private String excelFormatFromSmartClientDateFormat(String scFormat) {
        if (scFormat == null) {
            return this.excelFormatFromSmartClientDateFormatter("toString");
        }
        String excelFormat = scFormat;
        if (this.regex.matcher(excelFormat).find() || excelFormat.indexOf(8240) != -1) {
            log.warn("Date format \"" + scFormat + "\" contains formatting elements that are not supported by Excel.  See the client-side documentation for the \"exportFormat\" DataSource property");
        }
        excelFormat = excelFormat.replaceAll("a", "AM/PM");
        excelFormat = excelFormat.replaceAll("EEEE", "dddd");
        excelFormat = excelFormat.replaceAll("EE?E?", "ddd");
        return excelFormat;
    }

    private String excelFormatFromSmartClientNumberFormat(String scFormat) {
        if (scFormat == null) {
            return DEFAULT_EXCEL_FORMAT;
        }
        String excelFormat = scFormat;
        if (excelFormat.indexOf(8240) != -1) {
            log.warn("Number format \"" + scFormat + "\" contains formatting elements that are not supported by Excel.  See the client-side documentation for the \"exportFormat\" DataSource property");
            excelFormat = excelFormat.replace('\u2030', ' ');
        }
        excelFormat = excelFormat.replace("\u00a4", this.export.currencySymbol);
        excelFormat = excelFormat.replaceAll("[^#0\\.%,;\\$\\+\\(:\\^'{<=\\-\\)!&~}> ]+", "\"$0\"");
        excelFormat = excelFormat.replaceAll("(?<!')'(?!')", "\"");
        excelFormat = excelFormat.replace("''", "'");
        excelFormat = excelFormat.replaceAll("^,|(?<![\".#0]),", "#$0");
        return excelFormat;
    }

    private RichTextString buildRichTextString(List styles, String stringValue) throws Exception {
        RichTextString styledString = this.workbook.getCreationHelper().createRichTextString(stringValue);
        String firstValue = (String)((Map)styles.get(0)).get("value");
        int offset = firstValue.length();
        for (int i = 1; i < styles.size(); ++i) {
            Map style = (Map)styles.get(i);
            String styledValue = (String)style.get("value");
            Font font = this.getFont(style = (Map)style.get("style"));
            if (font != null) {
                styledString.applyFont(offset, offset + styledValue.length(), font);
            }
            offset += styledValue.length();
        }
        return styledString;
    }

    private int[] parseColorString(String pColor) {
        String color = pColor;
        if (color == null) {
            return null;
        }
        int[] rgb = new int[3];
        if (colorMap.containsKey(color.toLowerCase())) {
            color = colorMap.get(color.toLowerCase());
        }
        if (color.charAt(0) == '#') {
            if (color.length() == 4) {
                char[] chars = new char[]{'#', color.charAt(1), color.charAt(1), color.charAt(2), color.charAt(2), color.charAt(3), color.charAt(3)};
                color = new String(chars);
            }
            if (color.length() != 7) {
                log.warn("Unable to parse color " + pColor);
                return null;
            }
            try {
                rgb[0] = Integer.parseInt(color.substring(1, 3), 16);
                rgb[1] = Integer.parseInt(color.substring(3, 5), 16);
                rgb[2] = Integer.parseInt(color.substring(5), 16);
                return rgb;
            }
            catch (NumberFormatException nfe) {
                log.warn("Unable to parse color " + pColor);
                return null;
            }
        }
        if (color.startsWith("rgb(")) {
            String[] elements = (color = color.substring(4, color.length() - 1)).split(",");
            if (elements.length != 3) {
                log.warn("Unable to parse color " + pColor);
                return null;
            }
            try {
                if (elements[0].indexOf("%") == -1) {
                    rgb[0] = Integer.parseInt(elements[0]);
                    rgb[1] = Integer.parseInt(elements[1]);
                    rgb[2] = Integer.parseInt(elements[2]);
                } else {
                    elements[0] = elements[0].substring(0, elements[0].length() - 1);
                    elements[1] = elements[1].substring(0, elements[1].length() - 1);
                    elements[2] = elements[2].substring(0, elements[2].length() - 1);
                    rgb[0] = (int)Math.floor((float)Integer.parseInt(elements[0]) * 2.55f);
                    rgb[1] = (int)Math.floor((float)Integer.parseInt(elements[1]) * 2.55f);
                    rgb[2] = (int)Math.floor((float)Integer.parseInt(elements[2]) * 2.55f);
                }
                return rgb;
            }
            catch (NumberFormatException nfe) {
                log.warn("Unable to parse color " + pColor);
                return null;
            }
        }
        log.warn("Unable to parse color " + pColor);
        return null;
    }

    static {
        Float f = Config.getGlobal().getFloat("export.headerHeights.scale");
        PIXELS_TO_TWIPS_MULTIPLIER = f != null ? (float)((short)(15.0f * f.floatValue())) : 15.0f;
        colorMap = new HashMap<String, String>(){
            {
                this.put("aliceblue", "#f0f8ff");
                this.put("antiquewhite", "#faebd7");
                this.put("aqua", "#00ffff");
                this.put("aquamarine", "#7fffd4");
                this.put("azure", "#f0ffff");
                this.put("beige", "#f5f5dc");
                this.put("bisque", "#ffe4c4");
                this.put("black", "#000000");
                this.put("blanchedalmond", "#ffebcd");
                this.put("blue", "#0000ff");
                this.put("blueviolet", "#8a2be2");
                this.put("brown", "#a52a2a");
                this.put("burlywood", "#deb887");
                this.put("cadetblue", "#5f9ea0");
                this.put("chartreuse", "#7fff00");
                this.put("chocolate", "#d2691e");
                this.put("coral", "#ff7f50");
                this.put("cornflowerblue", "#6495ed");
                this.put("cornsilk", "#fff8dc");
                this.put("crimson", "#dc143c");
                this.put("cyan", "#00ffff");
                this.put("darkblue", "#00008b");
                this.put("darkcyan", "#008b8b");
                this.put("darkgoldenrod", "#b8860b");
                this.put("darkgray", "#a9a9a9");
                this.put("darkgreen", "#006400");
                this.put("darkkhaki", "#bdb76b");
                this.put("darkmagenta", "#8b008b");
                this.put("darkolivegreen", "#556b2f");
                this.put("darkorange", "#ff8c00");
                this.put("darkorchid", "#9932cc");
                this.put("darkred", "#8b0000");
                this.put("darksalmon", "#e9967a");
                this.put("darkseagreen", "#8fbc8f");
                this.put("darkslateblue", "#483d8b");
                this.put("darkslategray", "#2f4f4f");
                this.put("darkturquoise", "#00ced1");
                this.put("darkviolet", "#9400d3");
                this.put("deeppink", "#ff1493");
                this.put("deepskyblue", "#00bfff");
                this.put("dimgray", "#696969");
                this.put("dodgerblue", "#1e90ff");
                this.put("firebrick", "#b22222");
                this.put("floralwhite", "#fffaf0");
                this.put("forestgreen", "#228b22");
                this.put("fuchsia", "#ff00ff");
                this.put("gainsboro", "#dcdcdc");
                this.put("ghostwhite", "#f8f8ff");
                this.put("gold", "#ffd700");
                this.put("goldenrod", "#daa520");
                this.put("gray", "#808080");
                this.put("green", "#008000");
                this.put("greenyellow", "#adff2f");
                this.put("honeydew", "#f0fff0");
                this.put("hotpink", "#ff69b4");
                this.put("indianred ", "#cd5c5c");
                this.put("indigo ", "#4b0082");
                this.put("ivory", "#fffff0");
                this.put("khaki", "#f0e68c");
                this.put("lavender", "#e6e6fa");
                this.put("lavenderblush", "#fff0f5");
                this.put("lawngreen", "#7cfc00");
                this.put("lemonchiffon", "#fffacd");
                this.put("lightblue", "#add8e6");
                this.put("lightcoral", "#f08080");
                this.put("lightcyan", "#e0ffff");
                this.put("lightgoldenrodyellow", "#fafad2");
                this.put("lightgrey", "#d3d3d3");
                this.put("lightgreen", "#90ee90");
                this.put("lightpink", "#ffb6c1");
                this.put("lightsalmon", "#ffa07a");
                this.put("lightseagreen", "#20b2aa");
                this.put("lightskyblue", "#87cefa");
                this.put("lightslategray", "#778899");
                this.put("lightsteelblue", "#b0c4de");
                this.put("lightyellow", "#ffffe0");
                this.put("lime", "#00ff00");
                this.put("limegreen", "#32cd32");
                this.put("linen", "#faf0e6");
                this.put("magenta", "#ff00ff");
                this.put("maroon", "#800000");
                this.put("mediumaquamarine", "#66cdaa");
                this.put("mediumblue", "#0000cd");
                this.put("mediumorchid", "#ba55d3");
                this.put("mediumpurple", "#9370d8");
                this.put("mediumseagreen", "#3cb371");
                this.put("mediumslateblue", "#7b68ee");
                this.put("mediumspringgreen", "#00fa9a");
                this.put("mediumturquoise", "#48d1cc");
                this.put("mediumvioletred", "#c71585");
                this.put("midnightblue", "#191970");
                this.put("mintcream", "#f5fffa");
                this.put("mistyrose", "#ffe4e1");
                this.put("moccasin", "#ffe4b5");
                this.put("navajowhite", "#ffdead");
                this.put("navy", "#000080");
                this.put("oldlace", "#fdf5e6");
                this.put("olive", "#808000");
                this.put("olivedrab", "#6b8e23");
                this.put("orange", "#ffa500");
                this.put("orangered", "#ff4500");
                this.put("orchid", "#da70d6");
                this.put("palegoldenrod", "#eee8aa");
                this.put("palegreen", "#98fb98");
                this.put("paleturquoise", "#afeeee");
                this.put("palevioletred", "#d87093");
                this.put("papayawhip", "#ffefd5");
                this.put("peachpuff", "#ffdab9");
                this.put("peru", "#cd853f");
                this.put("pink", "#ffc0cb");
                this.put("plum", "#dda0dd");
                this.put("powderblue", "#b0e0e6");
                this.put("purple", "#800080");
                this.put("red", "#ff0000");
                this.put("rosybrown", "#bc8f8f");
                this.put("royalblue", "#4169e1");
                this.put("saddlebrown", "#8b4513");
                this.put("salmon", "#fa8072");
                this.put("sandybrown", "#f4a460");
                this.put("seagreen", "#2e8b57");
                this.put("seashell", "#fff5ee");
                this.put("sienna", "#a0522d");
                this.put("silver", "#c0c0c0");
                this.put("skyblue", "#87ceeb");
                this.put("slateblue", "#6a5acd");
                this.put("slategray", "#708090");
                this.put("snow", "#fffafa");
                this.put("springgreen", "#00ff7f");
                this.put("steelblue", "#4682b4");
                this.put("tan", "#d2b48c");
                this.put("teal", "#008080");
                this.put("thistle", "#d8bfd8");
                this.put("tomato", "#ff6347");
                this.put("turquoise", "#40e0d0");
                this.put("violet", "#ee82ee");
                this.put("wheat", "#f5deb3");
                this.put("white", "#ffffff");
                this.put("whitesmoke", "#f5f5f5");
                this.put("yellow", "#ffff00");
                this.put("yellowgreen", "#9acd32");
            }
        };
    }

    private class HeaderSpan {
        public int row;
        public int endRow = -1;
        public int startCol;
        public int endCol;
        public String title;
        public short height;

        private HeaderSpan() {
        }

        public String toString() {
            return "HeaderSpan [row=" + this.row + ", endRow=" + this.endRow + ", startCol=" + this.startCol + ", endCol=" + this.endCol + ", title=" + this.title + ", height=" + this.height + "]";
        }
    }

    private class HeaderColors {
        public String rowFacetColor;
        public String columnFacetColor;

        public HeaderColors(Map settings, String property) {
            Object colors = settings.get("exportHeader" + property);
            if (colors instanceof List && ((List)colors).size() >= 2) {
                this.rowFacetColor = (String)((List)colors).get(0);
                this.columnFacetColor = (String)((List)colors).get(1);
            } else if (colors instanceof String) {
                this.rowFacetColor = this.columnFacetColor = (String)colors;
            }
        }

        public boolean different() {
            if (this.rowFacetColor == null) {
                return this.columnFacetColor != null;
            }
            return !this.rowFacetColor.equals(this.columnFacetColor);
        }
    }

    private class HeaderStyle {
        private CellStyle headerStyle;
        private CellStyle headerLeftStyle;
        private CellStyle headerRightStyle;
        private CellStyle headerCenterStyle;
        private CellStyle headerSpanStyle;

        public HeaderStyle(String bgColor, String textColor) {
            this.headerStyle = this.createHeaderStyle(bgColor, textColor, HorizontalAlignment.GENERAL);
            this.headerLeftStyle = this.createHeaderStyle(bgColor, textColor, HorizontalAlignment.LEFT);
            this.headerRightStyle = this.createHeaderStyle(bgColor, textColor, HorizontalAlignment.RIGHT);
            this.headerCenterStyle = this.createHeaderStyle(bgColor, textColor, HorizontalAlignment.CENTER);
            this.headerSpanStyle = this.createHeaderStyle(bgColor, textColor, HorizontalAlignment.CENTER);
        }

        public CellStyle getStyle(boolean noSpanning, HorizontalAlignment alignment) {
            if (noSpanning) {
                if (alignment == null) {
                    return this.headerStyle;
                }
                switch (alignment) {
                    case LEFT: {
                        return this.headerLeftStyle;
                    }
                    case RIGHT: {
                        return this.headerRightStyle;
                    }
                    case CENTER: {
                        return this.headerCenterStyle;
                    }
                }
                return this.headerStyle;
            }
            return this.headerSpanStyle;
        }

        private CellStyle createHeaderStyle(String bgColor, String textColor, HorizontalAlignment alignment) {
            CellStyle baseHeaderStyle = ExcelDataExport.this.workbook.createCellStyle();
            if (bgColor != null) {
                ExcelDataExport.this.setBackgroundColor(baseHeaderStyle, bgColor);
            }
            if (textColor != null) {
                Font defaultFont = ExcelDataExport.this.workbook.getFontAt(baseHeaderStyle.getFontIndex());
                Font headerFont = ExcelDataExport.this.cloneFont(ExcelDataExport.this.workbook, defaultFont);
                headerFont.setColor(ExcelDataExport.this.getColor(textColor));
                baseHeaderStyle.setFont(headerFont);
            }
            if (alignment != HorizontalAlignment.GENERAL) {
                baseHeaderStyle.setAlignment(alignment);
            }
            baseHeaderStyle.setVerticalAlignment(VerticalAlignment.CENTER);
            if (ExcelDataExport.this.wrapHeaders) {
                baseHeaderStyle.setWrapText(true);
            }
            return baseHeaderStyle;
        }
    }

    private class BackgroundColors {
        private Map<String, String> defaultForNumberedRows;
        private Map<String, String> defaultForNumberedColumns;
        private String defaultForOddRow;
        private String defaultForAnyRow;

        private BackgroundColors(Map settings) {
            this.defaultForAnyRow = (String)settings.get("exportDefaultBGColor");
            this.defaultForOddRow = (String)settings.get("exportAlternateRowBGColor");
            this.defaultForNumberedRows = (Map)settings.get("exportRowBGColors");
            this.defaultForNumberedColumns = (Map)settings.get("exportColumnBGColors");
        }

        private String getColorForCell(int row, int col) {
            if (this.defaultForNumberedRows != null && this.defaultForNumberedRows.get(String.valueOf(row)) != null) {
                return this.defaultForNumberedRows.get(String.valueOf(row));
            }
            if (this.defaultForNumberedColumns != null && this.defaultForNumberedColumns.get(String.valueOf(col)) != null) {
                return this.defaultForNumberedColumns.get(String.valueOf(col));
            }
            if (col < ExcelDataExport.this.numberOfRowHeaderCells) {
                return null;
            }
            if (this.defaultForOddRow != null && row % 2 != 0) {
                return this.defaultForOddRow;
            }
            return this.defaultForAnyRow;
        }
    }
}

