/*
 * Decompiled with CFR 0.152.
 */
package org.htmlparser.parserapplications.filterbuilder.wrappers;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Iterator;
import java.util.Set;
import javax.swing.JComboBox;
import org.htmlparser.Node;
import org.htmlparser.NodeFactory;
import org.htmlparser.NodeFilter;
import org.htmlparser.Parser;
import org.htmlparser.PrototypicalNodeFactory;
import org.htmlparser.Tag;
import org.htmlparser.filters.NodeClassFilter;
import org.htmlparser.parserapplications.filterbuilder.Filter;

public class NodeClassFilterWrapper
extends Filter
implements ActionListener {
    protected NodeClassFilter mFilter = new NodeClassFilter();
    protected JComboBox mClass = new JComboBox();

    public NodeClassFilterWrapper() {
        this.mClass.addItem("");
        this.add(this.mClass);
        this.mClass.addActionListener(this);
    }

    public String getDescription() {
        return "Nodes of class";
    }

    public String getIconSpec() {
        return "images/NodeClassFilter.gif";
    }

    public NodeFilter getNodeFilter() {
        NodeClassFilter ret = new NodeClassFilter();
        ret.setMatchClass(this.mFilter.getMatchClass());
        return ret;
    }

    public void setNodeFilter(NodeFilter filter, Parser context) {
        this.mFilter = (NodeClassFilter)filter;
        NodeFactory factory = context.getNodeFactory();
        if (factory instanceof PrototypicalNodeFactory) {
            PrototypicalNodeFactory proto = (PrototypicalNodeFactory)factory;
            Set names = proto.getTagNames();
            Iterator iterator = names.iterator();
            while (iterator.hasNext()) {
                String name = (String)iterator.next();
                Tag tag = proto.get(name);
                this.mClass.addItem(tag.getClass().getName());
            }
        }
        this.mClass.setSelectedItem(this.mFilter.getMatchClass().getName());
    }

    public NodeFilter[] getSubNodeFilters() {
        return new NodeFilter[0];
    }

    public void setSubNodeFilters(NodeFilter[] filters) {
    }

    public String toJavaCode(StringBuffer out, int[] context) {
        int n = context[1];
        context[1] = n + 1;
        String ret = "filter" + n;
        NodeClassFilterWrapper.spaces(out, context[0]);
        out.append("NodeClassFilter ");
        out.append(ret);
        out.append(" = new NodeClassFilter ();");
        NodeClassFilterWrapper.newline(out);
        NodeClassFilterWrapper.spaces(out, context[0]);
        out.append("try { ");
        out.append(ret);
        out.append(".setMatchClass (Class.forName (\"");
        out.append(this.mFilter.getMatchClass().getName());
        out.append("\")); } catch (ClassNotFoundException cnfe) { cnfe.printStackTrace (); }");
        NodeClassFilterWrapper.newline(out);
        return ret;
    }

    public boolean accept(Node node) {
        return this.mFilter.accept(node);
    }

    public void actionPerformed(ActionEvent event) {
        Object source = event.getSource();
        if (source == this.mClass) {
            try {
                this.mFilter.setMatchClass(Class.forName((String)this.mClass.getSelectedItem()));
            }
            catch (ClassNotFoundException cnfe) {
                cnfe.printStackTrace();
            }
        }
    }
}

