/*
 * Decompiled with CFR 0.152.
 */
package com.isomorphic.log;

import com.isomorphic.log.Logger;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections4.queue.CircularFifoQueue;
import org.apache.logging.log4j.core.Filter;
import org.apache.logging.log4j.core.Layout;
import org.apache.logging.log4j.core.LogEvent;
import org.apache.logging.log4j.core.appender.AbstractAppender;
import org.apache.logging.log4j.core.config.plugins.Plugin;
import org.apache.logging.log4j.core.config.plugins.PluginAttribute;
import org.apache.logging.log4j.core.config.plugins.PluginElement;
import org.apache.logging.log4j.core.config.plugins.PluginFactory;
import org.apache.logging.log4j.core.layout.PatternLayout;

@Plugin(name="RevolvingMemoryAppender", category="Core", elementType="appender", printObject=true)
public final class RevolvingMemoryAppenderImpl
extends AbstractAppender {
    protected int maxEntries = 50;
    protected static Map<String, Collection> logs = new LinkedHashMap<String, Collection>();
    boolean reentrant = false;

    @PluginFactory
    public static RevolvingMemoryAppenderImpl createAppender(@PluginAttribute(value="name") String name, @PluginAttribute(value="ignoreExceptions") boolean ignoreExceptions, @PluginAttribute(value="maxEntries", defaultInt=50) int maxEntries, @PluginElement(value="Layout") Layout layout, @PluginElement(value="Filters") Filter filter) {
        if (name == null) {
            System.out.println("No name provided for Log4j2 appender: RevolvingMemoryAppender");
            return null;
        }
        if (layout == null) {
            layout = PatternLayout.createDefaultLayout();
        }
        return new RevolvingMemoryAppenderImpl(name, ignoreExceptions, maxEntries, (Layout<? extends Serializable>)layout, filter);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private RevolvingMemoryAppenderImpl(String name, boolean ignoreExceptions, int maxEntries, Layout<? extends Serializable> layout, Filter filter) {
        super(name, filter, layout, ignoreExceptions, null);
        this.maxEntries = maxEntries;
        Map<String, Collection> map = logs;
        synchronized (map) {
            ArrayList log = RevolvingMemoryAppenderImpl.getLogEntries(name);
            if (log == null) {
                log = maxEntries == -1 ? new ArrayList() : new CircularFifoQueue(maxEntries);
                logs.put(name, log);
            }
        }
    }

    public int getMaxEntires() {
        return this.maxEntries;
    }

    public static List<String> getLogNames() {
        return new ArrayList<String>(logs.keySet());
    }

    public static Collection getLogEntries(String name) {
        return logs.get(name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void clearLogEntries(String name) {
        Map<String, Collection> map = logs;
        synchronized (map) {
            Collection log = RevolvingMemoryAppenderImpl.getLogEntries(name);
            if (log != null) {
                log.clear();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void append(LogEvent event) {
        if (this.reentrant) {
            return;
        }
        if (Logger.threadIgnored() || Logger.threadDisabled()) {
            return;
        }
        this.reentrant = true;
        try {
            Collection logEntries = RevolvingMemoryAppenderImpl.getLogEntries(this.getName());
            String formattedMessage = this.getLayout().toSerializable(event).toString();
            HashMap<String, Object> logEntry = new HashMap<String, Object>();
            logEntry.put("loggerName", this.getName());
            logEntry.put("timeStamp", new Date(event.getTimeMillis()));
            logEntry.put("logMessage", formattedMessage);
            logEntry.put("threadName", event.getThreadName());
            logEntry.put("level", event.getLevel().intLevel());
            logEntries.add(logEntry);
        }
        finally {
            this.reentrant = false;
        }
    }
}

