/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.thirdparty.streamhtmlparser.impl;

import com.google.gwt.thirdparty.guava.common.collect.Maps;
import com.google.gwt.thirdparty.streamhtmlparser.ExternalState;
import com.google.gwt.thirdparty.streamhtmlparser.JavascriptParser;
import com.google.gwt.thirdparty.streamhtmlparser.impl.GenericParser;
import com.google.gwt.thirdparty.streamhtmlparser.impl.InternalState;
import com.google.gwt.thirdparty.streamhtmlparser.impl.ParserStateTable;
import com.google.gwt.thirdparty.streamhtmlparser.impl.StateTableTransition;
import com.google.gwt.thirdparty.streamhtmlparser.util.HtmlUtils;
import com.google.gwt.thirdparty.streamhtmlparser.util.JavascriptTokenBuffer;
import java.util.Map;

public class JavascriptParserImpl
extends GenericParser
implements JavascriptParser {
    static final InternalState JS_TEXT = InternalState.getInstanceJavascript("JS_TEXT");
    static final InternalState JS_Q = InternalState.getInstanceJavascript("JS_Q");
    static final InternalState JS_Q_E = InternalState.getInstanceJavascript("JS_Q_E");
    static final InternalState JS_DQ = InternalState.getInstanceJavascript("JS_DQ");
    static final InternalState JS_DQ_E = InternalState.getInstanceJavascript("JS_DQ_E");
    static final InternalState JS_SLASH = InternalState.getInstanceJavascript("JS_SLASH");
    static final InternalState JS_REGEXP_SLASH;
    static final InternalState JS_REGEXP;
    static final InternalState JS_REGEXP_BRK;
    static final InternalState JS_REGEXP_BRK_E;
    static final InternalState JS_REGEXP_E;
    static final InternalState JS_COM_LN;
    static final InternalState JS_COM_ML;
    static final InternalState JS_COM_ML_CLOSE;
    static final InternalState JS_COM_AFTER;
    private static final Map<InternalState, ExternalState> STATE_MAPPING;
    private static final ParserStateTable STATE_TABLE;
    private final JavascriptTokenBuffer ccBuffer;

    public JavascriptParserImpl() {
        super(STATE_TABLE, STATE_MAPPING, JS_TEXT);
        this.ccBuffer = new JavascriptTokenBuffer();
    }

    public JavascriptParserImpl(JavascriptParserImpl aJavascriptParserImpl) {
        super(aJavascriptParserImpl);
        this.ccBuffer = new JavascriptTokenBuffer(aJavascriptParserImpl.ccBuffer);
    }

    public void reset() {
        super.reset();
        this.currentState = JS_TEXT;
    }

    protected InternalState handleEnterState(InternalState currentState, InternalState expectedNextState, char input) {
        InternalState nextState = expectedNextState;
        if (currentState == JS_SLASH) {
            nextState = this.enterStateJsSlash(currentState, input);
        } else if (currentState == JS_COM_AFTER) {
            this.enterStateJsCommentAfter();
        }
        return nextState;
    }

    protected InternalState handleExitState(InternalState currentState, InternalState expectedNextState, char input) {
        return expectedNextState;
    }

    protected InternalState handleInState(InternalState currentState, char input) {
        if (currentState == JS_TEXT) {
            this.inStateJsText(input);
        }
        return currentState;
    }

    private InternalState enterStateJsSlash(InternalState state, char input) {
        InternalState nextState = state;
        int position = -1;
        if (HtmlUtils.isJavascriptWhitespace(this.ccBuffer.getChar(position))) {
            --position;
        }
        switch (this.ccBuffer.getChar(position)) {
            case '+': {
                if (this.ccBuffer.getChar(position - 1) == '+') break;
                nextState = JS_REGEXP_SLASH;
                break;
            }
            case '-': {
                if (this.ccBuffer.getChar(position - 1) == '-') break;
                nextState = JS_REGEXP_SLASH;
                break;
            }
            case '\u0000': 
            case '!': 
            case '%': 
            case '&': 
            case '(': 
            case '*': 
            case ',': 
            case '/': 
            case ':': 
            case ';': 
            case '<': 
            case '=': 
            case '>': 
            case '?': 
            case '[': 
            case '^': 
            case '{': 
            case '|': 
            case '}': 
            case '~': {
                nextState = JS_REGEXP_SLASH;
                break;
            }
            default: {
                String lastIdentifier = this.ccBuffer.getLastIdentifier();
                if (lastIdentifier == null || !HtmlUtils.isJavascriptRegexpPrefix(lastIdentifier)) break;
                nextState = JS_REGEXP_SLASH;
            }
        }
        this.ccBuffer.appendChar(input);
        return nextState;
    }

    private void enterStateJsCommentAfter() {
        if (HtmlUtils.isJavascriptWhitespace(this.ccBuffer.getChar(-2))) {
            this.ccBuffer.popChar();
        } else {
            this.ccBuffer.setChar(-1, ' ');
        }
    }

    private void inStateJsText(char input) {
        this.ccBuffer.appendChar(input);
    }

    private static void registerMapping(InternalState internalState, ExternalState externalState) {
        STATE_MAPPING.put(internalState, externalState);
    }

    private static void initializeStateMapping() {
        JavascriptParserImpl.registerMapping(InternalState.INTERNAL_ERROR_STATE, JavascriptParser.STATE_ERROR);
        JavascriptParserImpl.registerMapping(JS_TEXT, JavascriptParser.STATE_TEXT);
        JavascriptParserImpl.registerMapping(JS_Q, JavascriptParser.STATE_Q);
        JavascriptParserImpl.registerMapping(JS_Q_E, JavascriptParser.STATE_Q);
        JavascriptParserImpl.registerMapping(JS_DQ, JavascriptParser.STATE_DQ);
        JavascriptParserImpl.registerMapping(JS_DQ_E, JavascriptParser.STATE_DQ);
        JavascriptParserImpl.registerMapping(JS_SLASH, JavascriptParser.STATE_TEXT);
        JavascriptParserImpl.registerMapping(JS_REGEXP_SLASH, JavascriptParser.STATE_TEXT);
        JavascriptParserImpl.registerMapping(JS_REGEXP, JavascriptParser.STATE_REGEXP);
        JavascriptParserImpl.registerMapping(JS_REGEXP_BRK, JavascriptParser.STATE_REGEXP);
        JavascriptParserImpl.registerMapping(JS_REGEXP_BRK_E, JavascriptParser.STATE_REGEXP);
        JavascriptParserImpl.registerMapping(JS_REGEXP_E, JavascriptParser.STATE_REGEXP);
        JavascriptParserImpl.registerMapping(JS_COM_LN, JavascriptParser.STATE_COMMENT);
        JavascriptParserImpl.registerMapping(JS_COM_ML, JavascriptParser.STATE_COMMENT);
        JavascriptParserImpl.registerMapping(JS_COM_ML_CLOSE, JavascriptParser.STATE_COMMENT);
        JavascriptParserImpl.registerMapping(JS_COM_AFTER, JavascriptParser.STATE_TEXT);
    }

    private static void registerTransition(String expression, InternalState source, InternalState to) {
        StateTableTransition stt = new StateTableTransition(expression, source, to);
        STATE_TABLE.setExpression(stt.getExpression(), stt.getFrom(), stt.getTo());
    }

    private static void initializeParserStateTable() {
        JavascriptParserImpl.registerTransition("[:default:]", JS_COM_AFTER, JS_TEXT);
        JavascriptParserImpl.registerTransition("/", JS_COM_AFTER, JS_SLASH);
        JavascriptParserImpl.registerTransition("\"", JS_COM_AFTER, JS_DQ);
        JavascriptParserImpl.registerTransition("'", JS_COM_AFTER, JS_Q);
        JavascriptParserImpl.registerTransition("[:default:]", JS_COM_ML_CLOSE, JS_COM_ML);
        JavascriptParserImpl.registerTransition("/", JS_COM_ML_CLOSE, JS_COM_AFTER);
        JavascriptParserImpl.registerTransition("[:default:]", JS_COM_ML, JS_COM_ML);
        JavascriptParserImpl.registerTransition("*", JS_COM_ML, JS_COM_ML_CLOSE);
        JavascriptParserImpl.registerTransition("[:default:]", JS_COM_LN, JS_COM_LN);
        JavascriptParserImpl.registerTransition("\n", JS_COM_LN, JS_COM_AFTER);
        JavascriptParserImpl.registerTransition("[:default:]", JS_REGEXP_E, JS_REGEXP);
        JavascriptParserImpl.registerTransition("[:default:]", JS_REGEXP_BRK_E, JS_REGEXP_BRK);
        JavascriptParserImpl.registerTransition("[:default:]", JS_REGEXP_BRK, JS_REGEXP_BRK);
        JavascriptParserImpl.registerTransition("]", JS_REGEXP_BRK, JS_REGEXP);
        JavascriptParserImpl.registerTransition("\\", JS_REGEXP_BRK, JS_REGEXP_BRK_E);
        JavascriptParserImpl.registerTransition("[:default:]", JS_REGEXP, JS_REGEXP);
        JavascriptParserImpl.registerTransition("/", JS_REGEXP, JS_TEXT);
        JavascriptParserImpl.registerTransition("[", JS_REGEXP, JS_REGEXP_BRK);
        JavascriptParserImpl.registerTransition("\\", JS_REGEXP, JS_REGEXP_E);
        JavascriptParserImpl.registerTransition("[:default:]", JS_REGEXP_SLASH, JS_REGEXP);
        JavascriptParserImpl.registerTransition("[", JS_REGEXP_SLASH, JS_REGEXP_BRK);
        JavascriptParserImpl.registerTransition("\\", JS_REGEXP_SLASH, JS_REGEXP_E);
        JavascriptParserImpl.registerTransition("*", JS_REGEXP_SLASH, JS_COM_ML);
        JavascriptParserImpl.registerTransition("/", JS_REGEXP_SLASH, JS_COM_LN);
        JavascriptParserImpl.registerTransition("[:default:]", JS_SLASH, JS_TEXT);
        JavascriptParserImpl.registerTransition("*", JS_SLASH, JS_COM_ML);
        JavascriptParserImpl.registerTransition("/", JS_SLASH, JS_COM_LN);
        JavascriptParserImpl.registerTransition("[:default:]", JS_DQ_E, JS_DQ);
        JavascriptParserImpl.registerTransition("[:default:]", JS_DQ, JS_DQ);
        JavascriptParserImpl.registerTransition("\"", JS_DQ, JS_TEXT);
        JavascriptParserImpl.registerTransition("\\", JS_DQ, JS_DQ_E);
        JavascriptParserImpl.registerTransition("[:default:]", JS_Q_E, JS_Q);
        JavascriptParserImpl.registerTransition("[:default:]", JS_Q, JS_Q);
        JavascriptParserImpl.registerTransition("'", JS_Q, JS_TEXT);
        JavascriptParserImpl.registerTransition("\\", JS_Q, JS_Q_E);
        JavascriptParserImpl.registerTransition("[:default:]", JS_TEXT, JS_TEXT);
        JavascriptParserImpl.registerTransition("/", JS_TEXT, JS_SLASH);
        JavascriptParserImpl.registerTransition("\"", JS_TEXT, JS_DQ);
        JavascriptParserImpl.registerTransition("'", JS_TEXT, JS_Q);
    }

    static {
        JS_REGEXP = InternalState.getInstanceJavascript("JS_REGEXP");
        JS_REGEXP_SLASH = InternalState.getInstanceJavascript("JS_REGEXP_SLASH");
        JS_REGEXP_E = InternalState.getInstanceJavascript("JS_REGEXP_E");
        JS_REGEXP_BRK = InternalState.getInstanceJavascript("JS_REGEXP_BRK");
        JS_REGEXP_BRK_E = InternalState.getInstanceJavascript("JS_REGEXP_BRK_E");
        JS_COM_LN = InternalState.getInstanceJavascript("COMMENT_LN");
        JS_COM_ML = InternalState.getInstanceJavascript("COMMENT_ML");
        JS_COM_ML_CLOSE = InternalState.getInstanceJavascript("COMMENT_ML_CLOSE");
        JS_COM_AFTER = InternalState.getInstanceJavascript("COMMENT_AFTER");
        STATE_MAPPING = Maps.newHashMap();
        JavascriptParserImpl.initializeStateMapping();
        STATE_TABLE = new ParserStateTable();
        JavascriptParserImpl.initializeParserStateTable();
    }
}

