
package com.smartgwt.client.docs;

/**
 * <h3>Skin Editor</h3>
 * Isomorphic provides a visual Skin Editor tool which allows for rapid, bulk customization of 
 * skin details like colors, borders and fonts.   <p> With this tool, you can create a new skin
 * based on an existing one and make styling  customizations to it - your changes are saved in an
 * intermediate database so the skin can  be updated over time.  If the skin exists in a local SDK
 * Skin Editor and your project uses  the {@link com.smartgwt.client.docs.IscServer Smart GWT
 * Server}, it can be loaded by pages outside of the  Skin Editor in the same way as any other
 * skin.  The server delivers your saved Skin  Editor customizations from the database as if the
 * skin existed on disk. <p> Once complete, you can choose to leave your skin in the Skin Editor
 * database, if it's local, or export it to a zip file that can be dropped into your project
 * skins/  directory, along with other framework skins.  If you export as a "Base" skin, your 
 * customizations are exported as base config and the skin is  no longer editable in the Skin
 * Editor - if you export as a "User" skin, you can extract the  zip to another environment where
 * it will continue to be editable if that environment has a  local Skin Editor, by selecting it
 * from the "Edit Skin" picker.  This means that the  exported zip must not be extracted into the
 * same environment as the Skin Editor, since  skin-names must be unique.  See below for details
 * on exporting. <p> <h3>Accessing Skin Editor</h3> You can access the Skin Editor in one of two
 * ways: <h4>Online</h4> The Skin Editor is available online as a single-user tool at <a
 * href='https://www.smartclient.com/themes/' target='_blank'>smartclient.com/themes</a>.  This
 * link   runs against the  <a href='https://www.smartclient.com/product/download.jsp'
 * target='_blank'>latest public release</a> and is  available to customers with a  <a
 * href='https://www.smartclient.com/product/' target='_blank'>Pro or better</a> license of that
 * release.  Note that this is a single-user version of Skin Editor and does not support some team
 * features like sharing your design with other users. <p> For Skin Editor team support,
 * registered users can access the tool via  <a href='https://create.reify.com'
 * target='_blank'>Reify</a>, Isomorphic's low-code platform.  The  <a
 * href='https://create.reify.com/themes/' target='_blank'>Skin Editor for Reify</a> allows
 * skin-designs  to be shared among users and changes you make to your skins are reflected right
 * away within <code>Reify</code>.  Note that this version of the tool may be running
 * bleeding-edge code,  more recent then the current public release. <h4>Locally</h4> If you have
 * a <a href='https://www.smartclient.com/product/' target='_blank'>Pro or better</a> license,    
 * inheriting module <code>com.smartgwtee.tools.Tools</code> will make the Skin Editor available
 * in your SmartGWT project.  Only skin resources inherited by your project will be available for
 * editing so you may want to add additional dependencies to your module file.  For example, to
 * make the Obsidian skin available, add: <p> &lt;inherits
 * name="com.smartclient.theme.obsidian.ObsidianResources"/&gt; <p> Always run a GWT compile after
 * any module file change to ensure it's picked up, and then  navigate to
 * <code>{project_name}/tools/skinTools/skinEditor.jsp</code>.  <p> <h3>Creating a new skin</h3>
 * To create a new skin in the Skin Editor, select a Base-skin from the grid and enter a name  for
 * your skin.  The name must be unique across all existing User-skins, including those  in the
 * <code>isc_userSkin</code> dataSource and those on-disk. <p> <h3>The main screen</h3> When
 * you're ready, click the "Create and Edit Skin" button to advance to the main editor  screen,
 * which consists of two main panels.   <ul> <li> On the left, a set of {@link
 * com.smartgwt.client.widgets.tab.TabSet tabs},  each housing trees with cascades of skin
 * settings such as colors, borders and padding.  Above  these is a {@link
 * com.smartgwt.client.widgets.form.fields.ColorItem} labelled "Highlight Color", which is the
 * main color from  which most of the colored parts of the skin inherit - for example, background
 * colors in  {@link com.smartgwt.client.widgets.grid.ListGrid} headers and rollovers, backgrounds
 * and shadows of buttons of various  types, and various cases where text is highlighted, such as
 * values with  {@link com.smartgwt.client.widgets.form.fields.FormItem#getShowPending unsaved
 * changes}.  Above this ColorItem are several functional  buttons: "Delete", which permanently
 * removes a skin; "Export", which allows the skin to be  exported to a zip file for distribution;
 * and "Save", which saves your changes to database or  file-system where you skin exists and
 * recompiles the underlying stylesheet to include your  changes. <li> On the right, a "Preview"
 * area showing some  sample components.  Above this area is a toolbar offering a selector to
 * change between  which types of components to show in the Preview, a selector for modifying the
 * "Density"  (size/spacing) of the skin, and a button for switching all components in the Preview
 * into a "Disabled" state, in order to understand those styles. </ul>  <h3>Editing a skin</h3> To
 * make modifications to your skin, change values in the trees on the left to see your  changes
 * applied to the widgets in the Preview area on the right.  Changing values higher up  in the
 * cascades, such as "Standard Text", is a good place to start because those values  will affect
 * the broadest set of variables with the fewest changes - more specific changes  can be applied
 * in later passes. <p> As a rough guide, a good way to start is as follows: <ul> <li>"Standard
 * Background Color" - this cascades to the entire skin and sets up whether your       skin is
 * essentially a light or dark skin <li>"Standard Text Color" - this cascades to most of the skin
 * and is typically        dark-grey to black in lighter skins, or light-grey to white in darker
 * skins <li>"Standard Border Color" - this cascades to most of the skin - it's typically a      
 * light-grey and largely uniform across a skin, where borders are present <li>"Highlight Color" -
 * if this color is blue and you change it to green, most colors in the       skin that were
 * previously a shade of blue will change to a shade of green - this might       include
 * background/rollover-colors, text, shadows or focused borders, for example,       in any widget
 * </ul> As you make changes, you'll see them applied in the Preview area on the right of the
 * screen. Use the "Select View" picker above the Preview to show different types of widgets  and
 * discover how your changes affect them. <p> The Skin Editor only allows for editing variables
 * which are used to populate the base skin's  SASS template.  It will incorporate your changes to
 * those template variables and recompile  the content for the skin's stylesheet,
 * <code>skin_styles.css</code>, but it does not  currently allow for customizing the other parts
 * of the skin, such as JavaScript code and  icons. <p> <h3>Skin Editor files</h3> Files used by
 * the Skin Editor include: <ul> <li> skinEditor.jsp - the bootstrap page for the tool <li>
 * colorTester.jsp - the page displayed in the Skin Editor's <i>Preview Pane</i>  </ul> In
 * addition to these application files, the tool requires several framework  {@link
 * com.smartgwt.client.data.DataSource}s <ul> <li><i>isc_baseSkin</i> - manages information about
 * "base" skins, which are skins that can  be used as the starting point for custom skins in the
 * Skin Editor.  The <i>Flat series</i>  of framework skins are base-skins.
 * <li><i>isc_userSkin</i> - manages information about "user" skins, which are custom skins 
 * created in the Skin Editor, as an extension of an existing <i>base</i> skin.  These user skins
 * can exist either as dataSource-records or as exported skins on disk.
 * <li><i>isc_registeredFonts</i> - manages information about fonts which have been registered 
 * with the framework and exist in the <code>system/helpers/fonts</code> directory. These are  the
 * fonts available in the Skin Editor. </ul> <P> <h3>Prerequisites</h3> Using Skin Editor locally
 * requires the following additional steps: <ul> <li>the builtin DataSource
 * <code>isc_userSkin</code> must be imported to your Database using the  {@link
 * com.smartgwt.client.docs.AdminConsole}.  This DataSource is used to store user skins until
 * export</li> <li> <a href='https://www.python.org/downloads/' target='_blank'>python</a>, <a
 * href='http://www.ruby-lang.org/en/downloads/' target='_blank'>Ruby</a> and <a
 * href='http://compass-style.org/install/' target='_blank'>Compass</a> must all be installed on
 * your  computer, and in the PATH.  During saves, Skin Editor uses <code>Compass</code> to
 * recompile  skin-CSS, via an operation on the <code>isc_userSkin</code> DataSource which invokes
 * <i><b>compass compile 'path-to-skin-template-dir'</b></i> on the server.</li> </ul> <p>
 * <h3>Exporting Skins</h3> To export a skin, load it in the Skin Editor and click the "Export"
 * button to download the  skin in a zip file.  To use the skin, extract the zip into your project
 * skins/ directory and load it in your project in the usual way. <P> A skin exported in this way
 * can be further edited locally in your project  Skin Editor, if you have an appropriate license.
 * Once extracted into the skins/ directory, it will appear in Skin Editor's list of user-skins
 * and can  be edited as normal, with changes being saved to disk rather than database.  You might
 * want  to do this, for example, in order to make non-CSS configuration to the skin, via 
 * <code>load_skin.js</code>.  While future versions of Skin Editor will support non-CSS skin
 * configuration, these features are not yet available. <p> <h4>Base Skins</h4> When you create a
 * new skin in Skin Editor, the first step is to choose a Base skin to use as  a starting-point -
 * by default, these are all builtin Isomorphic skins, but you can add your  own to the list by
 * selecting <i>Export as a Base skin</i> in the Skin Editor. <P> You might want to do this if you
 * create a customized skin and you want to be able to  generate several variations on it - like
 * changing colors, to make the color schemes of  multiple customers that you are creating
 * applications for.
 */
public interface SkinEditor {
}
