/*
 * Smart GWT (GWT for SmartClient)
 * Copyright 2008 and beyond, Isomorphic Software, Inc.
 *
 * Smart GWT is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License version 3
 * as published by the Free Software Foundation.  Smart GWT is also
 * available under typical commercial license terms - see
 * http://smartclient.com/license
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 */
/* sgwtgen */
 
package com.smartgwt.client.widgets;


import com.smartgwt.client.event.*;
import com.smartgwt.client.core.*;
import com.smartgwt.client.types.*;
import com.smartgwt.client.data.*;
import com.smartgwt.client.data.Record;
import com.smartgwt.client.data.events.*;
import com.smartgwt.client.browser.window.*;
import com.smartgwt.client.rpc.*;
import com.smartgwt.client.ai.*;
import com.smartgwt.client.callbacks.*;
import com.smartgwt.client.tools.*;
import com.smartgwt.client.bean.*;
import com.smartgwt.client.widgets.*;
import com.smartgwt.client.widgets.ai.*;
import com.smartgwt.client.widgets.events.*;
import com.smartgwt.client.widgets.form.*;
import com.smartgwt.client.widgets.form.validator.*;
import com.smartgwt.client.widgets.form.fields.*;
import com.smartgwt.client.widgets.tile.*;
import com.smartgwt.client.widgets.tile.events.*;
import com.smartgwt.client.widgets.grid.*;
import com.smartgwt.client.widgets.grid.events.*;
import com.smartgwt.client.widgets.chart.*;
import com.smartgwt.client.widgets.layout.*;
import com.smartgwt.client.widgets.layout.events.*;
import com.smartgwt.client.widgets.menu.*;
import com.smartgwt.client.widgets.tour.*;
import com.smartgwt.client.widgets.notify.*;
import com.smartgwt.client.widgets.rte.*;
import com.smartgwt.client.widgets.rte.events.*;
import com.smartgwt.client.widgets.ace.*;
import com.smartgwt.client.widgets.ace.events.*;
import com.smartgwt.client.widgets.tab.*;
import com.smartgwt.client.widgets.toolbar.*;
import com.smartgwt.client.widgets.tree.*;
import com.smartgwt.client.widgets.tree.events.*;
import com.smartgwt.client.widgets.tableview.*;
import com.smartgwt.client.widgets.viewer.*;
import com.smartgwt.client.widgets.calendar.*;
import com.smartgwt.client.widgets.calendar.events.*;
import com.smartgwt.client.widgets.cube.*;
import com.smartgwt.client.widgets.notify.*;
import com.smartgwt.client.widgets.drawing.*;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

import com.google.gwt.event.shared.*;
import com.google.gwt.dom.client.Element;
import com.google.gwt.user.client.ui.Widget;
import com.google.gwt.core.client.JavaScriptObject;

import com.smartgwt.client.util.*;
import com.smartgwt.client.util.events.*;
import com.smartgwt.client.util.workflow.*;
import com.smartgwt.client.util.workflow.Process; // required to override java.lang.Process
import com.smartgwt.client.util.tour.*;

import com.smartgwt.logicalstructure.core.*;
import com.smartgwt.logicalstructure.widgets.*;
import com.smartgwt.logicalstructure.widgets.drawing.*;
import com.smartgwt.logicalstructure.widgets.plugins.*;
import com.smartgwt.logicalstructure.widgets.form.*;
import com.smartgwt.logicalstructure.widgets.tile.*;
import com.smartgwt.logicalstructure.widgets.grid.*;
import com.smartgwt.logicalstructure.widgets.chart.*;
import com.smartgwt.logicalstructure.widgets.layout.*;
import com.smartgwt.logicalstructure.widgets.menu.*;
import com.smartgwt.logicalstructure.widgets.rte.*;
import com.smartgwt.logicalstructure.widgets.ace.*;
import com.smartgwt.logicalstructure.widgets.tab.*;
import com.smartgwt.logicalstructure.widgets.tableview.*;
import com.smartgwt.logicalstructure.widgets.toolbar.*;
import com.smartgwt.logicalstructure.widgets.tree.*;
import com.smartgwt.logicalstructure.widgets.viewer.*;
import com.smartgwt.logicalstructure.widgets.calendar.*;
import com.smartgwt.logicalstructure.widgets.cube.*;
import com.smartgwt.logicalstructure.widgets.tools.*;
import com.smartgwt.logicalstructure.widgets.tour.*;
import com.smartgwt.logicalstructure.widgets.ai.*;

/**
 * A simple control that presents a Boolean value as a toggle-switch, where the value can be  toggled by clicking with the
 * mouse, or with the Spacebar and left/right  arrow-keys when {@link
 * com.smartgwt.client.widgets.ToggleSwitch#getToggleOnKeypress toggleOnKeypress} is true.
 */
@BeanFactory.FrameworkClass
@BeanFactory.ScClassName("ToggleSwitch")
public class ToggleSwitch extends StatefulCanvas implements com.smartgwt.client.widgets.events.HasToggleValueChangedHandlers {

    public static ToggleSwitch getOrCreateRef(JavaScriptObject jsObj) {
        if (jsObj == null) return null;
        final BaseWidget refInstance = BaseWidget.getRef(jsObj);
        if (refInstance == null) {
            return new ToggleSwitch(jsObj);
        } else {
            assert refInstance instanceof ToggleSwitch;
            return (ToggleSwitch)refInstance;
        }
    }
        


    /**
     * Changes the defaults for Canvas AutoChildren named <code>autoChildName</code>.
     *
     * @param autoChildName name of an AutoChild to customize the defaults for.
     * @param defaults Canvas defaults to apply. These defaults override any existing properties
     * without destroying or wiping out non-overridden properties.  For usage tips on this
     * param, see {@link com.smartgwt.client.docs.SGWTProperties}.
     * @see com.smartgwt.client.docs.AutoChildUsage
     */
    public static native void changeAutoChildDefaults(String autoChildName, Canvas defaults) /*-{
        if (defaults.@com.smartgwt.client.widgets.BaseWidget::isCreated()()) {
            @com.smartgwt.client.util.ConfigUtil::warnOfPreConfigInstantiation(Ljava/lang/Class;Ljava/lang/String;Ljava/lang/String;)(ToggleSwitch.@java.lang.Object::getClass()(), "changeAutoChildDefaults", "Canvas");
        }
        defaults.@com.smartgwt.client.widgets.BaseWidget::setConfigOnly(Z)(true);
        var cleanDefaultsJS = @com.smartgwt.client.util.JSOHelper::cleanProperties(Lcom/google/gwt/core/client/JavaScriptObject;Z)(defaults.@com.smartgwt.client.widgets.BaseWidget::getConfig()(), true);
        $wnd.isc.ToggleSwitch.changeDefaults(autoChildName + "Defaults", cleanDefaultsJS);
    }-*/;

    /**
     * Changes the defaults for FormItem AutoChildren named <code>autoChildName</code>.
     *
     * @param autoChildName name of an AutoChild to customize the defaults for.
     * @param defaults FormItem defaults to apply. These defaults override any existing properties
     * without destroying or wiping out non-overridden properties.  For usage tips on this
     * param, see {@link com.smartgwt.client.docs.SGWTProperties}.
     * @see com.smartgwt.client.docs.AutoChildUsage
     */
    public static native void changeAutoChildDefaults(String autoChildName, FormItem defaults) /*-{
        if (defaults.@com.smartgwt.client.widgets.form.fields.FormItem::isCreated()()) {
            @com.smartgwt.client.util.ConfigUtil::warnOfPreConfigInstantiation(Ljava/lang/Class;Ljava/lang/String;Ljava/lang/String;)(ToggleSwitch.@java.lang.Object::getClass()(), "changeAutoChildDefaults", "FormItem");
        }
        defaults.@com.smartgwt.client.widgets.form.fields.FormItem::setConfigOnly(Z)(true);
    	var cleanDefaultsJS = defaults.@com.smartgwt.client.widgets.form.fields.FormItem::getEditorTypeConfig()();
        $wnd.isc.ToggleSwitch.changeDefaults(autoChildName + "Defaults", cleanDefaultsJS);
    }-*/;

    public ToggleSwitch(){
        scClassName = "ToggleSwitch";
    }

    public ToggleSwitch(JavaScriptObject jsObj){
        scClassName = "ToggleSwitch";
        setJavaScriptObject(jsObj);
    }


    public ToggleSwitch(String title) {
        setTitle(title);
                scClassName = "ToggleSwitch";
    }

    protected native JavaScriptObject create()/*-{
        var config = this.@com.smartgwt.client.widgets.BaseWidget::getConfig()();
        var scClassName = this.@com.smartgwt.client.widgets.BaseWidget::scClassName;
        var widget = $wnd.isc[scClassName].create(config);
        if ($wnd.isc.keepGlobals) this.@com.smartgwt.client.widgets.BaseWidget::internalSetID(Lcom/google/gwt/core/client/JavaScriptObject;)(widget);
        this.@com.smartgwt.client.widgets.BaseWidget::doInit()();
        return widget;
    }-*/;


    // ********************* Properties / Attributes ***********************

    /**
     * When set to true, animates the movement of the {@link com.smartgwt.client.widgets.ToggleSwitch#getThumb thumb} when  the
     * value changes.
     *
     * @param animateThumb New animateThumb value. Default value is true
     * @return {@link com.smartgwt.client.widgets.ToggleSwitch ToggleSwitch} instance, for chaining setter calls
     * @see com.smartgwt.client.docs.Appearance Appearance overview and related methods
     */
    public ToggleSwitch setAnimateThumb(Boolean animateThumb) {
        return (ToggleSwitch)setAttribute("animateThumb", animateThumb, true);
    }

    /**
     * When set to true, animates the movement of the {@link com.smartgwt.client.widgets.ToggleSwitch#getThumb thumb} when  the
     * value changes.
     *
     * @return Current animateThumb value. Default value is true
     * @see com.smartgwt.client.docs.Appearance Appearance overview and related methods
     */
    public Boolean getAnimateThumb()  {
        Boolean result = getAttributeAsBoolean("animateThumb");
        return result == null ? true : result;
    }
    

    /**
     * When {@link com.smartgwt.client.widgets.ToggleSwitch#getAnimateThumb animateThumb} is true, the time taken to move  the
     * {@link com.smartgwt.client.widgets.ToggleSwitch#getThumb thumb} from one state to the other.
     *
     * @param animateThumbTime New animateThumbTime value. Default value is 200
     * @return {@link com.smartgwt.client.widgets.ToggleSwitch ToggleSwitch} instance, for chaining setter calls
     * @see com.smartgwt.client.docs.Appearance Appearance overview and related methods
     */
    public ToggleSwitch setAnimateThumbTime(Integer animateThumbTime) {
        return (ToggleSwitch)setAttribute("animateThumbTime", animateThumbTime, true);
    }

    /**
     * When {@link com.smartgwt.client.widgets.ToggleSwitch#getAnimateThumb animateThumb} is true, the time taken to move  the
     * {@link com.smartgwt.client.widgets.ToggleSwitch#getThumb thumb} from one state to the other.
     *
     * @return Current animateThumbTime value. Default value is 200
     * @see com.smartgwt.client.docs.Appearance Appearance overview and related methods
     */
    public Integer getAnimateThumbTime()  {
        return getAttributeAsInt("animateThumbTime");
    }
    

    /**
     * The default value of this ToggleSwitch.
     *
     * @param defaultValue New defaultValue value. Default value is false
     * @return {@link com.smartgwt.client.widgets.ToggleSwitch ToggleSwitch} instance, for chaining setter calls
     * @see com.smartgwt.client.docs.Appearance Appearance overview and related methods
     */
    public ToggleSwitch setDefaultValue(Boolean defaultValue) {
        return (ToggleSwitch)setAttribute("defaultValue", defaultValue, true);
    }

    /**
     * The default value of this ToggleSwitch.
     *
     * @return Current defaultValue value. Default value is false
     * @see com.smartgwt.client.docs.Appearance Appearance overview and related methods
     */
    public Boolean getDefaultValue()  {
        Boolean result = getAttributeAsBoolean("defaultValue");
        return result == null ? false : result;
    }
    

    /**
     * A canvas used as the thumb of this ToggleSwitch, which can be styled using  {@link
     * com.smartgwt.client.widgets.ToggleSwitch#getThumbBaseStyle thumbBaseStyle} and otherwise modified according to the
     * AutoChild  pattern - <code>thumbConstructor</code>, <code>thumbDefaults</code> and <code>thumbProperties</code> are
     * valid.
     * <p>
     * This component is an AutoChild named "thumb".  For an overview of how to use and
     * configure AutoChildren, see {@link com.smartgwt.client.docs.AutoChildUsage Using AutoChildren}.
     *
     * @return Current thumb value. Default value is null
     * @throws IllegalStateException if this widget has not yet been rendered.
     */
    public Canvas getThumb() throws IllegalStateException {
        errorIfNotCreated("thumb");
        return (Canvas)Canvas.getByJSObject(getAttributeAsJavaScriptObject("thumb"));
    }
    

    /**
     * The name of the base CSS class to apply to the {@link com.smartgwt.client.widgets.ToggleSwitch#getThumb thumb} of this 
     * toggle switch - the actual styleName applied will be suffixed "On" or "Off", depending on this widget's current value.
     *
     * @param thumbBaseStyle New thumbBaseStyle value. Default value is "toggleSwitchThumb"
     * @return {@link com.smartgwt.client.widgets.ToggleSwitch ToggleSwitch} instance, for chaining setter calls
     * @see com.smartgwt.client.docs.CSSStyleName CSSStyleName 
     * @see com.smartgwt.client.docs.Appearance Appearance overview and related methods
     */
    public ToggleSwitch setThumbBaseStyle(String thumbBaseStyle) {
        return (ToggleSwitch)setAttribute("thumbBaseStyle", thumbBaseStyle, true);
    }

    /**
     * The name of the base CSS class to apply to the {@link com.smartgwt.client.widgets.ToggleSwitch#getThumb thumb} of this 
     * toggle switch - the actual styleName applied will be suffixed "On" or "Off", depending on this widget's current value.
     *
     * @return Current thumbBaseStyle value. Default value is "toggleSwitchThumb"
     * @see com.smartgwt.client.docs.CSSStyleName CSSStyleName 
     * @see com.smartgwt.client.docs.Appearance Appearance overview and related methods
     */
    public String getThumbBaseStyle()  {
        return getAttributeAsString("thumbBaseStyle");
    }
    

    /**
     * Spacing to apply inside of this ToggleSwitch, outside of the {@link com.smartgwt.client.widgets.ToggleSwitch#getThumb
     * thumb}.
     *
     * @param thumbOffset New thumbOffset value. Default value is 2
     * @return {@link com.smartgwt.client.widgets.ToggleSwitch ToggleSwitch} instance, for chaining setter calls
     * @see com.smartgwt.client.docs.Appearance Appearance overview and related methods
     */
    public ToggleSwitch setThumbOffset(Integer thumbOffset) {
        return (ToggleSwitch)setAttribute("thumbOffset", thumbOffset, true);
    }

    /**
     * Spacing to apply inside of this ToggleSwitch, outside of the {@link com.smartgwt.client.widgets.ToggleSwitch#getThumb
     * thumb}.
     *
     * @return Current thumbOffset value. Default value is 2
     * @see com.smartgwt.client.docs.Appearance Appearance overview and related methods
     */
    public Integer getThumbOffset()  {
        return getAttributeAsInt("thumbOffset");
    }
    

    /**
     * The CSS border-radius for the {@link com.smartgwt.client.widgets.ToggleSwitch#getThumb thumb}.  The value can be any
     * variant  of a CSS border-radius value - that is, from 1 to 4 space-separated px values, where one  value affects all
     * corners and 4 values affects individual corners.  For example "10px"  applies a 10px radius to all corners, where "5px
     * 10px 15px 20px" applies a different  radius to each corner, clockwise from Top-Left: "TL TR BR BL".
     *
     * @param thumbRadius New thumbRadius value. Default value is null
     * @return {@link com.smartgwt.client.widgets.ToggleSwitch ToggleSwitch} instance, for chaining setter calls
     * @see com.smartgwt.client.docs.Appearance Appearance overview and related methods
     */
    public ToggleSwitch setThumbRadius(String thumbRadius) {
        return (ToggleSwitch)setAttribute("thumbRadius", thumbRadius, true);
    }

    /**
     * The CSS border-radius for the {@link com.smartgwt.client.widgets.ToggleSwitch#getThumb thumb}.  The value can be any
     * variant  of a CSS border-radius value - that is, from 1 to 4 space-separated px values, where one  value affects all
     * corners and 4 values affects individual corners.  For example "10px"  applies a 10px radius to all corners, where "5px
     * 10px 15px 20px" applies a different  radius to each corner, clockwise from Top-Left: "TL TR BR BL".
     *
     * @return Current thumbRadius value. Default value is null
     * @see com.smartgwt.client.docs.Appearance Appearance overview and related methods
     */
    public String getThumbRadius()  {
        return getAttributeAsString("thumbRadius");
    }
    

    /**
     * The name of the CSS class to apply to this ToggleSwitch - the actual styleName applied  will be suffixed "On" or "Off",
     * depending on the widget's current value.
     *
     * @param toggleBaseStyle New toggleBaseStyle value. Default value is "toggleSwitch"
     * @return {@link com.smartgwt.client.widgets.ToggleSwitch ToggleSwitch} instance, for chaining setter calls
     * @see com.smartgwt.client.docs.CSSStyleName CSSStyleName 
     * @see com.smartgwt.client.docs.Appearance Appearance overview and related methods
     */
    public ToggleSwitch setToggleBaseStyle(String toggleBaseStyle) {
        return (ToggleSwitch)setAttribute("toggleBaseStyle", toggleBaseStyle, true);
    }

    /**
     * The name of the CSS class to apply to this ToggleSwitch - the actual styleName applied  will be suffixed "On" or "Off",
     * depending on the widget's current value.
     *
     * @return Current toggleBaseStyle value. Default value is "toggleSwitch"
     * @see com.smartgwt.client.docs.CSSStyleName CSSStyleName 
     * @see com.smartgwt.client.docs.Appearance Appearance overview and related methods
     */
    public String getToggleBaseStyle()  {
        return getAttributeAsString("toggleBaseStyle");
    }
    

    /**
     * When set to true, the value can be toggled by pressing the <i>Spacebar</i>, or changed  with the left and right
     * arrow-keys.
     *
     * @param toggleOnKeypress New toggleOnKeypress value. Default value is true
     * @return {@link com.smartgwt.client.widgets.ToggleSwitch ToggleSwitch} instance, for chaining setter calls
     * @see com.smartgwt.client.docs.Appearance Appearance overview and related methods
     */
    public ToggleSwitch setToggleOnKeypress(Boolean toggleOnKeypress) {
        return (ToggleSwitch)setAttribute("toggleOnKeypress", toggleOnKeypress, true);
    }

    /**
     * When set to true, the value can be toggled by pressing the <i>Spacebar</i>, or changed  with the left and right
     * arrow-keys.
     *
     * @return Current toggleOnKeypress value. Default value is true
     * @see com.smartgwt.client.docs.Appearance Appearance overview and related methods
     */
    public Boolean getToggleOnKeypress()  {
        Boolean result = getAttributeAsBoolean("toggleOnKeypress");
        return result == null ? true : result;
    }
    

    /**
     * When set to true, causes the ToggleSwitch to change value when the  {@link
     * com.smartgwt.client.widgets.ToggleSwitch#getThumb thumb} is clicked, as well as when clicking in the widget body.
     *
     * @param toggleOnThumbClick New toggleOnThumbClick value. Default value is true
     * @return {@link com.smartgwt.client.widgets.ToggleSwitch ToggleSwitch} instance, for chaining setter calls
     * @see com.smartgwt.client.docs.Appearance Appearance overview and related methods
     */
    public ToggleSwitch setToggleOnThumbClick(Boolean toggleOnThumbClick) {
        return (ToggleSwitch)setAttribute("toggleOnThumbClick", toggleOnThumbClick, true);
    }

    /**
     * When set to true, causes the ToggleSwitch to change value when the  {@link
     * com.smartgwt.client.widgets.ToggleSwitch#getThumb thumb} is clicked, as well as when clicking in the widget body.
     *
     * @return Current toggleOnThumbClick value. Default value is true
     * @see com.smartgwt.client.docs.Appearance Appearance overview and related methods
     */
    public Boolean getToggleOnThumbClick()  {
        Boolean result = getAttributeAsBoolean("toggleOnThumbClick");
        return result == null ? true : result;
    }
    

    /**
     * The current value of this ToggleSwitch.
     *
     * <br><br>If this method is called after the component has been drawn/initialized:
     * Sets the {@link com.smartgwt.client.widgets.ToggleSwitch#getValue value} of this ToggleSwitch.
     *
     * @param value new value for the ToggleSwitch. Default value is false
     * @return {@link com.smartgwt.client.widgets.ToggleSwitch ToggleSwitch} instance, for chaining setter calls
     * @see com.smartgwt.client.docs.Appearance Appearance overview and related methods
     */
    public ToggleSwitch setValue(Boolean value) {
        return (ToggleSwitch)setAttribute("value", value, true);
    }

    /**
     * The current value of this ToggleSwitch.
     *
     * @return Returns the current {@link com.smartgwt.client.widgets.ToggleSwitch#getValue value} of this ToggleSwitch. Default value is false
     * @see com.smartgwt.client.docs.Appearance Appearance overview and related methods
     */
    public Boolean getValue()  {
        Boolean result = getAttributeAsBoolean("value");
        return result == null ? false : result;
    }
    

    // ********************* Methods ***********************
    /**
     * Add a toggleValueChanged handler.
     * <p>
     * Notification fired when the value is toggled by the user.
     *
     * @param handler the toggleValueChanged handler
     * @return {@link HandlerRegistration} used to remove this handler
     */
    public HandlerRegistration addToggleValueChangedHandler(com.smartgwt.client.widgets.events.ToggleValueChangedHandler handler) {
        if(getHandlerCount(com.smartgwt.client.widgets.events.ToggleValueChangedEvent.getType()) == 0) setupToggleValueChangedEvent();
        return doAddHandler(handler, com.smartgwt.client.widgets.events.ToggleValueChangedEvent.getType());
    }

    private native void setupToggleValueChangedEvent() /*-{
        var obj;
        var selfJ = this;
        var hasDefaultHandler;
        var valueChanged = $entry(function(){
            var param = {"_this": this, "newValue" : arguments[0], "oldValue" : arguments[1]};
            var event = @com.smartgwt.client.widgets.events.ToggleValueChangedEvent::new(Lcom/google/gwt/core/client/JavaScriptObject;)(param);
            selfJ.@com.smartgwt.client.widgets.BaseWidget::fireEvent(Lcom/google/gwt/event/shared/GwtEvent;)(event);
            selfJ.@com.smartgwt.client.widgets.ToggleSwitch::handleTearDownToggleValueChangedEvent()();
            if (hasDefaultHandler) this.Super("valueChanged", arguments);
        });
        if(this.@com.smartgwt.client.widgets.BaseWidget::isCreated()()) {
            obj = this.@com.smartgwt.client.widgets.BaseWidget::getJsObj()();
            hasDefaultHandler = $wnd.isc.isA.Function(obj.getProperty("valueChanged"));
            obj.addProperties({valueChanged:  valueChanged              });
        } else {
            obj = this.@com.smartgwt.client.widgets.BaseWidget::getConfig()();
            var scClassName = this.@com.smartgwt.client.widgets.BaseWidget::scClassName;
            hasDefaultHandler = $wnd.isc.isA.Function($wnd.isc[scClassName].getInstanceProperty("valueChanged"));
            obj.valueChanged =  valueChanged             ;
        }
    }-*/;

    private void handleTearDownToggleValueChangedEvent() {
        if (getHandlerCount(com.smartgwt.client.widgets.events.ToggleValueChangedEvent.getType()) == 0) tearDownToggleValueChangedEvent();
    }

    private native void tearDownToggleValueChangedEvent() /*-{
        var obj;
        if(this.@com.smartgwt.client.widgets.BaseWidget::isCreated()()) {
            obj = this.@com.smartgwt.client.widgets.BaseWidget::getJsObj()();
        } else {
            obj = this.@com.smartgwt.client.widgets.BaseWidget::getConfig()();
        }
        if (obj && obj.hasOwnProperty("valueChanged")) delete obj.valueChanged;
    }-*/;


    // ********************* Static Methods ***********************

    /** 
     * Class level method to set the default properties of this class.  If set, then all
     * existing and subsequently created instances of this class will automatically have
     * default properties corresponding to
     * the properties set on the SmartGWT class instance passed to this function before its
     * underlying SmartClient JS object was created.
     * This is a powerful feature that eliminates the need for users to create a separate
     * hierarchy of subclasses that only alter the default properties of this class. Can also
     * be used for skinning / styling purposes.  <P> <b>Note:</b> This method is intended for
     * setting default attributes only and will affect all instances of the underlying class
     * (including those automatically generated in JavaScript).  This method should not be used
     * to apply standard EventHandlers or override methods for a class - use a custom subclass
     * instead.  Calling this method after instances have been created can result in undefined
     * behavior, since it bypasses any setters and a class instance may have already examined 
     * a particular property and not be expecting any changes through this route.
     *
     * @param toggleSwitchProperties properties that should be used as new defaults when instances of this class are created
     * @see com.smartgwt.client.docs.SGWTProperties
     */
    public static native void setDefaultProperties(ToggleSwitch toggleSwitchProperties) /*-{
        if (toggleSwitchProperties.@com.smartgwt.client.widgets.BaseWidget::isCreated()()) {
            @com.smartgwt.client.util.ConfigUtil::warnOfPreConfigInstantiation(Ljava/lang/Class;Ljava/lang/String;Ljava/lang/Class;)(ToggleSwitch.@java.lang.Object::getClass()(), "setDefaultProperties", toggleSwitchProperties.@java.lang.Object::getClass()());
        }
        toggleSwitchProperties.@com.smartgwt.client.widgets.BaseWidget::setConfigOnly(Z)(true);
    	var properties = toggleSwitchProperties.@com.smartgwt.client.widgets.BaseWidget::getConfig()();
        properties = @com.smartgwt.client.util.JSOHelper::cleanProperties(Lcom/google/gwt/core/client/JavaScriptObject;Z)(properties,true);
        $wnd.isc.ToggleSwitch.addProperties(properties);
    }-*/;

    // ***********************************************************

    /**
     * Setter implementing the {@link com.smartgwt.client.core.LogicalStructure} interface,
     * which supports Eclipse's logical structure debugging facility.
     */
    public LogicalStructureObject setLogicalStructure(ToggleSwitchLogicalStructure s) {
        super.setLogicalStructure(s);
        try {
            s.animateThumb = getAttributeAsString("animateThumb");
        } catch (Throwable t) {
            s.logicalStructureErrors += "ToggleSwitch.animateThumb:" + t.getMessage() + "\n";
        }
        try {
            s.animateThumbTime = getAttributeAsString("animateThumbTime");
        } catch (Throwable t) {
            s.logicalStructureErrors += "ToggleSwitch.animateThumbTime:" + t.getMessage() + "\n";
        }
        try {
            s.defaultValue = getAttributeAsString("defaultValue");
        } catch (Throwable t) {
            s.logicalStructureErrors += "ToggleSwitch.defaultValue:" + t.getMessage() + "\n";
        }
        try {
            s.thumbBaseStyle = getAttributeAsString("thumbBaseStyle");
        } catch (Throwable t) {
            s.logicalStructureErrors += "ToggleSwitch.thumbBaseStyle:" + t.getMessage() + "\n";
        }
        try {
            s.thumbOffset = getAttributeAsString("thumbOffset");
        } catch (Throwable t) {
            s.logicalStructureErrors += "ToggleSwitch.thumbOffset:" + t.getMessage() + "\n";
        }
        try {
            s.thumbRadius = getAttributeAsString("thumbRadius");
        } catch (Throwable t) {
            s.logicalStructureErrors += "ToggleSwitch.thumbRadius:" + t.getMessage() + "\n";
        }
        try {
            s.toggleBaseStyle = getAttributeAsString("toggleBaseStyle");
        } catch (Throwable t) {
            s.logicalStructureErrors += "ToggleSwitch.toggleBaseStyle:" + t.getMessage() + "\n";
        }
        try {
            s.toggleOnKeypress = getAttributeAsString("toggleOnKeypress");
        } catch (Throwable t) {
            s.logicalStructureErrors += "ToggleSwitch.toggleOnKeypress:" + t.getMessage() + "\n";
        }
        try {
            s.toggleOnThumbClick = getAttributeAsString("toggleOnThumbClick");
        } catch (Throwable t) {
            s.logicalStructureErrors += "ToggleSwitch.toggleOnThumbClick:" + t.getMessage() + "\n";
        }
        try {
            s.value = getAttributeAsString("value");
        } catch (Throwable t) {
            s.logicalStructureErrors += "ToggleSwitch.value:" + t.getMessage() + "\n";
        }
        return s;
    }

    /**
     * Getter implementing the {@link com.smartgwt.client.core.LogicalStructure} interface,
     * which supports Eclipse's logical structure debugging facility.
     */
    public LogicalStructureObject getLogicalStructure() {
        ToggleSwitchLogicalStructure s = new ToggleSwitchLogicalStructure();
        setLogicalStructure(s);
        return s;
    }
}
