/*
 * Decompiled with CFR 0.152.
 */
package com.isomorphic.datasource;

import com.isomorphic.base.Reflection;
import com.isomorphic.datasource.DSField;
import com.isomorphic.datasource.DataSource;
import com.isomorphic.log.Logger;
import com.isomorphic.util.DataTools;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.commons.collections4.queue.CircularFifoQueue;

public class MemoryStore {
    private static final String CLASS_NAME = MemoryStore.class.getName();
    private static final Logger log = new Logger(CLASS_NAME);
    private static final String FIELD_NAME = "name";
    private static final String FIELD_TYPE = "type";
    private static final String FIELD_SEQUENCE = "sequence";
    private static final String FIELD_ID = "id";
    private static final Map<String, Collection<Map<String, Object>>> stores = new HashMap<String, Collection<Map<String, Object>>>();
    private static final Map<String, List<Map<String, Object>>> storesConfig = new HashMap<String, List<Map<String, Object>>>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<String> storeList() {
        Map<String, Collection<Map<String, Object>>> map = stores;
        synchronized (map) {
            return new ArrayList<String>(stores.keySet());
        }
    }

    public static Collection<Map<String, Object>> getStore(String storeName) {
        return stores.get(storeName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void createStore(String storeName, DataSource ds) {
        int maxRows = ds.getConfig().getInt("maxRows", -1);
        Map<String, Collection<Map<String, Object>>> map = stores;
        synchronized (map) {
            Map<String, List<Map<String, Object>>> map2 = storesConfig;
            synchronized (map2) {
                if (!storesConfig.containsKey(storeName)) {
                    log.debug("Creating memory store: '" + storeName + "'.");
                    LinkedList store = maxRows == -1 ? new LinkedList() : new CircularFifoQueue(maxRows);
                    stores.put(storeName, store);
                    List<DSField> fields = ds.getFields();
                    ArrayList storeFields = new ArrayList();
                    for (DSField field : fields) {
                        HashMap<String, Object> fieldConfig = new HashMap<String, Object>();
                        String fieldName = field.getName();
                        fieldConfig.put(FIELD_NAME, fieldName);
                        Class fieldClass = null;
                        Object className = field.get("javaClass");
                        if (className != null) {
                            try {
                                fieldClass = Reflection.classForName(className.toString());
                            }
                            catch (Exception ex) {
                                log.warn(ex);
                            }
                        }
                        if (fieldClass == null) {
                            String fieldType = field.getType();
                            if (fieldType == null) {
                                fieldType = "text";
                            }
                            if (!FIELD_SEQUENCE.equals(fieldType)) {
                                fieldType = ds.getSimpleBaseType(fieldType);
                            }
                            if ("text".equals(fieldType)) {
                                fieldClass = String.class;
                            } else if ("boolean".equalsIgnoreCase(fieldType)) {
                                fieldClass = Boolean.class;
                            } else if ("integer".equalsIgnoreCase(fieldType)) {
                                fieldClass = Integer.class;
                            } else if ("float".equalsIgnoreCase(fieldType)) {
                                fieldClass = Float.class;
                            } else if ("date".equalsIgnoreCase(fieldType)) {
                                fieldClass = Date.class;
                            } else if ("time".equalsIgnoreCase(fieldType)) {
                                fieldClass = Date.class;
                            } else if ("datetime".equalsIgnoreCase(fieldType)) {
                                fieldClass = Date.class;
                            } else if ("enum".equalsIgnoreCase(fieldType)) {
                                fieldClass = Enum.class;
                            } else if ("intEnum".equalsIgnoreCase(fieldType)) {
                                fieldClass = Enum.class;
                            } else if (FIELD_SEQUENCE.equalsIgnoreCase(fieldType)) {
                                fieldConfig.put(FIELD_SEQUENCE, new AtomicLong(0L));
                                fieldClass = Long.class;
                            } else {
                                fieldClass = "link".equalsIgnoreCase(fieldType) ? String.class : ("image".equalsIgnoreCase(fieldType) ? String.class : ("binary".equalsIgnoreCase(fieldType) ? Object.class : ("imageFile".equalsIgnoreCase(fieldType) ? Object.class : ("any".equalsIgnoreCase(fieldType) ? Object.class : ("jsonb".equalsIgnoreCase(fieldType) ? Object.class : ("json".equalsIgnoreCase(fieldType) ? Object.class : ("custom".equalsIgnoreCase(fieldType) ? Object.class : ("modifier".equalsIgnoreCase(fieldType) ? String.class : ("modifierTimestamp".equalsIgnoreCase(fieldType) ? Date.class : ("creator".equalsIgnoreCase(fieldType) ? String.class : ("creatorTimestamp".equalsIgnoreCase(fieldType) ? Date.class : ("password".equalsIgnoreCase(fieldType) ? String.class : ("ntext".equalsIgnoreCase(fieldType) ? String.class : ("localeInt".equalsIgnoreCase(fieldType) ? Integer.class : ("localeFloat".equalsIgnoreCase(fieldType) ? Float.class : ("localeCurrency".equalsIgnoreCase(fieldType) ? BigDecimal.class : ("phoneNumber".equalsIgnoreCase(fieldType) ? String.class : Object.class)))))))))))))))));
                            }
                        }
                        fieldConfig.put(FIELD_TYPE, fieldClass);
                        if (field.isPrimaryKey()) {
                            fieldConfig.put(FIELD_ID, Boolean.TRUE);
                        }
                        storeFields.add(fieldConfig);
                        log.debug("Created field: " + fieldConfig);
                    }
                    storesConfig.put(storeName, storeFields);
                    log.debug("Store: '" + storeName + "' created.");
                } else {
                    log.debug("Memory store: '" + storeName + "' already exists.");
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void deleteStore(String storeName) {
        Map<String, Collection<Map<String, Object>>> map = stores;
        synchronized (map) {
            Map<String, List<Map<String, Object>>> map2 = storesConfig;
            synchronized (map2) {
                log.debug("Deleting store: '" + storeName + "'.");
                stores.remove(storeName);
                storesConfig.remove(storeName);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void clearStore(String storeName) {
        log.debug("Clearing store: '" + storeName + "'.");
        Collection<Map<String, Object>> s = MemoryStore.getStore(storeName);
        if (s != null) {
            Collection<Map<String, Object>> collection = s;
            synchronized (collection) {
                s.clear();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long recordCount(String storeName) {
        Collection<Map<String, Object>> s = MemoryStore.getStore(storeName);
        if (s != null) {
            Collection<Map<String, Object>> collection = s;
            synchronized (collection) {
                return s.size();
            }
        }
        return 0L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Map<String, Object> insert(String storeName, Map record) {
        Collection<Map<String, Object>> s;
        if (record == null) {
            record = new HashMap();
        }
        if ((s = MemoryStore.getStore(storeName)) != null) {
            Collection<Map<String, Object>> collection = s;
            synchronized (collection) {
                record = MemoryStore.createRecord(storeName, record, true);
                Map<String, Object> rec = MemoryStore.findById(storeName, record);
                if (rec != null) {
                    return null;
                }
                s.add(record);
            }
            return record;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Map<String, Object> update(String storeName, Map<String, Object> id, Map<String, Object> record) {
        Collection<Map<String, Object>> s = MemoryStore.getStore(storeName);
        if (s != null) {
            Collection<Map<String, Object>> collection = s;
            synchronized (collection) {
                id = MemoryStore.createRecord(storeName, id, true);
                Map<String, Object> rec = MemoryStore.findById(storeName, id);
                record = MemoryStore.createRecord(storeName, record, false);
                if (rec != null) {
                    for (String fieldName : record.keySet()) {
                        rec.put(fieldName, record.get(fieldName));
                    }
                } else {
                    return null;
                }
            }
            return MemoryStore.findById(storeName, record);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Map<String, Object> delete(String storeName, Map<String, Object> record) {
        Collection<Map<String, Object>> s = MemoryStore.getStore(storeName);
        if (s != null) {
            Collection<Map<String, Object>> collection = s;
            synchronized (collection) {
                record = MemoryStore.createRecord(storeName, record, true);
                Map<String, Object> rec = MemoryStore.findById(storeName, record);
                if (rec == null) {
                    return null;
                }
                s.remove(rec);
            }
            return record;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<Map<String, Object>> find(String storeName, Map record) {
        record = MemoryStore.createRecord(storeName, record, false);
        Collection<Map<String, Object>> s = MemoryStore.getStore(storeName);
        if (s != null) {
            Collection<Map<String, Object>> collection = s;
            synchronized (collection) {
                LinkedList<Map<String, Object>> records = new LinkedList<Map<String, Object>>();
                for (Map<String, Object> rec : s) {
                    boolean allMatch = true;
                    for (String fieldNameObj : record.keySet()) {
                        String fieldName;
                        if (fieldNameObj == null || !rec.containsKey(fieldName = fieldNameObj.toString())) continue;
                        Object value = record.get(fieldName);
                        Object storeValue = rec.get(fieldName);
                        if (value == null) {
                            if (storeValue == null) continue;
                            allMatch = false;
                            break;
                        }
                        if (value.equals(storeValue)) continue;
                        allMatch = false;
                        break;
                    }
                    if (!allMatch) continue;
                    records.add(MemoryStore.createRecord(storeName, rec, true));
                }
                return records;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Map<String, Object> findById(String storeName, Map record) {
        record = MemoryStore.createRecord(storeName, record, false);
        Collection<Map<String, Object>> s = MemoryStore.getStore(storeName);
        List<Map<String, Object>> fields = storesConfig.get(storeName);
        if (s != null && fields != null) {
            Collection<Map<String, Object>> collection = s;
            synchronized (collection) {
                List<Map<String, Object>> list = fields;
                synchronized (list) {
                    for (Map<String, Object> rec : s) {
                        boolean allMatch = true;
                        for (Map<String, Object> field : fields) {
                            Boolean isId = (Boolean)field.get(FIELD_ID);
                            if (isId == null || !isId.booleanValue()) continue;
                            String fieldName = (String)field.get(FIELD_NAME);
                            Object value = record.get(fieldName);
                            Object storeValue = rec.get(fieldName);
                            if (value == null) {
                                if (storeValue == null) continue;
                                allMatch = false;
                                break;
                            }
                            if (value.equals(storeValue)) continue;
                            allMatch = false;
                            break;
                        }
                        if (!allMatch) continue;
                        return rec;
                    }
                }
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Map<String, Object> createRecord(String storeName, Map values, boolean allFields) {
        List<Map<String, Object>> fields = storesConfig.get(storeName);
        if (fields != null) {
            List<Map<String, Object>> list = fields;
            synchronized (list) {
                HashMap<String, Object> record = new HashMap<String, Object>();
                for (Map<String, Object> field : fields) {
                    Object realValue;
                    String fieldName = (String)field.get(FIELD_NAME);
                    if (!allFields && !values.containsKey(fieldName)) continue;
                    Object value = values.get(fieldName);
                    try {
                        realValue = DataTools.castValue(value, (Class)field.get(FIELD_TYPE));
                    }
                    catch (Exception ex) {
                        realValue = null;
                    }
                    if (field.containsKey(FIELD_SEQUENCE)) {
                        AtomicLong seq = (AtomicLong)field.get(FIELD_SEQUENCE);
                        if (realValue == null) {
                            realValue = seq.incrementAndGet();
                        } else {
                            Long longValue = Long.valueOf(realValue.toString());
                            if (seq.get() < longValue) {
                                seq.set(longValue);
                            }
                        }
                    }
                    record.put(fieldName, realValue);
                }
                return record;
            }
        }
        return null;
    }

    public static Class getFieldType(String storeName, String fieldName) {
        if (fieldName == null) {
            return null;
        }
        List<Map<String, Object>> fields = storesConfig.get(storeName);
        if (fields != null) {
            for (Map<String, Object> field : fields) {
                if (!fieldName.equals(field.get(FIELD_NAME))) continue;
                return (Class)field.get(FIELD_TYPE);
            }
        }
        return null;
    }
}

