/*
 * Decompiled with CFR 0.152.
 */
package com.isomorphic.servlet;

import com.isomorphic.log.Logger;
import com.isomorphic.servlet.BaseFilter;
import com.isomorphic.servlet.ServletTools;
import java.io.IOException;
import javax.servlet.FilterChain;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;

public class VersionedURLFilter
extends BaseFilter {
    protected Logger log;

    @Override
    public void _doFilter(ServletRequest req, ServletResponse res, FilterChain fc) throws IOException, ServletException {
        String params;
        this.log = new Logger(this.getClass().getName());
        HttpServletRequestWrapper wrapper = new HttpServletRequestWrapper((HttpServletRequest)req);
        String original = wrapper.getRequestURI();
        String contextPath = wrapper.getContextPath();
        if (contextPath != null && contextPath.length() > 0 && original.startsWith(contextPath)) {
            original = original.substring(contextPath.length());
        }
        if ((params = wrapper.getQueryString()) != null && params.length() > 0) {
            original = original + "?" + params;
        }
        String unversioned = original;
        if (config.getBoolean((Object)"isc.stripVersionPathSegments", false)) {
            unversioned = ServletTools.stripVersionPathSegment(original);
        }
        if (!original.equals(unversioned)) {
            RequestDispatcher dispatcher = wrapper.getRequestDispatcher(unversioned);
            dispatcher.forward(req, res);
        } else {
            fc.doFilter((ServletRequest)wrapper, res);
        }
    }
}

