package com.smartgwt.sample.client;

import java.util.Map;

import com.smartgwt.client.types.*;
import com.smartgwt.client.data.*;
import com.smartgwt.client.util.*;
import com.smartgwt.client.widgets.*;
import com.smartgwt.client.widgets.events.*;
import com.smartgwt.client.widgets.layout.*;
import com.smartgwt.client.browser.window.*;
import com.smartgwt.client.widgets.form.*;


import static com.smartgwt.sample.client.AnimalsDataSource.AnimalRecord;

public class DataContextPane extends SectionStack  {

    AnimalForm commonPojoForm;
    AnimalForm boundRecordForm;

    public DataContextPane() {
        DataContext dataContext = MultiWindow.getDataContext();

        commonPojoForm = new AnimalForm("Common POJO", (Record)
            dataContext.getSharedJavaObject("sharedRecord"));
        SectionStackSection commonPojoSection = new SectionStackSection();
        commonPojoSection.setTitle("Animal Data as Common POJO in DataContext");
        commonPojoSection.setItems(commonPojoForm);
        commonPojoSection.setControls(commonPojoForm.getRefreshButton(),
                                      commonPojoForm.getSaveButton());
        commonPojoSection.setExpanded(true);

        boundRecordForm = new AnimalForm("Bound Record",
            dataContext.getDataSourceRecord("AnimalsDS"));
        SectionStackSection boundRecordSection = new SectionStackSection();
        boundRecordSection.setTitle("Animal Data as Bound Record in DataContext");
        boundRecordSection.setItems(boundRecordForm);
        boundRecordSection.setControls(boundRecordForm.getRefreshButton(),
                                       boundRecordForm.getSaveButton());
        boundRecordSection.setExpanded(true);

        setSections(commonPojoSection, boundRecordSection);
        setVisibilityMode(VisibilityMode.MULTIPLE);
    }

    static void setupInitialDataContext() {
        DataContext dataContext = MultiWindow.getDataContext();

        Record commonPOJO = new AnimalRecord(
            "Elephant (African)", "Loxodonta africana", 60, "Threatened", "Herbivore");
        dataContext.setSharedJavaObject("sharedRecord", commonPOJO);

        Record boundRecord = new AnimalRecord(
            "Otus asio", "Screech Owl", 10, "Not Endangered", "Carnivore");
        dataContext.setDataSourceRecord("AnimalsDS", boundRecord);
    }

    public static class AnimalForm extends DynamicForm {
        String title;
        Record record;
        public AnimalForm(String title, Record record) {
            setDataSource(AnimalsDataSource.getInstance());
            this.title = title;
            this.record = record;
            refreshRecord();            
        }

        ImgButton getRefreshButton() {
            return new AnimalFormRefresh();
        }

        ImgButton getSaveButton() {
            return new AnimalFormSave();
        }

        void refreshRecord() {
            editRecord(record);
        }

        void saveRecord() {
            Map edits = getValues();
            for (Object key : edits.keySet()) {
                record.setAttribute((String)key, edits.get(key));
            }
        }

        public class AnimalFormToolButton extends ImgButton {
            public AnimalFormToolButton() {
                setShowRollOver(false);
                setShowFocused(false);
                setShowDown(false);
                setSize(20);
            }
        }

        public class AnimalFormRefresh extends AnimalFormToolButton {
            public AnimalFormRefresh() {
                setSrc("[SKIN]/actions/refresh.png");
                setPrompt("Refresh form from DataContext");
                addClickHandler(new ClickHandler() {
                    public void onClick(ClickEvent event) {
                        SC.notify("Refreshed " + title + " Form from DataContext");
                        refreshRecord();
                    }
                });
            }
        }

        public class AnimalFormSave extends AnimalFormToolButton {
            public AnimalFormSave() {
                setSrc("[SKIN]/actions/save.png");
                setPrompt("Save changes back to DataContext");
                addClickHandler(new ClickHandler() {
                    public void onClick(ClickEvent event) {
                        SC.notify("Saved " + title + " Form data back to DataContext");
                        saveRecord();
                    }
                });
            }
        }


    }
    
}
