
/*
 * Isomorphic Smart GWT web presentation layer
 * Copyright 2000 and beyond Isomorphic Software, Inc.
 *
 * OWNERSHIP NOTICE
 * Isomorphic Software owns and reserves all rights not expressly granted in this source code,
 * including all intellectual property rights to the structure, sequence, and format of this code
 * and to all designs, interfaces, algorithms, schema, protocols, and inventions expressed herein.
 *
 *  If you have any questions, please email <sourcecode@isomorphic.com>.
 *
 *  This entire comment must accompany any portion of Isomorphic Software source code that is
 *  copied or moved from this file.
 */
/* sgwtgen */
package com.smartgwt.client.docs.serverds;

import com.smartgwt.client.types.*;
import com.smartgwt.client.data.DSRequest;
import com.smartgwt.client.data.DSResponse;
import com.smartgwt.client.docs.*;
import com.smartgwt.client.callbacks.*;
import com.smartgwt.client.widgets.form.fields.FormItem;
import java.util.List;
import java.util.Map;

/**
 * Authentication settings, applicable only to the {@link
 * com.smartgwt.client.docs.ServerRestConnector RestConnector}
 */
public class RESTAuthentication {

    /**
     * For a {@link com.smartgwt.client.docs.ServerRestConnector RestConnector DataSource} using
     * {@link com.smartgwt.client.types.RESTAuthenticationType bearerToken authentication}, the token
     * to use.  This attribute is for use when you are using bearerToken auth with a long-lived token,
     * such as a fixed API key, rather than a regularly changing refresh/accept pattern.  If you need
     * to  use the refresh/accept token pattern, omit this attribute and instead declare an  {@link
     * com.smartgwt.client.docs.serverds.RESTAuthentication#dataSource authentication dataSource}
     *
     * <p>Default value is null
     * @see com.smartgwt.client.docs.ServerRestConnector Server-side REST Connector
     */
    public String authToken;

    /**
     * For a {@link com.smartgwt.client.docs.ServerRestConnector RestConnector DataSource}, the
     * password to authenticate with if you are using {@link
     * com.smartgwt.client.types.RESTAuthenticationType basic authentication}.  Note, for  services
     * that support Basic authentication but require an API key rather than a password, you still use
     * this property, just set it to the API key instead
     *
     * <p>Default value is null
     * @see com.smartgwt.client.docs.ServerRestConnector Server-side REST Connector
     */
    public String password;

    /**
     * For a {@link com.smartgwt.client.docs.ServerRestConnector RestConnector DataSource} using
     * {@link com.smartgwt.client.types.RESTAuthenticationType authHeader authentication}, the
     * complete, well-formed  header value to set for the "Authorization" HTTP header.  This attribute
     * is for use when  you are using authHeader authentication with a long-lived token, such as a
     * fixed API key,  rather than a regularly changing refresh/accept pattern.  If you need to use
     * the  refresh/accept token pattern, omit this attribute and instead declare an  {@link
     * com.smartgwt.client.docs.serverds.RESTAuthentication#dataSource authentication dataSource}
     *
     * <p>Default value is null
     * @see com.smartgwt.client.docs.ServerRestConnector Server-side REST Connector
     */
    public String authHeader;

    /**
     * For a {@link com.smartgwt.client.docs.ServerRestConnector RestConnector DataSource}, the
     * username to authenticate with if you are using {@link
     * com.smartgwt.client.types.RESTAuthenticationType basic authentication}
     *
     * <p>Default value is null
     * @see com.smartgwt.client.docs.ServerRestConnector Server-side REST Connector
     */
    public String username;

    /**
     * For a {@link com.smartgwt.client.docs.ServerRestConnector RestConnector DataSource}, the
     * authentication type
     *  to use.  Note, as well as the formal header-based authentication types used by most REST 
     *  services, <code>RestConnector</code> can also support more ad-hoc auth schemes, such as 
     *  sending a username/password or authentication token in the body of a request.  Whether or 
     *  not such non-standard auth schemes are a good idea is academic; if the REST endpoint you 
     *  need to target is expecting a token in a URL param, that's what you have to provide.  
     *  <p>
     *  Because <code>RestConnector</code> is so configurable, it is easy to achieve this.
     *  Assuming you have an API token that must be passed as parameter "Token", and that token is 
     *  stored in your <code>system.properties</code> file, achieving this is as easy as adding the 
     * following to your {@link com.smartgwt.client.docs.serverds.DataSource#serverConfig
     * serverConfig}:<pre>
     *     &lt;params&gt;
     *         &lt;Token&gt;$config['myrestservice.apikey']&lt;/Token&gt;
     *     &lt;/params&gt;
     *  </pre>
     *  Note, if the REST service you are targeting does have a non-standard auth scheme that does 
     *  not use the HTTP Authorization header, you should simply omit the 
     *  {@link com.smartgwt.client.docs.serverds.DataSource#auth auth block}
     *
     * <p>Default value is null
     * @see com.smartgwt.client.docs.ServerRestConnector Server-side REST Connector
     */
    public RESTAuthenticationType type;

    /**
     * For a {@link com.smartgwt.client.docs.ServerRestConnector RestConnector DataSource}, a second
     * dataSource that is capable of fetching tokens that this dataSource can use to authenticate
     * requests.  This property is required for {@link
     * com.smartgwt.client.types.RESTAuthenticationType bearerToken} and {@link
     * com.smartgwt.client.types.RESTAuthenticationType authHeader} authentication types.   <p>
     * Typically, this dataSource will be a separate "rest" dataSource that connects to the token
     * vending endpoint of an authorization server, passing in a "refresh" token and getting back  an
     * "access" token.  Access tokens are typically short-lived, to minimize their usefulness  to
     * attackers if the token should somehow be exposed.  When an access token expires it must be
     * refreshed by again connecting to the token vending endpoint of the authorization server.
     * <code>RestConnector</code> handles all the mechanics of this for you; you just have to  provide
     * a dataSource that can do the fetch. <p> Note, <code>RestConnector</code> will issue a
     * straightforward fetch with null criteria on the authentication dataSource when it needs to
     * refresh its access token.  This means that the authentication dataSource must be able to supply
     * the refresh token to the REST auth endpoint without context from the dataSource fetch request. 
     * As mentioned above, the  authentication dataSource is typically another "rest" dataSource, so
     * you can use  <code>RestConnector</code>'s extensive request templating features to accomplish
     * this - for example, by embedding a reference to a <code>server.properties</code> property in
     * the  {@link com.smartgwt.client.docs.serverds.DataSource#dataURL dataURL} <p> A
     * <code>RestConnector</code> authentication dataSource should include the following fields. Note,
     * the "Field name" shown in the table is just the default; you can override the name of any of
     * these fields by setting the property shown in the "Customize" column.  So, eg, if  you set
     * <code>tokenField: "custom_token"</code> in the {@link
     * com.smartgwt.client.docs.serverds.RESTAuthentication auth} config block, we will expect the
     * dataSource to contain a field called "custom_token" instead of the default "access_token"
     * <table> <tr style="background-color:#444444;color:#ffffff"> <td>Field
     * name</td><td>Description</td><td>Customize</td></tr> <tr> <td><code>access_token</code></td>
     * <td>For "bearerToken" auth only, field containing the bearer token to be set in the     
     * Authorization header (Smart GWT will add the "Bearer" text)</td>
     * <td><code>tokenField</code></td> </tr><tr> <td><code>authorizationheader</code></td> <td>For
     * "authHeader" auth only, field containing the complete, well-formed header value to     be set
     * in the Authorization header</td> <td><code>headerAuthorizationField</code></td> </tr><tr>
     * <td><code>expires</code></td> <td>Absolute point in time when this token expires, expressed as
     * milliseconds since the      epoch (midnight on January 1st 1970)</td>
     * <td><code>expiresField</code></td> </tr><tr> <td><code>expires_in</code></td> <td>Length of
     * time from now before this token expires, expressed as a number of seconds.     If "expires" is
     * also present, "expires" is used in preference to "expires_in".  If      neither value is
     * present, the token is considered to be one that does not expire</td>
     * <td><code>expiresInField</code></td> </table>
     *
     * <p>Default value is null
     * @see com.smartgwt.client.docs.ServerRestConnector Server-side REST Connector
     */
    public DataSource dataSource;

}
