package com.smartgwt.client.types;


/*
 * Smart GWT (GWT for SmartClient)
 * Copyright 2008 and beyond, Isomorphic Software, Inc.
 *
 * Smart GWT is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License version 3
 * as published by the Free Software Foundation.  Smart GWT is also
 * available under typical commercial license terms - see
 * http://smartclient.com/license
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 */
/* sgwtgen */
 
/**
 * Governs how {@link com.smartgwt.client.widgets.grid.ListGrid#getRowRangeDisplayValue ListGrid.getRowRangeDisplayValue()}
 * formats the row range and row count for display
 */
public enum RowRangeDisplayStyle implements ValueEnum {
    /**
     * The {@link com.smartgwt.client.widgets.grid.ListGrid#getFullRowRangeDisplayValue ListGrid.fullRowRangeDisplayValue}
     * template will be used to display both row range and row count
     * <P>
     * If this enumerated value is used in a {@link com.smartgwt.client.docs.ComponentXML Component XML}
     * file or server-side DataSource descriptor (.ds.xml file), use the value "full".
     */
    FULL("full"),
    /**
     * The {@link com.smartgwt.client.widgets.grid.ListGrid#getBriefRowRangeDisplayValue ListGrid.briefRowRangeDisplayValue}
     * template will be used to display both row range and row count
     * <P>
     * If this enumerated value is used in a {@link com.smartgwt.client.docs.ComponentXML Component XML}
     * file or server-side DataSource descriptor (.ds.xml file), use the value "brief".
     */
    BRIEF("brief"),
    /**
     * The {@link com.smartgwt.client.widgets.grid.ListGrid#getFormattedRowCount ListGrid.getFormattedRowCount()} will be
     * displayed with no other text.
     * <P>
     * If this enumerated value is used in a {@link com.smartgwt.client.docs.ComponentXML Component XML}
     * file or server-side DataSource descriptor (.ds.xml file), use the value "countOnly".
     */
    COUNTONLY("countOnly"),
    /**
     * The {@link com.smartgwt.client.widgets.grid.ListGrid#getFormattedRowRange ListGrid.getFormattedRowRange()} will be
     * displayed with no other text.
     * <P>
     * If this enumerated value is used in a {@link com.smartgwt.client.docs.ComponentXML Component XML}
     * file or server-side DataSource descriptor (.ds.xml file), use the value "rangeOnly".
     */
    RANGEONLY("rangeOnly");
    private String value;

    RowRangeDisplayStyle(String value) {
        this.value = value;
    }

    public String getValue() {
        return this.value;
    }
}
