/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.user.client.ui;

import com.google.gwt.dom.client.Style;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.event.dom.client.HasClickHandlers;
import com.google.gwt.event.dom.client.MouseOutEvent;
import com.google.gwt.event.dom.client.MouseOutHandler;
import com.google.gwt.event.dom.client.MouseOverEvent;
import com.google.gwt.event.dom.client.MouseOverHandler;
import com.google.gwt.event.logical.shared.BeforeSelectionEvent;
import com.google.gwt.event.logical.shared.BeforeSelectionHandler;
import com.google.gwt.event.logical.shared.HasBeforeSelectionHandlers;
import com.google.gwt.event.logical.shared.HasSelectionHandlers;
import com.google.gwt.event.logical.shared.SelectionEvent;
import com.google.gwt.event.logical.shared.SelectionHandler;
import com.google.gwt.event.shared.HandlerRegistration;
import com.google.gwt.layout.client.Layout;
import com.google.gwt.safehtml.shared.SafeHtml;
import com.google.gwt.safehtml.shared.annotations.IsSafeHtml;
import com.google.gwt.safehtml.shared.annotations.SuppressIsSafeHtmlCastCheck;
import com.google.gwt.user.client.ui.AnimatedLayout;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.HTML;
import com.google.gwt.user.client.ui.HasHTML;
import com.google.gwt.user.client.ui.HasText;
import com.google.gwt.user.client.ui.HasWidgets;
import com.google.gwt.user.client.ui.IndexedPanel;
import com.google.gwt.user.client.ui.IsWidget;
import com.google.gwt.user.client.ui.LayoutPanel;
import com.google.gwt.user.client.ui.ProvidesResize;
import com.google.gwt.user.client.ui.ResizeComposite;
import com.google.gwt.user.client.ui.Widget;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.NoSuchElementException;

public class StackLayoutPanel
extends ResizeComposite
implements HasWidgets,
ProvidesResize,
IndexedPanel.ForIsWidget,
AnimatedLayout,
HasBeforeSelectionHandlers<Integer>,
HasSelectionHandlers<Integer> {
    private static final String WIDGET_STYLE = "gwt-StackLayoutPanel";
    private static final String CONTENT_STYLE = "gwt-StackLayoutPanelContent";
    private static final String HEADER_STYLE = "gwt-StackLayoutPanelHeader";
    private static final String HEADER_STYLE_HOVERING = "gwt-StackLayoutPanelHeader-hovering";
    private static final int ANIMATION_TIME = 250;
    private int animationDuration = 250;
    private LayoutPanel layoutPanel;
    private final Style.Unit unit;
    private final ArrayList<LayoutData> layoutData = new ArrayList();
    private int selectedIndex = -1;

    public StackLayoutPanel(Style.Unit unit) {
        this.unit = unit;
        this.layoutPanel = new LayoutPanel();
        this.initWidget(this.layoutPanel);
        this.setStyleName(WIDGET_STYLE);
    }

    @Override
    public void add(Widget w) {
        assert (false) : "Single-argument add() is not supported for this widget";
    }

    public void add(Widget widget, SafeHtml header, double headerSize) {
        this.add(widget, header.asString(), true, headerSize);
    }

    public void add(Widget widget, @IsSafeHtml String header, boolean asHtml, double headerSize) {
        this.insert(widget, header, asHtml, headerSize, this.getWidgetCount());
    }

    public void add(IsWidget widget, @IsSafeHtml String header, boolean asHtml, double headerSize) {
        this.add(widget.asWidget(), header, asHtml, headerSize);
    }

    public void add(Widget widget, String header, double headerSize) {
        this.insert(widget, header, headerSize, this.getWidgetCount());
    }

    public void add(Widget widget, Widget header, double headerSize) {
        this.insert(widget, header, headerSize, this.getWidgetCount());
    }

    public void add(IsWidget widget, IsWidget header, double headerSize) {
        this.add(widget.asWidget(), header.asWidget(), headerSize);
    }

    @Override
    public HandlerRegistration addBeforeSelectionHandler(BeforeSelectionHandler<Integer> handler) {
        return this.addHandler(handler, BeforeSelectionEvent.getType());
    }

    @Override
    public HandlerRegistration addSelectionHandler(SelectionHandler<Integer> handler) {
        return this.addHandler(handler, SelectionEvent.getType());
    }

    @Override
    public void animate(int duration) {
        this.animate(duration, null);
    }

    @Override
    public void animate(int duration, Layout.AnimationCallback callback) {
        int i;
        if (this.layoutData.size() == 0) {
            if (callback != null) {
                callback.onAnimationComplete();
            }
            return;
        }
        double top = 0.0;
        double bottom = 0.0;
        for (i = 0; i < this.layoutData.size(); ++i) {
            LayoutData data = this.layoutData.get(i);
            this.layoutPanel.setWidgetTopHeight(data.header, top, this.unit, data.headerSize, this.unit);
            this.layoutPanel.setWidgetTopHeight(data.widget, top += data.headerSize, this.unit, 0.0, this.unit);
            if (i == this.selectedIndex) break;
        }
        for (int j = this.layoutData.size() - 1; j > i; --j) {
            LayoutData data = this.layoutData.get(j);
            this.layoutPanel.setWidgetBottomHeight(data.header, bottom, this.unit, data.headerSize, this.unit);
            this.layoutPanel.setWidgetBottomHeight(data.widget, bottom, this.unit, 0.0, this.unit);
            bottom += data.headerSize;
        }
        LayoutData data = this.layoutData.get(this.selectedIndex);
        this.layoutPanel.setWidgetTopBottom(data.widget, top, this.unit, bottom, this.unit);
        this.layoutPanel.animate(duration, callback);
    }

    @Override
    public void clear() {
        this.layoutPanel.clear();
        this.layoutData.clear();
        this.selectedIndex = -1;
    }

    @Override
    public void forceLayout() {
        this.layoutPanel.forceLayout();
    }

    public int getAnimationDuration() {
        return this.animationDuration;
    }

    public Widget getHeaderWidget(int index) {
        this.checkIndex(index);
        return this.layoutData.get((int)index).header.getWidget();
    }

    public Widget getHeaderWidget(Widget child) {
        this.checkChild(child);
        return this.getHeaderWidget(this.getWidgetIndex(child));
    }

    public int getVisibleIndex() {
        return this.selectedIndex;
    }

    public Widget getVisibleWidget() {
        if (this.selectedIndex == -1) {
            return null;
        }
        return this.getWidget(this.selectedIndex);
    }

    @Override
    public Widget getWidget(int index) {
        return this.layoutPanel.getWidget(index * 2 + 1);
    }

    @Override
    public int getWidgetCount() {
        return this.layoutPanel.getWidgetCount() / 2;
    }

    @Override
    public int getWidgetIndex(IsWidget child) {
        return this.getWidgetIndex(StackLayoutPanel.asWidgetOrNull(child));
    }

    @Override
    public int getWidgetIndex(Widget child) {
        int index = this.layoutPanel.getWidgetIndex(child);
        if (index == -1) {
            return index;
        }
        return (index - 1) / 2;
    }

    public void insert(Widget child, SafeHtml html, double headerSize, int beforeIndex) {
        this.insert(child, html.asString(), true, headerSize, beforeIndex);
    }

    public void insert(Widget child, @IsSafeHtml String text, boolean asHtml, double headerSize, int beforeIndex) {
        HTML contents = new HTML();
        if (asHtml) {
            contents.setHTML(text);
        } else {
            contents.setText(text);
        }
        this.insert(child, contents, headerSize, beforeIndex);
    }

    @SuppressIsSafeHtmlCastCheck
    public void insert(Widget child, String text, double headerSize, int beforeIndex) {
        this.insert(child, text, false, headerSize, beforeIndex);
    }

    public void insert(Widget child, Widget header, double headerSize, int beforeIndex) {
        this.insert(child, new Header(header), headerSize, beforeIndex);
    }

    @Override
    public Iterator<Widget> iterator() {
        return new Iterator<Widget>(){
            int i = 0;
            int last = -1;

            @Override
            public boolean hasNext() {
                return this.i < StackLayoutPanel.this.layoutData.size();
            }

            @Override
            public Widget next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                this.last = this.i++;
                return ((LayoutData)((StackLayoutPanel)StackLayoutPanel.this).layoutData.get((int)this.last)).widget;
            }

            @Override
            public void remove() {
                if (this.last < 0) {
                    throw new IllegalStateException();
                }
                StackLayoutPanel.this.remove(((LayoutData)((StackLayoutPanel)StackLayoutPanel.this).layoutData.get((int)this.last)).widget);
                this.i = this.last;
                this.last = -1;
            }
        };
    }

    @Override
    public void onResize() {
        this.layoutPanel.onResize();
    }

    @Override
    public boolean remove(int index) {
        return this.remove(this.getWidget(index));
    }

    @Override
    public boolean remove(Widget child) {
        if (child.getParent() != this.layoutPanel) {
            return false;
        }
        for (int i = 0; i < this.layoutData.size(); ++i) {
            LayoutData data = this.layoutData.get(i);
            if (data.widget != child) continue;
            this.layoutPanel.remove(data.header);
            this.layoutPanel.remove(data.widget);
            data.header.removeStyleName(HEADER_STYLE);
            data.widget.removeStyleName(CONTENT_STYLE);
            this.layoutData.remove(i);
            if (this.selectedIndex == i) {
                this.selectedIndex = -1;
                if (this.layoutData.size() > 0) {
                    this.showWidget(this.layoutData.get((int)0).widget);
                }
            } else {
                if (i <= this.selectedIndex) {
                    --this.selectedIndex;
                }
                this.animate(this.animationDuration);
            }
            return true;
        }
        return false;
    }

    public void setAnimationDuration(int duration) {
        this.animationDuration = duration;
    }

    public void setHeaderHTML(int index, @IsSafeHtml String html) {
        this.checkIndex(index);
        LayoutData data = this.layoutData.get(index);
        Widget headerWidget = data.header.getWidget();
        assert (headerWidget instanceof HasHTML) : "Header widget does not implement HasHTML";
        ((HasHTML)((Object)headerWidget)).setHTML(html);
    }

    public void setHeaderHTML(int index, SafeHtml html) {
        this.setHeaderHTML(index, html.asString());
    }

    public void setHeaderText(int index, String text) {
        this.checkIndex(index);
        LayoutData data = this.layoutData.get(index);
        Widget headerWidget = data.header.getWidget();
        assert (headerWidget instanceof HasText) : "Header widget does not implement HasText";
        ((HasText)((Object)headerWidget)).setText(text);
    }

    public void showWidget(int index) {
        this.showWidget(index, true);
    }

    public void showWidget(int index, boolean fireEvents) {
        this.checkIndex(index);
        this.showWidget(index, this.animationDuration, fireEvents);
    }

    public void showWidget(Widget child) {
        this.showWidget(this.getWidgetIndex(child));
    }

    public void showWidget(Widget child, boolean fireEvents) {
        this.showWidget(this.getWidgetIndex(child), this.animationDuration, fireEvents);
    }

    @Override
    protected void onLoad() {
        this.animate(0);
    }

    private void checkChild(Widget child) {
        assert (this.layoutPanel.getChildren().contains(child));
    }

    private void checkIndex(int index) {
        assert (index >= 0 && index < this.getWidgetCount()) : "Index out of bounds";
    }

    private void insert(final Widget child, final Header header, double headerSize, int beforeIndex) {
        assert (beforeIndex >= 0 && beforeIndex <= this.getWidgetCount()) : "beforeIndex out of bounds";
        int idx = this.getWidgetIndex(child);
        if (idx != -1) {
            this.remove(child);
            if (idx < beforeIndex) {
                --beforeIndex;
            }
        }
        int widgetIndex = beforeIndex * 2;
        this.layoutPanel.insert(child, widgetIndex);
        this.layoutPanel.insert(header, widgetIndex);
        this.layoutPanel.setWidgetLeftRight(header, 0.0, Style.Unit.PX, 0.0, Style.Unit.PX);
        this.layoutPanel.setWidgetLeftRight(child, 0.0, Style.Unit.PX, 0.0, Style.Unit.PX);
        LayoutData data = new LayoutData(child, header, headerSize);
        this.layoutData.add(beforeIndex, data);
        header.addStyleName(HEADER_STYLE);
        child.addStyleName(CONTENT_STYLE);
        header.addClickHandler(new ClickHandler(){
            final /* synthetic */ StackLayoutPanel this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public void onClick(ClickEvent event) {
                this.this$0.showWidget(child);
            }
        });
        header.addMouseOutHandler(new MouseOutHandler(){
            final /* synthetic */ StackLayoutPanel this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public void onMouseOut(MouseOutEvent event) {
                header.removeStyleName(StackLayoutPanel.HEADER_STYLE_HOVERING);
            }
        });
        header.addMouseOverHandler(new MouseOverHandler(){
            final /* synthetic */ StackLayoutPanel this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public void onMouseOver(MouseOverEvent event) {
                header.addStyleName(StackLayoutPanel.HEADER_STYLE_HOVERING);
            }
        });
        if (this.selectedIndex == -1) {
            this.showWidget(0);
        } else if (beforeIndex <= this.selectedIndex) {
            ++this.selectedIndex;
        }
        if (this.isAttached()) {
            this.animate(this.animationDuration);
        }
    }

    private void showWidget(int index, int duration, boolean fireEvents) {
        BeforeSelectionEvent<Integer> event;
        this.checkIndex(index);
        if (index == this.selectedIndex) {
            return;
        }
        if (fireEvents && (event = BeforeSelectionEvent.fire(this, index)) != null && event.isCanceled()) {
            return;
        }
        this.selectedIndex = index;
        if (this.isAttached()) {
            this.animate(duration);
        }
        if (fireEvents) {
            SelectionEvent.fire(this, index);
        }
    }

    private static class LayoutData {
        public double headerSize;
        public Header header;
        public Widget widget;

        public LayoutData(Widget widget, Header header, double headerSize) {
            this.widget = widget;
            this.header = header;
            this.headerSize = headerSize;
        }
    }

    private class Header
    extends Composite
    implements HasClickHandlers {
        public Header(Widget child) {
            this.initWidget(child);
        }

        @Override
        public HandlerRegistration addClickHandler(ClickHandler handler) {
            return this.addDomHandler(handler, ClickEvent.getType());
        }

        public HandlerRegistration addMouseOutHandler(MouseOutHandler handler) {
            return this.addDomHandler(handler, MouseOutEvent.getType());
        }

        public HandlerRegistration addMouseOverHandler(MouseOverHandler handler) {
            return this.addDomHandler(handler, MouseOverEvent.getType());
        }
    }
}

