/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.dialect.lock;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.hibernate.JDBCException;
import org.hibernate.LockMode;
import org.hibernate.LockOptions;
import org.hibernate.SessionFactory;
import org.hibernate.StaleObjectStateException;
import org.hibernate.dialect.lock.AbstractSelectLockingStrategy;
import org.hibernate.dialect.lock.PessimisticEntityLockException;
import org.hibernate.engine.jdbc.spi.JdbcCoordinator;
import org.hibernate.engine.spi.Mapping;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.event.spi.EventSource;
import org.hibernate.persister.entity.EntityPersister;
import org.hibernate.persister.entity.Lockable;
import org.hibernate.pretty.MessageHelper;
import org.hibernate.sql.SimpleSelect;
import org.hibernate.stat.spi.StatisticsImplementor;

public class PessimisticReadSelectLockingStrategy
extends AbstractSelectLockingStrategy {
    public PessimisticReadSelectLockingStrategy(Lockable lockable, LockMode lockMode) {
        super(lockable, lockMode);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void lock(Object id, Object version, Object object, int timeout, EventSource session) {
        String sql = this.determineSql(timeout);
        SessionFactory factory = session.getFactory();
        try {
            Lockable lockable = this.getLockable();
            try {
                JdbcCoordinator jdbcCoordinator = session.getJdbcCoordinator();
                PreparedStatement st = jdbcCoordinator.getStatementPreparer().prepareStatement(sql);
                try {
                    ResultSet rs;
                    lockable.getIdentifierType().nullSafeSet(st, id, 1, session);
                    if (lockable.isVersioned()) {
                        lockable.getVersionType().nullSafeSet(st, version, lockable.getIdentifierType().getColumnSpan((Mapping)((Object)factory)) + 1, session);
                    }
                    if (!(rs = jdbcCoordinator.getResultSetReturn().extract(st, sql)).next()) {
                        StatisticsImplementor statistics = factory.getStatistics();
                        if (statistics.isStatisticsEnabled()) {
                            statistics.optimisticFailure(lockable.getEntityName());
                        }
                        throw new StaleObjectStateException(lockable.getEntityName(), id);
                    }
                }
                finally {
                    jdbcCoordinator.getLogicalConnection().getResourceRegistry().release(st);
                    jdbcCoordinator.afterStatementExecution();
                }
            }
            catch (SQLException e) {
                throw session.getJdbcServices().getSqlExceptionHelper().convert(e, "could not lock: " + MessageHelper.infoString((EntityPersister)lockable, id, (SessionFactoryImplementor)session.getFactory()), sql);
            }
        }
        catch (JDBCException e) {
            throw new PessimisticEntityLockException(object, "could not obtain pessimistic lock", e);
        }
    }

    @Override
    protected String generateLockString(int lockTimeout) {
        SessionFactoryImplementor factory = this.getLockable().getFactory();
        LockOptions lockOptions = new LockOptions(this.getLockMode());
        lockOptions.setTimeOut(lockTimeout);
        SimpleSelect select = new SimpleSelect(factory).setLockOptions(lockOptions).setTableName(this.getLockable().getRootTableName()).addColumn(this.getLockable().getRootTableIdentifierColumnNames()[0]).addRestriction(this.getLockable().getRootTableIdentifierColumnNames());
        if (this.getLockable().isVersioned()) {
            select.addRestriction(this.getLockable().getVersionColumnName());
        }
        if (factory.getSessionFactoryOptions().isCommentsEnabled()) {
            select.setComment(this.getLockMode() + " lock " + this.getLockable().getEntityName());
        }
        return select.toStatementString();
    }
}

