/*
 * Decompiled with CFR 0.152.
 */
package com.isomorphic.sql.cachesync;

import com.isomorphic.datasource.DSRequest;
import com.isomorphic.datasource.DSResponse;
import com.isomorphic.datasource.cachesync.GenericRefetchStrategy;
import com.isomorphic.datasource.cachesync.RequestValuesStrategy;
import com.isomorphic.sql.SQLDataSource;
import com.isomorphic.util.DataTools;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class SQLRefetchStrategy
extends GenericRefetchStrategy {
    public boolean worksForBatchAdd(DSRequest request) {
        return false;
    }

    public List getCacheSyncData(DSRequest request, DSResponse response) throws Exception {
        if (response != null && response.getAffectedRows() <= 0L) {
            return null;
        }
        if (!this.isCacheSyncFetchAllowed(request, response)) {
            return new RequestValuesStrategy().getCacheSyncData(request, response);
        }
        SQLDataSource ds = (SQLDataSource)request.getDataSource();
        String cacheSyncOperation = this.getCacheSyncOperation(request);
        Map primaryKeys = new HashMap();
        if (ds.getSequenceMode() != SQLDataSource.SequenceMode.NONE) {
            primaryKeys = request.getLastPrimaryKeys(response);
            if (SQLDataSource.isRemove((String)request.getOperationType())) {
                ArrayList keyList = new ArrayList();
                keyList.add(primaryKeys);
                return keyList;
            }
        }
        List pkFields = null;
        try {
            pkFields = ds.getPrimaryKeys();
        }
        catch (Exception e) {
            return null;
        }
        for (int i = 0; i < pkFields.size(); ++i) {
            if (primaryKeys.containsKey(pkFields.get(i))) continue;
            this.log.warn((Object)("SQLRefetchStrategy - missing key value for field " + String.valueOf(pkFields.get(i)) + "in DataSource " + ds.getName()));
            if (cacheSyncOperation == null) continue;
            this.log.warn((Object)"There is no explicit cache sync operation and we have missing keys, so we cannot fetch cache sync data.  Returning null to avoid a query with incomplete criteria");
            return null;
        }
        String schema = ds.getSchemaName();
        Object schemaClause = "";
        if (schema != null) {
            schemaClause = schema + ds.getDriver().getQualifiedSchemaSeparator();
        }
        DSRequest csReq = new DSRequest(request.getDataSource(), "fetch", request.getDSCacheManager());
        csReq.setOperationId(cacheSyncOperation);
        if (ds.getSequenceMode() != SQLDataSource.SequenceMode.NONE) {
            csReq.setCriteria(primaryKeys);
        } else {
            csReq.setCriteria((Object)request.getCriteria());
            csReq.setValues((Object)request.getValues());
        }
        csReq.inheritClientContext(request);
        csReq.setParameter((Object)"additionalOutputs", request.getParameter((Object)"additionalOutputs"));
        csReq.setOutputs(request.getOutputs());
        csReq.setTextMatchStyle("exactCase");
        Iterator i = request.getAttributeNames();
        while (i.hasNext()) {
            String key = (String)i.next();
            csReq.setAttribute(key, request.getAttribute(key));
        }
        csReq.setPrimaryDSRequest(request);
        request.addSubRequest(csReq);
        Object data = null;
        try {
            data = csReq.execute().getData();
        }
        catch (SecurityException se) {
            this.log.info((Object)("Cache sync operation failed to pass Declarative Security check, just submitted values will be returned. Security failure message: " + se.getMessage()));
            Map oldValues = request.getOldValues();
            data = oldValues != null ? DataTools.mapMerge((Map)request.getValues(), (Map)oldValues) : request.getValues();
        }
        if (csReq.getDroppedFields() != null) {
            Iterator i2 = csReq.getDroppedFields().iterator();
            while (i2.hasNext()) {
                request.removeField((String)i2.next(), true);
            }
        }
        if (SQLDataSource.isRemove((String)request.getOperationType())) {
            data = DataTools.subsetMap((Map)ds.getRecord(data), (List)ds.getPrimaryKeys());
        }
        return DataTools.makeListIfSingle((Object)data);
    }
}

