/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.typedarrays.server;

import com.google.gwt.typedarrays.server.ArrayBufferViewImpl;
import com.google.gwt.typedarrays.shared.ArrayBuffer;
import com.google.gwt.typedarrays.shared.Float64Array;

public final class Float64ArrayImpl
extends ArrayBufferViewImpl
implements Float64Array {
    public Float64ArrayImpl(ArrayBuffer buffer, int byteOffset, int length) {
        super(buffer, byteOffset, length * 8);
    }

    @Override
    public double get(int index) {
        return this.arrayBuf.getFloat64(this.checkRange(index, 8), true);
    }

    @Override
    public int length() {
        return this.byteLength() / 8;
    }

    @Override
    public void set(double[] array) {
        this.set(array, 0);
    }

    @Override
    public void set(double[] array, int offset) {
        int len = array.length;
        if (offset + len > this.length()) {
            throw new IndexOutOfBoundsException();
        }
        for (int i = 0; i < len; ++i) {
            this.set(offset++, array[i]);
        }
    }

    @Override
    public void set(Float64Array array) {
        this.set(array, 0);
    }

    @Override
    public void set(Float64Array array, int offset) {
        int len = array.length();
        if (offset + len > this.length()) {
            throw new IndexOutOfBoundsException();
        }
        for (int i = 0; i < len; ++i) {
            this.set(offset++, array.get(i));
        }
    }

    @Override
    public void set(int index, double value) {
        this.arrayBuf.setFloat64(this.checkRange(index, 8), value, true);
    }

    @Override
    public Float64Array subarray(int begin) {
        int count = (this.byteLength() - this.byteOffset()) / 8;
        return this.subarray(begin, count);
    }

    @Override
    public Float64Array subarray(int begin, int end) {
        int count = (this.byteLength() - this.byteOffset()) / 8;
        if (begin < 0) {
            if ((begin += count) < 0) {
                begin = 0;
            }
        } else if (begin > count) {
            begin = count;
        }
        if (end < 0) {
            if ((end += count) < 0) {
                end = 0;
            }
        } else if (end > count) {
            end = count;
        }
        if (end < begin) {
            end = begin;
        }
        return new Float64ArrayImpl(this.arrayBuf, begin * 8, end * 8);
    }
}

