/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.validation.client.impl;

import com.google.gwt.validation.client.impl.PathImpl;
import com.google.gwt.validation.client.impl.metadata.MessageAndPath;
import java.lang.annotation.Annotation;
import java.util.HashSet;
import java.util.Set;
import javax.validation.ConstraintValidatorContext;
import javax.validation.ConstraintViolation;
import javax.validation.metadata.ConstraintDescriptor;

public final class ConstraintValidatorContextImpl<A extends Annotation, T>
implements ConstraintValidatorContext {
    private final PathImpl basePath;
    private final ConstraintDescriptor<A> descriptor;
    private boolean disableDefault;
    private final Set<ConstraintViolation<T>> violations = new HashSet<ConstraintViolation<T>>();
    private final HashSet<MessageAndPath> messages = new HashSet();

    public ConstraintValidatorContextImpl(PathImpl path, ConstraintDescriptor<A> descriptor) {
        this.basePath = path;
        this.descriptor = descriptor;
    }

    public ConstraintValidatorContext.ConstraintViolationBuilder buildConstraintViolationWithTemplate(String messageTemplate) {
        ConstraintViolationBuilderImpl builder = new ConstraintViolationBuilderImpl(this, messageTemplate);
        return builder;
    }

    public void disableDefaultConstraintViolation() {
        this.disableDefault = true;
    }

    public String getDefaultConstraintMessageTemplate() {
        return (String)this.descriptor.getAttributes().get("message");
    }

    public Set<MessageAndPath> getMessageAndPaths() {
        if (!this.disableDefault) {
            this.messages.add(new MessageAndPath(this.basePath, this.getDefaultConstraintMessageTemplate()));
        }
        return this.messages;
    }

    public Set<ConstraintViolation<T>> getViolations() {
        return this.violations;
    }

    public final class ConstraintViolationBuilderImpl
    implements ConstraintValidatorContext.ConstraintViolationBuilder {
        private ConstraintValidatorContextImpl<A, T> context;
        private String messageTemplate;

        public ConstraintViolationBuilderImpl(ConstraintValidatorContextImpl<A, T> constraintValidatorContextImpl, String messageTemplate) {
            this.context = constraintValidatorContextImpl;
            this.messageTemplate = messageTemplate;
        }

        public ConstraintValidatorContext addConstraintViolation() {
            ConstraintValidatorContextImpl.this.messages.add(new MessageAndPath(this.context.basePath, this.messageTemplate));
            return this.context;
        }

        public ConstraintValidatorContext.ConstraintViolationBuilder.NodeBuilderDefinedContext addNode(String name) {
            return new NodeBuilderDefinedContextImpl(this, this.messageTemplate, ConstraintValidatorContextImpl.this.basePath.append(name));
        }
    }

    public final class NodeContextBuilderImpl
    implements ConstraintValidatorContext.ConstraintViolationBuilder.NodeContextBuilder {
        private final String messageTemplate;
        private final ConstraintViolationBuilderImpl parent;
        private final PathImpl path;

        public NodeContextBuilderImpl(PathImpl path, String messageTemplate, ConstraintViolationBuilderImpl parent) {
            this.path = path;
            this.messageTemplate = messageTemplate;
            this.parent = parent;
        }

        public ConstraintValidatorContext addConstraintViolation() {
            return null;
        }

        public ConstraintValidatorContext.ConstraintViolationBuilder.NodeBuilderCustomizableContext addNode(String name) {
            return new NodeBuilderCustomizableContextImpl(this.parent, this.messageTemplate, this.path.append(name));
        }

        public ConstraintValidatorContext.ConstraintViolationBuilder.NodeBuilderDefinedContext atIndex(Integer index) {
            return new NodeBuilderDefinedContextImpl(this.parent, this.messageTemplate, this.path.appendIndex(null, index));
        }

        public ConstraintValidatorContext.ConstraintViolationBuilder.NodeBuilderDefinedContext atKey(Object key) {
            return new NodeBuilderDefinedContextImpl(this.parent, this.messageTemplate, this.path.appendKey(null, key));
        }
    }

    public final class NodeBuilderDefinedContextImpl
    implements ConstraintValidatorContext.ConstraintViolationBuilder.NodeBuilderDefinedContext {
        private final String messageTemplate;
        private final ConstraintViolationBuilderImpl parent;
        private final PathImpl path;

        public NodeBuilderDefinedContextImpl(ConstraintViolationBuilderImpl parent, String messageTemplate, PathImpl path) {
            this.parent = parent;
            this.messageTemplate = messageTemplate;
            this.path = path;
        }

        public ConstraintValidatorContext addConstraintViolation() {
            ConstraintValidatorContextImpl.this.messages.add(new MessageAndPath(this.path, this.messageTemplate));
            return this.parent.context;
        }

        public ConstraintValidatorContext.ConstraintViolationBuilder.NodeBuilderCustomizableContext addNode(String name) {
            return new NodeBuilderCustomizableContextImpl(this.parent, this.messageTemplate, this.path.append(name));
        }
    }

    public final class NodeBuilderCustomizableContextImpl
    implements ConstraintValidatorContext.ConstraintViolationBuilder.NodeBuilderCustomizableContext {
        private final String messageTemplate;
        private final ConstraintViolationBuilderImpl parent;
        private final PathImpl path;

        public NodeBuilderCustomizableContextImpl(ConstraintViolationBuilderImpl parent, String messageTemplate, PathImpl path) {
            this.parent = parent;
            this.messageTemplate = messageTemplate;
            this.path = path;
        }

        public ConstraintValidatorContext addConstraintViolation() {
            return null;
        }

        public ConstraintValidatorContext.ConstraintViolationBuilder.NodeBuilderCustomizableContext addNode(String name) {
            return this;
        }

        public ConstraintValidatorContext.ConstraintViolationBuilder.NodeContextBuilder inIterable() {
            return new NodeContextBuilderImpl(this.path, this.messageTemplate, this.parent);
        }
    }
}

