package com.smartgwtpower.linker;

import com.google.gwt.core.ext.LinkerContext;
import com.google.gwt.core.ext.TreeLogger;
import com.google.gwt.core.ext.linker.AbstractLinker;
import com.google.gwt.core.ext.linker.ArtifactSet;
import com.google.gwt.core.ext.linker.LinkerOrder;

@LinkerOrder(LinkerOrder.Order.POST)
public class DeprecatedModuleWarningLinker extends AbstractLinker {

    @Override
    public String getDescription() {
        return "Smart GWT Power Deprecated Module Warnings";
    }

    @Override
    public ArtifactSet link(TreeLogger logger, LinkerContext context, ArtifactSet artifacts) {
        logger.log(TreeLogger.Type.WARN, "GWT modules `com.smartgwtpower.SmartGwtPower.gwt.xml', " +
                "`com.smartgwtpower.SmartGwtPowerNoScript.gwt.xml', and `com.smartgwtpower.SmartGwtPowerNoTheme.gwt.xml' " +
                "are deprecated. They have been replaced by their EE equivalents: `com.smartgwtee.SmartGwtEE.gwt.xml', " +
                "`com.smartgwtee.SmartGwtEENoScript.gwt.xml', and `com.smartgwtee.SmartGwtEENoTheme.gwt.xml'.");
        return artifacts;
    }
}
